/*
 * Decompiled with CFR 0.152.
 */
package jackpal.androidterm.emulatorview;

final class StyleRow {
    private int mStyle;
    private int mColumns;
    private byte[] mData;

    StyleRow(int style, int columns) {
        this.mStyle = style;
        this.mColumns = columns;
    }

    void set(int column, int style) {
        if (style == this.mStyle && this.mData == null) {
            return;
        }
        this.ensureData();
        this.setStyle(column, style);
    }

    int get(int column) {
        if (this.mData == null) {
            return this.mStyle;
        }
        return this.getStyle(column);
    }

    boolean isSolidStyle() {
        return this.mData == null;
    }

    int getSolidStyle() {
        if (this.mData != null) {
            throw new IllegalArgumentException("Not a solid style");
        }
        return this.mStyle;
    }

    void copy(int start, StyleRow dst, int offset, int len) {
        if (this.mData == null && dst.mData == null && start == 0 && offset == 0 && len == this.mColumns) {
            dst.mStyle = this.mStyle;
            return;
        }
        this.ensureData();
        dst.ensureData();
        System.arraycopy(this.mData, 3 * start, dst.mData, 3 * offset, 3 * len);
    }

    void ensureData() {
        if (this.mData == null) {
            this.allocate();
        }
    }

    private void allocate() {
        this.mData = new byte[3 * this.mColumns];
        for (int i = 0; i < this.mColumns; ++i) {
            this.setStyle(i, this.mStyle);
        }
    }

    private int getStyle(int column) {
        int index = 3 * column;
        byte[] line = this.mData;
        return line[index] & 0xFF | (line[index + 1] & 0xFF) << 8 | (line[index + 2] & 0xFF) << 16;
    }

    private void setStyle(int column, int value) {
        int index = 3 * column;
        byte[] line = this.mData;
        line[index] = (byte)(value & 0xFF);
        line[index + 1] = (byte)(value >> 8 & 0xFF);
        line[index + 2] = (byte)(value >> 16 & 0xFF);
    }
}

