/*
 * Decompiled with CFR 0.152.
 */
package jackpal.androidterm.emulatorview;

import jackpal.androidterm.emulatorview.UnicodeTranscript;

class FullUnicodeLine {
    private static final float SPARE_CAPACITY_FACTOR = 1.5f;
    private char[] mText;
    private short[] mOffset;
    private int mColumns;

    public FullUnicodeLine(int columns) {
        this.commonConstructor(columns);
        char[] text = this.mText;
        for (int i = 0; i < columns; ++i) {
            text[i] = 32;
        }
        this.mOffset[0] = (short)columns;
    }

    public FullUnicodeLine(char[] basicLine) {
        this.commonConstructor(basicLine.length);
        System.arraycopy(basicLine, 0, this.mText, 0, this.mColumns);
        this.mOffset[0] = (short)basicLine.length;
    }

    private void commonConstructor(int columns) {
        this.mColumns = columns;
        this.mOffset = new short[columns];
        this.mText = new char[(int)(1.5f * (float)columns)];
    }

    public int getSpaceUsed() {
        return this.mOffset[0];
    }

    public char[] getLine() {
        return this.mText;
    }

    public int findStartOfColumn(int column) {
        if (column == 0) {
            return 0;
        }
        return column + this.mOffset[column];
    }

    public boolean getChar(int column, int charIndex, char[] out, int offset) {
        int pos = this.findStartOfColumn(column);
        int length = column + 1 < this.mColumns ? this.findStartOfColumn(column + 1) - pos : this.getSpaceUsed() - pos;
        if (charIndex >= length) {
            throw new IllegalArgumentException();
        }
        out[offset] = this.mText[pos + charIndex];
        return charIndex + 1 < length;
    }

    public void setChar(int column, int codePoint) {
        int shift;
        int columns = this.mColumns;
        if (column < 0 || column >= columns) {
            throw new IllegalArgumentException();
        }
        char[] text = this.mText;
        short[] offset = this.mOffset;
        int spaceUsed = offset[0];
        int pos = this.findStartOfColumn(column);
        int charWidth = UnicodeTranscript.charWidth(codePoint);
        int oldCharWidth = UnicodeTranscript.charWidth(text, pos);
        if (charWidth == 2 && column == columns - 1) {
            codePoint = 32;
            charWidth = 1;
        }
        boolean wasExtraColForWideChar = false;
        if (oldCharWidth == 2 && column > 0) {
            boolean bl = wasExtraColForWideChar = this.findStartOfColumn(column - 1) == pos;
        }
        int oldLen = wasExtraColForWideChar && column + 1 < columns ? this.findStartOfColumn(column + 1) - pos : (column + oldCharWidth < columns ? this.findStartOfColumn(column + oldCharWidth) - pos : spaceUsed - pos);
        int newLen = Character.charCount(codePoint);
        if (charWidth == 0) {
            newLen += oldLen;
        }
        if ((shift = newLen - oldLen) > 0) {
            if (spaceUsed + shift > text.length) {
                char[] newText = new char[text.length + columns];
                System.arraycopy(text, 0, newText, 0, pos);
                System.arraycopy(text, pos + oldLen, newText, pos + newLen, spaceUsed - pos - oldLen);
                text = newText;
                this.mText = newText;
            } else {
                System.arraycopy(text, pos + oldLen, text, pos + newLen, spaceUsed - pos - oldLen);
            }
        }
        if (charWidth > 0) {
            Character.toChars(codePoint, text, pos);
        } else {
            Character.toChars(codePoint, text, pos + oldLen);
        }
        if (shift < 0) {
            System.arraycopy(text, pos + oldLen, text, pos + newLen, spaceUsed - pos - oldLen);
        }
        if (shift != 0) {
            offset[0] = (short)(spaceUsed += shift);
        }
        if (oldCharWidth == 2 && charWidth == 1 || wasExtraColForWideChar && charWidth == 2) {
            int nextPos = pos + newLen;
            char[] newText = text;
            if (spaceUsed + 1 > text.length) {
                newText = new char[text.length + columns];
                System.arraycopy(text, 0, newText, 0, wasExtraColForWideChar ? pos : nextPos);
            }
            if (wasExtraColForWideChar) {
                System.arraycopy(text, pos, newText, pos + 1, spaceUsed - pos);
                newText[pos] = 32;
            } else {
                System.arraycopy(text, nextPos, newText, nextPos + 1, spaceUsed - nextPos);
                newText[nextPos] = 32;
            }
            if (newText != text) {
                text = newText;
                this.mText = newText;
            }
            offset[0] = (short)(offset[0] + 1);
            spaceUsed = offset[0];
            if (wasExtraColForWideChar) {
                int n = column;
                offset[n] = (short)(offset[n] + 1);
                ++pos;
            } else {
                if (column == 0) {
                    offset[1] = (short)(newLen - 1);
                } else if (column + 1 < columns) {
                    offset[column + 1] = (short)(offset[column] + newLen - 1);
                }
                ++column;
            }
            ++shift;
        }
        if (oldCharWidth == 1 && charWidth == 2 || wasExtraColForWideChar && charWidth == 2) {
            if (column == columns - 2) {
                offset[column + 1] = (short)(offset[column] - 1);
                offset[0] = (short)(pos + newLen);
                shift = 0;
            } else {
                int nextPos = pos + newLen;
                int nextWidth = UnicodeTranscript.charWidth(text, nextPos);
                int nextLen = column + nextWidth + 1 < columns ? this.findStartOfColumn(column + nextWidth + 1) + shift - nextPos : spaceUsed - nextPos;
                if (nextWidth == 2) {
                    text[nextPos] = 32;
                    if (nextLen > 1) {
                        System.arraycopy(text, nextPos + nextLen, text, nextPos + 1, spaceUsed - nextPos - nextLen);
                        shift -= nextLen - 1;
                        offset[0] = (short)(offset[0] - (nextLen - 1));
                    }
                } else {
                    System.arraycopy(text, nextPos + nextLen, text, nextPos, spaceUsed - nextPos - nextLen);
                    shift -= nextLen;
                    offset[0] = (short)(offset[0] - nextLen);
                }
                if (column == 0) {
                    offset[1] = -1;
                } else {
                    offset[column + 1] = (short)(offset[column] - 1);
                }
                ++column;
            }
        }
        if (shift != 0) {
            int i = column + 1;
            while (i < columns) {
                int n = i++;
                offset[n] = (short)(offset[n] + shift);
            }
        }
    }
}

