/*
 * Decompiled with CFR 0.152.
 */
package jackpal.androidterm.emulatorview;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.style.URLSpan;
import android.text.util.Linkify;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.GestureDetector;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.inputmethod.BaseInputConnection;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.CorrectionInfo;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.ExtractedTextRequest;
import android.view.inputmethod.InputConnection;
import android.widget.Scroller;
import jackpal.androidterm.emulatorview.BaseTextRenderer;
import jackpal.androidterm.emulatorview.Bitmap4x8FontRenderer;
import jackpal.androidterm.emulatorview.ColorScheme;
import jackpal.androidterm.emulatorview.PaintRenderer;
import jackpal.androidterm.emulatorview.TermKeyListener;
import jackpal.androidterm.emulatorview.TermSession;
import jackpal.androidterm.emulatorview.TerminalEmulator;
import jackpal.androidterm.emulatorview.TextRenderer;
import jackpal.androidterm.emulatorview.TranscriptScreen;
import jackpal.androidterm.emulatorview.UnicodeTranscript;
import jackpal.androidterm.emulatorview.UpdateCallback;
import jackpal.androidterm.emulatorview.compat.ClipboardManagerCompat;
import jackpal.androidterm.emulatorview.compat.ClipboardManagerCompatFactory;
import jackpal.androidterm.emulatorview.compat.Patterns;
import java.io.IOException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.regex.Pattern;

public class EmulatorView
extends View
implements GestureDetector.OnGestureListener {
    private static final String TAG = "EmulatorView";
    private static final boolean LOG_KEY_EVENTS = false;
    private static final boolean LOG_IME = false;
    private boolean mKnownSize;
    private boolean mDeferInit = false;
    private int mVisibleWidth;
    private int mVisibleHeight;
    private TermSession mTermSession;
    private float mCharacterWidth;
    private int mCharacterHeight;
    private int mTopOfScreenMargin;
    private TextRenderer mTextRenderer;
    private int mTextSize = 10;
    private int mCursorBlink;
    private ColorScheme mColorScheme = BaseTextRenderer.defaultColorScheme;
    private Paint mForegroundPaint;
    private Paint mBackgroundPaint;
    private boolean mUseCookedIme;
    private TerminalEmulator mEmulator;
    private int mRows;
    private int mColumns;
    private int mVisibleColumns;
    private int mVisibleRows;
    private int mTopRow;
    private int mLeftColumn;
    private static final int CURSOR_BLINK_PERIOD = 1000;
    private boolean mCursorVisible = true;
    private boolean mIsSelectingText = false;
    private boolean mBackKeySendsCharacter = false;
    private int mControlKeyCode;
    private int mFnKeyCode;
    private boolean mIsControlKeySent = false;
    private boolean mIsFnKeySent = false;
    private boolean mMouseTracking;
    private float mDensity;
    private float mScaledDensity;
    private static final int SELECT_TEXT_OFFSET_Y = -40;
    private int mSelXAnchor = -1;
    private int mSelYAnchor = -1;
    private int mSelX1 = -1;
    private int mSelY1 = -1;
    private int mSelX2 = -1;
    private int mSelY2 = -1;
    private static final boolean sTrapAltAndMeta = Build.MODEL.contains("Transformer TF101");
    private Runnable mBlinkCursor = new Runnable(){

        @Override
        public void run() {
            if (EmulatorView.this.mCursorBlink != 0) {
                EmulatorView.this.mCursorVisible = !EmulatorView.this.mCursorVisible;
                EmulatorView.this.mHandler.postDelayed((Runnable)this, 1000L);
            } else {
                EmulatorView.this.mCursorVisible = true;
            }
            EmulatorView.this.invalidate();
        }
    };
    private GestureDetector mGestureDetector;
    private GestureDetector.OnGestureListener mExtGestureListener;
    private Scroller mScroller;
    private Runnable mFlingRunner = new Runnable(){

        @Override
        public void run() {
            if (EmulatorView.this.mScroller.isFinished()) {
                return;
            }
            if (EmulatorView.this.isMouseTrackingActive()) {
                return;
            }
            boolean more = EmulatorView.this.mScroller.computeScrollOffset();
            int newTopRow = EmulatorView.this.mScroller.getCurrY();
            if (newTopRow != EmulatorView.this.mTopRow) {
                EmulatorView.this.mTopRow = newTopRow;
                EmulatorView.this.invalidate();
            }
            if (more) {
                EmulatorView.this.post(this);
            }
        }
    };
    private Hashtable<Integer, URLSpan[]> mLinkLayer = new Hashtable();
    private static Linkify.MatchFilter sHttpMatchFilter = new HttpMatchFilter();
    private MouseTrackingFlingRunner mMouseTrackingFlingRunner = new MouseTrackingFlingRunner();
    private float mScrollRemainder;
    private TermKeyListener mKeyListener;
    private String mImeBuffer = "";
    private final Handler mHandler = new Handler();
    private UpdateCallback mUpdateNotify = new UpdateCallback(){

        @Override
        public void onUpdate() {
            if (EmulatorView.this.mIsSelectingText) {
                int rowShift = EmulatorView.this.mEmulator.getScrollCounter();
                EmulatorView.this.mSelY1 = EmulatorView.this.mSelY1 - rowShift;
                EmulatorView.this.mSelY2 = EmulatorView.this.mSelY2 - rowShift;
                EmulatorView.this.mSelYAnchor = EmulatorView.this.mSelYAnchor - rowShift;
            }
            EmulatorView.this.mEmulator.clearScrollCounter();
            EmulatorView.this.ensureCursorVisible();
            EmulatorView.this.invalidate();
        }
    };

    private int createLinks(int row) {
        int nextRow;
        int lineLen;
        TranscriptScreen transcriptScreen = this.mEmulator.getScreen();
        char[] line = transcriptScreen.getScriptLine(row);
        int lineCount = 1;
        if (line == null) {
            return lineCount;
        }
        boolean textIsBasic = transcriptScreen.isBasicLine(row);
        if (textIsBasic) {
            lineLen = line.length;
        } else {
            lineLen = 0;
            while (line[lineLen] != '\u0000') {
                ++lineLen;
            }
        }
        SpannableStringBuilder textToLinkify = new SpannableStringBuilder((CharSequence)new String(line, 0, lineLen));
        boolean lineWrap = transcriptScreen.getScriptLineWrap(row);
        while (lineWrap && (line = transcriptScreen.getScriptLine(nextRow = row + lineCount)) != null) {
            boolean lineIsBasic = transcriptScreen.isBasicLine(nextRow);
            if (textIsBasic && !lineIsBasic) {
                textIsBasic = lineIsBasic;
            }
            if (lineIsBasic) {
                lineLen = line.length;
            } else {
                lineLen = 0;
                while (line[lineLen] != '\u0000') {
                    ++lineLen;
                }
            }
            textToLinkify.append((CharSequence)new String(line, 0, lineLen));
            lineWrap = transcriptScreen.getScriptLineWrap(nextRow);
            ++lineCount;
        }
        Linkify.addLinks((Spannable)textToLinkify, (Pattern)Patterns.WEB_URL, null, (Linkify.MatchFilter)sHttpMatchFilter, null);
        URLSpan[] urls = (URLSpan[])textToLinkify.getSpans(0, textToLinkify.length(), URLSpan.class);
        if (urls.length > 0) {
            int i;
            int columns = this.mColumns;
            int screenRow = row - this.mTopRow;
            URLSpan[][] linkRows = new URLSpan[lineCount][];
            for (i = 0; i < lineCount; ++i) {
                linkRows[i] = new URLSpan[columns];
                Arrays.fill(linkRows[i], null);
            }
            for (int urlNum = 0; urlNum < urls.length; ++urlNum) {
                int i2;
                int endCol;
                int endRow;
                int startCol;
                int startRow;
                URLSpan url = urls[urlNum];
                int spanStart = textToLinkify.getSpanStart((Object)url);
                int spanEnd = textToLinkify.getSpanEnd((Object)url);
                if (textIsBasic) {
                    int spanLastPos = spanEnd - 1;
                    startRow = spanStart / this.mColumns;
                    startCol = spanStart % this.mColumns;
                    endRow = spanLastPos / this.mColumns;
                    endCol = spanLastPos % this.mColumns;
                } else {
                    char c;
                    startRow = 0;
                    startCol = 0;
                    for (i2 = 0; i2 < spanStart; ++i2) {
                        c = textToLinkify.charAt(i2);
                        startCol = Character.isHighSurrogate(c) ? (startCol += UnicodeTranscript.charWidth(c, textToLinkify.charAt(++i2))) : (startCol += UnicodeTranscript.charWidth(c));
                        if (startCol < columns) continue;
                        ++startRow;
                        startCol %= columns;
                    }
                    endRow = startRow;
                    endCol = startCol;
                    for (i2 = spanStart; i2 < spanEnd; ++i2) {
                        c = textToLinkify.charAt(i2);
                        endCol = Character.isHighSurrogate(c) ? (endCol += UnicodeTranscript.charWidth(c, textToLinkify.charAt(++i2))) : (endCol += UnicodeTranscript.charWidth(c));
                        if (endCol < columns) continue;
                        ++endRow;
                        endCol %= columns;
                    }
                }
                for (i2 = startRow; i2 <= endRow; ++i2) {
                    int runStart = i2 == startRow ? startCol : 0;
                    int runEnd = i2 == endRow ? endCol : this.mColumns - 1;
                    Arrays.fill(linkRows[i2], runStart, runEnd + 1, url);
                }
            }
            for (i = 0; i < lineCount; ++i) {
                this.mLinkLayer.put(screenRow + i, linkRows[i]);
            }
        }
        return lineCount;
    }

    public EmulatorView(Context context, TermSession session, DisplayMetrics metrics) {
        super(context);
        this.attachSession(session);
        this.setDensity(metrics);
        this.commonConstructor(context);
    }

    public EmulatorView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.commonConstructor(context);
    }

    public EmulatorView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.commonConstructor(context);
    }

    private void commonConstructor(Context context) {
        this.mScroller = new Scroller(context);
        this.mMouseTrackingFlingRunner.mScroller = new Scroller(context);
    }

    public void attachSession(TermSession session) {
        this.mTextRenderer = null;
        this.mForegroundPaint = new Paint();
        this.mBackgroundPaint = new Paint();
        this.mTopRow = 0;
        this.mLeftColumn = 0;
        this.mGestureDetector = new GestureDetector((GestureDetector.OnGestureListener)this);
        this.setVerticalScrollBarEnabled(true);
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.mTermSession = session;
        this.mKeyListener = new TermKeyListener(session);
        session.setKeyListener(this.mKeyListener);
        if (this.mDeferInit) {
            this.mDeferInit = false;
            this.mKnownSize = true;
            this.initialize();
        }
    }

    public void setDensity(DisplayMetrics metrics) {
        if (this.mDensity == 0.0f) {
            this.mTextSize = (int)((float)this.mTextSize * metrics.density);
        }
        this.mDensity = metrics.density;
        this.mScaledDensity = metrics.scaledDensity;
    }

    public void onResume() {
        this.updateSize(false);
        if (this.mCursorBlink != 0) {
            this.mHandler.postDelayed(this.mBlinkCursor, 1000L);
        }
        if (this.mKeyListener != null) {
            this.mKeyListener.onResume();
        }
    }

    public void onPause() {
        if (this.mCursorBlink != 0) {
            this.mHandler.removeCallbacks(this.mBlinkCursor);
        }
        if (this.mKeyListener != null) {
            this.mKeyListener.onPause();
        }
    }

    public void setColorScheme(ColorScheme scheme) {
        this.mColorScheme = scheme == null ? BaseTextRenderer.defaultColorScheme : scheme;
        this.updateText();
    }

    public boolean onCheckIsTextEditor() {
        return true;
    }

    public InputConnection onCreateInputConnection(EditorInfo outAttrs) {
        outAttrs.inputType = this.mUseCookedIme ? 1 : 0;
        return new BaseInputConnection(this, true){
            private int mCursor;
            private int mComposingTextStart;
            private int mComposingTextEnd;
            private int mSelectedTextStart;
            private int mSelectedTextEnd;

            private void sendText(CharSequence text) {
                int n = text.length();
                try {
                    for (int i = 0; i < n; ++i) {
                        char c = text.charAt(i);
                        if (Character.isHighSurrogate(c)) {
                            int codePoint = ++i < n ? Character.toCodePoint(c, text.charAt(i)) : 65533;
                            this.mapAndSend(codePoint);
                            continue;
                        }
                        this.mapAndSend(c);
                    }
                }
                catch (IOException e) {
                    Log.e((String)EmulatorView.TAG, (String)"error writing ", (Throwable)e);
                }
            }

            private void mapAndSend(int c) throws IOException {
                int result = EmulatorView.this.mKeyListener.mapControlChar(c);
                if (result < 0xA00000) {
                    EmulatorView.this.mTermSession.write(result);
                } else {
                    EmulatorView.this.mKeyListener.handleKeyCode(result - 0xA00000, null, EmulatorView.this.getKeypadApplicationMode());
                }
                EmulatorView.this.clearSpecialKeyStatus();
            }

            public boolean beginBatchEdit() {
                EmulatorView.this.setImeBuffer("");
                this.mCursor = 0;
                this.mComposingTextStart = 0;
                this.mComposingTextEnd = 0;
                return true;
            }

            public boolean clearMetaKeyStates(int arg0) {
                return false;
            }

            public boolean commitCompletion(CompletionInfo arg0) {
                return false;
            }

            public boolean endBatchEdit() {
                return true;
            }

            public boolean finishComposingText() {
                this.sendText(EmulatorView.this.mImeBuffer);
                EmulatorView.this.setImeBuffer("");
                this.mComposingTextStart = 0;
                this.mComposingTextEnd = 0;
                this.mCursor = 0;
                return true;
            }

            public int getCursorCapsMode(int reqModes) {
                int mode = 0;
                if ((reqModes & 0x1000) != 0) {
                    mode |= 0x1000;
                }
                return mode;
            }

            public ExtractedText getExtractedText(ExtractedTextRequest arg0, int arg1) {
                return null;
            }

            public CharSequence getTextAfterCursor(int n, int flags) {
                int len = Math.min(n, EmulatorView.this.mImeBuffer.length() - this.mCursor);
                if (len <= 0 || this.mCursor < 0 || this.mCursor >= EmulatorView.this.mImeBuffer.length()) {
                    return "";
                }
                return EmulatorView.this.mImeBuffer.substring(this.mCursor, this.mCursor + len);
            }

            public CharSequence getTextBeforeCursor(int n, int flags) {
                int len = Math.min(n, this.mCursor);
                if (len <= 0 || this.mCursor < 0 || this.mCursor >= EmulatorView.this.mImeBuffer.length()) {
                    return "";
                }
                return EmulatorView.this.mImeBuffer.substring(this.mCursor - len, this.mCursor);
            }

            public boolean performContextMenuAction(int arg0) {
                return true;
            }

            public boolean performPrivateCommand(String arg0, Bundle arg1) {
                return true;
            }

            public boolean reportFullscreenMode(boolean arg0) {
                return true;
            }

            public boolean commitCorrection(CorrectionInfo correctionInfo) {
                return true;
            }

            public boolean commitText(CharSequence text, int newCursorPosition) {
                this.clearComposingText();
                this.sendText(text);
                EmulatorView.this.setImeBuffer("");
                this.mCursor = 0;
                return true;
            }

            private void clearComposingText() {
                int len = EmulatorView.this.mImeBuffer.length();
                if (this.mComposingTextStart > len || this.mComposingTextEnd > len) {
                    this.mComposingTextStart = 0;
                    this.mComposingTextEnd = 0;
                    return;
                }
                EmulatorView.this.setImeBuffer(EmulatorView.this.mImeBuffer.substring(0, this.mComposingTextStart) + EmulatorView.this.mImeBuffer.substring(this.mComposingTextEnd));
                if (this.mCursor >= this.mComposingTextStart) {
                    this.mCursor = this.mCursor < this.mComposingTextEnd ? this.mComposingTextStart : (this.mCursor -= this.mComposingTextEnd - this.mComposingTextStart);
                }
                this.mComposingTextStart = 0;
                this.mComposingTextEnd = 0;
            }

            public boolean deleteSurroundingText(int leftLength, int rightLength) {
                if (leftLength > 0) {
                    for (int i = 0; i < leftLength; ++i) {
                        this.sendKeyEvent(new KeyEvent(0, 67));
                    }
                } else if (leftLength == 0 && rightLength == 0) {
                    this.sendKeyEvent(new KeyEvent(0, 67));
                }
                return true;
            }

            public boolean performEditorAction(int actionCode) {
                if (actionCode == 0) {
                    this.sendText("\r");
                }
                return true;
            }

            public boolean sendKeyEvent(KeyEvent event) {
                EmulatorView.this.dispatchKeyEvent(event);
                return true;
            }

            public boolean setComposingText(CharSequence text, int newCursorPosition) {
                int len = EmulatorView.this.mImeBuffer.length();
                if (this.mComposingTextStart > len || this.mComposingTextEnd > len) {
                    return false;
                }
                EmulatorView.this.setImeBuffer(EmulatorView.this.mImeBuffer.substring(0, this.mComposingTextStart) + text + EmulatorView.this.mImeBuffer.substring(this.mComposingTextEnd));
                this.mComposingTextEnd = this.mComposingTextStart + text.length();
                this.mCursor = newCursorPosition > 0 ? this.mComposingTextEnd + newCursorPosition - 1 : this.mComposingTextStart - newCursorPosition;
                return true;
            }

            public boolean setSelection(int start, int end) {
                int length = EmulatorView.this.mImeBuffer.length();
                if (start == end && start > 0 && start < length) {
                    this.mSelectedTextEnd = 0;
                    this.mSelectedTextStart = 0;
                    this.mCursor = start;
                } else if (start < end && start > 0 && end < length) {
                    this.mSelectedTextStart = start;
                    this.mSelectedTextEnd = end;
                    this.mCursor = start;
                }
                return true;
            }

            public boolean setComposingRegion(int start, int end) {
                if (start < end && start > 0 && end < EmulatorView.this.mImeBuffer.length()) {
                    this.clearComposingText();
                    this.mComposingTextStart = start;
                    this.mComposingTextEnd = end;
                }
                return true;
            }

            public CharSequence getSelectedText(int flags) {
                int len = EmulatorView.this.mImeBuffer.length();
                if (this.mSelectedTextEnd >= len || this.mSelectedTextStart > this.mSelectedTextEnd) {
                    return "";
                }
                return EmulatorView.this.mImeBuffer.substring(this.mSelectedTextStart, this.mSelectedTextEnd + 1);
            }
        };
    }

    private void setImeBuffer(String buffer) {
        if (!buffer.equals(this.mImeBuffer)) {
            this.invalidate();
        }
        this.mImeBuffer = buffer;
    }

    public boolean getKeypadApplicationMode() {
        return this.mEmulator.getKeypadApplicationMode();
    }

    public void setExtGestureListener(GestureDetector.OnGestureListener listener) {
        this.mExtGestureListener = listener;
    }

    protected int computeVerticalScrollRange() {
        return this.mEmulator.getScreen().getActiveRows();
    }

    protected int computeVerticalScrollExtent() {
        return this.mRows;
    }

    protected int computeVerticalScrollOffset() {
        return this.mEmulator.getScreen().getActiveRows() + this.mTopRow - this.mRows;
    }

    private void initialize() {
        TermSession session = this.mTermSession;
        this.updateText();
        this.mEmulator = session.getEmulator();
        session.setUpdateCallback(this.mUpdateNotify);
        this.requestFocus();
    }

    public TermSession getTermSession() {
        return this.mTermSession;
    }

    public int getVisibleWidth() {
        return this.mVisibleWidth;
    }

    public int getVisibleHeight() {
        return this.mVisibleHeight;
    }

    public int getVisibleRows() {
        return this.mVisibleRows;
    }

    public int getVisibleColumns() {
        return this.mVisibleColumns;
    }

    public void page(int delta) {
        this.mTopRow = Math.min(0, Math.max(-this.mEmulator.getScreen().getActiveTranscriptRows(), this.mTopRow + this.mRows * delta));
        this.invalidate();
    }

    public void pageHorizontal(int deltaColumns) {
        this.mLeftColumn = Math.max(0, Math.min(this.mLeftColumn + deltaColumns, this.mColumns - this.mVisibleColumns));
        this.invalidate();
    }

    public void setTextSize(int fontSize) {
        this.mTextSize = (int)((float)fontSize * this.mDensity);
        this.updateText();
    }

    public void setUseCookedIME(boolean useCookedIME) {
        this.mUseCookedIme = useCookedIME;
    }

    public boolean isMouseTrackingActive() {
        return this.mEmulator.getMouseTrackingMode() != 0 && this.mMouseTracking;
    }

    private void sendMouseEventCode(MotionEvent e, int button_code) {
        boolean out_of_bounds;
        int x = (int)(e.getX() / this.mCharacterWidth) + 1;
        int y = (int)((e.getY() - (float)this.mTopOfScreenMargin) / (float)this.mCharacterHeight) + 1;
        boolean bl = out_of_bounds = x < 1 || y < 1 || x > this.mColumns || y > this.mRows || x > 223 || y > 223;
        if (button_code < 0 || button_code > 223) {
            Log.e((String)TAG, (String)("mouse button_code out of range: " + button_code));
            return;
        }
        if (!out_of_bounds) {
            byte[] data = new byte[]{27, 91, 77, (byte)(32 + button_code), (byte)(32 + x), (byte)(32 + y)};
            this.mTermSession.write(data, 0, data.length);
        }
    }

    public boolean onSingleTapUp(MotionEvent e) {
        if (this.mExtGestureListener != null && this.mExtGestureListener.onSingleTapUp(e)) {
            return true;
        }
        if (this.isMouseTrackingActive()) {
            this.sendMouseEventCode(e, 0);
            this.sendMouseEventCode(e, 3);
        }
        this.requestFocus();
        return true;
    }

    public void onLongPress(MotionEvent e) {
        this.showContextMenu();
    }

    public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
        int deltaRows;
        if (this.mExtGestureListener != null && this.mExtGestureListener.onScroll(e1, e2, distanceX, distanceY)) {
            return true;
        }
        this.mScrollRemainder = distanceY - (float)(deltaRows * this.mCharacterHeight);
        if (this.isMouseTrackingActive()) {
            for (deltaRows = (int)((distanceY += this.mScrollRemainder) / (float)this.mCharacterHeight); deltaRows > 0; --deltaRows) {
                this.sendMouseEventCode(e1, 65);
            }
            while (deltaRows < 0) {
                this.sendMouseEventCode(e1, 64);
                ++deltaRows;
            }
            return true;
        }
        this.mTopRow = Math.min(0, Math.max(-this.mEmulator.getScreen().getActiveTranscriptRows(), this.mTopRow + deltaRows));
        this.invalidate();
        return true;
    }

    public void onSingleTapConfirmed(MotionEvent e) {
    }

    public boolean onJumpTapDown(MotionEvent e1, MotionEvent e2) {
        this.mTopRow = 0;
        this.invalidate();
        return true;
    }

    public boolean onJumpTapUp(MotionEvent e1, MotionEvent e2) {
        this.mTopRow = -this.mEmulator.getScreen().getActiveTranscriptRows();
        this.invalidate();
        return true;
    }

    public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
        if (this.mExtGestureListener != null && this.mExtGestureListener.onFling(e1, e2, velocityX, velocityY)) {
            return true;
        }
        this.mScrollRemainder = 0.0f;
        if (this.isMouseTrackingActive()) {
            this.mMouseTrackingFlingRunner.fling(e1, velocityX, velocityY);
        } else {
            float SCALE = 0.25f;
            this.mScroller.fling(0, this.mTopRow, -((int)(velocityX * SCALE)), -((int)(velocityY * SCALE)), 0, 0, -this.mEmulator.getScreen().getActiveTranscriptRows(), 0);
            this.post(this.mFlingRunner);
        }
        return true;
    }

    public void onShowPress(MotionEvent e) {
        if (this.mExtGestureListener != null) {
            this.mExtGestureListener.onShowPress(e);
        }
    }

    public boolean onDown(MotionEvent e) {
        if (this.mExtGestureListener != null && this.mExtGestureListener.onDown(e)) {
            return true;
        }
        this.mScrollRemainder = 0.0f;
        return true;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.mIsSelectingText) {
            return this.onTouchEventWhileSelectingText(ev);
        }
        return this.mGestureDetector.onTouchEvent(ev);
    }

    private boolean onTouchEventWhileSelectingText(MotionEvent ev) {
        int action = ev.getAction();
        int cx = (int)(ev.getX() / this.mCharacterWidth);
        int cy = Math.max(0, (int)((ev.getY() + -40.0f * this.mScaledDensity) / (float)this.mCharacterHeight) + this.mTopRow);
        switch (action) {
            case 0: {
                this.mSelXAnchor = cx;
                this.mSelYAnchor = cy;
                this.mSelX1 = cx;
                this.mSelY1 = cy;
                this.mSelX2 = this.mSelX1;
                this.mSelY2 = this.mSelY1;
                break;
            }
            case 1: 
            case 2: {
                int minx = Math.min(this.mSelXAnchor, cx);
                int maxx = Math.max(this.mSelXAnchor, cx);
                int miny = Math.min(this.mSelYAnchor, cy);
                int maxy = Math.max(this.mSelYAnchor, cy);
                this.mSelX1 = minx;
                this.mSelY1 = miny;
                this.mSelX2 = maxx;
                this.mSelY2 = maxy;
                if (action == 1) {
                    ClipboardManagerCompat clip = ClipboardManagerCompatFactory.getManager(this.getContext().getApplicationContext());
                    clip.setText(this.getSelectedText().trim());
                    this.toggleSelectingText();
                }
                this.invalidate();
                break;
            }
            default: {
                this.toggleSelectingText();
                this.invalidate();
            }
        }
        return true;
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (this.handleControlKey(keyCode, true)) {
            return true;
        }
        if (this.handleFnKey(keyCode, true)) {
            return true;
        }
        if (this.isSystemKey(keyCode, event) && !this.isInterceptedSystemKey(keyCode)) {
            return super.onKeyDown(keyCode, event);
        }
        try {
            int oldCombiningAccent = this.mKeyListener.getCombiningAccent();
            int oldCursorMode = this.mKeyListener.getCursorMode();
            this.mKeyListener.keyDown(keyCode, event, this.getKeypadApplicationMode(), TermKeyListener.isEventFromToggleDevice(event));
            if (this.mKeyListener.getCombiningAccent() != oldCombiningAccent || this.mKeyListener.getCursorMode() != oldCursorMode) {
                this.invalidate();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    private boolean isInterceptedSystemKey(int keyCode) {
        return keyCode == 4 && this.mBackKeySendsCharacter;
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (this.handleControlKey(keyCode, false)) {
            return true;
        }
        if (this.handleFnKey(keyCode, false)) {
            return true;
        }
        if (this.isSystemKey(keyCode, event) && !this.isInterceptedSystemKey(keyCode)) {
            return super.onKeyUp(keyCode, event);
        }
        this.mKeyListener.keyUp(keyCode, event);
        this.clearSpecialKeyStatus();
        return true;
    }

    public boolean onKeyPreIme(int keyCode, KeyEvent event) {
        if (sTrapAltAndMeta) {
            boolean altEsc = this.mKeyListener.getAltSendsEsc();
            boolean altOn = (event.getMetaState() & 2) != 0;
            boolean metaOn = (event.getMetaState() & 0x10000) != 0;
            boolean altPressed = keyCode == 57 || keyCode == 58;
            boolean altActive = this.mKeyListener.isAltActive();
            if (altEsc && (altOn || altPressed || altActive || metaOn)) {
                if (event.getAction() == 0) {
                    return this.onKeyDown(keyCode, event);
                }
                return this.onKeyUp(keyCode, event);
            }
        }
        if (this.handleHardwareControlKey(keyCode, event)) {
            return true;
        }
        if (this.mKeyListener.isCtrlActive()) {
            if (event.getAction() == 0) {
                return this.onKeyDown(keyCode, event);
            }
            return this.onKeyUp(keyCode, event);
        }
        return super.onKeyPreIme(keyCode, event);
    }

    private boolean handleControlKey(int keyCode, boolean down) {
        if (keyCode == this.mControlKeyCode) {
            this.mKeyListener.handleControlKey(down);
            this.invalidate();
            return true;
        }
        return false;
    }

    private boolean handleHardwareControlKey(int keyCode, KeyEvent event) {
        if (keyCode == 113 || keyCode == 114) {
            boolean down = event.getAction() == 0;
            this.mKeyListener.handleHardwareControlKey(down);
            this.invalidate();
            return true;
        }
        return false;
    }

    private boolean handleFnKey(int keyCode, boolean down) {
        if (keyCode == this.mFnKeyCode) {
            this.mKeyListener.handleFnKey(down);
            this.invalidate();
            return true;
        }
        return false;
    }

    private boolean isSystemKey(int keyCode, KeyEvent event) {
        return event.isSystem();
    }

    private void clearSpecialKeyStatus() {
        if (this.mIsControlKeySent) {
            this.mIsControlKeySent = false;
            this.mKeyListener.handleControlKey(false);
            this.invalidate();
        }
        if (this.mIsFnKeySent) {
            this.mIsFnKeySent = false;
            this.mKeyListener.handleFnKey(false);
            this.invalidate();
        }
    }

    private void updateText() {
        ColorScheme scheme = this.mColorScheme;
        this.mTextRenderer = this.mTextSize > 0 ? new PaintRenderer(this.mTextSize, scheme) : new Bitmap4x8FontRenderer(this.getResources(), scheme);
        this.mForegroundPaint.setColor(scheme.getForeColor());
        this.mBackgroundPaint.setColor(scheme.getBackColor());
        this.mCharacterWidth = this.mTextRenderer.getCharacterWidth();
        this.mCharacterHeight = this.mTextRenderer.getCharacterHeight();
        this.updateSize(true);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        if (this.mTermSession == null) {
            this.mDeferInit = true;
            return;
        }
        if (!this.mKnownSize) {
            this.mKnownSize = true;
            this.initialize();
        } else {
            this.updateSize(false);
        }
    }

    private void updateSize(int w, int h) {
        this.mColumns = Math.max(1, (int)((float)w / this.mCharacterWidth));
        this.mVisibleColumns = Math.max(1, (int)((float)this.mVisibleWidth / this.mCharacterWidth));
        this.mTopOfScreenMargin = this.mTextRenderer.getTopMargin();
        this.mRows = Math.max(1, (h - this.mTopOfScreenMargin) / this.mCharacterHeight);
        this.mVisibleRows = Math.max(1, (this.mVisibleHeight - this.mTopOfScreenMargin) / this.mCharacterHeight);
        this.mTermSession.updateSize(this.mColumns, this.mRows);
        this.mTopRow = 0;
        this.mLeftColumn = 0;
        this.invalidate();
    }

    public void updateSize(boolean force) {
        this.mLinkLayer.clear();
        if (this.mKnownSize) {
            int w = this.getWidth();
            int h = this.getHeight();
            if (force || w != this.mVisibleWidth || h != this.mVisibleHeight) {
                this.mVisibleWidth = w;
                this.mVisibleHeight = h;
                this.updateSize(this.mVisibleWidth, this.mVisibleHeight);
            }
        }
    }

    protected void onDraw(Canvas canvas) {
        this.updateSize(false);
        if (this.mEmulator == null) {
            return;
        }
        int w = this.getWidth();
        int h = this.getHeight();
        boolean reverseVideo = this.mEmulator.getReverseVideo();
        this.mTextRenderer.setReverseVideo(reverseVideo);
        Paint backgroundPaint = reverseVideo ? this.mForegroundPaint : this.mBackgroundPaint;
        canvas.drawRect(0.0f, 0.0f, (float)w, (float)h, backgroundPaint);
        float x = (float)(-this.mLeftColumn) * this.mCharacterWidth;
        float y = this.mCharacterHeight + this.mTopOfScreenMargin;
        int endLine = this.mTopRow + this.mRows;
        int cx = this.mEmulator.getCursorCol();
        int cy = this.mEmulator.getCursorRow();
        boolean cursorVisible = this.mCursorVisible && this.mEmulator.getShowCursor();
        String effectiveImeBuffer = this.mImeBuffer;
        int combiningAccent = this.mKeyListener.getCombiningAccent();
        if (combiningAccent != 0) {
            effectiveImeBuffer = effectiveImeBuffer + String.valueOf((char)combiningAccent);
        }
        int cursorStyle = this.mKeyListener.getCursorMode();
        int linkLinesToSkip = 0;
        for (int i = this.mTopRow; i < endLine; ++i) {
            int cursorX = -1;
            if (i == cy && cursorVisible) {
                cursorX = cx;
            }
            int selx1 = -1;
            int selx2 = -1;
            if (i >= this.mSelY1 && i <= this.mSelY2) {
                if (i == this.mSelY1) {
                    selx1 = this.mSelX1;
                }
                selx2 = i == this.mSelY2 ? this.mSelX2 : this.mColumns;
            }
            this.mEmulator.getScreen().drawText(i, canvas, x, y, this.mTextRenderer, cursorX, selx1, selx2, effectiveImeBuffer, cursorStyle);
            y += (float)this.mCharacterHeight;
            if (linkLinesToSkip == 0) {
                linkLinesToSkip = this.createLinks(i);
            }
            --linkLinesToSkip;
        }
    }

    private void ensureCursorVisible() {
        this.mTopRow = 0;
        if (this.mVisibleColumns > 0) {
            int cx = this.mEmulator.getCursorCol();
            int visibleCursorX = this.mEmulator.getCursorCol() - this.mLeftColumn;
            if (visibleCursorX < 0) {
                this.mLeftColumn = cx;
            } else if (visibleCursorX >= this.mVisibleColumns) {
                this.mLeftColumn = cx - this.mVisibleColumns + 1;
            }
        }
    }

    public void toggleSelectingText() {
        this.mIsSelectingText = !this.mIsSelectingText;
        this.setVerticalScrollBarEnabled(!this.mIsSelectingText);
        if (!this.mIsSelectingText) {
            this.mSelX1 = -1;
            this.mSelY1 = -1;
            this.mSelX2 = -1;
            this.mSelY2 = -1;
        }
    }

    public boolean getSelectingText() {
        return this.mIsSelectingText;
    }

    public String getSelectedText() {
        return this.mEmulator.getSelectedText(this.mSelX1, this.mSelY1, this.mSelX2, this.mSelY2);
    }

    public void sendControlKey() {
        this.mIsControlKeySent = true;
        this.mKeyListener.handleControlKey(true);
        this.invalidate();
    }

    public void sendFnKey() {
        this.mIsFnKeySent = true;
        this.mKeyListener.handleFnKey(true);
        this.invalidate();
    }

    public void setBackKeyCharacter(int keyCode) {
        this.mKeyListener.setBackKeyCharacter(keyCode);
        this.mBackKeySendsCharacter = keyCode != 0;
    }

    public void setAltSendsEsc(boolean flag) {
        this.mKeyListener.setAltSendsEsc(flag);
    }

    public void setControlKeyCode(int keyCode) {
        this.mControlKeyCode = keyCode;
    }

    public void setFnKeyCode(int keyCode) {
        this.mFnKeyCode = keyCode;
    }

    public void setTermType(String termType) {
        this.mKeyListener.setTermType(termType);
    }

    public void setMouseTracking(boolean flag) {
        this.mMouseTracking = flag;
    }

    public String getURLat(float x, float y) {
        URLSpan link;
        float w = this.getWidth();
        float h = this.getHeight();
        if (w == 0.0f || h == 0.0f) {
            return null;
        }
        float x_pos = x / w;
        float y_pos = y / h;
        int row = (int)Math.floor(y_pos * (float)this.mRows);
        int col = (int)Math.floor(x_pos * (float)this.mColumns);
        URLSpan[] linkRow = this.mLinkLayer.get(row);
        if (linkRow != null && (link = linkRow[col]) != null) {
            return link.getURL();
        }
        return null;
    }

    private class MouseTrackingFlingRunner
    implements Runnable {
        private Scroller mScroller;
        private int mLastY;
        private MotionEvent mMotionEvent;

        private MouseTrackingFlingRunner() {
        }

        public void fling(MotionEvent e, float velocityX, float velocityY) {
            float SCALE = 0.15f;
            this.mScroller.fling(0, 0, -((int)(velocityX * SCALE)), -((int)(velocityY * SCALE)), 0, 0, -100, 100);
            this.mLastY = 0;
            this.mMotionEvent = e;
            EmulatorView.this.post(this);
        }

        @Override
        public void run() {
            if (this.mScroller.isFinished()) {
                return;
            }
            if (!EmulatorView.this.isMouseTrackingActive()) {
                return;
            }
            boolean more = this.mScroller.computeScrollOffset();
            int newY = this.mScroller.getCurrY();
            while (this.mLastY < newY) {
                EmulatorView.this.sendMouseEventCode(this.mMotionEvent, 65);
                ++this.mLastY;
            }
            while (this.mLastY > newY) {
                EmulatorView.this.sendMouseEventCode(this.mMotionEvent, 64);
                --this.mLastY;
            }
            if (more) {
                EmulatorView.this.post(this);
            }
        }
    }

    private static class HttpMatchFilter
    implements Linkify.MatchFilter {
        private HttpMatchFilter() {
        }

        public boolean acceptMatch(CharSequence s, int start, int end) {
            return this.startsWith(s, start, end, "http:") || this.startsWith(s, start, end, "https:");
        }

        private boolean startsWith(CharSequence s, int start, int end, String prefix) {
            int fragmentLen;
            int prefixLen = prefix.length();
            if (prefixLen > (fragmentLen = end - start)) {
                return false;
            }
            for (int i = 0; i < prefixLen; ++i) {
                if (s.charAt(start + i) == prefix.charAt(i)) continue;
                return false;
            }
            return true;
        }
    }
}

