/*
 * Decompiled with CFR 0.152.
 */
package jackpal.androidterm.emulatorview;

class ByteQueue {
    private byte[] mBuffer;
    private int mHead;
    private int mStoredBytes;

    public ByteQueue(int size) {
        this.mBuffer = new byte[size];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBytesAvailable() {
        ByteQueue byteQueue = this;
        synchronized (byteQueue) {
            return this.mStoredBytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] buffer, int offset, int length) throws InterruptedException {
        if (length + offset > buffer.length) {
            throw new IllegalArgumentException("length + offset > buffer.length");
        }
        if (length < 0) {
            throw new IllegalArgumentException("length < 0");
        }
        if (length == 0) {
            return 0;
        }
        ByteQueue byteQueue = this;
        synchronized (byteQueue) {
            boolean wasFull;
            while (this.mStoredBytes == 0) {
                this.wait();
            }
            int totalRead = 0;
            int bufferLength = this.mBuffer.length;
            boolean bl = wasFull = bufferLength == this.mStoredBytes;
            while (length > 0 && this.mStoredBytes > 0) {
                int oneRun = Math.min(bufferLength - this.mHead, this.mStoredBytes);
                int bytesToCopy = Math.min(length, oneRun);
                System.arraycopy(this.mBuffer, this.mHead, buffer, offset, bytesToCopy);
                this.mHead += bytesToCopy;
                if (this.mHead >= bufferLength) {
                    this.mHead = 0;
                }
                this.mStoredBytes -= bytesToCopy;
                length -= bytesToCopy;
                offset += bytesToCopy;
                totalRead += bytesToCopy;
            }
            if (wasFull) {
                this.notify();
            }
            return totalRead;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(byte[] buffer, int offset, int length) throws InterruptedException {
        if (length + offset > buffer.length) {
            throw new IllegalArgumentException("length + offset > buffer.length");
        }
        if (length < 0) {
            throw new IllegalArgumentException("length < 0");
        }
        if (length == 0) {
            return 0;
        }
        ByteQueue byteQueue = this;
        synchronized (byteQueue) {
            boolean wasEmpty;
            int bufferLength = this.mBuffer.length;
            boolean bl = wasEmpty = this.mStoredBytes == 0;
            while (bufferLength == this.mStoredBytes) {
                this.wait();
            }
            int tail = this.mHead + this.mStoredBytes;
            int oneRun = tail >= bufferLength ? this.mHead - (tail -= bufferLength) : bufferLength - tail;
            int bytesToCopy = Math.min(oneRun, length);
            System.arraycopy(buffer, offset, this.mBuffer, tail, bytesToCopy);
            offset += bytesToCopy;
            this.mStoredBytes += bytesToCopy;
            if (wasEmpty) {
                this.notify();
            }
            return bytesToCopy;
        }
    }
}

