/*
 * Decompiled with CFR 0.152.
 */
package jackpal.androidterm.emulatorview;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import jackpal.androidterm.emulatorview.ColorScheme;
import jackpal.androidterm.emulatorview.TextRenderer;

abstract class BaseTextRenderer
implements TextRenderer {
    protected boolean mReverseVideo;
    protected int[] mPalette;
    protected static final int[] sXterm256Paint = new int[]{-16777216, -3342336, -16724736, -3289856, -16776978, -3342131, -16724531, -1710619, -8421505, -65536, -16711936, -256, -10724097, -65281, -16711681, -1, -16777216, -16777121, -16777081, -16777041, -16777001, -16776961, -16752896, -16752801, -16752761, -16752721, -16752681, -16752641, -16742656, -16742561, -16742521, -16742481, -16742441, -16742401, -16732416, -16732321, -16732281, -16732241, -16732201, -16732161, -16722176, -16722081, -16722041, -16722001, -16721961, -16721921, -16711936, -16711841, -16711801, -16711761, -16711721, -16711681, -10551296, -10551201, -10551161, -10551121, -10551081, -10551041, -10526976, -10526881, -10526841, -10526801, -10526761, -10526721, -10516736, -10516641, -10516601, -10516561, -10516521, -10516481, -10506496, -10506401, -10506361, -10506321, -10506281, -10506241, -10496256, -10496161, -10496121, -10496081, -10496041, -10496001, -10486016, -10485921, -10485881, -10485841, -10485801, -10485761, -7929856, -7929761, -7929721, -7929681, -7929641, -7929601, -7905536, -7905441, -7905401, -7905361, -7905321, -7905281, -7895296, -7895201, -7895161, -7895121, -7895081, -7895041, -7885056, -7884961, -7884921, -7884881, -7884841, -7884801, -7874816, -7874721, -7874681, -7874641, -7874601, -7874561, -7864576, -7864481, -7864441, -7864401, -7864361, -7864321, -5308416, -5308321, -5308281, -5308241, -5308201, -5308161, -5284096, -5284001, -5283961, -5283921, -5283881, -5283841, -5273856, -5273761, -5273721, -5273681, -5273641, -5273601, -5263616, -5263521, -5263481, -5263441, -5263401, -5263361, -5253376, -5253281, -5253241, -5253201, -5253161, -5253121, -5243136, -5243041, -5243001, -5242961, -5242921, -5242881, -2686976, -2686881, -2686841, -2686801, -2686761, -2686721, -2662656, -2662561, -2662521, -2662481, -2662441, -2662401, -2652416, -2652321, -2652281, -2652241, -2652201, -2652161, -2642176, -2642081, -2642041, -2642001, -2641961, -2641921, -2631936, -2631841, -2631801, -2631761, -2631721, -2631681, -2621696, -2621601, -2621561, -2621521, -2621481, -2621441, -65536, -65441, -65401, -65361, -65321, -65281, -41216, -41121, -41081, -41041, -41001, -40961, -30976, -30881, -30841, -30801, -30761, -30721, -20736, -20641, -20601, -20561, -20521, -20481, -10496, -10401, -10361, -10321, -10281, -10241, -256, -161, -121, -81, -41, -1, -16250872, -15592942, -14935012, -14277082, -13619152, -12961222, -12303292, -11645362, -10987432, -10329502, -9671572, -9013642, -8355712, -7697782, -7039852, -6381922, -5723992, -5066062, -4408132, -3750202, -3092272, -2434342, -1776412, -1118482};
    static final ColorScheme defaultColorScheme = new ColorScheme(-3355444, -16777216);
    private final Paint mCursorScreenPaint;
    private final Paint mCopyRedToAlphaPaint;
    private final Paint mCursorPaint;
    private final Paint mCursorStrokePaint;
    private final Path mShiftCursor;
    private final Path mAltCursor;
    private final Path mCtrlCursor;
    private final Path mFnCursor;
    private RectF mTempSrc;
    private RectF mTempDst;
    private Matrix mScaleMatrix;
    private float mLastCharWidth;
    private float mLastCharHeight;
    private static final Matrix.ScaleToFit mScaleType = Matrix.ScaleToFit.FILL;
    private Bitmap mCursorBitmap;
    private Bitmap mWorkBitmap;
    private int mCursorBitmapCursorMode = -1;

    public BaseTextRenderer(ColorScheme scheme) {
        if (scheme == null) {
            scheme = defaultColorScheme;
        }
        this.setDefaultColors(scheme);
        this.mCursorScreenPaint = new Paint();
        this.mCursorScreenPaint.setColor(scheme.getCursorBackColor());
        this.mCursorPaint = new Paint();
        this.mCursorPaint.setColor(-7303024);
        this.mCursorPaint.setAntiAlias(true);
        this.mCursorStrokePaint = new Paint(this.mCursorPaint);
        this.mCursorStrokePaint.setStrokeWidth(0.1f);
        this.mCursorStrokePaint.setStyle(Paint.Style.STROKE);
        this.mCopyRedToAlphaPaint = new Paint();
        ColorMatrix cm = new ColorMatrix();
        cm.set(new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f});
        this.mCopyRedToAlphaPaint.setColorFilter((ColorFilter)new ColorMatrixColorFilter(cm));
        this.mShiftCursor = new Path();
        this.mShiftCursor.lineTo(0.5f, 0.33f);
        this.mShiftCursor.lineTo(1.0f, 0.0f);
        this.mAltCursor = new Path();
        this.mAltCursor.moveTo(0.0f, 1.0f);
        this.mAltCursor.lineTo(0.5f, 0.66f);
        this.mAltCursor.lineTo(1.0f, 1.0f);
        this.mCtrlCursor = new Path();
        this.mCtrlCursor.moveTo(0.0f, 0.25f);
        this.mCtrlCursor.lineTo(1.0f, 0.5f);
        this.mCtrlCursor.lineTo(0.0f, 0.75f);
        this.mFnCursor = new Path();
        this.mFnCursor.moveTo(1.0f, 0.25f);
        this.mFnCursor.lineTo(0.0f, 0.5f);
        this.mFnCursor.lineTo(1.0f, 0.75f);
        this.mTempSrc = new RectF();
        this.mTempSrc.set(0.0f, 0.0f, 1.0f, 1.0f);
        this.mTempDst = new RectF();
        this.mScaleMatrix = new Matrix();
    }

    @Override
    public void setReverseVideo(boolean reverseVideo) {
        this.mReverseVideo = reverseVideo;
    }

    private void setDefaultColors(ColorScheme scheme) {
        this.mPalette = BaseTextRenderer.cloneDefaultColors();
        this.mPalette[256] = scheme.getForeColor();
        this.mPalette[257] = scheme.getBackColor();
        this.mPalette[258] = scheme.getCursorForeColor();
        this.mPalette[259] = scheme.getCursorBackColor();
    }

    private static int[] cloneDefaultColors() {
        int length = sXterm256Paint.length;
        int[] clone = new int[260];
        System.arraycopy(sXterm256Paint, 0, clone, 0, length);
        return clone;
    }

    protected void drawCursorImp(Canvas canvas, float x, float y, float charWidth, float charHeight, int cursorMode) {
        if (cursorMode == 0) {
            canvas.drawRect(x, y - charHeight, x + charWidth, y, this.mCursorScreenPaint);
            return;
        }
        if (charWidth != this.mLastCharWidth || charHeight != this.mLastCharHeight) {
            this.mLastCharWidth = charWidth;
            this.mLastCharHeight = charHeight;
            this.mTempDst.set(0.0f, 0.0f, charWidth, charHeight);
            this.mScaleMatrix.setRectToRect(this.mTempSrc, this.mTempDst, mScaleType);
            this.mCursorBitmap = Bitmap.createBitmap((int)((int)charWidth), (int)((int)charHeight), (Bitmap.Config)Bitmap.Config.ALPHA_8);
            this.mWorkBitmap = Bitmap.createBitmap((int)((int)charWidth), (int)((int)charHeight), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            this.mCursorBitmapCursorMode = -1;
        }
        if (cursorMode != this.mCursorBitmapCursorMode) {
            this.mCursorBitmapCursorMode = cursorMode;
            this.mWorkBitmap.eraseColor(-1);
            Canvas workCanvas = new Canvas(this.mWorkBitmap);
            workCanvas.concat(this.mScaleMatrix);
            this.drawCursorHelper(workCanvas, this.mShiftCursor, cursorMode, 0);
            this.drawCursorHelper(workCanvas, this.mAltCursor, cursorMode, 2);
            this.drawCursorHelper(workCanvas, this.mCtrlCursor, cursorMode, 4);
            this.drawCursorHelper(workCanvas, this.mFnCursor, cursorMode, 6);
            this.mCursorBitmap.eraseColor(0);
            Canvas bitmapCanvas = new Canvas(this.mCursorBitmap);
            bitmapCanvas.drawBitmap(this.mWorkBitmap, 0.0f, 0.0f, this.mCopyRedToAlphaPaint);
        }
        canvas.drawBitmap(this.mCursorBitmap, x, y - charHeight, this.mCursorScreenPaint);
    }

    private void drawCursorHelper(Canvas canvas, Path path, int mode, int shift) {
        switch (mode >> shift & 3) {
            case 1: {
                canvas.drawPath(path, this.mCursorStrokePaint);
                break;
            }
            case 2: {
                canvas.drawPath(path, this.mCursorPaint);
            }
        }
    }
}

