/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.settings;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.LinkedHashSet;
import java.util.Set;
import net.wurstclient.WurstClient;
import net.wurstclient.clickgui.Component;
import net.wurstclient.clickgui.components.CheckboxComponent;
import net.wurstclient.keybinds.PossibleKeybind;
import net.wurstclient.settings.CheckboxLock;
import net.wurstclient.settings.Setting;
import net.wurstclient.util.json.JsonUtils;
import net.wurstclient.util.text.WText;

public class CheckboxSetting
extends Setting
implements CheckboxLock {
    private boolean checked;
    private final boolean checkedByDefault;
    private CheckboxLock lock;

    public CheckboxSetting(String name, WText description, boolean checked) {
        super(name, description);
        this.checked = checked;
        this.checkedByDefault = checked;
    }

    public CheckboxSetting(String name, String descriptionKey, boolean checked) {
        this(name, WText.translated(descriptionKey, new Object[0]), checked);
    }

    public CheckboxSetting(String name, boolean checked) {
        this(name, WText.empty(), checked);
    }

    @Override
    public final boolean isChecked() {
        return this.isLocked() ? this.lock.isChecked() : this.checked;
    }

    public final boolean isCheckedByDefault() {
        return this.checkedByDefault;
    }

    public final void setChecked(boolean checked) {
        if (this.isLocked()) {
            return;
        }
        this.setCheckedIgnoreLock(checked);
    }

    private void setCheckedIgnoreLock(boolean checked) {
        this.checked = checked;
        this.update();
        WurstClient.INSTANCE.saveSettings();
    }

    public final boolean isLocked() {
        return this.lock != null;
    }

    public final void lock(CheckboxLock lock) {
        this.lock = lock;
        this.update();
    }

    public final void unlock() {
        this.lock = null;
        this.update();
    }

    @Override
    public final Component getComponent() {
        return new CheckboxComponent(this);
    }

    @Override
    public final void fromJson(JsonElement json) {
        if (!JsonUtils.isBoolean(json)) {
            return;
        }
        this.setCheckedIgnoreLock(json.getAsBoolean());
    }

    @Override
    public final JsonElement toJson() {
        return new JsonPrimitive(Boolean.valueOf(this.checked));
    }

    @Override
    public JsonObject exportWikiData() {
        JsonObject json = new JsonObject();
        json.addProperty("name", this.getName());
        json.addProperty("descriptionKey", this.getDescription());
        json.addProperty("type", "\u590d\u9009\u6846");
        json.addProperty("\u9ed8\u8ba4\u9009\u4e2d", Boolean.valueOf(this.checkedByDefault));
        return json;
    }

    @Override
    public final Set<PossibleKeybind> getPossibleKeybinds(String featureName) {
        String fullName = featureName + " " + this.getName();
        String command = ".setcheckbox " + featureName.toLowerCase() + " ";
        command = command + this.getName().toLowerCase().replace(" ", "_") + " ";
        LinkedHashSet<PossibleKeybind> pkb = new LinkedHashSet<PossibleKeybind>();
        pkb.add(new PossibleKeybind(command + "\u5207\u6362", "\u5207\u6362 " + fullName));
        pkb.add(new PossibleKeybind(command + "\u5f00\u542f", "\u52fe\u9009" + fullName));
        pkb.add(new PossibleKeybind(command + "\u5173\u95ed", "\u53d6\u6d88\u52fe\u9009" + fullName));
        return pkb;
    }
}

