/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.settings;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_2189;
import net.minecraft.class_2248;
import net.wurstclient.WurstClient;
import net.wurstclient.clickgui.Component;
import net.wurstclient.clickgui.components.BlockComponent;
import net.wurstclient.keybinds.PossibleKeybind;
import net.wurstclient.settings.Setting;
import net.wurstclient.util.BlockUtils;
import net.wurstclient.util.json.JsonException;
import net.wurstclient.util.json.JsonUtils;
import net.wurstclient.util.text.WText;

public final class BlockSetting
extends Setting {
    private String blockName = "";
    private final String defaultName;
    private final boolean allowAir;

    public BlockSetting(String name, WText description, String blockName, boolean allowAir) {
        super(name, description);
        class_2248 block = BlockUtils.getBlockFromNameOrID(blockName);
        Objects.requireNonNull(block);
        this.defaultName = this.blockName = BlockUtils.getName(block);
        this.allowAir = allowAir;
    }

    public BlockSetting(String name, String descriptionKey, String blockName, boolean allowAir) {
        this(name, WText.translated(descriptionKey, new Object[0]), blockName, allowAir);
    }

    public BlockSetting(String name, String blockName, boolean allowAir) {
        this(name, WText.empty(), blockName, allowAir);
    }

    public class_2248 getBlock() {
        return BlockUtils.getBlockFromName(this.blockName);
    }

    public String getBlockName() {
        return this.blockName;
    }

    public String getShortBlockName() {
        return this.blockName.replace("minecraft:", "");
    }

    public void setBlock(class_2248 block) {
        if (block == null) {
            return;
        }
        if (!this.allowAir && block instanceof class_2189) {
            return;
        }
        String newName = Objects.requireNonNull(BlockUtils.getName(block));
        if (this.blockName.equals(newName)) {
            return;
        }
        this.blockName = newName;
        WurstClient.INSTANCE.saveSettings();
    }

    public void setBlockName(String blockName) {
        class_2248 block = BlockUtils.getBlockFromNameOrID(blockName);
        Objects.requireNonNull(block);
        this.setBlock(block);
    }

    public void resetToDefault() {
        this.blockName = this.defaultName;
        WurstClient.INSTANCE.saveSettings();
    }

    @Override
    public Component getComponent() {
        return new BlockComponent(this);
    }

    @Override
    public void fromJson(JsonElement json) {
        try {
            String newName = JsonUtils.getAsString(json);
            class_2248 newBlock = BlockUtils.getBlockFromNameOrID(newName);
            if (newBlock == null) {
                throw new JsonException();
            }
            if (!this.allowAir && newBlock instanceof class_2189) {
                throw new JsonException();
            }
            this.blockName = BlockUtils.getName(newBlock);
        }
        catch (JsonException e) {
            e.printStackTrace();
            this.resetToDefault();
        }
    }

    @Override
    public JsonElement toJson() {
        return new JsonPrimitive(this.blockName);
    }

    @Override
    public JsonObject exportWikiData() {
        JsonObject json = new JsonObject();
        json.addProperty("name", this.getName());
        json.addProperty("descriptionKey", this.getDescription());
        json.addProperty("type", "\u65b9\u5757");
        json.addProperty("\u9ed8\u8ba4\u503c", this.defaultName);
        json.addProperty("\u5141\u8bb8\u7a7a\u6c14", Boolean.valueOf(this.allowAir));
        return json;
    }

    @Override
    public Set<PossibleKeybind> getPossibleKeybinds(String featureName) {
        String fullName = featureName + " " + this.getName();
        String command = ".setblock " + featureName.toLowerCase() + " ";
        command = command + this.getName().toLowerCase().replace(" ", "_") + " ";
        LinkedHashSet<PossibleKeybind> pkb = new LinkedHashSet<PossibleKeybind>();
        pkb.add(new PossibleKeybind(command + "\u91cd\u7f6e", "\u91cd\u7f6e" + fullName));
        return pkb;
    }
}

