/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.other_features;

import net.minecraft.class_2561;
import net.minecraft.class_3675;
import net.minecraft.class_7172;
import net.wurstclient.DontBlock;
import net.wurstclient.SearchTags;
import net.wurstclient.events.MouseScrollListener;
import net.wurstclient.other_feature.OtherFeature;
import net.wurstclient.settings.CheckboxSetting;
import net.wurstclient.settings.SliderSetting;
import net.wurstclient.settings.TextFieldSetting;
import net.wurstclient.util.MathUtils;

@SearchTags(value={"telescope", "optifine"})
@DontBlock
public final class ZoomOtf
extends OtherFeature
implements MouseScrollListener {
    private final SliderSetting level = new SliderSetting("\u7f29\u653e\u7ea7\u522b", 3.0, 1.0, 50.0, 0.1, SliderSetting.ValueDisplay.DECIMAL.withSuffix("x"));
    private final CheckboxSetting scroll = new CheckboxSetting("\u4f7f\u7528\u9f20\u6807\u6eda\u8f6e", "\u5982\u679c\u542f\u7528\uff0c\u60a8\u53ef\u4ee5\u5728\u7f29\u653e\u65f6\u4f7f\u7528\u9f20\u6807\u6eda\u8f6e\u8fdb\u4e00\u6b65\u653e\u5927\u3002", true);
    private final CheckboxSetting zoomInScreens = new CheckboxSetting("\u7f29\u653e\u5c4f\u5e55", "\u5982\u679c\u542f\u7528\uff0c\u60a8\u4e5f\u53ef\u4ee5\u5728\u6253\u5f00\u804a\u5929\u7a97\u53e3\u3001\u7269\u54c1\u680f\u7b49\u5c4f\u5e55\u65f6\u8fdb\u884c\u7f29\u653e\u3002", false);
    private final TextFieldSetting keybind = new TextFieldSetting("\u5feb\u6377\u952e", "\u786e\u5b9a\u7f29\u653e\u7684\u5feb\u6377\u952e\u3002\n\n\u4e0e\u5176\u624b\u52a8\u7f16\u8f91\u6b64\u503c\uff0c\u60a8\u5e94\u8be5\u8fdb\u5165Wurst\u9009\u9879 -> \u7f29\u653e\u5e76\u5728\u90a3\u91cc\u8bbe\u7f6e\u3002", "key.keyboard.v", this::isValidKeybind);
    private Double currentLevel;
    private Double defaultMouseSensitivity;

    public ZoomOtf() {
        super("\u7f29\u653e", "\u5141\u8bb8\u60a8\u653e\u5927\u3002\n\u9ed8\u8ba4\u60c5\u51b5\u4e0b\uff0c\u901a\u8fc7\u6309\u4e0b\u00a7lV\u00a7r\u952e\u6fc0\u6d3b\u7f29\u653e\u3002\n\u524d\u5f80Wurst\u9009\u9879 -> \u7f29\u653e\u4ee5\u66f4\u6539\u6b64\u5feb\u6377\u952e\u3002");
        this.addSetting(this.level);
        this.addSetting(this.scroll);
        this.addSetting(this.zoomInScreens);
        this.addSetting(this.keybind);
        EVENTS.add(MouseScrollListener.class, this);
    }

    public float changeFovBasedOnZoom(float fov) {
        class_7172 mouseSensitivitySetting = ZoomOtf.MC.field_1690.method_42495();
        if (this.currentLevel == null) {
            this.currentLevel = this.level.getValue();
        }
        if (!this.isZoomKeyPressed()) {
            this.currentLevel = this.level.getValue();
            if (this.defaultMouseSensitivity != null) {
                mouseSensitivitySetting.method_41748((Object)this.defaultMouseSensitivity);
                this.defaultMouseSensitivity = null;
            }
            return fov;
        }
        if (this.defaultMouseSensitivity == null) {
            this.defaultMouseSensitivity = (Double)mouseSensitivitySetting.method_41753();
        }
        mouseSensitivitySetting.method_41748((Object)(this.defaultMouseSensitivity * (1.0 / this.currentLevel)));
        return (float)((double)fov / this.currentLevel);
    }

    @Override
    public void onMouseScroll(double amount) {
        if (!this.isZoomKeyPressed() || !this.scroll.isChecked()) {
            return;
        }
        if (this.currentLevel == null) {
            this.currentLevel = this.level.getValue();
        }
        if (amount > 0.0) {
            this.currentLevel = this.currentLevel * 1.1;
        } else if (amount < 0.0) {
            this.currentLevel = this.currentLevel * 0.9;
        }
        this.currentLevel = MathUtils.clamp(this.currentLevel, this.level.getMinimum(), this.level.getMaximum());
    }

    public boolean shouldPreventHotbarScrolling() {
        return this.isZoomKeyPressed() && this.scroll.isChecked();
    }

    public class_2561 getTranslatedKeybindName() {
        return class_3675.method_15981((String)this.keybind.getValue()).method_27445();
    }

    public void setBoundKey(String translationKey) {
        this.keybind.setValue(translationKey);
    }

    private boolean isZoomKeyPressed() {
        if (ZoomOtf.MC.field_1755 != null && !this.zoomInScreens.isChecked()) {
            return false;
        }
        return class_3675.method_15987((long)MC.method_22683().method_4490(), (int)class_3675.method_15981((String)this.keybind.getValue()).method_1444());
    }

    private boolean isValidKeybind(String keybind) {
        try {
            return class_3675.method_15981((String)keybind) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public SliderSetting getLevelSetting() {
        return this.level;
    }

    public CheckboxSetting getScrollSetting() {
        return this.scroll;
    }
}

