/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.other_features;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import net.wurstclient.Category;
import net.wurstclient.Feature;
import net.wurstclient.hack.Hack;
import net.wurstclient.keybinds.Keybind;
import net.wurstclient.keybinds.KeybindList;
import net.wurstclient.other_feature.OtherFeature;
import net.wurstclient.settings.Setting;
import net.wurstclient.util.ChatUtils;
import net.wurstclient.util.json.JsonUtils;

public final class WikiDataExportOtf
extends OtherFeature {
    public WikiDataExportOtf() {
        super("\u7ef4\u57fa\u6570\u636e\u5bfc\u51fa", "\u521b\u5efa\u4e00\u4e2a\u5305\u542b\u6b64\u7248\u672cWurst\u4e2d\u6240\u6709\u529f\u80fd\u548c\u8bbe\u7f6e\u7684\u6280\u672f\u7ec6\u8282\u7684JSON\u6587\u4ef6\u4e0d\u540c\u7684\u529f\u80fd\u548c\u8bbe\u7f6e\u7684\u6280\u672f\u7ec6\u8282\u4e3b\u8981\u7528\u4e8e\u66f4\u65b0Wurst\u7ef4\u57fa\u3002");
    }

    @Override
    public String getPrimaryAction() {
        return "\u5bfc\u51fa\u6570\u636e";
    }

    @Override
    public void doPrimaryAction() {
        try {
            Path exportFile = WURST.getWurstFolder().resolve("wiki-data.json");
            JsonObject json = new JsonObject();
            for (Hack hack : WURST.getHax().getAllHax()) {
                json.add(hack.getName(), (JsonElement)this.hackToJson(hack));
            }
            JsonUtils.toJson((JsonElement)json, exportFile);
        }
        catch (Exception e) {
            ChatUtils.error("\u5bfc\u51fa\u6570\u636e\u5931\u8d25: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private JsonObject hackToJson(Hack hack) {
        JsonObject json = new JsonObject();
        json.addProperty("name", hack.getName());
        json.addProperty("descriptionKey", hack.getDescriptionKey());
        json.addProperty("type", "Hack");
        Category category = hack.getCategory();
        if (category != null) {
            json.addProperty("category", category.getName());
        }
        json.addProperty("keybind", this.getDefaultKeybind(hack));
        json.addProperty("stateSaved", Boolean.valueOf(hack.isStateSaved()));
        json.addProperty("class", hack.getClass().getName());
        JsonArray settings = new JsonArray();
        for (Setting setting : hack.getSettings().values()) {
            settings.add((JsonElement)setting.exportWikiData());
        }
        json.add("settings", (JsonElement)settings);
        return json;
    }

    private String getDefaultKeybind(Feature feature) {
        String name = feature.getName().toLowerCase().replace(" ", "_");
        if (name.startsWith(".")) {
            name = name.substring(1);
        }
        for (Keybind keybind : KeybindList.DEFAULT_KEYBINDS) {
            if (!keybind.getCommands().toLowerCase().contains(name)) continue;
            return keybind.getKey();
        }
        return null;
    }
}

