/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.hacks.autofish;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1536;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.wurstclient.WurstClient;
import net.wurstclient.hacks.autofish.FishingSpot;
import net.wurstclient.hacks.autofish.PositionAndRotation;
import net.wurstclient.mixinterface.IKeyBinding;
import net.wurstclient.settings.CheckboxSetting;
import net.wurstclient.settings.Setting;
import net.wurstclient.settings.SliderSetting;
import net.wurstclient.util.ChatUtils;
import net.wurstclient.util.Rotation;
import net.wurstclient.util.RotationUtils;

public final class FishingSpotManager {
    private static final class_310 MC = WurstClient.MC;
    private final CheckboxSetting mcmmoMode = new CheckboxSetting("mcMMO\u6a21\u5f0f", "\u5982\u679c\u542f\u7528\uff0cAutoFish\u5c06\u5728\u4e24\u4e2a\u4e0d\u540c\u7684\u9493\u9c7c\u70b9\u4e4b\u95f4\u5faa\u73af to bypass mcMMO's overfishing mechanic.\n\n\u5982\u679c\u7981\u7528\uff0c\u6240\u6709\u5176\u4ed6mcMMO\u8bbe\u7f6e\u5c06\u4e0d\u8d77\u4f5c\u7528", false);
    private final SliderSetting mcmmoRange = new SliderSetting("mcMMO\u8303\u56f4", "The value of mcMMO's MoveRange config option. This is the minimum \u4e24\u4e2a\u9493\u9c7c\u70b9\u4e4b\u95f4\u7684\u8ddd\u79bb\u4ee5\u907f\u514d\u8fc7\u5ea6\u6355\u9c7c\u3002\n\nmcMMO only cares about the position of the bobber, so you don't \u4e0d\u9700\u8981\u79fb\u52a8\u60a8\u7684\u89d2\u8272\uff0c\u9664\u975e\u6709\u5176\u4ed6\u53cdAFK\u63d2\u4ef6 \u5b58\u5728", 3.0, 1.0, 50.0, 1.0, SliderSetting.ValueDisplay.INTEGER.withSuffix(" \u65b9\u5757"));
    private final CheckboxSetting mcmmoRangeBug = new CheckboxSetting("mcMMO\u8303\u56f4\u9519\u8bef", "At the time of writing, there is a bug in mcMMO's range \u610f\u5473\u7740\u9ed8\u8ba4\u76843\u65b9\u5757\u8303\u56f4\u5b9e\u9645\u4e0a\u662f \u5b9e\u9645\u4e0a\u53ea\u67092\u65b9\u5757\u3002\n\n\u5982\u679c\u4ed6\u4eec\u4ee5\u540e\u4fee\u590d\u4e86\u8fd9\u4e2a\u95ee\u9898\uff0c\u8bf7\u53d6\u6d88\u52fe\u9009\u6b64\u6846\u3002", true);
    private final SliderSetting mcmmoLimit = new SliderSetting("mcMMO\u9650\u5236", "The value of mcMMO's OverFishLimit config option. Overfishing starts \u5728\u6b64\u503c\u4e0b\uff0c\u60a8\u5b9e\u9645\u4e0a\u53ea\u80fd\u6355\u83b7 (limit - 1) \u6761\u9c7c \u4ece\u540c\u4e00\u4e2a\u4f4d\u7f6e\u3002", 10.0, 2.0, 1000.0, 1.0, SliderSetting.ValueDisplay.INTEGER);
    private final ArrayList<FishingSpot> fishingSpots = new ArrayList();
    private FishingSpot lastSpot;
    private FishingSpot nextSpot;
    private PositionAndRotation castPosRot;
    private int fishCaughtAtLastSpot;
    private boolean spot1MsgShown;
    private boolean spot2MsgShown;
    private boolean setupDoneMsgShown;

    public boolean onCast() {
        this.castPosRot = new PositionAndRotation((class_1297)FishingSpotManager.MC.field_1724);
        if (!this.mcmmoMode.isChecked()) {
            return true;
        }
        if (this.lastSpot == null) {
            if (this.spot1MsgShown) {
                return true;
            }
            ChatUtils.message("\u6b63\u5728\u542f\u52a8AutoFish mcMMO\u6a21\u5f0f\u3002");
            ChatUtils.message("\u8bf7\u7b49\u5f85\u7b2c\u4e00\u4e2a\u9493\u9c7c\u70b9\u88ab\u8bb0\u5f55\u3002 \u6b63\u5728\u88ab\u8bb0\u5f55\u3002");
            this.spot1MsgShown = true;
            return true;
        }
        this.spot1MsgShown = false;
        if (this.nextSpot == null && (this.nextSpot = this.chooseNextSpot()) == null) {
            if (this.spot2MsgShown) {
                return false;
            }
            ChatUtils.message("AutoFish mcMMO\u6a21\u5f0f\u9700\u8981\u53e6\u4e00\u4e2a\u9493\u9c7c\u70b9\u3002");
            ChatUtils.message("\u79fb\u52a8\u60a8\u7684\u6444\u50cf\u673a\uff08\u5982\u679c\u6709\u5fc5\u8981\uff0c\u79fb\u52a8\u73a9\u5bb6\uff09 \u4f7f\u9493\u9975\u843d\u5728\u7ea2\u8272\u65b9\u6846\u5916\uff0c\u7136\u540e \u6295\u63b7\u9c7c\u7aff\u3002");
            this.spot2MsgShown = true;
            this.setupDoneMsgShown = false;
            return false;
        }
        this.spot2MsgShown = false;
        if (!this.setupDoneMsgShown) {
            ChatUtils.message("\u5b8c\u6210\uff01AutoFish\u73b0\u5728\u5c06\u81ea\u52a8\u8fd0\u884c \u5e76\u6839\u636e\u9700\u8981\u5728\u9493\u9c7c\u70b9\u4e4b\u95f4\u5207\u6362\u3002");
            this.setupDoneMsgShown = true;
        }
        if (this.fishCaughtAtLastSpot >= this.mcmmoLimit.getValueI() - 1) {
            this.moveToNextSpot();
            return false;
        }
        return true;
    }

    private void moveToNextSpot() {
        IKeyBinding forwardKey = IKeyBinding.get(FishingSpotManager.MC.field_1690.field_1894);
        IKeyBinding jumpKey = IKeyBinding.get(FishingSpotManager.MC.field_1690.field_1903);
        PositionAndRotation nextPosRot = this.nextSpot.input();
        forwardKey.resetPressedState();
        jumpKey.resetPressedState();
        class_243 nextPos = nextPosRot.pos();
        double distance = nextPos.method_1022(this.castPosRot.pos());
        if (distance > 0.1) {
            Rotation needed = RotationUtils.getNeededRotations(nextPos).withPitch(0.0f);
            if (!RotationUtils.isAlreadyFacing(needed)) {
                RotationUtils.slowlyTurnTowards(needed, 5.0f).applyToClientPlayer();
                return;
            }
            jumpKey.method_23481(FishingSpotManager.MC.field_1724.method_5799() || FishingSpotManager.MC.field_1724.field_5976);
            if (distance < 0.2) {
                FishingSpotManager.MC.field_1724.method_5814(nextPos.field_1352, nextPos.field_1351, nextPos.field_1350);
            } else if (distance > 0.7 || FishingSpotManager.MC.field_1724.field_6012 % 10 == 0) {
                forwardKey.method_23481(true);
            }
            return;
        }
        Rotation nextRot = nextPosRot.rotation();
        if (!RotationUtils.isAlreadyFacing(nextRot)) {
            RotationUtils.slowlyTurnTowards(nextRot, 5.0f).applyToClientPlayer();
            return;
        }
        this.lastSpot = this.nextSpot;
        this.nextSpot = null;
        this.fishCaughtAtLastSpot = 0;
    }

    public void onBite(class_1536 bobber) {
        boolean sameBobberPos;
        boolean samePlayerInput = this.lastSpot != null && this.lastSpot.input().isNearlyIdenticalTo(this.castPosRot);
        boolean bl = sameBobberPos = this.lastSpot != null && this.isInRange(this.lastSpot.bobberPos(), bobber.method_19538());
        this.fishCaughtAtLastSpot = sameBobberPos ? ++this.fishCaughtAtLastSpot : 1;
        if (!samePlayerInput) {
            this.lastSpot = new FishingSpot(this.castPosRot, bobber);
            this.fishingSpots.add(this.lastSpot);
            return;
        }
        if (!sameBobberPos) {
            FishingSpot updatedSpot = new FishingSpot(this.lastSpot.input(), bobber);
            this.fishingSpots.remove(this.lastSpot);
            this.fishingSpots.add(updatedSpot);
            this.lastSpot = updatedSpot;
        }
    }

    public void reset() {
        this.fishingSpots.clear();
        this.lastSpot = null;
        this.nextSpot = null;
        this.castPosRot = null;
        this.fishCaughtAtLastSpot = 0;
        this.spot1MsgShown = false;
        this.spot2MsgShown = false;
        this.setupDoneMsgShown = false;
    }

    private FishingSpot chooseNextSpot() {
        return this.fishingSpots.stream().filter(spot -> spot != this.lastSpot).filter(spot -> !this.isInRange(spot.bobberPos(), this.lastSpot.bobberPos())).min(Comparator.comparingDouble(spot -> spot.input().differenceTo(this.lastSpot.input()))).orElse(null);
    }

    private boolean isInRange(class_243 pos1, class_243 pos2) {
        double dz;
        double dy = Math.abs(pos1.field_1351 - pos2.field_1351);
        if (dy > 2.0) {
            return false;
        }
        double dx = Math.abs(pos1.field_1352 - pos2.field_1352);
        return Math.max(dx, dz = Math.abs(pos1.field_1350 - pos2.field_1350)) <= (double)this.getRange();
    }

    public int getRange() {
        if (this.mcmmoRangeBug.isChecked()) {
            return this.mcmmoRange.getValueI() / 2 * 2;
        }
        return this.mcmmoRange.getValueI();
    }

    public FishingSpot getLastSpot() {
        return this.lastSpot;
    }

    public boolean isSetupDone() {
        return this.lastSpot != null && this.nextSpot != null;
    }

    public boolean isMcmmoMode() {
        return this.mcmmoMode.isChecked();
    }

    public Stream<Setting> getSettings() {
        return Stream.of(this.mcmmoMode, this.mcmmoRange, this.mcmmoRangeBug, this.mcmmoLimit);
    }

    public List<FishingSpot> getFishingSpots() {
        return Collections.unmodifiableList(this.fishingSpots);
    }
}

