/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.hacks.autocomplete;

import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.class_3532;
import net.wurstclient.settings.Setting;
import net.wurstclient.settings.SliderSetting;

public final class SuggestionHandler {
    private final ArrayList<String> suggestions = new ArrayList();
    private final SliderSetting maxSuggestionsPerDraft = new SliderSetting("\u6bcf\u4e2a\u8349\u7a3f\u7684\u6700\u5927\u5efa\u8bae\u6570", "AI\u53ef\u4ee5\u4e3a\u540c\u4e00 \u8349\u7a3f\u6d88\u606f\u751f\u6210\u591a\u5c11\u5efa\u8bae", 3.0, 1.0, 10.0, 1.0, SliderSetting.ValueDisplay.INTEGER);
    private final SliderSetting maxSuggestionsKept = new SliderSetting("\u6700\u5927\u4fdd\u7559\u5efa\u8bae\u6570", "\u6700\u5927\u4fdd\u7559\u7684\u5efa\u8bae\u6570\uff08\u5185\u5b58\u4e2d\uff09", 100.0, 10.0, 1000.0, 10.0, SliderSetting.ValueDisplay.INTEGER);
    private final SliderSetting maxSuggestionsShown = new SliderSetting("\u6700\u5927\u663e\u793a\u5efa\u8bae\u6570", "\u53ef\u4ee5\u663e\u793a\u5728\u804a\u5929\u6846\u4e0a\u65b9\u7684\u5efa\u8bae\u6570\u3002\n\n\u5982\u679c\u8bbe\u7f6e\u5f97\u592a\u9ad8\uff0c\u5efa\u8bae\u5c06\u906e\u6321\u4e00\u4e9b \u73b0\u6709\u7684\u804a\u5929\u6d88\u606f\u3002\u60a8\u53ef\u4ee5\u8bbe\u7f6e\u7684\u591a\u9ad8\u53d6\u51b3\u4e8e \u60a8\u7684\u5c4f\u5e55\u5206\u8fa8\u7387\u548cGUI\u7f29\u653e\u6bd4\u4f8b", 5.0, 1.0, 10.0, 1.0, SliderSetting.ValueDisplay.INTEGER);
    private final List<Setting> settings = Arrays.asList(this.maxSuggestionsPerDraft, this.maxSuggestionsKept, this.maxSuggestionsShown);

    public List<Setting> getSettings() {
        return this.settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxSuggestionsFor(String draftMessage) {
        ArrayList<String> arrayList = this.suggestions;
        synchronized (arrayList) {
            int existing = (int)this.suggestions.stream().map(String::toLowerCase).filter(s -> s.startsWith(draftMessage.toLowerCase())).count();
            int maxPerDraft = this.maxSuggestionsPerDraft.getValueI();
            return class_3532.method_15340((int)(maxPerDraft - existing), (int)0, (int)maxPerDraft);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSuggestion(String suggestion, String draftMessage, BiConsumer<SuggestionsBuilder, String> suggestionsUpdater) {
        ArrayList<String> arrayList = this.suggestions;
        synchronized (arrayList) {
            String completedMessage = draftMessage + suggestion;
            if (!this.suggestions.contains(completedMessage)) {
                this.suggestions.add(completedMessage);
                if ((double)this.suggestions.size() > this.maxSuggestionsKept.getValue()) {
                    this.suggestions.remove(0);
                }
            }
            this.showSuggestionsImpl(draftMessage, suggestionsUpdater);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showSuggestions(String draftMessage, BiConsumer<SuggestionsBuilder, String> suggestionsUpdater) {
        ArrayList<String> arrayList = this.suggestions;
        synchronized (arrayList) {
            this.showSuggestionsImpl(draftMessage, suggestionsUpdater);
        }
    }

    private void showSuggestionsImpl(String draftMessage, BiConsumer<SuggestionsBuilder, String> suggestionsUpdater) {
        SuggestionsBuilder builder = new SuggestionsBuilder(draftMessage, 0);
        String inlineSuggestion = null;
        int shownSuggestions = 0;
        for (int i = this.suggestions.size() - 1; i >= 0; --i) {
            String s = this.suggestions.get(i);
            if (!s.toLowerCase().startsWith(draftMessage.toLowerCase())) continue;
            if ((double)shownSuggestions >= this.maxSuggestionsShown.getValue()) break;
            builder.suggest(s);
            inlineSuggestion = s;
            ++shownSuggestions;
        }
        suggestionsUpdater.accept(builder, inlineSuggestion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSuggestions() {
        ArrayList<String> arrayList = this.suggestions;
        synchronized (arrayList) {
            this.suggestions.clear();
        }
    }
}

