/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.hacks.autocomplete;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import net.wurstclient.hacks.autocomplete.MessageCompleter;
import net.wurstclient.hacks.autocomplete.ModelSettings;
import net.wurstclient.util.json.JsonException;
import net.wurstclient.util.json.JsonUtils;
import net.wurstclient.util.json.WsonObject;

public final class OpenAiMessageCompleter
extends MessageCompleter {
    public OpenAiMessageCompleter(ModelSettings modelSettings) {
        super(modelSettings);
    }

    @Override
    protected JsonObject buildParams(String prompt, int maxSuggestions) {
        JsonObject params = new JsonObject();
        params.addProperty("\u505c\u6b62", this.modelSettings.stopSequence.getSelected().getSequence());
        params.addProperty("\u6700\u5927\u4ee4\u724c\u6570", (Number)this.modelSettings.maxTokens.getValueI());
        params.addProperty("\u6e29\u5ea6", (Number)this.modelSettings.temperature.getValue());
        params.addProperty("top_p", (Number)this.modelSettings.topP.getValue());
        params.addProperty("\u5b58\u5728\u60e9\u7f5a", (Number)this.modelSettings.presencePenalty.getValue());
        params.addProperty("\u9891\u7387\u60e9\u7f5a", (Number)this.modelSettings.frequencyPenalty.getValue());
        params.addProperty("n", (Number)maxSuggestions);
        boolean customModel = !this.modelSettings.customModel.getValue().isBlank();
        String modelName = customModel ? this.modelSettings.customModel.getValue() : String.valueOf((Object)this.modelSettings.openAiModel.getSelected());
        boolean chatModel = customModel ? this.modelSettings.customModelType.getSelected().isChat() : this.modelSettings.openAiModel.getSelected().isChatModel();
        params.addProperty("\u6a21\u578b", modelName);
        if (chatModel) {
            JsonArray messages = new JsonArray();
            JsonObject systemMessage = new JsonObject();
            systemMessage.addProperty("\u89d2\u8272", "\u7cfb\u7edf");
            systemMessage.addProperty("\u5185\u5bb9", "\u5b8c\u6210\u4ee5\u4e0b\u6587\u672c\u3002\u4ec5\u56de\u590d\u5b8c\u6210\u90e8\u5206\u3002 \u4f60\u4e0d\u662f\u52a9\u624b\u3002");
            messages.add((JsonElement)systemMessage);
            JsonObject promptMessage = new JsonObject();
            promptMessage.addProperty("\u89d2\u8272", "\u7528\u6237");
            promptMessage.addProperty("\u5185\u5bb9", prompt);
            messages.add((JsonElement)promptMessage);
            params.add("\u6d88\u606f", (JsonElement)messages);
        } else {
            params.addProperty("\u63d0\u793a", prompt);
        }
        return params;
    }

    @Override
    protected WsonObject requestCompletions(JsonObject parameters) throws IOException, JsonException {
        URL url = URI.create(this.modelSettings.openAiModel.getSelected().isChatModel() ? this.modelSettings.openaiChatEndpoint.getValue() : this.modelSettings.openaiLegacyEndpoint.getValue()).toURL();
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setRequestProperty("\u5185\u5bb9\u7c7b\u578b", "application/json");
        conn.setRequestProperty("\u6388\u6743", "Bearer " + System.getenv("WURST_OPENAI_KEY"));
        conn.setDoOutput(true);
        try (OutputStream os = conn.getOutputStream();){
            os.write(JsonUtils.GSON.toJson((JsonElement)parameters).getBytes());
            os.flush();
        }
        return JsonUtils.parseConnectionToObject(conn);
    }

    @Override
    protected String[] extractCompletions(WsonObject response) throws JsonException {
        ArrayList<String> completions = new ArrayList<String>();
        ArrayList<WsonObject> choices = response.getArray("\u9009\u62e9").getAllObjects();
        if (this.modelSettings.openAiModel.getSelected().isChatModel()) {
            for (WsonObject choice : choices) {
                WsonObject message = choice.getObject("\u6d88\u606f");
                String content = message.getString("\u5185\u5bb9");
                completions.add(content);
            }
        } else {
            for (WsonObject choice : choices) {
                completions.add(choice.getString("\u6587\u672c"));
            }
        }
        for (String completion : completions) {
            completion = completion.replace("\n", " ");
        }
        return completions.toArray(new String[completions.size()]);
    }
}

