/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.hacks;

import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_290;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.wurstclient.Category;
import net.wurstclient.SearchTags;
import net.wurstclient.WurstRenderLayers;
import net.wurstclient.events.PacketInputListener;
import net.wurstclient.events.RenderListener;
import net.wurstclient.events.UpdateListener;
import net.wurstclient.hack.Hack;
import net.wurstclient.settings.ChunkAreaSetting;
import net.wurstclient.settings.ColorSetting;
import net.wurstclient.settings.SliderSetting;
import net.wurstclient.util.BlockVertexCompiler;
import net.wurstclient.util.ChatUtils;
import net.wurstclient.util.EasyVertexBuffer;
import net.wurstclient.util.RegionPos;
import net.wurstclient.util.RenderUtils;
import net.wurstclient.util.RotationUtils;
import net.wurstclient.util.chunk.ChunkSearcher;
import net.wurstclient.util.chunk.ChunkSearcherCoordinator;

@SearchTags(value={"cave finder"})
public final class CaveFinderHack
extends Hack
implements UpdateListener,
RenderListener {
    private final ChunkAreaSetting area = new ChunkAreaSetting("\u6d1e\u7a74\u67e5\u627e\u8005\u7684\u641c\u7d22\u533a\u57df\u3002", "\u6d1e\u7a74\u67e5\u627e\u8005\u7684\u641c\u7d22\u533a\u57df\u3002\u66f4\u9ad8\u7684\u503c\u9700\u8981\u66f4\u5feb\u7684\u8ba1\u7b97\u673a\u3002");
    private final SliderSetting limit = new SliderSetting("\u9650\u5236", "\u8981\u663e\u793a\u7684\u6700\u5927\u65b9\u5757\u6570\u91cf\u3002\u66f4\u9ad8\u7684\u503c\u9700\u8981\u66f4\u5feb\u7684\u8ba1\u7b97\u673a\u3002", 5.0, 3.0, 6.0, 1.0, SliderSetting.ValueDisplay.LOGARITHMIC);
    private final ColorSetting color = new ColorSetting("\u989c\u8272", "\u6d1e\u7a74\u5c06\u4ee5\u8fd9\u79cd\u989c\u8272\u9ad8\u4eae\u663e\u793a\u3002", Color.RED);
    private final SliderSetting opacity = new SliderSetting("\u4e0d\u900f\u660e\u5ea6", "\u9ad8\u4eae\u663e\u793a\u7684\u4e0d\u900f\u660e\u5ea6\u30020 = \u547c\u5438\u52a8\u753b", 0.0, 0.0, 1.0, 0.01, SliderSetting.ValueDisplay.PERCENTAGE.withLabel(0.0, "\u547c\u5438"));
    private int prevLimit;
    private boolean notify;
    private final ChunkSearcherCoordinator coordinator = new ChunkSearcherCoordinator((pos, state) -> state.method_26204() == class_2246.field_10543, this.area);
    private ForkJoinPool forkJoinPool;
    private ForkJoinTask<HashSet<class_2338>> getMatchingBlocksTask;
    private ForkJoinTask<ArrayList<int[]>> compileVerticesTask;
    private EasyVertexBuffer vertexBuffer;
    private RegionPos bufferRegion;
    private boolean bufferUpToDate;

    public CaveFinderHack() {
        super("\u6d1e\u7a74\u5bfb\u627e\u8005");
        this.setCategory(Category.RENDER);
        this.addSetting(this.area);
        this.addSetting(this.limit);
        this.addSetting(this.color);
        this.addSetting(this.opacity);
    }

    @Override
    protected void onEnable() {
        this.prevLimit = this.limit.getValueI();
        this.notify = true;
        this.forkJoinPool = new ForkJoinPool();
        this.bufferUpToDate = false;
        EVENTS.add(UpdateListener.class, this);
        EVENTS.add(PacketInputListener.class, this.coordinator);
        EVENTS.add(RenderListener.class, this);
    }

    @Override
    protected void onDisable() {
        EVENTS.remove(UpdateListener.class, this);
        EVENTS.remove(PacketInputListener.class, this.coordinator);
        EVENTS.remove(RenderListener.class, this);
        this.stopBuildingBuffer();
        this.coordinator.reset();
        this.forkJoinPool.shutdownNow();
        if (this.vertexBuffer != null) {
            this.vertexBuffer.close();
        }
        this.vertexBuffer = null;
        this.bufferRegion = null;
    }

    @Override
    public void onUpdate() {
        boolean searchersChanged = this.coordinator.update();
        if (searchersChanged) {
            this.stopBuildingBuffer();
        }
        if (!this.coordinator.isDone()) {
            return;
        }
        if (this.limit.getValueI() != this.prevLimit) {
            this.stopBuildingBuffer();
            this.prevLimit = this.limit.getValueI();
            this.notify = true;
        }
        if (this.getMatchingBlocksTask == null) {
            this.startGetMatchingBlocksTask();
        }
        if (!this.getMatchingBlocksTask.isDone()) {
            return;
        }
        if (this.compileVerticesTask == null) {
            this.startCompileVerticesTask();
        }
        if (!this.compileVerticesTask.isDone()) {
            return;
        }
        if (!this.bufferUpToDate) {
            this.setBufferFromTask();
        }
    }

    @Override
    public void onRender(class_4587 matrixStack, float partialTicks) {
        if (this.vertexBuffer == null || this.bufferRegion == null) {
            return;
        }
        float x = (float)(System.currentTimeMillis() % 2000L) / 1000.0f;
        float alpha = 0.25f + 0.25f * class_3532.method_15374((float)(x * (float)Math.PI));
        if (this.opacity.getValue() > 0.0) {
            alpha = this.opacity.getValueF();
        }
        matrixStack.method_22903();
        RenderUtils.applyRegionalRenderOffset(matrixStack, this.bufferRegion);
        this.vertexBuffer.draw(matrixStack, WurstRenderLayers.ESP_QUADS, this.color.getColorF(), alpha);
        matrixStack.method_22909();
    }

    private void stopBuildingBuffer() {
        if (this.getMatchingBlocksTask != null) {
            this.getMatchingBlocksTask.cancel(true);
            this.getMatchingBlocksTask = null;
        }
        if (this.compileVerticesTask != null) {
            this.compileVerticesTask.cancel(true);
            this.compileVerticesTask = null;
        }
        this.bufferUpToDate = false;
    }

    private void startGetMatchingBlocksTask() {
        class_2338 eyesPos = class_2338.method_49638((class_2374)RotationUtils.getEyesPos());
        Comparator<class_2338> comparator = Comparator.comparingInt(pos -> eyesPos.method_19455((class_2382)pos));
        this.getMatchingBlocksTask = this.forkJoinPool.submit(() -> ((Stream)this.coordinator.getMatches().parallel()).map(ChunkSearcher.Result::pos).sorted(comparator).limit(this.limit.getValueLog()).collect(Collectors.toCollection(HashSet::new)));
    }

    private void startCompileVerticesTask() {
        HashSet<class_2338> matchingBlocks = this.getMatchingBlocksTask.join();
        if (matchingBlocks.size() < this.limit.getValueLog()) {
            this.notify = true;
        } else if (this.notify) {
            ChatUtils.warning("\u6d1e\u7a74\u67e5\u627e\u8005\u627e\u5230\u4e86 \u00a7l\u5927\u91cf\u00a7r \u7684\u65b9\u5757\uff01 \u4e3a\u4e86\u9632\u6b62\u5ef6\u8fdf\uff0c\u5b83\u53ea\u4f1a\u663e\u793a\u6700\u8fd1\u7684 \u00a76" + this.limit.getValueString() + "\u00a7r \u7ed3\u679c\u3002");
            this.notify = false;
        }
        this.compileVerticesTask = this.forkJoinPool.submit(() -> BlockVertexCompiler.compile(matchingBlocks));
    }

    private void setBufferFromTask() {
        ArrayList<int[]> vertices = this.compileVerticesTask.join();
        RegionPos region = RenderUtils.getCameraRegion();
        if (this.vertexBuffer != null) {
            this.vertexBuffer.close();
        }
        this.vertexBuffer = EasyVertexBuffer.createAndUpload(VertexFormat.class_5596.field_27382, class_290.field_1576, buffer -> {
            for (int[] vertex : vertices) {
                buffer.method_22912((float)(vertex[0] - region.x()), (float)vertex[1], (float)(vertex[2] - region.z())).method_39415(-1);
            }
        });
        this.bufferUpToDate = true;
        this.bufferRegion = region;
    }
}

