/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.commands;

import net.minecraft.class_2248;
import net.wurstclient.DontBlock;
import net.wurstclient.Feature;
import net.wurstclient.command.CmdError;
import net.wurstclient.command.CmdException;
import net.wurstclient.command.CmdSyntaxError;
import net.wurstclient.command.Command;
import net.wurstclient.settings.BlockSetting;
import net.wurstclient.settings.Setting;
import net.wurstclient.util.BlockUtils;
import net.wurstclient.util.CmdUtils;

@DontBlock
public final class SetBlockCmd
extends Command {
    public SetBlockCmd() {
        super("setblock", "Changes a block setting of a feature. Allows you\nto change these settings through keybinds.", ".setblock <feature> <setting> <block>", ".setblock <feature> <setting> reset", "Example: .setblock Nuker ID dirt");
    }

    @Override
    public void call(String[] args) throws CmdException {
        if (args.length != 3) {
            throw new CmdSyntaxError();
        }
        Feature feature = CmdUtils.findFeature(args[0]);
        Setting setting = CmdUtils.findSetting(feature, args[1]);
        BlockSetting blockSetting = this.getAsBlockSetting(feature, setting);
        this.setBlock(blockSetting, args[2]);
    }

    private BlockSetting getAsBlockSetting(Feature feature, Setting setting) throws CmdError {
        if (!(setting instanceof BlockSetting)) {
            throw new CmdError(feature.getName() + " " + setting.getName() + " is not a block setting.");
        }
        return (BlockSetting)setting;
    }

    private void setBlock(BlockSetting setting, String value) throws CmdSyntaxError {
        if (value.toLowerCase().equals("reset")) {
            setting.resetToDefault();
            return;
        }
        class_2248 block = BlockUtils.getBlockFromNameOrID(value);
        if (block == null) {
            throw new CmdSyntaxError("\"" + value + "\" is not a valid block.");
        }
        setting.setBlock(block);
    }
}

