/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.analytics;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import net.wurstclient.analytics.PlausibleAnalytics;
import net.wurstclient.util.json.JsonException;
import net.wurstclient.util.json.JsonUtils;
import net.wurstclient.util.json.WsonObject;

public final class AnalyticsConfigFile {
    private final Path path;

    public AnalyticsConfigFile(Path path) {
        this.path = path;
    }

    public void load(PlausibleAnalytics plausible) {
        try {
            WsonObject wson = JsonUtils.parseFileToObject(this.path);
            plausible.setEnabled(wson.getBoolean("enabled"));
        }
        catch (NoSuchFileException wson) {
        }
        catch (IOException | JsonException e) {
            System.out.println("Couldn't load " + String.valueOf(this.path.getFileName()));
            e.printStackTrace();
        }
        this.save(plausible);
    }

    public void save(PlausibleAnalytics plausible) {
        JsonObject json = this.createJson(plausible);
        try {
            JsonUtils.toJson((JsonElement)json, this.path);
        }
        catch (IOException | JsonException e) {
            System.out.println("Couldn't save " + String.valueOf(this.path.getFileName()));
            e.printStackTrace();
        }
    }

    private JsonObject createJson(PlausibleAnalytics plausible) {
        JsonObject json = new JsonObject();
        json.addProperty("enabled", Boolean.valueOf(plausible.isEnabled()));
        return json;
    }
}

