# UI优化和功能增强计划

本文档说明了6个主要优化任务的实现方案。

## 1. 无标题栏窗口实现

### 已完成
- ✅ 创建了 `FramelessWindow` 基类 (`module/frameless_window.py`)
- ✅ 实现了自定义标题栏、最大化、最小化、关闭按钮
- ✅ 支持窗口拖拽功能

### 待实现
- [ ] 将 `SettingsDialog` 改为继承 `FramelessWindow`
- [ ] 将 `CodeDialog` 改为继承 `FramelessWindow`
- [ ] 将 `BuiltInPreviewWindow` 改为继承 `FramelessWindow`
- [ ] 将 `WindowClassDialog` 改为继承 `FramelessWindow`
- [ ] 将 `MenuEditorDialog` 改为继承 `FramelessWindow`
- [ ] 为主窗口添加无标题栏选项（可选）

## 2. 主题和颜色统一

### 已完成
- ✅ 创建了 `ThemeFontManager` (`module/theme_font_manager.py`)
- ✅ 实现了组件样式获取功能

### 待实现
- [ ] 为所有主题文件添加统一的组件样式
- [ ] 确保所有组件在不同主题下背景色统一
- [ ] 优化组件在不同主题下的对比度和可读性
- [ ] 添加组件样式覆盖机制

## 3. 字体统一

### 已完成
- ✅ `ThemeFontManager` 中实现了统一字体获取方法

### 待实现
- [ ] 在设置中添加字体选择选项
- [ ] 为所有组件应用统一字体
- [ ] 确保字体在不同主题下可读性良好

## 4. 组件配置文件系统

### 已完成
- ✅ 创建了组件配置目录 (`lib/component_configs/`)
- ✅ `ThemeFontManager` 支持读取组件配置文件

### 待实现
- [ ] 为每个组件创建独立的JSON配置文件
- [ ] 实现组件配置的加载和应用机制
- [ ] 实现组件配置的编辑界面
- [ ] 支持组件配置的导入导出

## 5. 撤销重做和保存操作适配

### 待实现
- [ ] 为所有窗口操作添加撤销重做支持
- [ ] 实现窗口状态的保存和恢复
- [ ] 添加操作历史记录
- [ ] 优化保存操作的性能

## 6. 代码编辑器体验优化

### 已完成
- ✅ Monaco Editor 已集成代码补全功能
- ✅ 已有代码高亮功能

### 待实现
- [ ] 增强代码补全提示（添加更多Python和PySide6的关键词）
- [ ] 添加代码提示信息（hover提示）
- [ ] 添加错误检查和提示
- [ ] 优化代码补全的响应速度
- [ ] 添加代码片段（snippets）支持
- [ ] 添加代码格式化功能

## 实施优先级

1. **高优先级**：无标题栏窗口、主题统一、字体统一
2. **中优先级**：组件配置文件系统、代码编辑器优化
3. **低优先级**：撤销重做适配（已有基础实现）

## 注意事项

- 所有修改需要保持向后兼容
- 需要充分测试各个主题下的显示效果
- 配置文件格式需要文档化
- 代码编辑器优化需要考虑性能影响

