# 控件配置文件说明

本目录用于存储各个控件的独立配置文件，每个控件对应一个JSON配置文件。

## 配置文件格式

每个控件的配置文件应包含以下字段：

```json
{
  "name": "控件名称",
  "display_name": "显示名称",
  "category": "控件分类",
  "description": "控件描述",
  "class_name": "PySide6类名",
  "default_properties": {
    "属性名": "属性值"
  },
  "default_size": [宽度, 高度],
  "icon": null,
  "resizable": true,
  "can_contain": false,
  "events": [
    "事件1",
    "事件2"
  ]
}
```

## 文件命名规则

配置文件命名格式：`控件名称.json`

例如：
- `Label.json` - 标签控件配置
- `Button.json` - 按钮控件配置
- `LineEdit.json` - 单行输入框配置

## 使用方法

### 1. 迁移现有配置

如果已有 `controls.json` 文件，可以运行迁移工具将其拆分为单个文件：

```bash
python lib/migrate_to_individual_configs.py
```

### 2. 添加新控件

直接在 `control_configs/` 目录下创建新的 JSON 文件，例如 `MyControl.json`：

```json
{
  "name": "MyControl",
  "display_name": "我的控件",
  "category": "基础",
  "description": "这是一个新控件",
  "class_name": "QWidget",
  "default_properties": {
    "text": "新控件"
  },
  "default_size": [100, 30],
  "icon": null,
  "resizable": true,
  "can_contain": false,
  "events": ["mousePressEvent", "clicked"]
}
```

### 3. 修改现有控件

直接编辑对应的 JSON 文件，修改后程序会自动重新加载（如果支持热重载）。

### 4. 动态加载

程序启动时会自动从本目录加载所有控件配置。也可以通过 `ControlConfigLoader` 进行动态加载：

```python
from lib.control_config_loader import ControlConfigLoader

loader = ControlConfigLoader("lib", use_individual_files=True)

# 加载所有控件
loader.load_all()

# 按需加载单个控件
loader.load_control("Button")

# 保存控件配置
loader.save_control_config("Button", config_dict)

# 重新加载单个控件
loader.reload_control("Button")
```

## 优势

1. **易于管理**: 每个控件一个文件，结构清晰
2. **动态加载**: 支持按需加载，提高启动速度
3. **易于修改**: 修改单个控件不影响其他控件
4. **版本控制友好**: 单个文件的修改更容易追踪
5. **支持热重载**: 可以动态重新加载单个控件配置

## 注意事项

1. JSON 文件格式必须正确，否则可能导致加载失败
2. 控件名称（`name` 字段）必须与文件名（不含扩展名）一致
3. 修改配置文件后，需要重新加载才能生效
4. 建议在修改前备份配置文件

