# 控件配置系统使用说明

## 概述

本系统实现了所有组件的动态加载功能，将所有组件信息（包括属性、事件、默认代码、默认属性、名称等）存储在配置文件中，支持从配置文件动态加载。

## 文件结构

```
lib/
├── control_config_exporter.py  # 控件配置导出工具
├── control_config_loader.py     # 控件配置动态加载器
├── controls.json                # 控件定义配置文件
├── events.json                 # 事件定义配置文件
├── categories.json             # 分类信息配置文件
├── code_templates.json         # 代码生成模板配置文件
└── README.md                   # 本说明文件
```

## 配置文件说明

### controls.json
包含所有控件的定义信息：
- `name`: 控件名称
- `display_name`: 显示名称
- `category`: 分类
- `description`: 描述
- `class_name`: PySide6类名
- `default_properties`: 默认属性字典
- `default_size`: 默认大小 [宽度, 高度]
- `icon`: 图标路径（可选）
- `resizable`: 是否可调整大小
- `can_contain`: 是否可作为容器
- `events`: 支持的事件列表

### events.json
包含所有事件的定义：
- `common_events`: 通用事件（所有控件都支持）
- `control_specific_events`: 控件特定事件

每个事件包含：
- `name`: 事件显示名称
- `signal`: Qt信号名称（如果有）
- `description`: 事件描述
- `function_name_template`: 事件处理函数名称模板

### categories.json
包含控件分类信息：
- 每个分类包含名称、显示名称和控件列表

### code_templates.json
包含代码生成模板：
- `import_template`: 导入语句模板
- `creation_template`: 控件创建模板
- `property_setting_template`: 属性设置模板

## 使用方法

### 1. 导出控件配置

运行导出工具，将所有控件信息导出为配置文件：

```bash
python lib/control_config_exporter.py
```

这将生成以下文件：
- `lib/controls.json`
- `lib/events.json`
- `lib/categories.json`
- `lib/code_templates.json`

### 2. 动态加载控件配置

程序启动时会自动从 `lib` 文件夹加载控件配置。加载逻辑在 `visual_programming_main_pyside.py` 的 `main()` 函数中：

```python
# 在创建应用程序之前加载控件配置
from lib.control_config_loader import ControlConfigLoader
loader = ControlConfigLoader(lib_dir)
loader.load_all()
```

### 3. 手动加载控件配置

如果需要手动加载：

```python
from lib.control_config_loader import ControlConfigLoader

loader = ControlConfigLoader("lib")
loader.load_all()
```

### 4. 添加新控件

要添加新控件，有两种方式：

#### 方式1：修改配置文件
直接编辑 `lib/controls.json`，添加新控件的定义：

```json
{
  "MyNewControl": {
    "name": "MyNewControl",
    "display_name": "我的新控件",
    "category": "基础",
    "description": "这是一个新控件",
    "class_name": "QWidget",
    "default_properties": {
      "text": "新控件"
    },
    "default_size": [100, 30],
    "icon": null,
    "resizable": true,
    "can_contain": false,
    "events": ["mousePressEvent", "clicked"]
  }
}
```

#### 方式2：使用代码注册
在 `module/controls/` 目录下创建新的控件类，然后运行导出工具更新配置文件。

## 系统特性

1. **动态加载**: 所有控件信息从配置文件加载，无需修改代码即可添加新控件
2. **完整信息**: 包含控件的所有信息：属性、事件、默认值、代码生成模板等
3. **向后兼容**: 支持原有的静态控件定义，同时支持动态加载
4. **易于扩展**: 通过修改配置文件即可添加新控件或修改现有控件

## 注意事项

1. 修改配置文件后，需要重启程序才能生效
2. 确保 JSON 文件格式正确，否则可能导致加载失败
3. 如果配置文件不存在，程序会使用默认的静态控件定义
4. 动态加载的控件会与静态定义的控件合并，如果名称冲突，静态定义优先

## 技术实现

- **导出工具**: `ControlConfigExporter` 类负责从代码中提取控件信息并导出为 JSON
- **加载器**: `ControlConfigLoader` 类负责从 JSON 文件加载控件配置并注册到 `control_registry`
- **动态控件**: `DynamicControl` 类是基于配置创建的控件实例，实现了 `BaseControl` 接口
- **兼容层**: `ControlLibrary` 类已更新，支持从静态定义和动态加载的控件中获取信息

