# 项目预览树形框优化说明

## 优化内容

项目预览树形框已按照层次化结构重新组织，结构如下：

```
窗口类: GeneratedWindow
├── 画布代码
│   ├── 尺寸: 800x600
│   └── 代码生成方法
│       ├── _generate_imports: 生成导入语句
│       ├── _generate_window_class: 生成窗口类代码
│       └── ...
├── 功能代码
│   └── code_generator
│       └── 函数和类
│           ├── 函数 (72)
│           │   ├── CodeGenerator.__init__
│           │   ├── CodeGenerator.generate_code
│           │   └── ...
│           └── 类 (4)
│               ├── CodeGenerator
│               │   ├── 成员 (27)
│               │   │   ├── __init__ (method)
│               │   │   ├── generate_code (method)
│               │   │   └── ...
│               │   └── 数据结构 (0)
│               ├── EventFunctionGenerator
│               │   ├── 成员
│               │   └── 数据结构
│               ├── Control
│               │   ├── 成员
│               │   └── 数据结构
│               └── ControlManager
│                   ├── 成员
│                   └── 数据结构
│                       └── 数据结构成员
└── 窗口组件 (29)
    ├── Label (基础)
    │   └── 绑定的事件
    │       ├── ✓ 鼠标按下
    │       ├── ✓ 鼠标释放
    │       └── ...
    ├── Button (基础)
    │   └── 绑定的事件
    └── ...
```

## 层次结构说明

### 1. 窗口类 (Window Class)
- 顶层节点，显示窗口类名称
- 双击可展开/折叠

### 2. 画布代码 (Canvas Code)
- 画布相关配置
- 包含画布尺寸、代码生成方法等

### 3. 功能代码 (Functional Code)
- 所有功能模块的代码信息
- 每个文件包含：
  - **函数和类**
    - **函数**: 列出所有函数（限制显示前10个）
    - **类**: 列出所有类
      - **成员**: 类的方法、属性、变量（限制显示前5个）
      - **数据结构**: 类的数据结构
        - **数据结构成员**: 数据结构的详细成员

### 4. 窗口组件 (Window Components)
- 所有可用的窗口组件
- 每个组件包含：
  - **绑定的事件**: 显示该组件已绑定的事件（如果有实际控件）
  - 如果没有实际控件，显示所有可用事件（限制显示前5个）

## 功能特性

1. **层次清晰**: 按照逻辑层次组织，易于导航
2. **信息完整**: 包含从窗口类到数据结构成员的完整信息
3. **智能显示**: 
   - 只显示已绑定的事件（如果有实际控件）
   - 限制显示数量，避免树形结构过于庞大
4. **兼容模式**: 如果层次化配置加载失败，自动回退到简化结构

## 交互功能

- **双击窗口类/功能代码/类/组件**: 展开/折叠节点
- **双击画布代码**: 切换到画布代码标签页
- **双击函数文件**: 切换到事件函数文件标签页
- **双击控件**: 在设计画布中选中该控件
- **双击事件**: 跳转到对应的事件处理函数

## 技术实现

1. **使用层次化配置加载器**: 从 `hierarchical_config.json` 加载配置
2. **动态构建树形结构**: 根据配置动态生成树节点
3. **数据关联**: 每个节点都关联相应的数据，支持双击操作
4. **错误处理**: 如果配置加载失败，自动使用简化结构

## 文件修改

- `module/main_window_pyside.py`
  - `_refresh_project_preview()`: 重构为使用层次化配置
  - `_build_hierarchical_tree()`: 新增，构建层次化树形结构
  - `_build_simple_tree()`: 新增，构建简化结构（兼容模式）
  - `_on_preview_item_double_clicked()`: 扩展，支持新的节点类型

## 使用说明

1. 确保已生成层次化配置文件：
   ```bash
   python lib/hierarchical_config_exporter.py
   ```

2. 在项目预览面板中点击"刷新预览"按钮

3. 树形结构会自动按照层次化配置组织

4. 双击节点可以展开/折叠或执行相应操作

