# 多窗口类功能实现说明

## 完成的功能

### 1. ✅ 树形框优化
- **默认不展开**: 树形框默认不展开，防止卡顿
- **支持键盘操作**: 
  - `Delete` 键删除选中项（窗口类、控件、事件）
  - `Ctrl+C` 复制选中项（窗口类、控件）

### 2. ✅ 多窗口类管理系统
- **窗口类管理器** (`module/window_class_manager.py`):
  - 支持创建多个窗口类
  - 每个窗口类独立管理控件
  - 自动防止重名
  - 支持重命名、复制、删除

### 3. ✅ 保存/加载逻辑优化
- **项目管理器** (`module/project_manager_pyside.py`):
  - 支持保存多个窗口类
  - 向后兼容单窗口类项目
  - 自动加载窗口类管理器数据

### 4. ✅ 窗口管理对话框
- **窗口类管理对话框** (`module/window_class_dialog.py`):
  - 新建窗口（Ctrl+N）
  - 删除窗口（Delete）
  - 复制窗口（Ctrl+C）
  - 重命名窗口
  - 自动重命名防止冲突

### 5. ✅ 菜单编辑器集成
- **在画布右键菜单中添加**:
  - "窗口类管理" 菜单项（快捷键 Ctrl+W）
  - 打开窗口类管理对话框

### 6. ✅ 快捷键支持
- **全局快捷键**:
  - `Ctrl+N`: 新建窗口类（在窗口管理对话框中）
  - `Ctrl+C`: 复制窗口类或控件（在树形框中）
  - `Delete`: 删除窗口类、控件或事件（在树形框中）
  - `Ctrl+W`: 打开窗口类管理对话框（在画布右键菜单中）

### 7. ✅ 树形框删除功能
- **支持删除**:
  - 窗口类（至少保留一个）
  - 控件
  - 事件绑定
- **自动刷新**: 删除后自动刷新树形结构

### 8. ✅ 复制功能
- **支持复制**:
  - 窗口类（自动重命名）
  - 控件（使用控件管理器的复制功能）
- **自动处理**: 复制后自动处理重名问题

### 9. ✅ 自动重命名逻辑
- **窗口类重命名**:
  - 新建时自动检查重名
  - 如果重名，自动添加序号（如：`Window_1`, `Window_2`）
- **功能文件重命名**:
  - 事件函数文件自动处理重名
  - 格式：`{窗口名}_function.py`, `{窗口名}_function_1.py` 等

### 10. ✅ 功能文件不重名
- **事件函数文件**:
  - 每个窗口类生成独立的事件函数文件
  - 自动检查已存在的文件名
  - 如果重名，自动添加序号

## 使用说明

### 创建新窗口类
1. 在画布上右键点击
2. 选择"窗口类管理"（或按 Ctrl+W）
3. 在对话框中输入窗口类名称
4. 点击"新建窗口"（或按 Ctrl+N）

### 删除窗口类
1. 在项目预览树形框中选中窗口类
2. 按 `Delete` 键
3. 确认删除

### 复制窗口类
1. 在项目预览树形框中选中窗口类
2. 按 `Ctrl+C`
3. 系统自动创建副本并重命名

### 复制控件
1. 在项目预览树形框中选中控件
2. 按 `Ctrl+C`
3. 控件被复制到当前窗口类

### 切换窗口类
1. 在窗口类管理对话框中
2. 双击窗口类名称
3. 或选中后点击确定

## 技术实现

### 窗口类管理器
```python
from module.window_class_manager import WindowClassManager, WindowClass

# 创建管理器
manager = WindowClassManager()

# 添加窗口类
window = manager.add_window_class("MyWindow")

# 获取当前窗口类
current = manager.get_current_window_class()

# 切换窗口类
manager.set_current_window_class("MyWindow")

# 复制窗口类
copy = manager.copy_window_class("MyWindow", "MyWindow_Copy")

# 删除窗口类
manager.remove_window_class("MyWindow")
```

### 项目保存格式
```json
{
  "version": "1.0",
  "window_class_manager": {
    "window_classes": {
      "Window1": { ... },
      "Window2": { ... }
    },
    "current_window_class_name": "Window1"
  }
}
```

## 文件清单

- `module/window_class_manager.py` - 窗口类管理器
- `module/window_class_dialog.py` - 窗口类管理对话框
- `module/project_manager_pyside.py` - 项目管理器（已更新支持多窗口类）
- `module/main_window_pyside.py` - 主窗口（已更新支持多窗口类）
- `module/design_canvas_pyside.py` - 设计画布（已添加窗口管理菜单）
- `module/event_function_generator_pyside.py` - 事件函数生成器（已更新支持重名处理）
- `module/code_generator_pyside.py` - 代码生成器（已更新支持唯一文件名）

## 注意事项

1. **至少保留一个窗口类**: 系统要求至少保留一个窗口类，无法删除最后一个
2. **窗口类名称规则**: 只能包含字母、数字和下划线，且不能以数字开头
3. **自动重命名**: 如果名称冲突，系统会自动添加序号
4. **功能文件命名**: 每个窗口类的事件函数文件会自动处理重名
5. **向后兼容**: 旧版本的项目文件仍然可以正常加载

