import { localize } from '../../../../nls.js';
import { Color } from '../../../../base/common/color.js';
import { registerColor, ifDefinedThenElse, lighten, darken, transparent } from '../colorUtils.js';
import { activeContrastBorder, focusBorder, iconForeground, contrastBorder, foreground } from './baseColors.js';
import { editorWidgetBackground, widgetShadow, editorFindMatchHighlight, editorFindMatchHighlightBorder, editorWidgetForeground } from './editorColors.js';

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
const listFocusBackground = registerColor('list.focusBackground', null, localize(1940, "List/Tree background color for the focused item when the list/tree is active. An active list/tree has keyboard focus, an inactive does not."));
const listFocusForeground = registerColor('list.focusForeground', null, localize(1941, "List/Tree foreground color for the focused item when the list/tree is active. An active list/tree has keyboard focus, an inactive does not."));
const listFocusOutline = registerColor('list.focusOutline', { dark: focusBorder, light: focusBorder, hcDark: activeContrastBorder, hcLight: activeContrastBorder }, localize(1942, "List/Tree outline color for the focused item when the list/tree is active. An active list/tree has keyboard focus, an inactive does not."));
const listFocusAndSelectionOutline = registerColor('list.focusAndSelectionOutline', null, localize(1943, "List/Tree outline color for the focused item when the list/tree is active and selected. An active list/tree has keyboard focus, an inactive does not."));
const listActiveSelectionBackground = registerColor('list.activeSelectionBackground', { dark: '#04395E', light: '#0060C0', hcDark: null, hcLight: Color.fromHex('#0F4A85').transparent(0.1) }, localize(1944, "List/Tree background color for the selected item when the list/tree is active. An active list/tree has keyboard focus, an inactive does not."));
const listActiveSelectionForeground = registerColor('list.activeSelectionForeground', { dark: Color.white, light: Color.white, hcDark: null, hcLight: null }, localize(1945, "List/Tree foreground color for the selected item when the list/tree is active. An active list/tree has keyboard focus, an inactive does not."));
const listActiveSelectionIconForeground = registerColor('list.activeSelectionIconForeground', null, localize(1946, "List/Tree icon foreground color for the selected item when the list/tree is active. An active list/tree has keyboard focus, an inactive does not."));
const listInactiveSelectionBackground = registerColor('list.inactiveSelectionBackground', { dark: '#37373D', light: '#E4E6F1', hcDark: null, hcLight: Color.fromHex('#0F4A85').transparent(0.1) }, localize(1947, "List/Tree background color for the selected item when the list/tree is inactive. An active list/tree has keyboard focus, an inactive does not."));
const listInactiveSelectionForeground = registerColor('list.inactiveSelectionForeground', null, localize(1948, "List/Tree foreground color for the selected item when the list/tree is inactive. An active list/tree has keyboard focus, an inactive does not."));
const listInactiveSelectionIconForeground = registerColor('list.inactiveSelectionIconForeground', null, localize(1949, "List/Tree icon foreground color for the selected item when the list/tree is inactive. An active list/tree has keyboard focus, an inactive does not."));
const listInactiveFocusBackground = registerColor('list.inactiveFocusBackground', null, localize(1950, "List/Tree background color for the focused item when the list/tree is inactive. An active list/tree has keyboard focus, an inactive does not."));
const listInactiveFocusOutline = registerColor('list.inactiveFocusOutline', null, localize(1951, "List/Tree outline color for the focused item when the list/tree is inactive. An active list/tree has keyboard focus, an inactive does not."));
const listHoverBackground = registerColor('list.hoverBackground', { dark: '#2A2D2E', light: '#F0F0F0', hcDark: Color.white.transparent(0.1), hcLight: Color.fromHex('#0F4A85').transparent(0.1) }, localize(1952, "List/Tree background when hovering over items using the mouse."));
const listHoverForeground = registerColor('list.hoverForeground', null, localize(1953, "List/Tree foreground when hovering over items using the mouse."));
const listDropOverBackground = registerColor('list.dropBackground', { dark: '#062F4A', light: '#D6EBFF', hcDark: null, hcLight: null }, localize(1954, "List/Tree drag and drop background when moving items over other items when using the mouse."));
const listDropBetweenBackground = registerColor('list.dropBetweenBackground', { dark: iconForeground, light: iconForeground, hcDark: null, hcLight: null }, localize(1955, "List/Tree drag and drop border color when moving items between items when using the mouse."));
const listHighlightForeground = registerColor('list.highlightForeground', { dark: '#2AAAFF', light: '#0066BF', hcDark: focusBorder, hcLight: focusBorder }, localize(1956, 'List/Tree foreground color of the match highlights when searching inside the list/tree.'));
const listFocusHighlightForeground = registerColor('list.focusHighlightForeground', { dark: listHighlightForeground, light: ifDefinedThenElse(listActiveSelectionBackground, listHighlightForeground, '#BBE7FF'), hcDark: listHighlightForeground, hcLight: listHighlightForeground }, localize(1957, 'List/Tree foreground color of the match highlights on actively focused items when searching inside the list/tree.'));
registerColor('list.invalidItemForeground', { dark: '#B89500', light: '#B89500', hcDark: '#B89500', hcLight: '#B5200D' }, localize(1958, 'List/Tree foreground color for invalid items, for example an unresolved root in explorer.'));
registerColor('list.errorForeground', { dark: '#F88070', light: '#B01011', hcDark: null, hcLight: null }, localize(1959, 'Foreground color of list items containing errors.'));
registerColor('list.warningForeground', { dark: '#CCA700', light: '#855F00', hcDark: null, hcLight: null }, localize(1960, 'Foreground color of list items containing warnings.'));
const listFilterWidgetBackground = registerColor('listFilterWidget.background', { light: darken(editorWidgetBackground, 0), dark: lighten(editorWidgetBackground, 0), hcDark: editorWidgetBackground, hcLight: editorWidgetBackground }, localize(1961, 'Background color of the type filter widget in lists and trees.'));
const listFilterWidgetOutline = registerColor('listFilterWidget.outline', { dark: Color.transparent, light: Color.transparent, hcDark: '#f38518', hcLight: '#007ACC' }, localize(1962, 'Outline color of the type filter widget in lists and trees.'));
const listFilterWidgetNoMatchesOutline = registerColor('listFilterWidget.noMatchesOutline', { dark: '#BE1100', light: '#BE1100', hcDark: contrastBorder, hcLight: contrastBorder }, localize(1963, 'Outline color of the type filter widget in lists and trees, when there are no matches.'));
const listFilterWidgetShadow = registerColor('listFilterWidget.shadow', widgetShadow, localize(1964, 'Shadow color of the type filter widget in lists and trees.'));
registerColor('list.filterMatchBackground', { dark: editorFindMatchHighlight, light: editorFindMatchHighlight, hcDark: null, hcLight: null }, localize(1965, 'Background color of the filtered match.'));
registerColor('list.filterMatchBorder', { dark: editorFindMatchHighlightBorder, light: editorFindMatchHighlightBorder, hcDark: contrastBorder, hcLight: activeContrastBorder }, localize(1966, 'Border color of the filtered match.'));
registerColor('list.deemphasizedForeground', { dark: '#8C8C8C', light: '#8E8E90', hcDark: '#A7A8A9', hcLight: '#666666' }, localize(1967, "List/Tree foreground color for items that are deemphasized."));
// ------ tree
const treeIndentGuidesStroke = registerColor('tree.indentGuidesStroke', { dark: '#585858', light: '#a9a9a9', hcDark: '#a9a9a9', hcLight: '#a5a5a5' }, localize(1968, "Tree stroke color for the indentation guides."));
const treeInactiveIndentGuidesStroke = registerColor('tree.inactiveIndentGuidesStroke', transparent(treeIndentGuidesStroke, 0.4), localize(1969, "Tree stroke color for the indentation guides that are not active."));
// ------ table
const tableColumnsBorder = registerColor('tree.tableColumnsBorder', { dark: '#CCCCCC20', light: '#61616120', hcDark: null, hcLight: null }, localize(1970, "Table border color between columns."));
const tableOddRowsBackgroundColor = registerColor('tree.tableOddRowsBackground', { dark: transparent(foreground, 0.04), light: transparent(foreground, 0.04), hcDark: null, hcLight: null }, localize(1971, "Background color for odd table rows."));
// ------ action list
registerColor('editorActionList.background', editorWidgetBackground, localize(1972, "Action List background color."));
const editorActionListForeground = registerColor('editorActionList.foreground', editorWidgetForeground, localize(1973, "Action List foreground color."));
registerColor('editorActionList.focusForeground', listActiveSelectionForeground, localize(1974, "Action List foreground color for the focused item."));
registerColor('editorActionList.focusBackground', listActiveSelectionBackground, localize(1975, "Action List background color for the focused item."));

export { editorActionListForeground, listActiveSelectionBackground, listActiveSelectionForeground, listActiveSelectionIconForeground, listDropBetweenBackground, listDropOverBackground, listFilterWidgetBackground, listFilterWidgetNoMatchesOutline, listFilterWidgetOutline, listFilterWidgetShadow, listFocusAndSelectionOutline, listFocusBackground, listFocusForeground, listFocusHighlightForeground, listFocusOutline, listHighlightForeground, listHoverBackground, listHoverForeground, listInactiveFocusBackground, listInactiveFocusOutline, listInactiveSelectionBackground, listInactiveSelectionForeground, listInactiveSelectionIconForeground, tableColumnsBorder, tableOddRowsBackgroundColor, treeInactiveIndentGuidesStroke, treeIndentGuidesStroke };
