"""
版本信息模块
定义应用程序的版本号、作者、版权等常量信息
"""

# 应用程序名称：显示在关于对话框和窗口标题中
APP_NAME = "Python Visual Studio Code"

# 应用程序版本号：遵循语义化版本规范（主版本.次版本.修订版本）
APP_VERSION = "3.4.0"

# 应用程序作者信息：作者的联系方式
APP_AUTHOR = "QQ304888898 and 642599945"

# 应用程序版权信息：版权声明
APP_COPYRIGHT = "©QQ304888898 and 642599945"

# 项目架构版本号：用于项目文件的兼容性检查，当项目文件格式变更时递增此版本号
PROJECT_SCHEMA_VERSION = "21.0"


def about_text():
    """
    生成关于对话框的文本内容
    
    Returns:
        str: 格式化的关于信息文本，包含应用程序名称、版本、作者和版权信息
    """
    # 返回格式化的关于信息文本，使用换行符分隔各部分信息
    return f"基于PySide6的{APP_NAME}\n版本: {APP_VERSION}\n作者: {APP_AUTHOR}\n{APP_COPYRIGHT}"
