#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
控件库初始化模块
导入并注册所有控件到全局控件注册表
在模块导入时自动执行，确保所有控件在应用启动时可用
"""

# ========== 导入所有控件库的注册函数 ==========
# 从基础控件模块导入注册函数
from .basic_controls import register_basic_controls
# 从输入控件模块导入注册函数
from .input_controls import register_input_controls
# 从选择控件模块导入注册函数
from .selection_controls import register_selection_controls
# 从显示控件模块导入注册函数
from .display_controls import register_display_controls
# 从布局控件模块导入注册函数
from .layout_controls import register_layout_controls
# 从对话框控件模块导入注册函数
from .dialog_controls import register_dialog_controls
# 从高级控件模块导入注册函数
from .advanced_controls import register_advanced_controls

# 导入控件注册表（全局单例）
from .control_base import control_registry


def initialize_all_controls():
    """
    初始化并注册所有控件到全局注册表
    按类别依次注册所有控件，使其在应用中使用
    
    Returns:
        control_registry: 控件注册表对象，包含所有已注册的控件
    """
    # 注册基础控件（Label、Button等）
    register_basic_controls()
    
    # 注册输入控件（LineEdit、TextEdit、SpinBox等）
    register_input_controls()
    
    # 注册选择控件（CheckBox、RadioButton、ComboBox等）
    register_selection_controls()
    
    # 注册显示控件（ProgressBar、LCDNumber等）
    register_display_controls()
    
    # 注册布局控件（Frame、GroupBox、TabWidget等）
    register_layout_controls()
    
    # 注册对话框控件（MessageBox、FileDialog等）
    register_dialog_controls()
    
    # 注册高级控件（ListWidget、TableWidget、TreeWidget等）
    register_advanced_controls()
    
    # 返回控件注册表对象
    return control_registry


# ========== 自动初始化所有控件 ==========
# 在模块导入时自动执行初始化，确保所有控件在应用启动时已注册
initialize_all_controls()