# Python Visual Studio Code

<div align="center">

![Version](https://img.shields.io/badge/version-3.4.0-blue.svg)
![Python](https://img.shields.io/badge/python-3.7+-green.svg)
![PySide6](https://img.shields.io/badge/PySide6-6.0.0+-orange.svg)
![License](https://img.shields.io/badge/license-MIT-yellow.svg)

**基于 PySide6 的可视化编程工具，类似易语言的图形化编程环境**

[功能特性](#功能特性) • [快速开始](#快速开始) • [使用指南](#使用指南) • [项目结构](#项目结构) • [开发说明](#开发说明)

</div>

---

## 📖 项目简介

Python Visual Studio Code 是一个功能强大的可视化编程工具，允许用户通过拖拽控件的方式设计图形界面，并自动生成 Python 代码。该工具基于 PySide6（Qt for Python）开发，提供了类似易语言的图形化编程体验，让开发者能够快速构建桌面应用程序。

### 核心特点

- 🎨 **可视化设计**：通过拖拽控件快速设计界面
- 🔄 **双向转换**：支持设计转代码和代码转设计
- 🤖 **AI 辅助**：集成 AI 对话功能，智能生成代码
- 🎯 **多窗口支持**：支持创建和管理多个窗口类
- 🎨 **主题系统**：内置多种主题，支持自定义
- 📝 **代码编辑**：集成 Monaco Editor，提供专业的代码编辑体验
- 🔍 **实时预览**：实时预览界面设计效果

---

## ✨ 功能特性

### 1. 可视化界面设计

- **控件调色板**：提供丰富的控件库，包括：
  - 基础控件：标签、按钮、输入框、框架等
  - 布局控件：水平布局、垂直布局、网格布局、表单布局等
  - 选择控件：复选框、单选按钮、下拉框、列表、树形控件、表格等
  - 输入控件：文本编辑、数字输入、滑块、日期时间选择等
  - 显示控件：图片、进度条、LCD 数字、日历、图形视图等
  - 高级控件：表格、树形、日历、停靠窗口、MDI 区域等
  - 对话框控件：消息框、输入对话框、颜色对话框、文件对话框等

- **设计画布**：直观的可视化编辑界面
  - 拖拽添加控件
  - 选择、移动、调整大小
  - 对齐和分布工具
  - 网格对齐辅助

- **属性编辑器**：实时编辑控件属性
  - 文本、颜色、字体、大小等属性
  - 样式表（QSS）编辑
  - 事件绑定

### 2. 代码生成与解析

- **代码生成器**：将可视化设计转换为 Python 代码
  - 自动生成窗口类代码
  - 生成控件创建和属性设置代码
  - 生成事件处理函数框架
  - 支持多窗口类代码生成

- **代码解析器**：将 Python 代码解析为控件设计
  - 自动识别控件类型
  - 提取控件属性
  - 恢复布局结构
  - 解析事件绑定

### 3. AI 辅助编程

- **AI 对话功能**：集成 GLM-4.5-Flash 和 DeepSeek API
  - 智能代码生成
  - 代码优化建议
  - 问题解答
  - 支持多种提示词模板

- **API 密钥管理**：安全的 API 密钥存储和管理

### 4. 项目管理

- **项目保存/加载**：完整的项目文件管理
  - 保存所有窗口类和控件信息
  - 保存事件处理代码
  - 保存项目配置
  - 支持项目版本管理

- **多窗口类管理**：
  - 创建多个独立的窗口类
  - 窗口类复制、重命名、删除
  - 窗口类切换
  - 自动处理重名问题

### 5. 代码编辑

- **Monaco Editor 集成**：
  - 语法高亮
  - 代码补全（Python 关键字、PySide6 类、控件类型）
  - 悬停提示
  - 代码折叠
  - 多光标编辑
  - 查找替换

### 6. 预览功能

- **实时预览**：在设计过程中实时预览界面效果
- **内置预览窗口**：无标题栏的预览窗口
- **预览树形结构**：可视化显示窗口和控件层次

### 7. 主题系统

- **内置主题**：
  - 白色主题（white）
  - 黑色主题（black）
  - 黑蓝主题（blackblue）
  - 黑粉主题（blackpink）
  - 蓝白主题（bluewhite）
  - 绿色主题（green）
  - 红色主题（red）

- **主题切换**：一键切换主题，实时生效
- **统一字体管理**：支持自定义字体设置

### 8. 撤销重做

- **操作历史管理**：完整的撤销/重做功能
  - 控件操作撤销重做
  - 属性修改撤销重做
  - 窗口操作撤销重做
  - 代码编辑撤销重做

### 9. 文件管理

- **文件树形视图**：可视化文件管理
- **文件操作**：创建、删除、重命名、复制、移动文件
- **文件类型识别**：自动识别文本文件
- **文件中文名称**：支持文件中文名称显示

### 10. 其他功能

- **菜单编辑器**：可视化编辑菜单栏
- **事件管理器**：管理控件事件绑定
- **设置对话框**：应用程序设置管理
- **无标题栏窗口**：自定义标题栏设计
- **FnPy 库管理**：函数库管理功能

---

## 🚀 快速开始

### 环境要求

- Python 3.7 或更高版本
- PySide6 6.0.0 或更高版本
- PySide6-WebEngine 6.0.0 或更高版本（用于 Monaco Editor）

### 安装步骤

1. **克隆或下载项目**

```bash
git clone <repository-url>
cd 21
```

2. **安装依赖**

```bash
pip install -r 资源文件/requirements_pyside.txt
```

或者手动安装：

```bash
pip install PySide6>=6.0.0
pip install PySide6-WebEngine>=6.0.0
```

3. **运行程序**

```bash
python visual_programming_main_pyside.py
```

### 首次运行

1. 程序启动后，会自动创建一个默认窗口类
2. 从左侧控件调色板拖拽控件到设计画布
3. 在右侧属性编辑器中编辑控件属性
4. 使用菜单栏或工具栏进行项目操作

---

## 📚 使用指南

### 创建新项目

1. 点击菜单栏 **文件 → 新建项目**（或按 `Ctrl+N`）
2. 选择项目保存位置
3. 输入项目名称
4. 点击确定

### 添加控件

1. 在左侧控件调色板中选择控件类型
2. 拖拽控件到设计画布上
3. 释放鼠标完成添加

### 编辑控件属性

1. 在设计画布上选择控件
2. 在右侧属性编辑器中修改属性
3. 修改会实时反映在设计画布上

### 绑定事件

1. 选择控件
2. 在属性编辑器的"事件"选项卡中选择事件
3. 输入事件处理函数名称
4. 在代码编辑器中编写事件处理代码

### 生成代码

1. 点击菜单栏 **生成 → 生成代码**（或按 `F5`）
2. 代码会在代码对话框中显示
3. 可以复制代码或保存到文件

### 预览界面

1. 点击菜单栏 **预览 → 预览窗口**（或按 `F6`）
2. 预览窗口会显示当前设计的界面效果

### 保存项目

1. 点击菜单栏 **文件 → 保存项目**（或按 `Ctrl+S`）
2. 选择保存位置
3. 项目会保存为 JSON 格式文件

### 加载项目

1. 点击菜单栏 **文件 → 打开项目**（或按 `Ctrl+O`）
2. 选择项目文件
3. 项目会加载到设计画布

### 多窗口类管理

1. 在设计画布上右键点击
2. 选择 **窗口类管理**（或按 `Ctrl+W`）
3. 在对话框中可以：
   - 新建窗口类（`Ctrl+N`）
   - 删除窗口类（`Delete`）
   - 复制窗口类（`Ctrl+C`）
   - 重命名窗口类
   - 切换当前窗口类

### AI 辅助编程

1. 点击右侧 **AI 对话** 标签页
2. 在设置中配置 API 密钥（GLM-4.5-Flash 或 DeepSeek）
3. 输入问题或需求
4. AI 会生成代码或提供建议

### 切换主题

1. 点击菜单栏 **视图 → 主题**
2. 选择主题
3. 主题会立即应用

---

## 📁 项目结构

```
21/
├── visual_programming_main_pyside.py  # 主程序入口
├── clear_api_key.py                   # API 密钥清理工具
│
├── module/                             # 核心模块目录
│   ├── main_window_pyside.py          # 主窗口类
│   ├── main_window_ui.py              # 主窗口 UI 管理器
│   ├── design_canvas_pyside.py        # 设计画布
│   ├── control_pyside.py              # 控件管理器
│   ├── control_library_pyside.py      # 控件库
│   ├── property_editor_pyside.py      # 属性编辑器
│   ├── code_generator_pyside.py       # 代码生成器
│   ├── code_parser_pyside.py          # 代码解析器
│   ├── code_dialog_pyside.py          # 代码对话框
│   ├── project_manager_pyside.py      # 项目管理器
│   ├── undo_redo_manager_pyside.py    # 撤销重做管理器
│   ├── preview_window_pyside.py       # 预览窗口
│   ├── ai_chat_module.py              # AI 对话模块
│   ├── monaco_editor_widget.py        # Monaco Editor 组件
│   ├── event_manager_pyside.py        # 事件管理器
│   ├── event_function_generator_pyside.py  # 事件函数生成器
│   ├── window_class_manager.py        # 窗口类管理器
│   ├── window_class_dialog.py         # 窗口类管理对话框
│   ├── menu_editor_pyside.py          # 菜单编辑器
│   ├── settings_dialog.py             # 设置对话框
│   ├── theme_manager.py               # 主题管理器
│   ├── theme_font_manager.py          # 主题字体管理器
│   ├── file_manager.py                # 文件管理器
│   ├── frameless_window.py            # 无标题栏窗口基类
│   ├── version.py                     # 版本信息
│   │
│   └── controls/                      # 控件实现目录
│       ├── basic_controls.py          # 基础控件
│       ├── layout_controls.py         # 布局控件
│       ├── selection_controls.py     # 选择控件
│       ├── input_controls.py          # 输入控件
│       ├── display_controls.py        # 显示控件
│       ├── advanced_controls.py       # 高级控件
│       └── dialog_controls.py         # 对话框控件
│
├── lib/                                # 库文件目录
│   ├── control_config_loader.py       # 控件配置加载器
│   ├── control_config_exporter.py     # 控件配置导出器
│   ├── hierarchical_config_loader.py  # 分层配置加载器
│   ├── hierarchical_config_exporter.py # 分层配置导出器
│   ├── component_config_loader_unified.py  # 统一组件配置加载器
│   ├── fnpy_library_manager.py        # FnPy 库管理器
│   ├── categories.json                # 控件分类配置
│   ├── code_templates.json            # 代码模板配置
│   │
│   ├── control_configs/               # 控件配置文件目录
│   │   ├── Button.json
│   │   ├── Label.json
│   │   ├── LineEdit.json
│   │   └── ...                        # 其他控件配置
│   │
│   ├── component_configs/             # 组件配置文件目录
│   │   ├── QPushButton.json
│   │   ├── QLabel.json
│   │   ├── QLineEdit.json
│   │   └── README.md
│   │
│   └── fnpy/                          # FnPy 函数库
│       ├── window_utils.fnpy
│       └── window_utils.py
│
├── ui/                                 # UI 资源目录
│   ├── color/                         # 主题样式文件
│   │   ├── white.qss
│   │   ├── black.qss
│   │   ├── blackblue.qss
│   │   ├── blackpink.qss
│   │   ├── bluewhite.qss
│   │   ├── green.qss
│   │   └── red.qss
│   │
│   ├── icon/                          # 图标资源
│   │   ├── black/                     # 黑色主题图标
│   │   ├── blue/                      # 蓝色主题图标
│   │   ├── green/                     # 绿色主题图标
│   │   ├── pink/                      # 粉色主题图标
│   │   ├── red/                       # 红色主题图标
│   │   └── white/                     # 白色主题图标
│   │
│   ├── monaco_editor_local/           # Monaco Editor 本地文件
│   └── monaco_editor_template.html    # Monaco Editor 模板
│
├── Python/                             # Python 相关文件
│   ├── app_secrets.json               # 应用密钥配置
│   └── 这里放完整的Python环境.txt
│
└── 资源文件/                           # 资源文件目录
    ├── doc/                           # 文档目录
    │   ├── README.md                  # 控件配置系统说明
    │   ├── IMPLEMENTATION_SUMMARY.md   # 实施总结
    │   ├── MULTI_WINDOW_FEATURES.md    # 多窗口功能说明
    │   ├── HIERARCHICAL_CONFIG_README.md  # 分层配置说明
    │   ├── UI_OPTIMIZATION_PLAN.md     # UI 优化计划
    │   ├── PREVIEW_TREE_OPTIMIZATION.md  # 预览树优化
    │   └── OPTIMIZATION_SUMMARY.md     # 优化总结
    │
    ├── requirements_pyside.txt         # Python 依赖列表
    └── kid.ico                         # 应用程序图标
```

---

## 🛠️ 开发说明

### 架构设计

项目采用模块化设计，主要模块包括：

1. **主窗口模块**（`main_window_pyside.py`）：应用程序主窗口，协调各个组件
2. **控件管理模块**（`control_pyside.py`）：管理所有控件的创建、删除、选择等操作
3. **设计画布模块**（`design_canvas_pyside.py`）：可视化编辑界面
4. **代码生成模块**（`code_generator_pyside.py`）：将设计转换为代码
5. **代码解析模块**（`code_parser_pyside.py`）：将代码解析为设计
6. **项目管理模块**（`project_manager_pyside.py`）：项目保存和加载
7. **撤销重做模块**（`undo_redo_manager_pyside.py`）：操作历史管理

### 控件系统

控件系统采用配置驱动的方式：

- **控件定义**：在 `lib/control_configs/` 目录下的 JSON 文件中定义
- **控件实现**：在 `module/controls/` 目录下的 Python 文件中实现
- **动态加载**：程序启动时从配置文件动态加载控件信息

### 添加新控件

1. **创建控件配置文件**（`lib/control_configs/YourControl.json`）：

```json
{
  "name": "YourControl",
  "display_name": "你的控件",
  "category": "基础",
  "description": "控件描述",
  "class_name": "QWidget",
  "default_properties": {
    "text": "默认文本"
  },
  "default_size": [100, 30],
  "resizable": true,
  "can_contain": false,
  "events": ["clicked"]
}
```

2. **实现控件类**（`module/controls/basic_controls.py` 或新建文件）：

```python
from module.control_base import BaseControl

class YourControl(BaseControl):
    def __init__(self, parent=None):
        super().__init__(parent)
        # 控件初始化代码
```

3. **注册控件**：在 `module/control_library_pyside.py` 中注册控件

### 配置文件系统

项目使用 JSON 配置文件管理控件和组件信息：

- **控件配置**：`lib/control_configs/*.json`
- **组件配置**：`lib/component_configs/*.json`
- **分类配置**：`lib/categories.json`
- **代码模板**：`lib/code_templates.json`

### 主题系统

主题系统使用 QSS（Qt Style Sheets）实现：

- 主题文件位于 `ui/color/` 目录
- 支持动态切换主题
- 主题文件包含完整的样式定义

### 代码生成

代码生成器支持：

- 窗口类代码生成
- 控件创建代码生成
- 属性设置代码生成
- 事件处理函数生成
- 多窗口类代码生成

### 代码解析

代码解析器支持：

- Python 代码解析
- 控件识别
- 属性提取
- 布局恢复
- 事件绑定解析

---

## ⌨️ 快捷键

### 文件操作

- `Ctrl+N`：新建项目
- `Ctrl+O`：打开项目
- `Ctrl+S`：保存项目
- `Ctrl+Shift+S`：另存为

### 编辑操作

- `Ctrl+Z`：撤销
- `Ctrl+Y`：重做
- `Ctrl+C`：复制
- `Ctrl+V`：粘贴
- `Ctrl+X`：剪切
- `Delete`：删除

### 代码生成

- `F5`：生成代码
- `F6`：预览窗口

### 窗口管理

- `Ctrl+W`：打开窗口类管理对话框
- `Ctrl+N`（在窗口管理对话框中）：新建窗口类
- `Ctrl+C`（在树形框中）：复制窗口类或控件
- `Delete`（在树形框中）：删除窗口类、控件或事件

---

## 🔧 配置说明

### API 密钥配置

AI 功能需要配置 API 密钥：

1. 在 `Python/app_secrets.json` 中配置（已加密）
2. 或在程序设置中配置

### 项目文件格式

项目文件使用 JSON 格式：

```json
{
  "version": "21.0",
  "window_class_manager": {
    "window_classes": {
      "Window1": {
        "controls": [...],
        "properties": {...}
      }
    },
    "current_window_class_name": "Window1"
  },
  "function_files": {...}
}
```

---

## 📝 版本信息

- **当前版本**：3.4.0
- **项目架构版本**：21.0
- **Python 要求**：3.7+
- **PySide6 要求**：6.0.0+

### 版本历史

- **v3.4.0**：当前版本
  - 多窗口类支持
  - AI 对话功能
  - Monaco Editor 集成
  - 主题系统优化
  - 无标题栏窗口
  - 文件管理功能

---

## 👤 作者信息

- **作者**：QQ304888898 and 642599945
- **版权**：©QQ304888898 and 642599945

---

## 📄 许可证

本项目采用 MIT 许可证。

---

## 🤝 贡献

欢迎提交 Issue 和 Pull Request！

---

## 📞 联系方式

如有问题或建议，请通过以下方式联系：

- QQ：304888898 and 642599945

---

## 🙏 致谢

感谢以下开源项目：

- [PySide6](https://www.qt.io/qt-for-python) - Qt for Python
- [Monaco Editor](https://microsoft.github.io/monaco-editor/) - 代码编辑器

---

## 📚 相关文档

- [控件配置系统说明](资源文件/doc/README.md)
- [多窗口功能说明](资源文件/doc/MULTI_WINDOW_FEATURES.md)
- [实施总结](资源文件/doc/IMPLEMENTATION_SUMMARY.md)
- [UI 优化计划](资源文件/doc/UI_OPTIMIZATION_PLAN.md)

---

<div align="center">

**⭐ 如果这个项目对你有帮助，请给个 Star！⭐**

Made with ❤️ by QQ304888898 and 642599945

</div>

