/*
Navicat MySQL Data Transfer

Source Server         : hospital
Source Server Version : 50726
Source Host           : localhost:3306
Source Database       : hopsital1

Target Server Type    : MYSQL
Target Server Version : 50726
File Encoding         : 65001

Date: 2020-05-10 23:10:53
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for 01patients
-- ----------------------------
DROP TABLE IF EXISTS `01patients`;
CREATE TABLE `01patients` (
  `patientID` int(30) NOT NULL AUTO_INCREMENT,
  `medicalRecordNumber` int(30) DEFAULT NULL,
  `patientIDNumber` char(19) CHARACTER SET utf8 DEFAULT NULL,
  `patientName` text CHARACTER SET utf8,
  `patientSex` char(10) CHARACTER SET utf8 DEFAULT NULL,
  `patientBirthday` date DEFAULT NULL,
  `patientAge` int(10) DEFAULT NULL,
  `patientAgeType` text CHARACTER SET utf8,
  `patientAddress` text CHARACTER SET utf8,
  `deletedMark` char(10) CHARACTER SET utf8 DEFAULT NULL,
  PRIMARY KEY (`patientID`),
  UNIQUE KEY `medicalRecordNumber` (`medicalRecordNumber`)
) ENGINE=MyISAM AUTO_INCREMENT=314 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of 01patients
-- ----------------------------
INSERT INTO `01patients` VALUES ('3', '600600', '110101199003073335', '李白', '71', '1900-01-02', '18', '岁', '北京', '1');
INSERT INTO `01patients` VALUES ('4', '600601', '110101199003073634', '杜甫', '71', '1900-01-02', '17', '岁', '雄安', '1');
INSERT INTO `01patients` VALUES ('5', '600602', '110101199003075496', '李商隐', '71', '1900-01-02', '11', '岁', '哈尔滨', '1');
INSERT INTO `01patients` VALUES ('6', '600603', '110101199003072519', '杜牧', '71', '1900-01-02', '11', '岁', '大连', '1');
INSERT INTO `01patients` VALUES ('7', '600604', '11010119900307643X', '李清照', '72', '1900-01-02', '56', '岁', '青岛', '1');
INSERT INTO `01patients` VALUES ('8', '600605', '110101199003078937', '李贺', '71', '1900-01-02', '67', '岁', '长沙', '1');
INSERT INTO `01patients` VALUES ('9', '600606', '110101199003079577', '卢照邻', '71', '1900-01-02', '33', '岁', '天津', '1');
INSERT INTO `01patients` VALUES ('26', '600607', '110101199003072770', '陆游', '71', '1900-01-02', '33', '岁', '上海', '1');
INSERT INTO `01patients` VALUES ('27', '600608', '11010119900307045X', '屈原', '71', '1900-01-02', '72', '岁', '广州', '1');
INSERT INTO `01patients` VALUES ('28', '600609', '210102199208051076', '白居易', '71', '1900-01-02', '23', '岁', '台北', '1');
INSERT INTO `01patients` VALUES ('29', '600610', '210102199208050938', '王安石', '71', '1900-01-02', '11', '岁', '香港', '1');
INSERT INTO `01patients` VALUES ('30', '600611', '210102199208051834', '李煜', '71', '1900-01-02', '33', '岁', '杭州', '1');
INSERT INTO `01patients` VALUES ('31', '600612', '210102199208058972', '孟浩然', '71', '1900-01-02', '23', '岁', '南京', '1');
INSERT INTO `01patients` VALUES ('32', '600613', '210102199208055392', '王勃', '71', '1900-01-02', '22', '岁', '武汉', '1');
INSERT INTO `01patients` VALUES ('33', '600614', '210102199208056053', '范仲淹', '71', '1900-01-02', '22', '岁', '成都', '1');
INSERT INTO `01patients` VALUES ('34', '600615', '210102199208059377', '陶渊明', '71', '1900-01-02', '33', '岁', '深圳', '1');
INSERT INTO `01patients` VALUES ('36', '600617', '210102199208059916', '苏洵', '71', '1900-01-02', '8', '岁', '重庆', '1');
INSERT INTO `01patients` VALUES ('37', '600618', '210102199208058999', '苏辙', '71', '1900-01-02', '22', '岁', '厦门', '1');
INSERT INTO `01patients` VALUES ('39', '600619', '21010219920805025X', '苏轼', '71', '2000-01-01', '19', '岁', '沈阳', '1');
INSERT INTO `01patients` VALUES ('121', '600622', '210102199208057253', '辛弃疾', '71', '1900-01-02', '21', '岁', '沈阳', '1');
INSERT INTO `01patients` VALUES ('122', '600623', '320114198702156937', '刘禹锡', '71', '1900-01-02', '21', '岁', '南京', '1');
INSERT INTO `01patients` VALUES ('123', '600624', '320114198702158713', '王维', '71', '1900-01-02', '21', '岁', '南京', '1');
INSERT INTO `01patients` VALUES ('124', '600625', '32011419870215929X', '李商隐', '71', '1900-01-02', '21', '岁', '南京', '1');
INSERT INTO `01patients` VALUES ('125', '600626', '320114198702159134', '纳兰性德', '71', '1900-01-02', '21', '岁', '南京', '1');
INSERT INTO `01patients` VALUES ('308', '600717', '310203199902156673', '王晓', '男', '1999-02-15', '20', '岁', '上海市浦东区', '1');
INSERT INTO `01patients` VALUES ('127', '600628', '320114198702158932', '元稹', '71', '1900-01-02', '21', '岁', '南京', '1');
INSERT INTO `01patients` VALUES ('128', '600629', '320114198702157593', '柳宗元', '71', '1900-01-02', '21', '岁', '南京', '1');
INSERT INTO `01patients` VALUES ('129', '600630', '320114198702159775', '岑参', '71', '1900-01-02', '21', '岁', '南京', '1');
INSERT INTO `01patients` VALUES ('130', '600631', '320114198702159097', '韩愈', '71', '1900-01-02', '21', '岁', '南京', '1');
INSERT INTO `01patients` VALUES ('131', '600632', '320114198702156056', '欧阳修', '71', '1900-01-02', '21', '岁', '南京', '1');
INSERT INTO `01patients` VALUES ('132', '600633', '320114198702156275', '齐己', '71', '1900-01-02', '21', '岁', '南京', '1');
INSERT INTO `01patients` VALUES ('133', '600634', '320114198702156996', '贾岛', '71', '1900-01-02', '21', '岁', '南京', '1');
INSERT INTO `01patients` VALUES ('134', '600635', '320114198702158836', '韦应物', '71', '1900-01-02', '21', '岁', '南京', '1');
INSERT INTO `01patients` VALUES ('135', '600636', '320114198702157497', '曹操', '71', '1900-01-02', '21', '岁', '南京', '1');
INSERT INTO `01patients` VALUES ('136', '600637', '32011419870215945X', '温庭筠', '71', '1900-01-02', '21', '岁', '南京', '1');
INSERT INTO `01patients` VALUES ('137', '600638', '440304199210189484', '柳永', '71', '1900-01-02', '21', '岁', '深圳', '1');
INSERT INTO `01patients` VALUES ('138', '600639', '440304199210187462', '刘长卿', '71', '1900-01-02', '21', '岁', '深圳', '1');
INSERT INTO `01patients` VALUES ('139', '600640', '440304199210188967', '曹植', '71', '1900-01-02', '21', '岁', '深圳', '1');
INSERT INTO `01patients` VALUES ('140', '600641', '440304199210188326', '王昌龄', '71', '1900-01-02', '21', '岁', '深圳', '1');
INSERT INTO `01patients` VALUES ('141', '600642', '440304199210186267', '张籍', '71', '1900-01-02', '21', '岁', '深圳', '1');
INSERT INTO `01patients` VALUES ('142', '600643', '440304199210186523', '孟郊', '71', '1900-01-02', '21', '岁', '深圳', '1');
INSERT INTO `01patients` VALUES ('143', '600644', '440304199210186347', '皎然', '71', '1900-01-02', '21', '岁', '深圳', '1');
INSERT INTO `01patients` VALUES ('144', '600645', '440304199210188182', '贯休', '71', '1900-01-02', '21', '岁', '深圳', '1');
INSERT INTO `01patients` VALUES ('145', '600646', '440304199210189409', '许浑', '71', '1900-01-02', '21', '岁', '深圳', '1');
INSERT INTO `01patients` VALUES ('146', '600647', '440304199210189222', '罗隐', '71', '1900-01-02', '21', '岁', '深圳', '1');
INSERT INTO `01patients` VALUES ('147', '600648', '440304199210186269', '杨万里', '71', '1900-01-02', '21', '岁', '深圳', '1');
INSERT INTO `01patients` VALUES ('148', '600649', '440304199210188203', '陆龟蒙', '71', '1900-01-02', '21', '岁', '深圳', '1');
INSERT INTO `01patients` VALUES ('149', '600650', '440304199210186689', '张祜', '71', '1900-01-02', '21', '岁', '深圳', '1');
INSERT INTO `01patients` VALUES ('150', '600651', '44030419921018830X', '王建', '71', '1900-01-02', '21', '岁', '深圳', '1');
INSERT INTO `01patients` VALUES ('151', '600652', '440304199210188924', '韦庄', '71', '1900-01-02', '21', '岁', '深圳', '1');
INSERT INTO `01patients` VALUES ('152', '600653', '430111197906137887', '诸葛亮', '71', '1900-01-02', '21', '岁', '长沙', '1');
INSERT INTO `01patients` VALUES ('153', '600654', '430111197906136681', '姚合', '71', '1900-01-02', '21', '岁', '长沙', '1');
INSERT INTO `01patients` VALUES ('154', '600655', '430111197906139728', '晏殊', '71', '1900-01-02', '21', '岁', '长沙', '1');
INSERT INTO `01patients` VALUES ('155', '600656', '430111197906139161', '卢纶', '71', '1900-01-02', '21', '岁', '长沙', '1');
INSERT INTO `01patients` VALUES ('156', '600657', '430111197906138249', '杜荀鹤', '71', '1900-01-02', '21', '岁', '长沙', '1');
INSERT INTO `01patients` VALUES ('157', '600658', '430111197906137182', '岳飞', '71', '1900-01-02', '21', '岁', '长沙', '1');
INSERT INTO `01patients` VALUES ('158', '600659', '430111197906139727', '周邦彦', '71', '1900-01-02', '21', '岁', '长沙', '1');
INSERT INTO `01patients` VALUES ('159', '600660', '430111197906138388', '晏几道', '71', '1900-01-02', '21', '岁', '长沙', '1');
INSERT INTO `01patients` VALUES ('160', '600661', '43011119790613730X', '钱起', '71', '1900-01-02', '21', '岁', '长沙', '1');
INSERT INTO `01patients` VALUES ('161', '600662', '430111197906139444', '韩偓', '71', '1900-01-02', '21', '岁', '长沙', '1');
INSERT INTO `01patients` VALUES ('162', '600663', '430111197906137983', '皮日休', '71', '1900-01-02', '21', '岁', '长沙', '1');
INSERT INTO `01patients` VALUES ('163', '600664', '430111197906137203', '秦观', '71', '1900-01-02', '21', '岁', '长沙', '1');
INSERT INTO `01patients` VALUES ('164', '600665', '430111197906138126', '吴文英', '71', '1900-01-02', '21', '岁', '长沙', '1');
INSERT INTO `01patients` VALUES ('165', '600666', '430111197906136665', '朱熹', '71', '1900-01-02', '21', '岁', '长沙', '1');
INSERT INTO `01patients` VALUES ('166', '600667', '430111197906137326', '高适', '71', '1900-01-02', '21', '岁', '长沙', '1');
INSERT INTO `01patients` VALUES ('167', '600668', '35021119790613928X', '方干', '71', '1900-01-02', '21', '岁', '厦门', '1');
INSERT INTO `01patients` VALUES ('168', '600669', '350211197906138180', '马致远', '71', '1900-01-02', '21', '岁', '厦门', '1');
INSERT INTO `01patients` VALUES ('169', '600670', '350211197906138287', '李峤', '71', '1900-01-02', '21', '岁', '厦门', '1');
INSERT INTO `01patients` VALUES ('170', '600671', '350211197906136046', '权德舆', '71', '1900-01-02', '21', '岁', '厦门', '1');
INSERT INTO `01patients` VALUES ('171', '600672', '350211197906136409', '皇甫冉', '71', '1900-01-02', '21', '岁', '厦门', '1');
INSERT INTO `01patients` VALUES ('172', '600673', '350211197906136943', '左丘明', '71', '1900-01-02', '21', '岁', '厦门', '1');
INSERT INTO `01patients` VALUES ('173', '600674', '350211197906138922', '刘辰翁', '71', '1900-01-02', '21', '岁', '厦门', '1');
INSERT INTO `01patients` VALUES ('174', '600675', '350211197906136986', '郑谷', '71', '1900-01-02', '21', '岁', '厦门', '1');
INSERT INTO `01patients` VALUES ('175', '600676', '350211197906139984', '黄庭坚', '71', '1900-01-02', '21', '岁', '厦门', '1');
INSERT INTO `01patients` VALUES ('176', '600677', '350211197906138826', '贺铸', '71', '1900-01-02', '21', '岁', '厦门', '1');
INSERT INTO `01patients` VALUES ('177', '600678', '350211197906138041', '赵长卿', '71', '1900-01-02', '21', '岁', '厦门', '1');
INSERT INTO `01patients` VALUES ('178', '600679', '350211197906137882', '张九龄', '71', '1900-01-02', '21', '岁', '厦门', '1');
INSERT INTO `01patients` VALUES ('179', '600680', '350211197906138105', '卓文君', '71', '1900-01-02', '21', '岁', '厦门', '1');
INSERT INTO `01patients` VALUES ('180', '600681', '350211197906139327', '戴叔伦司', '71', '1900-01-02', '21', '岁', '厦门', '1');
INSERT INTO `01patients` VALUES ('181', '600682', '35021119790613929X', '马迁周', '71', '1900-01-02', '21', '岁', '厦门', '1');
INSERT INTO `01patients` VALUES ('182', '600683', '510101199008166455', '敦颐', '71', '1900-01-02', '21', '岁', '成都', '1');
INSERT INTO `01patients` VALUES ('183', '600684', '51010119900816787X', '文天祥', '71', '1900-01-02', '21', '岁', '成都', '1');
INSERT INTO `01patients` VALUES ('184', '600685', '510101199008167810', '张说', '71', '1900-01-02', '21', '岁', '成都', '1');
INSERT INTO `01patients` VALUES ('185', '600686', '510101199008167650', '张炎', '71', '1900-01-02', '21', '岁', '成都', '1');
INSERT INTO `01patients` VALUES ('186', '600687', '510101199008168573', '吴融', '71', '1900-01-02', '21', '岁', '成都', '1');
INSERT INTO `01patients` VALUES ('187', '600688', '510101199008168370', '郦道元', '71', '1900-01-02', '21', '岁', '成都', '1');
INSERT INTO `01patients` VALUES ('188', '600689', '510101199008167896', '陈著', '71', '1900-01-02', '21', '岁', '成都', '1');
INSERT INTO `01patients` VALUES ('189', '600690', '510101199008168178', '宋之问', '71', '1900-01-02', '21', '岁', '成都', '1');
INSERT INTO `01patients` VALUES ('190', '600691', '510101199008169832', '贺知章', '71', '1900-01-02', '21', '岁', '成都', '1');
INSERT INTO `01patients` VALUES ('191', '600692', '510101199008168995', '王之涣', '71', '1900-01-02', '21', '岁', '成都', '1');
INSERT INTO `01patients` VALUES ('192', '600693', '510101199008166973', '吴潜', '71', '1900-01-02', '21', '岁', '成都', '1');
INSERT INTO `01patients` VALUES ('193', '600694', '510101199008167351', '范成大', '71', '1900-01-02', '21', '岁', '成都', '1');
INSERT INTO `01patients` VALUES ('194', '600695', '510101199008168012', '李端', '71', '1900-01-02', '21', '岁', '成都', '1');
INSERT INTO `01patients` VALUES ('195', '600696', '510101199008167897', '白朴', '71', '1900-01-02', '21', '岁', '成都', '1');
INSERT INTO `01patients` VALUES ('196', '600697', '510101199008166578', '刘克庄', '71', '1900-01-02', '21', '岁', '成都', '1');
INSERT INTO `01patients` VALUES ('197', '600698', '510101199008169728', '顾况', '71', '1900-01-02', '21', '岁', '成都', '1');
INSERT INTO `01patients` VALUES ('198', '600699', '510101199008167220', '张乔', '71', '1900-01-02', '21', '岁', '成都', '1');
INSERT INTO `01patients` VALUES ('199', '600700', '510101199008166543', '马戴', '71', '1900-01-02', '21', '岁', '成都', '1');
INSERT INTO `01patients` VALUES ('273', '600715', '350801199902026637', '王益', '1', '1999-02-07', '20', '岁', '福州', '1');
INSERT INTO `01patients` VALUES ('257', '600702', ' 4', ' 4', '女', '2018-07-10', '1', '岁', ' 4', '1');
INSERT INTO `01patients` VALUES ('258', '600703', ' 7', ' 7', '女', '2019-07-09', '0', '岁', ' 7', '1');
INSERT INTO `01patients` VALUES ('259', '600704', ' 999', ' 999', '女', '2018-07-01', '1', '岁', ' 9', '1');
INSERT INTO `01patients` VALUES ('260', '600705', ' 44', ' 44', '女', '2018-07-23', '1', '岁', ' 44', '1');
INSERT INTO `01patients` VALUES ('261', '600706', ' 111', ' 111', '男', '2018-07-17', '1', '岁', ' 111', '1');
INSERT INTO `01patients` VALUES ('262', '600707', ' 90', ' 90', '女', '2018-07-09', '1', '岁', ' 665', '1');
INSERT INTO `01patients` VALUES ('263', '600708', ' 45', ' 45', '女', '2018-07-09', '1', '岁', ' 33', '1');
INSERT INTO `01patients` VALUES ('264', '600709', ' 222', ' 222', '女', '2018-07-02', '1', '岁', ' 222', '1');
INSERT INTO `01patients` VALUES ('265', '600710', ' 2223', ' 2223', '女', '2019-07-09', '0', '岁', ' 22', '1');
INSERT INTO `01patients` VALUES ('266', '600711', ' 11111', ' 11111', '男', '2019-06-30', '0', '岁', ' 11111', '1');
INSERT INTO `01patients` VALUES ('267', '600712', ' 21212', ' 1213', '男', '2019-06-30', '0', '岁', ' 213', '1');
INSERT INTO `01patients` VALUES ('307', '600716', '222222222222222222', '2', '女', '2017-08-07', '2', '岁', '2', '1');
INSERT INTO `01patients` VALUES ('310', '600718', '350802199905226785', '李明', '男', '1999-05-22', '20', '岁', '而返回瑞典', '1');
INSERT INTO `01patients` VALUES ('313', '600719', '111111111111122222', '小红', '女', '2016-09-05', '3', '岁', 'hkhkgj', '1');

-- ----------------------------
-- Table structure for 02users
-- ----------------------------
DROP TABLE IF EXISTS `02users`;
CREATE TABLE `02users` (
  `userID` int(30) NOT NULL AUTO_INCREMENT,
  `userLoginName` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `userPassword` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `userName` text CHARACTER SET utf8,
  `departmentID` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `userCategory` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `deletedMark` char(10) CHARACTER SET utf8 DEFAULT NULL,
  PRIMARY KEY (`userID`),
  UNIQUE KEY `userLoginName` (`userLoginName`),
  KEY `departmentID` (`departmentID`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of 02users
-- ----------------------------
INSERT INTO `02users` VALUES ('8', 'caiwu', 'caiwu123', '财务管理员', '138', '1', '1');
INSERT INTO `02users` VALUES ('9', 'drug', 'drud123', '药房操作员', '132', '0', '1');
INSERT INTO `02users` VALUES ('10', 'root', 'root123', '超级管理员', '138', '2', '1');

-- ----------------------------
-- Table structure for 03doctors
-- ----------------------------
DROP TABLE IF EXISTS `03doctors`;
CREATE TABLE `03doctors` (
  `doctorID` int(30) NOT NULL AUTO_INCREMENT,
  `doctorLoginName` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `doctorPassword` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `doctorName` text CHARACTER SET utf8,
  `departmentID` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `doctorCategory` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `titleID` text CHARACTER SET utf8,
  `scheduling` text CHARACTER SET utf8,
  `registeredGradeID` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `deletedMark` char(10) CHARACTER SET utf8 DEFAULT NULL,
  PRIMARY KEY (`doctorID`),
  UNIQUE KEY `doctorLoginName` (`doctorLoginName`),
  KEY `departmentID` (`departmentID`),
  KEY `registeredGradeID` (`registeredGradeID`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of 03doctors
-- ----------------------------
INSERT INTO `03doctors` VALUES ('1', 'bianque', 'bianque123', '扁鹊', '1', '3', '主任医师', '是', '1', '1');
INSERT INTO `03doctors` VALUES ('2', 'fwb', 'fwb123', '张仲景', '1', '3', '副主任医师', '是', '2', '1');
INSERT INTO `03doctors` VALUES ('3', 'hqb', 'hqb123', '皇甫谧', '1', '3', '主治医生', '是', '2', '1');
INSERT INTO `03doctors` VALUES ('4', 'huatuo', 'huatuo123', '华佗', '2', '3', '主任医师', '是', '1', '1');
INSERT INTO `03doctors` VALUES ('5', 'xll', 'xll123', '葛洪', '2', '3', '住院医师', '是', '2', '1');
INSERT INTO `03doctors` VALUES ('6', 'adq', 'adq123', '孙思邈', '2', '3', '副主任医师', '是', '2', '1');

-- ----------------------------
-- Table structure for 04administrators
-- ----------------------------
DROP TABLE IF EXISTS `04administrators`;
CREATE TABLE `04administrators` (
  `administratorID` int(30) NOT NULL AUTO_INCREMENT,
  `administratorLoginName` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `administratorPassword` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `administratorName` text CHARACTER SET utf8,
  `departmentID` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `deletedMark` char(10) CHARACTER SET utf8 DEFAULT NULL,
  PRIMARY KEY (`administratorID`),
  UNIQUE KEY `administratorLoginName` (`administratorLoginName`),
  KEY `departmentID` (`departmentID`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of 04administrators
-- ----------------------------
INSERT INTO `04administrators` VALUES ('11', 'admin', 'admin123', '医院管理员', '1', '1');

-- ----------------------------
-- Table structure for 05diseases
-- ----------------------------
DROP TABLE IF EXISTS `05diseases`;
CREATE TABLE `05diseases` (
  `diseaseID` int(30) NOT NULL AUTO_INCREMENT,
  `diseaseName` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `diseaseCategory` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `ICDCode` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `diseaseMnemonicCode` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `deletedMark` char(10) CHARACTER SET utf8 DEFAULT NULL,
  PRIMARY KEY (`diseaseID`),
  UNIQUE KEY `diseaseName` (`diseaseName`)
) ENGINE=MyISAM AUTO_INCREMENT=29396 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of 05diseases
-- ----------------------------
INSERT INTO `05diseases` VALUES ('1', '古典型霍乱', '140', 'A00.051', 'GDXHL', '1');
INSERT INTO `05diseases` VALUES ('2', '中型[典型]霍乱', '140', 'A00.052', 'ZXDXHL', '1');
INSERT INTO `05diseases` VALUES ('3', '重型[暴发型或干性]霍乱', '140', 'A00.053', 'ZXBFXHGXHL', '1');
INSERT INTO `05diseases` VALUES ('4', '轻型[非典型]霍乱', '140', 'A00.151', 'QXFDXHL', '1');
INSERT INTO `05diseases` VALUES ('5', '埃尔托霍乱', '140', 'A00.152', 'AETHL', '1');
INSERT INTO `05diseases` VALUES ('6', '埃尔托小肠炎', '33', 'A00.153', 'AETXCY', '1');
INSERT INTO `05diseases` VALUES ('7', '霍乱 NOS', '140', 'A00.901', 'HL', '1');
INSERT INTO `05diseases` VALUES ('8', '伤寒', '306', 'A01.001', 'SH', '1');
INSERT INTO `05diseases` VALUES ('9', '伤寒杆菌性败血症', '306', 'A01.002', 'SHGJXBXZ', '1');
INSERT INTO `05diseases` VALUES ('10', '伤寒性脑膜炎', '232', 'A01.003+', 'SHXNMY', '1');
INSERT INTO `05diseases` VALUES ('11', '伤寒肺炎', '81', 'A01.051+', 'SHFY', '1');
INSERT INTO `05diseases` VALUES ('12', '伤寒腹膜炎', '306', 'A01.052', 'SHFMY', '1');
INSERT INTO `05diseases` VALUES ('13', '埃贝特Eberth`s氏病(伤寒)', '306', 'A01.053', 'ABTSBSH', '1');
INSERT INTO `05diseases` VALUES ('14', '肠出血性伤寒', '306', 'A01.054', 'CCXXSH', '1');
INSERT INTO `05diseases` VALUES ('15', '伤寒性肠穿孔', '306', 'A01.055', 'SHXCCK', '1');
INSERT INTO `05diseases` VALUES ('16', '肠伤寒', '306', 'A01.056', 'CSH', '1');
INSERT INTO `05diseases` VALUES ('17', '伤寒样小肠炎', '33', 'A01.057', 'SHYXCY', '1');
INSERT INTO `05diseases` VALUES ('18', '甲型副伤寒', '306', 'A01.101', 'JXFSH', '1');
INSERT INTO `05diseases` VALUES ('19', '乙型副伤寒', '306', 'A01.201', 'YXFSH', '1');
INSERT INTO `05diseases` VALUES ('20', '丙型副伤寒', '306', 'A01.301', 'BXFSH', '1');
INSERT INTO `05diseases` VALUES ('21', '副伤寒', '306', 'A01.401', 'FSH', '1');
INSERT INTO `05diseases` VALUES ('22', 'Ｂ群沙门氏菌肠炎', '33', 'A02.001', 'QSMSJCY', '1');
INSERT INTO `05diseases` VALUES ('23', 'Ｃ群沙门氏菌肠炎', '33', 'A02.002', 'QSMSJCY', '1');
INSERT INTO `05diseases` VALUES ('24', '阿哥拉沙门氏菌肠炎', '33', 'A02.003', 'AGLSMSJCY', '1');
INSERT INTO `05diseases` VALUES ('25', '沙门氏菌性肠炎', '33', 'A02.004', 'SMSJXCY', '1');
INSERT INTO `05diseases` VALUES ('26', '沙门氏菌伦敦血清型肠炎', '33', 'A02.005', 'SMSJLDXQXCY', '1');
INSERT INTO `05diseases` VALUES ('27', '沙门氏菌胃肠炎', '33', 'A02.006', 'SMSJWCY', '1');
INSERT INTO `05diseases` VALUES ('28', '鼠伤寒沙门氏菌性肠炎', '33', 'A02.007', 'SSHSMSJXCY', '1');
INSERT INTO `05diseases` VALUES ('29', '婴儿沙门氏菌肠炎', '33', 'A02.008', 'YESMSJCY', '1');
INSERT INTO `05diseases` VALUES ('30', '沙门氏菌肠道感染', '31', 'A02.051', 'SMSJCDGR', '1');
INSERT INTO `05diseases` VALUES ('31', '沙门氏菌(亚利桑那)小肠炎', '33', 'A02.052', 'SMSJYLSNXCY', '1');
INSERT INTO `05diseases` VALUES ('32', '沙门氏菌败血症', '9', 'A02.101', 'SMSJBXZ', '1');
INSERT INTO `05diseases` VALUES ('33', '沙门氏菌鼠伤寒伴有败血症', '306', 'A02.102', 'SMSJSSHBYBXZ', '1');
INSERT INTO `05diseases` VALUES ('34', '沙门氏菌性肺炎', '81', 'A02.201+', 'SMSJXFY', '1');
INSERT INTO `05diseases` VALUES ('35', '沙门氏菌性关节炎', '123', 'A02.202+', 'SMSJXGJY', '1');
INSERT INTO `05diseases` VALUES ('36', '沙门氏菌性脑膜炎', '232', 'A02.203+', 'SMSJXNMY', '1');
INSERT INTO `05diseases` VALUES ('37', '沙门氏菌性骨髓炎', '114', 'A02.251+', 'SMSJXGSY', '1');
INSERT INTO `05diseases` VALUES ('38', '沙门氏菌性肾小管-间质病', '161', 'A02.252+', 'SMSJXSXGJZB', '1');
INSERT INTO `05diseases` VALUES ('39', '其他特指的沙门氏菌感染', '95', 'A02.851', 'QTTZDSMSJGR', '1');
INSERT INTO `05diseases` VALUES ('40', '沙门氏菌感染 NOS', '95', 'A02.901', 'SMSJGR', '1');
INSERT INTO `05diseases` VALUES ('41', '鼠伤寒沙门氏菌感染', '306', 'A02.902', 'SSHSMSJGR', '1');
INSERT INTO `05diseases` VALUES ('42', '沙门氏菌属食物中毒', '324', 'A02.903', 'SMSJSSWZD', '1');
INSERT INTO `05diseases` VALUES ('43', '什密氏志贺菌痢疾', '200', 'A03.001', 'SMSZHJLJ', '1');
INSERT INTO `05diseases` VALUES ('44', '志贺-克鲁泽痢疾[A亚群志贺菌病]', '200', 'A03.051', 'ZHKLZLJYQZHJB', '1');
INSERT INTO `05diseases` VALUES ('45', '施米茨(－施蒂策)痢疾', '200', 'A03.052', 'SMCSDCLJ', '1');
INSERT INTO `05diseases` VALUES ('46', '弗氏志贺菌痢疾', '200', 'A03.101', 'FSZHJLJ', '1');
INSERT INTO `05diseases` VALUES ('47', '希斯－罗素细菌性痢疾', '380', 'A03.151', 'XSLSXJXLJ', '1');
INSERT INTO `05diseases` VALUES ('48', '鲍氏志贺菌痢疾', '200', 'A03.201', 'BSZHJLJ', '1');
INSERT INTO `05diseases` VALUES ('49', '波伊德细菌性痢疾', '380', 'A03.251', 'BYDXJXLJ', '1');
INSERT INTO `05diseases` VALUES ('50', '宋内氏志贺菌痢疾', '200', 'A03.301', 'SNSZHJLJ', '1');
INSERT INTO `05diseases` VALUES ('51', '不定型志贺菌痢疾', '200', 'A03.801', 'BDXZHJLJ', '1');
INSERT INTO `05diseases` VALUES ('52', '菌痢混合感染', '95', 'A03.802', 'JLHHGR', '1');
INSERT INTO `05diseases` VALUES ('53', '其他志贺菌痢疾', '200', 'A03.851', 'QTZHJLJ', '1');
INSERT INTO `05diseases` VALUES ('54', '细菌性痢疾 NOS', '380', 'A03.901', 'XJXLJ', '1');
INSERT INTO `05diseases` VALUES ('55', '慢性细菌性痢疾急性发作', '380', 'A03.902', 'MXXJXLJJXFZ', '1');
INSERT INTO `05diseases` VALUES ('56', '慢性迁延型细菌性痢疾', '380', 'A03.903', 'MXQYXXJXLJ', '1');
INSERT INTO `05diseases` VALUES ('57', '慢性隐伏型菌痢', '278', 'A03.904', 'MXYFXJL', '1');
INSERT INTO `05diseases` VALUES ('58', '中毒性[暴发型]痢疾', '200', 'A03.905', 'ZDXBFXLJ', '1');
INSERT INTO `05diseases` VALUES ('59', '细菌性结肠炎', '33', 'A03.951', 'XJXJCY', '1');
INSERT INTO `05diseases` VALUES ('60', '细菌性关节炎痢疾', '123', 'A03.952+', 'XJXGJYLJ', '1');
INSERT INTO `05diseases` VALUES ('61', '新生儿肠病原性大肠埃希氏菌肠炎', '33', 'A04.001', 'XSECBYXDCAXSJCY', '1');
INSERT INTO `05diseases` VALUES ('62', '肠病原性大肠埃希氏菌肠炎', '33', 'A04.002', 'CBYXDCAXSJCY', '1');
INSERT INTO `05diseases` VALUES ('63', '肠道原病性大肠埃希氏菌感染', '31', 'A04.051', 'CDYBXDCAXSJGR', '1');
INSERT INTO `05diseases` VALUES ('64', '肠毒性大肠埃希氏菌肠炎', '33', 'A04.101', 'CDXDCAXSJCY', '1');
INSERT INTO `05diseases` VALUES ('65', '新生儿肠毒性大肠埃希氏菌肠炎', '33', 'A04.102', 'XSECDXDCAXSJCY', '1');
INSERT INTO `05diseases` VALUES ('66', '肠毒性大肠埃希氏菌感染', '95', 'A04.151', 'CDXDCAXSJGR', '1');
INSERT INTO `05diseases` VALUES ('67', '侵袭性大肠埃希氏菌肠炎', '33', 'A04.201', 'QXXDCAXSJCY', '1');
INSERT INTO `05diseases` VALUES ('68', '新生儿侵袭性大肠杆菌肠炎', '33', 'A04.202', 'XSEQXXDCGJCY', '1');
INSERT INTO `05diseases` VALUES ('69', '出血性大肠埃希氏菌肠炎', '33', 'A04.301', 'CXXDCAXSJCY', '1');
INSERT INTO `05diseases` VALUES ('70', '新生儿出血性大肠杆菌肠炎', '33', 'A04.302', 'XSECXXDCGJCY', '1');
INSERT INTO `05diseases` VALUES ('71', '大肠埃希氏杆菌性肠道感染', '31', 'A04.401', 'DCAXSGJXCDGR', '1');
INSERT INTO `05diseases` VALUES ('72', '新生儿大肠杆菌肠炎', '33', 'A04.402', 'XSEDCGJCY', '1');
INSERT INTO `05diseases` VALUES ('73', '新生儿粘附性大肠杆菌肠炎', '33', 'A04.403', 'XSENFXDCGJCY', '1');
INSERT INTO `05diseases` VALUES ('74', '粘附性大肠杆菌肠炎', '33', 'A04.404', 'NFXDCGJCY', '1');
INSERT INTO `05diseases` VALUES ('75', '弯曲杆菌肠炎', '33', 'A04.501', 'WQGJCY', '1');
INSERT INTO `05diseases` VALUES ('76', '耶尔森氏菌肠炎[冰箱病]', '33', 'A04.601', 'YESSJCYBXB', '1');
INSERT INTO `05diseases` VALUES ('77', '难辨梭状芽胞杆菌肠炎', '33', 'A04.701', 'NBSZYBGJCY', '1');
INSERT INTO `05diseases` VALUES ('78', '难辨梭状芽胞杆菌性小肠结肠炎', '33', 'A04.751', 'NBSZYBGJXXCJCY', '1');
INSERT INTO `05diseases` VALUES ('79', '吡邻单胞菌肠炎', '33', 'A04.801', 'BLDBJCY', '1');
INSERT INTO `05diseases` VALUES ('80', '变形杆菌性肠炎', '33', 'A04.802', 'BXGJXCY', '1');
INSERT INTO `05diseases` VALUES ('81', '产气杆菌肠炎', '33', 'A04.803', 'CQGJCY', '1');
INSERT INTO `05diseases` VALUES ('82', '肠道厌氧菌感染', '31', 'A04.804', 'CDYYJGR', '1');
INSERT INTO `05diseases` VALUES ('83', '副霍乱', '140', 'A04.805', 'FHL', '1');
INSERT INTO `05diseases` VALUES ('84', '副溶血孤菌肠炎', '33', 'A04.806', 'FRXGJCY', '1');
INSERT INTO `05diseases` VALUES ('85', '金黄色葡萄球菌性肠炎', '33', 'A04.807', 'JHSPTQJXCY', '1');
INSERT INTO `05diseases` VALUES ('86', '绿脓杆菌性肠炎', '33', 'A04.808', 'LNGJXCY', '1');
INSERT INTO `05diseases` VALUES ('87', '难辨芽胞杆菌肠炎', '33', 'A04.809', 'NBYBGJCY', '1');
INSERT INTO `05diseases` VALUES ('88', '嗜水气单胞菌肠炎', '33', 'A04.810', 'SSQDBJCY', '1');
INSERT INTO `05diseases` VALUES ('89', '产气荚膜梭状芽胞杆菌(产气荚膜杆菌)肠炎', '33', 'A04.851', 'CQJMSZYBGJCQJMGJCY', '1');
INSERT INTO `05diseases` VALUES ('90', '肠道感染', '31', 'A04.901', 'CDGR', '1');
INSERT INTO `05diseases` VALUES ('91', '细菌性肠炎 NOS', '33', 'A04.902', 'XJXCY', '1');
INSERT INTO `05diseases` VALUES ('92', '感染性腹泻', '95', 'A04.903', 'GRXFX', '1');
INSERT INTO `05diseases` VALUES ('93', '葡萄球菌性食物中毒', '324', 'A05.001', 'PTQJXSWZD', '1');
INSERT INTO `05diseases` VALUES ('94', '肉毒中毒', '471', 'A05.101', 'RDZD', '1');
INSERT INTO `05diseases` VALUES ('95', '肉毒梭状芽胞杆菌性食物中毒', '324', 'A05.151', 'RDSZYBGJXSWZD', '1');
INSERT INTO `05diseases` VALUES ('96', '出血性坏死性肠炎', '33', 'A05.201', 'CXXHSXCY', '1');
INSERT INTO `05diseases` VALUES ('97', '急性坏死性肠炎', '33', 'A05.202', 'JXHSXCY', '1');
INSERT INTO `05diseases` VALUES ('98', '急性出血性坏死性肠炎', '33', 'A05.203', 'JXCXXHSXCY', '1');
INSERT INTO `05diseases` VALUES ('99', '坏死性肠炎', '33', 'A05.251', 'HSXCY', '1');
INSERT INTO `05diseases` VALUES ('100', '产气夹膜梭状芽胞杆菌[韦尔希梭状芽胞杆菌]性食物中毒', '324', 'A05.252', 'CQJMSZYBGJWEXSZYBGJX', '1');
INSERT INTO `05diseases` VALUES ('101', '猪腹病', '264', 'A05.253', 'ZFB', '1');
INSERT INTO `05diseases` VALUES ('102', '副溶血弧菌性食物中毒', '324', 'A05.301', 'FRXHJXSWZD', '1');
INSERT INTO `05diseases` VALUES ('103', '蜡样芽胞杆菌性食物中毒', '324', 'A05.451', 'LYYBGJXSWZD', '1');
INSERT INTO `05diseases` VALUES ('104', '大肠杆菌性食物中毒', '324', 'A05.851', 'DCGJXSWZD', '1');
INSERT INTO `05diseases` VALUES ('105', '嗜盐杆菌性食物中毒', '324', 'A05.852', 'SYGJXSWZD', '1');
INSERT INTO `05diseases` VALUES ('106', '细菌性食物中毒', '324', 'A05.901', 'XJXSWZD', '1');
INSERT INTO `05diseases` VALUES ('107', '食物中毒 NOS', '324', 'A05.951', 'SWZD', '1');
INSERT INTO `05diseases` VALUES ('108', '胃肠型食物中毒', '324', 'A05.952', 'WCXSWZD', '1');
INSERT INTO `05diseases` VALUES ('109', '香肠(腊肠)食物中毒', '324', 'A05.953', 'XCLCSWZD', '1');
INSERT INTO `05diseases` VALUES ('110', '阿米巴性肠炎', '33', 'A06.001', 'AMBXCY', '1');
INSERT INTO `05diseases` VALUES ('111', '阿米巴性结肠炎', '33', 'A06.002', 'AMBXJCY', '1');
INSERT INTO `05diseases` VALUES ('112', '阿米巴性痢疾', '200', 'A06.003', 'AMBXLJ', '1');
INSERT INTO `05diseases` VALUES ('113', '肠道阿米巴病 NOS', '31', 'A06.004', 'CDAMBB', '1');
INSERT INTO `05diseases` VALUES ('114', '急性阿米巴痢疾', '200', 'A06.005', 'JXAMBLJ', '1');
INSERT INTO `05diseases` VALUES ('115', '急性阿米巴病', '1', 'A06.051', 'JXAMBB', '1');
INSERT INTO `05diseases` VALUES ('116', '慢性肠道阿米巴病', '31', 'A06.101', 'MXCDAMBB', '1');
INSERT INTO `05diseases` VALUES ('117', '慢性阿米巴性痢疾', '200', 'A06.151', 'MXAMBXLJ', '1');
INSERT INTO `05diseases` VALUES ('118', '阿米巴(肠)溃疡', '1', 'A06.152', 'AMBCKY', '1');
INSERT INTO `05diseases` VALUES ('119', '慢性阿米巴病', '1', 'A06.153', 'MXAMBB', '1');
INSERT INTO `05diseases` VALUES ('120', '慢性阿米巴病肠炎', '33', 'A06.154', 'MXAMBBCY', '1');
INSERT INTO `05diseases` VALUES ('121', '非痢疾性阿米巴结肠炎', '33', 'A06.201', 'FLJXAMBJCY', '1');
INSERT INTO `05diseases` VALUES ('122', '非痢疾性阿米巴肠炎', '33', 'A06.251', 'FLJXAMBCY', '1');
INSERT INTO `05diseases` VALUES ('123', '急性非痢疾性阿米巴肠炎', '33', 'A06.252', 'JXFLJXAMBCY', '1');
INSERT INTO `05diseases` VALUES ('124', '慢性非痢疾性阿米巴肠炎', '33', 'A06.253', 'MXFLJXAMBCY', '1');
INSERT INTO `05diseases` VALUES ('125', '阿米巴性肉芽肿(阿米巴瘤)', '1', 'A06.301', 'AMBXRYZAMBL', '1');
INSERT INTO `05diseases` VALUES ('126', '阿米巴病肠穿孔', '1', 'A06.351', 'AMBBCCK', '1');
INSERT INTO `05diseases` VALUES ('127', '肠道阿米巴', '31', 'A06.352', 'CDAMB', '1');
INSERT INTO `05diseases` VALUES ('128', '阿米巴性肝脓肿', '243', 'A06.401', 'AMBXGNZ', '1');
INSERT INTO `05diseases` VALUES ('129', '肝阿米巴病', '92', 'A06.402', 'GAMBB', '1');
INSERT INTO `05diseases` VALUES ('130', '阿米巴脓肿', '243', 'A06.451', 'AMBNZ', '1');
INSERT INTO `05diseases` VALUES ('131', '阿米巴性肺脓肿', '243', 'A06.501+', 'AMBXFNZ', '1');
INSERT INTO `05diseases` VALUES ('132', '肝肺阿米巴脓肿', '243', 'A06.502+', 'GFAMBNZ', '1');
INSERT INTO `05diseases` VALUES ('133', '阿米巴性脑脓肿', '243', 'A06.651+', 'AMBXNNZ', '1');
INSERT INTO `05diseases` VALUES ('134', '阿米巴脑和肝脓肿', '243', 'A06.652+', 'AMBNHGNZ', '1');
INSERT INTO `05diseases` VALUES ('135', '阿米巴脑和肺脓肿', '243', 'A06.653+', 'AMBNHFNZ', '1');
INSERT INTO `05diseases` VALUES ('136', '阿米巴脑和肝、肺脓肿', '243', 'A06.654+', 'AMBNHGFNZ', '1');
INSERT INTO `05diseases` VALUES ('137', '阿米巴性皮肤溃疡', '250', 'A06.701', 'AMBXPFKY', '1');
INSERT INTO `05diseases` VALUES ('138', '阿米巴皮炎', '1', 'A06.751', 'AMBPY', '1');
INSERT INTO `05diseases` VALUES ('139', '肺阿米巴病', '1', 'A06.801+', 'FAMBB', '1');
INSERT INTO `05diseases` VALUES ('140', '阿米巴性阑尾炎', '1', 'A06.851', 'AMBXLWY', '1');
INSERT INTO `05diseases` VALUES ('141', '阿米巴性外阴炎', '1', 'A06.852', 'AMBXWYY', '1');
INSERT INTO `05diseases` VALUES ('142', '阿米巴性心包炎', '1', 'A06.853+', 'AMBXXBY', '1');
INSERT INTO `05diseases` VALUES ('143', '阿米巴性龟头炎', '126', 'A06.854+', 'AMBXGTY', '1');
INSERT INTO `05diseases` VALUES ('144', '阿米巴病 NOS', '1', 'A06.901', 'AMBB', '1');
INSERT INTO `05diseases` VALUES ('145', '小袋虫病', '36', 'A07.001', 'XDCB', '1');
INSERT INTO `05diseases` VALUES ('146', '小袋虫性痢疾', '200', 'A07.051', 'XDCXLJ', '1');
INSERT INTO `05diseases` VALUES ('147', '贾第虫病(肠贾第虫)[兰伯鞭毛虫病]', '36', 'A07.101', 'JDCBCJDCLBBMCB', '1');
INSERT INTO `05diseases` VALUES ('148', '肠梨形鞭毛虫病[蓝氏贾第鞭毛虫病]', '36', 'A07.151', 'CLXBMCBLSJDBMCB', '1');
INSERT INTO `05diseases` VALUES ('149', '隐孢子虫病', '36', 'A07.251', 'YBZCB', '1');
INSERT INTO `05diseases` VALUES ('150', '等孢子球虫病(球虫病)', '36', 'A07.301', 'DBZQCBQCB', '1');
INSERT INTO `05diseases` VALUES ('151', '肠道球虫病', '31', 'A07.351', 'CDQCB', '1');
INSERT INTO `05diseases` VALUES ('152', '肠道滴虫病', '31', 'A07.801', 'CDDCB', '1');
INSERT INTO `05diseases` VALUES ('153', '肉孢子虫病', '36', 'A07.802', 'RBZCB', '1');
INSERT INTO `05diseases` VALUES ('154', '肠道毛滴虫病', '31', 'A07.851', 'CDMDCB', '1');
INSERT INTO `05diseases` VALUES ('155', '鞭毛虫性腹泻', '91', 'A07.951', 'BMCXFX', '1');
INSERT INTO `05diseases` VALUES ('156', '原生动物性结肠炎', '33', 'A07.952', 'YSDWXJCY', '1');
INSERT INTO `05diseases` VALUES ('157', '原生动物性痢疾', '200', 'A07.953', 'YSDWXLJ', '1');
INSERT INTO `05diseases` VALUES ('158', '原生动物性腹泻', '91', 'A07.954', 'YSDWXFX', '1');
INSERT INTO `05diseases` VALUES ('159', '旋转(轮状)病毒肠炎', '33', 'A08.001', 'XZLZBDCY', '1');
INSERT INTO `05diseases` VALUES ('160', '诺瓦克病毒肠炎', '33', 'A08.101', 'NWKBDCY', '1');
INSERT INTO `05diseases` VALUES ('161', '流行性恶心', '68', 'A08.151', 'LXXEX', '1');
INSERT INTO `05diseases` VALUES ('162', '流行性病毒性诺瓦克型胃肠病', '370', 'A08.152', 'LXXBDXNWKXWCB', '1');
INSERT INTO `05diseases` VALUES ('163', '流行性呕吐综合征[布拉德利病]', '268', 'A08.153', 'LXXOTZHZBLDLB', '1');
INSERT INTO `05diseases` VALUES ('164', '流行性胃肠炎[斯潘塞病]', '33', 'A08.154', 'LXXWCYSPSB', '1');
INSERT INTO `05diseases` VALUES ('165', '小圆结构病毒性肠炎', '33', 'A08.155', 'XYJGBDXCY', '1');
INSERT INTO `05diseases` VALUES ('166', '腺病毒肠炎', '33', 'A08.201', 'XBDCY', '1');
INSERT INTO `05diseases` VALUES ('167', '轮转病毒胃肠炎', '33', 'A08.351', 'LZBDWCY', '1');
INSERT INTO `05diseases` VALUES ('168', '病毒性肠炎', '33', 'A08.401', 'BDXCY', '1');
INSERT INTO `05diseases` VALUES ('169', '病毒性胃肠炎', '33', 'A08.402', 'BDXWCY', '1');
INSERT INTO `05diseases` VALUES ('170', '肠道病毒感染', '31', 'A08.451', 'CDBDGR', '1');
INSERT INTO `05diseases` VALUES ('171', '病毒性胃肠病', '370', 'A08.452', 'BDXWCB', '1');
INSERT INTO `05diseases` VALUES ('172', '肺结核，显微镜检证实', '171', 'A15.001', 'FJHXWJJZS', '1');
INSERT INTO `05diseases` VALUES ('173', '结核性肺纤维变性，经显微镜下痰检查证实', '171', 'A15.051', 'JHXFXWBXJXWJXTJCZS', '1');
INSERT INTO `05diseases` VALUES ('174', '结核性气胸，经显微镜下痰检查证实', '171', 'A15.052', 'JHXQXJXWJXTJCZS', '1');
INSERT INTO `05diseases` VALUES ('175', '结核性肺炎，经显微镜下痰检查证实', '81', 'A15.053', 'JHXFYJXWJXTJCZS', '1');
INSERT INTO `05diseases` VALUES ('176', '结核性支气管扩张，经显微镜下痰检查证实', '171', 'A15.054', 'JHXZQGKZJXWJXTJCZS', '1');
INSERT INTO `05diseases` VALUES ('177', '肺结核病，仅经痰培养所证实', '171', 'A15.101', 'FJHBJJTPYSZS', '1');
INSERT INTO `05diseases` VALUES ('178', '结核性肺纤维变性，仅经痰培养所证实', '171', 'A15.151', 'JHXFXWBXJJTPYSZS', '1');
INSERT INTO `05diseases` VALUES ('179', '结核性气胸，仅经痰培养所证实', '171', 'A15.152', 'JHXQXJJTPYSZS', '1');
INSERT INTO `05diseases` VALUES ('180', '结核性肺炎，仅经痰培养所证实', '81', 'A15.153', 'JHXFYJJTPYSZS', '1');
INSERT INTO `05diseases` VALUES ('181', '结核性支气管扩张，仅经痰培养所证实', '171', 'A15.154', 'JHXZQGKZJJTPYSZS', '1');
INSERT INTO `05diseases` VALUES ('182', '肺结核病，经组织学所证实', '171', 'A15.201', 'FJHBJZZXSZS', '1');
INSERT INTO `05diseases` VALUES ('183', '结核性肺纤维变性，经组织学所证实', '171', 'A15.251', 'JHXFXWBXJZZXSZS', '1');
INSERT INTO `05diseases` VALUES ('184', '结核性气胸，经组织学所证实', '171', 'A15.252', 'JHXQXJZZXSZS', '1');
INSERT INTO `05diseases` VALUES ('185', '结核性肺炎，经组织学所证实', '81', 'A15.253', 'JHXFYJZZXSZS', '1');
INSERT INTO `05diseases` VALUES ('186', '结核性支气管扩张，经组织学所证实', '171', 'A15.254', 'JHXZQGKZJZZXSZS', '1');
INSERT INTO `05diseases` VALUES ('187', '肺结核病，经未特指的方法所证实', '171', 'A15.351', 'FJHBJWTZDFFSZS', '1');
INSERT INTO `05diseases` VALUES ('188', '结核性肺纤维变性，经未特指的方法所证实', '171', 'A15.352', 'JHXFXWBXJWTZDFFSZS', '1');
INSERT INTO `05diseases` VALUES ('189', '结核性气胸，经未特指的方法所证实', '171', 'A15.353', 'JHXQXJWTZDFFSZS', '1');
INSERT INTO `05diseases` VALUES ('190', '结核性肺炎，经未特指的方法所证实', '81', 'A15.354', 'JHXFYJWTZDFFSZS', '1');
INSERT INTO `05diseases` VALUES ('191', '结核性支气管扩张，经未特指的方法所证实', '171', 'A15.355', 'JHXZQGKZJWTZDFFSZS', '1');
INSERT INTO `05diseases` VALUES ('192', '肺门淋巴结结核病，经细菌学和组织学所证实', '171', 'A15.451', 'FMLBJJHBJXJXHZZXSZS', '1');
INSERT INTO `05diseases` VALUES ('193', '纵隔淋巴结结核病，经细菌学和组织学所证实', '171', 'A15.452', 'ZGLBJJHBJXJXHZZXSZS', '1');
INSERT INTO `05diseases` VALUES ('194', '气管支气管淋巴结结核病，经细菌学和组织学所证实', '171', 'A15.453', 'QGZQGLBJJHBJXJXHZZXS', '1');
INSERT INTO `05diseases` VALUES ('195', '肺门淋巴结结核,已证实', '171', 'A15.501', 'FMLBJJHYZS', '1');
INSERT INTO `05diseases` VALUES ('196', '支气管结核病，经细菌学和组织学所证实', '171', 'A15.551', 'ZQGJHBJXJXHZZXSZS', '1');
INSERT INTO `05diseases` VALUES ('197', '声门结核病，经细菌学和组织学所证实', '171', 'A15.552', 'SMJHBJXJXHZZXSZS', '1');
INSERT INTO `05diseases` VALUES ('198', '喉结核病，经细菌学和组织学所证实', '133', 'A15.553', 'HJHBJXJXHZZXSZS', '1');
INSERT INTO `05diseases` VALUES ('199', '气管结核病，经细菌学和组织学所证实', '171', 'A15.554', 'QGJHBJXJXHZZXSZS', '1');
INSERT INTO `05diseases` VALUES ('200', '结核性胸膜炎，经细菌学和组织学所证实', '171', 'A15.601', 'JHXXMYJXJXHZZXSZS', '1');
INSERT INTO `05diseases` VALUES ('201', '结核性脓胸，经细菌学和组织学所证实', '171', 'A15.651', 'JHXNXJXJXHZZXSZS', '1');
INSERT INTO `05diseases` VALUES ('202', '原发性呼吸道结核病，经细菌学和组织学所证实', '171', 'A15.751', 'YFXHXDJHBJXJXHZZXSZS', '1');
INSERT INTO `05diseases` VALUES ('203', '纵隔结核病，经细菌学和组织所证实', '171', 'A15.851', 'ZGJHBJXJXHZZSZS', '1');
INSERT INTO `05diseases` VALUES ('204', '鼻咽结核病，经细菌学和组织学所证实', '16', 'A15.852', 'BYJHBJXJXHZZXSZS', '1');
INSERT INTO `05diseases` VALUES ('205', '窦(任何鼻窦)结核病，经细菌学和组织学所证实', '16', 'A15.853', 'DRHBDJHBJXJXHZZXSZS', '1');
INSERT INTO `05diseases` VALUES ('206', '鼻结核病，经细菌学和组织学所证实', '16', 'A15.854', 'BJHBJXJXHZZXSZS', '1');
INSERT INTO `05diseases` VALUES ('207', '呼吸结核病 NOS，经细菌学和组织学所证实', '171', 'A15.951', 'HXJHBJXJXHZZXSZS', '1');
INSERT INTO `05diseases` VALUES ('208', '结核性支气管扩张，细菌学和组织检查为阴性', '171', 'A16.051', 'JHXZQGKZXJXHZZJCWYX', '1');
INSERT INTO `05diseases` VALUES ('209', '结核性肺纤维变性，细菌学和组织学检查为阴性', '171', 'A16.052', 'JHXFXWBXXJXHZZXJCWYX', '1');
INSERT INTO `05diseases` VALUES ('210', '结核性肺炎，细菌学和组织学检查为阴性', '81', 'A16.053', 'JHXFYXJXHZZXJCWYX', '1');
INSERT INTO `05diseases` VALUES ('211', '结核性气胸，细菌学和组织学检查为阴性', '171', 'A16.054', 'JHXQXXJXHZZXJCWYX', '1');
INSERT INTO `05diseases` VALUES ('212', '肺结核病，未做细菌学和组织学检查', '171', 'A16.151', 'FJHBWXJXHZZXJC', '1');
INSERT INTO `05diseases` VALUES ('213', '结核性支气管扩张，未做细菌学和组织学检查', '171', 'A16.152', 'JHXZQGKZWXJXHZZXJC', '1');
INSERT INTO `05diseases` VALUES ('214', '结核性肺纤维变性，未做细菌学和组织学检查', '171', 'A16.153', 'JHXFXWBXWXJXHZZXJC', '1');
INSERT INTO `05diseases` VALUES ('215', '结核性肺炎，未做细菌学和组织学检查', '81', 'A16.154', 'JHXFYWXJXHZZXJC', '1');
INSERT INTO `05diseases` VALUES ('216', '结核性气胸，未做细菌学和组织学检查', '171', 'A16.155', 'JHXQXWXJXHZZXJC', '1');
INSERT INTO `05diseases` VALUES ('217', '肺干酪性结核', '171', 'A16.201', 'FGLXJH', '1');
INSERT INTO `05diseases` VALUES ('218', '肺结核，未提及细菌学或组织学的证实', '171', 'A16.202', 'FJHWTJXJXHZZXDZS', '1');
INSERT INTO `05diseases` VALUES ('219', '肺结核瘤，未提及细菌学或组织学的证实', '171', 'A16.203', 'FJHLWTJXJXHZZXDZS', '1');
INSERT INTO `05diseases` VALUES ('220', '结核性肺炎，未提及细菌学或组织学的证实(干酪性肺炎)', '81', 'A16.204', 'JHXFYGLXFYWTJXJXHZZX', '1');
INSERT INTO `05diseases` VALUES ('221', '结核性肺纤维变性(增殖性)，未提及细菌学或组织学的证实', '171', 'A16.205', 'JHXFXWBXZZXWTJXJXHZZ', '1');
INSERT INTO `05diseases` VALUES ('222', '结核性支气管扩张，未提及细菌学或组织学的证实', '171', 'A16.206', 'JHXZQGKZWTJXJXHZZXDZ', '1');
INSERT INTO `05diseases` VALUES ('223', '浸润型肺结核，未提及细菌学或组织学的证实', '171', 'A16.208', 'JRXFJHWTJXJXHZZXDZS', '1');
INSERT INTO `05diseases` VALUES ('224', '空洞型肺结核，未提及细菌学或组织学的证实', '171', 'A16.209', 'KDXFJHWTJXJXHZZXDZS', '1');
INSERT INTO `05diseases` VALUES ('225', '增殖型肺结核，未提及细菌学或组织学的证实', '171', 'A16.210', 'ZZXFJHWTJXJXHZZXDZS', '1');
INSERT INTO `05diseases` VALUES ('226', '结核性肺出血，未提及细菌学或组织学的证实', '171', 'A16.251', 'FCXJHXWTJXJXHZZXDZS', '1');
INSERT INTO `05diseases` VALUES ('227', '结节型肺结核，未提及细菌学或组织学的证实', '171', 'A16.252', 'JJXFJHWTJXJXHZZXDZS', '1');
INSERT INTO `05diseases` VALUES ('228', '结核性肺脓肿，未提及细菌学或组织学的证实', '171', 'A16.253', 'JHXFNZWTJXJXHZZXDZS', '1');
INSERT INTO `05diseases` VALUES ('229', '结核性气胸，未提及细菌学或组织学的证实', '171', 'A16.254', 'JHXQXWTJXJXHZZXDZS', '1');
INSERT INTO `05diseases` VALUES ('230', '矽肺肺结核，未提及细菌学或组织学的证实', '171', 'A16.255', 'XFFJHWTJXJXHZZXDZS', '1');
INSERT INTO `05diseases` VALUES ('231', '肺门淋巴结核，未提及细菌学或组织学的证实', '171', 'A16.301', 'FMLBJHWTJXJXHZZXDZS', '1');
INSERT INTO `05diseases` VALUES ('232', '结核性支气管淋巴瘘', '171', 'A16.302', 'JHXZQGLBL', '1');
INSERT INTO `05diseases` VALUES ('233', '胸壁淋巴结结核', '171', 'A16.303', 'XBLBJJH', '1');
INSERT INTO `05diseases` VALUES ('234', '胸内淋巴结核，未提及细菌学或组织学的证实', '171', 'A16.304', 'XNLBJHWTJXJXHZZXDZS', '1');
INSERT INTO `05diseases` VALUES ('235', '支气管淋巴结结核', '171', 'A16.305', 'ZQGLBJJH', '1');
INSERT INTO `05diseases` VALUES ('236', '纵隔淋巴结核，未提及细菌学或组织学的证实', '171', 'A16.306', 'ZGLBJHWTJXJXHZZXDZS', '1');
INSERT INTO `05diseases` VALUES ('237', '气管支气管淋巴结核，未提及细菌学或组织学的证实', '171', 'A16.351', 'QGZQGLBJHWTJXJXHZZXD', '1');
INSERT INTO `05diseases` VALUES ('238', '喉结核，未提及细菌学或组织学的证实', '133', 'A16.401', 'HJHWTJXJXHZZXDZS', '1');
INSERT INTO `05diseases` VALUES ('239', '会厌结核', '171', 'A16.402', 'HYJH', '1');
INSERT INTO `05diseases` VALUES ('240', '气管结核，未提及细菌学或组织学的证实', '171', 'A16.403', 'QGJHWTJXJXHZZXDZS', '1');
INSERT INTO `05diseases` VALUES ('241', '孤立性气管结核', '171', 'A16.404', 'GLXQGJH', '1');
INSERT INTO `05diseases` VALUES ('242', '孤立性气管支气管结核', '171', 'A16.405', 'GLXQGZQGJH', '1');
INSERT INTO `05diseases` VALUES ('243', '支气管结核，未提及细菌学或组织学的证实', '171', 'A16.406', 'ZQGJHWTJXJXHZZXDZS', '1');
INSERT INTO `05diseases` VALUES ('244', '支气管内膜结核，未提及细菌学或组织学的证实', '171', 'A16.407', 'ZQGNMJHWTJXJXHZZXDZS', '1');
INSERT INTO `05diseases` VALUES ('245', '声门结核病，未提及细菌学或组织学的证实', '171', 'A16.451', 'SMJHBWTJXJXHZZXDZS', '1');
INSERT INTO `05diseases` VALUES ('246', '结核性干性胸膜炎', '171', 'A16.501', 'JHXGXXMY', '1');
INSERT INTO `05diseases` VALUES ('247', '结核性脓胸，未提及细菌学或组织学的证实', '171', 'A16.502', 'JHXNXWTJXJXHZZXDZS', '1');
INSERT INTO `05diseases` VALUES ('248', '结核性渗出性胸膜炎', '171', 'A16.503', 'JHXSCXXMY', '1');
INSERT INTO `05diseases` VALUES ('249', '结核性胸膜炎(Ⅴ型)，未提及细菌学或组织学的证实', '171', 'A16.504', 'JHXXMYWXWTJXJXHZZXDZ', '1');
INSERT INTO `05diseases` VALUES ('250', '结核性胸腔积液，未提及细菌学或组织学的证实', '171', 'A16.505', 'JHXXQJYWTJXJXHZZXDZS', '1');
INSERT INTO `05diseases` VALUES ('251', '胸膜结核，未提及细菌学或组织学的证实', '171', 'A16.506', 'XMJHWTJXJXHZZXDZS', '1');
INSERT INTO `05diseases` VALUES ('252', '胸膜结核瘤，未提及细菌学或组织学的证实', '171', 'A16.507', 'XMJHLWTJXJXHZZXDZS', '1');
INSERT INTO `05diseases` VALUES ('253', '结核性胸膜炎伴积液，未提及细菌学或组织学的证实', '171', 'A16.551', 'JHXXMYBJYWTJXJXHZZXD', '1');
INSERT INTO `05diseases` VALUES ('254', '肺原发性结核性复征(原发综合征)，未提及细菌学或组织学的证实', '171', 'A16.701', 'FYFXJHXFZYFZHZWTJXJX', '1');
INSERT INTO `05diseases` VALUES ('255', '原发性肺结核，未提及细菌学或组织学的证实', '171', 'A16.702', 'YFXFJHWTJXJXHZZXDZS', '1');
INSERT INTO `05diseases` VALUES ('256', '原发性呼吸道结核病，未提及细菌学或组织学的证实', '171', 'A16.751', 'YFXHXDJHBWTJXJXHZZXD', '1');
INSERT INTO `05diseases` VALUES ('257', '原发性结核性胸膜炎，未提及细菌学或组织学的证实', '171', 'A16.752', 'YFXJHXXMYWTJXJXHZZXD', '1');
INSERT INTO `05diseases` VALUES ('258', '鼻结核，未提及细菌学或组织学的证实', '16', 'A16.801', 'BJHWTJXJXHZZXDZS', '1');
INSERT INTO `05diseases` VALUES ('259', '干酪性鼻窦炎，未提及细菌学或组织学的证实', '16', 'A16.802', 'GLXBDYWTJXJXHZZXDZS', '1');
INSERT INTO `05diseases` VALUES ('260', '干酪性鼻炎(结核性鼻炎)，未提及细菌学或组织学的证实', '16', 'A16.803', 'GLXBYJHXBYWTJXJXHZZX', '1');
INSERT INTO `05diseases` VALUES ('261', '膈结核', '171', 'A16.804', 'GJH', '1');
INSERT INTO `05diseases` VALUES ('262', '胸壁结核，未提及细菌学或组织学的证实', '171', 'A16.805', 'XBJHWTJXJXHZZXDZS', '1');
INSERT INTO `05diseases` VALUES ('263', '咽部结核', '171', 'A16.806', 'YBJH', '1');
INSERT INTO `05diseases` VALUES ('264', '纵膈结核瘤', '171', 'A16.807', 'ZGJHL', '1');
INSERT INTO `05diseases` VALUES ('265', '纵膈结核病，未提及细菌学或组织学的证实', '171', 'A16.851', 'ZGJHBWTJXJXHZZXDZS', '1');
INSERT INTO `05diseases` VALUES ('266', '鼻窦道(任何鼻窦)结核病，未提及细菌学或组织学的证实', '16', 'A16.852', 'BDDRHBDJHBWTJXJXHZZX', '1');
INSERT INTO `05diseases` VALUES ('267', '鼻咽结核病，未提及细菌学或组织学的证实', '16', 'A16.853', 'BYJHBWTJXJXHZZXDZS', '1');
INSERT INTO `05diseases` VALUES ('268', '鼻窦结核，未提及细菌学或组织学的证实', '16', 'A16.854', 'BDJHWTJXJXHZZXDZS', '1');
INSERT INTO `05diseases` VALUES ('269', '扁桃体结核，未提及细菌学或组织学的证实', '171', 'A16.855', 'BTTJHWTJXJXHZZXDZS', '1');
INSERT INTO `05diseases` VALUES ('270', '结核病，未提及细菌学或组织学的证实 NOS', '171', 'A16.901', 'JHBWTJXJXHZZXDZS', '1');
INSERT INTO `05diseases` VALUES ('271', '结核感染', '171', 'A16.902', 'JHGR', '1');
INSERT INTO `05diseases` VALUES ('272', '呼吸道结核病，未提及细菌学或组织学的证实', '171', 'A16.951', 'HXDJHBWTJXJXHZZXDZS', '1');
INSERT INTO `05diseases` VALUES ('273', '结核性脊膜炎', '171', 'A17.001+', 'JHXJMY', '1');
INSERT INTO `05diseases` VALUES ('274', '结核性脑脊髓膜炎', '171', 'A17.002+', 'JHXNJSMY', '1');
INSERT INTO `05diseases` VALUES ('275', '结核性脑膜炎', '171', 'A17.003+', 'JHXNMY', '1');
INSERT INTO `05diseases` VALUES ('276', '结核性蛛网膜炎', '171', 'A17.051+', 'JHXZWMY', '1');
INSERT INTO `05diseases` VALUES ('277', '结核性柔脑膜炎', '171', 'A17.052+', 'JHXRNMY', '1');
INSERT INTO `05diseases` VALUES ('278', '脑膜结核瘤', '171', 'A17.151+', 'NMJHL', '1');
INSERT INTO `05diseases` VALUES ('279', '脑脊膜核瘤', '234', 'A17.152+', 'NJMHL', '1');
INSERT INTO `05diseases` VALUES ('280', '结核性脑膜脑炎', '171', 'A17.801+', 'JHXNMNY', '1');
INSERT INTO `05diseases` VALUES ('281', '结核性脑脓肿', '171', 'A17.802+', 'JHXNNZ', '1');
INSERT INTO `05diseases` VALUES ('282', '结核性脑肉芽肿', '171', 'A17.803+', 'JHXNRYZ', '1');
INSERT INTO `05diseases` VALUES ('283', '结核性脑炎', '171', 'A17.804+', 'JHXNY', '1');
INSERT INTO `05diseases` VALUES ('284', '结核性脑脊髓膜炎(硬脊膜外)', '171', 'A17.805+', 'JHXNJSMYYJMW', '1');
INSERT INTO `05diseases` VALUES ('285', '脑结核瘤', '171', 'A17.806+', 'NJHL', '1');
INSERT INTO `05diseases` VALUES ('286', '中枢神经系统结核', '313', 'A17.807+', 'ZSSJXTJH', '1');
INSERT INTO `05diseases` VALUES ('287', '结核性脊髓炎', '171', 'A17.851+', 'JHXJSY', '1');
INSERT INTO `05diseases` VALUES ('288', '脊髓结核病', '171', 'A17.852+', 'JSJHB', '1');
INSERT INTO `05diseases` VALUES ('289', '结核性多神经病', '313', 'A17.853+', 'JHXDSJB', '1');
INSERT INTO `05diseases` VALUES ('290', '神经系统结核病 NOS', '313', 'A17.951+', 'SJXTJHB', '1');
INSERT INTO `05diseases` VALUES ('291', '鼻骨结核', '16', 'A18.001+', 'BGJH', '1');
INSERT INTO `05diseases` VALUES ('292', '腭骨结核', '171', 'A18.002+', 'EGJH', '1');
INSERT INTO `05diseases` VALUES ('293', '颌骨结核', '171', 'A18.003+', 'HGJH', '1');
INSERT INTO `05diseases` VALUES ('294', '乳突结核', '171', 'A18.004+', 'RTJH', '1');
INSERT INTO `05diseases` VALUES ('295', '下颌结核', '171', 'A18.005+', 'XHJH', '1');
INSERT INTO `05diseases` VALUES ('296', '颧骨结核', '171', 'A18.006+', 'QGJH', '1');
INSERT INTO `05diseases` VALUES ('297', '颈椎结核', '171', 'A18.007+', 'GZJH', '1');
INSERT INTO `05diseases` VALUES ('298', '肩关节结核', '123', 'A18.008+', 'JGJJH', '1');
INSERT INTO `05diseases` VALUES ('299', '腕关节结核', '123', 'A18.009+', 'WGJJH', '1');
INSERT INTO `05diseases` VALUES ('300', '胸椎结核', '171', 'A18.010+', 'XZJH', '1');
INSERT INTO `05diseases` VALUES ('301', '腰椎结核', '171', 'A18.011+', 'YZJH', '1');
INSERT INTO `05diseases` VALUES ('302', '跖趾关节结核', '123', 'A18.012+', 'ZZGJJH', '1');
INSERT INTO `05diseases` VALUES ('303', '脊柱结核性截瘫(波特氏截瘫)', '171', 'A18.013+', 'JZJHXJTBTSJT', '1');
INSERT INTO `05diseases` VALUES ('304', '骶髂关节结核', '123', 'A18.014+', 'DQGJJH', '1');
INSERT INTO `05diseases` VALUES ('305', '结核性风湿病[篷塞氏病]', '171', 'A18.015+', 'JHXFSBPSSB', '1');
INSERT INTO `05diseases` VALUES ('306', '脊柱结核性脓肿', '171', 'A18.016+', 'JZJHXNZ', '1');
INSERT INTO `05diseases` VALUES ('307', '滑膜结核', '171', 'A18.017+', 'HMJH', '1');
INSERT INTO `05diseases` VALUES ('308', '脊椎结核并椎旁脓肿', '171', 'A18.018+', 'JZJHBZPNZ', '1');
INSERT INTO `05diseases` VALUES ('309', '关节结核性脓肿(关节寒性脓肿)', '123', 'A18.019+', 'GJJHXNZGJHXNZ', '1');
INSERT INTO `05diseases` VALUES ('310', '结核性脊柱后凸', '171', 'A18.020+', 'JHXJZHT', '1');
INSERT INTO `05diseases` VALUES ('311', '关节结核', '123', 'A18.021+', 'GJJH', '1');
INSERT INTO `05diseases` VALUES ('312', '肘关节结核', '123', 'A18.022+', 'ZGJJH', '1');
INSERT INTO `05diseases` VALUES ('313', '髋关节结核', '123', 'A18.023+', 'KGJJH', '1');
INSERT INTO `05diseases` VALUES ('314', '髋结核性滑膜炎', '171', 'A18.024+', 'KJHXHMY', '1');
INSERT INTO `05diseases` VALUES ('315', '踝关节结核', '123', 'A18.025+', 'HGJJH', '1');
INSERT INTO `05diseases` VALUES ('316', '耻骨结核', '171', 'A18.026+', 'CGJH', '1');
INSERT INTO `05diseases` VALUES ('317', '肋骨结核', '171', 'A18.027+', 'LGJH', '1');
INSERT INTO `05diseases` VALUES ('318', '膝关节结核', '123', 'A18.028+', 'XGJJH', '1');
INSERT INTO `05diseases` VALUES ('319', '膝结核性滑膜炎', '171', 'A18.029+', 'XJHXHMY', '1');
INSERT INTO `05diseases` VALUES ('320', '肱骨结核', '171', 'A18.031+', 'GGJH', '1');
INSERT INTO `05diseases` VALUES ('321', '股骨结核', '171', 'A18.032+', 'GGJH', '1');
INSERT INTO `05diseases` VALUES ('322', '趾骨结核', '171', 'A18.033+', 'ZGJH', '1');
INSERT INTO `05diseases` VALUES ('323', '肢体骨结核', '171', 'A18.034+', 'ZTGJH', '1');
INSERT INTO `05diseases` VALUES ('324', '骨结核', '171', 'A18.035+', 'GJH', '1');
INSERT INTO `05diseases` VALUES ('325', '尺骨结核', '171', 'A18.036+', 'CGJH', '1');
INSERT INTO `05diseases` VALUES ('326', '腓骨结核', '171', 'A18.037+', 'FGJH', '1');
INSERT INTO `05diseases` VALUES ('327', '胫骨结核', '171', 'A18.038+', 'JGJH', '1');
INSERT INTO `05diseases` VALUES ('328', '跟骨结核', '171', 'A18.039+', 'GGJH', '1');
INSERT INTO `05diseases` VALUES ('329', '腰部结核性窦道', '171', 'A18.040+', 'YBJHXDD', '1');
INSERT INTO `05diseases` VALUES ('330', '结核性关节炎', '123', 'A18.041+', 'JHXGJY', '1');
INSERT INTO `05diseases` VALUES ('331', '第三楔骨结核', '171', 'A18.042+', 'DSXGJH', '1');
INSERT INTO `05diseases` VALUES ('332', '肌腱结核', '171', 'A18.043+', 'JJJH', '1');
INSERT INTO `05diseases` VALUES ('333', '掌骨结核', '171', 'A18.044+', 'ZGJH', '1');
INSERT INTO `05diseases` VALUES ('334', '其他骨结核', '171', 'A18.045+', 'QTGJH', '1');
INSERT INTO `05diseases` VALUES ('335', '脊柱结核', '171', 'A18.046+', 'JZJH', '1');
INSERT INTO `05diseases` VALUES ('336', '结核性乳突炎', '171', 'A18.051+', 'JHXRTY', '1');
INSERT INTO `05diseases` VALUES ('337', '骨关节结核', '123', 'A18.052+', 'GGJJH', '1');
INSERT INTO `05diseases` VALUES ('338', '结核性膝部囊肿[结核性贝克氏囊肿]', '171', 'A18.053+', 'JHXXBNZJHXBKSNZ', '1');
INSERT INTO `05diseases` VALUES ('339', '膝关节结核伴瘘道形成', '123', 'A18.054+', 'XGJJHBLDXC', '1');
INSERT INTO `05diseases` VALUES ('340', '波特弯曲(脊柱)', '154', 'A18.055+', 'BTWQJZ', '1');
INSERT INTO `05diseases` VALUES ('341', '结核性脊柱裂', '171', 'A18.056+', 'JHXJZL', '1');
INSERT INTO `05diseases` VALUES ('342', '结核性椎管内脓肿', '171', 'A18.057+', 'JHXZGNNZ', '1');
INSERT INTO `05diseases` VALUES ('343', '胸椎结核伴脓肿', '171', 'A18.058+', 'XZJHBNZ', '1');
INSERT INTO `05diseases` VALUES ('344', '腰椎结核伴脓肿', '171', 'A18.059+', 'YZJHBNZ', '1');
INSERT INTO `05diseases` VALUES ('345', '腰椎结核伴瘘道形成', '171', 'A18.060+', 'YZJHBLDXC', '1');
INSERT INTO `05diseases` VALUES ('346', '多个椎骨结核', '171', 'A18.061+', 'DGZGJH', '1');
INSERT INTO `05diseases` VALUES ('347', '结核性滑膜炎', '171', 'A18.062+', 'JHXHMY', '1');
INSERT INTO `05diseases` VALUES ('348', '结核性腱鞘炎', '171', 'A18.063+', 'JHXJQY', '1');
INSERT INTO `05diseases` VALUES ('349', '指(趾)关节结核', '123', 'A18.064+', 'ZZGJJH', '1');
INSERT INTO `05diseases` VALUES ('350', '结核性骨髓炎', '171', 'A18.065+', 'JHXGSY', '1');
INSERT INTO `05diseases` VALUES ('351', '胸骨结核', '171', 'A18.066+', 'XGJH', '1');
INSERT INTO `05diseases` VALUES ('352', '指骨结核', '171', 'A18.067+', 'ZGJH', '1');
INSERT INTO `05diseases` VALUES ('353', '跖骨结核', '171', 'A18.068+', 'ZGJH', '1');
INSERT INTO `05diseases` VALUES ('354', '跗骨结核', '171', 'A18.069+', 'FGJH', '1');
INSERT INTO `05diseases` VALUES ('355', '其他特指骨结核', '171', 'A18.070+', 'QTTZGJH', '1');
INSERT INTO `05diseases` VALUES ('356', '结核性骨坏死', '171', 'A18.071+', 'JHXGHS', '1');
INSERT INTO `05diseases` VALUES ('357', '泌尿生殖系结核', '171', 'A18.101', 'MNSZXJH', '1');
INSERT INTO `05diseases` VALUES ('358', '膀胱结核', '171', 'A18.102+', 'BGJH', '1');
INSERT INTO `05diseases` VALUES ('359', '泌尿系结核', '171', 'A18.103', 'MNXJH', '1');
INSERT INTO `05diseases` VALUES ('360', '子宫内膜结核', '171', 'A18.104+', 'ZGNMJH', '1');
INSERT INTO `05diseases` VALUES ('361', '附睾结核', '171', 'A18.105+', 'FGJH', '1');
INSERT INTO `05diseases` VALUES ('362', '睾丸结核', '171', 'A18.106+', 'GWJH', '1');
INSERT INTO `05diseases` VALUES ('363', '女性盆腔结核', '171', 'A18.107+', 'NXPQJH', '1');
INSERT INTO `05diseases` VALUES ('364', '子宫颈结核', '171', 'A18.108+', 'ZGGJH', '1');
INSERT INTO `05diseases` VALUES ('365', '阴茎结核', '171', 'A18.109+', 'YJJH', '1');
INSERT INTO `05diseases` VALUES ('366', '卵巢结核', '171', 'A18.110+', 'LCJH', '1');
INSERT INTO `05diseases` VALUES ('367', '前列腺结核', '171', 'A18.111+', 'QLXJH', '1');
INSERT INTO `05diseases` VALUES ('368', '肾结核', '171', 'A18.112+', 'SJH', '1');
INSERT INTO `05diseases` VALUES ('369', '结核性肾脓肿', '171', 'A18.113+', 'JHXSNZ', '1');
INSERT INTO `05diseases` VALUES ('370', '输精管结核', '171', 'A18.114+', 'SJGJH', '1');
INSERT INTO `05diseases` VALUES ('371', '输卵管结核', '171', 'A18.115+', 'SLGJH', '1');
INSERT INTO `05diseases` VALUES ('372', '结核性输尿管狭窄', '171', 'A18.116+', 'JHXSNGXZ', '1');
INSERT INTO `05diseases` VALUES ('373', '输尿管结核', '171', 'A18.117+', 'SNGJH', '1');
INSERT INTO `05diseases` VALUES ('374', '精囊结核', '171', 'A18.118+', 'JNJH', '1');
INSERT INTO `05diseases` VALUES ('375', '结核性肾盂积水', '171', 'A18.151+', 'JHXSYJS', '1');
INSERT INTO `05diseases` VALUES ('376', '结核性肾盂(肾)炎', '171', 'A18.152+', 'JHXSYSY', '1');
INSERT INTO `05diseases` VALUES ('377', '附睾结核性窦道', '171', 'A18.156+', 'FGJHXDD', '1');
INSERT INTO `05diseases` VALUES ('378', '男性生殖器官结核', '171', 'A18.157+', 'NXSZQGJH', '1');
INSERT INTO `05diseases` VALUES ('379', '女生殖器结核', '171', 'A18.159+', 'NSZQJH', '1');
INSERT INTO `05diseases` VALUES ('380', '道格拉斯陷窝结核病', '171', 'A18.160+', 'DGLSXWJHB', '1');
INSERT INTO `05diseases` VALUES ('381', '腹股沟淋巴结核', '171', 'A18.201', 'FGGLBJH', '1');
INSERT INTO `05diseases` VALUES ('382', '颌下淋巴结结核', '171', 'A18.202', 'HXLBJJH', '1');
INSERT INTO `05diseases` VALUES ('383', '结核性淋巴管炎', '171', 'A18.203', 'JHXLBGY', '1');
INSERT INTO `05diseases` VALUES ('384', '颈部淋巴结结核', '171', 'A18.204', 'GBLBJJH', '1');
INSERT INTO `05diseases` VALUES ('385', '颏下淋巴结结核', '171', 'A18.205', 'KXLBJJH', '1');
INSERT INTO `05diseases` VALUES ('386', '淋巴结核', '171', 'A18.206', 'LBJH', '1');
INSERT INTO `05diseases` VALUES ('387', '腮腺淋巴结核', '171', 'A18.207', 'SXLBJH', '1');
INSERT INTO `05diseases` VALUES ('388', '锁骨上淋巴结核', '171', 'A18.208', 'SGSLBJH', '1');
INSERT INTO `05diseases` VALUES ('389', '腋下(窝)淋巴结结核', '171', 'A18.209', 'YXWLBJJH', '1');
INSERT INTO `05diseases` VALUES ('390', '周围淋巴结结核', '171', 'A18.210', 'ZWLBJJH', '1');
INSERT INTO `05diseases` VALUES ('391', '结核结节', '171', 'A18.251', 'JHJJ', '1');
INSERT INTO `05diseases` VALUES ('392', '结核性面颈部淋巴结炎', '171', 'A18.252', 'JHXMGBLBJY', '1');
INSERT INTO `05diseases` VALUES ('393', '结核性淋巴腺炎', '171', 'A18.253', 'JHXLBXY', '1');
INSERT INTO `05diseases` VALUES ('394', '肠结核', '171', 'A18.301+', 'CJH', '1');
INSERT INTO `05diseases` VALUES ('395', '肠系膜结核', '171', 'A18.302+', 'CXMJH', '1');
INSERT INTO `05diseases` VALUES ('396', '肠系膜淋巴结结核', '171', 'A18.303+', 'CXMLBJJH', '1');
INSERT INTO `05diseases` VALUES ('397', '腹膜结核', '171', 'A18.304+', 'FMJH', '1');
INSERT INTO `05diseases` VALUES ('398', '结核性肛瘘', '171', 'A18.305+', 'JHXGL', '1');
INSERT INTO `05diseases` VALUES ('399', '髂窝结核', '171', 'A18.306+', 'QWJH', '1');
INSERT INTO `05diseases` VALUES ('400', '结核性腹膜炎', '171', 'A18.307+', 'JHXFMY', '1');
INSERT INTO `05diseases` VALUES ('401', '腹膜后淋巴结结核', '171', 'A18.308', 'FMHLBJJH', '1');
INSERT INTO `05diseases` VALUES ('402', '腹腔结核', '171', 'A18.309+', 'FQJH', '1');
INSERT INTO `05diseases` VALUES ('403', '腹腔淋巴结核', '171', 'A18.310', 'FQLBJH', '1');
INSERT INTO `05diseases` VALUES ('404', '肝门淋巴结核', '171', 'A18.311', 'GMLBJH', '1');
INSERT INTO `05diseases` VALUES ('405', '结核性腹水', '171', 'A18.312', 'JHXFS', '1');
INSERT INTO `05diseases` VALUES ('406', '结核性肠炎', '33', 'A18.351+', 'JHXCY', '1');
INSERT INTO `05diseases` VALUES ('407', '肛门结核病', '171', 'A18.352+', 'GMJHB', '1');
INSERT INTO `05diseases` VALUES ('408', '直肠结核病', '171', 'A18.353+', 'ZCJHB', '1');
INSERT INTO `05diseases` VALUES ('409', '播散性粟粒性狼疮', '250', 'A18.401', 'BSXSLXLC', '1');
INSERT INTO `05diseases` VALUES ('410', '腹壁结核', '171', 'A18.402', 'FBJH', '1');
INSERT INTO `05diseases` VALUES ('411', '腹部结核性窦道', '171', 'A18.403', 'FBJHXDD', '1');
INSERT INTO `05diseases` VALUES ('412', '结核性结节性红斑[硬红斑、巴赞氏病]', '171', 'A18.404', 'JHXJJXHBYHBBZSB', '1');
INSERT INTO `05diseases` VALUES ('413', '结核性皮肤脓肿', '171', 'A18.405', 'JHXPFNZ', '1');
INSERT INTO `05diseases` VALUES ('414', '酒渣样结核疹', '171', 'A18.406', 'JZYJHZ', '1');
INSERT INTO `05diseases` VALUES ('415', '皮肤和皮下组织结核', '171', 'A18.407', 'PFHPXZZJH', '1');
INSERT INTO `05diseases` VALUES ('416', '皮肤结核', '171', 'A18.408', 'PFJH', '1');
INSERT INTO `05diseases` VALUES ('417', '皮下组织结核性窦道', '171', 'A18.409', 'PXZZJHXDD', '1');
INSERT INTO `05diseases` VALUES ('418', '臀部结核', '171', 'A18.410', 'TBJH', '1');
INSERT INTO `05diseases` VALUES ('419', '寻常性狼疮', '250', 'A18.411', 'XCXLC', '1');
INSERT INTO `05diseases` VALUES ('420', '结核性皮肤瘢痕', '171', 'A18.451', 'JHXPFBH', '1');
INSERT INTO `05diseases` VALUES ('421', '皮肤瘰疠(结核)', '171', 'A18.452', 'PFLLJH', '1');
INSERT INTO `05diseases` VALUES ('422', '硬化性皮结核', '171', 'A18.453', 'YHXPJH', '1');
INSERT INTO `05diseases` VALUES ('423', '皮下结核', '171', 'A18.454', 'PXJH', '1');
INSERT INTO `05diseases` VALUES ('424', '结核疹', '171', 'A18.455', 'JHZ', '1');
INSERT INTO `05diseases` VALUES ('425', '结核性狼疮', '171', 'A18.456', 'JHXLC', '1');
INSERT INTO `05diseases` VALUES ('426', '腐蚀性狼疮', '250', 'A18.457', 'FSXLC', '1');
INSERT INTO `05diseases` VALUES ('427', '寻常眼睑的狼疮', '430', 'A18.458+', 'XCYJDLC', '1');
INSERT INTO `05diseases` VALUES ('428', '眼睑结核', '430', 'A18.459+', 'YJJH', '1');
INSERT INTO `05diseases` VALUES ('429', '眼结核', '430', 'A18.501', 'YJH', '1');
INSERT INTO `05diseases` VALUES ('430', '眼眶结核', '430', 'A18.502', 'YKJH', '1');
INSERT INTO `05diseases` VALUES ('431', '巩膜结核', '171', 'A18.503+', 'GMJH', '1');
INSERT INTO `05diseases` VALUES ('432', '角膜结核', '171', 'A18.504+', 'JMJH', '1');
INSERT INTO `05diseases` VALUES ('433', '结核性视神经脉络膜炎', '313', 'A18.505+', 'JHXSSJMLMY', '1');
INSERT INTO `05diseases` VALUES ('434', '结核性葡萄膜炎', '171', 'A18.506+', 'JHXPTMY', '1');
INSERT INTO `05diseases` VALUES ('435', '结核性视网膜静脉周围炎', '171', 'A18.507+', 'JHXSWMJMZWY', '1');
INSERT INTO `05diseases` VALUES ('436', '结膜结核', '171', 'A18.508+', 'JMJH', '1');
INSERT INTO `05diseases` VALUES ('437', '脉络膜结核', '171', 'A18.509+', 'MLMJH', '1');
INSERT INTO `05diseases` VALUES ('438', '脉络膜结核瘤', '171', 'A18.510+', 'MLMJHL', '1');
INSERT INTO `05diseases` VALUES ('439', '视神经结核', '313', 'A18.511+', 'SSJJH', '1');
INSERT INTO `05diseases` VALUES ('440', '视网膜结核', '171', 'A18.512+', 'SWMJH', '1');
INSERT INTO `05diseases` VALUES ('441', '结核性泪囊炎', '171', 'A18.551+', 'JHXLNY', '1');
INSERT INTO `05diseases` VALUES ('442', '结核性巩膜外层炎', '171', 'A18.552+', 'JHXGMWCY', '1');
INSERT INTO `05diseases` VALUES ('443', '结核性间质性角膜炎', '171', 'A18.553+', 'JHXJZXJMY', '1');
INSERT INTO `05diseases` VALUES ('444', '结核性角膜结膜炎(间质性)(小泡性)', '171', 'A18.554+', 'JHXJMJMYJZXXPX', '1');
INSERT INTO `05diseases` VALUES ('445', '结核性虹膜睫状体炎', '171', 'A18.555+', 'JHXHMJZTY', '1');
INSERT INTO `05diseases` VALUES ('446', '结核性脉络膜视网膜炎', '171', 'A18.556+', 'JHXMLMSWMY', '1');
INSERT INTO `05diseases` VALUES ('447', '外耳道结核', '70', 'A18.601', 'WEDJH', '1');
INSERT INTO `05diseases` VALUES ('448', '中耳结核', '70', 'A18.602', 'ZEJH', '1');
INSERT INTO `05diseases` VALUES ('449', '结核性中耳炎', '70', 'A18.603+', 'JHXZEY', '1');
INSERT INTO `05diseases` VALUES ('450', '耳结核', '70', 'A18.651+', 'EJH', '1');
INSERT INTO `05diseases` VALUES ('451', '肾上腺结核', '171', 'A18.701+', 'SSXJH', '1');
INSERT INTO `05diseases` VALUES ('452', '肾上腺结核病[艾迪生]', '171', 'A18.751+', 'SSXJHBADS', '1');
INSERT INTO `05diseases` VALUES ('453', '艾迪生结核病黑病变', '171', 'A18.752+', 'ADSJHBHBB', '1');
INSERT INTO `05diseases` VALUES ('454', '结核性肾上腺机能减退', '171', 'A18.753+', 'JHXSSXJNJT', '1');
INSERT INTO `05diseases` VALUES ('455', '结核性肾上腺机能障碍', '171', 'A18.754+', 'JHXSSXJNZA', '1');
INSERT INTO `05diseases` VALUES ('456', '肺外结核', '171', 'A18.801', 'FWJH', '1');
INSERT INTO `05diseases` VALUES ('457', '乳腺结核', '171', 'A18.802', 'RXJH', '1');
INSERT INTO `05diseases` VALUES ('458', '舌结核', '171', 'A18.803+', 'SJH', '1');
INSERT INTO `05diseases` VALUES ('459', '足结核', '171', 'A18.804', 'ZJH', '1');
INSERT INTO `05diseases` VALUES ('460', '垂体结核', '171', 'A18.805+', 'CTJH', '1');
INSERT INTO `05diseases` VALUES ('461', '唇结核', '171', 'A18.806+', 'CJH', '1');
INSERT INTO `05diseases` VALUES ('462', '胆囊结核', '53', 'A18.807+', 'DNJH', '1');
INSERT INTO `05diseases` VALUES ('463', '肝结核', '171', 'A18.808+', 'GJH', '1');
INSERT INTO `05diseases` VALUES ('464', '颌下腺结核', '171', 'A18.809+', 'HXXJH', '1');
INSERT INTO `05diseases` VALUES ('465', '肌结核', '171', 'A18.810+', 'JJH', '1');
INSERT INTO `05diseases` VALUES ('466', '甲状腺结核', '171', 'A18.811+', 'JZXJH', '1');
INSERT INTO `05diseases` VALUES ('467', '结缔组织结核', '171', 'A18.812+', 'JDZZJH', '1');
INSERT INTO `05diseases` VALUES ('468', '结核性腹主动脉炎', '171', 'A18.813+', 'JHXFZDMY', '1');
INSERT INTO `05diseases` VALUES ('469', '食管结核(结核性食管炎)', '171', 'A18.814+', 'SGJHJHXSGY', '1');
INSERT INTO `05diseases` VALUES ('470', '结核性心包积液', '171', 'A18.815+', 'JHXXBJY', '1');
INSERT INTO `05diseases` VALUES ('471', '心包结核(结核性心包炎)', '171', 'A18.816+', 'XBJHJHXXBY', '1');
INSERT INTO `05diseases` VALUES ('472', '心肌结核(结核性心肌炎)', '171', 'A18.817+', 'XJJHJHXXJY', '1');
INSERT INTO `05diseases` VALUES ('473', '结核性心内膜炎', '171', 'A18.818+', 'JHXXNMY', '1');
INSERT INTO `05diseases` VALUES ('474', '咀嚼肌结核', '171', 'A18.819+', 'JJJJH', '1');
INSERT INTO `05diseases` VALUES ('475', '脾结核', '171', 'A18.820+', 'PJH', '1');
INSERT INTO `05diseases` VALUES ('476', '腮腺结核', '171', 'A18.821+', 'SXJH', '1');
INSERT INTO `05diseases` VALUES ('477', '上臂内侧横纹肌结核', '171', 'A18.822+', 'SBNCHWJJH', '1');
INSERT INTO `05diseases` VALUES ('478', '胃结核', '171', 'A18.823+', 'WJH', '1');
INSERT INTO `05diseases` VALUES ('479', '胸大肌结核', '171', 'A18.824+', 'XDJJH', '1');
INSERT INTO `05diseases` VALUES ('480', '牙龈结核', '171', 'A18.825+', 'YYJH', '1');
INSERT INTO `05diseases` VALUES ('481', '腰部结核性脓肿', '171', 'A18.826+', 'YBJHXNZ', '1');
INSERT INTO `05diseases` VALUES ('482', '腰大肌结核性脓肿', '171', 'A18.827+', 'YDJJHXNZ', '1');
INSERT INTO `05diseases` VALUES ('483', '腰肌结核', '171', 'A18.828+', 'YJJH', '1');
INSERT INTO `05diseases` VALUES ('484', '胰腺结核', '171', 'A18.829+', 'YXJH', '1');
INSERT INTO `05diseases` VALUES ('485', '结核性大脑动脉炎', '171', 'A18.851+', 'JHXDNDMY', '1');
INSERT INTO `05diseases` VALUES ('486', '结核性动脉内膜炎', '171', 'A18.852+', 'JHXDMNMY', '1');
INSERT INTO `05diseases` VALUES ('487', '结核性肝(肝炎)', '93', 'A18.853+', 'JHXGGY', '1');
INSERT INTO `05diseases` VALUES ('488', '颌下淋巴结核', '171', 'A18.855+', 'HXLBJH', '1');
INSERT INTO `05diseases` VALUES ('489', '髂凹结核性脓肿(髂腰肌)', '171', 'A18.856+', 'QAJHXNZQYJ', '1');
INSERT INTO `05diseases` VALUES ('490', '臀部肌肉结核性脓肿', '171', 'A18.857+', 'TBJRJHXNZ', '1');
INSERT INTO `05diseases` VALUES ('491', '急性粟粒性肺结核', '171', 'A19.001', 'JXSLXFJH', '1');
INSERT INTO `05diseases` VALUES ('492', '急性血行播散型肺结核', '171', 'A19.051', 'JXXXBSXFJH', '1');
INSERT INTO `05diseases` VALUES ('493', '急性播散性多浆膜炎', '164', 'A19.151', 'JXBSXDJMY', '1');
INSERT INTO `05diseases` VALUES ('494', '急性多发性结核病', '171', 'A19.152', 'JXDFXJHB', '1');
INSERT INTO `05diseases` VALUES ('495', '急性粟粒性结核病', '171', 'A19.251', 'JXSLXJHB', '1');
INSERT INTO `05diseases` VALUES ('496', '慢性粟粒性肺结核', '171', 'A19.801', 'MXSLXFJH', '1');
INSERT INTO `05diseases` VALUES ('497', '亚急性粟粒性肺结核', '171', 'A19.802', 'YJXSLXFJH', '1');
INSERT INTO `05diseases` VALUES ('498', '亚急性血行播散型肺结核', '171', 'A19.851', 'YJXXXBSXFJH', '1');
INSERT INTO `05diseases` VALUES ('499', '慢性结核性多浆膜炎', '171', 'A19.852', 'MXJHXDJMY', '1');
INSERT INTO `05diseases` VALUES ('500', '慢性血行播散型肺结核', '171', 'A19.853', 'MXXXBSXFJH', '1');
INSERT INTO `05diseases` VALUES ('501', '慢性多发性结核病', '171', 'A19.854', 'MXDFXJHB', '1');
INSERT INTO `05diseases` VALUES ('502', '粟粒性脑膜结核', '171', 'A19.855+', 'SLXNMJH', '1');
INSERT INTO `05diseases` VALUES ('503', '粟粒性结核病', '171', 'A19.901', 'SLXJHB', '1');
INSERT INTO `05diseases` VALUES ('504', '结核性多浆膜炎', '171', 'A19.902', 'JHXDJMY', '1');
INSERT INTO `05diseases` VALUES ('505', '进行性恶性多发性浆膜炎', '164', 'A19.903', 'JXXEXDFXJMY', '1');
INSERT INTO `05diseases` VALUES ('506', '全身性粟粒性结核病', '171', 'A19.904', 'QSXSLXJHB', '1');
INSERT INTO `05diseases` VALUES ('507', '多系统结核', '171', 'A19.951', 'DXTJH', '1');
INSERT INTO `05diseases` VALUES ('508', '多发性结核病', '171', 'A19.952', 'DFXJHB', '1');
INSERT INTO `05diseases` VALUES ('509', '腹股沟淋巴结炎性鼠疫', '335', 'A20.051', 'FGGLBJYXSY', '1');
INSERT INTO `05diseases` VALUES ('510', '蜂窝织皮下型鼠疫', '335', 'A20.151', 'FWZPXXSY', '1');
INSERT INTO `05diseases` VALUES ('511', '肺炎型鼠疫', '81', 'A20.251', 'FYXSY', '1');
INSERT INTO `05diseases` VALUES ('512', '继发性肺炎型鼠疫', '81', 'A20.252', 'JFXFYXSY', '1');
INSERT INTO `05diseases` VALUES ('513', '原发性肺炎型鼠疫', '81', 'A20.253', 'YFXFYXSY', '1');
INSERT INTO `05diseases` VALUES ('514', '鼠疫型脑膜炎', '232', 'A20.351', 'SYXNMY', '1');
INSERT INTO `05diseases` VALUES ('515', '败血症性鼠疫', '9', 'A20.751', 'BXZXSY', '1');
INSERT INTO `05diseases` VALUES ('516', '顿挫性鼠疫', '335', 'A20.851', 'DCXSY', '1');
INSERT INTO `05diseases` VALUES ('517', '无症状性鼠疫', '335', 'A20.852', 'WZZXSY', '1');
INSERT INTO `05diseases` VALUES ('518', '轻鼠疫', '335', 'A20.853', 'QSY', '1');
INSERT INTO `05diseases` VALUES ('519', '鼠疫 NOS', '335', 'A20.901', 'SY', '1');
INSERT INTO `05diseases` VALUES ('520', '溃疡淋巴腺型土拉菌病', '359', 'A21.051', 'KYLBXXTLJB', '1');
INSERT INTO `05diseases` VALUES ('521', '眼土拉菌病', '430', 'A21.151', 'YTLJB', '1');
INSERT INTO `05diseases` VALUES ('522', '眼腺型土拉菌病', '430', 'A21.152', 'YXXTLJB', '1');
INSERT INTO `05diseases` VALUES ('523', '肺土拉菌病', '359', 'A21.251', 'FTLJB', '1');
INSERT INTO `05diseases` VALUES ('524', '腹部土拉菌病', '359', 'A21.351', 'FBTLJB', '1');
INSERT INTO `05diseases` VALUES ('525', '胃肠土拉菌病', '370', 'A21.352', 'WCTLJB', '1');
INSERT INTO `05diseases` VALUES ('526', '全身性土拉菌病', '359', 'A21.751', 'QSXTLJB', '1');
INSERT INTO `05diseases` VALUES ('527', '其他形式的土拉菌病', '359', 'A21.851', 'QTXSDTLJB', '1');
INSERT INTO `05diseases` VALUES ('528', '兔热病', '268', 'A21.901', 'TRB', '1');
INSERT INTO `05diseases` VALUES ('529', '土拉菌热', '271', 'A21.951', 'TLJR', '1');
INSERT INTO `05diseases` VALUES ('530', '皮肤炭疽', '250', 'A22.051', 'PFTJ', '1');
INSERT INTO `05diseases` VALUES ('531', '恶性脓疱', '242', 'A22.052', 'EXNP', '1');
INSERT INTO `05diseases` VALUES ('532', '恶性痈', '451', 'A22.053', 'EXY', '1');
INSERT INTO `05diseases` VALUES ('533', '肺炭疽', '346', 'A22.101', 'FTJ', '1');
INSERT INTO `05diseases` VALUES ('534', '炭疽肺炎', '81', 'A22.102+', 'TJFY', '1');
INSERT INTO `05diseases` VALUES ('535', '恶性炭疽(栋毛工病))', '346', 'A22.151', 'EXTJDMGB', '1');
INSERT INTO `05diseases` VALUES ('536', '捡破烂人病', '268', 'A22.152', 'JPLRB', '1');
INSERT INTO `05diseases` VALUES ('537', '吸入性炭疽', '346', 'A22.153', 'XRXTJ', '1');
INSERT INTO `05diseases` VALUES ('538', '胃肠炭疽', '370', 'A22.251', 'WCTJ', '1');
INSERT INTO `05diseases` VALUES ('539', '肠炭疽', '346', 'A22.252', 'CTJ', '1');
INSERT INTO `05diseases` VALUES ('540', '炭疽性败血症', '9', 'A22.751', 'TJXBXZ', '1');
INSERT INTO `05diseases` VALUES ('541', '炭疽脑膜炎', '232', 'A22.851+', 'TJNMY', '1');
INSERT INTO `05diseases` VALUES ('542', '炭疽 NOS', '346', 'A22.901', 'TJ', '1');
INSERT INTO `05diseases` VALUES ('543', '直布罗陀热(西班牙)', '425', 'A23.051', 'ZBLTRXBY', '1');
INSERT INTO `05diseases` VALUES ('544', '地中海热', '271', 'A23.052', 'DZHR', '1');
INSERT INTO `05diseases` VALUES ('545', '马耳他布鲁氏菌病', '70', 'A23.053', 'METBLSJB', '1');
INSERT INTO `05diseases` VALUES ('546', '塞普路斯波状热', '271', 'A23.054', 'SPLSBZR', '1');
INSERT INTO `05diseases` VALUES ('547', '流产布鲁氏菌病', '215', 'A23.151', 'LCBLSJB', '1');
INSERT INTO `05diseases` VALUES ('548', '猪布鲁氏菌病', '215', 'A23.251', 'ZBLSJB', '1');
INSERT INTO `05diseases` VALUES ('549', '犬布鲁氏菌病', '215', 'A23.351', 'QBLSJB', '1');
INSERT INTO `05diseases` VALUES ('550', '其他布鲁氏菌病', '215', 'A23.851', 'QTBLSJB', '1');
INSERT INTO `05diseases` VALUES ('551', '布鲁氏杆菌病[波状热]', '188', 'A23.901', 'BLSGJBBZR', '1');
INSERT INTO `05diseases` VALUES ('552', '布鲁氏杆菌性关节炎', '123', 'A23.902+', 'BLSGJXGJY', '1');
INSERT INTO `05diseases` VALUES ('553', '布鲁氏杆菌性眼色素膜炎', '430', 'A23.903+', 'BLSGJXYSSMY', '1');
INSERT INTO `05diseases` VALUES ('554', '马耳他热', '70', 'A23.951', 'METR', '1');
INSERT INTO `05diseases` VALUES ('555', '鼻疽假单胞菌感染', '16', 'A24.051', 'BJJDBJGR', '1');
INSERT INTO `05diseases` VALUES ('556', '鼻疽', '16', 'A24.052', 'BJ', '1');
INSERT INTO `05diseases` VALUES ('557', '类鼻疽败血症', '16', 'A24.151', 'LBJBXZ', '1');
INSERT INTO `05diseases` VALUES ('558', '类炭疽肺炎', '81', 'A24.152', 'LTJFY', '1');
INSERT INTO `05diseases` VALUES ('559', '急性和暴发性类鼻疽', '16', 'A24.153', 'JXHBFXLBJ', '1');
INSERT INTO `05diseases` VALUES ('560', '慢性类鼻疽', '16', 'A24.251', 'MXLBJ', '1');
INSERT INTO `05diseases` VALUES ('561', '亚急性类鼻疽', '16', 'A24.252', 'YJXLBJ', '1');
INSERT INTO `05diseases` VALUES ('562', '其他类鼻疽', '16', 'A24.351', 'QTLBJ', '1');
INSERT INTO `05diseases` VALUES ('563', '假鼻疽假单胞菌感染', '16', 'A24.451', 'JBJJDBJGR', '1');
INSERT INTO `05diseases` VALUES ('564', '惠特莫尔热', '271', 'A24.452', 'HTMER', '1');
INSERT INTO `05diseases` VALUES ('565', '螺菌病', '188', 'A25.051', 'LJB', '1');
INSERT INTO `05diseases` VALUES ('566', '链杆菌病', '188', 'A25.151', 'LGJB', '1');
INSERT INTO `05diseases` VALUES ('567', '链杆菌性鼠咬热', '271', 'A25.152', 'LGJXSYR', '1');
INSERT INTO `05diseases` VALUES ('568', '流行性关节红斑[哈弗山]', '123', 'A25.153', 'LXXGJHBHFS', '1');
INSERT INTO `05diseases` VALUES ('569', '鼠咬热 NOS', '271', 'A25.901', 'SYR', '1');
INSERT INTO `05diseases` VALUES ('570', '皮肤类丹毒', '250', 'A26.051', 'PFLDD', '1');
INSERT INTO `05diseases` VALUES ('571', '游走性红斑', '250', 'A26.052', 'YZXHB', '1');
INSERT INTO `05diseases` VALUES ('572', '丹毒菌丝败血病', '8', 'A26.751', 'DDJSBXB', '1');
INSERT INTO `05diseases` VALUES ('573', '其他形式类丹毒', '278', 'A26.851', 'QTXSLDD', '1');
INSERT INTO `05diseases` VALUES ('574', '类丹毒 NOS', '278', 'A26.901', 'LDD', '1');
INSERT INTO `05diseases` VALUES ('575', '出血性黄疸钩端螺旋体病[菲尔德病]', '216', 'A27.001', 'CXXHDGDLXTBFEDB', '1');
INSERT INTO `05diseases` VALUES ('576', '流感伤寒型钩端螺旋体病', '306', 'A27.801', 'LGSHXGDLXTB', '1');
INSERT INTO `05diseases` VALUES ('577', '南方钩端螺旋体感染', '95', 'A27.802', 'NFGDLXTGR', '1');
INSERT INTO `05diseases` VALUES ('578', '波蒙纳钩端螺旋体病', '216', 'A27.851', 'BMNGDLXTB', '1');
INSERT INTO `05diseases` VALUES ('579', '犬钩端螺旋体病', '216', 'A27.852', 'QGDLXTB', '1');
INSERT INTO `05diseases` VALUES ('580', '七日热[钩端螺旋体病]', '216', 'A27.853', 'QRRGDLXTB', '1');
INSERT INTO `05diseases` VALUES ('581', '钩端螺旋体脑膜炎', '232', 'A27.854+', 'GDLXTNMY', '1');
INSERT INTO `05diseases` VALUES ('582', '钩端螺旋体病 NOS', '216', 'A27.901', 'GDLXTB', '1');
INSERT INTO `05diseases` VALUES ('583', '巴斯德菌病', '188', 'A28.051', 'BSDJB', '1');
INSERT INTO `05diseases` VALUES ('584', '猫抓病(热)', '268', 'A28.101', 'MZBR', '1');
INSERT INTO `05diseases` VALUES ('585', '肠外耶尔森菌病', '188', 'A28.251', 'CWYESJB', '1');
INSERT INTO `05diseases` VALUES ('586', '其他特指的动物传染的细菌性疾病，NEC', '380', 'A28.851', 'QTTZDDWCRDXJXJB', '1');
INSERT INTO `05diseases` VALUES ('587', '动物传染的细菌性疾病 NOS', '380', 'A28.951', 'DWCRDXJXJB', '1');
INSERT INTO `05diseases` VALUES ('588', 'Ⅰ型麻风', '218', 'A30.051', 'YXMF', '1');
INSERT INTO `05diseases` VALUES ('589', '未定型麻风', '218', 'A30.052', 'WDXMF', '1');
INSERT INTO `05diseases` VALUES ('590', '类结核型麻风', '171', 'A30.101', 'LJHXMF', '1');
INSERT INTO `05diseases` VALUES ('591', 'ＴＴ型麻风', '218', 'A30.151', 'XMF', '1');
INSERT INTO `05diseases` VALUES ('592', '结核样型麻风', '171', 'A30.152', 'JHYXMF', '1');
INSERT INTO `05diseases` VALUES ('593', 'ＢＴ型麻风', '218', 'A30.251', 'XMF', '1');
INSERT INTO `05diseases` VALUES ('594', '近结核样型中间型麻风', '171', 'A30.252', 'JJHYXZJXMF', '1');
INSERT INTO `05diseases` VALUES ('595', '中间型麻风', '218', 'A30.351', 'ZJXMF', '1');
INSERT INTO `05diseases` VALUES ('596', 'ＢＢ型麻风', '218', 'A30.352', 'XMF', '1');
INSERT INTO `05diseases` VALUES ('597', '双型性(浸润性)(神经炎性)麻风', '313', 'A30.353', 'SXXJRXSJYXMF', '1');
INSERT INTO `05diseases` VALUES ('598', '混合性麻风', '218', 'A30.354', 'HHXMF', '1');
INSERT INTO `05diseases` VALUES ('599', '近瘤型中间型麻风', '218', 'A30.451', 'JLXZJXMF', '1');
INSERT INTO `05diseases` VALUES ('600', 'ＢＬ型麻风', '218', 'A30.452', 'XMF', '1');
INSERT INTO `05diseases` VALUES ('601', '瘤型麻风', '218', 'A30.501', 'LXMF', '1');
INSERT INTO `05diseases` VALUES ('602', 'ＬＬ型麻风', '218', 'A30.551', 'XMF', '1');
INSERT INTO `05diseases` VALUES ('603', '结节性麻风', '218', 'A30.552', 'JJXMF', '1');
INSERT INTO `05diseases` VALUES ('604', '其他特指形式麻风', '218', 'A30.851', 'QTTZXSMF', '1');
INSERT INTO `05diseases` VALUES ('605', '麻风 NOS', '218', 'A30.901', 'MF', '1');
INSERT INTO `05diseases` VALUES ('606', '斑疹性麻风', '218', 'A30.951', 'BZXMF', '1');
INSERT INTO `05diseases` VALUES ('607', '麻木型麻风', '218', 'A30.952', 'MMXMF', '1');
INSERT INTO `05diseases` VALUES ('608', '神经型麻风', '313', 'A30.953', 'SJXMF', '1');
INSERT INTO `05diseases` VALUES ('609', '肺非典型分支杆菌病', '188', 'A31.001', 'FFDXFZGJB', '1');
INSERT INTO `05diseases` VALUES ('610', '肺分支杆菌感染', '95', 'A31.002', 'FFZGJGR', '1');
INSERT INTO `05diseases` VALUES ('611', '细胞内[巴蒂杆菌]分支杆菌感染', '95', 'A31.053', 'XBNBDGJFZGJGR', '1');
INSERT INTO `05diseases` VALUES ('612', '鸟型结核分支杆菌感染', '171', 'A31.054', 'NXJHFZGJGR', '1');
INSERT INTO `05diseases` VALUES ('613', '皮肤分枝杆菌感染', '250', 'A31.151', 'PFFZGJGR', '1');
INSERT INTO `05diseases` VALUES ('614', '伯鲁里溃疡', '195', 'A31.152', 'BLLKY', '1');
INSERT INTO `05diseases` VALUES ('615', '溃疡分支杆菌感染', '95', 'A31.153', 'KYFZGJGR', '1');
INSERT INTO `05diseases` VALUES ('616', '次要分支杆菌感染', '95', 'A31.851', 'CYFZGJGR', '1');
INSERT INTO `05diseases` VALUES ('617', '土分枝杆菌属感染', '95', 'A31.852', 'TFZGJSGR', '1');
INSERT INTO `05diseases` VALUES ('618', '偶发分支杆菌感染', '95', 'A31.853', 'OFFZGJGR', '1');
INSERT INTO `05diseases` VALUES ('619', '非典型性分枝杆菌感染 NOS', '95', 'A31.901', 'FDXXFZGJGR', '1');
INSERT INTO `05diseases` VALUES ('620', '麻风分支杆菌感染', '218', 'A31.951', 'MFFZGJGR', '1');
INSERT INTO `05diseases` VALUES ('621', '分枝杆菌病', '188', 'A31.952', 'FZGJB', '1');
INSERT INTO `05diseases` VALUES ('622', '皮肤利斯特菌病', '250', 'A32.051', 'PFLSTJB', '1');
INSERT INTO `05diseases` VALUES ('623', '利斯特菌性单核细胞增多症脑膜炎(基底)(大脑)', '232', 'A32.151+', 'LSTJXDHXBZDZNMYJDDN', '1');
INSERT INTO `05diseases` VALUES ('624', '利斯特菌脑炎、脊髓炎和脑脊髓炎', '234', 'A32.152+', 'LSTJNYJSYHNJSY', '1');
INSERT INTO `05diseases` VALUES ('625', '利斯特菌性脑膜脑炎', '232', 'A32.153+', 'LSTJXNMNY', '1');
INSERT INTO `05diseases` VALUES ('626', '利斯特菌败血病', '8', 'A32.751', 'LSTJBXB', '1');
INSERT INTO `05diseases` VALUES ('627', '利斯特菌心内膜炎', '401', 'A32.851+', 'LSTJXNMY', '1');
INSERT INTO `05diseases` VALUES ('628', '利斯特菌病性大脑动脉炎', '234', 'A32.852+', 'LSTJBXDNDMY', '1');
INSERT INTO `05diseases` VALUES ('629', '眼腺利斯特菌病', '430', 'A32.853', 'YXLSTJB', '1');
INSERT INTO `05diseases` VALUES ('630', '利斯特菌病[李司忒氏菌病] NOS', '188', 'A32.901', 'LSTJBLSTSJB', '1');
INSERT INTO `05diseases` VALUES ('631', '新生儿破伤风', '257', 'A33.X01', 'XSEPSF', '1');
INSERT INTO `05diseases` VALUES ('632', '产后(产褥期)(分娩)破伤风', '257', 'A34.X51', 'CHCRQFMPSF', '1');
INSERT INTO `05diseases` VALUES ('633', '破伤风伴有流产或异位妊娠', '257', 'A34.X52', 'PSFBYLCHYWRS', '1');
INSERT INTO `05diseases` VALUES ('634', '破伤风 NOS', '257', 'A35.X01', 'PSF', '1');
INSERT INTO `05diseases` VALUES ('635', '强直性破伤风', '257', 'A35.X51', 'QZXPSF', '1');
INSERT INTO `05diseases` VALUES ('636', '白喉性扁桃体炎', '133', 'A36.051', 'BHXBTTY', '1');
INSERT INTO `05diseases` VALUES ('637', '扁桃体白喉', '133', 'A36.052', 'BTTBH', '1');
INSERT INTO `05diseases` VALUES ('638', '白喉性膜性喉炎', '133', 'A36.053', 'BHXMXHY', '1');
INSERT INTO `05diseases` VALUES ('639', '白喉性膜性峡炎', '133', 'A36.054', 'BHXMXXY', '1');
INSERT INTO `05diseases` VALUES ('640', '咽白喉', '133', 'A36.055', 'YBH', '1');
INSERT INTO `05diseases` VALUES ('641', '鼻咽白喉', '133', 'A36.101', 'BYBH', '1');
INSERT INTO `05diseases` VALUES ('642', '喉白喉', '133', 'A36.201', 'HBH', '1');
INSERT INTO `05diseases` VALUES ('643', '白喉性喉气管炎', '133', 'A36.251', 'BHXHQGY', '1');
INSERT INTO `05diseases` VALUES ('644', '皮肤白喉', '133', 'A36.301', 'PFBH', '1');
INSERT INTO `05diseases` VALUES ('645', '白喉感染伤口', '133', 'A36.352', 'BHGRSK', '1');
INSERT INTO `05diseases` VALUES ('646', '播散性白喉', '133', 'A36.801', 'BSXBH', '1');
INSERT INTO `05diseases` VALUES ('647', '白喉性多神经炎', '313', 'A36.802+', 'BHXDSJY', '1');
INSERT INTO `05diseases` VALUES ('648', '白喉性心肌炎', '133', 'A36.803+', 'BHXXJY', '1');
INSERT INTO `05diseases` VALUES ('649', '前鼻白喉', '133', 'A36.851', 'QBBH', '1');
INSERT INTO `05diseases` VALUES ('650', '白喉性结膜炎', '133', 'A36.852+', 'BHXJMY', '1');
INSERT INTO `05diseases` VALUES ('651', '白喉性心内膜炎', '133', 'A36.853+', 'BHXXNMY', '1');
INSERT INTO `05diseases` VALUES ('652', '白喉 NOS', '133', 'A36.901', 'BH', '1');
INSERT INTO `05diseases` VALUES ('653', '出血性白喉', '133', 'A36.951', 'CXXBH', '1');
INSERT INTO `05diseases` VALUES ('654', '坏疽性白喉', '133', 'A36.952', 'HJXBH', '1');
INSERT INTO `05diseases` VALUES ('655', '博德特杆菌百日咳', '7', 'A37.051', 'BDTGJBRK', '1');
INSERT INTO `05diseases` VALUES ('656', '副百日咳博代氏杆菌百日咳', '7', 'A37.151', 'FBRKBDSGJBRK', '1');
INSERT INTO `05diseases` VALUES ('657', '类百日咳[副百日咳]', '7', 'A37.152', 'LBRKFBRK', '1');
INSERT INTO `05diseases` VALUES ('658', '博德特杆菌支气管败血性百日咳', '279', 'A37.851', 'BDTGJZQGBXXBRK', '1');
INSERT INTO `05diseases` VALUES ('659', '百日咳 NOS', '7', 'A37.901', 'BRK', '1');
INSERT INTO `05diseases` VALUES ('660', '百日咳合并肺炎', '81', 'A37.902+', 'BRKHBFY', '1');
INSERT INTO `05diseases` VALUES ('661', '猩红热', '271', 'A38.X01', 'XHR', '1');
INSERT INTO `05diseases` VALUES ('662', '猩红热心肌炎', '397', 'A38.X51+', 'XHRXJY', '1');
INSERT INTO `05diseases` VALUES ('663', '脑膜炎球菌性脑膜炎', '232', 'A39.001+', 'NMYQJXNMY', '1');
INSERT INTO `05diseases` VALUES ('664', '脑脊膜炎', '234', 'A39.002+', 'NJMY', '1');
INSERT INTO `05diseases` VALUES ('665', '双球菌性脑膜炎', '232', 'A39.051+', 'SQJXNMY', '1');
INSERT INTO `05diseases` VALUES ('666', '流行性脑膜炎', '232', 'A39.052+', 'LXXNMY', '1');
INSERT INTO `05diseases` VALUES ('667', '沃－弗综合征(脑膜炎球菌性)', '232', 'A39.151+', 'WFZHZNMYQJX', '1');
INSERT INTO `05diseases` VALUES ('668', '脑膜炎球菌性出血性肾上腺炎', '232', 'A39.152', 'NMYQJXCXXSSXY', '1');
INSERT INTO `05diseases` VALUES ('669', '脑膜炎球菌性肾上腺综合征', '232', 'A39.153', 'NMYQJXSSXZHZ', '1');
INSERT INTO `05diseases` VALUES ('670', '急性脑膜炎球菌血症', '232', 'A39.251', 'JXNMYQJXZ', '1');
INSERT INTO `05diseases` VALUES ('671', '慢性脑膜炎球菌血症', '232', 'A39.351', 'MXNMYQJXZ', '1');
INSERT INTO `05diseases` VALUES ('672', '脑膜炎球菌性败血症', '232', 'A39.401', 'NMYQJXBXZ', '1');
INSERT INTO `05diseases` VALUES ('673', '脑膜炎球菌性脑炎', '232', 'A39.551+', 'NMYQJXNY', '1');
INSERT INTO `05diseases` VALUES ('674', '脑膜炎球菌性心包炎', '232', 'A39.552+', 'NMYQJXXBY', '1');
INSERT INTO `05diseases` VALUES ('675', '脑膜炎球菌性心内膜炎', '232', 'A39.553+', 'NMYQJXXNMY', '1');
INSERT INTO `05diseases` VALUES ('676', '脑膜炎球菌性心肌炎', '232', 'A39.554+', 'NMYQJXXJY', '1');
INSERT INTO `05diseases` VALUES ('677', '脑膜炎球菌性心炎', '232', 'A39.555+', 'NMYQJXXY', '1');
INSERT INTO `05diseases` VALUES ('678', '流行性脑膜脑炎', '232', 'A39.851+', 'LXXNMNY', '1');
INSERT INTO `05diseases` VALUES ('679', '暴发性脑膜炎球菌脑膜脑炎[流行性脑脊髓膜炎]', '232', 'A39.852+', 'BFXNMYQJNMNYLXXNJSMY', '1');
INSERT INTO `05diseases` VALUES ('680', '脑膜炎球菌脑炎、脊髓炎和脑脊髓炎', '232', 'A39.853+', 'NMYQJNYJSYHNJSY', '1');
INSERT INTO `05diseases` VALUES ('681', '脑膜炎球菌性结膜炎', '232', 'A39.854+', 'NMYQJXJMY', '1');
INSERT INTO `05diseases` VALUES ('682', '脑膜炎球菌性视神经炎', '313', 'A39.855+', 'NMYQJXSSJY', '1');
INSERT INTO `05diseases` VALUES ('683', '脑膜炎球菌性球后视神经炎', '313', 'A39.856+', 'NMYQJXQHSSJY', '1');
INSERT INTO `05diseases` VALUES ('684', '脑膜炎双球菌性关节炎', '123', 'A39.857+', 'NMYSQJXGJY', '1');
INSERT INTO `05diseases` VALUES ('685', '脑膜炎球菌感染后关节炎', '123', 'A39.858+', 'NMYQJGRHGJY', '1');
INSERT INTO `05diseases` VALUES ('686', '脑膜炎球菌病 NOS', '232', 'A39.951', 'NMYQJB', '1');
INSERT INTO `05diseases` VALUES ('687', 'Ａ族链球菌引起的败血病', '8', 'A40.051', 'ZLQJYQDBXB', '1');
INSERT INTO `05diseases` VALUES ('688', '链球菌性生脓性败血病', '8', 'A40.052', 'LQJXSNXBXB', '1');
INSERT INTO `05diseases` VALUES ('689', 'Ｂ族链球菌引起的败血病', '8', 'A40.151', 'ZLQJYQDBXB', '1');
INSERT INTO `05diseases` VALUES ('690', '链球菌性无乳性败血病', '8', 'A40.152', 'LQJXWRXBXB', '1');
INSERT INTO `05diseases` VALUES ('691', 'Ｄ族链球菌引起的败血病', '8', 'A40.251', 'ZLQJYQDBXB', '1');
INSERT INTO `05diseases` VALUES ('692', '肺炎球菌性败血症', '81', 'A40.301', 'FYQJXBXZ', '1');
INSERT INTO `05diseases` VALUES ('693', '其他链球菌性败血病', '8', 'A40.851', 'QTLQJXBXB', '1');
INSERT INTO `05diseases` VALUES ('694', '链球菌性败血症 NOS', '9', 'A40.901', 'LQJXBXZ', '1');
INSERT INTO `05diseases` VALUES ('695', '金黄色酿脓葡萄球菌引起的败血病', '8', 'A41.051', 'JHSNNPTQJYQDBXB', '1');
INSERT INTO `05diseases` VALUES ('696', '凝固阴性葡萄球菌引起的败血病', '8', 'A41.151', 'NGYXPTQJYQDBXB', '1');
INSERT INTO `05diseases` VALUES ('697', '葡萄球菌菌血病', '189', 'A41.201', 'PTQJJXB', '1');
INSERT INTO `05diseases` VALUES ('698', '葡萄球菌性败血症', '9', 'A41.202', 'PTQJXBXZ', '1');
INSERT INTO `05diseases` VALUES ('699', '流感嗜血杆引起的败血病', '8', 'A41.351', 'LGSXGYQDBXB', '1');
INSERT INTO `05diseases` VALUES ('700', '厌氧菌性败血病', '8', 'A41.451', 'YYJXBXB', '1');
INSERT INTO `05diseases` VALUES ('701', '变形杆菌性败血症', '9', 'A41.501', 'BXGJXBXZ', '1');
INSERT INTO `05diseases` VALUES ('702', '大肠埃希氏杆菌性败血症', '9', 'A41.502', 'DCAXSGJXBXZ', '1');
INSERT INTO `05diseases` VALUES ('703', '大肠杆菌性败血症', '9', 'A41.503', 'DCGJXBXZ', '1');
INSERT INTO `05diseases` VALUES ('704', '革兰氏阴性杆菌败血症', '9', 'A41.504', 'GLSYXGJBXZ', '1');
INSERT INTO `05diseases` VALUES ('705', '假单胞菌性败血症', '9', 'A41.505', 'JDBJXBXZ', '1');
INSERT INTO `05diseases` VALUES ('706', '克雷白氏杆菌性败血症', '9', 'A41.506', 'KLBSGJXBXZ', '1');
INSERT INTO `05diseases` VALUES ('707', '枯草杆菌性败血症', '9', 'A41.507', 'KCGJXBXZ', '1');
INSERT INTO `05diseases` VALUES ('708', '绿脓杆菌性败血症', '9', 'A41.508', 'LNGJXBXZ', '1');
INSERT INTO `05diseases` VALUES ('709', '粘球杆菌性败血症', '9', 'A41.509', 'NQGJXBXZ', '1');
INSERT INTO `05diseases` VALUES ('710', '痢疾杆菌败血病', '200', 'A41.551', 'LJGJBXB', '1');
INSERT INTO `05diseases` VALUES ('711', '肠球菌性败血病', '8', 'A41.552', 'CQJXBXB', '1');
INSERT INTO `05diseases` VALUES ('712', '其他革兰氏阴性病原体引起的败血病', '8', 'A41.553', 'QTGLSYXBYTYQDBXB', '1');
INSERT INTO `05diseases` VALUES ('714', '类酵母菌败血症', '9', 'A41.802', 'LJMJBXZ', '1');
INSERT INTO `05diseases` VALUES ('715', '霉菌性败血症', '9', 'A41.803', 'MJXBXZ', '1');
INSERT INTO `05diseases` VALUES ('716', '其他特指的败血症', '9', 'A41.804', 'QTTZDBXZ', '1');
INSERT INTO `05diseases` VALUES ('717', '真菌败血症', '464', 'A41.805', 'ZJBXZ', '1');
INSERT INTO `05diseases` VALUES ('718', '败血症 NOS', '9', 'A41.901', 'BXZ', '1');
INSERT INTO `05diseases` VALUES ('719', '脓毒败血症', '9', 'A41.902', 'NDBXZ', '1');
INSERT INTO `05diseases` VALUES ('720', '坏疽性败血病', '8', 'A41.951', 'HJXBXB', '1');
INSERT INTO `05diseases` VALUES ('721', '败血病性休克', '8', 'A41.953', 'BXBXXK', '1');
INSERT INTO `05diseases` VALUES ('722', '脓毒性休克[感染性休克；中毒性休克]', '95', 'A41.954', 'NDXXKGRXXKZDXXK', '1');
INSERT INTO `05diseases` VALUES ('723', '肺放线菌病', '188', 'A42.001', 'FFXJB', '1');
INSERT INTO `05diseases` VALUES ('724', '放线菌病伴有肺炎', '81', 'A42.052+', 'FXJBBYFY', '1');
INSERT INTO `05diseases` VALUES ('725', '腹放线菌病', '188', 'A42.151', 'FFXJB', '1');
INSERT INTO `05diseases` VALUES ('726', '胃肠放线菌病', '370', 'A42.152', 'WCFXJB', '1');
INSERT INTO `05diseases` VALUES ('727', '颈面部放线菌病', '188', 'A42.201', 'GMBFXJB', '1');
INSERT INTO `05diseases` VALUES ('728', '放线菌病性败血病', '8', 'A42.751', 'FXJBXBXB', '1');
INSERT INTO `05diseases` VALUES ('729', '乳腺放线菌病', '188', 'A42.801', 'RXFXJB', '1');
INSERT INTO `05diseases` VALUES ('730', '胸部放线菌病', '188', 'A42.851', 'XBFXJB', '1');
INSERT INTO `05diseases` VALUES ('731', '皮肤放线菌病', '250', 'A42.852', 'PFFXJB', '1');
INSERT INTO `05diseases` VALUES ('732', '放线菌病 NOS', '188', 'A42.901', 'FXJB', '1');
INSERT INTO `05diseases` VALUES ('733', '肺诺卡氏菌病', '188', 'A43.001+', 'FNKSJB', '1');
INSERT INTO `05diseases` VALUES ('734', '肺炎诺卡菌病', '81', 'A43.051+', 'FYNKJB', '1');
INSERT INTO `05diseases` VALUES ('735', '皮肤诺卡[放线]菌病', '250', 'A43.151', 'PFNKFXJB', '1');
INSERT INTO `05diseases` VALUES ('736', '其他形式诺卡[放线]菌病', '188', 'A43.851', 'QTXSNKFXJB', '1');
INSERT INTO `05diseases` VALUES ('737', '诺卡氏[放线]菌病 NOS', '188', 'A43.901', 'NKSFXJB', '1');
INSERT INTO `05diseases` VALUES ('738', '全身性巴尔通体热', '271', 'A44.051', 'QSXBETTR', '1');
INSERT INTO `05diseases` VALUES ('739', '奥罗亚热', '271', 'A44.052', 'ALYR', '1');
INSERT INTO `05diseases` VALUES ('740', '皮肤巴尔通体病', '250', 'A44.151', 'PFBETTB', '1');
INSERT INTO `05diseases` VALUES ('741', '粘膜皮肤巴尔通体病', '250', 'A44.152', 'NMPFBETTB', '1');
INSERT INTO `05diseases` VALUES ('742', '其他形式的巴尔通体病', '268', 'A44.851', 'QTXSDBETTB', '1');
INSERT INTO `05diseases` VALUES ('743', '巴尔通体病 NOS', '268', 'A44.951', 'BETTB', '1');
INSERT INTO `05diseases` VALUES ('744', '丹毒', '278', 'A46.X01', 'DD', '1');
INSERT INTO `05diseases` VALUES ('745', '眼睑丹毒', '430', 'A46.X51', 'YJDD', '1');
INSERT INTO `05diseases` VALUES ('746', '外耳丹毒', '70', 'A46.X52+', 'WEDD', '1');
INSERT INTO `05diseases` VALUES ('747', '气性坏疽', '187', 'A48.001', 'QXHJ', '1');
INSERT INTO `05diseases` VALUES ('748', '梭状芽胞杆菌感染肌炎', '95', 'A48.051', 'SZYBGJGRJY', '1');
INSERT INTO `05diseases` VALUES ('749', '梭状芽胞杆菌性蜂窝组织炎', '84', 'A48.052', 'SZYBGJXFWZZY', '1');
INSERT INTO `05diseases` VALUES ('750', '梭状芽胞杆菌性肌坏死', '267', 'A48.053', 'SZYBGJXJHS', '1');
INSERT INTO `05diseases` VALUES ('751', '军团病', '268', 'A48.101', 'JTB', '1');
INSERT INTO `05diseases` VALUES ('752', '军团肺炎', '81', 'A48.151+', 'JTFY', '1');
INSERT INTO `05diseases` VALUES ('753', '非肺炎的军团病[庞蒂亚克热]', '81', 'A48.251', 'FFYDJTBPDYKR', '1');
INSERT INTO `05diseases` VALUES ('754', '中毒性休克综合征', '410', 'A48.351', 'ZDXXKZHZ', '1');
INSERT INTO `05diseases` VALUES ('755', '巴西紫热', '271', 'A48.451', 'BXZR', '1');
INSERT INTO `05diseases` VALUES ('756', '鼻硬结病[呼吸道硬结病]', '16', 'A48.801', 'BYJBHXDYJB', '1');
INSERT INTO `05diseases` VALUES ('757', '坏死性杆菌病', '188', 'A48.802', 'HSXGJB', '1');
INSERT INTO `05diseases` VALUES ('758', '金黄色葡萄球菌感染', '95', 'A49.001', 'JHSPTQJGR', '1');
INSERT INTO `05diseases` VALUES ('759', '葡萄球菌感染', '95', 'A49.002', 'PTQJGR', '1');
INSERT INTO `05diseases` VALUES ('760', '肺炎球菌感染', '81', 'A49.101', 'FYQJGR', '1');
INSERT INTO `05diseases` VALUES ('761', '链球菌感染', '95', 'A49.102', 'LQJGR', '1');
INSERT INTO `05diseases` VALUES ('762', '链球菌感染综合症', '95', 'A49.103', 'LQJGRZHZ', '1');
INSERT INTO `05diseases` VALUES ('763', '流感嗜血杆菌感染(H.流感杆菌)', '95', 'A49.201', 'LGSXGJGRLGGJ', '1');
INSERT INTO `05diseases` VALUES ('764', '支原体感染', '95', 'A49.301', 'ZYTGR', '1');
INSERT INTO `05diseases` VALUES ('765', '变形杆菌感染', '95', 'A49.801', 'BXGJGR', '1');
INSERT INTO `05diseases` VALUES ('766', '大肠埃希氏杆菌感染(大肠杆菌)', '95', 'A49.802', 'DCAXSGJGRDCGJ', '1');
INSERT INTO `05diseases` VALUES ('767', '弗里德兰德氏杆菌感染(肺炎杆菌)', '81', 'A49.803', 'FLDLDSGJGRFYGJ', '1');
INSERT INTO `05diseases` VALUES ('768', '假单胞菌感染', '95', 'A49.804', 'JDBJGR', '1');
INSERT INTO `05diseases` VALUES ('769', '克雷白氏肺炎杆菌感染', '81', 'A49.805', 'KLBSFYGJGR', '1');
INSERT INTO `05diseases` VALUES ('770', '克雷白氏杆菌感染', '95', 'A49.806', 'KLBSGJGR', '1');
INSERT INTO `05diseases` VALUES ('771', '雷极氏普鲁菲登氏菌感染', '95', 'A49.807', 'LJSPLFDSJGR', '1');
INSERT INTO `05diseases` VALUES ('772', '绿脓杆菌感染', '95', 'A49.808', 'LNGJGR', '1');
INSERT INTO `05diseases` VALUES ('773', '螺旋杆菌感染', '95', 'A49.809', 'LXGJGR', '1');
INSERT INTO `05diseases` VALUES ('774', '其他特指的细菌感染', '380', 'A49.810', 'QTTZDXJGR', '1');
INSERT INTO `05diseases` VALUES ('775', '沙雷氏菌感染', '95', 'A49.811', 'SLSJGR', '1');
INSERT INTO `05diseases` VALUES ('776', '幽门螺旋杆菌感染', '95', 'A49.812', 'YMLXGJGR', '1');
INSERT INTO `05diseases` VALUES ('777', '菌血症 NOS', '275', 'A49.901', 'JXZ', '1');
INSERT INTO `05diseases` VALUES ('778', '细菌性感染', '380', 'A49.902', 'XJXGR', '1');
INSERT INTO `05diseases` VALUES ('779', '革兰氏阴性杆菌感染', '95', 'A49.951', 'GLSYXGJGR', '1');
INSERT INTO `05diseases` VALUES ('780', '气球菌感染', '95', 'A49.952', 'QQJGR', '1');
INSERT INTO `05diseases` VALUES ('781', '白色肺炎(先天性梅毒的肺部病变)', '81', 'A50.051', 'BSFYXTXMDDFBBB', '1');
INSERT INTO `05diseases` VALUES ('782', '皮肤的早期先天性梅毒', '250', 'A50.052', 'PFDZQXTXMD', '1');
INSERT INTO `05diseases` VALUES ('783', '粘膜皮肤的早期先天性梅毒', '250', 'A50.053', 'NMPFDZQXTXMD', '1');
INSERT INTO `05diseases` VALUES ('784', '内脏的早期先天性梅毒', '225', 'A50.054', 'NZDZQXTXMD', '1');
INSERT INTO `05diseases` VALUES ('785', '早期先天性梅毒性喉炎', '133', 'A50.055', 'ZQXTXMDXHY', '1');
INSERT INTO `05diseases` VALUES ('786', '早期先天性梅毒性眼病', '430', 'A50.056', 'ZQXTXMDXYB', '1');
INSERT INTO `05diseases` VALUES ('787', '早期先天性梅毒性骨软骨病', '300', 'A50.057', 'ZQXTXMDXGRGB', '1');
INSERT INTO `05diseases` VALUES ('788', '早期先天性梅毒性咽炎', '429', 'A50.058', 'ZQXTXMDXYY', '1');
INSERT INTO `05diseases` VALUES ('789', '早期先天性梅毒性肺炎', '81', 'A50.059', 'ZQXTXMDXFY', '1');
INSERT INTO `05diseases` VALUES ('790', '早期先天性梅毒性鼻炎', '16', 'A50.060', 'ZQXTXMDXBY', '1');
INSERT INTO `05diseases` VALUES ('791', '潜伏性早期先天性梅毒(出生后二年内无临床表现)', '225', 'A50.151', 'QFXZQXTXMDCSHENNWLCB', '1');
INSERT INTO `05diseases` VALUES ('792', '未特指的早期先天性梅毒(出生后二年内)', '225', 'A50.251', 'WTZDZQXTXMDCSHENN', '1');
INSERT INTO `05diseases` VALUES ('793', '点状角膜炎', '167', 'A50.301+', 'DZJMY', '1');
INSERT INTO `05diseases` VALUES ('794', '梅毒性深层点状角膜炎', '167', 'A50.302+', 'MDXSCDZJMY', '1');
INSERT INTO `05diseases` VALUES ('795', '晚期先天性梅毒性间质性角膜炎', '167', 'A50.351+', 'WQXTXMDXJZXJMY', '1');
INSERT INTO `05diseases` VALUES ('796', '晚期先天性梅毒性眼病', '430', 'A50.352+', 'WQXTXMDXYB', '1');
INSERT INTO `05diseases` VALUES ('797', '晚期先天性神经梅毒[幼年型神经梅毒]', '313', 'A50.451', 'WQXTXSJMDYNXSJMD', '1');
INSERT INTO `05diseases` VALUES ('798', '晚期先天性梅毒性脑膜炎', '232', 'A50.452+', 'WQXTXMDXNMY', '1');
INSERT INTO `05diseases` VALUES ('799', '晚期先天性梅毒性脑炎', '234', 'A50.453+', 'WQXTXMDXNY', '1');
INSERT INTO `05diseases` VALUES ('800', '晚期先天性梅毒性多神经病', '313', 'A50.454+', 'WQXTXMDXDSJB', '1');
INSERT INTO `05diseases` VALUES ('801', '幼年型麻痹性痴呆', '34', 'A50.455', 'YNXMBXCD', '1');
INSERT INTO `05diseases` VALUES ('802', '幼年型脊髓痨', '152', 'A50.456', 'YNXJSL', '1');
INSERT INTO `05diseases` VALUES ('803', '幼年型脊髓痨麻痹性神经梅毒', '313', 'A50.457', 'YNXJSLMBXSJMD', '1');
INSERT INTO `05diseases` VALUES ('804', '梅毒性牙(赫秦生氏牙)', '425', 'A50.501', 'MDXYHQSSY', '1');
INSERT INTO `05diseases` VALUES ('805', '梅毒性鞍鼻', '16', 'A50.551', 'MDXAB', '1');
INSERT INTO `05diseases` VALUES ('806', '哈钦森三联症', '278', 'A50.552', 'HQSSLZ', '1');
INSERT INTO `05diseases` VALUES ('807', '哈钦森牙(先天性梅毒)', '425', 'A50.553', 'HQSYXTXMD', '1');
INSERT INTO `05diseases` VALUES ('808', '晚期性先天性心血管梅毒', '402', 'A50.554+', 'WQXXTXXXGMD', '1');
INSERT INTO `05diseases` VALUES ('809', '梅毒性关节病', '123', 'A50.555+', 'MDXGJB', '1');
INSERT INTO `05diseases` VALUES ('810', '梅毒性骨软骨病', '300', 'A50.556+', 'MDXGRGB', '1');
INSERT INTO `05diseases` VALUES ('811', '先天性梅毒 NOS', '225', 'A50.901', 'XTXMD', '1');
INSERT INTO `05diseases` VALUES ('812', '初期生殖器梅毒', '230', 'A51.051', 'CQSZQMD', '1');
INSERT INTO `05diseases` VALUES ('813', '梅毒性下疳', '381', 'A51.052', 'MDXXG', '1');
INSERT INTO `05diseases` VALUES ('814', '尿道下疳', '381', 'A51.053', 'NDXG', '1');
INSERT INTO `05diseases` VALUES ('815', '硬下疳', '381', 'A51.054', 'YXG', '1');
INSERT INTO `05diseases` VALUES ('816', '初期肛门梅毒', '225', 'A51.151', 'CQGMMD', '1');
INSERT INTO `05diseases` VALUES ('817', '唇下疳', '381', 'A51.251', 'CXG', '1');
INSERT INTO `05diseases` VALUES ('818', '结膜下疳', '381', 'A51.252', 'JMXG', '1');
INSERT INTO `05diseases` VALUES ('819', '乳头下疳', '86', 'A51.253', 'RTXG', '1');
INSERT INTO `05diseases` VALUES ('820', '外生殖器的下疳', '230', 'A51.254', 'WSZQDXG', '1');
INSERT INTO `05diseases` VALUES ('821', '皮肤二期梅毒', '250', 'A51.301', 'PFEQMD', '1');
INSERT INTO `05diseases` VALUES ('822', '皮肤梅毒(早期)(伴有溃疡)', '250', 'A51.302', 'PFMDZQBYKY', '1');
INSERT INTO `05diseases` VALUES ('823', '梅毒性湿疣', '319', 'A51.351', 'MDXSY', '1');
INSERT INTO `05diseases` VALUES ('824', '梅毒性粘膜斑', '461', 'A51.352', 'MDXNMB', '1');
INSERT INTO `05diseases` VALUES ('825', '梅毒性白斑病', '3', 'A51.354+', 'MDXBBB', '1');
INSERT INTO `05diseases` VALUES ('826', '梅毒性脱发', '363', 'A51.355+', 'MDXTF', '1');
INSERT INTO `05diseases` VALUES ('827', '二期梅毒', '225', 'A51.401', 'EQMD', '1');
INSERT INTO `05diseases` VALUES ('828', '梅毒性脉络膜视网膜炎', '327', 'A51.402+', 'MDXMLMSWMY', '1');
INSERT INTO `05diseases` VALUES ('829', '二期梅毒性淋巴结病', '206', 'A51.451', 'EQMDXLBJB', '1');
INSERT INTO `05diseases` VALUES ('830', '二期梅毒性脑膜炎', '232', 'A51.452+', 'EQMDXNMY', '1');
INSERT INTO `05diseases` VALUES ('831', '二期梅毒性虹膜睫状体炎', '229', 'A51.453+', 'EQMDXHMJZTY', '1');
INSERT INTO `05diseases` VALUES ('832', '二期梅毒性眼病', '430', 'A51.455+', 'EQMDXYB', '1');
INSERT INTO `05diseases` VALUES ('833', '二期梅毒性肌炎', '146', 'A51.456+', 'EQMDXJY', '1');
INSERT INTO `05diseases` VALUES ('834', '二期梅毒性骨膜炎', '110', 'A51.457+', 'EQMDXGMY', '1');
INSERT INTO `05diseases` VALUES ('835', '潜伏性早期梅毒', '225', 'A51.551', 'QFXZQMD', '1');
INSERT INTO `05diseases` VALUES ('836', '早期梅毒 NOS', '225', 'A51.951', 'ZQMD', '1');
INSERT INTO `05diseases` VALUES ('837', '梅毒性冠状动脉口狭窄', '125', 'A52.001+', 'MDXGZDMKXZ', '1');
INSERT INTO `05diseases` VALUES ('838', '梅毒性心血管疾病', '402', 'A52.002+', 'MDXXXGJB', '1');
INSERT INTO `05diseases` VALUES ('839', '梅毒性心脏病', '403', 'A52.003+', 'MDXXZB', '1');
INSERT INTO `05diseases` VALUES ('840', '梅毒性心肌炎', '397', 'A52.004+', 'MDXXJY', '1');
INSERT INTO `05diseases` VALUES ('841', '梅毒性主动脉瓣闭锁不全', '477', 'A52.005+', 'MDXZDMBBSBQ', '1');
INSERT INTO `05diseases` VALUES ('842', '梅毒性主动脉瓣狭窄', '477', 'A52.006+', 'MDXZDMBXZ', '1');
INSERT INTO `05diseases` VALUES ('843', '梅毒性主动脉瓣狭窄闭锁不全', '477', 'A52.007+', 'MDXZDMBXZBSBQ', '1');
INSERT INTO `05diseases` VALUES ('844', '梅毒性主动脉瘤', '477', 'A52.008+', 'MDXZDML', '1');
INSERT INTO `05diseases` VALUES ('845', '梅毒性主动脉炎', '477', 'A52.009+', 'MDXZDMY', '1');
INSERT INTO `05diseases` VALUES ('846', '梅毒性心包炎', '394', 'A52.051+', 'MDXXBY', '1');
INSERT INTO `05diseases` VALUES ('847', '梅毒性主动脉回流', '477', 'A52.052+', 'MDXZDMHL', '1');
INSERT INTO `05diseases` VALUES ('848', '梅毒性肺动脉回流', '60', 'A52.053+', 'MDXFDMHL', '1');
INSERT INTO `05diseases` VALUES ('849', '梅毒性心内膜炎', '401', 'A52.054+', 'MDXXNMY', '1');
INSERT INTO `05diseases` VALUES ('850', '梅毒性脑动脉瘤破裂', '234', 'A52.055+', 'MDXNDMLPL', '1');
INSERT INTO `05diseases` VALUES ('851', '梅毒性主动脉动脉瘤', '477', 'A52.056+', 'MDXZDMDML', '1');
INSERT INTO `05diseases` VALUES ('852', '梅毒性心血管硬化', '402', 'A52.057+', 'MDXXXGYH', '1');
INSERT INTO `05diseases` VALUES ('853', '胃危象', '370', 'A52.101', 'WWX', '1');
INSERT INTO `05diseases` VALUES ('854', '阿-罗氏瞳孔', '354', 'A52.102+', 'ALSTK', '1');
INSERT INTO `05diseases` VALUES ('855', '夏科氏关节病[神经病性关节病]', '313', 'A52.103+', 'XKSGJBSJBXGJB', '1');
INSERT INTO `05diseases` VALUES ('856', '进行性麻痹痴呆', '34', 'A52.104+', 'JXXMBCD', '1');
INSERT INTO `05diseases` VALUES ('857', '梅毒性帕金森氏综合征', '245', 'A52.105+', 'MDXPJSSZHZ', '1');
INSERT INTO `05diseases` VALUES ('858', '佩尔危象[脊髓痨性眼危象]', '430', 'A52.151', 'PEWXJSLXYWX', '1');
INSERT INTO `05diseases` VALUES ('859', '脊髓性梅毒性痉挛性埃尔布截瘫', '179', 'A52.152', 'JSXMDXJLXAEBJT', '1');
INSERT INTO `05diseases` VALUES ('860', '利绍尔麻痹(瘫痪)', '217', 'A52.153', 'LSEMBTH', '1');
INSERT INTO `05diseases` VALUES ('861', '麻痹性痴呆[培尔病]', '34', 'A52.154+', 'MBXCDPEB', '1');
INSERT INTO `05diseases` VALUES ('862', '神经梅毒痴呆', '313', 'A52.155+', 'SJMDCD', '1');
INSERT INTO `05diseases` VALUES ('863', '晚期梅毒性脑膜炎', '232', 'A52.156+', 'WQMDXNMY', '1');
INSERT INTO `05diseases` VALUES ('864', '晚期梅毒性脑炎', '234', 'A52.157+', 'WQMDXNY', '1');
INSERT INTO `05diseases` VALUES ('865', '晚期梅毒性多神经病', '313', 'A52.158+', 'WQMDXDSJB', '1');
INSERT INTO `05diseases` VALUES ('866', '晚期梅毒性视神经萎缩', '313', 'A52.159+', 'WQMDXSSJWS', '1');
INSERT INTO `05diseases` VALUES ('867', '晚期梅毒性听神经炎', '313', 'A52.160+', 'WQMDXTSJY', '1');
INSERT INTO `05diseases` VALUES ('868', '无症状性神经梅毒', '313', 'A52.251', 'WZZXSJMD', '1');
INSERT INTO `05diseases` VALUES ('869', '淋球菌性附睾炎', '88', 'A52.252+', 'LQJXFGY', '1');
INSERT INTO `05diseases` VALUES ('870', '神经梅毒', '313', 'A52.301', 'SJMD', '1');
INSERT INTO `05diseases` VALUES ('871', '梅毒瘤', '261', 'A52.701', 'MDL', '1');
INSERT INTO `05diseases` VALUES ('872', '二期梅毒性肝炎', '93', 'A52.702+', 'EQMDXGY', '1');
INSERT INTO `05diseases` VALUES ('873', '鼻梅毒', '16', 'A52.751', 'BMD', '1');
INSERT INTO `05diseases` VALUES ('874', '梅毒性鼻炎', '16', 'A52.752', 'MDXBY', '1');
INSERT INTO `05diseases` VALUES ('875', '梅毒性鼻中隔穿孔', '16', 'A52.753', 'MDXBZGCK', '1');
INSERT INTO `05diseases` VALUES ('876', '梅毒性泪囊炎', '198', 'A52.754+', 'MDXLNY', '1');
INSERT INTO `05diseases` VALUES ('877', '梅毒性巩膜外层炎', '277', 'A52.755+', 'MDXGMWCY', '1');
INSERT INTO `05diseases` VALUES ('878', '晚期梅毒性脉络膜视网膜炎', '327', 'A52.756+', 'WQMDXMLMSWMY', '1');
INSERT INTO `05diseases` VALUES ('879', '梅毒性玻璃体炎', '22', 'A52.757+', 'MDXBLTY', '1');
INSERT INTO `05diseases` VALUES ('880', '晚期梅毒性眼病', '430', 'A52.758+', 'WQMDXYB', '1');
INSERT INTO `05diseases` VALUES ('881', '肺梅毒', '225', 'A52.759+', 'FMD', '1');
INSERT INTO `05diseases` VALUES ('882', '晚期梅毒性腹膜炎', '90', 'A52.760+', 'WQMDXFMY', '1');
INSERT INTO `05diseases` VALUES ('883', '肝梅毒', '92', 'A52.761+', 'GMD', '1');
INSERT INTO `05diseases` VALUES ('884', '晚期梅毒性白斑病', '3', 'A52.762+', 'WQMDXBBB', '1');
INSERT INTO `05diseases` VALUES ('885', '肌肉梅毒', '225', 'A52.763+', 'JRMD', '1');
INSERT INTO `05diseases` VALUES ('886', '滑膜梅毒', '225', 'A52.764+', 'HMMD', '1');
INSERT INTO `05diseases` VALUES ('887', '晚期梅毒性粘液囊炎', '462', 'A52.765+', 'WQMDXNYNY', '1');
INSERT INTO `05diseases` VALUES ('888', '骨梅毒', '225', 'A52.766+', 'GMD', '1');
INSERT INTO `05diseases` VALUES ('889', '晚期梅毒性肾病变综合征', '225', 'A52.767+', 'WQMDXSBBZHZ', '1');
INSERT INTO `05diseases` VALUES ('890', '晚期潜伏性梅毒', '225', 'A52.801', 'WQQFXMD', '1');
INSERT INTO `05diseases` VALUES ('891', '晚期梅毒 NOS', '225', 'A52.901', 'WQMD', '1');
INSERT INTO `05diseases` VALUES ('892', '隐性梅毒', '225', 'A53.001', 'YXMD', '1');
INSERT INTO `05diseases` VALUES ('893', '潜伏期梅毒', '225', 'A53.051', 'QFQMD', '1');
INSERT INTO `05diseases` VALUES ('894', '血清反应阳性梅毒', '225', 'A53.052', 'XQFYYXMD', '1');
INSERT INTO `05diseases` VALUES ('895', '梅毒 NOS', '225', 'A53.901', 'MD', '1');
INSERT INTO `05diseases` VALUES ('896', '淋菌性阴道炎', '86', 'A54.001', 'LJXYDY', '1');
INSERT INTO `05diseases` VALUES ('897', '淋球菌性尿道狭窄', '237', 'A54.051', 'LQJXNDXZ', '1');
INSERT INTO `05diseases` VALUES ('898', '慢性淋病性尿道炎', '238', 'A54.052', 'MXLBXNDY', '1');
INSERT INTO `05diseases` VALUES ('899', '慢性下泌尿生殖道淋病', '209', 'A54.053', 'MXXMNSZDLB', '1');
INSERT INTO `05diseases` VALUES ('900', '(急性)淋球菌性菌龟头炎', '126', 'A54.054', 'JXLQJXJGTY', '1');
INSERT INTO `05diseases` VALUES ('901', '淋球菌性宫颈炎', '103', 'A54.055', 'LQJXGGY', '1');
INSERT INTO `05diseases` VALUES ('902', '淋球菌性膀胱炎', '247', 'A54.056', 'LQJXBGY', '1');
INSERT INTO `05diseases` VALUES ('903', '淋球菌性前庭大腺脓肿', '243', 'A54.151', 'LQJXQTDXNZ', '1');
INSERT INTO `05diseases` VALUES ('904', '淋球菌性盆腔炎', '249', 'A54.201+', 'LQJXPQY', '1');
INSERT INTO `05diseases` VALUES ('905', '淋球菌性前列腺炎', '286', 'A54.203+', 'LQJXQLXY', '1');
INSERT INTO `05diseases` VALUES ('906', '淋球菌性睾丸炎', '230', 'A54.251+', 'LQJXGWY', '1');
INSERT INTO `05diseases` VALUES ('907', '淋球菌性输卵管炎', '332', 'A54.252+', 'LQJXSLGY', '1');
INSERT INTO `05diseases` VALUES ('908', '淋球菌性盆腔腹膜炎', '90', 'A54.253+', 'LQJXPQFMY', '1');
INSERT INTO `05diseases` VALUES ('909', '淋球菌性子宫内膜炎', '86', 'A54.254+', 'LQJXZGNMY', '1');
INSERT INTO `05diseases` VALUES ('910', '淋球菌性新生儿眼炎', '430', 'A54.351+', 'LQJXXSEYY', '1');
INSERT INTO `05diseases` VALUES ('911', '淋病性结膜炎', '174', 'A54.352+', 'LBXJMY', '1');
INSERT INTO `05diseases` VALUES ('912', '淋球菌性虹膜睫状体炎', '229', 'A54.353+', 'LQJXHMJZTY', '1');
INSERT INTO `05diseases` VALUES ('913', '淋球菌性关节炎', '123', 'A54.451+', 'LQJXGJY', '1');
INSERT INTO `05diseases` VALUES ('914', '淋球菌性腱鞘炎', '163', 'A54.452+', 'LQJXJQY', '1');
INSERT INTO `05diseases` VALUES ('915', '淋球菌性滑膜炎', '134', 'A54.453+', 'LQJXHMY', '1');
INSERT INTO `05diseases` VALUES ('916', '淋球菌性粘液囊炎', '462', 'A54.454+', 'LQJXNYNY', '1');
INSERT INTO `05diseases` VALUES ('917', '淋球菌性骨髓炎', '114', 'A54.455+', 'LQJXGSY', '1');
INSERT INTO `05diseases` VALUES ('918', '淋球菌性咽炎', '429', 'A54.551', 'LQJXYY', '1');
INSERT INTO `05diseases` VALUES ('919', '肛门淋菌球感染', '95', 'A54.651', 'GMLJQGR', '1');
INSERT INTO `05diseases` VALUES ('920', '直肠淋菌球感染', '95', 'A54.652', 'ZCLJQGR', '1');
INSERT INTO `05diseases` VALUES ('921', '其他特指部位的淋球菌感染', '95', 'A54.801', 'QTTZBWDLQJGR', '1');
INSERT INTO `05diseases` VALUES ('922', '淋球菌性肺炎', '81', 'A54.802+', 'LQJXFY', '1');
INSERT INTO `05diseases` VALUES ('923', '淋球菌性腹膜炎', '90', 'A54.803+', 'LQJXFMY', '1');
INSERT INTO `05diseases` VALUES ('924', '淋球菌性脑膜炎', '232', 'A54.804+', 'LQJXNMY', '1');
INSERT INTO `05diseases` VALUES ('925', '淋球菌性脑脓肿', '243', 'A54.805+', 'LQJXNNZ', '1');
INSERT INTO `05diseases` VALUES ('926', '淋球菌性心包炎', '394', 'A54.806+', 'LQJXXBY', '1');
INSERT INTO `05diseases` VALUES ('927', '淋球菌性心肌炎', '397', 'A54.807+', 'LQJXXJY', '1');
INSERT INTO `05diseases` VALUES ('928', '淋球菌性心内膜炎', '401', 'A54.808+', 'LQJXXNMY', '1');
INSERT INTO `05diseases` VALUES ('929', '淋球菌性皮肤损害', '250', 'A54.851', 'LQJXPFSH', '1');
INSERT INTO `05diseases` VALUES ('930', '淋球菌性败血症', '9', 'A54.852', 'LQJXBXZ', '1');
INSERT INTO `05diseases` VALUES ('931', '淋病 NOS', '209', 'A54.901', 'LB', '1');
INSERT INTO `05diseases` VALUES ('932', '慢性淋球菌感染', '95', 'A54.902', 'MXLQJGR', '1');
INSERT INTO `05diseases` VALUES ('933', '性病性(衣原体性)淋巴肉芽肿', '295', 'A55.X01', 'XBXYYTXLBRYZ', '1');
INSERT INTO `05diseases` VALUES ('934', '迪朗-尼古拉-法夫尔病', '268', 'A55.X51', 'DLNGLFFEB', '1');
INSERT INTO `05diseases` VALUES ('935', '腹股沟淋巴肉芽肿', '295', 'A55.X52', 'FGGLBRYZ', '1');
INSERT INTO `05diseases` VALUES ('936', '生殖器肛门直肠综合征', '230', 'A55.X53', 'SZQGMZCZHZ', '1');
INSERT INTO `05diseases` VALUES ('937', '女阴蚀疮', '86', 'A55.X54', 'NYSC', '1');
INSERT INTO `05diseases` VALUES ('938', '衣原体性阴道炎', '86', 'A56.001', 'YYTXYDY', '1');
INSERT INTO `05diseases` VALUES ('939', '衣原体性外阴阴道炎', '86', 'A56.051', 'YYTXWYYDY', '1');
INSERT INTO `05diseases` VALUES ('940', '衣原体性尿道炎', '86', 'A56.052', 'YYTXNDY', '1');
INSERT INTO `05diseases` VALUES ('941', '衣原体性宫颈炎', '86', 'A56.053', 'YYTXGGY', '1');
INSERT INTO `05diseases` VALUES ('942', '衣原体性膀胱炎', '86', 'A56.054', 'YYTXBGY', '1');
INSERT INTO `05diseases` VALUES ('943', '衣原体性附睾炎', '230', 'A56.151+', 'YYTXFGY', '1');
INSERT INTO `05diseases` VALUES ('944', '衣原体性睾丸炎', '230', 'A56.152+', 'YYTXGWY', '1');
INSERT INTO `05diseases` VALUES ('945', '衣原体性女性盆腔炎性疾病', '249', 'A56.153+', 'YYTXNXPQYXJB', '1');
INSERT INTO `05diseases` VALUES ('946', '泌尿生殖道衣原体感染', '95', 'A56.251', 'MNSZDYYTGR', '1');
INSERT INTO `05diseases` VALUES ('947', '肛门衣原体感染', '95', 'A56.351', 'GMYYTGR', '1');
INSERT INTO `05diseases` VALUES ('948', '直肠衣原体感染', '95', 'A56.352', 'ZCYYTGR', '1');
INSERT INTO `05diseases` VALUES ('949', '咽衣原体感染', '95', 'A56.451', 'YYYTGR', '1');
INSERT INTO `05diseases` VALUES ('950', '其他部位的性传播的衣原体感染', '95', 'A56.851', 'QTBWDXCBDYYTGR', '1');
INSERT INTO `05diseases` VALUES ('951', '软下疳', '86', 'A57.X01', 'RXG', '1');
INSERT INTO `05diseases` VALUES ('952', '外阴下疳', '86', 'A57.X02', 'WYXG', '1');
INSERT INTO `05diseases` VALUES ('953', '阴茎下疳', '230', 'A57.X03', 'YJXG', '1');
INSERT INTO `05diseases` VALUES ('955', '腹股沟肉芽肿 (溃疡性)', '295', 'A58.X01', 'FGGRYZKYX', '1');
INSERT INTO `05diseases` VALUES ('956', '性病性肉芽肿', '295', 'A58.X51', 'XBXRYZ', '1');
INSERT INTO `05diseases` VALUES ('957', '滴虫性尿道炎', '238', 'A59.001+', 'DCXNDY', '1');
INSERT INTO `05diseases` VALUES ('958', '滴虫性阴道炎', '86', 'A59.002+', 'DCXYDY', '1');
INSERT INTO `05diseases` VALUES ('959', '膀胱滴虫病', '86', 'A59.051+', 'BGDCB', '1');
INSERT INTO `05diseases` VALUES ('960', '尿道滴虫病', '230', 'A59.052+', 'NDDCB', '1');
INSERT INTO `05diseases` VALUES ('961', '前列腺滴虫病', '230', 'A59.053+', 'QLXDCB', '1');
INSERT INTO `05diseases` VALUES ('962', '精囊滴虫病', '230', 'A59.054+', 'JNDCB', '1');
INSERT INTO `05diseases` VALUES ('963', '宫颈滴虫病', '86', 'A59.055+', 'GGDCB', '1');
INSERT INTO `05diseases` VALUES ('964', '阴道滴虫病', '86', 'A59.056+', 'YDDCB', '1');
INSERT INTO `05diseases` VALUES ('965', '外阴滴虫病', '86', 'A59.057+', 'WYDCB', '1');
INSERT INTO `05diseases` VALUES ('966', '其他特指部位的毛滴虫病', '86', 'A59.851', 'QTTZBWDMDCB', '1');
INSERT INTO `05diseases` VALUES ('967', '毛滴虫病 NOS', '86', 'A59.901', 'MDCB', '1');
INSERT INTO `05diseases` VALUES ('968', '阴茎单纯疱疹', '230', 'A60.001+', 'YJDCPZ', '1');
INSERT INTO `05diseases` VALUES ('969', '阴囊疱疹', '230', 'A60.051+', 'YNPZ', '1');
INSERT INTO `05diseases` VALUES ('970', '疱疹性(单纯性)外阴溃疡', '230', 'A60.052+', 'PZXDCXWYKY', '1');
INSERT INTO `05diseases` VALUES ('971', '单纯疱疹性外阴阴道炎', '86', 'A60.053+', 'DCPZXWYYDY', '1');
INSERT INTO `05diseases` VALUES ('972', '肛门皮肤疱疹病毒感染', '250', 'A60.151', 'GMPFPZBDGR', '1');
INSERT INTO `05diseases` VALUES ('973', '直肠疱疹病毒感染', '95', 'A60.152+', 'ZCPZBDGR', '1');
INSERT INTO `05diseases` VALUES ('974', '肛门生殖器疱疹', '230', 'A60.951', 'GMSZQPZ', '1');
INSERT INTO `05diseases` VALUES ('975', '尖锐湿疣', '230', 'A63.001', 'JRSY', '1');
INSERT INTO `05diseases` VALUES ('976', '湿疣', '230', 'A63.002', 'SY', '1');
INSERT INTO `05diseases` VALUES ('977', '外阴尖锐湿疣', '86', 'A63.003', 'WYJRSY', '1');
INSERT INTO `05diseases` VALUES ('978', '外阴湿疣', '86', 'A63.004', 'WYSY', '1');
INSERT INTO `05diseases` VALUES ('979', '外阴扁平湿疣', '86', 'A63.051', 'WYBPSY', '1');
INSERT INTO `05diseases` VALUES ('980', '肛门湿疣', '86', 'A63.052', 'GMSY', '1');
INSERT INTO `05diseases` VALUES ('981', '其他特指的性传播的疾病', '86', 'A63.851', 'QTTZDXCBDJB', '1');
INSERT INTO `05diseases` VALUES ('982', '性病', '230', 'A64.X51', 'XB', '1');
INSERT INTO `05diseases` VALUES ('983', '性病性龟头炎', '126', 'A64.X52+', 'XBXGTY', '1');
INSERT INTO `05diseases` VALUES ('984', '恩乔推拉病', '268', 'A65.X51', 'EQTLB', '1');
INSERT INTO `05diseases` VALUES ('985', '非性病性梅毒', '225', 'A65.X52', 'FXBXMD', '1');
INSERT INTO `05diseases` VALUES ('986', '地方性梅毒', '225', 'A65.X53', 'DFXMD', '1');
INSERT INTO `05diseases` VALUES ('987', '雅可病下疳', '381', 'A66.051', 'YKBXG', '1');
INSERT INTO `05diseases` VALUES ('988', '皮安瘤', '261', 'A66.151', 'PAL', '1');
INSERT INTO `05diseases` VALUES ('989', '雅司病的足底或掌乳头状瘤', '86', 'A66.152', 'YSBDZDHZRTZL', '1');
INSERT INTO `05diseases` VALUES ('990', '雅司瘤', '261', 'A66.153', 'YSL', '1');
INSERT INTO `05diseases` VALUES ('991', '早期雅司皮损', '278', 'A66.251', 'ZQYSPS', '1');
INSERT INTO `05diseases` VALUES ('992', '鬼状手', '328', 'A66.351', 'GZS', '1');
INSERT INTO `05diseases` VALUES ('993', '虫蛀样足底', '280', 'A66.352', 'CZYZD', '1');
INSERT INTO `05diseases` VALUES ('994', '树胶肿样雅司皮损', '278', 'A66.451', 'SJZYYSPS', '1');
INSERT INTO `05diseases` VALUES ('995', '结节型晚期(溃疡性)雅司病', '427', 'A66.452', 'JJXWQKYXYSB', '1');
INSERT INTO `05diseases` VALUES ('996', '破坏性(毁形性)溃疡鼻咽炎', '16', 'A66.551+', 'PHXHXXKYBYY', '1');
INSERT INTO `05diseases` VALUES ('997', '雅司病的鼻骨增殖性骨膜炎[根度病]', '16', 'A66.651', 'YSBDBGZZXGMYGDB', '1');
INSERT INTO `05diseases` VALUES ('998', '雅司病的腱鞘囊肿', '162', 'A66.652', 'YSBDJQNZ', '1');
INSERT INTO `05diseases` VALUES ('999', '雅司病的关节炎', '123', 'A66.653+', 'YSBDGJY', '1');
INSERT INTO `05diseases` VALUES ('1000', '雅司病的骨膜炎（肥大性）', '110', 'A66.654+', 'YSBDGMYFDX', '1');
INSERT INTO `05diseases` VALUES ('1001', '雅司病的树胶样肿骨', '427', 'A66.655+', 'YSBDSJYZG', '1');
INSERT INTO `05diseases` VALUES ('1002', '雅司病的骨炎', '115', 'A66.656+', 'YSBDGY', '1');
INSERT INTO `05diseases` VALUES ('1003', '雅司病的关节旁结节', '123', 'A66.751', 'YSBDGJPJJ', '');
INSERT INTO `05diseases` VALUES ('1004', '粘膜雅司病', '427', 'A66.752', 'NMYSB', '');
INSERT INTO `05diseases` VALUES ('1005', '潜伏性雅司病', '427', 'A66.851', 'QFXYSB', '');
INSERT INTO `05diseases` VALUES ('1006', '雅司病 NOS', '427', 'A66.951', 'YSB', '');
INSERT INTO `05diseases` VALUES ('1007', '品他病的(初期的)下疳', '381', 'A67.051', 'PTBDCQDXG', '');
INSERT INTO `05diseases` VALUES ('1008', '品他病的(初期的)丘疹', '250', 'A67.052', 'PTBDCQDQZ', '');
INSERT INTO `05diseases` VALUES ('1009', '品他病的红斑', '250', 'A67.151', 'PTBDHB', '');
INSERT INTO `05diseases` VALUES ('1010', '品他病的白斑', '250', 'A67.152', 'PTBDBB', '');
INSERT INTO `05diseases` VALUES ('1011', '品他病的角化过度', '268', 'A67.153', 'PTBDJHGD', '');
INSERT INTO `05diseases` VALUES ('1012', '品他病的浓染性损害', '268', 'A67.154', 'PTBDNRXSH', '');
INSERT INTO `05diseases` VALUES ('1013', '品他病的变色性皮肤损害', '250', 'A67.251', 'PTBDBSXPFSH', '');
INSERT INTO `05diseases` VALUES ('1014', '品他病的无色性皮肤损害', '250', 'A67.252', 'PTBDWSXPFSH', '');
INSERT INTO `05diseases` VALUES ('1015', '品他病的瘢痕性皮肤损害', '250', 'A67.253', 'PTBDBHXPFSH', '');
INSERT INTO `05diseases` VALUES ('1016', '品他病的心血管损害', '402', 'A67.254+', 'PTBDXXGSH', '');
INSERT INTO `05diseases` VALUES ('1017', '品他病的混合性(无色性和浓染性)皮肤损害', '250', 'A67.351', 'PTBDHHXWSXHNRXPFSH', '');
INSERT INTO `05diseases` VALUES ('1018', '品他病 NOS', '268', 'A67.951', 'PTB', '');
INSERT INTO `05diseases` VALUES ('1019', '虱媒介性回归热[流行性回归热]', '271', 'A68.001', 'SMJXHGRLXXHGR', '');
INSERT INTO `05diseases` VALUES ('1020', '蜱传回归热[地方性回归热]', '271', 'A68.151', 'PCHGRDFXHGR', '');
INSERT INTO `05diseases` VALUES ('1021', '卡特(亚洲)(包柔螺旋体)回归热', '271', 'A68.152', 'KTYZBRLXTHGR', '');
INSERT INTO `05diseases` VALUES ('1022', '回归热 NOS', '271', 'A68.901', 'HGR', '');
INSERT INTO `05diseases` VALUES ('1023', '复发性斑疹伤寒[回归热]', '306', 'A68.951', 'FFXBZSHHGR', '');
INSERT INTO `05diseases` VALUES ('1024', '走马疳[口颊坏疽、走马牙疳]', '425', 'A69.001', 'ZMGKJHJZMYG', '');
INSERT INTO `05diseases` VALUES ('1025', '坏疽性口腔炎', '192', 'A69.051', 'HJXKQY', '');
INSERT INTO `05diseases` VALUES ('1026', '坏死性溃疡性口炎', '193', 'A69.052', 'HSXKYXKY', '');
INSERT INTO `05diseases` VALUES ('1027', '梭菌螺旋体性的坏疽', '187', 'A69.053', 'SJLXTXDHJ', '');
INSERT INTO `05diseases` VALUES ('1028', '坏死性溃疡性龈口炎', '193', 'A69.151', 'HSXKYXYKY', '');
INSERT INTO `05diseases` VALUES ('1029', '坏死性溃疡性龈炎', '195', 'A69.152', 'HSXKYXYY', '');
INSERT INTO `05diseases` VALUES ('1030', '樊尚龈炎', '277', 'A69.153', 'FSYY', '');
INSERT INTO `05diseases` VALUES ('1031', '战壕口炎', '193', 'A69.154', 'ZHKY', '');
INSERT INTO `05diseases` VALUES ('1032', '樊尚(奋森)氏口炎[坏死性龈炎]', '193', 'A69.155', 'FSFSSKYHSXYY', '');
INSERT INTO `05diseases` VALUES ('1033', '螺旋体性口炎', '193', 'A69.156', 'LXTXKY', '');
INSERT INTO `05diseases` VALUES ('1034', '樊尚膜性咽峡炎', '428', 'A69.157', 'FSMXYXY', '');
INSERT INTO `05diseases` VALUES ('1035', '梭菌螺旋体性咽炎', '429', 'A69.158', 'SJLXTXYY', '');
INSERT INTO `05diseases` VALUES ('1036', '莱姆病', '268', 'A69.201', 'LMB', '');
INSERT INTO `05diseases` VALUES ('1037', '莱姆病引起的多神经病', '313', 'A69.251+', 'LMBYQDDSJB', '');
INSERT INTO `05diseases` VALUES ('1038', '莱姆病关节炎', '123', 'A69.252+', 'LMBGJY', '');
INSERT INTO `05diseases` VALUES ('1039', '其他特指的螺旋体感染', '95', 'A69.851', 'QTTZDLXTGR', '');
INSERT INTO `05diseases` VALUES ('1040', '螺旋体感染 NOS', '95', 'A69.901', 'LXTGR', '');
INSERT INTO `05diseases` VALUES ('1041', '螺旋体感染性关节炎', '123', 'A69.902+', 'LXTGRXGJY', '');
INSERT INTO `05diseases` VALUES ('1042', '鹦鹉热', '271', 'A70.X01', 'YWR', '');
INSERT INTO `05diseases` VALUES ('1043', '鸟疫', '278', 'A70.X51', 'NY', '');
INSERT INTO `05diseases` VALUES ('1044', '初期沙眼', '430', 'A71.051', 'CQSY', '');
INSERT INTO `05diseases` VALUES ('1045', '可疑沙眼', '430', 'A71.052', 'KYSY', '');
INSERT INTO `05diseases` VALUES ('1046', '沙眼性角膜炎', '430', 'A71.101', 'SYXJMY', '');
INSERT INTO `05diseases` VALUES ('1047', '沙眼性血管翳', '430', 'A71.102', 'SYXXGY', '');
INSERT INTO `05diseases` VALUES ('1048', '沙眼性泪囊炎', '430', 'A71.151', 'SYXLNY', '');
INSERT INTO `05diseases` VALUES ('1049', '沙眼性(颗粒性)结膜炎', '430', 'A71.152', 'SYXKLXJMY', '');
INSERT INTO `05diseases` VALUES ('1050', '埃及眼炎', '430', 'A71.153+', 'AJYY', '');
INSERT INTO `05diseases` VALUES ('1051', '沙眼 NOS', '430', 'A71.901', 'SY', '');
INSERT INTO `05diseases` VALUES ('1052', '类沙眼', '430', 'A74.051+', 'LSY', '');
INSERT INTO `05diseases` VALUES ('1053', '衣原体结膜炎', '174', 'A74.052+', 'YYTJMY', '');
INSERT INTO `05diseases` VALUES ('1054', '衣原体腹膜炎', '90', 'A74.851+', 'YYTFMY', '');
INSERT INTO `05diseases` VALUES ('1055', '衣原体感染 NOS', '95', 'A74.901', 'YYTGR', '');
INSERT INTO `05diseases` VALUES ('1056', '流行性斑疹伤寒', '306', 'A75.001', 'LXXBZSH', '');
INSERT INTO `05diseases` VALUES ('1057', '地方性(虱媒介的)斑疹伤寒', '306', 'A75.051', 'DFXSMJDBZSH', '');
INSERT INTO `05diseases` VALUES ('1058', '布里尔-津瑟病', '268', 'A75.151', 'BLEJSB', '');
INSERT INTO `05diseases` VALUES ('1059', '地方性斑疹伤寒(鼠型斑疹伤寒)', '306', 'A75.201', 'DFXBZSHSXBZSH', '');
INSERT INTO `05diseases` VALUES ('1060', '鼠型斑疹伤寒肠炎', '33', 'A75.202', 'SXBZSHCY', '');
INSERT INTO `05diseases` VALUES ('1061', '恙虫病[丛林斑疹伤寒]', '306', 'A75.301', 'YCBCLBZSH', '');
INSERT INTO `05diseases` VALUES ('1062', '斑疹伤寒 NOS', '306', 'A75.901', 'BZSH', '');
INSERT INTO `05diseases` VALUES ('1063', '立氏立克次体斑疹热', '10', 'A77.051', 'LSLKCTBZR', '');
INSERT INTO `05diseases` VALUES ('1064', '康诺尔于立克次体斑疹热', '10', 'A77.151', 'KNEYLKCTBZR', '');
INSERT INTO `05diseases` VALUES ('1065', '西北利亚立克次体斑疹热', '10', 'A77.251', 'XBLYLKCTBZR', '');
INSERT INTO `05diseases` VALUES ('1066', '澳洲立克次体斑疹热', '10', 'A77.351', 'AZLKCTBZR', '');
INSERT INTO `05diseases` VALUES ('1067', '其他物指的斑疹热', '10', 'A77.851', 'QTWZDBZR', '');
INSERT INTO `05diseases` VALUES ('1068', '斑疹热[蜱媒介的立克次氏体病] NOS', '10', 'A77.951', 'BZRPMJDLKCSTB', '');
INSERT INTO `05diseases` VALUES ('1069', '蜱媒介的斑疹伤寒 NOS', '306', 'A77.952', 'PMJDBZSH', '');
INSERT INTO `05diseases` VALUES ('1070', '寇(Ｑ)热', '271', 'A78.X01', 'KR', '');
INSERT INTO `05diseases` VALUES ('1071', '寇(Ｑ)热伴有肺炎', '81', 'A78.X51+', 'KRBYFY', '');
INSERT INTO `05diseases` VALUES ('1072', '战壕热[五日热]', '271', 'A79.051', 'ZHRWRR', '');
INSERT INTO `05diseases` VALUES ('1073', '立克次体痘[疹热]', '250', 'A79.151', 'LKCTDZR', '');
INSERT INTO `05diseases` VALUES ('1074', '附红细胞体病', '376', 'A79.801', 'FHXBTB', '');
INSERT INTO `05diseases` VALUES ('1075', '其他特指的立克次氏体病', '268', 'A79.851', 'QTTZDLKCSTB', '');
INSERT INTO `05diseases` VALUES ('1076', '立克次氏体病 NOS', '268', 'A79.901', 'LKCSTB', '');
INSERT INTO `05diseases` VALUES ('1077', '立克次体感染 NOS', '95', 'A79.902', 'LKCTGR', '');
INSERT INTO `05diseases` VALUES ('1078', '急性麻痹性脊髓灰质炎，与接种有关的', '151', 'A80.051', 'JXMBXJSHZYYJZYGD', '');
INSERT INTO `05diseases` VALUES ('1079', '急性麻痹性脊髓灰质炎，(外地)引入的野病毒', '151', 'A80.151', 'JXMBXJSHZYWDYRDYBD', '');
INSERT INTO `05diseases` VALUES ('1080', '急性麻痹性脊髓灰质炎，本地存在的野病毒', '151', 'A80.251', 'JXMBXJSHZYBDCZDYBD', '');
INSERT INTO `05diseases` VALUES ('1081', '急性延髓型脊髓灰质炎', '151', 'A80.351', 'JXYSXJSHZY', '');
INSERT INTO `05diseases` VALUES ('1082', '急性麻痹性脊髓灰质炎，其他和未特指的', '151', 'A80.352', 'JXMBXJSHZYQTHWTZD', '');
INSERT INTO `05diseases` VALUES ('1083', '急性非麻痹性脊髓灰质炎', '151', 'A80.451', 'JXFMBXJSHZY', '');
INSERT INTO `05diseases` VALUES ('1084', '急性脊髓灰质炎 NOS', '151', 'A80.901', 'JXJSHZY', '');
INSERT INTO `05diseases` VALUES ('1085', '脊髓前角灰质炎', '152', 'A80.902', 'JSQJHZY', '');
INSERT INTO `05diseases` VALUES ('1086', '脑灰质炎', '234', 'A80.951', 'NHZY', '');
INSERT INTO `05diseases` VALUES ('1087', '雅-克二氏病(痉挛性假硬化)(亚急性病毒性海绵状脑病)', '234', 'A81.001', 'YKESBJLXJYHYJXBDXHMZ', '');
INSERT INTO `05diseases` VALUES ('1088', '克罗伊茨费尔特－雅各布病伴有痴呆', '34', 'A81.051+', 'KLYCFETYGBBBYCD', '');
INSERT INTO `05diseases` VALUES ('1089', '亚急性包涵体脑炎(亚急性硬化性全脑炎)', '234', 'A81.101', 'YJXBHTNYYJXYHXQNY', '');
INSERT INTO `05diseases` VALUES ('1090', '道森包涵体性脑炎', '234', 'A81.151', 'DSBHTXNY', '');
INSERT INTO `05diseases` VALUES ('1091', '急性包涵体性脑炎', '234', 'A81.152', 'JXBHTXNY', '');
INSERT INTO `05diseases` VALUES ('1092', '范博盖尔特脑白质病', '234', 'A81.153', 'FBGETNBZB', '');
INSERT INTO `05diseases` VALUES ('1093', '播散性坏死性脑白质病', '234', 'A81.201', 'BSXHSXNBZB', '');
INSERT INTO `05diseases` VALUES ('1094', '进行性多灶性白质脑病', '234', 'A81.251', 'JXXDZXBZNB', '');
INSERT INTO `05diseases` VALUES ('1095', '库鲁病[恐惧性震颤]', '268', 'A81.851', 'KLBKJXZC', '');
INSERT INTO `05diseases` VALUES ('1096', '慢病毒感染', '95', 'A81.951', 'MBDGR', '');
INSERT INTO `05diseases` VALUES ('1097', '森林狂犬病', '194', 'A82.051', 'SLKQB', '');
INSERT INTO `05diseases` VALUES ('1098', '城市狂犬病', '194', 'A82.151', 'CSKQB', '');
INSERT INTO `05diseases` VALUES ('1099', '狂犬病[恐水症] NOS', '194', 'A82.901', 'KQBKSZ', '');
INSERT INTO `05diseases` VALUES ('1100', '流行性乙型脑炎(日本脑炎)', '234', 'A83.001', 'LXXYXNYRBNY', '');
INSERT INTO `05diseases` VALUES ('1101', '东方马型脑炎', '234', 'A83.251', 'DFMXNY', '');
INSERT INTO `05diseases` VALUES ('1102', '丙型脑炎', '234', 'A83.351', 'BXNY', '');
INSERT INTO `05diseases` VALUES ('1103', '昆金病毒病', '20', 'A83.451', 'KJBDB', '');
INSERT INTO `05diseases` VALUES ('1104', '拉克罗斯脑炎', '234', 'A83.551', 'LKLSNY', '');
INSERT INTO `05diseases` VALUES ('1105', '若西欧病毒病', '20', 'A83.651', 'RXOBDB', '');
INSERT INTO `05diseases` VALUES ('1106', '其他蚊媒介的病毒性脑炎', '234', 'A83.851', 'QTWMJDBDXNY', '');
INSERT INTO `05diseases` VALUES ('1107', '蚊媒介的病毒性脑炎 NOS', '234', 'A83.951', 'WMJDBDXNY', '');
INSERT INTO `05diseases` VALUES ('1108', '森林脑炎[蜱传脑炎]', '234', 'A84.051', 'SLNYPCNY', '');
INSERT INTO `05diseases` VALUES ('1109', '中部欧洲蜱媒介脑炎', '234', 'A84.151', 'ZBOZPMJNY', '');
INSERT INTO `05diseases` VALUES ('1110', '波瓦桑病毒病', '20', 'A84.851', 'BWSBDB', '');
INSERT INTO `05diseases` VALUES ('1111', '羊跳跃病', '268', 'A84.852', 'YTYB', '');
INSERT INTO `05diseases` VALUES ('1112', '蜱媒介的病毒性脑炎 NOS', '234', 'A84.951', 'PMJDBDXNY', '');
INSERT INTO `05diseases` VALUES ('1113', '肠病毒脑炎、脊髓炎或脑脊髓炎', '234', 'A85.051+', 'CBDNYJSYHNJSY', '');
INSERT INTO `05diseases` VALUES ('1114', '腺病毒脑炎、脊髓炎或脑脊髓炎', '234', 'A85.151+', 'XBDNYJSYHNJSY', '');
INSERT INTO `05diseases` VALUES ('1115', '节肢动物媒介的病毒性脑炎 NOS', '234', 'A85.251', 'JZDWMJDBDXNY', '');
INSERT INTO `05diseases` VALUES ('1116', '流行性脑脊髓炎[克律歇氏病]', '234', 'A85.851', 'LXXNJSYKLXSB', '');
INSERT INTO `05diseases` VALUES ('1117', '昏睡性脑炎[埃科若莫氏病]', '234', 'A85.852', 'HSXNYAKRMSB', '');
INSERT INTO `05diseases` VALUES ('1118', '嗜睡性脑炎[流行性甲型脑炎]', '234', 'A85.853', 'SSXNYLXXJXNY', '');
INSERT INTO `05diseases` VALUES ('1119', '冯.埃科诺莫-克吕谢病', '268', 'A85.854', 'FAKNMKLXB', '');
INSERT INTO `05diseases` VALUES ('1120', '病毒性脑膜脑炎', '232', 'A86.X01', 'BDXNMNY', '');
INSERT INTO `05diseases` VALUES ('1121', '病毒性脑炎', '234', 'A86.X02', 'BDXNY', '');
INSERT INTO `05diseases` VALUES ('1122', '急性脑膜脑炎', '232', 'A86.X51', 'JXNMNY', '');
INSERT INTO `05diseases` VALUES ('1123', '急性脑炎', '234', 'A86.X52', 'JXNY', '');
INSERT INTO `05diseases` VALUES ('1124', '流行性脑炎', '234', 'A86.X53', 'LXXNY', '');
INSERT INTO `05diseases` VALUES ('1125', '柯萨奇病毒性脑膜炎(基底)(大脑)(脊髓)', '232', 'A87.051+', 'KSQBDXNMYJDDNJS', '');
INSERT INTO `05diseases` VALUES ('1126', '肠病毒性脑膜炎', '232', 'A87.052+', 'CBDXNMY', '');
INSERT INTO `05diseases` VALUES ('1127', '腺病毒性脑膜炎', '232', 'A87.151+', 'XBDXNMY', '');
INSERT INTO `05diseases` VALUES ('1128', '淋巴细胞脉络膜性脑膜炎', '232', 'A87.251+', 'LBXBMLMXNMY', '');
INSERT INTO `05diseases` VALUES ('1129', '浆液性脑膜炎', '232', 'A87.252+', 'JYXNMY', '');
INSERT INTO `05diseases` VALUES ('1130', '淋巴细胞性浆液性脑膜炎', '232', 'A87.253+', 'LBXBXJYXNMY', '');
INSERT INTO `05diseases` VALUES ('1131', '其他病毒性脑膜炎', '232', 'A87.851', 'QTBDXNMY', '');
INSERT INTO `05diseases` VALUES ('1132', '病毒性脑膜炎[施奈德氏综合征] NOS', '232', 'A87.901', 'BDXNMYSNDSZHZ', '');
INSERT INTO `05diseases` VALUES ('1133', '肠病毒性发疹热(波士顿疹病)', '250', 'A88.051', 'CBDXFZRBSDZB', '');
INSERT INTO `05diseases` VALUES ('1134', '流行性眩晕', '412', 'A88.151+', 'LXXXY', '');
INSERT INTO `05diseases` VALUES ('1135', '中枢神经系统其他特指的病毒性感染', '313', 'A88.851', 'ZSSJXTQTTZDBDXGR', '');
INSERT INTO `05diseases` VALUES ('1136', '中枢神经系统的病毒性感染 NOS', '313', 'A89.X51', 'ZSSJXTDBDXGR', '');
INSERT INTO `05diseases` VALUES ('1137', '登革热', '271', 'A90.X01', 'DGR', '');
INSERT INTO `05diseases` VALUES ('1138', '登革出血热', '39', 'A91.X01', 'DGCXR', '');
INSERT INTO `05diseases` VALUES ('1139', '奇孔古尼亚(出血)热', '38', 'A92.051', 'QKGNYCXR', '');
INSERT INTO `05diseases` VALUES ('1140', '奥尼昂-尼昂热', '271', 'A92.151', 'ANANAR', '');
INSERT INTO `05diseases` VALUES ('1141', '委内瑞拉马型脑炎、脑脊髓炎或脊髓炎', '234', 'A92.251', 'WNRLMXNYNJSYHJSY', '');
INSERT INTO `05diseases` VALUES ('1142', '西尼罗河热', '271', 'A92.351', 'XNLHR', '');
INSERT INTO `05diseases` VALUES ('1143', '裂谷热', '271', 'A92.451', 'LGR', '');
INSERT INTO `05diseases` VALUES ('1144', '其他特指的蚊媒介的病毒性发热', '73', 'A92.851', 'QTTZDWMJDBDXFR', '');
INSERT INTO `05diseases` VALUES ('1145', '蚊媒介的病毒性发热 NOS', '73', 'A92.951', 'WMJDBDXFR', '');
INSERT INTO `05diseases` VALUES ('1146', '奥罗普什热', '271', 'A93.051', 'ALPSR', '');
INSERT INTO `05diseases` VALUES ('1147', '白岭热[三日热]', '271', 'A93.151', 'BLRSRR', '');
INSERT INTO `05diseases` VALUES ('1148', '科罗拉多蜱热', '271', 'A93.251', 'KLLDPR', '');
INSERT INTO `05diseases` VALUES ('1149', '其它蜱媒介的出血热', '39', 'A93.801', 'QTPMJDCXR', '');
INSERT INTO `05diseases` VALUES ('1150', '皮里病毒病', '20', 'A93.851', 'PLBDB', '');
INSERT INTO `05diseases` VALUES ('1151', '疱疹性口炎病毒病[印地安纳热]', '248', 'A93.852', 'PZXKYBDBYDANR', '');
INSERT INTO `05diseases` VALUES ('1152', '虫媒病毒感染', '95', 'A94.051', 'CMBDGR', '');
INSERT INTO `05diseases` VALUES ('1153', '虫媒介病毒性发热', '73', 'A94.052', 'CMJBDXFR', '');
INSERT INTO `05diseases` VALUES ('1154', '丛林黄热病', '268', 'A95.051', 'CLHRB', '');
INSERT INTO `05diseases` VALUES ('1155', '城市型黄热病', '268', 'A95.151', 'CSXHRB', '');
INSERT INTO `05diseases` VALUES ('1156', '黄热病 NOS', '268', 'A95.901', 'HRB', '');
INSERT INTO `05diseases` VALUES ('1157', '黄热病性肝炎', '93', 'A95.902+', 'HRBXGY', '');
INSERT INTO `05diseases` VALUES ('1158', '朱宁出血热', '39', 'A96.051', 'ZNCXR', '');
INSERT INTO `05diseases` VALUES ('1159', '玻利维亚出血热', '39', 'A96.151', 'BLWYCXR', '');
INSERT INTO `05diseases` VALUES ('1160', '拉沙热', '271', 'A96.251', 'LSR', '');
INSERT INTO `05diseases` VALUES ('1161', '其他沙粒病毒性出血热', '39', 'A96.851', 'QTSLBDXCXR', '');
INSERT INTO `05diseases` VALUES ('1162', '沙粒病毒性出血热 NOS', '39', 'A96.951', 'SLBDXCXR', '');
INSERT INTO `05diseases` VALUES ('1163', '中亚出血热', '39', 'A98.051', 'ZYCXR', '');
INSERT INTO `05diseases` VALUES ('1164', '鄂木斯克出血热', '39', 'A98.151', 'EMSKCXR', '');
INSERT INTO `05diseases` VALUES ('1165', '夸赛纳森林病', '268', 'A98.251', 'KSNSLB', '');
INSERT INTO `05diseases` VALUES ('1166', '马堡病毒病', '20', 'A98.351', 'MBBDB', '');
INSERT INTO `05diseases` VALUES ('1167', '埃博拉病毒病', '20', 'A98.451', 'ABLBDB', '');
INSERT INTO `05diseases` VALUES ('1168', '出血性肾变病性肾炎', '315', 'A98.501+', 'CXXSBBXSY', '');
INSERT INTO `05diseases` VALUES ('1169', '流行性出血热', '39', 'A98.502+', 'LXXCXR', '');
INSERT INTO `05diseases` VALUES ('1170', '出血热伴肾综合征', '39', 'A98.551+', 'CXRBSZHZ', '');
INSERT INTO `05diseases` VALUES ('1171', '汉坦病毒病', '20', 'A98.552', 'HTBDB', '');
INSERT INTO `05diseases` VALUES ('1172', '流行性肾病', '314', 'A98.553', 'LXXSB', '');
INSERT INTO `05diseases` VALUES ('1173', '新疆出血热', '39', 'A98.851', 'XJCXR', '');
INSERT INTO `05diseases` VALUES ('1174', '病毒性出血热 NOS', '39', 'A99.X01', 'BDXCXR', '');
INSERT INTO `05diseases` VALUES ('1175', '卡波西(济)氏水痘样疹', '336', 'B00.001', 'KBXJSSDYZ', '');
INSERT INTO `05diseases` VALUES ('1176', '疱疹性湿疹', '320', 'B00.002', 'PZXSZ', '');
INSERT INTO `05diseases` VALUES ('1177', '单纯疱疹性湿疹', '320', 'B00.051', 'DCPZXSZ', '');
INSERT INTO `05diseases` VALUES ('1178', '面单纯疱疹', '248', 'B00.151', 'MDCPZ', '');
INSERT INTO `05diseases` VALUES ('1179', '唇单纯疱疹', '248', 'B00.152', 'CDCPZ', '');
INSERT INTO `05diseases` VALUES ('1180', '耳水疱皮炎', '70', 'B00.153', 'ESPPY', '');
INSERT INTO `05diseases` VALUES ('1181', '睑水疱皮炎', '252', 'B00.154', 'JSPPY', '');
INSERT INTO `05diseases` VALUES ('1182', '口腔疱疹', '248', 'B00.201', 'KQPZ', '');
INSERT INTO `05diseases` VALUES ('1183', '疱疹病毒性咽炎', '429', 'B00.203', 'PZBDXYY', '');
INSERT INTO `05diseases` VALUES ('1184', '疱疹性龈口炎', '248', 'B00.204', 'PZXYKY', '');
INSERT INTO `05diseases` VALUES ('1185', '疱疹病毒性咽扁桃体炎', '18', 'B00.251', 'PZBDXYBTTY', '');
INSERT INTO `05diseases` VALUES ('1186', '疱疹病毒性脑膜炎[单纯性疱疹]', '232', 'B00.301+', 'PZBDXNMYDCXPZ', '');
INSERT INTO `05diseases` VALUES ('1187', '疱疹性脑炎', '234', 'B00.401+', 'PZXNY', '');
INSERT INTO `05diseases` VALUES ('1188', '疱疹(单纯)性脑膜脑炎', '232', 'B00.451+', 'PZDCXNMNY', '');
INSERT INTO `05diseases` VALUES ('1189', '疱疹病毒性脑炎、脊髓炎或脑脊髓炎[单纯性疱疹]', '234', 'B00.452+', 'PZBDXNYJSYHNJSYDCXPZ', '');
INSERT INTO `05diseases` VALUES ('1190', '病毒性角膜炎', '167', 'B00.501+', 'BDXJMY', '');
INSERT INTO `05diseases` VALUES ('1191', '单纯性疱疹伴眼部并发症', '430', 'B00.502+', 'DCXPZBYBBFZ', '');
INSERT INTO `05diseases` VALUES ('1192', '疱疹性结膜炎', '174', 'B00.503+', 'PZXJMY', '');
INSERT INTO `05diseases` VALUES ('1193', '疱疹性眼炎', '430', 'B00.504+', 'PZXYY', '');
INSERT INTO `05diseases` VALUES ('1194', '树枝状角膜炎', '167', 'B00.505+', 'SZZJMY', '');
INSERT INTO `05diseases` VALUES ('1195', '单纯性疱疹性(盘状)角膜炎', '167', 'B00.506+', 'DCXPZXPZJMY', '');
INSERT INTO `05diseases` VALUES ('1196', '单纯疱疹性眼睑炎', '430', 'B00.551+', 'DCPZXYJY', '');
INSERT INTO `05diseases` VALUES ('1197', '疱疹性(单纯)角膜结膜炎', '174', 'B00.552+', 'PZXDCJMJMY', '');
INSERT INTO `05diseases` VALUES ('1198', '单纯疱疹性虹膜炎', '248', 'B00.553+', 'DCPZXHMY', '');
INSERT INTO `05diseases` VALUES ('1199', '疱疹性(单纯)葡萄膜炎', '248', 'B00.554+', 'PZXDCPTMY', '');
INSERT INTO `05diseases` VALUES ('1200', '疱疹病毒性前眼色素层炎', '430', 'B00.555+', 'PZBDXQYSSCY', '');
INSERT INTO `05diseases` VALUES ('1201', '疱疹性败血症', '9', 'B00.701', 'PZXBXZ', '');
INSERT INTO `05diseases` VALUES ('1202', 'ＥＢ病毒肠炎', '33', 'B00.801', 'BDCY', '');
INSERT INTO `05diseases` VALUES ('1203', 'ＥＢ病毒感染的病毒性肝炎', '93', 'B00.802+', 'BDGRDBDXGY', '');
INSERT INTO `05diseases` VALUES ('1204', 'ＥＢ病毒感染的病毒性肝炎伴肝昏迷', '93', 'B00.803+', 'BDGRDBDXGYBGHM', '');
INSERT INTO `05diseases` VALUES ('1205', '内脏单纯疱疹', '248', 'B00.851', 'NZDCPZ', '');
INSERT INTO `05diseases` VALUES ('1206', '疱疹病毒性瘭疽[化脓性指头炎]', '248', 'B00.852', 'PZBDXBJHNXZTY', '');
INSERT INTO `05diseases` VALUES ('1207', '疱疹病毒性肝炎', '93', 'B00.853+', 'PZBDXGY', '');
INSERT INTO `05diseases` VALUES ('1208', 'ＥＢ病毒感染', '95', 'B00.901', 'BDGR', '');
INSERT INTO `05diseases` VALUES ('1209', '单纯疱疹 NOS', '248', 'B00.902', 'DCPZ', '');
INSERT INTO `05diseases` VALUES ('1210', '疱疹 NOS', '248', 'B00.903', 'PZ', '');
INSERT INTO `05diseases` VALUES ('1211', '水痘性脑膜炎', '232', 'B01.051+', 'SDXNMY', '');
INSERT INTO `05diseases` VALUES ('1212', '水痘后脑炎、脊髓炎或脑脊髓炎', '234', 'B01.151+', 'SDHNYJSYHNJSY', '');
INSERT INTO `05diseases` VALUES ('1213', '水痘后脑脊髓炎', '234', 'B01.152+', 'SDHNJSY', '');
INSERT INTO `05diseases` VALUES ('1214', '水痘性肺炎', '81', 'B01.251+', 'SDXFY', '');
INSERT INTO `05diseases` VALUES ('1215', '水痘并败血症', '9', 'B01.851', 'SDBBXZ', '');
INSERT INTO `05diseases` VALUES ('1216', '水痘并丹毒', '336', 'B01.852', 'SDBDD', '');
INSERT INTO `05diseases` VALUES ('1217', '水痘并蜂窝组织炎', '336', 'B01.853', 'SDBFWZZY', '');
INSERT INTO `05diseases` VALUES ('1218', '水痘[羊痘] NOS', '336', 'B01.901', 'SDYD', '');
INSERT INTO `05diseases` VALUES ('1219', '湿疹样水痘', '320', 'B01.951', 'SZYSD', '');
INSERT INTO `05diseases` VALUES ('1220', '带状疱疹性神经根脊髓炎', '313', 'B02.001+', 'DZPZXSJGJSY', '');
INSERT INTO `05diseases` VALUES ('1221', '带状疱疹脑炎、脊髓炎或脑脊髓炎', '234', 'B02.051+', 'DZPZNYJSYHNJSY', '');
INSERT INTO `05diseases` VALUES ('1222', '带状疱疹性脑膜炎', '232', 'B02.101+', 'DZPZXNMY', '');
INSERT INTO `05diseases` VALUES ('1223', '带状疱疹性多颅神经麻痹', '313', 'B02.201+', 'DZPZXDLSJMB', '');
INSERT INTO `05diseases` VALUES ('1224', '带状疮疹后坐骨神经痛', '313', 'B02.202+', 'DZCZHZGSJT', '');
INSERT INTO `05diseases` VALUES ('1225', '带状疱疹性神经根炎', '313', 'B02.203+', 'DZPZXSJGY', '');
INSERT INTO `05diseases` VALUES ('1226', '亨特氏综合征(Hunt`s)', '278', 'B02.204+', 'HTSZHZ', '');
INSERT INTO `05diseases` VALUES ('1227', '疱疹后三叉神经痛', '313', 'B02.205+', 'PZHSCSJT', '');
INSERT INTO `05diseases` VALUES ('1228', '疱疹后神经痛', '313', 'B02.206+', 'PZHSJT', '');
INSERT INTO `05diseases` VALUES ('1229', '疱疹后膝状神经节炎', '313', 'B02.251+', 'PZHXZSJJY', '');
INSERT INTO `05diseases` VALUES ('1230', '带状疱疹后末稍神经炎', '313', 'B02.252+', 'DZPZHMSSJY', '');
INSERT INTO `05diseases` VALUES ('1231', '带状疱疹后肋间神经痛', '313', 'B02.253+', 'DZPZHLJSJT', '');
INSERT INTO `05diseases` VALUES ('1232', '疱疹后多神经病', '313', 'B02.254+', 'PZHDSJB', '');
INSERT INTO `05diseases` VALUES ('1233', '疱疹后周围神经病', '313', 'B02.255+', 'PZHZWSJB', '');
INSERT INTO `05diseases` VALUES ('1234', '耳部带状疱疹[亨特氏综合征]', '70', 'B02.256+', 'EBDZPZHTSZHZ', '');
INSERT INTO `05diseases` VALUES ('1235', '带状疱疹伴眼部并发症', '430', 'B02.301+', 'DZPZBYBBFZ', '');
INSERT INTO `05diseases` VALUES ('1236', '带状疱疹性眼炎', '430', 'B02.302+', 'DZPZXYY', '');
INSERT INTO `05diseases` VALUES ('1237', '眼睑带状疱疹', '430', 'B02.303+', 'YJDZPZ', '');
INSERT INTO `05diseases` VALUES ('1238', '带状疱疹并发眼睑皮炎', '430', 'B02.351+', 'DZPZBFYJPY', '');
INSERT INTO `05diseases` VALUES ('1239', '带状疱疹性睑炎', '248', 'B02.352+', 'DZPZXJY', '');
INSERT INTO `05diseases` VALUES ('1240', '带状疱疹性结膜炎', '174', 'B02.353+', 'DZPZXJMY', '');
INSERT INTO `05diseases` VALUES ('1241', '带状疱疹性巩膜炎', '248', 'B02.354+', 'DZPZXGMY', '');
INSERT INTO `05diseases` VALUES ('1242', '带状疱疹角膜炎', '167', 'B02.355+', 'DZPZJMY', '');
INSERT INTO `05diseases` VALUES ('1243', '带状疱疹并发角膜结膜炎', '174', 'B02.356+', 'DZPZBFJMJMY', '');
INSERT INTO `05diseases` VALUES ('1244', '带状疱疹性虹膜睫状体炎', '229', 'B02.357+', 'DZPZXHMJZTY', '');
INSERT INTO `05diseases` VALUES ('1245', '播散性带状疱疹', '248', 'B02.751', 'BSXDZPZ', '');
INSERT INTO `05diseases` VALUES ('1246', '外耳带状疱疹', '70', 'B02.801+', 'WEDZPZ', '');
INSERT INTO `05diseases` VALUES ('1247', '带状疱疹伴有其他并发症', '248', 'B02.851', 'DZPZBYQTBFZ', '');
INSERT INTO `05diseases` VALUES ('1248', '带状疱疹 NOS', '248', 'B02.901', 'DZPZ', '');
INSERT INTO `05diseases` VALUES ('1249', '天花', '349', 'B03.X01', 'TH', '');
INSERT INTO `05diseases` VALUES ('1250', '猴痘', '65', 'B04.X51', 'HD', '');
INSERT INTO `05diseases` VALUES ('1251', '麻疹后脑炎、脊髓炎或脑脊髓炎', '234', 'B05.001+', 'MZHNYJSYHNJSY', '');
INSERT INTO `05diseases` VALUES ('1252', '麻疹并发脑膜炎', '232', 'B05.151+', 'MZBFNMY', '');
INSERT INTO `05diseases` VALUES ('1253', '麻疹合并肺炎', '81', 'B05.201+', 'MZHBFY', '');
INSERT INTO `05diseases` VALUES ('1254', '麻疹后中耳炎', '70', 'B05.301+', 'MZHZEY', '');
INSERT INTO `05diseases` VALUES ('1255', '麻疹伴有肠的并发症', '219', 'B05.451', 'MZBYCDBFZ', '');
INSERT INTO `05diseases` VALUES ('1256', '麻疹并喉炎', '133', 'B05.801+', 'MZBHY', '');
INSERT INTO `05diseases` VALUES ('1257', '麻疹角膜炎', '167', 'B05.851+', 'MZJMY', '');
INSERT INTO `05diseases` VALUES ('1258', '麻疹角膜结膜炎', '174', 'B05.852+', 'MZJMJMY', '');
INSERT INTO `05diseases` VALUES ('1259', '麻疹 NOS', '219', 'B05.901', 'MZ', '');
INSERT INTO `05diseases` VALUES ('1260', '非典型麻疹综合征', '219', 'B05.951', 'FDXMZZHZ', '');
INSERT INTO `05diseases` VALUES ('1261', '风疹性脑膜炎', '232', 'B06.051+', 'FZXNMY', '');
INSERT INTO `05diseases` VALUES ('1262', '风疹性脑炎、脊髓炎或脑脊髓炎', '234', 'B06.052+', 'FZXNYJSYHNJSY', '');
INSERT INTO `05diseases` VALUES ('1263', '风疹性肺炎', '81', 'B06.851+', 'FZXFY', '');
INSERT INTO `05diseases` VALUES ('1264', '风疹性关节炎', '123', 'B06.852+', 'FZXGJY', '');
INSERT INTO `05diseases` VALUES ('1265', '风疹[流行性蔷薇疹]', '250', 'B06.901', 'FZLXXQWZ', '');
INSERT INTO `05diseases` VALUES ('1266', '扁平疣', '453', 'B07.X01', 'BPY', '');
INSERT INTO `05diseases` VALUES ('1267', '病毒性疣', '453', 'B07.X02', 'BDXY', '');
INSERT INTO `05diseases` VALUES ('1268', '寻常疣', '453', 'B07.X03', 'XCY', '');
INSERT INTO `05diseases` VALUES ('1269', '疣', '453', 'B07.X04', 'Y', '');
INSERT INTO `05diseases` VALUES ('1270', '指状疣', '453', 'B07.X05', 'ZZY', '');
INSERT INTO `05diseases` VALUES ('1271', '外耳道疣', '70', 'B07.X06', 'WEDY', '');
INSERT INTO `05diseases` VALUES ('1272', '副牛痘', '65', 'B08.001', 'FND', '');
INSERT INTO `05diseases` VALUES ('1273', '牛痘', '65', 'B08.051', 'ND', '');
INSERT INTO `05diseases` VALUES ('1274', '触染性脓疱性皮炎', '252', 'B08.052', 'CRXNPXPY', '');
INSERT INTO `05diseases` VALUES ('1275', '传染性软疣', '453', 'B08.101', 'CRXRY', '');
INSERT INTO `05diseases` VALUES ('1276', '触染性软疣[贝特曼氏病]', '453', 'B08.151', 'CRXRYBTMSB', '');
INSERT INTO `05diseases` VALUES ('1277', '幼儿急疹[婴儿玫瑰疹；第六病；猝发疹]', '454', 'B08.201', 'YEJZYEMGZDLBCFZ', '');
INSERT INTO `05diseases` VALUES ('1278', '传染性红斑[第五病]', '250', 'B08.301', 'CRXHBDWB', '');
INSERT INTO `05diseases` VALUES ('1279', '肠病毒性水疱性咽炎，伴有疹病', '429', 'B08.351', 'CBDXSPXYYBYZB', '');
INSERT INTO `05diseases` VALUES ('1280', '手足口病', '191', 'B08.401', 'SZKB', '');
INSERT INTO `05diseases` VALUES ('1281', '水疱性咽炎', '429', 'B08.501', 'SPXYY', '');
INSERT INTO `05diseases` VALUES ('1282', '肠病毒性水疱性咽炎', '429', 'B08.551', 'CBDXSPXYY', '');
INSERT INTO `05diseases` VALUES ('1283', '疱疹性咽峡炎', '428', 'B08.552', 'PZXYXY', '');
INSERT INTO `05diseases` VALUES ('1284', '阿弗他咽峡炎', '428', 'B08.553', 'AFTYXY', '');
INSERT INTO `05diseases` VALUES ('1285', '阿弗他咽炎', '429', 'B08.554', 'AFTYY', '');
INSERT INTO `05diseases` VALUES ('1286', '阿萨奇病毒性咽炎', '429', 'B08.555', 'ASQBDXYY', '');
INSERT INTO `05diseases` VALUES ('1287', '急性淋巴结节性咽炎', '429', 'B08.801', 'JXLBJJXYY', '');
INSERT INTO `05diseases` VALUES ('1288', '口蹄疫[口疮热]', '43', 'B08.802', 'KTYKCR', '');
INSERT INTO `05diseases` VALUES ('1289', '流行性粟疹热', '340', 'B08.803', 'LXXSZR', '');
INSERT INTO `05diseases` VALUES ('1290', '阿弗地热', '271', 'B08.851', 'AFDR', '');
INSERT INTO `05diseases` VALUES ('1291', '第四病[杜克疹热病]', '250', 'B08.852', 'DSBDKZRB', '');
INSERT INTO `05diseases` VALUES ('1292', '肠病毒性淋巴结咽炎', '429', 'B08.853', 'CBDXLBJYY', '');
INSERT INTO `05diseases` VALUES ('1293', '病毒性皮疹', '250', 'B09.X01', 'BDXPZ', '');
INSERT INTO `05diseases` VALUES ('1294', '病毒性粘膜疹', '250', 'B09.X51', 'BDXNMZ', '');
INSERT INTO `05diseases` VALUES ('1295', '甲型病毒性肝炎伴肝昏迷', '93', 'B15.001', 'JXBDXGYBGHM', '');
INSERT INTO `05diseases` VALUES ('1296', '急性甲型病毒性肝炎伴肝昏迷', '93', 'B15.051', 'JXJXBDXGYBGHM', '');
INSERT INTO `05diseases` VALUES ('1297', '亚急性甲型病毒性肝炎伴肝昏迷', '93', 'B15.052', 'YJXJXBDXGYBGHM', '');
INSERT INTO `05diseases` VALUES ('1298', '甲型病毒性肝炎', '93', 'B15.901', 'JXBDXGY', '');
INSERT INTO `05diseases` VALUES ('1299', '传染性肝炎', '93', 'B15.902', 'CRXGY', '');
INSERT INTO `05diseases` VALUES ('1300', '急性黄疸型甲型病毒性肝炎', '93', 'B15.903', 'JXHDXJXBDXGY', '');
INSERT INTO `05diseases` VALUES ('1301', '急性无黄疸型甲型病毒性肝炎', '93', 'B15.904', 'JXWHDXJXBDXGY', '');
INSERT INTO `05diseases` VALUES ('1302', '甲型病毒性肝炎胆汁淤积型', '93', 'B15.905', 'JXBDXGYDZYJX', '');
INSERT INTO `05diseases` VALUES ('1303', '甲型病毒性肝炎亚急性重型', '93', 'B15.906', 'JXBDXGYYJXZX', '');
INSERT INTO `05diseases` VALUES ('1304', '甲型病毒性重型肝炎', '93', 'B15.907', 'JXBDXZXGY', '');
INSERT INTO `05diseases` VALUES ('1305', '急性乙型病毒性肝炎伴有丁型肝炎病毒感染，并伴有肝昏迷', '93', 'B16.051', 'JXYXBDXGYBYDXGYBDGRB', '');
INSERT INTO `05diseases` VALUES ('1306', '急性乙型病毒性肝炎伴有丁型肝炎病毒感染，但不伴有肝昏迷', '93', 'B16.151', 'JXYXBDXGYBYDXGYBDGRD', '');
INSERT INTO `05diseases` VALUES ('1307', '急性乙型病毒性肝炎不伴有丁型肝炎病毒感染，并伴有肝昏迷', '93', 'B16.201', 'JXYXBDXGYBBYDXGYBDGR', '');
INSERT INTO `05diseases` VALUES ('1308', '急性乙型病毒性肝炎伴肝昏迷', '93', 'B16.251', 'JXYXBDXGYBGHM', '');
INSERT INTO `05diseases` VALUES ('1309', '亚急性乙型病毒性肝炎伴肝昏迷', '93', 'B16.252', 'YJXYXBDXGYBGHM', '');
INSERT INTO `05diseases` VALUES ('1310', '急性黄疸型乙型病毒性肝炎', '93', 'B16.901', 'JXHDXYXBDXGY', '');
INSERT INTO `05diseases` VALUES ('1311', '急性无黄疸型乙型病毒性肝炎', '93', 'B16.902', 'JXWHDXYXBDXGY', '');
INSERT INTO `05diseases` VALUES ('1312', '输血后肝炎(血清性肝炎)', '93', 'B16.903', 'SXHGYXQXGY', '');
INSERT INTO `05diseases` VALUES ('1313', '乙型病毒性肝炎', '93', 'B16.905', 'YXBDXGY', '');
INSERT INTO `05diseases` VALUES ('1314', '乙型病毒性重型肝炎', '93', 'B16.906', 'YXBDXZXGY', '');
INSERT INTO `05diseases` VALUES ('1315', '乙型病毒性肝炎胆汁淤积型', '93', 'B16.907', 'YXBDXGYDZYJX', '');
INSERT INTO `05diseases` VALUES ('1316', '乙型病毒性肝炎急性重型', '93', 'B16.908', 'YXBDXGYJXZX', '');
INSERT INTO `05diseases` VALUES ('1317', '乙型病毒性肝炎亚急性重型', '93', 'B16.909', 'YXBDXGYYJXZX', '');
INSERT INTO `05diseases` VALUES ('1318', '乙型肝炎相关性肾炎', '93', 'B16.910+', 'YXGYXGXSY', '');
INSERT INTO `05diseases` VALUES ('1319', '乙型肝炎病毒携带者的急性丁型肝炎病毒(重复)感染', '93', 'B17.051', 'YXGYBDXDZDJXDXGYBDZF', '');
INSERT INTO `05diseases` VALUES ('1320', '丙型病毒性肝炎', '93', 'B17.101', 'BXBDXGY', '');
INSERT INTO `05diseases` VALUES ('1321', '急性丙型病毒性肝炎伴黄疸型', '93', 'B17.102', 'JXBXBDXGYBHDX', '');
INSERT INTO `05diseases` VALUES ('1322', '急性丙型病毒性肝炎，无黄疸型', '93', 'B17.103', 'JXBXBDXGYWHDX', '');
INSERT INTO `05diseases` VALUES ('1323', '急性丙型病毒性肝炎，重型', '93', 'B17.104', 'JXBXBDXGYZX', '');
INSERT INTO `05diseases` VALUES ('1324', '亚急性丙型病毒性肝炎，重型', '93', 'B17.105', 'YJXBXBDXGYZX', '');
INSERT INTO `05diseases` VALUES ('1325', '丙型病毒性黄疸性肝炎', '93', 'B17.106', 'BXBDXHDXGY', '');
INSERT INTO `05diseases` VALUES ('1326', '急性丙型病毒性肝炎', '93', 'B17.151', 'JXBXBDXGY', '');
INSERT INTO `05diseases` VALUES ('1327', '戊型病毒性肝炎', '93', 'B17.201', 'WXBDXGY', '');
INSERT INTO `05diseases` VALUES ('1328', '戊型病毒性肝炎胆汁淤积型', '93', 'B17.202', 'WXBDXGYDZYJX', '');
INSERT INTO `05diseases` VALUES ('1329', '戊型病毒性肝炎急性黄疸型', '93', 'B17.203', 'WXBDXGYJXHDX', '');
INSERT INTO `05diseases` VALUES ('1330', '戊型病毒性肝炎急性无黄疸型', '93', 'B17.204', 'WXBDXGYJXWHDX', '');
INSERT INTO `05diseases` VALUES ('1331', '戊型病毒性肝炎急性重型', '93', 'B17.205', 'WXBDXGYJXZX', '');
INSERT INTO `05diseases` VALUES ('1332', '戊型病毒性肝炎亚急性重型', '93', 'B17.206', 'WXBDXGYYJXZX', '');
INSERT INTO `05diseases` VALUES ('1333', '戊型病毒性肝炎伴有肝昏迷', '93', 'B17.251', 'WXBDXGYBYGHM', '');
INSERT INTO `05diseases` VALUES ('1334', 'δ型肝炎', '93', 'B17.801', 'XGY', '');
INSERT INTO `05diseases` VALUES ('1335', 'δ型肝炎伴肝昏迷', '93', 'B17.802', 'XGYBGHM', '');
INSERT INTO `05diseases` VALUES ('1336', '病毒性肝炎,重叠感染', '93', 'B17.803', 'BDXGYZDGR', '');
INSERT INTO `05diseases` VALUES ('1337', '病毒性肝炎重叠感染', '93', 'B17.804', 'BDXGYZDGR', '');
INSERT INTO `05diseases` VALUES ('1338', '丁型病毒性肝炎', '93', 'B17.805', 'DXBDXGY', '');
INSERT INTO `05diseases` VALUES ('1339', '非甲非乙型肝炎', '93', 'B17.806', 'FJFYXGY', '');
INSERT INTO `05diseases` VALUES ('1340', '双重病毒感染性肝炎', '93', 'B17.807', 'SZBDGRXGY', '');
INSERT INTO `05diseases` VALUES ('1341', '三重感染性肝炎', '93', 'B17.809', 'SZGRXGY', '');
INSERT INTO `05diseases` VALUES ('1342', '庚型肝炎', '93', 'B17.811', 'GXGY', '');
INSERT INTO `05diseases` VALUES ('1343', '急性黄疸性丁型肝炎', '93', 'B17.812', 'JXHDXDXGY', '');
INSERT INTO `05diseases` VALUES ('1344', '其他特指的病毒性肝炎伴肝昏迷', '93', 'B17.813', 'QTTZDBDXGYBGHM', '');
INSERT INTO `05diseases` VALUES ('1345', '其他特指的重症病毒性肝炎', '93', 'B17.814', 'QTTZDZZBDXGY', '');
INSERT INTO `05diseases` VALUES ('1346', '急性庚型病毒性肝炎', '93', 'B17.851', 'JXGXBDXGY', '');
INSERT INTO `05diseases` VALUES ('1347', '非甲非乙型病毒性肝炎', '93', 'B17.852', 'FJFYXBDXGY', '');
INSERT INTO `05diseases` VALUES ('1348', '其他特指的急性病毒性肝炎伴肝昏迷', '93', 'B17.853', 'QTTZDJXBDXGYBGHM', '');
INSERT INTO `05diseases` VALUES ('1349', '慢性乙型病毒肝炎，伴有丁型肝炎病毒感染', '93', 'B18.051', 'MXYXBDGYBYDXGYBDGR', '');
INSERT INTO `05diseases` VALUES ('1350', '慢性活动性乙型肝炎', '93', 'B18.101', 'MXHDXYXGY', '');
INSERT INTO `05diseases` VALUES ('1351', '慢性重型乙型病毒肝炎', '93', 'B18.102', 'MXZXYXBDGY', '');
INSERT INTO `05diseases` VALUES ('1352', '慢性迁延型乙型病毒性肝炎', '93', 'B18.103', 'MXQYXYXBDXGY', '');
INSERT INTO `05diseases` VALUES ('1353', '慢性乙型病毒性肝炎，不伴有丁型肝炎病毒感染', '93', 'B18.151', 'MXYXBDXGYBBYDXGYBDGR', '');
INSERT INTO `05diseases` VALUES ('1354', '慢性活动性丙型病毒性肝炎', '93', 'B18.201', 'MXHDXBXBDXGY', '');
INSERT INTO `05diseases` VALUES ('1355', '慢性迁延性丙型病毒性肝炎', '93', 'B18.202', 'MXQYXBXBDXGY', '');
INSERT INTO `05diseases` VALUES ('1356', '慢性重型丙型病毒性肝炎', '93', 'B18.203', 'MXZXBXBDXGY', '');
INSERT INTO `05diseases` VALUES ('1357', '慢性丙型病毒性肝炎', '93', 'B18.251', 'MXBXBDXGY', '');
INSERT INTO `05diseases` VALUES ('1358', '慢性甲型活动性肝炎', '93', 'B18.801', 'MXJXHDXGY', '');
INSERT INTO `05diseases` VALUES ('1359', '慢性庚型病毒性肝炎', '93', 'B18.851', 'MXGXBDXGY', '');
INSERT INTO `05diseases` VALUES ('1360', '慢性戊型病毒性肝炎', '93', 'B18.852', 'MXWXBDXGY', '');
INSERT INTO `05diseases` VALUES ('1361', '慢性病毒性肝炎伴肝昏迷', '93', 'B18.853', 'MXBDXGYBGHM', '');
INSERT INTO `05diseases` VALUES ('1362', '其他慢性病毒性肝炎伴肝昏迷', '93', 'B18.854', 'QTMXBDXGYBGHM', '');
INSERT INTO `05diseases` VALUES ('1363', '慢性活动性病毒性肝炎', '93', 'B18.901', 'MXHDXBDXGY', '');
INSERT INTO `05diseases` VALUES ('1364', '慢性迁延性病毒性肝炎', '93', 'B18.902', 'MXQYXBDXGY', '');
INSERT INTO `05diseases` VALUES ('1365', '慢性重型病毒性肝炎', '93', 'B18.903', 'MXZXBDXGY', '');
INSERT INTO `05diseases` VALUES ('1366', '肝炎后综合征', '93', 'B18.904', 'GYHZHZ', '');
INSERT INTO `05diseases` VALUES ('1367', '慢性病毒性肝炎', '93', 'B18.951', 'MXBDXGY', '');
INSERT INTO `05diseases` VALUES ('1368', '病毒性肝炎伴肝昏迷', '93', 'B19.001', 'BDXGYBGHM', '');
INSERT INTO `05diseases` VALUES ('1369', '急性暴发性肝炎伴肝昏迷', '93', 'B19.002', 'JXBFXGYBGHM', '');
INSERT INTO `05diseases` VALUES ('1370', '急性病毒性肝炎伴肝昏迷 NOS', '93', 'B19.051', 'JXBDXGYBGHM', '');
INSERT INTO `05diseases` VALUES ('1371', '亚急性病毒性肝炎伴肝昏迷 NOS', '93', 'B19.052', 'YJXBDXGYBGHM', '');
INSERT INTO `05diseases` VALUES ('1372', '暴发性肝炎(急性重症肝炎)', '93', 'B19.901', 'BFXGYJXZZGY', '');
INSERT INTO `05diseases` VALUES ('1373', '病毒性肝炎 NOS', '93', 'B19.902', 'BDXGY', '');
INSERT INTO `05diseases` VALUES ('1374', '胆汁淤积型病毒性肝炎', '93', 'B19.903', 'DZYJXBDXGY', '');
INSERT INTO `05diseases` VALUES ('1375', '急性黄疸型病毒性肝炎', '93', 'B19.904', 'JXHDXBDXGY', '');
INSERT INTO `05diseases` VALUES ('1376', '急性无黄疸型病毒性肝炎', '93', 'B19.905', 'JXWHDXBDXGY', '');
INSERT INTO `05diseases` VALUES ('1377', '急性重型病毒性肝炎', '93', 'B19.906', 'JXZXBDXGY', '');
INSERT INTO `05diseases` VALUES ('1378', '亚急性重型病毒性肝炎', '93', 'B19.907', 'YJXZXBDXGY', '');
INSERT INTO `05diseases` VALUES ('1379', '人类免疫缺陷病毒[HIV]病造成的结核病', '171', 'B20.051', 'RLMYQXBDBZCDJHB', '');
INSERT INTO `05diseases` VALUES ('1380', '人类免疫缺陷病毒[HIV]病造成的分枝杆菌感染', '228', 'B20.052', 'RLMYQXBDBZCDFZGJGR', '');
INSERT INTO `05diseases` VALUES ('1381', '人类免疫缺陷病毒[HIV]病造成的其他细菌感染', '380', 'B20.151', 'RLMYQXBDBZCDQTXJGR', '');
INSERT INTO `05diseases` VALUES ('1382', '人类免疫缺陷病毒[HIV]病造成的巨细胞病毒感染', '228', 'B20.251', 'RLMYQXBDBZCDJXBBDGR', '');
INSERT INTO `05diseases` VALUES ('1383', '人类免疫缺陷病毒[HIV]病造成的其他病毒感染', '228', 'B20.351', 'RLMYQXBDBZCDQTBDGR', '');
INSERT INTO `05diseases` VALUES ('1384', '人类免疫缺陷病毒[HIV]病造成的念珠菌病', '228', 'B20.451', 'RLMYQXBDBZCDNZJB', '');
INSERT INTO `05diseases` VALUES ('1385', '人类免疫缺陷病毒[HIV]病造成的其他真菌病', '464', 'B20.551', 'RLMYQXBDBZCDQTZJB', '');
INSERT INTO `05diseases` VALUES ('1386', '人类免疫缺陷病毒[HIV]病造成的卡氏肺囊虫性肺炎', '81', 'B20.651', 'RLMYQXBDBZCDKSFNCXFY', '');
INSERT INTO `05diseases` VALUES ('1387', '人类免疫缺陷病毒[HIV]病造成的多发性感染', '228', 'B20.751', 'RLMYQXBDBZCDDFXGR', '');
INSERT INTO `05diseases` VALUES ('1388', '人类免疫缺陷病毒[HIV]病造成的传染病和寄生虫病', '156', 'B20.851', 'RLMYQXBDBZCDCRBHJSCB', '');
INSERT INTO `05diseases` VALUES ('1389', '人类免疫缺陷病毒[HIV]病造成的未特指的传染病和寄生虫病', '156', 'B20.951', 'RLMYQXBDBZCDWTZDCRBH', '');
INSERT INTO `05diseases` VALUES ('1390', '人类免疫缺陷病毒[HIV]病造成的卡波西肉瘤', '228', 'B21.051', 'RLMYQXBDBZCDKBXRL', '');
INSERT INTO `05diseases` VALUES ('1391', '人类免疫缺陷病毒[HIV]病造成的伯基特淋巴瘤', '228', 'B21.151', 'RLMYQXBDBZCDBJTLBL', '');
INSERT INTO `05diseases` VALUES ('1392', '人类免疫缺陷病毒[HIV]病造成的非霍奇[何杰]金氏淋巴瘤', '228', 'B21.251', 'RLMYQXBDBZCDFHQHJJSL', '');
INSERT INTO `05diseases` VALUES ('1393', '人类免疫缺陷病毒[HIV]病造成的恶性淋巴瘤', '228', 'B21.252', 'RLMYQXBDBZCDEXLBL', '');
INSERT INTO `05diseases` VALUES ('1395', '人类免疫缺陷病毒[HIV]病造成的多发性恶性肿瘤', '473', 'B21.751', 'RLMYQXBDBZCDDFXEXZL', '');
INSERT INTO `05diseases` VALUES ('1396', '人类免疫缺陷病毒[HIV]病造成的其他恶性肿瘤', '473', 'B21.851', 'RLMYQXBDBZCDQTEXZL', '');
INSERT INTO `05diseases` VALUES ('1397', '人类免疫缺陷病毒[HIV]病造成的未特指恶性肿瘤', '473', 'B21.951', 'RLMYQXBDBZCDWTZEXZL', '');
INSERT INTO `05diseases` VALUES ('1398', '人类免疫缺陷病毒[HIV]病造成的痴呆', '228', 'B22.051+', 'RLMYQXBDBZCDCD', '');
INSERT INTO `05diseases` VALUES ('1399', '人类免疫缺陷病毒[HIV]病造成的脑病', '228', 'B22.052', 'RLMYQXBDBZCDNB', '');
INSERT INTO `05diseases` VALUES ('1400', '人类免疫缺陷病毒[HIV]病造成的淋巴组织间质性肺炎', '81', 'B22.151', 'RLMYQXBDBZCDLBZZJZXF', '');
INSERT INTO `05diseases` VALUES ('1402', '人类免疫缺陷病毒[HIV]病造成的身材成长受阻', '228', 'B22.252', 'RLMYQXBDBZCDSCCCSZ', '');
INSERT INTO `05diseases` VALUES ('1403', '人类免疫缺陷病毒[HIV]病造分类于他处的多发性疾病', '228', 'B22.751', 'RLMYQXBDBZFLYTCDDFXJ', '');
INSERT INTO `05diseases` VALUES ('1404', '人类免疫缺陷病毒[HIV]感染综合征', '228', 'B23.051', 'RLMYQXBDGRZHZ', '');
INSERT INTO `05diseases` VALUES ('1405', '原始免疫细胞淋巴结病[血管性原始免疫细胞淋巴胞结病]', '228', 'B23.151', 'YSMYXBLBJBXGXYSMYXBL', '');
INSERT INTO `05diseases` VALUES ('1406', '人类免疫缺陷病毒[HIV]病造成的全身性(持续的)淋巴结病', '228', 'B23.152', 'RLMYQXBDBZCDQSXCXDLB', '');
INSERT INTO `05diseases` VALUES ('1408', '人类免疫缺陷病毒[HIV]病造成的其他特指情况', '228', 'B23.851', 'RLMYQXBDBZCDQTTZQK', '');
INSERT INTO `05diseases` VALUES ('1409', '艾滋病(Aids)[获得性免疫缺陷(不全)综合征]', '228', 'B24.X01', 'AZBHDXMYQXBQZHZ', '');
INSERT INTO `05diseases` VALUES ('1410', '艾滋病相关复合征[ARC] NOS', '268', 'B24.X51', 'AZBXGFHZ', '');
INSERT INTO `05diseases` VALUES ('1411', '巨细胞病毒性肺炎', '81', 'B25.051+', 'JXBBDXFY', '');
INSERT INTO `05diseases` VALUES ('1412', '巨细胞病毒性肝炎', '93', 'B25.101+', 'JXBBDXGY', '');
INSERT INTO `05diseases` VALUES ('1413', '巨细胞病毒感染的病毒性肝炎伴肝昏迷', '93', 'B25.102+', 'JXBBDGRDBDXGYBGHM', '');
INSERT INTO `05diseases` VALUES ('1414', '巨细胞包涵体病毒性肝炎', '93', 'B25.151+', 'JXBBHTBDXGY', '');
INSERT INTO `05diseases` VALUES ('1415', '巨细胞病毒性胰腺炎', '437', 'B25.251+', 'JXBBDXYXY', '');
INSERT INTO `05diseases` VALUES ('1416', '巨细胞病毒性脑炎、脊髓炎或脑脊髓炎', '234', 'B25.851+', 'JXBBDXNYJSYHNJSY', '');
INSERT INTO `05diseases` VALUES ('1417', '巨细胞病毒感染', '95', 'B25.901', 'JXBBDGR', '');
INSERT INTO `05diseases` VALUES ('1418', '巨细胞包涵体病', '376', 'B25.951', 'JXBBHTB', '');
INSERT INTO `05diseases` VALUES ('1419', '流行性腮腺炎性睾丸炎', '230', 'B26.001+', 'LXXSXYXGWY', '');
INSERT INTO `05diseases` VALUES ('1420', '流行性腮腺炎性脑膜炎', '232', 'B26.101+', 'LXXSXYXNMY', '');
INSERT INTO `05diseases` VALUES ('1421', '流行性腮腺炎性脑脊髓炎', '234', 'B26.201+', 'LXXSXYXNJSY', '');
INSERT INTO `05diseases` VALUES ('1422', '流行性腮腺炎性脑膜脑炎', '232', 'B26.202+', 'LXXSXYXNMNY', '');
INSERT INTO `05diseases` VALUES ('1423', '流行性腮腺炎性脑炎、脊髓炎或脑脊髓炎', '234', 'B26.203+', 'LXXSXYXNYJSYHNJSY', '');
INSERT INTO `05diseases` VALUES ('1424', '流行性腮腺炎性胰腺炎', '437', 'B26.301+', 'LXXSXYXYXY', '');
INSERT INTO `05diseases` VALUES ('1425', '流行生腮腺炎并其他并发症', '302', 'B26.801', 'LXSSXYBQTBFZ', '');
INSERT INTO `05diseases` VALUES ('1426', '流行性腮腺炎并颌下腺炎', '302', 'B26.802', 'LXXSXYBHXXY', '');
INSERT INTO `05diseases` VALUES ('1427', '流行性腮腺炎并胸骨前水肿', '302', 'B26.803', 'LXXSXYBXGQSZ', '');
INSERT INTO `05diseases` VALUES ('1428', '流行性腮腺炎并心肌炎', '397', 'B26.804+', 'LXXSXYBXJY', '');
INSERT INTO `05diseases` VALUES ('1429', '流行性腮腺炎性肝炎', '93', 'B26.805+', 'LXXSXYXGY', '');
INSERT INTO `05diseases` VALUES ('1430', '流行性腮腺炎性结膜炎', '174', 'B26.806+', 'LXXSXYXJMY', '');
INSERT INTO `05diseases` VALUES ('1431', '流行性腮腺炎性多神经病', '313', 'B26.851+', 'LXXSXYXDSJB', '');
INSERT INTO `05diseases` VALUES ('1432', '流行性腮腺炎性关节炎', '123', 'B26.852+', 'LXXSXYXGJY', '');
INSERT INTO `05diseases` VALUES ('1433', '流行性腮腺炎性肾炎', '315', 'B26.853+', 'LXXSXYXSY', '');
INSERT INTO `05diseases` VALUES ('1434', '流行性腮腺炎性卵巢炎', '86', 'B26.854+', 'LXXSXYXLCY', '');
INSERT INTO `05diseases` VALUES ('1435', '流行性腮腺炎 NOS', '302', 'B26.901', 'LXXSXY', '');
INSERT INTO `05diseases` VALUES ('1436', 'γ疱疹病毒性单核细胞增多症', '248', 'B27.051', 'PZBDXDHXBZDZ', '');
INSERT INTO `05diseases` VALUES ('1437', '传染性单核细胞增多症[菲拉托夫病]', '379', 'B27.052', 'CRXDHXBZDZFLTFB', '');
INSERT INTO `05diseases` VALUES ('1438', '巨细胞病毒性单核细胞增多症', '379', 'B27.151', 'JXBBDXDHXBZDZ', '');
INSERT INTO `05diseases` VALUES ('1439', '其他传染性单核细胞增多症', '379', 'B27.851', 'QTCRXDHXBZDZ', '');
INSERT INTO `05diseases` VALUES ('1440', '传染性单核细胞增多症 NOS', '379', 'B27.901', 'CRXDHXBZDZ', '');
INSERT INTO `05diseases` VALUES ('1441', '单核细胞性咽峡炎', '428', 'B27.951', 'DHXBXYXY', '');
INSERT INTO `05diseases` VALUES ('1442', '流行性角膜结膜炎[船乌病]', '174', 'B30.001+', 'LXXJMJMYCWB', '');
INSERT INTO `05diseases` VALUES ('1443', '腺病毒性角膜炎', '167', 'B30.051+', 'XBDXJMY', '');
INSERT INTO `05diseases` VALUES ('1444', '急性腺病毒性滤泡性结膜炎', '174', 'B30.151+', 'JXXBDXLPXJMY', '');
INSERT INTO `05diseases` VALUES ('1445', '游泳池结膜炎', '174', 'B30.152+', 'YYCJMY', '');
INSERT INTO `05diseases` VALUES ('1446', '咽结膜热', '173', 'B30.201+', 'YJMR', '');
INSERT INTO `05diseases` VALUES ('1447', '贝亚尔结膜炎', '174', 'B30.251+', 'BYEJMY', '');
INSERT INTO `05diseases` VALUES ('1448', '病毒性咽结膜炎 (热)', '174', 'B30.252+', 'BDXYJMYR', '');
INSERT INTO `05diseases` VALUES ('1449', '流行性出血性结膜炎', '174', 'B30.301+', 'LXXCXXJMY', '');
INSERT INTO `05diseases` VALUES ('1450', '２４型柯萨奇病毒性结膜炎', '174', 'B30.351+', 'XKSQBDXJMY', '');
INSERT INTO `05diseases` VALUES ('1451', '急性出血性结膜炎', '174', 'B30.352+', 'JXCXXJMY', '');
INSERT INTO `05diseases` VALUES ('1452', '其他病毒性结膜炎', '174', 'B30.851+', 'QTBDXJMY', '');
INSERT INTO `05diseases` VALUES ('1453', '新城结膜炎', '174', 'B30.852+', 'XCJMY', '');
INSERT INTO `05diseases` VALUES ('1454', '病毒性结膜炎 NOS', '174', 'B30.901+', 'BDXJMY', '');
INSERT INTO `05diseases` VALUES ('1455', '流行性结膜炎', '174', 'B30.902+', 'LXXJMY', '');
INSERT INTO `05diseases` VALUES ('1456', '流行性胸肌痛', '273', 'B33.001', 'LXXXJT', '');
INSERT INTO `05diseases` VALUES ('1457', '流行性肌痛', '273', 'B33.051', 'LXXJT', '');
INSERT INTO `05diseases` VALUES ('1458', '流行性肌炎', '146', 'B33.052', 'LXXJY', '');
INSERT INTO `05diseases` VALUES ('1459', '流行性胸膜痛[鬼抓风]', '273', 'B33.053', 'LXXXMTGZF', '');
INSERT INTO `05diseases` VALUES ('1460', '罗斯河热', '271', 'B33.151', 'LSHR', '');
INSERT INTO `05diseases` VALUES ('1461', '流行性多关节炎和疹病', '123', 'B33.152', 'LXXDGJYHZB', '');
INSERT INTO `05diseases` VALUES ('1462', '新生儿无菌性心肌炎', '397', 'B33.201+', 'XSEWJXXJY', '');
INSERT INTO `05diseases` VALUES ('1463', '柯萨奇(病毒性)心包炎', '394', 'B33.251+', 'KSQBDXXBY', '');
INSERT INTO `05diseases` VALUES ('1464', '柯萨奇病毒性心内膜炎', '401', 'B33.252+', 'KSQBDXXNMY', '');
INSERT INTO `05diseases` VALUES ('1465', '新生儿流行性心肌炎[柯萨奇病毒性]', '397', 'B33.253+', 'XSELXXXJYKSQBDX', '');
INSERT INTO `05diseases` VALUES ('1466', '柯萨奇(病毒性)心肌炎', '397', 'B33.254+', 'KSQBDXXJY', '');
INSERT INTO `05diseases` VALUES ('1467', '病毒性心炎', '404', 'B33.255+', 'BDXXY', '');
INSERT INTO `05diseases` VALUES ('1468', '逆病毒感染', '95', 'B33.351', 'NBDGR', '');
INSERT INTO `05diseases` VALUES ('1469', '传染性淋巴细胞增多症', '379', 'B33.801', 'CRXLBXBZDZ', '');
INSERT INTO `05diseases` VALUES ('1470', '急性传染性淋巴细胞增多症', '379', 'B33.802', 'JXCRXLBXBZDZ', '');
INSERT INTO `05diseases` VALUES ('1471', '假狂犬病[奥斯勒结节]', '194', 'B33.851', 'JKQBASLJJ', '');
INSERT INTO `05diseases` VALUES ('1472', '塔希纳热', '271', 'B33.852', 'TXNR', '');
INSERT INTO `05diseases` VALUES ('1473', '腺病毒感染 NOS', '95', 'B34.001', 'XBDGR', '');
INSERT INTO `05diseases` VALUES ('1474', '埃可病毒感染', '95', 'B34.101', 'AKBDGR', '');
INSERT INTO `05diseases` VALUES ('1475', '柯萨奇病毒感染', '95', 'B34.102', 'KSQBDGR', '');
INSERT INTO `05diseases` VALUES ('1476', '人日冕病毒感染[冠状病毒]', '95', 'B34.251', 'RRMBDGRGZBD', '');
INSERT INTO `05diseases` VALUES ('1477', '细小的病毒感染 NOS', '95', 'B34.351', 'XXDBDGR', '');
INSERT INTO `05diseases` VALUES ('1478', '乳头多瘤空泡病毒感染 NOS', '95', 'B34.451', 'RTDLKPBDGR', '');
INSERT INTO `05diseases` VALUES ('1479', '鼻病毒感染', '16', 'B34.801', 'BBDGR', '');
INSERT INTO `05diseases` VALUES ('1480', '其他未特指部位的病毒ＥＢ感染', '95', 'B34.851', 'QTWTZBWDBDGR', '');
INSERT INTO `05diseases` VALUES ('1481', '病毒感染 NOS', '95', 'B34.901', 'BDGR', '');
INSERT INTO `05diseases` VALUES ('1482', '病毒血症', '275', 'B34.951', 'BDXZ', '');
INSERT INTO `05diseases` VALUES ('1483', '脓癣', '250', 'B35.001', 'NX', '');
INSERT INTO `05diseases` VALUES ('1484', '头癣', '250', 'B35.002', 'TX', '');
INSERT INTO `05diseases` VALUES ('1485', '须癣', '250', 'B35.051', 'XX', '');
INSERT INTO `05diseases` VALUES ('1486', '霉菌性须疮', '227', 'B35.052', 'MJXXC', '');
INSERT INTO `05diseases` VALUES ('1487', '甲癣[甲霉菌病，俗称灰指甲]', '226', 'B35.101', 'JXJMJBSCHZJ', '');
INSERT INTO `05diseases` VALUES ('1488', '指甲皮真菌病', '464', 'B35.151', 'ZJPZJB', '');
INSERT INTO `05diseases` VALUES ('1489', '皮霉菌性甲床炎', '227', 'B35.152', 'PMJXJCY', '');
INSERT INTO `05diseases` VALUES ('1490', '甲真菌病', '464', 'B35.153', 'JZJB', '');
INSERT INTO `05diseases` VALUES ('1491', '手癣', '250', 'B35.201', 'SX', '');
INSERT INTO `05diseases` VALUES ('1492', '手皮真菌病', '464', 'B35.251', 'SPZJB', '');
INSERT INTO `05diseases` VALUES ('1493', '足癣', '250', 'B35.301', 'ZX', '');
INSERT INTO `05diseases` VALUES ('1494', '足皮真菌病', '464', 'B35.351', 'ZPZJB', '');
INSERT INTO `05diseases` VALUES ('1495', '钱癣', '250', 'B35.401', 'QX', '');
INSERT INTO `05diseases` VALUES ('1496', '体癣', '250', 'B35.402', 'TX', '');
INSERT INTO `05diseases` VALUES ('1497', '叠瓦癣', '250', 'B35.551', 'DWX', '');
INSERT INTO `05diseases` VALUES ('1498', '股癣', '250', 'B35.601', 'GX', '');
INSERT INTO `05diseases` VALUES ('1499', '腹股沟癣', '250', 'B35.651', 'FGGX', '');
INSERT INTO `05diseases` VALUES ('1500', '洗衣员癣', '250', 'B35.652', 'XYYX', '');
INSERT INTO `05diseases` VALUES ('1501', '轮廓性湿疹[巴伦斯普郎氏病、黑布腊]', '320', 'B35.653', 'LKXSZBLSPLSBHBL', '');
INSERT INTO `05diseases` VALUES ('1502', '手足癣', '250', 'B35.851', 'SZX', '');
INSERT INTO `05diseases` VALUES ('1503', '肛周区癣', '250', 'B35.852', 'GZQX', '');
INSERT INTO `05diseases` VALUES ('1504', '变色性皮癣', '250', 'B35.853', 'BSXPX', '');
INSERT INTO `05diseases` VALUES ('1505', '播散性皮真菌病', '464', 'B35.854', 'BSXPZJB', '');
INSERT INTO `05diseases` VALUES ('1506', '肉芽肿性皮真菌病', '464', 'B35.855', 'RYZXPZJB', '');
INSERT INTO `05diseases` VALUES ('1507', '黄癣', '250', 'B35.901', 'HX', '');
INSERT INTO `05diseases` VALUES ('1508', '皮真菌病(皮癣菌疹)', '464', 'B35.902', 'PZJBPXJZ', '');
INSERT INTO `05diseases` VALUES ('1509', '其他和未特指的皮真菌病', '464', 'B35.951', 'QTHWTZDPZJB', '');
INSERT INTO `05diseases` VALUES ('1510', '癣 NOS', '250', 'B35.952', 'X', '');
INSERT INTO `05diseases` VALUES ('1511', '花斑癣(花斑糠疹)[艾克斯特德氏病]', '250', 'B36.001', 'HBXHBKZAKSTDSB', '');
INSERT INTO `05diseases` VALUES ('1512', '糠秕孢子性毛囊炎', '224', 'B36.002', 'KBBZXMNY', '');
INSERT INTO `05diseases` VALUES ('1513', '热带花斑癣', '250', 'B36.051', 'RDHBX', '');
INSERT INTO `05diseases` VALUES ('1514', '斑状糠疹', '250', 'B36.052', 'BZKZ', '');
INSERT INTO `05diseases` VALUES ('1515', '黑癣', '250', 'B36.101', 'HX', '');
INSERT INTO `05diseases` VALUES ('1516', '黑糠疹', '250', 'B36.151', 'HKZ', '');
INSERT INTO `05diseases` VALUES ('1517', '黑色小孢子菌病', '14', 'B36.152', 'HSXBZJB', '');
INSERT INTO `05diseases` VALUES ('1518', '掌肌微黑色膜霉菌病', '226', 'B36.153', 'ZJWHSMMJB', '');
INSERT INTO `05diseases` VALUES ('1519', '白癣', '250', 'B36.201', 'BX', '');
INSERT INTO `05diseases` VALUES ('1520', '黑色发结节病', '172', 'B36.351', 'HSFJJB', '');
INSERT INTO `05diseases` VALUES ('1521', '其他特指的表面的霉菌病', '226', 'B36.851', 'QTTZDBMDMJB', '');
INSERT INTO `05diseases` VALUES ('1522', '霉菌性皮炎 NOS', '252', 'B36.901', 'MJXPY', '');
INSERT INTO `05diseases` VALUES ('1523', '霉菌性外耳道炎', '70', 'B36.902+', 'MJXWEDY', '');
INSERT INTO `05diseases` VALUES ('1524', '表面的霉菌病 NOS', '226', 'B36.951', 'BMDMJB', '');
INSERT INTO `05diseases` VALUES ('1525', '口腔念珠菌感染(鹅口疮)', '95', 'B37.001', 'KQNZJGREKC', '');
INSERT INTO `05diseases` VALUES ('1526', '咽鹅口疮', '43', 'B37.002', 'YEKC', '');
INSERT INTO `05diseases` VALUES ('1527', '口腔苍白', '191', 'B37.051', 'KQCB', '');
INSERT INTO `05diseases` VALUES ('1528', '口腔霉菌感染', '95', 'B37.052', 'KQMJGR', '');
INSERT INTO `05diseases` VALUES ('1529', '念珠菌性口炎', '193', 'B37.053', 'NZJXKY', '');
INSERT INTO `05diseases` VALUES ('1530', '口鹅口疮', '43', 'B37.054', 'KEKC', '');
INSERT INTO `05diseases` VALUES ('1531', '肺念珠菌病', '236', 'B37.101+', 'FNZJB', '');
INSERT INTO `05diseases` VALUES ('1532', '念珠菌性皮炎', '252', 'B37.201', 'NZJXPY', '');
INSERT INTO `05diseases` VALUES ('1533', '肢端念珠菌感染', '95', 'B37.202', 'ZDNZJGR', '');
INSERT INTO `05diseases` VALUES ('1534', '念珠菌性甲床炎', '277', 'B37.251', 'NZJXJCY', '');
INSERT INTO `05diseases` VALUES ('1535', '念珠菌性甲沟炎', '157', 'B37.252', 'NZJXJGY', '');
INSERT INTO `05diseases` VALUES ('1536', '念珠菌性阴道炎', '86', 'B37.301+', 'NZJXYDY', '');
INSERT INTO `05diseases` VALUES ('1537', '霉菌性外阴炎', '368', 'B37.302+', 'MJXWYY', '');
INSERT INTO `05diseases` VALUES ('1538', '念珠菌性外阴阴道炎', '86', 'B37.351+', 'NZJXWYYDY', '');
INSERT INTO `05diseases` VALUES ('1539', '泌尿道念珠菌感染', '95', 'B37.401+', 'MNDNZJGR', '');
INSERT INTO `05diseases` VALUES ('1540', '念珠菌性尿道口炎', '193', 'B37.402+', 'NZJXNDKY', '');
INSERT INTO `05diseases` VALUES ('1541', '念珠菌性龟头炎', '126', 'B37.451+', 'NZJXGTY', '');
INSERT INTO `05diseases` VALUES ('1542', '念珠菌性脑膜炎', '232', 'B37.551+', 'NZJXNMY', '');
INSERT INTO `05diseases` VALUES ('1543', '念珠菌性心内膜炎', '401', 'B37.601+', 'NZJXXNMY', '');
INSERT INTO `05diseases` VALUES ('1544', '念珠菌性败血症', '9', 'B37.751', 'NZJXBXZ', '');
INSERT INTO `05diseases` VALUES ('1545', '播散性念珠菌病', '236', 'B37.801', 'BSXNZJB', '');
INSERT INTO `05diseases` VALUES ('1546', '肠道念珠菌病', '31', 'B37.802', 'CDNZJB', '');
INSERT INTO `05diseases` VALUES ('1547', '呼吸道念珠菌感染', '95', 'B37.803', 'HXDNZJGR', '');
INSERT INTO `05diseases` VALUES ('1548', '脑念珠菌感染', '95', 'B37.804', 'NNZJGR', '');
INSERT INTO `05diseases` VALUES ('1549', '支气管念珠菌病', '279', 'B37.805', 'ZQGNZJB', '');
INSERT INTO `05diseases` VALUES ('1550', '视神经念珠菌感染', '313', 'B37.806+', 'SSJNZJGR', '');
INSERT INTO `05diseases` VALUES ('1551', '念珠菌性肠炎', '33', 'B37.851', 'NZJXCY', '');
INSERT INTO `05diseases` VALUES ('1552', '念珠菌性唇炎', '277', 'B37.852', 'NZJXCY', '');
INSERT INTO `05diseases` VALUES ('1553', '念珠菌感染', '95', 'B37.901', 'NZJGR', '');
INSERT INTO `05diseases` VALUES ('1554', '鹅口疮 NOS', '43', 'B37.951', 'EKC', '');
INSERT INTO `05diseases` VALUES ('1555', '圣华金河(谷)热[球孢子菌病]', '14', 'B38.051+', 'SHJHGRQBZJB', '');
INSERT INTO `05diseases` VALUES ('1556', '急性肺球孢子菌病', '14', 'B38.052+', 'JXFQBZJB', '');
INSERT INTO `05diseases` VALUES ('1557', '慢性肺球孢子菌病', '14', 'B38.151+', 'MXFQBZJB', '');
INSERT INTO `05diseases` VALUES ('1558', '肺球孢子菌病 NOS', '14', 'B38.201+', 'FQBZJB', '');
INSERT INTO `05diseases` VALUES ('1559', '皮肤球孢子菌病', '250', 'B38.351+', 'PFQBZJB', '');
INSERT INTO `05diseases` VALUES ('1560', '球孢子菌病脑膜炎', '232', 'B38.451+', 'QBZJBNMY', '');
INSERT INTO `05diseases` VALUES ('1561', '播散性球孢子菌病', '14', 'B38.751', 'BSXQBZJB', '');
INSERT INTO `05diseases` VALUES ('1562', '全身性球孢子菌病', '14', 'B38.752', 'QSXQBZJB', '');
INSERT INTO `05diseases` VALUES ('1563', '前列腺球孢子菌病', '14', 'B38.851', 'QLXQBZJB', '');
INSERT INTO `05diseases` VALUES ('1564', '球孢子菌病', '14', 'B38.901', 'QBZJB', '');
INSERT INTO `05diseases` VALUES ('1565', '急性肺荚膜组织胞浆菌病', '188', 'B39.051+', 'JXFJMZZBJJB', '');
INSERT INTO `05diseases` VALUES ('1566', '慢性肺荚膜组织胞浆菌病', '188', 'B39.151+', 'MXFJMZZBJJB', '');
INSERT INTO `05diseases` VALUES ('1567', '肺组织胞浆菌病', '188', 'B39.201+', 'FZZBJJB', '');
INSERT INTO `05diseases` VALUES ('1568', '肺荚膜组织胞浆菌病 NOS', '188', 'B39.251+', 'FJMZZBJJB', '');
INSERT INTO `05diseases` VALUES ('1569', '播散性荚膜组织胞浆菌病', '188', 'B39.352', 'BSXJMZZBJJB', '');
INSERT INTO `05diseases` VALUES ('1570', '全身性荚膜组织胞浆菌病', '188', 'B39.353', 'QSXJMZZBJJB', '');
INSERT INTO `05diseases` VALUES ('1571', '荚膜组织胞浆菌病 NOS', '188', 'B39.451', 'JMZZBJJB', '');
INSERT INTO `05diseases` VALUES ('1572', '杜波依西变种组织胞浆菌病', '188', 'B39.551', 'DBYXBZZZBJJB', '');
INSERT INTO `05diseases` VALUES ('1573', '组织胞浆菌病 NOS', '188', 'B39.901', 'ZZBJJB', '');
INSERT INTO `05diseases` VALUES ('1574', '急性肺芽生菌病', '426', 'B40.051+', 'JXFYSJB', '');
INSERT INTO `05diseases` VALUES ('1575', '慢性肺芽生菌病', '426', 'B40.151+', 'MXFYSJB', '');
INSERT INTO `05diseases` VALUES ('1576', '肺芽生菌病 NOS', '426', 'B40.201+', 'FYSJB', '');
INSERT INTO `05diseases` VALUES ('1577', '芽生菌性脓皮病', '268', 'B40.301+', 'YSJXNPB', '');
INSERT INTO `05diseases` VALUES ('1578', '芽生菌性皮炎', '252', 'B40.302+', 'YSJXPY', '');
INSERT INTO `05diseases` VALUES ('1579', '播散性芽生菌病', '426', 'B40.751', 'BSXYSJB', '');
INSERT INTO `05diseases` VALUES ('1580', '全身性芽生菌病', '426', 'B40.752', 'QSXYSJB', '');
INSERT INTO `05diseases` VALUES ('1581', '其他形式的芽生菌病', '426', 'B40.851', 'QTXSDYSJB', '');
INSERT INTO `05diseases` VALUES ('1582', '芽生菌病(酿母菌病) NOS', '426', 'B40.901', 'YSJBNMJB', '');
INSERT INTO `05diseases` VALUES ('1583', '肺类球孢子菌病', '14', 'B41.051+', 'FLQBZJB', '');
INSERT INTO `05diseases` VALUES ('1584', '播散性类球孢子菌病', '14', 'B41.751', 'BSXLQBZJB', '');
INSERT INTO `05diseases` VALUES ('1585', '全身性类球孢子菌病', '14', 'B41.752', 'QSXLQBZJB', '');
INSERT INTO `05diseases` VALUES ('1586', '其他形式类球孢子菌病', '14', 'B41.851', 'QTXSLQBZJB', '');
INSERT INTO `05diseases` VALUES ('1587', '类球孢子菌肉芽肿', '295', 'B41.901', 'LQBZJRYZ', '');
INSERT INTO `05diseases` VALUES ('1588', '类球孢子菌病 NOS', '14', 'B41.951', 'LQBZJB', '');
INSERT INTO `05diseases` VALUES ('1589', '肺孢子丝菌病', '188', 'B42.001+', 'FBZSJB', '');
INSERT INTO `05diseases` VALUES ('1590', '淋巴皮肤的孢子丝菌病', '250', 'B42.151', 'LBPFDBZSJB', '');
INSERT INTO `05diseases` VALUES ('1591', '播散性孢子丝菌病', '188', 'B42.751', 'BSXBZSJB', '');
INSERT INTO `05diseases` VALUES ('1592', '全身性孢子丝菌病', '188', 'B42.752', 'QSXBZSJB', '');
INSERT INTO `05diseases` VALUES ('1593', '其他形式孢子丝菌病', '188', 'B42.851', 'QTXSBZSJB', '');
INSERT INTO `05diseases` VALUES ('1594', '孢子丝菌病 NOS', '188', 'B42.901', 'BZSJB', '');
INSERT INTO `05diseases` VALUES ('1595', '皮肤着色真菌病', '464', 'B43.051+', 'PFZSZJB', '');
INSERT INTO `05diseases` VALUES ('1596', '疣状皮炎', '252', 'B43.052+', 'YZPY', '');
INSERT INTO `05diseases` VALUES ('1597', '棕色真菌病性脑脓肿', '464', 'B43.151+', 'ZSZJBXNNZ', '');
INSERT INTO `05diseases` VALUES ('1598', '大脑着色真菌病', '464', 'B43.152+', 'DNZSZJB', '');
INSERT INTO `05diseases` VALUES ('1599', '皮棕色真菌病性脓肿和囊肿', '464', 'B43.251+', 'PZSZJBXNZHNZ', '');
INSERT INTO `05diseases` VALUES ('1600', '皮下囊肿', '231', 'B43.252+', 'PXNZ', '');
INSERT INTO `05diseases` VALUES ('1601', '其他形式的着色真菌病', '464', 'B43.851', 'QTXSDZSZJB', '');
INSERT INTO `05diseases` VALUES ('1602', '着色真菌病 NOS', '464', 'B43.901', 'ZSZJB', '');
INSERT INTO `05diseases` VALUES ('1603', '侵入性肺曲霉病', '290', 'B44.051+', 'QRXFQMB', '');
INSERT INTO `05diseases` VALUES ('1604', '变态反应性支气管肺曲菌病', '279', 'B44.101+', 'BTFYXZQGFQJB', '');
INSERT INTO `05diseases` VALUES ('1605', '肺曲菌病', '188', 'B44.102+', 'FQJB', '');
INSERT INTO `05diseases` VALUES ('1606', '曲霉菌性肺炎', '81', 'B44.103+', 'QMJXFY', '');
INSERT INTO `05diseases` VALUES ('1607', '其他肺曲菌病[第状菌]', '188', 'B44.151', 'QTFQJBDZJ', '');
INSERT INTO `05diseases` VALUES ('1608', '扁桃体曲霉病', '290', 'B44.251', 'BTTQMB', '');
INSERT INTO `05diseases` VALUES ('1609', '播散性曲霉病', '290', 'B44.751', 'BSXQMB', '');
INSERT INTO `05diseases` VALUES ('1610', '全身性曲霉病', '290', 'B44.752', 'QSXQMB', '');
INSERT INTO `05diseases` VALUES ('1611', '上颌窦曲菌病', '188', 'B44.801', 'SHDQJB', '');
INSERT INTO `05diseases` VALUES ('1612', '耳曲霉病(香港耳)', '70', 'B44.851', 'EQMBXGE', '');
INSERT INTO `05diseases` VALUES ('1613', '曲霉菌病(曲菌病) NOS', '226', 'B44.901', 'QMJBQJB', '');
INSERT INTO `05diseases` VALUES ('1614', '肺隐球菌病', '188', 'B45.001+', 'FYQJB', '');
INSERT INTO `05diseases` VALUES ('1615', '新型隐球菌性脑膜炎', '232', 'B45.101+', 'XXYQJXNMY', '');
INSERT INTO `05diseases` VALUES ('1616', '隐球菌性脑膜炎', '232', 'B45.102+', 'YQJXNMY', '');
INSERT INTO `05diseases` VALUES ('1617', '隐球菌性脑炎', '234', 'B45.103+', 'YQJXNY', '');
INSERT INTO `05diseases` VALUES ('1618', '皮肤隐球菌病', '250', 'B45.251+', 'PFYQJB', '');
INSERT INTO `05diseases` VALUES ('1619', '骨隐球菌病', '188', 'B45.351+', 'GYQJB', '');
INSERT INTO `05diseases` VALUES ('1620', '播散性隐球菌病', '188', 'B45.751', 'BSXYQJB', '');
INSERT INTO `05diseases` VALUES ('1621', '全身性隐球菌病', '188', 'B45.752', 'QSXYQJB', '');
INSERT INTO `05diseases` VALUES ('1622', '其他形式的隐球菌病', '188', 'B45.851', 'QTXSDYQJB', '');
INSERT INTO `05diseases` VALUES ('1623', '隐球菌病 NOS', '188', 'B45.901', 'YQJB', '');
INSERT INTO `05diseases` VALUES ('1624', '肺毛霉菌病', '226', 'B46.001+', 'FMMJB', '');
INSERT INTO `05diseases` VALUES ('1625', '鼻大脑毛霉菌病', '16', 'B46.151+', 'BDNMMJB', '');
INSERT INTO `05diseases` VALUES ('1626', '胃肠毛霉菌病', '370', 'B46.251+', 'WCMMJB', '');
INSERT INTO `05diseases` VALUES ('1627', '虫霉菌病[皮下组织型藻菌病]', '226', 'B46.351+', 'CMJBPXZZXZJB', '');
INSERT INTO `05diseases` VALUES ('1628', '播散性毛霉菌病', '226', 'B46.451', 'BSXMMJB', '');
INSERT INTO `05diseases` VALUES ('1629', '全身性毛霉菌病', '226', 'B46.452', 'QSXMMJB', '');
INSERT INTO `05diseases` VALUES ('1630', '毛霉菌病(藻菌病) NOS', '226', 'B46.501', 'MMJBZJB', '');
INSERT INTO `05diseases` VALUES ('1631', '蝇疫霉病', '268', 'B46.851', 'YYMB', '');
INSERT INTO `05diseases` VALUES ('1632', '藻菌病', '188', 'B46.951', 'ZJB', '');
INSERT INTO `05diseases` VALUES ('1633', '接合菌病 NOS', '188', 'B46.952', 'JHJB', '');
INSERT INTO `05diseases` VALUES ('1634', '霉菌性足分支菌病', '188', 'B47.051', 'MJXZFZJB', '');
INSERT INTO `05diseases` VALUES ('1635', '放线菌瘤', '261', 'B47.151', 'FXJL', '');
INSERT INTO `05diseases` VALUES ('1636', '足分支菌病 NOS', '188', 'B47.951', 'ZFZJB', '');
INSERT INTO `05diseases` VALUES ('1637', '瘢痕瘤性芽生菌病', '426', 'B48.051', 'BHLXYSJB', '');
INSERT INTO `05diseases` VALUES ('1638', '洛博病', '268', 'B48.052', 'LBB', '');
INSERT INTO `05diseases` VALUES ('1639', '洛博芽生菌病', '426', 'B48.053', 'LBYSJB', '');
INSERT INTO `05diseases` VALUES ('1640', '鼻孢子虫病', '16', 'B48.151', 'BBZCB', '');
INSERT INTO `05diseases` VALUES ('1641', '波伊德假霉样真菌感染', '464', 'B48.251', 'BYDJMYZJGR', '');
INSERT INTO `05diseases` VALUES ('1642', '霉样真菌病', '464', 'B48.252', 'MYZJB', '');
INSERT INTO `05diseases` VALUES ('1643', '地丝菌病', '188', 'B48.351', 'DSJB', '');
INSERT INTO `05diseases` VALUES ('1644', '地丝菌口炎', '193', 'B48.352', 'DSJKY', '');
INSERT INTO `05diseases` VALUES ('1645', '青霉病', '268', 'B48.451', 'QMB', '');
INSERT INTO `05diseases` VALUES ('1646', '机遇性霉菌病', '226', 'B48.751', 'JYXMJB', '');
INSERT INTO `05diseases` VALUES ('1647', '霉菌性龟头包皮炎', '126', 'B48.851', 'MJXGTBPY', '');
INSERT INTO `05diseases` VALUES ('1648', '不育大孢子菌病', '14', 'B48.852', 'BYDBZJB', '');
INSERT INTO `05diseases` VALUES ('1649', '肠道霉菌感染[霉菌性结肠炎]', '33', 'B49.X01', 'CDMJGRMJXJCY', '');
INSERT INTO `05diseases` VALUES ('1650', '肺霉菌感染', '95', 'B49.X02', 'FMJGR', '');
INSERT INTO `05diseases` VALUES ('1651', '霉菌性泌尿道感染', '95', 'B49.X03', 'MJXMNDGR', '');
INSERT INTO `05diseases` VALUES ('1652', '霉菌性蝶窦炎', '227', 'B49.X04+', 'MJXDDY', '');
INSERT INTO `05diseases` VALUES ('1653', '霉菌性颌窦炎', '227', 'B49.X05', 'MJXHDY', '');
INSERT INTO `05diseases` VALUES ('1654', '霉菌感染', '95', 'B49.X06', 'MJGR', '');
INSERT INTO `05diseases` VALUES ('1655', '霉菌性筛窦炎', '227', 'B49.X07+', 'MJXSDY', '');
INSERT INTO `05diseases` VALUES ('1656', '霉菌性泌尿系感染', '95', 'B49.X08', 'MJXMNXGR', '');
INSERT INTO `05diseases` VALUES ('1657', '脑霉菌感染', '95', 'B49.X09+', 'NMJGR', '');
INSERT INTO `05diseases` VALUES ('1658', '霉菌性食管炎', '227', 'B49.X10+', 'MJXSGY', '');
INSERT INTO `05diseases` VALUES ('1659', '呼吸道霉菌感染', '95', 'B49.X11', 'HXDMJGR', '');
INSERT INTO `05diseases` VALUES ('1660', '真菌性脑膜炎', '464', 'B49.X12+', 'ZJXNMY', '');
INSERT INTO `05diseases` VALUES ('1661', '霉菌性角膜炎', '167', 'B49.X13+', 'MJXJMY', '');
INSERT INTO `05diseases` VALUES ('1662', '垂体霉菌感染', '95', 'B49.X14+', 'CTMJGR', '');
INSERT INTO `05diseases` VALUES ('1663', '支气管霉菌感染', '95', 'B49.X15', 'ZQGMJGR', '');
INSERT INTO `05diseases` VALUES ('1664', '霉菌性上颌窦炎', '227', 'B49.X16+', 'MJXSHDY', '');
INSERT INTO `05diseases` VALUES ('1665', '真菌病', '464', 'B49.X51', 'ZJB', '');
INSERT INTO `05diseases` VALUES ('1666', '脑型疟(疾)', '234', 'B50.001+', 'NXYJ', '');
INSERT INTO `05diseases` VALUES ('1667', '黑水热[黑尿热]', '269', 'B50.801', 'HSRHNR', '');
INSERT INTO `05diseases` VALUES ('1668', '疟疾伴有黑水热', '244', 'B50.851', 'YJBYHSR', '');
INSERT INTO `05diseases` VALUES ('1669', '恶性疟(恶性间日疟)', '278', 'B50.901', 'EXYEXJRY', '');
INSERT INTO `05diseases` VALUES ('1670', '恶性超高热型疟疾', '244', 'B50.951', 'EXCGRXYJ', '');
INSERT INTO `05diseases` VALUES ('1671', '恶性厥冷型疟疾', '244', 'B50.952+', 'EXJLXYJ', '');
INSERT INTO `05diseases` VALUES ('1672', '间日疟原虫疟疾伴脾破裂', '455', 'B51.051+', 'JRYYCYJBPPL', '');
INSERT INTO `05diseases` VALUES ('1673', '间日疟原虫疟疾伴其他并发症', '455', 'B51.851', 'JRYYCYJBQTBFZ', '');
INSERT INTO `05diseases` VALUES ('1674', '间日疟 NOS', '278', 'B51.901', 'JRY', '');
INSERT INTO `05diseases` VALUES ('1675', '疟疾性肾病变', '314', 'B52.051+', 'YJXSBB', '');
INSERT INTO `05diseases` VALUES ('1676', '疟疾性肾病', '314', 'B52.052+', 'YJXSB', '');
INSERT INTO `05diseases` VALUES ('1677', '三日疟疾伴有肝病', '92', 'B52.851+', 'SRYJBYGB', '');
INSERT INTO `05diseases` VALUES ('1678', '三日疟 NOS', '278', 'B52.901', 'SRY', '');
INSERT INTO `05diseases` VALUES ('1679', '卵形疟原虫疟疾', '455', 'B53.051', 'LXYYCYJ', '');
INSERT INTO `05diseases` VALUES ('1680', '猴疟原虫疟疾', '455', 'B53.151', 'HYYCYJ', '');
INSERT INTO `05diseases` VALUES ('1681', '疗病诱发的疟疾(经寄生虫证实)', '156', 'B53.851', 'LBYFDYJJJSCZS', '');
INSERT INTO `05diseases` VALUES ('1682', '良性疟疾', '244', 'B53.852', 'LXYJ', '');
INSERT INTO `05diseases` VALUES ('1683', '特殊类型疟疾', '244', 'B53.853', 'TSLXYJ', '');
INSERT INTO `05diseases` VALUES ('1684', '疗病诱发疟', '268', 'B54.X01', 'LBYFY', '');
INSERT INTO `05diseases` VALUES ('1685', '疟疾', '244', 'B54.X02', 'YJ', '');
INSERT INTO `05diseases` VALUES ('1686', '疟疾性肝炎', '93', 'B54.X03+', 'YJXGY', '');
INSERT INTO `05diseases` VALUES ('1687', '临床诊断为疟疾(不伴有寄生虫原的证实)', '156', 'B54.X51', 'LCZDWYJBBYJSCYDZS', '');
INSERT INTO `05diseases` VALUES ('1688', '复发性疟疾', '244', 'B54.X52', 'FFXYJ', '');
INSERT INTO `05diseases` VALUES ('1689', '输血疟疾', '244', 'B54.X53', 'SXYJ', '');
INSERT INTO `05diseases` VALUES ('1690', '黑热病(内脏利什曼病)', '268', 'B55.001', 'HRBNZLSMB', '');
INSERT INTO `05diseases` VALUES ('1691', '利什曼痢疾', '200', 'B55.051', 'LSMLJ', '');
INSERT INTO `05diseases` VALUES ('1692', '皮肤利什曼病[东方疖、阿里坡疖]', '250', 'B55.101', 'PFLSMBDFJALPJ', '');
INSERT INTO `05diseases` VALUES ('1693', '德里溃疡[皮肤利什曼病欧亚型]', '250', 'B55.151', 'DLKYPFLSMBOYX', '');
INSERT INTO `05diseases` VALUES ('1694', '急性坏死型黑热病[乡村型或湿型]', '268', 'B55.152', 'JXHSXHRBXCXHSX', '');
INSERT INTO `05diseases` VALUES ('1695', '皮肤型黑热病', '250', 'B55.153', 'PFXHRB', '');
INSERT INTO `05diseases` VALUES ('1696', '拉合尔溃疡[皮肤利什曼病欧亚型]', '250', 'B55.154', 'LHEKYPFLSMBOYX', '');
INSERT INTO `05diseases` VALUES ('1697', '迟发溃疡型皮肤黑色病[城镇型或干型]', '250', 'B55.155', 'CFKYXPFHSBCZXHGX', '');
INSERT INTO `05diseases` VALUES ('1698', '粘膜皮肤的利什曼病', '250', 'B55.251', 'NMPFDLSMB', '');
INSERT INTO `05diseases` VALUES ('1699', '利什曼病 NOS', '268', 'B55.951', 'LSMB', '');
INSERT INTO `05diseases` VALUES ('1700', '脑锥虫病', '234', 'B56.951', 'NZCB', '');
INSERT INTO `05diseases` VALUES ('1701', '非洲锥虫病引起的脑炎、脊髓炎或脑脊髓炎', '234', 'B56.952+', 'FZZCBYQDNYJSYHNJSY', '');
INSERT INTO `05diseases` VALUES ('1702', '昏睡病 NOS', '338', 'B56.953', 'HSB', '');
INSERT INTO `05diseases` VALUES ('1703', '急性查加斯病伴心肌炎', '397', 'B57.051+', 'JXCJSBBXJY', '');
INSERT INTO `05diseases` VALUES ('1704', '急性查加斯病伴心血管疾病', '402', 'B57.052+', 'JXCJSBBXXGJB', '');
INSERT INTO `05diseases` VALUES ('1705', '急性查加斯病', '268', 'B57.151', 'JXCJSB', '');
INSERT INTO `05diseases` VALUES ('1706', '慢性查加斯病[美洲锥虫病]伴心肌炎', '397', 'B57.251+', 'MXCJSBMZZCBBXJY', '');
INSERT INTO `05diseases` VALUES ('1707', '慢性查加斯病[美洲锥虫病]伴心血管疾病', '402', 'B57.252+', 'MXCJSBMZZCBBXXGJB', '');
INSERT INTO `05diseases` VALUES ('1708', '慢性查加斯病[美洲锥虫病]伴有巨食管疾病', '222', 'B57.351+', 'MXCJSBMZZCBBYJSGJB', '');
INSERT INTO `05diseases` VALUES ('1709', '慢性查加斯病[美洲锥虫病]伴有巨结肠疾病', '222', 'B57.352+', 'MXCJSBMZZCBBYJJCJB', '');
INSERT INTO `05diseases` VALUES ('1710', '慢性查加斯病[美洲锥虫病]伴消化道疾病', '222', 'B57.353+', 'MXCJSBMZZCBBXHDJB', '');
INSERT INTO `05diseases` VALUES ('1712', '查加斯病[美洲锥虫病]伴脑炎、脊髓炎或脑脊髓炎(慢性)', '234', 'B57.452+', 'CJSBMZZCBBNYJSYHNJSY', '');
INSERT INTO `05diseases` VALUES ('1713', '查加斯病[美洲锥虫病]伴有累及其他器官', '36', 'B57.551', 'CJSBMZZCBBYLJQTQG', '');
INSERT INTO `05diseases` VALUES ('1714', '弓形体属脉络膜视网膜炎', '327', 'B58.051+', 'GXTSMLMSWMY', '');
INSERT INTO `05diseases` VALUES ('1715', '弓形体病肝炎', '93', 'B58.101+', 'GXTBGY', '');
INSERT INTO `05diseases` VALUES ('1716', '弓形病脑炎', '234', 'B58.201+', 'GXBNY', '');
INSERT INTO `05diseases` VALUES ('1717', '弓形体属脑膜脑炎', '232', 'B58.251+', 'GXTSNMNY', '');
INSERT INTO `05diseases` VALUES ('1718', '弓形体属脑炎、脊髓炎或脑脊髓炎', '234', 'B58.252+', 'GXTSNYJSYHNJSY', '');
INSERT INTO `05diseases` VALUES ('1719', '肺弓形体病', '79', 'B58.351+', 'FGXTB', '');
INSERT INTO `05diseases` VALUES ('1720', '弓形体属心肌炎', '397', 'B58.851+', 'GXTSXJY', '');
INSERT INTO `05diseases` VALUES ('1721', '弓形体属肌炎', '146', 'B58.852+', 'GXTSJY', '');
INSERT INTO `05diseases` VALUES ('1722', '弓形体病 NOS', '268', 'B58.901', 'GXTB', '');
INSERT INTO `05diseases` VALUES ('1723', '肺囊虫病', '79', 'B59.X01', 'FNCB', '');
INSERT INTO `05diseases` VALUES ('1724', '卡氏肺囊虫性肺炎', '81', 'B59.X02', 'KSFNCXFY', '');
INSERT INTO `05diseases` VALUES ('1725', '肺囊虫性肺炎', '81', 'B59.X51+', 'FNCXFY', '');
INSERT INTO `05diseases` VALUES ('1726', '巴贝虫病', '36', 'B60.051', 'BBCB', '');
INSERT INTO `05diseases` VALUES ('1727', '棘阿米巴结膜炎', '1', 'B60.151+', 'JAMBJMY', '');
INSERT INTO `05diseases` VALUES ('1728', '棘阿米巴性角(膜)结膜炎', '1', 'B60.152+', 'JAMBXJMJMY', '');
INSERT INTO `05diseases` VALUES ('1729', '阿米巴性脑膜脑炎', '232', 'B60.201+', 'AMBXNMNY', '');
INSERT INTO `05diseases` VALUES ('1730', '非寄生性阿米巴引起的脑膜脑炎', '232', 'B60.202+', 'FJSXAMBYQDNMNY', '');
INSERT INTO `05diseases` VALUES ('1731', '原发性阿米巴性脑膜脑炎', '232', 'B60.203+', 'YFXAMBXNMNY', '');
INSERT INTO `05diseases` VALUES ('1732', '纳格勒阿米巴病脑炎', '1', 'B60.251+', 'NGLAMBBNY', '');
INSERT INTO `05diseases` VALUES ('1733', '纳归虫病性脑炎、脊髓炎或脑脊髓炎', '234', 'B60.252+', 'NGCBXNYJSYHNJSY', '');
INSERT INTO `05diseases` VALUES ('1734', '小孢子菌病', '14', 'B60.851', 'XBZJB', '');
INSERT INTO `05diseases` VALUES ('1735', '原生动物性疾病 NOS', '268', 'B64.X51', 'YSDWXJB', '');
INSERT INTO `05diseases` VALUES ('1736', '埃及血吸虫病(膀胱血吸虫病)', '372', 'B65.001', 'AJXXCBBGXXCB', '');
INSERT INTO `05diseases` VALUES ('1737', '裂体吸虫侵染埃及美洲血吸虫病', '372', 'B65.051', 'LTXCQRAJMZXXCB', '');
INSERT INTO `05diseases` VALUES ('1738', '泌尿生殖道血吸虫病', '372', 'B65.052', 'MNSZDXXCB', '');
INSERT INTO `05diseases` VALUES ('1739', '肠血吸虫病', '372', 'B65.101', 'CXXCB', '');
INSERT INTO `05diseases` VALUES ('1740', '血吸虫性盲肠炎', '33', 'B65.151', 'XXCXMCY', '');
INSERT INTO `05diseases` VALUES ('1741', '日本血吸虫病', '372', 'B65.201', 'RBXXCB', '');
INSERT INTO `05diseases` VALUES ('1742', '血吸虫病', '372', 'B65.202', 'XXCB', '');
INSERT INTO `05diseases` VALUES ('1743', '皮肤血吸虫病', '250', 'B65.301', 'PFXXCB', '');
INSERT INTO `05diseases` VALUES ('1744', '尾蚴性皮炎', '252', 'B65.351', 'WYXPY', '');
INSERT INTO `05diseases` VALUES ('1745', '其他特指的血吸虫病', '372', 'B65.801', 'QTTZDXXCB', '');
INSERT INTO `05diseases` VALUES ('1746', '肺血吸虫病', '79', 'B65.901+', 'FXXCB', '');
INSERT INTO `05diseases` VALUES ('1747', '血吸虫性肝炎', '93', 'B65.902+', 'XXCXGY', '');
INSERT INTO `05diseases` VALUES ('1748', '血吸虫肝', '92', 'B65.951', 'XXCG', '');
INSERT INTO `05diseases` VALUES ('1749', '脑血吸虫病', '234', 'B65.952', 'NXXCB', '');
INSERT INTO `05diseases` VALUES ('1750', '阑尾血吸虫病', '372', 'B65.953', 'LWXXCB', '');
INSERT INTO `05diseases` VALUES ('1751', '血吸虫性阑尾炎', '196', 'B65.954', 'XXCXLWY', '');
INSERT INTO `05diseases` VALUES ('1752', '血吸虫性肉芽肿', '295', 'B65.955', 'XXCXRYZ', '');
INSERT INTO `05diseases` VALUES ('1753', '血吸虫性肺炎', '81', 'B65.956+', 'XXCXFY', '');
INSERT INTO `05diseases` VALUES ('1754', '后睾吸虫病', '372', 'B66.051', 'HGXCB', '');
INSERT INTO `05diseases` VALUES ('1755', '华支睾吸虫病', '372', 'B66.102', 'HZGXCB', '');
INSERT INTO `05diseases` VALUES ('1756', '中华肝吸虫病', '92', 'B66.103+', 'ZHGXCB', '');
INSERT INTO `05diseases` VALUES ('1757', '胆道华支睾吸虫病', '53', 'B66.151', 'DDHZGXCB', '');
INSERT INTO `05diseases` VALUES ('1758', '支双腔吸虫病', '372', 'B66.251', 'ZSQXCB', '');
INSERT INTO `05diseases` VALUES ('1759', '肝片吸虫病[中华分支睾片吸虫病]', '92', 'B66.351+', 'GPXCBZHFZGPXCB', '');
INSERT INTO `05diseases` VALUES ('1760', '臂皮下组织肺吸虫感染', '95', 'B66.401', 'BPXZZFXCGR', '');
INSERT INTO `05diseases` VALUES ('1761', '肺吸虫病', '79', 'B66.402+', 'FXCB', '');
INSERT INTO `05diseases` VALUES ('1762', '腹型肺吸虫病', '79', 'B66.451+', 'FXFXCB', '');
INSERT INTO `05diseases` VALUES ('1763', '脑型肺吸虫病', '234', 'B66.452+', 'NXFXCB', '');
INSERT INTO `05diseases` VALUES ('1764', '姜片虫病', '36', 'B66.501', 'JPCB', '');
INSERT INTO `05diseases` VALUES ('1765', '胆道姜片虫病', '53', 'B66.551', 'DDJPCB', '');
INSERT INTO `05diseases` VALUES ('1766', '布斯克(肠)姜片虫侵染', '259', 'B66.552', 'BSKCJPCQR', '');
INSERT INTO `05diseases` VALUES ('1767', '胆道吸虫病', '53', 'B66.553', 'DDXCB', '');
INSERT INTO `05diseases` VALUES ('1768', '后殖吸虫病', '372', 'B66.851', 'HZXCB', '');
INSERT INTO `05diseases` VALUES ('1769', '棘口吸虫病', '372', 'B66.852', 'JKXCB', '');
INSERT INTO `05diseases` VALUES ('1770', '沃森吸虫病', '372', 'B66.853', 'WSXCB', '');
INSERT INTO `05diseases` VALUES ('1771', '异型吸虫病', '372', 'B66.854', 'YXXCB', '');
INSERT INTO `05diseases` VALUES ('1772', '伊族棘口吸虫病', '372', 'B66.855', 'YZJKXCB', '');
INSERT INTO `05diseases` VALUES ('1773', '隐孔吸虫病', '372', 'B66.856', 'YKXCB', '');
INSERT INTO `05diseases` VALUES ('1774', '脑吸虫病', '234', 'B66.901', 'NXCB', '');
INSERT INTO `05diseases` VALUES ('1775', '吸虫病', '372', 'B66.951', 'XCB', '');
INSERT INTO `05diseases` VALUES ('1776', '肝细粒棘球绦虫感染', '95', 'B67.051+', 'GXLJQTCGR', '');
INSERT INTO `05diseases` VALUES ('1777', '肺细粒棘球绦虫感染', '95', 'B67.151+', 'FXLJQTCGR', '');
INSERT INTO `05diseases` VALUES ('1778', '骨细粒棘球绦虫感染', '95', 'B67.251+', 'GXLJQTCGR', '');
INSERT INTO `05diseases` VALUES ('1779', '多部位细粒棘球绦虫感染', '95', 'B67.351', 'DBWXLJQTCGR', '');
INSERT INTO `05diseases` VALUES ('1780', '细粒棘球绦虫感染 NOS', '95', 'B67.451', 'XLJQTCGR', '');
INSERT INTO `05diseases` VALUES ('1781', '肝多房棘球绦虫感染', '95', 'B67.551+', 'GDFJQTCGR', '');
INSERT INTO `05diseases` VALUES ('1782', '多部位多房棘球绦虫感染', '95', 'B67.651', 'DBWDFJQTCGR', '');
INSERT INTO `05diseases` VALUES ('1783', '多房棘球绦虫感染 NOS', '95', 'B67.751', 'DFJQTCGR', '');
INSERT INTO `05diseases` VALUES ('1784', '肝包虫病', '92', 'B67.801+', 'GBCB', '');
INSERT INTO `05diseases` VALUES ('1785', '包虫病(棘球蚴病)', '36', 'B67.901', 'BCBJQYB', '');
INSERT INTO `05diseases` VALUES ('1786', '肺包虫病[肺棘球蚴病]', '79', 'B67.902', 'FBCBFJQYB', '');
INSERT INTO `05diseases` VALUES ('1787', '腹腔棘球蚴病', '264', 'B67.903', 'FQJQYB', '');
INSERT INTO `05diseases` VALUES ('1788', '脑棘球蚴病', '234', 'B67.905', 'NJQYB', '');
INSERT INTO `05diseases` VALUES ('1789', '胸膜棘球蚴病', '407', 'B67.906', 'XMJQYB', '');
INSERT INTO `05diseases` VALUES ('1790', '猪肉绦虫病', '36', 'B68.001', 'ZRTCB', '');
INSERT INTO `05diseases` VALUES ('1791', '肠绦虫病', '36', 'B68.051', 'CTCB', '');
INSERT INTO `05diseases` VALUES ('1792', '牛肉绦虫病', '36', 'B68.101', 'NRTCB', '');
INSERT INTO `05diseases` VALUES ('1793', '绦虫病 NOS', '36', 'B68.951', 'TCB', '');
INSERT INTO `05diseases` VALUES ('1794', '绦虫性脑病变', '234', 'B68.952', 'TCXNBB', '');
INSERT INTO `05diseases` VALUES ('1795', '脑囊虫病[脑囊尾蚴病]', '234', 'B69.001+', 'NNCBNNWYB', '');
INSERT INTO `05diseases` VALUES ('1796', '囊尾蚴病癫痫', '57', 'B69.051+', 'NWYBDX', '');
INSERT INTO `05diseases` VALUES ('1797', '中枢神经系统囊尾蚴病', '313', 'B69.052+', 'ZSSJXTNWYB', '');
INSERT INTO `05diseases` VALUES ('1798', '囊虫病(眼)', '430', 'B69.101+', 'NCBY', '');
INSERT INTO `05diseases` VALUES ('1799', '肝囊虫病', '92', 'B69.801', 'GNCB', '');
INSERT INTO `05diseases` VALUES ('1800', '骨囊虫病', '36', 'B69.802', 'GNCB', '');
INSERT INTO `05diseases` VALUES ('1801', '肌肉囊虫病', '36', 'B69.803', 'JRNCB', '');
INSERT INTO `05diseases` VALUES ('1802', '皮肤囊虫病', '250', 'B69.804', 'PFNCB', '');
INSERT INTO `05diseases` VALUES ('1803', '囊尾蚴病[囊虫病] NOS', '36', 'B69.901', 'NWYBNCB', '');
INSERT INTO `05diseases` VALUES ('1804', '囊虫感染', '95', 'B69.902', 'NCGR', '');
INSERT INTO `05diseases` VALUES ('1805', '裂头绦虫病', '36', 'B70.051', 'LTTCB', '');
INSERT INTO `05diseases` VALUES ('1806', '裂头蚴侵染(巴克斯特)(曼林)', '357', 'B70.151', 'LTYQRBKSTML', '');
INSERT INTO `05diseases` VALUES ('1807', '叠宫属病', '102', 'B70.152', 'DGSB', '');
INSERT INTO `05diseases` VALUES ('1808', '长膜壳绦虫感染', '95', 'B71.051', 'CMKTCGR', '');
INSERT INTO `05diseases` VALUES ('1809', '短膜壳绦虫病', '36', 'B71.052', 'DMKTCB', '');
INSERT INTO `05diseases` VALUES ('1810', '复孔绦虫病', '36', 'B71.151', 'FKTCB', '');
INSERT INTO `05diseases` VALUES ('1811', '犬绦虫感染', '95', 'B71.152', 'QTCGR', '');
INSERT INTO `05diseases` VALUES ('1812', '多头绦虫蚴病', '357', 'B71.851', 'DTTCYB', '');
INSERT INTO `05diseases` VALUES ('1813', '马尾绦虫肉芽肿', '295', 'B71.902', 'MWTCRYZ', '');
INSERT INTO `05diseases` VALUES ('1814', '麦地那龙线虫侵染', '278', 'B72.X51', 'MDNLXCQR', '');
INSERT INTO `05diseases` VALUES ('1815', '河盲病', '268', 'B73.X51', 'HMB', '');
INSERT INTO `05diseases` VALUES ('1816', '旋盘尾丝虫感染', '95', 'B73.X52', 'XPWSCGR', '');
INSERT INTO `05diseases` VALUES ('1817', '盘尾丝虫病', '36', 'B73.X53+', 'PWSCB', '');
INSERT INTO `05diseases` VALUES ('1818', '班氏丝虫病', '36', 'B74.051', 'BSSCB', '');
INSERT INTO `05diseases` VALUES ('1819', '班氏象皮腿', '360', 'B74.052', 'BSXPT', '');
INSERT INTO `05diseases` VALUES ('1820', '马来(布鲁格)丝虫引起的丝虫病', '36', 'B74.151', 'MLBLGSCYQDSCB', '');
INSERT INTO `05diseases` VALUES ('1821', '帝汶(布鲁格)丝虫引起的丝虫病', '36', 'B74.251', 'DWBLGSCYQDSCB', '');
INSERT INTO `05diseases` VALUES ('1822', '卡拉巴肿', '278', 'B74.351', 'KLBZ', '');
INSERT INTO `05diseases` VALUES ('1823', '罗阿丝虫病[眼虫病]', '430', 'B74.352', 'LASCBYCB', '');
INSERT INTO `05diseases` VALUES ('1824', '曼森线虫引起的奥扎尔德', '278', 'B74.451', 'MSXCYQDAZED', '');
INSERT INTO `05diseases` VALUES ('1825', '恶丝虫病', '36', 'B74.851', 'ESCB', '');
INSERT INTO `05diseases` VALUES ('1826', '丝虫病', '36', 'B74.901', 'SCB', '');
INSERT INTO `05diseases` VALUES ('1827', '丝虫病性乳糜尿', '36', 'B74.902', 'SCBXRMN', '');
INSERT INTO `05diseases` VALUES ('1828', '丝虫性外阴象皮病', '367', 'B74.903', 'SCXWYXPB', '');
INSERT INTO `05diseases` VALUES ('1829', '丝虫性象皮病', '268', 'B74.904', 'SCXXPB', '');
INSERT INTO `05diseases` VALUES ('1830', '丝虫性腹水', '264', 'B74.951', 'SCXFS', '');
INSERT INTO `05diseases` VALUES ('1831', '旋毛虫病', '36', 'B75.X51', 'XMCB', '');
INSERT INTO `05diseases` VALUES ('1832', '十二指肠钩虫病', '321', 'B76.051', 'SEZCGCB', '');
INSERT INTO `05diseases` VALUES ('1833', '皮肤的(钩虫)蠕虫蚴移行症', '296', 'B76.052', 'PFDGCRCYYXZ', '');
INSERT INTO `05diseases` VALUES ('1834', '其他钩虫病', '36', 'B76.851', 'QTGCB', '');
INSERT INTO `05diseases` VALUES ('1835', '肠道钩虫病', '31', 'B76.901', 'CDGCB', '');
INSERT INTO `05diseases` VALUES ('1836', '钩虫病 NOS', '36', 'B76.902', 'GCB', '');
INSERT INTO `05diseases` VALUES ('1837', '皮肤的游走性幼虫病', '250', 'B76.951', 'PFDYZXYCB', '');
INSERT INTO `05diseases` VALUES ('1838', '幼虫移行性匐行疹', '250', 'B76.952', 'YCYXXFXZ', '');
INSERT INTO `05diseases` VALUES ('1839', '钩虫病性贫血', '255', 'B76.953+', 'GCBXPX', '');
INSERT INTO `05diseases` VALUES ('1840', '蛔虫性肠穿孔', '138', 'B77.051+', 'HCXCCK', '');
INSERT INTO `05diseases` VALUES ('1841', '蛔虫性肠梗阻', '138', 'B77.052+', 'HCXCGZ', '');
INSERT INTO `05diseases` VALUES ('1842', '肠蛔虫', '138', 'B77.053+', 'CHC', '');
INSERT INTO `05diseases` VALUES ('1843', '胆道蛔虫病', '53', 'B77.801', 'DDHCB', '');
INSERT INTO `05diseases` VALUES ('1844', '肝管蛔虫病', '92', 'B77.802', 'GGHCB', '');
INSERT INTO `05diseases` VALUES ('1845', '肺蛔虫', '79', 'B77.851', 'FHC', '');
INSERT INTO `05diseases` VALUES ('1846', '阑尾蛔虫病', '36', 'B77.852', 'LWHCB', '');
INSERT INTO `05diseases` VALUES ('1847', '蛔虫性阑尾炎', '138', 'B77.853', 'HCXLWY', '');
INSERT INTO `05diseases` VALUES ('1848', '蛔虫性腹膜炎', '90', 'B77.854', 'HCXFMY', '');
INSERT INTO `05diseases` VALUES ('1849', '胰管蛔虫', '138', 'B77.855', 'YGHC', '');
INSERT INTO `05diseases` VALUES ('1850', '蛔虫病 NOS', '36', 'B77.901', 'HCB', '');
INSERT INTO `05diseases` VALUES ('1851', '肠道类圆线虫病', '31', 'B78.051+', 'CDLYXCB', '');
INSERT INTO `05diseases` VALUES ('1852', '皮肤类圆线虫病', '250', 'B78.151+', 'PFLYXCB', '');
INSERT INTO `05diseases` VALUES ('1853', '播散性类圆线虫病', '36', 'B78.751', 'BSXLYXCB', '');
INSERT INTO `05diseases` VALUES ('1854', '类圆线虫病 NOS', '36', 'B78.951', 'LYXCB', '');
INSERT INTO `05diseases` VALUES ('1855', '鞭虫病', '36', 'B79.X01', 'BCB', '');
INSERT INTO `05diseases` VALUES ('1856', '肠鞭虫病', '36', 'B79.X02', 'CBCB', '');
INSERT INTO `05diseases` VALUES ('1857', '蛲虫病', '36', 'B80.X01', 'NCB', '');
INSERT INTO `05diseases` VALUES ('1858', '异尖线虫病', '36', 'B81.051', 'YJXCB', '');
INSERT INTO `05diseases` VALUES ('1859', '肠道毛细线虫病', '31', 'B81.151', 'CDMXXCB', '');
INSERT INTO `05diseases` VALUES ('1860', '毛圆线虫病', '36', 'B81.251', 'MYXCB', '');
INSERT INTO `05diseases` VALUES ('1861', '肠道血管圆线虫病', '31', 'B81.351', 'CDXGYXCB', '');
INSERT INTO `05diseases` VALUES ('1862', '混合型肠道蠕虫病', '296', 'B81.451', 'HHXCDRCB', '');
INSERT INTO `05diseases` VALUES ('1863', '混合型蠕虫病 NOS', '296', 'B81.452', 'HHXRCB', '');
INSERT INTO `05diseases` VALUES ('1864', '结节线虫属肠道蠕虫病', '296', 'B81.851', 'JJXCSCDRCB', '');
INSERT INTO `05diseases` VALUES ('1865', '缩小三尺线虫肠道蠕虫病', '296', 'B81.852', 'SXSCXCCDRCB', '');
INSERT INTO `05diseases` VALUES ('1866', '肠蠕虫病 NOS', '296', 'B82.051', 'CRCB', '');
INSERT INTO `05diseases` VALUES ('1867', '肠道寄生虫病 NOS', '156', 'B82.901', 'CDJSCB', '');
INSERT INTO `05diseases` VALUES ('1868', '肠寄生虫性脓肿', '156', 'B82.902', 'CJSCXNZ', '');
INSERT INTO `05diseases` VALUES ('1869', '弓蛔虫病', '36', 'B83.051', 'GHCB', '');
INSERT INTO `05diseases` VALUES ('1870', '内脏的游走性幼虫病', '36', 'B83.052', 'NZDYZXYCB', '');
INSERT INTO `05diseases` VALUES ('1871', '游动性肿', '278', 'B83.151', 'YDXZ', '');
INSERT INTO `05diseases` VALUES ('1872', '颚口线虫病', '36', 'B83.152', 'EKXCB', '');
INSERT INTO `05diseases` VALUES ('1873', '广州副圆线虫侵染', '278', 'B83.251', 'GZFYXCQR', '');
INSERT INTO `05diseases` VALUES ('1874', '嗜酸细胞性脑膜脑炎', '232', 'B83.252+', 'SSXBXNMNY', '');
INSERT INTO `05diseases` VALUES ('1875', '比翼线虫病', '36', 'B83.351', 'BYXCB', '');
INSERT INTO `05diseases` VALUES ('1876', '内部水蛭病', '268', 'B83.451', 'NBSZB', '');
INSERT INTO `05diseases` VALUES ('1877', '肝毛细线虫病', '92', 'B83.851', 'GMXXCB', '');
INSERT INTO `05diseases` VALUES ('1878', '后圆线虫病', '36', 'B83.852', 'HYXCB', '');
INSERT INTO `05diseases` VALUES ('1879', '棘头虫病', '36', 'B83.853', 'JTCB', '');
INSERT INTO `05diseases` VALUES ('1880', '筒线虫病', '36', 'B83.854', 'TXCB', '');
INSERT INTO `05diseases` VALUES ('1881', '吸吮线虫病', '36', 'B83.855', 'XSXCB', '');
INSERT INTO `05diseases` VALUES ('1882', '蠕虫病 NOS', '296', 'B83.951', 'RCB', '');
INSERT INTO `05diseases` VALUES ('1883', '头虱病', '318', 'B85.001', 'TSB', '');
INSERT INTO `05diseases` VALUES ('1884', '体虱病', '318', 'B85.101', 'TSB', '');
INSERT INTO `05diseases` VALUES ('1885', '虱病 NOS', '318', 'B85.201', 'SB', '');
INSERT INTO `05diseases` VALUES ('1886', '阴虱病', '318', 'B85.301', 'YSB', '');
INSERT INTO `05diseases` VALUES ('1887', '混合型虱病', '318', 'B85.451', 'HHXSB', '');
INSERT INTO `05diseases` VALUES ('1888', '混合型阴虱病', '318', 'B85.452', 'HHXYSB', '');
INSERT INTO `05diseases` VALUES ('1889', '疥疮', '43', 'B86.X01', 'JC', '');
INSERT INTO `05diseases` VALUES ('1890', '皮肤蝇蛆病', '250', 'B87.051+', 'PFYQB', '');
INSERT INTO `05diseases` VALUES ('1891', '匐行蝇蛆病', '450', 'B87.052+', 'FXYQB', '');
INSERT INTO `05diseases` VALUES ('1892', '创伤性蝇蛆病', '450', 'B87.151', 'CSXYQB', '');
INSERT INTO `05diseases` VALUES ('1893', '伤口蝇蛆病', '450', 'B87.152', 'SKYQB', '');
INSERT INTO `05diseases` VALUES ('1894', '眼蝇蛆病', '430', 'B87.251+', 'YYQB', '');
INSERT INTO `05diseases` VALUES ('1895', '喉蝇蛆病', '133', 'B87.351+', 'HYQB', '');
INSERT INTO `05diseases` VALUES ('1896', '鼻咽蝇蛆病', '16', 'B87.352+', 'BYYQB', '');
INSERT INTO `05diseases` VALUES ('1897', '耳蝇蛆病', '70', 'B87.451+', 'EYQB', '');
INSERT INTO `05diseases` VALUES ('1898', '肠道蝇蛆病', '31', 'B87.851', 'CDYQB', '');
INSERT INTO `05diseases` VALUES ('1899', '泌尿生殖道蝇蛆病', '450', 'B87.852', 'MNSZDYQB', '');
INSERT INTO `05diseases` VALUES ('1900', '蝇蛆病 NOS', '450', 'B87.951', 'YQB', '');
INSERT INTO `05diseases` VALUES ('1901', '螨虫病', '36', 'B88.001', 'MCB', '');
INSERT INTO `05diseases` VALUES ('1902', '螨虫性皮炎', '252', 'B88.051+', 'MCXPY', '');
INSERT INTO `05diseases` VALUES ('1903', '谷痒症[荨麻疹样螨皮炎]', '423', 'B88.052+', 'GYZQMZYMPY', '');
INSERT INTO `05diseases` VALUES ('1904', '潜蚤病[沙蚤侵染]', '268', 'B88.151', 'QZBSZQR', '');
INSERT INTO `05diseases` VALUES ('1905', '肠蜣螂病', '259', 'B88.251', 'CQLB', '');
INSERT INTO `05diseases` VALUES ('1906', '水蛭病', '268', 'B88.301', 'SZB', '');
INSERT INTO `05diseases` VALUES ('1907', '马皮疽侵染', '187', 'B88.351', 'MPJQR', '');
INSERT INTO `05diseases` VALUES ('1908', '蛇舌状虫病', '36', 'B88.851', 'SSZCB', '');
INSERT INTO `05diseases` VALUES ('1909', '舌形虫病', '36', 'B88.852', 'SXCB', '');
INSERT INTO `05diseases` VALUES ('1910', '螨病 NOS', '268', 'B88.951', 'MB', '');
INSERT INTO `05diseases` VALUES ('1911', '皮肤寄生虫感染', '156', 'B88.952', 'PFJSCGR', '');
INSERT INTO `05diseases` VALUES ('1912', '寄生虫感染 NOS', '156', 'B89.X51', 'JSCGR', '');
INSERT INTO `05diseases` VALUES ('1913', '陈旧性结核性脑膜炎', '171', 'B90.001', 'CJXJHXNMY', '');
INSERT INTO `05diseases` VALUES ('1914', '结核性脑膜炎后遗症', '171', 'B90.002', 'JHXNMYHYZ', '');
INSERT INTO `05diseases` VALUES ('1915', '中枢神经系统结核病的后遗症', '313', 'B90.051', 'ZSSJXTJHBDHYZ', '');
INSERT INTO `05diseases` VALUES ('1916', '泌尿道系结核病的后遗症', '171', 'B90.151', 'MNDXJHBDHYZ', '');
INSERT INTO `05diseases` VALUES ('1917', '陈旧性骨和关节结核病', '123', 'B90.201', 'CJXGHGJJHB', '');
INSERT INTO `05diseases` VALUES ('1918', '陈旧性脊柱结核', '171', 'B90.202', 'CJXJZJH', '');
INSERT INTO `05diseases` VALUES ('1919', '陈旧性肩关节结核', '123', 'B90.251', 'CJXJGJJH', '');
INSERT INTO `05diseases` VALUES ('1920', '陈旧性髋关节结核', '123', 'B90.252', 'CJXKGJJH', '');
INSERT INTO `05diseases` VALUES ('1921', '陈旧性腰椎结核', '171', 'B90.253', 'CJXYZJH', '');
INSERT INTO `05diseases` VALUES ('1922', '陈旧性胸椎结核', '171', 'B90.254', 'CJXXZJH', '');
INSERT INTO `05diseases` VALUES ('1923', '陈旧性肠系膜淋巴结核', '171', 'B90.801', 'CJXCXMLBJH', '');
INSERT INTO `05diseases` VALUES ('1924', '陈旧性腹腔结核', '171', 'B90.802', 'CJXFQJH', '');
INSERT INTO `05diseases` VALUES ('1925', '陈旧性颈淋巴结核', '171', 'B90.803', 'CJXGLBJH', '');
INSERT INTO `05diseases` VALUES ('1926', '特指部位的陈旧性结核', '171', 'B90.804', 'TZBWDCJXJH', '');
INSERT INTO `05diseases` VALUES ('1927', '其他器官结核病的后遗症', '171', 'B90.851', 'QTQGJHBDHYZ', '');
INSERT INTO `05diseases` VALUES ('1928', '陈旧性肺结核', '171', 'B90.901', 'CJXFJH', '');
INSERT INTO `05diseases` VALUES ('1929', '陈旧性胸膜结核', '171', 'B90.902', 'CJXXMJH', '');
INSERT INTO `05diseases` VALUES ('1930', '脊髓灰质炎后遗症(小儿麻痹后遗症)', '151', 'B91.X01', 'JSHZYHYZXEMBHYZ', '');
INSERT INTO `05diseases` VALUES ('1931', '麻风后遗症', '218', 'B92.X51', 'MFHYZ', '');
INSERT INTO `05diseases` VALUES ('1932', '沙眼的晚期效应', '430', 'B94.051', 'SYDWQXY', '');
INSERT INTO `05diseases` VALUES ('1933', '病毒性脑炎后遗症', '234', 'B94.101', 'BDXNYHYZ', '');
INSERT INTO `05diseases` VALUES ('1934', '流行性乙型脑炎后遗症', '234', 'B94.102', 'LXXYXNYHYZ', '');
INSERT INTO `05diseases` VALUES ('1935', '病毒性肝炎的晚期效应', '93', 'B94.251', 'BDXGYDWQXY', '');
INSERT INTO `05diseases` VALUES ('1936', '天花后遗症', '349', 'B94.851', 'THHYZ', '');
INSERT INTO `05diseases` VALUES ('1937', '传染病或寄生虫病后遗症 NOS', '156', 'B94.951', 'CRBHJSCBHYZ', '');
INSERT INTO `05diseases` VALUES ('1938', 'Ａ族链球菌作为分类于其他章疾病的原因', '263', 'B95.051', 'ZLQJZWFLYQTZJBDYY', '');
INSERT INTO `05diseases` VALUES ('1939', 'Ｂ族链球菌作为分类于其他章疾病的原因', '263', 'B95.151', 'ZLQJZWFLYQTZJBDYY', '');
INSERT INTO `05diseases` VALUES ('1940', 'Ｄ族链球菌作为分类于其他章疾病的原因', '263', 'B95.251', 'ZLQJZWFLYQTZJBDYY', '');
INSERT INTO `05diseases` VALUES ('1941', '肺炎链球菌作为分类于其他章疾病的原因', '81', 'B95.351', 'FYLQJZWFLYQTZJBDYY', '');
INSERT INTO `05diseases` VALUES ('1942', '其他链球菌作为分类于其他章疾病的原因', '263', 'B95.451', 'QTLQJZWFLYQTZJBDYY', '');
INSERT INTO `05diseases` VALUES ('1943', '链球菌作为分类于其他章疾病的原因 NOS', '263', 'B95.551', 'LQJZWFLYQTZJBDYY', '');
INSERT INTO `05diseases` VALUES ('1944', '金黄色葡萄球菌感染作为分类于其他章疾病的原因', '95', 'B95.651', 'JHSPTQJGRZWFLYQTZJBD', '');
INSERT INTO `05diseases` VALUES ('1945', '其他葡萄球菌作为分类于其他章疾病的原因', '263', 'B95.751', 'QTPTQJZWFLYQTZJBDYY', '');
INSERT INTO `05diseases` VALUES ('1946', '葡萄球菌作为分类于其他章疾病的原因 NOS', '263', 'B95.851', 'PTQJZWFLYQTZJBDYY', '');
INSERT INTO `05diseases` VALUES ('1947', '支原体肺炎菌作为分类于其他章疾病的原因', '81', 'B96.051', 'ZYTFYJZWFLYQTZJBDYY', '');
INSERT INTO `05diseases` VALUES ('1948', '肺炎杆菌作为分类于其他章疾病的原因', '81', 'B96.151', 'FYGJZWFLYQTZJBDYY', '');
INSERT INTO `05diseases` VALUES ('1949', '大肠埃希氏菌作为分类于其他章疾病的原因', '50', 'B96.251', 'DCAXSJZWFLYQTZJBDYY', '');
INSERT INTO `05diseases` VALUES ('1950', '流感嗜血杆菌感染作为分类于其他章疾病的原因', '95', 'B96.351', 'LGSXGJGRZWFLYQTZJBDY', '');
INSERT INTO `05diseases` VALUES ('1951', '弯曲杆菌病作为分类于其他章疾病的原因', '188', 'B96.451', 'WQGJBZWFLYQTZJBDYY', '');
INSERT INTO `05diseases` VALUES ('1953', '脆弱(微小)杆菌作为分类于其他章疾病的原因', '263', 'B96.651', 'CRWXGJZWFLYQTZJBDYY', '');
INSERT INTO `05diseases` VALUES ('1954', '产气荚膜梭状芽胞杆菌作为分类于其他章疾病的原因', '26', 'B96.751', 'CQJMSZYBGJZWFLYQTZJB', '');
INSERT INTO `05diseases` VALUES ('1955', '其他特指的细菌性病原体作为分类于其他章疾病的原因', '380', 'B96.851', 'QTTZDXJXBYTZWFLYQTZJ', '');
INSERT INTO `05diseases` VALUES ('1956', '腺病毒作为分类于其他章疾病的原因', '263', 'B97.051', 'XBDZWFLYQTZJBDYY', '');
INSERT INTO `05diseases` VALUES ('1957', '肠病毒作为分类于其他章疾病的原因', '259', 'B97.151', 'CBDZWFLYQTZJBDYY', '');
INSERT INTO `05diseases` VALUES ('1958', '冠状病毒作为分类于其他章疾病的原因', '263', 'B97.251', 'GZBDZWFLYQTZJBDYY', '');
INSERT INTO `05diseases` VALUES ('1959', '逆病毒作为分类于其他章疾病的原因', '263', 'B97.351', 'NBDZWFLYQTZJBDYY', '');
INSERT INTO `05diseases` VALUES ('1960', '呼吸道合胞病毒感染[RSV]作为分类于其他章疾病的原因', '95', 'B97.451', 'HXDHBBDGRZWFLYQTZJBD', '');
INSERT INTO `05diseases` VALUES ('1961', '呼肠病毒作为分类于其他章疾病的原因', '259', 'B97.551', 'HCBDZWFLYQTZJBDYY', '');
INSERT INTO `05diseases` VALUES ('1962', '细小病毒作为分类于其他章疾病的原因', '263', 'B97.651', 'XXBDZWFLYQTZJBDYY', '');
INSERT INTO `05diseases` VALUES ('1963', '乳头状瘤病毒作为分类于其他章疾病的原因', '86', 'B97.751', 'RTZLBDZWFLYQTZJBDYY', '');
INSERT INTO `05diseases` VALUES ('1964', '其他病毒性病原体作为分类于其他章疾病的原因', '263', 'B97.851', 'QTBDXBYTZWFLYQTZJBDY', '');
INSERT INTO `05diseases` VALUES ('1965', '感染', '95', 'B99.X01', 'GR', '');
INSERT INTO `05diseases` VALUES ('1966', '感染性发热', '95', 'B99.X02', 'GRXFR', '');
INSERT INTO `05diseases` VALUES ('1967', '感染后脑积水', '95', 'B99.X03+', 'GRHNJS', '');
INSERT INTO `05diseases` VALUES ('1968', '其他传染病', '268', 'B99.X51', 'QTCRB', '');
INSERT INTO `05diseases` VALUES ('1969', '传染性肉芽肿', '295', 'B99.X52', 'CRXRYZ', '');
INSERT INTO `05diseases` VALUES ('1970', '上唇恶性肿瘤', '473', 'C00.001', 'SCEXZL', '');
INSERT INTO `05diseases` VALUES ('1971', '下唇恶性肿瘤', '473', 'C00.101', 'XCEXZL', '');
INSERT INTO `05diseases` VALUES ('1972', '外唇恶性肿瘤', '473', 'C00.251', 'WCEXZL', '');
INSERT INTO `05diseases` VALUES ('1973', '上唇(内)口腔面恶性肿瘤', '473', 'C00.351', 'SCNKQMEXZL', '');
INSERT INTO `05diseases` VALUES ('1974', '上唇颊侧面恶性肿瘤', '473', 'C00.352', 'SCJCMEXZL', '');
INSERT INTO `05diseases` VALUES ('1975', '上唇系带恶性肿瘤', '473', 'C00.353', 'SCXDEXZL', '');
INSERT INTO `05diseases` VALUES ('1976', '上唇粘膜恶性肿瘤', '473', 'C00.354', 'SCNMEXZL', '');
INSERT INTO `05diseases` VALUES ('1977', '下唇(内)口腔面恶性肿瘤', '473', 'C00.451', 'XCNKQMEXZL', '');
INSERT INTO `05diseases` VALUES ('1978', '下唇颊侧面恶性肿瘤', '473', 'C00.452', 'XCJCMEXZL', '');
INSERT INTO `05diseases` VALUES ('1979', '下唇系带恶性肿瘤', '473', 'C00.453', 'XCXDEXZL', '');
INSERT INTO `05diseases` VALUES ('1980', '唇(内)口腔面恶性肿瘤', '473', 'C00.551', 'CNKQMEXZL', '');
INSERT INTO `05diseases` VALUES ('1981', '唇部颊侧面恶性肿瘤', '473', 'C00.552', 'CBJCMEXZL', '');
INSERT INTO `05diseases` VALUES ('1982', '唇系带恶性肿瘤', '473', 'C00.553', 'CXDEXZL', '');
INSERT INTO `05diseases` VALUES ('1983', '唇部粘膜恶性肿瘤', '473', 'C00.554', 'CBNMEXZL', '');
INSERT INTO `05diseases` VALUES ('1984', '唇联合恶性肿瘤', '473', 'C00.651', 'CLHEXZL', '');
INSERT INTO `05diseases` VALUES ('1985', '唇交搭跨越的恶性肿瘤', '473', 'C00.851', 'CJDKYDEXZL', '');
INSERT INTO `05diseases` VALUES ('1986', '唇恶性肿瘤 NOS', '473', 'C00.901', 'CEXZL', '');
INSERT INTO `05diseases` VALUES ('1987', '舌根恶性肿瘤', '473', 'C01.X01', 'SGEXZL', '');
INSERT INTO `05diseases` VALUES ('1988', '舌后三分之一恶性肿瘤', '473', 'C01.X51', 'SHSFZYEXZL', '');
INSERT INTO `05diseases` VALUES ('1989', '舌背面恶性肿瘤', '473', 'C02.051', 'SBMEXZL', '');
INSERT INTO `05diseases` VALUES ('1990', '舌前三分之二背面恶性肿瘤', '473', 'C02.052', 'SQSFZEBMEXZL', '');
INSERT INTO `05diseases` VALUES ('1991', '舌尖及侧缘的恶性肿瘤', '473', 'C02.101', 'SJJCYDEXZL', '');
INSERT INTO `05diseases` VALUES ('1992', '舌缘恶性肿瘤', '473', 'C02.102', 'SYEXZL', '');
INSERT INTO `05diseases` VALUES ('1993', '舌腹面恶性肿瘤', '473', 'C02.251', 'SFMEXZL', '');
INSERT INTO `05diseases` VALUES ('1994', '舌前三分之二腹面恶性肿瘤', '473', 'C02.252', 'SQSFZEFMEXZL', '');
INSERT INTO `05diseases` VALUES ('1995', '舌系带恶性肿瘤', '473', 'C02.253', 'SXDEXZL', '');
INSERT INTO `05diseases` VALUES ('1996', '舌活动部分恶性肿瘤', '473', 'C02.351', 'SHDBFEXZL', '');
INSERT INTO `05diseases` VALUES ('1997', '舌中三分之一恶性肿瘤', '473', 'C02.352', 'SZSFZYEXZL', '');
INSERT INTO `05diseases` VALUES ('1998', '舌扁桃体恶性肿瘤', '473', 'C02.451', 'SBTTEXZL', '');
INSERT INTO `05diseases` VALUES ('1999', '舌交搭跨越的恶性肿瘤', '473', 'C02.851', 'SJDKYDEXZL', '');
INSERT INTO `05diseases` VALUES ('2000', '舌恶性肿瘤 NOS', '473', 'C02.901', 'SEXZL', '');
INSERT INTO `05diseases` VALUES ('2001', '上牙龈恶性肿瘤', '473', 'C03.001', 'SYYEXZL', '');
INSERT INTO `05diseases` VALUES ('2002', '下牙龈恶性肿瘤', '473', 'C03.151', 'XYYEXZL', '');
INSERT INTO `05diseases` VALUES ('2003', '颌结缔组织恶性肿瘤', '473', 'C03.901', 'HJDZZEXZL', '');
INSERT INTO `05diseases` VALUES ('2004', '牙龈恶性肿瘤 NOS', '473', 'C03.902', 'YYEXZL', '');
INSERT INTO `05diseases` VALUES ('2005', '颌下结缔组织恶性肿瘤', '473', 'C03.951', 'HXJDZZEXZL', '');
INSERT INTO `05diseases` VALUES ('2006', '前磨牙与尖牙连接处以前恶性肿瘤', '473', 'C04.051', 'QMYYJYLJCYQEXZL', '');
INSERT INTO `05diseases` VALUES ('2007', '口底前部恶性肿瘤', '473', 'C04.052', 'KDQBEXZL', '');
INSERT INTO `05diseases` VALUES ('2008', '口底侧部恶性肿瘤', '473', 'C04.151', 'KDCBEXZL', '');
INSERT INTO `05diseases` VALUES ('2009', '口底交搭跨越的恶性肿瘤', '473', 'C04.851', 'KDJDKYDEXZL', '');
INSERT INTO `05diseases` VALUES ('2010', '口底恶性肿瘤 NOS', '473', 'C04.901', 'KDEXZL', '');
INSERT INTO `05diseases` VALUES ('2011', '硬腭恶性肿瘤', '473', 'C05.001', 'YEEXZL', '');
INSERT INTO `05diseases` VALUES ('2012', '软腭恶性肿瘤', '473', 'C05.101', 'REEXZL', '');
INSERT INTO `05diseases` VALUES ('2013', '悬雍垂恶性肿瘤', '473', 'C05.251', 'XYCEXZL', '');
INSERT INTO `05diseases` VALUES ('2014', '腭交搭跨越的恶性肿瘤', '473', 'C05.851', 'EJDKYDEXZL', '');
INSERT INTO `05diseases` VALUES ('2015', '腭恶性肿瘤 NOS', '473', 'C05.901', 'EEXZL', '');
INSERT INTO `05diseases` VALUES ('2016', '颊内部恶性肿瘤', '473', 'C06.001', 'JNBEXZL', '');
INSERT INTO `05diseases` VALUES ('2017', '颊粘膜恶性肿瘤', '473', 'C06.002', 'JNMEXZL', '');
INSERT INTO `05diseases` VALUES ('2018', '口腔粘膜恶性肿瘤', '473', 'C06.003', 'KQNMEXZL', '');
INSERT INTO `05diseases` VALUES ('2019', '颊沟恶性肿瘤', '473', 'C06.151', 'JGEXZL', '');
INSERT INTO `05diseases` VALUES ('2020', '口前庭恶性肿瘤', '473', 'C06.152', 'KQTEXZL', '');
INSERT INTO `05diseases` VALUES ('2021', '唇沟恶性肿瘤', '473', 'C06.153', 'CGEXZL', '');
INSERT INTO `05diseases` VALUES ('2022', '磨牙后区恶性肿瘤', '473', 'C06.251', 'MYHQEXZL', '');
INSERT INTO `05diseases` VALUES ('2023', '口腔交搭跨越的恶性肿瘤', '473', 'C06.851', 'KQJDKYDEXZL', '');
INSERT INTO `05diseases` VALUES ('2024', '小涎腺恶性肿瘤', '473', 'C06.951', 'XXXEXZL', '');
INSERT INTO `05diseases` VALUES ('2025', '口腔恶性肿瘤 NOS', '473', 'C06.952', 'KQEXZL', '');
INSERT INTO `05diseases` VALUES ('2026', '腮腺恶性肿瘤', '473', 'C07.X01', 'SXEXZL', '');
INSERT INTO `05diseases` VALUES ('2027', '腮腺混合瘤恶变', '261', 'C07.X02', 'SXHHLEB', '');
INSERT INTO `05diseases` VALUES ('2028', '斯滕森管[腮腺管]恶性肿瘤', '473', 'C07.X51', 'STSGSXGEXZL', '');
INSERT INTO `05diseases` VALUES ('2029', '颌下腺恶性肿瘤', '473', 'C08.001', 'HXXEXZL', '');
INSERT INTO `05diseases` VALUES ('2030', '沃顿管恶性肿瘤', '473', 'C08.051', 'WDGEXZL', '');
INSERT INTO `05diseases` VALUES ('2031', '舌下腺恶性肿瘤', '473', 'C08.101', 'SXXEXZL', '');
INSERT INTO `05diseases` VALUES ('2032', '舌下腺及颌下腺恶性肿瘤', '473', 'C08.801', 'SXXJHXXEXZL', '');
INSERT INTO `05diseases` VALUES ('2033', '大涎腺交搭跨越的恶性肿瘤', '473', 'C08.851', 'DXXJDKYDEXZL', '');
INSERT INTO `05diseases` VALUES ('2034', '涎腺恶性肿瘤', '473', 'C08.901', 'XXEXZL', '');
INSERT INTO `05diseases` VALUES ('2035', '主唾液腺的恶性肿瘤', '473', 'C08.951', 'ZTYXDEXZL', '');
INSERT INTO `05diseases` VALUES ('2036', '扁桃体窝恶性肿瘤', '473', 'C09.051', 'BTTWEXZL', '');
INSERT INTO `05diseases` VALUES ('2037', '舌腭弓恶性肿瘤', '473', 'C09.101', 'SEGEXZL', '');
INSERT INTO `05diseases` VALUES ('2038', '扁桃体柱恶性肿瘤', '473', 'C09.151', 'BTTZEXZL', '');
INSERT INTO `05diseases` VALUES ('2039', '扁桃体交搭跨越的恶性肿瘤', '473', 'C09.851', 'BTTJDKYDEXZL', '');
INSERT INTO `05diseases` VALUES ('2040', '扁桃体恶性肿瘤', '473', 'C09.901', 'BTTEXZL', '');
INSERT INTO `05diseases` VALUES ('2041', '腭扁桃体恶性肿瘤', '473', 'C09.951', 'EBTTEXZL', '');
INSERT INTO `05diseases` VALUES ('2042', '咽门扁桃体恶性肿瘤', '473', 'C09.952', 'YMBTTEXZL', '');
INSERT INTO `05diseases` VALUES ('2043', '会厌谷恶性肿瘤', '473', 'C10.051', 'HYGEXZL', '');
INSERT INTO `05diseases` VALUES ('2044', '会厌游离缘[边缘]恶性肿瘤', '473', 'C10.151', 'HYYLYBYEXZL', '');
INSERT INTO `05diseases` VALUES ('2045', '会厌前面的恶性肿瘤', '473', 'C10.152', 'HYQMDEXZL', '');
INSERT INTO `05diseases` VALUES ('2046', '舌会厌褶恶性肿瘤', '473', 'C10.153', 'SHYZEXZL', '');
INSERT INTO `05diseases` VALUES ('2047', '口咽侧壁恶性肿瘤', '473', 'C10.251', 'KYCBEXZL', '');
INSERT INTO `05diseases` VALUES ('2048', '口咽后壁恶性肿瘤', '473', 'C10.351', 'KYHBEXZL', '');
INSERT INTO `05diseases` VALUES ('2049', '鳃裂恶性肿瘤', '473', 'C10.401', 'SLEXZL', '');
INSERT INTO `05diseases` VALUES ('2050', '腮弓恶性肿瘤', '473', 'C10.451', 'SGEXZL', '');
INSERT INTO `05diseases` VALUES ('2051', '口咽交搭跨越的恶性肿瘤', '473', 'C10.851', 'KYJDKYDEXZL', '');
INSERT INTO `05diseases` VALUES ('2052', '口咽恶性肿瘤 NOS', '473', 'C10.901', 'KYEXZL', '');
INSERT INTO `05diseases` VALUES ('2053', '鼻咽顶恶性肿瘤', '473', 'C11.051', 'BYDEXZL', '');
INSERT INTO `05diseases` VALUES ('2054', '鼻咽上壁恶性肿瘤', '473', 'C11.052', 'BYSBEXZL', '');
INSERT INTO `05diseases` VALUES ('2055', '鼻咽后壁恶性肿瘤', '473', 'C11.101', 'BYHBEXZL', '');
INSERT INTO `05diseases` VALUES ('2056', '鼻咽后壁腺样体恶性肿瘤', '473', 'C11.151', 'BYHBXYTEXZL', '');
INSERT INTO `05diseases` VALUES ('2057', '鼻咽后壁咽扁桃体恶性肿瘤', '473', 'C11.152', 'BYHBYBTTEXZL', '');
INSERT INTO `05diseases` VALUES ('2058', '咽扁桃体恶性肿瘤', '473', 'C11.153', 'YBTTEXZL', '');
INSERT INTO `05diseases` VALUES ('2059', '鼻咽侧壁恶性肿瘤', '473', 'C11.201', 'BYCBEXZL', '');
INSERT INTO `05diseases` VALUES ('2060', '鼻咽侧壁咽鼓管开口恶性肿瘤', '473', 'C11.251', 'BYCBYGGKKEXZL', '');
INSERT INTO `05diseases` VALUES ('2061', '鼻咽侧壁咽隐窝恶性肿瘤', '473', 'C11.252', 'BYCBYYWEXZL', '');
INSERT INTO `05diseases` VALUES ('2062', '罗森米勒窝(咽隐窝)恶性肿瘤', '473', 'C11.253', 'LSMLWYYWEXZL', '');
INSERT INTO `05diseases` VALUES ('2063', '鼻中隔后缘恶性肿瘤', '473', 'C11.301', 'BZGHYEXZL', '');
INSERT INTO `05diseases` VALUES ('2064', '鼻后孔后缘恶性肿瘤', '473', 'C11.351', 'BHKHYEXZL', '');
INSERT INTO `05diseases` VALUES ('2065', '鼻咽底恶性肿瘤', '473', 'C11.352', 'BYDEXZL', '');
INSERT INTO `05diseases` VALUES ('2066', '鼻咽前壁恶性肿瘤', '473', 'C11.353', 'BYQBEXZL', '');
INSERT INTO `05diseases` VALUES ('2067', '软腭的鼻咽(后)(上)面恶性肿瘤', '473', 'C11.354', 'REDBYHSMEXZL', '');
INSERT INTO `05diseases` VALUES ('2068', '鼻咽交搭跨越的恶性肿瘤', '473', 'C11.851', 'BYJDKYDEXZL', '');
INSERT INTO `05diseases` VALUES ('2069', '鼻咽恶性肿瘤 NOS', '473', 'C11.901', 'BYEXZL', '');
INSERT INTO `05diseases` VALUES ('2070', '鼻咽壁恶性肿瘤', '473', 'C11.951', 'BYBEXZL', '');
INSERT INTO `05diseases` VALUES ('2071', '梨状窝恶性肿瘤', '473', 'C12.X01', 'LZWEXZL', '');
INSERT INTO `05diseases` VALUES ('2072', '环状软骨后恶性肿瘤', '473', 'C13.001', 'HZRGHEXZL', '');
INSERT INTO `05diseases` VALUES ('2073', '边缘区杓状会厌褶恶性肿瘤', '473', 'C13.151', 'BYQBZHYZEXZL', '');
INSERT INTO `05diseases` VALUES ('2074', '杓状会厌褶、咽下面恶性肿瘤', '473', 'C13.152', 'BZHYZYXMEXZL', '');
INSERT INTO `05diseases` VALUES ('2075', '下咽后壁恶性肿瘤', '473', 'C13.251', 'XYHBEXZL', '');
INSERT INTO `05diseases` VALUES ('2076', '下咽交搭跨越的恶性肿瘤', '473', 'C13.851', 'XYJDKYDEXZL', '');
INSERT INTO `05diseases` VALUES ('2077', '下咽恶性肿瘤 NOS', '473', 'C13.901', 'XYEXZL', '');
INSERT INTO `05diseases` VALUES ('2078', '喉咽恶性肿瘤', '473', 'C14.001', 'HYEXZL', '');
INSERT INTO `05diseases` VALUES ('2079', '咽壁恶性肿瘤', '473', 'C14.002', 'YBEXZL', '');
INSERT INTO `05diseases` VALUES ('2080', '咽恶性肿瘤', '473', 'C14.003', 'YEXZL', '');
INSERT INTO `05diseases` VALUES ('2081', '咽后壁恶性肿瘤', '473', 'C14.004', 'YHBEXZL', '');
INSERT INTO `05diseases` VALUES ('2082', '瓦尔代尔扁桃体环恶性肿瘤', '473', 'C14.251', 'WEDEBTTHEXZL', '');
INSERT INTO `05diseases` VALUES ('2083', '颊部，牙龈恶性肿瘤', '473', 'C14.801', 'JBYYEXZL', '');
INSERT INTO `05diseases` VALUES ('2084', '舌根，咽部恶性肿瘤', '473', 'C14.802', 'SGYBEXZL', '');
INSERT INTO `05diseases` VALUES ('2085', '舌根、咽部、喉部恶性肿瘤', '473', 'C14.803', 'SGYBHBEXZL', '');
INSERT INTO `05diseases` VALUES ('2086', '唇、口腔和咽交搭跨越的恶性肿瘤', '473', 'C14.851', 'CKQHYJDKYDEXZL', '');
INSERT INTO `05diseases` VALUES ('2087', '食管颈部恶性肿瘤', '473', 'C15.051', 'SGGBEXZL', '');
INSERT INTO `05diseases` VALUES ('2088', '食管胸部恶性肿瘤', '473', 'C15.151', 'SGXBEXZL', '');
INSERT INTO `05diseases` VALUES ('2089', '食管腹部恶性肿瘤', '473', 'C15.251', 'SGFBEXZL', '');
INSERT INTO `05diseases` VALUES ('2090', '食管上段恶性肿瘤', '473', 'C15.301', 'SGSDEXZL', '');
INSERT INTO `05diseases` VALUES ('2091', '食管中段恶性肿瘤', '473', 'C15.401', 'SGZDEXZL', '');
INSERT INTO `05diseases` VALUES ('2092', '食管下段恶性肿瘤', '473', 'C15.501', 'SGXDEXZL', '');
INSERT INTO `05diseases` VALUES ('2093', '食道中下段恶性肿瘤', '473', 'C15.801', 'SDZXDEXZL', '');
INSERT INTO `05diseases` VALUES ('2094', '食管交搭跨越的恶性肿瘤', '473', 'C15.851', 'SGJDKYDEXZL', '');
INSERT INTO `05diseases` VALUES ('2095', '食管恶性肿瘤 NOS', '473', 'C15.901', 'SGEXZL', '');
INSERT INTO `05diseases` VALUES ('2096', '贲门恶性肿瘤', '473', 'C16.001', 'BMEXZL', '');
INSERT INTO `05diseases` VALUES ('2097', '食管贲门连接处恶性肿瘤', '473', 'C16.002', 'SGBMLJCEXZL', '');
INSERT INTO `05diseases` VALUES ('2098', '胃－食管连接处恶性肿瘤', '473', 'C16.051', 'WSGLJCEXZL', '');
INSERT INTO `05diseases` VALUES ('2099', '胃底恶性肿瘤', '473', 'C16.101', 'WDEXZL', '');
INSERT INTO `05diseases` VALUES ('2100', '胃体恶性肿瘤', '473', 'C16.201', 'WTEXZL', '');
INSERT INTO `05diseases` VALUES ('2101', '胃窦恶性肿瘤', '473', 'C16.301', 'WDEXZL', '');
INSERT INTO `05diseases` VALUES ('2102', '幽门窦恶性肿瘤', '473', 'C16.351', 'YMDEXZL', '');
INSERT INTO `05diseases` VALUES ('2103', '幽门恶性肿瘤', '473', 'C16.401', 'YMEXZL', '');
INSERT INTO `05diseases` VALUES ('2104', '幽门管恶性肿瘤', '473', 'C16.402', 'YMGEXZL', '');
INSERT INTO `05diseases` VALUES ('2105', '幽门前恶性肿瘤', '473', 'C16.451', 'YMQEXZL', '');
INSERT INTO `05diseases` VALUES ('2106', '胃小弯恶性肿瘤', '473', 'C16.501', 'WXWEXZL', '');
INSERT INTO `05diseases` VALUES ('2107', '胃大弯恶性肿瘤', '473', 'C16.601', 'WDWEXZL', '');
INSERT INTO `05diseases` VALUES ('2108', '胃底贲门恶性肿瘤', '473', 'C16.801', 'WDBMEXZL', '');
INSERT INTO `05diseases` VALUES ('2109', '胃交搭跨越的恶性肿瘤', '473', 'C16.851', 'WJDKYDEXZL', '');
INSERT INTO `05diseases` VALUES ('2110', '残胃恶性肿瘤(癌)[胃切除术后癌 M80100/3]', '473', 'C16.901', 'CWEXZLAWQCSHA', '');
INSERT INTO `05diseases` VALUES ('2111', '胃恶性肿瘤', '473', 'C16.902', 'WEXZL', '');
INSERT INTO `05diseases` VALUES ('2112', '胃溃疡癌变', '370', 'C16.903', 'WKYAB', '');
INSERT INTO `05diseases` VALUES ('2113', '胃息肉癌变', '370', 'C16.904', 'WXRAB', '');
INSERT INTO `05diseases` VALUES ('2114', '胃腺瘤癌变 (M80100/3)', '370', 'C16.905', 'WXLAB', '');
INSERT INTO `05diseases` VALUES ('2115', '早期胃癌', '370', 'C16.906', 'ZQWA', '');
INSERT INTO `05diseases` VALUES ('2116', '革囊胃[弥漫性浸润型胃硬癌、皮革状胃] (M81420/3)', '370', 'C16.907', 'GNWMMXJRXWYAPGZW', '');
INSERT INTO `05diseases` VALUES ('2117', '十二指肠恶性肿瘤', '473', 'C17.001', 'SEZCEXZL', '');
INSERT INTO `05diseases` VALUES ('2118', '空肠恶性肿瘤', '473', 'C17.101', 'KCEXZL', '');
INSERT INTO `05diseases` VALUES ('2119', '回肠恶性肿瘤', '473', 'C17.201', 'HCEXZL', '');
INSERT INTO `05diseases` VALUES ('2120', '麦克尔憩息恶性肿瘤', '473', 'C17.351', 'MKEQXEXZL', '');
INSERT INTO `05diseases` VALUES ('2121', '小肠交搭跨越的恶性肿瘤', '473', 'C17.851', 'XCJDKYDEXZL', '');
INSERT INTO `05diseases` VALUES ('2122', '小肠恶性肿瘤 NOS', '473', 'C17.901', 'XCEXZL', '');
INSERT INTO `05diseases` VALUES ('2123', '回盲部恶性肿瘤', '473', 'C18.001', 'HMBEXZL', '');
INSERT INTO `05diseases` VALUES ('2124', '盲肠恶性肿瘤', '473', 'C18.002', 'MCEXZL', '');
INSERT INTO `05diseases` VALUES ('2125', '阑尾恶性肿瘤', '473', 'C18.101', 'LWEXZL', '');
INSERT INTO `05diseases` VALUES ('2126', '升结肠恶性肿瘤', '473', 'C18.201', 'SJCEXZL', '');
INSERT INTO `05diseases` VALUES ('2127', '结肠肝曲恶性肿瘤', '473', 'C18.301', 'JCGQEXZL', '');
INSERT INTO `05diseases` VALUES ('2128', '横结肠恶性肿瘤', '473', 'C18.401', 'HJCEXZL', '');
INSERT INTO `05diseases` VALUES ('2129', '脾曲恶性肿瘤', '473', 'C18.501', 'PQEXZL', '');
INSERT INTO `05diseases` VALUES ('2130', '脾曲结肠恶性肿瘤', '473', 'C18.551', 'PQJCEXZL', '');
INSERT INTO `05diseases` VALUES ('2131', '降结肠恶性肿瘤', '473', 'C18.601', 'JJCEXZL', '');
INSERT INTO `05diseases` VALUES ('2132', '乙状结肠恶性肿瘤', '473', 'C18.701', 'YZJCEXZL', '');
INSERT INTO `05diseases` VALUES ('2133', '降结肠乙状结肠恶性肿瘤', '473', 'C18.801', 'JJCYZJCEXZL', '');
INSERT INTO `05diseases` VALUES ('2134', '盲肠升结肠恶性肿瘤', '473', 'C18.802', 'MCSJCEXZL', '');
INSERT INTO `05diseases` VALUES ('2135', '结肠交搭跨越的恶性肿瘤', '473', 'C18.851', 'JCJDKYDEXZL', '');
INSERT INTO `05diseases` VALUES ('2136', '结肠的腺瘤恶变', '261', 'C18.901', 'JCDXLEB', '');
INSERT INTO `05diseases` VALUES ('2137', '结肠恶性肿瘤 NOS', '473', 'C18.902', 'JCEXZL', '');
INSERT INTO `05diseases` VALUES ('2138', '大肠恶性肿瘤', '473', 'C18.951', 'DCEXZL', '');
INSERT INTO `05diseases` VALUES ('2139', '直肠乙状结肠连接处恶性肿瘤', '473', 'C19.X01', 'ZCYZJCLJCEXZL', '');
INSERT INTO `05diseases` VALUES ('2140', '结肠、直肠恶性肿瘤', '473', 'C19.X51', 'JCZCEXZL', '');
INSERT INTO `05diseases` VALUES ('2141', '直肠恶性肿瘤', '473', 'C20.X01', 'ZCEXZL', '');
INSERT INTO `05diseases` VALUES ('2142', '直肠壶腹恶性肿瘤', '473', 'C20.X51', 'ZCHFEXZL', '');
INSERT INTO `05diseases` VALUES ('2143', '肛门恶性肿瘤', '473', 'C21.001', 'GMEXZL', '');
INSERT INTO `05diseases` VALUES ('2144', '肛管恶性肿瘤', '473', 'C21.101', 'GGEXZL', '');
INSERT INTO `05diseases` VALUES ('2145', '肛门括约肌恶性肿瘤', '473', 'C21.151', 'GMKYJEXZL', '');
INSERT INTO `05diseases` VALUES ('2146', '泄殖腔源性区恶性肿瘤', '473', 'C21.251', 'XZQYXQEXZL', '');
INSERT INTO `05diseases` VALUES ('2147', '肛门直肠恶性肿瘤', '473', 'C21.801', 'GMZCEXZL', '');
INSERT INTO `05diseases` VALUES ('2148', '直肠、肛门和肛管交搭跨越的恶性肿瘤', '473', 'C21.851', 'ZCGMHGGJDKYDEXZL', '');
INSERT INTO `05diseases` VALUES ('2149', '肛管直肠癌', '2', 'C21.852', 'GGZCA', '');
INSERT INTO `05diseases` VALUES ('2150', '莫尔加尼隐窝恶性肿瘤', '473', 'C21.853', 'MEJNYWEXZL', '');
INSERT INTO `05diseases` VALUES ('2151', '肝细胞癌 (M81700/3)', '92', 'C22.001', 'GXBA', '');
INSERT INTO `05diseases` VALUES ('2152', '胆管癌 (M81600/3)', '53', 'C22.101', 'DGA', '');
INSERT INTO `05diseases` VALUES ('2153', '肝内胆管恶性肿瘤 (M81600/3)', '473', 'C22.102', 'GNDGEXZL', '');
INSERT INTO `05diseases` VALUES ('2154', '克拉特斯金瘤 (M81620/3)', '261', 'C22.151', 'KLTSJL', '');
INSERT INTO `05diseases` VALUES ('2155', '肝母细胞瘤 (M89700/3)', '92', 'C22.201', 'GMXBL', '');
INSERT INTO `05diseases` VALUES ('2156', '枯否氏细胞(肝星形细胞)肉瘤 (M91240/3)', '92', 'C22.301', 'KFSXBGXXXBRL', '');
INSERT INTO `05diseases` VALUES ('2157', '肝巨噬细胞肉瘤 (M88020/3)', '92', 'C22.351', 'GJSXBRL', '');
INSERT INTO `05diseases` VALUES ('2158', '肝血管肉瘤 (M91200/3)', '92', 'C22.352', 'GXGRL', '');
INSERT INTO `05diseases` VALUES ('2159', '肝肉瘤 (M88000/3)', '92', 'C22.451', 'GRL', '');
INSERT INTO `05diseases` VALUES ('2160', '其他特指的肝癌', '92', 'C22.751', 'QTTZDGA', '');
INSERT INTO `05diseases` VALUES ('2161', '肝恶性肿瘤 NOS', '473', 'C22.901', 'GEXZL', '');
INSERT INTO `05diseases` VALUES ('2162', '肝原发性恶性肿瘤', '473', 'C22.951', 'GYFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2163', '胆囊恶性肿瘤', '473', 'C23.051', 'DNEXZL', '');
INSERT INTO `05diseases` VALUES ('2164', '胆管恶性肿瘤', '473', 'C24.001', 'DGEXZL', '');
INSERT INTO `05diseases` VALUES ('2165', '肝管恶性肿瘤', '473', 'C24.002', 'GGEXZL', '');
INSERT INTO `05diseases` VALUES ('2166', '胆囊管恶性肿瘤', '473', 'C24.003', 'DNGEXZL', '');
INSERT INTO `05diseases` VALUES ('2167', '胆总管恶性肿瘤', '473', 'C24.004', 'DZGEXZL', '');
INSERT INTO `05diseases` VALUES ('2168', '肝外胆管恶性肿瘤', '473', 'C24.005', 'GWDGEXZL', '');
INSERT INTO `05diseases` VALUES ('2169', '肝门胆管癌[上1/3部胆管癌]', '53', 'C24.051', 'GMDGASBDGA', '');
INSERT INTO `05diseases` VALUES ('2170', '法特氏壶腹恶性肿瘤', '473', 'C24.101', 'FTSHFEXZL', '');
INSERT INTO `05diseases` VALUES ('2171', '胰腺壶腹部腺癌', '262', 'C24.102', 'YXHFBXA', '');
INSERT INTO `05diseases` VALUES ('2172', '胆总管下端的壶部癌', '53', 'C24.151', 'DZGXDDHBA', '');
INSERT INTO `05diseases` VALUES ('2173', '肝内外胆管恶性肿瘤', '473', 'C24.851', 'GNWDGEXZL', '');
INSERT INTO `05diseases` VALUES ('2174', '胆道交搭跨越的恶性肿瘤', '473', 'C24.852', 'DDJDKYDEXZL', '');
INSERT INTO `05diseases` VALUES ('2175', '胆道恶性肿瘤 NOS', '473', 'C24.951', 'DDEXZL', '');
INSERT INTO `05diseases` VALUES ('2176', '胰头恶性肿瘤', '473', 'C25.001', 'YTEXZL', '');
INSERT INTO `05diseases` VALUES ('2177', '胰体恶性肿瘤', '473', 'C25.101', 'YTEXZL', '');
INSERT INTO `05diseases` VALUES ('2178', '胰尾恶性肿瘤', '473', 'C25.201', 'YWEXZL', '');
INSERT INTO `05diseases` VALUES ('2179', '胰管(桑托理尼氏管；维尔松氏管)恶性肿瘤', '473', 'C25.301', 'YGSTLNSGWESSGEXZL', '');
INSERT INTO `05diseases` VALUES ('2180', '恶性胰岛素瘤 (M81510/3)', '261', 'C25.401', 'EXYDSL', '');
INSERT INTO `05diseases` VALUES ('2181', '胰岛恶性肿瘤', '473', 'C25.402', 'YDEXZL', '');
INSERT INTO `05diseases` VALUES ('2182', '胰岛细胞腺癌 (M81500/3)', '2', 'C25.403', 'YDXBXA', '');
INSERT INTO `05diseases` VALUES ('2183', '胰岛细胞癌 (M81500/3)', '2', 'C25.404', 'YDXBA', '');
INSERT INTO `05diseases` VALUES ('2184', '胰岛朗格罕氏恶性肿瘤', '473', 'C25.451', 'YDLGHSEXZL', '');
INSERT INTO `05diseases` VALUES ('2185', '高血糖素恶性瘤', '261', 'C25.452', 'GXTSEXL', '');
INSERT INTO `05diseases` VALUES ('2186', '朗格汉斯胰岛恶性肿瘤', '473', 'C25.453', 'LGHSYDEXZL', '');
INSERT INTO `05diseases` VALUES ('2187', '内分泌的胰腺恶性肿瘤', '473', 'C25.454', 'NFMDYXEXZL', '');
INSERT INTO `05diseases` VALUES ('2188', '胰的其他部位(胰颈)恶性肿瘤', '473', 'C25.751', 'YDQTBWYGEXZL', '');
INSERT INTO `05diseases` VALUES ('2189', '胰腺交搭跨越的恶性肿瘤', '473', 'C25.851', 'YXJDKYDEXZL', '');
INSERT INTO `05diseases` VALUES ('2190', '胰腺恶性肿瘤 NOS', '473', 'C25.901', 'YXEXZL', '');
INSERT INTO `05diseases` VALUES ('2191', '肠道恶性肿瘤', '473', 'C26.051', 'CDEXZL', '');
INSERT INTO `05diseases` VALUES ('2192', '脾恶性肿瘤', '473', 'C26.101', 'PEXZL', '');
INSERT INTO `05diseases` VALUES ('2193', '消化系统交搭跨越的恶性肿瘤', '473', 'C26.851', 'XHXTJDKYDEXZL', '');
INSERT INTO `05diseases` VALUES ('2194', '胃肠道(消化道)部位不明确的恶性肿瘤', '473', 'C26.901', 'WCDXHDBWBMQDEXZL', '');
INSERT INTO `05diseases` VALUES ('2195', '感觉神经母细胞瘤 (M95220/3)', '313', 'C30.001', 'GJSJMXBL', '');
INSERT INTO `05diseases` VALUES ('2196', '感觉神经上皮瘤 (M95230/3)', '313', 'C30.002', 'GJSJSPL', '');
INSERT INTO `05diseases` VALUES ('2197', '嗅神经母细胞瘤 (M95220/3)', '313', 'C30.003', 'XSJMXBL', '');
INSERT INTO `05diseases` VALUES ('2198', '鼻内恶性肿瘤', '473', 'C30.051', 'BNEXZL', '');
INSERT INTO `05diseases` VALUES ('2199', '鼻甲恶性肿瘤', '473', 'C30.052', 'BJEXZL', '');
INSERT INTO `05diseases` VALUES ('2200', '鼻前庭恶性肿瘤', '473', 'C30.053', 'BQTEXZL', '');
INSERT INTO `05diseases` VALUES ('2201', '鼻腔恶性肿瘤', '473', 'C30.054', 'BQEXZL', '');
INSERT INTO `05diseases` VALUES ('2202', '鼻软骨恶性肿瘤', '473', 'C30.055', 'BRGEXZL', '');
INSERT INTO `05diseases` VALUES ('2203', '鼻中隔恶性肿瘤', '473', 'C30.056', 'BZGEXZL', '');
INSERT INTO `05diseases` VALUES ('2204', '乳突恶性肿瘤', '473', 'C30.101', 'RTEXZL', '');
INSERT INTO `05diseases` VALUES ('2205', '咽鼓管恶性肿瘤', '473', 'C30.102', 'YGGEXZL', '');
INSERT INTO `05diseases` VALUES ('2206', '中耳恶性肿瘤', '473', 'C30.103', 'ZEEXZL', '');
INSERT INTO `05diseases` VALUES ('2207', '内耳恶性肿瘤', '473', 'C30.151', 'NEEXZL', '');
INSERT INTO `05diseases` VALUES ('2208', '乳突气泡恶性肿瘤', '473', 'C30.152', 'RTQPEXZL', '');
INSERT INTO `05diseases` VALUES ('2209', '咽鼓管开口恶性肿瘤', '473', 'C30.153', 'YGGKKEXZL', '');
INSERT INTO `05diseases` VALUES ('2210', '上颌窦(海默尔)恶性肿瘤', '473', 'C31.001', 'SHDHMEEXZL', '');
INSERT INTO `05diseases` VALUES ('2211', '筛窦恶性肿瘤', '473', 'C31.101', 'SDEXZL', '');
INSERT INTO `05diseases` VALUES ('2212', '额窦恶性肿瘤', '473', 'C31.201', 'EDEXZL', '');
INSERT INTO `05diseases` VALUES ('2213', '蝶窦恶性肿瘤', '473', 'C31.301', 'DDEXZL', '');
INSERT INTO `05diseases` VALUES ('2214', '副鼻窦交搭跨越的恶性肿瘤', '473', 'C31.851', 'FBDJDKYDEXZL', '');
INSERT INTO `05diseases` VALUES ('2215', '鼻窦恶性肿瘤 NOS', '473', 'C31.901', 'BDEXZL', '');
INSERT INTO `05diseases` VALUES ('2216', '副鼻窦恶性肿瘤', '473', 'C31.951', 'FBDEXZL', '');
INSERT INTO `05diseases` VALUES ('2217', '声带恶性肿瘤', '473', 'C32.001', 'SDEXZL', '');
INSERT INTO `05diseases` VALUES ('2218', '声门恶性肿瘤', '473', 'C32.002', 'SMEXZL', '');
INSERT INTO `05diseases` VALUES ('2219', '内喉恶性肿瘤', '473', 'C32.051', 'NHEXZL', '');
INSERT INTO `05diseases` VALUES ('2220', '会厌恶性肿瘤', '473', 'C32.101', 'HYEXZL', '');
INSERT INTO `05diseases` VALUES ('2221', '声门上恶性肿瘤', '473', 'C32.151', 'SMSEXZL', '');
INSERT INTO `05diseases` VALUES ('2222', '外喉恶性肿瘤', '473', 'C32.152', 'WHEXZL', '');
INSERT INTO `05diseases` VALUES ('2223', '杓状会厌褶、喉面恶性肿瘤', '473', 'C32.153', 'BZHYZHMEXZL', '');
INSERT INTO `05diseases` VALUES ('2224', '喉室带恶性肿瘤', '473', 'C32.154', 'HSDEXZL', '');
INSERT INTO `05diseases` VALUES ('2225', '会厌后面(喉面)恶性肿瘤', '473', 'C32.155', 'HYHMHMEXZL', '');
INSERT INTO `05diseases` VALUES ('2226', '假声带恶性肿瘤', '473', 'C32.156', 'JSDEXZL', '');
INSERT INTO `05diseases` VALUES ('2227', '声门下恶性肿瘤', '473', 'C32.251', 'SMXEXZL', '');
INSERT INTO `05diseases` VALUES ('2228', '喉软骨恶性肿瘤', '473', 'C32.351', 'HRGEXZL', '');
INSERT INTO `05diseases` VALUES ('2229', '喉交搭跨越性恶性肿瘤', '473', 'C32.851', 'HJDKYXEXZL', '');
INSERT INTO `05diseases` VALUES ('2230', '喉恶性肿瘤 NOS', '473', 'C32.901', 'HEXZL', '');
INSERT INTO `05diseases` VALUES ('2231', '气管恶性肿瘤', '473', 'C33.X01', 'QGEXZL', '');
INSERT INTO `05diseases` VALUES ('2232', '主支气管恶性肿瘤', '473', 'C34.001', 'ZZQGEXZL', '');
INSERT INTO `05diseases` VALUES ('2233', '肺门恶性肿瘤', '473', 'C34.051', 'FMEXZL', '');
INSERT INTO `05diseases` VALUES ('2234', '气管隆嵴恶性肿瘤', '473', 'C34.052', 'QGLJEXZL', '');
INSERT INTO `05diseases` VALUES ('2235', '肺上叶恶性肿瘤', '473', 'C34.101', 'FSYEXZL', '');
INSERT INTO `05diseases` VALUES ('2236', '肺上叶支气管恶性肿瘤', '473', 'C34.102', 'FSYZQGEXZL', '');
INSERT INTO `05diseases` VALUES ('2237', '潘科斯特瘤 (M80100/3)', '261', 'C34.151', 'PKSTL', '');
INSERT INTO `05diseases` VALUES ('2238', '肺中叶恶性肿瘤', '473', 'C34.201', 'FZYEXZL', '');
INSERT INTO `05diseases` VALUES ('2239', '中叶支气管恶性肿瘤', '473', 'C34.251', 'ZYZQGEXZL', '');
INSERT INTO `05diseases` VALUES ('2240', '肺下叶恶性肿瘤', '473', 'C34.301', 'FXYEXZL', '');
INSERT INTO `05diseases` VALUES ('2241', '下叶支气管恶性肿瘤', '473', 'C34.351', 'XYZQGEXZL', '');
INSERT INTO `05diseases` VALUES ('2242', '支气管和肺交搭跨越的恶性肿瘤', '473', 'C34.851', 'ZQGHFJDKYDEXZL', '');
INSERT INTO `05diseases` VALUES ('2243', '支气管或肺恶性肿瘤 NOS', '473', 'C34.901', 'ZQGHFEXZL', '');
INSERT INTO `05diseases` VALUES ('2244', '细支气管恶性肿瘤', '473', 'C34.902', 'XZQGEXZL', '');
INSERT INTO `05diseases` VALUES ('2245', '肺瘢痕癌', '2', 'C34.903', 'FBHA', '');
INSERT INTO `05diseases` VALUES ('2246', '右支气管肺癌', '2', 'C34.904', 'YZQGFA', '');
INSERT INTO `05diseases` VALUES ('2247', '支气管恶性肿瘤', '473', 'C34.905', 'ZQGEXZL', '');
INSERT INTO `05diseases` VALUES ('2248', '左支气管肺恶性肿瘤', '473', 'C34.906', 'ZZQGFEXZL', '');
INSERT INTO `05diseases` VALUES ('2249', '肺泡细胞癌', '2', 'C34.951', 'FPXBA', '');
INSERT INTO `05diseases` VALUES ('2250', '肺泡性腺癌', '2', 'C34.952', 'FPXXA', '');
INSERT INTO `05diseases` VALUES ('2251', '细支气管腺癌', '2', 'C34.953', 'XZQGXA', '');
INSERT INTO `05diseases` VALUES ('2252', '恶性胸腺瘤 (M85800/3)', '261', 'C37.X01', 'EXXXL', '');
INSERT INTO `05diseases` VALUES ('2253', '胸腺恶性肿瘤', '473', 'C37.X02', 'XXEXZL', '');
INSERT INTO `05diseases` VALUES ('2254', '心包恶性肿瘤', '473', 'C38.001', 'XBEXZL', '');
INSERT INTO `05diseases` VALUES ('2255', '心房恶性肿瘤', '473', 'C38.002', 'XFEXZL', '');
INSERT INTO `05diseases` VALUES ('2256', '心脏恶性肿瘤', '473', 'C38.003', 'XZEXZL', '');
INSERT INTO `05diseases` VALUES ('2257', '心肌恶性肿瘤', '473', 'C38.051', 'XJEXZL', '');
INSERT INTO `05diseases` VALUES ('2258', '心内膜恶性肿瘤', '473', 'C38.052', 'XNMEXZL', '');
INSERT INTO `05diseases` VALUES ('2259', '心脏粘液肉瘤', '403', 'C38.053', 'XZNYRL', '');
INSERT INTO `05diseases` VALUES ('2260', '前纵隔恶性肿瘤', '473', 'C38.101', 'QZGEXZL', '');
INSERT INTO `05diseases` VALUES ('2261', '后纵隔恶性肿瘤', '473', 'C38.201', 'HZGEXZL', '');
INSERT INTO `05diseases` VALUES ('2262', '纵隔恶性肿瘤', '473', 'C38.301', 'ZGEXZL', '');
INSERT INTO `05diseases` VALUES ('2263', '纵隔肉瘤', '294', 'C38.351', 'ZGRL', '');
INSERT INTO `05diseases` VALUES ('2264', '胸膜壁层恶性肿瘤', '473', 'C38.401', 'XMBCEXZL', '');
INSERT INTO `05diseases` VALUES ('2265', '胸膜恶性肿瘤', '473', 'C38.402', 'XMEXZL', '');
INSERT INTO `05diseases` VALUES ('2266', '心脏、纵隔和胸膜交搭跨越的恶性肿瘤', '473', 'C38.851', 'XZZGHXMJDKYDEXZL', '');
INSERT INTO `05diseases` VALUES ('2267', '上呼吸道恶性肿瘤', '473', 'C39.051', 'SHXDEXZL', '');
INSERT INTO `05diseases` VALUES ('2268', '鼻腔、鼻窦恶性肿瘤', '473', 'C39.801', 'BQBDEXZL', '');
INSERT INTO `05diseases` VALUES ('2269', '呼吸系统交搭跨越的恶性肿瘤', '473', 'C39.851', 'HXXTJDKYDEXZL', '');
INSERT INTO `05diseases` VALUES ('2270', '呼吸系统，部位不明确的恶性肿瘤', '473', 'C39.951', 'HXXTBWBMQDEXZL', '');
INSERT INTO `05diseases` VALUES ('2271', '肱骨恶性肿瘤', '473', 'C40.001', 'GGEXZL', '');
INSERT INTO `05diseases` VALUES ('2272', '肩胛骨恶性肿瘤', '473', 'C40.002', 'JJGEXZL', '');
INSERT INTO `05diseases` VALUES ('2273', '桡尺骨恶性肿瘤', '473', 'C40.003', 'RCGEXZL', '');
INSERT INTO `05diseases` VALUES ('2274', '肩关节恶性肿瘤', '473', 'C40.051', 'JGJEXZL', '');
INSERT INTO `05diseases` VALUES ('2275', '尺骨恶性肿瘤', '473', 'C40.052', 'CGEXZL', '');
INSERT INTO `05diseases` VALUES ('2276', '肘关节恶性肿瘤', '473', 'C40.053', 'ZGJEXZL', '');
INSERT INTO `05diseases` VALUES ('2277', '桡骨恶性肿瘤', '473', 'C40.054', 'RGEXZL', '');
INSERT INTO `05diseases` VALUES ('2278', '上肢短骨恶性肿瘤', '473', 'C40.101', 'SZDGEXZL', '');
INSERT INTO `05diseases` VALUES ('2279', '指骨恶性肿瘤', '473', 'C40.102', 'ZGEXZL', '');
INSERT INTO `05diseases` VALUES ('2280', '腕关节恶性肿瘤', '473', 'C40.151', 'WGJEXZL', '');
INSERT INTO `05diseases` VALUES ('2281', '腓骨恶性肿瘤', '473', 'C40.201', 'FGEXZL', '');
INSERT INTO `05diseases` VALUES ('2282', '股骨恶性肿瘤', '473', 'C40.202', 'GGEXZL', '');
INSERT INTO `05diseases` VALUES ('2283', '胫骨恶性肿瘤', '473', 'C40.203', 'JGEXZL', '');
INSERT INTO `05diseases` VALUES ('2284', '股骨成骨肉瘤', '294', 'C40.251', 'GGCGRL', '');
INSERT INTO `05diseases` VALUES ('2285', '膝关节恶性肿瘤', '473', 'C40.252', 'XGJEXZL', '');
INSERT INTO `05diseases` VALUES ('2286', '胫骨成骨肉瘤', '294', 'C40.253', 'JGCGRL', '');
INSERT INTO `05diseases` VALUES ('2287', '下肢短骨恶性肿瘤', '473', 'C40.301', 'XZDGEXZL', '');
INSERT INTO `05diseases` VALUES ('2288', '趾骨恶性肿瘤', '473', 'C40.302', 'ZGEXZL', '');
INSERT INTO `05diseases` VALUES ('2289', '踝关节恶性肿瘤', '473', 'C40.351', 'HGJEXZL', '');
INSERT INTO `05diseases` VALUES ('2290', '四肢的骨和关节软骨交搭跨越的恶性肿瘤', '473', 'C40.851', 'SZDGHGJRGJDKYDEXZL', '');
INSERT INTO `05diseases` VALUES ('2291', '四肢的骨和关节软骨恶性肿瘤 NOS', '473', 'C40.951', 'SZDGHGJRGEXZL', '');
INSERT INTO `05diseases` VALUES ('2292', '颅骨恶性肿瘤', '473', 'C41.001', 'LGEXZL', '');
INSERT INTO `05diseases` VALUES ('2293', '上颌恶性肿瘤', '473', 'C41.002', 'SHEXZL', '');
INSERT INTO `05diseases` VALUES ('2294', '上颌骨恶性肿瘤', '473', 'C41.003', 'SHGEXZL', '');
INSERT INTO `05diseases` VALUES ('2295', '上颌骨齿原性恶性肿瘤', '473', 'C41.004', 'SHGCYXEXZL', '');
INSERT INTO `05diseases` VALUES ('2296', '头部其它骨恶性肿瘤', '473', 'C41.051', 'TBQTGEXZL', '');
INSERT INTO `05diseases` VALUES ('2297', '眼眶骨恶性肿瘤', '473', 'C41.052', 'YKGEXZL', '');
INSERT INTO `05diseases` VALUES ('2298', '额骨恶性肿瘤', '473', 'C41.053', 'EGEXZL', '');
INSERT INTO `05diseases` VALUES ('2299', '下颌骨恶性肿瘤', '473', 'C41.101', 'XHGEXZL', '');
INSERT INTO `05diseases` VALUES ('2300', '下颌骨齿原性恶性肿瘤', '473', 'C41.102', 'XHGCYXEXZL', '');
INSERT INTO `05diseases` VALUES ('2301', '脊柱恶性肿瘤', '473', 'C41.201', 'JZEXZL', '');
INSERT INTO `05diseases` VALUES ('2302', '颈椎恶性肿瘤', '473', 'C41.202', 'GZEXZL', '');
INSERT INTO `05diseases` VALUES ('2303', '胸椎恶性肿瘤', '473', 'C41.203', 'XZEXZL', '');
INSERT INTO `05diseases` VALUES ('2304', '腰椎恶性肿瘤', '473', 'C41.204', 'YZEXZL', '');
INSERT INTO `05diseases` VALUES ('2305', '椎体恶性肿瘤', '473', 'C41.205', 'ZTEXZL', '');
INSERT INTO `05diseases` VALUES ('2306', '肋骨恶性肿瘤', '473', 'C41.301', 'LGEXZL', '');
INSERT INTO `05diseases` VALUES ('2307', '锁骨恶性肿瘤', '473', 'C41.302', 'SGEXZL', '');
INSERT INTO `05diseases` VALUES ('2308', '胸骨恶性肿瘤', '473', 'C41.303', 'XGEXZL', '');
INSERT INTO `05diseases` VALUES ('2309', '耻骨恶性肿瘤', '473', 'C41.401', 'CGEXZL', '');
INSERT INTO `05diseases` VALUES ('2310', '骶骨恶性肿瘤', '473', 'C41.402', 'DGEXZL', '');
INSERT INTO `05diseases` VALUES ('2311', '髂骨恶性肿瘤', '473', 'C41.403', 'QGEXZL', '');
INSERT INTO `05diseases` VALUES ('2312', '尾骨恶性肿瘤', '473', 'C41.451', 'WGEXZL', '');
INSERT INTO `05diseases` VALUES ('2313', '盆骨恶性肿瘤', '473', 'C41.452', 'PGEXZL', '');
INSERT INTO `05diseases` VALUES ('2314', '骨和关节软骨交搭跨越的恶性肿瘤', '473', 'C41.851', 'GHGJRGJDKYDEXZL', '');
INSERT INTO `05diseases` VALUES ('2315', '骨恶性肿瘤', '473', 'C41.901', 'GEXZL', '');
INSERT INTO `05diseases` VALUES ('2316', '骨巨细胞未特指的恶性肿瘤', '473', 'C41.951', 'GJXBWTZDEXZL', '');
INSERT INTO `05diseases` VALUES ('2317', '骨膜肉瘤', '294', 'C41.952', 'GMRL', '');
INSERT INTO `05diseases` VALUES ('2318', '关节软骨肉瘤', '123', 'C41.953', 'GJRGRL', '');
INSERT INTO `05diseases` VALUES ('2319', '唇恶性黑色素瘤 (M87200/3)', '131', 'C43.001', 'CEXHSSL', '');
INSERT INTO `05diseases` VALUES ('2320', '眼睑恶性黑色素瘤 (M87200/3)', '430', 'C43.101', 'YJEXHSSL', '');
INSERT INTO `05diseases` VALUES ('2321', '眦恶性黑色素瘤 (M87200/3)', '131', 'C43.151', 'ZEXHSSL', '');
INSERT INTO `05diseases` VALUES ('2322', '耳廓恶性黑色素瘤 (M87200/3)', '70', 'C43.201', 'EKEXHSSL', '');
INSERT INTO `05diseases` VALUES ('2323', '外耳道恶性黑色素瘤 (M87200/3)', '70', 'C43.251', 'WEDEXHSSL', '');
INSERT INTO `05diseases` VALUES ('2324', '鼻恶性黑色素瘤 (M87200/3)', '16', 'C43.301', 'BEXHSSL', '');
INSERT INTO `05diseases` VALUES ('2325', '面部皮肤黑色素瘤 (M87200/3)', '250', 'C43.302', 'MBPFHSSL', '');
INSERT INTO `05diseases` VALUES ('2326', '颊(外部的)恶性黑色素瘤', '131', 'C43.351', 'JWBDEXHSSL', '');
INSERT INTO `05diseases` VALUES ('2327', '眉恶性黑色素瘤(恶性) (M87200/3)', '131', 'C43.352', 'MEXHSSLEX', '');
INSERT INTO `05diseases` VALUES ('2328', '颈部黑色素瘤 (M87200/3)', '131', 'C43.401', 'GBHSSL', '');
INSERT INTO `05diseases` VALUES ('2329', '头皮恶性黑色素瘤 (M87200/3)', '131', 'C43.402', 'TPEXHSSL', '');
INSERT INTO `05diseases` VALUES ('2330', '腹股沟恶性黑色素瘤 (M87200/3)', '131', 'C43.501', 'FGGEXHSSL', '');
INSERT INTO `05diseases` VALUES ('2331', '乳房皮肤恶性黑色素瘤 (M87200/3)', '250', 'C43.551', 'RFPFEXHSSL', '');
INSERT INTO `05diseases` VALUES ('2332', '肛门边缘恶性黑色素瘤 (M87200/3)', '131', 'C43.552', 'GMBYEXHSSL', '');
INSERT INTO `05diseases` VALUES ('2333', '肛周皮肤恶性黑色素瘤 (M87200/3)', '250', 'C43.553', 'GZPFEXHSSL', '');
INSERT INTO `05diseases` VALUES ('2334', '上肢恶性黑色素瘤（M87200/3）', '131', 'C43.601', 'SZEXHSSL', '');
INSERT INTO `05diseases` VALUES ('2335', '手指黑色素瘤 (M87200/3）', '131', 'C43.602', 'SZHSSL', '');
INSERT INTO `05diseases` VALUES ('2336', '肩恶性黑色素瘤 (M87200/3)', '131', 'C43.651', 'JEXHSSL', '');
INSERT INTO `05diseases` VALUES ('2337', '下肢恶性黑色素瘤 (M87200/3)', '131', 'C43.701', 'XZEXHSSL', '');
INSERT INTO `05diseases` VALUES ('2338', '髋恶性黑色素瘤 (M87200/3)', '131', 'C43.751', 'KEXHSSL', '');
INSERT INTO `05diseases` VALUES ('2339', '足恶性黑色素瘤 (M87200/3)', '131', 'C43.752', 'ZEXHSSL', '');
INSERT INTO `05diseases` VALUES ('2340', '皮肤交搭跨越的恶性黑色素瘤 (M87200/3)', '250', 'C43.851', 'PFJDKYDEXHSSL', '');
INSERT INTO `05diseases` VALUES ('2341', '黑色素瘤 (M87200/3)', '131', 'C43.901', 'HSSL', '');
INSERT INTO `05diseases` VALUES ('2342', '皮肤黑色素瘤 (M87200/3)', '250', 'C43.902', 'PFHSSL', '');
INSERT INTO `05diseases` VALUES ('2343', '唇皮肤恶性肿瘤', '473', 'C44.001', 'CPFEXZL', '');
INSERT INTO `05diseases` VALUES ('2344', '唇基底细胞癌 (M80900/3)', '2', 'C44.051', 'CJDXBA', '');
INSERT INTO `05diseases` VALUES ('2345', '睑板腺[迈博腺]恶性肿瘤', '473', 'C44.101', 'JBXMBXEXZL', '');
INSERT INTO `05diseases` VALUES ('2346', '眼睑恶性肿瘤', '473', 'C44.102', 'YJEXZL', '');
INSERT INTO `05diseases` VALUES ('2347', '眼睑皮肤恶性肿瘤', '473', 'C44.103', 'YJPFEXZL', '');
INSERT INTO `05diseases` VALUES ('2348', '眦皮肤恶性肿瘤', '473', 'C44.151', 'ZPFEXZL', '');
INSERT INTO `05diseases` VALUES ('2349', '耵聍腺癌 (M84200/3)', '2', 'C44.201', 'DNXA', '');
INSERT INTO `05diseases` VALUES ('2350', '耳部恶性肿瘤', '473', 'C44.202', 'EBEXZL', '');
INSERT INTO `05diseases` VALUES ('2351', '耳廓恶性肿瘤', '473', 'C44.203', 'EKEXZL', '');
INSERT INTO `05diseases` VALUES ('2352', '耳皮肤恶性肿瘤', '473', 'C44.204', 'EPFEXZL', '');
INSERT INTO `05diseases` VALUES ('2353', '外耳道恶性肿瘤', '473', 'C44.205', 'WEDEXZL', '');
INSERT INTO `05diseases` VALUES ('2354', '鼻部皮肤恶性肿瘤', '473', 'C44.301', 'BBPFEXZL', '');
INSERT INTO `05diseases` VALUES ('2355', '鼻唇沟恶性肿瘤', '473', 'C44.302', 'BCGEXZL', '');
INSERT INTO `05diseases` VALUES ('2356', '额部皮肤恶性肿瘤', '473', 'C44.303', 'EBPFEXZL', '');
INSERT INTO `05diseases` VALUES ('2357', '面部皮肤恶性肿瘤', '473', 'C44.304', 'MBPFEXZL', '');
INSERT INTO `05diseases` VALUES ('2358', '面部其他的和未特指皮肤的恶性肿瘤', '473', 'C44.305', 'MBQTDHWTZPFDEXZL', '');
INSERT INTO `05diseases` VALUES ('2359', '颞部皮肤恶性肿瘤', '473', 'C44.306', 'NBPFEXZL', '');
INSERT INTO `05diseases` VALUES ('2360', '外鼻基底细胞瘤 (M80900/3)', '16', 'C44.351', 'WBJDXBL', '');
INSERT INTO `05diseases` VALUES ('2361', '颌下皮肤恶性肿瘤', '473', 'C44.401', 'HXPFEXZL', '');
INSERT INTO `05diseases` VALUES ('2362', '颈部皮肤恶性肿瘤', '473', 'C44.402', 'GBPFEXZL', '');
INSERT INTO `05diseases` VALUES ('2363', '头颈皮肤恶性肿瘤', '473', 'C44.403', 'TGPFEXZL', '');
INSERT INTO `05diseases` VALUES ('2364', '头皮恶性肿瘤', '473', 'C44.404', 'TPEXZL', '');
INSERT INTO `05diseases` VALUES ('2365', '背皮肤恶性肿瘤', '473', 'C44.501', 'BPFEXZL', '');
INSERT INTO `05diseases` VALUES ('2366', '腹壁恶性肿瘤', '473', 'C44.502', 'FBEXZL', '');
INSERT INTO `05diseases` VALUES ('2367', '躯干皮肤恶性肿瘤', '473', 'C44.503', 'QGPFEXZL', '');
INSERT INTO `05diseases` VALUES ('2368', '臀部皮肤恶性肿瘤', '473', 'C44.504', 'TBPFEXZL', '');
INSERT INTO `05diseases` VALUES ('2369', '肛门边缘的恶性肿瘤', '473', 'C44.551', 'GMBYDEXZL', '');
INSERT INTO `05diseases` VALUES ('2370', '肛门的皮肤的恶性肿瘤', '473', 'C44.552', 'GMDPFDEXZL', '');
INSERT INTO `05diseases` VALUES ('2371', '肛周皮肤恶性肿瘤', '473', 'C44.553', 'GZPFEXZL', '');
INSERT INTO `05diseases` VALUES ('2372', '乳房皮肤恶性肿瘤', '473', 'C44.554', 'RFPFEXZL', '');
INSERT INTO `05diseases` VALUES ('2373', '上肢皮肤恶性肿瘤', '473', 'C44.601', 'SZPFEXZL', '');
INSERT INTO `05diseases` VALUES ('2374', '肩皮肤恶性肿瘤', '473', 'C44.651', 'JPFEXZL', '');
INSERT INTO `05diseases` VALUES ('2375', '下肢皮肤恶性肿瘤', '473', 'C44.701', 'XZPFEXZL', '');
INSERT INTO `05diseases` VALUES ('2376', '髋皮肤恶性肿瘤', '473', 'C44.751', 'KPFEXZL', '');
INSERT INTO `05diseases` VALUES ('2377', '皮肤交搭跨越的恶性肿瘤', '473', 'C44.851', 'PFJDKYDEXZL', '');
INSERT INTO `05diseases` VALUES ('2378', '汗腺恶性肿瘤', '473', 'C44.901', 'HXEXZL', '');
INSERT INTO `05diseases` VALUES ('2379', '皮肤恶性肿瘤 NOS', '473', 'C44.902', 'PFEXZL', '');
INSERT INTO `05diseases` VALUES ('2380', '皮肤溃疡癌变 (M80000/3)', '250', 'C44.903', 'PFKYAB', '');
INSERT INTO `05diseases` VALUES ('2381', '胸膜恶性间皮瘤 (M90500/3)', '251', 'C45.001', 'XMEXJPL', '');
INSERT INTO `05diseases` VALUES ('2382', '腹膜恶性间皮瘤 (M90500/3)', '251', 'C45.101', 'FMEXJPL', '');
INSERT INTO `05diseases` VALUES ('2383', '网膜恶性间皮瘤 (M90500/3)', '251', 'C45.151', 'WMEXJPL', '');
INSERT INTO `05diseases` VALUES ('2384', '结肠系膜恶性间皮瘤 (M90500/3)', '251', 'C45.152', 'JCXMEXJPL', '');
INSERT INTO `05diseases` VALUES ('2385', '肠系膜恶性间皮瘤 (M90500/3)', '251', 'C45.153', 'CXMEXJPL', '');
INSERT INTO `05diseases` VALUES ('2386', '心包恶性间皮瘤 (M90500/3)', '251', 'C45.251', 'XBEXJPL', '');
INSERT INTO `05diseases` VALUES ('2387', '其他部位的恶性间皮瘤 (M90500/3)', '251', 'C45.751', 'QTBWDEXJPL', '');
INSERT INTO `05diseases` VALUES ('2388', '恶性间皮瘤 NOS (M90500/3)', '251', 'C45.951', 'EXJPL', '');
INSERT INTO `05diseases` VALUES ('2389', '皮肤卡波西肉瘤 (M91400/3)', '250', 'C46.051', 'PFKBXRL', '');
INSERT INTO `05diseases` VALUES ('2390', '软组织卡波西肉瘤 (M91400/3)', '294', 'C46.151', 'RZZKBXRL', '');
INSERT INTO `05diseases` VALUES ('2391', '腭卡波西肉瘤 (M91400/3)', '294', 'C46.251', 'EKBXRL', '');
INSERT INTO `05diseases` VALUES ('2392', '淋巴结卡波西肉瘤 (M91400/3)', '294', 'C46.351', 'LBJKBXRL', '');
INSERT INTO `05diseases` VALUES ('2393', '其他部位的卡波西肉瘤 (M91400/3)', '294', 'C46.751', 'QTBWDKBXRL', '');
INSERT INTO `05diseases` VALUES ('2394', '多器官卡波西肉瘤 (M91400/3)', '294', 'C46.851', 'DQGKBXRL', '');
INSERT INTO `05diseases` VALUES ('2395', '卡波西肉瘤 NOS (M91400/3)', '294', 'C46.901', 'KBXRL', '');
INSERT INTO `05diseases` VALUES ('2396', '头恶性周围神经肿瘤', '473', 'C47.051', 'TEXZWSJZL', '');
INSERT INTO `05diseases` VALUES ('2397', '面恶性周围神经肿瘤', '473', 'C47.052', 'MEXZWSJZL', '');
INSERT INTO `05diseases` VALUES ('2398', '颈恶性周围神经肿瘤', '473', 'C47.053', 'GEXZWSJZL', '');
INSERT INTO `05diseases` VALUES ('2399', '肩恶性周围神经肿瘤', '473', 'C47.151', 'JEXZWSJZL', '');
INSERT INTO `05diseases` VALUES ('2400', '臂丛恶性神经肿瘤', '473', 'C47.152', 'BCEXSJZL', '');
INSERT INTO `05diseases` VALUES ('2401', '上肢恶性周围神经肿瘤', '473', 'C47.153', 'SZEXZWSJZL', '');
INSERT INTO `05diseases` VALUES ('2402', '股神经恶性肿瘤', '473', 'C47.201', 'GSJEXZL', '');
INSERT INTO `05diseases` VALUES ('2403', '髋恶性周围神经肿瘤', '473', 'C47.252', 'KEXZWSJZL', '');
INSERT INTO `05diseases` VALUES ('2404', '下肢恶性周围神经肿瘤', '473', 'C47.253', 'XZEXZWSJZL', '');
INSERT INTO `05diseases` VALUES ('2405', '胸恶性周围神经肿瘤', '473', 'C47.351', 'XEXZWSJZL', '');
INSERT INTO `05diseases` VALUES ('2406', '腹恶性周围神经肿瘤', '473', 'C47.451', 'FEXZWSJZL', '');
INSERT INTO `05diseases` VALUES ('2407', '骨盆恶性周围神经肿瘤', '473', 'C47.551', 'GPEXZWSJZL', '');
INSERT INTO `05diseases` VALUES ('2408', '躯干恶性周围神经肿瘤', '473', 'C47.651', 'QGEXZWSJZL', '');
INSERT INTO `05diseases` VALUES ('2409', '周围神经和自主神经系统交搭跨越的恶性肿瘤', '473', 'C47.851', 'ZWSJHZZSJXTJDKYDEXZL', '');
INSERT INTO `05diseases` VALUES ('2410', '周围神经和自主神经系统的恶性肿瘤 NOS', '473', 'C47.951', 'ZWSJHZZSJXTDEXZL', '');
INSERT INTO `05diseases` VALUES ('2411', '腹膜后恶性肿瘤', '473', 'C48.001', 'FMHEXZL', '');
INSERT INTO `05diseases` VALUES ('2412', '腹主动脉旁恶性肿瘤', '473', 'C48.002', 'FZDMPEXZL', '');
INSERT INTO `05diseases` VALUES ('2413', '肾上腺周围恶性肿瘤', '473', 'C48.003', 'SSXZWEXZL', '');
INSERT INTO `05diseases` VALUES ('2414', '肠系膜恶性肿瘤', '473', 'C48.101', 'CXMEXZL', '');
INSERT INTO `05diseases` VALUES ('2415', '腹膜壁层恶性肿瘤', '473', 'C48.151', 'FMBCEXZL', '');
INSERT INTO `05diseases` VALUES ('2416', '腹膜骨盆恶性肿瘤', '473', 'C48.152', 'FMGPEXZL', '');
INSERT INTO `05diseases` VALUES ('2417', '结肠系膜恶性肿瘤', '473', 'C48.153', 'JCXMEXZL', '');
INSERT INTO `05diseases` VALUES ('2418', '大网膜恶性肿瘤', '473', 'C48.154', 'DWMEXZL', '');
INSERT INTO `05diseases` VALUES ('2419', '道格拉斯陷凹或襄恶性肿瘤', '473', 'C48.155', 'DGLSXAHXEXZL', '');
INSERT INTO `05diseases` VALUES ('2420', '网膜恶性肿瘤', '473', 'C48.156', 'WMEXZL', '');
INSERT INTO `05diseases` VALUES ('2421', '腹膜恶性肿瘤', '473', 'C48.201', 'FMEXZL', '');
INSERT INTO `05diseases` VALUES ('2422', '腹膜腔恶性肿瘤', '473', 'C48.202', 'FMQEXZL', '');
INSERT INTO `05diseases` VALUES ('2423', '腹膜和腹膜后交搭跨越的恶性肿瘤', '473', 'C48.851', 'FMHFMHJDKYDEXZL', '');
INSERT INTO `05diseases` VALUES ('2424', '耳结缔组织恶性肿瘤', '473', 'C49.001', 'EJDZZEXZL', '');
INSERT INTO `05diseases` VALUES ('2425', '颈部结缔组织恶性肿瘤', '473', 'C49.002', 'GBJDZZEXZL', '');
INSERT INTO `05diseases` VALUES ('2426', '面部结缔组织恶性肿瘤', '473', 'C49.003', 'MBJDZZEXZL', '');
INSERT INTO `05diseases` VALUES ('2427', '颞部结缔组织恶性肿瘤', '473', 'C49.004', 'NBJDZZEXZL', '');
INSERT INTO `05diseases` VALUES ('2428', '头部结缔组织恶性肿瘤', '473', 'C49.005', 'TBJDZZEXZL', '');
INSERT INTO `05diseases` VALUES ('2429', '睑结缔组织恶性肿瘤', '473', 'C49.051', 'JJDZZEXZL', '');
INSERT INTO `05diseases` VALUES ('2430', '上肢结缔组织恶性肿瘤', '473', 'C49.101', 'SZJDZZEXZL', '');
INSERT INTO `05diseases` VALUES ('2431', '肩结缔组织和软组织恶性肿瘤', '473', 'C49.151', 'JJDZZHRZZEXZL', '');
INSERT INTO `05diseases` VALUES ('2432', '下肢结缔组织恶性肿瘤', '473', 'C49.201', 'XZJDZZEXZL', '');
INSERT INTO `05diseases` VALUES ('2433', '髋结缔组织和软组织恶性肿瘤', '473', 'C49.251', 'KJDZZHRZZEXZL', '');
INSERT INTO `05diseases` VALUES ('2434', '横膈恶性肿瘤', '473', 'C49.301', 'HGEXZL', '');
INSERT INTO `05diseases` VALUES ('2435', '肩胛区结缔组织恶性肿瘤', '473', 'C49.302', 'JJQJDZZEXZL', '');
INSERT INTO `05diseases` VALUES ('2436', '胸结缔组织恶性肿瘤', '473', 'C49.303', 'XJDZZEXZL', '');
INSERT INTO `05diseases` VALUES ('2437', '腋下结缔组织恶性肿瘤', '473', 'C49.304', 'YXJDZZEXZL', '');
INSERT INTO `05diseases` VALUES ('2438', '膈肌神经纤维肉瘤 (M95400/3)', '313', 'C49.351', 'GJSJXWRL', '');
INSERT INTO `05diseases` VALUES ('2439', '膈恶性肿瘤', '473', 'C49.352', 'GEXZL', '');
INSERT INTO `05diseases` VALUES ('2440', '胸壁结缔组织恶性肿瘤', '473', 'C49.353', 'XBJDZZEXZL', '');
INSERT INTO `05diseases` VALUES ('2441', '腹部结缔组织恶性肿瘤', '473', 'C49.401', 'FBJDZZEXZL', '');
INSERT INTO `05diseases` VALUES ('2442', '下腔静脉恶性肿瘤', '473', 'C49.402', 'XQJMEXZL', '');
INSERT INTO `05diseases` VALUES ('2443', '季肋部结缔组织和软组织恶性肿瘤', '473', 'C49.451', 'JLBJDZZHRZZEXZL', '');
INSERT INTO `05diseases` VALUES ('2444', '骶前结缔组织恶性肿瘤', '473', 'C49.501', 'DQJDZZEXZL', '');
INSERT INTO `05diseases` VALUES ('2445', '腹股沟结缔组织恶性肿瘤', '473', 'C49.502', 'FGGJDZZEXZL', '');
INSERT INTO `05diseases` VALUES ('2446', '会阴部恶性肿瘤', '473', 'C49.503', 'HYBEXZL', '');
INSERT INTO `05diseases` VALUES ('2447', '盆腔结缔组织恶性肿瘤', '473', 'C49.504', 'PQJDZZEXZL', '');
INSERT INTO `05diseases` VALUES ('2448', '直肠阴道隔结缔组织恶性肿瘤', '473', 'C49.505', 'ZCYDGJDZZEXZL', '');
INSERT INTO `05diseases` VALUES ('2449', '臀部结缔组织恶性肿瘤', '473', 'C49.551', 'TBJDZZEXZL', '');
INSERT INTO `05diseases` VALUES ('2450', '躯干结缔组织恶性肿瘤', '473', 'C49.601', 'QGJDZZEXZL', '');
INSERT INTO `05diseases` VALUES ('2451', '结缔组织和软组织交搭跨越的恶性肿瘤', '473', 'C49.851', 'JDZZHRZZJDKYDEXZL', '');
INSERT INTO `05diseases` VALUES ('2452', '葡萄样肉瘤 (M89100/3)', '294', 'C49.901', 'PTYRL', '');
INSERT INTO `05diseases` VALUES ('2453', '结缔组织恶性肿瘤 NOS', '473', 'C49.902', 'JDZZEXZL', '');
INSERT INTO `05diseases` VALUES ('2454', '淋巴管恶性肿瘤', '473', 'C49.903', 'LBGEXZL', '');
INSERT INTO `05diseases` VALUES ('2455', '结缔组织和软组织恶性肿瘤', '473', 'C49.951', 'JDZZHRZZEXZL', '');
INSERT INTO `05diseases` VALUES ('2456', '粘液肌肉肉瘤 (M88400/3)', '294', 'C49.952', 'NYJRRL', '');
INSERT INTO `05diseases` VALUES ('2457', '粘液腱膜肉瘤 (M88400/3)', '294', 'C49.953', 'NYJMRL', '');
INSERT INTO `05diseases` VALUES ('2458', '皮下肉瘤', '294', 'C49.954', 'PXRL', '');
INSERT INTO `05diseases` VALUES ('2459', '乳头恶性肿瘤', '473', 'C50.001', 'RTEXZL', '');
INSERT INTO `05diseases` VALUES ('2460', '乳头乳晕恶性肿瘤', '473', 'C50.002', 'RTRYEXZL', '');
INSERT INTO `05diseases` VALUES ('2461', '乳晕恶性肿瘤', '473', 'C50.051', 'RYEXZL', '');
INSERT INTO `05diseases` VALUES ('2462', '乳房中央部恶性肿瘤', '473', 'C50.151', 'RFZYBEXZL', '');
INSERT INTO `05diseases` VALUES ('2463', '乳房上内象限恶性肿瘤', '473', 'C50.251', 'RFSNXXEXZL', '');
INSERT INTO `05diseases` VALUES ('2464', '乳房下内象限恶性肿瘤', '473', 'C50.351', 'RFXNXXEXZL', '');
INSERT INTO `05diseases` VALUES ('2465', '乳房上外象限恶性肿瘤', '473', 'C50.451', 'RFSWXXEXZL', '');
INSERT INTO `05diseases` VALUES ('2466', '乳房下外象限恶性肿瘤', '473', 'C50.551', 'RFXWXXEXZL', '');
INSERT INTO `05diseases` VALUES ('2467', '乳房腋尾部恶性肿瘤', '473', 'C50.651', 'RFYWBEXZL', '');
INSERT INTO `05diseases` VALUES ('2468', '乳房交搭跨越的恶性肿瘤', '473', 'C50.851', 'RFJDKYDEXZL', '');
INSERT INTO `05diseases` VALUES ('2469', '副乳腺恶性肿瘤', '473', 'C50.901', 'FRXEXZL', '');
INSERT INTO `05diseases` VALUES ('2470', '乳腺(房)恶性肿瘤 NOS', '473', 'C50.902', 'RXFEXZL', '');
INSERT INTO `05diseases` VALUES ('2471', '乳腺佩吉特氏病 [乳房外湿疹样癌](M85400/3)', '2', 'C50.903', 'RXPJTSBRFWSZYA', '');
INSERT INTO `05diseases` VALUES ('2472', '乳房佩吉特氏病伴浸润性导管癌 (M85410/3)', '2', 'C50.904', 'RFPJTSBBJRXDGA', '');
INSERT INTO `05diseases` VALUES ('2473', '大阴唇恶性肿瘤', '473', 'C51.001', 'DYCEXZL', '');
INSERT INTO `05diseases` VALUES ('2474', '前庭大腺[巴多林腺]恶性肿瘤', '473', 'C51.002', 'QTDXBDLXEXZL', '');
INSERT INTO `05diseases` VALUES ('2475', '小阴唇恶性肿瘤', '473', 'C51.101', 'XYCEXZL', '');
INSERT INTO `05diseases` VALUES ('2476', '阴蒂恶性肿瘤', '473', 'C51.201', 'YDEXZL', '');
INSERT INTO `05diseases` VALUES ('2477', '外阴交搭跨越的恶性肿瘤', '473', 'C51.851', 'WYJDKYDEXZL', '');
INSERT INTO `05diseases` VALUES ('2478', '外阴恶性肿瘤 NOS', '473', 'C51.901', 'WYEXZL', '');
INSERT INTO `05diseases` VALUES ('2479', '外阴佩杰特氏病[湿疹样癌]', '2', 'C51.902', 'WYPJTSBSZYA', '');
INSERT INTO `05diseases` VALUES ('2480', '阴道恶性肿瘤', '473', 'C52.X01', 'YDEXZL', '');
INSERT INTO `05diseases` VALUES ('2481', '加特纳管[卵巢冠纵管]恶性肿瘤', '473', 'C52.X51', 'JTNGLCGZGEXZL', '');
INSERT INTO `05diseases` VALUES ('2482', '纳博特腺恶性肿瘤(滤泡)', '473', 'C53.051', 'NBTXEXZLLP', '');
INSERT INTO `05diseases` VALUES ('2483', '子宫颈管恶性肿瘤', '473', 'C53.052', 'ZGGGEXZL', '');
INSERT INTO `05diseases` VALUES ('2484', '子宫颈内膜恶性肿瘤', '473', 'C53.053', 'ZGGNMEXZL', '');
INSERT INTO `05diseases` VALUES ('2485', '外子宫颈恶性肿瘤', '473', 'C53.151', 'WZGGEXZL', '');
INSERT INTO `05diseases` VALUES ('2486', '宫颈交搭跨越的恶性肿瘤', '473', 'C53.851', 'GGJDKYDEXZL', '');
INSERT INTO `05diseases` VALUES ('2487', '子宫颈残端恶性肿瘤', '473', 'C53.901', 'ZGGCDEXZL', '');
INSERT INTO `05diseases` VALUES ('2488', '子宫颈恶性肿瘤 NOS', '473', 'C53.902', 'ZGGEXZL', '');
INSERT INTO `05diseases` VALUES ('2489', '子宫峡恶性肿瘤', '473', 'C54.051', 'ZGXEXZL', '');
INSERT INTO `05diseases` VALUES ('2490', '子宫下段恶性肿瘤', '473', 'C54.052', 'ZGXDEXZL', '');
INSERT INTO `05diseases` VALUES ('2491', '子宫内膜恶性肿瘤', '473', 'C54.101', 'ZGNMEXZL', '');
INSERT INTO `05diseases` VALUES ('2492', '子宫肌层恶性肿瘤', '473', 'C54.251', 'ZGJCEXZL', '');
INSERT INTO `05diseases` VALUES ('2493', '子宫底恶性肿瘤', '473', 'C54.351', 'ZGDEXZL', '');
INSERT INTO `05diseases` VALUES ('2494', '子宫体交搭跨越的恶性肿瘤', '473', 'C54.851', 'ZGTJDKYDEXZL', '');
INSERT INTO `05diseases` VALUES ('2495', '子宫体恶性肿瘤 NOS', '473', 'C54.901', 'ZGTEXZL', '');
INSERT INTO `05diseases` VALUES ('2496', '子宫恶性肿瘤 NOS', '473', 'C55.X01', 'ZGEXZL', '');
INSERT INTO `05diseases` VALUES ('2497', '子宫肉瘤', '86', 'C55.X51', 'ZGRL', '');
INSERT INTO `05diseases` VALUES ('2498', '子宫绒毛膜上皮癌 (M91000/3)', '86', 'C55.X52', 'ZGRMMSPA', '');
INSERT INTO `05diseases` VALUES ('2499', '恶性纤维上皮瘤(恶性布伦纳瘤) (M90000/3)', '251', 'C56.X01', 'EXXWSPLEXBLNL', '');
INSERT INTO `05diseases` VALUES ('2500', '卵巢恶性肿瘤', '473', 'C56.X02', 'LCEXZL', '');
INSERT INTO `05diseases` VALUES ('2501', '卵巢交界恶性浆液性囊腺瘤 (M84420/3)', '86', 'C56.X03', 'LCJJEXJYXNXL', '');
INSERT INTO `05diseases` VALUES ('2502', '泡膜细胞癌 (M86000/3)', '2', 'C56.X04', 'PMXBA', '');
INSERT INTO `05diseases` VALUES ('2503', '卵巢恶性畸胎瘤', '86', 'C56.X51', 'LCEXJTL', '');
INSERT INTO `05diseases` VALUES ('2504', '输卵管恶性肿瘤', '473', 'C57.001', 'SLGEXZL', '');
INSERT INTO `05diseases` VALUES ('2505', '卵巢冠恶性肿瘤', '473', 'C57.101', 'LCGEXZL', '');
INSERT INTO `05diseases` VALUES ('2506', '阔韧带恶性肿瘤', '473', 'C57.151', 'KRDEXZL', '');
INSERT INTO `05diseases` VALUES ('2507', '圆韧带恶性肿瘤', '473', 'C57.251', 'YRDEXZL', '');
INSERT INTO `05diseases` VALUES ('2508', '子宫骶骨韧带恶性肿瘤', '473', 'C57.301', 'ZGDGRDEXZL', '');
INSERT INTO `05diseases` VALUES ('2509', '子宫旁组织恶性肿瘤', '473', 'C57.351', 'ZGPZZEXZL', '');
INSERT INTO `05diseases` VALUES ('2510', '子宫韧带恶性肿瘤', '473', 'C57.352', 'ZGRDEXZL', '');
INSERT INTO `05diseases` VALUES ('2511', '子宫附件恶性肿瘤', '473', 'C57.401', 'ZGFJEXZL', '');
INSERT INTO `05diseases` VALUES ('2512', '其他特指的女性生殖器官恶性肿瘤', '473', 'C57.751', 'QTTZDNXSZQGEXZL', '');
INSERT INTO `05diseases` VALUES ('2513', '沃尔夫体或管恶性肿瘤', '473', 'C57.752', 'WEFTHGEXZL', '');
INSERT INTO `05diseases` VALUES ('2514', '女性生殖器官交搭跨越的恶性肿瘤', '473', 'C57.851', 'NXSZQGJDKYDEXZL', '');
INSERT INTO `05diseases` VALUES ('2515', '输卵管-卵巢交搭跨越的恶性肿瘤', '473', 'C57.852', 'SLGLCJDKYDEXZL', '');
INSERT INTO `05diseases` VALUES ('2516', '子宫-卵巢交搭跨越的恶性肿瘤', '473', 'C57.853', 'ZGLCJDKYDEXZL', '');
INSERT INTO `05diseases` VALUES ('2517', '女性生殖器官恶性肿瘤 NOS', '473', 'C57.951', 'NXSZQGEXZL', '');
INSERT INTO `05diseases` VALUES ('2518', '女性泌尿生殖道恶性肿瘤 NOS', '473', 'C57.952', 'NXMNSZDEXZL', '');
INSERT INTO `05diseases` VALUES ('2519', '女性绒毛膜上皮癌 (M91000/3)', '2', 'C58.X51', 'NXRMMSPA', '');
INSERT INTO `05diseases` VALUES ('2520', '绒毛膜上皮癌 (M91000/3)', '2', 'C58.X52', 'RMMSPA', '');
INSERT INTO `05diseases` VALUES ('2521', '包皮恶性肿瘤', '473', 'C60.051', 'BPEXZL', '');
INSERT INTO `05diseases` VALUES ('2522', '阴茎头恶性肿瘤', '473', 'C60.101', 'YJTEXZL', '');
INSERT INTO `05diseases` VALUES ('2523', '阴茎体(海绵体)恶性肿瘤', '473', 'C60.201', 'YJTHMTEXZL', '');
INSERT INTO `05diseases` VALUES ('2524', '阴茎交搭跨越的恶性肿瘤', '473', 'C60.851', 'YJJDKYDEXZL', '');
INSERT INTO `05diseases` VALUES ('2525', '阴茎皮肤恶性肿瘤 NOS', '473', 'C60.901', 'YJPFEXZL', '');
INSERT INTO `05diseases` VALUES ('2526', '前列腺恶性肿瘤', '473', 'C61.X01', 'QLXEXZL', '');
INSERT INTO `05diseases` VALUES ('2527', '隐睾恶性肿瘤', '473', 'C62.001', 'YGEXZL', '');
INSERT INTO `05diseases` VALUES ('2528', '睾丸异位恶性肿瘤', '473', 'C62.051', 'GWYWEXZL', '');
INSERT INTO `05diseases` VALUES ('2529', '睾丸未降恶性肿瘤', '473', 'C62.052', 'GWWJEXZL', '');
INSERT INTO `05diseases` VALUES ('2530', '睾丸下降的恶性肿瘤', '473', 'C62.151', 'GWXJDEXZL', '');
INSERT INTO `05diseases` VALUES ('2531', '阴囊的睾丸恶性肿瘤', '473', 'C62.152', 'YNDGWEXZL', '');
INSERT INTO `05diseases` VALUES ('2532', '睾丸畸胎瘤 (M90800/3)', '230', 'C62.901', 'GWJTL', '');
INSERT INTO `05diseases` VALUES ('2533', '男性绒毛膜上皮癌 (M91000/3)', '2', 'C62.951', 'NXRMMSPA', '');
INSERT INTO `05diseases` VALUES ('2534', '睾丸精原细胞瘤', '230', 'C62.952', 'GWJYXBL', '');
INSERT INTO `05diseases` VALUES ('2535', '睾丸恶性胚胎瘤', '230', 'C62.953', 'GWEXPTL', '');
INSERT INTO `05diseases` VALUES ('2536', '睾丸恶性肿瘤 NOS', '473', 'C62.954', 'GWEXZL', '');
INSERT INTO `05diseases` VALUES ('2537', '副睾恶性肿瘤', '473', 'C63.001', 'FGEXZL', '');
INSERT INTO `05diseases` VALUES ('2538', '精索恶性肿瘤', '473', 'C63.151', 'JSEXZL', '');
INSERT INTO `05diseases` VALUES ('2539', '阴囊恶性肿瘤', '473', 'C63.201', 'YNEXZL', '');
INSERT INTO `05diseases` VALUES ('2540', '阴囊横纹肌肉瘤 (M89000/3)', '294', 'C63.251', 'YNHWJRL', '');
INSERT INTO `05diseases` VALUES ('2541', '阴囊佩吉特氏病 (M85400/3)', '445', 'C63.252', 'YNPJTSB', '');
INSERT INTO `05diseases` VALUES ('2542', '阴囊皮肤恶性肿瘤', '473', 'C63.253', 'YNPFEXZL', '');
INSERT INTO `05diseases` VALUES ('2543', '精囊恶性肿瘤', '473', 'C63.751', 'JNEXZL', '');
INSERT INTO `05diseases` VALUES ('2544', '鞘膜恶性肿瘤', '473', 'C63.752', 'QMEXZL', '');
INSERT INTO `05diseases` VALUES ('2545', '男性生殖器官交搭跨越的恶性肿瘤', '473', 'C63.851', 'NXSZQGJDKYDEXZL', '');
INSERT INTO `05diseases` VALUES ('2546', '男性泌尿生殖道恶性肿瘤 NOS', '473', 'C63.951', 'NXMNSZDEXZL', '');
INSERT INTO `05diseases` VALUES ('2547', '肾恶性肿瘤', '473', 'C64.X01', 'SEXZL', '');
INSERT INTO `05diseases` VALUES ('2548', '肾母细胞瘤 (M89600/3)', '377', 'C64.X02', 'SMXBL', '');
INSERT INTO `05diseases` VALUES ('2549', '肾细胞癌 (M83120/3)', '2', 'C64.X03', 'SXBA', '');
INSERT INTO `05diseases` VALUES ('2550', '维尔姆斯瘤 (M89600/3)', '261', 'C64.X51', 'WEMSL', '');
INSERT INTO `05diseases` VALUES ('2551', '肾盂恶性肿瘤', '473', 'C65.X01', 'SYEXZL', '');
INSERT INTO `05diseases` VALUES ('2552', '肾盂输尿管连结处恶性肿瘤', '473', 'C65.X51', 'SYSNGLJCEXZL', '');
INSERT INTO `05diseases` VALUES ('2553', '肾盏恶性肿瘤', '473', 'C65.X52', 'SZEXZL', '');
INSERT INTO `05diseases` VALUES ('2554', '肾门恶性肿瘤', '473', 'C65.X53', 'SMEXZL', '');
INSERT INTO `05diseases` VALUES ('2555', '输尿管恶性肿瘤', '473', 'C66.X01', 'SNGEXZL', '');
INSERT INTO `05diseases` VALUES ('2556', '膀胱三角区恶性肿瘤', '473', 'C67.001', 'BGSJQEXZL', '');
INSERT INTO `05diseases` VALUES ('2557', '膀胱顶恶性肿瘤', '473', 'C67.151', 'BGDEXZL', '');
INSERT INTO `05diseases` VALUES ('2558', '膀胱侧壁恶性肿瘤', '473', 'C67.251', 'BGCBEXZL', '');
INSERT INTO `05diseases` VALUES ('2559', '膀胱前壁恶性肿瘤', '473', 'C67.351', 'BGQBEXZL', '');
INSERT INTO `05diseases` VALUES ('2560', '膀胱后壁恶性肿瘤', '473', 'C67.451', 'BGHBEXZL', '');
INSERT INTO `05diseases` VALUES ('2561', '膀胱颈恶性肿瘤', '473', 'C67.501', 'BGGEXZL', '');
INSERT INTO `05diseases` VALUES ('2562', '尿道内口恶性肿瘤', '473', 'C67.551', 'NDNKEXZL', '');
INSERT INTO `05diseases` VALUES ('2563', '输尿管口恶性肿瘤', '473', 'C67.651', 'SNGKEXZL', '');
INSERT INTO `05diseases` VALUES ('2564', '脐尿管恶性肿瘤', '473', 'C67.701', 'QNGEXZL', '');
INSERT INTO `05diseases` VALUES ('2565', '膀胱交搭跨越的恶性肿瘤', '473', 'C67.851', 'BGJDKYDEXZL', '');
INSERT INTO `05diseases` VALUES ('2566', '膀胱恶性肿瘤 NOS', '473', 'C67.901', 'BGEXZL', '');
INSERT INTO `05diseases` VALUES ('2567', '尿道恶性肿瘤', '473', 'C68.001', 'NDEXZL', '');
INSERT INTO `05diseases` VALUES ('2568', '尿道旁腺恶性肿瘤', '473', 'C68.151', 'NDPXEXZL', '');
INSERT INTO `05diseases` VALUES ('2569', '斯基恩腺恶性肿瘤', '473', 'C68.152', 'SJEXEXZL', '');
INSERT INTO `05diseases` VALUES ('2570', '肾及输尿管恶性肿瘤', '473', 'C68.801', 'SJSNGEXZL', '');
INSERT INTO `05diseases` VALUES ('2571', '泌尿器官交搭跨越的恶性肿瘤', '473', 'C68.851', 'MNQGJDKYDEXZL', '');
INSERT INTO `05diseases` VALUES ('2572', '泌尿系统(器官)恶性肿瘤 NOS', '473', 'C68.951', 'MNXTQGEXZL', '');
INSERT INTO `05diseases` VALUES ('2573', '结膜恶性肿瘤', '473', 'C69.001', 'JMEXZL', '');
INSERT INTO `05diseases` VALUES ('2574', '角膜恶性肿瘤', '473', 'C69.101', 'JMEXZL', '');
INSERT INTO `05diseases` VALUES ('2575', '视网膜恶性肿瘤', '473', 'C69.201', 'SWMEXZL', '');
INSERT INTO `05diseases` VALUES ('2576', '视网膜母细胞瘤 (M95100/3)', '377', 'C69.202', 'SWMMXBL', '');
INSERT INTO `05diseases` VALUES ('2577', '脉络膜恶性肿瘤', '473', 'C69.301', 'MLMEXZL', '');
INSERT INTO `05diseases` VALUES ('2578', '睫状体恶性肿瘤', '473', 'C69.401', 'JZTEXZL', '');
INSERT INTO `05diseases` VALUES ('2579', '葡萄膜恶性肿瘤', '473', 'C69.402', 'PTMEXZL', '');
INSERT INTO `05diseases` VALUES ('2580', '眼内恶性肿瘤', '473', 'C69.403', 'YNEXZL', '');
INSERT INTO `05diseases` VALUES ('2581', '眼球恶性肿瘤', '473', 'C69.451', 'YQEXZL', '');
INSERT INTO `05diseases` VALUES ('2582', '泪囊恶性肿瘤', '473', 'C69.501', 'LNEXZL', '');
INSERT INTO `05diseases` VALUES ('2583', '泪腺恶性肿瘤', '473', 'C69.502', 'LXEXZL', '');
INSERT INTO `05diseases` VALUES ('2584', '鼻泪管恶性肿瘤', '473', 'C69.551', 'BLGEXZL', '');
INSERT INTO `05diseases` VALUES ('2585', '眶内恶性肿瘤', '473', 'C69.601', 'KNEXZL', '');
INSERT INTO `05diseases` VALUES ('2586', '眶周神经恶性肿瘤', '473', 'C69.651', 'KZSJEXZL', '');
INSERT INTO `05diseases` VALUES ('2587', '眼球后恶性肿瘤', '473', 'C69.652', 'YQHEXZL', '');
INSERT INTO `05diseases` VALUES ('2588', '眼球外肌恶性肿瘤', '473', 'C69.653', 'YQWJEXZL', '');
INSERT INTO `05diseases` VALUES ('2589', '眼和附器交搭跨越的恶性肿瘤', '473', 'C69.851', 'YHFQJDKYDEXZL', '');
INSERT INTO `05diseases` VALUES ('2590', '眼恶性肿瘤 NOS', '473', 'C69.901', 'YEXZL', '');
INSERT INTO `05diseases` VALUES ('2591', '脑膜恶性肿瘤', '473', 'C70.001', 'NMEXZL', '');
INSERT INTO `05diseases` VALUES ('2592', '颅内脑膜肉瘤', '232', 'C70.051', 'LNNMRL', '');
INSERT INTO `05diseases` VALUES ('2593', '脑干脑膜肉瘤', '232', 'C70.052', 'NGNMRL', '');
INSERT INTO `05diseases` VALUES ('2594', '脑膜肉瘤', '232', 'C70.053', 'NMRL', '');
INSERT INTO `05diseases` VALUES ('2595', '脊膜恶性肿瘤', '473', 'C70.101', 'JMEXZL', '');
INSERT INTO `05diseases` VALUES ('2596', '脊髓内膜恶性肿瘤', '473', 'C70.151', 'JSNMEXZL', '');
INSERT INTO `05diseases` VALUES ('2597', '硬膜下恶性肿瘤', '473', 'C70.901', 'YMXEXZL', '');
INSERT INTO `05diseases` VALUES ('2598', '脑脊膜恶性肿瘤 NOS', '473', 'C70.951', 'NJMEXZL', '');
INSERT INTO `05diseases` VALUES ('2599', '大脑恶性肿瘤', '473', 'C71.001', 'DNEXZL', '');
INSERT INTO `05diseases` VALUES ('2600', '大脑神经胶质瘤病 (M93810/3)', '313', 'C71.002', 'DNSJJZLB', '');
INSERT INTO `05diseases` VALUES ('2601', '胶质恶性细胞瘤 (M93810/1)', '377', 'C71.003', 'JZEXXBL', '');
INSERT INTO `05diseases` VALUES ('2602', '胼胝体恶性肿瘤', '473', 'C71.004', 'PZTEXZL', '');
INSERT INTO `05diseases` VALUES ('2603', '丘脑恶性肿瘤', '473', 'C71.005', 'QNEXZL', '');
INSERT INTO `05diseases` VALUES ('2604', '幕上的恶性肿瘤', '473', 'C71.051', 'MSDEXZL', '');
INSERT INTO `05diseases` VALUES ('2605', '赖尔岛恶性肿瘤[脑岛]', '473', 'C71.052', 'LEDEXZLND', '');
INSERT INTO `05diseases` VALUES ('2606', '大脑恶性胶质细胞瘤 (M93800/3)', '234', 'C71.053', 'DNEXJZXBL', '');
INSERT INTO `05diseases` VALUES ('2607', '大脑恶性胶质细胞瘤病 (M93810/3)', '234', 'C71.054', 'DNEXJZXBLB', '');
INSERT INTO `05diseases` VALUES ('2608', '大脑星形细胞瘤 (M94000/3)', '234', 'C71.055', 'DNXXXBL', '');
INSERT INTO `05diseases` VALUES ('2609', '额叶恶性肿瘤', '473', 'C71.101', 'EYEXZL', '');
INSERT INTO `05diseases` VALUES ('2610', '颞叶恶性肿瘤', '473', 'C71.201', 'NYEXZL', '');
INSERT INTO `05diseases` VALUES ('2611', '海马回恶性肿瘤', '473', 'C71.251', 'HMHEXZL', '');
INSERT INTO `05diseases` VALUES ('2612', '顶叶恶性肿瘤', '473', 'C71.301', 'DYEXZL', '');
INSERT INTO `05diseases` VALUES ('2613', '枕叶恶性肿瘤', '473', 'C71.401', 'ZYEXZL', '');
INSERT INTO `05diseases` VALUES ('2614', '恶性脉络丛乳头状瘤 (M93900/3)', '86', 'C71.501', 'EXMLCRTZL', '');
INSERT INTO `05diseases` VALUES ('2615', '脉络丛恶性肿瘤', '473', 'C71.502', 'MLCEXZL', '');
INSERT INTO `05diseases` VALUES ('2616', '脑室恶性肿瘤', '473', 'C71.503', 'NSEXZL', '');
INSERT INTO `05diseases` VALUES ('2617', '小脑恶性肿瘤', '473', 'C71.601', 'XNEXZL', '');
INSERT INTO `05diseases` VALUES ('2618', '脑干恶性肿瘤', '473', 'C71.701', 'NGEXZL', '');
INSERT INTO `05diseases` VALUES ('2619', '脑桥恶性肿瘤', '473', 'C71.702', 'NQEXZL', '');
INSERT INTO `05diseases` VALUES ('2620', '第四脑室恶性肿瘤', '473', 'C71.751', 'DSNSEXZL', '');
INSERT INTO `05diseases` VALUES ('2621', '脑干幕下恶性肿瘤', '473', 'C71.752', 'NGMXEXZL', '');
INSERT INTO `05diseases` VALUES ('2622', '顶枕叶恶性肿瘤', '473', 'C71.801', 'DZYEXZL', '');
INSERT INTO `05diseases` VALUES ('2623', '额顶叶恶性肿瘤', '473', 'C71.802', 'EDYEXZL', '');
INSERT INTO `05diseases` VALUES ('2624', '额颞顶叶恶性肿瘤', '473', 'C71.803', 'ENDYEXZL', '');
INSERT INTO `05diseases` VALUES ('2625', '脑交搭跨越的恶性肿瘤', '473', 'C71.851', 'NJDKYDEXZL', '');
INSERT INTO `05diseases` VALUES ('2626', '鞍上区恶性肿瘤', '473', 'C71.901', 'ASQEXZL', '');
INSERT INTO `05diseases` VALUES ('2627', '颅内恶性肿瘤', '473', 'C71.902', 'LNEXZL', '');
INSERT INTO `05diseases` VALUES ('2628', '脑恶性肿瘤', '473', 'C71.903', 'NEXZL', '');
INSERT INTO `05diseases` VALUES ('2629', '脊髓恶性肿瘤', '473', 'C72.001', 'JSEXZL', '');
INSERT INTO `05diseases` VALUES ('2630', '脊髓圆锥恶性肿瘤', '473', 'C72.002', 'JSYZEXZL', '');
INSERT INTO `05diseases` VALUES ('2631', '马尾恶性肿瘤', '473', 'C72.151', 'MWEXZL', '');
INSERT INTO `05diseases` VALUES ('2632', '嗅神经恶性肿瘤', '473', 'C72.201', 'XSJEXZL', '');
INSERT INTO `05diseases` VALUES ('2633', '视神经恶性肿瘤', '473', 'C72.301', 'SSJEXZL', '');
INSERT INTO `05diseases` VALUES ('2634', '听神经恶性肿瘤', '473', 'C72.451', 'TSJEXZL', '');
INSERT INTO `05diseases` VALUES ('2635', '颅神经恶性肿瘤', '473', 'C72.501', 'LSJEXZL', '');
INSERT INTO `05diseases` VALUES ('2636', '脑和中枢神经系统其他部位交搭跨越的恶性肿瘤', '473', 'C72.851', 'NHZSSJXTQTBWJDKYDEXZ', '');
INSERT INTO `05diseases` VALUES ('2637', '硬脊膜外恶性肿瘤', '473', 'C72.901', 'YJMWEXZL', '');
INSERT INTO `05diseases` VALUES ('2638', '硬膜外恶性肿瘤', '473', 'C72.902', 'YMWEXZL', '');
INSERT INTO `05diseases` VALUES ('2639', '中枢神经系统未特指的恶性肿瘤', '473', 'C72.951', 'ZSSJXTWTZDEXZL', '');
INSERT INTO `05diseases` VALUES ('2640', '复发性甲状腺癌', '2', 'C73.X01', 'FFXJZXA', '');
INSERT INTO `05diseases` VALUES ('2641', '甲状腺恶性肿瘤', '473', 'C73.X02', 'JZXEXZL', '');
INSERT INTO `05diseases` VALUES ('2642', '甲状腺良性肿瘤癌变', '473', 'C73.X03', 'JZXLXZLAB', '');
INSERT INTO `05diseases` VALUES ('2643', '滤泡变异性乳头状腺癌 (M83400/3)', '2', 'C73.X04', 'LPBYXRTZXA', '');
INSERT INTO `05diseases` VALUES ('2644', '滤泡性腺癌 (M83300/3)', '2', 'C73.X05', 'LPXXA', '');
INSERT INTO `05diseases` VALUES ('2645', '肾上腺皮质恶性肿瘤 (M83700/3)', '473', 'C74.001', 'SSXPZEXZL', '');
INSERT INTO `05diseases` VALUES ('2646', '恶性嗜铬细胞瘤 (M87000/3)', '377', 'C74.101', 'EXSGXBL', '');
INSERT INTO `05diseases` VALUES ('2647', '肾上腺髓质恶性肿瘤', '473', 'C74.151', 'SSXSZEXZL', '');
INSERT INTO `05diseases` VALUES ('2648', '肾上腺恶性肿瘤 NOS', '473', 'C74.901', 'SSXEXZL', '');
INSERT INTO `05diseases` VALUES ('2649', '甲状旁腺恶性肿瘤', '473', 'C75.001', 'JZPXEXZL', '');
INSERT INTO `05diseases` VALUES ('2650', '垂体恶性肿瘤', '473', 'C75.101', 'CTEXZL', '');
INSERT INTO `05diseases` VALUES ('2651', '蝶鞍区恶性肿瘤', '473', 'C75.102', 'DAQEXZL', '');
INSERT INTO `05diseases` VALUES ('2652', '拉特克囊恶性肿瘤', '473', 'C75.151', 'LTKNEXZL', '');
INSERT INTO `05diseases` VALUES ('2653', '颅咽管恶性肿瘤', '473', 'C75.251', 'LYGEXZL', '');
INSERT INTO `05diseases` VALUES ('2654', '松果体恶性肿瘤', '473', 'C75.301', 'SGTEXZL', '');
INSERT INTO `05diseases` VALUES ('2655', '颈动脉体恶性肿瘤', '473', 'C75.451', 'GDMTEXZL', '');
INSERT INTO `05diseases` VALUES ('2656', '祖克坎德耳器恶性肿瘤', '473', 'C75.551', 'ZKKDEQEXZL', '');
INSERT INTO `05diseases` VALUES ('2657', '主动脉体恶性肿瘤', '473', 'C75.552', 'ZDMTEXZL', '');
INSERT INTO `05diseases` VALUES ('2658', '多个腺体恶性肿瘤', '473', 'C75.851', 'DGXTEXZL', '');
INSERT INTO `05diseases` VALUES ('2659', '内分泌腺恶性肿瘤 NOS', '473', 'C75.951', 'NFMXEXZL', '');
INSERT INTO `05diseases` VALUES ('2660', '鼻恶性肿瘤', '473', 'C76.001', 'BEXZL', '');
INSERT INTO `05diseases` VALUES ('2661', '颔下恶性肿瘤', '473', 'C76.003', 'HXEXZL', '');
INSERT INTO `05diseases` VALUES ('2662', '颊部恶性肿瘤', '473', 'C76.004', 'JBEXZL', '');
INSERT INTO `05diseases` VALUES ('2663', '头、面和颈恶性肿瘤', '473', 'C76.005', 'TMHGEXZL', '');
INSERT INTO `05diseases` VALUES ('2664', '头部恶性肿瘤', '473', 'C76.051', 'TBEXZL', '');
INSERT INTO `05diseases` VALUES ('2665', '面部恶性肿瘤', '473', 'C76.052', 'MBEXZL', '');
INSERT INTO `05diseases` VALUES ('2666', '颈部恶性肿瘤', '473', 'C76.053', 'GBEXZL', '');
INSERT INTO `05diseases` VALUES ('2667', '胸壁恶性肿瘤', '473', 'C76.101', 'XBEXZL', '');
INSERT INTO `05diseases` VALUES ('2668', '胸恶性肿瘤', '473', 'C76.102', 'XEXZL', '');
INSERT INTO `05diseases` VALUES ('2669', '胸腔恶性肿瘤', '473', 'C76.103', 'XQEXZL', '');
INSERT INTO `05diseases` VALUES ('2670', '腋窝恶性肿瘤', '473', 'C76.104', 'YWEXZL', '');
INSERT INTO `05diseases` VALUES ('2671', '腹腔恶性肿瘤', '473', 'C76.201', 'FQEXZL', '');
INSERT INTO `05diseases` VALUES ('2672', '髂窝恶性肿瘤', '473', 'C76.202', 'QWEXZL', '');
INSERT INTO `05diseases` VALUES ('2673', '骶前恶性肿瘤', '473', 'C76.301', 'DQEXZL', '');
INSERT INTO `05diseases` VALUES ('2674', '骨盆恶性肿瘤', '473', 'C76.302', 'GPEXZL', '');
INSERT INTO `05diseases` VALUES ('2675', '骶尾部恶性肿瘤', '473', 'C76.303', 'DWBEXZL', '');
INSERT INTO `05diseases` VALUES ('2676', '盆腔恶性肿瘤', '473', 'C76.304', 'PQEXZL', '');
INSERT INTO `05diseases` VALUES ('2677', '腹股沟恶性肿瘤', '473', 'C76.305', 'FGGEXZL', '');
INSERT INTO `05diseases` VALUES ('2678', '臀部恶性肿瘤', '473', 'C76.306', 'TBEXZL', '');
INSERT INTO `05diseases` VALUES ('2679', '直肠阴道隔恶性肿瘤', '473', 'C76.307', 'ZCYDGEXZL', '');
INSERT INTO `05diseases` VALUES ('2680', '腹股沟血管恶性肿瘤', '473', 'C76.351', 'FGGXGEXZL', '');
INSERT INTO `05diseases` VALUES ('2681', '直肠阴道恶性肿瘤', '473', 'C76.352', 'ZCYDZEXZL', '');
INSERT INTO `05diseases` VALUES ('2682', '直肠膀胱的(隔)恶性肿瘤', '473', 'C76.353', 'ZCBGDGEXZL', '');
INSERT INTO `05diseases` VALUES ('2683', '上肢恶性肿瘤', '473', 'C76.401', 'SZEXZL', '');
INSERT INTO `05diseases` VALUES ('2684', '上肢横纹肌肉瘤 (M89000/3)', '294', 'C76.451', 'SZHWJRL', '');
INSERT INTO `05diseases` VALUES ('2685', '下肢恶性肿瘤', '473', 'C76.501', 'XZEXZL', '');
INSERT INTO `05diseases` VALUES ('2686', '小腿恶性肿瘤', '473', 'C76.502', 'XTEXZL', '');
INSERT INTO `05diseases` VALUES ('2687', '大腿肉瘤(股脂肪)', '294', 'C76.551', 'DTRLGZF', '');
INSERT INTO `05diseases` VALUES ('2688', '下肢横纹肌肉瘤 (M89000/3)', '294', 'C76.552', 'XZHWJRL', '');
INSERT INTO `05diseases` VALUES ('2689', '臀部深部脂肪肉瘤 (M88500/3)', '294', 'C76.553', 'TBSBZFRL', '');
INSERT INTO `05diseases` VALUES ('2690', '躯干横纹肌肉瘤 (M89000/3)', '294', 'C76.751', 'QGHWJRL', '');
INSERT INTO `05diseases` VALUES ('2691', '四肢深部恶性肿瘤', '473', 'C76.851', 'SZSBEXZL', '');
INSERT INTO `05diseases` VALUES ('2692', '不明部位的交搭跨越的恶性肿瘤', '473', 'C76.852', 'BMBWDJDKYDEXZL', '');
INSERT INTO `05diseases` VALUES ('2693', '颌下淋巴结继发恶性肿瘤', '473', 'C77.001', 'HXLBJJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2694', '颈部淋巴结继发恶性肿瘤', '473', 'C77.002', 'GBLBJJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2695', '腮腺淋巴结继发恶性肿瘤', '473', 'C77.003', 'SXLBJJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2696', '锁骨上淋巴结继发恶性肿瘤', '473', 'C77.004', 'SGSLBJJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2697', '头部淋巴结继发性恶性肿瘤', '473', 'C77.051', 'TBLBJJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2698', '面部淋巴结继发性恶性肿瘤', '473', 'C77.052', 'MBLBJJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2699', '魏尔啸腺继发性恶性肿瘤', '473', 'C77.053', 'WEXXJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2700', '肺门淋巴结继发恶性肿瘤', '473', 'C77.101', 'FMLBJJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2701', '胸内淋巴结继发性恶性肿瘤', '473', 'C77.102', 'XNLBJJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2702', '纵隔淋巴结继发恶性肿瘤', '473', 'C77.103', 'ZGLBJJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2703', '贲门淋巴结继发恶性肿瘤', '473', 'C77.201', 'BMLBJJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2704', '肠系膜淋巴结继发恶性肿瘤', '473', 'C77.202', 'CXMLBJJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2705', '腹腔淋巴结继发恶性肿瘤', '473', 'C77.203', 'FQLBJJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2706', '肝门淋巴结继发恶性肿瘤', '473', 'C77.204', 'GMLBJJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2707', '脾门淋巴结继发性恶性肿瘤', '473', 'C77.205', 'PMLBJJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2708', '腋窝淋巴结继发恶性肿瘤', '473', 'C77.301', 'YWLBJJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2709', '胸淋巴结继发性恶性肿瘤', '473', 'C77.351', 'XLBJJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2710', '上肢淋巴结继发性恶性肿瘤', '473', 'C77.352', 'SZLBJJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2711', '腹股沟淋巴结继发恶性肿瘤', '473', 'C77.401', 'FGGLBJJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2712', '克洛凯腺淋巴继发性恶性肿瘤', '473', 'C77.451', 'KLKXLBJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2713', '罗森米勒腺淋巴继发性恶性肿瘤', '473', 'C77.452', 'LSMLXLBJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2714', '下肢淋巴结继发性恶性肿瘤', '473', 'C77.453', 'XZLBJJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2715', '盆腔淋巴结继发性恶性肿瘤', '473', 'C77.501', 'PQLBJJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2716', '髂淋巴结继发恶性肿瘤', '473', 'C77.502', 'QLBJJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2717', '颌下、锁骨上淋巴结继发恶性肿瘤', '473', 'C77.801', 'HXSGSLBJJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2718', '多部位淋巴结继发性恶性肿瘤', '473', 'C77.851', 'DBWLBJJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2719', '淋巴结继发恶性肿瘤 NOS', '473', 'C77.901', 'LBJJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2720', '肺继发恶性肿瘤', '473', 'C78.001', 'FJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2721', '支气管继发恶性肿瘤', '473', 'C78.002', 'ZQGJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2722', '纵隔继发恶性肿瘤', '473', 'C78.101', 'ZGJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2723', '胸膜继发恶性肿瘤', '473', 'C78.201', 'XMJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2724', '其他呼吸系统的继发性肿瘤', '473', 'C78.301', 'QTHXXTDJFXZL', '');
INSERT INTO `05diseases` VALUES ('2725', '气管继发恶性肿瘤', '473', 'C78.302', 'QGJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2726', '气管支气管继发性恶性肿瘤', '473', 'C78.303', 'QGZQGJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2727', '中耳继发性肿瘤', '473', 'C78.304', 'ZEJFXZL', '');
INSERT INTO `05diseases` VALUES ('2728', '上颌窦[海默尔]继发性恶性肿瘤', '473', 'C78.351', 'SHDHMEJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2729', '呼吸系统其他器官继发性恶性肿瘤', '473', 'C78.352', 'HXXTQTQGJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2730', '十二指肠继发恶性肿瘤', '473', 'C78.401', 'SEZCJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2731', '小肠继发恶性肿瘤', '473', 'C78.402', 'XCJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2732', '麦克尔憩息继发性恶性肿瘤', '473', 'C78.451', 'MKEQXJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2733', '大、直肠继发性肿瘤', '473', 'C78.501', 'DZCJFXZL', '');
INSERT INTO `05diseases` VALUES ('2734', '结肠继发恶性肿瘤', '473', 'C78.502', 'JCJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2735', '盲肠继发恶性肿瘤', '473', 'C78.503', 'MCJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2736', '乙状结肠继发恶性肿瘤', '473', 'C78.504', 'YZJCJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2737', '直肠继发恶性肿瘤', '473', 'C78.505', 'ZCJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2738', '莫尔加尼隐窝继发性恶性肿瘤', '473', 'C78.551', 'MEJNYWJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2739', '肛门继发性恶性肿瘤', '473', 'C78.552', 'GMJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2740', '大肠继发性恶性肿瘤', '473', 'C78.553', 'DCJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2741', '肠系膜继发恶性肿瘤', '473', 'C78.601', 'CXMJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2742', '大网膜继发恶性肿瘤', '473', 'C78.602', 'DWMJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2743', '腹膜后腔继发恶性肿瘤', '473', 'C78.603', 'FMHQJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2744', '腹膜继发恶性肿瘤', '473', 'C78.604', 'FMJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2745', '腹膜假粘液瘤 (M84800/6)', '261', 'C78.605', 'FMJNYL', '');
INSERT INTO `05diseases` VALUES ('2746', '道格拉斯陷凹或襄继发性恶性肿瘤', '473', 'C78.651', 'DGLSXAHXJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2747', '腹膜腔继发性恶性肿瘤', '473', 'C78.652', 'FMQJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2748', '腹内继发恶性肿瘤', '473', 'C78.653', 'FNJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2749', '恶性腹水', '264', 'C78.661', 'EXFS', '');
INSERT INTO `05diseases` VALUES ('2750', '腹盆腔继发恶性肿瘤', '473', 'C78.662', 'FPQJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2751', '肝继发恶性肿瘤', '473', 'C78.701', 'GJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2752', '胆管继发性恶性肿瘤', '473', 'C78.801', 'DGJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2753', '胆囊继发恶性肿瘤', '473', 'C78.802', 'DNJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2754', '脾继发恶性肿瘤', '473', 'C78.803', 'PJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2755', '其他和未特指消化器官的继发性肿瘤', '473', 'C78.804', 'QTHWTZXHQGDJFXZL', '');
INSERT INTO `05diseases` VALUES ('2756', '食管继发恶性肿瘤', '473', 'C78.805', 'SGJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2757', '胃肠道继发恶性肿瘤', '473', 'C78.806', 'WCDJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2758', '胃继发性恶性肿瘤', '473', 'C78.807', 'WJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2759', '胰腺继发恶性肿瘤', '473', 'C78.809', 'YXJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2760', '肝、腹腔继发性恶性肿瘤', '473', 'C78.851', 'GFQJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2761', '朗格汉斯胰岛继发性恶性肿瘤', '473', 'C78.852', 'LGHSYDJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2762', '法特壶腹继发性恶性肿瘤', '473', 'C78.853', 'FTHFJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2763', '圣托理尼管继发性恶性肿瘤', '473', 'C78.854', 'STLNGJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2764', '维尔松管继发性恶性肿瘤', '473', 'C78.855', 'WESGJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2765', '肝(内、外)管继发性恶性肿瘤', '473', 'C78.856', 'GNWGJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2766', '胆总管继发性恶性肿瘤', '473', 'C78.857', 'DZGJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2767', '肾继发恶性肿瘤', '473', 'C79.001', 'SJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2768', '肾盂继发性恶性肿瘤', '473', 'C79.051', 'SYJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2769', '膀胱继发恶性肿瘤', '473', 'C79.101', 'BGJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2770', '泌尿系统继发恶性肿瘤', '473', 'C79.102', 'MNXTJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2771', '尿道继发恶性肿瘤', '473', 'C79.103', 'NDJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2772', '输尿管继发恶性肿瘤', '473', 'C79.104', 'SNGJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2773', '斯基恩腺继发性恶性肿瘤', '473', 'C79.151', 'SJEXJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2774', '腹壁继发性恶性肿瘤', '473', 'C79.201', 'FBJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2775', '睑板继发恶性肿瘤', '473', 'C79.202', 'JBJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2776', '皮肤继发恶性肿瘤', '473', 'C79.203', 'PFJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2777', '迈博腺[睑板腺]继发性恶性肿瘤', '473', 'C79.251', 'MBXJBXJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2778', '脊髓继发恶性肿瘤', '473', 'C79.301', 'JSJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2779', '脑继发恶性肿瘤', '473', 'C79.302', 'NJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2780', '脑(脊)膜继发恶性肿瘤', '473', 'C79.303', 'NJMJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2781', '小脑继发性恶性肿瘤', '473', 'C79.304', 'XNJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2782', '赖尔岛[脑岛]继发性恶性肿瘤', '473', 'C79.351', 'LEDNDJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2783', '海马回继发性恶性肿瘤', '473', 'C79.352', 'HMHJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2784', '额叶继发性恶性癌', '2', 'C79.353', 'EYJFXEXA', '');
INSERT INTO `05diseases` VALUES ('2785', '眶内继发性肿瘤', '473', 'C79.401', 'KNJFXZL', '');
INSERT INTO `05diseases` VALUES ('2786', '脉络膜继发恶性肿瘤', '473', 'C79.402', 'MLMJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2787', '眼继发性恶性肿瘤', '473', 'C79.403', 'YJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2788', '中枢神经系统继发恶性肿瘤', '473', 'C79.404', 'ZSSJXTJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2789', '喉返神经继发性恶性肿瘤', '473', 'C79.451', 'HFSJJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2790', '骨继发恶性肿瘤', '473', 'C79.501', 'GJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2791', '骨髓继发恶性肿瘤', '473', 'C79.502', 'GSJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2792', '脊柱继发性恶性肿瘤', '473', 'C79.503', 'JZJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2793', '上颌骨非齿源性恶性肿瘤', '473', 'C79.504', 'SHGFCYXEXZL', '');
INSERT INTO `05diseases` VALUES ('2794', '上颌骨继发恶性肿瘤', '473', 'C79.505', 'SHGJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2795', '下颌骨非齿源性恶性肿瘤', '473', 'C79.506', 'XHGFCYXEXZL', '');
INSERT INTO `05diseases` VALUES ('2796', '下颌骨继发恶性肿瘤', '473', 'C79.507', 'XHGJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2797', '椎体继发恶性肿瘤', '473', 'C79.508', 'ZTJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2798', '颈椎继发性恶性肿瘤', '473', 'C79.551', 'GZJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2799', '肋骨继发性恶性肿瘤', '473', 'C79.552', 'LGJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2800', '颅骨继发性恶性肿瘤', '473', 'C79.553', 'LGJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2801', '胸椎继发性恶性肿瘤', '473', 'C79.554', 'XZJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2802', '克鲁肯伯格氏瘤 (M84900/6)', '261', 'C79.601', 'KLKBGSL', '');
INSERT INTO `05diseases` VALUES ('2803', '卵巢继发恶性肿瘤', '473', 'C79.602', 'LCJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2804', '肾上腺继发恶性肿瘤', '473', 'C79.701', 'SSXJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2805', '骶尾区继发性恶性肿瘤', '473', 'C79.801', 'DWQJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2806', '腹腔继发性恶性肿瘤', '473', 'C79.802', 'FQJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2807', '腹主动脉继发恶性肿瘤', '473', 'C79.803', 'FZDMJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2808', '睾丸继发恶性肿瘤', '473', 'C79.804', 'GWJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2809', '膈继发恶性肿瘤', '473', 'C79.805', 'GJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2810', '颌、颏继发性恶性肿瘤', '473', 'C79.806', 'HKJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2811', '会阴继发性恶性肿瘤', '473', 'C79.807', 'HYJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2812', '甲状腺继发性恶性肿瘤', '473', 'C79.808', 'JZXJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2813', '精囊继发性恶性肿瘤', '473', 'C79.809', 'JNJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2814', '颈部继发性恶性肿瘤', '473', 'C79.810', 'GBJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2815', '口腔继发性恶性肿瘤', '473', 'C79.811', 'KQJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2816', '盆腔继发恶性肿瘤', '473', 'C79.812', 'PQJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2817', '髂血管继发恶性肿瘤', '473', 'C79.813', 'QXGJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2818', '躯干继发性恶性肿瘤', '473', 'C79.814', 'QGJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2819', '乳腺继发性恶性肿瘤', '473', 'C79.815', 'RXJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2820', '腮腺继发性恶性肿瘤', '473', 'C79.816', 'SXJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2821', '舌继发恶性肿瘤', '473', 'C79.817', 'SJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2822', '输卵管继发恶性肿瘤', '473', 'C79.818', 'SLGJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2823', '头部继发性恶性肿瘤', '473', 'C79.819', 'TBJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2824', '外阴继发恶性肿瘤', '473', 'C79.820', 'WYJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2825', '心包继发恶性肿瘤', '473', 'C79.821', 'XBJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2826', '心脏继发恶性肿瘤', '473', 'C79.822', 'XZJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2827', '胸壁继发性恶性肿瘤', '473', 'C79.823', 'XBJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2828', '胸腔继发性恶性肿瘤', '473', 'C79.824', 'XQJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2829', '咽继发恶性肿瘤', '473', 'C79.825', 'YJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2830', '腋下继发性恶性肿瘤', '473', 'C79.826', 'YXJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2831', '阴道继发恶性肿瘤', '473', 'C79.827', 'YDJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2832', '阴囊内肿瘤种植', '473', 'C79.828', 'YNNZLZZ', '');
INSERT INTO `05diseases` VALUES ('2833', '子宫颈继发恶性肿瘤', '473', 'C79.829', 'ZGGJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2834', '子宫继发恶性肿瘤', '473', 'C79.830', 'ZGJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2835', '子宫旁继发恶性肿瘤', '473', 'C79.831', 'ZGPJFEXZL', '');
INSERT INTO `05diseases` VALUES ('2836', '结缔组织继发性恶性肿瘤', '473', 'C79.851', 'JDZZJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2837', '拉特克囊继发性恶性肿瘤', '473', 'C79.852', 'LTKNJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2838', '罗森米勒窝继发性恶性肿瘤', '473', 'C79.853', 'LSMLWJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2839', '脉络膜继发性恶性肿瘤', '473', 'C79.854', 'MLMJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2840', '纳博特腺[滤泡]继发性恶性肿瘤', '473', 'C79.855', 'NBTXLPJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2841', '腹股沟继发性恶性肿瘤', '473', 'C79.856', 'FGGJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2842', '骨外性继发性恶性肉瘤', '294', 'C79.857', 'GWXJFXEXRL', '');
INSERT INTO `05diseases` VALUES ('2843', '加特纳管[卵巢冠纵管]继发性恶性肿瘤', '473', 'C79.858', 'JTNGLCGZGJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2844', '巴多林腺[前庭大腺]继发性恶性肿瘤', '473', 'C79.859', 'BDLXQTDXJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2845', '扁桃体继发性恶性肿瘤', '473', 'C79.860', 'BTTJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2846', '祖克坎德耳器继发性恶性肿瘤', '473', 'C79.861', 'ZKKDEQJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2847', '血管继发性恶性肿瘤', '473', 'C79.862', 'XGJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2848', '腰部继发性恶性肿瘤', '473', 'C79.863', 'YBJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2849', '沃顿管继发性恶性肿瘤', '473', 'C79.864', 'WDGJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2850', '心肌继发性恶性肿瘤', '473', 'C79.865', 'XJJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2851', '胸腺继发性恶性肿瘤', '473', 'C79.866', 'XXJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2852', '斯滕森管[腮腺管]继发性恶性肿瘤', '473', 'C79.867', 'STSGSXGJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2853', '瓦尔代尔扁桃体环继发性恶性肿瘤', '473', 'C79.868', 'WEDEBTTHJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2854', '多系统继发性恶性肿瘤', '473', 'C80.X01', 'DXTJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2855', '广泛转移性肿瘤', '473', 'C80.X02', 'GFZYXZL', '');
INSERT INTO `05diseases` VALUES ('2856', '未特指部位原发或继发性恶性肿瘤', '473', 'C80.X03', 'WTZBWYFHJFXEXZL', '');
INSERT INTO `05diseases` VALUES ('2857', '恶性肿瘤肌病 (M80000/3)', '473', 'C80.X04+', 'EXZLJB', '');
INSERT INTO `05diseases` VALUES ('2858', '恶性肿瘤肌无力综合征 (M80000/3)', '473', 'C80.X05+', 'EXZLJWLZHZ', '');
INSERT INTO `05diseases` VALUES ('2859', '恶性肿瘤性周围神经病 (M80000/3)', '473', 'C80.X06+', 'EXZLXZWSJB', '');
INSERT INTO `05diseases` VALUES ('2860', '癌症性恶病质', '2', 'C80.X51', 'AZXEBZ', '');
INSERT INTO `05diseases` VALUES ('2861', '癌原性神经病', '313', 'C80.X52', 'AYXSJB', '');
INSERT INTO `05diseases` VALUES ('2862', '全身性癌症', '2', 'C80.X53', 'QSXAZ', '');
INSERT INTO `05diseases` VALUES ('2863', '多发性癌症', '2', 'C80.X54', 'DFXAZ', '');
INSERT INTO `05diseases` VALUES ('2864', '淋巴细胞为主型霍奇[何杰]金氏病 (M96570/3)', '376', 'C81.001', 'LBXBWZXHQHJJSB', '');
INSERT INTO `05diseases` VALUES ('2865', '结节性硬化型霍奇[何杰]金氏病 (M96630/3)', '268', 'C81.101', 'JJXYHXHQHJJSB', '');
INSERT INTO `05diseases` VALUES ('2866', '混合细胞型霍奇[何杰]金氏病 (M96520/3)', '376', 'C81.201', 'HHXBXHQHJJSB', '');
INSERT INTO `05diseases` VALUES ('2867', '淋巴细胞缺乏性霍奇[何杰]金氏病 (M96530/3)', '376', 'C81.301', 'LBXBQFXHQHJJSB', '');
INSERT INTO `05diseases` VALUES ('2868', '霍奇[何杰]金氏类肉芽肿 (M96610/3)', '295', 'C81.751', 'HQHJJSLRYZ', '');
INSERT INTO `05diseases` VALUES ('2869', '霍奇[何杰]金氏肉瘤 (M96620/3)', '294', 'C81.752', 'HQHJJSRL', '');
INSERT INTO `05diseases` VALUES ('2870', '霍奇[何杰]金氏病副肉芽肿 (M96600/3)', '295', 'C81.753', 'HQHJJSBFRYZ', '');
INSERT INTO `05diseases` VALUES ('2871', '霍奇[何杰]金氏病 (M96500/3)', '268', 'C81.901', 'HQHJJSB', '');
INSERT INTO `05diseases` VALUES ('2872', '嗜酸细胞性淋巴肉芽肿 (M96500/3)', '295', 'C81.902', 'SSXBXLBRYZ', '');
INSERT INTO `05diseases` VALUES ('2873', '滤泡性小分裂细胞型非霍奇金淋巴瘤 (M96950/3)', '208', 'C82.051', 'LPXXFLXBXFHQJLBL', '');
INSERT INTO `05diseases` VALUES ('2874', '混合细胞型淋巴肉瘤 (M96910/3)', '294', 'C82.101', 'HHXBXLBRL', '');
INSERT INTO `05diseases` VALUES ('2875', '滤泡性大细胞型非霍奇金淋巴瘤 (M96980/3)', '208', 'C82.251', 'LPXDXBXFHQJLBL', '');
INSERT INTO `05diseases` VALUES ('2876', '高分化型淋巴细胞性恶性淋巴瘤 (M96930/3)', '208', 'C82.701', 'GFHXLBXBXEXLBL', '');
INSERT INTO `05diseases` VALUES ('2877', '其他类型的滤泡性非霍奇金淋巴瘤 (M969，/3)', '208', 'C82.751', 'QTLXDLPXFHQJLBL', '');
INSERT INTO `05diseases` VALUES ('2878', '结节型淋巴瘤 (M96900/3)', '208', 'C82.901', 'JJXLBL', '');
INSERT INTO `05diseases` VALUES ('2879', '滤泡性淋巴瘤 (M96900/3)', '208', 'C82.902', 'LPXLBL', '');
INSERT INTO `05diseases` VALUES ('2880', '结节性非霍奇[何杰]金淋巴瘤 (M96900/3)', '208', 'C82.951', 'JJXFHQHJJLBL', '');
INSERT INTO `05diseases` VALUES ('2881', '非霍奇[何杰]金淋巴瘤 (M96900/3)', '208', 'C82.952', 'FHQHJJLBL', '');
INSERT INTO `05diseases` VALUES ('2882', '淋巴细胞性淋巴瘤(恶性) (M96700/3)', '208', 'C83.051', 'LBXBXLBLEX', '');
INSERT INTO `05diseases` VALUES ('2883', '小细胞型(弥漫性)非霍奇金淋巴瘤 (M96700/3)', '208', 'C83.052', 'XXBXMMXFHQJLBL', '');
INSERT INTO `05diseases` VALUES ('2884', '小分裂细胞型(弥漫性)非霍奇金淋巴瘤 (M96720/3)', '208', 'C83.151', 'XFLXBXMMXFHQJLBL', '');
INSERT INTO `05diseases` VALUES ('2885', '混合细胞型恶性淋巴瘤 (M96750/3)', '208', 'C83.201', 'HHXBXEXLBL', '');
INSERT INTO `05diseases` VALUES ('2886', '弥漫性混合细胞型恶性淋巴瘤 (M96750/3)', '208', 'C83.202', 'MMXHHXBXEXLBL', '');
INSERT INTO `05diseases` VALUES ('2888', '血管网状细胞瘤 (M96800/3)', '377', 'C83.301', 'XGWZXBL', '');
INSERT INTO `05diseases` VALUES ('2889', '网织细胞肉瘤 (M95930/3)', '294', 'C83.302', 'WZXBRL', '');
INSERT INTO `05diseases` VALUES ('2890', '大细胞型(弥漫性)非霍奇金淋巴瘤 (M96800/3)', '208', 'C83.351', 'DXBXMMXFHQJLBL', '');
INSERT INTO `05diseases` VALUES ('2891', '免疫母细胞型恶性淋巴瘤 (M96840/3)', '228', 'C83.401', 'MYMXBXEXLBL', '');
INSERT INTO `05diseases` VALUES ('2892', '原淋巴细胞(弥漫性)非霍奇金淋巴瘤 (M96850/3)', '208', 'C83.551', 'YLBXBMMXFHQJLBL', '');
INSERT INTO `05diseases` VALUES ('2893', '未分化性恶性淋巴瘤(弥漫性) (M96860/3)', '208', 'C83.651', 'WFHXEXLBLMMX', '');
INSERT INTO `05diseases` VALUES ('2895', '伯基特瘤 (M96870/3)', '261', 'C83.752', 'BJTL', '');
INSERT INTO `05diseases` VALUES ('2896', '淋巴浆细胞型恶性淋巴瘤 (M96710/3)', '208', 'C83.801', 'LBJXBXEXLBL', '');
INSERT INTO `05diseases` VALUES ('2897', '胃网状细胞肉瘤 (M95930/3)', '370', 'C83.951', 'WWZXBRL', '');
INSERT INTO `05diseases` VALUES ('2898', '蕈样真菌病[阿利贝尔特氏病] (M97000/3)', '464', 'C84.001', 'XYZJBALBETSB', '');
INSERT INTO `05diseases` VALUES ('2899', '网状细胞增多(症)[塞扎瑞氏病] (M97010/3)', '376', 'C84.101', 'WZXBZDZSZRSB', '');
INSERT INTO `05diseases` VALUES ('2900', 'Ｔ－区性淋巴瘤 (M97030/3)', '208', 'C84.251', 'QXLBL', '');
INSERT INTO `05diseases` VALUES ('2901', '淋巴上皮样淋巴瘤 (M97040/3)', '208', 'C84.351', 'LBSPYLBL', '');
INSERT INTO `05diseases` VALUES ('2902', '伦纳特淋巴瘤(恶性) (M97040/3)', '208', 'C84.352', 'LNTLBLEX', '');
INSERT INTO `05diseases` VALUES ('2903', '周围的Ｔ细胞淋巴瘤 (M97050/3)', '208', 'C84.451', 'ZWDXBLBL', '');
INSERT INTO `05diseases` VALUES ('2904', '其他和未特指的Ｔ细胞淋巴瘤 (M95900/3)', '208', 'C84.551', 'QTHWTZDXBLBL', '');
INSERT INTO `05diseases` VALUES ('2905', '鼻淋巴肉瘤 (M95920/3)', '16', 'C85.001', 'BLBRL', '');
INSERT INTO `05diseases` VALUES ('2906', '肠淋巴肉瘤 (M95920/3)', '294', 'C85.002', 'CLBRL', '');
INSERT INTO `05diseases` VALUES ('2907', '肠系膜淋巴肉瘤 (M95920/3)', '294', 'C85.003', 'CXMLBRL', '');
INSERT INTO `05diseases` VALUES ('2908', '额叶淋巴肉瘤 (M95920/3)', '294', 'C85.004', 'EYLBRL', '');
INSERT INTO `05diseases` VALUES ('2909', '腹腔淋巴肉瘤 (M95920/3)', '294', 'C85.005', 'FQLBRL', '');
INSERT INTO `05diseases` VALUES ('2910', '睾丸淋巴肉瘤 (M95920/3)', '230', 'C85.006', 'GWLBRL', '');
INSERT INTO `05diseases` VALUES ('2911', '颌淋巴肉瘤 (M95920/3)', '294', 'C85.007', 'HLBRL', '');
INSERT INTO `05diseases` VALUES ('2912', '喉淋巴肉瘤 (M95920/3)', '133', 'C85.008', 'HLBRL', '');
INSERT INTO `05diseases` VALUES ('2913', '结节性淋巴肉瘤 (M95920/3)', '294', 'C85.009', 'JJXLBRL', '');
INSERT INTO `05diseases` VALUES ('2914', '淋巴肉瘤 (M95920/3)', '294', 'C85.010', 'LBRL', '');
INSERT INTO `05diseases` VALUES ('2915', '盲肠淋巴肉瘤 (M95920/3)', '294', 'C85.011', 'MCLBRL', '');
INSERT INTO `05diseases` VALUES ('2916', '脾淋巴肉瘤 (M95920/3)', '253', 'C85.012', 'PLBRL', '');
INSERT INTO `05diseases` VALUES ('2917', '腮腺淋巴肉瘤 (M95920/3)', '294', 'C85.013', 'SXLBRL', '');
INSERT INTO `05diseases` VALUES ('2918', '十二指肠淋巴肉瘤 (M95920/3)', '321', 'C85.014', 'SEZCLBRL', '');
INSERT INTO `05diseases` VALUES ('2919', '胃淋巴肉瘤 (M95920/3)', '370', 'C85.015', 'WLBRL', '');
INSERT INTO `05diseases` VALUES ('2920', '咽淋巴肉瘤 (M95920/3)', '294', 'C85.016', 'YLBRL', '');
INSERT INTO `05diseases` VALUES ('2921', '纵隔淋巴肉瘤 (M95920/3)', '294', 'C85.017', 'ZGLBRL', '');
INSERT INTO `05diseases` VALUES ('2922', 'Ｂ－细胞淋巴瘤 NOS', '208', 'C85.151', 'XBLBL', '');
INSERT INTO `05diseases` VALUES ('2923', '恶性网状细胞增多症 (M97130/3)', '379', 'C85.701', 'EXWZXBZDZ', '');
INSERT INTO `05diseases` VALUES ('2924', '恶性小神经胶质细胞瘤 (M95940/3)', '313', 'C85.751', 'EXXSJJZXBL', '');
INSERT INTO `05diseases` VALUES ('2925', '恶性网状内皮组织增殖 (M97120/3)', '278', 'C85.752', 'EXWZNPZZZZ', '');
INSERT INTO `05diseases` VALUES ('2926', '鼻窦恶性淋巴瘤 (M95900/3)', '16', 'C85.901', 'BDEXLBL', '');
INSERT INTO `05diseases` VALUES ('2927', '鼻腔恶性淋巴瘤 (M95900/3)', '16', 'C85.902', 'BQEXLBL', '');
INSERT INTO `05diseases` VALUES ('2928', '扁桃体恶性淋巴瘤 (M95900/3)', '208', 'C85.903', 'BTTEXLBL', '');
INSERT INTO `05diseases` VALUES ('2929', '肠恶性淋巴瘤 (M95900/3)', '208', 'C85.904', 'CEXLBL', '');
INSERT INTO `05diseases` VALUES ('2930', '肠系膜恶性淋巴瘤 (M95900/3)', '208', 'C85.905', 'CXMEXLBL', '');
INSERT INTO `05diseases` VALUES ('2931', '恶性淋巴瘤 (M95900/3)', '208', 'C85.906', 'EXLBL', '');
INSERT INTO `05diseases` VALUES ('2932', '非何杰金氏淋巴瘤 (M95910/3)', '208', 'C85.907', 'FHJJSLBL', '');
INSERT INTO `05diseases` VALUES ('2933', '肺恶性淋巴瘤 (M95900/3)', '79', 'C85.908', 'FEXLBL', '');
INSERT INTO `05diseases` VALUES ('2934', '腹膜后恶性淋巴瘤 (M95900/3)', '208', 'C85.909', 'FMHEXLBL', '');
INSERT INTO `05diseases` VALUES ('2935', '腹腔恶性淋巴瘤 (M95900/3)', '208', 'C85.910', 'FQEXLBL', '');
INSERT INTO `05diseases` VALUES ('2936', '肝恶性淋巴瘤 (M95900/3)', '92', 'C85.911', 'GEXLBL', '');
INSERT INTO `05diseases` VALUES ('2937', '睾丸恶性淋巴瘤 (M95900/3)', '230', 'C85.912', 'GWEXLBL', '');
INSERT INTO `05diseases` VALUES ('2938', '纵膈恶性淋巴瘤 (M95900/3)', '208', 'C85.913', 'ZGEXLBL', '');
INSERT INTO `05diseases` VALUES ('2939', '回盲部恶性淋巴瘤 (M95900/3)', '208', 'C85.914', 'HMBEXLBL', '');
INSERT INTO `05diseases` VALUES ('2940', '结肠恶性淋巴瘤 (M95900/3)', '208', 'C85.915', 'JCEXLBL', '');
INSERT INTO `05diseases` VALUES ('2941', '卵巢恶性淋巴瘤 (M95900/3)', '86', 'C85.916', 'LCEXLBL', '');
INSERT INTO `05diseases` VALUES ('2942', '盲肠恶性淋巴瘤 (M95900/3)', '208', 'C85.917', 'MCEXLBL', '');
INSERT INTO `05diseases` VALUES ('2943', '面部恶性淋巴瘤 (M95900/3)', '208', 'C85.918', 'MBEXLBL', '');
INSERT INTO `05diseases` VALUES ('2944', '脑恶性淋巴瘤 (M95900/3)', '234', 'C85.919', 'NEXLBL', '');
INSERT INTO `05diseases` VALUES ('2945', '脾恶性淋巴瘤 (M95900/3)', '253', 'C85.920', 'PEXLBL', '');
INSERT INTO `05diseases` VALUES ('2946', '脾脏恶性淋巴瘤 (M95900/3)', '253', 'C85.921', 'PZEXLBL', '');
INSERT INTO `05diseases` VALUES ('2947', '舌恶性淋巴瘤 (M95900/3)', '208', 'C85.922', 'SEXLBL', '');
INSERT INTO `05diseases` VALUES ('2948', '胃恶性淋巴瘤 (M95900/3)', '370', 'C85.923', 'WEXLBL', '');
INSERT INTO `05diseases` VALUES ('2949', '小肠恶性淋巴瘤 (M95900/3)', '208', 'C85.924', 'XCEXLBL', '');
INSERT INTO `05diseases` VALUES ('2950', '眼恶性淋巴瘤 (M95900/3)', '430', 'C85.925', 'YEXLBL', '');
INSERT INTO `05diseases` VALUES ('2951', '硬膜外恶性淋巴瘤 (M95900/3)', '208', 'C85.926', 'YMWEXLBL', '');
INSERT INTO `05diseases` VALUES ('2952', '肢体恶性淋巴瘤 (M95900/3)', '208', 'C85.927', 'ZTEXLBL', '');
INSERT INTO `05diseases` VALUES ('2953', '直肠恶性淋巴瘤 (M95900/3)', '208', 'C85.928', 'ZCEXLBL', '');
INSERT INTO `05diseases` VALUES ('2954', '骨恶性淋巴瘤 (M95900/3)', '208', 'C85.929', 'GEXLBL', '');
INSERT INTO `05diseases` VALUES ('2955', '非霍奇[何杰]金氏恶性淋巴瘤 (M95900/3)', '208', 'C85.951', 'FHQHJJSEXLBL', '');
INSERT INTO `05diseases` VALUES ('2957', 'α重链病 (M97620/3)', '268', 'C88.151', 'ZLB', '');
INSERT INTO `05diseases` VALUES ('2958', 'γ重链病 (M97630/3)', '268', 'C88.251', 'ZLB', '');
INSERT INTO `05diseases` VALUES ('2959', '富兰克林病 (M97630/3)', '268', 'C88.252', 'FLKLB', '');
INSERT INTO `05diseases` VALUES ('2960', '免疫增生性小肠病 (M97640/3)', '228', 'C88.351', 'MYZSXXCB', '');
INSERT INTO `05diseases` VALUES ('2961', '地中海淋巴瘤 (M97640/3)', '208', 'C88.352', 'DZHLBL', '');
INSERT INTO `05diseases` VALUES ('2962', '其他恶性免疫增生性疾病 (M97600/3)', '228', 'C88.751', 'QTEXMYZSXJB', '');
INSERT INTO `05diseases` VALUES ('2963', '恶性免疫增生性疾病 NOS (M97600/3)', '228', 'C88.951', 'EXMYZSXJB', '');
INSERT INTO `05diseases` VALUES ('2964', '多发性骨髓瘤[卡勒病] (M97320/3)', '261', 'C90.001', 'DFXGSLKLB', '');
INSERT INTO `05diseases` VALUES ('2965', '浆细胞性骨髓瘤 (M97320/3)', '261', 'C90.002', 'JXBXGSL', '');
INSERT INTO `05diseases` VALUES ('2966', '骨髓瘤肾病 (M97320/3)', '314', 'C90.003+', 'GSLSB', '');
INSERT INTO `05diseases` VALUES ('2967', '骨髓瘤病 (M97320/3)', '261', 'C90.051', 'GSLB', '');
INSERT INTO `05diseases` VALUES ('2968', '浆细胞性白血病 (M98300/3)', '5', 'C90.101', 'JXBXBXB', '');
INSERT INTO `05diseases` VALUES ('2969', '浆细胞瘤 NOS (M97310/3)', '377', 'C90.201', 'JXBL', '');
INSERT INTO `05diseases` VALUES ('2970', '单骨性浆细胞性骨髓瘤 (M97310/3)', '261', 'C90.202', 'DGXJXBXGSL', '');
INSERT INTO `05diseases` VALUES ('2971', '孤立性骨髓瘤 (M97310/3)', '261', 'C90.251', 'GLXGSL', '');
INSERT INTO `05diseases` VALUES ('2972', '恶性浆细胞瘤 (M97310/3)', '377', 'C90.252', 'EXJXBL', '');
INSERT INTO `05diseases` VALUES ('2973', '浆细胞肉瘤 (M97310/3)', '294', 'C90.253', 'JXBRL', '');
INSERT INTO `05diseases` VALUES ('2974', '急性淋巴细胞性白血病 (M98210/3)', '5', 'C91.001', 'JXLBXBXBXB', '');
INSERT INTO `05diseases` VALUES ('2975', '急性淋巴细胞性白血病L1 (M98210/3)', '5', 'C91.002', 'JXLBXBXBXB', '');
INSERT INTO `05diseases` VALUES ('2976', '急性淋巴细胞性白血病L2 (M98210/3)', '5', 'C91.003', 'JXLBXBXBXB', '');
INSERT INTO `05diseases` VALUES ('2977', '急性淋巴细胞性白血病L3 (M98210/3)', '5', 'C91.004', 'JXLBXBXBXB', '');
INSERT INTO `05diseases` VALUES ('2978', '慢性粒细胞性白血病，急淋变 (M98210/3)', '5', 'C91.005', 'MXLXBXBXBJLB', '');
INSERT INTO `05diseases` VALUES ('2979', '慢性淋巴细胞性白血病 (M98230/3)', '5', 'C91.101', 'MXLBXBXBXB', '');
INSERT INTO `05diseases` VALUES ('2980', '亚急性淋巴细胞性白血病 (M98220/3)', '5', 'C91.251', 'YJXLBXBXBXB', '');
INSERT INTO `05diseases` VALUES ('2981', '幼淋巴细胞性白血病 (M98250/3)', '5', 'C91.301', 'YLBXBXBXB', '');
INSERT INTO `05diseases` VALUES ('2982', '毛细胞性白血病 (M99400/3)', '5', 'C91.401', 'MXBXBXB', '');
INSERT INTO `05diseases` VALUES ('2983', '多毛细胞性白血病 (M99400/3)', '5', 'C91.451', 'DMXBXBXB', '');
INSERT INTO `05diseases` VALUES ('2984', '白血病性网状内皮细胞增多症 (M99410/3)', '5', 'C91.452', 'BXBXWZNPXBZDZ', '');
INSERT INTO `05diseases` VALUES ('2985', '成人Ｔ－细胞白血病 (M98270/3)', '5', 'C91.551', 'CRXBBXB', '');
INSERT INTO `05diseases` VALUES ('2986', '非白血性淋巴细胞性白血病 (M98240/3)', '5', 'C91.701', 'FBXXLBXBXBXB', '');
INSERT INTO `05diseases` VALUES ('2987', '其他淋巴样白血病 (M98200/3)', '5', 'C91.751', 'QTLBYBXB', '');
INSERT INTO `05diseases` VALUES ('2988', '淋巴细胞性白血病 (M98200/3)', '5', 'C91.901', 'LBXBXBXB', '');
INSERT INTO `05diseases` VALUES ('2992', '慢性粒细胞性白血病急性发作 (M98630/3)', '5', 'C92.102', 'MXLXBXBXBJXFZ', '');
INSERT INTO `05diseases` VALUES ('2993', '慢性中性粒细胞性白血病 (M98630/3)', '5', 'C92.103', 'MXZXLXBXBXB', '');
INSERT INTO `05diseases` VALUES ('2994', '慢性髓样白血病 (M98630/3)', '5', 'C92.151', 'MXSYBXB', '');
INSERT INTO `05diseases` VALUES ('2995', '亚急性粒细胞性白血病 (M98620/3)', '5', 'C92.201', 'YJXLXBXBXB', '');
INSERT INTO `05diseases` VALUES ('2996', '亚急性髓样白血病 (M98620/3)', '5', 'C92.251', 'YJXSYBXB', '');
INSERT INTO `05diseases` VALUES ('2997', '绿色瘤 (M99300/3)', '261', 'C92.301', 'LSL', '');
INSERT INTO `05diseases` VALUES ('2998', '粒细胞肉瘤 (M99300/3)　', '294', 'C92.351', 'LXBRL', '');
INSERT INTO `05diseases` VALUES ('2999', '髓样肉瘤 (M99300/3)', '294', 'C92.352', 'SYRL', '');
INSERT INTO `05diseases` VALUES ('3003', '嗜碱细胞性白血病 (M98700/3)', '5', 'C92.702', 'SJXBXBXB', '');
INSERT INTO `05diseases` VALUES ('3004', '嗜酸细胞性白血病 (M98800/3)', '5', 'C92.703', 'SSXBXBXB', '');
INSERT INTO `05diseases` VALUES ('3005', '其他髓样白血病', '5', 'C92.751', 'QTSYBXB', '');
INSERT INTO `05diseases` VALUES ('3006', '低增生性粒细胞性白血病 (M98600/3)', '5', 'C92.901', 'DZSXLXBXBXB', '');
INSERT INTO `05diseases` VALUES ('3007', '粒细胞性白血病 (M98600/3)', '5', 'C92.902', 'LXBXBXB', '');
INSERT INTO `05diseases` VALUES ('3008', '髓样白血病 NOS (M98600/3)', '5', 'C92.951', 'SYBXB', '');
INSERT INTO `05diseases` VALUES ('3009', '急性单核细胞性白血病[AMOL]  (M98910/3)', '5', 'C93.001', 'JXDHXBXBXB', '');
INSERT INTO `05diseases` VALUES ('3010', '慢性单核细胞性白血病 (M98930/3)', '5', 'C93.101', 'MXDHXBXBXB', '');
INSERT INTO `05diseases` VALUES ('3011', '亚急性单核细胞性白血病 (M98920/3)', '5', 'C93.251', 'YJXDHXBXBXB', '');
INSERT INTO `05diseases` VALUES ('3012', '其他单核细胞性白血病 (M98940/3)', '5', 'C93.751', 'QTDHXBXBXB', '');
INSERT INTO `05diseases` VALUES ('3013', '组织细胞性白血病 (M98900/3)', '5', 'C93.901', 'ZZXBXBXB', '');
INSERT INTO `05diseases` VALUES ('3014', '单核细胞性白血病 NOS (M98900/3)', '5', 'C93.951', 'DHXBXBXB', '');
INSERT INTO `05diseases` VALUES ('3015', '红白血病[AEL] Ｍ6型 (M98400/3)', '5', 'C94.001', 'HBXBX', '');
INSERT INTO `05diseases` VALUES ('3016', '急性红细胞增多症 (M98410/3)', '379', 'C94.002', 'JXHXBZDZ', '');
INSERT INTO `05diseases` VALUES ('3017', '红细胞增多症 (M98410/3)', '379', 'C94.003', 'HXBZDZ', '');
INSERT INTO `05diseases` VALUES ('3018', '迪古列尔莫病[巨红细胞性骨髓增殖] (M98410/3)', '113', 'C94.051', 'DGLEMBJHXBXGSZZ', '');
INSERT INTO `05diseases` VALUES ('3019', '急性红细胞性骨髓组织增生(多)症 (M98410/3)', '113', 'C94.052', 'JXHXBXGSZZZSDZ', '');
INSERT INTO `05diseases` VALUES ('3020', '慢性红细胞增多症 (M98420/3)', '379', 'C94.101', 'MXHXBZDZ', '');
INSERT INTO `05diseases` VALUES ('3021', '海尔迈尔－舍纳病(急性) (M98420/3)', '268', 'C94.151', 'HEMESNBJX', '');
INSERT INTO `05diseases` VALUES ('3022', '巨核细胞性白血病 Ｍ7 (M99100/3)', '5', 'C94.201', 'JHXBXBXB', '');
INSERT INTO `05diseases` VALUES ('3023', '肥大细胞白血病 (M99000/3)', '5', 'C94.351', 'FDXBBXB', '');
INSERT INTO `05diseases` VALUES ('3024', '急性全骨髓增殖症 (M99310/3)', '113', 'C94.451', 'JXQGSZZZ', '');
INSERT INTO `05diseases` VALUES ('3025', '急性骨髓纤维变性 (M99320/3)', '113', 'C94.551', 'JXGSXWBX', '');
INSERT INTO `05diseases` VALUES ('3026', '淋巴肉瘤细胞性白血病 (M98500/3)', '294', 'C94.701', 'LBRLXBXBXB', '');
INSERT INTO `05diseases` VALUES ('3027', '急性白血病 (M98010/3)', '5', 'C95.001', 'JXBXB', '');
INSERT INTO `05diseases` VALUES ('3028', '急性白血病髓外复发 (M98010/3)', '5', 'C95.002', 'JXBXBSWFF', '');
INSERT INTO `05diseases` VALUES ('3029', '急性非淋巴细胞性白血病 (M98010/3)', '5', 'C95.003', 'JXFLBXBXBXB', '');
INSERT INTO `05diseases` VALUES ('3030', '未分化型白血病 (M98010/3)', '5', 'C95.004', 'WFHXBXB', '');
INSERT INTO `05diseases` VALUES ('3031', '干细胞性白血病 (M98010/3)', '5', 'C95.051', 'GXBXBXB', '');
INSERT INTO `05diseases` VALUES ('3032', '母细胞性白血病 (M98010/3)', '5', 'C95.052', 'MXBXBXB', '');
INSERT INTO `05diseases` VALUES ('3033', '慢性白血病 (M98030/3)', '5', 'C95.151', 'MXBXB', '');
INSERT INTO `05diseases` VALUES ('3034', '亚急性白血病 (M98020/3)', '5', 'C95.251', 'YJXBXB', '');
INSERT INTO `05diseases` VALUES ('3035', '非白血性白血病[白细胞不增多性血病] (M98040/3)', '5', 'C95.751', 'FBXXBXBBXBBZDXXB', '');
INSERT INTO `05diseases` VALUES ('3036', '白血病 (M98000/3)', '5', 'C95.901', 'BXB', '');
INSERT INTO `05diseases` VALUES ('3037', '混合细胞性白血病 (M98000/3)', '5', 'C95.902', 'HHXBXBXB', '');
INSERT INTO `05diseases` VALUES ('3038', '白血病性关节病 (M98000/3)', '123', 'C95.903+', 'BXBXGJB', '');
INSERT INTO `05diseases` VALUES ('3039', '脑膜白血病 (M98000/3)', '232', 'C95.904+', 'NMBXB', '');
INSERT INTO `05diseases` VALUES ('3040', '关节病合并白血病', '123', 'C95.951+', 'GJBHBBXB', '');
INSERT INTO `05diseases` VALUES ('3042', '非脂肪性网状内皮组织增殖 (M97220/3)', '278', 'C96.051', 'FZFXWZNPZZZZ', '');
INSERT INTO `05diseases` VALUES ('3043', '急性婴儿网状内皮细胞增多症 (M97220/3)', '379', 'C96.052', 'JXYEWZNPXBZDZ', '');
INSERT INTO `05diseases` VALUES ('3044', '恶性组织细胞增多症 (M97200/3)', '379', 'C96.101', 'EXZZXBZDZ', '');
INSERT INTO `05diseases` VALUES ('3045', '恶性组织细胞增多症累及中枢神经系统 (M97200/3)', '313', 'C96.102', 'EXZZXBZDZLJZSSJXT', '');
INSERT INTO `05diseases` VALUES ('3046', '恶性组织细胞病 (M97200/3)', '376', 'C96.151', 'EXZZXBB', '');
INSERT INTO `05diseases` VALUES ('3047', '组织细胞髓性网状细胞增多 (M97200/3)', '376', 'C96.152', 'ZZXBSXWZXBZD', '');
INSERT INTO `05diseases` VALUES ('3048', '肥大细胞肉瘤 (M97400/3)', '294', 'C96.251', 'FDXBRL', '');
INSERT INTO `05diseases` VALUES ('3049', '恶性肥大细胞增多症 (M92410/3)', '379', 'C96.252', 'EXFDXBZDZ', '');
INSERT INTO `05diseases` VALUES ('3050', '恶性肥大细胞瘤 (M97400/3)', '377', 'C96.253', 'EXFDXBL', '');
INSERT INTO `05diseases` VALUES ('3051', '真性组织细胞淋巴瘤 (M97230/3)', '208', 'C96.351', 'ZXZZXBLBL', '');
INSERT INTO `05diseases` VALUES ('3052', '其他特指的淋巴、造血和有关组织的恶性肿瘤', '473', 'C96.751', 'QTTZDLBZXHYGZZDEXZL', '');
INSERT INTO `05diseases` VALUES ('3053', '淋巴、造血和有关组织的恶性肿瘤 NOS', '473', 'C96.951', 'LBZXHYGZZDEXZL', '');
INSERT INTO `05diseases` VALUES ('3054', '恶性独立的多个部位的肿瘤', '473', 'C97.X51', 'EXDLDDGBWDZL', '');
INSERT INTO `05diseases` VALUES ('3055', '咽原位癌', '2', 'D00.051', 'YYWA', '');
INSERT INTO `05diseases` VALUES ('3056', '唇原位癌', '2', 'D00.052', 'CYWA', '');
INSERT INTO `05diseases` VALUES ('3057', '口腔原位癌', '2', 'D00.053', 'KQYWA', '');
INSERT INTO `05diseases` VALUES ('3058', '软腭原位癌', '2', 'D00.054', 'REYWA', '');
INSERT INTO `05diseases` VALUES ('3059', '杓状会厌褶咽下面原位癌', '2', 'D00.055', 'BZHYZYXMYWA', '');
INSERT INTO `05diseases` VALUES ('3060', '杓状会厌褶边缘区原位癌', '2', 'D00.056', 'BZHYZBYQYWA', '');
INSERT INTO `05diseases` VALUES ('3061', '食管原位癌', '2', 'D00.101', 'SGYWA', '');
INSERT INTO `05diseases` VALUES ('3062', '胃原位癌', '370', 'D00.251', 'WYWA', '');
INSERT INTO `05diseases` VALUES ('3063', '结肠原位癌', '2', 'D01.051', 'JCYWA', '');
INSERT INTO `05diseases` VALUES ('3064', '直肠乙状结肠连接处原位癌', '2', 'D01.151', 'ZCYZJCLJCYWA', '');
INSERT INTO `05diseases` VALUES ('3065', '直肠原位癌', '2', 'D01.251', 'ZCYWA', '');
INSERT INTO `05diseases` VALUES ('3066', '肛管原位癌', '2', 'D01.351', 'GGYWA', '');
INSERT INTO `05diseases` VALUES ('3067', '肛门原位癌', '2', 'D01.352', 'GMYWA', '');
INSERT INTO `05diseases` VALUES ('3068', '肠原位癌', '2', 'D01.451', 'CYWA', '');
INSERT INTO `05diseases` VALUES ('3069', '胆道原位癌', '53', 'D01.551', 'DDYWA', '');
INSERT INTO `05diseases` VALUES ('3070', '胆囊原位癌', '53', 'D01.552', 'DNYWA', '');
INSERT INTO `05diseases` VALUES ('3071', '肝原位癌', '92', 'D01.553', 'GYWA', '');
INSERT INTO `05diseases` VALUES ('3072', '法特壶腹原位癌', '2', 'D01.554', 'FTHFYWA', '');
INSERT INTO `05diseases` VALUES ('3073', '胰原位癌', '2', 'D01.751', 'YYWA', '');
INSERT INTO `05diseases` VALUES ('3074', '特指的消化器官原位癌', '2', 'D01.752', 'TZDXHQGYWA', '');
INSERT INTO `05diseases` VALUES ('3075', '消化器官原位癌　NOS', '2', 'D01.951', 'XHQGYWA', '');
INSERT INTO `05diseases` VALUES ('3076', '喉原位癌', '133', 'D02.001', 'HYWA', '');
INSERT INTO `05diseases` VALUES ('3077', '声带原位癌', '2', 'D02.002', 'SDYWA', '');
INSERT INTO `05diseases` VALUES ('3078', '杓状会厌褶、喉面原位癌', '133', 'D02.051', 'BZHYZHMYWA', '');
INSERT INTO `05diseases` VALUES ('3079', '会厌原位癌(舌骨上部分)', '2', 'D02.052', 'HYYWASGSBF', '');
INSERT INTO `05diseases` VALUES ('3080', '气管原位癌', '2', 'D02.151', 'QGYWA', '');
INSERT INTO `05diseases` VALUES ('3081', '肺原位癌', '2', 'D02.251', 'FYWA', '');
INSERT INTO `05diseases` VALUES ('3082', '支气管原位癌', '2', 'D02.252', 'ZQGYWA', '');
INSERT INTO `05diseases` VALUES ('3083', '副鼻窦原位癌', '16', 'D02.351', 'FBDYWA', '');
INSERT INTO `05diseases` VALUES ('3084', '中耳原位癌', '70', 'D02.352', 'ZEYWA', '');
INSERT INTO `05diseases` VALUES ('3085', '呼吸系统的原位癌', '2', 'D02.353', 'HXXTDYWA', '');
INSERT INTO `05diseases` VALUES ('3086', '鼻腔原位癌', '16', 'D02.354', 'BQYWA', '');
INSERT INTO `05diseases` VALUES ('3087', '唇原位黑(色素)瘤 (M87200/2)', '130', 'D03.051', 'CYWHSSL', '');
INSERT INTO `05diseases` VALUES ('3088', '眼睑原位黑(色素)瘤 (M87200/2)', '430', 'D03.151', 'YJYWHSSL', '');
INSERT INTO `05diseases` VALUES ('3089', '耳原位黑(色素)瘤 (M87200/2)', '70', 'D03.251', 'EYWHSSL', '');
INSERT INTO `05diseases` VALUES ('3090', '外耳道原位黑(色素)瘤 (M87200/2)', '70', 'D03.252', 'WEDYWHSSL', '');
INSERT INTO `05diseases` VALUES ('3091', '面部原位黑(色素)瘤 (M87200/2)', '130', 'D03.351', 'MBYWHSSL', '');
INSERT INTO `05diseases` VALUES ('3092', '头皮原位黑(色素)瘤 (M87200/2)', '130', 'D03.451', 'TPYWHSSL', '');
INSERT INTO `05diseases` VALUES ('3093', '颈部原位黑(色素)瘤 (M87200/2)', '130', 'D03.452', 'GBYWHSSL', '');
INSERT INTO `05diseases` VALUES ('3094', '肛门边缘原位黑(色素)瘤 (M87200/2)', '130', 'D03.551', 'GMBYYWHSSL', '');
INSERT INTO `05diseases` VALUES ('3095', '肛门皮肤原位黑(色素)瘤 (M87200/2)', '250', 'D03.552', 'GMPFYWHSSL', '');
INSERT INTO `05diseases` VALUES ('3096', '躯干原位黑(色素)瘤 (M87200/2)', '130', 'D03.553', 'QGYWHSSL', '');
INSERT INTO `05diseases` VALUES ('3097', '乳房原位黑(色素)瘤 (M87200/2)', '86', 'D03.554', 'RFYWHSSL', '');
INSERT INTO `05diseases` VALUES ('3098', '肩原位黑(色素)瘤 (M87200/2)', '130', 'D03.651', 'JYWHSSL', '');
INSERT INTO `05diseases` VALUES ('3099', '上肢原位黑(色素)瘤 (M87200/2)', '130', 'D03.652', 'SZYWHSSL', '');
INSERT INTO `05diseases` VALUES ('3100', '髋原位黑(色素)瘤 (M87200/2)', '130', 'D03.751', 'KYWHSSL', '');
INSERT INTO `05diseases` VALUES ('3101', '下肢原位黑(色素)瘤 (M87200/2)', '130', 'D03.752', 'XZYWHSSL', '');
INSERT INTO `05diseases` VALUES ('3102', '其他部位的原位黑(色素)瘤 (M87200/2)', '130', 'D03.851', 'QTBWDYWHSSL', '');
INSERT INTO `05diseases` VALUES ('3103', '原位黑(色素)瘤 NOS (M87200/2)', '130', 'D03.951', 'YWHSSL', '');
INSERT INTO `05diseases` VALUES ('3104', '唇的皮肤原位癌', '250', 'D04.051', 'CDPFYWA', '');
INSERT INTO `05diseases` VALUES ('3105', '眼(睑)皮肤原位癌', '430', 'D04.101', 'YJPFYWA', '');
INSERT INTO `05diseases` VALUES ('3106', '眦皮肤原位癌', '250', 'D04.151', 'ZPFYWA', '');
INSERT INTO `05diseases` VALUES ('3107', '耳和外耳道的皮肤原位癌', '70', 'D04.251', 'EHWEDDPFYWA', '');
INSERT INTO `05diseases` VALUES ('3108', '外耳道原位癌', '70', 'D04.252', 'WEDYWA', '');
INSERT INTO `05diseases` VALUES ('3109', '鼻沟原位癌', '16', 'D04.301', 'BGYWA', '');
INSERT INTO `05diseases` VALUES ('3110', '面部其他的皮肤原位癌', '250', 'D04.351', 'MBQTDPFYWA', '');
INSERT INTO `05diseases` VALUES ('3111', '头皮和颈皮肤的原位癌', '250', 'D04.451', 'TPHGPFDYWA', '');
INSERT INTO `05diseases` VALUES ('3112', '颈部皮肤原位癌', '250', 'D04.452', 'GBPFYWA', '');
INSERT INTO `05diseases` VALUES ('3113', '肛门皮肤原位癌', '250', 'D04.551', 'GMPFYWA', '');
INSERT INTO `05diseases` VALUES ('3114', '躯干皮肤原位癌', '250', 'D04.552', 'QGPFYWA', '');
INSERT INTO `05diseases` VALUES ('3115', '乳房皮肤原位癌', '250', 'D04.553', 'RFPFYWA', '');
INSERT INTO `05diseases` VALUES ('3116', '上肢皮肤原位癌', '250', 'D04.651', 'SZPFYWA', '');
INSERT INTO `05diseases` VALUES ('3117', '肩皮肤原位癌', '250', 'D04.652', 'JPFYWA', '');
INSERT INTO `05diseases` VALUES ('3118', '下肢皮肤原位癌', '250', 'D04.701', 'XZPFYWA', '');
INSERT INTO `05diseases` VALUES ('3119', '髋皮肤原位癌', '250', 'D04.751', 'KPFYWA', '');
INSERT INTO `05diseases` VALUES ('3120', '其他特指部位的皮肤原位癌', '250', 'D04.851', 'QTTZBWDPFYWA', '');
INSERT INTO `05diseases` VALUES ('3121', '皮肤原位癌 NOS', '250', 'D04.901', 'PFYWA', '');
INSERT INTO `05diseases` VALUES ('3122', '博恩病[鲍恩病] (M80810/2)', '268', 'D04.951', 'BEBBEB', '');
INSERT INTO `05diseases` VALUES ('3123', '小叶性原位癌 (M85200/2)', '2', 'D05.001', 'XYXYWA', '');
INSERT INTO `05diseases` VALUES ('3124', '乳房导管原位癌', '2', 'D05.151', 'RFDGYWA', '');
INSERT INTO `05diseases` VALUES ('3125', '乳房其他原位癌', '2', 'D05.751', 'RFQTYWA', '');
INSERT INTO `05diseases` VALUES ('3126', '乳腺(房)原位癌 NOS', '2', 'D05.901', 'RXFYWA', '');
INSERT INTO `05diseases` VALUES ('3127', '宫颈内膜原位癌', '2', 'D06.051', 'GGNMYWA', '');
INSERT INTO `05diseases` VALUES ('3128', '宫颈外膜原位癌', '2', 'D06.151', 'GGWMYWA', '');
INSERT INTO `05diseases` VALUES ('3129', '宫颈其他部位原位癌', '2', 'D06.751', 'GGQTBWYWA', '');
INSERT INTO `05diseases` VALUES ('3130', '子宫颈原位癌 NOS', '86', 'D06.901', 'ZGGYWA', '');
INSERT INTO `05diseases` VALUES ('3131', '子宫内膜原位癌', '86', 'D07.001', 'ZGNMYWA', '');
INSERT INTO `05diseases` VALUES ('3132', '外阴原位癌', '2', 'D07.101', 'WYYWA', '');
INSERT INTO `05diseases` VALUES ('3133', '外阴博温氏病', '367', 'D07.151', 'WYBWSB', '');
INSERT INTO `05diseases` VALUES ('3134', '阴道原位癌', '86', 'D07.201', 'YDYWA', '');
INSERT INTO `05diseases` VALUES ('3135', '子宫原位癌', '86', 'D07.351', 'ZGYWA', '');
INSERT INTO `05diseases` VALUES ('3136', '其他和未特指的女性生殖器官原位癌', '86', 'D07.352', 'QTHWTZDNXSZQGYWA', '');
INSERT INTO `05diseases` VALUES ('3137', '阴茎原位癌', '230', 'D07.401', 'YJYWA', '');
INSERT INTO `05diseases` VALUES ('3138', '增殖性红斑', '250', 'D07.402', 'ZZXHB', '');
INSERT INTO `05diseases` VALUES ('3139', '凯拉增殖性红斑原位癌', '2', 'D07.451', 'KLZZXHBYWA', '');
INSERT INTO `05diseases` VALUES ('3140', '前列腺原位癌', '2', 'D07.501', 'QLXYWA', '');
INSERT INTO `05diseases` VALUES ('3141', '其他和未特指的男性生殖器官原位癌', '230', 'D07.551', 'QTHWTZDNXSZQGYWA', '');
INSERT INTO `05diseases` VALUES ('3142', '膀胱原位癌', '2', 'D09.001', 'BGYWA', '');
INSERT INTO `05diseases` VALUES ('3143', '尿道原位癌', '2', 'D09.101', 'NDYWA', '');
INSERT INTO `05diseases` VALUES ('3144', '其他和未特指的泌尿器官原位癌', '2', 'D09.151', 'QTHWTZDMNQGYWA', '');
INSERT INTO `05diseases` VALUES ('3145', '角膜原位癌', '2', 'D09.201', 'JMYWA', '');
INSERT INTO `05diseases` VALUES ('3146', '眼原位癌', '430', 'D09.251', 'YYWA', '');
INSERT INTO `05diseases` VALUES ('3147', '甲状腺原位癌', '2', 'D09.351', 'JZXYWA', '');
INSERT INTO `05diseases` VALUES ('3148', '其他内分泌腺的原位癌', '2', 'D09.352', 'QTNFMXDYWA', '');
INSERT INTO `05diseases` VALUES ('3149', '其他特指部位的原位癌', '2', 'D09.751', 'QTTZBWDYWA', '');
INSERT INTO `05diseases` VALUES ('3150', '原位癌 NOS', '2', 'D09.951', 'YWA', '');
INSERT INTO `05diseases` VALUES ('3151', '唇良性肿瘤', '473', 'D10.001', 'CLXZL', '');
INSERT INTO `05diseases` VALUES ('3152', '唇粘膜良性肿瘤', '473', 'D10.051', 'CNMLXZL', '');
INSERT INTO `05diseases` VALUES ('3153', '唇内面良性肿瘤', '473', 'D10.052', 'CNMLXZL', '');
INSERT INTO `05diseases` VALUES ('3154', '唇系带良性肿瘤', '473', 'D10.053', 'CXDLXZL', '');
INSERT INTO `05diseases` VALUES ('3155', '舌良性肿瘤', '473', 'D10.101', 'SLXZL', '');
INSERT INTO `05diseases` VALUES ('3156', '舌扁桃体良性肿瘤', '473', 'D10.151', 'SBTTLXZL', '');
INSERT INTO `05diseases` VALUES ('3157', '口底良性肿瘤', '473', 'D10.201', 'KDLXZL', '');
INSERT INTO `05diseases` VALUES ('3158', '舌下良性肿瘤', '473', 'D10.202', 'SXLXZL', '');
INSERT INTO `05diseases` VALUES ('3159', '齿槽良性肿瘤', '473', 'D10.301', 'CCLXZL', '');
INSERT INTO `05diseases` VALUES ('3160', '腭良性肿瘤', '473', 'D10.302', 'ELXZL', '');
INSERT INTO `05diseases` VALUES ('3161', '颊粘膜良性肿瘤', '473', 'D10.303', 'JNMLXZL', '');
INSERT INTO `05diseases` VALUES ('3162', '口腔良性肿瘤', '473', 'D10.304', 'KQLXZL', '');
INSERT INTO `05diseases` VALUES ('3163', '悬雍垂良性肿瘤', '473', 'D10.305', 'XYCLXZL', '');
INSERT INTO `05diseases` VALUES ('3164', '牙龈良性肿瘤', '473', 'D10.306', 'YYLXZL', '');
INSERT INTO `05diseases` VALUES ('3165', '软腭良性肿瘤', '473', 'D10.351', 'RELXZL', '');
INSERT INTO `05diseases` VALUES ('3166', '小涎腺良性肿瘤', '473', 'D10.352', 'XXXLXZL', '');
INSERT INTO `05diseases` VALUES ('3167', '扁桃体(腭的)(咽门)良性肿瘤', '473', 'D10.401', 'BTTEDYMLXZL', '');
INSERT INTO `05diseases` VALUES ('3168', '扁桃体窝良性肿瘤', '473', 'D10.551', 'BTTWLXZL', '');
INSERT INTO `05diseases` VALUES ('3169', '会咽谷良性肿瘤', '473', 'D10.552', 'HYGLXZL', '');
INSERT INTO `05diseases` VALUES ('3170', '鼻咽良性肿瘤', '473', 'D10.601', 'BYLXZL', '');
INSERT INTO `05diseases` VALUES ('3171', '罗森米勒窝良性肿瘤', '473', 'D10.651', 'LSMLWLXZL', '');
INSERT INTO `05diseases` VALUES ('3172', '咽扁桃体良性肿瘤', '473', 'D10.652', 'YBTTLXZL', '');
INSERT INTO `05diseases` VALUES ('3173', '鼻中隔后缘良性肿瘤', '473', 'D10.653', 'BZGHYLXZL', '');
INSERT INTO `05diseases` VALUES ('3174', '鼻后孔良性肿瘤', '473', 'D10.654', 'BHKLXZL', '');
INSERT INTO `05diseases` VALUES ('3175', '咽下部良性肿瘤', '473', 'D10.751', 'YXBLXZL', '');
INSERT INTO `05diseases` VALUES ('3176', '咽良性肿瘤 NOS', '473', 'D10.901', 'YLXZL', '');
INSERT INTO `05diseases` VALUES ('3177', '咽旁颞下良性肿瘤', '473', 'D10.902', 'YPNXLXZL', '');
INSERT INTO `05diseases` VALUES ('3178', '良性瓦尔代尔扁桃体环', '17', 'D10.951', 'LXWEDEBTTH', '');
INSERT INTO `05diseases` VALUES ('3179', '腮腺良性肿瘤', '473', 'D11.001', 'SXLXZL', '');
INSERT INTO `05diseases` VALUES ('3180', '斯滕森管肋良性肿瘤[腮腺管]', '473', 'D11.051', 'STSGLLXZLSXG', '');
INSERT INTO `05diseases` VALUES ('3181', '颌下腺良性肿瘤', '473', 'D11.701', 'HXXLXZL', '');
INSERT INTO `05diseases` VALUES ('3182', '舌下腺良性肿瘤', '473', 'D11.702', 'SXXLXZL', '');
INSERT INTO `05diseases` VALUES ('3183', '沃顿管良性肿瘤', '473', 'D11.751', 'WDGLXZL', '');
INSERT INTO `05diseases` VALUES ('3184', '大涎腺良性肿瘤 NOS', '473', 'D11.901', 'DXXLXZL', '');
INSERT INTO `05diseases` VALUES ('3185', '盲肠良性肿瘤', '473', 'D12.001', 'MCLXZL', '');
INSERT INTO `05diseases` VALUES ('3186', '回盲瓣良性肿瘤', '473', 'D12.051', 'HMBLXZL', '');
INSERT INTO `05diseases` VALUES ('3187', '阑尾良性肿瘤', '473', 'D12.101', 'LWLXZL', '');
INSERT INTO `05diseases` VALUES ('3188', '升结肠良性肿瘤', '473', 'D12.201', 'SJCLXZL', '');
INSERT INTO `05diseases` VALUES ('3189', '升结肠息肉', '374', 'D12.251', 'SJCXR', '');
INSERT INTO `05diseases` VALUES ('3190', '横结肠良性肿瘤', '473', 'D12.301', 'HJCLXZL', '');
INSERT INTO `05diseases` VALUES ('3191', '结肠肝曲良性肿瘤', '473', 'D12.351', 'JCGQLXZL', '');
INSERT INTO `05diseases` VALUES ('3192', '结肠脾曲良性肿瘤', '473', 'D12.352', 'JCPQLXZL', '');
INSERT INTO `05diseases` VALUES ('3193', '降结肠良性肿瘤', '473', 'D12.401', 'JJCLXZL', '');
INSERT INTO `05diseases` VALUES ('3194', '乙状结肠良性肿瘤', '473', 'D12.501', 'YZJCLXZL', '');
INSERT INTO `05diseases` VALUES ('3195', '家族性息肉病 (M82200/0)', '374', 'D12.601', 'JZXXRB', '');
INSERT INTO `05diseases` VALUES ('3196', '结肠良性肿瘤', '473', 'D12.602', 'JCLXZL', '');
INSERT INTO `05diseases` VALUES ('3197', '结肠腺瘤样息肉病 (M82200/0)', '261', 'D12.603', 'JCXLYXRB', '');
INSERT INTO `05diseases` VALUES ('3198', '结肠腺瘤样息肉', '261', 'D12.651', 'JCXLYXR', '');
INSERT INTO `05diseases` VALUES ('3199', '大肠良性肿瘤', '473', 'D12.652', 'DCLXZL', '');
INSERT INTO `05diseases` VALUES ('3200', '遗传性结肠息肉病', '374', 'D12.653', 'YCXJCXRB', '');
INSERT INTO `05diseases` VALUES ('3201', '直肠乙状结肠连结处良性肿瘤', '473', 'D12.751', 'ZCYZJCLJCLXZL', '');
INSERT INTO `05diseases` VALUES ('3202', '直肠良性肿瘤', '473', 'D12.801', 'ZCLXZL', '');
INSERT INTO `05diseases` VALUES ('3203', '肛门良性肿瘤', '473', 'D12.901', 'GMLXZL', '');
INSERT INTO `05diseases` VALUES ('3204', '莫尔加尼隐窝良性肿瘤', '473', 'D12.951', 'MEJNYWLXZL', '');
INSERT INTO `05diseases` VALUES ('3205', '食管良性肿瘤', '473', 'D13.001', 'SGLXZL', '');
INSERT INTO `05diseases` VALUES ('3206', '贲门良性肿瘤', '473', 'D13.101', 'BMLXZL', '');
INSERT INTO `05diseases` VALUES ('3207', '胃良性肿瘤', '473', 'D13.102', 'WLXZL', '');
INSERT INTO `05diseases` VALUES ('3208', '胃肌腺瘤', '370', 'D13.151', 'WJXL', '');
INSERT INTO `05diseases` VALUES ('3209', '十二指肠良性肿瘤', '473', 'D13.201', 'SEZCLXZL', '');
INSERT INTO `05diseases` VALUES ('3211', '小肠良性肿瘤', '473', 'D13.301', 'XCLXZL', '');
INSERT INTO `05diseases` VALUES ('3212', '麦克尔憩息良性肿瘤', '473', 'D13.351', 'MKEQXLXZL', '');
INSERT INTO `05diseases` VALUES ('3213', '肝良性肿瘤', '473', 'D13.401', 'GLXZL', '');
INSERT INTO `05diseases` VALUES ('3214', '肝胆管良性肿瘤', '473', 'D13.451', 'GDGLXZL', '');
INSERT INTO `05diseases` VALUES ('3215', '肝内胆管腺瘤', '53', 'D13.452', 'GNDGXL', '');
INSERT INTO `05diseases` VALUES ('3216', '胆管良性肿瘤', '473', 'D13.501', 'DGLXZL', '');
INSERT INTO `05diseases` VALUES ('3217', '胆囊良性肿瘤', '473', 'D13.502', 'DNLXZL', '');
INSERT INTO `05diseases` VALUES ('3218', '法特氏壶腹良性肿瘤', '473', 'D13.503', 'FTSHFLXZL', '');
INSERT INTO `05diseases` VALUES ('3219', '肝外胆管良性肿瘤', '473', 'D13.551', 'GWDGLXZL', '');
INSERT INTO `05diseases` VALUES ('3220', '胆囊腺瘤样息肉', '53', 'D13.552', 'DNXLYXR', '');
INSERT INTO `05diseases` VALUES ('3221', '胰腺良性肿瘤', '473', 'D13.601', 'YXLXZL', '');
INSERT INTO `05diseases` VALUES ('3222', '胰管良性肿瘤(圣托理尼)(维尔松)', '473', 'D13.651', 'YGLXZLSTLNWES', '');
INSERT INTO `05diseases` VALUES ('3223', '高血糖素瘤 (M81520/0)', '261', 'D13.701', 'GXTSL', '');
INSERT INTO `05diseases` VALUES ('3224', '胰岛良性肿瘤', '473', 'D13.702', 'YDLXZL', '');
INSERT INTO `05diseases` VALUES ('3225', '胰岛素瘤 (M81510/0)', '261', 'D13.703', 'YDSL', '');
INSERT INTO `05diseases` VALUES ('3226', '胰岛细胞瘤 (M81510/0)', '377', 'D13.704', 'YDXBL', '');
INSERT INTO `05diseases` VALUES ('3227', '胰岛细胞腺瘤 (M81510/0)', '261', 'D13.705', 'YDXBXL', '');
INSERT INTO `05diseases` VALUES ('3228', '腹泻性胰岛细胞瘤[舒血管肠肽瘤水泻低血钾胃酸综合征或胰霍乱]', '140', 'D13.751', 'FXXYDXBLSXGCTLSXDXJW', '');
INSERT INTO `05diseases` VALUES ('3229', '良性高血糖素瘤', '261', 'D13.752', 'LXGXTSL', '');
INSERT INTO `05diseases` VALUES ('3230', '朗格汉斯胰岛良性肿瘤', '473', 'D13.753', 'LGHSYDLXZL', '');
INSERT INTO `05diseases` VALUES ('3231', '消化系统良性肿瘤 NOS', '473', 'D13.951', 'XHXTLXZL', '');
INSERT INTO `05diseases` VALUES ('3232', '脾皮样囊肿', '253', 'D13.952', 'PPYNZ', '');
INSERT INTO `05diseases` VALUES ('3233', '肠道良性肿瘤 NOS', '473', 'D13.953', 'CDLXZL', '');
INSERT INTO `05diseases` VALUES ('3234', '鼻窦良性肿瘤', '473', 'D14.001', 'BDLXZL', '');
INSERT INTO `05diseases` VALUES ('3235', '鼻前庭良性肿瘤', '473', 'D14.002', 'BQTLXZL', '');
INSERT INTO `05diseases` VALUES ('3236', '鼻腔良性肿瘤', '473', 'D14.003', 'BQLXZL', '');
INSERT INTO `05diseases` VALUES ('3237', '鼻中隔良性肿瘤', '473', 'D14.004', 'BZGLXZL', '');
INSERT INTO `05diseases` VALUES ('3238', '额窦良性肿瘤', '473', 'D14.005', 'EDLXZL', '');
INSERT INTO `05diseases` VALUES ('3239', '筛窦良性肿瘤', '473', 'D14.006', 'SDLXZL', '');
INSERT INTO `05diseases` VALUES ('3240', '上颌窦[海默尔]良性肿瘤', '473', 'D14.007', 'SHDHMELXZL', '');
INSERT INTO `05diseases` VALUES ('3241', '中耳良性肿瘤', '473', 'D14.008', 'ZELXZL', '');
INSERT INTO `05diseases` VALUES ('3242', '鼻腺瘤性息肉', '16', 'D14.051', 'BXLXXR', '');
INSERT INTO `05diseases` VALUES ('3243', '施奈德乳头状瘤 NOS (M80500/0)', '86', 'D14.052', 'SNDRTZL', '');
INSERT INTO `05diseases` VALUES ('3244', '副鼻窦良性肿瘤', '473', 'D14.053', 'FBDLXZL', '');
INSERT INTO `05diseases` VALUES ('3245', '喉良性肿瘤', '473', 'D14.101', 'HLXZL', '');
INSERT INTO `05diseases` VALUES ('3246', '会厌良性肿瘤', '473', 'D14.102', 'HYLXZL', '');
INSERT INTO `05diseases` VALUES ('3247', '声带良性肿瘤', '473', 'D14.103', 'SDLXZL', '');
INSERT INTO `05diseases` VALUES ('3248', '声门下良性肿瘤', '473', 'D14.151', 'SMXLXZL', '');
INSERT INTO `05diseases` VALUES ('3249', '气管良性肿瘤', '473', 'D14.201', 'QGLXZL', '');
INSERT INTO `05diseases` VALUES ('3250', '肺良性肿瘤', '473', 'D14.301', 'FLXZL', '');
INSERT INTO `05diseases` VALUES ('3251', '主支气管良性肿瘤', '473', 'D14.302', 'ZZQGLXZL', '');
INSERT INTO `05diseases` VALUES ('3252', '主支气管旁良性肿瘤', '473', 'D14.303', 'ZZQGPLXZL', '');
INSERT INTO `05diseases` VALUES ('3253', '支气管良性肿瘤', '473', 'D14.351', 'ZQGLXZL', '');
INSERT INTO `05diseases` VALUES ('3254', '呼吸系统良性肿瘤 NOS', '473', 'D14.451', 'HXXTLXZL', '');
INSERT INTO `05diseases` VALUES ('3255', '胸腺良性肿瘤 (M85800/0)', '473', 'D15.001', 'XXLXZL', '');
INSERT INTO `05diseases` VALUES ('3256', '心房良性肿瘤', '473', 'D15.101', 'XFLXZL', '');
INSERT INTO `05diseases` VALUES ('3257', '心脏良性肿瘤', '473', 'D15.102', 'XZLXZL', '');
INSERT INTO `05diseases` VALUES ('3258', '心房粘液瘤', '403', 'D15.151', 'XFNYL', '');
INSERT INTO `05diseases` VALUES ('3259', '心肌良性肿瘤', '473', 'D15.152', 'XJLXZL', '');
INSERT INTO `05diseases` VALUES ('3260', '心内膜良性肿瘤', '473', 'D15.153', 'XNMLXZL', '');
INSERT INTO `05diseases` VALUES ('3261', '后纵隔良性肿瘤', '473', 'D15.201', 'HZGLXZL', '');
INSERT INTO `05diseases` VALUES ('3262', '前纵隔良性肿瘤', '473', 'D15.202', 'QZGLXZL', '');
INSERT INTO `05diseases` VALUES ('3263', '纵隔良性肿瘤', '473', 'D15.203', 'ZGLXZL', '');
INSERT INTO `05diseases` VALUES ('3264', '纵隔良性畸胎瘤', '261', 'D15.251', 'ZGLXJTL', '');
INSERT INTO `05diseases` VALUES ('3265', '胸膜良性肿瘤', '473', 'D15.701', 'XMLXZL', '');
INSERT INTO `05diseases` VALUES ('3266', '胸壁良性肿瘤', '473', 'D15.751', 'XBLXZL', '');
INSERT INTO `05diseases` VALUES ('3267', '胸腔内器官良性肿瘤 NOS', '473', 'D15.951', 'XQNQGLXZL', '');
INSERT INTO `05diseases` VALUES ('3268', '肱骨良性肿瘤', '473', 'D16.001', 'GGLXZL', '');
INSERT INTO `05diseases` VALUES ('3269', '肩胛骨良性肿瘤', '473', 'D16.002', 'JJGLXZL', '');
INSERT INTO `05diseases` VALUES ('3270', '桡(尺)骨良性肿瘤', '473', 'D16.003', 'RCGLXZL', '');
INSERT INTO `05diseases` VALUES ('3271', '桡骨良性肿瘤', '473', 'D16.004', 'RGLXZL', '');
INSERT INTO `05diseases` VALUES ('3272', '上肢长骨良性肿瘤', '473', 'D16.005', 'SZCGLXZL', '');
INSERT INTO `05diseases` VALUES ('3273', '肱骨骨软骨瘤', '301', 'D16.051', 'GGGRGL', '');
INSERT INTO `05diseases` VALUES ('3274', '尺骨良性肿瘤', '473', 'D16.052', 'CGLXZL', '');
INSERT INTO `05diseases` VALUES ('3275', '上肢短骨良性肿瘤', '473', 'D16.101', 'SZDGLXZL', '');
INSERT INTO `05diseases` VALUES ('3276', '上肢关节良性肿瘤', '473', 'D16.102', 'SZGJLXZL', '');
INSERT INTO `05diseases` VALUES ('3277', '掌骨良性肿瘤', '473', 'D16.103', 'ZGLXZL', '');
INSERT INTO `05diseases` VALUES ('3278', '指骨良性肿瘤', '473', 'D16.104', 'ZGLXZL', '');
INSERT INTO `05diseases` VALUES ('3279', '腕骨良性肿瘤', '473', 'D16.151', 'WGLXZL', '');
INSERT INTO `05diseases` VALUES ('3280', '腓骨良性肿瘤', '473', 'D16.201', 'FGLXZL', '');
INSERT INTO `05diseases` VALUES ('3281', '股骨良性肿瘤', '473', 'D16.202', 'GGLXZL', '');
INSERT INTO `05diseases` VALUES ('3282', '胫骨良性肿瘤', '473', 'D16.203', 'JGLXZL', '');
INSERT INTO `05diseases` VALUES ('3283', '下肢骨良性肿瘤', '473', 'D16.204', 'XZGLXZL', '');
INSERT INTO `05diseases` VALUES ('3284', '胫骨骨母细胞瘤', '377', 'D16.251', 'JGGMXBL', '');
INSERT INTO `05diseases` VALUES ('3285', '跟骨良性肿瘤', '473', 'D16.301', 'GGLXZL', '');
INSERT INTO `05diseases` VALUES ('3286', '踝骨良性肿瘤', '473', 'D16.302', 'HGLXZL', '');
INSERT INTO `05diseases` VALUES ('3287', '距骨良性肿瘤', '473', 'D16.303', 'JGLXZL', '');
INSERT INTO `05diseases` VALUES ('3288', '膝关节良性肿瘤', '473', 'D16.304', 'XGJLXZL', '');
INSERT INTO `05diseases` VALUES ('3289', '下肢短骨良性肿瘤', '473', 'D16.305', 'XZDGLXZL', '');
INSERT INTO `05diseases` VALUES ('3290', '下肢关节良性肿瘤', '473', 'D16.306', 'XZGJLXZL', '');
INSERT INTO `05diseases` VALUES ('3291', '趾骨良性肿瘤', '473', 'D16.307', 'ZGLXZL', '');
INSERT INTO `05diseases` VALUES ('3292', '足骨良性肿瘤', '473', 'D16.351', 'ZGLXZL', '');
INSERT INTO `05diseases` VALUES ('3293', '踝软骨瘤', '301', 'D16.352', 'HRGL', '');
INSERT INTO `05diseases` VALUES ('3294', '鼻骨良性肿瘤', '473', 'D16.401', 'BGLXZL', '');
INSERT INTO `05diseases` VALUES ('3295', '顶骨良性肿瘤', '473', 'D16.402', 'DGLXZL', '');
INSERT INTO `05diseases` VALUES ('3296', '额骨良性肿瘤', '473', 'D16.403', 'EGLXZL', '');
INSERT INTO `05diseases` VALUES ('3297', '颅骨良性肿瘤', '473', 'D16.404', 'LGLXZL', '');
INSERT INTO `05diseases` VALUES ('3298', '面骨良性肿瘤', '473', 'D16.405', 'MGLXZL', '');
INSERT INTO `05diseases` VALUES ('3299', '颞骨良性肿瘤', '473', 'D16.406', 'NGLXZL', '');
INSERT INTO `05diseases` VALUES ('3300', '颧骨良性肿瘤', '473', 'D16.407', 'QGLXZL', '');
INSERT INTO `05diseases` VALUES ('3301', '乳突骨良性肿瘤', '473', 'D16.408', 'RTGLXZL', '');
INSERT INTO `05diseases` VALUES ('3302', '筛骨良性肿瘤', '473', 'D16.409', 'SGLXZL', '');
INSERT INTO `05diseases` VALUES ('3303', '上颌骨良性肿瘤', '473', 'D16.410', 'SHGLXZL', '');
INSERT INTO `05diseases` VALUES ('3304', '枕骨良性肿瘤', '473', 'D16.411', 'ZGLXZL', '');
INSERT INTO `05diseases` VALUES ('3305', '眶骨良性肿瘤', '473', 'D16.451', 'KGLXZL', '');
INSERT INTO `05diseases` VALUES ('3306', '下颌骨良性肿瘤', '473', 'D16.501', 'XHGLXZL', '');
INSERT INTO `05diseases` VALUES ('3307', '牙瘤 (M92800/0)', '425', 'D16.502', 'YL', '');
INSERT INTO `05diseases` VALUES ('3308', '脊柱良性肿瘤', '473', 'D16.601', 'JZLXZL', '');
INSERT INTO `05diseases` VALUES ('3309', '胸、腰椎管良性肿瘤', '473', 'D16.651', 'XYZGLXZL', '');
INSERT INTO `05diseases` VALUES ('3310', '椎骨良性肿瘤', '473', 'D16.652', 'ZGLXZL', '');
INSERT INTO `05diseases` VALUES ('3311', '椎管良性肿瘤', '473', 'D16.653', 'ZGLXZL', '');
INSERT INTO `05diseases` VALUES ('3312', '骶、尾椎管良性肿瘤', '473', 'D16.654', 'DWZGLXZL', '');
INSERT INTO `05diseases` VALUES ('3313', '肋骨良性肿瘤', '473', 'D16.701', 'LGLXZL', '');
INSERT INTO `05diseases` VALUES ('3314', '胸骨良性肿瘤', '473', 'D16.702', 'XGLXZL', '');
INSERT INTO `05diseases` VALUES ('3315', '胸骨骨软骨瘤', '301', 'D16.751', 'XGGRGL', '');
INSERT INTO `05diseases` VALUES ('3316', '锁骨良性肿瘤', '473', 'D16.752', 'SGLXZL', '');
INSERT INTO `05diseases` VALUES ('3317', '耻骨良性肿瘤', '473', 'D16.801', 'CGLXZL', '');
INSERT INTO `05diseases` VALUES ('3318', '骶骨良性肿瘤', '473', 'D16.802', 'DGLXZL', '');
INSERT INTO `05diseases` VALUES ('3319', '髋骨良性肿瘤', '473', 'D16.803', 'KGLXZL', '');
INSERT INTO `05diseases` VALUES ('3320', '髂骨良性肿瘤', '473', 'D16.804', 'QGLXZL', '');
INSERT INTO `05diseases` VALUES ('3321', '坐骨良性肿瘤', '473', 'D16.805', 'ZGLXZL', '');
INSERT INTO `05diseases` VALUES ('3322', '骨盆骨良性肿瘤', '473', 'D16.851', 'GPGLXZL', '');
INSERT INTO `05diseases` VALUES ('3323', '尾骨良性肿瘤', '473', 'D16.852', 'WGLXZL', '');
INSERT INTO `05diseases` VALUES ('3324', '骨和关节软骨良性肿瘤 NOS', '473', 'D16.901', 'GHGJRGLXZL', '');
INSERT INTO `05diseases` VALUES ('3325', '骨样骨瘤', '301', 'D16.951', 'GYGL', '');
INSERT INTO `05diseases` VALUES ('3326', '软骨瘤 NOS', '301', 'D16.952', 'RGL', '');
INSERT INTO `05diseases` VALUES ('3327', '颌下腺脂肪瘤 (M88500/0)', '467', 'D17.001', 'HXXZFL', '');
INSERT INTO `05diseases` VALUES ('3328', '头.面.颈部脂肪瘤 (M88500/0)', '467', 'D17.002', 'TMGBZFL', '');
INSERT INTO `05diseases` VALUES ('3329', '头部皮肤和皮下组织脂肪瘤样良性肿瘤', '473', 'D17.051', 'TBPFHPXZZZFLYLXZL', '');
INSERT INTO `05diseases` VALUES ('3330', '面部皮肤和皮下组织脂肪瘤样良性肿瘤', '473', 'D17.052', 'MBPFHPXZZZFLYLXZL', '');
INSERT INTO `05diseases` VALUES ('3331', '颈部皮肤和皮下组织脂肪瘤样良性肿瘤', '473', 'D17.053', 'GBPFHPXZZZFLYLXZL', '');
INSERT INTO `05diseases` VALUES ('3332', '躯干脂肪瘤 (M88500/0)', '467', 'D17.101', 'QGZFL', '');
INSERT INTO `05diseases` VALUES ('3333', '乳房(腺)脂肪瘤 (M88500/0)', '86', 'D17.102', 'RFXZFL', '');
INSERT INTO `05diseases` VALUES ('3334', '躯干皮肤和皮下组织脂肪瘤样良性肿瘤', '473', 'D17.151', 'QGPFHPXZZZFLYLXZL', '');
INSERT INTO `05diseases` VALUES ('3335', '肢体脂肪瘤 (M88500/0)', '467', 'D17.201', 'ZTZFL', '');
INSERT INTO `05diseases` VALUES ('3336', '肩部脂肪瘤 (M88500/0)', '467', 'D17.251', 'JBZFL', '');
INSERT INTO `05diseases` VALUES ('3337', '四肢皮肤和皮下组织脂肪瘤样良性肿瘤', '473', 'D17.252', 'SZPFHPXZZZFLYLXZL', '');
INSERT INTO `05diseases` VALUES ('3338', '大阴唇脂肪瘤 (M88500/0)', '467', 'D17.301', 'DYCZFL', '');
INSERT INTO `05diseases` VALUES ('3339', '其他和未特指部位皮肤和皮下组织脂肪瘤样良性肿瘤', '473', 'D17.351', 'QTHWTZBWPFHPXZZZFLYL', '');
INSERT INTO `05diseases` VALUES ('3340', '纵隔脂肪瘤 (M88500/0)', '467', 'D17.401', 'ZGZFL', '');
INSERT INTO `05diseases` VALUES ('3341', '胸腔内器官脂肪瘤样良性肿瘤', '473', 'D17.451', 'XQNQGZFLYLXZL', '');
INSERT INTO `05diseases` VALUES ('3342', '肠系膜脂肪瘤 (M88500/0)', '467', 'D17.501', 'CXMZFL', '');
INSERT INTO `05diseases` VALUES ('3343', '肠纤维脂肪瘤 (M88510/0)', '467', 'D17.502', 'CXWZFL', '');
INSERT INTO `05diseases` VALUES ('3344', '肠脂肪瘤 (M88500/0)', '467', 'D17.503', 'CZFL', '');
INSERT INTO `05diseases` VALUES ('3345', '腹腔脂肪瘤 (M88500/0)', '467', 'D17.504', 'FQZFL', '');
INSERT INTO `05diseases` VALUES ('3346', '盆腔脂肪瘤 (M88500/0)', '467', 'D17.505', 'PQZFL', '');
INSERT INTO `05diseases` VALUES ('3347', '腹腔内器官脂肪瘤样良性肿瘤', '473', 'D17.551', 'FQNQGZFLYLXZL', '');
INSERT INTO `05diseases` VALUES ('3348', '精索脂肪瘤 (M88500/0)', '467', 'D17.601', 'JSZFL', '');
INSERT INTO `05diseases` VALUES ('3349', '精索脂肪瘤样良性肿瘤', '473', 'D17.651', 'JSZFLYLXZL', '');
INSERT INTO `05diseases` VALUES ('3350', '鞍区脂肪瘤 (M88500/0)', '467', 'D17.701', 'AQZFL', '');
INSERT INTO `05diseases` VALUES ('3351', '腹膜后脂肪瘤 (M88500/0)', '467', 'D17.702', 'FMHZFL', '');
INSERT INTO `05diseases` VALUES ('3352', '喉脂肪瘤 (M88500/0)', '133', 'D17.703', 'HZFL', '');
INSERT INTO `05diseases` VALUES ('3353', '脊髓圆椎脂肪瘤 (M88500/0)', '467', 'D17.704', 'JSYZZFL', '');
INSERT INTO `05diseases` VALUES ('3354', '结膜脂肪瘤 (M88500/0)', '467', 'D17.705', 'JMZFL', '');
INSERT INTO `05diseases` VALUES ('3355', '梨状窝脂肪瘤 (M88500/0)', '467', 'D17.706', 'LZWZFL', '');
INSERT INTO `05diseases` VALUES ('3356', '颅骨脂肪瘤 (M88500/0)', '467', 'D17.707', 'LGZFL', '');
INSERT INTO `05diseases` VALUES ('3357', '神经系统脂肪瘤 (M88500/0)', '313', 'D17.708', 'SJXTZFL', '');
INSERT INTO `05diseases` VALUES ('3358', '肾上腺脂肪瘤 (M88500/0)', '467', 'D17.709', 'SSXZFL', '');
INSERT INTO `05diseases` VALUES ('3359', '硬膜内脂肪瘤 (M88500/0)', '467', 'D17.710', 'YMNZFL', '');
INSERT INTO `05diseases` VALUES ('3360', '硬膜外脂肪瘤 (M88500/0)', '467', 'D17.711', 'YMWZFL', '');
INSERT INTO `05diseases` VALUES ('3361', '腹膜及腹膜后脂肪瘤样良性肿瘤', '473', 'D17.751', 'FMJFMHZFLYLXZL', '');
INSERT INTO `05diseases` VALUES ('3362', '腹膜后脂肪瘤样良性肿瘤', '473', 'D17.752', 'FMHZFLYLXZL', '');
INSERT INTO `05diseases` VALUES ('3363', '骨髓脂肪瘤 (M88700/0)', '467', 'D17.753', 'GSZFL', '');
INSERT INTO `05diseases` VALUES ('3364', '肾血管肌脂肪瘤 (M88600/0)', '467', 'D17.754', 'SXGJZFL', '');
INSERT INTO `05diseases` VALUES ('3365', '多发性脂肪瘤 (M88500/0)', '467', 'D17.901', 'DFXZFL', '');
INSERT INTO `05diseases` VALUES ('3366', '纤维脂肪瘤 (M88510/0)', '467', 'D17.951', 'XWZFL', '');
INSERT INTO `05diseases` VALUES ('3367', '血管脂肪瘤 (M88610/0)', '467', 'D17.952', 'XGZFL', '');
INSERT INTO `05diseases` VALUES ('3368', '粘液脂肪瘤 (M88520/0)', '467', 'D17.953', 'NYZFL', '');
INSERT INTO `05diseases` VALUES ('3369', '蛰伏脂肪瘤 (M88800/0)', '467', 'D17.954', 'ZFZFL', '');
INSERT INTO `05diseases` VALUES ('3370', '脂肪瘤 (M88500/0) NOS', '467', 'D17.955', 'ZFL', '');
INSERT INTO `05diseases` VALUES ('3371', '肌脂肪瘤 NOS (M88500/0)', '467', 'D17.956', 'JZFL', '');
INSERT INTO `05diseases` VALUES ('3372', '布朗脂肪瘤 (M88800/0)', '467', 'D17.957', 'BLZFL', '');
INSERT INTO `05diseases` VALUES ('3373', '成脂细胞瘤[脂母细胞瘤] (M88810/0)', '377', 'D17.958', 'CZXBLZMXBL', '');
INSERT INTO `05diseases` VALUES ('3374', '贲门血管瘤 (M91200/0)', '414', 'D18.001', 'BMXGL', '');
INSERT INTO `05diseases` VALUES ('3375', '鼻背血管瘤 (M91200/0)', '16', 'D18.002', 'BBXGL', '');
INSERT INTO `05diseases` VALUES ('3376', '鼻窦血管瘤 (M91200/0)', '16', 'D18.003', 'BDXGL', '');
INSERT INTO `05diseases` VALUES ('3377', '鼻腔血管瘤 (M91200/0)', '16', 'D18.004', 'BQXGL', '');
INSERT INTO `05diseases` VALUES ('3378', '鼻血管瘤 (M91200/0)', '16', 'D18.005', 'BXGL', '');
INSERT INTO `05diseases` VALUES ('3379', '鼻咽部血管瘤 (M91200/0)', '16', 'D18.006', 'BYBXGL', '');
INSERT INTO `05diseases` VALUES ('3380', '肠系膜血管瘤 (M91200/0)', '414', 'D18.007', 'CXMXGL', '');
INSERT INTO `05diseases` VALUES ('3381', '肠血管瘤 (M91200/0)', '414', 'D18.008', 'CXGL', '');
INSERT INTO `05diseases` VALUES ('3382', '唇血管瘤 (M91200/0)', '414', 'D18.009', 'CXGL', '');
INSERT INTO `05diseases` VALUES ('3383', '丛状血管瘤 (M91200/0)', '414', 'D18.010', 'CZXGL', '');
INSERT INTO `05diseases` VALUES ('3384', '大肠血管瘤 (M91200/0)', '414', 'D18.011', 'DCXGL', '');
INSERT INTO `05diseases` VALUES ('3385', '耳道血管瘤 (M91200/0)', '70', 'D18.012', 'EDXGL', '');
INSERT INTO `05diseases` VALUES ('3386', '肺血管瘤 (M91200/0)', '79', 'D18.013', 'FXGL', '');
INSERT INTO `05diseases` VALUES ('3387', '腹壁血管瘤 (M91200/0)', '414', 'D18.014', 'FBXGL', '');
INSERT INTO `05diseases` VALUES ('3388', '腹膜后血管瘤 (M91200/0)', '414', 'D18.015', 'FMHXGL', '');
INSERT INTO `05diseases` VALUES ('3389', '肝血管瘤 (M91200/0)', '92', 'D18.016', 'GXGL', '');
INSERT INTO `05diseases` VALUES ('3390', '骨血管瘤 (M91200/0)', '414', 'D18.018', 'GXGL', '');
INSERT INTO `05diseases` VALUES ('3391', '海绵状血管瘤 (M91210/0)', '414', 'D18.019', 'HMZXGL', '');
INSERT INTO `05diseases` VALUES ('3392', '喉血管瘤 (M91200/0)', '133', 'D18.020', 'HXGL', '');
INSERT INTO `05diseases` VALUES ('3393', '肌内血管瘤 (M91320/0)', '414', 'D18.021', 'JNXGL', '');
INSERT INTO `05diseases` VALUES ('3394', '脊椎血管瘤 (M91200/0)', '414', 'D18.022', 'JZXGL', '');
INSERT INTO `05diseases` VALUES ('3395', '颊部血管瘤 (M91200/0)', '414', 'D18.023', 'JBXGL', '');
INSERT INTO `05diseases` VALUES ('3396', '结膜海绵状血管瘤 (M91210/0)', '414', 'D18.024', 'JMHMZXGL', '');
INSERT INTO `05diseases` VALUES ('3397', '颈部血管瘤 (M91200/0)', '414', 'D18.025', 'GBXGL', '');
INSERT INTO `05diseases` VALUES ('3398', '静脉性血管瘤 (M91220/0)', '414', 'D18.026', 'JMXXGL', '');
INSERT INTO `05diseases` VALUES ('3399', '口腔血管瘤 (M91200/0)', '414', 'D18.028', 'KQXGL', '');
INSERT INTO `05diseases` VALUES ('3400', '眶内血管瘤 (M91200/0)', '414', 'D18.029', 'KNXGL', '');
INSERT INTO `05diseases` VALUES ('3401', '良性血管内皮瘤 (M91300/0)', '251', 'D18.030', 'LXXGNPL', '');
INSERT INTO `05diseases` VALUES ('3402', '颅内血管瘤 (M91200/0)', '414', 'D18.031', 'LNXGL', '');
INSERT INTO `05diseases` VALUES ('3403', '脉络膜血管瘤 (M91200/0)', '414', 'D18.032', 'MLMXGL', '');
INSERT INTO `05diseases` VALUES ('3404', '蔓状血管瘤 (M91230/0)', '414', 'D18.033', 'MZXGL', '');
INSERT INTO `05diseases` VALUES ('3405', '毛细血管性血管瘤 (M91310/0)', '414', 'D18.034', 'MXXGXXGL', '');
INSERT INTO `05diseases` VALUES ('3406', '脑血管瘤 (M91200/0)', '233', 'D18.035', 'NXGL', '');
INSERT INTO `05diseases` VALUES ('3407', '尿道口血管瘤 (M91200/0)', '237', 'D18.036', 'NDKXGL', '');
INSERT INTO `05diseases` VALUES ('3408', '皮肤血管球瘤 (M91200/0)', '250', 'D18.037', 'PFXGQL', '');
INSERT INTO `05diseases` VALUES ('3409', '脾血管瘤 (M91200/0)', '253', 'D18.038', 'PXGL', '');
INSERT INTO `05diseases` VALUES ('3410', '其他特指部位血管瘤 (M91200/0)', '414', 'D18.039', 'QTTZBWXGL', '');
INSERT INTO `05diseases` VALUES ('3411', '眼球后血管瘤 (M91200/0)', '430', 'D18.040', 'YQHXGL', '');
INSERT INTO `05diseases` VALUES ('3412', '躯干血管瘤 (M91200/0)', '414', 'D18.041', 'QGXGL', '');
INSERT INTO `05diseases` VALUES ('3413', '腮腺血管瘤 (M91200/0)', '414', 'D18.042', 'SXXGL', '');
INSERT INTO `05diseases` VALUES ('3414', '舌口涎腺血管瘤 (M91200/0)', '414', 'D18.043', 'SKXXXGL', '');
INSERT INTO `05diseases` VALUES ('3415', '舌血管瘤 (M91200/0)', '414', 'D18.044', 'SXGL', '');
INSERT INTO `05diseases` VALUES ('3416', '肾上腺血管瘤 (M91200/0)', '414', 'D18.045', 'SSXXGL', '');
INSERT INTO `05diseases` VALUES ('3417', '肾血管瘤 (M91200/0)', '414', 'D18.046', 'SXGL', '');
INSERT INTO `05diseases` VALUES ('3418', '食道血管瘤 (M91200/0)', '414', 'D18.047', 'SDXGL', '');
INSERT INTO `05diseases` VALUES ('3419', '肢体血管瘤 (M91200/0)', '414', 'D18.048', 'ZTXGL', '');
INSERT INTO `05diseases` VALUES ('3420', '头、面、颈血管瘤 (M91200/0)', '414', 'D18.049', 'TMGXGL', '');
INSERT INTO `05diseases` VALUES ('3421', '头面血管瘤 (M91200/0)', '414', 'D18.050', 'TMXGL', '');
INSERT INTO `05diseases` VALUES ('3422', '外阴血管瘤 (M91200/0)', '367', 'D18.051', 'WYXGL', '');
INSERT INTO `05diseases` VALUES ('3423', '小肠血管瘤 (M91200/0)', '414', 'D18.052', 'XCXGL', '');
INSERT INTO `05diseases` VALUES ('3424', '血管瘤 (M91200/0))', '414', 'D18.053', 'XGL', '');
INSERT INTO `05diseases` VALUES ('3425', '咽、喉、鼻腔血管瘤 (M91200/0)', '133', 'D18.054', 'YHBQXGL', '');
INSERT INTO `05diseases` VALUES ('3426', '咽部血管瘤 (M91200/0)', '414', 'D18.055', 'YBXGL', '');
INSERT INTO `05diseases` VALUES ('3427', '胰腺血管瘤 (M91200/0)', '262', 'D18.056', 'YXXGL', '');
INSERT INTO `05diseases` VALUES ('3428', '硬膜外血管瘤 (M91200/0)', '414', 'D18.057', 'YMWXGL', '');
INSERT INTO `05diseases` VALUES ('3429', '椎管内血管瘤 (M91200/0)', '414', 'D18.058', 'ZGNXGL', '');
INSERT INTO `05diseases` VALUES ('3430', '纵隔血管瘤 (M91200/0)', '414', 'D18.059', 'ZGXGL', '');
INSERT INTO `05diseases` VALUES ('3431', '血管球瘤 (M87110/0)', '261', 'D18.060', 'XGQL', '');
INSERT INTO `05diseases` VALUES ('3432', '胃壁血管瘤 (M91200/0)', '370', 'D18.061', 'WBXGL', '');
INSERT INTO `05diseases` VALUES ('3433', '额部海绵状血管瘤 (M91210/0)', '414', 'D18.062', 'EBHMZXGL', '');
INSERT INTO `05diseases` VALUES ('3434', '肝海绵状血管瘤 (M91210/0)', '92', 'D18.063', 'GHMZXGL', '');
INSERT INTO `05diseases` VALUES ('3435', '脑室血管瘤 (M91200/0)', '234', 'D18.064', 'NSXGL', '');
INSERT INTO `05diseases` VALUES ('3436', '肠系膜淋巴管瘤 (M91700/0)', '203', 'D18.101', 'CXMLBGL', '');
INSERT INTO `05diseases` VALUES ('3437', '腹膜后淋巴管瘤 (M91700/0)', '203', 'D18.102', 'FMHLBGL', '');
INSERT INTO `05diseases` VALUES ('3438', '海绵状淋巴管瘤 (M91720/0)', '203', 'D18.103', 'HMZLBGL', '');
INSERT INTO `05diseases` VALUES ('3439', '口腔内淋巴管瘤 (M91700/0)', '203', 'D18.104', 'KQNLBGL', '');
INSERT INTO `05diseases` VALUES ('3440', '淋巴管肌瘤 (M91740/0)', '261', 'D18.105', 'LBGJL', '');
INSERT INTO `05diseases` VALUES ('3441', '淋巴管瘤 (M91700/0)', '203', 'D18.106', 'LBGL', '');
INSERT INTO `05diseases` VALUES ('3442', '囊性淋巴管瘤 (M91730/0)', '203', 'D18.107', 'NXLBGL', '');
INSERT INTO `05diseases` VALUES ('3443', '颞枕硬膜下淋巴管瘤 (M91700/0)', '203', 'D18.108', 'NZYMXLBGL', '');
INSERT INTO `05diseases` VALUES ('3444', '躯干淋巴管瘤 (M91700/0)', '203', 'D18.109', 'QGLBGL', '');
INSERT INTO `05diseases` VALUES ('3445', '腮腺淋巴管瘤 (M91700/0)', '203', 'D18.110', 'SXLBGL', '');
INSERT INTO `05diseases` VALUES ('3446', '舌淋巴管瘤 (M91700/0)', '203', 'D18.111', 'SLBGL', '');
INSERT INTO `05diseases` VALUES ('3447', '四肢淋巴管瘤 (M91700/0)', '203', 'D18.112', 'SZLBGL', '');
INSERT INTO `05diseases` VALUES ('3448', '头、面、颈部淋巴管瘤 (M91700/0)', '203', 'D18.113', 'TMGBLBGL', '');
INSERT INTO `05diseases` VALUES ('3449', '血管淋巴管瘤 (M91750/0)', '203', 'D18.114', 'XGLBGL', '');
INSERT INTO `05diseases` VALUES ('3450', '纵隔淋巴管瘤 (M91700/0)', '203', 'D18.115', 'ZGLBGL', '');
INSERT INTO `05diseases` VALUES ('3451', '水囊瘤 (M91730/0)', '261', 'D18.151', 'SNL', '');
INSERT INTO `05diseases` VALUES ('3452', '空肠浆膜下淋巴管瘤 (M91700/0)', '203', 'D18.153', 'KCJMXLBGL', '');
INSERT INTO `05diseases` VALUES ('3453', '胸腹良性间皮瘤 (M90520/0)', '251', 'D19.051', 'XFLXJPL', '');
INSERT INTO `05diseases` VALUES ('3454', '腹膜良性间皮瘤 (M90520/0)', '251', 'D19.151', 'FMLXJPL', '');
INSERT INTO `05diseases` VALUES ('3455', '其他部位的良性间皮瘤 (M90520/0)', '251', 'D19.751', 'QTBWDLXJPL', '');
INSERT INTO `05diseases` VALUES ('3456', '良性间皮瘤 NOS (M90520/0)', '251', 'D19.951', 'LXJPL', '');
INSERT INTO `05diseases` VALUES ('3457', '腹膜后良性肿瘤', '473', 'D20.001', 'FMHLXZL', '');
INSERT INTO `05diseases` VALUES ('3458', '腹主动脉旁良性肿瘤', '473', 'D20.002', 'FZDMPLXZL', '');
INSERT INTO `05diseases` VALUES ('3459', '肠系膜良性肿瘤', '473', 'D20.101', 'CXMLXZL', '');
INSERT INTO `05diseases` VALUES ('3460', '腹膜良性肿瘤', '473', 'D20.102', 'FMLXZL', '');
INSERT INTO `05diseases` VALUES ('3461', '网膜良性肿瘤', '473', 'D20.103', 'WMLXZL', '');
INSERT INTO `05diseases` VALUES ('3462', '大网膜良性肿瘤', '473', 'D20.151', 'DWMLXZL', '');
INSERT INTO `05diseases` VALUES ('3463', '道格拉斯陷凹或襄良性肿瘤', '473', 'D20.152', 'DGLSXAHXLXZL', '');
INSERT INTO `05diseases` VALUES ('3464', '耳部结缔组织良性肿瘤', '473', 'D21.001', 'EBJDZZLXZL', '');
INSERT INTO `05diseases` VALUES ('3465', '耳软骨良性肿瘤', '473', 'D21.002', 'ERGLXZL', '');
INSERT INTO `05diseases` VALUES ('3466', '耳后皮下良性肿瘤', '473', 'D21.003', 'EHPXLXZL', '');
INSERT INTO `05diseases` VALUES ('3467', '颈部结缔组织良性肿瘤', '473', 'D21.005', 'GBJDZZLXZL', '');
INSERT INTO `05diseases` VALUES ('3468', '面部结缔组织良性肿瘤', '473', 'D21.006', 'MBJDZZLXZL', '');
INSERT INTO `05diseases` VALUES ('3469', '锁骨上结缔组织良性肿瘤', '473', 'D21.007', 'SGSJDZZLXZL', '');
INSERT INTO `05diseases` VALUES ('3470', '头结缔组织良性肿瘤', '473', 'D21.008', 'TJDZZLXZL', '');
INSERT INTO `05diseases` VALUES ('3471', '头面部结缔组织的良性肿瘤', '473', 'D21.009', 'TMBJDZZDLXZL', '');
INSERT INTO `05diseases` VALUES ('3472', '臂结缔组织良性肿瘤', '473', 'D21.101', 'BJDZZLXZL', '');
INSERT INTO `05diseases` VALUES ('3473', '上肢结缔组织良性肿瘤', '473', 'D21.102', 'SZJDZZLXZL', '');
INSERT INTO `05diseases` VALUES ('3474', '肘结缔组织良性肿瘤', '473', 'D21.103', 'ZJDZZLXZL', '');
INSERT INTO `05diseases` VALUES ('3475', '四肢多发性结缔组织良性肿瘤', '473', 'D21.201', 'SZDFXJDZZLXZL', '');
INSERT INTO `05diseases` VALUES ('3476', '足结缔组织良性肿瘤', '473', 'D21.202', 'ZJDZZLXZL', '');
INSERT INTO `05diseases` VALUES ('3477', '股结缔组织良性肿瘤', '473', 'D21.251', 'GJDZZLXZL', '');
INSERT INTO `05diseases` VALUES ('3478', '腘窝结缔组织良性肿瘤', '473', 'D21.252', 'NYJJLJZZ', '');
INSERT INTO `05diseases` VALUES ('3479', '膝关节滑膜良性肿瘤', '473', 'D21.253', 'XGJHMLXZL', '');
INSERT INTO `05diseases` VALUES ('3480', '髋结缔组织良性肿瘤', '473', 'D21.254', 'KJDZZLXZL', '');
INSERT INTO `05diseases` VALUES ('3481', '胸壁结缔组织良性肿瘤', '473', 'D21.301', 'XBJDZZLXZL', '');
INSERT INTO `05diseases` VALUES ('3482', '腋结缔组织良性肿瘤', '473', 'D21.302', 'YJDZZLXZL', '');
INSERT INTO `05diseases` VALUES ('3483', '膈结缔组织良性肿瘤', '473', 'D21.351', 'GJDZZLXZL', '');
INSERT INTO `05diseases` VALUES ('3484', '膈下良性肿瘤', '473', 'D21.352', 'GXLXZL', '');
INSERT INTO `05diseases` VALUES ('3485', '腹部结缔组织良性肿瘤', '473', 'D21.401', 'FBJDZZLXZL', '');
INSERT INTO `05diseases` VALUES ('3486', '骼窝结缔组织良性肿瘤', '473', 'D21.402', 'GWJDZZLXZL', '');
INSERT INTO `05diseases` VALUES ('3487', '髂腰肌结缔组织良性肿瘤', '473', 'D21.403', 'QYJJDZZLXZL', '');
INSERT INTO `05diseases` VALUES ('3488', '腹部韧带纤维瘤', '384', 'D21.451', 'FBRDXWL', '');
INSERT INTO `05diseases` VALUES ('3489', '骶部结缔组织良性肿瘤', '473', 'D21.501', 'DBJDZZLXZL', '');
INSERT INTO `05diseases` VALUES ('3490', '骶前结缔组织良性肿瘤', '473', 'D21.502', 'DQJDZZLXZL', '');
INSERT INTO `05diseases` VALUES ('3491', '腹股沟结缔组织良性肿瘤', '473', 'D21.503', 'FGGJDZZLXZL', '');
INSERT INTO `05diseases` VALUES ('3492', '尿道旁结缔组织良性肿瘤', '473', 'D21.504', 'NDPJDZZLXZL', '');
INSERT INTO `05diseases` VALUES ('3493', '直肠平滑肌瘤', '261', 'D21.551', 'ZCPHJL', '');
INSERT INTO `05diseases` VALUES ('3494', '背部结缔组织良性肿瘤', '473', 'D21.601', 'BBJDZZLXZL', '');
INSERT INTO `05diseases` VALUES ('3495', '躯干结缔组织良性肿瘤', '473', 'D21.602', 'QGJDZZLXZL', '');
INSERT INTO `05diseases` VALUES ('3496', '腰部结缔组织良性肿瘤', '473', 'D21.603', 'YBJDZZLXZL', '');
INSERT INTO `05diseases` VALUES ('3497', '肌肉良性肿瘤', '473', 'D21.901', 'JRLXZL', '');
INSERT INTO `05diseases` VALUES ('3498', '结缔组织良性肿瘤 NOS', '473', 'D21.902', 'JDZZLXZL', '');
INSERT INTO `05diseases` VALUES ('3499', '唇黑色素痣', '470', 'D22.051', 'CHSSZ', '');
INSERT INTO `05diseases` VALUES ('3500', '眼睑黑色素细胞痣', '430', 'D22.151', 'YJHSSXBZ', '');
INSERT INTO `05diseases` VALUES ('3501', '眦黑色素细胞痣', '376', 'D22.152', 'ZHSSXBZ', '');
INSERT INTO `05diseases` VALUES ('3502', '耳黑色素细胞痣', '70', 'D22.251', 'EHSSXBZ', '');
INSERT INTO `05diseases` VALUES ('3503', '外耳道黑色素细胞痣', '70', 'D22.252', 'WEDHSSXBZ', '');
INSERT INTO `05diseases` VALUES ('3504', '鼻皮内痣 (M87500/0)', '16', 'D22.351', 'BPNZ', '');
INSERT INTO `05diseases` VALUES ('3505', '面部黑毛痣 (M87200/0)', '470', 'D22.352', 'MBHMZ', '');
INSERT INTO `05diseases` VALUES ('3506', '面部皮内痣 (M87500/0)', '470', 'D22.353', 'MBPNZ', '');
INSERT INTO `05diseases` VALUES ('3507', '头皮蓝痣 (M87800/0)', '470', 'D22.451', 'TPLZ', '');
INSERT INTO `05diseases` VALUES ('3508', '头部黑色素痣 (M87200/0)', '470', 'D22.452', 'TBHSSZ', '');
INSERT INTO `05diseases` VALUES ('3509', '肛门皮肤黑色素细胞痣 (M87200/0)', '250', 'D22.551', 'GMPFHSSXBZ', '');
INSERT INTO `05diseases` VALUES ('3510', '乳房皮肤黑色素细胞痣 (M87200/0)', '250', 'D22.552', 'RFPFHSSXBZ', '');
INSERT INTO `05diseases` VALUES ('3511', '上肢黑色素细胞痣 (M87200/0)', '376', 'D22.651', 'SZHSSXBZ', '');
INSERT INTO `05diseases` VALUES ('3512', '肩黑色素细胞痣 (M87200/0)', '376', 'D22.652', 'JHSSXBZ', '');
INSERT INTO `05diseases` VALUES ('3513', '下肢黑色素痣 (M87200/0)', '470', 'D22.751', 'XZHSSZ', '');
INSERT INTO `05diseases` VALUES ('3514', '髋黑色素细胞痣 (M87200/0)', '376', 'D22.752', 'KHSSXBZ', '');
INSERT INTO `05diseases` VALUES ('3515', '蓝痣 (M87800/0)', '470', 'D22.951', 'LZ', '');
INSERT INTO `05diseases` VALUES ('3516', '痣 NOS (M87200/0)', '470', 'D22.952', 'Z', '');
INSERT INTO `05diseases` VALUES ('3517', '唇皮肤良性肿瘤', '473', 'D23.051', 'CPFLXZL', '');
INSERT INTO `05diseases` VALUES ('3518', '眼睑良性肿瘤', '473', 'D23.101', 'YJLXZL', '');
INSERT INTO `05diseases` VALUES ('3519', '迈博腺[睑板腺]良性肿瘤', '473', 'D23.151', 'MBXJBXLXZL', '');
INSERT INTO `05diseases` VALUES ('3520', '眦皮肤良性瘤', '250', 'D23.152', 'ZPFLXL', '');
INSERT INTO `05diseases` VALUES ('3521', '耵聍腺瘤 (M84200/0)', '261', 'D23.201', 'DNXL', '');
INSERT INTO `05diseases` VALUES ('3522', '耳廓良性肿瘤', '473', 'D23.202', 'EKLXZL', '');
INSERT INTO `05diseases` VALUES ('3523', '耳皮肤良性肿瘤', '473', 'D23.203', 'EPFLXZL', '');
INSERT INTO `05diseases` VALUES ('3524', '听道结缔组织良性肿瘤', '473', 'D23.204', 'TDJDZZLXZL', '');
INSERT INTO `05diseases` VALUES ('3525', '外耳道良性肿瘤', '473', 'D23.205', 'WEDLXZL', '');
INSERT INTO `05diseases` VALUES ('3526', '外耳道乳头状瘤', '70', 'D23.251', 'WEDRTZL', '');
INSERT INTO `05diseases` VALUES ('3527', '鼻部皮肤良性肿瘤', '473', 'D23.301', 'BBPFLXZL', '');
INSERT INTO `05diseases` VALUES ('3528', '鼻唇沟良性肿瘤', '473', 'D23.303', 'BCGLXZL', '');
INSERT INTO `05diseases` VALUES ('3529', '颊部皮肤良性肿瘤', '473', 'D23.304', 'JBPFLXZL', '');
INSERT INTO `05diseases` VALUES ('3530', '眉良性肿瘤', '473', 'D23.305', 'MLXZL', '');
INSERT INTO `05diseases` VALUES ('3531', '面部皮肤良性肿瘤', '473', 'D23.306', 'MBPFLXZL', '');
INSERT INTO `05diseases` VALUES ('3532', '颧部钙化上皮瘤', '251', 'D23.351', 'QBGHSPL', '');
INSERT INTO `05diseases` VALUES ('3533', '耳后皮肤良性肿瘤', '473', 'D23.401', 'EHPFLXZL', '');
INSERT INTO `05diseases` VALUES ('3534', '颈部皮肤良性肿瘤', '473', 'D23.402', 'GBPFLXZL', '');
INSERT INTO `05diseases` VALUES ('3535', '头皮良性肿瘤', '473', 'D23.403', 'TPLXZL', '');
INSERT INTO `05diseases` VALUES ('3536', '背部皮肤良性肿瘤', '473', 'D23.501', 'BBPFLXZL', '');
INSERT INTO `05diseases` VALUES ('3537', '腹壁良性肿瘤', '473', 'D23.502', 'FBLXZL', '');
INSERT INTO `05diseases` VALUES ('3538', '肛门皮肤良性肿瘤', '473', 'D23.503', 'GMPFLXZL', '');
INSERT INTO `05diseases` VALUES ('3539', '躯干皮肤良性肿瘤', '473', 'D23.504', 'QGPFLXZL', '');
INSERT INTO `05diseases` VALUES ('3540', '臀部皮肤良性肿瘤', '473', 'D23.505', 'TBPFLXZL', '');
INSERT INTO `05diseases` VALUES ('3541', '胸部皮肤良性肿瘤', '473', 'D23.506', 'XBPFLXZL', '');
INSERT INTO `05diseases` VALUES ('3542', '腋下皮肤良性肿瘤', '473', 'D23.507', 'YXPFLXZL', '');
INSERT INTO `05diseases` VALUES ('3543', '腹壁皮肤良性肿瘤', '473', 'D23.551', 'FBPFLXZL', '');
INSERT INTO `05diseases` VALUES ('3544', '乳房皮肤良性肿瘤', '473', 'D23.552', 'RFPFLXZL', '');
INSERT INTO `05diseases` VALUES ('3545', '上肢皮肤良性肿瘤', '473', 'D23.601', 'SZPFLXZL', '');
INSERT INTO `05diseases` VALUES ('3546', '指皮肤良性肿瘤', '473', 'D23.602', 'ZPFLXZL', '');
INSERT INTO `05diseases` VALUES ('3547', '肩皮肤良性肿瘤', '473', 'D23.651', 'JPFLXZL', '');
INSERT INTO `05diseases` VALUES ('3548', '下肢皮肤良性肿瘤', '473', 'D23.701', 'XZPFLXZL', '');
INSERT INTO `05diseases` VALUES ('3549', '髋皮肤良性肿瘤', '473', 'D23.751', 'KPFLXZL', '');
INSERT INTO `05diseases` VALUES ('3550', '皮肤良性肿瘤 NOS', '473', 'D23.901', 'PFLXZL', '');
INSERT INTO `05diseases` VALUES ('3551', '良性叶状囊肉瘤 (M90200/0)', '294', 'D24.X01', 'LXYZNRL', '');
INSERT INTO `05diseases` VALUES ('3552', '乳房良性肿瘤', '473', 'D24.X02', 'RFLXZL', '');
INSERT INTO `05diseases` VALUES ('3553', '乳腺纤维腺瘤 (M90100/0)', '261', 'D24.X51', 'RXXWXL', '');
INSERT INTO `05diseases` VALUES ('3554', '小管内型纤维腺瘤 (M90110/0)', '261', 'D24.X52', 'XGNXXWXL', '');
INSERT INTO `05diseases` VALUES ('3555', '子宫粘膜下肌瘤 (M88900/0)', '86', 'D25.001', 'ZGNMXJL', '');
INSERT INTO `05diseases` VALUES ('3556', '子宫粘膜下平滑肌瘤 (M88900/0)', '86', 'D25.051', 'ZGNMXPHJL', '');
INSERT INTO `05diseases` VALUES ('3557', '子宫壁内平滑肌瘤 (M88900/0)', '86', 'D25.151', 'ZGBNPHJL', '');
INSERT INTO `05diseases` VALUES ('3558', '子宫浆膜下肌瘤 (M88900/0)', '86', 'D25.201', 'ZGJMXJL', '');
INSERT INTO `05diseases` VALUES ('3559', '子宫浆膜下层平滑肌瘤 (M88900/0)', '86', 'D25.251', 'ZGJMXCPHJL', '');
INSERT INTO `05diseases` VALUES ('3560', '子宫多发性平滑肌瘤 (M88900/0)', '86', 'D25.901', 'ZGDFXPHJL', '');
INSERT INTO `05diseases` VALUES ('3561', '子宫(颈)(体)平滑肌瘤(子宫肌瘤) (M88900/0)', '86', 'D25.902', 'ZGGTPHJLZGJL', '');
INSERT INTO `05diseases` VALUES ('3562', '子宫纤维肌瘤 (M88900/0)', '86', 'D25.951', 'ZGXWJL', '');
INSERT INTO `05diseases` VALUES ('3563', '子宫颈良性肿瘤', '473', 'D26.001', 'ZGGLXZL', '');
INSERT INTO `05diseases` VALUES ('3564', '子宫颈腺瘤性息肉', '86', 'D26.051', 'ZGGXLXXR', '');
INSERT INTO `05diseases` VALUES ('3565', '纳博特腺(滤泡)良性肿瘤', '473', 'D26.052', 'NBTXLPLXZL', '');
INSERT INTO `05diseases` VALUES ('3566', '子宫体良性肿瘤', '473', 'D26.101', 'ZGTLXZL', '');
INSERT INTO `05diseases` VALUES ('3567', '胎盘良性肿瘤', '473', 'D26.701', 'TPLXZL', '');
INSERT INTO `05diseases` VALUES ('3568', '子宫良性肿瘤 NOS', '473', 'D26.901', 'ZGLXZL', '');
INSERT INTO `05diseases` VALUES ('3569', '卵巢良性肿瘤', '473', 'D27.X01', 'LCLXZL', '');
INSERT INTO `05diseases` VALUES ('3570', '类脂质细胞瘤 (M86700/0)', '377', 'D27.X02', 'LZZXBL', '');
INSERT INTO `05diseases` VALUES ('3571', '卵巢畸胎瘤 (M90800/0)', '86', 'D27.X03', 'LCJTL', '');
INSERT INTO `05diseases` VALUES ('3572', '卵巢甲状腺肿 (M90900/0)', '86', 'D27.X04', 'LCJZXZ', '');
INSERT INTO `05diseases` VALUES ('3573', '布伦纳氏瘤 (M90000/0)', '261', 'D27.X05', 'BLNSL', '');
INSERT INTO `05diseases` VALUES ('3574', '泡膜细胞瘤 (M86000/0)', '377', 'D27.X06', 'PMXBL', '');
INSERT INTO `05diseases` VALUES ('3575', '卵巢脂质细胞瘤 (M86700/0)', '86', 'D27.X07', 'LCZZXBL', '');
INSERT INTO `05diseases` VALUES ('3576', '子宫内膜样腺瘤 (M83800/0)', '86', 'D27.X08', 'ZGNMYXL', '');
INSERT INTO `05diseases` VALUES ('3577', '浆液性囊腺瘤 (M84410/0)', '261', 'D27.X09', 'JYXNXL', '');
INSERT INTO `05diseases` VALUES ('3578', '乳头状囊腺瘤 (M84500/0)', '86', 'D27.X10', 'RTZNXL', '');
INSERT INTO `05diseases` VALUES ('3579', '乳头状粘液性囊腺瘤 (M84710/0)', '86', 'D27.X11', 'RTZNYXNXL', '');
INSERT INTO `05diseases` VALUES ('3580', '黄体瘤 (M86100/0)', '261', 'D27.X12', 'HTL', '');
INSERT INTO `05diseases` VALUES ('3581', '浆液性腺纤维瘤 (M90140/0)', '384', 'D27.X13', 'JYXXXWL', '');
INSERT INTO `05diseases` VALUES ('3582', '卵巢皮样囊肿', '86', 'D27.X51', 'LCPYNZ', '');
INSERT INTO `05diseases` VALUES ('3583', '外阴良性肿瘤', '473', 'D28.001', 'WYLXZL', '');
INSERT INTO `05diseases` VALUES ('3584', '阴唇良性肿瘤', '473', 'D28.002', 'YCLXZL', '');
INSERT INTO `05diseases` VALUES ('3585', '巴多林腺良性肿瘤[前庭大腺]', '473', 'D28.051', 'BDLXLXZLQTDX', '');
INSERT INTO `05diseases` VALUES ('3586', '阴道良性肿瘤', '473', 'D28.101', 'YDLXZL', '');
INSERT INTO `05diseases` VALUES ('3587', '加特纳管[卵巢冠纵管]良性肿瘤', '473', 'D28.151', 'JTNGLCGZGLXZL', '');
INSERT INTO `05diseases` VALUES ('3588', '阔韧带良性肿瘤', '473', 'D28.201', 'KRDLXZL', '');
INSERT INTO `05diseases` VALUES ('3589', '卵巢冠良性肿瘤', '473', 'D28.202', 'LCGLXZL', '');
INSERT INTO `05diseases` VALUES ('3590', '输卵管良性肿瘤', '473', 'D28.203', 'SLGLXZL', '');
INSERT INTO `05diseases` VALUES ('3591', '子宫韧带良性肿瘤', '473', 'D28.251', 'ZGRDLXZL', '');
INSERT INTO `05diseases` VALUES ('3592', '其他特指的女生殖器官良性肿瘤', '473', 'D28.751', 'QTTZDNSZQGLXZL', '');
INSERT INTO `05diseases` VALUES ('3593', '女生殖器官良性肿瘤 NOS', '473', 'D28.951', 'NSZQGLXZL', '');
INSERT INTO `05diseases` VALUES ('3594', '龟头良性肿瘤', '473', 'D29.001', 'GTLXZL', '');
INSERT INTO `05diseases` VALUES ('3595', '阴茎良性肿瘤', '473', 'D29.002', 'YJLXZL', '');
INSERT INTO `05diseases` VALUES ('3596', '包皮良性肿瘤', '473', 'D29.051', 'BPLXZL', '');
INSERT INTO `05diseases` VALUES ('3597', '前列腺良性肿瘤', '473', 'D29.101', 'QLXLXZL', '');
INSERT INTO `05diseases` VALUES ('3598', '睾丸良性肿瘤', '473', 'D29.201', 'GWLXZL', '');
INSERT INTO `05diseases` VALUES ('3599', '附睾良性肿瘤', '473', 'D29.301', 'FGLXZL', '');
INSERT INTO `05diseases` VALUES ('3600', '阴囊良性肿瘤', '473', 'D29.401', 'YNLXZL', '');
INSERT INTO `05diseases` VALUES ('3601', '精囊良性肿瘤', '473', 'D29.701', 'JNLXZL', '');
INSERT INTO `05diseases` VALUES ('3602', '精索良性肿瘤', '473', 'D29.702', 'JSLXZL', '');
INSERT INTO `05diseases` VALUES ('3603', '鞘膜良性肿瘤', '473', 'D29.751', 'QMLXZL', '');
INSERT INTO `05diseases` VALUES ('3604', '男性生殖器官良性肿瘤 NOS', '473', 'D29.951', 'NXSZQGLXZL', '');
INSERT INTO `05diseases` VALUES ('3605', '肾良性肿瘤', '473', 'D30.001', 'SLXZL', '');
INSERT INTO `05diseases` VALUES ('3606', '肾盂良性肿瘤', '473', 'D30.101', 'SYLXZL', '');
INSERT INTO `05diseases` VALUES ('3607', '输尿管良性肿瘤', '473', 'D30.201', 'SNGLXZL', '');
INSERT INTO `05diseases` VALUES ('3608', '膀胱良性肿瘤', '473', 'D30.301', 'BGLXZL', '');
INSERT INTO `05diseases` VALUES ('3609', '膀胱口输尿管的良性肿瘤', '473', 'D30.351', 'BGKSNGDLXZL', '');
INSERT INTO `05diseases` VALUES ('3610', '尿道良性肿瘤', '473', 'D30.401', 'NDLXZL', '');
INSERT INTO `05diseases` VALUES ('3611', '尿道旁腺良性肿瘤', '473', 'D30.751', 'NDPXLXZL', '');
INSERT INTO `05diseases` VALUES ('3612', '斯基恩腺良性肿瘤', '473', 'D30.752', 'SJEXLXZL', '');
INSERT INTO `05diseases` VALUES ('3613', '泌尿系统(器官)良性肿瘤 NOS', '473', 'D30.951', 'MNXTQGLXZL', '');
INSERT INTO `05diseases` VALUES ('3614', '结膜良性肿瘤', '473', 'D31.001', 'JMLXZL', '');
INSERT INTO `05diseases` VALUES ('3615', '角膜良性肿瘤', '473', 'D31.101', 'JMLXZL', '');
INSERT INTO `05diseases` VALUES ('3616', '视网膜良性肿瘤', '473', 'D31.201', 'SWMLXZL', '');
INSERT INTO `05diseases` VALUES ('3617', '脉络膜良性肿瘤', '473', 'D31.301', 'MLMLXZL', '');
INSERT INTO `05diseases` VALUES ('3618', '虹膜良性肿瘤', '473', 'D31.401', 'HMLXZL', '');
INSERT INTO `05diseases` VALUES ('3619', '睫状体良性肿瘤', '473', 'D31.451', 'JZTLXZL', '');
INSERT INTO `05diseases` VALUES ('3620', '葡萄膜良性肿瘤', '473', 'D31.452', 'PTMLXZL', '');
INSERT INTO `05diseases` VALUES ('3621', '眼球良性肿瘤', '473', 'D31.453', 'YQLXZL', '');
INSERT INTO `05diseases` VALUES ('3622', '泪管良性肿瘤', '473', 'D31.501', 'LGLXZL', '');
INSERT INTO `05diseases` VALUES ('3623', '泪腺良性肿瘤', '473', 'D31.502', 'LXLXZL', '');
INSERT INTO `05diseases` VALUES ('3624', '泪囊良性肿瘤', '473', 'D31.551', 'LNLXZL', '');
INSERT INTO `05diseases` VALUES ('3625', '眶内良性细胞瘤', '377', 'D31.601', 'KNLXXBL', '');
INSERT INTO `05diseases` VALUES ('3626', '球后良性肿瘤', '473', 'D31.602', 'QHLXZL', '');
INSERT INTO `05diseases` VALUES ('3627', '眼眶良性肿瘤', '473', 'D31.603', 'YKLXZL', '');
INSERT INTO `05diseases` VALUES ('3628', '眶周围神经良性肿瘤', '473', 'D31.651', 'KZWSJLXZL', '');
INSERT INTO `05diseases` VALUES ('3629', '眼后组织良性肿瘤', '473', 'D31.652', 'YHZZLXZL', '');
INSERT INTO `05diseases` VALUES ('3630', '眼球后良性肿瘤', '473', 'D31.653', 'YQHLXZL', '');
INSERT INTO `05diseases` VALUES ('3631', '眼外肌良性肿瘤', '473', 'D31.654', 'YWJLXZL', '');
INSERT INTO `05diseases` VALUES ('3632', '眼良性肿瘤 NOS', '473', 'D31.901', 'YLXZL', '');
INSERT INTO `05diseases` VALUES ('3633', '鞍部脑膜瘤', '232', 'D32.001', 'ABNML', '');
INSERT INTO `05diseases` VALUES ('3634', '鞍膈脑膜瘤', '232', 'D32.002', 'AGNML', '');
INSERT INTO `05diseases` VALUES ('3635', '鞍结节脑膜瘤', '232', 'D32.003', 'AJJNML', '');
INSERT INTO `05diseases` VALUES ('3636', '大脑镰脑膜良性肿瘤', '473', 'D32.004', 'DNLNMLXZL', '');
INSERT INTO `05diseases` VALUES ('3637', '大脑镰旁脑膜瘤', '232', 'D32.005', 'DNLPNML', '');
INSERT INTO `05diseases` VALUES ('3638', '蝶鞍区脑膜良性肿瘤', '473', 'D32.006', 'DAQNMLXZL', '');
INSERT INTO `05diseases` VALUES ('3639', '蝶骨嵴脑膜良性肿瘤', '473', 'D32.007', 'DGJNMLXZL', '');
INSERT INTO `05diseases` VALUES ('3640', '蝶骨脑膜瘤', '232', 'D32.008', 'DGNML', '');
INSERT INTO `05diseases` VALUES ('3641', '顶叶脑膜良性肿瘤', '473', 'D32.009', 'DYNMLXZL', '');
INSERT INTO `05diseases` VALUES ('3642', '额叶脑膜良性肿瘤', '473', 'D32.010', 'EYNMLXZL', '');
INSERT INTO `05diseases` VALUES ('3643', '横窦脑膜瘤', '232', 'D32.011', 'HDNML', '');
INSERT INTO `05diseases` VALUES ('3644', '颅后窝脑膜良性肿瘤', '473', 'D32.012', 'LHWNMLXZL', '');
INSERT INTO `05diseases` VALUES ('3645', '颅前窝脑膜瘤', '232', 'D32.013', 'LQWNML', '');
INSERT INTO `05diseases` VALUES ('3646', '颅窝脑膜瘤', '232', 'D32.014', 'LWNML', '');
INSERT INTO `05diseases` VALUES ('3647', '颅中窝脑膜良性肿瘤', '473', 'D32.015', 'LZWNMLXZL', '');
INSERT INTO `05diseases` VALUES ('3648', '脑室脑膜良性肿瘤', '473', 'D32.016', 'NSNMLXZL', '');
INSERT INTO `05diseases` VALUES ('3649', '颞叶脑膜良性肿瘤', '473', 'D32.017', 'NYNMLXZL', '');
INSERT INTO `05diseases` VALUES ('3650', '前床突脑膜瘤', '232', 'D32.018', 'QCTNML', '');
INSERT INTO `05diseases` VALUES ('3651', '桥脑脑膜瘤 (M95300/0)', '232', 'D32.019', 'QNNML', '');
INSERT INTO `05diseases` VALUES ('3652', '筛窦脑膜瘤 (M95300/0)', '232', 'D32.020', 'SDNML', '');
INSERT INTO `05diseases` VALUES ('3653', '矢状窦脑膜瘤 (M95300/0)', '232', 'D32.021', 'SZDNML', '');
INSERT INTO `05diseases` VALUES ('3654', '矢状窦旁脑膜瘤 (M95300/0)', '232', 'D32.022', 'SZDPNML', '');
INSERT INTO `05diseases` VALUES ('3655', '小脑慕脑膜瘤 (M95300/0)', '232', 'D32.023', 'XNMNML', '');
INSERT INTO `05diseases` VALUES ('3656', '小脑脑膜瘤 (M95300/0)', '232', 'D32.024', 'XNNML', '');
INSERT INTO `05diseases` VALUES ('3657', '嗅沟脑膜瘤 (M95300/0)', '232', 'D32.025', 'XGNML', '');
INSERT INTO `05diseases` VALUES ('3658', '岩骨脑膜瘤 (M95300/0)', '232', 'D32.026', 'YGNML', '');
INSERT INTO `05diseases` VALUES ('3659', '枕骨大孔脑膜瘤 (M95300/0)', '232', 'D32.027', 'ZGDKNML', '');
INSERT INTO `05diseases` VALUES ('3660', '枕叶脑膜瘤 (M95300/0)', '232', 'D32.028', 'ZYNML', '');
INSERT INTO `05diseases` VALUES ('3661', '中颅窝脑膜瘤', '232', 'D32.029', 'ZLWNML', '');
INSERT INTO `05diseases` VALUES ('3662', '脊膜良性肿瘤', '473', 'D32.101', 'JMLXZL', '');
INSERT INTO `05diseases` VALUES ('3663', '硬脊膜下良性肿瘤 (M95300/0)', '473', 'D32.102', 'YJMXLXZL', '');
INSERT INTO `05diseases` VALUES ('3664', '硬脊膜下脑膜瘤 (M95300/0)', '232', 'D32.103', 'YJMXNML', '');
INSERT INTO `05diseases` VALUES ('3665', '椎管内硬膜下良性肿瘤', '473', 'D32.104', 'ZGNYMXLXZL', '');
INSERT INTO `05diseases` VALUES ('3666', '脊髓神经鞘瘤', '313', 'D32.151', 'JSSJQL', '');
INSERT INTO `05diseases` VALUES ('3667', '混合性脑膜瘤 (M95370/0)', '232', 'D32.901', 'HHXNML', '');
INSERT INTO `05diseases` VALUES ('3668', '脑膜瘤 (M95300/0)', '232', 'D32.902', 'NML', '');
INSERT INTO `05diseases` VALUES ('3669', '硬膜良性肿瘤', '473', 'D32.903', 'YMLXZL', '');
INSERT INTO `05diseases` VALUES ('3670', '椎管内良性肿瘤', '473', 'D32.904', 'ZGNLXZL', '');
INSERT INTO `05diseases` VALUES ('3671', '蝶鞍上脑膜瘤 (M95300/0)', '232', 'D32.951', 'DASNML', '');
INSERT INTO `05diseases` VALUES ('3672', '额叶脑膜瘤 (M95300/0)', '232', 'D32.952', 'EYNML', '');
INSERT INTO `05diseases` VALUES ('3673', '脑室脑膜瘤 (M95300/0)', '232', 'D32.954', 'NSNML', '');
INSERT INTO `05diseases` VALUES ('3674', '鼻腔脑脊（膜）瘤 (M95300/0)', '16', 'D32.955', 'BQNJML', '');
INSERT INTO `05diseases` VALUES ('3675', '大脑镰脑膜瘤 (M95300/0)', '232', 'D32.956', 'DNLNML', '');
INSERT INTO `05diseases` VALUES ('3676', '顶叶脑膜瘤 (M95300/0)', '232', 'D32.957', 'DYNML', '');
INSERT INTO `05diseases` VALUES ('3677', '颅窝良性肿瘤', '473', 'D33.001', 'LWLXZL', '');
INSERT INTO `05diseases` VALUES ('3678', '脉络丛乳头状瘤 (M93900/0)', '86', 'D33.002', 'MLCRTZL', '');
INSERT INTO `05diseases` VALUES ('3679', '脑室良性肿瘤', '473', 'D33.003', 'NSLXZL', '');
INSERT INTO `05diseases` VALUES ('3680', '矢状窦良性肿瘤', '473', 'D33.004', 'SZDLXZL', '');
INSERT INTO `05diseases` VALUES ('3681', '颞叶神经良性肿瘤', '473', 'D33.051', 'NYSJLXZL', '');
INSERT INTO `05diseases` VALUES ('3682', '顶叶良性肿瘤', '473', 'D33.052', 'DYLXZL', '');
INSERT INTO `05diseases` VALUES ('3683', '赖尔岛[脑岛]良性肿瘤', '473', 'D33.054', 'LEDNDLXZL', '');
INSERT INTO `05diseases` VALUES ('3684', '脉络丛良性肿瘤', '473', 'D33.055', 'MLCLXZL', '');
INSERT INTO `05diseases` VALUES ('3685', '海马回良性肿瘤', '473', 'D33.056', 'HMHLXZL', '');
INSERT INTO `05diseases` VALUES ('3686', '大脑良性肿瘤', '473', 'D33.057', 'DNLXZL', '');
INSERT INTO `05diseases` VALUES ('3687', '脑干良性肿瘤', '473', 'D33.101', 'NGLXZL', '');
INSERT INTO `05diseases` VALUES ('3688', '桥脑良性肿瘤 (M95300/0)', '473', 'D33.102', 'QNLXZL', '');
INSERT INTO `05diseases` VALUES ('3689', '小脑良性肿瘤', '473', 'D33.103', 'XNLXZL', '');
INSERT INTO `05diseases` VALUES ('3690', '颅内良性肿瘤', '473', 'D33.201', 'LNLXZL', '');
INSERT INTO `05diseases` VALUES ('3691', '脑良性肿瘤 NOS', '473', 'D33.202', 'NLXZL', '');
INSERT INTO `05diseases` VALUES ('3692', '颅中窝脑膜瘤 (M95300/0)', '232', 'D33.251', 'LZWNML', '');
INSERT INTO `05diseases` VALUES ('3693', '颅后窝脑膜瘤 (M95300/0)', '232', 'D33.252', 'LHWNML', '');
INSERT INTO `05diseases` VALUES ('3694', '蝶鞍上区良性肿瘤', '473', 'D33.253', 'DASQLXZL', '');
INSERT INTO `05diseases` VALUES ('3695', '颅神经良性肿瘤', '473', 'D33.301', 'LSJLXZL', '');
INSERT INTO `05diseases` VALUES ('3696', '迷走神经良性肿瘤', '473', 'D33.302', 'MZSJLXZL', '');
INSERT INTO `05diseases` VALUES ('3697', '面神经良性肿瘤', '473', 'D33.303', 'MSJLXZL', '');
INSERT INTO `05diseases` VALUES ('3698', '三叉神经良性肿瘤', '473', 'D33.304', 'SCSJLXZL', '');
INSERT INTO `05diseases` VALUES ('3699', '舌下神经良性肿瘤', '473', 'D33.305', 'SXSJLXZL', '');
INSERT INTO `05diseases` VALUES ('3700', '视盘良性肿瘤', '473', 'D33.306', 'SPLXZL', '');
INSERT INTO `05diseases` VALUES ('3701', '视神经良性肿瘤', '473', 'D33.307', 'SSJLXZL', '');
INSERT INTO `05diseases` VALUES ('3702', '听神经良性肿瘤 (M95600/0)', '473', 'D33.308', 'TSJLXZL', '');
INSERT INTO `05diseases` VALUES ('3703', '听神经瘤 (M95600/0)', '313', 'D33.309', 'TSJL', '');
INSERT INTO `05diseases` VALUES ('3704', '嗅球神经良性肿瘤', '473', 'D33.351', 'XQSJLXZL', '');
INSERT INTO `05diseases` VALUES ('3705', '脊髓良性肿瘤', '473', 'D33.401', 'JSLXZL', '');
INSERT INTO `05diseases` VALUES ('3706', '马尾良性肿瘤', '473', 'D33.402', 'MWLXZL', '');
INSERT INTO `05diseases` VALUES ('3707', '马尾圆锥良性肿瘤', '473', 'D33.403', 'MWYZLXZL', '');
INSERT INTO `05diseases` VALUES ('3708', '其他特指部位的中枢神经系统的良性肿瘤', '473', 'D33.751', 'QTTZBWDZSSJXTDLXZL', '');
INSERT INTO `05diseases` VALUES ('3709', '硬膜内外良性肿瘤', '473', 'D33.901', 'YMNWLXZL', '');
INSERT INTO `05diseases` VALUES ('3710', '硬脊膜外良性肿瘤', '473', 'D33.902', 'YJMWLXZL', '');
INSERT INTO `05diseases` VALUES ('3711', '中枢神经系统的良性肿瘤 NOS', '473', 'D33.951', 'ZSSJXTDLXZL', '');
INSERT INTO `05diseases` VALUES ('3712', '蝶鞍旁良性肿瘤', '473', 'D33.952', 'DAPLXZL', '');
INSERT INTO `05diseases` VALUES ('3713', '甲状舌管良性肿瘤', '473', 'D34.X01', 'JZSGLXZL', '');
INSERT INTO `05diseases` VALUES ('3714', '甲状腺良性肿瘤', '473', 'D34.X02', 'JZXLXZL', '');
INSERT INTO `05diseases` VALUES ('3715', '胸骨后甲状腺良性肿瘤', '473', 'D34.X03', 'XGHJZXLXZL', '');
INSERT INTO `05diseases` VALUES ('3716', '许特耳氏细胞腺瘤 (M82900/0)', '70', 'D34.X04', 'XTESXBXL', '');
INSERT INTO `05diseases` VALUES ('3717', '异位甲状腺良性肿瘤', '473', 'D34.X05', 'YWJZXLXZL', '');
INSERT INTO `05diseases` VALUES ('3718', '甲状腺腺瘤', '261', 'D34.X51', 'JZXXL', '');
INSERT INTO `05diseases` VALUES ('3719', '肾上腺良性肿瘤', '473', 'D35.001', 'SSXLXZL', '');
INSERT INTO `05diseases` VALUES ('3720', '肾上腺皮质腺瘤 (M83700/0)', '261', 'D35.002', 'SSXPZXL', '');
INSERT INTO `05diseases` VALUES ('3721', '嗜铬细胞瘤', '377', 'D35.051', 'SGXBL', '');
INSERT INTO `05diseases` VALUES ('3722', '甲状旁腺良性肿瘤', '473', 'D35.101', 'JZPXLXZL', '');
INSERT INTO `05diseases` VALUES ('3723', '异位甲状旁腺良性肿瘤', '473', 'D35.102', 'YWJZPXLXZL', '');
INSERT INTO `05diseases` VALUES ('3724', '主细胞腺瘤 (M83210/0)', '261', 'D35.103', 'ZXBXL', '');
INSERT INTO `05diseases` VALUES ('3725', '垂体良性肿瘤', '473', 'D35.201', 'CTLXZL', '');
INSERT INTO `05diseases` VALUES ('3726', '垂体泌乳素瘤 (M82710/0)', '261', 'D35.202', 'CTMRSL', '');
INSERT INTO `05diseases` VALUES ('3727', '垂体微腺瘤', '261', 'D35.203', 'CTWXL', '');
INSERT INTO `05diseases` VALUES ('3728', '垂体无功能良性肿瘤', '473', 'D35.204', 'CTWGNLXZL', '');
INSERT INTO `05diseases` VALUES ('3729', '嗜酸性腺癌 (M82800/3)', '2', 'D35.205', 'SSXXA', '');
INSERT INTO `05diseases` VALUES ('3730', '拉特克囊良性肿瘤 (M93500/0)', '473', 'D35.251', 'LTKNLXZL', '');
INSERT INTO `05diseases` VALUES ('3731', '颅咽管良性肿瘤', '473', 'D35.351', 'LYGLXZL', '');
INSERT INTO `05diseases` VALUES ('3732', '松果体良性肿瘤', '473', 'D35.401', 'SGTLXZL', '');
INSERT INTO `05diseases` VALUES ('3733', '颈动脉体良性肿瘤', '473', 'D35.551', 'GDMTLXZL', '');
INSERT INTO `05diseases` VALUES ('3734', '祖克坎德耳器良性肿瘤', '473', 'D35.651', 'ZKKDEQLXZL', '');
INSERT INTO `05diseases` VALUES ('3735', '主动脉体良性肿瘤', '473', 'D35.652', 'ZDMTLXZL', '');
INSERT INTO `05diseases` VALUES ('3736', '其他特指的内分泌腺良性肿瘤', '473', 'D35.751', 'QTTZDNFMXLXZL', '');
INSERT INTO `05diseases` VALUES ('3737', '多个腺体良性肿瘤', '473', 'D35.851', 'DGXTLXZL', '');
INSERT INTO `05diseases` VALUES ('3738', '内分泌腺良性肿瘤 NOS', '473', 'D35.951', 'NFMXLXZL', '');
INSERT INTO `05diseases` VALUES ('3739', '魏尔啸腺良性肿瘤', '473', 'D36.051', 'WEXXLXZL', '');
INSERT INTO `05diseases` VALUES ('3740', '克洛凯腺淋巴良性肿瘤', '473', 'D36.052', 'KLKXLBLXZL', '');
INSERT INTO `05diseases` VALUES ('3741', '罗森米勒腺淋巴良性肿瘤', '473', 'D36.053', 'LSMLXLBLXZL', '');
INSERT INTO `05diseases` VALUES ('3742', '淋巴结良性肿瘤', '473', 'D36.054', 'LBJLXZL', '');
INSERT INTO `05diseases` VALUES ('3743', '臂丛神经良性肿瘤', '473', 'D36.101', 'BCSJLXZL', '');
INSERT INTO `05diseases` VALUES ('3744', '脊神经良性肿瘤', '473', 'D36.102', 'JSJLXZL', '');
INSERT INTO `05diseases` VALUES ('3745', '颈部神经良性肿瘤', '473', 'D36.103', 'GBSJLXZL', '');
INSERT INTO `05diseases` VALUES ('3746', '下肢神经纤维瘤', '313', 'D36.104', 'XZSJXWL', '');
INSERT INTO `05diseases` VALUES ('3747', '正中神经良性肿瘤', '473', 'D36.105', 'ZZSJLXZL', '');
INSERT INTO `05diseases` VALUES ('3748', '坐骨神经良性肿瘤', '473', 'D36.106', 'ZGSJLXZL', '');
INSERT INTO `05diseases` VALUES ('3749', '交感或副交感神经及神经良性肿瘤', '473', 'D36.151', 'JGHFJGSJJSJLXZL', '');
INSERT INTO `05diseases` VALUES ('3750', '躯干神经良性肿瘤', '473', 'D36.152', 'QGSJLXZL', '');
INSERT INTO `05diseases` VALUES ('3751', '神经节母细胞瘤', '313', 'D36.153', 'SJJMXBL', '');
INSERT INTO `05diseases` VALUES ('3752', '髂窝良性肿瘤', '473', 'D36.201', 'QWLXZL', '');
INSERT INTO `05diseases` VALUES ('3753', '头部良性肿瘤', '473', 'D36.701', 'TBLXZL', '');
INSERT INTO `05diseases` VALUES ('3754', '颞部良性肿瘤', '473', 'D36.702', 'NBLXZL', '');
INSERT INTO `05diseases` VALUES ('3755', '颌下良性肿瘤', '473', 'D36.703', 'HXLXZL', '');
INSERT INTO `05diseases` VALUES ('3756', '颊部良性肿瘤', '473', 'D36.704', 'JBLXZL', '');
INSERT INTO `05diseases` VALUES ('3757', '面部良性肿瘤', '473', 'D36.705', 'MBLXZL', '');
INSERT INTO `05diseases` VALUES ('3758', '颈部良性肿瘤', '473', 'D36.706', 'GBLXZL', '');
INSERT INTO `05diseases` VALUES ('3759', '胸腔良性肿瘤', '473', 'D36.707', 'XQLXZL', '');
INSERT INTO `05diseases` VALUES ('3760', '腹腔良性肿瘤', '473', 'D36.708', 'FQLXZL', '');
INSERT INTO `05diseases` VALUES ('3761', '骶前良性肿瘤', '473', 'D36.709', 'DQLXZL', '');
INSERT INTO `05diseases` VALUES ('3762', '骶尾区良性肿瘤', '473', 'D36.710', 'DWQLXZL', '');
INSERT INTO `05diseases` VALUES ('3763', '会阴部良性肿瘤', '473', 'D36.711', 'HYBLXZL', '');
INSERT INTO `05diseases` VALUES ('3764', '腘窝良性肿瘤', '473', 'D36.712', 'GWLXZL', '');
INSERT INTO `05diseases` VALUES ('3765', '髋良性肿瘤', '473', 'D36.713', 'KLXZL', '');
INSERT INTO `05diseases` VALUES ('3766', '盆腔良性肿瘤', '473', 'D36.714', 'PQLXZL', '');
INSERT INTO `05diseases` VALUES ('3767', '上肢和肩良性肿瘤', '473', 'D36.715', 'SZHJLXZL', '');
INSERT INTO `05diseases` VALUES ('3768', '臀部良性肿瘤', '473', 'D36.716', 'TBLXZL', '');
INSERT INTO `05diseases` VALUES ('3769', '下肢良性肿瘤', '473', 'D36.717', 'XZLXZL', '');
INSERT INTO `05diseases` VALUES ('3770', '小腿良性肿瘤', '473', 'D36.718', 'XTLXZL', '');
INSERT INTO `05diseases` VALUES ('3771', '直肠旁良性肿瘤', '473', 'D36.719', 'ZCPLXZL', '');
INSERT INTO `05diseases` VALUES ('3772', '直肠阴道膈良性肿瘤', '473', 'D36.720', 'ZCYDGLXZL', '');
INSERT INTO `05diseases` VALUES ('3773', '足良性肿瘤', '473', 'D36.721', 'ZLXZL', '');
INSERT INTO `05diseases` VALUES ('3774', '鼻良性肿瘤', '473', 'D36.751', 'BLXZL', '');
INSERT INTO `05diseases` VALUES ('3775', '肩胛区弹力纤维瘤（M88200/0）', '384', 'D36.752', 'JJQDLXWL', '');
INSERT INTO `05diseases` VALUES ('3776', '多发性腺瘤样息肉 (M82210/0)', '261', 'D36.901', 'DFXXLYXR', '');
INSERT INTO `05diseases` VALUES ('3778', '良性肿瘤 NOS', '473', 'D36.951', 'LXZL', '');
INSERT INTO `05diseases` VALUES ('3779', '扁桃体肿瘤 (M80000/1)', '473', 'D37.001', 'BTTZL', '');
INSERT INTO `05diseases` VALUES ('3780', '唇交界恶性肿瘤', '473', 'D37.002', 'CJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3781', '腮腺交界恶性肿瘤', '473', 'D37.003', 'SXJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3782', '涎腺交界恶性肿瘤', '473', 'D37.004', 'XXJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3783', '咽部交界恶性肿瘤', '473', 'D37.005', 'YBJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3784', '唇动态未定的肿瘤 (M80000/1)', '473', 'D37.051', 'CDTWDDZL', '');
INSERT INTO `05diseases` VALUES ('3785', '口腔动态未定的肿瘤 (M80000/1)', '473', 'D37.052', 'KQDTWDDZL', '');
INSERT INTO `05diseases` VALUES ('3786', '咽动态未定的肿瘤 (M80000/1)', '473', 'D37.053', 'YDTWDDZL', '');
INSERT INTO `05diseases` VALUES ('3787', '贲门交界恶性肿瘤', '473', 'D37.101', 'BMJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3788', '胃交界恶性肿瘤', '473', 'D37.102', 'WJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3789', '胃类癌', '370', 'D37.151', 'WLA', '');
INSERT INTO `05diseases` VALUES ('3790', '胃动态未定的肿瘤 (M80000/1)', '473', 'D37.152', 'WDTWDDZL', '');
INSERT INTO `05diseases` VALUES ('3791', '十二指肠交界恶性肿瘤', '473', 'D37.201', 'SEZCJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3792', '小肠动态未定的肿瘤 (M80000/1)', '473', 'D37.251', 'XCDTWDDZL', '');
INSERT INTO `05diseases` VALUES ('3793', '阑尾交界恶性肿瘤', '473', 'D37.301', 'LWJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3794', '阑尾类癌', '2', 'D37.351', 'LWLA', '');
INSERT INTO `05diseases` VALUES ('3795', '结肠交界恶性肿瘤', '473', 'D37.401', 'JCJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3796', '乙状结肠交界恶性肿瘤', '473', 'D37.402', 'YZJCJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3797', '直肠交界恶性肿瘤', '473', 'D37.501', 'ZCJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3798', '直肠类癌', '2', 'D37.551', 'ZCLA', '');
INSERT INTO `05diseases` VALUES ('3799', '直肠绒毛状乳头状瘤', '86', 'D37.552', 'ZCRMZRTZL', '');
INSERT INTO `05diseases` VALUES ('3800', '直肠乙状结肠连接处动态未定的肿瘤 (M80000/1)', '473', 'D37.553', 'ZCYZJCLJCDTWDDZL', '');
INSERT INTO `05diseases` VALUES ('3801', '胆囊交界恶性肿瘤', '473', 'D37.601', 'DNJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3802', '壶腹部交界恶性肿瘤', '473', 'D37.602', 'HFBJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3803', '肝动态未定的肿瘤 (M80000/1)', '473', 'D37.651', 'GDTWDDZL', '');
INSERT INTO `05diseases` VALUES ('3804', '胆管动态未定的肿瘤 (M80000/1)', '473', 'D37.652', 'DGDTWDDZL', '');
INSERT INTO `05diseases` VALUES ('3805', '胆囊动态未定的肿瘤 (M80000/1)', '473', 'D37.653', 'DNDTWDDZL', '');
INSERT INTO `05diseases` VALUES ('3806', '肠交界恶性肿瘤', '473', 'D37.701', 'CJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3807', '食道交界恶性肿瘤', '473', 'D37.702', 'SDJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3808', '胰腺交界恶性肿瘤', '473', 'D37.703', 'YXJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3809', '胰腺肿瘤 (M80000/1)', '473', 'D37.704', 'YXZL', '');
INSERT INTO `05diseases` VALUES ('3810', '肛门动态未定的肿瘤 (M80000/1)', '473', 'D37.751', 'GMDTWDDZL', '');
INSERT INTO `05diseases` VALUES ('3811', '胰腺动态未定的肿瘤 (M80000/1)', '473', 'D37.752', 'YXDTWDDZL', '');
INSERT INTO `05diseases` VALUES ('3812', '食管动态未定的肿瘤 (M80000/1)', '473', 'D37.753', 'SGDTWDDZL', '');
INSERT INTO `05diseases` VALUES ('3813', '其他消化器官交界恶性肿瘤', '473', 'D37.901', 'QTXHQGJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3814', '消化系统肿瘤 (M80000/1) NOS', '473', 'D37.902', 'XHXTZL', '');
INSERT INTO `05diseases` VALUES ('3815', '会厌交界恶性肿瘤', '473', 'D38.001', 'HYJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3816', '喉动态未定的肿瘤 (M80000/1)', '473', 'D38.051', 'HDTWDDZL', '');
INSERT INTO `05diseases` VALUES ('3817', '肺交界恶性肿瘤', '473', 'D38.101', 'FJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3818', '气管交界恶性肿瘤', '473', 'D38.102', 'QGJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3819', '支气管交界恶性肿瘤', '473', 'D38.103', 'ZQGJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3820', '肺动态未定的肿瘤 (M80000/1)', '473', 'D38.151', 'FDTWDDZL', '');
INSERT INTO `05diseases` VALUES ('3821', '气管动态未定的肿瘤 (M80000/1)', '473', 'D38.152', 'QGDTWDDZL', '');
INSERT INTO `05diseases` VALUES ('3822', '支气管类癌', '2', 'D38.153', 'ZQGLA', '');
INSERT INTO `05diseases` VALUES ('3823', '胸膜动态未定的肿瘤 (M80000/1)', '473', 'D38.251', 'XMDTWDDZL', '');
INSERT INTO `05diseases` VALUES ('3824', '纵隔交界恶性肿瘤', '473', 'D38.301', 'ZGJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3825', '胸腺动态未定肿瘤 (M80000/1)', '473', 'D38.401', 'XXDTWDZL', '');
INSERT INTO `05diseases` VALUES ('3826', '鼻腔交界恶性肿瘤', '473', 'D38.501', 'BQJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3827', '鼓室颈静脉交界恶性肿瘤', '473', 'D38.502', 'GSGJMJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3828', '中耳动态未定的肿瘤 (M80000/1)', '473', 'D38.551', 'ZEDTWDDZL', '');
INSERT INTO `05diseases` VALUES ('3829', '鼻腔动态未定的肿瘤 (M80000/1)', '473', 'D38.552', 'BQDTWDDZL', '');
INSERT INTO `05diseases` VALUES ('3830', '副鼻窦动态未定的肿瘤 (M80000/1)', '473', 'D38.553', 'FBDDTWDDZL', '');
INSERT INTO `05diseases` VALUES ('3831', '呼吸系统交界恶性肿瘤', '473', 'D38.601', 'HXXTJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3832', '呼吸系统肿瘤 (M80000/1)', '473', 'D38.602', 'HXXTZL', '');
INSERT INTO `05diseases` VALUES ('3833', '淋巴管内性间质异位症 (M89310/1)', '202', 'D39.001', 'LBGNXJZYWZ', '');
INSERT INTO `05diseases` VALUES ('3834', '子宫交界恶性肿瘤', '473', 'D39.002', 'ZGJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3835', '子宫内膜交界恶性肿瘤', '473', 'D39.003', 'ZGNMJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3836', '子宫内膜间质异位症 (M89310/1)', '86', 'D39.052', 'ZGNMJZYWZ', '');
INSERT INTO `05diseases` VALUES ('3837', '多房囊肿 (M80000/1)', '231', 'D39.101', 'DFNZ', '');
INSERT INTO `05diseases` VALUES ('3839', '交界性子宫内膜样腺瘤 (M83800/1)', '86', 'D39.103', 'JJXZGNMYXL', '');
INSERT INTO `05diseases` VALUES ('3840', '粒膜泡膜细胞瘤 (M86210/1)', '377', 'D39.104', 'LMPMXBL', '');
INSERT INTO `05diseases` VALUES ('3841', '粒膜细胞瘤 (M86200/1)', '377', 'D39.105', 'LMXBL', '');
INSERT INTO `05diseases` VALUES ('3842', '两性母细胞瘤 (M86320/1)', '377', 'D39.106', 'LXMXBL', '');
INSERT INTO `05diseases` VALUES ('3843', '卵巢交界恶性肿瘤', '473', 'D39.107', 'LCJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3844', '卵巢颗粒细胞瘤 (M86200/1)', '86', 'D39.108', 'LCKLXBL', '');
INSERT INTO `05diseases` VALUES ('3845', '增生性布伦纳瘤 (M90000/1)', '261', 'D39.151', 'ZSXBLNL', '');
INSERT INTO `05diseases` VALUES ('3846', '女性性腺母细胞瘤 (M90730/1)', '377', 'D39.152', 'NXXXMXBL', '');
INSERT INTO `05diseases` VALUES ('3847', '恶性葡萄胎 (M91000/1)', '258', 'D39.201', 'EXPTT', '');
INSERT INTO `05diseases` VALUES ('3848', '侵袭性葡萄胎 (M91000/1)', '258', 'D39.251', 'QXXPTT', '');
INSERT INTO `05diseases` VALUES ('3849', '破坏性绒毛膜腺瘤 (M91000/1)', '261', 'D39.252', 'PHXRMMXL', '');
INSERT INTO `05diseases` VALUES ('3850', '输卵管交界恶性肿瘤', '473', 'D39.701', 'SLGJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3851', '阴道交界恶性肿瘤', '473', 'D39.702', 'YDJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3852', '前列腺动态性质未定的肿瘤 (M80000/1)', '473', 'D40.051', 'QLXDTXZWDDZL', '');
INSERT INTO `05diseases` VALUES ('3853', '间质细胞瘤 (M86500/1)', '377', 'D40.101', 'JZXBL', '');
INSERT INTO `05diseases` VALUES ('3854', '睾丸交界恶性肿瘤', '473', 'D40.102', 'GWJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3855', '男性性腺母细胞瘤 (M91730/1)', '377', 'D40.151', 'NXXXMXBL', '');
INSERT INTO `05diseases` VALUES ('3856', '附睾交界恶性肿瘤', '473', 'D40.701', 'FGJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3857', '精囊交界恶性肿瘤', '473', 'D40.702', 'JNJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3858', '肾交界恶性肿瘤', '473', 'D41.001', 'SJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3859', '肾盂交界恶性肿瘤', '473', 'D41.101', 'SYJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3860', '输尿管交界恶性肿瘤', '473', 'D41.201', 'SNGJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3861', '尿道动态未定的肿瘤 (M80000/1)', '473', 'D41.351', 'NDDTWDDZL', '');
INSERT INTO `05diseases` VALUES ('3862', '膀胱交界恶性肿瘤', '473', 'D41.401', 'BGJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3863', '膀胱颈息肉 (M81200/1)', '374', 'D41.402', 'BGGXR', '');
INSERT INTO `05diseases` VALUES ('3864', '膀胱内翻性移行上皮乳头状瘤 (M81200/1)', '86', 'D41.403', 'BGNFXYXSPRTZL', '');
INSERT INTO `05diseases` VALUES ('3865', '膀胱乳头状瘤 (M81200/1)', '86', 'D41.404', 'BGRTZL', '');
INSERT INTO `05diseases` VALUES ('3866', '膀胱乳头状息肉 (M81200/1)', '86', 'D41.405', 'BGRTZXR', '');
INSERT INTO `05diseases` VALUES ('3867', '膀胱息肉 (M81200/1)', '374', 'D41.406', 'BGXR', '');
INSERT INTO `05diseases` VALUES ('3868', '膀胱移行上皮息肉 (M81200/1)', '374', 'D41.407', 'BGYXSPXR', '');
INSERT INTO `05diseases` VALUES ('3869', '膀胱移行性细胞乳头状瘤 (M81200/1)', '86', 'D41.408', 'BGYXXXBRTZL', '');
INSERT INTO `05diseases` VALUES ('3870', '泌尿生殖系统交界恶性肿瘤', '473', 'D41.901', 'MNSZXTJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3871', '泌尿生殖系统动态未定肿瘤 (M80000/1)', '473', 'D41.902', 'MNSZXTDTWDZL', '');
INSERT INTO `05diseases` VALUES ('3872', '脑膜交界恶性肿瘤', '473', 'D42.001', 'NMJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3873', '脊(髓)膜交界恶性肿瘤', '473', 'D42.101', 'JSMJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3874', '硬膜下动态未定的肿瘤 (M80000/1)', '473', 'D42.951', 'YMXDTWDDZL', '');
INSERT INTO `05diseases` VALUES ('3875', '枕叶交界恶性肿瘤', '473', 'D43.001', 'ZYJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3876', '脑室神经动态未定的肿瘤 (M80000/1)', '473', 'D43.051', 'NSSJDTWDDZL', '');
INSERT INTO `05diseases` VALUES ('3877', '大脑神经动态未定的肿瘤 (M80000/1)', '473', 'D43.052', 'DNSJDTWDDZL', '');
INSERT INTO `05diseases` VALUES ('3878', '脑干交界恶性肿瘤', '473', 'D43.101', 'NGJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3879', '小脑交界恶性肿瘤', '473', 'D43.102', 'XNJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3880', '延髓交界恶性肿瘤', '473', 'D43.103', 'YSJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3881', '小脑动态未定的肿瘤 (M80000/1)', '473', 'D43.151', 'XNDTWDDZL', '');
INSERT INTO `05diseases` VALUES ('3882', '颅内交界恶性肿瘤', '473', 'D43.201', 'LNJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3883', '脑交界恶性肿瘤', '473', 'D43.202', 'NJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3884', '脑瘤 (M80000/1) NOS', '234', 'D43.203', 'NL', '');
INSERT INTO `05diseases` VALUES ('3885', '脑血管交界恶性肿瘤', '473', 'D43.205', 'NXGJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3886', '颅神经动态未定的肿瘤 (M80000/1)', '473', 'D43.351', 'LSJDTWDDZL', '');
INSERT INTO `05diseases` VALUES ('3887', '脊髓交界恶性肿瘤', '473', 'D43.401', 'JSJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3888', '椎管内交界性恶性肿瘤', '473', 'D43.701', 'ZGNJJXEXZL', '');
INSERT INTO `05diseases` VALUES ('3889', '中枢神经系统其他交界性恶性肿瘤 NOS', '473', 'D43.901', 'ZSSJXTQTJJXEXZL', '');
INSERT INTO `05diseases` VALUES ('3890', '硬膜外交界恶性肿瘤', '473', 'D43.902', 'YMWJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3891', '甲状腺动态未定的肿瘤 (M80000/1)', '473', 'D44.051', 'JZXDTXZWDDZL', '');
INSERT INTO `05diseases` VALUES ('3892', '肾上腺交界恶性肿瘤', '473', 'D44.101', 'SSXJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3893', '甲状旁腺动态未定的肿瘤 (M80000/1)', '473', 'D44.251', 'JZPXDTXZWDDZL', '');
INSERT INTO `05diseases` VALUES ('3894', '垂体交界恶性肿瘤', '473', 'D44.301', 'CTJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3895', '垂体生长激素瘤 (M80000/1)', '261', 'D44.302', 'CTSCJSL', '');
INSERT INTO `05diseases` VALUES ('3896', '拉特克瘤 (M93500/1)', '261', 'D44.351', 'LTKL', '');
INSERT INTO `05diseases` VALUES ('3897', '颅咽管交界恶性肿瘤', '473', 'D44.401', 'LYGJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3898', '颅咽管瘤(M93500/1)', '261', 'D44.402', 'LYGL', '');
INSERT INTO `05diseases` VALUES ('3899', '松果体交界恶性肿瘤', '473', 'D44.501', 'SGTJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3900', '松果体瘤 (M93600/1)', '261', 'D44.502', 'SGTL', '');
INSERT INTO `05diseases` VALUES ('3901', '松果体区交界恶性肿瘤', '473', 'D44.503', 'SGTQJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3902', '颈动脉体瘤 (M86920/1)', '178', 'D44.601', 'GDMTL', '');
INSERT INTO `05diseases` VALUES ('3903', '颈动脉体交界恶性肿瘤', '473', 'D44.602', 'GDMTJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3904', '颈静脉血管球瘤 (M86900/1)', '261', 'D44.701', 'GJMXGQL', '');
INSERT INTO `05diseases` VALUES ('3905', '主动脉体瘤 (M86910/1)', '477', 'D44.702', 'ZDMTL', '');
INSERT INTO `05diseases` VALUES ('3906', '主动脉体和其他节旁体动态未定的肿瘤 (M80000/1)', '473', 'D44.751', 'ZDMTHQTJPTDTXZWDDZL', '');
INSERT INTO `05diseases` VALUES ('3907', '多发性内分泌腺瘤病 (M83600/1)', '261', 'D44.801', 'DFXNFMXLB', '');
INSERT INTO `05diseases` VALUES ('3908', '多发性内分泌腺肌瘤(MEA)', '261', 'D44.851', 'DFXNFMXJL', '');
INSERT INTO `05diseases` VALUES ('3909', '内分泌腺肿瘤 NOS', '473', 'D44.901', 'NFMXZL', '');
INSERT INTO `05diseases` VALUES ('3910', '真性红细胞增多[症][奥斯勒－瓦凯氏病](M99500/1)', '376', 'D45.X01', 'ZXHXBZDZASLWKSB', '');
INSERT INTO `05diseases` VALUES ('3911', '顽固性贫血不伴有铁粒幼细胞 (M99810/1)', '255', 'D46.051+', 'WGXPXBBYTLYXB', '');
INSERT INTO `05diseases` VALUES ('3912', '顽固性贫血伴有铁粒幼细胞 (M99820/1)', '255', 'D46.151+', 'WGXPXBYTLYXB', '');
INSERT INTO `05diseases` VALUES ('3913', '顽固性贫血伴有胚细胞过多 (M99830/1)', '255', 'D46.251+', 'WGXPXBYPXBGD', '');
INSERT INTO `05diseases` VALUES ('3914', '顽固性贫血伴有转化中的胚细胞过多 (M99840/1)', '255', 'D46.351+', 'WGXPXBYZHZDPXBGD', '');
INSERT INTO `05diseases` VALUES ('3915', '难治性贫血 (M99800/1)', '255', 'D46.401+', 'NZXPX', '');
INSERT INTO `05diseases` VALUES ('3916', '其他骨髓增生异常综合征 (M99890/1)', '113', 'D46.751', 'QTGSZSYCZHZ', '');
INSERT INTO `05diseases` VALUES ('3917', '骨髓增生异常综合征 (M99890/1)', '113', 'D46.901', 'GSZSYCZHZ', '');
INSERT INTO `05diseases` VALUES ('3918', '白血病前期(综合征) (M99890/1)', '5', 'D46.952', 'BXBQQZHZ', '');
INSERT INTO `05diseases` VALUES ('3919', '肥大细胞瘤', '377', 'D47.051', 'FDXBL', '');
INSERT INTO `05diseases` VALUES ('3920', '骨髓纤维化 (M99610/1)', '113', 'D47.101', 'GSXWH', '');
INSERT INTO `05diseases` VALUES ('3921', '骨髓增生病 (M99600/1)', '113', 'D47.102', 'GSZSB', '');
INSERT INTO `05diseases` VALUES ('3922', '慢性骨髓增生病 (M99600/1)', '113', 'D47.103', 'MXGSZSB', '');
INSERT INTO `05diseases` VALUES ('3923', '骨髓硬化症(巨核细胞性)伴髓样化生动态未定的肿瘤', '473', 'D47.151', 'GSYHZJHXBXBSYHSDTWDD', '');
INSERT INTO `05diseases` VALUES ('3924', '骨髓增生性动态未定的肿瘤 (M80000/1)', '473', 'D47.152', 'GSZSXDTXZWDDZL', '');
INSERT INTO `05diseases` VALUES ('3925', '单克隆丙种球蛋白病 (M97650/1)', '268', 'D47.201', 'DKLBZQDBB', '');
INSERT INTO `05diseases` VALUES ('3926', '特发性(出血性)血小板增多症 (M99620/1)', '38', 'D47.301', 'TFXCXXXXBZDZ', '');
INSERT INTO `05diseases` VALUES ('3927', '原发性血小板增多症', '420', 'D47.351', 'YFXXXBZDZ', '');
INSERT INTO `05diseases` VALUES ('3931', '骶骨交界恶性肿瘤', '473', 'D48.001', 'DGJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3932', '上肢骨交界恶性肿瘤', '473', 'D48.002', 'SZGJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3933', '下肢骨交界恶性肿瘤', '473', 'D48.003', 'XZGJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3934', '骨软骨瘤病 (M92100/1)', '301', 'D48.004', 'GRGLB', '');
INSERT INTO `05diseases` VALUES ('3935', '骨交界恶性肿瘤', '473', 'D48.005', 'GJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3936', '关节交界性恶性肿瘤', '473', 'D48.006', 'GJJJXEXZL', '');
INSERT INTO `05diseases` VALUES ('3937', '颌骨交界恶性肿瘤', '473', 'D48.007', 'HGJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3938', '脊椎交界性恶性肿瘤', '473', 'D48.008', 'JZJJXEXZL', '');
INSERT INTO `05diseases` VALUES ('3939', '颅骨交界性恶性肿瘤', '473', 'D48.009', 'LGJJXEXZL', '');
INSERT INTO `05diseases` VALUES ('3940', '胫骨巨细胞瘤 (M92500/1)', '377', 'D48.051', 'JGJXBL', '');
INSERT INTO `05diseases` VALUES ('3941', '骨巨细胞瘤 (M92500/1)', '377', 'D48.052', 'GJXBL', '');
INSERT INTO `05diseases` VALUES ('3942', '硬纤维瘤 (M88210/1)', '384', 'D48.102', 'YXWL', '');
INSERT INTO `05diseases` VALUES ('3943', '骶前结缔组织交界恶性肿瘤', '473', 'D48.103', 'DQJDZZJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3944', '腹壁交界恶性肿瘤', '473', 'D48.104', 'FBJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3945', '腹壁硬纤维瘤 (M88210/1)', '384', 'D48.105', 'FBYXWL', '');
INSERT INTO `05diseases` VALUES ('3946', '滑膜交界恶性肿瘤', '473', 'D48.106', 'HMJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3947', '结缔组织及其他软组织交界性恶性肿瘤', '473', 'D48.107', 'JDZZJQTRZZJJXEXZL', '');
INSERT INTO `05diseases` VALUES ('3948', '颈静脉交界恶性肿瘤', '473', 'D48.108', 'GJMJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3949', '软组织交界恶性肿瘤', '473', 'D48.109', 'RZZJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3950', '上肢结缔组织交界恶性肿瘤', '473', 'D48.110', 'SZJDZZJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3951', '臀部结缔组织交界恶性肿瘤', '473', 'D48.111', 'TBJDZZJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3952', '下肢结缔组织交界性恶性肿瘤', '473', 'D48.112', 'XZJDZZJJXEXZL', '');
INSERT INTO `05diseases` VALUES ('3953', '耳结缔组织交界性肿瘤', '473', 'D48.151', 'EJDZZJJXZL', '');
INSERT INTO `05diseases` VALUES ('3954', '躯干结缔组织交界性肿瘤', '473', 'D48.152', 'QGJDZZJJXZL', '');
INSERT INTO `05diseases` VALUES ('3955', '指结缔组织交界性肿瘤', '473', 'D48.153', 'ZJDZZJJXZL', '');
INSERT INTO `05diseases` VALUES ('3956', '指浸润性纤维瘤 (M88210/1)', '384', 'D48.154', 'ZJRXXWL', '');
INSERT INTO `05diseases` VALUES ('3957', '眼眶结缔组织交界性肿瘤', '473', 'D48.155', 'YKJDZZJJXZL', '');
INSERT INTO `05diseases` VALUES ('3958', '周围神经和自主神经系统动态未定的肿瘤 (M80000 /1)', '473', 'D48.251', 'ZWSJHZZSJXTDTWDDZL', '');
INSERT INTO `05diseases` VALUES ('3959', '腹膜后交界恶性肿瘤', '473', 'D48.301', 'FMHJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3960', '腹膜后纤维病', '89', 'D48.351', 'FMHXWB', '');
INSERT INTO `05diseases` VALUES ('3961', '肠系膜交界恶性肿瘤', '473', 'D48.401', 'CXMJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3962', '腹膜交界恶性肿瘤', '473', 'D48.402', 'FMJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3963', '基底细胞瘤 (M80900/1)', '377', 'D48.501', 'JDXBL', '');
INSERT INTO `05diseases` VALUES ('3964', '鼻部皮肤交界恶性肿瘤', '473', 'D48.502', 'BBPFJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3965', '臂皮肤交界恶性肿瘤', '473', 'D48.504', 'BPFJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3966', '耳部皮肤交界恶性肿瘤', '473', 'D48.505', 'EBPFJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3967', '皮肤交界恶性肿瘤', '473', 'D48.506', 'PFJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3968', '躯干皮肤交界恶性肿瘤', '473', 'D48.507', 'QGPFJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3969', '眼睑交界恶性肿瘤', '473', 'D48.508', 'YJJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3970', '面部皮肤交界性肿瘤', '473', 'D48.551', 'MBPFJJXZL', '');
INSERT INTO `05diseases` VALUES ('3971', '巨痣 (M87610/1)', '470', 'D48.552', 'JZ', '');
INSERT INTO `05diseases` VALUES ('3972', '叶状囊肉瘤 (M90200/1)', '294', 'D48.601', 'YZNRL', '');
INSERT INTO `05diseases` VALUES ('3973', '乳房交界恶性肿瘤', '473', 'D48.603', 'RFJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3974', '背部交界恶性肿瘤', '473', 'D48.701', 'BBJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3975', '臂交界恶性肿瘤', '473', 'D48.702', 'BJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3976', '骶前区交界恶性肿瘤', '473', 'D48.703', 'DQQJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3977', '腹部交界恶性肿瘤', '473', 'D48.704', 'FBJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3978', '腹股沟交界恶性肿瘤', '473', 'D48.705', 'FGGJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3979', '腹腔交界恶性肿瘤', '473', 'D48.706', 'FQJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3980', '颊部交界恶性肿瘤', '473', 'D48.707', 'JBJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3981', '盆腹腔交界性肿瘤', '473', 'D48.708', 'PFQJJXZL', '');
INSERT INTO `05diseases` VALUES ('3982', '盆腔交界恶性肿瘤', '473', 'D48.709', 'PQJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3983', '其他特指部位交界恶性肿瘤', '473', 'D48.710', 'QTTZBWJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3984', '躯干部交界恶性肿瘤', '473', 'D48.711', 'QGBJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3985', '上肢动态未定肿瘤 (M80000 /1)', '473', 'D48.712', 'SZXZWDZL', '');
INSERT INTO `05diseases` VALUES ('3986', '手交界恶性肿瘤', '473', 'D48.713', 'SJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3987', '腿部交界恶性肿瘤', '473', 'D48.714', 'TBJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3988', '臀部交界恶性肿瘤', '473', 'D48.715', 'TBJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3989', '腕部交界恶性肿瘤', '473', 'D48.716', 'WBJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3990', '下肢交界恶性肿瘤', '473', 'D48.717', 'XZJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3991', '心室交界恶性肿瘤', '473', 'D48.718', 'XSJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3992', '胸壁交界恶性肿瘤', '473', 'D48.719', 'XBJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3993', '眼交界恶性肿瘤', '473', 'D48.720', 'YJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3994', '眼眶交界恶性肿瘤', '473', 'D48.721', 'YKJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3995', '眼眶肿瘤 (M80000/1)', '473', 'D48.722', 'YKZL', '');
INSERT INTO `05diseases` VALUES ('3996', '腋下交界性恶性肿瘤', '473', 'D48.723', 'YXJJXEXZL', '');
INSERT INTO `05diseases` VALUES ('3997', '指交界恶性肿瘤', '473', 'D48.724', 'ZJJEXZL', '');
INSERT INTO `05diseases` VALUES ('3998', '心脏动态未定的肿瘤 (M80000 /1)', '473', 'D48.751', 'XZDTXZWDDZL', '');
INSERT INTO `05diseases` VALUES ('3999', '手鱼际肌粘液表皮样瘤 (M84300/1)', '261', 'D48.752', 'SYJJNYBPYL', '');
INSERT INTO `05diseases` VALUES ('4000', '眶周围动态未定的肿瘤 (M80000 /1)', '473', 'D48.753', 'KZWDTXZWDDZL', '');
INSERT INTO `05diseases` VALUES ('4001', '腹腔畸胎瘤', '261', 'D48.754', 'FQJTL', '');
INSERT INTO `05diseases` VALUES ('4002', '骶尾部畸胎瘤', '261', 'D48.755', 'DWBJTL', '');
INSERT INTO `05diseases` VALUES ('4003', '癌性脑白质病 (M80100/1)', '2', 'D48.901+', 'AXNBZB', '');
INSERT INTO `05diseases` VALUES ('4004', '癌性脑病  (M80100/1)', '2', 'D48.902+', 'AXNB', '');
INSERT INTO `05diseases` VALUES ('4005', '癌旁(丹尼布斯)神经病', '313', 'D48.951+', 'APDNBSSJB', '');
INSERT INTO `05diseases` VALUES ('4006', '肿瘤疾病引起的贫血', '473', 'D48.952+', 'ZLJBYQDPX', '');
INSERT INTO `05diseases` VALUES ('4007', '慢性失血致贫血', '255', 'D50.001', 'MXSXZPX', '');
INSERT INTO `05diseases` VALUES ('4008', '失血性贫血', '255', 'D50.002', 'SXXPX', '');
INSERT INTO `05diseases` VALUES ('4009', '继发于(慢性)失血的缺铁性贫血', '255', 'D50.051', 'JFYMXSXDQTXPX', '');
INSERT INTO `05diseases` VALUES ('4010', '普卢默－文森综合征', '278', 'D50.151', 'PLMWSZHZ', '');
INSERT INTO `05diseases` VALUES ('4011', '缺铁性吞咽困难[凯利-佩特森综合征]', '361', 'D50.152', 'QTXTYKNKLPTSZHZ', '');
INSERT INTO `05diseases` VALUES ('4012', '低色素性小细胞性贫血', '255', 'D50.801', 'DSSXXXBXPX', '');
INSERT INTO `05diseases` VALUES ('4013', '威茨贫血', '255', 'D50.851', 'WCPX', '');
INSERT INTO `05diseases` VALUES ('4014', '低色小红细胞性贫血', '255', 'D50.852', 'DSXHXBXPX', '');
INSERT INTO `05diseases` VALUES ('4015', '小红细胞性贫血', '255', 'D50.853', 'XHXBXPX', '');
INSERT INTO `05diseases` VALUES ('4016', '低色素性贫血', '255', 'D50.901', 'DSSXPX', '');
INSERT INTO `05diseases` VALUES ('4017', '缺铁性贫血', '255', 'D50.902', 'QTXPX', '');
INSERT INTO `05diseases` VALUES ('4018', '恶性贫血[比尔默氏病]', '255', 'D51.001', 'EXPXBEMSB', '');
INSERT INTO `05diseases` VALUES ('4019', '亨特舌炎', '310', 'D51.051', 'HTSY', '');
INSERT INTO `05diseases` VALUES ('4020', '脊髓亚急性联合变性伴贫血', '255', 'D51.052', 'JSYJXLHBXBPX', '');
INSERT INTO `05diseases` VALUES ('4021', '阿狄森(艾迪生)氏贫血', '255', 'D51.053', 'ADSADSSPX', '');
INSERT INTO `05diseases` VALUES ('4022', '伊梅斯隆德(-格雷斯贝克)综合征', '278', 'D51.151', 'YMSLDGLSBKZHZ', '');
INSERT INTO `05diseases` VALUES ('4023', '巨幼细胞遗传性贫血', '255', 'D51.152', 'JYXBYCXPX', '');
INSERT INTO `05diseases` VALUES ('4024', '转钴胺素2缺乏', '278', 'D51.251', 'ZGASQF', '');
INSERT INTO `05diseases` VALUES ('4025', '绝对素食者的贫血', '255', 'D51.351', 'JDSSZDPX', '');
INSERT INTO `05diseases` VALUES ('4026', '其他维生素Ｂ12缺乏性贫血', '255', 'D51.851', 'QTWSSQFXPX', '');
INSERT INTO `05diseases` VALUES ('4027', '维生素Ｂ12缺乏性贫血性脊髓后侧索硬化', '255', 'D51.901+', 'WSSQFXPXXJSHCSYH', '');
INSERT INTO `05diseases` VALUES ('4028', '维生素Ｂ12缺乏性贫血　NOS', '255', 'D51.951', 'WSSQFXPX', '');
INSERT INTO `05diseases` VALUES ('4029', '大细胞性贫血', '255', 'D52.001', 'DXBXPX', '');
INSERT INTO `05diseases` VALUES ('4030', '营养性巨幼红细胞性贫血', '255', 'D52.002', 'YYXJYHXBXPX', '');
INSERT INTO `05diseases` VALUES ('4031', '饮食性叶酸盐缺乏性贫血', '255', 'D52.051', 'YSXYSYQFXPX', '');
INSERT INTO `05diseases` VALUES ('4032', '药物致叶酸缺乏性贫血', '255', 'D52.101', 'YWZYSQFXPX', '');
INSERT INTO `05diseases` VALUES ('4033', '其他叶酸(盐)缺乏性贫血', '255', 'D52.851', 'QTYSYQFXPX', '');
INSERT INTO `05diseases` VALUES ('4034', '叶酸(盐)缺乏性贫血 NOS', '255', 'D52.951', 'YSYQFXPX', '');
INSERT INTO `05diseases` VALUES ('4035', '蛋白缺乏引起的贫血', '255', 'D53.001', 'DBQFYQDPX', '');
INSERT INTO `05diseases` VALUES ('4036', '氨基酸缺乏性贫血', '255', 'D53.051', 'AJSQFXPX', '');
INSERT INTO `05diseases` VALUES ('4037', '乳清酸尿性贫血', '255', 'D53.052', 'RQSNXPX', '');
INSERT INTO `05diseases` VALUES ('4038', '巨幼红细胞性贫血 NOS', '255', 'D53.101', 'JYHXBXPX', '');
INSERT INTO `05diseases` VALUES ('4039', '二(双)性相贫血', '255', 'D53.151', 'ESXXPX', '');
INSERT INTO `05diseases` VALUES ('4040', '坏血病性贫血', '255', 'D53.201', 'HXBXPX', '');
INSERT INTO `05diseases` VALUES ('4041', '营养性贫血', '255', 'D53.901', 'YYXPX', '');
INSERT INTO `05diseases` VALUES ('4042', '单纯性慢性贫血', '255', 'D53.951', 'DCXMXPX', '');
INSERT INTO `05diseases` VALUES ('4043', 'Ｇ6ＰＤ缺陷', '278', 'D55.001', 'QX', '');
INSERT INTO `05diseases` VALUES ('4044', '蚕豆病', '268', 'D55.002', 'CDB', '');
INSERT INTO `05diseases` VALUES ('4045', '葡萄糖６－磷酸脱氢酶[Ｇ6ＰＤ]缺乏性贫血', '255', 'D55.003', 'PTTLSTQMQFXPX', '');
INSERT INTO `05diseases` VALUES ('4046', '谷胱甘肽还原酶缺乏性贫血', '255', 'D55.151', 'GGGTHYMQFXPX', '');
INSERT INTO `05diseases` VALUES ('4047', 'Ⅰ型溶血性非球形红细胞性(遗传性)贫血', '255', 'D55.152', 'YXRXXFQXHXBXYCXPX', '');
INSERT INTO `05diseases` VALUES ('4048', '丙酮酸激酶缺乏性贫血', '255', 'D55.201', 'BTSJMQFXPX', '');
INSERT INTO `05diseases` VALUES ('4049', 'Ⅱ型溶血性非球形红细胞性(遗传性)贫血', '255', 'D55.251', 'EXRXXFQXHXBXYCXPX', '');
INSERT INTO `05diseases` VALUES ('4050', '已糖激酶缺乏性贫血', '255', 'D55.252', 'YTJMQFXPX', '');
INSERT INTO `05diseases` VALUES ('4051', '磷酸丙糖(同分)异构酶缺乏性贫血', '255', 'D55.253', 'LSBTTFYGMQFXPX', '');
INSERT INTO `05diseases` VALUES ('4052', '核苷酸代谢障碍引起的贫血', '255', 'D55.351', 'HGSDXZAYQDPX', '');
INSERT INTO `05diseases` VALUES ('4053', '斯特兰斯基－里加拉型溶血性贫血', '255', 'D55.851', 'STLSJLJLXRXXPX', '');
INSERT INTO `05diseases` VALUES ('4054', '酶障碍引起的贫血 NOS', '255', 'D55.951', 'MZAYQDPX', '');
INSERT INTO `05diseases` VALUES ('4055', 'α型地中海贫血', '255', 'D56.001', 'XDZHPX', '');
INSERT INTO `05diseases` VALUES ('4056', '库利氏贫血', '255', 'D56.101', 'KLSPX', '');
INSERT INTO `05diseases` VALUES ('4057', 'β型地中海贫血', '255', 'D56.102', 'XDZHPX', '');
INSERT INTO `05diseases` VALUES ('4058', '镰状细胞β型地中海贫血', '255', 'D56.151', 'LZXBXDZHPX', '');
INSERT INTO `05diseases` VALUES ('4059', '中间型贫血', '255', 'D56.152', 'ZJXPX', '');
INSERT INTO `05diseases` VALUES ('4060', '重型贫血', '255', 'D56.153', 'ZXPX', '');
INSERT INTO `05diseases` VALUES ('4061', 'δ-β型地中海贫血', '255', 'D56.251', 'XDZHPX', '');
INSERT INTO `05diseases` VALUES ('4062', '地中海贫血特性', '255', 'D56.351', 'DZHPXTX', '');
INSERT INTO `05diseases` VALUES ('4063', '遗传性胎儿血红蛋白持续存在症[HPFH]', '275', 'D56.451', 'YCXTEXHDBCXCZZ', '');
INSERT INTO `05diseases` VALUES ('4064', '其他地中海贫血', '255', 'D56.851', 'QTDZHPX', '');
INSERT INTO `05diseases` VALUES ('4065', '地中海贫血 NOS', '255', 'D56.901', 'DZHPX', '');
INSERT INTO `05diseases` VALUES ('4066', '列蒂－格雷皮－米凯利[微椭圆异形细胞性贫血]贫血', '255', 'D56.951', 'LDGLPMKLWTYYXXBXPXPX', '');
INSERT INTO `05diseases` VALUES ('4067', '地中海贫血综合症(伴有其他血红蛋白病)', '255', 'D56.952', 'DZHPXZHZBYQTXHDBB', '');
INSERT INTO `05diseases` VALUES ('4068', '镰状细胞性贫血伴有危象', '255', 'D57.051', 'LZXBXPXBYWX', '');
INSERT INTO `05diseases` VALUES ('4069', 'Ｈb-SS病伴有危象', '268', 'D57.052', 'BBYWX', '');
INSERT INTO `05diseases` VALUES ('4070', '镰状细胞性贫血，不伴有危象', '255', 'D57.101', 'LZXBXPXBBYWX', '');
INSERT INTO `05diseases` VALUES ('4071', '赫里克贫血不伴有危象', '255', 'D57.151', 'HLKPXBBYWX', '');
INSERT INTO `05diseases` VALUES ('4072', '血红蛋白病Ｓ(Ｈb-SC)', '416', 'D57.251', 'XHDBB', '');
INSERT INTO `05diseases` VALUES ('4073', '血红蛋白病Ｈb-S', '416', 'D57.301', 'XHDBB', '');
INSERT INTO `05diseases` VALUES ('4074', '杂合血红蛋白Ｓ', '275', 'D57.351', 'ZHXHDB', '');
INSERT INTO `05diseases` VALUES ('4075', '其他镰状细胞疾患', '376', 'D57.851', 'QTLZXBJH', '');
INSERT INTO `05diseases` VALUES ('4076', '先天性溶血性贫血', '255', 'D58.001', 'XTXRXXPX', '');
INSERT INTO `05diseases` VALUES ('4077', '遗传性球形红细胞症', '376', 'D58.002', 'YCXQXHXBZ', '');
INSERT INTO `05diseases` VALUES ('4078', '口形红细胞增多', '191', 'D58.051', 'KXHXBZD', '');
INSERT INTO `05diseases` VALUES ('4079', '遗传性球形红细胞增多', '376', 'D58.052', 'YCXQXHXBZD', '');
INSERT INTO `05diseases` VALUES ('4080', '遗传性或先天性球形红细胞症', '383', 'D58.053', 'YCXHXTXQXHXBZ', '');
INSERT INTO `05diseases` VALUES ('4081', '无胆色素尿性(家族性)黄疸', '137', 'D58.054', 'WDSSNXJZXHD', '');
INSERT INTO `05diseases` VALUES ('4082', '先天性溶血性(球形红细胞)黄疸', '137', 'D58.055', 'XTXRXXQXHXBHD', '');
INSERT INTO `05diseases` VALUES ('4083', '明科夫斯基消法尔综合征', '278', 'D58.056', 'MKFSJXFEZHZ', '');
INSERT INTO `05diseases` VALUES ('4084', '遗传性椭圆形红细胞增多症', '379', 'D58.101', 'YCXTYXHXBZDZ', '');
INSERT INTO `05diseases` VALUES ('4085', '(先天性)(遗传性)卵形性红细胞增多症', '383', 'D58.151', 'XTXYCXLXXHXBZDZ', '');
INSERT INTO `05diseases` VALUES ('4086', '血红蛋白病  NOS', '416', 'D58.201', 'XHDBB', '');
INSERT INTO `05diseases` VALUES ('4087', '先天性海因茨小体[球形包涵体]贫血', '255', 'D58.251', 'XTXHYCXTQXBHTPX', '');
INSERT INTO `05diseases` VALUES ('4088', '血红蛋白病，Ｃ型 [Hb-C］', '416', 'D58.252', 'XHDBBX', '');
INSERT INTO `05diseases` VALUES ('4089', '血红蛋白病，Ｄ型［Hb-D]', '416', 'D58.253', 'XHDBBX', '');
INSERT INTO `05diseases` VALUES ('4090', '血红蛋白病，Ｅ型 [Hb-E])', '416', 'D58.254', 'XHDBBX', '');
INSERT INTO `05diseases` VALUES ('4091', '异常的血红蛋白 NOS', '275', 'D58.255', 'YCDXHDB', '');
INSERT INTO `05diseases` VALUES ('4092', '裂红细胞增多症', '379', 'D58.852', 'LHXBZDZ', '');
INSERT INTO `05diseases` VALUES ('4093', '溶血性贫血 NOS', '255', 'D58.901', 'RXXPX', '');
INSERT INTO `05diseases` VALUES ('4094', '遗传性溶血性贫血 NOS', '255', 'D58.902', 'YCXRXXPX', '');
INSERT INTO `05diseases` VALUES ('4095', '药物性自身免疫性溶血性贫血', '228', 'D59.051', 'YWXZSMYXRXXPX', '');
INSERT INTO `05diseases` VALUES ('4096', '冷凝集素病', '268', 'D59.101', 'LNJSB', '');
INSERT INTO `05diseases` VALUES ('4097', '自身免疫性溶血性贫血', '228', 'D59.102', 'ZSMYXRXXPX', '');
INSERT INTO `05diseases` VALUES ('4098', '菜德勒(溶血性)贫血', '255', 'D59.151', 'CDLRXXPX', '');
INSERT INTO `05diseases` VALUES ('4099', '慢性冷性血细胞凝集素病', '376', 'D59.152', 'MXLXXXBNJSB', '');
INSERT INTO `05diseases` VALUES ('4100', '冷凝集素血红蛋白尿', '417', 'D59.153', 'LNJSXHDBN', '');
INSERT INTO `05diseases` VALUES ('4101', '溶血性冷型(继发性)(症状性)贫血', '255', 'D59.154', 'RXXLXJFXZZXPX', '');
INSERT INTO `05diseases` VALUES ('4102', '溶血性温型(继发性)(症状性)贫血', '255', 'D59.155', 'RXXWXJFXZZXPX', '');
INSERT INTO `05diseases` VALUES ('4103', '药物性非自身免疫性溶血性贫血', '228', 'D59.251', 'YWXFZSMYXRXXPX', '');
INSERT INTO `05diseases` VALUES ('4104', '药物性酶缺乏性贫血', '255', 'D59.252', 'YWXMQFXPX', '');
INSERT INTO `05diseases` VALUES ('4105', '溶血-尿毒症性综合征', '239', 'D59.301', 'RXNDZXZHZ', '');
INSERT INTO `05diseases` VALUES ('4106', '非自体免疫性溶血性贫血', '228', 'D59.401', 'FZTMYXRXXPX', '');
INSERT INTO `05diseases` VALUES ('4107', '感染性溶血性贫血', '95', 'D59.402', 'GRXRXXPX', '');
INSERT INTO `05diseases` VALUES ('4108', '继发性溶血性贫血', '255', 'D59.403', 'JFXRXXPX', '');
INSERT INTO `05diseases` VALUES ('4109', '微血管性溶血性贫血', '255', 'D59.451', 'WXGXRXXPX', '');
INSERT INTO `05diseases` VALUES ('4110', '症状性贫血', '255', 'D59.452', 'ZZXPX', '');
INSERT INTO `05diseases` VALUES ('4111', '中毒性溶血性贫血', '255', 'D59.453', 'ZDXRXXPX', '');
INSERT INTO `05diseases` VALUES ('4112', '溶血性机械性贫血', '255', 'D59.454', 'RXXJXXPX', '');
INSERT INTO `05diseases` VALUES ('4113', '阵发性夜间血红蛋白尿伴再生障碍性贫血(PNH-AA)', '255', 'D59.501', 'ZFXYJXHDBNBZSZAXPX', '');
INSERT INTO `05diseases` VALUES ('4114', '阵发性夜间性血红蛋白尿[马尔基亚法瓦米凯利]', '417', 'D59.502', 'ZFXYJXXHDBNMEJYFWMKL', '');
INSERT INTO `05diseases` VALUES ('4115', '运动性血红蛋白尿(行军性血红蛋白尿)', '417', 'D59.601', 'YDXXHDBNXJXXHDBN', '');
INSERT INTO `05diseases` VALUES ('4116', '间歇性血红蛋白尿[穆里病]', '417', 'D59.651', 'JXXXHDBNMLB', '');
INSERT INTO `05diseases` VALUES ('4117', '劳力性血红蛋白尿', '417', 'D59.652', 'LLXXHDBN', '');
INSERT INTO `05diseases` VALUES ('4118', '冷凝集素(阵发性冷性)(伴有雷诺综合征)血红蛋白尿', '417', 'D59.653', 'LNJSZFXLXBYLNZHZXHDB', '');
INSERT INTO `05diseases` VALUES ('4119', '戴克－杨型(继发性)(症状性)贫血', '255', 'D59.851', 'DKYXJFXZZXPX', '');
INSERT INTO `05diseases` VALUES ('4120', '溶血性黄疸[阿杨－维达尔氏综合征]', '137', 'D59.852', 'RXXHDAYWDESZHZ', '');
INSERT INTO `05diseases` VALUES ('4121', '后天性溶血性贫血[阿布拉米氏病]', '255', 'D59.901', 'HTXRXXPXABLMSB', '');
INSERT INTO `05diseases` VALUES ('4122', '急性溶血性贫血', '255', 'D59.902', 'JXRXXPX', '');
INSERT INTO `05diseases` VALUES ('4123', '溶血性黄疸', '137', 'D59.903', 'RXXHD', '');
INSERT INTO `05diseases` VALUES ('4124', '生理性新生儿黄疸', '137', 'D59.951', 'SLXXSEHD', '');
INSERT INTO `05diseases` VALUES ('4125', '血红蛋白血', '275', 'D59.952', 'XHDBX', '');
INSERT INTO `05diseases` VALUES ('4126', '慢性特发性溶血性贫血', '255', 'D59.953', 'MXTFXRXXPX', '');
INSERT INTO `05diseases` VALUES ('4127', '慢性后天性纯红细胞再生障碍', '378', 'D60.051', 'MXHTXCHXBZSZA', '');
INSERT INTO `05diseases` VALUES ('4128', '短暂后天性纯红细胞再生障碍', '378', 'D60.151', 'DZHTXCHXBZSZA', '');
INSERT INTO `05diseases` VALUES ('4129', '其他后天性纯红细胞再生障碍', '378', 'D60.851', 'QTHTXCHXBZSZA', '');
INSERT INTO `05diseases` VALUES ('4130', '单纯红细胞再生障碍性贫血', '255', 'D60.901', 'DCHXBZSZAXPX', '');
INSERT INTO `05diseases` VALUES ('4131', '红细胞发育不伴胸腺瘤', '261', 'D60.902', 'HXBFYBBXXL', '');
INSERT INTO `05diseases` VALUES ('4132', '后天性纯红细胞再生障碍 NOS', '378', 'D60.951', 'HTXCHXBZSZA', '');
INSERT INTO `05diseases` VALUES ('4133', '先天性再生障碍性贫血[范科尼贫血]', '255', 'D61.001', 'XTXZSZAXPXFKNPX', '');
INSERT INTO `05diseases` VALUES ('4134', '家族性再生不良性贫血', '255', 'D61.002', 'JZXZSBLXPX', '');
INSERT INTO `05diseases` VALUES ('4135', '先天性单纯红细胞再生障碍性贫血', '255', 'D61.003', 'XTXDCHXBZSZAXPX', '');
INSERT INTO `05diseases` VALUES ('4136', '先天性再生低下性贫血[先天性纯红细胞性贫血]', '255', 'D61.051', 'XTXZSDXXPXXTXCHXBXPX', '');
INSERT INTO `05diseases` VALUES ('4137', '戴蒙德－布菜克芬贫血[先天性再生不良性贫血]', '255', 'D61.052', 'DMDBCKFPXXTXZSBLXPX', '');
INSERT INTO `05diseases` VALUES ('4138', '体质性再生不良性贫血', '255', 'D61.053', 'TZXZSBLXPX', '');
INSERT INTO `05diseases` VALUES ('4139', '全血细胞减少症伴有畸形', '148', 'D61.054', 'QXXBJSZBYJX', '');
INSERT INTO `05diseases` VALUES ('4140', '药物性再生障碍性贫血', '255', 'D61.101', 'YWXZSZAXPX', '');
INSERT INTO `05diseases` VALUES ('4141', '药物引起的再生不良性贫血', '255', 'D61.151', 'YWYQDZSBLXPX', '');
INSERT INTO `05diseases` VALUES ('4142', '中毒性贫血', '255', 'D61.201', 'ZDXPX', '');
INSERT INTO `05diseases` VALUES ('4143', '感染性再生不良性贫血(骨髓造血功能停滞，感染)', '95', 'D61.251', 'GRXZSBLXPXGSZXGNTZGR', '');
INSERT INTO `05diseases` VALUES ('4144', '中毒性再生不良性贫血', '255', 'D61.252', 'ZDXZSBLXPX', '');
INSERT INTO `05diseases` VALUES ('4145', '特发性再生不良性贫血', '255', 'D61.351', 'TFXZSBLXPX', '');
INSERT INTO `05diseases` VALUES ('4146', '继发性再生障碍性贫血', '255', 'D61.801', 'JFXZSZAXPX', '');
INSERT INTO `05diseases` VALUES ('4147', '其他特指的再生不良性贫血', '255', 'D61.851', 'QTTZDZSBLXPX', '');
INSERT INTO `05diseases` VALUES ('4148', '骨髓抑制', '113', 'D61.901', 'GSYZ', '');
INSERT INTO `05diseases` VALUES ('4149', '骨髓抑制性贫血', '255', 'D61.902', 'GSYZXPX', '');
INSERT INTO `05diseases` VALUES ('4150', '慢性再生障碍性贫血', '255', 'D61.903', 'MXZSZAXPX', '');
INSERT INTO `05diseases` VALUES ('4151', '全血细胞减少', '376', 'D61.904', 'QXXBJS', '');
INSERT INTO `05diseases` VALUES ('4152', '再生障碍性贫血 NOS', '255', 'D61.905', 'ZSZAXPX', '');
INSERT INTO `05diseases` VALUES ('4153', '增生性低下性(折射性)贫血', '255', 'D61.951', 'ZSXDXXZSXPX', '');
INSERT INTO `05diseases` VALUES ('4154', '骨髓再生不良性贫血', '255', 'D61.952', 'GSZSBLXPX', '');
INSERT INTO `05diseases` VALUES ('4155', '全骨髓病', '113', 'D61.953', 'QGSB', '');
INSERT INTO `05diseases` VALUES ('4156', '急性出血性贫血', '255', 'D62.X01', 'JXCXXPX', '');
INSERT INTO `05diseases` VALUES ('4157', '急性出血后贫血', '255', 'D62.X51', 'JXCXHPX', '');
INSERT INTO `05diseases` VALUES ('4158', '遗传性铁粒幼红细胞性贫血', '255', 'D64.051', 'YCXTLYHXBXPX', '');
INSERT INTO `05diseases` VALUES ('4159', '性连锁遗传的低色素铁粒幼红细胞性贫血', '255', 'D64.052', 'XLSYCDDSSTLYHXBXPX', '');
INSERT INTO `05diseases` VALUES ('4160', '疾病引起的继发性铁粒幼红细胞性贫血', '255', 'D64.151', 'JBYQDJFXTLYHXBXPX', '');
INSERT INTO `05diseases` VALUES ('4161', '药物和中毒引起的继发性铁粒幼红细胞性贫血', '255', 'D64.251', 'YWHZDYQDJFXTLYHXBXPX', '');
INSERT INTO `05diseases` VALUES ('4162', '铁粒幼红细胞性贫血', '255', 'D64.301', 'TLYHXBXPX', '');
INSERT INTO `05diseases` VALUES ('4163', '吡哆醇有效性铁粒幼红细胞性贫血', '255', 'D64.351', 'BDCYXXTLYHXBXPX', '');
INSERT INTO `05diseases` VALUES ('4164', '先天性造血不良性贫血', '255', 'D64.401', 'XTXZXBLXPX', '');
INSERT INTO `05diseases` VALUES ('4165', '先天性红细胞生成不良性贫血', '255', 'D64.451', 'XTXHXBSCBLXPX', '');
INSERT INTO `05diseases` VALUES ('4166', '雅克什病[婴儿假白血病性贫血、雅克施-吕泽病]', '255', 'D64.801', 'YKSBYEJBXBXPXYKSLZB', '');
INSERT INTO `05diseases` VALUES ('4167', '靶细胞性贫血', '255', 'D64.851', 'BXBXPX', '');
INSERT INTO `05diseases` VALUES ('4168', '幼白红细胞性贫血', '255', 'D64.852', 'YBHXBXPX', '');
INSERT INTO `05diseases` VALUES ('4169', '婴儿假性白血病', '5', 'D64.853', 'YEJXBXB', '');
INSERT INTO `05diseases` VALUES ('4170', '感染性贫血', '95', 'D64.901', 'GRXPX', '');
INSERT INTO `05diseases` VALUES ('4171', '继发性贫血', '255', 'D64.902', 'JFXPX', '');
INSERT INTO `05diseases` VALUES ('4172', '贫血 NOS', '255', 'D64.903', 'PX', '');
INSERT INTO `05diseases` VALUES ('4173', '肾性贫血', '255', 'D64.904', 'SXPX', '');
INSERT INTO `05diseases` VALUES ('4174', '婴儿贫血', '255', 'D64.905', 'YEPX', '');
INSERT INTO `05diseases` VALUES ('4175', '特发性贫血', '255', 'D64.951', 'TFXPX', '');
INSERT INTO `05diseases` VALUES ('4176', '极度重贫血', '255', 'D64.952', 'JDZPX', '');
INSERT INTO `05diseases` VALUES ('4177', '播散性血管内凝血[去纤维蛋白综合征]', '241', 'D65.X01', 'BSXXGNNXQXWDBZHZ', '');
INSERT INTO `05diseases` VALUES ('4178', '纤维蛋白溶解[症]', '278', 'D65.X03', 'XWDBRJZ', '');
INSERT INTO `05diseases` VALUES ('4179', '坏疽性紫癜', '481', 'D65.X04', 'HJXZD', '');
INSERT INTO `05diseases` VALUES ('4180', '暴发性紫癜', '481', 'D65.X51', 'BFXZD', '');
INSERT INTO `05diseases` VALUES ('4181', '纤维蛋白溶解性紫癜', '481', 'D65.X52', 'XWDBRJXZD', '');
INSERT INTO `05diseases` VALUES ('4182', '后天性纤维蛋白原缺乏血症', '275', 'D65.X53', 'HTXXWDBYQFXZ', '');
INSERT INTO `05diseases` VALUES ('4183', '消耗性凝血障碍', '241', 'D65.X54', 'XHXNXZA', '');
INSERT INTO `05diseases` VALUES ('4184', '后天性纤维蛋白溶解性出血', '38', 'D65.X55', 'HTXXWDBRJXCX', '');
INSERT INTO `05diseases` VALUES ('4185', '第Ⅷ因子缺乏', '278', 'D66.X01', 'DBYZQF', '');
INSERT INTO `05diseases` VALUES ('4186', '血友病', '421', 'D66.X02', 'XYB', '');
INSERT INTO `05diseases` VALUES ('4187', 'Ａ型血友病', '421', 'D66.X03', 'XXYB', '');
INSERT INTO `05diseases` VALUES ('4188', '血友病性关节炎', '124', 'D66.X04+', 'XYBXGJY', '');
INSERT INTO `05diseases` VALUES ('4189', '典型的血友病', '421', 'D66.X51', 'DXDXYB', '');
INSERT INTO `05diseases` VALUES ('4190', '遗传性因子Ⅷ缺乏(伴有功能性缺陷)', '439', 'D66.X52', 'YCXYZBQFBYGNXQX', '');
INSERT INTO `05diseases` VALUES ('4191', 'Ｂ型血友病[克里斯马斯病]', '421', 'D67.X01', 'XXYBKLSMSB', '');
INSERT INTO `05diseases` VALUES ('4192', '遗传因子Ⅸ缺乏', '439', 'D67.X51', 'YCYZJQF', '');
INSERT INTO `05diseases` VALUES ('4193', '血浆凝血酶成份[PTC]缺乏', '241', 'D67.X52', 'XJNXMCFQF', '');
INSERT INTO `05diseases` VALUES ('4194', '血管性血友病[冯维勒布兰氏病]', '421', 'D68.001', 'XGXXYBFWLBLSB', '');
INSERT INTO `05diseases` VALUES ('4195', '维勒布兰德－尤尔根斯血小板紊乱', '420', 'D68.051', 'WLBLDYEGSXXBWL', '');
INSERT INTO `05diseases` VALUES ('4196', '因子Ⅷ缺乏伴有血管缺陷', '413', 'D68.052', 'YZBQFBYXGQX', '');
INSERT INTO `05diseases` VALUES ('4197', 'Ｃ型血友病', '421', 'D68.101', 'XXYB', '');
INSERT INTO `05diseases` VALUES ('4198', '血浆凝血致活酶前质[PTA]缺乏', '241', 'D68.151', 'XJNXZHMQZQF', '');
INSERT INTO `05diseases` VALUES ('4199', '凝血酶原缺乏症(先天性)(遗传性)', '383', 'D68.201', 'NXMYQFZXTXYCX', '');
INSERT INTO `05diseases` VALUES ('4200', '凝血因子Ⅴ缺乏症', '241', 'D68.202', 'NXYZWQFZ', '');
INSERT INTO `05diseases` VALUES ('4201', '凝血因子Ⅶ缺乏症', '241', 'D68.203', 'NXYZQQFZ', '');
INSERT INTO `05diseases` VALUES ('4202', '凝血因子Ⅹ缺乏症', '241', 'D68.204', 'NXYZQFZ', '');
INSERT INTO `05diseases` VALUES ('4203', '先天性纤维蛋白原缺乏', '383', 'D68.205', 'XTXXWDBYQF', '');
INSERT INTO `05diseases` VALUES ('4204', '纤维蛋白原缺乏', '278', 'D68.206', 'XWDBYQF', '');
INSERT INTO `05diseases` VALUES ('4205', '奥夫伦病[副血友病]', '421', 'D68.251', 'AFLBFXYB', '');
INSERT INTO `05diseases` VALUES ('4206', '凝血因子缺乏Ⅰ[纤维蛋白原因子]', '241', 'D68.252', 'NXYZQFYXWDBYYZ', '');
INSERT INTO `05diseases` VALUES ('4207', '凝血因子缺乏Ⅱ[凝血酶原因子]', '241', 'D68.253', 'NXYZQFENXMYYZ', '');
INSERT INTO `05diseases` VALUES ('4208', '凝血因子缺乏Ⅻ[哈格曼因子]', '241', 'D68.254', 'NXYZQFHGMYZ', '');
INSERT INTO `05diseases` VALUES ('4209', '凝血因子缺乏ⅩⅢ[纤维蛋白稳定因子]', '241', 'D68.255', 'NXYZQFSXWDBWDYZ', '');
INSERT INTO `05diseases` VALUES ('4210', '异常纤维蛋白原血症(先天性)', '383', 'D68.256', 'YCXWDBYXZXTX', '');
INSERT INTO `05diseases` VALUES ('4211', '低前转变素血症', '275', 'D68.257', 'DQZBSXZ', '');
INSERT INTO `05diseases` VALUES ('4212', '第八因子抗体形成', '278', 'D68.301', 'DBYZKTXC', '');
INSERT INTO `05diseases` VALUES ('4213', '高肝素血症', '92', 'D68.302', 'GGSXZ', '');
INSERT INTO `05diseases` VALUES ('4214', '血循环中抗凝物质存在', '275', 'D68.303', 'XXHZKNWZCZ', '');
INSERT INTO `05diseases` VALUES ('4215', '抗凝血酶增多', '241', 'D68.351', 'KNXMZD', '');
INSERT INTO `05diseases` VALUES ('4216', '抗Ⅷａ增多', '278', 'D68.352', 'KBZD', '');
INSERT INTO `05diseases` VALUES ('4217', '抗Ⅸａ增多', '278', 'D68.353', 'KJZD', '');
INSERT INTO `05diseases` VALUES ('4218', '抗Ⅹａ增多', '278', 'D68.354', 'KZD', '');
INSERT INTO `05diseases` VALUES ('4219', '抗Ⅺａ增多', '278', 'D68.355', 'KZD', '');
INSERT INTO `05diseases` VALUES ('4220', '后天性凝血因子缺乏', '241', 'D68.401', 'HTXNXYZQF', '');
INSERT INTO `05diseases` VALUES ('4221', '获得性维生素Ｋ依赖因子缺乏症', '369', 'D68.402', 'HDXWSSYLYZQFZ', '');
INSERT INTO `05diseases` VALUES ('4222', '免疫性凝血酶元减少', '228', 'D68.403', 'MYXNXMYJS', '');
INSERT INTO `05diseases` VALUES ('4223', '获得性凝血因子缺乏', '241', 'D68.851', 'HDXNXYZQF', '');
INSERT INTO `05diseases` VALUES ('4224', '出血倾向', '38', 'D68.901', 'CXQX', '');
INSERT INTO `05diseases` VALUES ('4225', '凝血时间延长', '241', 'D68.902', 'NXSJYC', '');
INSERT INTO `05diseases` VALUES ('4226', '凝血机制缺陷(障碍)', '241', 'D68.951', 'NXJZQXZA', '');
INSERT INTO `05diseases` VALUES ('4227', '变应性血管炎', '415', 'D69.001', 'BYXXGY', '');
INSERT INTO `05diseases` VALUES ('4228', '腹型过敏性紫癜', '481', 'D69.002', 'FXGMXZD', '');
INSERT INTO `05diseases` VALUES ('4229', '关节炎性紫癫', '123', 'D69.003', 'GJYXZD', '');
INSERT INTO `05diseases` VALUES ('4230', '过敏性紫癜[亨诺克(－舍恩莱因)紫癜]', '481', 'D69.004', 'GMXZDHNKSELYZD', '');
INSERT INTO `05diseases` VALUES ('4231', '过敏性紫癜性肾炎', '315', 'D69.005+', 'GMXZDXSY', '');
INSERT INTO `05diseases` VALUES ('4232', '风湿性紫癜', '481', 'D69.051', 'FSXZD', '');
INSERT INTO `05diseases` VALUES ('4233', '变应性紫癜', '481', 'D69.052', 'BYXZD', '');
INSERT INTO `05diseases` VALUES ('4234', '传染性紫癜', '481', 'D69.053', 'CRXZD', '');
INSERT INTO `05diseases` VALUES ('4235', '腹型紫癜', '481', 'D69.054', 'FXZD', '');
INSERT INTO `05diseases` VALUES ('4236', '神经性紫癜', '313', 'D69.055', 'SJXZD', '');
INSERT INTO `05diseases` VALUES ('4237', '血管性紫癜', '481', 'D69.056', 'XGXZD', '');
INSERT INTO `05diseases` VALUES ('4238', '中毒性紫癜', '471', 'D69.057', 'ZDXZD', '');
INSERT INTO `05diseases` VALUES ('4239', '肾小球肾炎伴亨诺克(－舍恩莱因)紫癜', '315', 'D69.058+', 'SXQSYBHNKSELYZD', '');
INSERT INTO `05diseases` VALUES ('4240', '非血小板减少性出血性紫癜', '481', 'D69.059', 'FXXBJSXCXXZD', '');
INSERT INTO `05diseases` VALUES ('4241', '血小板病', '420', 'D69.101', 'XXBB', '');
INSERT INTO `05diseases` VALUES ('4243', '血小板紊乱综合症[贝尔纳－苏利耶、巨大血小板]', '420', 'D69.151', 'XXBWLZHZBENSLYJDXXB', '');
INSERT INTO `05diseases` VALUES ('4244', '单纯性紫癜', '481', 'D69.201', 'DCXZD', '');
INSERT INTO `05diseases` VALUES ('4245', '老年性紫癜', '481', 'D69.202', 'LNXZD', '');
INSERT INTO `05diseases` VALUES ('4246', '毛细血管扩张性环状紫瘢', '413', 'D69.203', 'MXXGKZXHZZB', '');
INSERT INTO `05diseases` VALUES ('4247', '紫癜', '481', 'D69.204', 'ZD', '');
INSERT INTO `05diseases` VALUES ('4248', '毛细血管扩张性环状紫癜[马约基氏病]', '481', 'D69.251', 'MXXGKZXHZZDMYJSB', '');
INSERT INTO `05diseases` VALUES ('4249', '加德纳-戴蒙德综合征[疼痛性青肿综合征]', '273', 'D69.252', 'JDNDMDZHZTTXQZZHZ', '');
INSERT INTO `05diseases` VALUES ('4250', '埃文斯综合征', '278', 'D69.301', 'AWSZHZ', '');
INSERT INTO `05diseases` VALUES ('4251', '出血性紫癜', '481', 'D69.302', 'CXXZD', '');
INSERT INTO `05diseases` VALUES ('4252', '特发性血小板减少性紫癜[埃文斯综合征ITP]', '481', 'D69.351', 'TFXXXBJSXZDAWSZHZ', '');
INSERT INTO `05diseases` VALUES ('4253', '巨核细胞再生不良', '376', 'D69.401', 'JHXBZSBL', '');
INSERT INTO `05diseases` VALUES ('4254', '免疫性血小板减少性紫癜', '228', 'D69.402', 'MYXXXBJSXZD', '');
INSERT INTO `05diseases` VALUES ('4255', '无巨核细胞性血小板减少性紫癜', '481', 'D69.403', 'WJHXBXXXBJSXZD', '');
INSERT INTO `05diseases` VALUES ('4256', '先天性血小板减少症', '383', 'D69.404', 'XTXXXBJSZ', '');
INSERT INTO `05diseases` VALUES ('4257', '血小板减少性紫癜', '481', 'D69.405', 'XXBJSXZD', '');
INSERT INTO `05diseases` VALUES ('4258', '原发性血小板减少性紫癜', '481', 'D69.406', 'YFXXXBJSXZD', '');
INSERT INTO `05diseases` VALUES ('4259', '原发性血小板减少症', '420', 'D69.407', 'YFXXXBJSZ', '');
INSERT INTO `05diseases` VALUES ('4260', '单纯性遗传性紫癜', '481', 'D69.451', 'DCXYCXZD', '');
INSERT INTO `05diseases` VALUES ('4261', '继发性血小板减少性紫癜', '481', 'D69.501', 'JFXXXBJSXZD', '');
INSERT INTO `05diseases` VALUES ('4262', '继发性血小板减少症', '420', 'D69.502', 'JFXXXBJSZ', '');
INSERT INTO `05diseases` VALUES ('4263', '药物性血小板减少性紫癜', '481', 'D69.503', 'YWXXXBJSXZD', '');
INSERT INTO `05diseases` VALUES ('4264', '药物性血小板减少症', '420', 'D69.504', 'YWXXXBJSZ', '');
INSERT INTO `05diseases` VALUES ('4265', '类固醇紫癜', '481', 'D69.551', 'LGCZD', '');
INSERT INTO `05diseases` VALUES ('4266', '输血后紫癜', '481', 'D69.552', 'SXHZD', '');
INSERT INTO `05diseases` VALUES ('4267', '原因不明性血小板减少性紫癜', '481', 'D69.553', 'YYBMXXXBJSXZD', '');
INSERT INTO `05diseases` VALUES ('4268', '获得性巨细胞性血小板减少', '376', 'D69.601', 'HDXJXBXXXBJS', '');
INSERT INTO `05diseases` VALUES ('4269', '血小板减少症', '420', 'D69.602', 'XXBJSZ', '');
INSERT INTO `05diseases` VALUES ('4270', 'Kasabach-Merritt综合征', '278', 'D69.801', 'ZHZ', '');
INSERT INTO `05diseases` VALUES ('4271', '血管性假血友病', '421', 'D69.802', 'XGXJXYB', '');
INSERT INTO `05diseases` VALUES ('4272', '维生素Ｃ缺乏性紫癜', '481', 'D69.851', 'WSSQFXZD', '');
INSERT INTO `05diseases` VALUES ('4273', '遗传性毛细血管脆弱', '413', 'D69.852', 'YCXMXXGCR', '');
INSERT INTO `05diseases` VALUES ('4274', '白细胞减少症', '376', 'D70.X01', 'BXBJSZ', '');
INSERT INTO `05diseases` VALUES ('4275', '急性粒细胞缺乏症', '376', 'D70.X02', 'JXLXBQFZ', '');
INSERT INTO `05diseases` VALUES ('4276', '药物性粒细胞减少', '376', 'D70.X03', 'YWXLXBJS', '');
INSERT INTO `05diseases` VALUES ('4277', '中性白细胞减少性脾大', '253', 'D70.X04', 'ZXBXBJSXPD', '');
INSERT INTO `05diseases` VALUES ('4278', '婴儿遗传性粒细胞缺乏[科斯特曼病]', '376', 'D70.X51', 'YEYCXLXBQFKSTMB', '');
INSERT INTO `05diseases` VALUES ('4279', '粒细胞缺乏症[舒耳茨氏病]', '70', 'D70.X52', 'LXBQFZSECSB', '');
INSERT INTO `05diseases` VALUES ('4280', '恶性中性白细胞减少症', '376', 'D70.X53', 'EXZXBXBJSZ', '');
INSERT INTO `05diseases` VALUES ('4281', '继发性中性白细胞减少症', '376', 'D70.X54', 'JFXZXBXBJSZ', '');
INSERT INTO `05diseases` VALUES ('4282', '先天性中性白细胞减少症', '383', 'D70.X55', 'XTXZXBXBJSZ', '');
INSERT INTO `05diseases` VALUES ('4283', '中毒性中性白细胞减少症', '471', 'D70.X56', 'ZDXZXBXBJSZ', '');
INSERT INTO `05diseases` VALUES ('4284', '药物性中性白细胞减少症', '376', 'D70.X57', 'YWXZXBXBJSZ', '');
INSERT INTO `05diseases` VALUES ('4285', '脾性(原发性)中性白细胞减少症', '253', 'D70.X58', 'PXYFXZXBXBJSZ', '');
INSERT INTO `05diseases` VALUES ('4286', '中性粒细胞减少', '376', 'D70.X59', 'ZXLXBJS', '');
INSERT INTO `05diseases` VALUES ('4287', '慢性粒细胞缺乏', '376', 'D70.X60', 'MXLXBQF', '');
INSERT INTO `05diseases` VALUES ('4288', '婴儿期粒细胞缺乏', '376', 'D70.X61', 'YEQLXBQF', '');
INSERT INTO `05diseases` VALUES ('4289', '周期性粒细胞缺乏', '376', 'D70.X62', 'ZQXLXBQF', '');
INSERT INTO `05diseases` VALUES ('4290', '先天性粒细胞缺乏', '383', 'D70.X63', 'XTXLXBQF', '');
INSERT INTO `05diseases` VALUES ('4291', '粒细胞缺乏性咽峡炎', '428', 'D70.X64', 'LXBQFXYXY', '');
INSERT INTO `05diseases` VALUES ('4292', '进行性脓毒性肉芽肿病', '295', 'D71.X51', 'JXXNDXRYZB', '');
INSERT INTO `05diseases` VALUES ('4293', '先天性吞噬细胞功能不良', '383', 'D71.X52', 'XTXTSXBGNBL', '');
INSERT INTO `05diseases` VALUES ('4294', '慢性(儿童期)肉芽肿性疾病', '295', 'D71.X53', 'MXETQRYZXJB', '');
INSERT INTO `05diseases` VALUES ('4295', '网状组织发育不全', '75', 'D72.001', 'WZZZFYBQ', '');
INSERT INTO `05diseases` VALUES ('4296', '遗传性白黑变病', '268', 'D72.051', 'YCXBHBB', '');
INSERT INTO `05diseases` VALUES ('4297', '白细胞颗粒异常[奥尔德氏综合征]', '376', 'D72.052', 'BXBKLYCAEDSZHZ', '');
INSERT INTO `05diseases` VALUES ('4298', '梅－黑格林综合征', '278', 'D72.053', 'MHGLZHZ', '');
INSERT INTO `05diseases` VALUES ('4299', '佩尔格－许特综合征', '278', 'D72.054', 'PEGXTZHZ', '');
INSERT INTO `05diseases` VALUES ('4300', '遗传性白细胞性分节不足', '376', 'D72.055', 'YCXBXBXFJBZ', '');
INSERT INTO `05diseases` VALUES ('4301', '反应性嗜酸细胞增多症', '379', 'D72.101', 'FYXSSXBZDZ', '');
INSERT INTO `05diseases` VALUES ('4302', '嗜酸细胞增多症', '379', 'D72.102', 'SSXBZDZ', '');
INSERT INTO `05diseases` VALUES ('4303', '嗜酸粒细胞增多', '376', 'D72.151', 'SSLXBZD', '');
INSERT INTO `05diseases` VALUES ('4304', '变应性[过敏性]嗜酸粒细胞增多', '376', 'D72.152', 'BYXGMXSSLXBZD', '');
INSERT INTO `05diseases` VALUES ('4305', '遗传性嗜酸粒细胞增多', '376', 'D72.153', 'YCXSSLXBZD', '');
INSERT INTO `05diseases` VALUES ('4306', '白细胞增多症', '379', 'D72.801', 'BXBZDZ', '');
INSERT INTO `05diseases` VALUES ('4307', '白血病样反应', '5', 'D72.802', 'BXBYFY', '');
INSERT INTO `05diseases` VALUES ('4308', '单核细胞增多症', '379', 'D72.803', 'DHXBZDZ', '');
INSERT INTO `05diseases` VALUES ('4309', '浆细胞增多症', '379', 'D72.804', 'JXBZDZ', '');
INSERT INTO `05diseases` VALUES ('4310', '淋巴细胞减少症', '376', 'D72.805', 'LBXBJSZ', '');
INSERT INTO `05diseases` VALUES ('4311', '淋巴细胞增多症', '379', 'D72.806', 'LBXBZDZ', '');
INSERT INTO `05diseases` VALUES ('4312', '单核细胞性类白血病反应', '5', 'D72.851', 'DHXBXLBXBFY', '');
INSERT INTO `05diseases` VALUES ('4313', '淋巴细胞性类白血病反应', '5', 'D72.852', 'LBXBXLBXBFY', '');
INSERT INTO `05diseases` VALUES ('4314', '中幼粒细胞性类白血病反应', '5', 'D72.853', 'ZYLXBXLBXBFY', '');
INSERT INTO `05diseases` VALUES ('4315', '髓细胞性白血病样反应', '5', 'D72.854', 'SXBXBXBYFY', '');
INSERT INTO `05diseases` VALUES ('4316', '白细胞病 NOS', '376', 'D72.951', 'BXBB', '');
INSERT INTO `05diseases` VALUES ('4317', '非创伤性脾萎缩', '253', 'D73.001', 'FCSXPWS', '');
INSERT INTO `05diseases` VALUES ('4318', '手术后无脾', '253', 'D73.051', 'SSHWP', '');
INSERT INTO `05diseases` VALUES ('4319', '脾机能亢进', '253', 'D73.101', 'PJNKJ', '');
INSERT INTO `05diseases` VALUES ('4320', '铁质沉着性脾大[甘迪－南塔氏病]', '253', 'D73.151', 'TZCZXPDGDNTSB', '');
INSERT INTO `05diseases` VALUES ('4321', '慢性充血性脾大', '253', 'D73.201', 'MXCXXPD', '');
INSERT INTO `05diseases` VALUES ('4322', '血栓静脉炎性脾大[奥皮茨病]', '185', 'D73.251', 'XSJMYXPDAPCB', '');
INSERT INTO `05diseases` VALUES ('4323', '脾脓肿', '243', 'D73.301', 'PNZ', '');
INSERT INTO `05diseases` VALUES ('4324', '脾囊肿', '253', 'D73.401', 'PNZ', '');
INSERT INTO `05diseases` VALUES ('4325', '非创伤性脾破裂', '253', 'D73.501', 'FCSXPPL', '');
INSERT INTO `05diseases` VALUES ('4326', '脾包膜下出血', '253', 'D73.502', 'PBMXCX', '');
INSERT INTO `05diseases` VALUES ('4327', '脾梗塞', '253', 'D73.503', 'PGS', '');
INSERT INTO `05diseases` VALUES ('4328', '脾扭转', '253', 'D73.504', 'PNZ', '');
INSERT INTO `05diseases` VALUES ('4329', '脾浆细胞性肉芽肿', '253', 'D73.801', 'PJXBXRYZ', '');
INSERT INTO `05diseases` VALUES ('4330', '脾血肿机化', '253', 'D73.802', 'PXZJH', '');
INSERT INTO `05diseases` VALUES ('4331', '脾周围炎', '253', 'D73.803', 'PZWY', '');
INSERT INTO `05diseases` VALUES ('4332', '游走脾', '253', 'D73.851', 'YZP', '');
INSERT INTO `05diseases` VALUES ('4333', '脾炎', '253', 'D73.852', 'PY', '');
INSERT INTO `05diseases` VALUES ('4334', '脾纤维化', '253', 'D73.853', 'PXWH', '');
INSERT INTO `05diseases` VALUES ('4335', '脾占位性病变', '253', 'D73.901', 'PZWXBB', '');
INSERT INTO `05diseases` VALUES ('4336', '脾肿物', '253', 'D73.902', 'PZW', '');
INSERT INTO `05diseases` VALUES ('4337', '脾疾病 NOS', '253', 'D73.951', 'PJB', '');
INSERT INTO `05diseases` VALUES ('4338', '先天性高铁血红蛋白血症', '383', 'D74.001', 'XTXGTXHDBXZ', '');
INSERT INTO `05diseases` VALUES ('4339', '血红蛋白病，Ｍ型 [Hb-M]', '416', 'D74.051', 'XHDBBX', '');
INSERT INTO `05diseases` VALUES ('4340', '先天性高铁血红蛋白血症敏性还原酶缺乏[NADH]', '383', 'D74.052', 'XTXGTXHDBXZMXHYMQF', '');
INSERT INTO `05diseases` VALUES ('4341', '遗传性高铁血红蛋白血症', '6', 'D74.053', 'YCXGTXHDBXZ', '');
INSERT INTO `05diseases` VALUES ('4342', '亚硝酸盐中毒[肠原性紫绀症；斯托克维斯－塔尔玛病]', '471', 'D74.851', 'YXSYZDCYXZGZSTKWSTEM', '');
INSERT INTO `05diseases` VALUES ('4343', '中毒性高铁血红蛋白血症', '471', 'D74.852', 'ZDXGTXHDBXZ', '');
INSERT INTO `05diseases` VALUES ('4344', '高铁血红蛋白血症 NOS', '6', 'D74.901', 'GTXHDBXZ', '');
INSERT INTO `05diseases` VALUES ('4345', '家族性红细胞增多症', '379', 'D75.001', 'JZXHXBZDZ', '');
INSERT INTO `05diseases` VALUES ('4346', '良性红细胞增多症', '379', 'D75.051', 'LXHXBZDZ', '');
INSERT INTO `05diseases` VALUES ('4347', '一过性红细胞增多症', '379', 'D75.101', 'YGXHXBZDZ', '');
INSERT INTO `05diseases` VALUES ('4348', '继发性红细胞增多症', '379', 'D75.102', 'JFXHXBZDZ', '');
INSERT INTO `05diseases` VALUES ('4349', '高血压性红细胞增多症[盖斯伯克病]', '379', 'D75.151', 'GXYXHXBZDZGSBKB', '');
INSERT INTO `05diseases` VALUES ('4350', '肾源性红细胞增多症', '314', 'D75.152', 'SYXHXBZDZ', '');
INSERT INTO `05diseases` VALUES ('4351', '后天性红细胞增多症', '379', 'D75.153', 'HTXHXBZDZ', '');
INSERT INTO `05diseases` VALUES ('4352', '情绪性红细胞增多症', '379', 'D75.154', 'QXXHXBZDZ', '');
INSERT INTO `05diseases` VALUES ('4353', '低血氧性红细胞增多症', '379', 'D75.155', 'DXYXHXBZDZ', '');
INSERT INTO `05diseases` VALUES ('4354', '相对性红细胞增多症', '379', 'D75.156', 'XDXHXBZDZ', '');
INSERT INTO `05diseases` VALUES ('4355', '红细胞生成素引起的红细胞增多症', '379', 'D75.157', 'HXBSCSYQDHXBZDZ', '');
INSERT INTO `05diseases` VALUES ('4356', '血浆容积下降引起的红细胞增多症', '379', 'D75.158', 'XJRJXJYQDHXBZDZ', '');
INSERT INTO `05diseases` VALUES ('4357', '高海拔性红细胞增多症', '379', 'D75.159', 'GHBXHXBZDZ', '');
INSERT INTO `05diseases` VALUES ('4358', '应激性红细胞增多症', '379', 'D75.160', 'YJXHXBZDZ', '');
INSERT INTO `05diseases` VALUES ('4359', '血小板增多', '420', 'D75.201', 'XXBZD', '');
INSERT INTO `05diseases` VALUES ('4360', '特发性血小板增多', '420', 'D75.251', 'TFXXXBZD', '');
INSERT INTO `05diseases` VALUES ('4361', '骨髓坏死', '113', 'D75.801', 'GSHS', '');
INSERT INTO `05diseases` VALUES ('4362', '骨髓外造血灶组织', '113', 'D75.802', 'GSWZXZZZ', '');
INSERT INTO `05diseases` VALUES ('4363', '骨髓硬化', '113', 'D75.803', 'GSYH', '');
INSERT INTO `05diseases` VALUES ('4364', '骨髓增生', '113', 'D75.804', 'GSZS', '');
INSERT INTO `05diseases` VALUES ('4365', '化疗后骨髓抑制', '113', 'D75.805', 'HLHGSYZ', '');
INSERT INTO `05diseases` VALUES ('4366', '急性造血功能抑制', '275', 'D75.806', 'JXZXGNYZ', '');
INSERT INTO `05diseases` VALUES ('4367', '继发性血小板增多症', '420', 'D75.807', 'JFXXXBZDZ', '');
INSERT INTO `05diseases` VALUES ('4368', '药物性骨髓抑制', '113', 'D75.808', 'YWXGSYZ', '');
INSERT INTO `05diseases` VALUES ('4369', '嗜碱粒细胞增多症', '379', 'D75.851', 'SJLXBZDZ', '');
INSERT INTO `05diseases` VALUES ('4370', '骨髓增生减低', '113', 'D75.901', 'GSZSJD', '');
INSERT INTO `05diseases` VALUES ('4371', '造血功能停滞', '275', 'D75.902', 'ZXGNTZ', '');
INSERT INTO `05diseases` VALUES ('4372', '造血器官疾病 NOS', '275', 'D75.903', 'ZXQGJB', '');
INSERT INTO `05diseases` VALUES ('4373', '肠嗜酸性肉芽肿', '295', 'D76.001', 'CSSXRYZ', '');
INSERT INTO `05diseases` VALUES ('4374', '肺嗜酸性肉芽肿', '79', 'D76.002', 'FSSXRYZ', '');
INSERT INTO `05diseases` VALUES ('4375', '骨嗜酸细胞性肉芽肿', '295', 'D76.003', 'GSSXBXRYZ', '');
INSERT INTO `05diseases` VALUES ('4376', '嗜酸细胞性肉芽肿', '295', 'D76.004', 'SSXBXRYZ', '');
INSERT INTO `05diseases` VALUES ('4378', '颏下嗜酸性细胞增生性淋巴肉芽肿', '295', 'D76.006', 'KXSSXXBZSXLBRYZ', '');
INSERT INTO `05diseases` VALUES ('4379', '胃嗜酸性肉芽肿', '370', 'D76.007', 'WSSXRYZ', '');
INSERT INTO `05diseases` VALUES ('4380', '单核吞噬细胞朗格汉斯细胞的组织细胞增多症', '379', 'D76.051', 'DHTSXBLGHSXBDZZXBZDZ', '');
INSERT INTO `05diseases` VALUES ('4381', '慢性组织细胞增多症Ｘ', '379', 'D76.052', 'MXZZXBZDZ', '');
INSERT INTO `05diseases` VALUES ('4382', '嗜酸性胫骨肉芽肿', '295', 'D76.053', 'SSXJGRYZ', '');
INSERT INTO `05diseases` VALUES ('4383', '家族性噬红细胞性网状细胞增多', '376', 'D76.151', 'JZXSHXBXWZXBZD', '');
INSERT INTO `05diseases` VALUES ('4384', '与感染有关的噬细胞综合征', '95', 'D76.251', 'YGRYGDSXBZHZ', '');
INSERT INTO `05diseases` VALUES ('4385', '黄色肉芽肿', '295', 'D76.301', 'HSRYZ', '');
INSERT INTO `05diseases` VALUES ('4386', '网状组织细胞瘤(巨细胞)', '377', 'D76.302', 'WZZZXBLJXB', '');
INSERT INTO `05diseases` VALUES ('4387', '组织细胞增多症', '379', 'D76.303', 'ZZXBZDZ', '');
INSERT INTO `05diseases` VALUES ('4388', '组织细胞增生症Ｘ', '376', 'D76.304', 'ZZXBZSZ', '');
INSERT INTO `05diseases` VALUES ('4389', '遗传性低丙种球蛋白血症', '6', 'D80.051', 'YCXDBZQDBXZ', '');
INSERT INTO `05diseases` VALUES ('4390', '常染色体退行性(瑞士型)无丙种球蛋白血症', '6', 'D80.052', 'CRSTTXXRSXWBZQDBXZ', '');
INSERT INTO `05diseases` VALUES ('4391', 'Ｘ连锁的[布鲁顿](伴有生长激素缺乏)无丙种球蛋白血症', '6', 'D80.053', 'LSDBLDBYSCJSQFWBZQDB', '');
INSERT INTO `05diseases` VALUES ('4392', '低丙种球蛋白血症', '6', 'D80.101', 'DBZQDBXZ', '');
INSERT INTO `05diseases` VALUES ('4393', '非家族性低丙种球蛋白血症', '6', 'D80.151', 'FJZXDBZQDBXZ', '');
INSERT INTO `05diseases` VALUES ('4394', '普通易变型无丙种球蛋白血症', '6', 'D80.152', 'PTYBXWBZQDBXZ', '');
INSERT INTO `05diseases` VALUES ('4395', '免疫球蛋白Ａ[IgA]的选择性缺乏', '228', 'D80.201', 'MYQDBDXZXQF', '');
INSERT INTO `05diseases` VALUES ('4396', '免疫球蛋白Ｇ[IgG]亚类的选择性缺乏', '228', 'D80.351', 'MYQDBYLDXZXQF', '');
INSERT INTO `05diseases` VALUES ('4397', '免疫球蛋白Ｍ[IgM]的选择性缺乏', '228', 'D80.451', 'MYQDBDXZXQF', '');
INSERT INTO `05diseases` VALUES ('4398', '免疫缺陷伴有免疫球蛋白Ｍ[IgM]增多', '228', 'D80.551', 'MYQXBYMYQDBZD', '');
INSERT INTO `05diseases` VALUES ('4399', '抗体缺乏伴有接近正常的免疫球蛋白或伴有高免疫球蛋白血症', '228', 'D80.651', 'KTQFBYJJZCDMYQDBHBYG', '');
INSERT INTO `05diseases` VALUES ('4400', '婴儿期短暂性低丙球蛋白血症', '6', 'D80.751', 'YEQDZXDBQDBXZ', '');
INSERT INTO `05diseases` VALUES ('4401', '抗体缺陷为主的其他免疫缺陷', '228', 'D80.851', 'KTQXWZDQTMYQX', '');
INSERT INTO `05diseases` VALUES ('4402', 'Ｋ轻链缺乏', '278', 'D80.852', 'QLQF', '');
INSERT INTO `05diseases` VALUES ('4403', '免疫球蛋白缺乏', '228', 'D80.901', 'MYQDBQF', '');
INSERT INTO `05diseases` VALUES ('4404', '体液免疫缺乏', '228', 'D80.902', 'TYMYQF', '');
INSERT INTO `05diseases` VALUES ('4405', '抗体缺陷为主的未特指的免疫缺陷', '228', 'D80.951', 'KTQXWZDWTZDMYQX', '');
INSERT INTO `05diseases` VALUES ('4406', '严重的联合免疫缺陷[SCID]伴有网状组织发育不全', '228', 'D81.051', 'YZDLHMYQXBYWZZZFYBQ', '');
INSERT INTO `05diseases` VALUES ('4407', '严重的联合免疫缺陷[SICD]伴有低数量的Ｔ和Ｂ细胞', '228', 'D81.151', 'YZDLHMYQXBYDSLDHXB', '');
INSERT INTO `05diseases` VALUES ('4408', '严重的联合缺陷[SICD]伴有低或正常数量的Ｂ细胞', '376', 'D81.251', 'YZDLHQXBYDHZCSLDXB', '');
INSERT INTO `05diseases` VALUES ('4409', '腺苷脱氨酶缺乏[ADA]', '278', 'D81.351', 'XGTAMQF', '');
INSERT INTO `05diseases` VALUES ('4410', '胸腺发育异常综合征[奈泽洛夫综合征]', '409', 'D81.451', 'XXFYYCZHZNZLFZHZ', '');
INSERT INTO `05diseases` VALUES ('4411', '嘌呤核苷磷酸化酶缺乏[PNP]', '278', 'D81.551', 'PLHGLSHMQF', '');
INSERT INTO `05diseases` VALUES ('4412', '淋巴细胞稀少综合征', '376', 'D81.651', 'LBXBXSZHZ', '');
INSERT INTO `05diseases` VALUES ('4413', '生物素依赖羧酶缺乏', '278', 'D81.851', 'SWSYLSMQF', '');
INSERT INTO `05diseases` VALUES ('4414', '联合免疫缺乏 NOS', '228', 'D81.903', 'LHMYQF', '');
INSERT INTO `05diseases` VALUES ('4415', '严重联合免疫缺陷症[SCID]', '228', 'D81.951', 'YZLHMYQXZ', '');
INSERT INTO `05diseases` VALUES ('4416', '免疫缺陷伴血小板减少和湿疹', '228', 'D82.051', 'MYQXBXXBJSHSZ', '');
INSERT INTO `05diseases` VALUES ('4417', '维斯科特-奥尔德里奇综合征', '278', 'D82.052', 'WSKTAEDLQZHZ', '');
INSERT INTO `05diseases` VALUES ('4418', '咽囊肿综合征', '231', 'D82.151', 'YNZZHZ', '');
INSERT INTO `05diseases` VALUES ('4419', '胸腺淋巴组织发育不全', '409', 'D82.152', 'XXLBZZFYBQ', '');
INSERT INTO `05diseases` VALUES ('4420', '迪格奥尔格综合征', '278', 'D82.153', 'DGAEGZHZ', '');
INSERT INTO `05diseases` VALUES ('4421', '胸腺发育不全', '409', 'D82.154', 'XXFYBQ', '');
INSERT INTO `05diseases` VALUES ('4422', '胸腺再生不良伴免疫缺陷', '228', 'D82.155', 'XXZSBLBMYQX', '');
INSERT INTO `05diseases` VALUES ('4423', '免疫缺陷伴短肢身材', '228', 'D82.251', 'MYQXBDZSC', '');
INSERT INTO `05diseases` VALUES ('4424', 'Ｘ连锁淋巴增生性疾病', '268', 'D82.351', 'LSLBZSXJB', '');
INSERT INTO `05diseases` VALUES ('4425', '高免疫球蛋白Ｅ[IgE]综合征', '228', 'D82.451', 'GMYQDBZHZ', '');
INSERT INTO `05diseases` VALUES ('4426', '与其他特指的严重缺陷有关的免疫缺陷', '228', 'D82.851', 'YQTTZDYZQXYGDMYQX', '');
INSERT INTO `05diseases` VALUES ('4427', '严重缺陷有关的免疫缺陷 NOS', '228', 'D82.951', 'YZQXYGDMYQX', '');
INSERT INTO `05diseases` VALUES ('4428', '普通易变型免疫缺陷，伴有显著的Ｂ细胞数量和功能异常', '228', 'D83.051', 'PTYBXMYQXBYXZDXBSLHG', '');
INSERT INTO `05diseases` VALUES ('4429', '普通易变型免疫缺陷，伴有显著的免疫调节和T细胞疾患', '228', 'D83.151', 'PTYBXMYQXBYXZDMYDJHX', '');
INSERT INTO `05diseases` VALUES ('4430', '普通易变型免疫缺陷，伴有对Ｂ或Ｔ细胞的自身抗体', '228', 'D83.251', 'PTYBXMYQXBYDHXBDZSKT', '');
INSERT INTO `05diseases` VALUES ('4431', '其他普通易变型免疫缺陷', '228', 'D83.851', 'QTPTYBXMYQX', '');
INSERT INTO `05diseases` VALUES ('4432', '普通易变型免疫缺陷 NOS', '228', 'D83.951', 'PTYBXMYQX', '');
INSERT INTO `05diseases` VALUES ('4433', '淋巴细胞机能抗原-1[LFA-1]缺陷', '376', 'D84.051', 'LBXBJNKYQX', '');
INSERT INTO `05diseases` VALUES ('4434', '补体成分缺乏', '278', 'D84.101', 'BTCFQF', '');
INSERT INTO `05diseases` VALUES ('4435', '遗传性血管神经性水肿', '313', 'D84.102', 'YCXXGSJXSZ', '');
INSERT INTO `05diseases` VALUES ('4436', '补体1酯酶抑制剂缺乏[C-INH]', '278', 'D84.151', 'BTZMYZJQF', '');
INSERT INTO `05diseases` VALUES ('4437', '其他特指的免疫缺陷', '228', 'D84.851', 'QTTZDMYQX', '');
INSERT INTO `05diseases` VALUES ('4438', '免疫缺陷病 NOS', '228', 'D84.901', 'MYQXB', '');
INSERT INTO `05diseases` VALUES ('4439', '肺结节病', '79', 'D86.001', 'FJJB', '');
INSERT INTO `05diseases` VALUES ('4440', '良性淋巴肉芽肿', '295', 'D86.101', 'LXLBRYZ', '');
INSERT INTO `05diseases` VALUES ('4441', '淋巴结结节病', '172', 'D86.151', 'LBJJJB', '');
INSERT INTO `05diseases` VALUES ('4442', '肺结核病伴淋巴结结节病', '171', 'D86.251', 'FJHBBLBJJJB', '');
INSERT INTO `05diseases` VALUES ('4443', '达里耶－鲁西结节病', '172', 'D86.351', 'DLYLXJJB', '');
INSERT INTO `05diseases` VALUES ('4444', '皮肤结节病', '250', 'D86.352', 'PFJJB', '');
INSERT INTO `05diseases` VALUES ('4445', '眼色素层腮腺炎[黑福特病]', '430', 'D86.851', 'YSSCSXYHFTB', '');
INSERT INTO `05diseases` VALUES ('4446', '结节病中的多发性颅神经麻痹', '313', 'D86.852+', 'JJBZDDFXLSJMB', '');
INSERT INTO `05diseases` VALUES ('4447', '结节病中的虹膜睫状体炎', '229', 'D86.853+', 'JJBZDHMJZTY', '');
INSERT INTO `05diseases` VALUES ('4448', '结节病中的心肌炎', '397', 'D86.854+', 'JJBZDXJY', '');
INSERT INTO `05diseases` VALUES ('4449', '结节病中的关节病', '123', 'D86.855+', 'JJBZDGJB', '');
INSERT INTO `05diseases` VALUES ('4450', '结节病中的肌炎', '146', 'D86.856+', 'JJBZDJY', '');
INSERT INTO `05diseases` VALUES ('4451', '结节病 NOS', '172', 'D86.901', 'JJB', '');
INSERT INTO `05diseases` VALUES ('4452', '伯克结节病', '172', 'D86.951', 'BKJJB', '');
INSERT INTO `05diseases` VALUES ('4453', '多克隆高丙种球蛋白血症', '6', 'D89.001', 'DKLGBZQDBXZ', '');
INSERT INTO `05diseases` VALUES ('4454', '高球蛋白血症性紫癜', '481', 'D89.002', 'GQDBXZXZD', '');
INSERT INTO `05diseases` VALUES ('4455', '多克隆丙球蛋白病', '268', 'D89.051', 'DKLBQDBB', '');
INSERT INTO `05diseases` VALUES ('4456', '高丙球蛋白血症性(良性)紫癜[瓦尔登斯特伦]', '481', 'D89.052', 'GBQDBXZXLXZDWEDSTL', '');
INSERT INTO `05diseases` VALUES ('4457', '冷球蛋白血症', '6', 'D89.151', 'LQDBXZ', '');
INSERT INTO `05diseases` VALUES ('4458', '冷球蛋白血症性紫癜', '481', 'D89.152', 'LQDBXZXZD', '');
INSERT INTO `05diseases` VALUES ('4459', '冷球蛋白血症血管炎', '6', 'D89.153', 'LQDBXZXGY', '');
INSERT INTO `05diseases` VALUES ('4460', '自发性冷球蛋白血症', '6', 'D89.154', 'ZFXLQDBXZ', '');
INSERT INTO `05diseases` VALUES ('4461', '特发性冷球蛋白血症', '6', 'D89.155', 'TFXLQDBXZ', '');
INSERT INTO `05diseases` VALUES ('4462', '混合性冷球蛋白血症', '6', 'D89.156', 'HHXLQDBXZ', '');
INSERT INTO `05diseases` VALUES ('4463', '原发性冷球蛋白血症', '6', 'D89.157', 'YFXLQDBXZ', '');
INSERT INTO `05diseases` VALUES ('4464', '继发性冷球蛋白血症', '6', 'D89.158', 'JFXLQDBXZ', '');
INSERT INTO `05diseases` VALUES ('4465', '高丙种球蛋白血症', '6', 'D89.201', 'GBZQDBXZ', '');
INSERT INTO `05diseases` VALUES ('4466', '高丙球蛋白血症 NOS', '6', 'D89.251', 'GBQDBXZ', '');
INSERT INTO `05diseases` VALUES ('4467', '其他特指的免疫机制疾患，NEC', '228', 'D89.851', 'QTTZDMYJZJH', '');
INSERT INTO `05diseases` VALUES ('4468', 'POEMS综合征', '278', 'D89.901', 'ZHZ', '');
INSERT INTO `05diseases` VALUES ('4469', '免疫疾病 NOS', '228', 'D89.951', 'MYJB', '');
INSERT INTO `05diseases` VALUES ('4470', '神经病型先天性碘缺乏综合征', '313', 'E00.051', 'SJBXXTXDQFZHZ', '');
INSERT INTO `05diseases` VALUES ('4471', '神经病型地方性呆小病', '313', 'E00.052', 'SJBXDFXDXB', '');
INSERT INTO `05diseases` VALUES ('4472', '粘液水肿型先天性碘缺乏综合征', '383', 'E00.151', 'NYSZXXTXDQFZHZ', '');
INSERT INTO `05diseases` VALUES ('4473', '甲状腺功能减退的地方性呆小病', '159', 'E00.152', 'JZXGNJTDDFXDXB', '');
INSERT INTO `05diseases` VALUES ('4474', '混合型先天性碘缺乏综合征', '383', 'E00.251', 'HHXXTXDQFZHZ', '');
INSERT INTO `05diseases` VALUES ('4475', '混合型地方性呆小病', '51', 'E00.252', 'HHXDFXDXB', '');
INSERT INTO `05diseases` VALUES ('4476', '呆小病[克汀病]', '51', 'E00.901', 'DXBKTB', '');
INSERT INTO `05diseases` VALUES ('4477', '家族性地方性呆小病', '51', 'E00.951', 'JZXDFXDXB', '');
INSERT INTO `05diseases` VALUES ('4478', '先天性碘缺乏综合征', '383', 'E00.952', 'XTXDQFZHZ', '');
INSERT INTO `05diseases` VALUES ('4479', '先天性碘缺乏性甲状腺功能减退症', '383', 'E00.953', 'XTXDQFXJZXGNJTZ', '');
INSERT INTO `05diseases` VALUES ('4480', '碘缺乏相关性弥漫性(地方性)甲状腺肿', '159', 'E01.051', 'DQFXGXMMXDFXJZXZ', '');
INSERT INTO `05diseases` VALUES ('4481', '碘缺乏相关性多结节性(地方性)甲状腺肿', '159', 'E01.151', 'DQFXGXDJJXDFXJZXZ', '');
INSERT INTO `05diseases` VALUES ('4482', '幼年期缺碘性甲状腺肿', '159', 'E01.201', 'YNQQDXJZXZ', '');
INSERT INTO `05diseases` VALUES ('4483', '地方性甲状腺肿', '159', 'E01.251', 'DFXJZXZ', '');
INSERT INTO `05diseases` VALUES ('4484', '碘性甲状腺机能减退', '159', 'E01.801', 'DXJZXJNJT', '');
INSERT INTO `05diseases` VALUES ('4485', '后天性碘缺乏性甲状腺功能减退症', '159', 'E01.851', 'HTXDQFXJZXGNJTZ', '');
INSERT INTO `05diseases` VALUES ('4486', '临床症状不明显的碘缺乏性甲状腺功能减退症', '159', 'E02.X51', 'LCZZBMXDDQFXJZXGNJTZ', '');
INSERT INTO `05diseases` VALUES ('4487', '先天性(非毒性)甲状腺肿', '383', 'E03.001', 'XTXFDXJZXZ', '');
INSERT INTO `05diseases` VALUES ('4488', '先天性甲状腺功能减退症伴有弥漫性甲状腺肿', '383', 'E03.051', 'XTXJZXGNJTZBYMMXJZXZ', '');
INSERT INTO `05diseases` VALUES ('4489', '先天性实质的(非毒性)甲状腺肿', '383', 'E03.052', 'XTXSZDFDXJZXZ', '');
INSERT INTO `05diseases` VALUES ('4490', '先天性甲状腺机能不全', '383', 'E03.101', 'XTXJZXJNBQ', '');
INSERT INTO `05diseases` VALUES ('4491', '甲状腺萎缩伴呆小病', '159', 'E03.151', 'JZXWSBDXB', '');
INSERT INTO `05diseases` VALUES ('4492', '先天性甲状腺萎缩伴粘液水肿', '383', 'E03.152', 'XTXJZXWSBNYSZ', '');
INSERT INTO `05diseases` VALUES ('4493', '先天性甲状腺功能减退症不伴有甲状腺肿', '383', 'E03.153', 'XTXJZXGNJTZBBYJZXZ', '');
INSERT INTO `05diseases` VALUES ('4494', '先天性甲状腺萎缩', '383', 'E03.154', 'XTXJZXWS', '');
INSERT INTO `05diseases` VALUES ('4495', '甲状腺发育不全(伴有粘液性水肿)', '159', 'E03.155', 'JZXFYBQBYNYXSZ', '');
INSERT INTO `05diseases` VALUES ('4496', '药物性甲状腺机能减退', '159', 'E03.201', 'YWXJZXJNJT', '');
INSERT INTO `05diseases` VALUES ('4497', '抗甲状腺药物引起的甲状腺机能减退', '159', 'E03.251', 'KJZXYWYQDJZXJNJT', '');
INSERT INTO `05diseases` VALUES ('4498', '外源性物质甲状腺机能减退, NEC', '159', 'E03.252', 'WYXWZJZXJNJT', '');
INSERT INTO `05diseases` VALUES ('4499', '感染后甲状腺机能减退', '95', 'E03.351', 'GRHJZXJNJT', '');
INSERT INTO `05diseases` VALUES ('4500', '甲状腺萎缩 (后天性)', '159', 'E03.401', 'JZXWSHTX', '');
INSERT INTO `05diseases` VALUES ('4501', '甲状腺萎缩伴粘液水肿[格尔病]', '159', 'E03.451', 'JZXWSBNYSZGEB', '');
INSERT INTO `05diseases` VALUES ('4502', '粘液性水肿昏迷', '139', 'E03.551', 'NYXSZHM', '');
INSERT INTO `05diseases` VALUES ('4503', '继发性甲状腺机能减退', '159', 'E03.801', 'JFXJZXJNJT', '');
INSERT INTO `05diseases` VALUES ('4504', '原发性甲状腺机能减退', '159', 'E03.802', 'YFXJZXJNJT', '');
INSERT INTO `05diseases` VALUES ('4505', '甲状腺机能减退', '159', 'E03.901', 'JZXJNJT', '');
INSERT INTO `05diseases` VALUES ('4506', '粘液性水肿', '337', 'E03.902', 'NYXSZ', '');
INSERT INTO `05diseases` VALUES ('4507', '甲状腺机能减退性肌病', '159', 'E03.903+', 'JZXJNJTXJB', '');
INSERT INTO `05diseases` VALUES ('4508', '甲状腺机能减退性心脏病[粘液水肿性心脏病]', '403', 'E03.904+', 'JZXJNJTXXZBNYSZXXZB', '');
INSERT INTO `05diseases` VALUES ('4509', '甲状腺机能减退性肥胖', '159', 'E03.951', 'JZXJNJTXFP', '');
INSERT INTO `05diseases` VALUES ('4510', '粘液水肿性肌病', '337', 'E03.952+', 'NYSZXJB', '');
INSERT INTO `05diseases` VALUES ('4511', '单纯性甲状腺肿[胶样甲状腺]', '159', 'E04.001', 'DCXJZXZJYJZX', '');
INSERT INTO `05diseases` VALUES ('4512', '弥漫性甲状腺肿[胶样甲状腺肿]', '159', 'E04.002', 'MMXJZXZJYJZXZ', '');
INSERT INTO `05diseases` VALUES ('4513', '甲状腺囊肿', '231', 'E04.101', 'JZXNZ', '');
INSERT INTO `05diseases` VALUES ('4514', '胸骨后甲状腺囊肿', '231', 'E04.102', 'XGHJZXNZ', '');
INSERT INTO `05diseases` VALUES ('4515', '甲状腺结节', '159', 'E04.103', 'JZXJJ', '');
INSERT INTO `05diseases` VALUES ('4516', '非毒性单个甲状腺肿', '159', 'E04.151', 'FDXDGJZXZ', '');
INSERT INTO `05diseases` VALUES ('4517', '非毒性多结节甲状腺肿', '159', 'E04.251', 'FDXDJJJZXZ', '');
INSERT INTO `05diseases` VALUES ('4518', '囊性甲状腺肿', '159', 'E04.252', 'NXJZXZ', '');
INSERT INTO `05diseases` VALUES ('4519', '青春期甲状腺肿', '159', 'E04.801', 'QCQJZXZ', '');
INSERT INTO `05diseases` VALUES ('4520', '其他特指多结节性非毒性甲状腺肿', '159', 'E04.851', 'QTTZDJJXFDXJZXZ', '');
INSERT INTO `05diseases` VALUES ('4521', '甲状腺肿', '159', 'E04.901', 'JZXZ', '');
INSERT INTO `05diseases` VALUES ('4522', '结节性甲状腺肿', '159', 'E04.902', 'JJXJZXZ', '');
INSERT INTO `05diseases` VALUES ('4523', '胸骨后甲状腺肿', '159', 'E04.903', 'XGHJZXZ', '');
INSERT INTO `05diseases` VALUES ('4524', '胸骨后结节性甲状腺肿', '159', 'E04.904', 'XGHJJXJZXZ', '');
INSERT INTO `05diseases` VALUES ('4525', '非毒性结节性甲状腺肿', '159', 'E04.951', 'FDXJJXJZXZ', '');
INSERT INTO `05diseases` VALUES ('4526', '散发性结节性甲状腺肿', '159', 'E04.952', 'SFXJJXJZXZ', '');
INSERT INTO `05diseases` VALUES ('4527', '锁骨下甲状腺肿', '159', 'E04.953', 'SGXJZXZ', '');
INSERT INTO `05diseases` VALUES ('4528', '非结节性甲状腺肿', '159', 'E04.954', 'FJJXJZXZ', '');
INSERT INTO `05diseases` VALUES ('4529', '游动性甲状腺肿', '159', 'E04.955', 'YDXJZXZ', '');
INSERT INTO `05diseases` VALUES ('4530', '毒性弥漫性甲状腺肿[格雷夫斯氏病]', '159', 'E05.002', 'DXMMXJZXZGLFSSB', '');
INSERT INTO `05diseases` VALUES ('4532', '甲状腺机能亢进性突眼', '430', 'E05.004+', 'JZXJNKJXTY', '');
INSERT INTO `05diseases` VALUES ('4533', '甲状腺功能异常[巴泽多病]', '159', 'E05.051', 'JZXGNYCBZDB', '');
INSERT INTO `05diseases` VALUES ('4534', '三碘甲状腺原氨酸型甲状腺机能亢进[Ｔ3型甲亢]', '159', 'E05.052', 'SDJZXYASXJZXJNKJXJK', '');
INSERT INTO `05diseases` VALUES ('4535', '毒性甲状腺肿', '159', 'E05.053', 'DXJZXZ', '');
INSERT INTO `05diseases` VALUES ('4536', '突眼性甲状腺肿[弗拉亚尼病]', '430', 'E05.054', 'TYXJZXZFLYNB', '');
INSERT INTO `05diseases` VALUES ('4537', '甲状腺肿伴甲状腺机能亢进', '159', 'E05.055', 'JZXZBJZXJNKJ', '');
INSERT INTO `05diseases` VALUES ('4538', '甲状腺毒症，伴有单甲状腺结节', '159', 'E05.151', 'JZXDZBYDJZXJJ', '');
INSERT INTO `05diseases` VALUES ('4539', '甲状腺毒症，伴有(弥漫性)毒性单结节性甲状腺肿', '159', 'E05.152', 'JZXDZBYMMXDXDJJXJZXZ', '');
INSERT INTO `05diseases` VALUES ('4540', '结节性甲状腺肿伴甲状腺机能亢进', '159', 'E05.201', 'JJXJZXZBJZXJNKJ', '');
INSERT INTO `05diseases` VALUES ('4541', '毒性多结节甲状腺肿[继发性甲状腺机能亢进]', '159', 'E05.251', 'DXDJJJZXZJFXJZXJNKJ', '');
INSERT INTO `05diseases` VALUES ('4542', '毒性结节性甲状腺肿', '159', 'E05.252', 'DXJJXJZXZ', '');
INSERT INTO `05diseases` VALUES ('4543', '腺瘤性甲状腺肿', '261', 'E05.253', 'XLXJZXZ', '');
INSERT INTO `05diseases` VALUES ('4544', '甲状腺肿伴有结节性甲状腺机能亢进', '159', 'E05.254', 'JZXZBYJJXJZXJNKJ', '');
INSERT INTO `05diseases` VALUES ('4545', '自主性高功能性甲状腺腺瘤', '261', 'E05.255', 'ZZXGGNXJZXXL', '');
INSERT INTO `05diseases` VALUES ('4546', '普卢默氏病[毒性单结节性甲状腺肿]', '159', 'E05.256', 'PLMSBDXDJJXJZXZ', '');
INSERT INTO `05diseases` VALUES ('4547', '甲状腺毒症，伴有毒性多结节性甲状腺肿', '159', 'E05.257', 'JZXDZBYDXDJJXJZXZ', '');
INSERT INTO `05diseases` VALUES ('4548', '甲状腺毒症，来自异位甲状腺组织的或结节的', '159', 'E05.351', 'JZXDZLZYWJZXZZDHJJD', '');
INSERT INTO `05diseases` VALUES ('4549', '人为甲状腺毒症', '159', 'E05.451', 'RWJZXDZ', '');
INSERT INTO `05diseases` VALUES ('4550', '甲状腺危象', '159', 'E05.501', 'JZXWX', '');
INSERT INTO `05diseases` VALUES ('4551', '甲状腺机能亢进危象', '159', 'E05.551', 'JZXJNKJWX', '');
INSERT INTO `05diseases` VALUES ('4552', '碘原性甲状腺机能亢进', '159', 'E05.801', 'DYXJZXJNKJ', '');
INSERT INTO `05diseases` VALUES ('4553', '药物性甲状腺机能亢进', '159', 'E05.802', 'YWXJZXJNKJ', '');
INSERT INTO `05diseases` VALUES ('4554', '原发性甲状腺机能亢进', '159', 'E05.803', 'YFXJZXJNKJ', '');
INSERT INTO `05diseases` VALUES ('4555', '促甲状腺激素分泌过度', '159', 'E05.851', 'CJZXJSFMGD', '');
INSERT INTO `05diseases` VALUES ('4556', '甲状腺机能亢进', '159', 'E05.901', 'JZXJNKJ', '');
INSERT INTO `05diseases` VALUES ('4557', '肌无力综合征伴甲状腺机能亢进', '159', 'E05.902+', 'JWLZHZBJZXJNKJ', '');
INSERT INTO `05diseases` VALUES ('4558', '甲状腺机能亢进性肝病', '92', 'E05.903+', 'JZXJNKJXGB', '');
INSERT INTO `05diseases` VALUES ('4559', '甲状腺机能亢进性心脏病', '403', 'E05.904+', 'JZXJNKJXXZB', '');
INSERT INTO `05diseases` VALUES ('4560', '甲状腺机能亢进性肌病', '159', 'E05.905+', 'JZXJNKJXJB', '');
INSERT INTO `05diseases` VALUES ('4561', '甲状腺毒症肌无力综合征', '159', 'E05.951+', 'JZXDZJWLZHZ', '');
INSERT INTO `05diseases` VALUES ('4562', '急性甲状腺炎', '159', 'E06.001', 'JXJZXY', '');
INSERT INTO `05diseases` VALUES ('4563', '甲状腺脓肿', '243', 'E06.051', 'JZXNZ', '');
INSERT INTO `05diseases` VALUES ('4564', '化脓性甲状腺炎', '159', 'E06.052', 'HNXJZXY', '');
INSERT INTO `05diseases` VALUES ('4565', '肉芽肿型[德奎尔万](亚急性)甲状腺炎', '295', 'E06.101', 'RYZXDKEWYJXJZXY', '');
INSERT INTO `05diseases` VALUES ('4566', '亚急性甲状腺炎(德.奎尔万氏甲状腺炎)', '159', 'E06.102', 'YJXJZXYDKEWSJZXY', '');
INSERT INTO `05diseases` VALUES ('4567', '非化脓性甲状腺炎', '159', 'E06.151', 'FHNXJZXY', '');
INSERT INTO `05diseases` VALUES ('4568', '巨细胞性甲状腺炎', '159', 'E06.152', 'JXBXJZXY', '');
INSERT INTO `05diseases` VALUES ('4569', '慢性伴有短暂性甲状腺毒症甲状腺炎', '159', 'E06.251', 'MXBYDZXJZXDZJZXY', '');
INSERT INTO `05diseases` VALUES ('4570', '淋巴细胞性甲状腺炎', '159', 'E06.301', 'LBXBXJZXY', '');
INSERT INTO `05diseases` VALUES ('4571', '桥本氏病', '268', 'E06.302', 'QBSB', '');
INSERT INTO `05diseases` VALUES ('4572', '淋巴瘤性甲状腺瘤', '208', 'E06.351', 'LBLXJZXL', '');
INSERT INTO `05diseases` VALUES ('4573', '慢性淋巴细胞性甲状腺炎[桥本氏甲状腺炎]', '159', 'E06.352', 'MXLBXBXJZXYQBSJZXY', '');
INSERT INTO `05diseases` VALUES ('4574', '自体免疫性甲状腺炎', '228', 'E06.353', 'ZTMYXJZXY', '');
INSERT INTO `05diseases` VALUES ('4575', '淋巴瘤性甲状腺肿', '208', 'E06.354', 'LBLXJZXZ', '');
INSERT INTO `05diseases` VALUES ('4576', '桥本甲状腺毒症(短暂性)', '159', 'E06.355', 'QBJZXDZDZX', '');
INSERT INTO `05diseases` VALUES ('4577', '药物性甲状腺炎', '159', 'E06.451', 'YWXJZXY', '');
INSERT INTO `05diseases` VALUES ('4578', '甲状腺炎性包块', '159', 'E06.501', 'JZXYXBK', '');
INSERT INTO `05diseases` VALUES ('4579', '慢性甲状腺炎', '159', 'E06.502', 'MXJZXY', '');
INSERT INTO `05diseases` VALUES ('4580', '慢性纤维性甲状腺炎[硬化性或慢性纤维甲腺炎]', '159', 'E06.551', 'MXXWXJZXYYHXHMXXWJXY', '');
INSERT INTO `05diseases` VALUES ('4581', '侵袭性纤维性甲状腺炎', '159', 'E06.552', 'QXXXWXJZXY', '');
INSERT INTO `05diseases` VALUES ('4582', '里德尔氏甲状腺炎', '159', 'E06.553', 'LDESJZXY', '');
INSERT INTO `05diseases` VALUES ('4583', '甲状腺炎 NOS', '159', 'E06.901', 'JZXY', '');
INSERT INTO `05diseases` VALUES ('4584', '高降钙素血症', '275', 'E07.001', 'GJGSXZ', '');
INSERT INTO `05diseases` VALUES ('4585', '降钙素分泌过多', '278', 'E07.051', 'JGSFMGD', '');
INSERT INTO `05diseases` VALUES ('4586', '甲状腺Ｃ细胞增生', '159', 'E07.052', 'JZXXBZS', '');
INSERT INTO `05diseases` VALUES ('4587', '激素障碍性甲状腺肿', '159', 'E07.101', 'JSZAXJZXZ', '');
INSERT INTO `05diseases` VALUES ('4588', '家族性呆小聋哑症[彭德莱综合征]', '71', 'E07.151', 'JZXDXLYZPDLZHZ', '');
INSERT INTO `05diseases` VALUES ('4589', '家族性激素生成障碍性甲状腺肿', '159', 'E07.152', 'JZXJSSCZAXJZXZ', '');
INSERT INTO `05diseases` VALUES ('4590', '甲状腺出血', '159', 'E07.801', 'JZXCX', '');
INSERT INTO `05diseases` VALUES ('4591', '甲状腺钙化', '159', 'E07.802', 'JZXGH', '');
INSERT INTO `05diseases` VALUES ('4592', '甲状腺激素不敏感综合征(T4抵抗综合征)', '159', 'E07.803', 'JZXJSBMGZHZDKZHZ', '');
INSERT INTO `05diseases` VALUES ('4593', '甲状腺肿物', '159', 'E07.804', 'JZXZW', '');
INSERT INTO `05diseases` VALUES ('4594', '手术后甲状腺瘘', '330', 'E07.805', 'SSHJZXL', '');
INSERT INTO `05diseases` VALUES ('4595', '病态甲状腺机能正常综合征', '159', 'E07.851', 'BTJZXJNZCZHZ', '');
INSERT INTO `05diseases` VALUES ('4596', '甲状腺梗塞', '159', 'E07.852', 'JZXGS', '');
INSERT INTO `05diseases` VALUES ('4597', '甲状腺结合球蛋白异常', '159', 'E07.853', 'JZXJHQDBYC', '');
INSERT INTO `05diseases` VALUES ('4598', '胰岛素依赖型糖尿病', '348', 'E10.901', 'YDSYLXTNB', '');
INSERT INTO `05diseases` VALUES ('4599', '胰岛素依赖Ⅰ型糖尿病', '348', 'E10.951', 'YDSYLYXTNB', '');
INSERT INTO `05diseases` VALUES ('4600', '脆弱型糖尿病', '348', 'E10.952', 'CRXTNB', '');
INSERT INTO `05diseases` VALUES ('4601', '幼年型糖尿病', '348', 'E10.953', 'YNXTNB', '');
INSERT INTO `05diseases` VALUES ('4602', '趋酮症性糖尿病', '348', 'E10.954', 'QTZXTNB', '');
INSERT INTO `05diseases` VALUES ('4603', '非胰岛素依赖型糖尿病', '348', 'E11.901', 'FYDSYLXTNB', '');
INSERT INTO `05diseases` VALUES ('4604', '成年型糖尿病[成人发病型糖尿病]', '348', 'E11.951', 'CNXTNBCRFBXTNB', '');
INSERT INTO `05diseases` VALUES ('4605', '非胰岛素依赖Ⅱ型糖尿病', '348', 'E11.952', 'FYDSYLEXTNB', '');
INSERT INTO `05diseases` VALUES ('4606', '成熟期发病糖尿病(非肥胖)(肥胖)', '348', 'E11.953', 'CSQFBTNBFFPFP', '');
INSERT INTO `05diseases` VALUES ('4607', '非酮症性糖尿病', '348', 'E11.954', 'FTZXTNB', '');
INSERT INTO `05diseases` VALUES ('4608', '青年的非胰岛素依赖型糖尿病', '348', 'E11.955', 'QNDFYDSYLXTNB', '');
INSERT INTO `05diseases` VALUES ('4609', '营养不良性糖尿病', '348', 'E12.951', 'YYBLXTNB', '');
INSERT INTO `05diseases` VALUES ('4610', '非胰岛素依赖型营养不良相关性糖尿病', '348', 'E12.952', 'FYDSYLXYYBLXGXTNB', '');
INSERT INTO `05diseases` VALUES ('4611', '肝性糖尿病', '348', 'E13.901', 'GXTNB', '');
INSERT INTO `05diseases` VALUES ('4612', '继发性糖尿病', '348', 'E13.902', 'JFXTNB', '');
INSERT INTO `05diseases` VALUES ('4613', '类固醇性糖尿病，正确用药所致', '348', 'E13.903', 'LGCXTNBZQYYSZ', '');
INSERT INTO `05diseases` VALUES ('4614', '医源性糖尿病', '348', 'E13.904', 'YYXTNB', '');
INSERT INTO `05diseases` VALUES ('4615', '其他特指的糖尿病', '348', 'E13.951', 'QTTZDTNB', '');
INSERT INTO `05diseases` VALUES ('4616', '糖尿病高渗性昏迷(糖尿病高渗性非酮症)', '348', 'E14.001', 'TNBGSXHMTNBGSXFTZ', '');
INSERT INTO `05diseases` VALUES ('4617', '糖尿病性昏迷', '348', 'E14.002', 'TNBXHM', '');
INSERT INTO `05diseases` VALUES ('4618', '胰岛素昏迷', '436', 'E14.003', 'YDSHM', '');
INSERT INTO `05diseases` VALUES ('4619', '糖尿病性酸中毒', '348', 'E14.101', 'TNBXSZD', '');
INSERT INTO `05diseases` VALUES ('4620', '糖尿病性酮症', '348', 'E14.102', 'TNBXTZ', '');
INSERT INTO `05diseases` VALUES ('4621', '糖尿病性酮症酸中毒', '348', 'E14.103', 'TNBXTZSZD', '');
INSERT INTO `05diseases` VALUES ('4622', '基-威氏综合征(毛细管间性肾小球硬化)', '314', 'E14.201+', 'JWSZHZMXGJXSXQYH', '');
INSERT INTO `05diseases` VALUES ('4623', '结节型糖尿病肾小球硬化', '348', 'E14.202+', 'JJXTNBSXQYH', '');
INSERT INTO `05diseases` VALUES ('4624', '糖尿病性肾病', '348', 'E14.203+', 'TNBXSB', '');
INSERT INTO `05diseases` VALUES ('4625', '糖尿病并眼部病变', '348', 'E14.301', 'TNBBYBBB', '');
INSERT INTO `05diseases` VALUES ('4626', 'DIDMOAD综合征 [视神经萎缩糖果尿病综合症]', '313', 'E14.302+', 'ZHZSSJWSTGNBZHZ', '');
INSERT INTO `05diseases` VALUES ('4627', '糖尿病性白内障', '348', 'E14.303+', 'TNBXBNZ', '');
INSERT INTO `05diseases` VALUES ('4628', '糖尿病性视网膜病', '348', 'E14.304+', 'TNBXSWMB', '');
INSERT INTO `05diseases` VALUES ('4629', '糖尿病眼漏', '348', 'E14.305+', 'TNBYL', '');
INSERT INTO `05diseases` VALUES ('4630', '糖尿病性虹膜炎', '348', 'E14.351+', 'TNBXHMY', '');
INSERT INTO `05diseases` VALUES ('4631', '糖尿病性眼病', '348', 'E14.352+', 'TNBXYB', '');
INSERT INTO `05diseases` VALUES ('4632', '糖尿病性眼底病变', '348', 'E14.353+', 'TNBXYDBB', '');
INSERT INTO `05diseases` VALUES ('4633', '糖尿病性神经元性膀胱炎', '313', 'E14.401+', 'TNBXSJYXBGY', '');
INSERT INTO `05diseases` VALUES ('4634', '糖尿病性单神经病', '313', 'E14.402+', 'TNBXDSJB', '');
INSERT INTO `05diseases` VALUES ('4635', '糖尿病性多神经病', '313', 'E14.403+', 'TNBXDSJB', '');
INSERT INTO `05diseases` VALUES ('4636', '糖尿病性肌萎缩', '348', 'E14.404+', 'TNBXJWS', '');
INSERT INTO `05diseases` VALUES ('4637', '糖尿病性神经病变', '313', 'E14.405+', 'TNBXSJBB', '');
INSERT INTO `05diseases` VALUES ('4638', '糖尿病性神经炎', '313', 'E14.406+', 'TNBXSJY', '');
INSERT INTO `05diseases` VALUES ('4639', '糖尿病性植物神经紊乱', '313', 'E14.407+', 'TNBXZWSJWL', '');
INSERT INTO `05diseases` VALUES ('4640', '糖尿病性周围神经病', '313', 'E14.408+', 'TNBXZWSJB', '');
INSERT INTO `05diseases` VALUES ('4641', '糖尿病性肌无力综合征', '348', 'E14.451+', 'TNBXJWLZHZ', '');
INSERT INTO `05diseases` VALUES ('4642', '糖尿病性坏疽', '348', 'E14.501', 'TNBXHJ', '');
INSERT INTO `05diseases` VALUES ('4643', '糖尿病性脑血管病变', '348', 'E14.502+', 'TNBXNXGBB', '');
INSERT INTO `05diseases` VALUES ('4644', '糖尿病性周围血管病变', '348', 'E14.503+', 'TNBXZWXGBB', '');
INSERT INTO `05diseases` VALUES ('4645', '糖尿病性冠心病', '348', 'E14.551', 'TNBXGXB', '');
INSERT INTO `05diseases` VALUES ('4646', '糖尿病合并其他特指的并发症', '348', 'E14.601', 'TNBHBQTTZDBFZ', '');
INSERT INTO `05diseases` VALUES ('4647', '糖尿病性骨病', '348', 'E14.602', 'TNBXGB', '');
INSERT INTO `05diseases` VALUES ('4648', '糖尿病性皮肤病', '348', 'E14.603', 'TNBXPFB', '');
INSERT INTO `05diseases` VALUES ('4649', '糖尿病性牙周病', '348', 'E14.604', 'TNBXYZB', '');
INSERT INTO `05diseases` VALUES ('4650', '糖尿病性硬皮病', '348', 'E14.605', 'TNBXYPB', '');
INSERT INTO `05diseases` VALUES ('4651', '糖尿病性足病', '348', 'E14.606', 'TNBXZB', '');
INSERT INTO `05diseases` VALUES ('4652', '糖尿病性大疱病', '348', 'E14.607+', 'TNBXDPB', '');
INSERT INTO `05diseases` VALUES ('4653', '糖尿病性神经原性膀胱', '313', 'E14.608+', 'TNBXSJYXBG', '');
INSERT INTO `05diseases` VALUES ('4654', '糖尿病性夏科氏关节病', '348', 'E14.609+', 'TNBXXKSGJB', '');
INSERT INTO `05diseases` VALUES ('4655', '糖尿病性心脏病', '403', 'E14.610+', 'TNBXXZB', '');
INSERT INTO `05diseases` VALUES ('4656', '糖尿病性腹泻', '348', 'E14.651', 'TNBXFX', '');
INSERT INTO `05diseases` VALUES ('4657', '糖尿病性肝病', '348', 'E14.652', 'TNBXGB', '');
INSERT INTO `05diseases` VALUES ('4658', '糖尿病性肠病', '348', 'E14.653', 'TNBXCB', '');
INSERT INTO `05diseases` VALUES ('4659', '糖尿病性关节病', '348', 'E14.654+', 'TNBXGJB', '');
INSERT INTO `05diseases` VALUES ('4660', '糖尿病性神经性关节病', '313', 'E14.655+', 'TNBXSJXGJB', '');
INSERT INTO `05diseases` VALUES ('4661', '糖尿病伴有多个并发症', '348', 'E14.751', 'TNBBYDGBFZ', '');
INSERT INTO `05diseases` VALUES ('4662', '糖尿病性伴有未特指并发症', '348', 'E14.851', 'TNBXBYWTZBFZ', '');
INSERT INTO `05diseases` VALUES ('4663', '糖尿病 NOS', '348', 'E14.901', 'TNB', '');
INSERT INTO `05diseases` VALUES ('4664', '低血糖性昏迷', '139', 'E15.X01', 'DXTXHM', '');
INSERT INTO `05diseases` VALUES ('4665', '非糖尿病性胰岛素昏迷', '348', 'E15.X51', 'FTNBXYDSHM', '');
INSERT INTO `05diseases` VALUES ('4666', '高胰岛素血(症)伴昏迷', '436', 'E15.X52', 'GYDSXZBHM', '');
INSERT INTO `05diseases` VALUES ('4667', '胰岛素分泌过多伴低血糖昏迷', '436', 'E15.X53', 'YDSFMGDBDXTHM', '');
INSERT INTO `05diseases` VALUES ('4668', '药物性低血糖不伴有昏迷', '139', 'E16.001', 'YWXDXTBBYHM', '');
INSERT INTO `05diseases` VALUES ('4669', '反应性低血糖症(餐后低血糖症)', '56', 'E16.101', 'FYXDXTZCHDXTZ', '');
INSERT INTO `05diseases` VALUES ('4670', '高胰岛素血症', '436', 'E16.102', 'GYDSXZ', '');
INSERT INTO `05diseases` VALUES ('4671', '特发性婴儿型低血糖症', '56', 'E16.151', 'TFXYEXDXTZ', '');
INSERT INTO `05diseases` VALUES ('4672', '低血糖后(昏迷)的脑病', '234', 'E16.152+', 'DXTHHMDNB', '');
INSERT INTO `05diseases` VALUES ('4673', '功能性非高胰岛素性低血糖', '436', 'E16.153', 'GNXFGYDSXDXT', '');
INSERT INTO `05diseases` VALUES ('4674', '胰岛素分泌过多', '436', 'E16.154', 'YDSFMGD', '');
INSERT INTO `05diseases` VALUES ('4675', '功能性胰岛素分泌过多', '436', 'E16.155', 'GNXYDSFMGD', '');
INSERT INTO `05diseases` VALUES ('4676', '胰岛β细胞增生', '376', 'E16.156', 'YDXBZS', '');
INSERT INTO `05diseases` VALUES ('4677', '低血糖症', '56', 'E16.201', 'DXTZ', '');
INSERT INTO `05diseases` VALUES ('4678', '高血糖素分泌异常', '98', 'E16.351', 'GXTSFMYC', '');
INSERT INTO `05diseases` VALUES ('4679', '高血糖素分泌过多', '98', 'E16.352', 'GXTSFMGD', '');
INSERT INTO `05diseases` VALUES ('4680', '胰腺内分泌细胞增生伴有(胰)高血糖素分泌过多', '262', 'E16.353', 'YXNFMXBZSBYYGXTSFMGD', '');
INSERT INTO `05diseases` VALUES ('4681', '促胃液素分泌异常', '370', 'E16.801', 'CWYSFMYC', '');
INSERT INTO `05diseases` VALUES ('4682', '高胃泌素血症', '370', 'E16.802', 'GWMSXZ', '');
INSERT INTO `05diseases` VALUES ('4683', '佐林格－埃利综合征(胰的促胃液素瘤)', '370', 'E16.803', 'ZLGALZHZYDCWYSL', '');
INSERT INTO `05diseases` VALUES ('4684', '生长激素释放素胰腺内分泌增加', '262', 'E16.851', 'SCJSSFSYXNFMZJ', '');
INSERT INTO `05diseases` VALUES ('4685', '胰多肽胰腺内分泌增加', '262', 'E16.852', 'YDTYXNFMZJ', '');
INSERT INTO `05diseases` VALUES ('4686', '生长抑制素胰腺内分泌增加', '262', 'E16.853', 'SCYZSYXNFMZJ', '');
INSERT INTO `05diseases` VALUES ('4687', '肠血管活性多肽胰腺内分泌增加', '262', 'E16.854', 'CXGHXDTYXNFMZJ', '');
INSERT INTO `05diseases` VALUES ('4688', '胰岛细胞增生症', '376', 'E16.901', 'YDXBZSZ', '');
INSERT INTO `05diseases` VALUES ('4689', '胰腺内分泌细胞增生', '262', 'E16.951', 'YXNFMXBZS', '');
INSERT INTO `05diseases` VALUES ('4690', '原发性甲状旁腺机能减退', '158', 'E20.001', 'YFXJZPXJNJT', '');
INSERT INTO `05diseases` VALUES ('4691', '特发性甲状旁腺功能减退症', '158', 'E20.051', 'TFXJZPXGNJTZ', '');
INSERT INTO `05diseases` VALUES ('4692', '假假性甲状旁腺功能亢进', '158', 'E20.101', 'JJXJZPXGNKJ', '');
INSERT INTO `05diseases` VALUES ('4693', '假性甲状旁腺机能减退', '158', 'E20.102', 'JXJZPXJNJT', '');
INSERT INTO `05diseases` VALUES ('4694', '继发性甲状旁腺机能减退', '158', 'E20.801', 'JFXJZPXJNJT', '');
INSERT INTO `05diseases` VALUES ('4695', '其他甲状旁腺功能减退症', '158', 'E20.851', 'QTJZPXGNJTZ', '');
INSERT INTO `05diseases` VALUES ('4696', '家族性甲状旁腺功能减退症', '158', 'E20.852', 'JZXJZPXGNJTZ', '');
INSERT INTO `05diseases` VALUES ('4697', '甲状旁腺机能减退', '158', 'E20.901', 'JZPXJNJT', '');
INSERT INTO `05diseases` VALUES ('4698', '甲状旁腺性手足搐搦', '158', 'E20.902', 'JZPXXSZCN', '');
INSERT INTO `05diseases` VALUES ('4699', '低钙性白内障，于甲状旁腺机能减退', '4', 'E20.903+', 'DGXBNZYJZPXJNJT', '');
INSERT INTO `05diseases` VALUES ('4700', '甲状旁腺增生', '158', 'E21.001', 'JZPXZS', '');
INSERT INTO `05diseases` VALUES ('4701', '上肢骨囊性纤维性骨炎', '115', 'E21.002', 'SZGNXXWXGY', '');
INSERT INTO `05diseases` VALUES ('4702', '下颌骨囊性纤维性骨炎', '115', 'E21.003', 'XHGNXXWXGY', '');
INSERT INTO `05diseases` VALUES ('4703', '下肢骨囊性纤维性骨炎', '115', 'E21.004', 'XZGNXXWXGY', '');
INSERT INTO `05diseases` VALUES ('4704', '原发性甲状旁腺机能亢进', '158', 'E21.005', 'YFXJZPXJNKJ', '');
INSERT INTO `05diseases` VALUES ('4705', '全身性纤维囊性骨炎[骨的冯.雷克林豪森病]', '115', 'E21.051', 'QSXXWNXGYGDFLKLHSB', '');
INSERT INTO `05diseases` VALUES ('4706', '继发性甲状旁腺机能亢进', '158', 'E21.101', 'JFXJZPXJNKJ', '');
INSERT INTO `05diseases` VALUES ('4707', '其他甲状旁腺机能亢进', '158', 'E21.251', 'QTJZPXJNKJ', '');
INSERT INTO `05diseases` VALUES ('4708', '甲状旁腺机能亢进 NOS', '158', 'E21.301', 'JZPXJNKJ', '');
INSERT INTO `05diseases` VALUES ('4709', '甲状旁腺出血', '38', 'E21.401', 'JZPXCX', '');
INSERT INTO `05diseases` VALUES ('4710', '甲状旁腺囊肿', '231', 'E21.402', 'JZPXNZ', '');
INSERT INTO `05diseases` VALUES ('4711', '甲状旁腺炎', '158', 'E21.551', 'JZPXY', '');
INSERT INTO `05diseases` VALUES ('4712', '巨人症(垂体性)', '45', 'E22.001', 'JRZCTX', '');
INSERT INTO `05diseases` VALUES ('4713', '生长激素生成过多', '278', 'E22.002', 'SCJSSCGD', '');
INSERT INTO `05diseases` VALUES ('4714', '肢端肥大症', '466', 'E22.003', 'ZDFDZ', '');
INSERT INTO `05diseases` VALUES ('4715', '肢端肥大和垂体性巨人症关节病', '123', 'E22.051+', 'ZDFDHCTXJRZGJB', '');
INSERT INTO `05diseases` VALUES ('4716', '高泌乳素血症', '275', 'E22.101', 'GMRSXZ', '');
INSERT INTO `05diseases` VALUES ('4717', '抗利尿激素分泌异常综合征', '269', 'E22.201', 'KLNJSFMYCZHZ', '');
INSERT INTO `05diseases` VALUES ('4718', '中枢性性早熟', '459', 'E22.851', 'ZSXXZS', '');
INSERT INTO `05diseases` VALUES ('4719', '垂体机能亢进', '45', 'E22.901', 'CTJNKJ', '');
INSERT INTO `05diseases` VALUES ('4720', '垂体机能减退性肌病', '45', 'E23.001+', 'CTJNJTXJB', '');
INSERT INTO `05diseases` VALUES ('4721', '卡尔曼氏综合征[嗅觉缺失-性腺机能减退]', '278', 'E23.002', 'KEMSZHZXJQSXXJNJT', '');
INSERT INTO `05diseases` VALUES ('4722', '产后垂体坏死(席汉氏病)', '25', 'E23.003', 'CHCTHSXHSB', '');
INSERT INTO `05diseases` VALUES ('4723', '席汉氏综合征(产后垂体机能不全综合征)', '25', 'E23.004', 'XHSZHZCHCTJNBQZHZ', '');
INSERT INTO `05diseases` VALUES ('4724', '产后垂体前叶机能减退[希恩综合征]', '25', 'E23.005', 'CHCTQYJNJTXEZHZ', '');
INSERT INTO `05diseases` VALUES ('4725', '垂体功能低下', '45', 'E23.006', 'CTGNDX', '');
INSERT INTO `05diseases` VALUES ('4726', '垂体机能减退', '45', 'E23.007', 'CTJNJT', '');
INSERT INTO `05diseases` VALUES ('4727', '垂体前叶机能减退', '45', 'E23.008', 'CTQYJNJT', '');
INSERT INTO `05diseases` VALUES ('4728', '垂体前叶机能减退危象', '45', 'E23.009', 'CTQYJNJTWX', '');
INSERT INTO `05diseases` VALUES ('4729', '垂体性侏儒', '45', 'E23.010', 'CTXZR', '');
INSERT INTO `05diseases` VALUES ('4730', '孤立性促性腺激素缺乏', '278', 'E23.011', 'GLXCXXJSQF', '');
INSERT INTO `05diseases` VALUES ('4731', '全垂体机能减退', '45', 'E23.012', 'QCTJNJT', '');
INSERT INTO `05diseases` VALUES ('4732', '生长激素缺乏症', '278', 'E23.013', 'SCJSQFZ', '');
INSERT INTO `05diseases` VALUES ('4733', '停经泌乳综合征', '278', 'E23.014', 'TJMRZHZ', '');
INSERT INTO `05diseases` VALUES ('4734', '单纯黄体生成激素缺乏', '278', 'E23.051', 'DCHTSCJSQF', '');
INSERT INTO `05diseases` VALUES ('4735', '成人垂体功能减退症[西蒙兹综合征、垂体性恶病质]', '45', 'E23.054', 'CRCTGNJTZXMZZHZCTXEB', '');
INSERT INTO `05diseases` VALUES ('4736', '洛兰(－勒维)身材矮小症', '312', 'E23.055', 'LLLWSCAXZ', '');
INSERT INTO `05diseases` VALUES ('4737', '男性单纯性促性腺激素缺乏症', '47', 'E23.056', 'NXDCXCXXJSQFZ', '');
INSERT INTO `05diseases` VALUES ('4738', '女性单纯性促性腺激素缺乏症', '47', 'E23.057', 'NXDCXCXXJSQFZ', '');
INSERT INTO `05diseases` VALUES ('4739', '婴儿粘液性水肿[布里索氏幼稚型]', '337', 'E23.058', 'YENYXSZBLSSYZX', '');
INSERT INTO `05diseases` VALUES ('4740', '垂体功能减退性肌病', '45', 'E23.060+', 'CTGNJTXJB', '');
INSERT INTO `05diseases` VALUES ('4741', '医源性垂体机能减退', '45', 'E23.151', 'YYXCTJNJT', '');
INSERT INTO `05diseases` VALUES ('4742', '脑外伤后尿崩症', '234', 'E23.201', 'NWSHNBZ', '');
INSERT INTO `05diseases` VALUES ('4743', '尿崩症(垂体性尿崩症)', '45', 'E23.202', 'NBZCTXNBZ', '');
INSERT INTO `05diseases` VALUES ('4744', '垂体机能不良', '45', 'E23.301', 'CTJNBL', '');
INSERT INTO `05diseases` VALUES ('4745', '下丘脑综合征', '234', 'E23.302', 'XQNZHZ', '');
INSERT INTO `05diseases` VALUES ('4746', '垂体机能障碍', '45', 'E23.351', 'CTJNZA', '');
INSERT INTO `05diseases` VALUES ('4747', '鞍区病变', '268', 'E23.601', 'AQBB', '');
INSERT INTO `05diseases` VALUES ('4748', '垂体疤痕形成', '45', 'E23.602', 'CTBHXC', '');
INSERT INTO `05diseases` VALUES ('4749', '垂体出血', '45', 'E23.603', 'CTCX', '');
INSERT INTO `05diseases` VALUES ('4750', '垂体钙化', '45', 'E23.604', 'CTGH', '');
INSERT INTO `05diseases` VALUES ('4751', '垂体管囊肿', '231', 'E23.605', 'CTGNZ', '');
INSERT INTO `05diseases` VALUES ('4752', '垂体囊肿', '231', 'E23.606', 'CTNZ', '');
INSERT INTO `05diseases` VALUES ('4753', '垂体脓肿', '243', 'E23.607', 'CTNZ', '');
INSERT INTO `05diseases` VALUES ('4754', '垂体炎', '45', 'E23.608', 'CTY', '');
INSERT INTO `05diseases` VALUES ('4755', '垂体性肥胖', '45', 'E23.609', 'CTXFP', '');
INSERT INTO `05diseases` VALUES ('4756', '垂体增大', '45', 'E23.610', 'CTZD', '');
INSERT INTO `05diseases` VALUES ('4757', '下丘脑性肥胖', '234', 'E23.611', 'XQNXFP', '');
INSERT INTO `05diseases` VALUES ('4758', '垂体肿物', '45', 'E23.612', 'CTZW', '');
INSERT INTO `05diseases` VALUES ('4759', '垂体卒中', '45', 'E23.613', 'CTZZ', '');
INSERT INTO `05diseases` VALUES ('4760', '蝶鞍扩大', '278', 'E23.614', 'DAKD', '');
INSERT INTO `05diseases` VALUES ('4761', '反馈性垂体瘤综合征', '261', 'E23.615', 'FKXCTLZHZ', '');
INSERT INTO `05diseases` VALUES ('4762', '肥胖--生殖无能综合征[弗勒赫利希综合征]', '77', 'E23.616', 'FPSZWNZHZFLHLXZHZ', '');
INSERT INTO `05diseases` VALUES ('4763', '间脑综合征', '234', 'E23.617', 'JNZHZ', '');
INSERT INTO `05diseases` VALUES ('4764', '空泡蝶鞍综合症', '278', 'E23.618', 'KPDAZHZ', '');
INSERT INTO `05diseases` VALUES ('4765', '脑性肥胖', '234', 'E23.651', 'NXFP', '');
INSERT INTO `05diseases` VALUES ('4766', '垂体促肾上腺皮质激素分类过多', '314', 'E24.001', 'CTCSSXPZJSFLGD', '');
INSERT INTO `05diseases` VALUES ('4767', '促肾上腺皮质激素生成过多', '314', 'E24.002', 'CSSXPZJSSCGD', '');
INSERT INTO `05diseases` VALUES ('4768', '垂体性嗜碱细胞增生', '45', 'E24.003', 'CTXSJXBZS', '');
INSERT INTO `05diseases` VALUES ('4769', '皮质醇增多症[库欣(柯兴)氏综合征]', '278', 'E24.051', 'PZCZDZKXKXSZHZ', '');
INSERT INTO `05diseases` VALUES ('4770', '垂体依赖性肾上腺皮质功能亢进症', '314', 'E24.052', 'CTYLXSSXPZGNKJZ', '');
INSERT INTO `05diseases` VALUES ('4771', '垂体依赖性库欣[柯兴]病', '45', 'E24.053', 'CTYLXKXKXB', '');
INSERT INTO `05diseases` VALUES ('4772', '纳尔逊氏综合征', '278', 'E24.101', 'NEXSZHZ', '');
INSERT INTO `05diseases` VALUES ('4773', '药物性皮质醇增多症，正确用药', '433', 'E24.201', 'YWXPZCZDZZQYY', '');
INSERT INTO `05diseases` VALUES ('4774', '类库欣综合征', '278', 'E24.202', 'LKXZHZ', '');
INSERT INTO `05diseases` VALUES ('4775', '药物性皮质醇增多症(库欣[柯兴]综合征)', '433', 'E24.251', 'YWXPZCZDZKXKXZHZ', '');
INSERT INTO `05diseases` VALUES ('4776', '异位促肾上腺皮质激素(瘤)综合征(ACTH)', '261', 'E24.301', 'YWCSSXPZJSLZHZ', '');
INSERT INTO `05diseases` VALUES ('4777', '醇诱发的假库欣[柯兴]综合征', '278', 'E24.451', 'CYFDJKXKXZHZ', '');
INSERT INTO `05diseases` VALUES ('4778', '其他库欣[柯兴]综合征', '278', 'E24.851', 'QTKXKXZHZ', '');
INSERT INTO `05diseases` VALUES ('4779', '库欣综合征 NOS', '278', 'E24.901', 'KXZHZ', '');
INSERT INTO `05diseases` VALUES ('4780', '11-羟化酶缺陷', '288', 'E25.001', 'QHMQX', '');
INSERT INTO `05diseases` VALUES ('4781', '17-羟化酶缺陷', '288', 'E25.002', 'QHMQX', '');
INSERT INTO `05diseases` VALUES ('4782', '21-羟化酶缺陷', '288', 'E25.003', 'QHMQX', '');
INSERT INTO `05diseases` VALUES ('4783', '男性肾上腺增生性性早熟', '314', 'E25.004', 'NXSSXZSXXZS', '');
INSERT INTO `05diseases` VALUES ('4784', '女性男性化', '278', 'E25.005', 'NXNXH', '');
INSERT INTO `05diseases` VALUES ('4785', '先天性肾上腺皮质增生', '383', 'E25.006', 'XTXSSXPZZS', '');
INSERT INTO `05diseases` VALUES ('4786', '早熟性巨睾症', '101', 'E25.007', 'ZSXJGZ', '');
INSERT INTO `05diseases` VALUES ('4787', '女性肾上腺性假两性畸形', '148', 'E25.051', 'NXSSXXJLXJX', '');
INSERT INTO `05diseases` VALUES ('4788', '先天性肾上腺征疾患伴有酶缺乏', '383', 'E25.052', 'XTXSSXZJHBYMQF', '');
INSERT INTO `05diseases` VALUES ('4789', '盐丢失性先天性肾上腺增生', '383', 'E25.053', 'YDSXXTXSSXZS', '');
INSERT INTO `05diseases` VALUES ('4790', '假性性早熟', '459', 'E25.801', 'JXXZS', '');
INSERT INTO `05diseases` VALUES ('4791', '肾上腺假两性畸形(同体)', '148', 'E25.851', 'SSXJLXJXTT', '');
INSERT INTO `05diseases` VALUES ('4792', '特发性肾上腺征疾患', '314', 'E25.852', 'TFXSSXZJH', '');
INSERT INTO `05diseases` VALUES ('4793', '药物性肾上腺征疾患', '314', 'E25.853', 'YWXSSXZJH', '');
INSERT INTO `05diseases` VALUES ('4794', '肾上腺性征综合征', '314', 'E25.901', 'SSXXZZHZ', '');
INSERT INTO `05diseases` VALUES ('4795', '阿查特－提尔斯氏Acth异位综合征', '278', 'E25.951', 'ACTTESSYWZHZ', '');
INSERT INTO `05diseases` VALUES ('4796', 'Liddle`s综合症', '278', 'E26.001', 'ZHZ', '');
INSERT INTO `05diseases` VALUES ('4797', '原发性醛固酮增多症(低肾素性醛固酮增多症)[康恩氏病]', '314', 'E26.002', 'YFXQGTZDZDSSXQGTZDZK', '');
INSERT INTO `05diseases` VALUES ('4798', '利德乐氏综合征[先天性肾小管病]', '383', 'E26.051', 'LDLSZHZXTXSXGB', '');
INSERT INTO `05diseases` VALUES ('4799', '肾上腺增生引起的原发性醛固酮过多症', '314', 'E26.052', 'SSXZSYQDYFXQGTGDZ', '');
INSERT INTO `05diseases` VALUES ('4800', '继发性醛固酮增多症', '278', 'E26.101', 'JFXQGTZDZ', '');
INSERT INTO `05diseases` VALUES ('4801', '巴特综合征[血压正常性醛固酮增多；先天性醛固酮过多症]', '383', 'E26.801', 'BTZHZXYZCXQGTZDXTXQG', '');
INSERT INTO `05diseases` VALUES ('4802', '高肾素性醛固酮增多症', '314', 'E26.802', 'GSSXQGTZDZ', '');
INSERT INTO `05diseases` VALUES ('4803', '醛固酮增多症 NOS', '278', 'E26.901', 'QGTZDZ', '');
INSERT INTO `05diseases` VALUES ('4804', '肾上腺皮质机能亢进', '314', 'E27.001', 'SSXPZJNKJ', '');
INSERT INTO `05diseases` VALUES ('4805', '促肾上腺皮质激素生成过多，与库欣综合征无关', '314', 'E27.051', 'CSSXPZJSSCGDYKXZHZWG', '');
INSERT INTO `05diseases` VALUES ('4806', '肾上腺皮质机能亢进，与库欣综合征无关', '314', 'E27.052', 'SSXPZJNKJYKXZHZWG', '');
INSERT INTO `05diseases` VALUES ('4807', '肾上腺(皮质)功能早现', '314', 'E27.053', 'SSXPZGNZX', '');
INSERT INTO `05diseases` VALUES ('4808', '阿狄森氏病[青铜色]', '268', 'E27.101', 'ADSSBQTS', '');
INSERT INTO `05diseases` VALUES ('4809', '原发性肾上腺皮质功能减退症', '314', 'E27.151', 'YFXSSXPZGNJTZ', '');
INSERT INTO `05diseases` VALUES ('4810', '自身免疫肾上腺炎', '228', 'E27.152', 'ZSMYSSXY', '');
INSERT INTO `05diseases` VALUES ('4811', '肾上腺黑变病[艾迪生黑变病]', '314', 'E27.153', 'SSXHBBADSHBB', '');
INSERT INTO `05diseases` VALUES ('4812', '阿狄森氏病危象', '268', 'E27.201', 'ADSSBWX', '');
INSERT INTO `05diseases` VALUES ('4813', '肾上腺皮质危象', '314', 'E27.202', 'SSXPZWX', '');
INSERT INTO `05diseases` VALUES ('4814', '肾上腺衰竭', '314', 'E27.251', 'SSXSJ', '');
INSERT INTO `05diseases` VALUES ('4815', '药物性肾上腺皮质功能减退症', '314', 'E27.351', 'YWXSSXPZGNJTZ', '');
INSERT INTO `05diseases` VALUES ('4816', '假性低醛固酮血症', '275', 'E27.401', 'JXDQGTXZ', '');
INSERT INTO `05diseases` VALUES ('4817', '肾上腺出血', '314', 'E27.402', 'SSXCX', '');
INSERT INTO `05diseases` VALUES ('4818', '肾上腺坏死', '314', 'E27.403', 'SSXHS', '');
INSERT INTO `05diseases` VALUES ('4819', '肾上腺皮质机能减退', '314', 'E27.404', 'SSXPZJNJT', '');
INSERT INTO `05diseases` VALUES ('4820', '肾上腺皮质萎缩', '314', 'E27.405', 'SSXPZWS', '');
INSERT INTO `05diseases` VALUES ('4821', '肾上腺梗塞', '314', 'E27.451', 'SSXGS', '');
INSERT INTO `05diseases` VALUES ('4822', '肾上腺钙化', '314', 'E27.452', 'SSXGH', '');
INSERT INTO `05diseases` VALUES ('4823', '醛甾酮过少症', '278', 'E27.453', 'QZTGSZ', '');
INSERT INTO `05diseases` VALUES ('4824', '肾上腺髓质增生', '314', 'E27.551', 'SSXSZZS', '');
INSERT INTO `05diseases` VALUES ('4825', '儿茶酚胺分泌过多', '278', 'E27.552', 'ECFAFMGD', '');
INSERT INTO `05diseases` VALUES ('4826', '肾上腺囊肿', '231', 'E27.801', 'SSXNZ', '');
INSERT INTO `05diseases` VALUES ('4827', '肾上腺脓肿', '243', 'E27.802', 'SSXNZ', '');
INSERT INTO `05diseases` VALUES ('4828', '肾上腺皮质增生', '314', 'E27.803', 'SSXPZZS', '');
INSERT INTO `05diseases` VALUES ('4829', '肾上腺炎', '314', 'E27.804', 'SSXY', '');
INSERT INTO `05diseases` VALUES ('4830', '肾上腺增生', '314', 'E27.805', 'SSXZS', '');
INSERT INTO `05diseases` VALUES ('4831', '肾上腺肿块', '314', 'E27.806', 'SSXZK', '');
INSERT INTO `05diseases` VALUES ('4832', '肾上腺肿物', '314', 'E27.807', 'SSXZW', '');
INSERT INTO `05diseases` VALUES ('4833', '肾上腺皮质(腺)肥胖', '314', 'E27.851', 'SSXPZXFP', '');
INSERT INTO `05diseases` VALUES ('4834', '皮质醇结合球蛋白异常', '278', 'E27.852', 'PZCJHQDBYC', '');
INSERT INTO `05diseases` VALUES ('4835', '肾上腺皮质机能障碍 NOS', '314', 'E27.951', 'SSXPZJNZA', '');
INSERT INTO `05diseases` VALUES ('4836', '雌激素过多症', '278', 'E28.001', 'CJSGDZ', '');
INSERT INTO `05diseases` VALUES ('4837', '卵巢(医源性)(药物性)雄激素分泌过多', '86', 'E28.101', 'LCYYXYWXXJSFMGD', '');
INSERT INTO `05diseases` VALUES ('4838', '多囊卵巢综合征(斯-利二氏综合征)', '86', 'E28.201', 'DNLCZHZSLESZHZ', '');
INSERT INTO `05diseases` VALUES ('4839', '斯坦－勒旺塔尔综合征', '278', 'E28.251', 'STLWTEZHZ', '');
INSERT INTO `05diseases` VALUES ('4840', '硬囊卵巢综合征', '86', 'E28.252', 'YNLCZHZ', '');
INSERT INTO `05diseases` VALUES ('4841', '多囊卵巢综合征', '86', 'E28.253', 'DNLCZHZ', '');
INSERT INTO `05diseases` VALUES ('4842', '早发绝经', '278', 'E28.301', 'ZFJJ', '');
INSERT INTO `05diseases` VALUES ('4843', '卵巢功能减退', '86', 'E28.302', 'LCGNJT', '');
INSERT INTO `05diseases` VALUES ('4844', '卵巢衰竭', '86', 'E28.303', 'LCSJ', '');
INSERT INTO `05diseases` VALUES ('4845', '卵巢早衰', '86', 'E28.304', 'LCZS', '');
INSERT INTO `05diseases` VALUES ('4846', '女性性腺功能低下', '278', 'E28.305', 'NXXXGNDX', '');
INSERT INTO `05diseases` VALUES ('4847', '雌激素减少', '278', 'E28.351', 'CJSJS', '');
INSERT INTO `05diseases` VALUES ('4848', '抗卵巢综合征', '86', 'E28.352', 'KLCZHZ', '');
INSERT INTO `05diseases` VALUES ('4849', '卵巢过度刺激综合征', '86', 'E28.801', 'LCGDCJZHZ', '');
INSERT INTO `05diseases` VALUES ('4850', '其他卵巢机能亢进', '86', 'E28.851', 'QTLCJNKJ', '');
INSERT INTO `05diseases` VALUES ('4851', '激素过多的闭经', '278', 'E28.852', 'JSGDDBJ', '');
INSERT INTO `05diseases` VALUES ('4852', '卵巢机能障碍 NOS', '86', 'E28.951', 'LCJNZA', '');
INSERT INTO `05diseases` VALUES ('4853', '雄(睾丸)激素分泌过多', '230', 'E29.001', 'XGWJSFMGD', '');
INSERT INTO `05diseases` VALUES ('4854', '睾丸机能亢进', '230', 'E29.051', 'GWJNKJ', '');
INSERT INTO `05diseases` VALUES ('4855', '5α-还原酶缺乏(伴有男性假两性同体)', '278', 'E29.101', 'HYMQFBYNXJLXTT', '');
INSERT INTO `05diseases` VALUES ('4856', '男性性腺功能低下', '278', 'E29.102', 'NXXXGNDX', '');
INSERT INTO `05diseases` VALUES ('4857', '原发性睾丸机能减退', '230', 'E29.103', 'YFXGWJNJT', '');
INSERT INTO `05diseases` VALUES ('4858', '继发性睾丸机能减退', '230', 'E29.151', 'JFXGWJNJT', '');
INSERT INTO `05diseases` VALUES ('4859', '睾丸机能减退', '230', 'E29.152', 'GWJNJT', '');
INSERT INTO `05diseases` VALUES ('4860', '睾丸雄激素生物合成障碍', '230', 'E29.153', 'GWXJSSWHCZA', '');
INSERT INTO `05diseases` VALUES ('4861', '幼稚型睾丸', '230', 'E29.801', 'YZXGW', '');
INSERT INTO `05diseases` VALUES ('4862', '其他睾丸机能减退', '230', 'E29.851', 'QTGWJNJT', '');
INSERT INTO `05diseases` VALUES ('4863', '睾丸机能减退 NOS', '230', 'E29.951', 'GWJNJT', '');
INSERT INTO `05diseases` VALUES ('4864', '第二性征发育不全', '75', 'E30.001', 'DEXZFYBQ', '');
INSERT INTO `05diseases` VALUES ('4865', '青春期发育延迟', '75', 'E30.002', 'QCQFYYC', '');
INSERT INTO `05diseases` VALUES ('4866', '性发育不全', '75', 'E30.003', 'XFYBQ', '');
INSERT INTO `05diseases` VALUES ('4867', '幼稚型子宫', '86', 'E30.004', 'YZXZG', '');
INSERT INTO `05diseases` VALUES ('4868', '性早熟', '459', 'E30.101', 'XZS', '');
INSERT INTO `05diseases` VALUES ('4869', '真性性早熟', '459', 'E30.102', 'ZXXZS', '');
INSERT INTO `05diseases` VALUES ('4870', '青春期早熟', '459', 'E30.151', 'QCQZS', '');
INSERT INTO `05diseases` VALUES ('4871', '乳房早熟', '86', 'E30.851', 'RFZS', '');
INSERT INTO `05diseases` VALUES ('4872', '青春期疾患 NOS', '278', 'E30.951', 'QCQJH', '');
INSERT INTO `05diseases` VALUES ('4873', '施密特氏综合征(甲状腺-肾上腺皮质的)', '159', 'E31.001', 'SMTSZHZJZXSSXPZD', '');
INSERT INTO `05diseases` VALUES ('4874', '甲状腺－肾上腺质机能不全综合征', '159', 'E31.051', 'JZXSSXZJNBQZHZ', '');
INSERT INTO `05diseases` VALUES ('4875', '多腺体缺乏', '385', 'E31.052', 'DXTQF', '');
INSERT INTO `05diseases` VALUES ('4876', '多腺体机能亢进', '385', 'E31.151', 'DXTJNKJ', '');
INSERT INTO `05diseases` VALUES ('4877', '多发性内分泌腺机能减退综合征', '235', 'E31.851', 'DFXNFMXJNJTZHZ', '');
INSERT INTO `05diseases` VALUES ('4878', '多发性内分泌腺病', '235', 'E31.901', 'DFXNFMXB', '');
INSERT INTO `05diseases` VALUES ('4879', '多腺体机能障碍 NOS', '385', 'E31.902', 'DXTJNZA', '');
INSERT INTO `05diseases` VALUES ('4880', '先天性胸腺肥大', '383', 'E32.001', 'XTXXXFD', '');
INSERT INTO `05diseases` VALUES ('4881', '胸腺增生', '409', 'E32.002', 'XXZS', '');
INSERT INTO `05diseases` VALUES ('4882', '胸腺脓肿', '243', 'E32.101', 'XXNZ', '');
INSERT INTO `05diseases` VALUES ('4883', '胸腺淋巴体质', '409', 'E32.801', 'XXLBTZ', '');
INSERT INTO `05diseases` VALUES ('4884', '胸腺囊肿', '231', 'E32.802', 'XXNZ', '');
INSERT INTO `05diseases` VALUES ('4885', '胸腺萎缩', '409', 'E32.803', 'XXWS', '');
INSERT INTO `05diseases` VALUES ('4886', '胸腺咽管瘘', '212', 'E32.804', 'XXYGL', '');
INSERT INTO `05diseases` VALUES ('4887', '胸腺病 NOS', '409', 'E32.951', 'XXB', '');
INSERT INTO `05diseases` VALUES ('4888', '类癌综合征', '2', 'E34.001', 'LAZHZ', '');
INSERT INTO `05diseases` VALUES ('4889', '其他肠激素分泌过多', '259', 'E34.151', 'QTCJSFMGD', '');
INSERT INTO `05diseases` VALUES ('4890', '异位激素分泌，NEC', '278', 'E34.251', 'YWJSFM', '');
INSERT INTO `05diseases` VALUES ('4891', '家族性身材矮小', '312', 'E34.301', 'JZXSCAX', '');
INSERT INTO `05diseases` VALUES ('4892', '侏儒症', '278', 'E34.302', 'ZRZ', '');
INSERT INTO `05diseases` VALUES ('4893', '体质性矮小', '312', 'E34.303', 'TZXAX', '');
INSERT INTO `05diseases` VALUES ('4894', '原基性侏儒', '278', 'E34.304', 'YJXZR', '');
INSERT INTO `05diseases` VALUES ('4895', '体格发育迟缓', '75', 'E34.351', 'TGFYCH', '');
INSERT INTO `05diseases` VALUES ('4896', '拉伦型身材矮小症', '312', 'E34.352', 'LLXSCAXZ', '');
INSERT INTO `05diseases` VALUES ('4897', '精神(心理)社会的身材矮小症', '177', 'E34.353', 'JSXLSHDSCAXZ', '');
INSERT INTO `05diseases` VALUES ('4898', '婴儿性身材矮小症', '312', 'E34.354', 'YEXSCAXZ', '');
INSERT INTO `05diseases` VALUES ('4899', '体质性高身材', '278', 'E34.451', 'TZXGSC', '');
INSERT INTO `05diseases` VALUES ('4900', '雄激素不敏感综合征[睾丸女性化综合征]', '230', 'E34.501', 'GWNXH', '');
INSERT INTO `05diseases` VALUES ('4901', '男性假两性畸形伴有睾丸女性化', '230', 'E34.502', 'XJSBMGZHZGWNXHZHZ', '');
INSERT INTO `05diseases` VALUES ('4902', '男性假两性同体伴有雄素抵抗', '278', 'E34.551', 'NXJLXTTBYXSDK', '');
INSERT INTO `05diseases` VALUES ('4903', '赖芬斯坦综合征', '278', 'E34.552', 'LFSTZHZ', '');
INSERT INTO `05diseases` VALUES ('4904', '雄激素抵抗综合征', '278', 'E34.553', 'XJSDKZHZ', '');
INSERT INTO `05diseases` VALUES ('4905', '戈德堡-马克斯韦尔综合征', '278', 'E34.554', 'GDBMKSWEZHZ', '');
INSERT INTO `05diseases` VALUES ('4906', '松果体功能障碍', '278', 'E34.801', 'SGTGNZA', '');
INSERT INTO `05diseases` VALUES ('4907', '早老症', '278', 'E34.802', 'ZLZ', '');
INSERT INTO `05diseases` VALUES ('4908', '早老性过早衰老', '278', 'E34.851', 'ZLXGZSL', '');
INSERT INTO `05diseases` VALUES ('4909', '内分泌性肌病', '235', 'E34.901+', 'NFMXJB', '');
INSERT INTO `05diseases` VALUES ('4910', '多发性内分泌功能紊乱', '235', 'E34.951', 'DFXNFMGNWL', '');
INSERT INTO `05diseases` VALUES ('4911', '内分泌失调 NOS', '235', 'E34.952', 'NFMSD', '');
INSERT INTO `05diseases` VALUES ('4912', '激素失调 NOS', '278', 'E34.953', 'JSSD', '');
INSERT INTO `05diseases` VALUES ('4913', '恶性营养不良[夸希奥科病]', '448', 'E40.X01', 'EXYYBLKXAKB', '');
INSERT INTO `05diseases` VALUES ('4914', '营养性水肿伴皮肤及头发色素沉着异常', '250', 'E40.X51', 'YYXSZBPFJTFSSCZYC', '');
INSERT INTO `05diseases` VALUES ('4915', '婴儿期多营养不良综合征', '448', 'E40.X52', 'YEQDYYBLZHZ', '');
INSERT INTO `05diseases` VALUES ('4916', '消瘦', '278', 'E41.X01', 'XS', '');
INSERT INTO `05diseases` VALUES ('4917', '营养性消瘦', '448', 'E41.X51', 'YYXXS', '');
INSERT INTO `05diseases` VALUES ('4918', '重度中间型蛋白质－能量营养不良病', '448', 'E42.X51', 'ZDZJXDBZNLYYBLB', '');
INSERT INTO `05diseases` VALUES ('4919', '重度营养不良[饥饿性水肿]', '448', 'E43.X01', 'ZDYYBLJEXSZ', '');
INSERT INTO `05diseases` VALUES ('4920', '营养性水肿', '337', 'E43.X02', 'YYXSZ', '');
INSERT INTO `05diseases` VALUES ('4921', '中度营养不良', '448', 'E44.001', 'ZDYYBL', '');
INSERT INTO `05diseases` VALUES ('4922', '轻度营养不良', '448', 'E44.101', 'QDYYBL', '');
INSERT INTO `05diseases` VALUES ('4923', '营养不良性发育缓慢', '448', 'E45.X01', 'YYBLXFYHM', '');
INSERT INTO `05diseases` VALUES ('4924', '营养性侏儒症', '448', 'E45.X51', 'YYXZRZ', '');
INSERT INTO `05diseases` VALUES ('4925', '营养性矮小', '312', 'E45.X52', 'YYXAX', '');
INSERT INTO `05diseases` VALUES ('4926', '蛋白缺乏', '278', 'E46.X01', 'DBQF', '');
INSERT INTO `05diseases` VALUES ('4927', '低蛋白性营养不良', '448', 'E46.X02', 'DDBXYYBL', '');
INSERT INTO `05diseases` VALUES ('4928', '营养不良', '448', 'E46.X03', 'YYBL', '');
INSERT INTO `05diseases` VALUES ('4929', '蛋白质热能缺乏病', '268', 'E46.X51', 'DBZRNQFB', '');
INSERT INTO `05diseases` VALUES ('4930', '营养代谢性心脏病', '403', 'E46.X52+', 'YYDXXXZB', '');
INSERT INTO `05diseases` VALUES ('4931', '蛋白质-能量失衡', '278', 'E46.X53', 'DBZNLSH', '');
INSERT INTO `05diseases` VALUES ('4932', '维生素A缺乏合并结膜干燥病', '173', 'E50.001+', 'WSSQFHBJMGZB', '');
INSERT INTO `05diseases` VALUES ('4933', '维生素Ａ缺乏合并角膜及结膜干燥症', '166', 'E50.051+', 'WSSQFHBJMJJMGZZ', '');
INSERT INTO `05diseases` VALUES ('4934', '比奥斑(角膜)伴有维生素Ａ缺乏(症)', '250', 'E50.151', 'BABJMBYWSSQFZ', '');
INSERT INTO `05diseases` VALUES ('4935', '维生素Ａ缺乏伴有比托斑点和结膜干燥症', '250', 'E50.152+', 'WSSQFBYBTBDHJMGZZ', '');
INSERT INTO `05diseases` VALUES ('4936', '维生素Ａ缺乏伴有角膜干燥病', '166', 'E50.201+', 'WSSQFBYJMGZB', '');
INSERT INTO `05diseases` VALUES ('4937', '维生素Ａ缺乏伴角膜溃疡', '195', 'E50.351+', 'WSSQFBJMKY', '');
INSERT INTO `05diseases` VALUES ('4938', '维生素Ａ缺乏合并角膜溃疡及干燥症', '195', 'E50.352+', 'WSSQFHBJMKYJGZZ', '');
INSERT INTO `05diseases` VALUES ('4939', '维生素Ａ缺乏合并角膜软化', '166', 'E50.401+', 'WSSQFHBJMRH', '');
INSERT INTO `05diseases` VALUES ('4940', '维生素Ａ缺乏合并夜盲症', '369', 'E50.501+', 'WSSQFHBYMZ', '');
INSERT INTO `05diseases` VALUES ('4941', '维生素Ａ缺乏合并角膜干眼瘢痕', '430', 'E50.601+', 'WSSQFHBJMGYBH', '');
INSERT INTO `05diseases` VALUES ('4942', '维生素Ａ缺乏合并干眼症', '430', 'E50.701+', 'WSSQFHBGYZ', '');
INSERT INTO `05diseases` VALUES ('4943', '维生素Ａ缺乏合并皮肤干燥病', '250', 'E50.801+', 'WSSQFHBPFGZB', '');
INSERT INTO `05diseases` VALUES ('4944', '维生素Ａ缺乏性毛囊角化病', '369', 'E50.851+', 'WSSQFXMNJHB', '');
INSERT INTO `05diseases` VALUES ('4945', '维生素Ａ缺乏', '369', 'E50.901', 'WSSQF', '');
INSERT INTO `05diseases` VALUES ('4946', '比奥斑(角膜)伴有维生素缺乏(症)', '250', 'E50.951', 'BABJMBYWSSQFZ', '');
INSERT INTO `05diseases` VALUES ('4947', '脚气病', '168', 'E51.101', 'JQB', '');
INSERT INTO `05diseases` VALUES ('4948', '糙皮病性多神经病', '313', 'E51.102+', 'CPBXDSJB', '');
INSERT INTO `05diseases` VALUES ('4949', '脚气病性多神经炎', '313', 'E51.103+', 'JQBXDSJY', '');
INSERT INTO `05diseases` VALUES ('4950', '脚气病性心脏病', '403', 'E51.104+', 'JQBXXZB', '');
INSERT INTO `05diseases` VALUES ('4951', '湿性脚气病', '168', 'E51.151+', 'SXJQB', '');
INSERT INTO `05diseases` VALUES ('4952', '干性脚气病', '168', 'E51.152', 'GXJQB', '');
INSERT INTO `05diseases` VALUES ('4953', '韦尼克氏脑病[急性出血性脑灰质炎]', '234', 'E51.201+', 'WNKSNBJXCXXNHZY', '');
INSERT INTO `05diseases` VALUES ('4954', '硫胺素缺乏的其他表现', '278', 'E51.851', 'LASQFDQTBX', '');
INSERT INTO `05diseases` VALUES ('4955', '维生素Ｂ1 缺乏[硫胺素缺乏]', '369', 'E51.901', 'WSSQFLASQF', '');
INSERT INTO `05diseases` VALUES ('4956', '烟酸(-色氨酸)缺乏[糙皮病、陪粒格］', '268', 'E52.X01', 'YSSASQFCPBPLG', '');
INSERT INTO `05diseases` VALUES ('4957', '酒精性糙皮病', '268', 'E52.X02', 'JJXCPB', '');
INSERT INTO `05diseases` VALUES ('4958', '眼睑蜀黍红斑(睑糙皮病)', '430', 'E52.X03', 'YJSSHBJCPB', '');
INSERT INTO `05diseases` VALUES ('4959', '地方性红斑', '250', 'E52.X51', 'DFXHB', '');
INSERT INTO `05diseases` VALUES ('4960', '维生素Ｂ2缺乏症[核黄素缺乏症]', '369', 'E53.001', 'WSSQFZHHSQFZ', '');
INSERT INTO `05diseases` VALUES ('4961', '维生素Ｂ6缺乏', '369', 'E53.101', 'WSSQF', '');
INSERT INTO `05diseases` VALUES ('4962', '吡哆醇缺乏(衍生物)', '278', 'E53.151', 'BDCQFYSW', '');
INSERT INTO `05diseases` VALUES ('4963', '维生素Ｂ12缺乏', '369', 'E53.801', 'WSSQF', '');
INSERT INTO `05diseases` VALUES ('4964', '叶酸缺乏', '278', 'E53.802', 'YSQF', '');
INSERT INTO `05diseases` VALUES ('4965', '侧索联合变性病', '268', 'E53.803+', 'CSLHBXB', '');
INSERT INTO `05diseases` VALUES ('4966', '达纳-普特南氏综合征(脊髓后侧索综合征)', '152', 'E53.804+', 'DNPTNSZHZJSHCSZHZ', '');
INSERT INTO `05diseases` VALUES ('4967', '脊髓后侧索硬化', '152', 'E53.805+', 'JSHCSYH', '');
INSERT INTO `05diseases` VALUES ('4968', '达-普综合征(脊髓后侧索综合征，亚急性)', '152', 'E53.806+', 'DPZHZJSHCSZHZYJX', '');
INSERT INTO `05diseases` VALUES ('4969', '脊髓亚急性联合变性[达娜(纳)－帕(普)特南氏综合征]', '152', 'E53.807+', 'JSYJXLHBXDNNPPTNSZHZ', '');
INSERT INTO `05diseases` VALUES ('4970', '维生素Ｂ12缺乏性周围神经病', '313', 'E53.808+', 'WSSQFXZWSJB', '');
INSERT INTO `05diseases` VALUES ('4971', '亚急性联合病变', '268', 'E53.809+', 'YJXLHBB', '');
INSERT INTO `05diseases` VALUES ('4972', '维生素Ｂ12缺乏痴呆', '34', 'E53.851+', 'WSSQFCD', '');
INSERT INTO `05diseases` VALUES ('4973', '生物素缺乏', '278', 'E53.852', 'SWSQF', '');
INSERT INTO `05diseases` VALUES ('4974', '泛酸缺乏', '278', 'E53.853', 'FSQF', '');
INSERT INTO `05diseases` VALUES ('4975', '氰钴胺素缺乏', '278', 'E53.854', 'QGASQF', '');
INSERT INTO `05diseases` VALUES ('4976', '复合维生素Ｂ缺乏(病)', '369', 'E53.901', 'FHWSSQFB', '');
INSERT INTO `05diseases` VALUES ('4977', '维生素缺乏性周围神经病(B)', '313', 'E53.902+', 'WSSQFXZWSJB', '');
INSERT INTO `05diseases` VALUES ('4978', '足灼热综合征', '280', 'E53.951', 'ZZRZHZ', '');
INSERT INTO `05diseases` VALUES ('4979', '慢性舌乳头炎[默勒舌炎]维生素Ｂ缺乏', '86', 'E53.952+', 'MXSRTYMLSYWSSQF', '');
INSERT INTO `05diseases` VALUES ('4980', '坏血病', '275', 'E54.X01', 'HXB', '');
INSERT INTO `05diseases` VALUES ('4981', '维生素Ｃ缺乏[抗坏血酸缺乏]', '275', 'E54.X02', 'WSSQFKHXSQF', '');
INSERT INTO `05diseases` VALUES ('4982', '婴儿坏血病[巴洛氏病、奇德尔病]', '275', 'E54.X51', 'YEHXBBLSBQDEB', '');
INSERT INTO `05diseases` VALUES ('4983', '佝偻病', '105', 'E55.001', 'GLB', '');
INSERT INTO `05diseases` VALUES ('4984', '婴儿的骨软化', '112', 'E55.051', 'YEDGRH', '');
INSERT INTO `05diseases` VALUES ('4985', '幼年的骨软化', '112', 'E55.052', 'YNDGRH', '');
INSERT INTO `05diseases` VALUES ('4986', '维生素Ｄ缺乏', '369', 'E55.901', 'WSSQF', '');
INSERT INTO `05diseases` VALUES ('4987', '维生素Ｄ缺乏性手足搐搦症', '42', 'E55.902', 'WSSQFXSZCNZ', '');
INSERT INTO `05diseases` VALUES ('4988', '维生素Ｅ缺乏', '369', 'E56.001', 'WSSQF', '');
INSERT INTO `05diseases` VALUES ('4989', '维生素Ｋ缺乏', '369', 'E56.101', 'WSSQF', '');
INSERT INTO `05diseases` VALUES ('4990', '维生素Ｐ缺乏', '369', 'E56.801', 'WSSQF', '');
INSERT INTO `05diseases` VALUES ('4991', '维生素缺乏 NOS', '369', 'E56.901', 'WSSQF', '');
INSERT INTO `05diseases` VALUES ('4992', '维生素缺乏性多神经炎', '313', 'E56.902+', 'WSSQFXDSJY', '');
INSERT INTO `05diseases` VALUES ('4993', '饮食性钙缺乏', '278', 'E58.X51', 'YSXGQF', '');
INSERT INTO `05diseases` VALUES ('4994', '克山病[地方性心脏病]', '403', 'E59.X01', 'KSBDFXXZB', '');
INSERT INTO `05diseases` VALUES ('4995', '饮食性硒缺乏', '278', 'E59.X51', 'YSXXQF', '');
INSERT INTO `05diseases` VALUES ('4996', '锌缺乏 NOS', '278', 'E60.X01', 'XQF', '');
INSERT INTO `05diseases` VALUES ('4997', '饮食性锌缺乏', '278', 'E60.X51', 'YSXXQF', '');
INSERT INTO `05diseases` VALUES ('4998', '铜缺乏', '278', 'E61.051', 'TQF', '');
INSERT INTO `05diseases` VALUES ('4999', '铁缺乏', '278', 'E61.151', 'TQF', '');
INSERT INTO `05diseases` VALUES ('5000', '镁缺乏', '278', 'E61.251', 'MQF', '');
INSERT INTO `05diseases` VALUES ('5001', '锰缺乏', '278', 'E61.351', 'MQF', '');
INSERT INTO `05diseases` VALUES ('5002', '铬缺乏', '278', 'E61.451', 'GQF', '');
INSERT INTO `05diseases` VALUES ('5003', '钼缺乏', '278', 'E61.551', 'MQF', '');
INSERT INTO `05diseases` VALUES ('5004', '钒缺乏', '278', 'E61.651', 'FQF', '');
INSERT INTO `05diseases` VALUES ('5005', '多种营养元素缺乏', '448', 'E61.751', 'DZYYYSQF', '');
INSERT INTO `05diseases` VALUES ('5006', '碘缺乏', '278', 'E61.851', 'DQF', '');
INSERT INTO `05diseases` VALUES ('5007', '营养元素缺乏 NOS', '448', 'E61.951', 'YYYSQF', '');
INSERT INTO `05diseases` VALUES ('5008', '必需脂脂肪酸[EFA]缺乏', '278', 'E63.051', 'BXZZFSQF', '');
INSERT INTO `05diseases` VALUES ('5009', '摄入食物结构缺乏', '278', 'E63.151', 'SRSWJGQF', '');
INSERT INTO `05diseases` VALUES ('5010', '其他特指的营养缺乏', '448', 'E63.851', 'QTTZDYYQF', '');
INSERT INTO `05diseases` VALUES ('5011', '营养缺乏性多神经炎', '313', 'E63.901+', 'YYQFXDSJY', '');
INSERT INTO `05diseases` VALUES ('5012', '营养性周围神经病', '313', 'E63.902+', 'YYXZWSJB', '');
INSERT INTO `05diseases` VALUES ('5013', '营养性心肌病', '397', 'E63.951+', 'YYXXJB', '');
INSERT INTO `05diseases` VALUES ('5014', '蛋白质-能量营养不良后遗症', '448', 'E64.051', 'DBZNLYYBLHYZ', '');
INSERT INTO `05diseases` VALUES ('5015', '维生素Ａ缺乏后遗症', '369', 'E64.151', 'WSSQFHYZ', '');
INSERT INTO `05diseases` VALUES ('5016', '维生素Ｃ缺乏后遗症', '369', 'E64.251', 'WSSQFHYZ', '');
INSERT INTO `05diseases` VALUES ('5017', '佝偻病后遗症', '105', 'E64.301', 'GLBHYZ', '');
INSERT INTO `05diseases` VALUES ('5018', '佝偻病性鸡胸', '274', 'E64.351', 'GLBXJX', '');
INSERT INTO `05diseases` VALUES ('5019', '其他营养缺乏后遗症', '448', 'E64.851', 'QTYYQFHYZ', '');
INSERT INTO `05diseases` VALUES ('5020', '未特指的营养缺乏后遗症', '448', 'E64.951', 'WTZDYYQFHYZ', '');
INSERT INTO `05diseases` VALUES ('5021', '脂肪垫', '278', 'E65.X01', 'ZFD', '');
INSERT INTO `05diseases` VALUES ('5022', '腹部多脂', '264', 'E65.X51', 'FBDZ', '');
INSERT INTO `05diseases` VALUES ('5023', '局部肥胖', '77', 'E65.X52', 'JBFP', '');
INSERT INTO `05diseases` VALUES ('5024', '营养性肥胖', '77', 'E66.051', 'YYXFP', '');
INSERT INTO `05diseases` VALUES ('5025', '药物性肥胖', '77', 'E66.151', 'YWXFP', '');
INSERT INTO `05diseases` VALUES ('5026', '皮克威氏(病)综合征[肥胖-低通气综合征]', '77', 'E66.201', 'PKWSBZHZFPDTQZHZ', '');
INSERT INTO `05diseases` VALUES ('5027', '极度肥胖，伴有小泡性肺换气不足', '79', 'E66.251', 'JDFPBYXPXFHQBZ', '');
INSERT INTO `05diseases` VALUES ('5028', '病态性肥胖', '77', 'E66.851', 'BTXFP', '');
INSERT INTO `05diseases` VALUES ('5029', '家族性肥胖', '77', 'E66.852', 'JZXFP', '');
INSERT INTO `05diseases` VALUES ('5030', '内分泌性肥胖', '77', 'E66.853', 'NFMXFP', '');
INSERT INTO `05diseases` VALUES ('5031', '继发性肥胖[症状性肥胖症]', '77', 'E66.854', 'JFXFPZZXFPZ', '');
INSERT INTO `05diseases` VALUES ('5032', '女性特征肥胖[普森氏综合征]', '77', 'E66.855', 'NXTZFPPSSZHZ', '');
INSERT INTO `05diseases` VALUES ('5033', '肥胖(综合症) NOS', '77', 'E66.902', 'FPZHZ', '');
INSERT INTO `05diseases` VALUES ('5034', '维生素Ａ过多症', '369', 'E67.001', 'WSSGDZ', '');
INSERT INTO `05diseases` VALUES ('5035', '高胡萝卜素血症', '275', 'E67.101', 'GHLBSXZ', '');
INSERT INTO `05diseases` VALUES ('5036', '大剂量维生素Ｂ6综合征', '369', 'E67.251', 'DJLWSSZHZ', '');
INSERT INTO `05diseases` VALUES ('5037', '维生素Ｄ过多症', '369', 'E67.301', 'WSSGDZ', '');
INSERT INTO `05diseases` VALUES ('5038', '其他特指的营养过度', '449', 'E67.851', 'QTTZDYYGD', '');
INSERT INTO `05diseases` VALUES ('5039', '营养过度后遗症', '449', 'E68.X51', 'YYGDHYZ', '');
INSERT INTO `05diseases` VALUES ('5040', '典型的苯丙酮酸尿', '341', 'E70.051', 'DXDBBTSN', '');
INSERT INTO `05diseases` VALUES ('5041', '苯丙酮尿症', '269', 'E70.101', 'BBTNZ', '');
INSERT INTO `05diseases` VALUES ('5042', '苯酮尿症', '269', 'E70.102', 'BTNZ', '');
INSERT INTO `05diseases` VALUES ('5043', '高苯丙氨酸血症', '342', 'E70.103', 'GBBASXZ', '');
INSERT INTO `05diseases` VALUES ('5044', '母体苯丙酮尿(症)', '269', 'E70.151', 'MTBBTNZ', '');
INSERT INTO `05diseases` VALUES ('5045', '高酪氨酸血症', '342', 'E70.201', 'GLASXZ', '');
INSERT INTO `05diseases` VALUES ('5046', '褐黄病', '268', 'E70.202', 'HHB', '');
INSERT INTO `05diseases` VALUES ('5047', '酪氨酸代谢(紊乱)症', '52', 'E70.203', 'LASDXWLZ', '');
INSERT INTO `05diseases` VALUES ('5048', '酪氨酸尿症', '341', 'E70.204', 'LASNZ', '');
INSERT INTO `05diseases` VALUES ('5049', '尿黑酸尿', '341', 'E70.251', 'NHSN', '');
INSERT INTO `05diseases` VALUES ('5050', '褐黄病性关节炎', '123', 'E70.252+', 'HHBXGJY', '');
INSERT INTO `05diseases` VALUES ('5051', '白化病', '268', 'E70.301', 'BHB', '');
INSERT INTO `05diseases` VALUES ('5052', '眼白化病', '430', 'E70.302', 'YBHB', '');
INSERT INTO `05diseases` VALUES ('5053', '赫日曼斯基－普德拉克综合征', '278', 'E70.351', 'HRMSJPDLKZHZ', '');
INSERT INTO `05diseases` VALUES ('5054', '克罗斯综合征', '278', 'E70.352', 'KLSZHZ', '');
INSERT INTO `05diseases` VALUES ('5055', '切迪阿克－东(－施泰因布林克)异常', '278', 'E70.353', 'QDAKDSTYBLKYC', '');
INSERT INTO `05diseases` VALUES ('5056', '高组氨酸血症', '342', 'E70.851', 'GZASXZ', '');
INSERT INTO `05diseases` VALUES ('5057', '色氨酸代谢紊乱', '52', 'E70.852', 'SASDXWL', '');
INSERT INTO `05diseases` VALUES ('5058', '组氨酸代谢紊乱', '52', 'E70.853', 'ZASDXWL', '');
INSERT INTO `05diseases` VALUES ('5059', '未特指的芳香氨基酸代谢紊乱', '52', 'E70.951', 'WTZDFXAJSDXWL', '');
INSERT INTO `05diseases` VALUES ('5060', '槭糖尿病', '348', 'E71.001', 'QTNB', '');
INSERT INTO `05diseases` VALUES ('5061', '丙酸血症', '342', 'E71.101', 'BSXZ', '');
INSERT INTO `05diseases` VALUES ('5062', '高缬氨酸血症', '342', 'E71.151', 'GXASXZ', '');
INSERT INTO `05diseases` VALUES ('5063', '异缬氨酸血症', '342', 'E71.152', 'YXASXZ', '');
INSERT INTO `05diseases` VALUES ('5064', '高缬氨酸血症-异缬氨酸血症', '342', 'E71.153', 'GXASXZYXASXZ', '');
INSERT INTO `05diseases` VALUES ('5065', '未特指的支链氨基酸代谢紊乱', '52', 'E71.251', 'WTZDZLAJSDXWL', '');
INSERT INTO `05diseases` VALUES ('5066', '肾上腺脑白质营养不良', '234', 'E71.301', 'SSXNBZYYBL', '');
INSERT INTO `05diseases` VALUES ('5067', '脂肪酸代谢紊乱', '52', 'E71.351', 'ZFSDXWL', '');
INSERT INTO `05diseases` VALUES ('5068', '脑白质肾上腺萎缩症[艾迪生-席尔德复征]', '234', 'E71.352', 'NBZSSXWSZADSXEDFZ', '');
INSERT INTO `05diseases` VALUES ('5069', '肌肉肉毒碱棕榈酰转移酶缺乏', '267', 'E71.353', 'JRRDJZLXZYMQF', '');
INSERT INTO `05diseases` VALUES ('5070', '范康尼氏综合征(－德.托尼)(－德勃雷)[胱氨酸病]', '268', 'E72.001', 'FKNSZHZDTNDBLGASB', '');
INSERT INTO `05diseases` VALUES ('5071', '甘氨酸尿症', '341', 'E72.002', 'GASNZ', '');
INSERT INTO `05diseases` VALUES ('5072', '胱氨酸尿症', '341', 'E72.003', 'GASNZ', '');
INSERT INTO `05diseases` VALUES ('5073', '哈特那普氏病[Ｈ病］', '268', 'E72.004', 'HTNPSBB', '');
INSERT INTO `05diseases` VALUES ('5074', '洛氏综合征[眼－脑－肾综合征]', '430', 'E72.005', 'LSZHZYNSZHZ', '');
INSERT INTO `05diseases` VALUES ('5075', '眼脑肾综合征伴有范科尼综合征', '430', 'E72.051', 'YNSZHZBYFKNZHZ', '');
INSERT INTO `05diseases` VALUES ('5076', '青光眼的洛氏综合征', '430', 'E72.052+', 'QGYDLSZHZ', '');
INSERT INTO `05diseases` VALUES ('5077', '蛋氨酸血症', '342', 'E72.151', 'DASXZ', '');
INSERT INTO `05diseases` VALUES ('5078', '载硫氨基酸代谢紊乱', '52', 'E72.152', 'ZLAJSDXWL', '');
INSERT INTO `05diseases` VALUES ('5079', '高胱氨酸尿症', '341', 'E72.153', 'GGASNZ', '');
INSERT INTO `05diseases` VALUES ('5080', '高氨血症', '275', 'E72.201', 'GAXZ', '');
INSERT INTO `05diseases` VALUES ('5081', '尿素循环代谢紊乱', '52', 'E72.251', 'NSXHDXWL', '');
INSERT INTO `05diseases` VALUES ('5082', '高赖氨酸血症', '342', 'E72.351', 'GLASXZ', '');
INSERT INTO `05diseases` VALUES ('5083', '羟赖氨酸血症', '342', 'E72.352', 'QLASXZ', '');
INSERT INTO `05diseases` VALUES ('5084', '鸟氨酸血症(Ⅰ、Ⅱ型)', '342', 'E72.451', 'NASXZYEX', '');
INSERT INTO `05diseases` VALUES ('5085', '肾性甘氨酸尿(症)', '314', 'E72.551', 'SXGASNZ', '');
INSERT INTO `05diseases` VALUES ('5086', '高(羟)氨基酸血(症)', '342', 'E72.552', 'GQAJSXZ', '');
INSERT INTO `05diseases` VALUES ('5087', '肌氨酸血症', '342', 'E72.553', 'JASXZ', '');
INSERT INTO `05diseases` VALUES ('5088', 'β氨基酸代谢紊乱', '52', 'E72.851', 'AJSDXWL', '');
INSERT INTO `05diseases` VALUES ('5089', 'γ谷氨酰(基)循环紊乱', '424', 'E72.852', 'GAXJXHWL', '');
INSERT INTO `05diseases` VALUES ('5090', '高氨基酸尿症', '341', 'E72.901', 'GAJSNZ', '');
INSERT INTO `05diseases` VALUES ('5091', '氨基酸尿', '341', 'E72.902', 'AJSN', '');
INSERT INTO `05diseases` VALUES ('5092', '低氨基酸血症', '342', 'E72.903', 'DAJSXZ', '');
INSERT INTO `05diseases` VALUES ('5093', '氨(基)乙醇尿', '269', 'E72.951', 'AJYCN', '');
INSERT INTO `05diseases` VALUES ('5094', '氨基酸代谢障碍', '52', 'E72.952', 'AJSDXZA', '');
INSERT INTO `05diseases` VALUES ('5095', '氨基酸缺乏', '278', 'E72.953', 'AJSQF', '');
INSERT INTO `05diseases` VALUES ('5096', '氨基酸病', '268', 'E72.954', 'AJSB', '');
INSERT INTO `05diseases` VALUES ('5097', '先天性乳糖缺乏', '383', 'E73.051', 'XTXRTQF', '');
INSERT INTO `05diseases` VALUES ('5098', '继发性乳糖缺乏', '278', 'E73.151', 'JFXRTQF', '');
INSERT INTO `05diseases` VALUES ('5099', '乳糖耐受不良[乳糖不耐(症)]', '278', 'E73.901', 'RTNSBLRTBNZ', '');
INSERT INTO `05diseases` VALUES ('5100', '乳糖吸收不良', '278', 'E73.902', 'RTXSBL', '');
INSERT INTO `05diseases` VALUES ('5101', '肝糖原贮积症(病)', '92', 'E74.001', 'GTYZJZB', '');
INSERT INTO `05diseases` VALUES ('5102', '糖原贮积病', '268', 'E74.002', 'TYZJB', '');
INSERT INTO `05diseases` VALUES ('5103', '糖原性心肥大', '404', 'E74.003+', 'TYXXFD', '');
INSERT INTO `05diseases` VALUES ('5104', '糖原贮积病肌病', '268', 'E74.004+', 'TYZJBJB', '');
INSERT INTO `05diseases` VALUES ('5105', '心脏糖原贮积病', '403', 'E74.005+', 'XZTYZJB', '');
INSERT INTO `05diseases` VALUES ('5106', '赫尔斯氏病[Ⅵ型糖原累积病]', '268', 'E74.051', 'HESSBLXTYLJB', '');
INSERT INTO `05diseases` VALUES ('5107', '冯.吉尔氏病[Ⅰ型糖原累积病]', '268', 'E74.052', 'FJESBYXTYLJB', '');
INSERT INTO `05diseases` VALUES ('5108', '肝磷酸果糖激酶缺乏症[Ⅶ型糖原累积病]', '92', 'E74.053', 'GLSGTJMQFZQXTYLJB', '');
INSERT INTO `05diseases` VALUES ('5109', '肝磷酸化酶６－激缺乏症[Ⅷ型糖原累积病]', '92', 'E74.054', 'GLSHMJQFZBXTYLJB', '');
INSERT INTO `05diseases` VALUES ('5110', '肝磷酸化酶激酶乏症[Ⅸ型糖原累积病]', '92', 'E74.055', 'GLSHMJMFZJXTYLJB', '');
INSERT INTO `05diseases` VALUES ('5111', '糖原过多性肝肿大', '92', 'E74.056', 'TYGDXGZD', '');
INSERT INTO `05diseases` VALUES ('5112', '科里氏病[Ⅲ型糖原累积病]', '268', 'E74.057', 'KLSBSXTYLJB', '');
INSERT INTO `05diseases` VALUES ('5113', '麦卡德尔氏(-施密德)(-皮尔逊)病[Ⅴ型糖原累积病]', '268', 'E74.058', 'MKDESSMDPEXBWXTYLJB', '');
INSERT INTO `05diseases` VALUES ('5114', '庞普[蓬佩]氏病[Ⅱ型糖原累积病]', '268', 'E74.059', 'PPPPSBEXTYLJB', '');
INSERT INTO `05diseases` VALUES ('5115', 'Ⅳ型糖原贮积病[安德森氏病]', '268', 'E74.060', 'SXTYZJBADSSB', '');
INSERT INTO `05diseases` VALUES ('5116', '遗传性果糖尿症', '348', 'E74.101', 'YCXGTNZ', '');
INSERT INTO `05diseases` VALUES ('5117', '果糖尿', '348', 'E74.151', 'GTN', '');
INSERT INTO `05diseases` VALUES ('5118', '果糖血症', '275', 'E74.152', 'GTXZ', '');
INSERT INTO `05diseases` VALUES ('5119', '原发性果糖耐受不良', '278', 'E74.153', 'YFXGTNSBL', '');
INSERT INTO `05diseases` VALUES ('5120', '果糖-１,６－二磷酸缺乏', '278', 'E74.154', 'GTELSQF', '');
INSERT INTO `05diseases` VALUES ('5121', '半乳糖血症', '275', 'E74.201', 'BRTXZ', '');
INSERT INTO `05diseases` VALUES ('5122', '半乳糖激酶缺乏', '278', 'E74.251', 'BRTJMQF', '');
INSERT INTO `05diseases` VALUES ('5123', '葡萄糖-半乳糖吸收不良', '278', 'E74.351', 'PTTBRTXSBL', '');
INSERT INTO `05diseases` VALUES ('5124', '蔗糖酶缺乏', '278', 'E74.352', 'ZTMQF', '');
INSERT INTO `05diseases` VALUES ('5125', '磷酸烯醇丙酮酸羟激酶缺乏', '278', 'E74.451', 'LSXCBTSQJMQF', '');
INSERT INTO `05diseases` VALUES ('5126', '肾性糖尿病', '348', 'E74.801', 'SXTNB', '');
INSERT INTO `05diseases` VALUES ('5127', '草酸尿', '341', 'E74.851', 'CSN', '');
INSERT INTO `05diseases` VALUES ('5128', '草酸盐沉积症(结石)(桑椹状结石)', '278', 'E74.852', 'CSYCJZJSSSZJS', '');
INSERT INTO `05diseases` VALUES ('5129', '高草酸尿(型)[原发性高草酸尿]', '341', 'E74.853', 'GCSNXYFXGCSN', '');
INSERT INTO `05diseases` VALUES ('5130', '特发性戊糖尿', '348', 'E74.854', 'TFXWTN', '');
INSERT INTO `05diseases` VALUES ('5131', '泰－萨克斯病', '268', 'E75.051', 'TSKSB', '');
INSERT INTO `05diseases` VALUES ('5132', '桑德霍夫病', '268', 'E75.052', 'SDHFB', '');
INSERT INTO `05diseases` VALUES ('5133', '成人型ＧＭ2神经节苷脂沉积症', '313', 'E75.053', 'CRXSJJGZCJZ', '');
INSERT INTO `05diseases` VALUES ('5134', '幼年型ＧＭ2神经节苷脂沉积症', '313', 'E75.054', 'YNXSJJGZCJZ', '');
INSERT INTO `05diseases` VALUES ('5135', '神经节苷脂沉积病', '313', 'E75.101', 'SJJGZCJB', '');
INSERT INTO `05diseases` VALUES ('5136', 'ＧＭ1神经节苷脂沉积症', '313', 'E75.151', 'SJJGZCJZ', '');
INSERT INTO `05diseases` VALUES ('5137', 'ＧＭ3神经节苷脂沉积症', '313', 'E75.152', 'SJJGZCJZ', '');
INSERT INTO `05diseases` VALUES ('5138', 'Ⅳ型粘脂贮积症', '278', 'E75.153', 'SXNZZJZ', '');
INSERT INTO `05diseases` VALUES ('5139', '高歇氏病[脑苷脂贮积综合征]', '234', 'E75.201', 'GXSBNGZZJZHZ', '');
INSERT INTO `05diseases` VALUES ('5140', '脑白质营养不良', '234', 'E75.202', 'NBZYYBL', '');
INSERT INTO `05diseases` VALUES ('5141', '神经鞘磷脂沉积病[尼曼－皮克氏病综合征]', '313', 'E75.203', 'SJQLZCJBNMPKSBZHZ', '');
INSERT INTO `05diseases` VALUES ('5142', '异染性脑白质营养不良', '234', 'E75.204', 'YRXNBZYYBL', '');
INSERT INTO `05diseases` VALUES ('5143', '尼曼－皮克脾大', '253', 'E75.251', 'NMPKPD', '');
INSERT INTO `05diseases` VALUES ('5144', '佩利措伊斯－梅茨巴赫病[家族性脑白质病]', '234', 'E75.252', 'PLCYSMCBHBJZXNBZB', '');
INSERT INTO `05diseases` VALUES ('5145', '葡糖脑昔脂病[戈谢病或戈谢脾大]', '234', 'E75.253', 'PTNXZBGXBHGXPD', '');
INSERT INTO `05diseases` VALUES ('5146', '法布里(－安德森)病', '268', 'E75.254+', 'FBLADSB', '');
INSERT INTO `05diseases` VALUES ('5147', '法伯病(综合征)', '268', 'E75.255', 'FBBZHZ', '');
INSERT INTO `05diseases` VALUES ('5148', '鞘脂类代谢障碍 NOS', '52', 'E75.351', 'QZLDXZA', '');
INSERT INTO `05diseases` VALUES ('5149', '巴滕病', '268', 'E75.451', 'BTB', '');
INSERT INTO `05diseases` VALUES ('5150', '比尔朔夫斯基－扬斯基病', '268', 'E75.452', 'BESFSJYSJB', '');
INSERT INTO `05diseases` VALUES ('5151', '婴儿型脑黄斑变性症[黑蒙性白痴或台－沙病]', '234', 'E75.453', 'YEXNHBBXZHMXBCHTSB', '');
INSERT INTO `05diseases` VALUES ('5152', '库夫斯病[大脑神经鞘脂病的晚少年型]', '313', 'E75.454', 'KFSBDNSJQZBDWSNX', '');
INSERT INTO `05diseases` VALUES ('5153', '脂肪沉积大脑变性', '234', 'E75.455+', 'ZFCJDNBX', '');
INSERT INTO `05diseases` VALUES ('5154', '施皮格尔迈尔－福格特病[家族黑蒙性白痴]', '268', 'E75.456', 'SPGEMEFGTBJZHMXBC', '');
INSERT INTO `05diseases` VALUES ('5155', '脑视网膜性脂肪沉积症', '234', 'E75.457', 'NSWMXZFCJZ', '');
INSERT INTO `05diseases` VALUES ('5156', '黄色瘤', '261', 'E75.501', 'HSL', '');
INSERT INTO `05diseases` VALUES ('5157', '幼年性黄色瘤', '261', 'E75.502', 'YNXHSL', '');
INSERT INTO `05diseases` VALUES ('5158', '原发性家族性黄瘤病', '261', 'E75.503', 'YFXJZXHLB', '');
INSERT INTO `05diseases` VALUES ('5159', '脑腱胆固醇沉着[范.博盖尔特－谢勒－爱泼斯坦病或综合征]', '53', 'E75.551', 'NJDGCCZFBGETXLAPSTBH', '');
INSERT INTO `05diseases` VALUES ('5160', '关节黄瘤病', '123', 'E75.552', 'GJHLB', '');
INSERT INTO `05diseases` VALUES ('5161', '腱(鞘)黄瘤病', '261', 'E75.553', 'JQHLB', '');
INSERT INTO `05diseases` VALUES ('5162', '脑腱黄瘤病', '234', 'E75.554', 'NJHLB', '');
INSERT INTO `05diseases` VALUES ('5163', '皮腱黄瘤病', '261', 'E75.555', 'PJHLB', '');
INSERT INTO `05diseases` VALUES ('5164', '活尔曼病', '268', 'E75.556', 'HEMB', '');
INSERT INTO `05diseases` VALUES ('5165', '大脑脂沉积性痴呆', '234', 'E75.557+', 'DNZCJXCD', '');
INSERT INTO `05diseases` VALUES ('5166', '脂贮积病', '268', 'E75.601', 'ZZJB', '');
INSERT INTO `05diseases` VALUES ('5167', '全身性脂沉积症性大脑变性', '234', 'E75.602+', 'QSXZCJZXDNBX', '');
INSERT INTO `05diseases` VALUES ('5168', '脂质沉积性肌病', '268', 'E75.603+', 'ZZCJXJB', '');
INSERT INTO `05diseases` VALUES ('5169', 'Ⅰ型粘多糖病[胡勒-沙伊氏综合症]', '67', 'E76.051', 'YXNDTBHLSYSZHZ', '');
INSERT INTO `05diseases` VALUES ('5170', 'ⅠS型粘多糖病[沙伊氏综合征]', '67', 'E76.052', 'YXNDTBSYSZHZ', '');
INSERT INTO `05diseases` VALUES ('5171', '脂肪软骨营养不良', '448', 'E76.053', 'ZFRGYYBL', '');
INSERT INTO `05diseases` VALUES ('5172', 'Ⅱ型粘多糖病[亨特－胡尔勒氏综合]', '67', 'E76.151', 'EXNDTBHTHELSZH', '');
INSERT INTO `05diseases` VALUES ('5173', 'Ⅲ型粘多糖病[桑菲立波氏综合征]', '67', 'E76.251', 'SXNDTBSFLBSZHZ', '');
INSERT INTO `05diseases` VALUES ('5174', 'Ⅳ型粘多糖病[马洛托－拉米综合征](轻度)(重度)', '67', 'E76.252', 'SXNDTBMLTLMZHZQDZD', '');
INSERT INTO `05diseases` VALUES ('5175', 'Ⅳ型粘多糖病[莫尔基奥(-乌尔里克)(-布雷斯福德)综合征]', '67', 'E76.253', 'SXNDTBMEJAWELKBLSFDZ', '');
INSERT INTO `05diseases` VALUES ('5176', '粘多糖贮积病', '268', 'E76.301', 'NDTZJB', '');
INSERT INTO `05diseases` VALUES ('5177', '粘多糖贮积性心脏病', '403', 'E76.302+', 'NDTZJXXZB', '');
INSERT INTO `05diseases` VALUES ('5178', '其他氨基葡聚糖代谢紊乱', '52', 'E76.851', 'QTAJPJTDXWL', '');
INSERT INTO `05diseases` VALUES ('5179', '未特指的氨基葡聚糖果代谢紊乱', '52', 'E76.951', 'WTZDAJPJTGDXWL', '');
INSERT INTO `05diseases` VALUES ('5180', '粘脂贮积病Ⅱ型[Ⅰ型细胞]', '376', 'E77.051', 'NZZJBEXYXXB', '');
INSERT INTO `05diseases` VALUES ('5181', '粘脂贮积病Ⅲ型[假胡勒多种营养不良]', '448', 'E77.052', 'NZZJBSXJHLDZYYBL', '');
INSERT INTO `05diseases` VALUES ('5182', '唾液酸沉积病[粘脂贮积病Ⅰ型]', '268', 'E77.151', 'TYSCJBNZZJBYX', '');
INSERT INTO `05diseases` VALUES ('5183', '岩藻糖苷贮积病', '268', 'E77.152', 'YZTGZJB', '');
INSERT INTO `05diseases` VALUES ('5184', '低(白)蛋白血(症)', '275', 'E77.801', 'DBDBXZ', '');
INSERT INTO `05diseases` VALUES ('5185', '糖蛋白紊乱 NOS', '278', 'E77.951', 'TDBWL', '');
INSERT INTO `05diseases` VALUES ('5186', '高胆固醇血症', '53', 'E78.001', 'GDGCXZ', '');
INSERT INTO `05diseases` VALUES ('5187', '家族性高胆固醇血症', '53', 'E78.002', 'JZXGDGCXZ', '');
INSERT INTO `05diseases` VALUES ('5188', '胆固醇性心包炎', '53', 'E78.051+', 'DGCXXBY', '');
INSERT INTO `05diseases` VALUES ('5189', 'Ⅱa型弗雷德里克森高脂蛋白血(症)', '275', 'E78.052', 'EXFLDLKSGZDBXZ', '');
INSERT INTO `05diseases` VALUES ('5190', 'Ａ族高甘油三脂血症', '275', 'E78.053', 'ZGGYSZXZ', '');
INSERT INTO `05diseases` VALUES ('5191', '高甘油脂血症 NOS', '275', 'E78.101', 'GGYZXZ', '');
INSERT INTO `05diseases` VALUES ('5192', 'Ｂ族高甘油三脂血症', '275', 'E78.151', 'ZGGYSZXZ', '');
INSERT INTO `05diseases` VALUES ('5193', '内源性高甘油脂血症', '275', 'E78.152', 'NYXGGYZXZ', '');
INSERT INTO `05diseases` VALUES ('5194', 'Ⅳ型弗雷德里克森高脂蛋白血(症)', '275', 'E78.153', 'SXFLDLKSGZDBXZ', '');
INSERT INTO `05diseases` VALUES ('5195', '高前β脂蛋白血症', '6', 'E78.154', 'GQZDBXZ', '');
INSERT INTO `05diseases` VALUES ('5196', '扁平黄瘤', '261', 'E78.201', 'BPHL', '');
INSERT INTO `05diseases` VALUES ('5197', '播散性黄(色)瘤', '261', 'E78.202', 'BSXHSL', '');
INSERT INTO `05diseases` VALUES ('5198', '混合性高脂血症', '100', 'E78.203', 'HHXGZXZ', '');
INSERT INTO `05diseases` VALUES ('5199', '结节性黄(色)瘤', '261', 'E78.204', 'JJXHSL', '');
INSERT INTO `05diseases` VALUES ('5200', 'Ⅲ型弗雷德里克森高脂蛋白(症)', '278', 'E78.251', 'SXFLDLKSGZDBZ', '');
INSERT INTO `05diseases` VALUES ('5201', 'Ⅱb型弗雷德里克森高脂蛋白血(症)', '275', 'E78.252', 'EXFLDLKSGZDBXZ', '');
INSERT INTO `05diseases` VALUES ('5202', '结节丘疹性黄瘤', '250', 'E78.253', 'JJQZXHL', '');
INSERT INTO `05diseases` VALUES ('5203', '混合高甘油脂血症', '275', 'E78.351', 'HHGGYZXZ', '');
INSERT INTO `05diseases` VALUES ('5204', '高乳糜微粒血症', '275', 'E78.352', 'GRMWLXZ', '');
INSERT INTO `05diseases` VALUES ('5205', 'Ⅰ型高脂蛋白血(症)', '275', 'E78.353', 'YXGZDBXZ', '');
INSERT INTO `05diseases` VALUES ('5206', 'Ⅴ型高脂蛋白血(症)[混合型高脂蛋白症]', '275', 'E78.354', 'WXGZDBXZHHXGZDBZ', '');
INSERT INTO `05diseases` VALUES ('5207', '视网膜脂血症[比尔格-格尔茨型]', '326', 'E78.355', 'SWMZXZBEGGECX', '');
INSERT INTO `05diseases` VALUES ('5208', '高血脂性肝脾大', '92', 'E78.356+', 'GXZXGPD', '');
INSERT INTO `05diseases` VALUES ('5209', '家族性混合性高脂血症', '100', 'E78.451', 'JZXHHXGZXZ', '');
INSERT INTO `05diseases` VALUES ('5210', '高脂血症', '100', 'E78.501', 'GZXZ', '');
INSERT INTO `05diseases` VALUES ('5211', '视网膜脂血症', '326', 'E78.502', 'SWMZXZ', '');
INSERT INTO `05diseases` VALUES ('5212', '棘红细胞(增多)症', '376', 'E78.601', 'JHXBZDZ', '');
INSERT INTO `05diseases` VALUES ('5213', '低α脂蛋白血症', '6', 'E78.651', 'DZDBXZ', '');
INSERT INTO `05diseases` VALUES ('5214', '低β脂蛋白血症', '6', 'E78.652', 'DZDBXZ', '');
INSERT INTO `05diseases` VALUES ('5215', '低脂蛋白血症', '6', 'E78.653', 'DZDBXZ', '');
INSERT INTO `05diseases` VALUES ('5216', '丹吉尔病', '268', 'E78.654', 'DJEB', '');
INSERT INTO `05diseases` VALUES ('5217', '巴森-科恩茨维格病或综合征[无β脂蛋白血症]', '6', 'E78.655', 'BSKECWGBHZHZWZDBXZ', '');
INSERT INTO `05diseases` VALUES ('5218', '脂肪肉芽肿病', '295', 'E78.801', 'ZFRYZB', '');
INSERT INTO `05diseases` VALUES ('5219', '脂(质)蛋白沉积症', '278', 'E78.851', 'ZZDBCJZ', '');
INSERT INTO `05diseases` VALUES ('5220', '骨软骨营养不良', '448', 'E78.901', 'GRGYYBL', '');
INSERT INTO `05diseases` VALUES ('5221', '脂蛋白代谢紊乱 NOS', '52', 'E78.951', 'ZDBDXWL', '');
INSERT INTO `05diseases` VALUES ('5222', '高尿酸血症', '342', 'E79.001', 'GNSXZ', '');
INSERT INTO `05diseases` VALUES ('5223', '无症状高尿酸血症', '342', 'E79.051', 'WZZGNSXZ', '');
INSERT INTO `05diseases` VALUES ('5224', '莱施－尼汉综合征', '278', 'E79.151+', 'LSNHZHZ', '');
INSERT INTO `05diseases` VALUES ('5225', '黄嘌呤尿症', '269', 'E79.851', 'HPLNZ', '');
INSERT INTO `05diseases` VALUES ('5226', '遗传性黄嘌呤尿症', '269', 'E79.852', 'YCXHPLNZ', '');
INSERT INTO `05diseases` VALUES ('5227', '嘧啶代谢紊乱 NOS', '52', 'E79.951', 'MDDXWL', '');
INSERT INTO `05diseases` VALUES ('5228', '遗传性红细胞生成性卟啉症', '376', 'E80.051', 'YCXHXBSCXBLZ', '');
INSERT INTO `05diseases` VALUES ('5229', '先天性红细胞生成性卟啉症', '383', 'E80.052', 'XTXHXBSCXBLZ', '');
INSERT INTO `05diseases` VALUES ('5230', '迟发性皮肤卟啉症', '250', 'E80.151', 'CFXPFBLZ', '');
INSERT INTO `05diseases` VALUES ('5231', '卟啉症[紫质症]', '278', 'E80.201', 'BLZZZZ', '');
INSERT INTO `05diseases` VALUES ('5232', '卟啉症(后天性)', '278', 'E80.251', 'BLZHTX', '');
INSERT INTO `05diseases` VALUES ('5233', '中毒性卟啉症', '471', 'E80.252', 'ZDXBLZ', '');
INSERT INTO `05diseases` VALUES ('5234', '急性间歇性(肝)血卟啉病', '92', 'E80.253', 'JXJXXGXBLB', '');
INSERT INTO `05diseases` VALUES ('5235', '过氧化氢酶缺乏[竹原]', '278', 'E80.351', 'GYHQMQFZY', '');
INSERT INTO `05diseases` VALUES ('5236', '吉耳伯特氏病Gilber综合症[良性非结合性胆红素血症]', '70', 'E80.401', 'JEBTSBZHZLXFJHXDHSXZ', '');
INSERT INTO `05diseases` VALUES ('5237', '先天性高胆红素血症[克里格勒－纳贾尔病或综合征]', '53', 'E80.501', 'XTXGDHSXZKLGLNJEBHZH', '');
INSERT INTO `05diseases` VALUES ('5238', '迪宾(杜宾)-约翰逊综合征[黄疸－肝脏色素沉着综合征]', '137', 'E80.601', 'DBDBYHXZHZHDGZSSCZZH', '');
INSERT INTO `05diseases` VALUES ('5239', '肝炎后高胆红素血症', '93', 'E80.602', 'GYHGDHSXZ', '');
INSERT INTO `05diseases` VALUES ('5240', '非新生儿高胆红素血症', '53', 'E80.603', 'FXSEGDHSXZ', '');
INSERT INTO `05diseases` VALUES ('5241', '罗特尔氏综合征[慢性家族性非溶血性黄疸]', '137', 'E80.604', 'LTESZHZMXJZXFRXXHD', '');
INSERT INTO `05diseases` VALUES ('5242', '其他胆红素代谢紊乱', '53', 'E80.651', 'QTDHSDXWL', '');
INSERT INTO `05diseases` VALUES ('5243', '体质性高胆红素血症', '53', 'E80.652', 'TZXGDHSXZ', '');
INSERT INTO `05diseases` VALUES ('5244', '罗托综合征', '278', 'E80.653', 'LTZHZ', '');
INSERT INTO `05diseases` VALUES ('5245', '胆红素代谢紊乱 NOS', '53', 'E80.751', 'DHSDXWL', '');
INSERT INTO `05diseases` VALUES ('5246', '肝豆状核变性[威尔逊病]', '92', 'E83.001', 'GDZHBXWEXB', '');
INSERT INTO `05diseases` VALUES ('5247', '门凯氏综合征[门克病遗传性铜吸收障碍]', '268', 'E83.002', 'MKSZHZMKBYCXTXSZA', '');
INSERT INTO `05diseases` VALUES ('5248', '铜代谢紊乱', '52', 'E83.003', 'TDXWL', '');
INSERT INTO `05diseases` VALUES ('5249', '肝豆状核变性痴呆', '92', 'E83.004+', 'GDZHBXCD', '');
INSERT INTO `05diseases` VALUES ('5250', '铜代谢紊乱肝豆状核变性精神病', '177', 'E83.051', 'TDXWLGDZHBXJSB', '');
INSERT INTO `05diseases` VALUES ('5251', '威尔逊病肾盂肾炎', '315', 'E83.052+', 'WEXBSYSY', '');
INSERT INTO `05diseases` VALUES ('5252', '血色病', '275', 'E83.101', 'XSB', '');
INSERT INTO `05diseases` VALUES ('5253', '血色病性心肌病', '397', 'E83.102', 'XSBXXJB', '');
INSERT INTO `05diseases` VALUES ('5254', '肺含铁血黄素沉积症', '79', 'E83.103+', 'FHTXHSCJZ', '');
INSERT INTO `05diseases` VALUES ('5255', '肝含铁血黄素沉积症', '92', 'E83.104+', 'GHTXHSCJZ', '');
INSERT INTO `05diseases` VALUES ('5256', '特发性肺含铁血黄素沉积症', '79', 'E83.105+', 'TFXFHTXHSCJZ', '');
INSERT INTO `05diseases` VALUES ('5257', '青铜色糖尿病', '348', 'E83.151', 'QTSTNB', '');
INSERT INTO `05diseases` VALUES ('5258', '糖尿病性血色病', '348', 'E83.152', 'TNBXXSB', '');
INSERT INTO `05diseases` VALUES ('5259', '血色素沉着关节病', '123', 'E83.153+', 'XSSCZGJB', '');
INSERT INTO `05diseases` VALUES ('5260', '饮食性含铁血黄素沉积症', '275', 'E83.154', 'YSXHTXHSCJZ', '');
INSERT INTO `05diseases` VALUES ('5261', '铁代谢紊乱', '52', 'E83.155', 'TDXWL', '');
INSERT INTO `05diseases` VALUES ('5262', '糖尿病伴色素性肝硬变[阿诺－肖法尔氏综合征]', '348', 'E83.156', 'TNBBSSXGYBANXFESZHZ', '');
INSERT INTO `05diseases` VALUES ('5263', '肠病性肢皮炎', '252', 'E83.251', 'CBXZPY', '');
INSERT INTO `05diseases` VALUES ('5264', '锌代谢紊乱', '52', 'E83.252', 'XDXWL', '');
INSERT INTO `05diseases` VALUES ('5265', '维生素Ｄ抵抗性骨软化', '112', 'E83.301+', 'WSSDKXGRH', '');
INSERT INTO `05diseases` VALUES ('5266', '低磷血症', '275', 'E83.302', 'DLXZ', '');
INSERT INTO `05diseases` VALUES ('5267', '高磷尿症', '269', 'E83.303', 'GLNZ', '');
INSERT INTO `05diseases` VALUES ('5268', '高磷酸盐血症(高磷血盐症)', '275', 'E83.304', 'GLSYXZGLXYZ', '');
INSERT INTO `05diseases` VALUES ('5269', '磷代谢紊乱', '52', 'E83.306', 'LDXWL', '');
INSERT INTO `05diseases` VALUES ('5270', '维生素Ｄ抵抗佝偻病', '369', 'E83.307+', 'WSSDKGLB', '');
INSERT INTO `05diseases` VALUES ('5271', '维生素Ｄ依赖性佝偻病', '369', 'E83.308+', 'WSSYLXGLB', '');
INSERT INTO `05diseases` VALUES ('5272', '低磷酸盐血症(磷酸酶过少症)', '275', 'E83.351', 'DLSYXZLSMGSZ', '');
INSERT INTO `05diseases` VALUES ('5273', '低镁血(症)', '275', 'E83.401', 'DMXZ', '');
INSERT INTO `05diseases` VALUES ('5274', '高镁血(症)', '275', 'E83.451', 'GMXZ', '');
INSERT INTO `05diseases` VALUES ('5275', '低钙血性惊厥', '275', 'E83.501', 'DGXXJJ', '');
INSERT INTO `05diseases` VALUES ('5276', '低钙血症', '275', 'E83.502', 'DGXZ', '');
INSERT INTO `05diseases` VALUES ('5277', '钙代谢紊乱', '52', 'E83.503', 'GDXWL', '');
INSERT INTO `05diseases` VALUES ('5278', '特发性高钙尿(症)', '269', 'E83.504', 'TFXGGNZ', '');
INSERT INTO `05diseases` VALUES ('5279', '高钙血症(低钙尿性、家族性)', '269', 'E83.505', 'GGXZDGNXJZX', '');
INSERT INTO `05diseases` VALUES ('5280', '低钙血性(手足搐搦性)白内障', '4', 'E83.506+', 'DGXXSZCNXBNZ', '');
INSERT INTO `05diseases` VALUES ('5281', '乳碱病或乳碱综合征', '268', 'E83.551', 'RJBHRJZHZ', '');
INSERT INTO `05diseases` VALUES ('5282', '钙质沉着症', '278', 'E83.552', 'GZCZZ', '');
INSERT INTO `05diseases` VALUES ('5283', '高钙血症痴呆', '34', 'E83.553+', 'GGXZCD', '');
INSERT INTO `05diseases` VALUES ('5284', '其他矿物质代谢紊乱', '52', 'E83.851', 'QTKWZDXWL', '');
INSERT INTO `05diseases` VALUES ('5285', '矿物质代谢紊乱 NOS', '52', 'E83.951', 'KWZDXWL', '');
INSERT INTO `05diseases` VALUES ('5286', '粘液粘稠病[肺囊性纤维化病]', '79', 'E84.051', 'NYNCBFNXXWHB', '');
INSERT INTO `05diseases` VALUES ('5287', '胎粪性(胎儿或新生儿)肠梗阻', '405', 'E84.101+', 'TFXTEHXSECGZ', '');
INSERT INTO `05diseases` VALUES ('5288', '囊性纤维病伴有肠表现', '259', 'E84.151', 'NXXWBBYCBX', '');
INSERT INTO `05diseases` VALUES ('5289', '囊性纤维病伴有混合性表现', '268', 'E84.851', 'NXXWBBYHHXBX', '');
INSERT INTO `05diseases` VALUES ('5290', '胰腺囊性纤维变性[胰管粘稠物阻塞症]', '262', 'E84.901', 'YXNXXWBXYGNCWZSZ', '');
INSERT INTO `05diseases` VALUES ('5291', '囊性纤维病 NOS', '268', 'E84.951', 'NXXWB', '');
INSERT INTO `05diseases` VALUES ('5292', '家族性地中海热', '271', 'E85.001', 'JZXDZHR', '');
INSERT INTO `05diseases` VALUES ('5293', '周期热', '271', 'E85.002', 'ZQR', '');
INSERT INTO `05diseases` VALUES ('5294', '遗传性淀粉性肾病', '314', 'E85.051', 'YCXDFXSB', '');
INSERT INTO `05diseases` VALUES ('5295', '淀粉样性(葡萄牙型)多神经病', '313', 'E85.151', 'DFYXPTYXDSJB', '');
INSERT INTO `05diseases` VALUES ('5296', '家族性遗传性淀粉样变性 NOS', '439', 'E85.251', 'JZXYCXDFYBX', '');
INSERT INTO `05diseases` VALUES ('5297', '继发性全身性淀粉样变性', '278', 'E85.351', 'JFXQSXDFYBX', '');
INSERT INTO `05diseases` VALUES ('5298', '膀胱淀粉样病变', '246', 'E85.401', 'BGDFYBB', '');
INSERT INTO `05diseases` VALUES ('5299', '喉淀粉样变性', '133', 'E85.402', 'HDFYBX', '');
INSERT INTO `05diseases` VALUES ('5300', '睑淀粉样变', '278', 'E85.403', 'JDFYB', '');
INSERT INTO `05diseases` VALUES ('5301', '脾淀粉样变性', '253', 'E85.404', 'PDFYBX', '');
INSERT INTO `05diseases` VALUES ('5302', '上呼吸道淀粉样变性', '266', 'E85.405', 'SHXDDFYBX', '');
INSERT INTO `05diseases` VALUES ('5303', '咽淀粉样变', '276', 'E85.406', 'YDFYB', '');
INSERT INTO `05diseases` VALUES ('5304', '鼻咽淀粉样变性', '16', 'E85.407+', 'BYDFYBX', '');
INSERT INTO `05diseases` VALUES ('5305', '淀粉样变性性周围神经病', '313', 'E85.408+', 'DFYBXXZWSJB', '');
INSERT INTO `05diseases` VALUES ('5306', '皮肤淀粉样变性', '250', 'E85.409+', 'PFDFYBX', '');
INSERT INTO `05diseases` VALUES ('5307', '肾淀粉样变性', '314', 'E85.410+', 'SDFYBX', '');
INSERT INTO `05diseases` VALUES ('5308', '肾脏淀粉样变性', '314', 'E85.411+', 'SZDFYBX', '');
INSERT INTO `05diseases` VALUES ('5309', '淀粉样变性心脏病', '403', 'E85.451+', 'DFYBXXZB', '');
INSERT INTO `05diseases` VALUES ('5310', '其他淀粉样变性', '278', 'E85.851', 'QTDFYBX', '');
INSERT INTO `05diseases` VALUES ('5311', '淀粉样变性 NOS', '278', 'E85.901', 'DFYBX', '');
INSERT INTO `05diseases` VALUES ('5312', '低血容量', '275', 'E86.X01', 'DXRL', '');
INSERT INTO `05diseases` VALUES ('5313', '脱水(等渗性脱水)', '278', 'E86.X02', 'TSDSXTS', '');
INSERT INTO `05diseases` VALUES ('5314', '低渗性失(脱)水', '278', 'E86.X51', 'DSXSTS', '');
INSERT INTO `05diseases` VALUES ('5315', '高钠血症', '275', 'E87.001', 'GNXZ', '');
INSERT INTO `05diseases` VALUES ('5316', '高渗透性综合征', '278', 'E87.051', 'GSTXZHZ', '');
INSERT INTO `05diseases` VALUES ('5317', '低钠血症(低钠性、消耗性、稀释性)', '275', 'E87.101', 'DNXZDNXXHXXSX', '');
INSERT INTO `05diseases` VALUES ('5318', '代谢性酸中毒', '471', 'E87.201', 'DXXSZD', '');
INSERT INTO `05diseases` VALUES ('5319', '高血氯性酸中毒', '471', 'E87.202', 'GXLXSZD', '');
INSERT INTO `05diseases` VALUES ('5320', '呼吸性酸中毒', '471', 'E87.203', 'HXXSZD', '');
INSERT INTO `05diseases` VALUES ('5321', '混合性酸中毒', '471', 'E87.204', 'HHXSZD', '');
INSERT INTO `05diseases` VALUES ('5322', '乳酸性酸中毒', '471', 'E87.205', 'RSXSZD', '');
INSERT INTO `05diseases` VALUES ('5323', '酸中毒', '471', 'E87.206', 'SZD', '');
INSERT INTO `05diseases` VALUES ('5324', '呼吸性酸中毒合并代谢性碱中毒', '471', 'E87.251', 'HXXSZDHBDXXJZD', '');
INSERT INTO `05diseases` VALUES ('5325', '酮症酸中毒', '471', 'E87.252', 'TZSZD', '');
INSERT INTO `05diseases` VALUES ('5326', '代谢性碱中毒', '471', 'E87.301', 'DXXJZD', '');
INSERT INTO `05diseases` VALUES ('5327', '低钾性碱', '278', 'E87.302', 'DJXJ', '');
INSERT INTO `05diseases` VALUES ('5328', '呼吸性碱中毒', '471', 'E87.303', 'HXXJZD', '');
INSERT INTO `05diseases` VALUES ('5329', '碱中毒', '471', 'E87.304', 'JZD', '');
INSERT INTO `05diseases` VALUES ('5330', '高碳酸血症后碱中毒', '471', 'E87.351', 'GTSXZHJZD', '');
INSERT INTO `05diseases` VALUES ('5331', '混合性酸碱平衡失调', '278', 'E87.401', 'HHXSJPHSD', '');
INSERT INTO `05diseases` VALUES ('5332', '高钾血(症)', '275', 'E87.501', 'GJXZ', '');
INSERT INTO `05diseases` VALUES ('5333', '钾过量', '278', 'E87.551', 'JGL', '');
INSERT INTO `05diseases` VALUES ('5334', '低钾性抽搐', '278', 'E87.601', 'DJXCC', '');
INSERT INTO `05diseases` VALUES ('5335', '低钾血症', '275', 'E87.602', 'DJXZ', '');
INSERT INTO `05diseases` VALUES ('5336', '水中毒', '471', 'E87.701', 'SZD', '');
INSERT INTO `05diseases` VALUES ('5337', '体液潴留(过多)', '278', 'E87.751', 'TYZLGD', '');
INSERT INTO `05diseases` VALUES ('5338', '血溶量过多', '275', 'E87.752', 'XRLGD', '');
INSERT INTO `05diseases` VALUES ('5339', '低氯血症', '275', 'E87.801', 'DLXZ', '');
INSERT INTO `05diseases` VALUES ('5340', '电解质紊乱', '278', 'E87.802', 'DJZWL', '');
INSERT INTO `05diseases` VALUES ('5341', '高氯血症', '275', 'E87.803', 'GLXZ', '');
INSERT INTO `05diseases` VALUES ('5342', '三低(低钾、钠、氯)综合征', '278', 'E87.804', 'SDDJNLZHZ', '');
INSERT INTO `05diseases` VALUES ('5343', '高蛋白血症', '6', 'E88.001', 'GDBXZ', '');
INSERT INTO `05diseases` VALUES ('5344', '双蛋白血症', '6', 'E88.051', 'SDBXZ', '');
INSERT INTO `05diseases` VALUES ('5345', '部分性脂肪营养不良', '448', 'E88.101', 'BFXZFYYBL', '');
INSERT INTO `05diseases` VALUES ('5346', '进行性脂肪营养不良[巴拉克尔(-西蒙斯)病]', '448', 'E88.102', 'JXXZFYYBLBLKEXMSB', '');
INSERT INTO `05diseases` VALUES ('5347', '全身性脂肪营养不良', '448', 'E88.103', 'QSXZFYYBL', '');
INSERT INTO `05diseases` VALUES ('5348', '疼痛性脂肪过多症[德卡姆]', '273', 'E88.201', 'TTXZFGDZDKM', '');
INSERT INTO `05diseases` VALUES ('5349', '脂肪堆积', '278', 'E88.202', 'ZFDJ', '');
INSERT INTO `05diseases` VALUES ('5350', '脂肪过多症', '278', 'E88.203', 'ZFGDZ', '');
INSERT INTO `05diseases` VALUES ('5351', '霍法氏综合征(髌骨后脂肪垫综合征)', '19', 'E88.801', 'HFSZHZBGHZFDZHZ', '');
INSERT INTO `05diseases` VALUES ('5352', '饥饿性酮症', '278', 'E88.802', 'JEXTZ', '');
INSERT INTO `05diseases` VALUES ('5353', '酮症', '278', 'E88.803', 'TZ', '');
INSERT INTO `05diseases` VALUES ('5354', '髌前脂质滑膜炎[霍法－卡斯特蒂氏病]', '134', 'E88.851', 'BQZZHMYHFKSTDSB', '');
INSERT INTO `05diseases` VALUES ('5355', '洛努瓦－邦素德腺脂瘤病', '261', 'E88.852', 'LNWBSDXZLB', '');
INSERT INTO `05diseases` VALUES ('5356', '膝关节创伤性脂肪组织增生[霍法病]', '123', 'E88.853', 'XGJCSXZFZZZSHFB', '');
INSERT INTO `05diseases` VALUES ('5357', '代谢性白内障', '4', 'E88.901+', 'DXXBNZ', '');
INSERT INTO `05diseases` VALUES ('5358', '代谢性骨病', '52', 'E88.902+', 'DXXGB', '');
INSERT INTO `05diseases` VALUES ('5359', '代谢性脊髓病', '52', 'E88.903+', 'DXXJSB', '');
INSERT INTO `05diseases` VALUES ('5360', '代谢性心肌病', '397', 'E88.904+', 'DXXXJB', '');
INSERT INTO `05diseases` VALUES ('5361', '放射治疗后甲状腺机能减退', '159', 'E89.001', 'FSZLHJZXJNJT', '');
INSERT INTO `05diseases` VALUES ('5362', '手术后甲状腺机能减退', '330', 'E89.002', 'SSHJZXJNJT', '');
INSERT INTO `05diseases` VALUES ('5363', '手术后低胰岛素血症', '330', 'E89.101', 'SSHDYDSXZ', '');
INSERT INTO `05diseases` VALUES ('5364', '手术后胰腺外分泌功能不全', '262', 'E89.102', 'SSHYXWFMGNBQ', '');
INSERT INTO `05diseases` VALUES ('5365', '胰腺切除术后高血糖', '262', 'E89.151', 'YXQCSHGXT', '');
INSERT INTO `05diseases` VALUES ('5366', '甲状旁腺缺失性手足搐搦', '158', 'E89.201', 'JZPXQSXSZCN', '');
INSERT INTO `05diseases` VALUES ('5367', '手术后甲状旁腺机能减退', '330', 'E89.202', 'SSHJZPXJNJT', '');
INSERT INTO `05diseases` VALUES ('5368', '手术后垂体机能减退', '330', 'E89.301', 'SSHCTJNJT', '');
INSERT INTO `05diseases` VALUES ('5369', '医原性垂体障碍', '45', 'E89.302', 'YYXCTZA', '');
INSERT INTO `05diseases` VALUES ('5370', '垂体切除后垂体机能障碍', '45', 'E89.351', 'CTQCHCTJNZA', '');
INSERT INTO `05diseases` VALUES ('5371', '放射后卵巢衰竭', '86', 'E89.401', 'FSHLCSJ', '');
INSERT INTO `05diseases` VALUES ('5372', '手术后卵巢衰竭', '86', 'E89.402', 'SSHLCSJ', '');
INSERT INTO `05diseases` VALUES ('5373', '医源性卵巢衰竭', '86', 'E89.403', 'YYXLCSJ', '');
INSERT INTO `05diseases` VALUES ('5374', '继发性睾丸机能减退(操作后)', '230', 'E89.501', 'JFXGWJNJTCZH', '');
INSERT INTO `05diseases` VALUES ('5375', '手术后睾丸机能减退', '230', 'E89.502', 'SSHGWJNJT', '');
INSERT INTO `05diseases` VALUES ('5376', '操作后肾上腺皮质(髓质)机能减退', '314', 'E89.601', 'CZHSSXPZSZJNJT', '');
INSERT INTO `05diseases` VALUES ('5377', '血透后失衡综合征', '275', 'E89.801', 'XTHSHZHZ', '');
INSERT INTO `05diseases` VALUES ('5378', '手术后尿崩症', '330', 'E89.802', 'SSHNBZ', '');
INSERT INTO `05diseases` VALUES ('5379', '其他操作后内分泌代谢紊乱', '52', 'E89.851', 'QTCZHNFMDXWL', '');
INSERT INTO `05diseases` VALUES ('5380', '操作后内分泌代谢紊乱 NOS', '52', 'E89.951', 'CZHNFMDXWL', '');
INSERT INTO `05diseases` VALUES ('5381', '急性发作的血管性痴呆', '34', 'F01.051', 'JXFZDXGXCD', '');
INSERT INTO `05diseases` VALUES ('5382', '多发脑梗死性痴呆', '234', 'F01.151', 'DFNGSXCD', '');
INSERT INTO `05diseases` VALUES ('5383', '皮层下血管性痴呆', '34', 'F01.251', 'PCXXGXCD', '');
INSERT INTO `05diseases` VALUES ('5384', '混合型皮层和皮层下血管性痴呆', '34', 'F01.351', 'HHXPCHPCXXGXCD', '');
INSERT INTO `05diseases` VALUES ('5385', '其他血管性痴呆', '34', 'F01.851', 'QTXGXCD', '');
INSERT INTO `05diseases` VALUES ('5386', '动脉硬化性痴呆', '34', 'F01.901', 'DMYHXCD', '');
INSERT INTO `05diseases` VALUES ('5387', '动脉硬化性精神病', '177', 'F01.902', 'DMYHXJSB', '');
INSERT INTO `05diseases` VALUES ('5388', '痴呆 NOS', '34', 'F03.X01', 'CD', '');
INSERT INTO `05diseases` VALUES ('5389', '老年精神病态', '177', 'F03.X02', 'LNJSBT', '');
INSERT INTO `05diseases` VALUES ('5390', '老年期痴呆抑郁型或妄想型', '34', 'F03.X03', 'LNQCDYYXHWXX', '');
INSERT INTO `05diseases` VALUES ('5391', '老年性(65岁以后)痴呆', '34', 'F03.X04', 'LNXSYHCD', '');
INSERT INTO `05diseases` VALUES ('5392', '器质性痴呆', '34', 'F03.X06', 'QZXCD', '');
INSERT INTO `05diseases` VALUES ('5393', '早老性痴呆', '34', 'F03.X07', 'ZLXCD', '');
INSERT INTO `05diseases` VALUES ('5394', '变性性(原发性)痴呆', '34', 'F03.X51', 'BXXYFXCD', '');
INSERT INTO `05diseases` VALUES ('5395', '老年性抑郁症', '442', 'F03.X52', 'LNXYYZ', '');
INSERT INTO `05diseases` VALUES ('5396', '非由酒精中毒性科尔萨科夫精神病或综合征', '177', 'F04.X51', 'FYJJZDXKESKFJSBHZHZ', '');
INSERT INTO `05diseases` VALUES ('5397', '被描述为非附加于痴呆的谵妄', '34', 'F05.051', 'BMSWFFJYCDDZW', '');
INSERT INTO `05diseases` VALUES ('5398', '附加于痴呆谵妄', '34', 'F05.151', 'FJYCDZW', '');
INSERT INTO `05diseases` VALUES ('5399', '其他谵妄(混合起因的谵妄)', '278', 'F05.851', 'QTZWHHQYDZW', '');
INSERT INTO `05diseases` VALUES ('5400', '感染性精神病', '177', 'F05.901', 'GRXJSB', '');
INSERT INTO `05diseases` VALUES ('5401', '谵妄 NOS', '278', 'F05.902', 'ZW', '');
INSERT INTO `05diseases` VALUES ('5402', '器质性幻觉症', '278', 'F06.051', 'QZXHJZ', '');
INSERT INTO `05diseases` VALUES ('5403', '器质性紧张性障碍', '278', 'F06.151', 'QZXJZXZA', '');
INSERT INTO `05diseases` VALUES ('5404', '器质性妄想性[精神分裂症样]障碍', '177', 'F06.201', 'QZXWXXJSFLZYZA', '');
INSERT INTO `05diseases` VALUES ('5405', '器质性心境[情感]障碍', '278', 'F06.351', 'QZXXJQGZA', '');
INSERT INTO `05diseases` VALUES ('5406', '器质性焦虑障碍', '165', 'F06.451', 'QZXJLZA', '');
INSERT INTO `05diseases` VALUES ('5407', '器质性分离性障碍', '278', 'F06.551', 'QZXFLXZA', '');
INSERT INTO `05diseases` VALUES ('5408', '器质性情绪不稳定[衰弱]障碍', '278', 'F06.651', 'QZXQXBWDSRZA', '');
INSERT INTO `05diseases` VALUES ('5409', '轻度认知障碍', '278', 'F06.751', 'QDRZZA', '');
INSERT INTO `05diseases` VALUES ('5410', '感染后器质性精神病', '177', 'F06.801', 'GRHQZXJSB', '');
INSERT INTO `05diseases` VALUES ('5411', '甲亢性精神病', '177', 'F06.802', 'JKXJSB', '');
INSERT INTO `05diseases` VALUES ('5412', '创伤性精神病', '177', 'F06.851', 'CSXJSB', '');
INSERT INTO `05diseases` VALUES ('5413', '器质性由于内分泌或代谢性病精神病', '177', 'F06.852', 'QZXYYNFMHDXXBJSB', '');
INSERT INTO `05diseases` VALUES ('5414', '癫痫性精神病', '177', 'F06.853', 'DXXJSB', '');
INSERT INTO `05diseases` VALUES ('5415', '脑(颅内)感染引起的精神病', '177', 'F06.854', 'NLNGRYQDJSB', '');
INSERT INTO `05diseases` VALUES ('5416', '多发性硬化引起的精神病', '177', 'F06.855', 'DFXYHYQDJSB', '');
INSERT INTO `05diseases` VALUES ('5417', '老年性痴呆引起的精神病', '177', 'F06.856', 'LNXCDYQDJSB', '');
INSERT INTO `05diseases` VALUES ('5418', '肠伤寒所致的精神障碍', '177', 'F06.901', 'CSHSZDJSZA', '');
INSERT INTO `05diseases` VALUES ('5419', '胆道感染所致的精神障碍', '53', 'F06.902', 'DDGRSZDJSZA', '');
INSERT INTO `05diseases` VALUES ('5420', '胆道术后精神障碍', '53', 'F06.903', 'DDSHJSZA', '');
INSERT INTO `05diseases` VALUES ('5421', '低血糖所致的精神障碍', '177', 'F06.904', 'DXTSZDJSZA', '');
INSERT INTO `05diseases` VALUES ('5422', '肺结核所致的精神障碍', '171', 'F06.905', 'FJHSZDJSZA', '');
INSERT INTO `05diseases` VALUES ('5423', '肺气肿所致的精神障碍', '177', 'F06.906', 'FQZSZDJSZA', '');
INSERT INTO `05diseases` VALUES ('5424', '肺炎所致的精神障碍', '81', 'F06.907', 'FYSZDJSZA', '');
INSERT INTO `05diseases` VALUES ('5425', '肝硬化所致的精神障碍', '177', 'F06.908', 'GYHSZDJSZA', '');
INSERT INTO `05diseases` VALUES ('5426', '感冒所致的精神障碍', '177', 'F06.909', 'GMSZDJSZA', '');
INSERT INTO `05diseases` VALUES ('5427', '高烧致精神障碍', '177', 'F06.910', 'GSZJSZA', '');
INSERT INTO `05diseases` VALUES ('5428', '高血压所致的精神障碍', '177', 'F06.911', 'GXYSZDJSZA', '');
INSERT INTO `05diseases` VALUES ('5429', '过敏性紫癜所致的精神障碍', '177', 'F06.912', 'GMXZDSZDJSZA', '');
INSERT INTO `05diseases` VALUES ('5430', '甲状腺机能亢进所致的精神障碍', '177', 'F06.913', 'JZXJNKJSZDJSZA', '');
INSERT INTO `05diseases` VALUES ('5431', '疟疾所致的精神障碍', '177', 'F06.914', 'YJSZDJSZA', '');
INSERT INTO `05diseases` VALUES ('5432', '肾炎所致的精神障碍', '177', 'F06.915', 'SYSZDJSZA', '');
INSERT INTO `05diseases` VALUES ('5433', '细菌性痢疾所致的精神障碍', '380', 'F06.916', 'XJXLJSZDJSZA', '');
INSERT INTO `05diseases` VALUES ('5434', '心脏病所致的精神障碍', '403', 'F06.917', 'XZBSZDJSZA', '');
INSERT INTO `05diseases` VALUES ('5435', '营养不良所致的精神障碍', '177', 'F06.918', 'YYBLSZDJSZA', '');
INSERT INTO `05diseases` VALUES ('5436', '有害气体中毒后精神障碍', '177', 'F06.919', 'YHQTZDHJSZA', '');
INSERT INTO `05diseases` VALUES ('5437', '中暑伴发精神障碍', '177', 'F06.920', 'ZSBFJSZA', '');
INSERT INTO `05diseases` VALUES ('5438', '器质性脑综合征 NOS', '234', 'F06.951', 'QZXNZHZ', '');
INSERT INTO `05diseases` VALUES ('5439', '器质性精神障碍 NOS', '177', 'F06.952', 'QZXJSZA', '');
INSERT INTO `05diseases` VALUES ('5440', '顶叶综合征', '278', 'F07.001', 'DYZHZ', '');
INSERT INTO `05diseases` VALUES ('5441', '额叶综合征', '278', 'F07.002', 'EYZHZ', '');
INSERT INTO `05diseases` VALUES ('5442', '脑白质切断术后综合征', '234', 'F07.051', 'NBZQDSHZHZ', '');
INSERT INTO `05diseases` VALUES ('5443', '脑叶切断术综合征', '234', 'F07.052', 'NYQDSZHZ', '');
INSERT INTO `05diseases` VALUES ('5444', '边缘性癫痫性人格综合征', '57', 'F07.053', 'BYXDXXRGZHZ', '');
INSERT INTO `05diseases` VALUES ('5445', '脑炎后综合征', '234', 'F07.101', 'NYHZHZ', '');
INSERT INTO `05diseases` VALUES ('5446', '颅内感染所致精神障碍', '177', 'F07.102', 'LNGRSZJSZA', '');
INSERT INTO `05diseases` VALUES ('5447', '脑膜炎后精神障碍', '177', 'F07.103', 'NMYHJSZA', '');
INSERT INTO `05diseases` VALUES ('5448', '脑炎后精神障碍', '177', 'F07.104', 'NYHJSZA', '');
INSERT INTO `05diseases` VALUES ('5449', '创伤性(脑震荡后)脑病', '234', 'F07.201', 'CSXNZDHNB', '');
INSERT INTO `05diseases` VALUES ('5450', '颅脑外伤所致的精神障碍', '177', 'F07.202', 'LNWSSZDJSZA', '');
INSERT INTO `05diseases` VALUES ('5451', '脑损伤后人格障碍', '234', 'F07.203', 'NSSHRGZA', '');
INSERT INTO `05diseases` VALUES ('5452', '脑外伤后综合征', '234', 'F07.204', 'NWSHZHZ', '');
INSERT INTO `05diseases` VALUES ('5453', '脑震荡后综合征', '234', 'F07.205', 'NZDHZHZ', '');
INSERT INTO `05diseases` VALUES ('5454', '一氧化碳中毒致精神障碍', '177', 'F07.801', 'YYHTZDZJSZA', '');
INSERT INTO `05diseases` VALUES ('5455', '脑血管病所致的精神障碍', '177', 'F07.802', 'NXGBSZDJSZA', '');
INSERT INTO `05diseases` VALUES ('5456', '右半球器质性情感性障碍', '278', 'F07.851', 'YBQQZXQGXZA', '');
INSERT INTO `05diseases` VALUES ('5457', '器质性精神综合征', '177', 'F07.951', 'QZXJSZHZ', '');
INSERT INTO `05diseases` VALUES ('5458', '脑病性精神病', '177', 'F09.X01', 'NBXJSB', '');
INSERT INTO `05diseases` VALUES ('5459', '脑器质性精神病', '177', 'F09.X02', 'NQZXJSB', '');
INSERT INTO `05diseases` VALUES ('5460', '器质性精神病', '177', 'F09.X03', 'QZXJSB', '');
INSERT INTO `05diseases` VALUES ('5461', '症状性精神病', '177', 'F09.X51', 'ZZXJSB', '');
INSERT INTO `05diseases` VALUES ('5462', '急性酒精中毒', '471', 'F10.001', 'JXJJZD', '');
INSERT INTO `05diseases` VALUES ('5463', '酒精中毒', '471', 'F10.002', 'JJZD', '');
INSERT INTO `05diseases` VALUES ('5464', '醉酒(饮酒过量)', '278', 'F10.051', 'ZJYJGL', '');
INSERT INTO `05diseases` VALUES ('5465', '酒瘾综合症', '278', 'F10.201', 'JYZHZ', '');
INSERT INTO `05diseases` VALUES ('5466', '慢性酒精中毒', '471', 'F10.202', 'MXJJZD', '');
INSERT INTO `05diseases` VALUES ('5467', '酒精(性)酒精中毒性戒断(戒酒综合症)', '471', 'F10.351', 'JJXJJZDXJDJJZHZ', '');
INSERT INTO `05diseases` VALUES ('5468', '酒精性精神病', '177', 'F10.501', 'JJXJSB', '');
INSERT INTO `05diseases` VALUES ('5469', '酒精中毒致精神障碍', '177', 'F10.502', 'JJZDZJSZA', '');
INSERT INTO `05diseases` VALUES ('5470', '慢性酒精性脑病', '234', 'F10.551', 'MXJJXNB', '');
INSERT INTO `05diseases` VALUES ('5471', '科萨科夫精神病[酒精中毒性精神病]', '177', 'F10.651', 'KSKFJSBJJZDXJSB', '');
INSERT INTO `05diseases` VALUES ('5472', '酒精性遗忘综合征[遗忘－虚构综合征]', '278', 'F10.652', 'JJXYWZHZYWXGZHZ', '');
INSERT INTO `05diseases` VALUES ('5473', '酒精中毒性小脑共济失调', '234', 'F10.751', 'JJZDXXNGJSD', '');
INSERT INTO `05diseases` VALUES ('5474', '慢性酒精(性)中毒性脑综合征', '234', 'F10.752', 'MXJJXZDXNZHZ', '');
INSERT INTO `05diseases` VALUES ('5475', '杜冷丁药物瘾', '433', 'F11.201', 'DLDYWY', '');
INSERT INTO `05diseases` VALUES ('5476', '吗啡型药物瘾', '433', 'F11.202', 'MFXYWY', '');
INSERT INTO `05diseases` VALUES ('5477', '镇痛药物瘾', '273', 'F11.203', 'ZTYWY', '');
INSERT INTO `05diseases` VALUES ('5478', '类阿片依赖综合症', '278', 'F11.251', 'LAPYLZHZ', '');
INSERT INTO `05diseases` VALUES ('5479', '大麻类药物瘾', '433', 'F12.251', 'DMLYWY', '');
INSERT INTO `05diseases` VALUES ('5480', '杜冷丁瘾', '278', 'F12.252', 'DLDY', '');
INSERT INTO `05diseases` VALUES ('5481', '安眠药物瘾', '433', 'F13.201', 'AMYWY', '');
INSERT INTO `05diseases` VALUES ('5482', '镇静药物（依赖）综合征', '433', 'F13.251', 'ZJYWYLZHZ', '');
INSERT INTO `05diseases` VALUES ('5483', '可卡因药物瘾', '433', 'F14.451', 'KKYYWY', '');
INSERT INTO `05diseases` VALUES ('5484', '苯丙胺类药物瘾', '433', 'F15.251', 'BBALYWY', '');
INSERT INTO `05diseases` VALUES ('5485', '使用致幻剂引起的精神和行为障碍', '177', 'F16.951', 'SYZHJYQDJSHXWZA', '');
INSERT INTO `05diseases` VALUES ('5486', '烟草瘾', '278', 'F17.251', 'YCY', '');
INSERT INTO `05diseases` VALUES ('5487', '使用烟草引起的精神和行为障碍', '177', 'F17.951', 'SYYCYQDJSHXWZA', '');
INSERT INTO `05diseases` VALUES ('5488', '使用挥发性溶剂引起的精神和行为障碍', '177', 'F18.951', 'SYHFXRJYQDJSHXWZA', '');
INSERT INTO `05diseases` VALUES ('5489', 'A.P.C药物瘾', '433', 'F19.201', 'YWY', '');
INSERT INTO `05diseases` VALUES ('5490', '药物瘾', '433', 'F19.202', 'YWY', '');
INSERT INTO `05diseases` VALUES ('5491', '戒药(脱药瘾)综合征(成人)', '278', 'F19.301', 'JYTYYZHZCR', '');
INSERT INTO `05diseases` VALUES ('5492', '药物引起的妄想状态或幻觉状态', '433', 'F19.451', 'YWYQDWXZTHHJZT', '');
INSERT INTO `05diseases` VALUES ('5493', 'A.P.C中毒致精神障碍', '177', 'F19.501', 'ZDZJSZA', '');
INSERT INTO `05diseases` VALUES ('5494', '阿的平中毒致精神障碍', '177', 'F19.502', 'ADPZDZJSZA', '');
INSERT INTO `05diseases` VALUES ('5495', '合霉素中毒致精神障碍', '177', 'F19.503', 'HMSZDZJSZA', '');
INSERT INTO `05diseases` VALUES ('5496', '考的松中毒致精神障碍', '177', 'F19.504', 'KDSZDZJSZA', '');
INSERT INTO `05diseases` VALUES ('5497', '眠尔通中毒致精神障碍', '177', 'F19.505', 'METZDZJSZA', '');
INSERT INTO `05diseases` VALUES ('5498', '药物性幻觉', '433', 'F19.506', 'YWXHJ', '');
INSERT INTO `05diseases` VALUES ('5499', '药物性精神病', '177', 'F19.507', 'YWXJSB', '');
INSERT INTO `05diseases` VALUES ('5500', '药物中毒致精神障碍', '177', 'F19.508', 'YWZDZJSZA', '');
INSERT INTO `05diseases` VALUES ('5501', '妄想型精神分裂症', '177', 'F20.001', 'WXXJSFLZ', '');
INSERT INTO `05diseases` VALUES ('5502', '偏执型精神分裂症', '177', 'F20.051', 'PZXJSFLZ', '');
INSERT INTO `05diseases` VALUES ('5503', '青春型精神分裂症', '177', 'F20.101', 'QCXJSFLZ', '');
INSERT INTO `05diseases` VALUES ('5504', '青春型精神痴呆', '177', 'F20.151', 'QCXJSCD', '');
INSERT INTO `05diseases` VALUES ('5505', '紧张型精神分裂症', '177', 'F20.201', 'JZXJSFLZ', '');
INSERT INTO `05diseases` VALUES ('5506', '紧张症', '278', 'F20.251', 'JZZ', '');
INSERT INTO `05diseases` VALUES ('5507', '精神分裂性倔强症', '177', 'F20.252', 'JSFLXQZ', '');
INSERT INTO `05diseases` VALUES ('5508', '非典型精神分裂症', '177', 'F20.351', 'FDXJSFLZ', '');
INSERT INTO `05diseases` VALUES ('5509', '精神分裂症后抑郁', '177', 'F20.451', 'JSFLZHYY', '');
INSERT INTO `05diseases` VALUES ('5510', '残余型精神分裂症', '177', 'F20.501', 'CYXJSFLZ', '');
INSERT INTO `05diseases` VALUES ('5511', '单纯型精神分裂症', '177', 'F20.601', 'DCXJSFLZ', '');
INSERT INTO `05diseases` VALUES ('5512', '体感异常性精神分裂症', '177', 'F20.851', 'TGYCXJSFLZ', '');
INSERT INTO `05diseases` VALUES ('5513', '精神分裂症', '177', 'F20.901', 'JSFLZ', '');
INSERT INTO `05diseases` VALUES ('5514', '精神分裂症性精神病', '177', 'F20.902', 'JSFLZXJSB', '');
INSERT INTO `05diseases` VALUES ('5515', '潜伏性精神分裂症', '177', 'F21.X01', 'QFXJSFLZ', '');
INSERT INTO `05diseases` VALUES ('5516', '假性神经症型精神分裂症', '313', 'F21.X51', 'JXSJZXJSFLZ', '');
INSERT INTO `05diseases` VALUES ('5517', '边缘状态精神分裂症', '177', 'F21.X52', 'BYZTJSFLZ', '');
INSERT INTO `05diseases` VALUES ('5518', '假性病态人格精神分裂症', '177', 'F21.X53', 'JXBTRGJSFLZ', '');
INSERT INTO `05diseases` VALUES ('5519', '精神分裂症人格障碍', '177', 'F21.X54', 'JSFLZRGZA', '');
INSERT INTO `05diseases` VALUES ('5520', '偏执性精神病', '177', 'F22.001', 'PZXJSB', '');
INSERT INTO `05diseases` VALUES ('5521', '妄想型精神分裂性精神病', '177', 'F22.002', 'WXXJSFLXJSB', '');
INSERT INTO `05diseases` VALUES ('5522', '妄想状态', '278', 'F22.003', 'WXZT', '');
INSERT INTO `05diseases` VALUES ('5523', '妄想狂', '278', 'F22.004', 'WXK', '');
INSERT INTO `05diseases` VALUES ('5524', '更年期妄想狂样状态', '278', 'F22.801', 'GNQWXKYZT', '');
INSERT INTO `05diseases` VALUES ('5525', '持久的妄想性障碍 NOS', '278', 'F22.951', 'CJDWXXZA', '');
INSERT INTO `05diseases` VALUES ('5526', '循环型躁狂抑郁症', '442', 'F23.051', 'XHXZKYYZ', '');
INSERT INTO `05diseases` VALUES ('5527', '急性多形性精神病性障碍伴有精神分裂症症状的', '177', 'F23.151', 'JXDXXJSBXZABYJSFLZZZ', '');
INSERT INTO `05diseases` VALUES ('5528', '急性精神分裂症样精神病性障碍', '177', 'F23.251', 'JXJSFLZYJSBXZA', '');
INSERT INTO `05diseases` VALUES ('5529', '偏执性反应', '278', 'F23.351', 'PZXFY', '');
INSERT INTO `05diseases` VALUES ('5530', '其他急性而短暂的精神病性障碍', '177', 'F23.851', 'QTJXEDZDJSBXZA', '');
INSERT INTO `05diseases` VALUES ('5531', '反应性精神病', '177', 'F23.901', 'FYXJSB', '');
INSERT INTO `05diseases` VALUES ('5532', '反应性精神错乱(病)', '177', 'F23.951', 'FYXJSCLB', '');
INSERT INTO `05diseases` VALUES ('5533', '感应性妄想性障碍', '278', 'F24.X51', 'GYXWXXZA', '');
INSERT INTO `05diseases` VALUES ('5534', '躁狂型分裂情感性障碍', '289', 'F25.051', 'ZKXFLQGXZA', '');
INSERT INTO `05diseases` VALUES ('5535', '抑郁型分裂情感性障碍', '442', 'F25.151', 'YYXFLQGXZA', '');
INSERT INTO `05diseases` VALUES ('5536', '周期性精神病', '177', 'F25.201', 'ZQXJSB', '');
INSERT INTO `05diseases` VALUES ('5537', '分裂－情感性精神病[混合型精神病]', '177', 'F25.251', 'FLQGXJSBHHXJSB', '');
INSERT INTO `05diseases` VALUES ('5538', '混合型躁狂抑郁症', '442', 'F25.252', 'HHXZKYYZ', '');
INSERT INTO `05diseases` VALUES ('5539', '其他分裂情感性障碍', '289', 'F25.851', 'QTFLQGXZA', '');
INSERT INTO `05diseases` VALUES ('5540', '情感分裂症', '278', 'F25.901', 'QGFLZ', '');
INSERT INTO `05diseases` VALUES ('5541', '分裂情感性精神病', '177', 'F25.951', 'FLQGXJSB', '');
INSERT INTO `05diseases` VALUES ('5542', '更年期性精神病', '177', 'F28.X01', 'GNQXJSB', '');
INSERT INTO `05diseases` VALUES ('5543', '慢性幻觉性精神病', '177', 'F28.X51', 'MXHJXJSB', '');
INSERT INTO `05diseases` VALUES ('5544', '精神病', '177', 'F29.X01', 'JSB', '');
INSERT INTO `05diseases` VALUES ('5545', '精神错乱', '177', 'F29.X02', 'JSCL', '');
INSERT INTO `05diseases` VALUES ('5546', '轻躁狂', '278', 'F30.051', 'QZK', '');
INSERT INTO `05diseases` VALUES ('5547', '躁狂不伴有精神病性症状', '177', 'F30.151', 'ZKBBYJSBXZZ', '');
INSERT INTO `05diseases` VALUES ('5548', '躁狂型精神病', '177', 'F30.201', 'ZKXJSB', '');
INSERT INTO `05diseases` VALUES ('5549', '兴奋型精神病', '177', 'F30.801', 'XFXJSB', '');
INSERT INTO `05diseases` VALUES ('5550', '老年性躁狂病', '268', 'F30.901', 'LNXZKB', '');
INSERT INTO `05diseases` VALUES ('5551', '躁狂症 NOS', '278', 'F30.951', 'ZKZ', '');
INSERT INTO `05diseases` VALUES ('5552', '轻躁狂发作双相情感障碍', '289', 'F31.051', 'QZKFZSXQGZA', '');
INSERT INTO `05diseases` VALUES ('5553', '双相情感障碍不伴有精神病性症状的躁狂发作', '177', 'F31.151', 'SXQGZABBYJSBXZZDZKFZ', '');
INSERT INTO `05diseases` VALUES ('5554', '躁狂抑郁性精神病当前为躁狂相', '177', 'F31.201', 'ZKYYXJSBDQWZKX', '');
INSERT INTO `05diseases` VALUES ('5555', '双相情感障碍伴有精神病性症状的躁狂发作', '177', 'F31.251', 'SXQGZABYJSBXZZDZKFZ', '');
INSERT INTO `05diseases` VALUES ('5556', '轻度或中度抑郁发作双相情感障碍', '442', 'F31.351', 'QDHZDYYFZSXQGZA', '');
INSERT INTO `05diseases` VALUES ('5557', '双相情感障碍不伴有精神病性症状的重度抑郁发作', '177', 'F31.451', 'SXQGZABBYJSBXZZDZDYY', '');
INSERT INTO `05diseases` VALUES ('5558', '双相情感障碍伴有精神病性症状的重度抑郁发作', '177', 'F31.551', 'SXQGZABYJSBXZZDZDYYF', '');
INSERT INTO `05diseases` VALUES ('5559', '混合性发作双相情感障碍', '289', 'F31.651', 'HHXFZSXQGZA', '');
INSERT INTO `05diseases` VALUES ('5560', '缓解状态双相情感障碍', '289', 'F31.751', 'HJZTSXQGZA', '');
INSERT INTO `05diseases` VALUES ('5561', '双相障碍Ⅱ型', '289', 'F31.851', 'SXZAEX', '');
INSERT INTO `05diseases` VALUES ('5562', '躁狂抑郁性精神病', '177', 'F31.901', 'ZKYYXJSB', '');
INSERT INTO `05diseases` VALUES ('5563', '轻度抑郁发作', '442', 'F32.051', 'QDYYFZ', '');
INSERT INTO `05diseases` VALUES ('5564', '中度抑郁发作', '442', 'F32.151', 'ZDYYFZ', '');
INSERT INTO `05diseases` VALUES ('5565', '重度抑郁发作不伴有精神病性症状', '177', 'F32.251', 'ZDYYFZBBYJSBXZZ', '');
INSERT INTO `05diseases` VALUES ('5566', '抑郁性精神病', '177', 'F32.301', 'YYXJSB', '');
INSERT INTO `05diseases` VALUES ('5567', '重度抑郁发作伴有精神病性症状', '177', 'F32.351', 'ZDYYFZBYJSBXZZ', '');
INSERT INTO `05diseases` VALUES ('5568', '更年期忧郁症', '278', 'F32.801', 'GNQYYZ', '');
INSERT INTO `05diseases` VALUES ('5569', '精神抑郁症', '177', 'F32.901', 'JSYYZ', '');
INSERT INTO `05diseases` VALUES ('5570', '抑郁症', '442', 'F32.902', 'YYZ', '');
INSERT INTO `05diseases` VALUES ('5571', '抑郁状态', '442', 'F32.903', 'YYZT', '');
INSERT INTO `05diseases` VALUES ('5572', '轻度复发性抑郁障碍', '442', 'F33.051', 'QDFFXYYZA', '');
INSERT INTO `05diseases` VALUES ('5573', '中度复发性抑郁障碍', '442', 'F33.151', 'ZDFFXYYZA', '');
INSERT INTO `05diseases` VALUES ('5574', '躁狂抑郁性精神病当前为抑郁相', '177', 'F33.201', 'ZKYYXJSBDQWYYX', '');
INSERT INTO `05diseases` VALUES ('5575', '复发性抑郁障碍不伴有精神病性症状的重度发作', '177', 'F33.251', 'FFXYYZABBYJSBXZZDZDF', '');
INSERT INTO `05diseases` VALUES ('5576', '复发性抑郁障碍伴有精神病性症状的重度发作', '177', 'F33.351', 'FFXYYZABYJSBXZZDZDFZ', '');
INSERT INTO `05diseases` VALUES ('5577', '缓解状态复发性抑郁障碍', '442', 'F33.451', 'HJZTFFXYYZA', '');
INSERT INTO `05diseases` VALUES ('5578', '其他复发性抑郁障碍', '442', 'F33.851', 'QTFFXYYZA', '');
INSERT INTO `05diseases` VALUES ('5579', '复发性抑郁障碍', '442', 'F33.951', 'FFXYYZA', '');
INSERT INTO `05diseases` VALUES ('5580', '单相抑郁', '442', 'F33.952', 'DXYY', '');
INSERT INTO `05diseases` VALUES ('5581', '情感性人格障碍', '292', 'F34.001', 'QGXRGZA', '');
INSERT INTO `05diseases` VALUES ('5582', '神经官能性抑郁(症)', '313', 'F34.101', 'SJGNXYYZ', '');
INSERT INTO `05diseases` VALUES ('5583', '其他持续性心境障碍', '399', 'F34.851', 'QTCXXXJZA', '');
INSERT INTO `05diseases` VALUES ('5584', '持续性心境障碍 NOS', '399', 'F34.951', 'CXXXJZA', '');
INSERT INTO `05diseases` VALUES ('5585', '混合性情感发作', '278', 'F38.051', 'HHXQGFZ', '');
INSERT INTO `05diseases` VALUES ('5586', '其他复发性心境[情感]障碍', '289', 'F38.151', 'QTFFXXJQGZA', '');
INSERT INTO `05diseases` VALUES ('5587', '复发性短暂抑郁发作', '442', 'F38.152', 'FFXDZYYFZ', '');
INSERT INTO `05diseases` VALUES ('5588', '其他特指的心境[情感]障碍', '289', 'F38.851', 'QTTZDXJQGZA', '');
INSERT INTO `05diseases` VALUES ('5589', '情感性精神病', '177', 'F39.X01', 'QGXJSB', '');
INSERT INTO `05diseases` VALUES ('5590', '广场恐怖', '278', 'F40.051', 'GCKB', '');
INSERT INTO `05diseases` VALUES ('5591', '社交恐怖', '278', 'F40.151', 'SJKB', '');
INSERT INTO `05diseases` VALUES ('5592', '红色恐怖[赫颜恐怖]', '278', 'F40.251', 'HSKBHYKB', '');
INSERT INTO `05diseases` VALUES ('5593', '其他恐怖性焦虑障碍', '165', 'F40.851', 'QTKBXJLZA', '');
INSERT INTO `05diseases` VALUES ('5594', '恐怖症状 NOS', '278', 'F40.901', 'KBZZ', '');
INSERT INTO `05diseases` VALUES ('5595', '惊恐障碍[间歇发作性焦虑]', '278', 'F41.051', 'JKZAJXFZXJL', '');
INSERT INTO `05diseases` VALUES ('5596', '焦虑型神经官能症', '313', 'F41.101', 'JLXSJGNZ', '');
INSERT INTO `05diseases` VALUES ('5597', '焦虑状态', '278', 'F41.102', 'JLZT', '');
INSERT INTO `05diseases` VALUES ('5598', '广泛性焦虑障碍', '165', 'F41.151', 'GFXJLZA', '');
INSERT INTO `05diseases` VALUES ('5599', '焦虑性抑郁症', '442', 'F41.201', 'JLXYYZ', '');
INSERT INTO `05diseases` VALUES ('5600', '混合性焦虑障碍和抑郁障碍', '442', 'F41.251', 'HHXJLZAHYYZA', '');
INSERT INTO `05diseases` VALUES ('5601', '其他混合性焦虑障碍', '165', 'F41.351', 'QTHHXJLZA', '');
INSERT INTO `05diseases` VALUES ('5602', '其他特指的焦虑障碍', '165', 'F41.851', 'QTTZDJLZA', '');
INSERT INTO `05diseases` VALUES ('5603', '焦虑 NOS', '278', 'F41.951', 'JL', '');
INSERT INTO `05diseases` VALUES ('5604', '强迫观念', '278', 'F42.001', 'QPGN', '');
INSERT INTO `05diseases` VALUES ('5605', '强迫性神经症', '313', 'F42.002', 'QPXSJZ', '');
INSERT INTO `05diseases` VALUES ('5606', '以强迫思维为主', '278', 'F42.051', 'YQPSWWZ', '');
INSERT INTO `05diseases` VALUES ('5607', '强迫型行为疾患[强迫仪式]', '278', 'F42.101', 'QPXXWJHQPYS', '');
INSERT INTO `05diseases` VALUES ('5608', '混合性强迫性思维和动作', '278', 'F42.251', 'HHXQPXSWHDZ', '');
INSERT INTO `05diseases` VALUES ('5609', '其他强迫性障碍', '278', 'F42.851', 'QTQPXZA', '');
INSERT INTO `05diseases` VALUES ('5610', '震吓性痴呆[炮弹休克]', '34', 'F43.051', 'ZXXCDPDXK', '');
INSERT INTO `05diseases` VALUES ('5611', '精神源性休克', '177', 'F43.052', 'JSYXXK', '');
INSERT INTO `05diseases` VALUES ('5612', '急性应激反应', '278', 'F43.053', 'JXYJFY', '');
INSERT INTO `05diseases` VALUES ('5613', '急性抑郁性精神压力反应', '177', 'F43.054', 'JXYYXJSYLFY', '');
INSERT INTO `05diseases` VALUES ('5614', '脑外伤神经症性反应', '313', 'F43.151', 'NWSSJZXFY', '');
INSERT INTO `05diseases` VALUES ('5615', '创伤后应激障碍', '44', 'F43.152', 'CSHYJZA', '');
INSERT INTO `05diseases` VALUES ('5616', '创伤性神经症', '313', 'F43.153', 'CSXSJZ', '');
INSERT INTO `05diseases` VALUES ('5617', '适应障碍', '278', 'F43.251', 'SYZA', '');
INSERT INTO `05diseases` VALUES ('5618', '文化休克', '410', 'F43.252', 'WHXK', '');
INSERT INTO `05diseases` VALUES ('5619', '悲哀反应', '278', 'F43.253', 'BAFY', '');
INSERT INTO `05diseases` VALUES ('5620', '儿童住院症', '278', 'F43.254', 'ETZYZ', '');
INSERT INTO `05diseases` VALUES ('5621', '其他严重应激反应', '278', 'F43.851', 'QTYZYJFY', '');
INSERT INTO `05diseases` VALUES ('5622', '严重应激反应 NOS', '278', 'F43.951', 'YZYJFY', '');
INSERT INTO `05diseases` VALUES ('5623', '分离性遗忘', '278', 'F44.051', 'FLXYW', '');
INSERT INTO `05diseases` VALUES ('5624', '分离性神游(症)', '278', 'F44.101', 'FLXSYZ', '');
INSERT INTO `05diseases` VALUES ('5625', '蜡样倔曲(倔强症)', '278', 'F44.251', 'LYQQZ', '');
INSERT INTO `05diseases` VALUES ('5626', '分离性木僵', '278', 'F44.252', 'FLXMJ', '');
INSERT INTO `05diseases` VALUES ('5627', '昼游和附体障碍', '278', 'F44.351', 'ZYHFTZA', '');
INSERT INTO `05diseases` VALUES ('5628', '癔病性截瘫', '444', 'F44.401', 'YBXJT', '');
INSERT INTO `05diseases` VALUES ('5629', '癔病性失音', '444', 'F44.402', 'YBXSY', '');
INSERT INTO `05diseases` VALUES ('5630', '癔病性瘫痪', '345', 'F44.403', 'YBXTH', '');
INSERT INTO `05diseases` VALUES ('5631', '癔病性麻痹', '217', 'F44.404', 'YBXMB', '');
INSERT INTO `05diseases` VALUES ('5632', '癔病痉挛发作', '179', 'F44.405', 'YBJLFZ', '');
INSERT INTO `05diseases` VALUES ('5633', '癔症性缄默症', '278', 'F44.451', 'YZXJMZ', '');
INSERT INTO `05diseases` VALUES ('5634', '癔症性舞蹈病[贝热隆氏病]', '268', 'F44.452', 'YZXWDBBRLSB', '');
INSERT INTO `05diseases` VALUES ('5635', '癔症性肢体麻木', '466', 'F44.453', 'YZXZTMM', '');
INSERT INTO `05diseases` VALUES ('5636', '心因性(转换反应)震颤', '278', 'F44.454', 'XYXZHFYZC', '');
INSERT INTO `05diseases` VALUES ('5637', '癔病性震颤', '444', 'F44.455', 'YBXZC', '');
INSERT INTO `05diseases` VALUES ('5638', '癔病性抽搐', '444', 'F44.501', 'YBXCC', '');
INSERT INTO `05diseases` VALUES ('5639', '分离性抽搐', '278', 'F44.551', 'FLXCC', '');
INSERT INTO `05diseases` VALUES ('5640', '癔病性耳聋', '70', 'F44.601', 'YBXEL', '');
INSERT INTO `05diseases` VALUES ('5641', '癔病性失明', '444', 'F44.602', 'YBXSM', '');
INSERT INTO `05diseases` VALUES ('5642', '癔症性视觉模糊(视疲劳)', '325', 'F44.651', 'YZXSJMHSPL', '');
INSERT INTO `05diseases` VALUES ('5643', '混合性分离性[转换]障碍', '278', 'F44.751', 'HHXFLXZHZA', '');
INSERT INTO `05diseases` VALUES ('5644', '精神错乱(心因性)', '177', 'F44.802', 'JSCLXYX', '');
INSERT INTO `05diseases` VALUES ('5645', '癔病性童样痴呆', '34', 'F44.803', 'YBXTYCD', '');
INSERT INTO `05diseases` VALUES ('5646', '癔症性睡梦状态', '338', 'F44.804', 'YZXSMZT', '');
INSERT INTO `05diseases` VALUES ('5647', '梦呓性精神病', '177', 'F44.851', 'MYXJSB', '');
INSERT INTO `05diseases` VALUES ('5648', '癔病性精神障碍', '177', 'F44.901', 'YBXJSZA', '');
INSERT INTO `05diseases` VALUES ('5649', '癔症 NOS', '278', 'F44.902', 'YZ', '');
INSERT INTO `05diseases` VALUES ('5650', '癔症性精神病', '177', 'F44.903', 'YZXJSB', '');
INSERT INTO `05diseases` VALUES ('5651', '躯体化障碍', '278', 'F45.051', 'QTHZA', '');
INSERT INTO `05diseases` VALUES ('5652', '未分化的躯体化障碍', '278', 'F45.151', 'WFHDQTHZA', '');
INSERT INTO `05diseases` VALUES ('5653', '疑病(症)[臆想症]', '268', 'F45.201', 'YBZYXZ', '');
INSERT INTO `05diseases` VALUES ('5654', '癌病恐怖', '2', 'F45.251', 'ABKB', '');
INSERT INTO `05diseases` VALUES ('5655', '肠神经官能症', '313', 'F45.301', 'CSJGNZ', '');
INSERT INTO `05diseases` VALUES ('5656', '功能性咳嗽', '278', 'F45.302', 'GNXKS', '');
INSERT INTO `05diseases` VALUES ('5657', '换气过度综合征', '278', 'F45.303', 'HQGDZHZ', '');
INSERT INTO `05diseases` VALUES ('5658', '吞气症', '278', 'F45.304', 'TQZ', '');
INSERT INTO `05diseases` VALUES ('5659', '胃肠神经官能症', '313', 'F45.305', 'WCSJGNZ', '');
INSERT INTO `05diseases` VALUES ('5660', '胃神经官能症[精神性胃肠道反应]', '313', 'F45.306', 'WSJGNZJSXWCDFY', '');
INSERT INTO `05diseases` VALUES ('5661', '心血管性神经官能症', '313', 'F45.307', 'XXGXSJGNZ', '');
INSERT INTO `05diseases` VALUES ('5662', '心脏神经官能症', '313', 'F45.308', 'XZSJGNZ', '');
INSERT INTO `05diseases` VALUES ('5663', '精神源性便秘', '177', 'F45.351', 'JSYXBM', '');
INSERT INTO `05diseases` VALUES ('5664', '心因性消化不良', '388', 'F45.352', 'XYXXHBL', '');
INSERT INTO `05diseases` VALUES ('5665', '心因性肠胃胀气', '370', 'F45.353', 'XYXCWZQ', '');
INSERT INTO `05diseases` VALUES ('5666', '心因性尿频', '269', 'F45.354', 'XYXNP', '');
INSERT INTO `05diseases` VALUES ('5667', '心因性尿潴留', '269', 'F45.355', 'XYXNZL', '');
INSERT INTO `05diseases` VALUES ('5668', '精神原性咳嗽', '177', 'F45.356', 'JSYXKS', '');
INSERT INTO `05diseases` VALUES ('5669', '精神原性呵欠', '177', 'F45.357', 'JSYXHQ', '');
INSERT INTO `05diseases` VALUES ('5670', '反刍性神经官能症', '313', 'F45.358', 'FCXSJGNZ', '');
INSERT INTO `05diseases` VALUES ('5671', '喉(感觉)神经官能症', '313', 'F45.359', 'HGJSJGNZ', '');
INSERT INTO `05diseases` VALUES ('5672', '心因性夜尿症', '269', 'F45.360', 'XYXYNZ', '');
INSERT INTO `05diseases` VALUES ('5673', '用力综合征(心因性)', '278', 'F45.361', 'YLZHZXYX', '');
INSERT INTO `05diseases` VALUES ('5674', '心因性幽门痉挛', '179', 'F45.362', 'XYXYMJL', '');
INSERT INTO `05diseases` VALUES ('5675', '咽神经官能症', '313', 'F45.363', 'YSJGNZ', '');
INSERT INTO `05diseases` VALUES ('5676', '通气过度综合征[手足搐搦]', '280', 'F45.364', 'TQGDZHZSZCN', '');
INSERT INTO `05diseases` VALUES ('5677', '精神原性心脏病', '403', 'F45.365', 'JSYXXZB', '');
INSERT INTO `05diseases` VALUES ('5678', '达科斯塔综合征[神经性循环衰弱]', '313', 'F45.366', 'DKSTZHZSJXXHSR', '');
INSERT INTO `05diseases` VALUES ('5679', '精神性疼痛(情绪性头痛)', '177', 'F45.401', 'JSXTTQXXTT', '');
INSERT INTO `05diseases` VALUES ('5680', '功能性肌无力', '145', 'F45.801', 'GNXJWL', '');
INSERT INTO `05diseases` VALUES ('5681', '功能性吞咽困难', '361', 'F45.802', 'GNXTYKN', '');
INSERT INTO `05diseases` VALUES ('5682', '精神性多饮', '177', 'F45.803', 'JSXDY', '');
INSERT INTO `05diseases` VALUES ('5683', '精神原性痛经', '177', 'F45.804', 'JSYXTJ', '');
INSERT INTO `05diseases` VALUES ('5684', '皮肤神经官能症', '313', 'F45.805', 'PFSJGNZ', '');
INSERT INTO `05diseases` VALUES ('5685', '食管神经官能症', '313', 'F45.851', 'SGSJGNZ', '');
INSERT INTO `05diseases` VALUES ('5686', '肌肉骨骼神经官能症', '313', 'F45.852', 'JRGGSJGNZ', '');
INSERT INTO `05diseases` VALUES ('5687', '心因性痛经', '356', 'F45.853', 'XYXTJ', '');
INSERT INTO `05diseases` VALUES ('5688', '心因性斜颈', '278', 'F45.854', 'XYXXG', '');
INSERT INTO `05diseases` VALUES ('5689', '躯体形式障碍 NOS', '278', 'F45.951', 'QTXSZA', '');
INSERT INTO `05diseases` VALUES ('5690', '疲劳综合征', '278', 'F48.001', 'PLZHZ', '');
INSERT INTO `05diseases` VALUES ('5691', '神经衰弱[比尔德氏病]', '313', 'F48.002', 'SJSRBEDSB', '');
INSERT INTO `05diseases` VALUES ('5692', '情感性人格疾患', '292', 'F48.151', 'QGXRGJH', '');
INSERT INTO `05diseases` VALUES ('5693', '精神衰弱', '177', 'F48.801', 'JSSR', '');
INSERT INTO `05diseases` VALUES ('5694', '脑心综合征', '234', 'F48.802', 'NXZHZ', '');
INSERT INTO `05diseases` VALUES ('5695', '书写痉挛症', '179', 'F48.803', 'SXJLZ', '');
INSERT INTO `05diseases` VALUES ('5696', '布里凯障碍', '278', 'F48.851', 'BLKZA', '');
INSERT INTO `05diseases` VALUES ('5697', '处境性神经官能症', '313', 'F48.852', 'CJXSJGNZ', '');
INSERT INTO `05diseases` VALUES ('5698', '代偿性神经官能症', '313', 'F48.853', 'DCXSJGNZ', '');
INSERT INTO `05diseases` VALUES ('5699', '职业性神经官能症', '313', 'F48.854', 'ZYXSJGNZ', '');
INSERT INTO `05diseases` VALUES ('5700', '德哈特综合征', '278', 'F48.855', 'DHTZHZ', '');
INSERT INTO `05diseases` VALUES ('5701', '脑外伤后神经官能症性反应', '313', 'F48.901', 'NWSHSJGNZXFY', '');
INSERT INTO `05diseases` VALUES ('5702', '神经官能症', '313', 'F48.903', 'SJGNZ', '');
INSERT INTO `05diseases` VALUES ('5703', '神经性厌食', '313', 'F50.001', 'SJXYS', '');
INSERT INTO `05diseases` VALUES ('5704', '神经性非典型厌食', '313', 'F50.151', 'SJXFDXYS', '');
INSERT INTO `05diseases` VALUES ('5705', '神经性贪食', '313', 'F50.251', 'SJXS', '');
INSERT INTO `05diseases` VALUES ('5706', '神经性非典型贪食', '313', 'F50.351', 'SJXFDXS', '');
INSERT INTO `05diseases` VALUES ('5707', '精神原性(心因性)暴食', '177', 'F50.401', 'JSYXXYXBS', '');
INSERT INTO `05diseases` VALUES ('5708', '神经性呕吐', '313', 'F50.501', 'SJXOT', '');
INSERT INTO `05diseases` VALUES ('5709', '习惯性呕吐[心因性呕吐]', '278', 'F50.502', 'XGXOTXYXOT', '');
INSERT INTO `05diseases` VALUES ('5710', '胃肠道手术后呕吐', '31', 'F50.551', 'WCDSSHOT', '');
INSERT INTO `05diseases` VALUES ('5711', '成年人异食症', '278', 'F50.851', 'CNRYSZ', '');
INSERT INTO `05diseases` VALUES ('5712', '心因性无食欲', '278', 'F50.852', 'XYXWSY', '');
INSERT INTO `05diseases` VALUES ('5713', '进食障碍 NOS', '278', 'F50.951', 'JSZA', '');
INSERT INTO `05diseases` VALUES ('5714', '心因性失眠', '278', 'F51.051', 'XYXSM', '');
INSERT INTO `05diseases` VALUES ('5715', '非器质性失眠症', '278', 'F51.052', 'FQZXSMZ', '');
INSERT INTO `05diseases` VALUES ('5716', '非器质性嗜睡症', '338', 'F51.151', 'FQZXSSZ', '');
INSERT INTO `05diseases` VALUES ('5717', '非器质性睡眠-觉醒节律障碍', '338', 'F51.251', 'FQZXSMJXJLZA', '');
INSERT INTO `05diseases` VALUES ('5718', '睡眠-觉醒节律心因性倒错', '338', 'F51.252', 'SMJXJLXYXDC', '');
INSERT INTO `05diseases` VALUES ('5719', '女性性唤起障碍', '278', 'F51.253', 'NXXHQZA', '');
INSERT INTO `05diseases` VALUES ('5720', '男性勃起障碍', '230', 'F51.254', 'NXBQZA', '');
INSERT INTO `05diseases` VALUES ('5721', '心因性阳萎', '278', 'F51.255', 'XYXYW', '');
INSERT INTO `05diseases` VALUES ('5722', '梦游[睡行症]', '338', 'F51.301', 'MYSXZ', '');
INSERT INTO `05diseases` VALUES ('5723', '夜惊症[睡惊症]', '338', 'F51.451', 'YJZSJZ', '');
INSERT INTO `05diseases` VALUES ('5724', '其他非器质性睡眠障碍', '338', 'F51.851', 'QTFQZXSMZA', '');
INSERT INTO `05diseases` VALUES ('5725', '情绪性睡眠障碍', '338', 'F51.951', 'QXXSMZA', '');
INSERT INTO `05diseases` VALUES ('5726', '非器质性睡眠障碍 NOS', '338', 'F51.952', 'FQZXSMZA', '');
INSERT INTO `05diseases` VALUES ('5727', '性欲缺失', '278', 'F52.001', 'XYQS', '');
INSERT INTO `05diseases` VALUES ('5728', '性厌恶', '278', 'F52.151', 'XYE', '');
INSERT INTO `05diseases` VALUES ('5729', '阴茎拔起不坚[阳萎(精神原性)]', '177', 'F52.201', 'YJBQBJYWJSYX', '');
INSERT INTO `05diseases` VALUES ('5730', '性高潮功能障碍', '230', 'F52.351', 'XGCGNZA', '');
INSERT INTO `05diseases` VALUES ('5731', '早泄', '278', 'F52.401', 'ZX', '');
INSERT INTO `05diseases` VALUES ('5732', '非器质性阴道痉挛', '86', 'F52.551', 'FQZXYDJL', '');
INSERT INTO `05diseases` VALUES ('5733', '非器质性性交疼痛', '273', 'F52.651', 'FQZXXJTT', '');
INSERT INTO `05diseases` VALUES ('5734', '性欲亢进', '278', 'F52.751', 'XYKJ', '');
INSERT INTO `05diseases` VALUES ('5735', '女性色情狂', '278', 'F52.752', 'NXSQK', '');
INSERT INTO `05diseases` VALUES ('5736', '男性色情狂', '278', 'F52.753', 'NXSQK', '');
INSERT INTO `05diseases` VALUES ('5737', '其他非器质性性功能障碍', '278', 'F52.851', 'QTFQZXXGNZA', '');
INSERT INTO `05diseases` VALUES ('5738', '非器质性性功能障碍 NOS', '278', 'F52.951', 'FQZXXGNZA', '');
INSERT INTO `05diseases` VALUES ('5739', '产褥期抑郁', '26', 'F53.051', 'CRQYY', '');
INSERT INTO `05diseases` VALUES ('5740', '产后精神病', '177', 'F53.151', 'CHJSB', '');
INSERT INTO `05diseases` VALUES ('5741', '其他产褥期精神障碍', '177', 'F53.851', 'QTCRQJSZA', '');
INSERT INTO `05diseases` VALUES ('5742', '产褥期精神障碍 NOS', '177', 'F53.951', 'CRQJSZA', '');
INSERT INTO `05diseases` VALUES ('5743', '皮肤塬着病', '250', 'F54.X01', 'PFYZB', '');
INSERT INTO `05diseases` VALUES ('5744', '神经性胃炎', '313', 'F54.X51', 'SJXWY', '');
INSERT INTO `05diseases` VALUES ('5745', '精神源性十二指肠溃疡', '177', 'F54.X52', 'JSYXSEZCKY', '');
INSERT INTO `05diseases` VALUES ('5746', '维生素滥用', '369', 'F55.X51', 'WSSLY', '');
INSERT INTO `05diseases` VALUES ('5747', '精神原性多饮', '177', 'F59.X01', 'JSYXDY', '');
INSERT INTO `05diseases` VALUES ('5748', '心因性生理功能障碍', '278', 'F59.X51', 'XYXSLGNZA', '');
INSERT INTO `05diseases` VALUES ('5749', '狂信性人格疾患', '292', 'F60.001', 'KXXRGJH', '');
INSERT INTO `05diseases` VALUES ('5750', '偏执型人格障碍', '292', 'F60.051', 'PZXRGZA', '');
INSERT INTO `05diseases` VALUES ('5751', '好诉讼性人格障碍', '292', 'F60.052', 'HSSXRGZA', '');
INSERT INTO `05diseases` VALUES ('5752', '精神分裂样人格', '177', 'F60.101', 'JSFLYRG', '');
INSERT INTO `05diseases` VALUES ('5753', '人格(障碍)精神病态', '177', 'F60.251', 'RGZAJSBT', '');
INSERT INTO `05diseases` VALUES ('5754', '病态人格[社会病态性人格障碍]', '292', 'F60.252', 'BTRGSHBTXRGZA', '');
INSERT INTO `05diseases` VALUES ('5755', '悖备型人格障碍', '292', 'F60.253', 'BBXRGZA', '');
INSERT INTO `05diseases` VALUES ('5756', '情绪不稳型人格障碍', '292', 'F60.351', 'QXBWXRGZA', '');
INSERT INTO `05diseases` VALUES ('5757', '攻击性人格障碍', '292', 'F60.352', 'GJXRGZA', '');
INSERT INTO `05diseases` VALUES ('5758', '表演型人格障碍', '292', 'F60.451', 'BYXRGZA', '');
INSERT INTO `05diseases` VALUES ('5759', '心理幼雅型人格障碍', '292', 'F60.452', 'XLYYXRGZA', '');
INSERT INTO `05diseases` VALUES ('5760', '强迫型人格障碍', '292', 'F60.551', 'QPXRGZA', '');
INSERT INTO `05diseases` VALUES ('5761', '焦虑[回避]型人格障碍', '292', 'F60.651', 'JLHBXRGZA', '');
INSERT INTO `05diseases` VALUES ('5762', '依赖型人格障碍', '292', 'F60.751', 'YLXRGZA', '');
INSERT INTO `05diseases` VALUES ('5763', '被动型人格障碍', '292', 'F60.752', 'BDXRGZA', '');
INSERT INTO `05diseases` VALUES ('5764', '自我挫败型人格障碍', '292', 'F60.753', 'ZWCBXRGZA', '');
INSERT INTO `05diseases` VALUES ('5765', '不当型人格障碍', '292', 'F60.754', 'BDXRGZA', '');
INSERT INTO `05diseases` VALUES ('5766', '衰弱型人格障碍', '292', 'F60.755', 'SRXRGZA', '');
INSERT INTO `05diseases` VALUES ('5767', '妄想狂样人格障碍', '292', 'F60.851', 'WXKYRGZA', '');
INSERT INTO `05diseases` VALUES ('5768', '古怪型人格障碍', '292', 'F60.852', 'GGXRGZA', '');
INSERT INTO `05diseases` VALUES ('5769', '不成熟型人格障碍', '292', 'F60.853', 'BCSXRGZA', '');
INSERT INTO `05diseases` VALUES ('5770', '自恋型人格障碍', '292', 'F60.854', 'ZLXRGZA', '');
INSERT INTO `05diseases` VALUES ('5771', '被动-攻击型人格障碍', '292', 'F60.855', 'BDGJXRGZA', '');
INSERT INTO `05diseases` VALUES ('5772', '精神神经症型人格障碍', '313', 'F60.856', 'JSSJZXRGZA', '');
INSERT INTO `05diseases` VALUES ('5773', '变化异常型人格障碍', '292', 'F60.857', 'BHYCXRGZA', '');
INSERT INTO `05diseases` VALUES ('5774', '人格疾病 NOS', '292', 'F60.901', 'RGJB', '');
INSERT INTO `05diseases` VALUES ('5775', '病理性人格 NOS', '292', 'F60.951', 'BLXRG', '');
INSERT INTO `05diseases` VALUES ('5776', '人格神经症 NOS', '313', 'F60.952', 'RGSJZ', '');
INSERT INTO `05diseases` VALUES ('5777', '混合性人格障碍', '292', 'F61.X51', 'HHXRGZA', '');
INSERT INTO `05diseases` VALUES ('5778', '灾难性经历后的持久性人格改变', '292', 'F62.051', 'ZNXJLHDCJXRGGB', '');
INSERT INTO `05diseases` VALUES ('5779', '精神科疾病后持久性人格改变', '177', 'F62.151', 'JSKJBHCJXRGGB', '');
INSERT INTO `05diseases` VALUES ('5780', '其他持久性人格改变', '292', 'F62.851', 'QTCJXRGGB', '');
INSERT INTO `05diseases` VALUES ('5781', '慢性疼痛性人格综合征', '273', 'F62.852', 'MXTTXRGZHZ', '');
INSERT INTO `05diseases` VALUES ('5782', '持久性人格改变 NOS', '292', 'F62.951', 'CJXRGGB', '');
INSERT INTO `05diseases` VALUES ('5783', '病理性赌博', '268', 'F63.051', 'BLXDB', '');
INSERT INTO `05diseases` VALUES ('5784', '病理性纵火[纵火狂]', '268', 'F63.151', 'BLXZHZHK', '');
INSERT INTO `05diseases` VALUES ('5785', '偷窃狂[病理性偷窃]', '268', 'F63.251', 'TQKBLXTQ', '');
INSERT INTO `05diseases` VALUES ('5786', '拔毛狂', '278', 'F63.351', 'BMK', '');
INSERT INTO `05diseases` VALUES ('5787', '间歇性爆发性障碍', '278', 'F63.851', 'JXXBFXZA', '');
INSERT INTO `05diseases` VALUES ('5788', '习惯和冲突障碍 NOS', '278', 'F63.951', 'XGHCTZA', '');
INSERT INTO `05diseases` VALUES ('5789', '易性症', '278', 'F64.051', 'YXZ', '');
INSERT INTO `05diseases` VALUES ('5790', '双重异装症', '278', 'F64.151', 'SZYZZ', '');
INSERT INTO `05diseases` VALUES ('5791', '童年期性身份障碍', '278', 'F64.251', 'TNQXSFZA', '');
INSERT INTO `05diseases` VALUES ('5792', '其他性身份障碍', '278', 'F64.851', 'QTXSFZA', '');
INSERT INTO `05diseases` VALUES ('5793', '性身份障碍 NOS', '278', 'F64.951', 'XSFZA', '');
INSERT INTO `05diseases` VALUES ('5794', '性角色障碍', '278', 'F64.952', 'XJSZA', '');
INSERT INTO `05diseases` VALUES ('5795', '恋物症', '278', 'F65.051', 'LWZ', '');
INSERT INTO `05diseases` VALUES ('5796', '恋物性异装症', '278', 'F65.151', 'LWXYZZ', '');
INSERT INTO `05diseases` VALUES ('5797', '露阴症', '23', 'F65.251', 'LYZ', '');
INSERT INTO `05diseases` VALUES ('5798', '窥淫症', '278', 'F65.351', 'KYZ', '');
INSERT INTO `05diseases` VALUES ('5799', '恋童症', '278', 'F65.451', 'LTZ', '');
INSERT INTO `05diseases` VALUES ('5800', '施虐受虐症', '278', 'F65.551', 'SNSNZ', '');
INSERT INTO `05diseases` VALUES ('5801', '性偏好多相障碍', '278', 'F65.651', 'XPHDXZA', '');
INSERT INTO `05diseases` VALUES ('5802', '其他性偏听偏信好多相障碍', '278', 'F65.851', 'QTXPTPXHDXZA', '');
INSERT INTO `05diseases` VALUES ('5803', '摩擦症', '278', 'F65.852', 'MCZ', '');
INSERT INTO `05diseases` VALUES ('5804', '恋尸症', '278', 'F65.853', 'LSZ', '');
INSERT INTO `05diseases` VALUES ('5805', '打淫秽电话', '278', 'F65.854', 'DYHDH', '');
INSERT INTO `05diseases` VALUES ('5806', '性偏离', '278', 'F65.951', 'XPL', '');
INSERT INTO `05diseases` VALUES ('5807', '性偏好障碍 NOS', '278', 'F65.952', 'XPHZA', '');
INSERT INTO `05diseases` VALUES ('5808', '性成熟障碍', '278', 'F66.051', 'XCSZA', '');
INSERT INTO `05diseases` VALUES ('5809', '自我不和谐的性障碍', '278', 'F66.151', 'ZWBHXDXZA', '');
INSERT INTO `05diseases` VALUES ('5810', '性关系障碍', '278', 'F66.251', 'XGXZA', '');
INSERT INTO `05diseases` VALUES ('5811', '其他性心理发育障碍', '75', 'F66.851', 'QTXXLFYZA', '');
INSERT INTO `05diseases` VALUES ('5812', '性心理发育障碍 NOS', '75', 'F66.951', 'XXLFYZA', '');
INSERT INTO `05diseases` VALUES ('5813', '赔偿神经症', '313', 'F68.051', 'PCSJZ', '');
INSERT INTO `05diseases` VALUES ('5814', '医院游击者综合征', '278', 'F68.151', 'YYYJZZHZ', '');
INSERT INTO `05diseases` VALUES ('5815', '夸大综合征[明希豪森综合征]', '278', 'F68.152', 'KDZHZMXHSZHZ', '');
INSERT INTO `05diseases` VALUES ('5816', '巡游型病人', '268', 'F68.153', 'XYXBR', '');
INSERT INTO `05diseases` VALUES ('5817', '性格障碍', '278', 'F68.851', 'XGZA', '');
INSERT INTO `05diseases` VALUES ('5818', '关系障碍', '278', 'F68.852', 'GXZA', '');
INSERT INTO `05diseases` VALUES ('5819', '成人人格障碍 NOS', '292', 'F69.X51', 'CRRGZA', '');
INSERT INTO `05diseases` VALUES ('5820', '轻度精神发育迟滞', '177', 'F70.951', 'QDJSFYCZ', '');
INSERT INTO `05diseases` VALUES ('5821', '智力迟钝', '278', 'F70.952', 'ZLCD', '');
INSERT INTO `05diseases` VALUES ('5822', '智力缺欠', '278', 'F70.953', 'ZLQQ', '');
INSERT INTO `05diseases` VALUES ('5823', '轻度低能', '278', 'F70.954', 'QDDN', '');
INSERT INTO `05diseases` VALUES ('5824', '痴愚者(中度精神发育迟缓)', '177', 'F71.851', 'CYZZDJSFYCH', '');
INSERT INTO `05diseases` VALUES ('5825', '智力低下，智商 35-49', '278', 'F71.901', 'ZLDXZS', '');
INSERT INTO `05diseases` VALUES ('5826', '重度精神发育迟滞', '177', 'F72.851', 'ZDJSFYCZ', '');
INSERT INTO `05diseases` VALUES ('5827', '极重度精神发育迟滞', '177', 'F73.851', 'JZDJSFYCZ', '');
INSERT INTO `05diseases` VALUES ('5828', '其他精神发育迟滞', '177', 'F78.851', 'QTJSFYCZ', '');
INSERT INTO `05diseases` VALUES ('5829', '智力(精神)发育迟缓', '177', 'F79.901', 'ZLJSFYCH', '');
INSERT INTO `05diseases` VALUES ('5830', '智力低下', '278', 'F79.902', 'ZLDX', '');
INSERT INTO `05diseases` VALUES ('5831', '精神发育迟滞 NOS', '177', 'F79.951', 'JSFYCZ', '');
INSERT INTO `05diseases` VALUES ('5832', '发育性语音学障碍', '75', 'F80.051', 'FYXYYXZA', '');
INSERT INTO `05diseases` VALUES ('5833', '功能性言语构音障碍', '278', 'F80.052', 'GNXYYGYZA', '');
INSERT INTO `05diseases` VALUES ('5834', '构音困难', '278', 'F80.053', 'GYKN', '');
INSERT INTO `05diseases` VALUES ('5835', '表达性失语[布罗卡失语]', '317', 'F80.151', 'BDXSYBLKSY', '');
INSERT INTO `05diseases` VALUES ('5836', '发育性失语', '317', 'F80.201', 'FYXSY', '');
INSERT INTO `05diseases` VALUES ('5837', '感觉性失语', '317', 'F80.202', 'GJXSY', '');
INSERT INTO `05diseases` VALUES ('5838', '韦尼克发育性失语(感受型)', '317', 'F80.251', 'WNKFYXSYGSX', '');
INSERT INTO `05diseases` VALUES ('5839', '后天性失语伴有癫痫[兰道－克勒失纳综合征]', '57', 'F80.351', 'HTXSYBYDXLDKLSNZHZ', '');
INSERT INTO `05diseases` VALUES ('5840', '齿音发育不清', '75', 'F80.851', 'CYFYBQ', '');
INSERT INTO `05diseases` VALUES ('5841', '语言发育障碍 NOS', '75', 'F80.951', 'YYFYZA', '');
INSERT INTO `05diseases` VALUES ('5842', '发育性诵读困难', '75', 'F81.001', 'FYXSDKN', '');
INSERT INTO `05diseases` VALUES ('5843', '特定的拼写迟滞(不伴有阅读障碍)', '278', 'F81.151', 'TDDPXCZBBYYDZA', '');
INSERT INTO `05diseases` VALUES ('5844', '发育性计算不能', '75', 'F81.251', 'FYXJSBN', '');
INSERT INTO `05diseases` VALUES ('5845', '视像侧反', '325', 'F81.252', 'SXCF', '');
INSERT INTO `05diseases` VALUES ('5846', '发育性格斯特曼综合征', '75', 'F81.253', 'FYXGSTMZHZ', '');
INSERT INTO `05diseases` VALUES ('5847', '混合性学习技能障碍', '278', 'F81.351', 'HHXXXJNZA', '');
INSERT INTO `05diseases` VALUES ('5848', '发育性表达性书写障碍', '75', 'F81.851', 'FYXBDXSXZA', '');
INSERT INTO `05diseases` VALUES ('5849', '知识获得不能', '278', 'F81.951', 'ZSHDBN', '');
INSERT INTO `05diseases` VALUES ('5850', '学习障碍 NOS', '278', 'F81.952', 'XXZA', '');
INSERT INTO `05diseases` VALUES ('5851', '发育性共济障碍', '75', 'F82.X51', 'FYXGJZA', '');
INSERT INTO `05diseases` VALUES ('5852', '发育性运动不良', '75', 'F82.X52', 'FYXYDBL', '');
INSERT INTO `05diseases` VALUES ('5853', '笨拙儿童综合征', '278', 'F82.X53', 'BZETZHZ', '');
INSERT INTO `05diseases` VALUES ('5854', '混合性特定性发育障碍', '75', 'F83.X51', 'HHXTDXFYZA', '');
INSERT INTO `05diseases` VALUES ('5855', '特发于儿童期的精神病', '177', 'F84.001', 'TFYETQDJSB', '');
INSERT INTO `05diseases` VALUES ('5856', '婴儿性孤独癖', '278', 'F84.002', 'YEXGDP', '');
INSERT INTO `05diseases` VALUES ('5857', '童年孤独症', '278', 'F84.051', 'TNGDZ', '');
INSERT INTO `05diseases` VALUES ('5858', '坎纳综合征', '278', 'F84.052', 'KNZHZ', '');
INSERT INTO `05diseases` VALUES ('5859', '不典型孤独症', '278', 'F84.151', 'BDXGDZ', '');
INSERT INTO `05diseases` VALUES ('5860', 'Rett`s综合征 (脑萎缩性高血氨症)', '234', 'F84.201', 'ZHZNWSXGXAZ', '');
INSERT INTO `05diseases` VALUES ('5861', '雷特综合征', '278', 'F84.251', 'LTZHZ', '');
INSERT INTO `05diseases` VALUES ('5862', '赫勒综合征', '278', 'F84.351', 'HLZHZ', '');
INSERT INTO `05diseases` VALUES ('5863', '共生性精神病', '177', 'F84.352', 'GSXJSB', '');
INSERT INTO `05diseases` VALUES ('5864', '瓦解性精神病', '177', 'F84.353', 'WJXJSB', '');
INSERT INTO `05diseases` VALUES ('5865', '婴儿痴呆', '34', 'F84.354', 'YECD', '');
INSERT INTO `05diseases` VALUES ('5866', '与精力发育迟缓和刻板伴动作有关的多动障碍(综合征)', '66', 'F84.451', 'YJLFYCHHKBBDZYGDDDZA', '');
INSERT INTO `05diseases` VALUES ('5867', '儿童性精神分裂症', '177', 'F84.501', 'ETXJSFLZ', '');
INSERT INTO `05diseases` VALUES ('5868', '阿斯珀综合征', '278', 'F84.551', 'ASPZHZ', '');
INSERT INTO `05diseases` VALUES ('5869', '其他发育障碍', '75', 'F84.851', 'QTFYZA', '');
INSERT INTO `05diseases` VALUES ('5870', '弥漫性发育障碍 NOS', '75', 'F84.951', 'MMXFYZA', '');
INSERT INTO `05diseases` VALUES ('5871', '发育性失认症', '75', 'F88.X51', 'FYXSRZ', '');
INSERT INTO `05diseases` VALUES ('5872', '发育障碍', '75', 'F89.X51', 'FYZA', '');
INSERT INTO `05diseases` VALUES ('5873', '活动与注意力障碍伴多动(综合征)', '66', 'F90.051', 'HDYZYLZABDDZHZ', '');
INSERT INTO `05diseases` VALUES ('5874', '注意缺陷综合症伴多动', '66', 'F90.052', 'ZYQXZHZBDD', '');
INSERT INTO `05diseases` VALUES ('5875', '多动品行障碍伴运动过度(综合征)', '66', 'F90.151', 'DDPXZABYDGDZHZ', '');
INSERT INTO `05diseases` VALUES ('5876', '多动特指的临床表现伴运动过度(综合征)', '66', 'F90.851', 'DDTZDLCBXBYDGDZHZ', '');
INSERT INTO `05diseases` VALUES ('5877', '多动症', '66', 'F90.901', 'DDZ', '');
INSERT INTO `05diseases` VALUES ('5878', '多动运动过度(综合征)', '66', 'F90.951', 'DDYDGDZHZ', '');
INSERT INTO `05diseases` VALUES ('5879', '局限于家庭的品行障碍', '256', 'F91.051', 'JXYJTDPXZA', '');
INSERT INTO `05diseases` VALUES ('5880', '未社会化的品行障碍', '256', 'F91.151', 'WSHHDPXZA', '');
INSERT INTO `05diseases` VALUES ('5881', '社会化的品行障碍', '256', 'F91.251', 'SHHDPXZA', '');
INSERT INTO `05diseases` VALUES ('5882', '对立违抗性障碍', '256', 'F91.351', 'DLWKXZA', '');
INSERT INTO `05diseases` VALUES ('5883', '其他品行障碍', '256', 'F91.851', 'QTPXZA', '');
INSERT INTO `05diseases` VALUES ('5884', '童年品行障碍', '256', 'F91.951', 'TNPXZA', '');
INSERT INTO `05diseases` VALUES ('5885', '品行障碍 NOS', '256', 'F91.952', 'PXZA', '');
INSERT INTO `05diseases` VALUES ('5886', '抑郁性品行障碍', '442', 'F92.051', 'YYXPXZA', '');
INSERT INTO `05diseases` VALUES ('5887', '其他品行和情绪混合性障碍', '256', 'F92.851', 'QTPXHQXHHXZA', '');
INSERT INTO `05diseases` VALUES ('5888', '品行和情绪混合性障碍 NOS', '256', 'F92.951', 'PXHQXHHXZA', '');
INSERT INTO `05diseases` VALUES ('5889', '童年离别焦虑障碍', '165', 'F93.051', 'TNLBJLZA', '');
INSERT INTO `05diseases` VALUES ('5890', '童年恐怖性焦虑障碍', '165', 'F93.151', 'TNKBXJLZA', '');
INSERT INTO `05diseases` VALUES ('5891', '童年社交性焦虑障碍', '165', 'F93.251', 'TNSJXJLZA', '');
INSERT INTO `05diseases` VALUES ('5892', '同胞竞争障碍', '278', 'F93.351', 'TBJZZA', '');
INSERT INTO `05diseases` VALUES ('5893', '过度焦虑障碍', '165', 'F93.851', 'GDJLZA', '');
INSERT INTO `05diseases` VALUES ('5894', '身分障碍', '278', 'F93.852', 'SFZA', '');
INSERT INTO `05diseases` VALUES ('5895', '童年情绪障碍 NOS', '278', 'F93.951', 'TNQXZA', '');
INSERT INTO `05diseases` VALUES ('5896', '选择性缄默症[沉默不语]', '278', 'F94.051', 'XZXJMZCMBY', '');
INSERT INTO `05diseases` VALUES ('5897', '童年反应性依恋障碍', '434', 'F94.151', 'TNFYXYLZA', '');
INSERT INTO `05diseases` VALUES ('5898', '童年脱抑制性依恋障碍', '434', 'F94.251', 'TNTYZXYLZA', '');
INSERT INTO `05diseases` VALUES ('5899', '其他童年社会功能障碍', '434', 'F94.851', 'QTTNSHGNZA', '');
INSERT INTO `05diseases` VALUES ('5900', '童年社会功能障碍 NOS', '278', 'F94.951', 'TNSHGNZA', '');
INSERT INTO `05diseases` VALUES ('5901', '一过性(短暂性)抽动障碍', '37', 'F95.051', 'YGXDZXCDZA', '');
INSERT INTO `05diseases` VALUES ('5902', '慢性运动或发声抽动障碍', '37', 'F95.151', 'MXYDHFSCDZA', '');
INSERT INTO `05diseases` VALUES ('5903', '多动秽语综合征', '66', 'F95.201', 'DDHYZHZ', '');
INSERT INTO `05diseases` VALUES ('5904', '吉勒.德拉图雷特综合征[发声和多种运动联合抽动障碍]', '37', 'F95.251', 'JLDLTLTZHZFSHDZYDLHC', '');
INSERT INTO `05diseases` VALUES ('5905', '眨眼症', '430', 'F95.801', 'ZYZ', '');
INSERT INTO `05diseases` VALUES ('5906', '眼睑抽搐', '430', 'F95.851', 'YJCC', '');
INSERT INTO `05diseases` VALUES ('5907', '呼吸抽动障碍', '37', 'F95.852', 'HXCDZA', '');
INSERT INTO `05diseases` VALUES ('5908', '痉挛性抽动障碍', '37', 'F95.853', 'JLXCDZA', '');
INSERT INTO `05diseases` VALUES ('5909', '抽搐', '278', 'F95.901', 'CC', '');
INSERT INTO `05diseases` VALUES ('5910', '面肌抽搐', '267', 'F95.902', 'MJCC', '');
INSERT INTO `05diseases` VALUES ('5911', '心因性遗尿症', '441', 'F98.051', 'XYXYNZ', '');
INSERT INTO `05diseases` VALUES ('5912', '功能性遗尿症', '441', 'F98.052', 'GNXYNZ', '');
INSERT INTO `05diseases` VALUES ('5913', '继发性遗尿症', '441', 'F98.053', 'JFXYNZ', '');
INSERT INTO `05diseases` VALUES ('5914', '非器质性遗粪症', '278', 'F98.151', 'FQZXYFZ', '');
INSERT INTO `05diseases` VALUES ('5915', '婴儿和儿童期喂养障碍', '278', 'F98.251', 'YEHETQWYZA', '');
INSERT INTO `05diseases` VALUES ('5916', '婴幼儿和童年异食癖', '278', 'F98.351', 'YYEHTNYSP', '');
INSERT INTO `05diseases` VALUES ('5917', '刻板性运动障碍', '278', 'F98.451', 'KBXYDZA', '');
INSERT INTO `05diseases` VALUES ('5918', '口吃[结巴]', '191', 'F98.501', 'KCJB', '');
INSERT INTO `05diseases` VALUES ('5919', '言语急促杂乱', '278', 'F98.651', 'YYJCZL', '');
INSERT INTO `05diseases` VALUES ('5920', '手淫', '23', 'F98.801', 'SY', '');
INSERT INTO `05diseases` VALUES ('5921', '注意力缺乏障碍或综合征', '278', 'F98.851', 'ZYLQFZAHZHZ', '');
INSERT INTO `05diseases` VALUES ('5922', '咬指甲', '278', 'F98.852', 'YZJ', '');
INSERT INTO `05diseases` VALUES ('5923', '挖鼻孔', '16', 'F98.853', 'WBK', '');
INSERT INTO `05diseases` VALUES ('5924', '吸吮母指', '278', 'F98.854', 'XSMZ', '');
INSERT INTO `05diseases` VALUES ('5925', '起于童年和青少年期的未特指的行为和情绪障碍', '278', 'F98.951', 'QYTNHQSNQDWTZDXWHQXZ', '');
INSERT INTO `05diseases` VALUES ('5926', '精神障碍 NOS', '177', 'F99.X01', 'JSZA', '');
INSERT INTO `05diseases` VALUES ('5927', '气功致精神障碍', '177', 'F99.X02', 'QGZJSZA', '');
INSERT INTO `05diseases` VALUES ('5928', '精神烦燥综合征', '177', 'F99.X51', 'JSFZZHZ', '');
INSERT INTO `05diseases` VALUES ('5929', '流行性感冒杆菌脑膜炎', '232', 'G00.051', 'LXXGMGJNMY', '');
INSERT INTO `05diseases` VALUES ('5930', '嗜血杆菌性脑膜炎', '232', 'G00.052', 'SXGJXNMY', '');
INSERT INTO `05diseases` VALUES ('5931', '肺炎球菌性脑膜炎', '81', 'G00.151', 'FYQJXNMY', '');
INSERT INTO `05diseases` VALUES ('5932', '链球菌性脑膜炎', '232', 'G00.251', 'LQJXNMY', '');
INSERT INTO `05diseases` VALUES ('5933', '葡萄球菌性脑膜炎', '232', 'G00.351', 'PTQJXNMY', '');
INSERT INTO `05diseases` VALUES ('5934', '变形杆菌性脑膜炎', '232', 'G00.801', 'BXGJXNMY', '');
INSERT INTO `05diseases` VALUES ('5935', '大肠埃希氏杆菌性脑膜炎', '232', 'G00.851', 'DCAXSGJXNMY', '');
INSERT INTO `05diseases` VALUES ('5936', '克雷白杆菌性脑膜炎', '232', 'G00.852', 'KLBGJXNMY', '');
INSERT INTO `05diseases` VALUES ('5937', '弗里德伦德尔(芽胞杆菌)脑膜炎', '232', 'G00.853', 'FLDLDEYBGJNMY', '');
INSERT INTO `05diseases` VALUES ('5938', '化脓性脑膜炎', '232', 'G00.901', 'HNXNMY', '');
INSERT INTO `05diseases` VALUES ('5939', '细菌性脑膜炎', '380', 'G00.902', 'XJXNMY', '');
INSERT INTO `05diseases` VALUES ('5940', '新生儿化脓性脑膜炎', '232', 'G00.903', 'XSEHNXNMY', '');
INSERT INTO `05diseases` VALUES ('5941', '革兰氏阳性球菌性脑膜炎', '232', 'G00.951', 'GLSYXQJXNMY', '');
INSERT INTO `05diseases` VALUES ('5942', '革兰氏阴性球菌性脑膜炎', '232', 'G00.952', 'GLSYXQJXNMY', '');
INSERT INTO `05diseases` VALUES ('5943', '无菌性(急性)脑膜炎', '232', 'G03.001', 'WJXJXNMY', '');
INSERT INTO `05diseases` VALUES ('5944', '非化脓性脑膜炎', '232', 'G03.051', 'FHNXNMY', '');
INSERT INTO `05diseases` VALUES ('5945', '局限性浆液性脑膜炎 NEC', '232', 'G03.052', 'JXXJYXNMY', '');
INSERT INTO `05diseases` VALUES ('5946', '慢性脑膜炎', '232', 'G03.101', 'MXNMY', '');
INSERT INTO `05diseases` VALUES ('5947', '莫拉利特(良性复发性)脑膜炎', '232', 'G03.251', 'MLLTLXFFXNMY', '');
INSERT INTO `05diseases` VALUES ('5948', '癌性脑膜炎', '232', 'G03.801', 'AXNMY', '');
INSERT INTO `05diseases` VALUES ('5949', '其他特指原因引起的脑膜炎', '232', 'G03.851', 'QTTZYYYQDNMY', '');
INSERT INTO `05diseases` VALUES ('5950', '预防性人工免疫或疫苗接种引起的脑膜炎', '228', 'G03.852', 'YFXRGMYHYMJZYQDNMY', '');
INSERT INTO `05diseases` VALUES ('5951', '耳源性脑膜炎', '70', 'G03.901', 'EYXNMY', '');
INSERT INTO `05diseases` VALUES ('5952', '脊髓蛛网膜炎', '476', 'G03.902', 'JSZWMY', '');
INSERT INTO `05diseases` VALUES ('5953', '局限性脑膜炎', '232', 'G03.903', 'JXXNMY', '');
INSERT INTO `05diseases` VALUES ('5954', '颅底蛛网膜炎', '476', 'G03.904', 'LDZWMY', '');
INSERT INTO `05diseases` VALUES ('5955', '脑膜炎', '232', 'G03.905', 'NMY', '');
INSERT INTO `05diseases` VALUES ('5956', '蛛网膜炎', '476', 'G03.906', 'ZWMY', '');
INSERT INTO `05diseases` VALUES ('5957', '非特异性脑(脊)膜炎', '234', 'G03.951', 'FTYXNJMY', '');
INSERT INTO `05diseases` VALUES ('5958', '脑蛛网膜炎[浆液性脑膜炎“假脑瘤”]', '232', 'G03.952', 'NZWMYJYXNMYJNL', '');
INSERT INTO `05diseases` VALUES ('5959', '基底蛛网膜炎', '476', 'G03.953', 'JDZWMY', '');
INSERT INTO `05diseases` VALUES ('5960', '柔脑膜炎(慢性)(出血性)', '232', 'G03.954', 'RNMYMXCXX', '');
INSERT INTO `05diseases` VALUES ('5961', '急性播散性脑脊髓炎', '234', 'G04.001', 'JXBSXNJSY', '');
INSERT INTO `05diseases` VALUES ('5962', '急性播散性脑炎', '234', 'G04.002', 'JXBSXNY', '');
INSERT INTO `05diseases` VALUES ('5963', '疫苗接种后脑炎', '234', 'G04.003', 'YMJZHNY', '');
INSERT INTO `05diseases` VALUES ('5964', '疫苗接种后脑脊髓膜炎[播散性脑脊髓炎]', '234', 'G04.051', 'YMJZHNJSMYBSXNJSY', '');
INSERT INTO `05diseases` VALUES ('5965', '热带痉挛性截瘫', '179', 'G04.151', 'RDJLXJT', '');
INSERT INTO `05diseases` VALUES ('5966', '化脓性脑膜脑炎', '232', 'G04.201', 'HNXNMNY', '');
INSERT INTO `05diseases` VALUES ('5967', '细菌性脑膜脑炎，NEC', '380', 'G04.251', 'XJXNMNY', '');
INSERT INTO `05diseases` VALUES ('5968', '脊髓脊膜炎，NEC', '152', 'G04.252', 'JSJMY', '');
INSERT INTO `05diseases` VALUES ('5969', '变态反应性脑炎', '234', 'G04.801', 'BTFYXNY', '');
INSERT INTO `05diseases` VALUES ('5970', '反应性脑膜炎', '232', 'G04.802', 'FYXNMY', '');
INSERT INTO `05diseases` VALUES ('5971', '感染性脑炎', '95', 'G04.803', 'GRXNY', '');
INSERT INTO `05diseases` VALUES ('5972', '化脓性脊髓炎', '153', 'G04.804', 'HNXJSY', '');
INSERT INTO `05diseases` VALUES ('5973', '化学性脑膜炎', '232', 'G04.805', 'HXXNMY', '');
INSERT INTO `05diseases` VALUES ('5974', '化脓性脑炎', '234', 'G04.851', 'HNXNY', '');
INSERT INTO `05diseases` VALUES ('5976', '非特异性脑炎', '234', 'G04.901', 'FTYXNY', '');
INSERT INTO `05diseases` VALUES ('5977', '化脓性脑室炎', '234', 'G04.902', 'HNXNSY', '');
INSERT INTO `05diseases` VALUES ('5978', '急性脊髓炎', '153', 'G04.903', 'JXJSY', '');
INSERT INTO `05diseases` VALUES ('5979', '急性神经根脊髓炎', '313', 'G04.904', 'JXSJGJSY', '');
INSERT INTO `05diseases` VALUES ('5980', '脊髓神经根病', '313', 'G04.905', 'JSSJGB', '');
INSERT INTO `05diseases` VALUES ('5981', '脊髓神经根炎', '313', 'G04.906', 'JSSJGY', '');
INSERT INTO `05diseases` VALUES ('5982', '脊髓炎', '153', 'G04.907', 'JSY', '');
INSERT INTO `05diseases` VALUES ('5983', '局限性脑炎', '234', 'G04.908', 'JXXNY', '');
INSERT INTO `05diseases` VALUES ('5984', '局灶性脑炎', '234', 'G04.909', 'JZXNY', '');
INSERT INTO `05diseases` VALUES ('5985', '脑干脑炎', '234', 'G04.910', 'NGNY', '');
INSERT INTO `05diseases` VALUES ('5986', '脑脊髓神经根神经炎', '313', 'G04.911', 'NJSSJGSJY', '');
INSERT INTO `05diseases` VALUES ('5987', '脑脊髓炎', '234', 'G04.912', 'NJSY', '');
INSERT INTO `05diseases` VALUES ('5988', '脑膜脑炎', '232', 'G04.913', 'NMNY', '');
INSERT INTO `05diseases` VALUES ('5989', '脑室炎', '234', 'G04.914', 'NSY', '');
INSERT INTO `05diseases` VALUES ('5990', '脑性发热', '234', 'G04.915', 'NXFR', '');
INSERT INTO `05diseases` VALUES ('5991', '脑炎', '234', 'G04.916', 'NY', '');
INSERT INTO `05diseases` VALUES ('5992', '脑炎性假瘤', '234', 'G04.917', 'NYXJL', '');
INSERT INTO `05diseases` VALUES ('5993', '脑炎性肿块', '234', 'G04.918', 'NYXZK', '');
INSERT INTO `05diseases` VALUES ('5994', '散发性脑炎', '234', 'G04.919', 'SFXNY', '');
INSERT INTO `05diseases` VALUES ('5995', '上行性脊髓炎', '153', 'G04.920', 'SXXJSY', '');
INSERT INTO `05diseases` VALUES ('5996', '室管膜炎', '277', 'G04.923', 'SGMY', '');
INSERT INTO `05diseases` VALUES ('5997', '小脑炎', '234', 'G04.924', 'XNY', '');
INSERT INTO `05diseases` VALUES ('5998', '中枢神经系统感染', '313', 'G04.925', 'ZSSJXTGR', '');
INSERT INTO `05diseases` VALUES ('5999', '侧窦周围脓肿', '243', 'G06.001', 'CDZWNZ', '');
INSERT INTO `05diseases` VALUES ('6000', '耳源性脑脓肿', '70', 'G06.002', 'EYXNNZ', '');
INSERT INTO `05diseases` VALUES ('6001', '颅内感染', '95', 'G06.003', 'LNGR', '');
INSERT INTO `05diseases` VALUES ('6002', '颅内脓肿', '243', 'G06.004', 'LNNZ', '');
INSERT INTO `05diseases` VALUES ('6003', '颅内炎性肉芽肿', '295', 'G06.005', 'LNYXRYZ', '');
INSERT INTO `05diseases` VALUES ('6004', '脑脓肿', '243', 'G06.006', 'NNZ', '');
INSERT INTO `05diseases` VALUES ('6005', '脑肉芽肿', '234', 'G06.007', 'NRYZ', '');
INSERT INTO `05diseases` VALUES ('6006', '小脑脓肿', '243', 'G06.008', 'XNNZ', '');
INSERT INTO `05diseases` VALUES ('6007', '细菌性脑脓肿', '380', 'G06.051', 'XJXNNZ', '');
INSERT INTO `05diseases` VALUES ('6008', '硬膜下脑脓肿', '243', 'G06.052', 'YMXNNZ', '');
INSERT INTO `05diseases` VALUES ('6009', '硬脊膜外脓肿', '243', 'G06.101', 'YJMWNZ', '');
INSERT INTO `05diseases` VALUES ('6010', '椎管内脓肿', '243', 'G06.102', 'ZGNNZ', '');
INSERT INTO `05diseases` VALUES ('6011', '脊髓脓肿', '243', 'G06.151', 'JSNZ', '');
INSERT INTO `05diseases` VALUES ('6012', '硬膜外脊髓脓肿', '243', 'G06.152', 'YMWJSNZ', '');
INSERT INTO `05diseases` VALUES ('6013', '硬膜下脊髓脓肿', '243', 'G06.153', 'YMXJSNZ', '');
INSERT INTO `05diseases` VALUES ('6014', '脊髓肉芽肿', '295', 'G06.154', 'JSRYZ', '');
INSERT INTO `05diseases` VALUES ('6015', '硬膜外脓肿', '243', 'G06.201', 'YMWNZ', '');
INSERT INTO `05diseases` VALUES ('6016', '硬膜下脓肿', '243', 'G06.202', 'YMXNZ', '');
INSERT INTO `05diseases` VALUES ('6017', '硬膜下炎性肉芽肿', '295', 'G06.203', 'YMXYXRYZ', '');
INSERT INTO `05diseases` VALUES ('6018', '侧窦栓塞', '278', 'G08.X01', 'CDSS', '');
INSERT INTO `05diseases` VALUES ('6019', '海绵窦血栓形成', '419', 'G08.X02', 'HMDXSXC', '');
INSERT INTO `05diseases` VALUES ('6020', '海绵窦血栓性静脉炎', '185', 'G08.X03', 'HMDXSXJMY', '');
INSERT INTO `05diseases` VALUES ('6021', '海绵窦炎', '277', 'G08.X04', 'HMDY', '');
INSERT INTO `05diseases` VALUES ('6022', '硬脑膜横窦血栓形成', '232', 'G08.X06', 'YNMHDXSXC', '');
INSERT INTO `05diseases` VALUES ('6023', '颅内静脉窦非化脓性血栓形成', '419', 'G08.X07', 'LNJMDFHNXXSXC', '');
INSERT INTO `05diseases` VALUES ('6024', '颅内静脉窦静脉炎', '185', 'G08.X08', 'LNJMDJMY', '');
INSERT INTO `05diseases` VALUES ('6025', '颅内静脉窦血栓形成', '419', 'G08.X09', 'LNJMDXSXC', '');
INSERT INTO `05diseases` VALUES ('6026', '上矢状窦血栓形成', '419', 'G08.X10', 'SSZDXSXC', '');
INSERT INTO `05diseases` VALUES ('6027', '乙状窦栓塞', '278', 'G08.X11', 'YZDSS', '');
INSERT INTO `05diseases` VALUES ('6028', '乙状窦血栓性静脉炎', '185', 'G08.X12', 'YZDXSXJMY', '');
INSERT INTO `05diseases` VALUES ('6029', '海绵窦静脉炎', '185', 'G08.X51', 'HMDJMY', '');
INSERT INTO `05diseases` VALUES ('6030', '横(静脉)窦静脉炎', '185', 'G08.X52', 'HJMDJMY', '');
INSERT INTO `05diseases` VALUES ('6031', '脊柱内静脉窦和静脉的脓毒性静脉炎', '185', 'G08.X53', 'JZNJMDHJMDNDXJMY', '');
INSERT INTO `05diseases` VALUES ('6032', '脊髓炎后遗症', '153', 'G09.X01', 'JSYHYZ', '');
INSERT INTO `05diseases` VALUES ('6033', '脑炎后遗症', '234', 'G09.X02', 'NYHYZ', '');
INSERT INTO `05diseases` VALUES ('6034', '非创伤性脑损伤后遗症 NOS', '234', 'G09.X03', 'FCSXNSSHYZ', '');
INSERT INTO `05diseases` VALUES ('6035', '颅内或脊柱内的脓肿后遗症', '243', 'G09.X51', 'LNHJZNDNZHYZ', '');
INSERT INTO `05diseases` VALUES ('6036', '亨廷顿氏舞蹈病(大舞蹈病)', '268', 'G10.X01', 'HTDSWDBDWDB', '');
INSERT INTO `05diseases` VALUES ('6037', '亨廷顿病性痴呆', '34', 'G10.X51+', 'HTDBXCD', '');
INSERT INTO `05diseases` VALUES ('6038', '先天性非进行性共济失调', '383', 'G11.051', 'XTXFJXXGJSD', '');
INSERT INTO `05diseases` VALUES ('6039', '弗里德赖希氏共济失调', '278', 'G11.101', 'FLDLXSGJSD', '');
INSERT INTO `05diseases` VALUES ('6040', '弗里德赖希脊髓硬变', '152', 'G11.151', 'FLDLXJSYB', '');
INSERT INTO `05diseases` VALUES ('6041', '弗里德赖希小脑硬变', '234', 'G11.152', 'FLDLXXNYB', '');
INSERT INTO `05diseases` VALUES ('6042', '儿童急性小脑共济失调综合征[扎佩氏Zappert`s综合征]', '234', 'G11.153', 'ETJXXNGJSDZHZZPSZHZ', '');
INSERT INTO `05diseases` VALUES ('6043', '弗里德赖希合并全身性病', '268', 'G11.154', 'FLDLXHBQSXB', '');
INSERT INTO `05diseases` VALUES ('6044', '享特共济失调', '278', 'G11.155', 'XTGJSD', '');
INSERT INTO `05diseases` VALUES ('6045', '晚期发病的小脑性共济失调', '234', 'G11.251', 'WQFBDXNXGJSD', '');
INSERT INTO `05diseases` VALUES ('6046', '遗传性(晚期发病)玛丽小脑性共济失调', '234', 'G11.252', 'YCXWQFBMLXNXGJSD', '');
INSERT INTO `05diseases` VALUES ('6047', '共济失调性毛细血管扩张[路易斯-巴尔]', '413', 'G11.301', 'GJSDXMXXGKZLYSBE', '');
INSERT INTO `05diseases` VALUES ('6048', '遗传性痉挛性截瘫', '179', 'G11.401', 'YCXJLXJT', '');
INSERT INTO `05diseases` VALUES ('6049', '其他遗传性共济失调', '439', 'G11.851', 'QTYCXGJSD', '');
INSERT INTO `05diseases` VALUES ('6050', '共济失调综合征', '278', 'G11.901', 'GJSDZHZ', '');
INSERT INTO `05diseases` VALUES ('6051', '马里氏共济失调[遗传性小脑性共济失调]', '234', 'G11.902', 'MLSGJSDYCXXNXGJSD', '');
INSERT INTO `05diseases` VALUES ('6052', '小脑共济失调', '234', 'G11.903', 'XNGJSD', '');
INSERT INTO `05diseases` VALUES ('6053', '遗传性共济失调', '439', 'G11.904', 'YCXGJSD', '');
INSERT INTO `05diseases` VALUES ('6054', '原发性小脑变性', '234', 'G11.905', 'YFXXNBX', '');
INSERT INTO `05diseases` VALUES ('6055', '遗传性小脑综合征', '234', 'G11.951', 'YCXXNZHZ', '');
INSERT INTO `05diseases` VALUES ('6056', '婴儿松软综合征', '278', 'G12.001', 'YESRZHZ', '');
INSERT INTO `05diseases` VALUES ('6057', '婴儿脊髓性肌肉萎缩，Ⅰ型[韦德尼希－霍夫曼]', '144', 'G12.002', 'YEJSXJRWSYXWDNXHFM', '');
INSERT INTO `05diseases` VALUES ('6058', '幼儿型脊髓性肌肉萎缩，Ⅱ型', '144', 'G12.151', 'YEXJSXJRWSEX', '');
INSERT INTO `05diseases` VALUES ('6059', '幼儿型脊髓性肌肉萎缩，Ⅲ型[库格尔贝-韦兰德]', '144', 'G12.152', 'YEXJSXJRWSSXKGEBWLD', '');
INSERT INTO `05diseases` VALUES ('6060', '成年型脊髓性肌肉萎缩', '144', 'G12.153', 'CNXJSXJRWS', '');
INSERT INTO `05diseases` VALUES ('6061', '慢性进行性童年延髓性瘫痪[法齐奥－隆德]', '345', 'G12.154', 'MXJXXTNYSXTHFQALD', '');
INSERT INTO `05diseases` VALUES ('6062', '肌萎缩侧索硬化', '144', 'G12.201', 'JWSCSYH', '');
INSERT INTO `05diseases` VALUES ('6063', '继发性侧索硬化', '278', 'G12.202', 'JFXCSYH', '');
INSERT INTO `05diseases` VALUES ('6064', '假性球麻痹', '217', 'G12.203', 'JXQMB', '');
INSERT INTO `05diseases` VALUES ('6065', '进行性核上性麻痹', '217', 'G12.204', 'JXXHSXMB', '');
INSERT INTO `05diseases` VALUES ('6066', '进行性肌萎缩[克律韦利埃氏病]', '144', 'G12.205', 'JXXJWSKLWLASB', '');
INSERT INTO `05diseases` VALUES ('6067', '进行性脊髓性肌萎缩', '144', 'G12.206', 'JXXJSXJWS', '');
INSERT INTO `05diseases` VALUES ('6068', '球麻痹(进行性)[延髓麻痹]', '217', 'G12.207', 'QMBJXXYSMB', '');
INSERT INTO `05diseases` VALUES ('6069', '原发性侧索硬化', '278', 'G12.208', 'YFXCSYH', '');
INSERT INTO `05diseases` VALUES ('6070', '运动神经元变性病', '313', 'G12.209', 'YDSJYBXB', '');
INSERT INTO `05diseases` VALUES ('6071', '运动神经元病', '313', 'G12.210', 'YDSJYB', '');
INSERT INTO `05diseases` VALUES ('6072', '上运动神经元性延髓麻痹[假性延髓麻痹]', '313', 'G12.251', 'SYDSJYXYSMBJXYSMB', '');
INSERT INTO `05diseases` VALUES ('6073', '下运动神经元性延髓麻痹[真性延髓麻痹]', '313', 'G12.252', 'XYDSJYXYSMBZXYSMB', '');
INSERT INTO `05diseases` VALUES ('6074', '进行性核上性延髓麻痹', '217', 'G12.253', 'JXXHSXYSMB', '');
INSERT INTO `05diseases` VALUES ('6075', '延髓外侧综合征', '278', 'G12.254', 'YSWCZHZ', '');
INSERT INTO `05diseases` VALUES ('6076', '家族性运动神经元病', '313', 'G12.255', 'JZXYDSJYB', '');
INSERT INTO `05diseases` VALUES ('6077', '脊髓性进行性肌肉萎缩', '144', 'G12.256', 'JSXJXXJRWS', '');
INSERT INTO `05diseases` VALUES ('6078', '进行性脊髓麻痹', '217', 'G12.257', 'JXXJSMB', '');
INSERT INTO `05diseases` VALUES ('6079', '迪谢纳－阿朗萎缩[脊髓性肌萎缩]', '144', 'G12.258', 'DXNALWSJSXJWS', '');
INSERT INTO `05diseases` VALUES ('6080', '脊髓性肌萎缩 NOS', '144', 'G12.901', 'JSXJWS', '');
INSERT INTO `05diseases` VALUES ('6081', '帕金森叠加综合征', '245', 'G20.X01', 'PJSDJZHZ', '');
INSERT INTO `05diseases` VALUES ('6082', '帕金森氏病', '245', 'G20.X02', 'PJSSB', '');
INSERT INTO `05diseases` VALUES ('6083', '原发性帕金森氏综合征[震颤麻痹]', '245', 'G20.X03', 'YFXPJSSZHZZCMB', '');
INSERT INTO `05diseases` VALUES ('6084', '帕金森病性(帕金森综合征)痴呆', '34', 'G20.X51+', 'PJSBXPJSZHZCD', '');
INSERT INTO `05diseases` VALUES ('6085', '震颤麻痹痴呆', '34', 'G20.X52', 'ZCMBCD', '');
INSERT INTO `05diseases` VALUES ('6086', '恶性抗精神病药综合征', '177', 'G21.051', 'EXKJSBYZHZ', '');
INSERT INTO `05diseases` VALUES ('6087', '其他药物性继发性帕金森氏综合征', '245', 'G21.151', 'QTYWXJFXPJSSZHZ', '');
INSERT INTO `05diseases` VALUES ('6088', '其他外部因素引起的帕金森氏综合征', '245', 'G21.251', 'QTWBYSYQDPJSSZHZ', '');
INSERT INTO `05diseases` VALUES ('6089', '脑炎后帕金森综合征', '234', 'G21.351', 'NYHPJSZHZ', '');
INSERT INTO `05diseases` VALUES ('6090', '其他帕金森氏综合征', '245', 'G21.851', 'QTPJSSZHZ', '');
INSERT INTO `05diseases` VALUES ('6091', '继发性帕金森氏综合征 NOS', '245', 'G21.901', 'JFXPJSSZHZ', '');
INSERT INTO `05diseases` VALUES ('6092', '哈勒沃登－施帕茨病', '268', 'G23.051', 'HLWDSPCB', '');
INSERT INTO `05diseases` VALUES ('6093', '苍白球色毒变性', '278', 'G23.052', 'CBQSDBX', '');
INSERT INTO `05diseases` VALUES ('6094', '进行性核上性眼肌麻痹[斯蒂尔－里查森－奥尔谢夫斯基]', '430', 'G23.151', 'JXXHSXYJMBSDELCSAEXF', '');
INSERT INTO `05diseases` VALUES ('6095', '纹状体黑质变性', '278', 'G23.251', 'WZTHZBX', '');
INSERT INTO `05diseases` VALUES ('6096', '橄榄体桥脑小脑萎缩[德热里纳－托马斯]', '234', 'G23.801', 'GLTQNXNWSDRLNTMS', '');
INSERT INTO `05diseases` VALUES ('6097', '橄榄体桥脑小脑变性', '234', 'G23.802', 'GLTQNXNBX', '');
INSERT INTO `05diseases` VALUES ('6098', '基底节钙化', '278', 'G23.851', 'JDJGH', '');
INSERT INTO `05diseases` VALUES ('6099', '特指的基底核(节)变性 NEC', '278', 'G23.852', 'TZDJDHJBX', '');
INSERT INTO `05diseases` VALUES ('6100', '基底核(节)变性(病变)', '268', 'G23.951', 'JDHJBXBB', '');
INSERT INTO `05diseases` VALUES ('6101', '药物性肌张力障碍', '147', 'G24.051', 'YWXJZLZA', '');
INSERT INTO `05diseases` VALUES ('6102', '扭转痉挛', '179', 'G24.101', 'NZJL', '');
INSERT INTO `05diseases` VALUES ('6103', '特发性肌张力异常', '267', 'G24.151', 'TFXJZLYC', '');
INSERT INTO `05diseases` VALUES ('6104', '家族性特发性肌张力障碍', '147', 'G24.152', 'JZXTFXJZLZA', '');
INSERT INTO `05diseases` VALUES ('6105', '进行性扭转痉挛', '179', 'G24.153', 'JXXNZJL', '');
INSERT INTO `05diseases` VALUES ('6106', '齐思－奥本海姆病[变形性肌张力障碍]', '147', 'G24.154', 'QSABHMBBXXJZLZA', '');
INSERT INTO `05diseases` VALUES ('6107', '特发性非家族性肌张力障碍', '147', 'G24.251', 'TFXFJZXJZLZA', '');
INSERT INTO `05diseases` VALUES ('6108', '痉挛性斜颈', '179', 'G24.301', 'JLXXG', '');
INSERT INTO `05diseases` VALUES ('6109', '口面运动障碍', '191', 'G24.401', 'KMYDZA', '');
INSERT INTO `05diseases` VALUES ('6110', '眼睑痉挛', '430', 'G24.501', 'YJJL', '');
INSERT INTO `05diseases` VALUES ('6111', '其他肌张力障碍', '147', 'G24.851', 'QTJZLZA', '');
INSERT INTO `05diseases` VALUES ('6112', '肌紧张异常', '267', 'G24.901', 'JJZYC', '');
INSERT INTO `05diseases` VALUES ('6113', '运动障碍 NOS', '278', 'G24.902', 'YDZA', '');
INSERT INTO `05diseases` VALUES ('6114', '不明原因零星性扭转性肌张力障碍', '147', 'G24.951', 'BMYYLXXNZXJZLZA', '');
INSERT INTO `05diseases` VALUES ('6115', '良性特发性震颤', '278', 'G25.001', 'LXTFXZC', '');
INSERT INTO `05diseases` VALUES ('6116', '特发性震颤', '278', 'G25.051', 'TFXZC', '');
INSERT INTO `05diseases` VALUES ('6117', '药物性震颤', '433', 'G25.151', 'YWXZC', '');
INSERT INTO `05diseases` VALUES ('6118', '意向性震颤', '278', 'G25.251', 'YXXZC', '');
INSERT INTO `05diseases` VALUES ('6119', '肌阵挛', '267', 'G25.301', 'JZL', '');
INSERT INTO `05diseases` VALUES ('6120', '药物性肌阵挛', '267', 'G25.351', 'YWXJZL', '');
INSERT INTO `05diseases` VALUES ('6121', '家族性特发性肌阵挛', '267', 'G25.352', 'JZXTFXJZL', '');
INSERT INTO `05diseases` VALUES ('6122', '药物性舞蹈病', '268', 'G25.451', 'YWXWDB', '');
INSERT INTO `05diseases` VALUES ('6123', '偏身舞蹈病', '268', 'G25.501', 'PSWDB', '');
INSERT INTO `05diseases` VALUES ('6124', '舞蹈病', '268', 'G25.502', 'WDB', '');
INSERT INTO `05diseases` VALUES ('6125', '舞蹈样手足搐动症', '41', 'G25.503', 'WDYSZCDZ', '');
INSERT INTO `05diseases` VALUES ('6126', '小舞蹈病', '268', 'G25.504', 'XWDB', '');
INSERT INTO `05diseases` VALUES ('6127', '慢性进行性舞蹈病', '268', 'G25.551', 'MXJXXWDB', '');
INSERT INTO `05diseases` VALUES ('6128', '老年性舞蹈病', '268', 'G25.552', 'LNXWDB', '');
INSERT INTO `05diseases` VALUES ('6129', '偏瘫后舞蹈病', '268', 'G25.553', 'PTHWDB', '');
INSERT INTO `05diseases` VALUES ('6130', '变性性面肌抽搐', '267', 'G25.651', 'BXXMJCC', '');
INSERT INTO `05diseases` VALUES ('6131', '变性性(全身性)(局部性)抽搐', '278', 'G25.652', 'BXXQSXJBXCC', '');
INSERT INTO `05diseases` VALUES ('6132', '舞蹈病后抽搐', '268', 'G25.653', 'WDBHCC', '');
INSERT INTO `05diseases` VALUES ('6133', '药物性抽搐', '433', 'G25.654', 'YWXCC', '');
INSERT INTO `05diseases` VALUES ('6134', '不安腿综合征', '360', 'G25.801', 'BATZHZ', '');
INSERT INTO `05diseases` VALUES ('6135', '进行性苍白球萎缩', '278', 'G25.802', 'JXXCBQWS', '');
INSERT INTO `05diseases` VALUES ('6136', '纹状体综合征', '278', 'G25.803', 'WZTZHZ', '');
INSERT INTO `05diseases` VALUES ('6137', '僵人综合征', '278', 'G25.851', 'JRZHZ', '');
INSERT INTO `05diseases` VALUES ('6138', '多动(不安)腿综合征[埃克博姆氏综合征]', '66', 'G25.852', 'DDBATZHZAKBMSZHZ', '');
INSERT INTO `05diseases` VALUES ('6139', '其他特指的运动(神经系统)障碍', '313', 'G25.853', 'QTTZDYDSJXTZA', '');
INSERT INTO `05diseases` VALUES ('6140', '特指类型锥体外束综合征', '278', 'G25.854', 'TZLXZTWSZHZ', '');
INSERT INTO `05diseases` VALUES ('6141', '基底节病变', '268', 'G25.901', 'JDJBB', '');
INSERT INTO `05diseases` VALUES ('6142', '神经节(基底神经节，脑)综合征', '313', 'G25.902', 'SJJJDSJJNZHZ', '');
INSERT INTO `05diseases` VALUES ('6143', '锥体外系疾病', '268', 'G25.903', 'ZTWXJB', '');
INSERT INTO `05diseases` VALUES ('6144', '锥体外束综合征 NOS', '278', 'G25.951', 'ZTWSZHZ', '');
INSERT INTO `05diseases` VALUES ('6145', '运动(神经系统)治疗诱发障碍', '313', 'G25.952', 'YDSJXTZLYFZA', '');
INSERT INTO `05diseases` VALUES ('6146', '阿尔茨海默病(早老性))', '268', 'G30.051', 'AECHMBZLX', '');
INSERT INTO `05diseases` VALUES ('6147', '早期发病(早老性)阿尔茨海默氏病引起的痴呆', '34', 'G30.052+', 'ZQFBZLXAECHMSBYQDCD', '');
INSERT INTO `05diseases` VALUES ('6148', '阿尔茨海默病，伴有晚期发病(老年性)', '268', 'G30.151', 'AECHMBBYWQFBLNX', '');
INSERT INTO `05diseases` VALUES ('6149', '晚期发病(老年性)阿尔茨海默氏病引起的痴呆', '34', 'G30.152+', 'WQFBLNXAECHMSBYQDCD', '');
INSERT INTO `05diseases` VALUES ('6150', '非典型型或混合型阿尔茨海默氏病', '268', 'G30.851+', 'FDXXHHHXAECHMSB', '');
INSERT INTO `05diseases` VALUES ('6151', '阿耳茨海默氏病(早老性痴呆)', '70', 'G30.904', 'AECHMSBZLXCD', '');
INSERT INTO `05diseases` VALUES ('6152', '阿尔茨海默氏病引起的痴呆', '34', 'G30.951+', 'AECHMSBYQDCD', '');
INSERT INTO `05diseases` VALUES ('6153', '阿尔茨海默硬化 NOS', '278', 'G30.952', 'AECHMYH', '');
INSERT INTO `05diseases` VALUES ('6154', '脑叶硬化萎缩[皮克氏病]', '234', 'G31.001', 'NYYHWSPKSB', '');
INSERT INTO `05diseases` VALUES ('6155', '脑叶硬化萎缩[皮克氏病]引起的痴呆', '234', 'G31.051+', 'NYYHWSPKSBYQDCD', '');
INSERT INTO `05diseases` VALUES ('6156', '老年性脑变性', '234', 'G31.101', 'LNXNBX', '');
INSERT INTO `05diseases` VALUES ('6157', '老年性脑萎缩', '234', 'G31.102', 'LNXNWS', '');
INSERT INTO `05diseases` VALUES ('6158', '慢性酒精中毒性神经系统损害', '313', 'G31.201', 'MXJJZDXSJXTSH', '');
INSERT INTO `05diseases` VALUES ('6159', '酒精中毒性脑病', '234', 'G31.202', 'JJZDXNB', '');
INSERT INTO `05diseases` VALUES ('6160', '酒精性小脑变性', '234', 'G31.251', 'JJXXNBX', '');
INSERT INTO `05diseases` VALUES ('6161', '酒精性小脑共济失调', '234', 'G31.252', 'JJXXNGJSD', '');
INSERT INTO `05diseases` VALUES ('6162', '脊髓变性', '152', 'G31.801', 'JSBX', '');
INSERT INTO `05diseases` VALUES ('6163', '亚速尔病(Azorean Disease)', '268', 'G31.802', 'YSEB', '');
INSERT INTO `05diseases` VALUES ('6164', '婴儿进行性脑灰质营养不良综合征[奥尔泊氏综合症]', '234', 'G31.851', 'YEJXXNHZYYBLZHZAEBSZ', '');
INSERT INTO `05diseases` VALUES ('6165', '脂肪性脊髓(索)变性', '152', 'G31.852', 'ZFXJSSBX', '');
INSERT INTO `05diseases` VALUES ('6166', '亚急性坏死性脑脊髓病[利氏病或综合症]', '234', 'G31.853', 'YJXHSXNJSBLSBHZHZ', '');
INSERT INTO `05diseases` VALUES ('6167', '脊髓小脑变性', '234', 'G31.854', 'JSXNBX', '');
INSERT INTO `05diseases` VALUES ('6168', '灰质变性[阿尔珀斯]', '278', 'G31.855', 'HZBXAEPS', '');
INSERT INTO `05diseases` VALUES ('6169', '大脑变性', '234', 'G31.901', 'DNBX', '');
INSERT INTO `05diseases` VALUES ('6170', '多神经系统变性', '313', 'G31.902', 'DSJXTBX', '');
INSERT INTO `05diseases` VALUES ('6171', '儿童期脑萎缩', '234', 'G31.903', 'ETQNWS', '');
INSERT INTO `05diseases` VALUES ('6172', '末稍神经退行性改变', '313', 'G31.905', 'MSSJTXXGB', '');
INSERT INTO `05diseases` VALUES ('6173', '脑萎缩', '234', 'G31.906', 'NWS', '');
INSERT INTO `05diseases` VALUES ('6174', '皮质延髓小脑萎缩', '234', 'G31.907', 'PZYSXNWS', '');
INSERT INTO `05diseases` VALUES ('6175', '神经系统变性病', '313', 'G31.908', 'SJXTBXB', '');
INSERT INTO `05diseases` VALUES ('6176', '小脑变性', '234', 'G31.909', 'XNBX', '');
INSERT INTO `05diseases` VALUES ('6177', '小脑萎缩', '234', 'G31.910', 'XNWS', '');
INSERT INTO `05diseases` VALUES ('6178', '婴儿进行性大脑变性', '234', 'G31.911', 'YEJXXDNBX', '');
INSERT INTO `05diseases` VALUES ('6179', '中枢神经系统变性', '313', 'G31.912', 'ZSSJXTBX', '');
INSERT INTO `05diseases` VALUES ('6180', '脑病内脏脂肪变性综合征', '234', 'G31.951', 'NBNZZFBXZHZ', '');
INSERT INTO `05diseases` VALUES ('6181', '慢性皮质下脑病[慢性进行皮质下脑炎]', '234', 'G31.952', 'MXPZXNBMXJXPZXNY', '');
INSERT INTO `05diseases` VALUES ('6182', '多发性硬化', '278', 'G35.X01', 'DFXYH', '');
INSERT INTO `05diseases` VALUES ('6183', '多发性硬化性痴呆', '34', 'G35.X02+', 'DFXYHXCD', '');
INSERT INTO `05diseases` VALUES ('6184', '脑干多发性硬化', '234', 'G35.X52', 'NGDFXYH', '');
INSERT INTO `05diseases` VALUES ('6185', '脊髓多发性硬化', '152', 'G35.X53', 'JSDFXYH', '');
INSERT INTO `05diseases` VALUES ('6186', '全身性多发性硬化', '278', 'G35.X54', 'QSXDFXYH', '');
INSERT INTO `05diseases` VALUES ('6187', '视神经脊髓炎[德维克氏病]', '313', 'G36.001', 'SSJJSYDWKSB', '');
INSERT INTO `05diseases` VALUES ('6188', '视神经炎的脱髓鞘', '313', 'G36.051', 'SSJYDTSQ', '');
INSERT INTO `05diseases` VALUES ('6189', '急性和亚急性出血性脑白质炎[赫斯特病]', '234', 'G36.151', 'JXHYJXCXXNBZYHSTB', '');
INSERT INTO `05diseases` VALUES ('6190', '其他特指的急性播散性脱髓鞘', '364', 'G36.851', 'QTTZDJXBSXTSQ', '');
INSERT INTO `05diseases` VALUES ('6191', '神经脊髓炎', '313', 'G36.951', 'SJJSY', '');
INSERT INTO `05diseases` VALUES ('6192', '急性播散性脱髓鞘 NOS', '364', 'G36.952', 'JXBSXTSQ', '');
INSERT INTO `05diseases` VALUES ('6193', '弥漫性硬化', '278', 'G37.001', 'MMXYH', '');
INSERT INTO `05diseases` VALUES ('6194', '谢德尔氏病(弥漫性轴周性脑病)', '234', 'G37.002', 'XDESBMMXZZXNB', '');
INSERT INTO `05diseases` VALUES ('6195', '进行性皮质性脑病[弗拉托－希尔德病]', '234', 'G37.051', 'JXXPZXNBFLTXEDB', '');
INSERT INTO `05diseases` VALUES ('6196', '弥漫性轴周性脑炎', '234', 'G37.052', 'MMXZZXNY', '');
INSERT INTO `05diseases` VALUES ('6197', '弥漫性(脑)(脊髓)硬化', '234', 'G37.053', 'MMXNJSYH', '');
INSERT INTO `05diseases` VALUES ('6198', '胼胝体中枢性脱髓鞘', '364', 'G37.151', 'PZTZSXTSQ', '');
INSERT INTO `05diseases` VALUES ('6199', '胼胝体中枢性脱髓鞘性脑病', '234', 'G37.152', 'PZTZSXTSQXNB', '');
INSERT INTO `05diseases` VALUES ('6200', '中枢性脑桥髓鞘破坏', '234', 'G37.251', 'ZSXNQSQPH', '');
INSERT INTO `05diseases` VALUES ('6201', '急性横贯性脊髓炎', '153', 'G37.301', 'JXHGXJSY', '');
INSERT INTO `05diseases` VALUES ('6202', '脊髓横贯性损害', '152', 'G37.302', 'JSHGXSH', '');
INSERT INTO `05diseases` VALUES ('6203', '亚急性坏死性脊髓炎', '153', 'G37.451', 'YJXHSXJSY', '');
INSERT INTO `05diseases` VALUES ('6204', '同心性硬化[鲍洛]', '278', 'G37.551', 'TXXYHBL', '');
INSERT INTO `05diseases` VALUES ('6205', '脱髓鞘性白质脑病', '234', 'G37.801', 'TSQXBZNB', '');
INSERT INTO `05diseases` VALUES ('6206', '脱髓鞘性脑病', '234', 'G37.802', 'TSQXNB', '');
INSERT INTO `05diseases` VALUES ('6207', '其他特指的中枢神经系统脱髓鞘病', '313', 'G37.851', 'QTTZDZSSJXTTSQB', '');
INSERT INTO `05diseases` VALUES ('6208', '脱髓鞘病 NOS', '364', 'G37.901', 'TSQB', '');
INSERT INTO `05diseases` VALUES ('6209', '癫痫综合征伴有局限性发作', '57', 'G40.051', 'DXZHZBYJXXFZ', '');
INSERT INTO `05diseases` VALUES ('6210', '儿童期良性癫痫伴在中颞部尖波的脑电图', '234', 'G40.052', 'ETQLXDXBZZNBJBDNDT', '');
INSERT INTO `05diseases` VALUES ('6211', '强直性阵挛性癫痫持续状态', '57', 'G40.053', 'QZXZLXDXCXZT', '');
INSERT INTO `05diseases` VALUES ('6212', '部分性癫痫', '57', 'G40.101', 'BFXDX', '');
INSERT INTO `05diseases` VALUES ('6213', '杰克逊氏癫痫(头痛型)', '57', 'G40.103', 'JKXSDXTTX', '');
INSERT INTO `05diseases` VALUES ('6214', '局灶性癫痫', '57', 'G40.104', 'JZXDX', '');
INSERT INTO `05diseases` VALUES ('6215', '旋转性癫', '278', 'G40.105', 'XZXD', '');
INSERT INTO `05diseases` VALUES ('6216', '部分运动性癫痫', '57', 'G40.151', 'BFYDXDX', '');
INSERT INTO `05diseases` VALUES ('6217', '布拉韦-杰克逊(癫痫)', '57', 'G40.152', 'BLWJKXDX', '');
INSERT INTO `05diseases` VALUES ('6218', '躯体运动性癫痫', '57', 'G40.153', 'QTYDXDX', '');
INSERT INTO `05diseases` VALUES ('6219', '躯体感觉性癫痫', '57', 'G40.154', 'QTGJXDX', '');
INSERT INTO `05diseases` VALUES ('6220', '精神运动性癫痫', '177', 'G40.201', 'JSYDXDX', '');
INSERT INTO `05diseases` VALUES ('6221', '颞叶性癫痫', '57', 'G40.202', 'NYXDX', '');
INSERT INTO `05diseases` VALUES ('6222', '自动性癫痫', '57', 'G40.251', 'ZDXDX', '');
INSERT INTO `05diseases` VALUES ('6223', '前奔性癫痫', '57', 'G40.252', 'QBXDX', '');
INSERT INTO `05diseases` VALUES ('6224', '边缘系统癫痫', '57', 'G40.253', 'BYXTDX', '');
INSERT INTO `05diseases` VALUES ('6225', '发作性肌阵挛', '267', 'G40.301', 'FZXJZL', '');
INSERT INTO `05diseases` VALUES ('6226', '混合型癫痫', '57', 'G40.302', 'HHXDX', '');
INSERT INTO `05diseases` VALUES ('6227', '肌阵挛性癫痫[翁韦里希特-伦德伯格氏病]', '57', 'G40.303', 'JZLXDXWWLXTLDBGSB', '');
INSERT INTO `05diseases` VALUES ('6228', '进行性肌阵挛性癫痫', '57', 'G40.305', 'JXXJZLXDX', '');
INSERT INTO `05diseases` VALUES ('6229', '强直性癫痫', '57', 'G40.306', 'QZXDX', '');
INSERT INTO `05diseases` VALUES ('6230', '强直-阵挛性癫痫', '57', 'G40.307', 'QZZLXDX', '');
INSERT INTO `05diseases` VALUES ('6231', '全身性非惊厥性癫痫', '57', 'G40.308', 'QSXFJJXDX', '');
INSERT INTO `05diseases` VALUES ('6232', '全身惊厥性疾病', '268', 'G40.309', 'QSJJXJB', '');
INSERT INTO `05diseases` VALUES ('6233', '阵挛性癫痫', '57', 'G40.310', 'ZLXDX', '');
INSERT INTO `05diseases` VALUES ('6234', '婴儿痉挛性癫痫', '57', 'G40.351', 'YEJLXDX', '');
INSERT INTO `05diseases` VALUES ('6235', '面肌阵挛抽搐[面肌阵挛半侧颜面挛]', '267', 'G40.352', 'MJZLCCMJZLBCYML', '');
INSERT INTO `05diseases` VALUES ('6236', '婴儿性痉挛', '179', 'G40.401', 'YEXJL', '');
INSERT INTO `05diseases` VALUES ('6237', '伦诺克斯－加斯托综合征', '278', 'G40.451', 'LNKSJSTZHZ', '');
INSERT INTO `05diseases` VALUES ('6238', '韦斯特综合征', '278', 'G40.452', 'WSTZHZ', '');
INSERT INTO `05diseases` VALUES ('6239', '继发性癫痫', '57', 'G40.501', 'JFXDX', '');
INSERT INTO `05diseases` VALUES ('6240', '部分性癫痫连续状态', '57', 'G40.551', 'BFXDXLXZT', '');
INSERT INTO `05diseases` VALUES ('6241', '科热夫尼科夫', '271', 'G40.552', 'KRFNKF', '');
INSERT INTO `05diseases` VALUES ('6242', '酒精性癫痫发作', '57', 'G40.553', 'JJXDXFZ', '');
INSERT INTO `05diseases` VALUES ('6243', '药物性癫痫发作', '57', 'G40.554', 'YWXDXFZ', '');
INSERT INTO `05diseases` VALUES ('6244', '癫痫大发作 NOS', '57', 'G40.651', 'DXDFZ', '');
INSERT INTO `05diseases` VALUES ('6245', '癫痫小发作 NOS', '57', 'G40.751', 'DXXFZ', '');
INSERT INTO `05diseases` VALUES ('6246', '反射性癫痫', '57', 'G40.801', 'FSXDX', '');
INSERT INTO `05diseases` VALUES ('6247', '腹型癫痫[穆尔氏综合征]', '57', 'G40.802', 'FXDXMESZHZ', '');
INSERT INTO `05diseases` VALUES ('6248', '内脏性癫痫', '57', 'G40.803', 'NZXDX', '');
INSERT INTO `05diseases` VALUES ('6249', '症状性癫痫', '57', 'G40.804', 'ZZXDX', '');
INSERT INTO `05diseases` VALUES ('6250', '植物神经性癫痫', '313', 'G40.805', 'ZWSJXDX', '');
INSERT INTO `05diseases` VALUES ('6251', '视觉性癫痫', '57', 'G40.851', 'SJXDX', '');
INSERT INTO `05diseases` VALUES ('6252', '老年性癫痫', '57', 'G40.852', 'LNXDX', '');
INSERT INTO `05diseases` VALUES ('6253', '更年期癫痫', '57', 'G40.853', 'GNQDX', '');
INSERT INTO `05diseases` VALUES ('6254', '周围性癫痫', '57', 'G40.854', 'ZWXDX', '');
INSERT INTO `05diseases` VALUES ('6255', '昏迷性癫痫', '57', 'G40.855', 'HMXDX', '');
INSERT INTO `05diseases` VALUES ('6256', '癫痫', '57', 'G40.901', 'DX', '');
INSERT INTO `05diseases` VALUES ('6257', '间脑性癫痫', '234', 'G40.902', 'JNXDX', '');
INSERT INTO `05diseases` VALUES ('6258', '癫痫的惊厥', '57', 'G40.951', 'DXDJJ', '');
INSERT INTO `05diseases` VALUES ('6259', '癫痫性痴呆', '34', 'G40.952+', 'DXXCD', '');
INSERT INTO `05diseases` VALUES ('6260', '癫痫大发作状态', '57', 'G41.001', 'DXDFZZT', '');
INSERT INTO `05diseases` VALUES ('6261', '癫痫失神状态', '57', 'G41.101', 'DXSSZT', '');
INSERT INTO `05diseases` VALUES ('6262', '癫痫小发作状态', '57', 'G41.102', 'DXXFZZT', '');
INSERT INTO `05diseases` VALUES ('6263', '癫痫连续状态 NOS', '57', 'G41.901', 'DXLXZT', '');
INSERT INTO `05diseases` VALUES ('6264', '普通型偏头痛', '358', 'G43.001', 'PTXPTT', '');
INSERT INTO `05diseases` VALUES ('6265', '典型偏头痛', '358', 'G43.151', 'DXPTT', '');
INSERT INTO `05diseases` VALUES ('6266', '基底动脉型偏头痛', '260', 'G43.152', 'JDDMXPTT', '');
INSERT INTO `05diseases` VALUES ('6267', '偏头痛状态', '358', 'G43.251', 'PTTZT', '');
INSERT INTO `05diseases` VALUES ('6268', '复合性偏头痛', '358', 'G43.351', 'FHXPTT', '');
INSERT INTO `05diseases` VALUES ('6269', '血管性偏头痛', '358', 'G43.801', 'XGXPTT', '');
INSERT INTO `05diseases` VALUES ('6270', '眼肌瘫痪型偏头痛', '430', 'G43.802', 'YJTHXPTT', '');
INSERT INTO `05diseases` VALUES ('6271', '视网膜性偏头痛', '358', 'G43.851', 'SWMXPTT', '');
INSERT INTO `05diseases` VALUES ('6272', '偏头痛', '358', 'G43.901', 'PTT', '');
INSERT INTO `05diseases` VALUES ('6273', '睫部神经痛(鼻睫神经痛)', '313', 'G44.051', 'JBSJTBJSJT', '');
INSERT INTO `05diseases` VALUES ('6274', '丛集性头痛', '358', 'G44.052', 'CJXTT', '');
INSERT INTO `05diseases` VALUES ('6275', '组织胺性头痛', '358', 'G44.053', 'ZZAXTT', '');
INSERT INTO `05diseases` VALUES ('6276', '霍顿头痛或霍顿神经痛[偏头神经痛]', '313', 'G44.054', 'HDTTHHDSJTPTSJT', '');
INSERT INTO `05diseases` VALUES ('6277', '神经性头痛', '313', 'G44.101', 'SJXTT', '');
INSERT INTO `05diseases` VALUES ('6278', '血管神经性头痛', '313', 'G44.102', 'XGSJXTT', '');
INSERT INTO `05diseases` VALUES ('6279', '血管性头痛', '358', 'G44.103', 'XGXTT', '');
INSERT INTO `05diseases` VALUES ('6280', '紧张性头痛', '358', 'G44.201', 'JZXTT', '');
INSERT INTO `05diseases` VALUES ('6281', '慢性紧张性头痛', '358', 'G44.251', 'MXJZXTT', '');
INSERT INTO `05diseases` VALUES ('6282', '发作性紧张性头痛', '358', 'G44.252', 'FZXJZXTT', '');
INSERT INTO `05diseases` VALUES ('6283', '慢性创伤后头痛', '44', 'G44.351', 'MXCSHTT', '');
INSERT INTO `05diseases` VALUES ('6284', '药物性头痛', '358', 'G44.451', 'YWXTT', '');
INSERT INTO `05diseases` VALUES ('6285', '颅内低压综合征[位置性头痛]', '358', 'G44.851', 'LNDYZHZWZXTT', '');
INSERT INTO `05diseases` VALUES ('6286', '变应性头痛', '358', 'G44.852', 'BYXTT', '');
INSERT INTO `05diseases` VALUES ('6287', '椎基底动脉供血不足', '59', 'G45.001', 'ZJDDMGXBZ', '');
INSERT INTO `05diseases` VALUES ('6288', '基底动脉综合症', '260', 'G45.051', 'JDDMZHZ', '');
INSERT INTO `05diseases` VALUES ('6289', '颈内动脉供血不足', '59', 'G45.101', 'GNDMGXBZ', '');
INSERT INTO `05diseases` VALUES ('6290', '颈内动脉缺血', '260', 'G45.102', 'GNDMQX', '');
INSERT INTO `05diseases` VALUES ('6291', '颈动脉综合征(大脑半球的)', '234', 'G45.151', 'GDMZHZDNBQD', '');
INSERT INTO `05diseases` VALUES ('6292', '多发性和双侧入脑前动脉综合征', '234', 'G45.251', 'DFXHSCRNQDMZHZ', '');
INSERT INTO `05diseases` VALUES ('6293', '阵发性黑蒙', '278', 'G45.351', 'ZFXHM', '');
INSERT INTO `05diseases` VALUES ('6294', '短暂性全面遗忘', '278', 'G45.451', 'DZXQMYW', '');
INSERT INTO `05diseases` VALUES ('6295', '锁骨下盗血综合征', '344', 'G45.801', 'SGXDXZHZ', '');
INSERT INTO `05diseases` VALUES ('6296', '无名动脉盗血综合征', '260', 'G45.802', 'WMDMDXZHZ', '');
INSERT INTO `05diseases` VALUES ('6297', '脑血管供血不足伴短暂性局灶性神经症状', '313', 'G45.851', 'NXGGXBZBDZXJZXSJZZ', '');
INSERT INTO `05diseases` VALUES ('6298', '锁骨下动脉分流综合征', '260', 'G45.852', 'SGXDMFLZHZ', '');
INSERT INTO `05diseases` VALUES ('6299', '短暂性脑缺血[阿尔瓦雷斯氏综合征TIA]', '234', 'G45.901', 'DZXNQXAEWLSSZHZ', '');
INSERT INTO `05diseases` VALUES ('6300', '脑动脉痉挛', '234', 'G45.902', 'NDMJL', '');
INSERT INTO `05diseases` VALUES ('6301', '短暂性大脑缺血', '234', 'G45.951', 'DZXDNQX', '');
INSERT INTO `05diseases` VALUES ('6302', '失眠', '278', 'G47.001', 'SM', '');
INSERT INTO `05diseases` VALUES ('6303', '嗜眠症', '278', 'G47.151', 'SMZ', '');
INSERT INTO `05diseases` VALUES ('6304', '延迟睡眠阶段综合征', '338', 'G47.251', 'YCSMJDZHZ', '');
INSERT INTO `05diseases` VALUES ('6305', '睡眠-觉醒节律障碍', '338', 'G47.252', 'SMJXJLZA', '');
INSERT INTO `05diseases` VALUES ('6306', '睡眠呼吸暂停综合征', '338', 'G47.301', 'SMHXZTZHZ', '');
INSERT INTO `05diseases` VALUES ('6307', '中枢性睡眠呼吸暂停', '338', 'G47.351', 'ZSXSMHXZT', '');
INSERT INTO `05diseases` VALUES ('6308', '梗阻性睡眠呼吸暂停', '338', 'G47.352', 'GZXSMHXZT', '');
INSERT INTO `05diseases` VALUES ('6309', '猝倒(症)', '278', 'G47.401', 'CDZ', '');
INSERT INTO `05diseases` VALUES ('6310', '发作性睡眠', '338', 'G47.402', 'FZXSM', '');
INSERT INTO `05diseases` VALUES ('6311', '克莱内－莱文综合征', '278', 'G47.851', 'KLNLWZHZ', '');
INSERT INTO `05diseases` VALUES ('6312', '睡眠障碍 NOS', '338', 'G47.901', 'SMZA', '');
INSERT INTO `05diseases` VALUES ('6313', '睡眠节律逆转', '338', 'G47.951', 'SMJLNZ', '');
INSERT INTO `05diseases` VALUES ('6314', '眶上神经痛', '313', 'G50.001', 'KSSJT', '');
INSERT INTO `05diseases` VALUES ('6315', '三叉神经痛', '313', 'G50.002', 'SCSJT', '');
INSERT INTO `05diseases` VALUES ('6316', '筛前神经痛', '313', 'G50.003', 'SQSJT', '');
INSERT INTO `05diseases` VALUES ('6317', '阵发性面痛综合征', '273', 'G50.051', 'ZFXMTZHZ', '');
INSERT INTO `05diseases` VALUES ('6318', '非典型性面部痛', '273', 'G50.151', 'FDXXMBT', '');
INSERT INTO `05diseases` VALUES ('6319', '三叉神经麻痹', '313', 'G50.801', 'SCSJMB', '');
INSERT INTO `05diseases` VALUES ('6320', '三叉神经炎[福瑟吉尔神经痛]', '313', 'G50.802', 'SCSJYFSJESJT', '');
INSERT INTO `05diseases` VALUES ('6321', '味觉性出汗综合征', '278', 'G50.803', 'WJXCHZHZ', '');
INSERT INTO `05diseases` VALUES ('6322', '耳颞神经综合征[弗赖综合征]', '313', 'G50.851', 'ENSJZHZFLZHZ', '');
INSERT INTO `05diseases` VALUES ('6323', '眼鼻区综合征[鼻定区神经综合征]', '313', 'G50.852', 'YBQZHZBDQSJZHZ', '');
INSERT INTO `05diseases` VALUES ('6324', '三叉神经疾患 NOS', '313', 'G50.901', 'SCSJJH', '');
INSERT INTO `05diseases` VALUES ('6325', '面神经麻痹[贝尔氏麻痹；面神经炎]', '313', 'G51.002', 'MSJMBBESMBMSJY', '');
INSERT INTO `05diseases` VALUES ('6326', '眼轮匝肌麻痹', '430', 'G51.003', 'YLZJMB', '');
INSERT INTO `05diseases` VALUES ('6327', '膝状神经节炎', '313', 'G51.101', 'XZSJJY', '');
INSERT INTO `05diseases` VALUES ('6328', '梅尔克松－罗森塔尔综合征', '278', 'G51.251', 'MEKSLSTEZHZ', '');
INSERT INTO `05diseases` VALUES ('6329', '面肌痉挛', '179', 'G51.301', 'MJJL', '');
INSERT INTO `05diseases` VALUES ('6330', '面肌纤维抽搐', '267', 'G51.451', 'MJXWCC', '');
INSERT INTO `05diseases` VALUES ('6331', '面肌萎缩[颜面萎缩症]', '144', 'G51.801', 'MJWSYMWSZ', '');
INSERT INTO `05diseases` VALUES ('6332', '面神经炎', '313', 'G51.802', 'MSJY', '');
INSERT INTO `05diseases` VALUES ('6333', '龙贝格半侧颜面萎缩[单侧面神经萎缩]', '313', 'G51.851', 'LBGBCYMWSDCMSJWS', '');
INSERT INTO `05diseases` VALUES ('6334', '面神经功能障碍 NOS', '313', 'G51.901', 'MSJGNZA', '');
INSERT INTO `05diseases` VALUES ('6335', '嗅神经疾患(第一神经)', '313', 'G52.001', 'XSJJHDYSJ', '');
INSERT INTO `05diseases` VALUES ('6336', '舌咽神经疾患(第九神经)', '313', 'G52.101', 'SYSJJHDJSJ', '');
INSERT INTO `05diseases` VALUES ('6337', '舌咽神经痛', '313', 'G52.102', 'SYSJT', '');
INSERT INTO `05diseases` VALUES ('6338', '喉返神经麻痹', '313', 'G52.201', 'HFSJMB', '');
INSERT INTO `05diseases` VALUES ('6339', '喉返神经炎', '313', 'G52.202', 'HFSJY', '');
INSERT INTO `05diseases` VALUES ('6340', '迷走神经疾患[第十神经、肺胃神经]', '313', 'G52.203', 'MZSJJHDSSJFWSJ', '');
INSERT INTO `05diseases` VALUES ('6341', '迷走神经亢进', '313', 'G52.204', 'MZSJKJ', '');
INSERT INTO `05diseases` VALUES ('6342', '迷走神经过敏', '313', 'G52.251', 'MZSJGM', '');
INSERT INTO `05diseases` VALUES ('6343', '舌下神经疾患(第十二神经)', '313', 'G52.301', 'SXSJJHDSESJ', '');
INSERT INTO `05diseases` VALUES ('6344', '舌下神经麻痹', '313', 'G52.302', 'SXSJMB', '');
INSERT INTO `05diseases` VALUES ('6345', '杰克逊综合征[迷走副舌下神经麻痹综合征]', '313', 'G52.351', 'JKXZHZMZFSXSJMBZHZ', '');
INSERT INTO `05diseases` VALUES ('6346', '多发性颅神经麻痹', '313', 'G52.701', 'DFXLSJMB', '');
INSERT INTO `05diseases` VALUES ('6347', '多发性颅神经损害', '313', 'G52.702', 'DFXLSJSH', '');
INSERT INTO `05diseases` VALUES ('6348', '多发性颅神经炎', '313', 'G52.703', 'DFXLSJY', '');
INSERT INTO `05diseases` VALUES ('6349', '颈静脉孔综合征', '181', 'G52.704', 'GJMKZHZ', '');
INSERT INTO `05diseases` VALUES ('6350', '维拉雷氏综合征', '278', 'G52.705', 'WLLSZHZ', '');
INSERT INTO `05diseases` VALUES ('6351', '迷走舌下神经综合征', '313', 'G52.751', 'MZSXSJZHZ', '');
INSERT INTO `05diseases` VALUES ('6352', '副神经疾患', '313', 'G52.801', 'FSJJH', '');
INSERT INTO `05diseases` VALUES ('6353', '斜方肌麻痹', '217', 'G52.802', 'XFJMB', '');
INSERT INTO `05diseases` VALUES ('6354', '其他特指的颅神经疾患', '313', 'G52.851', 'QTTZDLSJJH', '');
INSERT INTO `05diseases` VALUES ('6355', '颅神经麻痹', '313', 'G52.901', 'LSJMB', '');
INSERT INTO `05diseases` VALUES ('6356', '颅神经炎', '313', 'G52.902', 'LSJY', '');
INSERT INTO `05diseases` VALUES ('6357', '颅神经痛', '313', 'G52.951', 'LSJT', '');
INSERT INTO `05diseases` VALUES ('6358', '臂丛神经损害', '313', 'G54.001', 'BCSJSH', '');
INSERT INTO `05diseases` VALUES ('6359', '臂神经麻痹', '313', 'G54.002', 'BSJMB', '');
INSERT INTO `05diseases` VALUES ('6360', '胸廓出口综合征', '191', 'G54.003', 'XKCKZHZ', '');
INSERT INTO `05diseases` VALUES ('6361', '纳夫济格氏综合征[斜角肌综合征]', '267', 'G54.051', 'NFJGSZHZXJJZHZ', '');
INSERT INTO `05diseases` VALUES ('6362', '肋锁骨综合征', '344', 'G54.052', 'LSGZHZ', '');
INSERT INTO `05diseases` VALUES ('6363', '臂丛神经炎[臂丛神经痛臂丛神经病]', '313', 'G54.053', 'BCSJYBCSJTBCSJB', '');
INSERT INTO `05diseases` VALUES ('6364', '外展过度综合征(或肠小肌)', '259', 'G54.054', 'WZGDZHZHCXJ', '');
INSERT INTO `05diseases` VALUES ('6365', '腰骶丛损害', '278', 'G54.151', 'YDCSH', '');
INSERT INTO `05diseases` VALUES ('6366', '腰丛神经病', '313', 'G54.152', 'YCSJB', '');
INSERT INTO `05diseases` VALUES ('6367', '颈神经根损害', '313', 'G54.201', 'GSJGSH', '');
INSERT INTO `05diseases` VALUES ('6368', '神经根型颈椎病', '313', 'G54.251', 'SJGXGZB', '');
INSERT INTO `05diseases` VALUES ('6369', '胸神经根疾患，NEC', '313', 'G54.351', 'XSJGJH', '');
INSERT INTO `05diseases` VALUES ('6370', '腰骶神经根疾患，NEC', '313', 'G54.401', 'YDSJGJH', '');
INSERT INTO `05diseases` VALUES ('6371', '神经痛性肌萎缩', '313', 'G54.501', 'SJTXJWS', '');
INSERT INTO `05diseases` VALUES ('6372', '帕森内奇－奥尔德雷－特纳综合征', '278', 'G54.551', 'PSNQAEDLTNZHZ', '');
INSERT INTO `05diseases` VALUES ('6373', '肩胛带神经炎', '313', 'G54.552', 'JJDSJY', '');
INSERT INTO `05diseases` VALUES ('6374', '幻肢综合征伴有疼痛', '273', 'G54.651', 'HZZHZBYTT', '');
INSERT INTO `05diseases` VALUES ('6375', '幻肢综合征', '466', 'G54.751', 'HZZHZ', '');
INSERT INTO `05diseases` VALUES ('6376', '其他特指的神经根和神经丛疾患', '313', 'G54.851', 'QTTZDSJGHSJCJH', '');
INSERT INTO `05diseases` VALUES ('6377', '神经根和神经丛疾患 NOS', '313', 'G54.951', 'SJGHSJCJH', '');
INSERT INTO `05diseases` VALUES ('6378', '腕管综合征(正中神经腕管压迫症)', '313', 'G56.001', 'WGZHZZZSJWGYPZ', '');
INSERT INTO `05diseases` VALUES ('6379', '正中神经损害', '313', 'G56.101', 'ZZSJSH', '');
INSERT INTO `05diseases` VALUES ('6380', '迟发性尺神经炎', '313', 'G56.201', 'CFXCSJY', '');
INSERT INTO `05diseases` VALUES ('6381', '尺神经麻痹', '313', 'G56.202', 'CSJMB', '');
INSERT INTO `05diseases` VALUES ('6382', '尺神经损害', '313', 'G56.203', 'CSJSH', '');
INSERT INTO `05diseases` VALUES ('6383', '尺神经炎', '313', 'G56.204', 'CSJY', '');
INSERT INTO `05diseases` VALUES ('6384', '肘管综合征', '278', 'G56.205', 'ZGZHZ', '');
INSERT INTO `05diseases` VALUES ('6385', '迟发性尺神经麻痹', '313', 'G56.251', 'CFXCSJMB', '');
INSERT INTO `05diseases` VALUES ('6386', '桡神经损害', '313', 'G56.301', 'RSJSH', '');
INSERT INTO `05diseases` VALUES ('6387', '灼性神经痛', '313', 'G56.401', 'ZXSJT', '');
INSERT INTO `05diseases` VALUES ('6388', '上肢指间神经瘤', '313', 'G56.851', 'SZZJSJL', '');
INSERT INTO `05diseases` VALUES ('6389', '上肢单神经病 NOS', '313', 'G56.951', 'SZDSJB', '');
INSERT INTO `05diseases` VALUES ('6390', '梨状肌综合征', '267', 'G57.001', 'LZJZHZ', '');
INSERT INTO `05diseases` VALUES ('6391', '坐骨神经损害', '313', 'G57.002', 'ZGSJSH', '');
INSERT INTO `05diseases` VALUES ('6392', '坐骨神经粘连', '313', 'G57.003', 'ZGSJNL', '');
INSERT INTO `05diseases` VALUES ('6393', '股外侧皮神经综合征', '313', 'G57.101', 'GWCPSJZHZ', '');
INSERT INTO `05diseases` VALUES ('6394', '伯恩哈特(-罗特)病[感觉异常性股痛症]', '273', 'G57.151', 'BEHTLTBGJYCXGTZ', '');
INSERT INTO `05diseases` VALUES ('6395', '股神经麻痹', '313', 'G57.201', 'GSJMB', '');
INSERT INTO `05diseases` VALUES ('6396', '股神经损害', '313', 'G57.251', 'GSJSH', '');
INSERT INTO `05diseases` VALUES ('6397', '球麻痹', '217', 'G57.252', 'QMB', '');
INSERT INTO `05diseases` VALUES ('6398', '进行性球麻痹', '217', 'G57.253', 'JXXQMB', '');
INSERT INTO `05diseases` VALUES ('6399', '腓深神经麻痹', '313', 'G57.301', 'FSSJMB', '');
INSERT INTO `05diseases` VALUES ('6400', '腓神经麻痹', '313', 'G57.302', 'FSJMB', '');
INSERT INTO `05diseases` VALUES ('6401', '腓总神经损害', '313', 'G57.303', 'FZSJSH', '');
INSERT INTO `05diseases` VALUES ('6402', '腓侧神经损害', '313', 'G57.351', 'FCSJSH', '');
INSERT INTO `05diseases` VALUES ('6403', '腘内侧神经损害', '313', 'G57.451', 'NKAYZ', '');
INSERT INTO `05diseases` VALUES ('6404', '胫后神经嵌压综合征', '313', 'G57.501', 'JHSJQYZHZ', '');
INSERT INTO `05diseases` VALUES ('6405', '跗骨小管综合征', '265', 'G57.551', 'FGXGZHZ', '');
INSERT INTO `05diseases` VALUES ('6406', '跖趾神经炎', '313', 'G57.601', 'ZZSJY', '');
INSERT INTO `05diseases` VALUES ('6407', '足底神经损害', '313', 'G57.651', 'ZDSJSH', '');
INSERT INTO `05diseases` VALUES ('6408', '莫顿跖骨痛', '273', 'G57.652', 'MDZGT', '');
INSERT INTO `05diseases` VALUES ('6409', '趾间神经瘤', '313', 'G57.851', 'ZJSJL', '');
INSERT INTO `05diseases` VALUES ('6410', '跖骨间神经瘤', '313', 'G57.852', 'ZGJSJL', '');
INSERT INTO `05diseases` VALUES ('6411', '下肢单神经病 NOS', '313', 'G57.951', 'XZDSJB', '');
INSERT INTO `05diseases` VALUES ('6412', '肋间神经痛', '313', 'G58.001', 'LJSJT', '');
INSERT INTO `05diseases` VALUES ('6413', '多发性单神经炎', '313', 'G58.751', 'DFXDSJY', '');
INSERT INTO `05diseases` VALUES ('6414', '膈神经麻痹', '313', 'G58.801', 'GSJMB', '');
INSERT INTO `05diseases` VALUES ('6415', '枕大神经痛', '313', 'G58.802', 'ZDSJT', '');
INSERT INTO `05diseases` VALUES ('6416', '枕大神经炎', '313', 'G58.803', 'ZDSJY', '');
INSERT INTO `05diseases` VALUES ('6417', '枕神经痛', '313', 'G58.804', 'ZSJT', '');
INSERT INTO `05diseases` VALUES ('6418', '单神经炎', '313', 'G58.901', 'DSJY', '');
INSERT INTO `05diseases` VALUES ('6419', '神经功能障碍', '313', 'G58.902', 'SJGNZA', '');
INSERT INTO `05diseases` VALUES ('6420', '神经麻痹', '313', 'G58.903', 'SJMB', '');
INSERT INTO `05diseases` VALUES ('6421', '神经痛 NOS', '313', 'G58.951', 'SJT', '');
INSERT INTO `05diseases` VALUES ('6422', '腓骨肌萎缩', '78', 'G60.001', 'FGJWS', '');
INSERT INTO `05diseases` VALUES ('6423', '夏科-马丽-图斯氏病[进行性神经性肌萎缩]', '313', 'G60.002', 'XKMLTSSBJXXSJXJWS', '');
INSERT INTO `05diseases` VALUES ('6424', '德热里纳－索塔斯神经炎', '313', 'G60.051', 'DRLNSTSSJY', '');
INSERT INTO `05diseases` VALUES ('6425', '鲁西－莱维综合[遗传性运动失调性起立困难]', '439', 'G60.052', 'LXLWZHYCXYDSDXQLKN', '');
INSERT INTO `05diseases` VALUES ('6426', '雷夫叙姆病或综合征', '268', 'G60.151', 'LFXMBHZHZ', '');
INSERT INTO `05diseases` VALUES ('6427', '遗传性共济失调性多发性神经炎', '313', 'G60.152', 'YCXGJSDXDFXSJY', '');
INSERT INTO `05diseases` VALUES ('6428', '遗传性共济失调性神经病', '313', 'G60.251', 'YCXGJSDXSJB', '');
INSERT INTO `05diseases` VALUES ('6429', '特发性进行性神经病', '313', 'G60.351', 'TFXJXXSJB', '');
INSERT INTO `05diseases` VALUES ('6430', '感觉性多神经病', '313', 'G60.801', 'GJXDSJB', '');
INSERT INTO `05diseases` VALUES ('6431', '里吉综合征', '278', 'G60.802', 'LJZHZ', '');
INSERT INTO `05diseases` VALUES ('6432', '色素沉着,水肿,多发性神经病综合征', '313', 'G60.803', 'SSCZSZDFXSJBZHZ', '');
INSERT INTO `05diseases` VALUES ('6433', '遗传性感觉性神经病', '313', 'G60.804', 'YCXGJXSJB', '');
INSERT INTO `05diseases` VALUES ('6434', '莫尔万病', '268', 'G60.851', 'MEWB', '');
INSERT INTO `05diseases` VALUES ('6435', '内拉东综合征', '278', 'G60.852', 'NLDZHZ', '');
INSERT INTO `05diseases` VALUES ('6436', '显性遗传性感觉性神经病', '313', 'G60.853', 'XXYCXGJXSJB', '');
INSERT INTO `05diseases` VALUES ('6437', '隐性遗传性感觉性神经病', '313', 'G60.854', 'YXYCXGJXSJB', '');
INSERT INTO `05diseases` VALUES ('6438', '遗传性周围神经病', '313', 'G60.901', 'YCXZWSJB', '');
INSERT INTO `05diseases` VALUES ('6439', '特发性神经病 NOS', '313', 'G60.951', 'TFXSJB', '');
INSERT INTO `05diseases` VALUES ('6440', '遗传性神经病 NOS', '313', 'G60.952', 'YCXSJB', '');
INSERT INTO `05diseases` VALUES ('6441', '费舍综合征[变异型格林-巴利综合征]', '278', 'G61.001', 'FSZHZBYXGLBLZHZ', '');
INSERT INTO `05diseases` VALUES ('6442', '感染后多发性周围神经病', '313', 'G61.002', 'GRHDFXZWSJB', '');
INSERT INTO `05diseases` VALUES ('6443', '急性感染性多神经炎[格林－巴利、吉兰－巴雷综合征]', '313', 'G61.003', 'JXGRXDSJYGLBLJLBLZHZ', '');
INSERT INTO `05diseases` VALUES ('6444', '慢性格林巴利氏综合征', '278', 'G61.004', 'MXGLBLSZHZ', '');
INSERT INTO `05diseases` VALUES ('6445', '上行性神经脊髓炎', '313', 'G61.051', 'SXXSJJSY', '');
INSERT INTO `05diseases` VALUES ('6446', '浆液性神经病', '313', 'G61.151', 'JYXSJB', '');
INSERT INTO `05diseases` VALUES ('6447', '其他炎性多神经病', '313', 'G61.851', 'QTYXDSJB', '');
INSERT INTO `05diseases` VALUES ('6448', '炎性多神经病 NOS', '313', 'G61.951', 'YXDSJB', '');
INSERT INTO `05diseases` VALUES ('6449', '药物性多神经病', '313', 'G62.001', 'YWXDSJB', '');
INSERT INTO `05diseases` VALUES ('6450', '药物性周围神经病', '313', 'G62.002', 'YWXZWSJB', '');
INSERT INTO `05diseases` VALUES ('6451', '药物性神经炎', '313', 'G62.051', 'YWXSJY', '');
INSERT INTO `05diseases` VALUES ('6452', '酒精中毒性周围神经病', '313', 'G62.101', 'JJZDXZWSJB', '');
INSERT INTO `05diseases` VALUES ('6453', '慢性酒精中毒性神经病', '313', 'G62.102', 'MXJJZDXSJB', '');
INSERT INTO `05diseases` VALUES ('6454', '化学性多神经病', '313', 'G62.201', 'HXXDSJB', '');
INSERT INTO `05diseases` VALUES ('6455', '有机磷中毒性周围神经病', '313', 'G62.202', 'YJLZDXZWSJB', '');
INSERT INTO `05diseases` VALUES ('6456', '中毒性多神经病', '313', 'G62.203', 'ZDXDSJB', '');
INSERT INTO `05diseases` VALUES ('6457', '中毒性神经病', '313', 'G62.251', 'ZDXSJB', '');
INSERT INTO `05diseases` VALUES ('6458', '中毒性神经炎', '313', 'G62.252', 'ZDXSJY', '');
INSERT INTO `05diseases` VALUES ('6459', '放射性神经炎', '313', 'G62.851', 'FSXSJY', '');
INSERT INTO `05diseases` VALUES ('6460', '多发性神经根炎', '313', 'G62.901', 'DFXSJGY', '');
INSERT INTO `05diseases` VALUES ('6461', '多发性神经炎', '313', 'G62.902', 'DFXSJY', '');
INSERT INTO `05diseases` VALUES ('6462', '多神经病', '313', 'G62.903', 'DSJB', '');
INSERT INTO `05diseases` VALUES ('6463', '周围神经病', '313', 'G62.904', 'ZWSJB', '');
INSERT INTO `05diseases` VALUES ('6464', '周围神经炎', '313', 'G62.905', 'ZWSJY', '');
INSERT INTO `05diseases` VALUES ('6465', '中毒性多发性神经炎及周围神经病', '313', 'G62.951', 'ZDXDFXSJYJZWSJB', '');
INSERT INTO `05diseases` VALUES ('6466', '原因不明进行性多神经病', '313', 'G62.952', 'YYBMJXXDSJB', '');
INSERT INTO `05diseases` VALUES ('6467', '周围神经系统疾患', '313', 'G64.X51', 'ZWSJXTJH', '');
INSERT INTO `05diseases` VALUES ('6468', '重症肌无力', '145', 'G70.001', 'ZZJWL', '');
INSERT INTO `05diseases` VALUES ('6469', '中毒性肌神经疾患', '313', 'G70.101', 'ZDXJSJJH', '');
INSERT INTO `05diseases` VALUES ('6470', '先天性肌弛缓[奥本海姆氏病]', '383', 'G70.201', 'XTXJCHABHMSB', '');
INSERT INTO `05diseases` VALUES ('6471', '先天性重症肌无力', '383', 'G70.251', 'XTXZZJWL', '');
INSERT INTO `05diseases` VALUES ('6472', '其他特指的肌神经疾患', '313', 'G70.851', 'QTTZDJSJJH', '');
INSERT INTO `05diseases` VALUES ('6473', '喉肌无力', '133', 'G70.901', 'HJWL', '');
INSERT INTO `05diseases` VALUES ('6474', '肌神经疾患', '313', 'G70.902', 'JSJJH', '');
INSERT INTO `05diseases` VALUES ('6475', '肌无力', '145', 'G70.903', 'JWL', '');
INSERT INTO `05diseases` VALUES ('6476', '肌无力危象', '145', 'G70.904', 'JWLWX', '');
INSERT INTO `05diseases` VALUES ('6477', '肌无力综合征', '145', 'G70.905', 'JWLZHZ', '');
INSERT INTO `05diseases` VALUES ('6478', '继发性肌无力综合征', '145', 'G70.906', 'JFXJWLZHZ', '');
INSERT INTO `05diseases` VALUES ('6479', '面肌肌无力', '145', 'G70.907', 'MJJWL', '');
INSERT INTO `05diseases` VALUES ('6480', '神经肌病', '313', 'G70.908', 'SJJB', '');
INSERT INTO `05diseases` VALUES ('6481', '肌神经疾患 NOS', '313', 'G70.951', 'JSJJH', '');
INSERT INTO `05diseases` VALUES ('6482', '肌营养不良', '448', 'G71.001', 'JYYBL', '');
INSERT INTO `05diseases` VALUES ('6483', '假肥大性肌营养不良', '448', 'G71.002', 'JFDXJYYBL', '');
INSERT INTO `05diseases` VALUES ('6484', '进行性(遗传性)肌营养不良', '448', 'G71.003', 'JXXYCXJYYBL', '');
INSERT INTO `05diseases` VALUES ('6485', '远端型肌病', '268', 'G71.004', 'YDXJB', '');
INSERT INTO `05diseases` VALUES ('6486', '假性肥大性肌萎缩[迪谢纳－格里辛格病]', '144', 'G71.051', 'JXFDXJWSDXNGLXGB', '');
INSERT INTO `05diseases` VALUES ('6487', '高尔肌营养不良', '448', 'G71.052', 'GEJYYBL', '');
INSERT INTO `05diseases` VALUES ('6488', '莱登－默比乌斯肌营养不良', '448', 'G71.053', 'LDMBWSJYYBL', '');
INSERT INTO `05diseases` VALUES ('6489', '朗杜齐－德热里纳肌肉萎缩(面、肩、肱)', '144', 'G71.054', 'LDQDRLNJRWSMJG', '');
INSERT INTO `05diseases` VALUES ('6490', '朗杜齐－德热里纳肌营养不良', '448', 'G71.055', 'LDQDRLNJYYBL', '');
INSERT INTO `05diseases` VALUES ('6491', '迪谢纳病或综合征肌营养不良', '448', 'G71.056', 'DXNBHZHZJYYBL', '');
INSERT INTO `05diseases` VALUES ('6492', '埃尔布营养不良', '448', 'G71.057', 'AEBYYBL', '');
INSERT INTO `05diseases` VALUES ('6493', '埃米尼－德赖富斯肌营养不良', '448', 'G71.058', 'AMNDLFSJYYBL', '');
INSERT INTO `05diseases` VALUES ('6494', '贝克尔型营养不良', '448', 'G71.059', 'BKEXYYBL', '');
INSERT INTO `05diseases` VALUES ('6495', 'ISAACS综合征', '278', 'G71.101', 'ZHZ', '');
INSERT INTO `05diseases` VALUES ('6496', '强直性肌营养不良', '448', 'G71.102', 'QZXJYYBL', '');
INSERT INTO `05diseases` VALUES ('6497', '萎缩性肌强直', '267', 'G71.103', 'WSXJQZ', '');
INSERT INTO `05diseases` VALUES ('6498', '先天性肌强直', '383', 'G71.104', 'XTXJQZ', '');
INSERT INTO `05diseases` VALUES ('6499', '骨筋膜室综合征', '265', 'G71.151', 'GJMSZHZ', '');
INSERT INTO `05diseases` VALUES ('6500', '萎缩性肌僵直症[-肌僵直营养不良症]', '448', 'G71.152', 'WSXJJZZJJZYYBLZ', '');
INSERT INTO `05diseases` VALUES ('6501', '神经性肌强直[艾萨克斯]', '313', 'G71.153', 'SJXJQZASKS', '');
INSERT INTO `05diseases` VALUES ('6502', '先天性肌病', '383', 'G71.201', 'XTXJB', '');
INSERT INTO `05diseases` VALUES ('6503', '先天性遗传性肌营养障碍', '383', 'G71.251', 'XTXYCXJYYZA', '');
INSERT INTO `05diseases` VALUES ('6504', '线样小体肌病', '268', 'G71.252', 'XYXTJB', '');
INSERT INTO `05diseases` VALUES ('6505', '线粒体肌病', '268', 'G71.301', 'XLTJB', '');
INSERT INTO `05diseases` VALUES ('6506', '肌肉的其他原发性疾患', '267', 'G71.851', 'JRDQTYFXJH', '');
INSERT INTO `05diseases` VALUES ('6507', '遗传性肌病', '268', 'G71.951', 'YCXJB', '');
INSERT INTO `05diseases` VALUES ('6508', '药物性肌病', '268', 'G72.051', 'YWXJB', '');
INSERT INTO `05diseases` VALUES ('6509', '酒精性肌病', '268', 'G72.101', 'JJXJB', '');
INSERT INTO `05diseases` VALUES ('6510', '中毒性肌病', '471', 'G72.201', 'ZDXJB', '');
INSERT INTO `05diseases` VALUES ('6511', '低血钾性周期性麻痹', '217', 'G72.301', 'DXJXZQXMB', '');
INSERT INTO `05diseases` VALUES ('6512', '高血钾性周期性麻痹', '217', 'G72.302', 'GXJXZQXMB', '');
INSERT INTO `05diseases` VALUES ('6513', '甲亢性周期性麻痹', '217', 'G72.303', 'JKXZQXMB', '');
INSERT INTO `05diseases` VALUES ('6514', '周期性麻痹', '217', 'G72.304', 'ZQXMB', '');
INSERT INTO `05diseases` VALUES ('6515', '肌强直性周期性(家族性)麻痹', '217', 'G72.351', 'JQZXZQXJZXMB', '');
INSERT INTO `05diseases` VALUES ('6516', '炎性肌病', '277', 'G72.451', 'YXJB', '');
INSERT INTO `05diseases` VALUES ('6517', '肌麻痹', '217', 'G72.801', 'JMB', '');
INSERT INTO `05diseases` VALUES ('6518', '血管性肌病', '413', 'G72.802', 'XGXJB', '');
INSERT INTO `05diseases` VALUES ('6519', '进行性肌病', '268', 'G72.851', 'JXXJB', '');
INSERT INTO `05diseases` VALUES ('6520', '佐藤吉氏综合征[痛性肌痉挛]', '179', 'G72.852', 'ZTJSZHZTXJJL', '');
INSERT INTO `05diseases` VALUES ('6521', '肌病 NOS', '268', 'G72.901', 'JB', '');
INSERT INTO `05diseases` VALUES ('6522', '痉挛性大脑性麻痹[瘫痪]', '234', 'G80.051', 'JLXDNXMBTH', '');
INSERT INTO `05diseases` VALUES ('6523', '先天性痉挛性大脑性(大脑性)麻痹[瘫痪]', '234', 'G80.052', 'XTXJLXDNXDNXMBTH', '');
INSERT INTO `05diseases` VALUES ('6524', '先天性痉挛性双侧截瘫', '383', 'G80.151', 'XTXJLXSCJT', '');
INSERT INTO `05diseases` VALUES ('6525', '婴儿性偏瘫', '254', 'G80.201', 'YEXPT', '');
INSERT INTO `05diseases` VALUES ('6526', '双侧性手足徐动症', '411', 'G80.301', 'SCXSZXDZ', '');
INSERT INTO `05diseases` VALUES ('6527', '婴儿大脑性手足徐动型轻瘫', '234', 'G80.302', 'YEDNXSZXDXQT', '');
INSERT INTO `05diseases` VALUES ('6528', '共济失调性大脑性[瘫痪]麻痹', '234', 'G80.451', 'GJSDXDNXTHMB', '');
INSERT INTO `05diseases` VALUES ('6529', '其他婴儿大脑性麻痹[瘫痪]', '234', 'G80.851', 'QTYEDNXMBTH', '');
INSERT INTO `05diseases` VALUES ('6530', '大脑先天性四肢瘫痪', '234', 'G80.852', 'DNXTXSZTH', '');
INSERT INTO `05diseases` VALUES ('6531', '脑性瘫痪', '234', 'G80.901', 'NXTH', '');
INSERT INTO `05diseases` VALUES ('6532', '新生儿脑性麻痹', '234', 'G80.902', 'XSENXMB', '');
INSERT INTO `05diseases` VALUES ('6533', '先天性单侧大脑性瘫痪', '234', 'G80.951', 'XTXDCDNXTH', '');
INSERT INTO `05diseases` VALUES ('6534', '大脑性瘫痪 NOS', '234', 'G80.952', 'DNXTH', '');
INSERT INTO `05diseases` VALUES ('6535', '新生儿脑性瘫痪', '234', 'G80.953', 'XSENXTH', '');
INSERT INTO `05diseases` VALUES ('6536', '弛缓性偏瘫', '254', 'G81.051', 'CHXPT', '');
INSERT INTO `05diseases` VALUES ('6537', '痉挛性偏瘫', '179', 'G81.151', 'JLXPT', '');
INSERT INTO `05diseases` VALUES ('6538', '高血压性偏瘫', '99', 'G81.901', 'GXYXPT', '');
INSERT INTO `05diseases` VALUES ('6539', '脑血管病性偏瘫', '233', 'G81.902', 'NXGBXPT', '');
INSERT INTO `05diseases` VALUES ('6540', '半身不遂(偏瘫)', '254', 'G81.903', 'BSBSPT', '');
INSERT INTO `05diseases` VALUES ('6541', '轻偏瘫', '254', 'G81.904', 'QPT', '');
INSERT INTO `05diseases` VALUES ('6542', '偏瘫 NOS', '254', 'G81.951', 'PT', '');
INSERT INTO `05diseases` VALUES ('6543', '弛缓性截瘫', '175', 'G82.051', 'CHXJT', '');
INSERT INTO `05diseases` VALUES ('6544', '痉挛性截瘫', '179', 'G82.101', 'JLXJT', '');
INSERT INTO `05diseases` VALUES ('6545', '不全截瘫', '175', 'G82.201', 'BQJT', '');
INSERT INTO `05diseases` VALUES ('6546', '陈旧性脊柱骨折伴截瘫', '116', 'G82.202', 'CJXJZGZBJT', '');
INSERT INTO `05diseases` VALUES ('6547', '陈旧性腰椎骨折伴截瘫', '116', 'G82.203', 'CJXYZGZBJT', '');
INSERT INTO `05diseases` VALUES ('6548', '高位截瘫', '175', 'G82.204', 'GWJT', '');
INSERT INTO `05diseases` VALUES ('6549', '截瘫', '175', 'G82.205', 'JT', '');
INSERT INTO `05diseases` VALUES ('6550', '弛缓性四肢瘫痪', '345', 'G82.351', 'CHXSZTH', '');
INSERT INTO `05diseases` VALUES ('6551', '痉挛性四肢瘫痪', '179', 'G82.451', 'JLXSZTH', '');
INSERT INTO `05diseases` VALUES ('6552', '四肢不全瘫', '345', 'G82.501', 'SZBQT', '');
INSERT INTO `05diseases` VALUES ('6553', '四肢瘫', '345', 'G82.502', 'SZT', '');
INSERT INTO `05diseases` VALUES ('6554', '双侧上肢瘫痪', '307', 'G83.051', 'SCSZTH', '');
INSERT INTO `05diseases` VALUES ('6555', '下肢单瘫', '345', 'G83.101', 'XZDT', '');
INSERT INTO `05diseases` VALUES ('6556', '上肢单瘫', '345', 'G83.201', 'SZDT', '');
INSERT INTO `05diseases` VALUES ('6557', '桡神经麻痹', '313', 'G83.251', 'RSJMB', '');
INSERT INTO `05diseases` VALUES ('6558', '上肢瘫痪', '345', 'G83.252', 'SZTH', '');
INSERT INTO `05diseases` VALUES ('6559', '单瘫 NOS', '175', 'G83.351', 'DT', '');
INSERT INTO `05diseases` VALUES ('6560', '马尾综合征', '278', 'G83.401', 'MWZHZ', '');
INSERT INTO `05diseases` VALUES ('6561', '马尾综合征引起的神经原性膀胱炎', '313', 'G83.451', 'MWZHZYQDSJYXBGY', '');
INSERT INTO `05diseases` VALUES ('6562', '布朗－塞卡尔氏麻痹综合征(脊髓半侧损害)', '217', 'G83.801', 'BLSKESMBZHZJSBCSH', '');
INSERT INTO `05diseases` VALUES ('6563', '托德氏（Todd氏）麻痹', '217', 'G83.802', 'TDSSMB', '');
INSERT INTO `05diseases` VALUES ('6564', '完全性瘫痪', '345', 'G83.803', 'WQXTH', '');
INSERT INTO `05diseases` VALUES ('6565', '交叉性面神经偏瘫', '313', 'G83.851', 'JCXMSJPT', '');
INSERT INTO `05diseases` VALUES ('6566', '痉挛性瘫痪', '179', 'G83.901', 'JLXTH', '');
INSERT INTO `05diseases` VALUES ('6567', '瘫痪', '345', 'G83.902', 'TH', '');
INSERT INTO `05diseases` VALUES ('6568', '轻度瘫痪', '345', 'G83.951', 'QDTH', '');
INSERT INTO `05diseases` VALUES ('6569', '麻痹(瘫痪)综合症', '217', 'G83.952', 'MBTHZHZ', '');
INSERT INTO `05diseases` VALUES ('6570', '颈动脉窦晕厥', '178', 'G90.001', 'GDMDYJ', '');
INSERT INTO `05diseases` VALUES ('6571', '家族性自主神经机能异常[赖利-戴]', '313', 'G90.151', 'JZXZZSJJNYCLLD', '');
INSERT INTO `05diseases` VALUES ('6572', '副交感神经麻痹[霍纳氏综合征]', '313', 'G90.251', 'FJGSJMBHNSZHZ', '');
INSERT INTO `05diseases` VALUES ('6573', '多系统变性', '278', 'G90.301', 'DXTBX', '');
INSERT INTO `05diseases` VALUES ('6574', '直立性低血压伴多系统变性[夏伊－德雷格氏综合症]', '99', 'G90.351', 'ZLXDXYBDXTBXXYDLGSZH', '');
INSERT INTO `05diseases` VALUES ('6575', '交感神经炎', '313', 'G90.801', 'JGSJY', '');
INSERT INTO `05diseases` VALUES ('6576', '施泰因布罗克综合征', '278', 'G90.851', 'STYBLKZHZ', '');
INSERT INTO `05diseases` VALUES ('6577', '植物神经功能紊乱', '313', 'G90.901', 'ZWSJGNWL', '');
INSERT INTO `05diseases` VALUES ('6578', '心脏植物神经功能紊乱', '313', 'G90.951', 'XZZWSJGNWL', '');
INSERT INTO `05diseases` VALUES ('6579', '交通性脑积水', '234', 'G91.001', 'JTXNJS', '');
INSERT INTO `05diseases` VALUES ('6580', '梗阻性脑积水', '234', 'G91.101', 'GZXNJS', '');
INSERT INTO `05diseases` VALUES ('6581', '中脑水管梗阻', '234', 'G91.102', 'ZNSGGZ', '');
INSERT INTO `05diseases` VALUES ('6582', '正常压力脑积水', '234', 'G91.251', 'ZCYLNJS', '');
INSERT INTO `05diseases` VALUES ('6583', '外伤后脑积水', '234', 'G91.301', 'WSHNJS', '');
INSERT INTO `05diseases` VALUES ('6584', '手术后脑积水', '234', 'G91.351', 'SSHNJS', '');
INSERT INTO `05diseases` VALUES ('6585', '耳源性脑积水', '70', 'G91.801', 'EYXNJS', '');
INSERT INTO `05diseases` VALUES ('6586', '继发性脑积水', '234', 'G91.852', 'JFXNJS', '');
INSERT INTO `05diseases` VALUES ('6587', '脑积水', '234', 'G91.901', 'NJS', '');
INSERT INTO `05diseases` VALUES ('6588', '硬脑膜下积水(液)', '232', 'G91.902', 'YNMXJSY', '');
INSERT INTO `05diseases` VALUES ('6589', '中毒性脑病', '234', 'G92.X01', 'ZDXNB', '');
INSERT INTO `05diseases` VALUES ('6590', '中毒性脑膜炎', '232', 'G92.X51', 'ZDXNMY', '');
INSERT INTO `05diseases` VALUES ('6591', '中毒性脑炎', '234', 'G92.X52', 'ZDXNY', '');
INSERT INTO `05diseases` VALUES ('6592', '蛛网膜囊肿', '231', 'G93.001', 'ZWMNZ', '');
INSERT INTO `05diseases` VALUES ('6593', '脑囊肿', '234', 'G93.002', 'NNZ', '');
INSERT INTO `05diseases` VALUES ('6594', '透明隔囊肿', '231', 'G93.003', 'TMGNZ', '');
INSERT INTO `05diseases` VALUES ('6595', '硬脑脊膜(大脑)囊肿', '234', 'G93.004', 'YNJMDNNZ', '');
INSERT INTO `05diseases` VALUES ('6596', '硬膜下囊肿', '231', 'G93.005', 'YMXNZ', '');
INSERT INTO `05diseases` VALUES ('6597', '脑穿通性囊肿', '234', 'G93.051', 'NCTXNZ', '');
INSERT INTO `05diseases` VALUES ('6598', '缺氧性脑病(肺性脑病)', '234', 'G93.101', 'QYXNBFXNB', '');
INSERT INTO `05diseases` VALUES ('6599', '脑缺氧症', '234', 'G93.102', 'NQYZ', '');
INSERT INTO `05diseases` VALUES ('6600', '颅内压增高', '213', 'G93.201', 'LNYZG', '');
INSERT INTO `05diseases` VALUES ('6601', '脑假瘤', '234', 'G93.251', 'NJL', '');
INSERT INTO `05diseases` VALUES ('6602', '颅内压增高综合征', '213', 'G93.252', 'LNYZGZHZ', '');
INSERT INTO `05diseases` VALUES ('6603', '良性肌痛性脑脊髓炎[阿库雷里氏病]', '234', 'G93.351', 'LXJTXNJSYAKLLSB', '');
INSERT INTO `05diseases` VALUES ('6604', '白质灰质性脑病', '234', 'G93.401', 'BZHZXNB', '');
INSERT INTO `05diseases` VALUES ('6605', '低颅压综合征', '213', 'G93.402', 'DLYZHZ', '');
INSERT INTO `05diseases` VALUES ('6606', '间脑病变', '234', 'G93.403', 'JNBB', '');
INSERT INTO `05diseases` VALUES ('6607', '颅内压降低', '213', 'G93.404', 'LNYJD', '');
INSERT INTO `05diseases` VALUES ('6608', '弥散性脑病', '234', 'G93.405', 'MSXNB', '');
INSERT INTO `05diseases` VALUES ('6609', '脑白质病', '234', 'G93.406', 'NBZB', '');
INSERT INTO `05diseases` VALUES ('6610', '脑病变', '234', 'G93.407', 'NBB', '');
INSERT INTO `05diseases` VALUES ('6611', '枕叶脑白质病变', '234', 'G93.408', 'ZYNBZBB', '');
INSERT INTO `05diseases` VALUES ('6612', '枕骨大孔疝', '305', 'G93.501', 'ZGDKS', '');
INSERT INTO `05diseases` VALUES ('6613', '脑干受压', '234', 'G93.502', 'NGSY', '');
INSERT INTO `05diseases` VALUES ('6614', '脑干占位性病变', '234', 'G93.503', 'NGZWXBB', '');
INSERT INTO `05diseases` VALUES ('6615', '脑干肿物', '234', 'G93.504', 'NGZW', '');
INSERT INTO `05diseases` VALUES ('6616', '脑疝', '234', 'G93.505', 'NS', '');
INSERT INTO `05diseases` VALUES ('6617', '脑受压', '234', 'G93.506', 'NSY', '');
INSERT INTO `05diseases` VALUES ('6618', '小脑幕切迹疝[海马回钩疝]', '234', 'G93.552', 'XNMQJSHMHGS', '');
INSERT INTO `05diseases` VALUES ('6619', '脑水肿', '234', 'G93.601', 'NSZ', '');
INSERT INTO `05diseases` VALUES ('6620', '脑干水肿', '234', 'G93.602', 'NGSZ', '');
INSERT INTO `05diseases` VALUES ('6621', '赖氏综合征', '278', 'G93.701', 'LSZHZ', '');
INSERT INTO `05diseases` VALUES ('6622', '闭锁综合征', '278', 'G93.801', 'BSZHZ', '');
INSERT INTO `05diseases` VALUES ('6623', '后天性脑畸形', '234', 'G93.802', 'HTXNJX', '');
INSERT INTO `05diseases` VALUES ('6624', '大脑钙化', '234', 'G93.803', 'DNGH', '');
INSERT INTO `05diseases` VALUES ('6625', '颅内胆脂瘤', '53', 'G93.804', 'LNDZL', '');
INSERT INTO `05diseases` VALUES ('6626', '大脑去皮层状态', '234', 'G93.805', 'DNQPCZT', '');
INSERT INTO `05diseases` VALUES ('6627', '颅内积气', '213', 'G93.806', 'LNJQ', '');
INSERT INTO `05diseases` VALUES ('6628', '脑钙化', '234', 'G93.807', 'NGH', '');
INSERT INTO `05diseases` VALUES ('6629', '放射性脑病', '234', 'G93.808', 'FSXNB', '');
INSERT INTO `05diseases` VALUES ('6630', '脑皮质胶质细胞增生', '234', 'G93.809', 'NPZJZXBZS', '');
INSERT INTO `05diseases` VALUES ('6631', '脑软化', '234', 'G93.810', 'NRH', '');
INSERT INTO `05diseases` VALUES ('6632', '脑室扩张', '234', 'G93.811', 'NSKZ', '');
INSERT INTO `05diseases` VALUES ('6633', '丘脑功能衰竭', '234', 'G93.812', 'QNGNSJ', '');
INSERT INTO `05diseases` VALUES ('6634', '丘脑红核综合征', '234', 'G93.813', 'QNHHZHZ', '');
INSERT INTO `05diseases` VALUES ('6635', '丘脑综合征', '234', 'G93.814', 'QNZHZ', '');
INSERT INTO `05diseases` VALUES ('6636', '视丘反应综合征', '325', 'G93.816', 'SQFYZHZ', '');
INSERT INTO `05diseases` VALUES ('6637', '胰腺脑病', '262', 'G93.817', 'YXNB', '');
INSERT INTO `05diseases` VALUES ('6638', '中枢性呼吸衰竭', '266', 'G93.818', 'ZSXHXSJ', '');
INSERT INTO `05diseases` VALUES ('6639', '蛛网膜憩室', '475', 'G93.819', 'ZWMQS', '');
INSERT INTO `05diseases` VALUES ('6640', '脑桥综合征(脑桥受损所致的症候群)', '234', 'G93.851', 'NQZHZNQSSSZDZHQ', '');
INSERT INTO `05diseases` VALUES ('6641', '神经胶质细胞增生', '313', 'G93.852', 'SJJZXBZS', '');
INSERT INTO `05diseases` VALUES ('6642', '室管膜病', '268', 'G93.853', 'SGMB', '');
INSERT INTO `05diseases` VALUES ('6643', '脑干病变(脑干功能衰竭)', '234', 'G93.901', 'NGBBNGGNSJ', '');
INSERT INTO `05diseases` VALUES ('6644', '脑损害', '234', 'G93.904', 'NSH', '');
INSERT INTO `05diseases` VALUES ('6645', '脑肿物', '234', 'G93.905', 'NZW', '');
INSERT INTO `05diseases` VALUES ('6646', '器质性脑损害', '234', 'G93.906', 'QZXNSH', '');
INSERT INTO `05diseases` VALUES ('6647', '颅内(腔)积气', '213', 'G93.951', 'LNQJQ', '');
INSERT INTO `05diseases` VALUES ('6648', '大脑病变(损害)', '234', 'G93.952', 'DNBBSH', '');
INSERT INTO `05diseases` VALUES ('6649', '小脑病变', '234', 'G93.953', 'XNBB', '');
INSERT INTO `05diseases` VALUES ('6650', '去大脑强直', '234', 'G93.954', 'QDNQZ', '');
INSERT INTO `05diseases` VALUES ('6651', '脊髓空洞症', '152', 'G95.001', 'JSKDZ', '');
INSERT INTO `05diseases` VALUES ('6652', '急性脊髓梗塞', '152', 'G95.101', 'JXJSGS', '');
INSERT INTO `05diseases` VALUES ('6653', '脊髓出血', '38', 'G95.102', 'JSCX', '');
INSERT INTO `05diseases` VALUES ('6654', '脊髓动脉血栓', '260', 'G95.103', 'JSDMXS', '');
INSERT INTO `05diseases` VALUES ('6655', '脊髓前动脉供血不足', '59', 'G95.104', 'JSQDMGXBZ', '');
INSERT INTO `05diseases` VALUES ('6656', '脊髓前动脉血栓形成', '260', 'G95.105', 'JSQDMXSXC', '');
INSERT INTO `05diseases` VALUES ('6657', '脊髓缺血', '152', 'G95.106', 'JSQX', '');
INSERT INTO `05diseases` VALUES ('6658', '脊(髓)动脉硬化', '63', 'G95.151', 'JSDMYH', '');
INSERT INTO `05diseases` VALUES ('6659', '亚急性坏死性脊髓病', '152', 'G95.152', 'YJXHSXJSB', '');
INSERT INTO `05diseases` VALUES ('6660', '脊柱前、后动脉血栓形成', '260', 'G95.153', 'JZQHDMXSXC', '');
INSERT INTO `05diseases` VALUES ('6661', '脊髓水肿', '337', 'G95.154', 'JSSZ', '');
INSERT INTO `05diseases` VALUES ('6662', '血管性脊髓病', '152', 'G95.155', 'XGXJSB', '');
INSERT INTO `05diseases` VALUES ('6663', '脊髓受压', '152', 'G95.201', 'JSSY', '');
INSERT INTO `05diseases` VALUES ('6664', '放射性脊髓病', '152', 'G95.801', 'FSXJSB', '');
INSERT INTO `05diseases` VALUES ('6665', '肝性脊髓病', '92', 'G95.802', 'GXJSB', '');
INSERT INTO `05diseases` VALUES ('6666', '脊神经根囊肿', '313', 'G95.803', 'JSJGNZ', '');
INSERT INTO `05diseases` VALUES ('6667', '脊髓内囊肿', '231', 'G95.804', 'JSNNZ', '');
INSERT INTO `05diseases` VALUES ('6668', '脊髓前角病变', '152', 'G95.805', 'JSQJBB', '');
INSERT INTO `05diseases` VALUES ('6669', '脊髓萎缩', '152', 'G95.806', 'JSWS', '');
INSERT INTO `05diseases` VALUES ('6670', '脊髓膀胱', '152', 'G95.807', 'JSBG', '');
INSERT INTO `05diseases` VALUES ('6671', '脊髓硬化', '152', 'G95.808', 'JSYH', '');
INSERT INTO `05diseases` VALUES ('6672', '腰骶神经根囊肿', '313', 'G95.809', 'YDSJGNZ', '');
INSERT INTO `05diseases` VALUES ('6673', '硬脊膜内囊肿(脊髓)', '231', 'G95.810', 'YJMNNZJS', '');
INSERT INTO `05diseases` VALUES ('6674', '椎管内囊肿', '231', 'G95.811', 'ZGNNZ', '');
INSERT INTO `05diseases` VALUES ('6675', '药物引起的脊髓病', '152', 'G95.851', 'YWYQDJSB', '');
INSERT INTO `05diseases` VALUES ('6676', '中毒性脊髓病', '471', 'G95.852', 'ZDXJSB', '');
INSERT INTO `05diseases` VALUES ('6677', '脊髓软化', '152', 'G95.853', 'JSRH', '');
INSERT INTO `05diseases` VALUES ('6678', '脊髓圆锥综合征', '152', 'G95.854', 'JSYZZHZ', '');
INSERT INTO `05diseases` VALUES ('6679', '脊髓病', '152', 'G95.901', 'JSB', '');
INSERT INTO `05diseases` VALUES ('6680', '脊髓占位性病变', '152', 'G95.902', 'JSZWXBB', '');
INSERT INTO `05diseases` VALUES ('6681', '椎管内占位性病变', '479', 'G95.903', 'ZGNZWXBB', '');
INSERT INTO `05diseases` VALUES ('6682', '脊髓神经病变', '313', 'G95.951', 'JSSJBB', '');
INSERT INTO `05diseases` VALUES ('6683', '脑脊液鼻漏', '16', 'G96.001', 'NJYBL', '');
INSERT INTO `05diseases` VALUES ('6684', '脑脊液耳漏', '70', 'G96.002', 'NJYEL', '');
INSERT INTO `05diseases` VALUES ('6685', '手术后脑脊液漏', '234', 'G96.005', 'SSHNJYL', '');
INSERT INTO `05diseases` VALUES ('6686', '脊髓粘连', '152', 'G96.101', 'JSNL', '');
INSERT INTO `05diseases` VALUES ('6687', '脊髓蛛网膜粘连', '152', 'G96.102', 'JSZWMNL', '');
INSERT INTO `05diseases` VALUES ('6688', '马尾粘连', '278', 'G96.103', 'MWNL', '');
INSERT INTO `05diseases` VALUES ('6689', '脑室粘连', '234', 'G96.104', 'NSNL', '');
INSERT INTO `05diseases` VALUES ('6690', '髓外硬膜外囊肿', '231', 'G96.105', 'SWYMWNZ', '');
INSERT INTO `05diseases` VALUES ('6691', '圆锥内表皮囊肿', '231', 'G96.106', 'YZNBPNZ', '');
INSERT INTO `05diseases` VALUES ('6692', '蛛网膜粘连', '475', 'G96.107', 'ZWMNL', '');
INSERT INTO `05diseases` VALUES ('6693', '颅内脑膜粘连', '232', 'G96.151', 'LNNMNL', '');
INSERT INTO `05diseases` VALUES ('6694', '柔脑(脊)膜病', '234', 'G96.152', 'RNJMB', '');
INSERT INTO `05diseases` VALUES ('6695', '脊柱硬脑脊膜外囊肿', '234', 'G96.153', 'JZYNJMWNZ', '');
INSERT INTO `05diseases` VALUES ('6696', '硬膜下脊髓囊肿', '231', 'G96.154', 'YMXJSNZ', '');
INSERT INTO `05diseases` VALUES ('6697', '后天性脑膜膨出', '232', 'G96.801', 'HTXNMPC', '');
INSERT INTO `05diseases` VALUES ('6698', '脑脊髓病', '234', 'G96.901', 'NJSB', '');
INSERT INTO `05diseases` VALUES ('6699', '脑脊髓神经病', '313', 'G96.902', 'NJSSJB', '');
INSERT INTO `05diseases` VALUES ('6700', '脑脊髓神经根病', '313', 'G96.903', 'NJSSJGB', '');
INSERT INTO `05diseases` VALUES ('6701', '中枢神经系统并发症', '313', 'G96.904', 'ZSSJXTBFZ', '');
INSERT INTO `05diseases` VALUES ('6702', '腰椎穿刺引起的脑脊液漏', '234', 'G97.051', 'YZCCYQDNJYL', '');
INSERT INTO `05diseases` VALUES ('6703', '腰穿后低颅压性头痛', '358', 'G97.101', 'YCHDLYXTT', '');
INSERT INTO `05diseases` VALUES ('6704', '腰椎穿刺后头痛', '358', 'G97.151', 'YZCCHTT', '');
INSERT INTO `05diseases` VALUES ('6705', '脑室分流后的低颅压综合征', '234', 'G97.251', 'NSFLHDDLYZHZ', '');
INSERT INTO `05diseases` VALUES ('6706', '发生于操作中或操作后的缺氧性脑损害', '234', 'G97.802', 'FSYCZZHCZHDQYXNSH', '');
INSERT INTO `05diseases` VALUES ('6707', '手术后脑膜膨出', '232', 'G97.803', 'SSHNMPC', '');
INSERT INTO `05diseases` VALUES ('6708', '其他神经系统操作后疾患', '313', 'G97.851', 'QTSJXTCZHJH', '');
INSERT INTO `05diseases` VALUES ('6709', '神经系统操作后疾患 NOS', '313', 'G97.951', 'SJXTCZHJH', '');
INSERT INTO `05diseases` VALUES ('6710', '神经系统病变', '313', 'G98.X01', 'SJXTBB', '');
INSERT INTO `05diseases` VALUES ('6711', '神经系统疾患 NOS', '313', 'G98.X51', 'SJXTJH', '');
INSERT INTO `05diseases` VALUES ('6712', '睑板腺炎', '277', 'H00.001', 'JBXY', '');
INSERT INTO `05diseases` VALUES ('6713', '睑腺炎[麦粒肿；迈博姆；察司]', '277', 'H00.002', 'JXYMLZMBMCS', '');
INSERT INTO `05diseases` VALUES ('6714', '眼睑蜂窝织炎', '430', 'H00.003', 'YJFWZY', '');
INSERT INTO `05diseases` VALUES ('6715', '眼睑脓肿', '430', 'H00.004', 'YJNZ', '');
INSERT INTO `05diseases` VALUES ('6716', '眼睑疖肿', '430', 'H00.051', 'YJJZ', '');
INSERT INTO `05diseases` VALUES ('6717', '睑板腺囊肿[霰粒肿]', '231', 'H00.101', 'JBXNZXLZ', '');
INSERT INTO `05diseases` VALUES ('6718', '睑(缘)炎', '277', 'H01.001', 'JYY', '');
INSERT INTO `05diseases` VALUES ('6719', '新生儿睑缘炎', '405', 'H01.002', 'XSEJYY', '');
INSERT INTO `05diseases` VALUES ('6720', '溃疡性睑(缘)炎', '195', 'H01.051', 'KYXJYY', '');
INSERT INTO `05diseases` VALUES ('6721', '鳞状性睑缘炎', '277', 'H01.052', 'LZXJYY', '');
INSERT INTO `05diseases` VALUES ('6722', '眼睑皮炎', '430', 'H01.101', 'YJPY', '');
INSERT INTO `05diseases` VALUES ('6723', '眼睑的盘形红斑狼疮', '430', 'H01.151', 'YJDPXHBLC', '');
INSERT INTO `05diseases` VALUES ('6724', '眼睑的干皮病', '430', 'H01.152', 'YJDGPB', '');
INSERT INTO `05diseases` VALUES ('6725', '眼睑湿疹性皮炎', '430', 'H01.153', 'YJSZXPY', '');
INSERT INTO `05diseases` VALUES ('6726', '眼睑变应性(过敏性)皮炎', '430', 'H01.154', 'YJBYXGMXPY', '');
INSERT INTO `05diseases` VALUES ('6727', '眼睑瘘', '430', 'H01.801', 'YJL', '');
INSERT INTO `05diseases` VALUES ('6728', '眼睑肉芽肿', '430', 'H01.802', 'YJRYZ', '');
INSERT INTO `05diseases` VALUES ('6729', '睑板炎', '277', 'H01.851', 'JBY', '');
INSERT INTO `05diseases` VALUES ('6730', '眼睑炎', '430', 'H01.901', 'YJY', '');
INSERT INTO `05diseases` VALUES ('6731', '瘢痕性倒睫', '55', 'H02.001', 'BHXDJ', '');
INSERT INTO `05diseases` VALUES ('6732', '眼睑倒睫', '430', 'H02.002', 'YJDJ', '');
INSERT INTO `05diseases` VALUES ('6733', '眼睑内翻', '430', 'H02.003', 'YJNF', '');
INSERT INTO `05diseases` VALUES ('6734', '痉挛性睑内翻', '179', 'H02.051', 'JLXJNF', '');
INSERT INTO `05diseases` VALUES ('6735', '瘢痕性睑内翻', '11', 'H02.052', 'BHXJNF', '');
INSERT INTO `05diseases` VALUES ('6736', '睑外翻', '366', 'H02.101', 'JWF', '');
INSERT INTO `05diseases` VALUES ('6737', '老年性睑外翻', '366', 'H02.102', 'LNXJWF', '');
INSERT INTO `05diseases` VALUES ('6738', '麻痹性睑外翻', '366', 'H02.103', 'MBXJWF', '');
INSERT INTO `05diseases` VALUES ('6739', '兔眼', '430', 'H02.201', 'TY', '');
INSERT INTO `05diseases` VALUES ('6740', '睑皮肤松驰', '250', 'H02.301', 'JPFSC', '');
INSERT INTO `05diseases` VALUES ('6741', '上睑下垂', '278', 'H02.401', 'SJXC', '');
INSERT INTO `05diseases` VALUES ('6742', '睑疤痕性闭合不全', '278', 'H02.501', 'JBHXBHBQ', '');
INSERT INTO `05diseases` VALUES ('6743', '睑裂闭合不全', '278', 'H02.502', 'JLBHBQ', '');
INSERT INTO `05diseases` VALUES ('6744', '睑裂狭小', '278', 'H02.503', 'JLXX', '');
INSERT INTO `05diseases` VALUES ('6745', '睑缘粘连', '278', 'H02.504', 'JYNL', '');
INSERT INTO `05diseases` VALUES ('6746', '上睑退缩症', '278', 'H02.505', 'SJTSZ', '');
INSERT INTO `05diseases` VALUES ('6747', '眼睑闭锁', '430', 'H02.506', 'YJBS', '');
INSERT INTO `05diseases` VALUES ('6748', '眼睑粘连性疤痕', '430', 'H02.507', 'YJNLXBH', '');
INSERT INTO `05diseases` VALUES ('6749', '眼睑黄斑瘤', '430', 'H02.601', 'YJHBL', '');
INSERT INTO `05diseases` VALUES ('6750', '睑板腺脂肪变性', '278', 'H02.701', 'JBXZFBX', '');
INSERT INTO `05diseases` VALUES ('6751', '眶脂肪脱垂', '278', 'H02.702', 'KZFTC', '');
INSERT INTO `05diseases` VALUES ('6752', '眉毛脱落', '278', 'H02.703', 'MMTL', '');
INSERT INTO `05diseases` VALUES ('6753', '眉缺损', '278', 'H02.704', 'MQS', '');
INSERT INTO `05diseases` VALUES ('6754', '眼睑坏死', '430', 'H02.705', 'YJHS', '');
INSERT INTO `05diseases` VALUES ('6755', '眼睑睫毛脱落', '430', 'H02.751', 'YJJMTL', '');
INSERT INTO `05diseases` VALUES ('6756', '眼睑白癜风', '430', 'H02.752', 'YJBDF', '');
INSERT INTO `05diseases` VALUES ('6757', '陈旧性眼睑异物', '430', 'H02.801', 'CJXYJYW', '');
INSERT INTO `05diseases` VALUES ('6758', '后天性内眦畸形', '148', 'H02.802', 'HTXNZJX', '');
INSERT INTO `05diseases` VALUES ('6759', '后天性外眦畸形', '148', 'H02.803', 'HTXWZJX', '');
INSERT INTO `05diseases` VALUES ('6760', '眼睑水肿', '430', 'H02.804', 'YJSZ', '');
INSERT INTO `05diseases` VALUES ('6761', '烧伤后睑畸形', '309', 'H02.805', 'SSHJJX', '');
INSERT INTO `05diseases` VALUES ('6762', '烧伤后眉毛缺损', '309', 'H02.806', 'SSHMMQS', '');
INSERT INTO `05diseases` VALUES ('6763', '眼睑出血', '430', 'H02.807', 'YJCX', '');
INSERT INTO `05diseases` VALUES ('6764', '眼睑黑变病', '430', 'H02.808', 'YJHBB', '');
INSERT INTO `05diseases` VALUES ('6765', '眼睑后天性畸形', '430', 'H02.809', 'YJHTXJX', '');
INSERT INTO `05diseases` VALUES ('6766', '眼睑囊肿', '430', 'H02.810', 'YJNZ', '');
INSERT INTO `05diseases` VALUES ('6767', '眼睑皮脂腺囊肿', '430', 'H02.811', 'YJPZXNZ', '');
INSERT INTO `05diseases` VALUES ('6768', '眼眦后天畸形', '430', 'H02.812', 'YZHTJX', '');
INSERT INTO `05diseases` VALUES ('6769', '眦畸形', '148', 'H02.851', 'ZJX', '');
INSERT INTO `05diseases` VALUES ('6770', '眼睑充血', '430', 'H02.853', 'YJCX', '');
INSERT INTO `05diseases` VALUES ('6771', '莫尔腺囊肿', '231', 'H02.854', 'MEXNZ', '');
INSERT INTO `05diseases` VALUES ('6772', '眼睑新生物', '430', 'H02.901', 'YJXSW', '');
INSERT INTO `05diseases` VALUES ('6773', '眼睑肿物', '430', 'H02.902', 'YJZW', '');
INSERT INTO `05diseases` VALUES ('6774', '眼睑疾患 NOS', '430', 'H02.951', 'YJJH', '');
INSERT INTO `05diseases` VALUES ('6775', '急性泪腺炎', '199', 'H04.001', 'JXLXY', '');
INSERT INTO `05diseases` VALUES ('6776', '慢性泪腺炎', '199', 'H04.002', 'MXLXY', '');
INSERT INTO `05diseases` VALUES ('6777', '慢性泪腺肥大', '278', 'H04.051', 'MXLXFD', '');
INSERT INTO `05diseases` VALUES ('6778', '泪腺脱出', '362', 'H04.101', 'LXTC', '');
INSERT INTO `05diseases` VALUES ('6779', '泪眼', '430', 'H04.102', 'LY', '');
INSERT INTO `05diseases` VALUES ('6780', '泪液分泌过少', '278', 'H04.103', 'LYFMGS', '');
INSERT INTO `05diseases` VALUES ('6781', '眼干燥综合征', '430', 'H04.104', 'YGZZHZ', '');
INSERT INTO `05diseases` VALUES ('6782', '泪器囊肿', '231', 'H04.151', 'LQNZ', '');
INSERT INTO `05diseases` VALUES ('6783', '泪器萎缩', '278', 'H04.152', 'LQWS', '');
INSERT INTO `05diseases` VALUES ('6784', '外伤性泪器萎缩', '278', 'H04.153', 'WSXLQWS', '');
INSERT INTO `05diseases` VALUES ('6785', '泪溢', '278', 'H04.201', 'LY', '');
INSERT INTO `05diseases` VALUES ('6786', '泪腺分泌过多', '278', 'H04.251', 'LXFMGD', '');
INSERT INTO `05diseases` VALUES ('6787', '化脓性泪囊炎', '198', 'H04.301', 'HNXLNY', '');
INSERT INTO `05diseases` VALUES ('6788', '急性泪囊炎', '198', 'H04.302', 'JXLNY', '');
INSERT INTO `05diseases` VALUES ('6789', '泪囊脓肿', '243', 'H04.303', 'LNNZ', '');
INSERT INTO `05diseases` VALUES ('6790', '泪囊炎', '198', 'H04.304', 'LNY', '');
INSERT INTO `05diseases` VALUES ('6791', '泪小管炎', '277', 'H04.305', 'LXGY', '');
INSERT INTO `05diseases` VALUES ('6792', '急性泪囊周围炎', '277', 'H04.351', 'JXLNZWY', '');
INSERT INTO `05diseases` VALUES ('6793', '急性泪小管炎', '277', 'H04.352', 'JXLXGY', '');
INSERT INTO `05diseases` VALUES ('6794', '慢性泪囊炎', '198', 'H04.401', 'MXLNY', '');
INSERT INTO `05diseases` VALUES ('6795', '泪囊粘液溢', '278', 'H04.451', 'LNNYY', '');
INSERT INTO `05diseases` VALUES ('6796', '慢性泪囊周围炎', '277', 'H04.452', 'MXLNZWY', '');
INSERT INTO `05diseases` VALUES ('6797', '鼻泪管闭锁', '16', 'H04.501', 'BLGBS', '');
INSERT INTO `05diseases` VALUES ('6798', '鼻泪管阻塞', '16', 'H04.502', 'BLGZS', '');
INSERT INTO `05diseases` VALUES ('6799', '泪道梗阻', '278', 'H04.503', 'LDGZ', '');
INSERT INTO `05diseases` VALUES ('6800', '泪道狭窄', '278', 'H04.504', 'LDXZ', '');
INSERT INTO `05diseases` VALUES ('6801', '泪道阻塞', '278', 'H04.505', 'LDZS', '');
INSERT INTO `05diseases` VALUES ('6802', '泪小管阻塞', '278', 'H04.506', 'LXGZS', '');
INSERT INTO `05diseases` VALUES ('6803', '泪管闭锁', '278', 'H04.551', 'LGBS', '');
INSERT INTO `05diseases` VALUES ('6804', '泪石', '278', 'H04.552', 'LS', '');
INSERT INTO `05diseases` VALUES ('6805', '泪点外翻', '366', 'H04.553', 'LDWF', '');
INSERT INTO `05diseases` VALUES ('6806', '泪囊瘘', '212', 'H04.601', 'LNL', '');
INSERT INTO `05diseases` VALUES ('6807', '泪囊囊肿', '231', 'H04.602', 'LNNZ', '');
INSERT INTO `05diseases` VALUES ('6808', '泪囊粘液囊肿', '231', 'H04.603', 'LNNYNZ', '');
INSERT INTO `05diseases` VALUES ('6809', '泪管肿大', '278', 'H04.651', 'LGZD', '');
INSERT INTO `05diseases` VALUES ('6810', '泪囊膨出', '278', 'H04.652', 'LNPC', '');
INSERT INTO `05diseases` VALUES ('6811', '泪道(管)扩张', '278', 'H04.653', 'LDGKZ', '');
INSERT INTO `05diseases` VALUES ('6812', '泪小管断裂', '278', 'H04.801', 'LXGDL', '');
INSERT INTO `05diseases` VALUES ('6813', '泪器系的疾患 NOS', '278', 'H04.951', 'LQXDJH', '');
INSERT INTO `05diseases` VALUES ('6814', '眶蜂窝织炎', '83', 'H05.001', 'KFWZY', '');
INSERT INTO `05diseases` VALUES ('6815', '眶内脓肿', '243', 'H05.002', 'KNNZ', '');
INSERT INTO `05diseases` VALUES ('6816', '球筋膜炎', '277', 'H05.003', 'QJMY', '');
INSERT INTO `05diseases` VALUES ('6817', '眼眶骨膜炎', '430', 'H05.051', 'YKGMY', '');
INSERT INTO `05diseases` VALUES ('6818', '眼眶骨髓炎', '430', 'H05.052', 'YKGSY', '');
INSERT INTO `05diseases` VALUES ('6819', '眶内肉芽肿', '295', 'H05.101', 'KNRYZ', '');
INSERT INTO `05diseases` VALUES ('6820', '眶内炎性假瘤', '261', 'H05.102', 'KNYXJL', '');
INSERT INTO `05diseases` VALUES ('6821', '眼眶非特异性炎症', '430', 'H05.103', 'YKFTYXYZ', '');
INSERT INTO `05diseases` VALUES ('6822', '眼眶炎性肉芽肿', '430', 'H05.104', 'YKYXRYZ', '');
INSERT INTO `05diseases` VALUES ('6823', '眼球后炎症', '430', 'H05.105', 'YQHYZ', '');
INSERT INTO `05diseases` VALUES ('6824', '眶部出血', '38', 'H05.201', 'KBCX', '');
INSERT INTO `05diseases` VALUES ('6825', '眶内血肿', '422', 'H05.202', 'KNXZ', '');
INSERT INTO `05diseases` VALUES ('6826', '眼球突出', '430', 'H05.203', 'YQTC', '');
INSERT INTO `05diseases` VALUES ('6827', '眼眶水肿', '430', 'H05.251', 'YKSZ', '');
INSERT INTO `05diseases` VALUES ('6828', '眼球移位', '430', 'H05.252', 'YQYW', '');
INSERT INTO `05diseases` VALUES ('6829', '搏动性突眼', '430', 'H05.253', 'BDXTY', '');
INSERT INTO `05diseases` VALUES ('6830', '间歇性突眼', '430', 'H05.254', 'JXXTY', '');
INSERT INTO `05diseases` VALUES ('6831', '外伤性突眼', '430', 'H05.255', 'WSXTY', '');
INSERT INTO `05diseases` VALUES ('6832', '眼眶外生骨疣', '430', 'H05.351', 'YKWSGY', '');
INSERT INTO `05diseases` VALUES ('6833', '眼眶畸形', '430', 'H05.352', 'YKJX', '');
INSERT INTO `05diseases` VALUES ('6834', '眼眶萎缩', '430', 'H05.353', 'YKWS', '');
INSERT INTO `05diseases` VALUES ('6835', '眼球陷没', '430', 'H05.451', 'YQXM', '');
INSERT INTO `05diseases` VALUES ('6836', '眶内陈旧性异物', '278', 'H05.501', 'KNCJXYW', '');
INSERT INTO `05diseases` VALUES ('6837', '陈旧性球后异物', '278', 'H05.551', 'CJXQHYW', '');
INSERT INTO `05diseases` VALUES ('6838', '眶部囊肿', '231', 'H05.801', 'KBNZ', '');
INSERT INTO `05diseases` VALUES ('6839', '眶部粘液囊肿', '231', 'H05.802', 'KBNYNZ', '');
INSERT INTO `05diseases` VALUES ('6840', '眶内上皮样囊肿', '231', 'H05.803', 'KNSPYNZ', '');
INSERT INTO `05diseases` VALUES ('6841', '眼眶假瘤', '430', 'H05.804', 'YKJL', '');
INSERT INTO `05diseases` VALUES ('6842', '眶瘘', '212', 'H05.851', 'KL', '');
INSERT INTO `05diseases` VALUES ('6843', '眶内占位性病变', '268', 'H05.901', 'KNZWXBB', '');
INSERT INTO `05diseases` VALUES ('6844', '眶内肿物', '278', 'H05.902', 'KNZW', '');
INSERT INTO `05diseases` VALUES ('6845', '眼外肌肌病', '430', 'H05.951', 'YWJJB', '');
INSERT INTO `05diseases` VALUES ('6846', '粘液脓性结膜炎', '174', 'H10.051', 'NYNXJMY', '');
INSERT INTO `05diseases` VALUES ('6847', '科克－威克斯结膜炎[急性触染性眼炎]', '430', 'H10.052', 'KKWKSJMYJXCRXYY', '');
INSERT INTO `05diseases` VALUES ('6848', '结膜脓肿', '243', 'H10.053', 'JMNZ', '');
INSERT INTO `05diseases` VALUES ('6849', '变应性结膜炎', '174', 'H10.101', 'BYXJMY', '');
INSERT INTO `05diseases` VALUES ('6850', '春季结膜炎', '174', 'H10.102', 'CJJMY', '');
INSERT INTO `05diseases` VALUES ('6851', '卡他性结膜炎', '174', 'H10.201', 'KTXJMY', '');
INSERT INTO `05diseases` VALUES ('6852', '莫拉－阿克森费尔德结膜炎[双杆菌结膜炎]', '174', 'H10.253', 'MLAKSFEDJMYSGJJMY', '');
INSERT INTO `05diseases` VALUES ('6853', '急性结膜炎 NOS', '174', 'H10.301', 'JXJMY', '');
INSERT INTO `05diseases` VALUES ('6854', '球结膜肉芽肿', '295', 'H10.401', 'QJMRYZ', '');
INSERT INTO `05diseases` VALUES ('6855', '慢性结膜炎', '174', 'H10.402', 'MXJMY', '');
INSERT INTO `05diseases` VALUES ('6856', '结膜肉芽肿', '295', 'H10.451', 'JMRYZ', '');
INSERT INTO `05diseases` VALUES ('6857', '眼眦脓肿', '430', 'H10.501', 'YZNZ', '');
INSERT INTO `05diseases` VALUES ('6858', '睑结膜炎', '174', 'H10.551', 'JJMY', '');
INSERT INTO `05diseases` VALUES ('6859', '感染性结膜炎', '95', 'H10.801', 'GRXJMY', '');
INSERT INTO `05diseases` VALUES ('6860', '结膜溃疡', '195', 'H10.802', 'JMKY', '');
INSERT INTO `05diseases` VALUES ('6861', '帕里诺结膜炎[结膜纤毛菌病]', '174', 'H10.852', 'PLNJMYJMXMJB', '');
INSERT INTO `05diseases` VALUES ('6862', '帕里诺眼腺型综合征', '430', 'H10.853', 'PLNYXXZHZ', '');
INSERT INTO `05diseases` VALUES ('6863', '结膜炎 NOS', '174', 'H10.901', 'JMY', '');
INSERT INTO `05diseases` VALUES ('6864', '细菌性结膜炎', '380', 'H10.902', 'XJXJMY', '');
INSERT INTO `05diseases` VALUES ('6865', '眼炎', '430', 'H10.903', 'YY', '');
INSERT INTO `05diseases` VALUES ('6866', '翼状胬肉', '278', 'H11.001', 'YZNR', '');
INSERT INTO `05diseases` VALUES ('6867', '结膜变性', '173', 'H11.101', 'JMBX', '');
INSERT INTO `05diseases` VALUES ('6868', '睑裂斑', '250', 'H11.102', 'JLB', '');
INSERT INTO `05diseases` VALUES ('6869', '干眼病[结膜干燥]', '430', 'H11.103', 'GYBJMGZ', '');
INSERT INTO `05diseases` VALUES ('6870', '结膜角化', '173', 'H11.105', 'JMJH', '');
INSERT INTO `05diseases` VALUES ('6871', '结膜结石', '173', 'H11.106', 'JMJS', '');
INSERT INTO `05diseases` VALUES ('6872', '结膜黄斑', '250', 'H11.151', 'JMHB', '');
INSERT INTO `05diseases` VALUES ('6873', '结膜黑变病[黑色素沉着病]', '173', 'H11.152', 'JMHBBHSSCZB', '');
INSERT INTO `05diseases` VALUES ('6874', '结膜色素沉着', '173', 'H11.153', 'JMSSCZ', '');
INSERT INTO `05diseases` VALUES ('6875', '睑球粘连', '278', 'H11.201', 'JQNL', '');
INSERT INTO `05diseases` VALUES ('6876', '结膜疤痕', '173', 'H11.202', 'JMBH', '');
INSERT INTO `05diseases` VALUES ('6877', '结膜出血', '173', 'H11.301', 'JMCX', '');
INSERT INTO `05diseases` VALUES ('6878', '结膜囊肿', '231', 'H11.401', 'JMNZ', '');
INSERT INTO `05diseases` VALUES ('6879', '结膜血管增生', '173', 'H11.402', 'JMXGZS', '');
INSERT INTO `05diseases` VALUES ('6880', '结膜水肿', '173', 'H11.451', 'JMSZ', '');
INSERT INTO `05diseases` VALUES ('6881', '眼充血', '430', 'H11.452', 'YCX', '');
INSERT INTO `05diseases` VALUES ('6882', '结膜动脉瘤', '62', 'H11.453', 'JMDML', '');
INSERT INTO `05diseases` VALUES ('6883', '假性翼状胬肉', '278', 'H11.801', 'JXYZNR', '');
INSERT INTO `05diseases` VALUES ('6884', '角结膜增生', '173', 'H11.802', 'JJMZS', '');
INSERT INTO `05diseases` VALUES ('6885', '结膜淋巴管扩张', '173', 'H11.803', 'JMLBGKZ', '');
INSERT INTO `05diseases` VALUES ('6886', '结膜囊畸形', '148', 'H11.804', 'JMNJX', '');
INSERT INTO `05diseases` VALUES ('6887', '结膜囊挛缩', '173', 'H11.805', 'JMNLS', '');
INSERT INTO `05diseases` VALUES ('6888', '结膜囊狭窄', '173', 'H11.806', 'JMNXZ', '');
INSERT INTO `05diseases` VALUES ('6889', '结膜松驰', '173', 'H11.807', 'JMSC', '');
INSERT INTO `05diseases` VALUES ('6890', '结膜息肉', '374', 'H11.808', 'JMXR', '');
INSERT INTO `05diseases` VALUES ('6891', '手术后结膜瘘', '330', 'H11.809', 'SSHJML', '');
INSERT INTO `05diseases` VALUES ('6892', '眼结膜脱垂', '430', 'H11.810', 'YJMTC', '');
INSERT INTO `05diseases` VALUES ('6893', '结膜肿物', '173', 'H11.901', 'JMZW', '');
INSERT INTO `05diseases` VALUES ('6894', '结膜赘生物', '173', 'H11.951', 'JMZSW', '');
INSERT INTO `05diseases` VALUES ('6895', '巩膜溃疡', '195', 'H15.001', 'GMKY', '');
INSERT INTO `05diseases` VALUES ('6896', '巩膜脓肿', '243', 'H15.002', 'GMNZ', '');
INSERT INTO `05diseases` VALUES ('6897', '巩膜炎', '104', 'H15.003', 'GMY', '');
INSERT INTO `05diseases` VALUES ('6898', '后巩膜炎', '104', 'H15.051', 'HGMY', '');
INSERT INTO `05diseases` VALUES ('6899', '巩膜结膜炎', '174', 'H15.052', 'GMJMY', '');
INSERT INTO `05diseases` VALUES ('6900', '巩膜球筋膜炎', '277', 'H15.053', 'GMQJMY', '');
INSERT INTO `05diseases` VALUES ('6901', '坏死性巩膜炎', '104', 'H15.054', 'HSXGMY', '');
INSERT INTO `05diseases` VALUES ('6902', '肉芽肿性巩膜炎', '295', 'H15.055', 'RYZXGMY', '');
INSERT INTO `05diseases` VALUES ('6903', '化脓性巩膜炎', '104', 'H15.056', 'HNXGMY', '');
INSERT INTO `05diseases` VALUES ('6904', '上巩膜炎[巩膜外层炎]', '104', 'H15.151', 'SGMYGMWCY', '');
INSERT INTO `05diseases` VALUES ('6905', '化脓性上巩膜炎', '104', 'H15.152', 'HNXSGMY', '');
INSERT INTO `05diseases` VALUES ('6906', '巩膜黑变病[黑色素沉着病]', '268', 'H15.801', 'GMHBBHSSCZB', '');
INSERT INTO `05diseases` VALUES ('6907', '巩膜葡萄肿(前)(后)(睫状体)', '278', 'H15.802', 'GMPTZQHJZT', '');
INSERT INTO `05diseases` VALUES ('6908', '巩膜肉芽肿', '295', 'H15.803', 'GMRYZ', '');
INSERT INTO `05diseases` VALUES ('6909', '巩膜粘连', '278', 'H15.804', 'GMNL', '');
INSERT INTO `05diseases` VALUES ('6910', '睫状体巩膜葡萄肿', '278', 'H15.805', 'JZTGMPTZ', '');
INSERT INTO `05diseases` VALUES ('6911', '穿孔性巩膜软化症', '278', 'H15.851', 'CKXGMRHZ', '');
INSERT INTO `05diseases` VALUES ('6912', '巩膜坏死', '278', 'H15.852', 'GMHS', '');
INSERT INTO `05diseases` VALUES ('6913', '巩膜膨出', '278', 'H15.853', 'GMPC', '');
INSERT INTO `05diseases` VALUES ('6914', '巩膜疾患 NOS', '278', 'H15.951', 'GMJH', '');
INSERT INTO `05diseases` VALUES ('6915', '病毒性角膜溃疡', '195', 'H16.001', 'BDXJMKY', '');
INSERT INTO `05diseases` VALUES ('6916', '角膜穿孔', '166', 'H16.002', 'JMCK', '');
INSERT INTO `05diseases` VALUES ('6917', '角膜溃疡', '195', 'H16.003', 'JMKY', '');
INSERT INTO `05diseases` VALUES ('6918', '前房积脓性角膜溃疡', '195', 'H16.004', 'QFJNXJMKY', '');
INSERT INTO `05diseases` VALUES ('6919', '眼角膜溃疡穿孔', '430', 'H16.005', 'YJMKYCK', '');
INSERT INTO `05diseases` VALUES ('6920', '周边性角膜溃疡', '195', 'H16.051', 'ZBXJMKY', '');
INSERT INTO `05diseases` VALUES ('6921', '中心性角膜溃疡', '195', 'H16.052', 'ZXXJMKY', '');
INSERT INTO `05diseases` VALUES ('6922', '角膜溃疡伴前房积脓性', '195', 'H16.053', 'JMKYBQFJNX', '');
INSERT INTO `05diseases` VALUES ('6923', '环形性角膜溃疡', '195', 'H16.054', 'HXXJMKY', '');
INSERT INTO `05diseases` VALUES ('6924', '角膜炎伴角膜溃疡', '167', 'H16.055', 'JMYBJMKY', '');
INSERT INTO `05diseases` VALUES ('6925', '电光性眼炎', '430', 'H16.101', 'DGXYY', '');
INSERT INTO `05diseases` VALUES ('6926', '浅层点状角膜炎', '167', 'H16.102', 'QCDZJMY', '');
INSERT INTO `05diseases` VALUES ('6927', '光性角膜炎', '167', 'H16.151', 'GXJMY', '');
INSERT INTO `05diseases` VALUES ('6928', '丝状角膜炎', '167', 'H16.152', 'SZJMY', '');
INSERT INTO `05diseases` VALUES ('6929', '晕性角膜炎', '167', 'H16.153', 'YXJMY', '');
INSERT INTO `05diseases` VALUES ('6930', '日光性眼炎[雪盲]', '430', 'H16.154', 'RGXYYXM', '');
INSERT INTO `05diseases` VALUES ('6931', '光化性眼炎', '430', 'H16.155', 'GHXYY', '');
INSERT INTO `05diseases` VALUES ('6932', '暴露性角膜结膜炎', '174', 'H16.201', 'BLXJMJMY', '');
INSERT INTO `05diseases` VALUES ('6933', '小泡性角膜结膜炎', '174', 'H16.202', 'XPXJMJMY', '');
INSERT INTO `05diseases` VALUES ('6934', '结节性眼炎', '430', 'H16.251', 'JJXYY', '');
INSERT INTO `05diseases` VALUES ('6935', '角膜结膜炎', '174', 'H16.252', 'JMJMY', '');
INSERT INTO `05diseases` VALUES ('6936', '神经营养性角膜结膜炎', '313', 'H16.253', 'SJYYXJMJMY', '');
INSERT INTO `05diseases` VALUES ('6937', '科根氏综合征(间质性角膜炎综合征)', '167', 'H16.301', 'KGSZHZJZXJMYZHZ', '');
INSERT INTO `05diseases` VALUES ('6938', '角膜脓肿', '243', 'H16.302', 'JMNZ', '');
INSERT INTO `05diseases` VALUES ('6939', '实质性角膜炎', '167', 'H16.303', 'SZXJMY', '');
INSERT INTO `05diseases` VALUES ('6940', '硬化性角膜炎', '167', 'H16.304', 'YHXJMY', '');
INSERT INTO `05diseases` VALUES ('6941', '间质性角膜炎', '167', 'H16.351', 'JZXJMY', '');
INSERT INTO `05diseases` VALUES ('6942', '角膜血管翳', '166', 'H16.401', 'JMXGY', '');
INSERT INTO `05diseases` VALUES ('6943', '大泡性角膜炎', '167', 'H16.803', 'DPXJMY', '');
INSERT INTO `05diseases` VALUES ('6944', '疫苗接种角膜炎', '167', 'H16.804', 'YMJZJMY', '');
INSERT INTO `05diseases` VALUES ('6945', '大疱性角膜结膜炎', '174', 'H16.805', 'DPXJMJMY', '');
INSERT INTO `05diseases` VALUES ('6946', '粘连性角膜炎', '167', 'H16.806', 'NLXJMY', '');
INSERT INTO `05diseases` VALUES ('6947', '反应性角膜炎', '167', 'H16.807', 'FYXJMY', '');
INSERT INTO `05diseases` VALUES ('6948', '真菌性角膜炎', '464', 'H16.808', 'ZJXJMY', '');
INSERT INTO `05diseases` VALUES ('6949', '化脓性角膜炎', '167', 'H16.809', 'HNXJMY', '');
INSERT INTO `05diseases` VALUES ('6950', '神经麻痹性角膜炎', '313', 'H16.810', 'SJMBXJMY', '');
INSERT INTO `05diseases` VALUES ('6951', '束状角膜炎', '167', 'H16.811', 'SZJMY', '');
INSERT INTO `05diseases` VALUES ('6952', '干燥性角膜炎', '167', 'H16.851', 'GZXJMY', '');
INSERT INTO `05diseases` VALUES ('6953', '石化性角膜炎', '167', 'H16.852', 'SHXJMY', '');
INSERT INTO `05diseases` VALUES ('6954', '小泡性角膜炎', '167', 'H16.853', 'XPXJMY', '');
INSERT INTO `05diseases` VALUES ('6955', '巩膜角膜炎', '167', 'H16.854', 'GMJMY', '');
INSERT INTO `05diseases` VALUES ('6956', '角膜炎', '167', 'H16.901', 'JMY', '');
INSERT INTO `05diseases` VALUES ('6957', '卡他性角膜炎', '167', 'H16.951', 'KTXJMY', '');
INSERT INTO `05diseases` VALUES ('6958', '细菌性角膜炎', '380', 'H16.952', 'XJXJMY', '');
INSERT INTO `05diseases` VALUES ('6959', '角膜粘连性白斑', '250', 'H17.001', 'JMNLXBB', '');
INSERT INTO `05diseases` VALUES ('6960', '中心性角膜混浊', '166', 'H17.151', 'ZXXJMHZ', '');
INSERT INTO `05diseases` VALUES ('6961', '角膜白斑', '250', 'H17.801', 'JMBB', '');
INSERT INTO `05diseases` VALUES ('6962', '角膜斑翳(薄翳)[角膜翳]', '250', 'H17.802', 'JMBYBYJMY', '');
INSERT INTO `05diseases` VALUES ('6963', '角膜云翳', '166', 'H17.803', 'JMYY', '');
INSERT INTO `05diseases` VALUES ('6964', '干眼性角膜瘢痕', '430', 'H17.851', 'GYXJMBH', '');
INSERT INTO `05diseases` VALUES ('6965', '角膜瘢痕', '166', 'H17.901', 'JMBH', '');
INSERT INTO `05diseases` VALUES ('6966', '角膜混浊 NOS', '166', 'H17.902', 'JMHZ', '');
INSERT INTO `05diseases` VALUES ('6967', '角膜黑变病(早老性)(老年性)[黑色素沉着]', '166', 'H18.002', 'JMHBBZLXLNXHSSCZ', '');
INSERT INTO `05diseases` VALUES ('6968', '角膜血染', '166', 'H18.003', 'JMXR', '');
INSERT INTO `05diseases` VALUES ('6969', '角膜色素沉着物', '166', 'H18.051', 'JMSSCZW', '');
INSERT INTO `05diseases` VALUES ('6970', '凯泽－弗莱舍尔环(角膜)', '166', 'H18.052', 'KZFLSEHJM', '');
INSERT INTO `05diseases` VALUES ('6971', '克鲁肯贝格梭', '278', 'H18.053', 'KLKBGS', '');
INSERT INTO `05diseases` VALUES ('6972', '施特里线[角膜色素线]', '166', 'H18.054', 'STLXJMSSX', '');
INSERT INTO `05diseases` VALUES ('6973', '角膜积血', '166', 'H18.055', 'JMJX', '');
INSERT INTO `05diseases` VALUES ('6974', '角膜血沉着', '166', 'H18.056', 'JMXCZ', '');
INSERT INTO `05diseases` VALUES ('6975', '大泡性角膜病', '166', 'H18.101', 'DPXJMB', '');
INSERT INTO `05diseases` VALUES ('6976', '角膜水肿', '166', 'H18.201', 'JMSZ', '');
INSERT INTO `05diseases` VALUES ('6977', '特塞梅特膜破裂', '278', 'H18.351', 'TSMTMPL', '');
INSERT INTO `05diseases` VALUES ('6978', '特塞梅特膜绉折', '278', 'H18.352', 'TSMTMZZ', '');
INSERT INTO `05diseases` VALUES ('6979', '角膜变性', '166', 'H18.401', 'JMBX', '');
INSERT INTO `05diseases` VALUES ('6980', '角膜带状变性', '166', 'H18.402', 'JMDZBX', '');
INSERT INTO `05diseases` VALUES ('6981', '角膜角化病', '166', 'H18.403', 'JMJHB', '');
INSERT INTO `05diseases` VALUES ('6982', '角膜软化', '166', 'H18.404', 'JMRH', '');
INSERT INTO `05diseases` VALUES ('6983', '老年环', '278', 'H18.405', 'LNH', '');
INSERT INTO `05diseases` VALUES ('6984', '变性性角膜混浊', '166', 'H18.451', 'BXXJMHZ', '');
INSERT INTO `05diseases` VALUES ('6985', '哈索尔-亨利小体或疣(角膜的)', '453', 'H18.452', 'HSEHLXTHYJMD', '');
INSERT INTO `05diseases` VALUES ('6986', '带状角膜病', '166', 'H18.453', 'DZJMB', '');
INSERT INTO `05diseases` VALUES ('6987', '家族性遗传性角膜变性', '166', 'H18.501', 'JZXYCXJMBX', '');
INSERT INTO `05diseases` VALUES ('6988', '角膜营养不良', '448', 'H18.502', 'JMYYBL', '');
INSERT INTO `05diseases` VALUES ('6989', '富克斯营养不良', '448', 'H18.551', 'FKSYYBL', '');
INSERT INTO `05diseases` VALUES ('6990', '遗传性角膜营养不良', '448', 'H18.552', 'YCXJMYYBL', '');
INSERT INTO `05diseases` VALUES ('6991', '皮性角膜营养不良', '448', 'H18.553', 'PXJMYYBL', '');
INSERT INTO `05diseases` VALUES ('6992', '富克斯氏综合征[富克斯氏异色性睫状体炎]', '277', 'H18.554', 'FKSSZHZFKSSYSXJZTY', '');
INSERT INTO `05diseases` VALUES ('6993', '圆锥形角膜', '166', 'H18.601', 'YZXJM', '');
INSERT INTO `05diseases` VALUES ('6994', '角膜后弹力层膨出', '166', 'H18.701', 'JMHDLCPC', '');
INSERT INTO `05diseases` VALUES ('6995', '角膜葡萄肿', '166', 'H18.702', 'JMPTZ', '');
INSERT INTO `05diseases` VALUES ('6996', '球形角膜', '166', 'H18.703', 'QXJM', '');
INSERT INTO `05diseases` VALUES ('6997', '角膜突出', '166', 'H18.751', 'JMTC', '');
INSERT INTO `05diseases` VALUES ('6998', '角膜扩张', '166', 'H18.752', 'JMKZ', '');
INSERT INTO `05diseases` VALUES ('6999', '角膜干燥症', '166', 'H18.801', 'JMGZZ', '');
INSERT INTO `05diseases` VALUES ('7000', '角膜内皮失代偿', '166', 'H18.802', 'JMNPSDC', '');
INSERT INTO `05diseases` VALUES ('7001', '角膜皮赘', '166', 'H18.804', 'JMPZ', '');
INSERT INTO `05diseases` VALUES ('7002', '角膜切口瘘', '212', 'H18.805', 'JMQKL', '');
INSERT INTO `05diseases` VALUES ('7003', '角膜上皮脱落', '166', 'H18.806', 'JMSPTL', '');
INSERT INTO `05diseases` VALUES ('7004', '角膜炎性肿物', '167', 'H18.807', 'JMYXZW', '');
INSERT INTO `05diseases` VALUES ('7005', '复发性角膜糜烂', '166', 'H18.851', 'FFXJMML', '');
INSERT INTO `05diseases` VALUES ('7006', '角膜感觉减退', '166', 'H18.852', 'JMGJJT', '');
INSERT INTO `05diseases` VALUES ('7007', '角膜感觉缺失', '166', 'H18.853', 'JMGJQS', '');
INSERT INTO `05diseases` VALUES ('7008', '虹膜角膜内皮综合征', '166', 'H18.854', 'HMJMNPZHZ', '');
INSERT INTO `05diseases` VALUES ('7009', '陈旧性角膜炎', '167', 'H18.901', 'CJXJMY', '');
INSERT INTO `05diseases` VALUES ('7010', '角膜疾患 NOS', '166', 'H18.951', 'JMJH', '');
INSERT INTO `05diseases` VALUES ('7011', '创伤性虹膜睫状体炎', '229', 'H20.001', 'CSXHMJZTY', '');
INSERT INTO `05diseases` VALUES ('7012', '复发性虹膜睫状体炎', '229', 'H20.002', 'FFXHMJZTY', '');
INSERT INTO `05diseases` VALUES ('7013', '前房积脓', '278', 'H20.003', 'QFJN', '');
INSERT INTO `05diseases` VALUES ('7014', '急性虹膜睫状体炎', '229', 'H20.004', 'JXHMJZTY', '');
INSERT INTO `05diseases` VALUES ('7015', '前房积脓性虹膜睫状体炎', '229', 'H20.005', 'QFJNXHMJZTY', '');
INSERT INTO `05diseases` VALUES ('7016', '亚急性虹膜睫状体炎', '229', 'H20.051', 'YJXHMJZTY', '');
INSERT INTO `05diseases` VALUES ('7017', '内源性虹膜睫状体炎', '229', 'H20.052', 'NYXHMJZTY', '');
INSERT INTO `05diseases` VALUES ('7018', '变态反应性虹膜睫状体炎', '229', 'H20.053', 'BTFYXHMJZTY', '');
INSERT INTO `05diseases` VALUES ('7019', '非肉芽肿性虹膜睫状体炎', '229', 'H20.054', 'FRYZXHMJZTY', '');
INSERT INTO `05diseases` VALUES ('7020', '复发性葡萄膜炎', '277', 'H20.055', 'FFXPTMY', '');
INSERT INTO `05diseases` VALUES ('7021', '慢性虹膜睫状体炎', '229', 'H20.101', 'MXHMJZTY', '');
INSERT INTO `05diseases` VALUES ('7022', '慢性眼色素膜炎[慢性葡萄膜炎])', '430', 'H20.103', 'MXYSSMYMXPTMY', '');
INSERT INTO `05diseases` VALUES ('7023', '肉芽肿性色素膜炎', '295', 'H20.104', 'RYZXSSMY', '');
INSERT INTO `05diseases` VALUES ('7024', '肉芽肿性虹膜睫状体炎', '229', 'H20.151', 'RYZXHMJZTY', '');
INSERT INTO `05diseases` VALUES ('7025', '晶体诱发性眼色素膜炎', '430', 'H20.201', 'JTYFXYSSMY', '');
INSERT INTO `05diseases` VALUES ('7026', '晶体诱发性虹膜睫状体炎', '229', 'H20.251', 'JTYFXHMJZTY', '');
INSERT INTO `05diseases` VALUES ('7027', '虹膜脓肿', '243', 'H20.801', 'HMNZ', '');
INSERT INTO `05diseases` VALUES ('7028', '眼色素层脑膜炎[福格特－小柳综合征]', '430', 'H20.803', 'YSSCNMYFGTXLZHZ', '');
INSERT INTO `05diseases` VALUES ('7029', '全色素膜炎', '277', 'H20.804', 'QSSMY', '');
INSERT INTO `05diseases` VALUES ('7030', '眼坏死型色素膜炎', '430', 'H20.805', 'YHSXSSMY', '');
INSERT INTO `05diseases` VALUES ('7031', '异色性虹膜炎', '277', 'H20.806', 'YSXHMY', '');
INSERT INTO `05diseases` VALUES ('7032', '单纯性虹膜异色症', '132', 'H20.851', 'DCXHMYSZ', '');
INSERT INTO `05diseases` VALUES ('7033', '葡萄膜炎异色', '277', 'H20.852', 'PTMYYS', '');
INSERT INTO `05diseases` VALUES ('7034', '葡萄膜大脑炎', '234', 'H20.853', 'PTMDNY', '');
INSERT INTO `05diseases` VALUES ('7035', '虹膜睫状体炎 NOS', '229', 'H20.901', 'HMJZTY', '');
INSERT INTO `05diseases` VALUES ('7036', '继发性虹膜炎', '277', 'H20.903', 'JFXHMY', '');
INSERT INTO `05diseases` VALUES ('7037', '眼色素膜炎[葡萄膜炎]', '430', 'H20.904', 'YSSMYPTMY', '');
INSERT INTO `05diseases` VALUES ('7038', '角膜葡萄膜炎', '166', 'H20.951', 'JMPTMY', '');
INSERT INTO `05diseases` VALUES ('7039', '虹膜出血', '38', 'H21.001', 'HMCX', '');
INSERT INTO `05diseases` VALUES ('7040', '眼前房出血', '430', 'H21.002', 'YQFCX', '');
INSERT INTO `05diseases` VALUES ('7041', '虹膜新生血管形成', '413', 'H21.101', 'HMXSXGXC', '');
INSERT INTO `05diseases` VALUES ('7042', '虹膜红变', '132', 'H21.102', 'HMHB', '');
INSERT INTO `05diseases` VALUES ('7043', '虹膜或睫状体新血管形成', '413', 'H21.151', 'HMHJZTXXGXC', '');
INSERT INTO `05diseases` VALUES ('7044', '虹膜变性', '132', 'H21.201', 'HMBX', '');
INSERT INTO `05diseases` VALUES ('7045', '虹膜缺损', '132', 'H21.202', 'HMQS', '');
INSERT INTO `05diseases` VALUES ('7046', '虹膜萎缩(特发性)(进行性)', '132', 'H21.203', 'HMWSTFXJXX', '');
INSERT INTO `05diseases` VALUES ('7047', '虹膜色素性变性', '132', 'H21.251', 'HMSSXBX', '');
INSERT INTO `05diseases` VALUES ('7048', '半透明虹膜', '132', 'H21.252', 'BTMHM', '');
INSERT INTO `05diseases` VALUES ('7049', '瞳孔缘变性', '354', 'H21.253', 'TKYBX', '');
INSERT INTO `05diseases` VALUES ('7050', '缩瞳性瞳孔囊肿', '231', 'H21.254', 'STXTKNZ', '');
INSERT INTO `05diseases` VALUES ('7051', '虹膜壁裂症', '132', 'H21.255', 'HMBLZ', '');
INSERT INTO `05diseases` VALUES ('7052', '虹膜囊肿(渗出性)(植入性)(寄生虫)', '156', 'H21.301', 'HMNZSCXZRXJSC', '');
INSERT INTO `05diseases` VALUES ('7053', '睫状体囊肿(渗出性)(植入性)(寄生虫)', '156', 'H21.351', 'JZTNZSCXZRXJSC', '');
INSERT INTO `05diseases` VALUES ('7054', '前房囊肿(眼)(渗出性)(植入性)(寄生虫)', '430', 'H21.352', 'QFNZYSCXZRXJSC', '');
INSERT INTO `05diseases` VALUES ('7055', '瞳孔膜闭', '354', 'H21.401', 'TKMB', '');
INSERT INTO `05diseases` VALUES ('7056', '虹膜膨隆', '132', 'H21.451', 'HMPL', '');
INSERT INTO `05diseases` VALUES ('7057', '瞳孔闭锁', '354', 'H21.452', 'TKBS', '');
INSERT INTO `05diseases` VALUES ('7058', '陈旧性虹膜睫状体炎', '229', 'H21.501', 'CJXHMJZTY', '');
INSERT INTO `05diseases` VALUES ('7059', '陈旧性眼色素膜炎[陈旧性葡萄膜炎]', '430', 'H21.502', 'CJXYSSMYCJXPTMY', '');
INSERT INTO `05diseases` VALUES ('7060', '虹膜离断', '132', 'H21.503', 'HMLD', '');
INSERT INTO `05diseases` VALUES ('7061', '虹膜粘连', '132', 'H21.505', 'HMNL', '');
INSERT INTO `05diseases` VALUES ('7062', '前房后退[房角后退]', '278', 'H21.506', 'QFHTFJHT', '');
INSERT INTO `05diseases` VALUES ('7063', '前房角破裂', '278', 'H21.507', 'QFJPL', '');
INSERT INTO `05diseases` VALUES ('7064', '瞳孔后粘连', '354', 'H21.508', 'TKHNL', '');
INSERT INTO `05diseases` VALUES ('7065', '瞳孔移位', '354', 'H21.509', 'TKYW', '');
INSERT INTO `05diseases` VALUES ('7066', '瞳孔异位', '354', 'H21.551', 'TKYW', '');
INSERT INTO `05diseases` VALUES ('7067', '前房角粘连', '278', 'H21.552', 'QFJNL', '');
INSERT INTO `05diseases` VALUES ('7068', '虹膜破裂 NEC', '132', 'H21.553', 'HMPL', '');
INSERT INTO `05diseases` VALUES ('7069', '虹膜突出', '132', 'H21.802', 'HMTC', '');
INSERT INTO `05diseases` VALUES ('7070', '睫状体脱离', '278', 'H21.803', 'JZTTL', '');
INSERT INTO `05diseases` VALUES ('7071', '非创伤性虹膜脱垂', '44', 'H21.851', 'FCSXHMTC', '');
INSERT INTO `05diseases` VALUES ('7072', '虹膜震颤[虹膜震荡]', '132', 'H21.852', 'HMZCHMZD', '');
INSERT INTO `05diseases` VALUES ('7073', '虹膜和睫状体疾患 NOS', '132', 'H21.951', 'HMHJZTJH', '');
INSERT INTO `05diseases` VALUES ('7074', '老年性白内障未熟期', '4', 'H25.001', 'LNXBNZWSQ', '');
INSERT INTO `05diseases` VALUES ('7075', '前极白内障', '4', 'H25.002', 'QJBNZ', '');
INSERT INTO `05diseases` VALUES ('7076', '老年性初期白内障', '4', 'H25.051', 'LNXCQBNZ', '');
INSERT INTO `05diseases` VALUES ('7077', '老年性点状白内障', '4', 'H25.052', 'LNXDZBNZ', '');
INSERT INTO `05diseases` VALUES ('7078', '老年性皮质(软性)白内障', '4', 'H25.053', 'LNXPZRXBNZ', '');
INSERT INTO `05diseases` VALUES ('7079', '老年性花冠状白内障', '4', 'H25.054', 'LNXHGZBNZ', '');
INSERT INTO `05diseases` VALUES ('7080', '核性(硬化)白内障', '4', 'H25.101', 'HXYHBNZ', '');
INSERT INTO `05diseases` VALUES ('7081', '老年性核性(硬性)白内障', '4', 'H25.151', 'LNXHXYXBNZ', '');
INSERT INTO `05diseases` VALUES ('7082', '老年性过熟期白内障', '4', 'H25.251', 'LNXGSQBNZ', '');
INSERT INTO `05diseases` VALUES ('7083', '老年性莫加尼型白内障', '4', 'H25.252', 'LNXMJNXBNZ', '');
INSERT INTO `05diseases` VALUES ('7084', '老年性环状白内障', '4', 'H25.851', 'LNXHZBNZ', '');
INSERT INTO `05diseases` VALUES ('7085', '老年性混合型白内障', '4', 'H25.852', 'LNXHHXBNZ', '');
INSERT INTO `05diseases` VALUES ('7086', '老年性白内障 NOS', '4', 'H25.901', 'LNXBNZ', '');
INSERT INTO `05diseases` VALUES ('7087', '老年前期白内障', '4', 'H26.001', 'LNQQBNZ', '');
INSERT INTO `05diseases` VALUES ('7088', '青年期白内障', '4', 'H26.002', 'QNQBNZ', '');
INSERT INTO `05diseases` VALUES ('7089', '幼年期白内障', '4', 'H26.003', 'YNQBNZ', '');
INSERT INTO `05diseases` VALUES ('7090', '婴儿白内障', '4', 'H26.051', 'YEBNZ', '');
INSERT INTO `05diseases` VALUES ('7091', '创伤性白内障', '4', 'H26.101', 'CSXBNZ', '');
INSERT INTO `05diseases` VALUES ('7092', '晶体后囊膜破裂', '278', 'H26.102', 'JTHNMPL', '');
INSERT INTO `05diseases` VALUES ('7093', '并发性白内障', '4', 'H26.201', 'BFXBNZ', '');
INSERT INTO `05diseases` VALUES ('7094', '虹膜异色性白内障', '4', 'H26.202', 'HMYSXBNZ', '');
INSERT INTO `05diseases` VALUES ('7095', '青光眼性白内障', '430', 'H26.203', 'QGYXBNZ', '');
INSERT INTO `05diseases` VALUES ('7096', '变性并发性白内障', '4', 'H26.251', 'BXBFXBNZ', '');
INSERT INTO `05diseases` VALUES ('7097', '眼病白内障', '430', 'H26.252', 'YBBNZ', '');
INSERT INTO `05diseases` VALUES ('7098', '慢性虹膜睫状体炎白内障', '229', 'H26.253', 'MXHMJZTYBNZ', '');
INSERT INTO `05diseases` VALUES ('7099', '激素性白内障', '4', 'H26.301', 'JSXBNZ', '');
INSERT INTO `05diseases` VALUES ('7100', '中毒性白内障', '471', 'H26.302', 'ZDXBNZ', '');
INSERT INTO `05diseases` VALUES ('7101', '药物性白内障', '4', 'H26.351', 'YWXBNZ', '');
INSERT INTO `05diseases` VALUES ('7102', '后发性白内障', '4', 'H26.401', 'HFXBNZ', '');
INSERT INTO `05diseases` VALUES ('7103', '继发性白内障', '4', 'H26.402', 'JFXBNZ', '');
INSERT INTO `05diseases` VALUES ('7104', '膜性白内障', '4', 'H26.403', 'MXBNZ', '');
INSERT INTO `05diseases` VALUES ('7105', '泽默林环', '278', 'H26.451', 'ZMLH', '');
INSERT INTO `05diseases` VALUES ('7106', '混合性白内障', '4', 'H26.801', 'HHXBNZ', '');
INSERT INTO `05diseases` VALUES ('7107', '电击性白内障', '4', 'H26.851', 'DJXBNZ', '');
INSERT INTO `05diseases` VALUES ('7108', '辐射性白内障', '4', 'H26.852', 'FSXBNZ', '');
INSERT INTO `05diseases` VALUES ('7109', '玻璃工人的白内障', '4', 'H26.853', 'BLGRDBNZ', '');
INSERT INTO `05diseases` VALUES ('7110', '白内障 NOS', '4', 'H26.901', 'BNZ', '');
INSERT INTO `05diseases` VALUES ('7111', '后天性白内障', '4', 'H26.902', 'HTXBNZ', '');
INSERT INTO `05diseases` VALUES ('7112', '晶体混浊', '278', 'H26.903', 'JTHZ', '');
INSERT INTO `05diseases` VALUES ('7113', '手术后无晶体', '330', 'H27.001', 'SSHWJT', '');
INSERT INTO `05diseases` VALUES ('7114', '后天性无晶体', '278', 'H27.002', 'HTXWJT', '');
INSERT INTO `05diseases` VALUES ('7115', '晶状体缺失(后天性)', '278', 'H27.003', 'JZTQSHTX', '');
INSERT INTO `05diseases` VALUES ('7116', '陈旧性晶状体脱位', '365', 'H27.151', 'CJXJZTTW', '');
INSERT INTO `05diseases` VALUES ('7117', '自发性晶状体脱位', '365', 'H27.152', 'ZFXJZTTW', '');
INSERT INTO `05diseases` VALUES ('7118', '其他特指的晶状体疾患', '278', 'H27.851', 'QTTZDJZTJH', '');
INSERT INTO `05diseases` VALUES ('7119', '晶状体疾患 NOS', '278', 'H27.951', 'JZTJH', '');
INSERT INTO `05diseases` VALUES ('7120', '近乳头性脉络膜视网膜炎', '86', 'H30.001', 'JRTXMLMSWMY', '');
INSERT INTO `05diseases` VALUES ('7121', '渗出性脉络膜炎', '221', 'H30.002', 'SCXMLMY', '');
INSERT INTO `05diseases` VALUES ('7122', '近视性脉络膜视网膜炎[詹森病]', '327', 'H30.051', 'JSXMLMSWMYZSB', '');
INSERT INTO `05diseases` VALUES ('7123', '局灶性脉络膜视网膜炎', '327', 'H30.052', 'JZXMLMSWMY', '');
INSERT INTO `05diseases` VALUES ('7124', '中心性脉络膜视网膜炎', '327', 'H30.053', 'ZXXMLMSWMY', '');
INSERT INTO `05diseases` VALUES ('7125', '播散性脉络膜视网膜炎', '327', 'H30.101', 'BSXMLMSWMY', '');
INSERT INTO `05diseases` VALUES ('7126', '后睫状体炎', '277', 'H30.251', 'HJZTY', '');
INSERT INTO `05diseases` VALUES ('7127', '睫状体平部炎', '277', 'H30.252', 'JZTPBY', '');
INSERT INTO `05diseases` VALUES ('7128', '原田氏综合征或综合征', '278', 'H30.801', 'YTSZHZHZHZ', '');
INSERT INTO `05diseases` VALUES ('7129', '陈旧性脉络膜视网膜炎', '327', 'H30.901', 'CJXMLMSWMY', '');
INSERT INTO `05diseases` VALUES ('7130', '结节性脉络膜炎', '221', 'H30.902', 'JJXMLMY', '');
INSERT INTO `05diseases` VALUES ('7131', '视神经视网膜炎', '313', 'H30.903', 'SSJSWMY', '');
INSERT INTO `05diseases` VALUES ('7132', '脉络膜视网膜炎 NOS', '327', 'H30.951', 'MLMSWMY', '');
INSERT INTO `05diseases` VALUES ('7133', '视网膜瘢痕', '326', 'H31.001', 'SWMBH', '');
INSERT INTO `05diseases` VALUES ('7134', '后极部黄斑瘢痕(炎症后)(外伤后)', '250', 'H31.051', 'HJBHBBHYZHWSH', '');
INSERT INTO `05diseases` VALUES ('7135', '日光性视网膜病', '326', 'H31.052', 'RGXSWMB', '');
INSERT INTO `05diseases` VALUES ('7136', '脉络膜萎缩', '278', 'H31.101', 'MLMWS', '');
INSERT INTO `05diseases` VALUES ('7137', '脉络膜硬化', '278', 'H31.102', 'MLMYH', '');
INSERT INTO `05diseases` VALUES ('7138', '出血性脉络膜硬化', '38', 'H31.151', 'CXXMLMYH', '');
INSERT INTO `05diseases` VALUES ('7139', '遗传性脉络膜营养障碍', '449', 'H31.251', 'YCXMLMYYZA', '');
INSERT INTO `05diseases` VALUES ('7140', '无脉络膜', '278', 'H31.252', 'WMLM', '');
INSERT INTO `05diseases` VALUES ('7141', '脉络膜出血', '38', 'H31.301', 'MLMCX', '');
INSERT INTO `05diseases` VALUES ('7142', '脉络膜破裂', '278', 'H31.302', 'MLMPL', '');
INSERT INTO `05diseases` VALUES ('7143', '逼出性脉络膜出血', '38', 'H31.351', 'BCXMLMCX', '');
INSERT INTO `05diseases` VALUES ('7144', '出血性脉络膜脱离', '38', 'H31.401', 'CXXMLMTL', '');
INSERT INTO `05diseases` VALUES ('7145', '创伤性脉络膜脱离', '44', 'H31.402', 'CSXMLMTL', '');
INSERT INTO `05diseases` VALUES ('7146', '化脓性脉络膜脱离', '278', 'H31.403', 'HNXMLMTL', '');
INSERT INTO `05diseases` VALUES ('7147', '脉络膜脱离', '278', 'H31.404', 'MLMTL', '');
INSERT INTO `05diseases` VALUES ('7148', '渗出性脉络膜脱离', '278', 'H31.405', 'SCXMLMTL', '');
INSERT INTO `05diseases` VALUES ('7149', '手术后脉络膜脱离', '330', 'H31.406', 'SSHMLMTL', '');
INSERT INTO `05diseases` VALUES ('7150', '脉络膜缺血', '275', 'H31.801', 'MLMQX', '');
INSERT INTO `05diseases` VALUES ('7151', '脉络膜渗出', '278', 'H31.802', 'MLMSC', '');
INSERT INTO `05diseases` VALUES ('7152', '巩膜脉络膜炎', '221', 'H31.851', 'GMMLMY', '');
INSERT INTO `05diseases` VALUES ('7153', '脉络膜占位性病变', '268', 'H31.901', 'MLMZWXBB', '');
INSERT INTO `05diseases` VALUES ('7154', '脉络膜病 NOS', '268', 'H31.951', 'MLMB', '');
INSERT INTO `05diseases` VALUES ('7155', '锯齿缘离断', '278', 'H33.001', 'JCYLD', '');
INSERT INTO `05diseases` VALUES ('7156', '孔源性视网膜脱离', '326', 'H33.002', 'KYXSWMTL', '');
INSERT INTO `05diseases` VALUES ('7157', '视网膜锯齿缘断离', '326', 'H33.051', 'SWMJCYDL', '');
INSERT INTO `05diseases` VALUES ('7158', '视网膜剥离', '326', 'H33.052', 'SWMBL', '');
INSERT INTO `05diseases` VALUES ('7159', '视网膜囊肿', '231', 'H33.101', 'SWMNZ', '');
INSERT INTO `05diseases` VALUES ('7160', '视网膜劈裂(症)', '326', 'H33.102', 'SWMPLZ', '');
INSERT INTO `05diseases` VALUES ('7161', '视网膜假囊肿', '231', 'H33.151', 'SWMJNZ', '');
INSERT INTO `05diseases` VALUES ('7162', '视网膜(寄生虫型)囊肿', '156', 'H33.152', 'SWMJSCXNZ', '');
INSERT INTO `05diseases` VALUES ('7163', '锯齿缘囊肿', '231', 'H33.153', 'JCYNZ', '');
INSERT INTO `05diseases` VALUES ('7164', '陈旧性视网膜脱离', '326', 'H33.201', 'CJXSWMTL', '');
INSERT INTO `05diseases` VALUES ('7165', '视网膜脱离 NOS', '326', 'H33.202', 'SWMTL', '');
INSERT INTO `05diseases` VALUES ('7166', '浆液性视网膜脱离', '326', 'H33.203', 'JYXSWMTL', '');
INSERT INTO `05diseases` VALUES ('7167', '视网膜脱离不伴有视网膜断裂', '326', 'H33.251', 'SWMTLBBYSWMDL', '');
INSERT INTO `05diseases` VALUES ('7168', '视网膜缺损', '326', 'H33.301', 'SWMQS', '');
INSERT INTO `05diseases` VALUES ('7169', '创伤性视网膜裂孔', '44', 'H33.302', 'CSXSWMLK', '');
INSERT INTO `05diseases` VALUES ('7170', '视网膜断裂(不伴有脱离)', '326', 'H33.303', 'SWMDLBBYTL', '');
INSERT INTO `05diseases` VALUES ('7171', '视网膜破裂', '326', 'H33.304', 'SWMPL', '');
INSERT INTO `05diseases` VALUES ('7172', '视网膜撕裂', '326', 'H33.305', 'SWMSL', '');
INSERT INTO `05diseases` VALUES ('7173', '视网膜圆形缺损不伴视网膜脱离', '326', 'H33.352', 'SWMYXQSBBSWMTL', '');
INSERT INTO `05diseases` VALUES ('7174', '牵拉性视网膜脱离', '326', 'H33.401', 'QLXSWMTL', '');
INSERT INTO `05diseases` VALUES ('7175', '增生性玻璃体-视网膜病伴视网膜脱离', '21', 'H33.451', 'ZSXBLTSWMBBSWMTL', '');
INSERT INTO `05diseases` VALUES ('7176', '创伤性视网膜脱离', '44', 'H33.501', 'CSXSWMTL', '');
INSERT INTO `05diseases` VALUES ('7177', '大泡性视网膜脱离', '326', 'H33.502', 'DPXSWMTL', '');
INSERT INTO `05diseases` VALUES ('7178', '复发性视网膜脱离', '326', 'H33.503', 'FFXSWMTL', '');
INSERT INTO `05diseases` VALUES ('7179', '继发性视网膜脱离', '326', 'H33.504', 'JFXSWMTL', '');
INSERT INTO `05diseases` VALUES ('7180', '渗出性视网膜脱离', '326', 'H33.505', 'SCXSWMTL', '');
INSERT INTO `05diseases` VALUES ('7181', '医源性视网膜脱离', '326', 'H33.506', 'YYXSWMTL', '');
INSERT INTO `05diseases` VALUES ('7182', '原发性视网膜脱离', '326', 'H33.507', 'YFXSWMTL', '');
INSERT INTO `05diseases` VALUES ('7183', '短暂性视网膜动脉闭塞', '58', 'H34.051', 'DZXSWMDMBS', '');
INSERT INTO `05diseases` VALUES ('7184', '中心性视网膜动脉闭塞', '58', 'H34.151', 'ZXXSWMDMBS', '');
INSERT INTO `05diseases` VALUES ('7185', '视网膜动脉闭塞', '58', 'H34.201', 'SWMDMBS', '');
INSERT INTO `05diseases` VALUES ('7186', '视网膜血管闭塞', '326', 'H34.202', 'SWMXGBS', '');
INSERT INTO `05diseases` VALUES ('7187', '视网膜血管痉挛', '179', 'H34.203', 'SWMXGJL', '');
INSERT INTO `05diseases` VALUES ('7188', '眼动脉栓塞', '430', 'H34.204', 'YDMSS', '');
INSERT INTO `05diseases` VALUES ('7189', '视网膜动脉梗塞', '260', 'H34.251', 'SWMDMGS', '');
INSERT INTO `05diseases` VALUES ('7190', '视网膜微血管栓塞', '326', 'H34.252', 'SWMWXGSS', '');
INSERT INTO `05diseases` VALUES ('7191', '视网膜动脉闭塞(分枝)(部分性)', '58', 'H34.253', 'SWMDMBSFZBFX', '');
INSERT INTO `05diseases` VALUES ('7192', '视网膜(动脉)痉挛', '260', 'H34.254', 'SWMDMJL', '');
INSERT INTO `05diseases` VALUES ('7193', '颞上枝静脉阻塞', '186', 'H34.801', 'NSZJMZS', '');
INSERT INTO `05diseases` VALUES ('7194', '视网膜静脉闭塞', '326', 'H34.802', 'SWMJMBS', '');
INSERT INTO `05diseases` VALUES ('7195', '视网膜中央静脉阻塞', '326', 'H34.803', 'SWMZYJMZS', '');
INSERT INTO `05diseases` VALUES ('7196', '眼底静脉栓塞', '430', 'H34.804', 'YDJMSS', '');
INSERT INTO `05diseases` VALUES ('7197', '视网膜中央静脉血栓形成', '419', 'H34.851', 'SWMZYJMXSXC', '');
INSERT INTO `05diseases` VALUES ('7198', '初期视网膜静脉闭塞', '326', 'H34.852', 'CQSWMJMBS', '');
INSERT INTO `05diseases` VALUES ('7199', '分枝性视网膜静脉闭塞', '326', 'H34.853', 'FZXSWMJMBS', '');
INSERT INTO `05diseases` VALUES ('7200', '部分性视网膜静脉闭塞', '326', 'H34.854', 'BFXSWMJMBS', '');
INSERT INTO `05diseases` VALUES ('7201', '视网膜血管闭塞 NOS', '326', 'H34.951', 'SWMXGBS', '');
INSERT INTO `05diseases` VALUES ('7202', '高血压性视网膜病', '99', 'H35.001', 'GXYXSWMB', '');
INSERT INTO `05diseases` VALUES ('7203', '环状视网膜病', '326', 'H35.002', 'HZSWMB', '');
INSERT INTO `05diseases` VALUES ('7204', '科茨氏病[渗出性视网膜病]', '326', 'H35.003', 'KCSBSCXSWMB', '');
INSERT INTO `05diseases` VALUES ('7205', '肾病眼底改变', '430', 'H35.005', 'SBYDGB', '');
INSERT INTO `05diseases` VALUES ('7206', '视网膜病', '326', 'H35.006', 'SWMB', '');
INSERT INTO `05diseases` VALUES ('7207', '视网膜动脉炎', '260', 'H35.007', 'SWMDMY', '');
INSERT INTO `05diseases` VALUES ('7208', '视网膜静脉炎', '185', 'H35.008', 'SWMJMY', '');
INSERT INTO `05diseases` VALUES ('7209', '视网膜静脉周围炎', '326', 'H35.009', 'SWMJMZWY', '');
INSERT INTO `05diseases` VALUES ('7210', '视网膜血管炎', '326', 'H35.010', 'SWMXGY', '');
INSERT INTO `05diseases` VALUES ('7211', '伊耳斯病<Eale`s>', '70', 'H35.011', 'YESB', '');
INSERT INTO `05diseases` VALUES ('7212', '视网膜动脉内膜炎', '260', 'H35.051', 'SWMDMNMY', '');
INSERT INTO `05diseases` VALUES ('7213', '视网膜微-动脉瘤', '62', 'H35.052', 'SWMWDML', '');
INSERT INTO `05diseases` VALUES ('7214', '视网膜血管曲张', '326', 'H35.053', 'SWMXGQZ', '');
INSERT INTO `05diseases` VALUES ('7215', '视网膜鞘(血管包鞘)', '326', 'H35.054', 'SWMQXGBQ', '');
INSERT INTO `05diseases` VALUES ('7216', '晶体后纤维增生', '278', 'H35.151', 'JTHXWZS', '');
INSERT INTO `05diseases` VALUES ('7217', '早熟性视网膜病', '326', 'H35.152', 'ZSXSWMB', '');
INSERT INTO `05diseases` VALUES ('7218', '创伤性增殖性视网膜病', '44', 'H35.201', 'CSXZZXSWMB', '');
INSERT INTO `05diseases` VALUES ('7219', '增殖性视网膜病[增殖性视网膜炎]', '327', 'H35.202', 'ZZXSWMBZZXSWMY', '');
INSERT INTO `05diseases` VALUES ('7220', '增生性玻璃体视网膜病', '21', 'H35.251', 'ZSXBLTSWMB', '');
INSERT INTO `05diseases` VALUES ('7221', '黄斑变性', '250', 'H35.301', 'HBBX', '');
INSERT INTO `05diseases` VALUES ('7222', '黄斑玻璃样疣', '250', 'H35.302', 'HBBLYY', '');
INSERT INTO `05diseases` VALUES ('7223', '黄斑裂孔', '250', 'H35.303', 'HBLK', '');
INSERT INTO `05diseases` VALUES ('7224', '黄斑前膜', '250', 'H35.304', 'HBQM', '');
INSERT INTO `05diseases` VALUES ('7225', '视网膜黄斑变性', '250', 'H35.305', 'SWMHBBX', '');
INSERT INTO `05diseases` VALUES ('7226', '老年性黄斑变性', '250', 'H35.351', 'LNXHBBX', '');
INSERT INTO `05diseases` VALUES ('7227', '中毒性黄斑病', '250', 'H35.352', 'ZDXHBB', '');
INSERT INTO `05diseases` VALUES ('7228', '黄斑囊肿', '250', 'H35.353', 'HBNZ', '');
INSERT INTO `05diseases` VALUES ('7229', '库恩特－尤尼乌斯变性', '278', 'H35.354', 'KETYNWSBX', '');
INSERT INTO `05diseases` VALUES ('7230', '视网膜后极变性', '326', 'H35.355', 'SWMHJBX', '');
INSERT INTO `05diseases` VALUES ('7231', '眼黄斑后极变性', '430', 'H35.356', 'YHBHJBX', '');
INSERT INTO `05diseases` VALUES ('7232', '视网膜变性', '326', 'H35.401', 'SWMBX', '');
INSERT INTO `05diseases` VALUES ('7233', '视网膜周边变性', '326', 'H35.402', 'SWMZBBX', '');
INSERT INTO `05diseases` VALUES ('7234', '视网膜色素变性', '326', 'H35.501', 'SWMSSBX', '');
INSERT INTO `05diseases` VALUES ('7235', '视网膜营养障碍(白点状)(色素性)(卵黄性)', '326', 'H35.502', 'SWMYYZABDZSSXLHX', '');
INSERT INTO `05diseases` VALUES ('7236', '先天性视网膜黄斑变性[贝斯特氏病]', '250', 'H35.551', 'XTXSWMHBBXBSTSB', '');
INSERT INTO `05diseases` VALUES ('7237', '毯样视网膜营养障碍', '326', 'H35.552', 'YSWMYYZA', '');
INSERT INTO `05diseases` VALUES ('7238', '玻璃体视网膜营养障碍', '21', 'H35.553', 'BLTSWMYYZA', '');
INSERT INTO `05diseases` VALUES ('7239', '色素性视网膜炎', '327', 'H35.554', 'SSXSWMY', '');
INSERT INTO `05diseases` VALUES ('7240', '施塔加特病', '268', 'H35.555', 'STJTB', '');
INSERT INTO `05diseases` VALUES ('7241', '黄斑出血', '250', 'H35.601', 'HBCX', '');
INSERT INTO `05diseases` VALUES ('7242', '视网膜出血', '38', 'H35.602', 'SWMCX', '');
INSERT INTO `05diseases` VALUES ('7243', '眼底出血', '430', 'H35.603', 'YDCX', '');
INSERT INTO `05diseases` VALUES ('7244', '中心性浆液性视网膜病', '326', 'H35.701', 'ZXXJYXSWMB', '');
INSERT INTO `05diseases` VALUES ('7245', '中心性浆液性视网膜脉络网病变', '326', 'H35.702', 'ZXXJYXSWMMLWBB', '');
INSERT INTO `05diseases` VALUES ('7246', '视网膜色素上皮脱离', '326', 'H35.751', 'SWMSSSPTL', '');
INSERT INTO `05diseases` VALUES ('7247', '中心性渗出性视网膜炎', '327', 'H35.752', 'ZXXSCXSWMY', '');
INSERT INTO `05diseases` VALUES ('7248', '浆液性脉络膜视网膜病', '326', 'H35.753', 'JYXMLMSWMB', '');
INSERT INTO `05diseases` VALUES ('7249', '创伤性脉络膜视网膜病', '44', 'H35.801', 'CSXMLMSWMB', '');
INSERT INTO `05diseases` VALUES ('7250', '黄斑水肿', '250', 'H35.802', 'HBSZ', '');
INSERT INTO `05diseases` VALUES ('7251', '视网膜动脉供血不足', '59', 'H35.803', 'SWMDMGXBZ', '');
INSERT INTO `05diseases` VALUES ('7252', '视网膜黑变病', '326', 'H35.804', 'SWMHBB', '');
INSERT INTO `05diseases` VALUES ('7253', '视网膜坏死', '326', 'H35.805', 'SWMHS', '');
INSERT INTO `05diseases` VALUES ('7254', '视网膜前机化膜', '326', 'H35.806', 'SWMQJHM', '');
INSERT INTO `05diseases` VALUES ('7255', '视网膜萎缩', '326', 'H35.807', 'SWMWS', '');
INSERT INTO `05diseases` VALUES ('7256', '视网膜胆固醇沉积物', '53', 'H35.851', 'SWMDGCCJW', '');
INSERT INTO `05diseases` VALUES ('7257', '视网膜铜质沉积症', '326', 'H35.852', 'SWMTZCJZ', '');
INSERT INTO `05diseases` VALUES ('7258', '创伤性视网膜病变', '44', 'H35.901', 'CSXSWMBB', '');
INSERT INTO `05diseases` VALUES ('7259', '视网膜疾患 NOS', '326', 'H35.951', 'SWMJH', '');
INSERT INTO `05diseases` VALUES ('7260', '视网膜病变 NOS', '326', 'H35.952', 'SWMBB', '');
INSERT INTO `05diseases` VALUES ('7261', '交界性青光眼', '430', 'H40.001', 'JJXQGY', '');
INSERT INTO `05diseases` VALUES ('7262', '青光眼临床前期', '430', 'H40.002', 'QGYLCQQ', '');
INSERT INTO `05diseases` VALUES ('7263', '眼压过高', '430', 'H40.003', 'YYGG', '');
INSERT INTO `05diseases` VALUES ('7264', '可凝青光眼', '430', 'H40.051', 'KNQGY', '');
INSERT INTO `05diseases` VALUES ('7265', '开角型青光眼', '430', 'H40.101', 'KJXQGY', '');
INSERT INTO `05diseases` VALUES ('7266', '低压性青光眼', '430', 'H40.102', 'DYXQGY', '');
INSERT INTO `05diseases` VALUES ('7267', '原发性开角型青光眼', '430', 'H40.103', 'YFXKJXQGY', '');
INSERT INTO `05diseases` VALUES ('7268', '非梗阻性青光眼', '430', 'H40.151', 'FGZXQGY', '');
INSERT INTO `05diseases` VALUES ('7269', '慢性单纯性青光眼', '430', 'H40.152', 'MXDCXQGY', '');
INSERT INTO `05diseases` VALUES ('7270', '色素性青光眼', '430', 'H40.153', 'SSXQGY', '');
INSERT INTO `05diseases` VALUES ('7271', '囊膜性青光眼(伴有晶状体假性剥脱)', '430', 'H40.154', 'NMXQGYBYJZTJXBT', '');
INSERT INTO `05diseases` VALUES ('7272', '慢性非充血性青光眼', '430', 'H40.155', 'MXFCXXQGY', '');
INSERT INTO `05diseases` VALUES ('7273', '闭角型青光眼', '430', 'H40.201', 'BJXQGY', '');
INSERT INTO `05diseases` VALUES ('7274', '恶性青光眼', '430', 'H40.202', 'EXQGY', '');
INSERT INTO `05diseases` VALUES ('7275', '急性闭角型青光眼', '430', 'H40.203', 'JXBJXQGY', '');
INSERT INTO `05diseases` VALUES ('7276', '急性青光眼', '430', 'H40.204', 'JXQGY', '');
INSERT INTO `05diseases` VALUES ('7277', '慢性闭角型青光眼', '430', 'H40.205', 'MXBJXQGY', '');
INSERT INTO `05diseases` VALUES ('7278', '原发性闭角型青光眼', '430', 'H40.206', 'YFXBJXQGY', '');
INSERT INTO `05diseases` VALUES ('7279', '间歇性闭角性青光眼', '430', 'H40.251', 'JXXBJXQGY', '');
INSERT INTO `05diseases` VALUES ('7280', '梗阻性青光眼', '430', 'H40.252', 'GZXQGY', '');
INSERT INTO `05diseases` VALUES ('7281', '创伤性青光眼', '430', 'H40.301', 'CSXQGY', '');
INSERT INTO `05diseases` VALUES ('7282', '眼球震荡引起的青光眼', '430', 'H40.351', 'YQZDYQDQGY', '');
INSERT INTO `05diseases` VALUES ('7283', '青光眼并发虹膜睫状体炎', '430', 'H40.401', 'QGYBFHMJZTY', '');
INSERT INTO `05diseases` VALUES ('7284', '青光眼睫状体炎危象[青光眼睫状体炎综合征]', '430', 'H40.402', 'QGYJZTYWXQGYJZTYZHZ', '');
INSERT INTO `05diseases` VALUES ('7285', '感染后青光眼', '430', 'H40.451', 'GRHQGY', '');
INSERT INTO `05diseases` VALUES ('7286', '新生血管性青光眼', '430', 'H40.501', 'XSXGXQGY', '');
INSERT INTO `05diseases` VALUES ('7287', '继发性青光眼', '430', 'H40.502', 'JFXQGY', '');
INSERT INTO `05diseases` VALUES ('7288', '晶体脱位后青光眼', '430', 'H40.503', 'JTTWHQGY', '');
INSERT INTO `05diseases` VALUES ('7289', '晶状体溶解性青光眼[溶晶状体性青光眼]', '430', 'H40.504', 'JZTRJXQGYRJZTXQGY', '');
INSERT INTO `05diseases` VALUES ('7290', '青光眼并发视网膜静脉阻塞', '430', 'H40.505', 'QGYBFSWMJMZS', '');
INSERT INTO `05diseases` VALUES ('7291', '青光眼合并白内障', '430', 'H40.506', 'QGYHBBNZ', '');
INSERT INTO `05diseases` VALUES ('7292', '无晶体性青光眼', '430', 'H40.507', 'WJTXQGY', '');
INSERT INTO `05diseases` VALUES ('7293', '虹膜发红引起的青光眼', '430', 'H40.551', 'HMFHYQDQGY', '');
INSERT INTO `05diseases` VALUES ('7294', '眼球肿瘤引起的青光眼', '473', 'H40.552', 'YQZLYQDQGY', '');
INSERT INTO `05diseases` VALUES ('7295', '皮质类固醇诱发青光眼', '430', 'H40.601', 'PZLGCYFQGY', '');
INSERT INTO `05diseases` VALUES ('7296', '药物性青光眼', '430', 'H40.651', 'YWXQGY', '');
INSERT INTO `05diseases` VALUES ('7297', '混合型青光眼', '430', 'H40.801', 'HHXQGY', '');
INSERT INTO `05diseases` VALUES ('7298', '血影细胞性青光眼', '430', 'H40.802', 'XYXBXQGY', '');
INSERT INTO `05diseases` VALUES ('7299', '出血性青光眼', '430', 'H40.851', 'CXXQGY', '');
INSERT INTO `05diseases` VALUES ('7300', '反象型青光眼', '430', 'H40.852', 'FXXQGY', '');
INSERT INTO `05diseases` VALUES ('7301', '分泌过多性青光眼', '430', 'H40.853', 'FMGDXQGY', '');
INSERT INTO `05diseases` VALUES ('7302', '青光眼 NOS', '430', 'H40.901', 'QGY', '');
INSERT INTO `05diseases` VALUES ('7303', '玻璃体疝', '21', 'H43.001', 'BLTS', '');
INSERT INTO `05diseases` VALUES ('7304', '玻璃体脱出', '21', 'H43.051', 'BLTTC', '');
INSERT INTO `05diseases` VALUES ('7305', '玻璃体出血', '21', 'H43.101', 'BLTCX', '');
INSERT INTO `05diseases` VALUES ('7306', '玻璃体炎', '22', 'H43.251', 'BLTY', '');
INSERT INTO `05diseases` VALUES ('7307', '星形玻璃体炎', '22', 'H43.252', 'XXBLTY', '');
INSERT INTO `05diseases` VALUES ('7308', '本森氏病[星形玻璃体变性]', '21', 'H43.253', 'BSSBXXBLTBX', '');
INSERT INTO `05diseases` VALUES ('7309', '玻璃体内的胆固醇', '53', 'H43.254', 'BLTNDDGC', '');
INSERT INTO `05diseases` VALUES ('7310', '玻璃体线', '21', 'H43.255', 'BLTX', '');
INSERT INTO `05diseases` VALUES ('7311', '玻璃体混浊', '21', 'H43.301', 'BLTHZ', '');
INSERT INTO `05diseases` VALUES ('7312', '玻璃膜疣', '453', 'H43.801', 'BLMY', '');
INSERT INTO `05diseases` VALUES ('7313', '玻璃体变性', '21', 'H43.802', 'BLTBX', '');
INSERT INTO `05diseases` VALUES ('7314', '玻璃体机化', '21', 'H43.803', 'BLTJH', '');
INSERT INTO `05diseases` VALUES ('7315', '玻璃体脱离', '21', 'H43.804', 'BLTTL', '');
INSERT INTO `05diseases` VALUES ('7316', '玻璃体萎缩', '21', 'H43.805', 'BLTWS', '');
INSERT INTO `05diseases` VALUES ('7317', '玻璃体液化', '21', 'H43.806', 'BLTYH', '');
INSERT INTO `05diseases` VALUES ('7318', '增殖性玻璃体病变', '21', 'H43.807', 'ZZXBLTBB', '');
INSERT INTO `05diseases` VALUES ('7319', '玻璃体疾患 NOS', '21', 'H43.951', 'BLTJH', '');
INSERT INTO `05diseases` VALUES ('7320', '玻璃体脓肿', '243', 'H44.001', 'BLTNZ', '');
INSERT INTO `05diseases` VALUES ('7321', '感染性眼内炎', '430', 'H44.002', 'GRXYNY', '');
INSERT INTO `05diseases` VALUES ('7322', '化脓性眼内炎', '430', 'H44.003', 'HNXYNY', '');
INSERT INTO `05diseases` VALUES ('7323', '全眼球炎', '430', 'H44.004', 'QYQY', '');
INSERT INTO `05diseases` VALUES ('7324', '眼内炎', '430', 'H44.005', 'YNY', '');
INSERT INTO `05diseases` VALUES ('7325', '眼脓肿', '430', 'H44.006', 'YNZ', '');
INSERT INTO `05diseases` VALUES ('7326', '转移性眼内炎', '430', 'H44.007', 'ZYXYNY', '');
INSERT INTO `05diseases` VALUES ('7327', '寄生虫性眼内炎', '430', 'H44.101', 'JSCXYNY', '');
INSERT INTO `05diseases` VALUES ('7328', '交感性眼炎', '430', 'H44.102', 'JGXYY', '');
INSERT INTO `05diseases` VALUES ('7329', '眼小梁炎', '430', 'H44.103', 'YXLY', '');
INSERT INTO `05diseases` VALUES ('7330', '交感性色素膜炎', '277', 'H44.151', 'JGXSSMY', '');
INSERT INTO `05diseases` VALUES ('7331', '虹膜睫状体脉络膜炎[全色素层炎]', '221', 'H44.152', 'HMJZTMLMYQSSCY', '');
INSERT INTO `05diseases` VALUES ('7332', '恶性近视眼', '430', 'H44.251', 'EXJSY', '');
INSERT INTO `05diseases` VALUES ('7333', '变性性近视', '325', 'H44.252', 'BXXJS', '');
INSERT INTO `05diseases` VALUES ('7334', '虹膜铁质沉着病', '268', 'H44.301', 'HMTZCZB', '');
INSERT INTO `05diseases` VALUES ('7335', '晶体铁锈沉着症', '278', 'H44.302', 'JTTXCZZ', '');
INSERT INTO `05diseases` VALUES ('7336', '视网膜铁质沉着病', '326', 'H44.303', 'SWMTZCZB', '');
INSERT INTO `05diseases` VALUES ('7337', '眼球铁质沉着病', '430', 'H44.304', 'YQTZCZB', '');
INSERT INTO `05diseases` VALUES ('7338', '眼铜屑沉着病', '430', 'H44.305', 'YTXCZB', '');
INSERT INTO `05diseases` VALUES ('7339', '低眼压', '430', 'H44.401', 'DYY', '');
INSERT INTO `05diseases` VALUES ('7340', '巩膜瘘', '212', 'H44.402', 'GML', '');
INSERT INTO `05diseases` VALUES ('7341', '角膜瘘', '212', 'H44.403', 'JML', '');
INSERT INTO `05diseases` VALUES ('7342', '绝对期青光眼', '430', 'H44.501', 'JDQQGY', '');
INSERT INTO `05diseases` VALUES ('7343', '眼球痨', '430', 'H44.502', 'YQL', '');
INSERT INTO `05diseases` VALUES ('7344', '眼球萎缩', '430', 'H44.503', 'YQWS', '');
INSERT INTO `05diseases` VALUES ('7345', '陈旧性眼内磁性异物', '430', 'H44.601', 'CJXYNCXYW', '');
INSERT INTO `05diseases` VALUES ('7346', '陈旧性前房磁性异物', '278', 'H44.651', 'CJXQFCXYW', '');
INSERT INTO `05diseases` VALUES ('7347', '陈旧性睫状体磁性异物', '278', 'H44.652', 'CJXJZTCXYW', '');
INSERT INTO `05diseases` VALUES ('7348', '陈旧性晶体状磁性异物', '278', 'H44.653', 'CJXJTZCXYW', '');
INSERT INTO `05diseases` VALUES ('7349', '陈旧性眼球后壁磁性异物', '430', 'H44.654', 'CJXYQHBCXYW', '');
INSERT INTO `05diseases` VALUES ('7350', '陈旧性玻璃体磁性异物', '21', 'H44.655', 'CJXBLTCXYW', '');
INSERT INTO `05diseases` VALUES ('7351', '玻璃体异物', '21', 'H44.701', 'BLTYW', '');
INSERT INTO `05diseases` VALUES ('7352', '陈旧性玻璃体异物', '21', 'H44.702', 'CJXBLTYW', '');
INSERT INTO `05diseases` VALUES ('7353', '陈旧性巩膜异物遗留', '278', 'H44.703', 'CJXGMYWYL', '');
INSERT INTO `05diseases` VALUES ('7354', '陈旧性眼前房非磁性异物', '430', 'H44.704', 'CJXYQFFCXYW', '');
INSERT INTO `05diseases` VALUES ('7355', '陈旧性眼球内非磁性异物', '430', 'H44.705', 'CJXYQNFCXYW', '');
INSERT INTO `05diseases` VALUES ('7356', '陈旧性巩膜异物', '278', 'H44.706', 'CJXGMYW', '');
INSERT INTO `05diseases` VALUES ('7357', '陈旧性眼内非磁性异物', '430', 'H44.751', 'CJXYNFCXYW', '');
INSERT INTO `05diseases` VALUES ('7358', '陈旧性睫状体非磁性异物', '278', 'H44.752', 'CJXJZTFCXYW', '');
INSERT INTO `05diseases` VALUES ('7359', '陈旧性晶状体非磁性异物', '278', 'H44.753', 'CJXJZTFCXYW', '');
INSERT INTO `05diseases` VALUES ('7360', '陈旧性眼球后壁非磁性异物', '430', 'H44.754', 'CJXYQHBFCXYW', '');
INSERT INTO `05diseases` VALUES ('7361', '眼内出血', '430', 'H44.801', 'YNCX', '');
INSERT INTO `05diseases` VALUES ('7362', '眼球脱位', '430', 'H44.802', 'YQTW', '');
INSERT INTO `05diseases` VALUES ('7363', '眼球粘连', '430', 'H44.851', 'YQNL', '');
INSERT INTO `05diseases` VALUES ('7364', '眼球积血', '430', 'H44.852', 'YQJX', '');
INSERT INTO `05diseases` VALUES ('7365', '眼球后肿物', '430', 'H44.951', 'YQHZW', '');
INSERT INTO `05diseases` VALUES ('7366', '球后视神经炎', '313', 'H46.X01', 'QHSSJY', '');
INSERT INTO `05diseases` VALUES ('7367', '球后炎性假瘤', '261', 'H46.X02', 'QHYXJL', '');
INSERT INTO `05diseases` VALUES ('7368', '视神经乳头炎', '313', 'H46.X03', 'SSJRTY', '');
INSERT INTO `05diseases` VALUES ('7369', '视神经病变', '313', 'H46.X04', 'SSJBB', '');
INSERT INTO `05diseases` VALUES ('7370', '视神经炎', '313', 'H46.X05', 'SSJY', '');
INSERT INTO `05diseases` VALUES ('7371', '眶尖综合征', '278', 'H47.001', 'KJZHZ', '');
INSERT INTO `05diseases` VALUES ('7372', '缺血性视乳头病变', '86', 'H47.002', 'QXXSRTBB', '');
INSERT INTO `05diseases` VALUES ('7373', '缺血性视神经病变', '313', 'H47.003', 'QXXSSJBB', '');
INSERT INTO `05diseases` VALUES ('7374', '视神经麻痹', '313', 'H47.004', 'SSJMB', '');
INSERT INTO `05diseases` VALUES ('7375', '视神经鞘膜内出血', '313', 'H47.051', 'SSJQMNCX', '');
INSERT INTO `05diseases` VALUES ('7376', '视神经受压', '313', 'H47.052', 'SSJSY', '');
INSERT INTO `05diseases` VALUES ('7377', '视乳头水肿', '86', 'H47.101', 'SRTSZ', '');
INSERT INTO `05diseases` VALUES ('7378', '利伯氏病[家族遗传性球后视神经萎缩]', '313', 'H47.201', 'LBSBJZYCXQHSSJWS', '');
INSERT INTO `05diseases` VALUES ('7379', '视(乳头黄斑束)神经萎缩', '313', 'H47.202', 'SRTHBSSJWS', '');
INSERT INTO `05diseases` VALUES ('7380', '视神经盘颞侧苍白', '313', 'H47.251', 'SSJPNCCB', '');
INSERT INTO `05diseases` VALUES ('7381', '外伤性视神经萎缩', '313', 'H47.252', 'WSXSSJWS', '');
INSERT INTO `05diseases` VALUES ('7382', '莱贝尔视神经萎缩(遗传性)', '313', 'H47.253', 'LBESSJWSYCX', '');
INSERT INTO `05diseases` VALUES ('7383', '假性(视神经)乳头水肿', '313', 'H47.301', 'JXSSJRTSZ', '');
INSERT INTO `05diseases` VALUES ('7384', '视盘玻璃样疣', '453', 'H47.302', 'SPBLYY', '');
INSERT INTO `05diseases` VALUES ('7385', '视乳头肿物', '86', 'H47.303', 'SRTZW', '');
INSERT INTO `05diseases` VALUES ('7386', '视神经盘的脉络膜小疣', '313', 'H47.351', 'SSJPDMLMXY', '');
INSERT INTO `05diseases` VALUES ('7387', '视交叉综合征', '325', 'H47.401', 'SJCZHZ', '');
INSERT INTO `05diseases` VALUES ('7388', '其他视交叉疾患', '325', 'H47.551', 'QTSJCJH', '');
INSERT INTO `05diseases` VALUES ('7389', '皮质盲', '278', 'H47.601', 'PZM', '');
INSERT INTO `05diseases` VALUES ('7390', '视皮层疾患', '325', 'H47.651', 'SPCJH', '');
INSERT INTO `05diseases` VALUES ('7391', '视路疾患 NOS', '325', 'H47.751', 'SLJH', '');
INSERT INTO `05diseases` VALUES ('7392', '第三颅神经麻痹[动眼神经麻痹]', '313', 'H49.001', 'DSLSJMBDYSJMB', '');
INSERT INTO `05diseases` VALUES ('7393', '动眼神经炎', '313', 'H49.002', 'DYSJY', '');
INSERT INTO `05diseases` VALUES ('7394', '滑车神经麻痹[第四]', '313', 'H49.101', 'HCSJMBDS', '');
INSERT INTO `05diseases` VALUES ('7395', '滑车(神经)炎', '313', 'H49.151', 'HCSJY', '');
INSERT INTO `05diseases` VALUES ('7396', '下斜面肌麻痹', '217', 'H49.152', 'XXMJMB', '');
INSERT INTO `05diseases` VALUES ('7397', '上斜肌麻痹', '217', 'H49.153', 'SXJMB', '');
INSERT INTO `05diseases` VALUES ('7398', '外展神经麻痹[第六]', '313', 'H49.201', 'WZSJMBDL', '');
INSERT INTO `05diseases` VALUES ('7399', '外展神经炎', '313', 'H49.202', 'WZSJY', '');
INSERT INTO `05diseases` VALUES ('7400', '全部(外部)眼肌麻痹', '430', 'H49.351', 'QBWBYJMB', '');
INSERT INTO `05diseases` VALUES ('7401', '进行性眼外肌麻痹', '430', 'H49.451', 'JXXYWJMB', '');
INSERT INTO `05diseases` VALUES ('7402', '眶上裂综合征', '278', 'H49.801', 'KSLZHZ', '');
INSERT INTO `05diseases` VALUES ('7403', '麻痹性外斜视', '391', 'H49.802', 'MBXWXS', '');
INSERT INTO `05diseases` VALUES ('7404', '眼内直肌麻痹', '430', 'H49.803', 'YNZJMB', '');
INSERT INTO `05diseases` VALUES ('7405', '眼上斜肌麻痹', '430', 'H49.804', 'YSXJMB', '');
INSERT INTO `05diseases` VALUES ('7406', '眼上直肌麻痹', '430', 'H49.805', 'YSZJMB', '');
INSERT INTO `05diseases` VALUES ('7407', '痛性眼肌麻痹', '430', 'H49.806', 'TXYJMB', '');
INSERT INTO `05diseases` VALUES ('7408', '眼外肌麻痹', '430', 'H49.807', 'YWJMB', '');
INSERT INTO `05diseases` VALUES ('7409', '眼外直肌麻痹', '430', 'H49.808', 'YWZJMB', '');
INSERT INTO `05diseases` VALUES ('7410', '眼下斜肌麻痹', '430', 'H49.809', 'YXXJMB', '');
INSERT INTO `05diseases` VALUES ('7411', '眼下直肌麻痹', '430', 'H49.810', 'YXZJMB', '');
INSERT INTO `05diseases` VALUES ('7412', '重症肌无力斜视', '391', 'H49.811', 'ZZJWLXS', '');
INSERT INTO `05diseases` VALUES ('7413', '卡恩斯－塞尔综合征', '278', 'H49.851', 'KESSEZHZ', '');
INSERT INTO `05diseases` VALUES ('7414', '帕里诺综合征[眼肌瘫痪]', '430', 'H49.852', 'PLNZHZYJTH', '');
INSERT INTO `05diseases` VALUES ('7415', '麻痹性斜视 NOS', '391', 'H49.901', 'MBXXS', '');
INSERT INTO `05diseases` VALUES ('7416', '先天性麻痹性斜视', '383', 'H49.902', 'XTXMBXXS', '');
INSERT INTO `05diseases` VALUES ('7417', '眼肌麻痹', '430', 'H49.903', 'YJMB', '');
INSERT INTO `05diseases` VALUES ('7418', '眼肌麻痹斜视', '430', 'H49.951', 'YJMBXS', '');
INSERT INTO `05diseases` VALUES ('7419', '调节性内斜视', '391', 'H50.001', 'DJXNXS', '');
INSERT INTO `05diseases` VALUES ('7420', '共同性内斜视', '391', 'H50.002', 'GTXNXS', '');
INSERT INTO `05diseases` VALUES ('7421', '交替性内斜视', '391', 'H50.003', 'JTXNXS', '');
INSERT INTO `05diseases` VALUES ('7422', '内斜视', '391', 'H50.004', 'NXS', '');
INSERT INTO `05diseases` VALUES ('7423', '废用性外斜视', '391', 'H50.101', 'FYXWXS', '');
INSERT INTO `05diseases` VALUES ('7424', '共同性外斜视', '391', 'H50.102', 'GTXWXS', '');
INSERT INTO `05diseases` VALUES ('7425', '交替性外斜视', '391', 'H50.103', 'JTXWXS', '');
INSERT INTO `05diseases` VALUES ('7426', '外斜视', '391', 'H50.104', 'WXS', '');
INSERT INTO `05diseases` VALUES ('7427', '垂直性斜视', '391', 'H50.251', 'CZXXS', '');
INSERT INTO `05diseases` VALUES ('7428', '间歇性外斜视', '391', 'H50.301', 'JXXWXS', '');
INSERT INTO `05diseases` VALUES ('7429', '交替性间歇性外斜视', '391', 'H50.302', 'JTXJXXWXS', '');
INSERT INTO `05diseases` VALUES ('7430', '间歇性(交替性)(单眼性)内斜视', '430', 'H50.351', 'JXXJTXDYXNXS', '');
INSERT INTO `05diseases` VALUES ('7431', 'DVD综合征[垂直性分离性斜视]', '391', 'H50.401', 'ZHZCZXFLXXS', '');
INSERT INTO `05diseases` VALUES ('7432', '共同性斜视', '391', 'H50.402', 'GTXXS', '');
INSERT INTO `05diseases` VALUES ('7433', '上斜视', '391', 'H50.403', 'SXS', '');
INSERT INTO `05diseases` VALUES ('7434', '下斜肌亢进', '267', 'H50.404', 'XXJKJ', '');
INSERT INTO `05diseases` VALUES ('7435', '下斜视', '391', 'H50.405', 'XXS', '');
INSERT INTO `05diseases` VALUES ('7436', '旋转斜视', '391', 'H50.451', 'XZXS', '');
INSERT INTO `05diseases` VALUES ('7437', '单眼固定综合征', '430', 'H50.452', 'DYGDZHZ', '');
INSERT INTO `05diseases` VALUES ('7438', '内隐斜视', '391', 'H50.551', 'NYXS', '');
INSERT INTO `05diseases` VALUES ('7439', '交替性上隐斜视', '391', 'H50.552', 'JTXSYXS', '');
INSERT INTO `05diseases` VALUES ('7440', '外隐斜视', '391', 'H50.553', 'WYXS', '');
INSERT INTO `05diseases` VALUES ('7441', '布郎氏鞘综合征[上斜肌腱鞘综合征]', '142', 'H50.601', 'BLSQZHZSXJJQZHZ', '');
INSERT INTO `05diseases` VALUES ('7442', '机械性斜视', '391', 'H50.651', 'JXXXS', '');
INSERT INTO `05diseases` VALUES ('7443', '外伤性眼肌展动受限', '430', 'H50.652', 'WSXYJZDSX', '');
INSERT INTO `05diseases` VALUES ('7444', '瘢痕粘连引起的斜视', '391', 'H50.653', 'BHNLYQDXS', '');
INSERT INTO `05diseases` VALUES ('7445', '废用性斜视', '391', 'H50.801', 'FYXXS', '');
INSERT INTO `05diseases` VALUES ('7446', '急性肌炎性斜视', '146', 'H50.802', 'JXJYXXS', '');
INSERT INTO `05diseases` VALUES ('7447', '痉挛性斜视', '391', 'H50.803', 'JLXXS', '');
INSERT INTO `05diseases` VALUES ('7448', '眼球退缩综合征', '430', 'H50.804', 'YQTSZHZ', '');
INSERT INTO `05diseases` VALUES ('7449', '眼球后退性斜视[杜安氏综合征]', '430', 'H50.851', 'YQHTXXSDASZHZ', '');
INSERT INTO `05diseases` VALUES ('7450', '重症肌无力性斜视', '391', 'H50.852', 'ZZJWLXXS', '');
INSERT INTO `05diseases` VALUES ('7451', '眼肌挛缩性斜视', '430', 'H50.853', 'YJLSXXS', '');
INSERT INTO `05diseases` VALUES ('7452', '斜视 NOS', '391', 'H50.901', 'XS', '');
INSERT INTO `05diseases` VALUES ('7453', '交替性斜视', '391', 'H50.951', 'JTXXS', '');
INSERT INTO `05diseases` VALUES ('7454', '同向性注视麻痹', '217', 'H51.051', 'TXXZSMB', '');
INSERT INTO `05diseases` VALUES ('7455', '会聚机能不全和过度', '278', 'H51.151', 'HJJNBQHGD', '');
INSERT INTO `05diseases` VALUES ('7456', '核间性眼肌麻痹', '430', 'H51.251', 'HJXYJMB', '');
INSERT INTO `05diseases` VALUES ('7457', '眶尖综合征[罗莱特氏综合征]', '278', 'H51.851', 'KJZHZLLTSZHZ', '');
INSERT INTO `05diseases` VALUES ('7458', '双眼运动疾患 NOS', '430', 'H51.951', 'SYYDJH', '');
INSERT INTO `05diseases` VALUES ('7459', '远视', '325', 'H52.001', 'YS', '');
INSERT INTO `05diseases` VALUES ('7460', '屈光性远视', '325', 'H52.051', 'QGXYS', '');
INSERT INTO `05diseases` VALUES ('7461', '高度近视', '325', 'H52.101', 'GDJS', '');
INSERT INTO `05diseases` VALUES ('7462', '近视(假性)', '325', 'H52.102', 'JSJX', '');
INSERT INTO `05diseases` VALUES ('7463', '散光', '278', 'H52.201', 'SG', '');
INSERT INTO `05diseases` VALUES ('7464', '屈光不正', '278', 'H52.301', 'QGBZ', '');
INSERT INTO `05diseases` VALUES ('7465', '屈光参差(先天性)', '383', 'H52.351', 'QGCCXTX', '');
INSERT INTO `05diseases` VALUES ('7466', '物象不等', '278', 'H52.352', 'WXBD', '');
INSERT INTO `05diseases` VALUES ('7467', '老视', '325', 'H52.401', 'LS', '');
INSERT INTO `05diseases` VALUES ('7468', '内眼肌麻痹', '430', 'H52.501', 'NYJMB', '');
INSERT INTO `05diseases` VALUES ('7469', '屈光的其他疾患', '278', 'H52.651', 'QGDQTJH', '');
INSERT INTO `05diseases` VALUES ('7470', '废用性弱视', '325', 'H53.001', 'FYXRS', '');
INSERT INTO `05diseases` VALUES ('7471', '弱视(先天性)', '383', 'H53.002', 'RSXTX', '');
INSERT INTO `05diseases` VALUES ('7472', '屈光参差性弱视', '325', 'H53.051', 'QGCCXRS', '');
INSERT INTO `05diseases` VALUES ('7473', '斜视性弱视', '391', 'H53.052', 'XSXRS', '');
INSERT INTO `05diseases` VALUES ('7474', '眼疲劳', '430', 'H53.101', 'YPL', '');
INSERT INTO `05diseases` VALUES ('7475', '闪光性暗点', '278', 'H53.151', 'SGXAD', '');
INSERT INTO `05diseases` VALUES ('7476', '羞明[畏光]', '278', 'H53.152', 'XMWG', '');
INSERT INTO `05diseases` VALUES ('7477', '视觉性晕', '325', 'H53.153', 'SJXY', '');
INSERT INTO `05diseases` VALUES ('7478', '昼盲', '278', 'H53.154', 'ZM', '');
INSERT INTO `05diseases` VALUES ('7479', '视物变形症', '325', 'H53.155', 'SWBXZ', '');
INSERT INTO `05diseases` VALUES ('7480', '突然性视力丧失', '325', 'H53.156', 'TRXSLSS', '');
INSERT INTO `05diseases` VALUES ('7481', '复视', '325', 'H53.201', 'FS', '');
INSERT INTO `05diseases` VALUES ('7482', '双眼视觉抑制', '430', 'H53.351', 'SYSJYZ', '');
INSERT INTO `05diseases` VALUES ('7483', '同步性视觉感受不伴融合', '325', 'H53.352', 'TBXSJGSBBRH', '');
INSERT INTO `05diseases` VALUES ('7484', '融合伴有实体感觉的缺陷', '278', 'H53.353', 'RHBYSTGJDQX', '');
INSERT INTO `05diseases` VALUES ('7485', '异常视网膜对应', '326', 'H53.354', 'YCSWMDY', '');
INSERT INTO `05diseases` VALUES ('7486', '偏盲', '278', 'H53.401', 'PM', '');
INSERT INTO `05diseases` VALUES ('7487', '视野缺损', '325', 'H53.402', 'SYQS', '');
INSERT INTO `05diseases` VALUES ('7488', '双鼻侧偏盲', '16', 'H53.403', 'SBCPM', '');
INSERT INTO `05diseases` VALUES ('7489', '比耶鲁姆暗点', '278', 'H53.451', 'BYLMAD', '');
INSERT INTO `05diseases` VALUES ('7490', '色盲', '278', 'H53.501', 'SM', '');
INSERT INTO `05diseases` VALUES ('7491', '异常的(先天性)三色视', '383', 'H53.551', 'YCDXTXSSS', '');
INSERT INTO `05diseases` VALUES ('7492', '夜盲', '278', 'H53.601', 'YM', '');
INSERT INTO `05diseases` VALUES ('7493', '浅水黑视', '325', 'H53.801', 'QSHS', '');
INSERT INTO `05diseases` VALUES ('7494', '缺血性视力障碍', '325', 'H53.802', 'QXXSLZA', '');
INSERT INTO `05diseases` VALUES ('7495', '视觉定向障碍(综合征)视力', '325', 'H53.852', 'SJDXZAZHZSL', '');
INSERT INTO `05diseases` VALUES ('7496', '中毒性弱视', '471', 'H53.853', 'ZDXRS', '');
INSERT INTO `05diseases` VALUES ('7497', '视力模糊', '325', 'H53.854', 'SLMH', '');
INSERT INTO `05diseases` VALUES ('7498', '视觉障碍 NOS', '325', 'H53.951', 'SJZA', '');
INSERT INTO `05diseases` VALUES ('7499', '黑蒙', '278', 'H54.001', 'HM', '');
INSERT INTO `05diseases` VALUES ('7500', '双眼盲', '430', 'H54.002', 'SYM', '');
INSERT INTO `05diseases` VALUES ('7501', '眼失明', '430', 'H54.003', 'YSM', '');
INSERT INTO `05diseases` VALUES ('7502', '另一眼视力低下单眼盲', '430', 'H54.151', 'LYYSLDXDYM', '');
INSERT INTO `05diseases` VALUES ('7503', '双眼视力低下', '430', 'H54.201', 'SYSLDX', '');
INSERT INTO `05diseases` VALUES ('7504', '双眼视力丧失', '430', 'H54.351', 'SYSLSS', '');
INSERT INTO `05diseases` VALUES ('7505', '单眼盲', '430', 'H54.401', 'DYM', '');
INSERT INTO `05diseases` VALUES ('7506', '单眼视力下降', '430', 'H54.501', 'DYSLXJ', '');
INSERT INTO `05diseases` VALUES ('7507', '单眼性质不明的视力丧失', '430', 'H54.651', 'DYXZBMDSLSS', '');
INSERT INTO `05diseases` VALUES ('7508', '视力丧失', '325', 'H54.751', 'SLSS', '');
INSERT INTO `05diseases` VALUES ('7509', '先天性眼球震颤', '430', 'H55.X01', 'XTXYQZC', '');
INSERT INTO `05diseases` VALUES ('7510', '眼球震颤', '430', 'H55.X02', 'YQZC', '');
INSERT INTO `05diseases` VALUES ('7511', '隐性眼球震颤', '430', 'H55.X51', 'YXYQZC', '');
INSERT INTO `05diseases` VALUES ('7512', '分离性眼球震颤', '430', 'H55.X52', 'FLXYQZC', '');
INSERT INTO `05diseases` VALUES ('7513', '剥夺性眼球震颤', '430', 'H55.X53', 'BDXYQZC', '');
INSERT INTO `05diseases` VALUES ('7514', '艾迪氏综合征(瞳孔)', '354', 'H57.001', 'ADSZHZTK', '');
INSERT INTO `05diseases` VALUES ('7515', '瞳孔散大', '354', 'H57.002', 'TKSD', '');
INSERT INTO `05diseases` VALUES ('7516', '虹膜麻痹', '217', 'H57.003', 'HMMB', '');
INSERT INTO `05diseases` VALUES ('7517', '持久性、非散瞳瞳孔散大', '354', 'H57.051', 'CJXFSTTKSD', '');
INSERT INTO `05diseases` VALUES ('7518', '眼部痛', '430', 'H57.101', 'YBT', '');
INSERT INTO `05diseases` VALUES ('7519', '眼眶痛', '430', 'H57.102', 'YKT', '');
INSERT INTO `05diseases` VALUES ('7520', '假性白内障', '4', 'H57.801', 'JXBNZ', '');
INSERT INTO `05diseases` VALUES ('7521', '眼动脉动脉瘤', '430', 'H57.802', 'YDMDML', '');
INSERT INTO `05diseases` VALUES ('7522', '眼眶综合征', '430', 'H57.803', 'YKZHZ', '');
INSERT INTO `05diseases` VALUES ('7523', '眼球旁囊肿', '430', 'H57.804', 'YQPNZ', '');
INSERT INTO `05diseases` VALUES ('7524', '眼缺血综合征', '430', 'H57.805', 'YQXZHZ', '');
INSERT INTO `05diseases` VALUES ('7525', '眼的其他疾患', '430', 'H57.851', 'YDQTJH', '');
INSERT INTO `05diseases` VALUES ('7526', '眼及附器的其它疾病', '430', 'H57.951', 'YJFQDQTJB', '');
INSERT INTO `05diseases` VALUES ('7527', '白内障术后玻璃体综合征', '330', 'H59.051', 'BNZSHBLTZHZ', '');
INSERT INTO `05diseases` VALUES ('7528', '手术后虹膜嵌顿', '330', 'H59.801', 'SSHHMQD', '');
INSERT INTO `05diseases` VALUES ('7529', '手术后虹膜脱出', '330', 'H59.802', 'SSHHMTC', '');
INSERT INTO `05diseases` VALUES ('7530', '视网膜脱离术后脉络视网膜瘢痕', '330', 'H59.851', 'SWMTLSHMLSWMBH', '');
INSERT INTO `05diseases` VALUES ('7531', '操作后眼疾患 NOS', '430', 'H59.951', 'CZHYJH', '');
INSERT INTO `05diseases` VALUES ('7532', '操作后附器疾患 NOS', '278', 'H59.952', 'CZHFQJH', '');
INSERT INTO `05diseases` VALUES ('7533', '外耳道疖', '70', 'H60.001', 'WEDJ', '');
INSERT INTO `05diseases` VALUES ('7534', '外耳脓肿', '70', 'H60.002', 'WENZ', '');
INSERT INTO `05diseases` VALUES ('7535', '耳廓疖', '70', 'H60.051', 'EKJ', '');
INSERT INTO `05diseases` VALUES ('7536', '耳廓脓肿', '70', 'H60.052', 'EKNZ', '');
INSERT INTO `05diseases` VALUES ('7537', '耳(外)蜂窝织炎', '70', 'H60.151', 'EWFWZY', '');
INSERT INTO `05diseases` VALUES ('7538', '坏死性外耳道炎[恶性外耳道炎]', '70', 'H60.251', 'HSXWEDYEXWEDY', '');
INSERT INTO `05diseases` VALUES ('7539', '出血性外耳炎', '70', 'H60.301', 'CXXWEY', '');
INSERT INTO `05diseases` VALUES ('7540', '耳廓感染', '70', 'H60.302', 'EKGR', '');
INSERT INTO `05diseases` VALUES ('7541', '耳廓瘘感染', '70', 'H60.303', 'EKLGR', '');
INSERT INTO `05diseases` VALUES ('7542', '耳廓软组织感染', '70', 'H60.304', 'EKRZZGR', '');
INSERT INTO `05diseases` VALUES ('7543', '外耳道炎(弥漫性外耳道炎)', '70', 'H60.305', 'WEDYMMXWEDY', '');
INSERT INTO `05diseases` VALUES ('7544', '外耳继发性感染', '70', 'H60.306', 'WEJFXGR', '');
INSERT INTO `05diseases` VALUES ('7545', '游泳者耳病', '70', 'H60.352', 'YYZEB', '');
INSERT INTO `05diseases` VALUES ('7546', '耳廓肉芽肿', '70', 'H60.401', 'EKRYZ', '');
INSERT INTO `05diseases` VALUES ('7547', '外耳道胆脂瘤', '70', 'H60.402', 'WEDDZL', '');
INSERT INTO `05diseases` VALUES ('7548', '外耳道肉芽肿', '70', 'H60.403', 'WEDRYZ', '');
INSERT INTO `05diseases` VALUES ('7549', '阻塞性外耳道角化病', '70', 'H60.451', 'ZSXWEDJHB', '');
INSERT INTO `05diseases` VALUES ('7550', '耳肉芽肿', '70', 'H60.452', 'ERYZ', '');
INSERT INTO `05diseases` VALUES ('7551', '急性外耳道炎', '70', 'H60.501', 'JXWEDY', '');
INSERT INTO `05diseases` VALUES ('7552', '外耳道湿疹', '70', 'H60.502', 'WEDSZ', '');
INSERT INTO `05diseases` VALUES ('7553', '慢性外耳道炎', '70', 'H60.801', 'MXWEDY', '');
INSERT INTO `05diseases` VALUES ('7554', '外耳道炎', '70', 'H60.901', 'WEDY', '');
INSERT INTO `05diseases` VALUES ('7555', '耳廓软骨膜炎', '70', 'H61.001', 'EKRGMY', '');
INSERT INTO `05diseases` VALUES ('7556', '慢性结节性耳轮软骨皮炎', '70', 'H61.051', 'MXJJXELRGPY', '');
INSERT INTO `05diseases` VALUES ('7557', '耳廓瘢痕', '70', 'H61.101', 'EKBH', '');
INSERT INTO `05diseases` VALUES ('7558', '后天性耳廓畸形', '70', 'H61.102', 'HTXEKJX', '');
INSERT INTO `05diseases` VALUES ('7559', '耳廓瘘', '70', 'H61.103', 'EKL', '');
INSERT INTO `05diseases` VALUES ('7560', '烧伤后耳廓缺损', '70', 'H61.105', 'SSHEKQS', '');
INSERT INTO `05diseases` VALUES ('7561', '烧伤后小耳畸形', '70', 'H61.106', 'SSHXEJX', '');
INSERT INTO `05diseases` VALUES ('7562', '双耳垂瘢痕', '70', 'H61.151', 'SECBH', '');
INSERT INTO `05diseases` VALUES ('7563', '耵聍栓塞', '278', 'H61.201', 'DNSS', '');
INSERT INTO `05diseases` VALUES ('7564', '后天性外耳道狭窄', '70', 'H61.301', 'HTXWEDXZ', '');
INSERT INTO `05diseases` VALUES ('7565', '烧伤后外耳道狭窄', '70', 'H61.302', 'SSHWEDXZ', '');
INSERT INTO `05diseases` VALUES ('7566', '外耳道萎陷', '70', 'H61.351', 'WEDWX', '');
INSERT INTO `05diseases` VALUES ('7567', '耳道瘘', '70', 'H61.801', 'EDL', '');
INSERT INTO `05diseases` VALUES ('7568', '后天性外耳道闭锁', '70', 'H61.802', 'HTXWEDBS', '');
INSERT INTO `05diseases` VALUES ('7569', '耳的瘘管', '70', 'H61.803', 'EDLG', '');
INSERT INTO `05diseases` VALUES ('7570', '烧伤后外耳道闭锁', '70', 'H61.804', 'SSHWEDBS', '');
INSERT INTO `05diseases` VALUES ('7571', '外耳道瘢痕', '70', 'H61.805', 'WEDBH', '');
INSERT INTO `05diseases` VALUES ('7572', '外耳道骨疣', '70', 'H61.806', 'WEDGY', '');
INSERT INTO `05diseases` VALUES ('7573', '外耳道坏死', '70', 'H61.807', 'WEDHS', '');
INSERT INTO `05diseases` VALUES ('7574', '外耳道囊肿', '70', 'H61.808', 'WEDNZ', '');
INSERT INTO `05diseases` VALUES ('7575', '后天性外耳畸形', '70', 'H61.851', 'HTXWEJX', '');
INSERT INTO `05diseases` VALUES ('7576', '耳廓肿物', '70', 'H61.901', 'EKZW', '');
INSERT INTO `05diseases` VALUES ('7577', '外耳疾患 NOS', '70', 'H61.951', 'WEJH', '');
INSERT INTO `05diseases` VALUES ('7578', '急性浆液性中耳炎', '70', 'H65.001', 'JXJYXZEY', '');
INSERT INTO `05diseases` VALUES ('7579', '亚急性分泌性中耳炎', '70', 'H65.051', 'YJXFMXZEY', '');
INSERT INTO `05diseases` VALUES ('7580', '急性变应性中耳炎', '70', 'H65.101', 'JXBYXZEY', '');
INSERT INTO `05diseases` VALUES ('7581', '急性卡他性中耳炎', '70', 'H65.102', 'JXKTXZEY', '');
INSERT INTO `05diseases` VALUES ('7582', '蓝鼓膜综合征', '120', 'H65.103', 'LGMZHZ', '');
INSERT INTO `05diseases` VALUES ('7583', '急性浆液粘蛋白性中耳炎', '70', 'H65.151', 'JXJYNDBXZEY', '');
INSERT INTO `05diseases` VALUES ('7584', '急性多血性中耳炎', '70', 'H65.152', 'JXDXXZEY', '');
INSERT INTO `05diseases` VALUES ('7585', '急性渗出性中耳炎', '70', 'H65.153', 'JXSCXZEY', '');
INSERT INTO `05diseases` VALUES ('7586', '慢性卡他性中耳炎', '70', 'H65.201', 'MXKTXZEY', '');
INSERT INTO `05diseases` VALUES ('7587', '慢性浆液性中耳炎', '70', 'H65.251', 'MXJYXZEY', '');
INSERT INTO `05diseases` VALUES ('7588', '慢性卡他性咽鼓管及鼓室', '276', 'H65.252', 'MXKTXYGGJGS', '');
INSERT INTO `05diseases` VALUES ('7589', '慢性分泌性中耳炎', '70', 'H65.301', 'MXFMXZEY', '');
INSERT INTO `05diseases` VALUES ('7590', '慢性粘蛋白性中耳炎', '70', 'H65.351', 'MXNDBXZEY', '');
INSERT INTO `05diseases` VALUES ('7591', '慢性粘液性中耳炎', '70', 'H65.352', 'MXNYXZEY', '');
INSERT INTO `05diseases` VALUES ('7592', '慢性渗出性中耳炎', '70', 'H65.401', 'MXSCXZEY', '');
INSERT INTO `05diseases` VALUES ('7593', '慢性变应性中耳炎', '70', 'H65.451', 'MXBYXZEY', '');
INSERT INTO `05diseases` VALUES ('7594', '慢性浆液粘蛋白性中耳炎', '70', 'H65.452', 'MXJYNDBXZEY', '');
INSERT INTO `05diseases` VALUES ('7595', '陈旧性中耳炎', '70', 'H65.453', 'CJXZEY', '');
INSERT INTO `05diseases` VALUES ('7596', '分泌性中耳炎', '70', 'H65.901', 'FMXZEY', '');
INSERT INTO `05diseases` VALUES ('7597', '卡他性中耳炎', '70', 'H65.902', 'KTXZEY', '');
INSERT INTO `05diseases` VALUES ('7598', '渗出性中耳炎', '70', 'H65.903', 'SCXZEY', '');
INSERT INTO `05diseases` VALUES ('7599', '变应性中耳炎', '70', 'H65.951', 'BYXZEY', '');
INSERT INTO `05diseases` VALUES ('7600', '浆液性中耳炎', '70', 'H65.952', 'JYXZEY', '');
INSERT INTO `05diseases` VALUES ('7601', '浆液粘蛋白性中耳炎', '70', 'H65.953', 'JYNDBXZEY', '');
INSERT INTO `05diseases` VALUES ('7602', '粘液性中耳炎', '70', 'H65.954', 'NYXZEY', '');
INSERT INTO `05diseases` VALUES ('7603', '急性化脓性中耳炎', '70', 'H66.001', 'JXHNXZEY', '');
INSERT INTO `05diseases` VALUES ('7604', '岩尖综合征[格拉代尼戈综合征]', '278', 'H66.051', 'YJZHZGLDNGZHZ', '');
INSERT INTO `05diseases` VALUES ('7605', '慢性咽鼓管及鼓室炎', '122', 'H66.151', 'MXYGGJGSY', '');
INSERT INTO `05diseases` VALUES ('7606', '良性慢性化脓性中耳炎', '70', 'H66.152', 'LXMXHNXZEY', '');
INSERT INTO `05diseases` VALUES ('7607', '慢性鼓窦隐窝炎', '277', 'H66.251', 'MXGDYWY', '');
INSERT INTO `05diseases` VALUES ('7608', '慢性化脓性中耳炎', '70', 'H66.301', 'MXHNXZEY', '');
INSERT INTO `05diseases` VALUES ('7609', '化脓性中耳炎', '70', 'H66.401', 'HNXZEY', '');
INSERT INTO `05diseases` VALUES ('7610', '耳源性脑炎', '70', 'H66.451+', 'EYXNY', '');
INSERT INTO `05diseases` VALUES ('7611', '残余性中耳炎', '70', 'H66.901', 'CYXZEY', '');
INSERT INTO `05diseases` VALUES ('7612', '急性中耳炎', '70', 'H66.902', 'JXZEY', '');
INSERT INTO `05diseases` VALUES ('7613', '慢性中耳炎', '70', 'H66.903', 'MXZEY', '');
INSERT INTO `05diseases` VALUES ('7614', '遗迹性中耳炎', '70', 'H66.904', 'YJXZEY', '');
INSERT INTO `05diseases` VALUES ('7615', '中耳炎', '70', 'H66.905', 'ZEY', '');
INSERT INTO `05diseases` VALUES ('7616', '新生儿中耳炎', '70', 'H66.906', 'XSEZEY', '');
INSERT INTO `05diseases` VALUES ('7617', '慢性化脓性中耳炎伴骨疡', '70', 'H66.951', 'MXHNXZEYBGY', '');
INSERT INTO `05diseases` VALUES ('7618', '咽鼓管炎', '276', 'H68.001', 'YGGY', '');
INSERT INTO `05diseases` VALUES ('7619', '咽鼓管梗阻', '276', 'H68.101', 'YGGGZ', '');
INSERT INTO `05diseases` VALUES ('7620', '咽鼓管狭窄', '276', 'H68.102', 'YGGXZ', '');
INSERT INTO `05diseases` VALUES ('7621', '咽鼓管受压', '276', 'H68.151', 'YGGSY', '');
INSERT INTO `05diseases` VALUES ('7622', '咽鼓管开放症', '276', 'H69.001', 'YGGKFZ', '');
INSERT INTO `05diseases` VALUES ('7623', '咽鼓管的其他疾患', '276', 'H69.801', 'YGGDQTJH', '');
INSERT INTO `05diseases` VALUES ('7624', '咽鼓管疾患 NOS', '276', 'H69.951', 'YGGJH', '');
INSERT INTO `05diseases` VALUES ('7625', '耳后脓肿', '70', 'H70.001', 'EHNZ', '');
INSERT INTO `05diseases` VALUES ('7626', '急性出血性乳突炎', '38', 'H70.002', 'JXCXXRTY', '');
INSERT INTO `05diseases` VALUES ('7627', '急性化脓性乳突炎', '297', 'H70.003', 'JXHNXRTY', '');
INSERT INTO `05diseases` VALUES ('7628', '急性坏死性乳突炎', '297', 'H70.004', 'JXHSXRTY', '');
INSERT INTO `05diseases` VALUES ('7629', '急性乳突炎', '297', 'H70.005', 'JXRTY', '');
INSERT INTO `05diseases` VALUES ('7630', '颞骨骨膜下脓肿(贝佐尔德氏脓肿)', '243', 'H70.006', 'NGGMXNZBZEDSNZ', '');
INSERT INTO `05diseases` VALUES ('7631', '乳突脓肿', '243', 'H70.007', 'RTNZ', '');
INSERT INTO `05diseases` VALUES ('7632', '耳乳头骨(骨膜下)脓肿', '70', 'H70.051', 'ERTGGMXNZ', '');
INSERT INTO `05diseases` VALUES ('7633', '耳后瘘管', '70', 'H70.101', 'EHLG', '');
INSERT INTO `05diseases` VALUES ('7634', '慢性化脓性乳突炎', '297', 'H70.102', 'MXHNXRTY', '');
INSERT INTO `05diseases` VALUES ('7635', '慢性乳突炎', '297', 'H70.103', 'MXRTY', '');
INSERT INTO `05diseases` VALUES ('7636', '乳突骨疽', '187', 'H70.104', 'RTGJ', '');
INSERT INTO `05diseases` VALUES ('7637', '乳突瘘', '212', 'H70.105', 'RTL', '');
INSERT INTO `05diseases` VALUES ('7638', '手术后耳后瘘', '70', 'H70.106', 'SSHEHL', '');
INSERT INTO `05diseases` VALUES ('7639', '手术后乳突瘘', '330', 'H70.107', 'SSHRTL', '');
INSERT INTO `05diseases` VALUES ('7640', '慢性坏死性乳突炎', '297', 'H70.151', 'MXHSXRTY', '');
INSERT INTO `05diseases` VALUES ('7641', '耳(前)后瘘管', '70', 'H70.152', 'EQHLG', '');
INSERT INTO `05diseases` VALUES ('7642', '岩锥炎(颞骨)[岩部炎]', '265', 'H70.201', 'YZYNGYBY', '');
INSERT INTO `05diseases` VALUES ('7643', '岩部骨(骨膜下)脓肿', '243', 'H70.252', 'YBGGMXNZ', '');
INSERT INTO `05diseases` VALUES ('7644', '乳突前庭窝感染', '95', 'H70.851', 'RTQTWGR', '');
INSERT INTO `05diseases` VALUES ('7645', '化脓性乳突炎', '297', 'H70.901', 'HNXRTY', '');
INSERT INTO `05diseases` VALUES ('7646', '乳突炎', '297', 'H70.902', 'RTY', '');
INSERT INTO `05diseases` VALUES ('7647', '乳突内(膜)炎', '277', 'H70.951', 'RTNMY', '');
INSERT INTO `05diseases` VALUES ('7648', '隐蔽性乳突炎[潜伏性乳突炎或非典型乳突炎]', '297', 'H70.952', 'YBXRTYQFXRTYHFDXRTY', '');
INSERT INTO `05diseases` VALUES ('7649', '中耳肉芽肿', '70', 'H71.X01', 'ZERYZ', '');
INSERT INTO `05diseases` VALUES ('7650', '鼓室胆脂瘤', '53', 'H71.X02', 'GSDZL', '');
INSERT INTO `05diseases` VALUES ('7651', '胆脂瘤性中耳炎(慢性化脓性中耳炎胆脂瘤)', '70', 'H71.X03', 'DZLXZEYMXHNXZEYDZL', '');
INSERT INTO `05diseases` VALUES ('7652', '乳突胆脂瘤', '53', 'H71.X04', 'RTDZL', '');
INSERT INTO `05diseases` VALUES ('7653', '原发性乳突胆脂瘤', '53', 'H71.X05', 'YFXRTDZL', '');
INSERT INTO `05diseases` VALUES ('7654', '中耳胆脂瘤', '70', 'H71.X06', 'ZEDZL', '');
INSERT INTO `05diseases` VALUES ('7655', '鼓膜中央部穿孔', '120', 'H72.051', 'GMZYBCK', '');
INSERT INTO `05diseases` VALUES ('7656', '鼓膜上鼓室穿孔', '120', 'H72.151', 'GMSGSCK', '');
INSERT INTO `05diseases` VALUES ('7657', '其他边缘性鼓膜穿孔', '120', 'H72.251', 'QTBYXGMCK', '');
INSERT INTO `05diseases` VALUES ('7658', '多发性鼓膜穿孔', '120', 'H72.851', 'DFXGMCK', '');
INSERT INTO `05diseases` VALUES ('7659', '全部鼓膜穿孔', '120', 'H72.852', 'QBGMCK', '');
INSERT INTO `05diseases` VALUES ('7660', '鼓膜穿孔 NOS', '120', 'H72.902', 'GMCK', '');
INSERT INTO `05diseases` VALUES ('7661', '持续性创伤后鼓膜穿孔', '44', 'H72.951', 'CXXCSHGMCK', '');
INSERT INTO `05diseases` VALUES ('7662', '鼓膜破裂', '120', 'H72.952', 'GMPL', '');
INSERT INTO `05diseases` VALUES ('7663', '大疱性鼓膜炎', '121', 'H73.001', 'DPXGMY', '');
INSERT INTO `05diseases` VALUES ('7664', '急性鼓膜炎', '121', 'H73.002', 'JXGMY', '');
INSERT INTO `05diseases` VALUES ('7665', '急性鼓室炎', '122', 'H73.051', 'JXGSY', '');
INSERT INTO `05diseases` VALUES ('7666', '慢性鼓膜炎', '121', 'H73.101', 'MXGMY', '');
INSERT INTO `05diseases` VALUES ('7667', '肉芽性鼓膜炎', '121', 'H73.102', 'RYXGMY', '');
INSERT INTO `05diseases` VALUES ('7668', '慢性鼓室炎', '122', 'H73.151', 'MXGSY', '');
INSERT INTO `05diseases` VALUES ('7669', '鼓膜萎缩', '120', 'H73.801', 'GMWS', '');
INSERT INTO `05diseases` VALUES ('7670', '鼓膜炎', '121', 'H73.802', 'GMY', '');
INSERT INTO `05diseases` VALUES ('7671', '鼓室炎', '122', 'H73.803', 'GSY', '');
INSERT INTO `05diseases` VALUES ('7672', '鼓室粘连', '278', 'H73.804', 'GSNL', '');
INSERT INTO `05diseases` VALUES ('7673', '血鼓室', '275', 'H73.805', 'XGS', '');
INSERT INTO `05diseases` VALUES ('7674', '鼓膜粘连', '120', 'H73.851', 'GMNL', '');
INSERT INTO `05diseases` VALUES ('7675', '上鼓室炎', '122', 'H73.852', 'SGSY', '');
INSERT INTO `05diseases` VALUES ('7676', '鼓膜硬化', '120', 'H73.853', 'GMYH', '');
INSERT INTO `05diseases` VALUES ('7677', '鼓膜疾患 NOS', '120', 'H73.951', 'GMJH', '');
INSERT INTO `05diseases` VALUES ('7678', '鼓室硬化症', '278', 'H74.001', 'GSYHZ', '');
INSERT INTO `05diseases` VALUES ('7679', '粘连性中耳炎', '70', 'H74.101', 'NLXZEY', '');
INSERT INTO `05diseases` VALUES ('7680', '听骨链中断', '351', 'H74.201', 'TGLZD', '');
INSERT INTO `05diseases` VALUES ('7681', '听骨脱位', '351', 'H74.202', 'TGTW', '');
INSERT INTO `05diseases` VALUES ('7682', '听骨不连续', '351', 'H74.251', 'TGBLX', '');
INSERT INTO `05diseases` VALUES ('7683', '后天性听骨畸形', '148', 'H74.301', 'HTXTGJX', '');
INSERT INTO `05diseases` VALUES ('7684', '听骨固定', '351', 'H74.302', 'TGGD', '');
INSERT INTO `05diseases` VALUES ('7685', '听骨部分丧失', '351', 'H74.351', 'TGBFSS', '');
INSERT INTO `05diseases` VALUES ('7686', '听骨关节强硬', '123', 'H74.352', 'TGGJQY', '');
INSERT INTO `05diseases` VALUES ('7687', '中耳息肉', '70', 'H74.401', 'ZEXR', '');
INSERT INTO `05diseases` VALUES ('7688', '慢性化脓性中耳炎骨疡型(肉芽型)(坏死性)', '70', 'H74.802', 'MXHNXZEYGYXRYXHSX', '');
INSERT INTO `05diseases` VALUES ('7689', '慢性化脓性中耳炎伴肉芽肿', '70', 'H74.803', 'MXHNXZEYBRYZ', '');
INSERT INTO `05diseases` VALUES ('7690', '中耳瘘', '70', 'H74.804', 'ZEL', '');
INSERT INTO `05diseases` VALUES ('7691', '中耳骨疡', '70', 'H74.851', 'ZEGY', '');
INSERT INTO `05diseases` VALUES ('7692', '中耳疾患 NOS', '70', 'H74.951', 'ZEJH', '');
INSERT INTO `05diseases` VALUES ('7693', '乳突疾患 NOS', '278', 'H74.952', 'RTJH', '');
INSERT INTO `05diseases` VALUES ('7694', '非闭塞性耳硬化症累及卵圆窗', '70', 'H80.051', 'FBSXEYHZLJLYC', '');
INSERT INTO `05diseases` VALUES ('7695', '耳硬化症合并卵圆窗闭塞', '70', 'H80.101', 'EYHZHBLYCBS', '');
INSERT INTO `05diseases` VALUES ('7696', '耳蜗耳硬化症', '70', 'H80.251', 'EWEYHZ', '');
INSERT INTO `05diseases` VALUES ('7697', '卵圆窗耳硬化症', '70', 'H80.252', 'LYCEYHZ', '');
INSERT INTO `05diseases` VALUES ('7698', '其他耳硬化症', '70', 'H80.851', 'QTEYHZ', '');
INSERT INTO `05diseases` VALUES ('7699', '耳硬化症 NOS', '70', 'H80.901', 'EYHZ', '');
INSERT INTO `05diseases` VALUES ('7700', '梅尼埃病[美尼尔氏病、内淋巴[迷路]积水', '268', 'H81.001', 'MNABMNESBNLBMLJS', '');
INSERT INTO `05diseases` VALUES ('7701', '迷路性眩晕', '412', 'H81.051', 'MLXXY', '');
INSERT INTO `05diseases` VALUES ('7702', '发作性眩晕', '412', 'H81.101', 'FZXXY', '');
INSERT INTO `05diseases` VALUES ('7703', '良性阵发性眩晕', '412', 'H81.151', 'LXZFXXY', '');
INSERT INTO `05diseases` VALUES ('7704', '前庭神经原炎', '313', 'H81.251', 'QTSJYY', '');
INSERT INTO `05diseases` VALUES ('7705', '耳源性眩晕', '70', 'H81.301', 'EYXXY', '');
INSERT INTO `05diseases` VALUES ('7706', '前庭性眩晕', '412', 'H81.302', 'QTXXY', '');
INSERT INTO `05diseases` VALUES ('7707', '周围前庭眩晕', '412', 'H81.303', 'ZWQTXY', '');
INSERT INTO `05diseases` VALUES ('7708', '莱穆瓦耶综合征', '278', 'H81.351', 'LMWYZHZ', '');
INSERT INTO `05diseases` VALUES ('7709', '耳鸣、耳聋、眩晕综合征', '70', 'H81.352', 'EMELXYZHZ', '');
INSERT INTO `05diseases` VALUES ('7710', '中枢性眩晕', '412', 'H81.401', 'ZSXXY', '');
INSERT INTO `05diseases` VALUES ('7711', '中枢性眼球震颤', '430', 'H81.402', 'ZSXYQZC', '');
INSERT INTO `05diseases` VALUES ('7712', '脑性眩晕', '234', 'H81.451', 'NXXY', '');
INSERT INTO `05diseases` VALUES ('7713', '耳石综合征', '70', 'H81.851', 'ESZHZ', '');
INSERT INTO `05diseases` VALUES ('7714', '前庭外侧核综合征[博尼耶综合征]', '278', 'H81.852', 'QTWCHZHZBNYZHZ', '');
INSERT INTO `05diseases` VALUES ('7715', '前庭功能低下', '278', 'H81.901', 'QTGNDX', '');
INSERT INTO `05diseases` VALUES ('7716', '前庭功能障碍', '278', 'H81.902', 'QTGNZA', '');
INSERT INTO `05diseases` VALUES ('7717', '前庭系统病变', '268', 'H81.903', 'QTXTBB', '');
INSERT INTO `05diseases` VALUES ('7718', '眩晕综合征', '412', 'H81.904', 'XYZHZ', '');
INSERT INTO `05diseases` VALUES ('7719', '前庭神功能疾患 NOS', '278', 'H81.951', 'QTSGNJH', '');
INSERT INTO `05diseases` VALUES ('7720', '迷路炎', '277', 'H83.001', 'MLY', '');
INSERT INTO `05diseases` VALUES ('7721', '迷路周围炎', '277', 'H83.002', 'MLZWY', '');
INSERT INTO `05diseases` VALUES ('7722', '急性迷路充血', '275', 'H83.051', 'JXMLCX', '');
INSERT INTO `05diseases` VALUES ('7723', '内耳充血', '70', 'H83.052', 'NECX', '');
INSERT INTO `05diseases` VALUES ('7724', '半规管瘘', '212', 'H83.101', 'BGGL', '');
INSERT INTO `05diseases` VALUES ('7725', '迷路瘘', '212', 'H83.102', 'MLL', '');
INSERT INTO `05diseases` VALUES ('7726', '半规管轻瘫', '175', 'H83.201', 'BGGQT', '');
INSERT INTO `05diseases` VALUES ('7727', '迷路机能减退', '278', 'H83.251', 'MLJNJT', '');
INSERT INTO `05diseases` VALUES ('7728', '迷路过敏', '278', 'H83.252', 'MLGM', '');
INSERT INTO `05diseases` VALUES ('7729', '爆炸性耳聋(声创伤性聋)', '70', 'H83.301', 'BZXELSCSXL', '');
INSERT INTO `05diseases` VALUES ('7730', '噪音性聋', '71', 'H83.351', 'ZYXL', '');
INSERT INTO `05diseases` VALUES ('7731', '迷路出血', '38', 'H83.801', 'MLCX', '');
INSERT INTO `05diseases` VALUES ('7732', '自发性圆窗膜破裂', '278', 'H83.802', 'ZFXYCMPL', '');
INSERT INTO `05diseases` VALUES ('7733', '慢性迷路出血', '38', 'H83.851', 'MXMLCX', '');
INSERT INTO `05diseases` VALUES ('7734', '内听道肿物', '350', 'H83.901', 'NTDZW', '');
INSERT INTO `05diseases` VALUES ('7735', '内耳疾病 NOS', '70', 'H83.951', 'NEJB', '');
INSERT INTO `05diseases` VALUES ('7736', '双侧传导性听觉丧失', '352', 'H90.051', 'SCCDXTJSS', '');
INSERT INTO `05diseases` VALUES ('7737', '单侧传导性听觉丧失，对侧听觉不受限制', '352', 'H90.151', 'DCCDXTJSSDCTJBSXZ', '');
INSERT INTO `05diseases` VALUES ('7738', '传导性耳聋', '70', 'H90.201', 'CDXEL', '');
INSERT INTO `05diseases` VALUES ('7739', '双侧感音神经性听觉丧失', '313', 'H90.351', 'SCGYSJXTJSS', '');
INSERT INTO `05diseases` VALUES ('7740', '单侧感音神经性听觉丧失，对侧听觉不受限制', '313', 'H90.451', 'DCGYSJXTJSSDCTJBSXZ', '');
INSERT INTO `05diseases` VALUES ('7741', '感觉神经性耳聋', '313', 'H90.501', 'GJSJXEL', '');
INSERT INTO `05diseases` VALUES ('7742', '神经性聋[感音性聋]', '313', 'H90.551', 'SJXLGYXL', '');
INSERT INTO `05diseases` VALUES ('7743', '先天性聋', '383', 'H90.552', 'XTXL', '');
INSERT INTO `05diseases` VALUES ('7744', '传感性听觉丧失', '352', 'H90.553', 'CGXTJSS', '');
INSERT INTO `05diseases` VALUES ('7745', '双侧混合性感音神经性听觉丧失', '313', 'H90.651', 'SCHHXGYSJXTJSS', '');
INSERT INTO `05diseases` VALUES ('7746', '双侧混合性传导性听觉丧失', '352', 'H90.652', 'SCHHXCDXTJSS', '');
INSERT INTO `05diseases` VALUES ('7747', '单侧混合性传导性听觉丧失，对侧听觉不受限制', '352', 'H90.752', 'DCHHXCDXTJSSDCTJBSXZ', '');
INSERT INTO `05diseases` VALUES ('7748', '混合性聋(传导性和感觉神经性聋)', '313', 'H90.801', 'HHXLCDXHGJSJXL', '');
INSERT INTO `05diseases` VALUES ('7749', '药物性聋', '71', 'H91.001', 'YWXL', '');
INSERT INTO `05diseases` VALUES ('7750', '中毒性聋', '471', 'H91.051', 'ZDXL', '');
INSERT INTO `05diseases` VALUES ('7751', '老年性聋', '71', 'H91.151', 'LNXL', '');
INSERT INTO `05diseases` VALUES ('7752', '突发性耳聋[特发性聋]', '70', 'H91.201', 'TFXELTFXL', '');
INSERT INTO `05diseases` VALUES ('7753', '聋哑症', '71', 'H91.301', 'LYZ', '');
INSERT INTO `05diseases` VALUES ('7754', '创伤性聋', '71', 'H91.801', 'CSXL', '');
INSERT INTO `05diseases` VALUES ('7755', '其他特指听觉丧失', '352', 'H91.851', 'QTTZTJSS', '');
INSERT INTO `05diseases` VALUES ('7756', '耳聋 NOS', '70', 'H91.901', 'EL', '');
INSERT INTO `05diseases` VALUES ('7757', '听觉问题', '353', 'H91.902', 'TJWT', '');
INSERT INTO `05diseases` VALUES ('7758', '听力减退', '353', 'H91.903', 'TLJT', '');
INSERT INTO `05diseases` VALUES ('7759', '高频率聋(症)', '71', 'H91.951', 'GPLLZ', '');
INSERT INTO `05diseases` VALUES ('7760', '低频率聋(症)', '71', 'H91.952', 'DPLLZ', '');
INSERT INTO `05diseases` VALUES ('7761', '耳神经痛', '313', 'H92.001', 'ESJT', '');
INSERT INTO `05diseases` VALUES ('7762', '耳痛', '70', 'H92.002', 'ET', '');
INSERT INTO `05diseases` VALUES ('7763', '乳突痛', '273', 'H92.051', 'RTT', '');
INSERT INTO `05diseases` VALUES ('7764', '耳流脓', '70', 'H92.151', 'ELN', '');
INSERT INTO `05diseases` VALUES ('7765', '耳出血', '70', 'H92.251', 'ECX', '');
INSERT INTO `05diseases` VALUES ('7766', '短暂性缺血性聋', '71', 'H93.001', 'DZXQXXL', '');
INSERT INTO `05diseases` VALUES ('7767', '血管性耳鸣', '70', 'H93.002', 'XGXEM', '');
INSERT INTO `05diseases` VALUES ('7768', '耳鸣', '70', 'H93.101', 'EM', '');
INSERT INTO `05diseases` VALUES ('7769', '复听', '353', 'H93.201', 'FT', '');
INSERT INTO `05diseases` VALUES ('7770', '听功能障碍', '353', 'H93.202', 'TGNZA', '');
INSERT INTO `05diseases` VALUES ('7771', '位听神经炎', '313', 'H93.301', 'WTSJY', '');
INSERT INTO `05diseases` VALUES ('7772', '听神经麻痹(第八神经)', '313', 'H93.351', 'TSJMBDBSJ', '');
INSERT INTO `05diseases` VALUES ('7773', '耳后血肿机化', '70', 'H93.801', 'EHXZJH', '');
INSERT INTO `05diseases` VALUES ('7774', '外耳道萎缩', '70', 'H93.851', 'WEDWS', '');
INSERT INTO `05diseases` VALUES ('7775', '耳疾患 NOS', '70', 'H93.951', 'EJH', '');
INSERT INTO `05diseases` VALUES ('7776', '乳突切除术后空腔的(复发性)胆脂瘤', '53', 'H95.051', 'RTQCSHKQDFFXDZL', '');
INSERT INTO `05diseases` VALUES ('7777', '乳突切除术后并发症', '330', 'H95.101', 'RTQCSHBFZ', '');
INSERT INTO `05diseases` VALUES ('7778', '乳突切除术后空腔感染', '95', 'H95.102', 'RTQCSHKQGR', '');
INSERT INTO `05diseases` VALUES ('7779', '乳突切除术后腔的囊肿', '231', 'H95.151', 'RTQCSHQDNZ', '');
INSERT INTO `05diseases` VALUES ('7780', '乳突切除术后腔的肉芽形成', '330', 'H95.152', 'RTQCSHQDRYXC', '');
INSERT INTO `05diseases` VALUES ('7781', '乳突切除术后腔慢性炎症', '330', 'H95.153', 'RTQCSHQMXYZ', '');
INSERT INTO `05diseases` VALUES ('7782', '其他耳操作后疾患', '70', 'H95.852', 'QTECZHJH', '');
INSERT INTO `05diseases` VALUES ('7783', '其他乳突操作后疾患', '278', 'H95.853', 'QTRTCZHJH', '');
INSERT INTO `05diseases` VALUES ('7784', '耳操作后疾患 NOS', '70', 'H95.951', 'ECZHJH', '');
INSERT INTO `05diseases` VALUES ('7785', '乳突操作后疾患 NOS', '278', 'H95.952', 'RTCZHJH', '');
INSERT INTO `05diseases` VALUES ('7786', '风湿活动', '278', 'I00.X01', 'FSHD', '');
INSERT INTO `05diseases` VALUES ('7787', '风湿热', '271', 'I00.X02', 'FSR', '');
INSERT INTO `05diseases` VALUES ('7788', '风湿性关节炎', '123', 'I00.X03', 'FSXGJY', '');
INSERT INTO `05diseases` VALUES ('7789', '急性风湿热', '271', 'I00.X04', 'JXFSR', '');
INSERT INTO `05diseases` VALUES ('7790', '急性(亚急性)风湿性关节炎', '123', 'I00.X05', 'JXYJXFSXGJY', '');
INSERT INTO `05diseases` VALUES ('7791', '风湿性脊柱炎', '155', 'I00.X06+', 'FSXJZY', '');
INSERT INTO `05diseases` VALUES ('7792', '急性风湿性心包炎', '394', 'I01.001', 'JXFSXXBY', '');
INSERT INTO `05diseases` VALUES ('7793', '风湿性心包炎', '394', 'I01.051', 'FSXXBY', '');
INSERT INTO `05diseases` VALUES ('7794', '急性活动性风湿性心包炎伴肺炎', '81', 'I01.052', 'JXHDXFSXXBYBFY', '');
INSERT INTO `05diseases` VALUES ('7795', '急性风湿性心内膜炎', '401', 'I01.101', 'JXFSXXNMY', '');
INSERT INTO `05diseases` VALUES ('7796', '急性风湿性瓣膜炎', '277', 'I01.151', 'JXFSXBMY', '');
INSERT INTO `05diseases` VALUES ('7797', '急性风湿性心肌炎', '397', 'I01.201', 'JXFSXXJY', '');
INSERT INTO `05diseases` VALUES ('7798', '急性风湿性全心炎', '404', 'I01.801', 'JXFSXQXY', '');
INSERT INTO `05diseases` VALUES ('7799', '急性风湿性心脏病', '403', 'I01.901', 'JXFSXXZB', '');
INSERT INTO `05diseases` VALUES ('7800', '风湿性舞蹈病伴心脏受累', '403', 'I02.051', 'FSXWDBBXZSL', '');
INSERT INTO `05diseases` VALUES ('7801', '风湿性舞蹈病伴二尖瓣和主动脉瓣及三尖瓣的心内膜炎', '477', 'I02.052', 'FSXWDBBEJBHZDMBJSJBD', '');
INSERT INTO `05diseases` VALUES ('7802', '风湿性舞蹈症伴病毒性心肌炎[西德纳姆]', '397', 'I02.053', 'FSXWDZBBDXXJYXDNM', '');
INSERT INTO `05diseases` VALUES ('7803', '风湿性舞蹈症[西德纳姆]伴二尖瓣的心内膜炎', '401', 'I02.054', 'FSXWDZXDNMBEJBDXNMY', '');
INSERT INTO `05diseases` VALUES ('7804', '风湿性舞蹈症[西德纳姆]伴肺瓣膜心内膜炎', '401', 'I02.055', 'FSXWDZXDNMBFBMXNMY', '');
INSERT INTO `05diseases` VALUES ('7805', '风湿性舞蹈症[西德纳姆]伴三尖瓣心内膜炎', '401', 'I02.056', 'FSXWDZXDNMBSJBXNMY', '');
INSERT INTO `05diseases` VALUES ('7806', '风湿性舞蹈症[西德纳姆]伴心包炎', '394', 'I02.057', 'FSXWDZXDNMBXBY', '');
INSERT INTO `05diseases` VALUES ('7807', '风湿性舞蹈症[西德纳姆]伴心肌炎', '397', 'I02.058', 'FSXWDZXDNMBXJY', '');
INSERT INTO `05diseases` VALUES ('7808', '风湿性舞蹈症[西德纳姆]伴心内膜炎', '401', 'I02.059', 'FSXWDZXDNMBXNMY', '');
INSERT INTO `05diseases` VALUES ('7809', '风湿性舞蹈症[西德纳姆]伴主动脉瓣心内膜炎', '477', 'I02.060', 'FSXWDZXDNMBZDMBXNMY', '');
INSERT INTO `05diseases` VALUES ('7810', '风湿性舞蹈病', '268', 'I02.901', 'FSXWDB', '');
INSERT INTO `05diseases` VALUES ('7811', '急性风湿性舞蹈病', '268', 'I02.902', 'JXFSXWDB', '');
INSERT INTO `05diseases` VALUES ('7812', '慢性风湿性舞蹈病', '268', 'I02.903', 'MXFSXWDB', '');
INSERT INTO `05diseases` VALUES ('7813', '西德纳姆舞蹈症(重症)(小)(痉挛性)', '179', 'I02.951', 'XDNMWDZZZXJLX', '');
INSERT INTO `05diseases` VALUES ('7814', '风湿性二尖瓣狭窄', '72', 'I05.001', 'FSXEJBXZ', '');
INSERT INTO `05diseases` VALUES ('7815', '风湿性二尖瓣闭锁不全', '72', 'I05.101', 'FSXEJBBSBQ', '');
INSERT INTO `05diseases` VALUES ('7816', '风湿性二尖瓣回流', '72', 'I05.151', 'FSXEJBHL', '');
INSERT INTO `05diseases` VALUES ('7817', '风湿性二尖瓣狭窄伴闭锁不全随', '72', 'I05.201', 'FSXEJBXZBBSBQS', '');
INSERT INTO `05diseases` VALUES ('7818', '二尖瓣狭窄闭锁不全', '72', 'I05.202', 'EJBXZBSBQ', '');
INSERT INTO `05diseases` VALUES ('7819', '二尖瓣钙化', '72', 'I05.801', 'EJBGH', '');
INSERT INTO `05diseases` VALUES ('7820', '二尖瓣衰竭', '72', 'I05.851', 'EJBSJ', '');
INSERT INTO `05diseases` VALUES ('7821', '二尖瓣病 NOS', '72', 'I05.901', 'EJBB', '');
INSERT INTO `05diseases` VALUES ('7822', '风湿性主动脉瓣狭窄', '477', 'I06.001', 'FSXZDMBXZ', '');
INSERT INTO `05diseases` VALUES ('7823', '风湿性主动脉(瓣)梗阻', '477', 'I06.051', 'FSXZDMBGZ', '');
INSERT INTO `05diseases` VALUES ('7824', '风湿性主动脉瓣闭锁不全', '477', 'I06.101', 'FSXZDMBBSBQ', '');
INSERT INTO `05diseases` VALUES ('7825', '风湿性主动脉瓣返流', '477', 'I06.102', 'FSXZDMBFL', '');
INSERT INTO `05diseases` VALUES ('7826', '风湿性主动脉瓣狭窄伴闭锁不全', '477', 'I06.201', 'FSXZDMBXZBBSBQ', '');
INSERT INTO `05diseases` VALUES ('7827', '其他风湿性主动脉(瓣)疾病', '477', 'I06.851', 'QTFSXZDMBJB', '');
INSERT INTO `05diseases` VALUES ('7828', '风湿性主动脉(瓣)疾病 NOS', '477', 'I06.951', 'FSXZDMBJB', '');
INSERT INTO `05diseases` VALUES ('7829', '风湿性三尖瓣狭窄', '303', 'I07.001', 'FSXSJBXZ', '');
INSERT INTO `05diseases` VALUES ('7830', '三尖瓣狭窄', '303', 'I07.002', 'SJBXZ', '');
INSERT INTO `05diseases` VALUES ('7831', '三尖瓣闭锁不全', '303', 'I07.101', 'SJBBSBQ', '');
INSERT INTO `05diseases` VALUES ('7832', '风湿性三尖瓣关闭不全', '303', 'I07.151', 'FSXSJBGBBQ', '');
INSERT INTO `05diseases` VALUES ('7833', '三尖瓣返流', '303', 'I07.152', 'SJBFL', '');
INSERT INTO `05diseases` VALUES ('7834', '三尖瓣狭窄伴关闭不全', '303', 'I07.201', 'SJBXZBGBBQ', '');
INSERT INTO `05diseases` VALUES ('7835', '其他三尖瓣疾病', '303', 'I07.851', 'QTSJBJB', '');
INSERT INTO `05diseases` VALUES ('7836', '三尖瓣疾病 NOS', '303', 'I07.951', 'SJBJB', '');
INSERT INTO `05diseases` VALUES ('7837', '二尖瓣闭锁不全伴主动脉瓣狭窄', '477', 'I08.001', 'EJBBSBQBZDMBXZ', '');
INSERT INTO `05diseases` VALUES ('7838', '二尖瓣闭锁不全伴主动脉瓣狭窄和主动脉漏', '477', 'I08.002', 'EJBBSBQBZDMBXZHZDML', '');
INSERT INTO `05diseases` VALUES ('7839', '二尖瓣闭锁不全及主动脉瓣狭窄闭锁不全', '477', 'I08.003', 'EJBBSBQJZDMBXZBSBQ', '');
INSERT INTO `05diseases` VALUES ('7840', '二尖瓣及主动脉瓣闭锁不全', '477', 'I08.004', 'EJBJZDMBBSBQ', '');
INSERT INTO `05diseases` VALUES ('7841', '二尖瓣及主动脉瓣畸形', '477', 'I08.005', 'EJBJZDMBJX', '');
INSERT INTO `05diseases` VALUES ('7842', '二尖瓣狭窄伴主动脉瓣返流', '477', 'I08.006', 'EJBXZBZDMBFL', '');
INSERT INTO `05diseases` VALUES ('7843', '二尖瓣及主动脉瓣狭窄', '477', 'I08.007', 'EJBJZDMBXZ', '');
INSERT INTO `05diseases` VALUES ('7844', '二尖瓣狭窄伴主动脉瓣狭窄', '477', 'I08.008', 'EJBXZBZDMBXZ', '');
INSERT INTO `05diseases` VALUES ('7845', '二尖瓣及主动脉瓣狭窄闭锁不全', '477', 'I08.009', 'EJBJZDMBXZBSBQ', '');
INSERT INTO `05diseases` VALUES ('7846', '二尖瓣狭窄伴主动脉瓣狭窄闭锁不全', '477', 'I08.010', 'EJBXZBZDMBXZBSBQ', '');
INSERT INTO `05diseases` VALUES ('7847', '二尖瓣狭窄闭锁不全伴主动脉狭窄', '477', 'I08.011', 'EJBXZBSBQBZDMXZ', '');
INSERT INTO `05diseases` VALUES ('7848', '二尖瓣狭窄关闭不全及主动脉瓣关闭不全', '477', 'I08.012', 'EJBXZGBBQJZDMBGBBQ', '');
INSERT INTO `05diseases` VALUES ('7849', '风湿性二尖瓣及主动脉瓣闭锁不全', '477', 'I08.013', 'FSXEJBJZDMBBSBQ', '');
INSERT INTO `05diseases` VALUES ('7850', '风湿性二尖瓣闭锁不全伴主动脉瓣狭窄', '477', 'I08.014', 'FSXEJBBSBQBZDMBXZ', '');
INSERT INTO `05diseases` VALUES ('7851', '风湿性二尖瓣闭锁不全伴主动脉瓣狭窄和漏', '477', 'I08.015', 'FSXEJBBSBQBZDMBXZHL', '');
INSERT INTO `05diseases` VALUES ('7852', '心内膜炎并主动脉瓣二尖瓣穿孔', '477', 'I08.016', 'XNMYBZDMBEJBCK', '');
INSERT INTO `05diseases` VALUES ('7853', '风湿性二尖瓣闭锁不全伴主动脉狭窄、闭锁不全', '477', 'I08.051', 'FSXEJBBSBQBZDMXZBSBQ', '');
INSERT INTO `05diseases` VALUES ('7854', '风湿性二尖瓣狭窄、闭锁不全伴主动脉瓣、闭锁不全', '477', 'I08.052', 'FSXEJBXZBSBQBZDMBBSB', '');
INSERT INTO `05diseases` VALUES ('7855', '风湿性二尖瓣狭窄伴主动脉瓣、闭锁不全', '477', 'I08.053', 'FSXEJBXZBZDMBBSBQ', '');
INSERT INTO `05diseases` VALUES ('7856', '风湿性二尖瓣狭窄伴主动脉瓣狭窄、闭锁不全', '477', 'I08.054', 'FSXEJBXZBZDMBXZBSBQ', '');
INSERT INTO `05diseases` VALUES ('7857', '二尖瓣和三尖瓣的疾患', '72', 'I08.151', 'EJBHSJBDJH', '');
INSERT INTO `05diseases` VALUES ('7858', '主动脉瓣和三尖瓣的疾患', '477', 'I08.251', 'ZDMBHSJBDJH', '');
INSERT INTO `05diseases` VALUES ('7859', '二尖瓣、主动脉瓣、三尖瓣合并疾患', '477', 'I08.351', 'EJBZDMBSJBHBJH', '');
INSERT INTO `05diseases` VALUES ('7860', '风湿性联合瓣膜病', '268', 'I08.851', 'FSXLHBMB', '');
INSERT INTO `05diseases` VALUES ('7861', '多个心瓣膜疾病 NOS', '392', 'I08.951', 'DGXBMJB', '');
INSERT INTO `05diseases` VALUES ('7862', '风湿性心肌[阿朔夫小体]', '397', 'I09.001', 'FSXXJASFXT', '');
INSERT INTO `05diseases` VALUES ('7863', '慢性风湿性心脏病', '403', 'I09.051', 'MXFSXXZB', '');
INSERT INTO `05diseases` VALUES ('7864', '慢性风湿性心内膜炎', '401', 'I09.151', 'MXFSXXNMY', '');
INSERT INTO `05diseases` VALUES ('7865', '慢性风湿性心瓣膜炎', '392', 'I09.152', 'MXFSXXBMY', '');
INSERT INTO `05diseases` VALUES ('7866', '风湿性粘连性心包炎', '394', 'I09.201', 'FSXNLXXBY', '');
INSERT INTO `05diseases` VALUES ('7867', '慢性风湿性心包炎', '394', 'I09.202', 'MXFSXXBY', '');
INSERT INTO `05diseases` VALUES ('7868', '慢性风湿性心肌心包炎', '397', 'I09.203', 'MXFSXXJXBY', '');
INSERT INTO `05diseases` VALUES ('7869', '慢性风湿性纵隔心包炎', '394', 'I09.204', 'MXFSXZGXBY', '');
INSERT INTO `05diseases` VALUES ('7870', '慢性风湿性心肌炎', '397', 'I09.251', 'MXFSXXJY', '');
INSERT INTO `05diseases` VALUES ('7871', '风湿性肺动脉瓣闭锁不全', '80', 'I09.801', 'FSXFDMBBSBQ', '');
INSERT INTO `05diseases` VALUES ('7872', '风湿性肺动脉瓣狭窄', '80', 'I09.802', 'FSXFDMBXZ', '');
INSERT INTO `05diseases` VALUES ('7873', '风湿性全心炎', '404', 'I09.803', 'FSXQXY', '');
INSERT INTO `05diseases` VALUES ('7874', '风湿性心脏肥大', '403', 'I09.851', 'FSXXZFD', '');
INSERT INTO `05diseases` VALUES ('7875', '风湿性心脏病(RHD)', '403', 'I09.901', 'FSXXZB', '');
INSERT INTO `05diseases` VALUES ('7876', '恶性高血压[急进型高血压病]', '99', 'I10.X01', 'EXGXYJJXGXYB', '');
INSERT INTO `05diseases` VALUES ('7877', '高血压', '99', 'I10.X02', 'GXY', '');
INSERT INTO `05diseases` VALUES ('7878', '高血压I', '99', 'I10.X03', 'GXY', '');
INSERT INTO `05diseases` VALUES ('7879', '高血压Ⅱ', '99', 'I10.X04', 'GXYE', '');
INSERT INTO `05diseases` VALUES ('7880', '高血压Ⅲ', '99', 'I10.X05', 'GXYS', '');
INSERT INTO `05diseases` VALUES ('7881', '高血压危象', '99', 'I10.X06', 'GXYWX', '');
INSERT INTO `05diseases` VALUES ('7882', '老年收缩期高血压', '99', 'I10.X07', 'LNSSQGXY', '');
INSERT INTO `05diseases` VALUES ('7883', '良性高血压', '99', 'I10.X08', 'LXGXY', '');
INSERT INTO `05diseases` VALUES ('7884', '临界性高血压', '99', 'I10.X09', 'LJXGXY', '');
INSERT INTO `05diseases` VALUES ('7885', '特发性高血压', '99', 'I10.X10', 'TFXGXY', '');
INSERT INTO `05diseases` VALUES ('7886', '原发性高血压', '99', 'I10.X11', 'YFXGXY', '');
INSERT INTO `05diseases` VALUES ('7887', '高血压性心脏病，伴有(充血性)心力衰竭', '403', 'I11.051', 'GXYXXZBBYCXXXLSJ', '');
INSERT INTO `05diseases` VALUES ('7888', '高血压性心力衰竭', '99', 'I11.052', 'GXYXXLSJ', '');
INSERT INTO `05diseases` VALUES ('7889', '高血压性心脏病 NOS', '403', 'I11.901', 'GXYXXZB', '');
INSERT INTO `05diseases` VALUES ('7890', '高血压性心脏病，不伴有(充血性)心力衰竭', '403', 'I11.951', 'GXYXXZBBBYCXXXLSJ', '');
INSERT INTO `05diseases` VALUES ('7891', '高血压性肾衰竭', '314', 'I12.001', 'GXYXSSJ', '');
INSERT INTO `05diseases` VALUES ('7892', '动脉硬化性肾病', '63', 'I12.901', 'DMYHXSB', '');
INSERT INTO `05diseases` VALUES ('7893', '动脉硬化性肾炎', '315', 'I12.902', 'DMYHXSY', '');
INSERT INTO `05diseases` VALUES ('7894', '高血压性肾病(肾性高血压)', '314', 'I12.903', 'GXYXSBSXGXY', '');
INSERT INTO `05diseases` VALUES ('7895', '肾动脉硬化', '63', 'I12.904', 'SDMYH', '');
INSERT INTO `05diseases` VALUES ('7896', '肾萎缩伴有高血压', '314', 'I12.905', 'SWSBYGXY', '');
INSERT INTO `05diseases` VALUES ('7897', '小动脉性肾炎', '315', 'I12.906', 'XDMXSY', '');
INSERT INTO `05diseases` VALUES ('7898', '小动脉性肾硬化', '260', 'I12.907', 'XDMXSYH', '');
INSERT INTO `05diseases` VALUES ('7899', '高血压性肾炎', '315', 'I12.951', 'GXYXSY', '');
INSERT INTO `05diseases` VALUES ('7900', '高血压性心脏病和肾脏病伴有(充血性)心力衰竭', '403', 'I13.051', 'GXYXXZBHSZBBYCXXXLSJ', '');
INSERT INTO `05diseases` VALUES ('7901', '高血压性心脏病和肾脏病伴有肾衰竭', '403', 'I13.151', 'GXYXXZBHSZBBYSSJ', '');
INSERT INTO `05diseases` VALUES ('7902', '高血压性心脏病和肾脏病同时伴有(充血性)心力衰竭和肾衰竭', '403', 'I13.251', 'GXYXXZBHSZBTSBYCXXXL', '');
INSERT INTO `05diseases` VALUES ('7903', '高血压性心脏病及肾脏病 NOS', '403', 'I13.908', 'GXYXXZBJSZB', '');
INSERT INTO `05diseases` VALUES ('7904', '肾性高血压伴高血压性心脏病', '403', 'I13.909', 'SXGXYBGXYXXZB', '');
INSERT INTO `05diseases` VALUES ('7905', '心肾综合征', '314', 'I13.951', 'XSZHZ', '');
INSERT INTO `05diseases` VALUES ('7906', '肾血管性高血压', '314', 'I15.001', 'SXGXGXY', '');
INSERT INTO `05diseases` VALUES ('7907', '肾实质性高血压病', '314', 'I15.101', 'SSZXGXYB', '');
INSERT INTO `05diseases` VALUES ('7908', '肾性高血压', '314', 'I15.102', 'SXGXY', '');
INSERT INTO `05diseases` VALUES ('7909', '继发于其他肾疾患的高血压', '314', 'I15.151', 'JFYQTSJHDGXY', '');
INSERT INTO `05diseases` VALUES ('7910', '继发于内分泌疾患的高血压', '99', 'I15.251', 'JFYNFMJHDGXY', '');
INSERT INTO `05diseases` VALUES ('7911', '口服避孕药高血压', '191', 'I15.801', 'KFBYYGXY', '');
INSERT INTO `05diseases` VALUES ('7912', '其它继发性高血压', '99', 'I15.802', 'QTJFXGXY', '');
INSERT INTO `05diseases` VALUES ('7913', '继发性高血压', '99', 'I15.901', 'JFXGXY', '');
INSERT INTO `05diseases` VALUES ('7914', '不稳定性心绞痛', '398', 'I20.001', 'BWDXXJT', '');
INSERT INTO `05diseases` VALUES ('7915', '梗塞前综合征', '278', 'I20.002', 'GSQZHZ', '');
INSERT INTO `05diseases` VALUES ('7916', '增强型心绞痛', '398', 'I20.051', 'ZQXXJT', '');
INSERT INTO `05diseases` VALUES ('7917', '心肌梗死前综合征', '397', 'I20.052', 'XJGSQZHZ', '');
INSERT INTO `05diseases` VALUES ('7918', '中间型冠状动脉综合征', '125', 'I20.053', 'ZJXGZDMZHZ', '');
INSERT INTO `05diseases` VALUES ('7919', '劳力恶化型心绞痛', '398', 'I20.054', 'LLEHXXJT', '');
INSERT INTO `05diseases` VALUES ('7920', '劳力再次型心绞痛', '398', 'I20.055', 'LLZCXXJT', '');
INSERT INTO `05diseases` VALUES ('7921', '梗死前心绞痛', '398', 'I20.056', 'GSQXJT', '');
INSERT INTO `05diseases` VALUES ('7922', '冠状动脉痉挛', '125', 'I20.101', 'GZDMJL', '');
INSERT INTO `05diseases` VALUES ('7923', '普林兹梅特尔', '278', 'I20.151', 'PLZMTE', '');
INSERT INTO `05diseases` VALUES ('7924', '心绞痛Ｘ－综合征[微血管型心绞痛]', '398', 'I20.152', 'XJTZHZWXGXXJT', '');
INSERT INTO `05diseases` VALUES ('7925', '变异型心绞痛', '398', 'I20.153', 'BYXXJT', '');
INSERT INTO `05diseases` VALUES ('7926', 'Ｘ综合征', '278', 'I20.801', 'ZHZ', '');
INSERT INTO `05diseases` VALUES ('7927', '梗塞后心绞痛', '398', 'I20.802', 'GSHXJT', '');
INSERT INTO `05diseases` VALUES ('7928', '混合型心绞痛', '398', 'I20.803', 'HHXXJT', '');
INSERT INTO `05diseases` VALUES ('7929', '劳力型心绞痛', '398', 'I20.804', 'LLXXJT', '');
INSERT INTO `05diseases` VALUES ('7930', '稳定性心绞痛', '398', 'I20.805', 'WDXXJT', '');
INSERT INTO `05diseases` VALUES ('7931', '狭心症', '404', 'I20.851', 'XXZ', '');
INSERT INTO `05diseases` VALUES ('7932', '心绞痛 NOS', '398', 'I20.902', 'XJT', '');
INSERT INTO `05diseases` VALUES ('7933', '缺血性胸痛', '273', 'I20.951', 'QXXXT', '');
INSERT INTO `05diseases` VALUES ('7934', '心绞痛综合症(血管运动型)', '398', 'I20.952', 'XJTZHZXGYDX', '');
INSERT INTO `05diseases` VALUES ('7935', '急性前壁侧壁心肌梗死', '397', 'I21.001', 'JXQBCBXJGS', '');
INSERT INTO `05diseases` VALUES ('7936', '急性前壁心肌梗死', '397', 'I21.002', 'JXQBXJGS', '');
INSERT INTO `05diseases` VALUES ('7937', '急性前膈心肌梗死', '397', 'I21.003', 'JXQGXJGS', '');
INSERT INTO `05diseases` VALUES ('7938', '急性前间壁心肌梗死', '397', 'I21.004', 'JXQJBXJGS', '');
INSERT INTO `05diseases` VALUES ('7939', '前壁尖部急性透壁心肌梗死', '397', 'I21.051', 'QBJBJXTBXJGS', '');
INSERT INTO `05diseases` VALUES ('7940', '急性膈面(下壁)心肌梗死', '397', 'I21.101', 'JXGMXBXJGS', '');
INSERT INTO `05diseases` VALUES ('7941', '急性膈面心肌梗死', '397', 'I21.102', 'JXGMXJGS', '');
INSERT INTO `05diseases` VALUES ('7942', '急性下壁心肌梗死', '397', 'I21.103', 'JXXBXJGS', '');
INSERT INTO `05diseases` VALUES ('7943', '膈壁急性透壁心肌梗死', '397', 'I21.151', 'GBJXTBXJGS', '');
INSERT INTO `05diseases` VALUES ('7944', '下侧壁急性透壁心肌梗死', '397', 'I21.152', 'XCBJXTBXJGS', '');
INSERT INTO `05diseases` VALUES ('7945', '下后壁急性透壁心肌梗死', '397', 'I21.153', 'XHBJXTBXJGS', '');
INSERT INTO `05diseases` VALUES ('7946', '急性侧壁心肌梗死', '397', 'I21.201', 'JXCBXJGS', '');
INSERT INTO `05diseases` VALUES ('7947', '急性高侧壁心肌梗死', '397', 'I21.202', 'JXGCBXJGS', '');
INSERT INTO `05diseases` VALUES ('7948', '急性后壁心肌梗死', '397', 'I21.203', 'JXHBXJGS', '');
INSERT INTO `05diseases` VALUES ('7949', '急性前壁下壁心肌梗死', '397', 'I21.204', 'JXQBXBXJGS', '');
INSERT INTO `05diseases` VALUES ('7950', '急性室间隔下段心肌梗死', '397', 'I21.205', 'JXSJGXDXJGS', '');
INSERT INTO `05diseases` VALUES ('7951', '急性下壁侧壁正后壁心肌梗死', '397', 'I21.206', 'JXXBCBZHBXJGS', '');
INSERT INTO `05diseases` VALUES ('7952', '急性下壁右心室心肌梗死', '403', 'I21.207', 'JXXBYXSXJGS', '');
INSERT INTO `05diseases` VALUES ('7953', '急性下壁正后壁心肌梗死', '397', 'I21.208', 'JXXBZHBXJGS', '');
INSERT INTO `05diseases` VALUES ('7954', '急性心房心肌梗死', '403', 'I21.209', 'JXXFXJGS', '');
INSERT INTO `05diseases` VALUES ('7955', '急性心尖部心肌梗死', '397', 'I21.210', 'JXXJBXJGS', '');
INSERT INTO `05diseases` VALUES ('7956', '急性正后壁心肌梗死', '397', 'I21.211', 'JXZHBXJGS', '');
INSERT INTO `05diseases` VALUES ('7957', '右心肌梗死', '397', 'I21.212', 'YXJGS', '');
INSERT INTO `05diseases` VALUES ('7958', '尖-侧壁急性透壁心肌梗死', '397', 'I21.251', 'JCBJXTBXJGS', '');
INSERT INTO `05diseases` VALUES ('7959', '基底-侧壁急性透壁心肌梗死', '397', 'I21.252', 'JDCBJXTBXJGS', '');
INSERT INTO `05diseases` VALUES ('7960', '高侧壁急性透壁心肌梗死', '397', 'I21.253', 'GCBJXTBXJGS', '');
INSERT INTO `05diseases` VALUES ('7961', '侧(壁)急性透壁心肌梗死', '397', 'I21.254', 'CBJXTBXJGS', '');
INSERT INTO `05diseases` VALUES ('7962', '后壁急性透壁心肌梗死', '397', 'I21.255', 'HBJXTBXJGS', '');
INSERT INTO `05diseases` VALUES ('7963', '后基底壁急性透壁心肌梗死', '397', 'I21.256', 'HJDBJXTBXJGS', '');
INSERT INTO `05diseases` VALUES ('7964', '后侧壁急性透壁心肌梗死', '397', 'I21.257', 'HCBJXTBXJGS', '');
INSERT INTO `05diseases` VALUES ('7965', '后间壁急性透壁心肌梗死', '397', 'I21.258', 'HJBJXTBXJGS', '');
INSERT INTO `05diseases` VALUES ('7966', '间壁急性透壁心肌梗死', '397', 'I21.259', 'JBJXTBXJGS', '');
INSERT INTO `05diseases` VALUES ('7967', '急性右心室心肌梗死', '403', 'I21.301', 'JXYXSXJGS', '');
INSERT INTO `05diseases` VALUES ('7968', '急性室壁心肌梗死', '397', 'I21.302', 'JXSBXJGS', '');
INSERT INTO `05diseases` VALUES ('7969', '手术后心肌梗死', '397', 'I21.303', 'SSHXJGS', '');
INSERT INTO `05diseases` VALUES ('7970', '透壁性心肌梗死', '397', 'I21.351', 'TBXXJGS', '');
INSERT INTO `05diseases` VALUES ('7971', '急性小灶心肌梗死', '397', 'I21.401', 'JXXZXJGS', '');
INSERT INTO `05diseases` VALUES ('7972', '急性心内膜下心肌梗死', '397', 'I21.402', 'JXXNMXXJGS', '');
INSERT INTO `05diseases` VALUES ('7973', '心内膜下心肌梗塞综合征', '397', 'I21.451', 'XNMXXJGSZHZ', '');
INSERT INTO `05diseases` VALUES ('7974', '非透壁性心肌梗死', '397', 'I21.452', 'FTBXXJGS', '');
INSERT INTO `05diseases` VALUES ('7975', '非冠心病心肌梗死', '397', 'I21.901', 'FGXBXJGS', '');
INSERT INTO `05diseases` VALUES ('7976', '冠状动脉闭塞', '58', 'I21.903', 'GZDMBS', '');
INSERT INTO `05diseases` VALUES ('7977', '冠状动脉破裂', '125', 'I21.904', 'GZDMPL', '');
INSERT INTO `05diseases` VALUES ('7978', '冠状动脉栓塞伴心肌梗死', '397', 'I21.905', 'GZDMSSBXJGS', '');
INSERT INTO `05diseases` VALUES ('7979', '冠状动脉血栓形成伴心肌梗死', '397', 'I21.906', 'GZDMXSXCBXJGS', '');
INSERT INTO `05diseases` VALUES ('7980', '急性多壁心肌梗死', '397', 'I21.907', 'JXDBXJGS', '');
INSERT INTO `05diseases` VALUES ('7981', '室间隔穿孔', '278', 'I21.908', 'SJGCK', '');
INSERT INTO `05diseases` VALUES ('7982', '心脏破裂', '403', 'I21.909', 'XZPL', '');
INSERT INTO `05diseases` VALUES ('7983', '心脏卒中', '403', 'I21.910', 'XZZZ', '');
INSERT INTO `05diseases` VALUES ('7984', '亚急性心肌梗死', '397', 'I21.911', 'YJXXJGS', '');
INSERT INTO `05diseases` VALUES ('7985', '心肌梗塞(急性) NOS', '397', 'I21.951', 'XJGSJX', '');
INSERT INTO `05diseases` VALUES ('7986', '心脏梗塞', '403', 'I21.952', 'XZGS', '');
INSERT INTO `05diseases` VALUES ('7987', '前壁的随后性心肌梗死', '397', 'I22.051', 'QBDSHXXJGS', '');
INSERT INTO `05diseases` VALUES ('7988', '前间壁的随后性心肌梗死', '397', 'I22.052', 'QJBDSHXXJGS', '');
INSERT INTO `05diseases` VALUES ('7989', '前侧壁的随后性心肌梗死', '397', 'I22.053', 'QCBDSHXXJGS', '');
INSERT INTO `05diseases` VALUES ('7990', '前壁尖部的随后性心肌梗死', '397', 'I22.054', 'QBJBDSHXXJGS', '');
INSERT INTO `05diseases` VALUES ('7991', '下壁的随后性心肌梗死', '397', 'I22.151', 'XBDSHXXJGS', '');
INSERT INTO `05diseases` VALUES ('7992', '膈壁的随后性心肌梗死', '397', 'I22.152', 'GBDSHXXJGS', '');
INSERT INTO `05diseases` VALUES ('7993', '下侧壁的随后性心肌梗死', '397', 'I22.153', 'XCBDSHXXJGS', '');
INSERT INTO `05diseases` VALUES ('7994', '下后壁的随后性心肌梗死', '397', 'I22.154', 'XHBDSHXXJGS', '');
INSERT INTO `05diseases` VALUES ('7995', '尖-侧壁的随后性心肌梗死', '397', 'I22.851', 'JCBDSHXXJGS', '');
INSERT INTO `05diseases` VALUES ('7996', '基底-侧壁的随后性心肌梗死', '397', 'I22.852', 'JDCBDSHXXJGS', '');
INSERT INTO `05diseases` VALUES ('7997', '高侧壁的随后性心肌梗死', '397', 'I22.853', 'GCBDSHXXJGS', '');
INSERT INTO `05diseases` VALUES ('7998', '侧(壁)的随后性心肌梗死', '397', 'I22.854', 'CBDSHXXJGS', '');
INSERT INTO `05diseases` VALUES ('7999', '后(真性)壁的随后性心肌梗死', '397', 'I22.855', 'HZXBDSHXXJGS', '');
INSERT INTO `05diseases` VALUES ('8000', '后侧壁的随后性心肌梗死', '397', 'I22.856', 'HCBDSHXXJGS', '');
INSERT INTO `05diseases` VALUES ('8001', '后间壁的随后性心肌梗死', '397', 'I22.857', 'HJBDSHXXJGS', '');
INSERT INTO `05diseases` VALUES ('8002', '间壁的随后性心肌梗死', '397', 'I22.858', 'JBDSHXXJGS', '');
INSERT INTO `05diseases` VALUES ('8003', '急性再发心肌梗死', '397', 'I22.901', 'JXZFXJGS', '');
INSERT INTO `05diseases` VALUES ('8004', '随后性心肌梗死', '397', 'I22.951', 'SHXXJGS', '');
INSERT INTO `05diseases` VALUES ('8005', '急性心肌梗死后的近期并发症心包积血', '397', 'I23.051', 'JXXJGSHDJQBFZXBJX', '');
INSERT INTO `05diseases` VALUES ('8006', '急性心肌梗死后的近期并发症房间隔缺损', '397', 'I23.151', 'JXXJGSHDJQBFZFJGQS', '');
INSERT INTO `05diseases` VALUES ('8007', '急性心肌梗死后的近期并发症室间隔缺损', '397', 'I23.251', 'JXXJGSHDJQBFZSJGQS', '');
INSERT INTO `05diseases` VALUES ('8008', '急性心肌梗死后的近期并发症心壁破裂', '397', 'I23.351', 'JXXJGSHDJQBFZXBPL', '');
INSERT INTO `05diseases` VALUES ('8009', '急性心肌梗死后的近期并发症腱索断裂', '397', 'I23.451', 'JXXJGSHDJQBFZJSDL', '');
INSERT INTO `05diseases` VALUES ('8010', '急性心肌梗死后的近期并发症乳头肌断裂', '397', 'I23.551', 'JXXJGSHDJQBFZRTJDL', '');
INSERT INTO `05diseases` VALUES ('8011', '急性心肌梗死后的近期并发症心房、心耳和心室的血栓形成', '70', 'I23.651', 'JXXJGSHDJQBFZXFXEHXS', '');
INSERT INTO `05diseases` VALUES ('8012', '急性心肌梗死后的其他近期并发症', '397', 'I23.851', 'JXXJGSHDQTJQBFZ', '');
INSERT INTO `05diseases` VALUES ('8013', '心肌梗塞后综合征', '397', 'I24.051', 'XJGSHZHZ', '');
INSERT INTO `05diseases` VALUES ('8014', '冠状动脉(静)脉栓(闭)塞', '125', 'I24.052', 'GZDMJMSBS', '');
INSERT INTO `05diseases` VALUES ('8015', '冠状动脉血栓形成，未造成心肌梗死', '397', 'I24.053', 'GZDMXSXCWZCXJGS', '');
INSERT INTO `05diseases` VALUES ('8016', '心肌梗死后综合征', '397', 'I24.101', 'XJGSHZHZ', '');
INSERT INTO `05diseases` VALUES ('8017', '德雷斯勒综合征', '278', 'I24.151', 'DLSLZHZ', '');
INSERT INTO `05diseases` VALUES ('8018', '冠状动脉供血不足', '59', 'I24.801', 'GZDMGXBZ', '');
INSERT INTO `05diseases` VALUES ('8019', '急性冠状动脉供血不足', '59', 'I24.802', 'JXGZDMGXBZ', '');
INSERT INTO `05diseases` VALUES ('8020', '冠状动脉衰竭', '125', 'I24.851', 'GZDMSJ', '');
INSERT INTO `05diseases` VALUES ('8021', '急性及亚急性缺血性心脏病 NOS', '403', 'I24.951', 'JXJYJXQXXXZB', '');
INSERT INTO `05diseases` VALUES ('8022', '动脉硬化性心血管病', '402', 'I25.051', 'DMYHXXXGB', '');
INSERT INTO `05diseases` VALUES ('8023', '冠心病', '404', 'I25.101', 'GXB', '');
INSERT INTO `05diseases` VALUES ('8024', '急性心肌缺血', '397', 'I25.102', 'JXXJQX', '');
INSERT INTO `05diseases` VALUES ('8025', '冠状动脉狭窄', '125', 'I25.103', 'GZDMXZ', '');
INSERT INTO `05diseases` VALUES ('8026', '冠状动脉粥样硬化(狭窄)', '125', 'I25.104', 'GZDMZYYHXZ', '');
INSERT INTO `05diseases` VALUES ('8027', '冠状动脉粥样硬化性心脏病', '403', 'I25.105', 'GZDMZYYHXXZB', '');
INSERT INTO `05diseases` VALUES ('8028', '心肌硬化', '397', 'I25.151', 'XJYH', '');
INSERT INTO `05diseases` VALUES ('8029', '冠状动脉病', '125', 'I25.152', 'GZDMB', '');
INSERT INTO `05diseases` VALUES ('8030', '陈旧性高侧壁心肌梗死', '397', 'I25.201', 'CJXGCBXJGS', '');
INSERT INTO `05diseases` VALUES ('8031', '陈旧性后壁心肌梗死', '397', 'I25.202', 'CJXHBXJGS', '');
INSERT INTO `05diseases` VALUES ('8032', '陈旧性前壁心肌梗死', '397', 'I25.203', 'CJXQBXJGS', '');
INSERT INTO `05diseases` VALUES ('8033', '陈旧性前间壁心肌梗死', '397', 'I25.204', 'CJXQJBXJGS', '');
INSERT INTO `05diseases` VALUES ('8034', '陈旧性下壁后壁心肌梗死', '397', 'I25.205', 'CJXXBHBXJGS', '');
INSERT INTO `05diseases` VALUES ('8035', '陈旧性下壁前壁心肌梗死', '397', 'I25.206', 'CJXXBQBXJGS', '');
INSERT INTO `05diseases` VALUES ('8036', '陈旧性下壁心肌梗死', '397', 'I25.207', 'CJXXBXJGS', '');
INSERT INTO `05diseases` VALUES ('8037', '陈旧性下壁正后壁心肌梗死', '397', 'I25.208', 'CJXXBZHBXJGS', '');
INSERT INTO `05diseases` VALUES ('8038', '陈旧性小灶性心肌梗死', '397', 'I25.209', 'CJXXZXXJGS', '');
INSERT INTO `05diseases` VALUES ('8039', '陈旧性心肌梗死', '397', 'I25.210', 'CJXXJGS', '');
INSERT INTO `05diseases` VALUES ('8040', '陈旧性心内膜下心肌梗死', '397', 'I25.211', 'CJXXNMXXJGS', '');
INSERT INTO `05diseases` VALUES ('8041', '陈旧性正后壁心肌梗死', '397', 'I25.212', 'CJXZHBXJGS', '');
INSERT INTO `05diseases` VALUES ('8042', '心肌梗塞恢复期', '397', 'I25.213', 'XJGSHFQ', '');
INSERT INTO `05diseases` VALUES ('8043', '治愈的心肌梗死', '397', 'I25.251', 'ZYDXJGS', '');
INSERT INTO `05diseases` VALUES ('8044', '房壁瘤(心壁动脉瘤)', '62', 'I25.301', 'FBLXBDML', '');
INSERT INTO `05diseases` VALUES ('8045', '室壁瘤(心室壁动脉瘤)', '403', 'I25.302', 'SBLXSBDML', '');
INSERT INTO `05diseases` VALUES ('8046', '心脏动脉瘤', '403', 'I25.351', 'XZDML', '');
INSERT INTO `05diseases` VALUES ('8047', '冠状动脉窦动脉瘤', '62', 'I25.401', 'GZDMDDML', '');
INSERT INTO `05diseases` VALUES ('8048', '冠状动脉扩张', '61', 'I25.402', 'GZDMKZ', '');
INSERT INTO `05diseases` VALUES ('8049', '后天性冠状动脉动静脉瘘', '125', 'I25.451', 'HTXGZDMDJML', '');
INSERT INTO `05diseases` VALUES ('8050', '缺血性心肌病', '397', 'I25.501', 'QXXXJB', '');
INSERT INTO `05diseases` VALUES ('8051', '慢性心肌缺血', '397', 'I25.551', 'MXXJQX', '');
INSERT INTO `05diseases` VALUES ('8052', '无症状的心肌缺血', '397', 'I25.651', 'WZZDXJQX', '');
INSERT INTO `05diseases` VALUES ('8053', '隐性冠心病(无症状性冠心病)', '404', 'I25.652', 'YXGXBWZZXGXB', '');
INSERT INTO `05diseases` VALUES ('8054', '无症状的缺血性心脏病', '403', 'I25.653', 'WZZDQXXXZB', '');
INSERT INTO `05diseases` VALUES ('8055', '冠状动脉炎', '125', 'I25.801', 'GZDMY', '');
INSERT INTO `05diseases` VALUES ('8056', '冠状动脉左房瘘', '125', 'I25.802', 'GZDMZFL', '');
INSERT INTO `05diseases` VALUES ('8057', '慢性冠状动脉供血不足', '59', 'I25.803', 'MXGZDMGXBZ', '');
INSERT INTO `05diseases` VALUES ('8058', '冠状动脉缺血', '125', 'I25.901', 'GZDMQX', '');
INSERT INTO `05diseases` VALUES ('8059', '缺血性心脏病', '403', 'I25.902', 'QXXXZB', '');
INSERT INTO `05diseases` VALUES ('8060', '急性肺原性心脏病', '403', 'I26.001', 'JXFYXXZB', '');
INSERT INTO `05diseases` VALUES ('8061', '肺栓塞，伴急性肺原性心脏病', '403', 'I26.051', 'FSSBJXFYXXZB', '');
INSERT INTO `05diseases` VALUES ('8062', '肺栓塞', '79', 'I26.901', 'FSS', '');
INSERT INTO `05diseases` VALUES ('8063', '肺血栓形成', '79', 'I26.902', 'FXSXC', '');
INSERT INTO `05diseases` VALUES ('8064', '出血性肺动(静)脉梗塞', '79', 'I26.951', 'CXXFDJMGS', '');
INSERT INTO `05diseases` VALUES ('8065', '肺栓塞，不伴急性肺原性心脏病', '403', 'I26.952', 'FSSBBJXFYXXZB', '');
INSERT INTO `05diseases` VALUES ('8066', '肺动脉高压', '80', 'I27.001', 'FDMGY', '');
INSERT INTO `05diseases` VALUES ('8067', '肺动脉高压危象', '80', 'I27.002', 'FDMGYWX', '');
INSERT INTO `05diseases` VALUES ('8068', '原发性肺动脉高压 (特发性)', '80', 'I27.003', 'YFXFDMGYTFX', '');
INSERT INTO `05diseases` VALUES ('8069', '肺动脉硬化', '63', 'I27.051', 'FDMYH', '');
INSERT INTO `05diseases` VALUES ('8070', '肺动脉硬化伴肺动脉高血压', '63', 'I27.052', 'FDMYHBFDMGXY', '');
INSERT INTO `05diseases` VALUES ('8071', '肺细动脉狭窄引起的心脏病[阿耶萨氏综合征]', '403', 'I27.053', 'FXDMXZYQDXZBAYSSZHZ', '');
INSERT INTO `05diseases` VALUES ('8072', '脊柱后侧凸性心脏病', '403', 'I27.101', 'JZHCTXXZB', '');
INSERT INTO `05diseases` VALUES ('8073', '继发性肺动脉高压', '80', 'I27.801', 'JFXFDMGY', '');
INSERT INTO `05diseases` VALUES ('8074', '其他特指肺原性心脏病', '403', 'I27.851', 'QTTZFYXXZB', '');
INSERT INTO `05diseases` VALUES ('8075', '肺源性心脏病', '403', 'I27.901', 'FYXXZB', '');
INSERT INTO `05diseases` VALUES ('8076', '慢性肺源性心脏病', '403', 'I27.902', 'MXFYXXZB', '');
INSERT INTO `05diseases` VALUES ('8077', '肺动静脉瘘', '79', 'I28.001', 'FDJML', '');
INSERT INTO `05diseases` VALUES ('8078', '肺动脉动脉瘤', '62', 'I28.101', 'FDMDML', '');
INSERT INTO `05diseases` VALUES ('8079', '肺动脉扩张', '61', 'I28.801', 'FDMKZ', '');
INSERT INTO `05diseases` VALUES ('8080', '肺静脉狭窄', '79', 'I28.802', 'FJMXZ', '');
INSERT INTO `05diseases` VALUES ('8081', '肺小动脉炎', '260', 'I28.803', 'FXDMY', '');
INSERT INTO `05diseases` VALUES ('8082', '肺血管破裂', '79', 'I28.851', 'FXGPL', '');
INSERT INTO `05diseases` VALUES ('8083', '肺血管狭窄', '79', 'I28.852', 'FXGXZ', '');
INSERT INTO `05diseases` VALUES ('8084', '肺血管病 NOS', '79', 'I28.951', 'FXGB', '');
INSERT INTO `05diseases` VALUES ('8085', '急性非特异性心包炎', '394', 'I30.051', 'JXFTYXXBY', '');
INSERT INTO `05diseases` VALUES ('8086', '特发性心包炎', '394', 'I30.052', 'TFXXBY', '');
INSERT INTO `05diseases` VALUES ('8087', '病毒性心包炎', '394', 'I30.101', 'BDXXBY', '');
INSERT INTO `05diseases` VALUES ('8088', '细菌性心包炎', '380', 'I30.102', 'XJXXBY', '');
INSERT INTO `05diseases` VALUES ('8089', '病毒性心肌心包炎', '397', 'I30.103', 'BDXXJXBY', '');
INSERT INTO `05diseases` VALUES ('8090', '化脓性心包炎', '394', 'I30.104', 'HNXXBY', '');
INSERT INTO `05diseases` VALUES ('8091', '感染性心包炎', '95', 'I30.105', 'GRXXBY', '');
INSERT INTO `05diseases` VALUES ('8092', '急性感染心包积液', '95', 'I30.106', 'JXGRXBJY', '');
INSERT INTO `05diseases` VALUES ('8093', '链球菌性心包炎', '394', 'I30.107', 'LQJXXBY', '');
INSERT INTO `05diseases` VALUES ('8094', '葡萄球菌性心包炎', '394', 'I30.108', 'PTQJXXBY', '');
INSERT INTO `05diseases` VALUES ('8095', '心包积脓', '393', 'I30.151', 'XBJN', '');
INSERT INTO `05diseases` VALUES ('8096', '其他类型的急性心包炎', '394', 'I30.851', 'QTLXDJXXBY', '');
INSERT INTO `05diseases` VALUES ('8097', '急性心包积液', '393', 'I30.901', 'JXXBJY', '');
INSERT INTO `05diseases` VALUES ('8098', '急性心包炎', '394', 'I30.902', 'JXXBY', '');
INSERT INTO `05diseases` VALUES ('8099', '急性心肌心包炎', '397', 'I30.903', 'JXXJXBY', '');
INSERT INTO `05diseases` VALUES ('8100', '慢性粘连渗出性心包炎', '394', 'I31.001', 'MXNLSCXXBY', '');
INSERT INTO `05diseases` VALUES ('8101', '心包粘连', '393', 'I31.002', 'XBNL', '');
INSERT INTO `05diseases` VALUES ('8102', '纤维性心包炎', '394', 'I31.051', 'XWXXBY', '');
INSERT INTO `05diseases` VALUES ('8103', '粘连性心包炎', '394', 'I31.052', 'NLXXBY', '');
INSERT INTO `05diseases` VALUES ('8104', '慢性化脓性缩窄性心包炎', '394', 'I31.101', 'MXHNXSZXXBY', '');
INSERT INTO `05diseases` VALUES ('8105', '缩窄性心包炎', '394', 'I31.102', 'SZXXBY', '');
INSERT INTO `05diseases` VALUES ('8106', '心包钙化', '393', 'I31.103', 'XBGH', '');
INSERT INTO `05diseases` VALUES ('8107', '钙化性心包炎', '394', 'I31.151', 'GHXXBY', '');
INSERT INTO `05diseases` VALUES ('8108', '心包积血', '393', 'I31.201', 'XBJX', '');
INSERT INTO `05diseases` VALUES ('8109', '癌性心包积液', '2', 'I31.301', 'AXXBJY', '');
INSERT INTO `05diseases` VALUES ('8110', '乳糜性心包积液', '393', 'I31.302', 'RMXXBJY', '');
INSERT INTO `05diseases` VALUES ('8111', '心包破裂', '393', 'I31.801', 'XBPL', '');
INSERT INTO `05diseases` VALUES ('8112', '心外膜斑', '250', 'I31.851', 'XWMB', '');
INSERT INTO `05diseases` VALUES ('8113', '局部心包粘连', '393', 'I31.852', 'JBXBNL', '');
INSERT INTO `05diseases` VALUES ('8114', '包裹性心包积液', '393', 'I31.901', 'BGXXBJY', '');
INSERT INTO `05diseases` VALUES ('8115', '非特异性心包炎', '394', 'I31.902', 'FTYXXBY', '');
INSERT INTO `05diseases` VALUES ('8116', '慢性心包炎', '394', 'I31.903', 'MXXBY', '');
INSERT INTO `05diseases` VALUES ('8117', '心包积气', '393', 'I31.904', 'XBJQ', '');
INSERT INTO `05diseases` VALUES ('8118', '心包积液', '393', 'I31.905', 'XBJY', '');
INSERT INTO `05diseases` VALUES ('8119', '心包压塞(填塞)', '393', 'I31.906', 'XBYSTS', '');
INSERT INTO `05diseases` VALUES ('8120', '心包炎', '394', 'I31.907', 'XBY', '');
INSERT INTO `05diseases` VALUES ('8121', '纵隔心包炎', '394', 'I31.908', 'ZGXBY', '');
INSERT INTO `05diseases` VALUES ('8122', '恶性心内膜炎', '401', 'I33.001', 'EXXNMY', '');
INSERT INTO `05diseases` VALUES ('8123', '二尖瓣赘生物', '72', 'I33.002', 'EJBZSW', '');
INSERT INTO `05diseases` VALUES ('8124', '肺动脉瓣赘生物', '80', 'I33.003', 'FDMBZSW', '');
INSERT INTO `05diseases` VALUES ('8125', '感染性心内膜炎', '95', 'I33.004', 'GRXXNMY', '');
INSERT INTO `05diseases` VALUES ('8126', '感染性心内膜炎性赘生物', '95', 'I33.005', 'GRXXNMYXZSW', '');
INSERT INTO `05diseases` VALUES ('8127', '革兰氏阳性杆菌性心内膜炎', '401', 'I33.006', 'GLSYXGJXXNMY', '');
INSERT INTO `05diseases` VALUES ('8128', '急性细菌性心内膜炎', '380', 'I33.007', 'JXXJXXNMY', '');
INSERT INTO `05diseases` VALUES ('8129', '假单胞菌性心内膜炎', '401', 'I33.008', 'JDBJXXNMY', '');
INSERT INTO `05diseases` VALUES ('8130', '链球菌性心内膜炎', '401', 'I33.009', 'LQJXXNMY', '');
INSERT INTO `05diseases` VALUES ('8131', '霉菌性心内膜炎', '401', 'I33.010', 'MJXXNMY', '');
INSERT INTO `05diseases` VALUES ('8132', '葡萄球菌性心内膜炎', '401', 'I33.011', 'PTQJXXNMY', '');
INSERT INTO `05diseases` VALUES ('8133', '三尖瓣赘生物', '303', 'I33.012', 'SJBZSW', '');
INSERT INTO `05diseases` VALUES ('8134', '细菌性心内膜炎', '380', 'I33.013', 'XJXXNMY', '');
INSERT INTO `05diseases` VALUES ('8135', '亚急性细菌性心内膜炎', '380', 'I33.014', 'YJXXJXXNMY', '');
INSERT INTO `05diseases` VALUES ('8136', '真菌性心内膜炎', '464', 'I33.015', 'ZJXXNMY', '');
INSERT INTO `05diseases` VALUES ('8137', '主动脉瓣赘生物', '477', 'I33.016', 'ZDMBZSW', '');
INSERT INTO `05diseases` VALUES ('8138', '奥斯勒结节[指尖痛性小结]', '273', 'I33.051', 'ASLJJZJTXXJ', '');
INSERT INTO `05diseases` VALUES ('8139', '溃疡性心内膜炎', '401', 'I33.052', 'KYXXNMY', '');
INSERT INTO `05diseases` VALUES ('8140', '脓毒性心内膜炎', '401', 'I33.053', 'NDXXNMY', '');
INSERT INTO `05diseases` VALUES ('8141', '增殖性心内膜炎', '401', 'I33.054', 'ZZXXNMY', '');
INSERT INTO `05diseases` VALUES ('8142', '急性心内膜炎', '401', 'I33.901', 'JXXNMY', '');
INSERT INTO `05diseases` VALUES ('8143', '中毒性心内膜炎', '401', 'I33.951', 'ZDXXNMY', '');
INSERT INTO `05diseases` VALUES ('8144', '二尖瓣闭锁不全', '72', 'I34.001', 'EJBBSBQ', '');
INSERT INTO `05diseases` VALUES ('8145', '非风湿性二尖瓣伴主动脉瓣闭锁不全', '477', 'I34.002', 'FFSXEJBBZDMBBSBQ', '');
INSERT INTO `05diseases` VALUES ('8146', '二尖瓣退行性变', '72', 'I34.003', 'EJBTXXB', '');
INSERT INTO `05diseases` VALUES ('8147', '非风湿性二尖瓣漏伴主动脉瓣狭窄和漏', '477', 'I34.004', 'FFSXEJBLBZDMBXZHL', '');
INSERT INTO `05diseases` VALUES ('8148', '非风湿性二尖瓣返流', '72', 'I34.051', 'FFSXEJBFL', '');
INSERT INTO `05diseases` VALUES ('8149', '二尖瓣后叶脱垂', '72', 'I34.101', 'EJBHYTC', '');
INSERT INTO `05diseases` VALUES ('8150', '二尖瓣脱垂', '72', 'I34.102', 'EJBTC', '');
INSERT INTO `05diseases` VALUES ('8151', '二尖瓣脱垂综合征', '72', 'I34.103', 'EJBTCZHZ', '');
INSERT INTO `05diseases` VALUES ('8152', '二尖瓣术后狭窄', '330', 'I34.201', 'EJBSHXZ', '');
INSERT INTO `05diseases` VALUES ('8153', '老年钙化性二尖瓣狭窄', '72', 'I34.202', 'LNGHXEJBXZ', '');
INSERT INTO `05diseases` VALUES ('8154', '非风湿性二尖(瓣)狭窄', '278', 'I34.251', 'FFSXEJBXZ', '');
INSERT INTO `05diseases` VALUES ('8155', '二尖瓣腱索断裂', '72', 'I34.801', 'EJBJSDL', '');
INSERT INTO `05diseases` VALUES ('8156', '二尖瓣裂', '72', 'I34.802', 'EJBL', '');
INSERT INTO `05diseases` VALUES ('8157', '手术后二尖瓣狭窄闭锁不全', '330', 'I34.803', 'SSHEJBXZBSBQ', '');
INSERT INTO `05diseases` VALUES ('8158', '非风湿性二尖瓣狭窄伴闭锁不全', '72', 'I34.804', 'FFSXEJBXZBBSBQ', '');
INSERT INTO `05diseases` VALUES ('8159', '心内膜炎并二尖瓣穿孔', '401', 'I34.805', 'XNMYBEJBCK', '');
INSERT INTO `05diseases` VALUES ('8160', '非风湿性二尖瓣钙化', '72', 'I34.851', 'FFSXEJBGH', '');
INSERT INTO `05diseases` VALUES ('8161', '非风湿性二尖瓣退行性改变', '72', 'I34.951', 'FFSXEJBTXXGB', '');
INSERT INTO `05diseases` VALUES ('8162', '主动脉瓣狭窄', '477', 'I35.001', 'ZDMBXZ', '');
INSERT INTO `05diseases` VALUES ('8163', '心内膜炎伴主动脉瓣闭锁不全', '477', 'I35.101', 'XNMYBZDMBBSBQ', '');
INSERT INTO `05diseases` VALUES ('8164', '主动脉瓣闭锁不全', '477', 'I35.102', 'ZDMBBSBQ', '');
INSERT INTO `05diseases` VALUES ('8165', '非风湿性主动脉瓣回流(返流)', '477', 'I35.151', 'FFSXZDMBHLFL', '');
INSERT INTO `05diseases` VALUES ('8166', '老年钙化性主动脉瓣狭窄关闭不全', '477', 'I35.201', 'LNGHXZDMBXZGBBQ', '');
INSERT INTO `05diseases` VALUES ('8167', '主动脉瓣狭窄伴闭锁不全', '477', 'I35.202', 'ZDMBXZBBSBQ', '');
INSERT INTO `05diseases` VALUES ('8168', '退行性主动脉瓣疾患', '477', 'I35.801', 'TXXZDMBJH', '');
INSERT INTO `05diseases` VALUES ('8169', '心内膜炎伴主动脉瓣穿孔', '477', 'I35.802', 'XNMYBZDMBCK', '');
INSERT INTO `05diseases` VALUES ('8170', '心内膜炎伴主动脉瓣脱垂', '477', 'I35.803', 'XNMYBZDMBTC', '');
INSERT INTO `05diseases` VALUES ('8171', '主动脉瓣肥厚', '477', 'I35.804', 'ZDMBFH', '');
INSERT INTO `05diseases` VALUES ('8172', '主动脉瓣钙化', '477', 'I35.805', 'ZDMBGH', '');
INSERT INTO `05diseases` VALUES ('8173', '主动脉瓣松软综合征', '477', 'I35.806', 'ZDMBSRZHZ', '');
INSERT INTO `05diseases` VALUES ('8174', '主动脉瓣下垂', '477', 'I35.807', 'ZDMBXC', '');
INSERT INTO `05diseases` VALUES ('8175', '主动脉瓣硬化', '477', 'I35.808', 'ZDMBYH', '');
INSERT INTO `05diseases` VALUES ('8176', '主动脉瓣周脓肿', '243', 'I35.809', 'ZDMBZNZ', '');
INSERT INTO `05diseases` VALUES ('8177', '非风湿性主动脉瓣退行性改变', '477', 'I35.951', 'FFSXZDMBTXXGB', '');
INSERT INTO `05diseases` VALUES ('8178', '非风湿性三尖瓣狭窄', '303', 'I36.001', 'FFSXSJBXZ', '');
INSERT INTO `05diseases` VALUES ('8179', '非风湿性三尖瓣闭锁不全', '303', 'I36.101', 'FFSXSJBBSBQ', '');
INSERT INTO `05diseases` VALUES ('8180', '非风湿性三尖瓣回流', '303', 'I36.102', 'FFSXSJBHL', '');
INSERT INTO `05diseases` VALUES ('8181', '非风湿性三尖(瓣)狭窄、闭锁不全', '278', 'I36.251', 'FFSXSJBXZBSBQ', '');
INSERT INTO `05diseases` VALUES ('8182', '非风湿性三尖瓣脱垂', '303', 'I36.801', 'FFSXSJBTC', '');
INSERT INTO `05diseases` VALUES ('8183', '三尖瓣脱垂', '303', 'I36.802', 'SJBTC', '');
INSERT INTO `05diseases` VALUES ('8184', '三尖瓣下移', '303', 'I36.803', 'SJBXY', '');
INSERT INTO `05diseases` VALUES ('8185', '肺动脉瓣狭窄', '80', 'I37.001', 'FDMBXZ', '');
INSERT INTO `05diseases` VALUES ('8186', '肺动脉瓣闭锁不全', '80', 'I37.101', 'FDMBBSBQ', '');
INSERT INTO `05diseases` VALUES ('8187', '非风湿性肺动脉瓣回流', '80', 'I37.151', 'FFSXFDMBHL', '');
INSERT INTO `05diseases` VALUES ('8188', '肺动脉瓣狭窄伴闭锁不全', '80', 'I37.251', 'FDMBXZBBSBQ', '');
INSERT INTO `05diseases` VALUES ('8189', '肺动脉硬化性心内膜炎', '401', 'I37.851', 'FDMYHXXNMY', '');
INSERT INTO `05diseases` VALUES ('8190', '心脏瓣膜病', '403', 'I38.X01', 'XZBMB', '');
INSERT INTO `05diseases` VALUES ('8191', '老年性心脏瓣膜病', '403', 'I38.X02', 'LNXXZBMB', '');
INSERT INTO `05diseases` VALUES ('8192', '心瓣膜穿孔', '392', 'I38.X03', 'XBMCK', '');
INSERT INTO `05diseases` VALUES ('8193', '心瓣膜钙化', '392', 'I38.X04', 'XBMGH', '');
INSERT INTO `05diseases` VALUES ('8194', '心瓣膜破裂', '392', 'I38.X05', 'XBMPL', '');
INSERT INTO `05diseases` VALUES ('8195', '心内膜炎', '401', 'I38.X06', 'XNMY', '');
INSERT INTO `05diseases` VALUES ('8196', '心瓣膜疾患', '392', 'I38.X51', 'XBMJH', '');
INSERT INTO `05diseases` VALUES ('8197', '心瓣膜炎', '392', 'I38.X52', 'XBMY', '');
INSERT INTO `05diseases` VALUES ('8198', '动脉硬化性心内膜炎', '401', 'I38.X53', 'DMYHXXNMY', '');
INSERT INTO `05diseases` VALUES ('8199', '非细菌性血栓性心内膜炎', '380', 'I38.X54', 'FXJXXSXXNMY', '');
INSERT INTO `05diseases` VALUES ('8200', '病毒性心肌炎', '397', 'I40.001', 'BDXXJY', '');
INSERT INTO `05diseases` VALUES ('8201', '感染性心肌炎', '95', 'I40.002', 'GRXXJY', '');
INSERT INTO `05diseases` VALUES ('8202', '细菌性心肌炎', '380', 'I40.003', 'XJXXJY', '');
INSERT INTO `05diseases` VALUES ('8203', '心肌脓肿', '243', 'I40.004', 'XJNZ', '');
INSERT INTO `05diseases` VALUES ('8204', '孤立性心肌炎', '397', 'I40.151', 'GLXXJY', '');
INSERT INTO `05diseases` VALUES ('8205', '特发性心肌炎', '397', 'I40.152', 'TFXXJY', '');
INSERT INTO `05diseases` VALUES ('8206', '菲尔德病毒性心肌炎', '397', 'I40.153', 'FEDBDXXJY', '');
INSERT INTO `05diseases` VALUES ('8207', '中毒性心肌炎', '397', 'I40.801', 'ZDXXJY', '');
INSERT INTO `05diseases` VALUES ('8208', '急性心肌炎', '397', 'I40.901', 'JXXJY', '');
INSERT INTO `05diseases` VALUES ('8209', '活动性心肌炎', '397', 'I40.951', 'HDXXJY', '');
INSERT INTO `05diseases` VALUES ('8210', '家族性扩张性心肌病', '397', 'I42.001', 'JZXKZXXJB', '');
INSERT INTO `05diseases` VALUES ('8211', '充血性心肌病(扩张型心肌病)', '397', 'I42.002', 'CXXXJBKZXXJB', '');
INSERT INTO `05diseases` VALUES ('8212', '肥厚性梗阻性心肌病', '397', 'I42.101', 'FHXGZXXJB', '');
INSERT INTO `05diseases` VALUES ('8213', '肥大性主动脉瓣下狭窄', '477', 'I42.151', 'FDXZDMBXXZ', '');
INSERT INTO `05diseases` VALUES ('8214', '肥厚性非梗阻性心肌病', '397', 'I42.201', 'FHXFGZXXJB', '');
INSERT INTO `05diseases` VALUES ('8215', '肥厚性心肌病', '397', 'I42.202', 'FHXXJB', '');
INSERT INTO `05diseases` VALUES ('8216', '心尖肥厚型心肌病', '397', 'I42.203', 'XJFHXXJB', '');
INSERT INTO `05diseases` VALUES ('8217', '特发性肥大性心肌病', '397', 'I42.251', 'TFXFDXXJB', '');
INSERT INTO `05diseases` VALUES ('8218', '心内膜心肌纤维化', '397', 'I42.301', 'XNMXJXWH', '');
INSERT INTO `05diseases` VALUES ('8219', '勒夫勒心内膜炎', '401', 'I42.351', 'LFLXNMY', '');
INSERT INTO `05diseases` VALUES ('8220', '心内膜心肌病(嗜曙红性)', '397', 'I42.352', 'XNMXJBSSHX', '');
INSERT INTO `05diseases` VALUES ('8221', '心内膜纤维弹性组织增生', '404', 'I42.401', 'XNMXWDXZZZS', '');
INSERT INTO `05diseases` VALUES ('8222', '先天性心肌病', '397', 'I42.451', 'XTXXJB', '');
INSERT INTO `05diseases` VALUES ('8223', '限制性心肌病', '397', 'I42.501', 'XZXXJB', '');
INSERT INTO `05diseases` VALUES ('8224', '酒精性中毒性心肌病', '397', 'I42.601', 'JJXZDXXJB', '');
INSERT INTO `05diseases` VALUES ('8225', '药物性心肌病', '397', 'I42.751', 'YWXXJB', '');
INSERT INTO `05diseases` VALUES ('8226', '心肌囊肿', '397', 'I42.801', 'XJNZ', '');
INSERT INTO `05diseases` VALUES ('8227', '其他心肌病', '397', 'I42.851', 'QTXJB', '');
INSERT INTO `05diseases` VALUES ('8228', '充血性心肌病', '397', 'I42.901', 'CXXXJB', '');
INSERT INTO `05diseases` VALUES ('8229', '继发性心肌病', '397', 'I42.902', 'JFXXJB', '');
INSERT INTO `05diseases` VALUES ('8230', '特发性心肌病', '397', 'I42.903', 'TFXXJB', '');
INSERT INTO `05diseases` VALUES ('8231', '心动过速性心肌病', '397', 'I42.904', 'XDGSXXJB', '');
INSERT INTO `05diseases` VALUES ('8232', '心肌病', '397', 'I42.905', 'XJB', '');
INSERT INTO `05diseases` VALUES ('8233', '心肌炎后心肌病', '397', 'I42.906', 'XJYHXJB', '');
INSERT INTO `05diseases` VALUES ('8234', '右心心肌病', '397', 'I42.907', 'YXXJB', '');
INSERT INTO `05diseases` VALUES ('8235', '家族性心肌病[家族性心肌肥大症]', '397', 'I42.951', 'JZXXJBJZXXJFDZ', '');
INSERT INTO `05diseases` VALUES ('8236', '缩窄性心肌病', '397', 'I42.952', 'SZXXJB', '');
INSERT INTO `05diseases` VALUES ('8237', 'Ⅰ度房室传导阻滞', '403', 'I44.001', 'YDFSCDZZ', '');
INSERT INTO `05diseases` VALUES ('8238', 'Ⅱ度房室传导阻滞，Ⅰ型和Ⅱ型', '403', 'I44.101', 'EDFSCDZZYXHEX', '');
INSERT INTO `05diseases` VALUES ('8239', 'Ⅱ度默比茨传导阻滞，Ⅰ型和Ⅱ型', '403', 'I44.151', 'EDMBCCDZZYXHEX', '');
INSERT INTO `05diseases` VALUES ('8240', '文克巴赫传导阻滞', '403', 'I44.152', 'WKBHCDZZ', '');
INSERT INTO `05diseases` VALUES ('8241', 'Ⅲ度房室传导阻滞(完全房室阻滞)', '403', 'I44.201', 'SDFSCDZZWQFSZZ', '');
INSERT INTO `05diseases` VALUES ('8242', '部分房室传导阻滞', '403', 'I44.301', 'BFFSCDZZ', '');
INSERT INTO `05diseases` VALUES ('8243', '房室传导阻滞', '403', 'I44.302', 'FSCDZZ', '');
INSERT INTO `05diseases` VALUES ('8244', '特发性房室束支退化症lengre`s病', '268', 'I44.303', 'TFXFSSZTHZB', '');
INSERT INTO `05diseases` VALUES ('8245', '隐匿性房室传导阻滞', '403', 'I44.304', 'YNXFSCDZZ', '');
INSERT INTO `05diseases` VALUES ('8246', '希斯束硬化', '278', 'I44.351', 'XSSYH', '');
INSERT INTO `05diseases` VALUES ('8247', '左前分枝传导阻滞', '403', 'I44.401', 'ZQFZCDZZ', '');
INSERT INTO `05diseases` VALUES ('8248', '左后束传导阻滞', '403', 'I44.551', 'ZHSCDZZ', '');
INSERT INTO `05diseases` VALUES ('8249', '完全性左束枝传导阻滞(ＣＬＢＢＢ)', '403', 'I44.601', 'WQXZSZCDZZ', '');
INSERT INTO `05diseases` VALUES ('8250', '左束支半传导阻滞', '403', 'I44.602', 'ZSZBCDZZ', '');
INSERT INTO `05diseases` VALUES ('8251', '左束支传导阻滞(ＬＢＢＢ)', '403', 'I44.701', 'ZSZCDZZ', '');
INSERT INTO `05diseases` VALUES ('8252', '右束传导阻滞(ＲＢＢＢ)', '403', 'I45.051', 'YSCDZZ', '');
INSERT INTO `05diseases` VALUES ('8253', '不完全性右束枝传导阻滞', '403', 'I45.101', 'BWQXYSZCDZZ', '');
INSERT INTO `05diseases` VALUES ('8254', '完全性右束枝传导阻滞', '403', 'I45.102', 'WQXYSZCDZZ', '');
INSERT INTO `05diseases` VALUES ('8255', '右束支传导阻滞 NOS', '403', 'I45.103', 'YSZCDZZ', '');
INSERT INTO `05diseases` VALUES ('8256', '二束传导阻滞', '403', 'I45.251', 'ESCDZZ', '');
INSERT INTO `05diseases` VALUES ('8257', '三束支传导阻滞', '403', 'I45.301', 'SSZCDZZ', '');
INSERT INTO `05diseases` VALUES ('8258', '室内传导阻滞', '403', 'I45.401', 'SNCDZZ', '');
INSERT INTO `05diseases` VALUES ('8259', '束支传导阻滞', '403', 'I45.402', 'SZCDZZ', '');
INSERT INTO `05diseases` VALUES ('8260', '中隔支传导阻滞', '403', 'I45.451', 'ZGZCDZZ', '');
INSERT INTO `05diseases` VALUES ('8261', '非特异性室内传导阻滞', '403', 'I45.452', 'FTYXSNCDZZ', '');
INSERT INTO `05diseases` VALUES ('8262', '窦房传导阻滞(ＳＡＢ)', '403', 'I45.501', 'DFCDZZ', '');
INSERT INTO `05diseases` VALUES ('8263', '窦房结功能低下', '278', 'I45.502', 'DFJGNDX', '');
INSERT INTO `05diseases` VALUES ('8264', '窦性停搏', '278', 'I45.503', 'DXTB', '');
INSERT INTO `05diseases` VALUES ('8265', '房内传导阻滞', '403', 'I45.504', 'FNCDZZ', '');
INSERT INTO `05diseases` VALUES ('8266', '中隔束传导阻滞', '403', 'I45.505', 'ZGSCDZZ', '');
INSERT INTO `05diseases` VALUES ('8267', '树状分支性(心脏)传导阻滞', '403', 'I45.551', 'SZFZXXZCDZZ', '');
INSERT INTO `05diseases` VALUES ('8268', '劳恩－加农－莱文综合征', '278', 'I45.601', 'LEJNLWZHZ', '');
INSERT INTO `05diseases` VALUES ('8269', '预激综合征[沃－帕－怀氏综合征]', '278', 'I45.602', 'YJZHZWPHSZHZ', '');
INSERT INTO `05diseases` VALUES ('8270', '隐性预激综合征', '278', 'I45.603', 'YXYJZHZ', '');
INSERT INTO `05diseases` VALUES ('8271', '沃尔夫-帕金森-怀特综合征', '245', 'I45.651', 'WEFPJSHTZHZ', '');
INSERT INTO `05diseases` VALUES ('8272', '附属的房室传导', '76', 'I45.652', 'FSDFSCD', '');
INSERT INTO `05diseases` VALUES ('8273', '加速的房室传导', '76', 'I45.653', 'JSDFSCD', '');
INSERT INTO `05diseases` VALUES ('8274', '预激的房室传导', '76', 'I45.654', 'YJDFSCD', '');
INSERT INTO `05diseases` VALUES ('8275', '房室节内双径', '278', 'I45.801', 'FSJNSJ', '');
INSERT INTO `05diseases` VALUES ('8276', '干扰性房室分离', '278', 'I45.802', 'GRXFSFL', '');
INSERT INTO `05diseases` VALUES ('8277', '斯托克斯－亚当斯氏综合征[心脏传导阻滞引起晕]', '403', 'I45.901', 'STKSYDSSZHZXZCDZZYQY', '');
INSERT INTO `05diseases` VALUES ('8278', '家族性传导系统障碍', '278', 'I45.902', 'JZXCDXTZA', '');
INSERT INTO `05diseases` VALUES ('8279', '心脏传导系统退行性变', '403', 'I45.903', 'XZCDXTTXXB', '');
INSERT INTO `05diseases` VALUES ('8280', '心脏传导阻滞', '403', 'I45.951', 'XZCDZZ', '');
INSERT INTO `05diseases` VALUES ('8281', '心脏停博复苏成功', '403', 'I46.051', 'XZTBFSCG', '');
INSERT INTO `05diseases` VALUES ('8282', '心原性猝死', '404', 'I46.101', 'XYXCS', '');
INSERT INTO `05diseases` VALUES ('8283', '心脏骤停', '403', 'I46.901', 'XZZT', '');
INSERT INTO `05diseases` VALUES ('8284', '呼吸心跳骤停', '404', 'I46.902', 'HXXTZT', '');
INSERT INTO `05diseases` VALUES ('8285', '室性异行心律', '400', 'I47.051', 'SXYXXL', '');
INSERT INTO `05diseases` VALUES ('8286', '窦房折返性心动过速', '396', 'I47.101', 'DFZFXXDGS', '');
INSERT INTO `05diseases` VALUES ('8287', '窦性心动过速', '396', 'I47.102', 'DXXDGS', '');
INSERT INTO `05diseases` VALUES ('8288', '房内折返性心动过速', '396', 'I47.103', 'FNZFXXDGS', '');
INSERT INTO `05diseases` VALUES ('8289', '房室结折返性心动过速', '396', 'I47.104', 'FSJZFXXDGS', '');
INSERT INTO `05diseases` VALUES ('8290', '房室折返性心动过速', '396', 'I47.105', 'FSZFXXDGS', '');
INSERT INTO `05diseases` VALUES ('8291', '房性心动过速', '396', 'I47.106', 'FXXDGS', '');
INSERT INTO `05diseases` VALUES ('8292', '结性心动过速(交界性心动过速)', '396', 'I47.107', 'JXXDGSJJXXDGS', '');
INSERT INTO `05diseases` VALUES ('8293', '室上性心动过速', '396', 'I47.108', 'SSXXDGS', '');
INSERT INTO `05diseases` VALUES ('8294', '阵发性房室性心动过速', '396', 'I47.109', 'ZFXFSXXDGS', '');
INSERT INTO `05diseases` VALUES ('8295', '阵发性房性心动过速', '396', 'I47.110', 'ZFXFXXDGS', '');
INSERT INTO `05diseases` VALUES ('8296', '阵发性交界性心动过速', '396', 'I47.111', 'ZFXJJXXDGS', '');
INSERT INTO `05diseases` VALUES ('8297', '阵发性室上性心动过速', '396', 'I47.112', 'ZFXSSXXDGS', '');
INSERT INTO `05diseases` VALUES ('8298', '自律性增高性房性心动过速', '396', 'I47.113', 'ZLXZGXFXXDGS', '');
INSERT INTO `05diseases` VALUES ('8299', '尖端扭转型室性心动过速', '396', 'I47.201', 'JDNZXSXXDGS', '');
INSERT INTO `05diseases` VALUES ('8300', '室性心动过速', '396', 'I47.202', 'SXXDGS', '');
INSERT INTO `05diseases` VALUES ('8301', '右室室性心动过速', '396', 'I47.203', 'YSSXXDGS', '');
INSERT INTO `05diseases` VALUES ('8302', '阵发性室性心动过速', '396', 'I47.204', 'ZFXSXXDGS', '');
INSERT INTO `05diseases` VALUES ('8303', '左室室性心动过速', '396', 'I47.205', 'ZSSXXDGS', '');
INSERT INTO `05diseases` VALUES ('8304', '阵发性心动过速[霍夫曼－布佛雷氏综合征]', '396', 'I47.901', 'ZFXXDGSHFMBFLSZHZ', '');
INSERT INTO `05diseases` VALUES ('8305', '不纯性心房扑动', '403', 'I48.X01', 'BCXXFPD', '');
INSERT INTO `05diseases` VALUES ('8306', '特发性房颤', '278', 'I48.X02', 'TFXFC', '');
INSERT INTO `05diseases` VALUES ('8307', '心房扑动', '403', 'I48.X03', 'XFPD', '');
INSERT INTO `05diseases` VALUES ('8308', '心房纤维性颤动(心房纤颤)', '403', 'I48.X04', 'XFXWXCDXFXC', '');
INSERT INTO `05diseases` VALUES ('8309', '阵发性心房扑动', '403', 'I48.X05', 'ZFXXFPD', '');
INSERT INTO `05diseases` VALUES ('8310', '阵发性心房纤颤', '403', 'I48.X06', 'ZFXXFXC', '');
INSERT INTO `05diseases` VALUES ('8311', '心室扑动', '403', 'I49.001', 'XSPD', '');
INSERT INTO `05diseases` VALUES ('8312', '心室纤维性颤动(心室纤颤)', '403', 'I49.002', 'XSXWXCDXSXC', '');
INSERT INTO `05diseases` VALUES ('8313', '房性期外收缩[房性早搏]', '278', 'I49.101', 'FXQWSSFXZB', '');
INSERT INTO `05diseases` VALUES ('8314', '频发性房性期外收缩', '278', 'I49.102', 'PFXFXQWSS', '');
INSERT INTO `05diseases` VALUES ('8315', '房性过早收缩', '278', 'I49.151', 'FXGZSS', '');
INSERT INTO `05diseases` VALUES ('8316', '结性过早搏动[交界性过早搏动]', '278', 'I49.201', 'JXGZBDJJXGZBD', '');
INSERT INTO `05diseases` VALUES ('8317', '频发性室性期外收缩', '278', 'I49.301', 'PFXSXQWSS', '');
INSERT INTO `05diseases` VALUES ('8318', '室性过早搏动', '278', 'I49.302', 'SXGZBD', '');
INSERT INTO `05diseases` VALUES ('8319', '室性自搏', '278', 'I49.303', 'SXZB', '');
INSERT INTO `05diseases` VALUES ('8320', '阵发性室性期外收缩', '278', 'I49.304', 'ZFXSXQWSS', '');
INSERT INTO `05diseases` VALUES ('8321', '期外收缩(过早搏动)', '278', 'I49.401', 'QWSSGZBD', '');
INSERT INTO `05diseases` VALUES ('8322', '偶发房室性期外收缩', '278', 'I49.402', 'OFFSXQWSS', '');
INSERT INTO `05diseases` VALUES ('8323', '频发性期外收缩', '278', 'I49.403', 'PFXQWSS', '');
INSERT INTO `05diseases` VALUES ('8324', '多灶性过早搏动', '278', 'I49.451', 'DZXGZBD', '');
INSERT INTO `05diseases` VALUES ('8325', '移动性起博点(过早复极)', '278', 'I49.452', 'YDXQBDGZFJ', '');
INSERT INTO `05diseases` VALUES ('8326', '异位搏动', '278', 'I49.453', 'YWBD', '');
INSERT INTO `05diseases` VALUES ('8327', '期外收缩性心律不齐', '400', 'I49.454', 'QWSSXXLBQ', '');
INSERT INTO `05diseases` VALUES ('8328', '病窦综合征[慢－快综合征]', '268', 'I49.501', 'BDZHZMKZHZ', '');
INSERT INTO `05diseases` VALUES ('8329', '窦房结-房室结游走节律', '278', 'I49.802', 'DFJFSJYZJL', '');
INSERT INTO `05diseases` VALUES ('8330', '窦房结游走性心律', '400', 'I49.803', 'DFJYZXXL', '');
INSERT INTO `05diseases` VALUES ('8331', '窦性心律失常', '400', 'I49.804', 'DXXLSC', '');
INSERT INTO `05diseases` VALUES ('8332', '反复心律(逆节律)', '400', 'I49.805', 'FFXLNJL', '');
INSERT INTO `05diseases` VALUES ('8333', '房性心律', '400', 'I49.806', 'FXXL', '');
INSERT INTO `05diseases` VALUES ('8334', '结性心律', '400', 'I49.807', 'JXXL', '');
INSERT INTO `05diseases` VALUES ('8335', '结性逸搏', '278', 'I49.808', 'JXB', '');
INSERT INTO `05diseases` VALUES ('8336', '特指多种心律失常', '400', 'I49.809', 'TZDZXLSC', '');
INSERT INTO `05diseases` VALUES ('8337', '紊乱性房性心率', '404', 'I49.810', 'WLXFXXL', '');
INSERT INTO `05diseases` VALUES ('8338', 'β受体过敏综合征', '278', 'I49.901', 'STGMZHZ', '');
INSERT INTO `05diseases` VALUES ('8339', '冠心病心律失常型', '400', 'I49.902', 'GXBXLSCX', '');
INSERT INTO `05diseases` VALUES ('8340', '室性心律失常', '400', 'I49.903', 'SXXLSC', '');
INSERT INTO `05diseases` VALUES ('8341', '心律失常[心律不齐；心律紊乱]', '400', 'I49.904', 'XLSCXLBQXLWL', '');
INSERT INTO `05diseases` VALUES ('8342', '充血性心力衰竭', '404', 'I50.001', 'CXXXLSJ', '');
INSERT INTO `05diseases` VALUES ('8343', '充血性心脏病', '403', 'I50.002', 'CXXXZB', '');
INSERT INTO `05diseases` VALUES ('8344', '全心衰竭', '404', 'I50.003', 'QXSJ', '');
INSERT INTO `05diseases` VALUES ('8345', '右心衰竭', '403', 'I50.004', 'YXSJ', '');
INSERT INTO `05diseases` VALUES ('8346', '心源性水肿', '404', 'I50.051', 'XYXSZ', '');
INSERT INTO `05diseases` VALUES ('8347', '急性肺水肿伴心力衰竭', '79', 'I50.101', 'JXFSZBXLSJ', '');
INSERT INTO `05diseases` VALUES ('8348', '急性左心衰竭', '403', 'I50.102', 'JXZXSJ', '');
INSERT INTO `05diseases` VALUES ('8349', '慢性左心功能不全', '403', 'I50.103', 'MXZXGNBQ', '');
INSERT INTO `05diseases` VALUES ('8350', '心源性哮喘', '404', 'I50.104', 'XYXXC', '');
INSERT INTO `05diseases` VALUES ('8351', '左心房衰竭', '403', 'I50.105', 'ZXFSJ', '');
INSERT INTO `05diseases` VALUES ('8352', '左心衰竭', '403', 'I50.106', 'ZXSJ', '');
INSERT INTO `05diseases` VALUES ('8353', '左心衰竭合并急性肺水肿', '79', 'I50.107', 'ZXSJHBJXFSZ', '');
INSERT INTO `05diseases` VALUES ('8354', '急性肺水肿提及心脏病(心力衰竭)', '403', 'I50.151', 'JXFSZTJXZBXLSJ', '');
INSERT INTO `05diseases` VALUES ('8355', '低心排综合征', '404', 'I50.901', 'DXPZHZ', '');
INSERT INTO `05diseases` VALUES ('8356', '心功能不全', '404', 'I50.902', 'XGNBQ', '');
INSERT INTO `05diseases` VALUES ('8357', '急性心功能衰竭', '404', 'I50.903', 'JXXGNSJ', '');
INSERT INTO `05diseases` VALUES ('8358', '急性心力衰竭', '404', 'I50.904', 'JXXLSJ', '');
INSERT INTO `05diseases` VALUES ('8359', '慢性心力衰竭', '404', 'I50.905', 'MXXLSJ', '');
INSERT INTO `05diseases` VALUES ('8360', '心房功能不全', '403', 'I50.906', 'XFGNBQ', '');
INSERT INTO `05diseases` VALUES ('8361', '心功能Ⅱ级', '404', 'I50.907', 'XGNEJ', '');
INSERT INTO `05diseases` VALUES ('8362', '心功能Ⅲ级', '404', 'I50.908', 'XGNSJ', '');
INSERT INTO `05diseases` VALUES ('8363', '心功能Ⅱ--Ⅲ级', '404', 'I50.909', 'XGNESJ', '');
INSERT INTO `05diseases` VALUES ('8364', '心功能Ⅳ级', '404', 'I50.910', 'XGNSJ', '');
INSERT INTO `05diseases` VALUES ('8365', '心力衰竭 NOS', '404', 'I50.911', 'XLSJ', '');
INSERT INTO `05diseases` VALUES ('8366', '心肾衰竭', '314', 'I50.912', 'XSSJ', '');
INSERT INTO `05diseases` VALUES ('8367', '循环衰竭', '424', 'I50.913', 'XHSJ', '');
INSERT INTO `05diseases` VALUES ('8368', '低输出量性心(力)衰竭', '404', 'I50.951', 'DSCLXXLSJ', '');
INSERT INTO `05diseases` VALUES ('8369', '心肌功能不全[心肌衰竭]', '397', 'I50.952', 'XJGNBQXJSJ', '');
INSERT INTO `05diseases` VALUES ('8370', '顽固性心力衰竭', '404', 'I50.953', 'WGXXLSJ', '');
INSERT INTO `05diseases` VALUES ('8371', '后天性心间隔缺损', '404', 'I51.051', 'HTXXJGQS', '');
INSERT INTO `05diseases` VALUES ('8372', '后天性(陈旧性)心房的间隔缺损', '403', 'I51.052', 'HTXCJXXFDJGQS', '');
INSERT INTO `05diseases` VALUES ('8373', '后天性(陈旧性)心室的间隔缺损', '403', 'I51.053', 'HTXCJXXSDJGQS', '');
INSERT INTO `05diseases` VALUES ('8374', '后天性(陈旧性)心耳的间隔缺损', '70', 'I51.054', 'HTXCJXXEDJGQS', '');
INSERT INTO `05diseases` VALUES ('8375', '心腱索断裂', '404', 'I51.101', 'XJSDL', '');
INSERT INTO `05diseases` VALUES ('8376', '心脏乳头肌破裂', '403', 'I51.201', 'XZRTJPL', '');
INSERT INTO `05diseases` VALUES ('8377', '心房血拴', '403', 'I51.301', 'XFXS', '');
INSERT INTO `05diseases` VALUES ('8378', '心耳血栓', '70', 'I51.302', 'XEXS', '');
INSERT INTO `05diseases` VALUES ('8379', '心室血栓', '403', 'I51.303', 'XSXS', '');
INSERT INTO `05diseases` VALUES ('8380', '心尖部血栓形成', '419', 'I51.351', 'XJBXSXC', '');
INSERT INTO `05diseases` VALUES ('8381', '老年性心脏病', '403', 'I51.402', 'LNXXZB', '');
INSERT INTO `05diseases` VALUES ('8382', '心肌炎', '397', 'I51.403', 'XJY', '');
INSERT INTO `05diseases` VALUES ('8383', '心肌炎后遗症', '397', 'I51.404', 'XJYHYZ', '');
INSERT INTO `05diseases` VALUES ('8384', '间质性心肌炎', '397', 'I51.451', 'JZXXJY', '');
INSERT INTO `05diseases` VALUES ('8385', '老年性心肌炎', '397', 'I51.452', 'LNXXJY', '');
INSERT INTO `05diseases` VALUES ('8386', '心肌变性', '397', 'I51.501', 'XJBX', '');
INSERT INTO `05diseases` VALUES ('8387', '心肌劳损', '397', 'I51.502', 'XJLS', '');
INSERT INTO `05diseases` VALUES ('8388', '心肌损害', '397', 'I51.503', 'XJSH', '');
INSERT INTO `05diseases` VALUES ('8389', '心肌脂肪变性', '397', 'I51.504', 'XJZFBX', '');
INSERT INTO `05diseases` VALUES ('8390', '老年性心肌变性', '397', 'I51.551', 'LNXXJBX', '');
INSERT INTO `05diseases` VALUES ('8391', '心血管变性', '402', 'I51.601', 'XXGBX', '');
INSERT INTO `05diseases` VALUES ('8392', '心血管意外', '402', 'I51.602', 'XXGYW', '');
INSERT INTO `05diseases` VALUES ('8393', '心血管硬化', '402', 'I51.603', 'XXGYH', '');
INSERT INTO `05diseases` VALUES ('8394', '室间隔肥大', '278', 'I51.701', 'SJGFD', '');
INSERT INTO `05diseases` VALUES ('8395', '心房肥大', '403', 'I51.702', 'XFFD', '');
INSERT INTO `05diseases` VALUES ('8396', '心房扩大', '403', 'I51.703', 'XFKD', '');
INSERT INTO `05diseases` VALUES ('8397', '心肌肥大', '397', 'I51.704', 'XJFD', '');
INSERT INTO `05diseases` VALUES ('8398', '心室肥大', '403', 'I51.705', 'XSFD', '');
INSERT INTO `05diseases` VALUES ('8399', '心室肥厚', '403', 'I51.706', 'XSFH', '');
INSERT INTO `05diseases` VALUES ('8400', '心室扩大', '403', 'I51.707', 'XSKD', '');
INSERT INTO `05diseases` VALUES ('8401', '心脏肥大', '403', 'I51.708', 'XZFD', '');
INSERT INTO `05diseases` VALUES ('8402', '心脏扩大', '403', 'I51.709', 'XZKD', '');
INSERT INTO `05diseases` VALUES ('8403', '运动员心脏[无瓣膜疾患的心脏肥大]', '403', 'I51.751', 'YDYXZWBMJHDXZFD', '');
INSERT INTO `05diseases` VALUES ('8404', '房室肥厚', '278', 'I51.752', 'FSFH', '');
INSERT INTO `05diseases` VALUES ('8405', '全心炎', '404', 'I51.801', 'QXY', '');
INSERT INTO `05diseases` VALUES ('8406', '乳头肌功能不全', '86', 'I51.802', 'RTJGNBQ', '');
INSERT INTO `05diseases` VALUES ('8407', '心房肿物', '403', 'I51.803', 'XFZW', '');
INSERT INTO `05diseases` VALUES ('8408', '扁桃心脏综合征', '403', 'I51.851', 'BTXZZHZ', '');
INSERT INTO `05diseases` VALUES ('8409', '心脏运动过度(综合征)', '403', 'I51.852', 'XZYDGDZHZ', '');
INSERT INTO `05diseases` VALUES ('8410', '肾源性心脏病', '403', 'I51.853', 'SYXXZB', '');
INSERT INTO `05diseases` VALUES ('8411', '原因不明心脏病', '403', 'I51.854', 'YYBMXZB', '');
INSERT INTO `05diseases` VALUES ('8412', '肝源性心脏病', '403', 'I51.901', 'GYXXZB', '');
INSERT INTO `05diseases` VALUES ('8413', '贫血性心脏病', '403', 'I51.902', 'PXXXZB', '');
INSERT INTO `05diseases` VALUES ('8414', '心功能Ⅰ级', '404', 'I51.903', 'XGNYJ', '');
INSERT INTO `05diseases` VALUES ('8415', '心脏病 NOS', '403', 'I51.904', 'XZB', '');
INSERT INTO `05diseases` VALUES ('8416', '颈内动脉瘤破裂入脑', '234', 'I60.001', 'GNDMLPLRN', '');
INSERT INTO `05diseases` VALUES ('8417', '颈动脉弯管和杈的珠网膜下腔出血', '178', 'I60.051', 'GDMWGHCDZWMXQCX', '');
INSERT INTO `05diseases` VALUES ('8418', '大脑中动脉出血', '234', 'I60.151', 'DNZDMCX', '');
INSERT INTO `05diseases` VALUES ('8419', '大脑中动脉的蛛网膜下出血', '234', 'I60.152', 'DNZDMDZWMXCX', '');
INSERT INTO `05diseases` VALUES ('8420', '前交通动脉的蛛网膜下出血', '260', 'I60.251', 'QJTDMDZWMXCX', '');
INSERT INTO `05diseases` VALUES ('8421', '后交通动脉瘤破裂', '62', 'I60.301', 'HJTDMLPL', '');
INSERT INTO `05diseases` VALUES ('8422', '后交通动脉的蛛网膜下出血', '260', 'I60.351', 'HJTDMDZWMXCX', '');
INSERT INTO `05diseases` VALUES ('8423', '基底动脉的蛛网膜下出血', '260', 'I60.451', 'JDDMDZWMXCX', '');
INSERT INTO `05diseases` VALUES ('8424', '椎动脉的蛛网膜下出血', '260', 'I60.551', 'ZDMDZWMXCX', '');
INSERT INTO `05diseases` VALUES ('8425', '威利期环破裂[大脑动脉环]', '234', 'I60.651', 'WLQHPLDNDMH', '');
INSERT INTO `05diseases` VALUES ('8426', '多个颅内动脉的蛛网膜下出血', '260', 'I60.652', 'DGLNDMDZWMXCX', '');
INSERT INTO `05diseases` VALUES ('8427', '未特指的颅内动脉的蛛网膜下出血', '260', 'I60.751', 'WTZDLNDMDZWMXCX', '');
INSERT INTO `05diseases` VALUES ('8428', '交通动脉的蛛网膜下出血', '260', 'I60.752', 'JTDMDZWMXCX', '');
INSERT INTO `05diseases` VALUES ('8429', '大脑动脉的蛛网膜下出血', '234', 'I60.753', 'DNDMDZWMXCX', '');
INSERT INTO `05diseases` VALUES ('8430', '脑动脉瘤破裂', '234', 'I60.801', 'NDMLPL', '');
INSERT INTO `05diseases` VALUES ('8431', '脑膜出血', '232', 'I60.802', 'NMCX', '');
INSERT INTO `05diseases` VALUES ('8432', '蛛网膜下腔出血', '38', 'I60.901', 'ZWMXQCX', '');
INSERT INTO `05diseases` VALUES ('8433', '先天性脑动脉瘤破裂', '234', 'I60.951', 'XTXNDMLPL', '');
INSERT INTO `05diseases` VALUES ('8434', '大脑后动脉出血', '234', 'I61.001', 'DNHDMCX', '');
INSERT INTO `05diseases` VALUES ('8435', '大脑内皮质下出血', '234', 'I61.002', 'DNNPZXCX', '');
INSERT INTO `05diseases` VALUES ('8436', '豆状核出血', '38', 'I61.004', 'DZHCX', '');
INSERT INTO `05diseases` VALUES ('8437', '基底节出血', '38', 'I61.005', 'JDJCX', '');
INSERT INTO `05diseases` VALUES ('8438', '内囊出血', '38', 'I61.006', 'NNCX', '');
INSERT INTO `05diseases` VALUES ('8439', '外囊出血', '38', 'I61.007', 'WNCX', '');
INSERT INTO `05diseases` VALUES ('8440', '皮质下大脑半球的脑内出血', '234', 'I61.051', 'PZXDNBQDNNCX', '');
INSERT INTO `05diseases` VALUES ('8441', '大脑内皮质出血', '234', 'I61.101', 'DNNPZCX', '');
INSERT INTO `05diseases` VALUES ('8442', '脑内皮质出血', '234', 'I61.151', 'NNPZCX', '');
INSERT INTO `05diseases` VALUES ('8443', '皮质的大脑半球的脑内出血', '234', 'I61.152', 'PZDDNBQDNNCX', '');
INSERT INTO `05diseases` VALUES ('8444', '大脑脑叶出血', '234', 'I61.153', 'DNNYCX', '');
INSERT INTO `05diseases` VALUES ('8445', '浅表性脑内出血', '234', 'I61.154', 'QBXNNCX', '');
INSERT INTO `05diseases` VALUES ('8446', '未特指的大脑半球的脑内出血', '234', 'I61.251', 'WTZDDNBQDNNCX', '');
INSERT INTO `05diseases` VALUES ('8447', '脑干出血', '234', 'I61.301', 'NGCX', '');
INSERT INTO `05diseases` VALUES ('8448', '脑桥出血', '234', 'I61.302', 'NQCX', '');
INSERT INTO `05diseases` VALUES ('8449', '丘脑出血', '234', 'I61.303', 'QNCX', '');
INSERT INTO `05diseases` VALUES ('8450', '丘脑下部出血', '234', 'I61.304', 'QNXBCX', '');
INSERT INTO `05diseases` VALUES ('8451', '小脑出血', '234', 'I61.401', 'XNCX', '');
INSERT INTO `05diseases` VALUES ('8452', '脑室出血', '234', 'I61.501', 'NSCX', '');
INSERT INTO `05diseases` VALUES ('8453', '多处局部脑内出血', '234', 'I61.651', 'DCJBNNCX', '');
INSERT INTO `05diseases` VALUES ('8454', '颅内小动脉瘤破裂(先天性)', '62', 'I61.751', 'LNXDMLPLXTX', '');
INSERT INTO `05diseases` VALUES ('8455', '非创伤性脑内血肿', '234', 'I61.901', 'FCSXNNXZ', '');
INSERT INTO `05diseases` VALUES ('8456', '脑出血', '234', 'I61.902', 'NCX', '');
INSERT INTO `05diseases` VALUES ('8457', '脑血管破裂', '233', 'I61.903', 'NXGPL', '');
INSERT INTO `05diseases` VALUES ('8458', '脑血肿', '234', 'I61.904', 'NXZ', '');
INSERT INTO `05diseases` VALUES ('8459', '出血(外伤)性脑软化', '234', 'I61.951', 'CXWSXNRH', '');
INSERT INTO `05diseases` VALUES ('8460', '非创伤性硬脑膜下出血', '232', 'I62.001', 'FCSXYNMXCX', '');
INSERT INTO `05diseases` VALUES ('8461', '慢性硬膜下血肿', '422', 'I62.002', 'MXYMXXZ', '');
INSERT INTO `05diseases` VALUES ('8462', '颅内硬膜下出血', '38', 'I62.051', 'LNYMXCX', '');
INSERT INTO `05diseases` VALUES ('8463', '亚急性硬膜下血肿', '422', 'I62.052', 'YJXYMXXZ', '');
INSERT INTO `05diseases` VALUES ('8464', '非创伤性硬膜外血肿', '422', 'I62.101', 'FCSXYMWXZ', '');
INSERT INTO `05diseases` VALUES ('8465', '非创伤性硬脑膜外出血', '232', 'I62.102', 'FCSXYNMWCX', '');
INSERT INTO `05diseases` VALUES ('8466', '非创伤性颅内出血', '44', 'I62.901', 'FCSXLNCX', '');
INSERT INTO `05diseases` VALUES ('8467', '颅内血肿(非创伤性)', '422', 'I62.951', 'LNXZFCSX', '');
INSERT INTO `05diseases` VALUES ('8468', '脑桥被盖部综合征[雷－塞二氏综合征]', '234', 'I63.051+', 'NQBGBZHZLSESZHZ', '');
INSERT INTO `05diseases` VALUES ('8469', '塞斯坦－舍奈麻痹', '217', 'I63.052+', 'SSTSNMB', '');
INSERT INTO `05diseases` VALUES ('8470', '入脑前动脉栓塞引起的脑梗死', '234', 'I63.151', 'RNQDMSSYQDNGS', '');
INSERT INTO `05diseases` VALUES ('8471', '居布勒－米亚尔麻痹[交叉性偏瘫]', '217', 'I63.251+', 'JBLMYEMBJCXPT', '');
INSERT INTO `05diseases` VALUES ('8472', '入脑前动脉未特指的闭塞或狭窄引起的脑梗死', '234', 'I63.252', 'RNQDMWTZDBSHXZYQDNGS', '');
INSERT INTO `05diseases` VALUES ('8473', '血栓性偏瘫', '419', 'I63.301', 'XSXPT', '');
INSERT INTO `05diseases` VALUES ('8474', '脑软化伴脑血栓', '234', 'I63.351', 'NRHBNXS', '');
INSERT INTO `05diseases` VALUES ('8475', '入脑前动脉血栓形成引起的脑梗死', '234', 'I63.352', 'RNQDMXSXCYQDNGS', '');
INSERT INTO `05diseases` VALUES ('8476', '脑栓塞性偏瘫', '234', 'I63.401', 'NSSXPT', '');
INSERT INTO `05diseases` VALUES ('8477', '栓子性脑软化', '234', 'I63.451', 'SZXNRH', '');
INSERT INTO `05diseases` VALUES ('8478', '大脑动脉栓塞引起的脑梗死', '234', 'I63.452', 'DNDMSSYQDNGS', '');
INSERT INTO `05diseases` VALUES ('8479', '脑软化，脑血管闭塞性', '233', 'I63.551', 'NRHNXGBSX', '');
INSERT INTO `05diseases` VALUES ('8480', '大脑动脉未特指的闭塞或狭窄引起的脑梗死', '234', 'I63.552', 'DNDMWTZDBSHXZYQDNGS', '');
INSERT INTO `05diseases` VALUES ('8481', '大脑静脉血栓形成引起的非生脓性脑梗死', '234', 'I63.651', 'DNJMXSXCYQDFSNXNGS', '');
INSERT INTO `05diseases` VALUES ('8482', '脑干梗塞', '234', 'I63.801', 'NGGS', '');
INSERT INTO `05diseases` VALUES ('8483', '动脉硬化性脑软化', '234', 'I63.851', 'DMYHXNRH', '');
INSERT INTO `05diseases` VALUES ('8484', '脑血管病性脑软化', '233', 'I63.852', 'NXGBXNRH', '');
INSERT INTO `05diseases` VALUES ('8485', '多发性脑梗塞', '234', 'I63.901', 'DFXNGS', '');
INSERT INTO `05diseases` VALUES ('8486', '脑梗塞', '234', 'I63.902', 'NGS', '');
INSERT INTO `05diseases` VALUES ('8487', '腔隙性脑梗塞', '234', 'I63.903', 'QXXNGS', '');
INSERT INTO `05diseases` VALUES ('8488', '小脑梗塞', '234', 'I63.904', 'XNGS', '');
INSERT INTO `05diseases` VALUES ('8489', '急性偏瘫', '254', 'I64.X01', 'JXPT', '');
INSERT INTO `05diseases` VALUES ('8490', '可逆性脑卒中', '234', 'I64.X02', 'KNXNZZ', '');
INSERT INTO `05diseases` VALUES ('8491', '脑血管意外', '233', 'I64.X03', 'NXGYW', '');
INSERT INTO `05diseases` VALUES ('8492', '脑卒中[中风]', '234', 'I64.X04', 'NZZZF', '');
INSERT INTO `05diseases` VALUES ('8493', '椎动脉血栓形成', '260', 'I65.002', 'ZDMXSXC', '');
INSERT INTO `05diseases` VALUES ('8494', '椎动脉闭塞和狭窄', '58', 'I65.051+', 'ZDMBSHXZ', '');
INSERT INTO `05diseases` VALUES ('8495', '基底动脉闭塞和狭窄', '58', 'I65.101', 'JDDMBSHXZ', '');
INSERT INTO `05diseases` VALUES ('8496', '基底动脉血栓形成', '260', 'I65.102', 'JDDMXSXC', '');
INSERT INTO `05diseases` VALUES ('8497', '颈动脉动脉硬化', '63', 'I65.201', 'GDMDMYH', '');
INSERT INTO `05diseases` VALUES ('8498', '颈动脉狭窄', '178', 'I65.202', 'GDMXZ', '');
INSERT INTO `05diseases` VALUES ('8499', '颈内动脉闭塞和狭窄', '58', 'I65.203', 'GNDMBSHXZ', '');
INSERT INTO `05diseases` VALUES ('8500', '颈内动脉栓塞', '260', 'I65.204', 'GNDMSS', '');
INSERT INTO `05diseases` VALUES ('8501', '颈内动脉狭窄', '260', 'I65.205', 'GNDMXZ', '');
INSERT INTO `05diseases` VALUES ('8502', '颈内动脉血栓形成', '260', 'I65.206', 'GNDMXSXC', '');
INSERT INTO `05diseases` VALUES ('8503', '颈外动脉闭塞', '58', 'I65.207', 'GWDMBS', '');
INSERT INTO `05diseases` VALUES ('8504', '双侧入脑前动脉的闭塞和狭窄', '234', 'I65.352', 'SCRNQDMDBSHXZ', '');
INSERT INTO `05diseases` VALUES ('8505', '多个入脑前动脉的闭塞和狭窄', '234', 'I65.354', 'DGRNQDMDBSHXZ', '');
INSERT INTO `05diseases` VALUES ('8506', '其他入脑前动脉的闭塞和狭窄', '234', 'I65.852', 'QTRNQDMDBSHXZ', '');
INSERT INTO `05diseases` VALUES ('8507', '入脑前动脉的狭窄 NOS', '234', 'I65.951', 'RNQDMDXZ', '');
INSERT INTO `05diseases` VALUES ('8508', '入脑前动脉的闭塞 NOS', '234', 'I65.952', 'RNQDMDBS', '');
INSERT INTO `05diseases` VALUES ('8509', '大脑中动脉闭塞', '234', 'I66.001', 'DNZDMBS', '');
INSERT INTO `05diseases` VALUES ('8510', '大脑中动脉综合征', '234', 'I66.051+', 'DNZDMZHZ', '');
INSERT INTO `05diseases` VALUES ('8511', '大脑前动脉综合征', '234', 'I66.151+', 'DNQDMZHZ', '');
INSERT INTO `05diseases` VALUES ('8512', '大脑后动脉综合征', '234', 'I66.251+', 'DNHDMZHZ', '');
INSERT INTO `05diseases` VALUES ('8513', '小脑后下动脉血栓形成', '234', 'I66.301', 'XNHXDMXSXC', '');
INSERT INTO `05diseases` VALUES ('8514', '延髓背外侧综合征', '278', 'I66.302+', 'YSBWCZHZ', '');
INSERT INTO `05diseases` VALUES ('8515', '瓦伦贝格氏综合征[延髓外侧部综合征]', '278', 'I66.303+', 'WLBGSZHZYSWCBZHZ', '');
INSERT INTO `05diseases` VALUES ('8516', '小脑前下动脉血栓形成', '234', 'I66.351', 'XNQXDMXSXC', '');
INSERT INTO `05diseases` VALUES ('8517', '双侧大脑动脉狭窄', '234', 'I66.451', 'SCDNDMXZ', '');
INSERT INTO `05diseases` VALUES ('8518', '双侧大脑动脉的闭塞', '234', 'I66.452', 'SCDNDMDBS', '');
INSERT INTO `05diseases` VALUES ('8519', '多个大脑动脉闭塞和狭窄', '234', 'I66.453', 'DGDNDMBSHXZ', '');
INSERT INTO `05diseases` VALUES ('8520', '克洛德综合征', '278', 'I66.851+', 'KLDZHZ', '');
INSERT INTO `05diseases` VALUES ('8521', '惯穿性动脉闭塞和狭窄', '58', 'I66.852', 'GCXDMBSHXZ', '');
INSERT INTO `05diseases` VALUES ('8522', '大脑动脉闭塞', '234', 'I66.901', 'DNDMBS', '');
INSERT INTO `05diseases` VALUES ('8523', '脑动脉栓塞', '234', 'I66.902', 'NDMSS', '');
INSERT INTO `05diseases` VALUES ('8524', '脑栓塞', '234', 'I66.903', 'NSS', '');
INSERT INTO `05diseases` VALUES ('8525', '脑血栓形成', '234', 'I66.904', 'NXSXC', '');
INSERT INTO `05diseases` VALUES ('8526', '闭塞性脑血管病', '233', 'I66.951', 'BSXNXGB', '');
INSERT INTO `05diseases` VALUES ('8527', '大脑动脉狭窄', '234', 'I66.952', 'DNDMXZ', '');
INSERT INTO `05diseases` VALUES ('8528', '闭锁综合症(Locked－In)', '278', 'I66.953', 'BSZHZ', '');
INSERT INTO `05diseases` VALUES ('8529', '非破裂性大脑动脉壁夹层形成', '234', 'I67.051', 'FPLXDNDMBJCXC', '');
INSERT INTO `05diseases` VALUES ('8530', '大脑动脉瘤', '234', 'I67.101', 'DNDML', '');
INSERT INTO `05diseases` VALUES ('8531', '后交通动脉瘤', '62', 'I67.102', 'HJTDML', '');
INSERT INTO `05diseases` VALUES ('8532', '颈内动脉--海绵窦瘘', '260', 'I67.103', 'GNDMHMDL', '');
INSERT INTO `05diseases` VALUES ('8533', '颅内动脉瘤', '62', 'I67.104', 'LNDML', '');
INSERT INTO `05diseases` VALUES ('8534', '脑动静脉瘘', '234', 'I67.105', 'NDJML', '');
INSERT INTO `05diseases` VALUES ('8535', '脑基底动脉瘤', '234', 'I67.106', 'NJDDML', '');
INSERT INTO `05diseases` VALUES ('8536', '脑膜动静脉瘘', '232', 'I67.107', 'NMDJML', '');
INSERT INTO `05diseases` VALUES ('8537', '前交通动脉瘤', '62', 'I67.108', 'QJTDML', '');
INSERT INTO `05diseases` VALUES ('8538', '小脑动脉瘤', '234', 'I67.109', 'XNDML', '');
INSERT INTO `05diseases` VALUES ('8539', '非破裂性大脑脑动脉瘤', '234', 'I67.151', 'FPLXDNNDML', '');
INSERT INTO `05diseases` VALUES ('8540', '非破裂性颅内脑动脉瘤', '234', 'I67.152', 'FPLXLNNDML', '');
INSERT INTO `05diseases` VALUES ('8541', '非破裂性后交通支脑动脉瘤', '234', 'I67.153', 'FPLXHJTZNDML', '');
INSERT INTO `05diseases` VALUES ('8542', '后天性大脑的动静脉瘘', '234', 'I67.154', 'HTXDNDDJML', '');
INSERT INTO `05diseases` VALUES ('8543', '动脉硬化性脑病', '234', 'I67.201', 'DMYHXNB', '');
INSERT INTO `05diseases` VALUES ('8544', '脑动脉硬化', '234', 'I67.202', 'NDMYH', '');
INSERT INTO `05diseases` VALUES ('8545', '皮层下动脉硬化性脑病', '234', 'I67.203', 'PCXDMYHXNB', '');
INSERT INTO `05diseases` VALUES ('8546', '脑(动脉)血管硬化', '234', 'I67.251', 'NDMXGYH', '');
INSERT INTO `05diseases` VALUES ('8547', '大脑动脉粥样硬化症', '234', 'I67.252', 'DNDMZYYHZ', '');
INSERT INTO `05diseases` VALUES ('8548', '肾动脉粥样硬化症', '260', 'I67.253', 'SDMZYYHZ', '');
INSERT INTO `05diseases` VALUES ('8549', '椎基底动脉硬化', '63', 'I67.254', 'ZJDDMYH', '');
INSERT INTO `05diseases` VALUES ('8550', '宾斯万格氏病(早老性痴呆的一种)', '34', 'I67.301', 'BSWGSBZLXCDDYZ', '');
INSERT INTO `05diseases` VALUES ('8551', '进行性白质脑病[宾斯旺格病]', '234', 'I67.351', 'JXXBZNBBSWGB', '');
INSERT INTO `05diseases` VALUES ('8552', '高血压性脑病', '234', 'I67.401', 'GXYXNB', '');
INSERT INTO `05diseases` VALUES ('8553', '脑底异常血管网病(云雾病)', '234', 'I67.501', 'NDYCXGWBYWB', '');
INSERT INTO `05diseases` VALUES ('8554', '非化脓性大脑静脉血栓形成', '234', 'I67.651', 'FHNXDNJMXSXC', '');
INSERT INTO `05diseases` VALUES ('8555', '非化脓性颅内静脉窦血栓形成', '419', 'I67.652', 'FHNXLNJMDXSXC', '');
INSERT INTO `05diseases` VALUES ('8556', '脑动脉炎', '234', 'I67.701', 'NDMY', '');
INSERT INTO `05diseases` VALUES ('8557', '急性脑血管病', '233', 'I67.801', 'JXNXGB', '');
INSERT INTO `05diseases` VALUES ('8558', '脑动脉供血不足', '234', 'I67.802', 'NDMGXBZ', '');
INSERT INTO `05diseases` VALUES ('8559', '脑坏死', '234', 'I67.803', 'NHS', '');
INSERT INTO `05diseases` VALUES ('8560', '脑血管供血不足', '233', 'I67.804', 'NXGGXBZ', '');
INSERT INTO `05diseases` VALUES ('8561', '缺血性脑血管病', '233', 'I67.805', 'QXXNXGB', '');
INSERT INTO `05diseases` VALUES ('8562', '一过性脑缺血', '234', 'I67.851', 'YGXNQX', '');
INSERT INTO `05diseases` VALUES ('8563', '一过性脑缺氧', '234', 'I67.852', 'YGXNQY', '');
INSERT INTO `05diseases` VALUES ('8564', '脑桥内侧部综合征[福维耳氏综合征；外展－面神经交叉性偏瘫]', '313', 'I67.853+', 'NQNCBZHZFWESZHZWZMSJ', '');
INSERT INTO `05diseases` VALUES ('8565', '复发性脑血管病', '233', 'I67.901', 'FFXNXGB', '');
INSERT INTO `05diseases` VALUES ('8566', '海绵窦受压综合征', '278', 'I67.902', 'HMDSYZHZ', '');
INSERT INTO `05diseases` VALUES ('8567', '脑血管病', '233', 'I67.903', 'NXGB', '');
INSERT INTO `05diseases` VALUES ('8568', '中脑腹部侧综合征[韦伯氏综合征；大脑脚综合征]', '234', 'I67.904+', 'ZNFBCZHZWBSZHZDNJZHZ', '');
INSERT INTO `05diseases` VALUES ('8569', '海绵窦受压综合症', '278', 'I67.951', 'HMDSYZHZ', '');
INSERT INTO `05diseases` VALUES ('8570', '脑干中风发作综合征', '234', 'I67.951+', 'NGZFFZZHZ', '');
INSERT INTO `05diseases` VALUES ('8571', '脑桥腹外侧综合征[米－古二氏综合征；交叉性偏瘫]', '234', 'I67.952+', 'NQFWCZHZMGESZHZJCXPT', '');
INSERT INTO `05diseases` VALUES ('8572', '小脑中风发作综合症', '234', 'I67.953+', 'XNZFFZZHZ', '');
INSERT INTO `05diseases` VALUES ('8573', '单纯运动性腔隙综合征', '278', 'I67.954+', 'DCYDXQXZHZ', '');
INSERT INTO `05diseases` VALUES ('8574', '单纯性感觉性腔隙综合征', '278', 'I67.955+', 'DCXGJXQXZHZ', '');
INSERT INTO `05diseases` VALUES ('8575', '其他腔隙综合征', '278', 'I67.956+', 'QTQXZHZ', '');
INSERT INTO `05diseases` VALUES ('8576', '蛛网膜下出血后遗症', '38', 'I69.051', 'ZWMXCXHYZ', '');
INSERT INTO `05diseases` VALUES ('8577', '脑出血后遗症', '234', 'I69.101', 'NCXHYZ', '');
INSERT INTO `05diseases` VALUES ('8578', '脑梗塞后遗症', '234', 'I69.301', 'NGSHYZ', '');
INSERT INTO `05diseases` VALUES ('8579', '出血或梗死中风后遗症 NOS', '38', 'I69.451', 'CXHGSZFHYZ', '');
INSERT INTO `05diseases` VALUES ('8580', '脑卒中后遗症', '234', 'I69.452', 'NZZHYZ', '');
INSERT INTO `05diseases` VALUES ('8581', '脑血管病后遗症', '233', 'I69.801', 'NXGBHYZ', '');
INSERT INTO `05diseases` VALUES ('8582', '脑血管病恢复期', '233', 'I69.802', 'NXGBHFQ', '');
INSERT INTO `05diseases` VALUES ('8583', '缺血缺氧性脑病后遗症', '234', 'I69.803', 'QXQYXNBHYZ', '');
INSERT INTO `05diseases` VALUES ('8584', '脑血栓后遗症', '234', 'I69.851', 'NXSHYZ', '');
INSERT INTO `05diseases` VALUES ('8585', '主动脉钙化', '477', 'I70.002', 'ZDMGH', '');
INSERT INTO `05diseases` VALUES ('8586', '主动脉硬化', '477', 'I70.003', 'ZDMYH', '');
INSERT INTO `05diseases` VALUES ('8587', '钙化性升主动脉狭窄', '477', 'I70.051', 'GHXSZDMXZ', '');
INSERT INTO `05diseases` VALUES ('8588', '主动脉粥样硬化症', '477', 'I70.052', 'ZDMZYYHZ', '');
INSERT INTO `05diseases` VALUES ('8589', '升主动脉弓狭窄', '477', 'I70.053', 'SZDMGXZ', '');
INSERT INTO `05diseases` VALUES ('8590', '动脉硬化性升主动脉狭窄', '477', 'I70.054', 'DMYHXSZDMXZ', '');
INSERT INTO `05diseases` VALUES ('8591', '肾动脉狭窄', '260', 'I70.101', 'SDMXZ', '');
INSERT INTO `05diseases` VALUES ('8592', '戈德布拉特肾', '314', 'I70.151', 'GDBLTS', '');
INSERT INTO `05diseases` VALUES ('8593', '闭塞性髂动脉硬化', '63', 'I70.201', 'BSXQDMYH', '');
INSERT INTO `05diseases` VALUES ('8594', '肢体动脉硬化', '63', 'I70.202', 'ZTDMYH', '');
INSERT INTO `05diseases` VALUES ('8595', '下肢动脉粥样硬化闭塞症', '260', 'I70.203', 'XZDMZYYHBSZ', '');
INSERT INTO `05diseases` VALUES ('8596', '肢体闭塞性动脉硬化', '63', 'I70.204', 'ZTBSXDMYH', '');
INSERT INTO `05diseases` VALUES ('8597', '蒙门克伯格氏硬化症', '278', 'I70.251', 'MMKBGSYHZ', '');
INSERT INTO `05diseases` VALUES ('8598', '闭塞性肢体动脉硬化', '63', 'I70.252', 'BSXZTDMYH', '');
INSERT INTO `05diseases` VALUES ('8599', '视网膜动脉硬化', '63', 'I70.801', 'SWMDMYH', '');
INSERT INTO `05diseases` VALUES ('8600', '腹主动脉硬化', '477', 'I70.851', 'FZDMYH', '');
INSERT INTO `05diseases` VALUES ('8601', '闭塞性视网膜动脉炎', '260', 'I70.852', 'BSXSWMDMY', '');
INSERT INTO `05diseases` VALUES ('8602', '高血压性视网膜动脉硬化', '63', 'I70.853+', 'GXYXSWMDMYH', '');
INSERT INTO `05diseases` VALUES ('8603', '眼底动脉硬化', '430', 'I70.854', 'YDDMYH', '');
INSERT INTO `05diseases` VALUES ('8604', '闭塞性动脉炎', '260', 'I70.901', 'BSXDMY', '');
INSERT INTO `05diseases` VALUES ('8605', '闭塞性动脉硬化', '63', 'I70.902', 'BSXDMYH', '');
INSERT INTO `05diseases` VALUES ('8606', '动脉硬化', '63', 'I70.903', 'DMYH', '');
INSERT INTO `05diseases` VALUES ('8607', '动脉粥样硬化', '260', 'I70.904', 'DMZYYH', '');
INSERT INTO `05diseases` VALUES ('8608', '周身性动脉硬化', '63', 'I70.905', 'ZSXDMYH', '');
INSERT INTO `05diseases` VALUES ('8609', '老年性动脉炎', '260', 'I70.951', 'LNXDMY', '');
INSERT INTO `05diseases` VALUES ('8610', '血栓性闭塞性(无脉病)动脉炎', '260', 'I70.952', 'XSXBSXWMBDMY', '');
INSERT INTO `05diseases` VALUES ('8611', '主动脉夹层动脉瘤破裂', '477', 'I71.001', 'ZDMJCDMLPL', '');
INSERT INTO `05diseases` VALUES ('8612', '主动脉夹层动脉瘤', '477', 'I71.002', 'ZDMJCDML', '');
INSERT INTO `05diseases` VALUES ('8613', '胸主动脉动脉瘤破裂', '477', 'I71.101', 'XZDMDMLPL', '');
INSERT INTO `05diseases` VALUES ('8614', '升主动脉动脉瘤', '477', 'I71.201', 'SZDMDML', '');
INSERT INTO `05diseases` VALUES ('8615', '升主动脉扩张', '477', 'I71.202', 'SZDMKZ', '');
INSERT INTO `05diseases` VALUES ('8616', '胸主动脉动脉瘤[霍奇森病]', '477', 'I71.203', 'XZDMDMLHQSB', '');
INSERT INTO `05diseases` VALUES ('8617', '主动脉弓动脉瘤', '477', 'I71.204', 'ZDMGDML', '');
INSERT INTO `05diseases` VALUES ('8618', '主动脉弓假性动脉瘤', '477', 'I71.205', 'ZDMGJXDML', '');
INSERT INTO `05diseases` VALUES ('8619', '腹主动脉动脉瘤破裂', '477', 'I71.301', 'FZDMDMLPL', '');
INSERT INTO `05diseases` VALUES ('8620', '腹主动脉瘤破裂', '477', 'I71.302', 'FZDMLPL', '');
INSERT INTO `05diseases` VALUES ('8621', '腹腔动脉动脉瘤', '62', 'I71.401', 'FQDMDML', '');
INSERT INTO `05diseases` VALUES ('8622', '腹主动脉动脉瘤', '477', 'I71.402', 'FZDMDML', '');
INSERT INTO `05diseases` VALUES ('8623', '胸腹主动脉动脉瘤伴破裂', '477', 'I71.551', 'XFZDMDMLBPL', '');
INSERT INTO `05diseases` VALUES ('8624', '胸腹主动脉动脉瘤', '477', 'I71.651', 'XFZDMDML', '');
INSERT INTO `05diseases` VALUES ('8625', '主动脉破裂', '477', 'I71.801', 'ZDMPL', '');
INSERT INTO `05diseases` VALUES ('8626', '降主动脉动脉瘤', '477', 'I71.901', 'JZDMDML', '');
INSERT INTO `05diseases` VALUES ('8627', '主动脉动脉瘤', '477', 'I71.902', 'ZDMDML', '');
INSERT INTO `05diseases` VALUES ('8628', '主动脉扩张', '477', 'I71.903', 'ZDMKZ', '');
INSERT INTO `05diseases` VALUES ('8629', '主动脉的玻璃样坏死', '477', 'I71.951', 'ZDMDBLYHS', '');
INSERT INTO `05diseases` VALUES ('8630', '创伤性颈动脉瘤', '62', 'I72.001', 'CSXGDML', '');
INSERT INTO `05diseases` VALUES ('8631', '颈动脉动脉瘤', '62', 'I72.002', 'GDMDML', '');
INSERT INTO `05diseases` VALUES ('8632', '颈动脉扩张', '61', 'I72.003', 'GDMKZ', '');
INSERT INTO `05diseases` VALUES ('8633', '颈内动脉动脉瘤', '62', 'I72.004', 'GNDMDML', '');
INSERT INTO `05diseases` VALUES ('8634', '颈内动脉瘤破裂', '62', 'I72.005', 'GNDMLPL', '');
INSERT INTO `05diseases` VALUES ('8635', '颈外动脉夹层动脉瘤', '62', 'I72.006', 'GWDMJCDML', '');
INSERT INTO `05diseases` VALUES ('8636', '上肢动脉动脉瘤', '62', 'I72.101', 'SZDMDML', '');
INSERT INTO `05diseases` VALUES ('8637', '上肢假性动脉瘤', '62', 'I72.102', 'SZJXDML', '');
INSERT INTO `05diseases` VALUES ('8638', '外伤性上肢动脉瘤', '62', 'I72.151', 'WSXSZDML', '');
INSERT INTO `05diseases` VALUES ('8639', '肾动脉动脉瘤', '62', 'I72.201', 'SDMDML', '');
INSERT INTO `05diseases` VALUES ('8640', '髂(总)动脉动脉瘤', '62', 'I72.301', 'QZDMDML', '');
INSERT INTO `05diseases` VALUES ('8641', '髂动脉瘤', '62', 'I72.302', 'QDML', '');
INSERT INTO `05diseases` VALUES ('8642', '创伤性股动脉瘤', '62', 'I72.401', 'CSXGDML', '');
INSERT INTO `05diseases` VALUES ('8643', '创伤性股假性动脉瘤', '62', 'I72.402', 'CSXGJXDML', '');
INSERT INTO `05diseases` VALUES ('8644', '股动脉假性动脉瘤', '62', 'I72.403', 'GDMJXDML', '');
INSERT INTO `05diseases` VALUES ('8645', '下肢动脉动脉瘤', '62', 'I72.404', 'XZDMDML', '');
INSERT INTO `05diseases` VALUES ('8646', '下肢假性动脉瘤', '62', 'I72.405', 'XZJXDML', '');
INSERT INTO `05diseases` VALUES ('8647', '腘动脉动脉瘤', '62', 'I72.451', 'MTJ', '');
INSERT INTO `05diseases` VALUES ('8648', '肝动脉动脉瘤', '92', 'I72.801', 'GDMDML', '');
INSERT INTO `05diseases` VALUES ('8649', '眶内动脉动脉瘤', '62', 'I72.802', 'KNDMDML', '');
INSERT INTO `05diseases` VALUES ('8650', '脾动脉动脉瘤', '62', 'I72.803', 'PDMDML', '');
INSERT INTO `05diseases` VALUES ('8651', '锁骨上假性动脉瘤', '62', 'I72.804', 'SGSJXDML', '');
INSERT INTO `05diseases` VALUES ('8652', '锁骨下动脉动脉瘤', '62', 'I72.805', 'SGXDMDML', '');
INSERT INTO `05diseases` VALUES ('8653', '无名动脉动脉瘤', '62', 'I72.806', 'WMDMDML', '');
INSERT INTO `05diseases` VALUES ('8654', '椎动脉动脉瘤', '62', 'I72.807', 'ZDMDML', '');
INSERT INTO `05diseases` VALUES ('8655', '椎假性动脉瘤', '62', 'I72.808', 'ZJXDML', '');
INSERT INTO `05diseases` VALUES ('8656', '腹腔动脉瘤', '62', 'I72.851', 'FQDML', '');
INSERT INTO `05diseases` VALUES ('8657', '后交通动脉动脉瘤', '62', 'I72.852', 'HJTDMDML', '');
INSERT INTO `05diseases` VALUES ('8658', '肠系膜动脉瘤', '62', 'I72.853', 'CXMDML', '');
INSERT INTO `05diseases` VALUES ('8659', '动脉瘤', '62', 'I72.901', 'DML', '');
INSERT INTO `05diseases` VALUES ('8660', '头顶部动脉瘤', '62', 'I72.951', 'TDBDML', '');
INSERT INTO `05diseases` VALUES ('8661', '动脉扩张', '61', 'I72.952', 'DMKZ', '');
INSERT INTO `05diseases` VALUES ('8662', '雷诺氏综合征', '278', 'I73.001', 'LNSZHZ', '');
INSERT INTO `05diseases` VALUES ('8663', '阵发性指(趾)发绀', '278', 'I73.051', 'ZFXZZFG', '');
INSERT INTO `05diseases` VALUES ('8664', '闭塞性血栓性脉管炎(血栓闭塞性脉管炎)[伯格氏病]', '419', 'I73.101', 'BSXXSXMGYXSBSXMGYBGS', '');
INSERT INTO `05diseases` VALUES ('8665', '股绀红皮病', '268', 'I73.801', 'GGHPB', '');
INSERT INTO `05diseases` VALUES ('8666', '上肢缺血', '308', 'I73.802', 'SZQX', '');
INSERT INTO `05diseases` VALUES ('8667', '四肢供血不足', '339', 'I73.803', 'SZGXBZ', '');
INSERT INTO `05diseases` VALUES ('8668', '下肢缺血', '382', 'I73.804', 'XZQX', '');
INSERT INTO `05diseases` VALUES ('8669', '肢端红痛症[红斑性肢痛病]', '250', 'I73.805', 'ZDHTZHBXZTB', '');
INSERT INTO `05diseases` VALUES ('8670', '肢端血管功能失调', '413', 'I73.806', 'ZDXGGNSD', '');
INSERT INTO `05diseases` VALUES ('8671', '手足发绀', '280', 'I73.851', 'SZFG', '');
INSERT INTO `05diseases` VALUES ('8672', '暂时性血管舒缩病', '413', 'I73.852', 'ZSXXGSSB', '');
INSERT INTO `05diseases` VALUES ('8673', '小腿绀红皮病', '268', 'I73.853', 'XTGHPB', '');
INSERT INTO `05diseases` VALUES ('8674', '动脉痉挛', '260', 'I73.901', 'DMJL', '');
INSERT INTO `05diseases` VALUES ('8675', '间歇性跛行', '278', 'I73.902', 'JXXBX', '');
INSERT INTO `05diseases` VALUES ('8676', '血管痉挛', '179', 'I73.903', 'XGJL', '');
INSERT INTO `05diseases` VALUES ('8677', '周围血管病', '413', 'I73.904', 'ZWXGB', '');
INSERT INTO `05diseases` VALUES ('8678', '腹主动脉闭塞', '477', 'I74.001', 'FZDMBS', '');
INSERT INTO `05diseases` VALUES ('8679', '腹主动脉血栓形成', '477', 'I74.002', 'FZDMXSXC', '');
INSERT INTO `05diseases` VALUES ('8680', '勒里什氏综合征[主动脉自发性血栓形成综合征]', '477', 'I74.003', 'LLSSZHZZDMZFXXSXCZHZ', '');
INSERT INTO `05diseases` VALUES ('8681', '主动脉分叉综合征', '477', 'I74.051', 'ZDMFCZHZ', '');
INSERT INTO `05diseases` VALUES ('8682', '主动脉栓塞', '477', 'I74.101', 'ZDMSS', '');
INSERT INTO `05diseases` VALUES ('8683', '主动脉血栓形成', '477', 'I74.102', 'ZDMXSXC', '');
INSERT INTO `05diseases` VALUES ('8684', '上肢动脉梗阻', '260', 'I74.201', 'SZDMGZ', '');
INSERT INTO `05diseases` VALUES ('8685', '上肢动脉栓塞', '260', 'I74.202', 'SZDMSS', '');
INSERT INTO `05diseases` VALUES ('8686', '创伤性股动静脉血栓形成', '44', 'I74.301', 'CSXGDJMXSXC', '');
INSERT INTO `05diseases` VALUES ('8687', '创伤性胫后动脉血栓形成', '260', 'I74.302', 'CSXJHDMXSXC', '');
INSERT INTO `05diseases` VALUES ('8688', '股动脉闭塞', '58', 'I74.303', 'GDMBS', '');
INSERT INTO `05diseases` VALUES ('8689', '股动脉梗阻', '260', 'I74.304', 'GDMGZ', '');
INSERT INTO `05diseases` VALUES ('8690', '下肢动脉栓塞', '260', 'I74.305', 'XZDMSS', '');
INSERT INTO `05diseases` VALUES ('8691', '下肢动脉血栓形成', '260', 'I74.306', 'XZDMXSXC', '');
INSERT INTO `05diseases` VALUES ('8692', '四肢动脉栓塞', '260', 'I74.401', 'SZDMSS', '');
INSERT INTO `05diseases` VALUES ('8693', '周围动脉栓塞', '260', 'I74.402', 'ZWDMSS', '');
INSERT INTO `05diseases` VALUES ('8694', '创伤性髂总动脉血栓形成', '260', 'I74.501', 'CSXQZDMXSXC', '');
INSERT INTO `05diseases` VALUES ('8695', '髂动脉闭塞', '58', 'I74.502', 'QDMBS', '');
INSERT INTO `05diseases` VALUES ('8696', '髂总动脉血栓形成', '260', 'I74.503', 'QZDMXSXC', '');
INSERT INTO `05diseases` VALUES ('8697', '髂总动脉栓塞', '260', 'I74.504', 'QZDMSS', '');
INSERT INTO `05diseases` VALUES ('8698', '腹腔动脉闭塞', '58', 'I74.801', 'FQDMBS', '');
INSERT INTO `05diseases` VALUES ('8699', '腹腔动脉血栓形成', '260', 'I74.802', 'FQDMXSXC', '');
INSERT INTO `05diseases` VALUES ('8700', '肝动脉血栓形成', '92', 'I74.803', 'GDMXSXC', '');
INSERT INTO `05diseases` VALUES ('8701', '脾栓塞', '253', 'I74.804', 'PSS', '');
INSERT INTO `05diseases` VALUES ('8702', '其他特指部位的动脉栓塞', '260', 'I74.805', 'QTTZBWDDMSS', '');
INSERT INTO `05diseases` VALUES ('8703', '锁骨下动脉闭塞', '58', 'I74.806', 'SGXDMBS', '');
INSERT INTO `05diseases` VALUES ('8704', '锁骨下动脉血栓形成', '260', 'I74.807', 'SGXDMXSXC', '');
INSERT INTO `05diseases` VALUES ('8705', '内听动脉闭塞', '58', 'I74.851', 'NTDMBS', '');
INSERT INTO `05diseases` VALUES ('8706', '动脉栓塞', '260', 'I74.901', 'DMSS', '');
INSERT INTO `05diseases` VALUES ('8707', '多发性动脉栓塞', '260', 'I74.902', 'DFXDMSS', '');
INSERT INTO `05diseases` VALUES ('8708', '血栓形成 NOS', '419', 'I74.951', 'XSXC', '');
INSERT INTO `05diseases` VALUES ('8709', '多发性动静脉瘘', '212', 'I77.001', 'DFXDJML', '');
INSERT INTO `05diseases` VALUES ('8710', '股动静脉瘘', '212', 'I77.002', 'GDJML', '');
INSERT INTO `05diseases` VALUES ('8711', '后天性动静脉瘘', '212', 'I77.003', 'HTXDJML', '');
INSERT INTO `05diseases` VALUES ('8712', '眶动静脉瘘', '212', 'I77.004', 'KDJML', '');
INSERT INTO `05diseases` VALUES ('8713', '盆腔动静脉瘘', '212', 'I77.005', 'PQDJML', '');
INSERT INTO `05diseases` VALUES ('8714', '锁骨下动静脉瘘', '212', 'I77.006', 'SGXDJML', '');
INSERT INTO `05diseases` VALUES ('8715', '下肢动静脉瘘', '212', 'I77.007', 'XZDJML', '');
INSERT INTO `05diseases` VALUES ('8716', '子宫旁动静脉瘘', '86', 'I77.008', 'ZGPDJML', '');
INSERT INTO `05diseases` VALUES ('8717', '动脉狭窄', '260', 'I77.101', 'DMXZ', '');
INSERT INTO `05diseases` VALUES ('8718', '腹主动脉狭窄', '477', 'I77.102', 'FZDMXZ', '');
INSERT INTO `05diseases` VALUES ('8719', '肱动脉扭曲', '260', 'I77.103', 'GDMNQ', '');
INSERT INTO `05diseases` VALUES ('8720', '髂动脉狭窄', '260', 'I77.104', 'QDMXZ', '');
INSERT INTO `05diseases` VALUES ('8721', '髂动脉纡曲', '260', 'I77.105', 'QDMYQ', '');
INSERT INTO `05diseases` VALUES ('8722', '上肢动脉狭窄', '260', 'I77.106', 'SZDMXZ', '');
INSERT INTO `05diseases` VALUES ('8723', '锁骨下动脉狭窄', '260', 'I77.107', 'SGXDMXZ', '');
INSERT INTO `05diseases` VALUES ('8724', '无名动脉迂曲', '260', 'I77.108', 'WMDMYQ', '');
INSERT INTO `05diseases` VALUES ('8725', '下肢动脉狭窄', '260', 'I77.109', 'XZDMXZ', '');
INSERT INTO `05diseases` VALUES ('8726', '动脉瘘', '260', 'I77.201', 'DML', '');
INSERT INTO `05diseases` VALUES ('8727', '腹主动脉-空肠瘘', '477', 'I77.202', 'FZDMKCL', '');
INSERT INTO `05diseases` VALUES ('8728', '动脉溃疡', '260', 'I77.251', 'DMKY', '');
INSERT INTO `05diseases` VALUES ('8729', '动脉糜烂', '260', 'I77.252', 'DMML', '');
INSERT INTO `05diseases` VALUES ('8730', '动脉破裂', '260', 'I77.253', 'DMPL', '');
INSERT INTO `05diseases` VALUES ('8731', '化脓性动脉炎', '260', 'I77.254', 'HNXDMY', '');
INSERT INTO `05diseases` VALUES ('8732', '动脉纤维肌肉增生', '260', 'I77.351', 'DMXWJRZS', '');
INSERT INTO `05diseases` VALUES ('8733', '腹腔动脉受压综合征', '260', 'I77.401', 'FQDMSYZHZ', '');
INSERT INTO `05diseases` VALUES ('8734', '慢性肠道缺血综合征', '31', 'I77.451', 'MXCDQXZHZ', '');
INSERT INTO `05diseases` VALUES ('8735', '颈动脉痛[颈动脉炎]', '178', 'I77.452', 'GDMTGDMY', '');
INSERT INTO `05diseases` VALUES ('8736', '动脉坏死', '260', 'I77.501', 'DMHS', '');
INSERT INTO `05diseases` VALUES ('8737', '坏死性血管炎', '415', 'I77.502', 'HSXXGY', '');
INSERT INTO `05diseases` VALUES ('8738', '大动脉炎', '260', 'I77.601', 'DDMY', '');
INSERT INTO `05diseases` VALUES ('8739', '动脉内膜炎', '260', 'I77.602', 'DMNMY', '');
INSERT INTO `05diseases` VALUES ('8740', '动脉炎', '260', 'I77.603', 'DMY', '');
INSERT INTO `05diseases` VALUES ('8741', '多发性大动脉炎', '260', 'I77.604', 'DFXDDMY', '');
INSERT INTO `05diseases` VALUES ('8742', '血管炎(脉管炎)', '220', 'I77.605', 'XGYMGY', '');
INSERT INTO `05diseases` VALUES ('8743', '上肢动脉炎', '260', 'I77.606', 'SZDMY', '');
INSERT INTO `05diseases` VALUES ('8744', '系统性血管炎', '415', 'I77.607', 'XTXXGY', '');
INSERT INTO `05diseases` VALUES ('8745', '下肢动脉炎', '260', 'I77.608', 'XZDMY', '');
INSERT INTO `05diseases` VALUES ('8746', '下肢脉管炎', '220', 'I77.609', 'XZMGY', '');
INSERT INTO `05diseases` VALUES ('8747', '主动脉炎', '477', 'I77.610', 'ZDMY', '');
INSERT INTO `05diseases` VALUES ('8748', '后天性腹主动脉畸形', '477', 'I77.801', 'HTXFZDMJX', '');
INSERT INTO `05diseases` VALUES ('8749', '主动脉根部病变', '477', 'I77.802', 'ZDMGBBB', '');
INSERT INTO `05diseases` VALUES ('8750', '主动脉脓肿', '243', 'I77.803', 'ZDMNZ', '');
INSERT INTO `05diseases` VALUES ('8751', '肾血管炎', '314', 'I77.851', 'SXGY', '');
INSERT INTO `05diseases` VALUES ('8752', '恶性丘疹病[德戈病]', '250', 'I77.852', 'EXQZBDGB', '');
INSERT INTO `05diseases` VALUES ('8753', '肾动脉增生', '260', 'I77.853', 'SDMZS', '');
INSERT INTO `05diseases` VALUES ('8754', '动脉疾患 NOS', '260', 'I77.951', 'DMJH', '');
INSERT INTO `05diseases` VALUES ('8755', '遗传性出血性毛细管扩张[朗迪－奥斯勒－韦伯病]', '38', 'I78.001', 'YCXCXXMXGKZLDASLWBB', '');
INSERT INTO `05diseases` VALUES ('8756', '星状痣', '470', 'I78.151', 'XZZ', '');
INSERT INTO `05diseases` VALUES ('8757', '蜘蛛状痣', '470', 'I78.152', 'ZZZZ', '');
INSERT INTO `05diseases` VALUES ('8758', '老年性痣', '470', 'I78.153', 'LNXZ', '');
INSERT INTO `05diseases` VALUES ('8759', '老年性血管瘤', '414', 'I78.154', 'LNXXGL', '');
INSERT INTO `05diseases` VALUES ('8760', '星状的血管瘤', '414', 'I78.155', 'XZDXGL', '');
INSERT INTO `05diseases` VALUES ('8761', '蜘蛛痣血管瘤', '414', 'I78.156', 'ZZZXGL', '');
INSERT INTO `05diseases` VALUES ('8762', '毛细血管扩张症', '413', 'I78.801', 'MXXGKZZ', '');
INSERT INTO `05diseases` VALUES ('8763', '胃肠道毛细血管扩张症', '31', 'I78.802', 'WCDMXXGKZZ', '');
INSERT INTO `05diseases` VALUES ('8764', '毛细血管疾病 NOS', '413', 'I78.951', 'MXXGJB', '');
INSERT INTO `05diseases` VALUES ('8765', '下肢表浅静脉炎', '185', 'I80.001', 'XZBQJMY', '');
INSERT INTO `05diseases` VALUES ('8766', '下肢化脓性浅血栓静脉炎', '185', 'I80.051', 'XZHNXQXSJMY', '');
INSERT INTO `05diseases` VALUES ('8767', '股静脉血栓形成', '419', 'I80.101', 'GJMXSXC', '');
INSERT INTO `05diseases` VALUES ('8768', '髂股静脉血栓形成', '419', 'I80.102', 'QGJMXSXC', '');
INSERT INTO `05diseases` VALUES ('8769', '髂静脉血栓形成', '419', 'I80.201', 'QJMXSXC', '');
INSERT INTO `05diseases` VALUES ('8770', '下肢慢性深静脉炎', '185', 'I80.202', 'XZMXSJMY', '');
INSERT INTO `05diseases` VALUES ('8771', '下肢深静脉炎', '185', 'I80.203', 'XZSJMY', '');
INSERT INTO `05diseases` VALUES ('8772', '下肢深部血栓性静脉炎', '185', 'I80.204', 'XZSBXSXJMY', '');
INSERT INTO `05diseases` VALUES ('8773', '下肢深静脉血栓形成', '419', 'I80.205', 'XZSJMXSXC', '');
INSERT INTO `05diseases` VALUES ('8774', '下肢深静脉栓塞', '184', 'I80.206', 'XZSJMSS', '');
INSERT INTO `05diseases` VALUES ('8775', '下肢化脓性深血管静脉炎', '185', 'I80.251', 'XZHNXSXGJMY', '');
INSERT INTO `05diseases` VALUES ('8776', '下肢静脉血栓形成', '419', 'I80.301', 'XZJMXSXC', '');
INSERT INTO `05diseases` VALUES ('8777', '下肢静脉炎', '185', 'I80.302', 'XZJMY', '');
INSERT INTO `05diseases` VALUES ('8778', '下肢血栓性静脉炎', '185', 'I80.303', 'XZXSXJMY', '');
INSERT INTO `05diseases` VALUES ('8779', '下肢化脓性血管静脉炎', '185', 'I80.351', 'XZHNXXGJMY', '');
INSERT INTO `05diseases` VALUES ('8780', '眶内血栓性静脉炎', '185', 'I80.801', 'KNXSXJMY', '');
INSERT INTO `05diseases` VALUES ('8781', '蒙道尔氏病[胸壁血栓性静脉炎]', '185', 'I80.802', 'MDESBXBXSXJMY', '');
INSERT INTO `05diseases` VALUES ('8782', '乳腺血栓性静脉炎', '185', 'I80.803', 'RXXSXJMY', '');
INSERT INTO `05diseases` VALUES ('8783', '上肢静脉炎', '185', 'I80.804', 'SZJMY', '');
INSERT INTO `05diseases` VALUES ('8784', '上肢血栓性静脉炎', '185', 'I80.805', 'SZXSXJMY', '');
INSERT INTO `05diseases` VALUES ('8785', '肾盂静脉炎', '185', 'I80.851', 'SYJMY', '');
INSERT INTO `05diseases` VALUES ('8786', '肝静脉炎', '185', 'I80.852', 'GJMY', '');
INSERT INTO `05diseases` VALUES ('8787', '胸部皮下大静脉炎', '185', 'I80.853', 'XBPXDJMY', '');
INSERT INTO `05diseases` VALUES ('8788', '静脉炎', '185', 'I80.901', 'JMY', '');
INSERT INTO `05diseases` VALUES ('8789', '血栓性静脉炎', '185', 'I80.902', 'XSXJMY', '');
INSERT INTO `05diseases` VALUES ('8790', '溃疡性静脉炎', '185', 'I80.951', 'KYXJMY', '');
INSERT INTO `05diseases` VALUES ('8791', '静脉周围炎', '181', 'I80.952', 'JMZWY', '');
INSERT INTO `05diseases` VALUES ('8792', '门静脉梗阻', '180', 'I81.X01', 'MJMGZ', '');
INSERT INTO `05diseases` VALUES ('8793', '门静脉血栓形成', '419', 'I81.X02', 'MJMXSXC', '');
INSERT INTO `05diseases` VALUES ('8794', '闭塞性肝静脉内膜炎[巴德－基亚里二氏综合征]', '92', 'I82.001', 'BSXGJMNMYBDJYLESZHZ', '');
INSERT INTO `05diseases` VALUES ('8795', '肝小静脉闭塞', '92', 'I82.002', 'GXJMBS', '');
INSERT INTO `05diseases` VALUES ('8796', '游走性血栓性静脉炎', '185', 'I82.101', 'YZXXSXJMY', '');
INSERT INTO `05diseases` VALUES ('8797', '腔静脉栓塞', '184', 'I82.201', 'QJMSS', '');
INSERT INTO `05diseases` VALUES ('8798', '下腔静脉栓塞', '184', 'I82.202', 'XQJMSS', '');
INSERT INTO `05diseases` VALUES ('8799', '肾静脉栓塞', '314', 'I82.301', 'SJMSS', '');
INSERT INTO `05diseases` VALUES ('8800', '颈静脉血栓形成', '419', 'I82.801', 'GJMXSXC', '');
INSERT INTO `05diseases` VALUES ('8801', '脾静脉栓塞', '253', 'I82.802', 'PJMSS', '');
INSERT INTO `05diseases` VALUES ('8802', '髂静脉栓塞', '184', 'I82.803', 'QJMSS', '');
INSERT INTO `05diseases` VALUES ('8803', '髂内静脉栓塞', '184', 'I82.804', 'QNJMSS', '');
INSERT INTO `05diseases` VALUES ('8804', '髂外静脉栓塞', '184', 'I82.805', 'QWJMSS', '');
INSERT INTO `05diseases` VALUES ('8805', '上肢静脉血栓形成', '419', 'I82.806', 'SZJMXSXC', '');
INSERT INTO `05diseases` VALUES ('8806', '上肢深静脉血栓形成', '419', 'I82.807', 'SZSJMXSXC', '');
INSERT INTO `05diseases` VALUES ('8807', '锁骨下静脉血栓形成', '344', 'I82.808', 'SGXJMXSXC', '');
INSERT INTO `05diseases` VALUES ('8808', '腋静脉栓塞', '184', 'I82.809', 'YJMSS', '');
INSERT INTO `05diseases` VALUES ('8809', '静脉血栓形成', '419', 'I82.902', 'JMXSXC', '');
INSERT INTO `05diseases` VALUES ('8810', '大隐静脉曲张伴溃疡', '195', 'I83.001', 'DYJMQZBKY', '');
INSERT INTO `05diseases` VALUES ('8811', '下肢静脉曲张伴溃疡', '195', 'I83.002', 'XZJMQZBKY', '');
INSERT INTO `05diseases` VALUES ('8812', '静脉曲张性皮炎', '252', 'I83.101', 'JMQZXPY', '');
INSERT INTO `05diseases` VALUES ('8813', '曲张静脉炎', '185', 'I83.102', 'QZJMY', '');
INSERT INTO `05diseases` VALUES ('8814', '下肢静脉曲张合并静脉炎', '185', 'I83.103', 'XZJMQZHBJMY', '');
INSERT INTO `05diseases` VALUES ('8815', '淤积性皮炎', '252', 'I83.104', 'YJXPY', '');
INSERT INTO `05diseases` VALUES ('8816', '静脉曲张性溃疡', '195', 'I83.201', 'JMQZXKY', '');
INSERT INTO `05diseases` VALUES ('8817', '下肢静脉曲张伴溃疡及炎症', '195', 'I83.202', 'XZJMQZBKYJYZ', '');
INSERT INTO `05diseases` VALUES ('8818', '大隐静脉曲张', '183', 'I83.901', 'DYJMQZ', '');
INSERT INTO `05diseases` VALUES ('8819', '静脉曲张破裂', '183', 'I83.902', 'JMQZPL', '');
INSERT INTO `05diseases` VALUES ('8820', '静脉曲张', '183', 'I83.903', 'JMQZ', '');
INSERT INTO `05diseases` VALUES ('8821', '静脉曲张综合征', '183', 'I83.904', 'JMQZZHZ', '');
INSERT INTO `05diseases` VALUES ('8822', '下肢静脉瘤', '182', 'I83.905', 'XZJML', '');
INSERT INTO `05diseases` VALUES ('8823', '小隐静脉曲张', '183', 'I83.906', 'XYJMQZ', '');
INSERT INTO `05diseases` VALUES ('8824', '下肢静脉曲张', '183', 'I83.951', 'XZJMQZ', '');
INSERT INTO `05diseases` VALUES ('8825', '血栓性内痔', '419', 'I84.001', 'XSXNZ', '');
INSERT INTO `05diseases` VALUES ('8826', '出血性内痔', '38', 'I84.101', 'CXXNZ', '');
INSERT INTO `05diseases` VALUES ('8827', '混合痔伴有并发症', '278', 'I84.102', 'HHZBYBFZ', '');
INSERT INTO `05diseases` VALUES ('8828', '绞窄性内痔', '278', 'I84.151', 'JZXNZ', '');
INSERT INTO `05diseases` VALUES ('8829', '溃疡性内痔', '195', 'I84.152', 'KYXNZ', '');
INSERT INTO `05diseases` VALUES ('8830', '脱垂性内痔', '278', 'I84.153', 'TCXNZ', '');
INSERT INTO `05diseases` VALUES ('8831', '内痔伴并发症', '278', 'I84.154', 'NZBBFZ', '');
INSERT INTO `05diseases` VALUES ('8832', '直肠静脉曲张破裂', '468', 'I84.201', 'ZCJMQZPL', '');
INSERT INTO `05diseases` VALUES ('8833', '内痔', '278', 'I84.202', 'NZ', '');
INSERT INTO `05diseases` VALUES ('8834', '血栓性外痔', '419', 'I84.301', 'XSXWZ', '');
INSERT INTO `05diseases` VALUES ('8835', '出血性外痔', '38', 'I84.401', 'CXXWZ', '');
INSERT INTO `05diseases` VALUES ('8836', '绞窄性外痔', '278', 'I84.451', 'JZXWZ', '');
INSERT INTO `05diseases` VALUES ('8837', '溃疡性外痔', '195', 'I84.452', 'KYXWZ', '');
INSERT INTO `05diseases` VALUES ('8838', '脱垂性外痔', '278', 'I84.453', 'TCXWZ', '');
INSERT INTO `05diseases` VALUES ('8839', '外痔', '278', 'I84.501', 'WZ', '');
INSERT INTO `05diseases` VALUES ('8840', '直肠赘', '468', 'I84.601', 'ZCZ', '');
INSERT INTO `05diseases` VALUES ('8841', '肛门皮赘', '96', 'I84.651', 'GMPZ', '');
INSERT INTO `05diseases` VALUES ('8842', '血栓性痔', '419', 'I84.751', 'XSXZ', '');
INSERT INTO `05diseases` VALUES ('8843', '出血性痔', '38', 'I84.851', 'CXXZ', '');
INSERT INTO `05diseases` VALUES ('8844', '绞窄性痔', '278', 'I84.852', 'JZXZ', '');
INSERT INTO `05diseases` VALUES ('8845', '溃疡性痔', '195', 'I84.853', 'KYXZ', '');
INSERT INTO `05diseases` VALUES ('8846', '脱垂性痔', '278', 'I84.854', 'TCXZ', '');
INSERT INTO `05diseases` VALUES ('8847', '痔 NOS', '278', 'I84.901', 'Z', '');
INSERT INTO `05diseases` VALUES ('8848', '食管静脉曲张破裂出血', '38', 'I85.001', 'SGJMQZPLCX', '');
INSERT INTO `05diseases` VALUES ('8849', '食管静脉曲张', '323', 'I85.901', 'SGJMQZ', '');
INSERT INTO `05diseases` VALUES ('8850', '舌下静脉曲张', '183', 'I86.051', 'SXJMQZ', '');
INSERT INTO `05diseases` VALUES ('8851', '精索静脉曲张', '183', 'I86.101', 'JSJMQZ', '');
INSERT INTO `05diseases` VALUES ('8852', '阴囊静脉曲张', '183', 'I86.102', 'YNJMQZ', '');
INSERT INTO `05diseases` VALUES ('8853', '膀胱静脉曲张', '183', 'I86.201', 'BGJMQZ', '');
INSERT INTO `05diseases` VALUES ('8854', '盆腔静脉曲张', '183', 'I86.202', 'PQJMQZ', '');
INSERT INTO `05diseases` VALUES ('8855', '卵巢静脉缩综合征', '86', 'I86.251', 'LCJMSZHZ', '');
INSERT INTO `05diseases` VALUES ('8856', '骨盆静脉曲张', '183', 'I86.252', 'GPJMQZ', '');
INSERT INTO `05diseases` VALUES ('8857', '外阴静脉曲张', '367', 'I86.301', 'WYJMQZ', '');
INSERT INTO `05diseases` VALUES ('8858', '胃底静脉曲张', '370', 'I86.401', 'WDJMQZ', '');
INSERT INTO `05diseases` VALUES ('8859', '胃血管扩张', '370', 'I86.402', 'WXGKZ', '');
INSERT INTO `05diseases` VALUES ('8860', '肝静脉静脉瘤', '92', 'I86.801', 'GJMJML', '');
INSERT INTO `05diseases` VALUES ('8861', '颈静脉扩张', '181', 'I86.802', 'GJMKZ', '');
INSERT INTO `05diseases` VALUES ('8862', '颈内静脉扩张', '181', 'I86.803', 'GNJMKZ', '');
INSERT INTO `05diseases` VALUES ('8863', '颈外静脉静脉瘤', '182', 'I86.804', 'GWJMJML', '');
INSERT INTO `05diseases` VALUES ('8864', '颈外静脉扩张', '181', 'I86.805', 'GWJMKZ', '');
INSERT INTO `05diseases` VALUES ('8865', '颈总静脉瘤', '182', 'I86.806', 'GZJML', '');
INSERT INTO `05diseases` VALUES ('8866', '眶静脉曲张', '183', 'I86.807', 'KJMQZ', '');
INSERT INTO `05diseases` VALUES ('8867', '颞静脉静脉瘤', '182', 'I86.808', 'NJMJML', '');
INSERT INTO `05diseases` VALUES ('8868', '腹壁静脉曲张', '183', 'I86.851', 'FBJMQZ', '');
INSERT INTO `05diseases` VALUES ('8869', '门静脉血栓形成、食道、胃静脉曲张破裂', '370', 'I86.852', 'MJMXSXCSDWJMQZPL', '');
INSERT INTO `05diseases` VALUES ('8870', '上肢静脉曲张', '183', 'I86.853', 'SZJMQZ', '');
INSERT INTO `05diseases` VALUES ('8871', '鼻中隔静脉曲张溃疡', '16', 'I86.854', 'BZGJMQZKY', '');
INSERT INTO `05diseases` VALUES ('8872', '静脉炎后综合征', '185', 'I87.001', 'JMYHZHZ', '');
INSERT INTO `05diseases` VALUES ('8873', '肝静脉-下腔静脉阻塞', '92', 'I87.101', 'GJMXQJMZS', '');
INSERT INTO `05diseases` VALUES ('8874', '髂总静脉狭窄', '181', 'I87.102', 'QZJMXZ', '');
INSERT INTO `05diseases` VALUES ('8875', '腔静脉阻塞综合征', '186', 'I87.103', 'QJMZSZHZ', '');
INSERT INTO `05diseases` VALUES ('8876', '上腔静脉梗阻', '180', 'I87.104', 'SQJMGZ', '');
INSERT INTO `05diseases` VALUES ('8877', '上腔静脉阻塞综合征', '186', 'I87.105', 'SQJMZSZHZ', '');
INSERT INTO `05diseases` VALUES ('8878', '上下腔静脉回流障碍综合征', '181', 'I87.106', 'SXQJMHLZAZHZ', '');
INSERT INTO `05diseases` VALUES ('8879', '上肢静脉阻塞', '186', 'I87.107', 'SZJMZS', '');
INSERT INTO `05diseases` VALUES ('8880', '锁骨下静脉压迫综合症', '344', 'I87.108', 'SGXJMYPZHZ', '');
INSERT INTO `05diseases` VALUES ('8881', '无名静脉阻塞', '186', 'I87.109', 'WMJMZS', '');
INSERT INTO `05diseases` VALUES ('8882', '下腔静脉梗阻', '180', 'I87.110', 'XQJMGZ', '');
INSERT INTO `05diseases` VALUES ('8883', '下腔静脉狭窄', '181', 'I87.111', 'XQJMXZ', '');
INSERT INTO `05diseases` VALUES ('8884', '下腔静脉阻塞综合征', '186', 'I87.112', 'XQJMZSZHZ', '');
INSERT INTO `05diseases` VALUES ('8885', '下腔静脉阻塞', '186', 'I87.113', 'XQJMZS', '');
INSERT INTO `05diseases` VALUES ('8886', '下肢静脉梗阻', '180', 'I87.114', 'XZJMGZ', '');
INSERT INTO `05diseases` VALUES ('8887', '静脉狭窄', '181', 'I87.151', 'JMXZ', '');
INSERT INTO `05diseases` VALUES ('8888', '海绵窦压迫综合征', '278', 'I87.152', 'HMDYPZHZ', '');
INSERT INTO `05diseases` VALUES ('8889', '下肢静脉功能不全', '382', 'I87.201', 'XZJMGNBQ', '');
INSERT INTO `05diseases` VALUES ('8890', '上肢静脉瓣功能不全', '308', 'I87.251', 'SZJMBGNBQ', '');
INSERT INTO `05diseases` VALUES ('8891', '假静脉瘤', '182', 'I87.801', 'JJML', '');
INSERT INTO `05diseases` VALUES ('8892', '静脉石', '181', 'I87.802', 'JMS', '');
INSERT INTO `05diseases` VALUES ('8893', '静脉硬化', '181', 'I87.803', 'JMYH', '');
INSERT INTO `05diseases` VALUES ('8894', '下肢静脉回流障碍', '382', 'I87.804', 'XZJMHLZA', '');
INSERT INTO `05diseases` VALUES ('8895', '静脉破裂', '181', 'I87.851', 'JMPL', '');
INSERT INTO `05diseases` VALUES ('8896', '阴茎静脉纤维化', '230', 'I87.852', 'YJJMXWH', '');
INSERT INTO `05diseases` VALUES ('8897', '上肢静脉回流障碍', '308', 'I87.951', 'SZJMHLZA', '');
INSERT INTO `05diseases` VALUES ('8898', '肠系膜淋巴结炎', '207', 'I88.001', 'CXMLBJY', '');
INSERT INTO `05diseases` VALUES ('8899', '颌下慢性淋巴结炎', '207', 'I88.101', 'HXMXLBJY', '');
INSERT INTO `05diseases` VALUES ('8900', '颏下慢性淋巴结炎', '207', 'I88.102', 'KXMXLBJY', '');
INSERT INTO `05diseases` VALUES ('8901', '慢性腹股沟淋巴结炎', '207', 'I88.103', 'MXFGGLBJY', '');
INSERT INTO `05diseases` VALUES ('8902', '慢性颈淋巴结炎', '207', 'I88.104', 'MXGLBJY', '');
INSERT INTO `05diseases` VALUES ('8903', '慢性淋巴结炎', '207', 'I88.105', 'MXLBJY', '');
INSERT INTO `05diseases` VALUES ('8904', '慢性腮腺淋巴结炎', '207', 'I88.106', 'MXSXLBJY', '');
INSERT INTO `05diseases` VALUES ('8905', '亚急性颈淋巴结炎', '207', 'I88.151', 'YJXGLBJY', '');
INSERT INTO `05diseases` VALUES ('8906', '支气管淋巴结炎', '279', 'I88.851', 'ZQGLBJY', '');
INSERT INTO `05diseases` VALUES ('8907', '反应性淋巴结炎', '207', 'I88.901', 'FYXLBJY', '');
INSERT INTO `05diseases` VALUES ('8908', '肺门淋巴结炎', '79', 'I88.902', 'FMLBJY', '');
INSERT INTO `05diseases` VALUES ('8909', '腹股沟淋巴结炎', '207', 'I88.903', 'FGGLBJY', '');
INSERT INTO `05diseases` VALUES ('8910', '颌下淋巴结炎', '207', 'I88.904', 'HXLBJY', '');
INSERT INTO `05diseases` VALUES ('8911', '颈淋巴结炎', '207', 'I88.905', 'GLBJY', '');
INSERT INTO `05diseases` VALUES ('8912', '淋巴结炎', '207', 'I88.906', 'LBJY', '');
INSERT INTO `05diseases` VALUES ('8913', '腮腺肉芽肿性淋巴结炎', '207', 'I88.907', 'SXRYZXLBJY', '');
INSERT INTO `05diseases` VALUES ('8914', '纵隔淋巴结炎', '207', 'I88.908', 'ZGLBJY', '');
INSERT INTO `05diseases` VALUES ('8915', '肠淋巴管扩张', '259', 'I89.001', 'CLBGKZ', '');
INSERT INTO `05diseases` VALUES ('8916', '非丝虫性象皮病', '268', 'I89.002', 'FSCXXPB', '');
INSERT INTO `05diseases` VALUES ('8917', '淋巴管闭塞', '202', 'I89.003', 'LBGBS', '');
INSERT INTO `05diseases` VALUES ('8918', '淋巴水肿', '337', 'I89.004', 'LBSZ', '');
INSERT INTO `05diseases` VALUES ('8919', '象皮病', '268', 'I89.005', 'XPB', '');
INSERT INTO `05diseases` VALUES ('8920', '胸导管梗阻', '274', 'I89.006', 'XDGGZ', '');
INSERT INTO `05diseases` VALUES ('8921', '淋巴管炎', '204', 'I89.101', 'LBGY', '');
INSERT INTO `05diseases` VALUES ('8922', '肠系膜乳糜囊肿', '231', 'I89.801', 'CXMRMNZ', '');
INSERT INTO `05diseases` VALUES ('8923', '非丝虫性乳糜胸', '274', 'I89.802', 'FSCXRMX', '');
INSERT INTO `05diseases` VALUES ('8924', '淋巴管瘘', '212', 'I89.803', 'LBGL', '');
INSERT INTO `05diseases` VALUES ('8925', '淋巴回流障碍', '205', 'I89.804', 'LBHLZA', '');
INSERT INTO `05diseases` VALUES ('8926', '淋巴结钙化', '205', 'I89.805', 'LBJGH', '');
INSERT INTO `05diseases` VALUES ('8927', '乳糜性腹水', '264', 'I89.806', 'RMXFS', '');
INSERT INTO `05diseases` VALUES ('8928', '乳糜性胸水', '274', 'I89.807', 'RMXXS', '');
INSERT INTO `05diseases` VALUES ('8929', '乳糜胸', '274', 'I89.808', 'RMX', '');
INSERT INTO `05diseases` VALUES ('8930', '胸导管断裂', '274', 'I89.809', 'XDGDL', '');
INSERT INTO `05diseases` VALUES ('8931', '非丝虫性乳糜腹水', '264', 'I89.851', 'FSCXRMFS', '');
INSERT INTO `05diseases` VALUES ('8932', '睾丸鞘膜(非丝虫性)乳糜囊肿', '230', 'I89.852', 'GWQMFSCXRMNZ', '');
INSERT INTO `05diseases` VALUES ('8933', '支气管淋巴结硬化', '279', 'I89.853', 'ZQGLBJYH', '');
INSERT INTO `05diseases` VALUES ('8934', '淋巴系统疾病', '268', 'I89.951', 'LBXTJB', '');
INSERT INTO `05diseases` VALUES ('8935', '特发性低血压', '99', 'I95.051', 'TFXDXY', '');
INSERT INTO `05diseases` VALUES ('8936', '体位性低血压', '99', 'I95.101', 'TWXDXY', '');
INSERT INTO `05diseases` VALUES ('8937', '原发性直立性低血压', '99', 'I95.151', 'YFXZLXDXY', '');
INSERT INTO `05diseases` VALUES ('8938', '药物性低血压', '99', 'I95.251', 'YWXDXY', '');
INSERT INTO `05diseases` VALUES ('8939', '慢性低血压', '99', 'I95.851', 'MXDXY', '');
INSERT INTO `05diseases` VALUES ('8940', '低血压 NOS', '99', 'I95.901', 'DXY', '');
INSERT INTO `05diseases` VALUES ('8941', '血压下降', '99', 'I95.902', 'XYXJ', '');
INSERT INTO `05diseases` VALUES ('8942', '心包切开术后综合征', '330', 'I97.001', 'XBQKSHZHZ', '');
INSERT INTO `05diseases` VALUES ('8943', '心脏术后低心排综合征', '403', 'I97.002', 'XZSHDXPZHZ', '');
INSERT INTO `05diseases` VALUES ('8944', '心脏术后综合征', '403', 'I97.003', 'XZSHZHZ', '');
INSERT INTO `05diseases` VALUES ('8945', '瓣膜切开术后综合征', '330', 'I97.051', 'BMQKSHZHZ', '');
INSERT INTO `05diseases` VALUES ('8946', '瓣膜置换术后心脏瓣膜衰竭', '403', 'I97.101', 'BMZHSHXZBMSJ', '');
INSERT INTO `05diseases` VALUES ('8947', '机械瓣置换术后瓣周漏', '330', 'I97.102', 'JXBZHSHBZL', '');
INSERT INTO `05diseases` VALUES ('8948', '生物瓣膜失功能', '278', 'I97.103', 'SWBMSGN', '');
INSERT INTO `05diseases` VALUES ('8949', '手术后心力衰竭伴肺水肿', '79', 'I97.104', 'SSHXLSJBFSZ', '');
INSERT INTO `05diseases` VALUES ('8950', '心脏手术后功能障碍', '403', 'I97.105', 'XZSSHGNZA', '');
INSERT INTO `05diseases` VALUES ('8951', '心脏手术后心力衰竭', '403', 'I97.106', 'XZSSHXLSJ', '');
INSERT INTO `05diseases` VALUES ('8952', '起博器综合征', '278', 'I97.151', 'QBQZHZ', '');
INSERT INTO `05diseases` VALUES ('8953', '乳房切除术后淋巴水肿综合征', '86', 'I97.251', 'RFQCSHLBSZZHZ', '');
INSERT INTO `05diseases` VALUES ('8954', '动脉导管结扎术后复通', '260', 'I97.801', 'DMDGJZSHFT', '');
INSERT INTO `05diseases` VALUES ('8955', '经皮导管治疗动脉导管未闭术后残余分流', '260', 'I97.802', 'JPDGZLDMDGWBSHCYFL', '');
INSERT INTO `05diseases` VALUES ('8956', '脑血管造影后脑血管痉挛', '233', 'I97.803', 'NXGZYHNXGJL', '');
INSERT INTO `05diseases` VALUES ('8957', '上肢动脉穿刺后痉挛', '260', 'I97.804', 'SZDMCCHJL', '');
INSERT INTO `05diseases` VALUES ('8958', '室缺残余漏', '278', 'I97.805', 'SQCYL', '');
INSERT INTO `05diseases` VALUES ('8959', '手术后腹主动脉阻塞', '477', 'I97.806', 'SSHFZDMZS', '');
INSERT INTO `05diseases` VALUES ('8960', '手术后淋巴水肿', '330', 'I97.807', 'SSHLBSZ', '');
INSERT INTO `05diseases` VALUES ('8961', '其他操作后循环系统疾患，NEC', '424', 'I97.851', 'QTCZHXHXTJH', '');
INSERT INTO `05diseases` VALUES ('8962', '冠状动脉搭桥术后', '125', 'I97.901', 'GZDMDQSH', '');
INSERT INTO `05diseases` VALUES ('8963', '经皮动脉导管矫治术后并发症', '260', 'I97.902', 'JPDMDGJZSHBFZ', '');
INSERT INTO `05diseases` VALUES ('8964', '经皮房缺.室缺矫治术后并发症', '330', 'I97.903', 'JPFQSQJZSHBFZ', '');
INSERT INTO `05diseases` VALUES ('8965', '经皮冠状动脉狭窄矫治术后并发症', '125', 'I97.904', 'JPGZDMXZJZSHBFZ', '');
INSERT INTO `05diseases` VALUES ('8966', '经皮球囊扩瓣术后并发症', '330', 'I97.905', 'JPQNKBSHBFZ', '');
INSERT INTO `05diseases` VALUES ('8967', '经皮射频消融术后并发症', '330', 'I97.906', 'JPSPXRSHBFZ', '');
INSERT INTO `05diseases` VALUES ('8968', '射频消融术后', '330', 'I97.907', 'SPXRSH', '');
INSERT INTO `05diseases` VALUES ('8969', '心导管检查术后', '330', 'I97.908', 'XDGJCSH', '');
INSERT INTO `05diseases` VALUES ('8970', '心导管造影术后并发症', '460', 'I97.909', 'XDGZYSHBFZ', '');
INSERT INTO `05diseases` VALUES ('8971', '心导管治疗术后', '330', 'I97.910', 'XDGZLSH', '');
INSERT INTO `05diseases` VALUES ('8972', '心脏瓣膜置换术后', '403', 'I97.911', 'XZBMZHSH', '');
INSERT INTO `05diseases` VALUES ('8973', '心脏术后', '403', 'I97.912', 'XZSH', '');
INSERT INTO `05diseases` VALUES ('8974', '操作后循环系统疾患 NOS', '424', 'I97.951', 'CZHXHXTJH', '');
INSERT INTO `05diseases` VALUES ('8975', '急性循环充血', '275', 'I99.X01', 'JXXHCX', '');
INSERT INTO `05diseases` VALUES ('8976', '心室残留异物', '403', 'I99.X02', 'XSCLYW', '');
INSERT INTO `05diseases` VALUES ('8977', '周围血管并发症', '413', 'I99.X03', 'ZWXGBFZ', '');
INSERT INTO `05diseases` VALUES ('8978', '上肢微循环障碍', '308', 'I99.X51', 'SZWXHZA', '');
INSERT INTO `05diseases` VALUES ('8979', '上肢血管畸形', '148', 'I99.X52', 'SZXGJX', '');
INSERT INTO `05diseases` VALUES ('8980', '后天性肠血管畸形', '148', 'I99.X53', 'HTXCXGJX', '');
INSERT INTO `05diseases` VALUES ('8981', '动脉性充血', '260', 'I99.X54', 'DMXCX', '');
INSERT INTO `05diseases` VALUES ('8982', '空回肠交界处血管扩张', '259', 'I99.X55', 'KHCJJCXGKZ', '');
INSERT INTO `05diseases` VALUES ('8983', '血管扩张', '413', 'I99.X56', 'XGKZ', '');
INSERT INTO `05diseases` VALUES ('8984', '直肠毛细血管扩张症', '468', 'I99.X57', 'ZCMXXGKZZ', '');
INSERT INTO `05diseases` VALUES ('8985', '鼻咽炎', '16', 'J00.X01', 'BYY', '');
INSERT INTO `05diseases` VALUES ('8986', '病毒性感冒', '94', 'J00.X02', 'BDXGM', '');
INSERT INTO `05diseases` VALUES ('8987', '感冒', '94', 'J00.X03', 'GM', '');
INSERT INTO `05diseases` VALUES ('8988', '胃肠型感冒', '370', 'J00.X04', 'WCXGM', '');
INSERT INTO `05diseases` VALUES ('8989', '急性鼻炎', '16', 'J00.X05', 'JXBY', '');
INSERT INTO `05diseases` VALUES ('8990', '脓毒性鼻咽炎', '16', 'J00.X51', 'NDXBYY', '');
INSERT INTO `05diseases` VALUES ('8991', '新生儿急性鼻炎', '16', 'J00.X52', 'XSEJXBY', '');
INSERT INTO `05diseases` VALUES ('8992', '化脓性上颌窦炎', '127', 'J01.001', 'HNXSHDY', '');
INSERT INTO `05diseases` VALUES ('8993', '急性上颌窦炎', '127', 'J01.002', 'JXSHDY', '');
INSERT INTO `05diseases` VALUES ('8994', '急性额窦炎', '277', 'J01.101', 'JXEDY', '');
INSERT INTO `05diseases` VALUES ('8995', '急性筛窦炎', '277', 'J01.201', 'JXSDY', '');
INSERT INTO `05diseases` VALUES ('8996', '急性蝶窦炎', '277', 'J01.301', 'JXDDY', '');
INSERT INTO `05diseases` VALUES ('8997', '急性全鼻窦炎', '16', 'J01.401', 'JXQBDY', '');
INSERT INTO `05diseases` VALUES ('8998', '其他急性鼻窦炎', '16', 'J01.851', 'QTJXBDY', '');
INSERT INTO `05diseases` VALUES ('8999', '急性鼻窦炎', '16', 'J01.901', 'JXBDY', '');
INSERT INTO `05diseases` VALUES ('9000', '急性化脓性鼻窦炎', '16', 'J01.902', 'JXHNXBDY', '');
INSERT INTO `05diseases` VALUES ('9001', '急性鼻窦脓肿', '16', 'J01.951', 'JXBDNZ', '');
INSERT INTO `05diseases` VALUES ('9002', '链球菌性咽峡炎', '428', 'J02.001', 'LQJXYXY', '');
INSERT INTO `05diseases` VALUES ('9003', '链球菌性咽喉痛', '133', 'J02.051', 'LQJXYHT', '');
INSERT INTO `05diseases` VALUES ('9004', '病毒性咽炎', '429', 'J02.851', 'BDXYY', '');
INSERT INTO `05diseases` VALUES ('9005', '化脓性咽炎', '429', 'J02.901', 'HNXYY', '');
INSERT INTO `05diseases` VALUES ('9006', '急性化脓性咽峡炎', '428', 'J02.902', 'JXHNXYXY', '');
INSERT INTO `05diseases` VALUES ('9007', '急性咽炎', '429', 'J02.904', 'JXYY', '');
INSERT INTO `05diseases` VALUES ('9008', '溃疡性咽炎', '429', 'J02.905', 'KYXYY', '');
INSERT INTO `05diseases` VALUES ('9009', '咽喉痛', '133', 'J02.906', 'YHT', '');
INSERT INTO `05diseases` VALUES ('9010', '咽囊炎', '276', 'J02.907', 'YNY', '');
INSERT INTO `05diseases` VALUES ('9011', '咽峡炎', '428', 'J02.908', 'YXY', '');
INSERT INTO `05diseases` VALUES ('9012', '咽炎', '429', 'J02.909', 'YY', '');
INSERT INTO `05diseases` VALUES ('9013', '病毒性咽喉痛', '133', 'J02.951', 'BDXYHT', '');
INSERT INTO `05diseases` VALUES ('9014', '链球菌性扁桃体炎', '18', 'J03.051', 'LQJXBTXY', '');
INSERT INTO `05diseases` VALUES ('9015', '其他特指病原体引起的急性扁桃体炎', '18', 'J03.851', 'QTTZBYTYQDJXBTTY', '');
INSERT INTO `05diseases` VALUES ('9016', '扁桃残体炎', '277', 'J03.901', 'BTCTY', '');
INSERT INTO `05diseases` VALUES ('9017', '扁桃腺炎', '277', 'J03.902', 'BTXY', '');
INSERT INTO `05diseases` VALUES ('9018', '急性扁桃体炎', '18', 'J03.903', 'JXBTTY', '');
INSERT INTO `05diseases` VALUES ('9019', '急性化脓性扁桃腺炎', '277', 'J03.904', 'JXHNXBTXY', '');
INSERT INTO `05diseases` VALUES ('9020', '急性腺样体炎', '386', 'J03.905', 'JXXYTY', '');
INSERT INTO `05diseases` VALUES ('9021', '慢性扁桃体炎急性发作', '18', 'J03.906', 'MXBTTYJXFZ', '');
INSERT INTO `05diseases` VALUES ('9022', '渗出性扁桃体炎', '18', 'J03.951', 'SCXBTTY', '');
INSERT INTO `05diseases` VALUES ('9023', '急性增殖腺(体)炎', '277', 'J03.952', 'JXZZXTY', '');
INSERT INTO `05diseases` VALUES ('9024', '感染性喉炎', '133', 'J04.001', 'GRXHY', '');
INSERT INTO `05diseases` VALUES ('9025', '喉炎', '133', 'J04.002', 'HY', '');
INSERT INTO `05diseases` VALUES ('9026', '化脓性喉炎', '133', 'J04.003', 'HNXHY', '');
INSERT INTO `05diseases` VALUES ('9027', '急性喉炎', '133', 'J04.004', 'JXHY', '');
INSERT INTO `05diseases` VALUES ('9028', '链球菌性喉炎', '133', 'J04.005', 'LQJXHY', '');
INSERT INTO `05diseases` VALUES ('9029', '水肿性喉炎', '133', 'J04.006', 'SZXHY', '');
INSERT INTO `05diseases` VALUES ('9030', '溃疡性喉炎', '133', 'J04.051', 'KYXHY', '');
INSERT INTO `05diseases` VALUES ('9031', '脓毒性喉炎', '133', 'J04.052', 'NDXHY', '');
INSERT INTO `05diseases` VALUES ('9032', '急性气管炎', '283', 'J04.101', 'JXQGY', '');
INSERT INTO `05diseases` VALUES ('9033', '气管炎', '283', 'J04.102', 'QGY', '');
INSERT INTO `05diseases` VALUES ('9034', '新生儿气管炎', '283', 'J04.103', 'XSEQGY', '');
INSERT INTO `05diseases` VALUES ('9035', '急性喘息性气管炎', '283', 'J04.151', 'JXCXXQGY', '');
INSERT INTO `05diseases` VALUES ('9036', '急性喉气管炎', '133', 'J04.201', 'JXHQGY', '');
INSERT INTO `05diseases` VALUES ('9037', '哮吼[格鲁布]', '278', 'J05.001', 'XHGLB', '');
INSERT INTO `05diseases` VALUES ('9038', '急性喉炎伴喉梗阻', '133', 'J05.051', 'JXHYBHGZ', '');
INSERT INTO `05diseases` VALUES ('9039', '会厌脓肿', '243', 'J05.101', 'HYNZ', '');
INSERT INTO `05diseases` VALUES ('9040', '急性会厌炎', '277', 'J05.102', 'JXHYY', '');
INSERT INTO `05diseases` VALUES ('9041', '急性咽喉炎', '133', 'J06.001', 'JXYHY', '');
INSERT INTO `05diseases` VALUES ('9042', '急性咽峡炎', '428', 'J06.002', 'JXYXY', '');
INSERT INTO `05diseases` VALUES ('9043', '咽下部炎', '276', 'J06.051', 'YXBY', '');
INSERT INTO `05diseases` VALUES ('9044', '急性咽气管炎', '283', 'J06.801', 'JXYQGY', '');
INSERT INTO `05diseases` VALUES ('9045', '扁桃体咽炎', '429', 'J06.851', 'BTTYY', '');
INSERT INTO `05diseases` VALUES ('9046', '病毒性上呼吸道感染', '95', 'J06.901', 'BDXSHXDGR', '');
INSERT INTO `05diseases` VALUES ('9047', '上呼吸道感染', '95', 'J06.903', 'SHXDGR', '');
INSERT INTO `05diseases` VALUES ('9048', '新生儿上呼吸道感染', '95', 'J06.904', 'XSESHXDGR', '');
INSERT INTO `05diseases` VALUES ('9049', '流行性感冒伴肺炎，流行性感冒病毒被标明', '81', 'J10.051', 'LXXGMBFYLXXGMBDBBM', '');
INSERT INTO `05diseases` VALUES ('9050', '流行性感冒性咽炎', '429', 'J10.151', 'LXXGMXYY', '');
INSERT INTO `05diseases` VALUES ('9051', '流行性感冒伴胃肠炎，流行性感冒病毒被标明', '33', 'J10.851', 'LXXGMBWCYLXXGMBDBBM', '');
INSERT INTO `05diseases` VALUES ('9052', '流行性感冒伴心肌炎，流行性感冒病毒被标明', '397', 'J10.852+', 'LXXGMBXJYLXXGMBDBBM', '');
INSERT INTO `05diseases` VALUES ('9053', '病毒性肺炎伴流感', '81', 'J11.051', 'BDXFYBLG', '');
INSERT INTO `05diseases` VALUES ('9054', '流行性感冒', '211', 'J11.101', 'LXXGM', '');
INSERT INTO `05diseases` VALUES ('9055', '流行性感冒伴胸膜渗漏，流行性感冒病毒未标明', '211', 'J11.151', 'LXXGMBXMSLLXXGMBDWBM', '');
INSERT INTO `05diseases` VALUES ('9056', '流行性感冒伴咽炎，流行性感冒病毒未标明', '429', 'J11.152', 'LXXGMBYYLXXGMBDWBM', '');
INSERT INTO `05diseases` VALUES ('9057', '流行性感冒伴喉炎，流行性感冒病毒未标明', '133', 'J11.153', 'LXXGMBHYLXXGMBDWBM', '');
INSERT INTO `05diseases` VALUES ('9058', '流行性感冒并发脑炎，流行性感冒病毒未标明', '211', 'J11.851', 'LXXGMBFNYLXXGMBDWBM', '');
INSERT INTO `05diseases` VALUES ('9059', '扁桃体炎伴流感', '18', 'J11.852', 'BTTYBLG', '');
INSERT INTO `05diseases` VALUES ('9060', '流感性心肌炎，流行性感冒病毒未标明', '397', 'J11.853+', 'LGXXJYLXXGMBDWBM', '');
INSERT INTO `05diseases` VALUES ('9061', '腺病毒性肺炎', '81', 'J12.051', 'XBDXFY', '');
INSERT INTO `05diseases` VALUES ('9062', '呼吸道合胞病毒肺炎', '81', 'J12.151', 'HXDHBBDFY', '');
INSERT INTO `05diseases` VALUES ('9063', '副流行性感冒肺炎', '81', 'J12.251', 'FLXXGMFY', '');
INSERT INTO `05diseases` VALUES ('9064', '其他病毒性肺炎', '81', 'J12.851', 'QTBDXFY', '');
INSERT INTO `05diseases` VALUES ('9065', '病毒性肺炎', '81', 'J12.901', 'BDXFY', '');
INSERT INTO `05diseases` VALUES ('9066', '肺炎链球菌性肺炎', '81', 'J13.X01', 'FYLQJXFY', '');
INSERT INTO `05diseases` VALUES ('9067', '肺炎球菌性肺炎', '81', 'J13.X02', 'FYQJXFY', '');
INSERT INTO `05diseases` VALUES ('9068', '肺炎链球菌性引起的支气管肺炎', '81', 'J13.X51', 'FYLQJXYQDZQGFY', '');
INSERT INTO `05diseases` VALUES ('9069', '流感嗜血杆菌性肺炎', '81', 'J14.X01', 'LGSXGJXFY', '');
INSERT INTO `05diseases` VALUES ('9070', '克雷白氏杆菌性肺炎', '81', 'J15.001', 'KLBSGJXFY', '');
INSERT INTO `05diseases` VALUES ('9071', '假单胞菌性肺炎(绿脓杆菌性肺炎)', '81', 'J15.101', 'JDBJXFYLNGJXFY', '');
INSERT INTO `05diseases` VALUES ('9072', '葡萄球菌性肺炎', '81', 'J15.201', 'PTQJXFY', '');
INSERT INTO `05diseases` VALUES ('9073', 'Ｂ族链球菌引起的肺炎', '81', 'J15.351', 'ZLQJYQDFY', '');
INSERT INTO `05diseases` VALUES ('9074', '链球菌性肺炎', '81', 'J15.401', 'LQJXFY', '');
INSERT INTO `05diseases` VALUES ('9075', '大肠杆菌性肺炎', '81', 'J15.501', 'DCGJXFY', '');
INSERT INTO `05diseases` VALUES ('9076', '变形杆菌性肺炎', '81', 'J15.601', 'BXGJXFY', '');
INSERT INTO `05diseases` VALUES ('9077', '非典型性肺炎', '81', 'J15.701', 'FDXXFY', '');
INSERT INTO `05diseases` VALUES ('9078', '支原体性肺炎', '81', 'J15.702', 'ZYTXFY', '');
INSERT INTO `05diseases` VALUES ('9079', '产气杆菌性肺炎', '81', 'J15.801', 'CQGJXFY', '');
INSERT INTO `05diseases` VALUES ('9080', '绿脓杆菌性肺炎', '81', 'J15.802', 'LNGJXFY', '');
INSERT INTO `05diseases` VALUES ('9081', '霉菌性肺炎', '81', 'J15.803', 'MJXFY', '');
INSERT INTO `05diseases` VALUES ('9082', '其他特指的细菌性肺炎', '81', 'J15.804', 'QTTZDXJXFY', '');
INSERT INTO `05diseases` VALUES ('9083', '洛菲不动杆菌性肺炎', '81', 'J15.851', 'LFBDGJXFY', '');
INSERT INTO `05diseases` VALUES ('9084', '厌氧菌性肺炎', '81', 'J15.852', 'YYJXFY', '');
INSERT INTO `05diseases` VALUES ('9085', '细菌性肺炎', '81', 'J15.901', 'XJXFY', '');
INSERT INTO `05diseases` VALUES ('9086', '细菌性支气管肺炎', '81', 'J15.902', 'XJXZQGFY', '');
INSERT INTO `05diseases` VALUES ('9087', '衣原体性肺炎', '81', 'J16.051', 'YYTXFY', '');
INSERT INTO `05diseases` VALUES ('9088', '立克次氏体性肺炎', '81', 'J16.851', 'LKCSTXFY', '');
INSERT INTO `05diseases` VALUES ('9089', '喘息性支气管肺炎', '81', 'J18.001', 'CXXZQGFY', '');
INSERT INTO `05diseases` VALUES ('9090', '毛细管支气管性肺炎', '81', 'J18.002', 'MXGZQGXFY', '');
INSERT INTO `05diseases` VALUES ('9091', '支气管肺炎(小叶性肺炎 )', '81', 'J18.003', 'ZQGFYXYXFY', '');
INSERT INTO `05diseases` VALUES ('9092', '哮喘性支气管肺炎', '81', 'J18.004', 'XCXZQGFY', '');
INSERT INTO `05diseases` VALUES ('9093', '新生儿支气管肺炎', '81', 'J18.005', 'XSEZQGFY', '');
INSERT INTO `05diseases` VALUES ('9094', '婴儿喘息性支气管肺炎', '81', 'J18.006', 'YECXXZQGFY', '');
INSERT INTO `05diseases` VALUES ('9095', '婴儿支气管肺炎', '81', 'J18.007', 'YEZQGFY', '');
INSERT INTO `05diseases` VALUES ('9096', '支气管肺炎[小叶性肺炎]', '81', 'J18.008', 'ZQGFYXYXFY', '');
INSERT INTO `05diseases` VALUES ('9097', '弥漫性肺炎', '81', 'J18.051', 'MMXFY', '');
INSERT INTO `05diseases` VALUES ('9098', '支气管肺炎伴心功能不全', '81', 'J18.052', 'ZQGFYBXGNBQ', '');
INSERT INTO `05diseases` VALUES ('9099', '大叶性肺炎', '81', 'J18.101', 'DYXFY', '');
INSERT INTO `05diseases` VALUES ('9100', '胸膜肺炎', '81', 'J18.151', 'XMFY', '');
INSERT INTO `05diseases` VALUES ('9101', '坠积性肺炎', '81', 'J18.201', 'ZJXFY', '');
INSERT INTO `05diseases` VALUES ('9102', '被动性肺炎', '81', 'J18.801', 'BDXFY', '');
INSERT INTO `05diseases` VALUES ('9103', '节段性肺炎', '81', 'J18.802', 'JDXFY', '');
INSERT INTO `05diseases` VALUES ('9104', '局限性肺炎', '81', 'J18.803', 'JXXFY', '');
INSERT INTO `05diseases` VALUES ('9105', '中毒性肺炎', '81', 'J18.804', 'ZDXFY', '');
INSERT INTO `05diseases` VALUES ('9106', '阻塞性肺炎', '81', 'J18.805', 'ZSXFY', '');
INSERT INTO `05diseases` VALUES ('9107', '肺泡性肺炎', '81', 'J18.851', 'FPXFY', '');
INSERT INTO `05diseases` VALUES ('9108', '肺炎', '81', 'J18.901', 'FY', '');
INSERT INTO `05diseases` VALUES ('9109', '肺炎休克', '81', 'J18.902', 'FYXK', '');
INSERT INTO `05diseases` VALUES ('9110', '婴儿肺炎', '81', 'J18.903', 'YEFY', '');
INSERT INTO `05diseases` VALUES ('9111', '迁延性肺炎', '81', 'J18.951', 'QYXFY', '');
INSERT INTO `05diseases` VALUES ('9112', '休克型[中毒性或暴发性]肺炎', '81', 'J18.952', 'XKXZDXHBFXFY', '');
INSERT INTO `05diseases` VALUES ('9113', '重症肺炎', '81', 'J18.953', 'ZZFY', '');
INSERT INTO `05diseases` VALUES ('9114', '空调机(性)肺炎[机化性肺炎]', '81', 'J18.954', 'KDJXFYJHXFY', '');
INSERT INTO `05diseases` VALUES ('9115', '流感嗜血杆菌引起的急性支气管炎', '465', 'J20.151', 'LGSXGJYQDJXZQGY', '');
INSERT INTO `05diseases` VALUES ('9116', '链球菌引起的急性支气管炎', '465', 'J20.251', 'LQJYQDJXZQGY', '');
INSERT INTO `05diseases` VALUES ('9117', '柯萨奇病毒引起的急性支气管炎', '465', 'J20.351', 'KSQBDYQDJXZQGY', '');
INSERT INTO `05diseases` VALUES ('9118', '副流感病毒引起的急性支气管炎', '465', 'J20.451', 'FLGBDYQDJXZQGY', '');
INSERT INTO `05diseases` VALUES ('9119', '呼吸道合胞病毒引起的急性支气管炎', '465', 'J20.551', 'HXDHBBDYQDJXZQGY', '');
INSERT INTO `05diseases` VALUES ('9120', '鼻病毒引起的急性支气管炎', '16', 'J20.651', 'BBDYQDJXZQGY', '');
INSERT INTO `05diseases` VALUES ('9121', '艾柯病毒引起的急性支气管炎', '465', 'J20.751', 'AKBDYQDJXZQGY', '');
INSERT INTO `05diseases` VALUES ('9122', '其他特指病原体引起的急性支气管炎', '465', 'J20.851', 'QTTZBYTYQDJXZQGY', '');
INSERT INTO `05diseases` VALUES ('9123', '新生儿支气管炎', '465', 'J20.901', 'XSEZQGY', '');
INSERT INTO `05diseases` VALUES ('9124', '婴儿支气管炎', '465', 'J20.902', 'YEZQGY', '');
INSERT INTO `05diseases` VALUES ('9125', '急性化脓性支气管炎', '465', 'J20.903', 'JXHNXZQGY', '');
INSERT INTO `05diseases` VALUES ('9126', '急性支气管炎', '465', 'J20.904', 'JXZQGY', '');
INSERT INTO `05diseases` VALUES ('9127', '气管炎伴急性支气管炎', '465', 'J20.951', 'QGYBJXZQGY', '');
INSERT INTO `05diseases` VALUES ('9128', '急性喉、气管、支气管炎', '133', 'J20.952', 'JXHQGZQGY', '');
INSERT INTO `05diseases` VALUES ('9129', '急性喉支气管炎', '133', 'J20.953', 'JXHZQGY', '');
INSERT INTO `05diseases` VALUES ('9130', '支气管炎 NOS(年龄小于15岁的儿童未特指急性或慢性者)', '465', 'J20.954', 'ZQGYNLXYSDETWTZJXHMX', '');
INSERT INTO `05diseases` VALUES ('9131', '呼吸道合胞病毒引起的急性(毛细支气管炎)细支气管炎', '465', 'J21.051', 'HXDHBBDYQDJXMXZQGYXZ', '');
INSERT INTO `05diseases` VALUES ('9132', '其他特指病原引起的急性(毛细支气管炎)细支气管炎', '465', 'J21.851', 'QTTZBYYQDJXMXZQGYXZQ', '');
INSERT INTO `05diseases` VALUES ('9133', '急性喘息性支气管炎', '465', 'J21.901', 'JXCXXZQGY', '');
INSERT INTO `05diseases` VALUES ('9134', '急性毛细支气管炎', '465', 'J21.902', 'JXMXZQGY', '');
INSERT INTO `05diseases` VALUES ('9135', '细支气管炎', '465', 'J21.903', 'XZQGY', '');
INSERT INTO `05diseases` VALUES ('9136', '急性下呼吸道感染', '95', 'J22.X51', 'JXXHXDGR', '');
INSERT INTO `05diseases` VALUES ('9137', '血管舒缩性鼻炎', '16', 'J30.001', 'XGSSXBY', '');
INSERT INTO `05diseases` VALUES ('9138', '血管运动性鼻炎', '16', 'J30.051', 'XGYDXBY', '');
INSERT INTO `05diseases` VALUES ('9139', '花粉症[枯草热；季节性变应性鼻炎]', '16', 'J30.101', 'HFZKCRJJXBYXBY', '');
INSERT INTO `05diseases` VALUES ('9140', '其他季节性变应性鼻炎', '16', 'J30.251', 'QTJJXBYXBY', '');
INSERT INTO `05diseases` VALUES ('9141', '药物性鼻炎', '16', 'J30.301', 'YWXBYXBY', '');
INSERT INTO `05diseases` VALUES ('9142', '全年性变应性鼻炎', '16', 'J30.351', 'QNBYXBY', '');
INSERT INTO `05diseases` VALUES ('9143', '过敏性鼻炎(变应性鼻炎)', '16', 'J30.401', 'GMXBYBYXBY', '');
INSERT INTO `05diseases` VALUES ('9144', '鼻炎', '16', 'J31.001', 'BY', '');
INSERT INTO `05diseases` VALUES ('9145', '肥厚性鼻炎能', '16', 'J31.002', 'FHXBY', '');
INSERT INTO `05diseases` VALUES ('9146', '溃疡性鼻炎', '16', 'J31.003', 'KYXBY', '');
INSERT INTO `05diseases` VALUES ('9147', '慢性鼻炎', '16', 'J31.004', 'MXBY', '');
INSERT INTO `05diseases` VALUES ('9148', '肉芽肿性鼻炎', '16', 'J31.005', 'RYZXBY', '');
INSERT INTO `05diseases` VALUES ('9149', '臭鼻症[萎缩性鼻炎]', '16', 'J31.006', 'CBZWSXBY', '');
INSERT INTO `05diseases` VALUES ('9150', '梗阻性鼻炎', '16', 'J31.051', 'GZXBY', '');
INSERT INTO `05diseases` VALUES ('9151', '慢性鼻咽炎', '16', 'J31.101', 'MXBYY', '');
INSERT INTO `05diseases` VALUES ('9152', '肥大性咽炎', '429', 'J31.201', 'FDXYY', '');
INSERT INTO `05diseases` VALUES ('9153', '慢性咽喉痛', '133', 'J31.202', 'MXYHT', '');
INSERT INTO `05diseases` VALUES ('9154', '慢性咽炎', '429', 'J31.203', 'MXYY', '');
INSERT INTO `05diseases` VALUES ('9155', '萎缩性咽炎', '429', 'J31.204', 'WSXYY', '');
INSERT INTO `05diseases` VALUES ('9156', '慢性化脓性溃疡性喉痛', '133', 'J31.251', 'MXHNXKYXHT', '');
INSERT INTO `05diseases` VALUES ('9157', '滤泡性咽炎', '429', 'J31.252', 'LPXYY', '');
INSERT INTO `05diseases` VALUES ('9158', '慢性上颌窦炎', '127', 'J32.001', 'MXSHDY', '');
INSERT INTO `05diseases` VALUES ('9159', '出血性坏死性上颌窦炎', '38', 'J32.002', 'CXXHSXSHDY', '');
INSERT INTO `05diseases` VALUES ('9160', '坏死性上颌窦炎', '127', 'J32.003', 'HSXSHDY', '');
INSERT INTO `05diseases` VALUES ('9161', '口腔上颌窦瘘', '212', 'J32.004', 'KQSHDL', '');
INSERT INTO `05diseases` VALUES ('9162', '慢性化脓性上颌窦炎', '127', 'J32.005', 'MXHNXSHDY', '');
INSERT INTO `05diseases` VALUES ('9163', '上颌窦瘘', '212', 'J32.006', 'SHDL', '');
INSERT INTO `05diseases` VALUES ('9164', '上颌窦炎', '127', 'J32.007', 'SHDY', '');
INSERT INTO `05diseases` VALUES ('9165', '真菌性上颌窦炎', '464', 'J32.051', 'ZJXSHDY', '');
INSERT INTO `05diseases` VALUES ('9166', '额窦炎', '277', 'J32.101', 'EDY', '');
INSERT INTO `05diseases` VALUES ('9167', '慢性额窦炎', '277', 'J32.102', 'MXEDY', '');
INSERT INTO `05diseases` VALUES ('9168', '额窦脓肿', '243', 'J32.103', 'EDNZ', '');
INSERT INTO `05diseases` VALUES ('9169', '息肉样鼻窦变性', '16', 'J32.151', 'XRYBDBX', '');
INSERT INTO `05diseases` VALUES ('9170', '筛窦炎(慢性)', '277', 'J32.201', 'SDYMX', '');
INSERT INTO `05diseases` VALUES ('9171', '化脓性筛窦炎', '277', 'J32.202', 'HNXSDY', '');
INSERT INTO `05diseases` VALUES ('9172', '慢性蝶窦炎', '277', 'J32.301', 'MXDDY', '');
INSERT INTO `05diseases` VALUES ('9173', '蝶窦脓肿', '243', 'J32.302', 'DDNZ', '');
INSERT INTO `05diseases` VALUES ('9174', '蝶窦肉芽肿', '295', 'J32.303', 'DDRYZ', '');
INSERT INTO `05diseases` VALUES ('9175', '慢性全鼻窦炎', '16', 'J32.401', 'MXQBDY', '');
INSERT INTO `05diseases` VALUES ('9176', '鼻窦炎', '16', 'J32.451', 'BDY', '');
INSERT INTO `05diseases` VALUES ('9177', '真菌性鼻窦炎', '16', 'J32.452', 'ZJXBDY', '');
INSERT INTO `05diseases` VALUES ('9178', '副鼻窦炎', '16', 'J32.453', 'FBDY', '');
INSERT INTO `05diseases` VALUES ('9179', '额筛窦脓肿', '243', 'J32.801', 'ESDNZ', '');
INSERT INTO `05diseases` VALUES ('9180', '多个部位鼻窦炎(不包括全鼻窦炎)', '16', 'J32.851', 'DGBWBDYBBKQBDY', '');
INSERT INTO `05diseases` VALUES ('9181', '化脓性鼻窦炎', '16', 'J32.901', 'HNXBDY', '');
INSERT INTO `05diseases` VALUES ('9182', '慢性鼻窦炎', '16', 'J32.902', 'MXBDY', '');
INSERT INTO `05diseases` VALUES ('9183', '慢性化脓性鼻窦炎', '16', 'J32.903', 'MXHNXBDY', '');
INSERT INTO `05diseases` VALUES ('9184', '鼻窦瘘', '16', 'J32.904', 'BDL', '');
INSERT INTO `05diseases` VALUES ('9185', '鼻窦脓肿', '16', 'J32.905', 'BDNZ', '');
INSERT INTO `05diseases` VALUES ('9186', '鼻窦肉芽肿', '16', 'J32.906', 'BDRYZ', '');
INSERT INTO `05diseases` VALUES ('9187', '慢性化脓性副鼻窦炎', '16', 'J32.908', 'MXHNXFBDY', '');
INSERT INTO `05diseases` VALUES ('9188', '儿童鼻窦炎', '16', 'J32.951', 'ETBDY', '');
INSERT INTO `05diseases` VALUES ('9189', '后鼻孔息肉', '16', 'J33.002', 'HBKXR', '');
INSERT INTO `05diseases` VALUES ('9190', '左侧鼻息肉', '16', 'J33.003', 'ZCBXR', '');
INSERT INTO `05diseases` VALUES ('9191', '鼻腔息肉', '16', 'J33.004', 'BQXR', '');
INSERT INTO `05diseases` VALUES ('9192', '鼻咽息肉', '16', 'J33.051', 'BYXR', '');
INSERT INTO `05diseases` VALUES ('9193', '鼻中隔息肉', '16', 'J33.052', 'BZGXR', '');
INSERT INTO `05diseases` VALUES ('9194', '筛窦炎[沃尔克斯氏综合征]', '277', 'J33.151', 'SDYWEKSSZHZ', '');
INSERT INTO `05diseases` VALUES ('9195', '鼻窦息肉', '16', 'J33.801', 'BDXR', '');
INSERT INTO `05diseases` VALUES ('9196', '鼻甲息肉', '16', 'J33.802', 'BJXR', '');
INSERT INTO `05diseases` VALUES ('9197', '蝶窦息肉', '374', 'J33.803', 'DDXR', '');
INSERT INTO `05diseases` VALUES ('9198', '上颌窦息肉', '374', 'J33.804', 'SHDXR', '');
INSERT INTO `05diseases` VALUES ('9199', '副鼻窦息肉', '16', 'J33.805', 'FBDXR', '');
INSERT INTO `05diseases` VALUES ('9200', '筛窦息肉', '374', 'J33.806', 'SDXR', '');
INSERT INTO `05diseases` VALUES ('9201', '鼻息肉 NOS', '16', 'J33.951', 'BXR', '');
INSERT INTO `05diseases` VALUES ('9202', '出血坏死性鼻息肉', '16', 'J33.952', 'CXHSXBXR', '');
INSERT INTO `05diseases` VALUES ('9203', '鼻部疖', '16', 'J34.001', 'BBJ', '');
INSERT INTO `05diseases` VALUES ('9204', '鼻部脓肿', '16', 'J34.002', 'BBNZ', '');
INSERT INTO `05diseases` VALUES ('9205', '鼻部痈', '16', 'J34.003', 'BBY', '');
INSERT INTO `05diseases` VALUES ('9206', '鼻蜂窝织炎', '16', 'J34.004', 'BFWZY', '');
INSERT INTO `05diseases` VALUES ('9207', '鼻坏死', '16', 'J34.005', 'BHS', '');
INSERT INTO `05diseases` VALUES ('9208', '鼻溃疡', '16', 'J34.006', 'BKY', '');
INSERT INTO `05diseases` VALUES ('9209', '鼻脓肿', '16', 'J34.007', 'BNZ', '');
INSERT INTO `05diseases` VALUES ('9210', '鼻前庭鼻中隔溃疡', '16', 'J34.008', 'BQTBZGKY', '');
INSERT INTO `05diseases` VALUES ('9211', '鼻中隔坏死', '16', 'J34.009', 'BZGHS', '');
INSERT INTO `05diseases` VALUES ('9212', '鼻中隔溃疡', '16', 'J34.010', 'BZGKY', '');
INSERT INTO `05diseases` VALUES ('9213', '鼻中隔脓肿', '16', 'J34.011', 'BZGNZ', '');
INSERT INTO `05diseases` VALUES ('9214', '鼻中隔肉芽肿', '16', 'J34.012', 'BZGRYZ', '');
INSERT INTO `05diseases` VALUES ('9215', '鼻部囊肿', '16', 'J34.101', 'BBNZ', '');
INSERT INTO `05diseases` VALUES ('9216', '鼻窦囊肿', '16', 'J34.102', 'BDNZ', '');
INSERT INTO `05diseases` VALUES ('9217', '鼻前庭囊肿', '16', 'J34.103', 'BQTNZ', '');
INSERT INTO `05diseases` VALUES ('9218', '蝶窦囊肿', '231', 'J34.104', 'DDNZ', '');
INSERT INTO `05diseases` VALUES ('9219', '额窦囊肿', '231', 'J34.105', 'EDNZ', '');
INSERT INTO `05diseases` VALUES ('9220', '筛窦囊肿', '231', 'J34.106', 'SDNZ', '');
INSERT INTO `05diseases` VALUES ('9221', '上颌窦囊肿', '231', 'J34.107', 'SHDNZ', '');
INSERT INTO `05diseases` VALUES ('9222', '鼻中隔偏曲', '16', 'J34.201', 'BZGPQ', '');
INSERT INTO `05diseases` VALUES ('9223', '鼻甲肥大', '16', 'J34.301', 'BJFD', '');
INSERT INTO `05diseases` VALUES ('9224', '鼻部感染', '16', 'J34.801', 'BBGR', '');
INSERT INTO `05diseases` VALUES ('9225', '鼻部瘘管', '16', 'J34.802', 'BBLG', '');
INSERT INTO `05diseases` VALUES ('9226', '鼻部肿物', '16', 'J34.803', 'BBZW', '');
INSERT INTO `05diseases` VALUES ('9227', '鼻肥大', '16', 'J34.804', 'BFD', '');
INSERT INTO `05diseases` VALUES ('9228', '鼻甲粘连', '16', 'J34.805', 'BJNL', '');
INSERT INTO `05diseases` VALUES ('9229', '鼻结石', '16', 'J34.806', 'BJS', '');
INSERT INTO `05diseases` VALUES ('9230', '鼻瘘', '16', 'J34.807', 'BL', '');
INSERT INTO `05diseases` VALUES ('9231', '鼻前庭炎', '16', 'J34.808', 'BQTY', '');
INSERT INTO `05diseases` VALUES ('9232', '后天性鼻孔闭锁[后天性鼻腔闭锁鼻腔闭锁,后天性]', '16', 'J34.809', 'HTXBKBSHTXBQBSBQBSHT', '');
INSERT INTO `05diseases` VALUES ('9233', '鼻腔狭窄', '16', 'J34.810', 'BQXZ', '');
INSERT INTO `05diseases` VALUES ('9234', '鼻腔粘连', '16', 'J34.811', 'BQNL', '');
INSERT INTO `05diseases` VALUES ('9235', '上颌窦肿物', '278', 'J34.812', 'SHDZW', '');
INSERT INTO `05diseases` VALUES ('9236', '筛窦肿物', '278', 'J34.813', 'SDZW', '');
INSERT INTO `05diseases` VALUES ('9237', '鼻腔肿物', '16', 'J34.814', 'BQZW', '');
INSERT INTO `05diseases` VALUES ('9238', '鼻中隔穿孔', '16', 'J34.815', 'BZGCK', '');
INSERT INTO `05diseases` VALUES ('9239', '鼻中膈血肿', '16', 'J34.816', 'BZGXZ', '');
INSERT INTO `05diseases` VALUES ('9240', '蝶窦肿物', '278', 'J34.817', 'DDZW', '');
INSERT INTO `05diseases` VALUES ('9241', '后天性鼻孔狭窄', '16', 'J34.818', 'HTXBKXZ', '');
INSERT INTO `05diseases` VALUES ('9242', '鼻甲囊肿', '16', 'J34.851', 'BJNZ', '');
INSERT INTO `05diseases` VALUES ('9243', '鼻孔闭锁', '16', 'J34.852', 'BKBS', '');
INSERT INTO `05diseases` VALUES ('9244', '鼻前(后)孔狭窄', '16', 'J34.853', 'BQHKXZ', '');
INSERT INTO `05diseases` VALUES ('9245', '鼻咽闭锁', '16', 'J34.854', 'BYBS', '');
INSERT INTO `05diseases` VALUES ('9246', '鼻咽粘连(与鼻甲)(中隔)', '16', 'J34.855', 'BYNLYBJZG', '');
INSERT INTO `05diseases` VALUES ('9247', '鼻中隔骨嵴(刺)', '16', 'J34.856', 'BZGGJC', '');
INSERT INTO `05diseases` VALUES ('9248', '鼻窦结石', '16', 'J34.857', 'BDJS', '');
INSERT INTO `05diseases` VALUES ('9249', '鼻骨肥大', '16', 'J34.858', 'BGFD', '');
INSERT INTO `05diseases` VALUES ('9250', '慢性扁桃体炎', '18', 'J35.001', 'MXBTTY', '');
INSERT INTO `05diseases` VALUES ('9251', '肥大性扁桃体炎', '18', 'J35.051', 'FDXBTTY', '');
INSERT INTO `05diseases` VALUES ('9252', '扁桃体肥大[扁桃体增生]', '17', 'J35.101', 'BTTFDBTTZS', '');
INSERT INTO `05diseases` VALUES ('9253', '腺样体肥大', '386', 'J35.201', 'XYTFD', '');
INSERT INTO `05diseases` VALUES ('9254', '慢性增殖腺(体)炎', '277', 'J35.251', 'MXZZXTY', '');
INSERT INTO `05diseases` VALUES ('9255', '增殖腺肥大', '278', 'J35.252', 'ZZXFD', '');
INSERT INTO `05diseases` VALUES ('9256', '慢性扁桃体炎和腺样体增生', '18', 'J35.301', 'MXBTTYHXYTZS', '');
INSERT INTO `05diseases` VALUES ('9257', '扁桃体肥大伴增殖腺肥大', '17', 'J35.351', 'BTTFDBZZXFD', '');
INSERT INTO `05diseases` VALUES ('9258', '扁桃体残体', '17', 'J35.801', 'BTTCT', '');
INSERT INTO `05diseases` VALUES ('9259', '扁桃体角化症', '17', 'J35.802', 'BTTJHZ', '');
INSERT INTO `05diseases` VALUES ('9260', '扁桃体溃疡', '17', 'J35.803', 'BTTKY', '');
INSERT INTO `05diseases` VALUES ('9261', '扁桃体囊肿', '231', 'J35.804', 'BTTNZ', '');
INSERT INTO `05diseases` VALUES ('9262', '扁桃体息肉', '17', 'J35.805', 'BTTXR', '');
INSERT INTO `05diseases` VALUES ('9263', '扁桃体结石', '17', 'J35.851', 'BTTJS', '');
INSERT INTO `05diseases` VALUES ('9264', '扁桃体肿物', '17', 'J35.901', 'BTTZW', '');
INSERT INTO `05diseases` VALUES ('9265', '扁桃体脓肿', '243', 'J36.X01', 'BTTNZ', '');
INSERT INTO `05diseases` VALUES ('9266', '扁桃体周围脓肿', '243', 'J36.X02', 'BTTZWNZ', '');
INSERT INTO `05diseases` VALUES ('9267', '扁桃体周围炎', '17', 'J36.X03', 'BTTZWY', '');
INSERT INTO `05diseases` VALUES ('9268', '扁桃体周围蜂窝组织炎', '17', 'J36.X51', 'BTTZWFWZZY', '');
INSERT INTO `05diseases` VALUES ('9269', '慢性喉咽炎', '133', 'J37.001', 'MXHYY', '');
INSERT INTO `05diseases` VALUES ('9270', '慢性喉炎', '133', 'J37.002', 'MXHY', '');
INSERT INTO `05diseases` VALUES ('9271', '慢性会厌炎', '277', 'J37.003', 'MXHYY', '');
INSERT INTO `05diseases` VALUES ('9272', '慢性喉炎伴慢性气管炎', '133', 'J37.151', 'MXHYBMXQGY', '');
INSERT INTO `05diseases` VALUES ('9273', '慢性气管炎伴慢性喉炎', '133', 'J37.152', 'MXQGYBMXHY', '');
INSERT INTO `05diseases` VALUES ('9274', '喉肌麻痹 [喉麻痹]', '133', 'J38.001', 'HJMBHMB', '');
INSERT INTO `05diseases` VALUES ('9275', '喉上神经麻痹', '313', 'J38.002', 'HSSJMB', '');
INSERT INTO `05diseases` VALUES ('9276', '喉神经麻痹', '313', 'J38.003', 'HSJMB', '');
INSERT INTO `05diseases` VALUES ('9277', '声带麻痹(瘫痪)', '217', 'J38.004', 'SDMBTH', '');
INSERT INTO `05diseases` VALUES ('9278', '喉麻痹', '133', 'J38.051', 'HMB', '');
INSERT INTO `05diseases` VALUES ('9279', '喉收肌麻痹', '133', 'J38.052', 'HSJMB', '');
INSERT INTO `05diseases` VALUES ('9280', '喉息肉', '133', 'J38.101', 'HXR', '');
INSERT INTO `05diseases` VALUES ('9281', '声带息肉', '374', 'J38.102', 'SDXR', '');
INSERT INTO `05diseases` VALUES ('9282', '室带息肉', '374', 'J38.151', 'SDXR', '');
INSERT INTO `05diseases` VALUES ('9283', '歌手结节', '328', 'J38.201', 'GSJJ', '');
INSERT INTO `05diseases` VALUES ('9284', '声带结节', '316', 'J38.202', 'SDJJ', '');
INSERT INTO `05diseases` VALUES ('9285', '声带小结', '316', 'J38.203', 'SDXJ', '');
INSERT INTO `05diseases` VALUES ('9286', '声带炎', '316', 'J38.204', 'SDY', '');
INSERT INTO `05diseases` VALUES ('9287', '室带炎', '277', 'J38.251', 'SDY', '');
INSERT INTO `05diseases` VALUES ('9288', '声带白斑', '250', 'J38.301', 'SDBB', '');
INSERT INTO `05diseases` VALUES ('9289', '声带出血', '38', 'J38.302', 'SDCX', '');
INSERT INTO `05diseases` VALUES ('9290', '声带恶性肉芽肿', '295', 'J38.303', 'SDEXRYZ', '');
INSERT INTO `05diseases` VALUES ('9291', '声带角化症', '316', 'J38.304', 'SDJHZ', '');
INSERT INTO `05diseases` VALUES ('9292', '声带囊肿', '231', 'J38.305', 'SDNZ', '');
INSERT INTO `05diseases` VALUES ('9293', '声带其他疾患', '316', 'J38.306', 'SDQTJH', '');
INSERT INTO `05diseases` VALUES ('9294', '声带肉芽肿', '295', 'J38.307', 'SDRYZ', '');
INSERT INTO `05diseases` VALUES ('9295', '声带水肿', '337', 'J38.308', 'SDSZ', '');
INSERT INTO `05diseases` VALUES ('9296', '声带松弛', '316', 'J38.309', 'SDSC', '');
INSERT INTO `05diseases` VALUES ('9297', '声带粘连', '316', 'J38.310', 'SDNL', '');
INSERT INTO `05diseases` VALUES ('9298', '声带肿物', '316', 'J38.311', 'SDZW', '');
INSERT INTO `05diseases` VALUES ('9299', '声带闭合不全', '316', 'J38.351', 'SDBHBQ', '');
INSERT INTO `05diseases` VALUES ('9300', '声带肥大', '316', 'J38.352', 'SDFD', '');
INSERT INTO `05diseases` VALUES ('9301', '声带脓肿', '243', 'J38.353', 'SDNZ', '');
INSERT INTO `05diseases` VALUES ('9302', '喉水肿', '133', 'J38.401', 'HSZ', '');
INSERT INTO `05diseases` VALUES ('9303', '声门水肿', '337', 'J38.451', 'SMSZ', '');
INSERT INTO `05diseases` VALUES ('9304', '喉痉挛', '133', 'J38.501', 'HJL', '');
INSERT INTO `05diseases` VALUES ('9305', '米勒哮喘(性)(支气管)(痉挛性)', '279', 'J38.551', 'MLXCXZQGJLX', '');
INSERT INTO `05diseases` VALUES ('9306', '咽－扁桃体－心脏综合征', '403', 'J38.552', 'YBTTXZZHZ', '');
INSERT INTO `05diseases` VALUES ('9307', '喉梗阻', '133', 'J38.601', 'HGZ', '');
INSERT INTO `05diseases` VALUES ('9308', '喉狭窄', '133', 'J38.602', 'HXZ', '');
INSERT INTO `05diseases` VALUES ('9309', '喉咽部狭窄', '133', 'J38.603', 'HYBXZ', '');
INSERT INTO `05diseases` VALUES ('9310', '声门狭窄', '278', 'J38.604', 'SMXZ', '');
INSERT INTO `05diseases` VALUES ('9311', '喉瘢痕狭窄', '133', 'J38.651', 'HBHXZ', '');
INSERT INTO `05diseases` VALUES ('9312', '喉室带囊肿', '133', 'J38.701', 'HSDNZ', '');
INSERT INTO `05diseases` VALUES ('9313', '喉囊肿', '133', 'J38.702', 'HNZ', '');
INSERT INTO `05diseases` VALUES ('9314', '喉肌弱症', '133', 'J38.703', 'HJRZ', '');
INSERT INTO `05diseases` VALUES ('9315', '喉角化不全症', '133', 'J38.704', 'HJHBQZ', '');
INSERT INTO `05diseases` VALUES ('9316', '喉角化症', '133', 'J38.705', 'HJHZ', '');
INSERT INTO `05diseases` VALUES ('9317', '喉溃疡', '133', 'J38.706', 'HKY', '');
INSERT INTO `05diseases` VALUES ('9318', '喉内炎性肿物', '133', 'J38.707', 'HNYXZW', '');
INSERT INTO `05diseases` VALUES ('9319', '喉肉芽肿', '133', 'J38.708', 'HRYZ', '');
INSERT INTO `05diseases` VALUES ('9320', '喉上皮角化症', '133', 'J38.709', 'HSPJHZ', '');
INSERT INTO `05diseases` VALUES ('9321', '喉硬结病', '133', 'J38.710', 'HYJB', '');
INSERT INTO `05diseases` VALUES ('9322', '喉肿物', '133', 'J38.711', 'HZW', '');
INSERT INTO `05diseases` VALUES ('9323', '环杓关节强硬', '123', 'J38.712', 'HBGJQY', '');
INSERT INTO `05diseases` VALUES ('9324', '会厌部肉芽肿', '295', 'J38.713', 'HYBRYZ', '');
INSERT INTO `05diseases` VALUES ('9325', '会厌溃疡', '195', 'J38.714', 'HYKY', '');
INSERT INTO `05diseases` VALUES ('9326', '会厌囊肿', '231', 'J38.715', 'HYNZ', '');
INSERT INTO `05diseases` VALUES ('9327', '会厌增生', '278', 'J38.717', 'HYZS', '');
INSERT INTO `05diseases` VALUES ('9328', '室带肥厚', '278', 'J38.718', 'SDFH', '');
INSERT INTO `05diseases` VALUES ('9329', '外伤性喉蹼', '133', 'J38.719', 'WSXHP', '');
INSERT INTO `05diseases` VALUES ('9330', '喉白斑病', '133', 'J38.751', 'HBBB', '');
INSERT INTO `05diseases` VALUES ('9331', '喉肥厚', '133', 'J38.752', 'HFH', '');
INSERT INTO `05diseases` VALUES ('9332', '喉厚皮症', '133', 'J38.753', 'HHPZ', '');
INSERT INTO `05diseases` VALUES ('9333', '接触性喉溃疡', '133', 'J38.754', 'JCXHKY', '');
INSERT INTO `05diseases` VALUES ('9334', '咽侧壁炎性肿物', '276', 'J39.001', 'YCBYXZW', '');
INSERT INTO `05diseases` VALUES ('9335', '咽后壁脓肿', '243', 'J39.002', 'YHBNZ', '');
INSERT INTO `05diseases` VALUES ('9336', '咽旁脓肿', '243', 'J39.004', 'YPNZ', '');
INSERT INTO `05diseases` VALUES ('9337', '咽周脓肿', '243', 'J39.051', 'YZNZ', '');
INSERT INTO `05diseases` VALUES ('9338', '咽脓肿', '243', 'J39.105', 'YNZ', '');
INSERT INTO `05diseases` VALUES ('9339', '咽囊炎[咽粘液囊炎]', '462', 'J39.151', 'YNYYNYNY', '');
INSERT INTO `05diseases` VALUES ('9340', '喉蜂窝织炎', '133', 'J39.152', 'HFWZY', '');
INSERT INTO `05diseases` VALUES ('9341', '瘢痕性咽狭窄', '11', 'J39.201', 'BHXYXZ', '');
INSERT INTO `05diseases` VALUES ('9342', '鼻咽部出血', '16', 'J39.202', 'BYBCX', '');
INSERT INTO `05diseases` VALUES ('9343', '鼻咽部囊肿', '16', 'J39.203', 'BYBNZ', '');
INSERT INTO `05diseases` VALUES ('9344', '咽部水肿', '337', 'J39.205', 'YBSZ', '');
INSERT INTO `05diseases` VALUES ('9345', '鼻咽粘连', '16', 'J39.207', 'BYNL', '');
INSERT INTO `05diseases` VALUES ('9346', '梨状窝息肉', '374', 'J39.208', 'LZWXR', '');
INSERT INTO `05diseases` VALUES ('9347', '手术后咽瘘', '330', 'J39.209', 'SSHYL', '');
INSERT INTO `05diseases` VALUES ('9348', '咽下部狭窄', '276', 'J39.210', 'YXBXZ', '');
INSERT INTO `05diseases` VALUES ('9349', '咽部肿物', '276', 'J39.211', 'YBZW', '');
INSERT INTO `05diseases` VALUES ('9350', '咽喉溃疡', '133', 'J39.212', 'YHKY', '');
INSERT INTO `05diseases` VALUES ('9351', '咽角化症', '276', 'J39.213', 'YJHZ', '');
INSERT INTO `05diseases` VALUES ('9352', '咽瘘', '212', 'J39.214', 'YL', '');
INSERT INTO `05diseases` VALUES ('9353', '咽旁隙感染', '95', 'J39.215', 'YPXGR', '');
INSERT INTO `05diseases` VALUES ('9354', '咽下部囊肿', '231', 'J39.216', 'YXBNZ', '');
INSERT INTO `05diseases` VALUES ('9355', '咽部溃疡', '195', 'J39.251', 'YBKY', '');
INSERT INTO `05diseases` VALUES ('9356', '咽部异感症', '276', 'J39.252', 'YBYGZ', '');
INSERT INTO `05diseases` VALUES ('9357', '咽蜂窝织炎', '83', 'J39.253', 'YFWZY', '');
INSERT INTO `05diseases` VALUES ('9358', '咽肌痉挛', '179', 'J39.254', 'YJJL', '');
INSERT INTO `05diseases` VALUES ('9359', '托伦瓦尔特囊肿或病[咽囊肿]', '231', 'J39.255', 'TLWETNZHBYNZ', '');
INSERT INTO `05diseases` VALUES ('9360', '喉部鳞状上皮增生', '133', 'J39.256', 'HBLZSPZS', '');
INSERT INTO `05diseases` VALUES ('9361', '部位未特指的上呼吸道过敏反应', '266', 'J39.351', 'BWWTZDSHXDGMFY', '');
INSERT INTO `05diseases` VALUES ('9362', '大气道狭窄', '282', 'J39.801', 'DQDXZ', '');
INSERT INTO `05diseases` VALUES ('9363', '气管瘢痕', '270', 'J39.802', 'QGBH', '');
INSERT INTO `05diseases` VALUES ('9364', '气管梗阻', '270', 'J39.803', 'QGGZ', '');
INSERT INTO `05diseases` VALUES ('9365', '气管假性淋巴瘤', '270', 'J39.804', 'QGJXLBL', '');
INSERT INTO `05diseases` VALUES ('9366', '气管囊肿', '270', 'J39.805', 'QGNZ', '');
INSERT INTO `05diseases` VALUES ('9367', '气管脓肿', '243', 'J39.806', 'QGNZ', '');
INSERT INTO `05diseases` VALUES ('9368', '气管肉芽肿', '270', 'J39.807', 'QGRYZ', '');
INSERT INTO `05diseases` VALUES ('9369', '气管软化症', '270', 'J39.808', 'QGRHZ', '');
INSERT INTO `05diseases` VALUES ('9370', '气管受压', '270', 'J39.809', 'QGSY', '');
INSERT INTO `05diseases` VALUES ('9371', '气管狭窄', '270', 'J39.810', 'QGXZ', '');
INSERT INTO `05diseases` VALUES ('9372', '气管肿物', '270', 'J39.901', 'QGZW', '');
INSERT INTO `05diseases` VALUES ('9373', '上呼吸道的疾病', '266', 'J39.951', 'SHXDDJB', '');
INSERT INTO `05diseases` VALUES ('9374', '气管支气管炎', '465', 'J40.X01', 'QGZQGY', '');
INSERT INTO `05diseases` VALUES ('9375', '纤维素性支气管炎', '465', 'J40.X02', 'XWSXZQGY', '');
INSERT INTO `05diseases` VALUES ('9376', '支气管炎 NOS(年龄 在15岁以上儿童未特指急性或慢性者)', '465', 'J40.X03', 'ZQGYNLZSYSETWTZJXHMX', '');
INSERT INTO `05diseases` VALUES ('9377', '支气管周围炎', '279', 'J40.X04', 'ZQGZWY', '');
INSERT INTO `05diseases` VALUES ('9378', '假膜性支气管炎', '465', 'J40.X51', 'JMXZQGY', '');
INSERT INTO `05diseases` VALUES ('9379', '慢性单纯性支气管炎', '465', 'J41.001', 'MXDCXZQGY', '');
INSERT INTO `05diseases` VALUES ('9380', '支气管炎性肿物', '465', 'J41.002', 'ZQGYXZW', '');
INSERT INTO `05diseases` VALUES ('9381', '慢性化脓性支气管炎', '465', 'J41.151', 'MXHNXZQGY', '');
INSERT INTO `05diseases` VALUES ('9382', '慢性混合的单纯性支气管炎', '465', 'J41.851', 'MXHHDDCXZQGY', '');
INSERT INTO `05diseases` VALUES ('9383', '慢性气管炎', '283', 'J42.X01', 'MXQGY', '');
INSERT INTO `05diseases` VALUES ('9384', '慢性支气管炎', '465', 'J42.X02', 'MXZQGY', '');
INSERT INTO `05diseases` VALUES ('9385', '慢性继发感染性支气管炎', '95', 'J42.X51', 'MXJFGRXZQGY', '');
INSERT INTO `05diseases` VALUES ('9386', '气管炎伴慢支炎', '283', 'J42.X52', 'QGYBMZY', '');
INSERT INTO `05diseases` VALUES ('9387', '单侧透明肺', '79', 'J43.051', 'DCTMF', '');
INSERT INTO `05diseases` VALUES ('9388', '单侧肺气肿', '79', 'J43.052', 'DCFQZ', '');
INSERT INTO `05diseases` VALUES ('9389', '麦克劳德综合征', '278', 'J43.053', 'MKLDZHZ', '');
INSERT INTO `05diseases` VALUES ('9390', '全叶性肺气肿', '79', 'J43.101', 'QYXFQZ', '');
INSERT INTO `05diseases` VALUES ('9391', '全肺泡性肺气肿', '79', 'J43.151', 'QFPXFQZ', '');
INSERT INTO `05diseases` VALUES ('9392', '中心叶性肺气肿', '79', 'J43.201', 'ZXYXFQZ', '');
INSERT INTO `05diseases` VALUES ('9393', '其他肺气肿', '79', 'J43.851', 'QTFQZ', '');
INSERT INTO `05diseases` VALUES ('9394', '大泡性肺气肿', '79', 'J43.901', 'DPXFQZ', '');
INSERT INTO `05diseases` VALUES ('9395', '肺大泡破裂', '79', 'J43.902', 'FDPPL', '');
INSERT INTO `05diseases` VALUES ('9396', '肺气肿 NOS', '79', 'J43.903', 'FQZ', '');
INSERT INTO `05diseases` VALUES ('9397', '老年性肺气肿', '79', 'J43.904', 'LNXFQZ', '');
INSERT INTO `05diseases` VALUES ('9398', '阻塞性肺气肿', '79', 'J43.905', 'ZSXFQZ', '');
INSERT INTO `05diseases` VALUES ('9399', '肺泡性肺气肿', '79', 'J43.951', 'FPXFQZ', '');
INSERT INTO `05diseases` VALUES ('9400', '局灶性肺气肿', '79', 'J43.952', 'JZXFQZ', '');
INSERT INTO `05diseases` VALUES ('9401', '肺大泡', '79', 'J43.953', 'FDP', '');
INSERT INTO `05diseases` VALUES ('9402', '慢性阻塞性支气管炎合并感染', '95', 'J44.001', 'MXZSXZQGYHBGR', '');
INSERT INTO `05diseases` VALUES ('9403', '哮喘性肺炎', '81', 'J44.002', 'XCXFY', '');
INSERT INTO `05diseases` VALUES ('9404', '慢性支气管炎急性发作', '465', 'J44.101', 'MXZQGYJXFZ', '');
INSERT INTO `05diseases` VALUES ('9405', '慢性阻塞性肺病伴有急性加重 NOS', '79', 'J44.151', 'MXZSXFBBYJXJZ', '');
INSERT INTO `05diseases` VALUES ('9406', '闭塞性细支气管炎', '465', 'J44.801', 'BSXXZQGY', '');
INSERT INTO `05diseases` VALUES ('9407', '慢性喘息性支气管炎', '465', 'J44.802', 'MXCXXZQGY', '');
INSERT INTO `05diseases` VALUES ('9408', '慢性哮喘性支气管炎', '465', 'J44.803', 'MXXCXZQGY', '');
INSERT INTO `05diseases` VALUES ('9409', '慢性气肿型支气管炎', '465', 'J44.804', 'MXQZXZQGY', '');
INSERT INTO `05diseases` VALUES ('9410', '慢性细支气管炎', '465', 'J44.805', 'MXXZQGY', '');
INSERT INTO `05diseases` VALUES ('9411', '慢性阻塞性支气管炎', '465', 'J44.806', 'MXZSXZQGY', '');
INSERT INTO `05diseases` VALUES ('9412', '慢性支气管炎伴肺气肿', '465', 'J44.851', 'MXZQGYBFQZ', '');
INSERT INTO `05diseases` VALUES ('9413', '慢性阻塞性肺疾病', '79', 'J44.901', 'MXZSXFJB', '');
INSERT INTO `05diseases` VALUES ('9414', '慢性阻塞性气道疾病', '282', 'J44.951', 'MXZSXQDJB', '');
INSERT INTO `05diseases` VALUES ('9415', '过敏性哮喘', '390', 'J45.001', 'GMXXC', '');
INSERT INTO `05diseases` VALUES ('9416', '外源性支气管哮喘', '279', 'J45.002', 'WYXZQGXC', '');
INSERT INTO `05diseases` VALUES ('9417', '儿童期哮喘', '390', 'J45.003', 'ETQXC', '');
INSERT INTO `05diseases` VALUES ('9418', '过敏性鼻炎伴哮喘', '16', 'J45.004', 'GMXBYBXC', '');
INSERT INTO `05diseases` VALUES ('9419', '过敏性哮喘，过敏性鼻炎伴哮喘', '16', 'J45.005', 'GMXXCGMXBYBXC', '');
INSERT INTO `05diseases` VALUES ('9420', '变态反应性支气管哮喘', '279', 'J45.051', 'BTFYXZQGXC', '');
INSERT INTO `05diseases` VALUES ('9421', '外因性变应性支气管哮喘', '279', 'J45.052', 'WYXBYXZQGXC', '');
INSERT INTO `05diseases` VALUES ('9422', '职业哮喘', '390', 'J45.053', 'ZYXC', '');
INSERT INTO `05diseases` VALUES ('9423', '内源性支气管哮喘', '279', 'J45.101', 'NYXZQGXC', '');
INSERT INTO `05diseases` VALUES ('9424', '内因性非变应性支气管哮喘', '279', 'J45.151', 'NYXFBYXZQGXC', '');
INSERT INTO `05diseases` VALUES ('9425', '特应性哮喘', '390', 'J45.152', 'TYXXC', '');
INSERT INTO `05diseases` VALUES ('9426', '混合性哮喘', '390', 'J45.851', 'HHXXC', '');
INSERT INTO `05diseases` VALUES ('9427', '哮喘', '390', 'J45.901', 'XC', '');
INSERT INTO `05diseases` VALUES ('9428', '哮喘性支气管炎', '465', 'J45.902', 'XCXZQGY', '');
INSERT INTO `05diseases` VALUES ('9429', '支气管哮喘', '279', 'J45.903', 'ZQGXC', '');
INSERT INTO `05diseases` VALUES ('9430', '迟发型哮喘', '390', 'J45.951', 'CFXXC', '');
INSERT INTO `05diseases` VALUES ('9431', '罗斯坦(性)(支气管)(痉挛性)哮喘', '279', 'J45.952', 'LSTXZQGJLXXC', '');
INSERT INTO `05diseases` VALUES ('9432', '哮喘持续状态(哮喘状态)', '390', 'J46.X01', 'XCCXZTXCZT', '');
INSERT INTO `05diseases` VALUES ('9433', '急性严重哮喘', '390', 'J46.X51', 'JXYZXC', '');
INSERT INTO `05diseases` VALUES ('9434', '支气管扩张', '279', 'J47.X01', 'ZQGKZ', '');
INSERT INTO `05diseases` VALUES ('9435', '支气管扩张伴咯血', '279', 'J47.X02', 'ZQGKZBKX', '');
INSERT INTO `05diseases` VALUES ('9436', '支气管扩张合并感染', '95', 'J47.X03', 'ZQGKZHBGR', '');
INSERT INTO `05diseases` VALUES ('9437', '细支气管扩张症', '279', 'J47.X51', 'XZQGKZZ', '');
INSERT INTO `05diseases` VALUES ('9438', '煤尘肺(炭末肺)', '79', 'J60.X01', 'MCFTMF', '');
INSERT INTO `05diseases` VALUES ('9439', '矿工肺', '79', 'J60.X51', 'KGF', '');
INSERT INTO `05diseases` VALUES ('9440', '矿工哮喘', '390', 'J60.X52', 'KGXC', '');
INSERT INTO `05diseases` VALUES ('9441', '煤矽肺', '79', 'J60.X53', 'MXF', '');
INSERT INTO `05diseases` VALUES ('9442', '石棉肺[石棉沉着病]', '79', 'J61.X51', 'SMFSMCZB', '');
INSERT INTO `05diseases` VALUES ('9443', '滑石粉尘肺', '79', 'J62.051', 'HSFCF', '');
INSERT INTO `05diseases` VALUES ('9444', '矽肺(硅肺)', '79', 'J62.801', 'XFGF', '');
INSERT INTO `05diseases` VALUES ('9445', '矽肺性肺纤维化', '79', 'J62.802', 'XFXFXWH', '');
INSERT INTO `05diseases` VALUES ('9446', '喷沙工哮喘、喷沙工肺、喷沙工尘肺', '79', 'J62.851', 'PSGXCPSGFPSGCF', '');
INSERT INTO `05diseases` VALUES ('9447', '花岗岩工人肺', '79', 'J62.852', 'HGYGRF', '');
INSERT INTO `05diseases` VALUES ('9448', '石匠哮喘、石匠病、石匠肺或石匠尘肺', '79', 'J62.853', 'SJXCSJBSJFHSJCF', '');
INSERT INTO `05diseases` VALUES ('9449', '矾土肺(肺的)', '79', 'J63.051', 'FTFFD', '');
INSERT INTO `05diseases` VALUES ('9450', '铝土纤维化(肺的)', '79', 'J63.151', 'LTXWHFD', '');
INSERT INTO `05diseases` VALUES ('9451', '铍中毒(肺)', '79', 'J63.251', 'PZDF', '');
INSERT INTO `05diseases` VALUES ('9452', '石墨纤维化(肺的)', '79', 'J63.351', 'SMXWHFD', '');
INSERT INTO `05diseases` VALUES ('9453', '肺铁未沉着病[阿尔克－韦尔法氏肺]', '79', 'J63.451', 'FTWCZBAEKWEFSF', '');
INSERT INTO `05diseases` VALUES ('9454', '锡尘肺(锡矿工尘肺)', '79', 'J63.551', 'XCFXKGCF', '');
INSERT INTO `05diseases` VALUES ('9455', '铸工支气管炎', '465', 'J63.851', 'ZGZQGY', '');
INSERT INTO `05diseases` VALUES ('9456', '金属尘肺', '79', 'J63.852', 'JSCF', '');
INSERT INTO `05diseases` VALUES ('9457', '肺尘埃沉着病[尘肺]', '79', 'J64.X51', 'FCACZBCF', '');
INSERT INTO `05diseases` VALUES ('9458', '矽肺结核病(矽肺并发肺结核病)', '171', 'J65.X01', 'XFJHBXFBFFJHB', '');
INSERT INTO `05diseases` VALUES ('9459', '棉尘肺', '79', 'J66.051', 'MCF', '');
INSERT INTO `05diseases` VALUES ('9460', '亚麻肺', '79', 'J66.151', 'YMF', '');
INSERT INTO `05diseases` VALUES ('9461', '大麻尘肺', '79', 'J66.251', 'DMCF', '');
INSERT INTO `05diseases` VALUES ('9462', '其他特指的有机粉尘引起的气道疾病', '282', 'J66.851', 'QTTZDYJFCYQDQDJB', '');
INSERT INTO `05diseases` VALUES ('9463', '农民肺', '79', 'J67.001', 'NMF', '');
INSERT INTO `05diseases` VALUES ('9464', '发霉干草病', '268', 'J67.051', 'FMGCB', '');
INSERT INTO `05diseases` VALUES ('9465', '蔗尘病或蔗尘肺', '79', 'J67.151', 'ZCBHZCF', '');
INSERT INTO `05diseases` VALUES ('9466', '好鸟者肺', '79', 'J67.251', 'HNZF', '');
INSERT INTO `05diseases` VALUES ('9467', '软木尘肺', '79', 'J67.351', 'RMCF', '');
INSERT INTO `05diseases` VALUES ('9468', '麦芽肺', '79', 'J67.451', 'MYF', '');
INSERT INTO `05diseases` VALUES ('9469', '蘑菇肺', '79', 'J67.501', 'MGF', '');
INSERT INTO `05diseases` VALUES ('9470', '剥枫树皮肺', '79', 'J67.651', 'BFSPF', '');
INSERT INTO `05diseases` VALUES ('9471', '空调和加湿器肺', '79', 'J67.751', 'KDHJSQF', '');
INSERT INTO `05diseases` VALUES ('9472', '木工哮喘', '390', 'J67.851', 'MGXC', '');
INSERT INTO `05diseases` VALUES ('9473', '变应性(外因性)肺泡炎', '79', 'J67.852', 'BYXWYXFPY', '');
INSERT INTO `05diseases` VALUES ('9474', '谷物工病[或谷物工人肺]', '79', 'J67.853', 'GWGBHGWGRF', '');
INSERT INTO `05diseases` VALUES ('9475', '咖啡肺', '79', 'J67.854', 'KFF', '');
INSERT INTO `05diseases` VALUES ('9476', '鱼食肺', '79', 'J67.855', 'YSF', '');
INSERT INTO `05diseases` VALUES ('9477', '皮毛肺', '79', 'J67.856', 'PMF', '');
INSERT INTO `05diseases` VALUES ('9478', '红杉锯屑病', '268', 'J67.857', 'HSJXB', '');
INSERT INTO `05diseases` VALUES ('9479', '过敏性肺炎', '81', 'J67.901', 'GMXFY', '');
INSERT INTO `05diseases` VALUES ('9480', '过敏性(变应性)肺泡炎[吕弗勒综合征]', '79', 'J67.902', 'GMXBYXFPYLFLZHZ', '');
INSERT INTO `05diseases` VALUES ('9481', '喘息性(哮喘)肺炎', '81', 'J67.951', 'CXXXCFY', '');
INSERT INTO `05diseases` VALUES ('9482', '肺炎，由于吸入有毒气体', '81', 'J68.001', 'FYYYXRYDQT', '');
INSERT INTO `05diseases` VALUES ('9483', '急性化学性支气管炎', '465', 'J68.051', 'JXHXXZQGY', '');
INSERT INTO `05diseases` VALUES ('9484', '急性化学性肺水肿', '79', 'J68.151', 'JXHXXFSZ', '');
INSERT INTO `05diseases` VALUES ('9485', '吸入化学制剂、气体、烟雾和蒸气引起的上呼吸道炎症', '266', 'J68.251', 'XRHXZJQTYWHZQYQDSHXD', '');
INSERT INTO `05diseases` VALUES ('9486', '反应性气道机能障碍综合征', '282', 'J68.351', 'FYXQDJNZAZHZ', '');
INSERT INTO `05diseases` VALUES ('9487', '吸入化学制剂、气体、烟雾和蒸气引起的肺气肿', '79', 'J68.451', 'XRHXZJQTYWHZQYQDFQZ', '');
INSERT INTO `05diseases` VALUES ('9488', '吸入化学制剂、气体、烟雾和蒸气引起的肺纤维化', '79', 'J68.452', 'XRHXZJQTYWHZQYQDFXWH', '');
INSERT INTO `05diseases` VALUES ('9489', '吸入化学制剂、气体、烟雾和蒸气引起的呼吸道疾病 NOS', '266', 'J68.951', 'XRHXZJQTYWHZQYQDHXDJ', '');
INSERT INTO `05diseases` VALUES ('9490', '吸入性肺炎', '81', 'J69.001', 'XRXFY', '');
INSERT INTO `05diseases` VALUES ('9491', '吸入性肺炎,由于胃分泌物', '81', 'J69.002', 'XRXFYYYWFMW', '');
INSERT INTO `05diseases` VALUES ('9492', '肺炎,由于吸入油', '81', 'J69.101', 'FYYYXRY', '');
INSERT INTO `05diseases` VALUES ('9493', '脂质性肺炎', '81', 'J69.151', 'ZZXFY', '');
INSERT INTO `05diseases` VALUES ('9494', '洗涤剂性支气管哮喘', '279', 'J69.801', 'XDJXZQGXC', '');
INSERT INTO `05diseases` VALUES ('9495', '吸入血引起的肺炎', '81', 'J69.851', 'XRXYQDFY', '');
INSERT INTO `05diseases` VALUES ('9496', '放射性肺炎', '81', 'J70.001', 'FSXFY', '');
INSERT INTO `05diseases` VALUES ('9497', '放射性肺纤维化', '79', 'J70.101', 'FSXFXWH', '');
INSERT INTO `05diseases` VALUES ('9498', '药物性急性间质性肺疾患', '79', 'J70.251', 'YWXJXJZXFJH', '');
INSERT INTO `05diseases` VALUES ('9499', '药物性慢性间质性肺疾患', '79', 'J70.351', 'YWXMXJZXFJH', '');
INSERT INTO `05diseases` VALUES ('9500', '药物性间质性肺疾患', '79', 'J70.451', 'YWXJZXFJH', '');
INSERT INTO `05diseases` VALUES ('9501', '其他特指外部物质引起的呼吸性情况', '266', 'J70.851', 'QTTZWBWZYQDHXXQK', '');
INSERT INTO `05diseases` VALUES ('9502', '由外部物质引起的呼吸性情况 NOS', '266', 'J70.951', 'YWBWZYQDHXXQK', '');
INSERT INTO `05diseases` VALUES ('9503', '成人型肺透明膜病', '79', 'J80.X01', 'CRXFTMMB', '');
INSERT INTO `05diseases` VALUES ('9504', '成人呼吸窘迫综合征', '266', 'J80.X02', 'CRHXJPZHZ', '');
INSERT INTO `05diseases` VALUES ('9505', '透明肺', '79', 'J80.X03', 'TMF', '');
INSERT INTO `05diseases` VALUES ('9506', '休克肺', '79', 'J80.X04', 'XKF', '');
INSERT INTO `05diseases` VALUES ('9507', '创伤性肺机能不全', '79', 'J80.X51', 'CSXFJNBQ', '');
INSERT INTO `05diseases` VALUES ('9508', '创伤性湿肺', '79', 'J81.X01', 'CSXSF', '');
INSERT INTO `05diseases` VALUES ('9509', '急性肺水肿', '79', 'J81.X02', 'JXFSZ', '');
INSERT INTO `05diseases` VALUES ('9510', '肺水肿', '79', 'J81.X03', 'FSZ', '');
INSERT INTO `05diseases` VALUES ('9511', '肺充血', '79', 'J81.X51', 'FCX', '');
INSERT INTO `05diseases` VALUES ('9512', '中毒性肺水肿', '79', 'J81.X52', 'ZDXFSZ', '');
INSERT INTO `05diseases` VALUES ('9513', '肺血液坠积', '79', 'J81.X53', 'FXYZJ', '');
INSERT INTO `05diseases` VALUES ('9514', '被动性肺水肿', '79', 'J81.X54', 'BDXFSZ', '');
INSERT INTO `05diseases` VALUES ('9515', '肺嗜酸细胞增多症', '79', 'J82.X01', 'FSSXBZDZ', '');
INSERT INTO `05diseases` VALUES ('9516', '过敏性肺炎(变应性)', '81', 'J82.X02', 'GMXFYBYX', '');
INSERT INTO `05diseases` VALUES ('9517', '嗜酸细胞性肺炎', '81', 'J82.X03', 'SSXBXFY', '');
INSERT INTO `05diseases` VALUES ('9518', '迁延性肺嗜酸粒细胞浸润症[慢性嗜酸粒细胞性肺]', '79', 'J82.X51', 'QYXFSSLXBJRZMXSSLXBX', '');
INSERT INTO `05diseases` VALUES ('9519', '肺嗜酸细胞浸润症，单纯性[勒夫勒氏综合征]', '79', 'J82.X52', 'FSSXBJRZDCXLFLSZHZ', '');
INSERT INTO `05diseases` VALUES ('9520', '热带性嗜酸细胞增多症', '379', 'J82.X53', 'RDXSSXBZDZ', '');
INSERT INTO `05diseases` VALUES ('9521', '嗜酸细胞性哮喘', '376', 'J82.X54', 'SSXBXXC', '');
INSERT INTO `05diseases` VALUES ('9522', '肺泡蛋白沉积症', '79', 'J84.001', 'FPDBCJZ', '');
INSERT INTO `05diseases` VALUES ('9523', '肺间质纤维化(炎症后)', '79', 'J84.101', 'FJZXWHYZH', '');
INSERT INTO `05diseases` VALUES ('9524', '肺肉芽肿', '79', 'J84.102', 'FRYZ', '');
INSERT INTO `05diseases` VALUES ('9525', '肺纤维化', '79', 'J84.103', 'FXWH', '');
INSERT INTO `05diseases` VALUES ('9526', '肺硬化', '79', 'J84.104', 'FYH', '');
INSERT INTO `05diseases` VALUES ('9527', '机化性肺炎', '81', 'J84.105', 'JHXFY', '');
INSERT INTO `05diseases` VALUES ('9528', '间质性纤维化性肺泡炎', '79', 'J84.106', 'JZXXWHXFPY', '');
INSERT INTO `05diseases` VALUES ('9529', '弥漫性肺间质纤维化', '79', 'J84.107', 'MMXFJZXWH', '');
INSERT INTO `05diseases` VALUES ('9530', '弥漫性肺纤维化', '79', 'J84.108', 'MMXFXWH', '');
INSERT INTO `05diseases` VALUES ('9531', '特发性弥漫性肺间质纤维化', '79', 'J84.109', 'TFXMMXFJZXWH', '');
INSERT INTO `05diseases` VALUES ('9532', '致纤维化肺泡炎', '79', 'J84.110', 'ZXWHFPY', '');
INSERT INTO `05diseases` VALUES ('9533', '肺间质纤维化[黑－里(哈曼－里奇)综合征]', '79', 'J84.151', 'FJZXWHHLHMLQZHZ', '');
INSERT INTO `05diseases` VALUES ('9534', '特发性肺棕色硬结症', '79', 'J84.152', 'TFXFZSYJZ', '');
INSERT INTO `05diseases` VALUES ('9535', '胆固醇肺炎[类源性类脂性肺炎]', '81', 'J84.801', 'DGCFYLYXLZXFY', '');
INSERT INTO `05diseases` VALUES ('9536', '肺弥漫性间质病变', '161', 'J84.802', 'FMMXJZBB', '');
INSERT INTO `05diseases` VALUES ('9537', '间质性肺炎', '81', 'J84.901', 'JZXFY', '');
INSERT INTO `05diseases` VALUES ('9538', '坏疽性肺炎', '81', 'J85.001', 'HJXFY', '');
INSERT INTO `05diseases` VALUES ('9539', '肺脓肿伴肺炎', '81', 'J85.151', 'FNZBFY', '');
INSERT INTO `05diseases` VALUES ('9540', '肺脓肿', '243', 'J85.201', 'FNZ', '');
INSERT INTO `05diseases` VALUES ('9541', '继发性肺脓肿', '243', 'J85.251', 'JFXFNZ', '');
INSERT INTO `05diseases` VALUES ('9542', '吸入性肺脓肿', '243', 'J85.252', 'XRXFNZ', '');
INSERT INTO `05diseases` VALUES ('9543', '血源性肺脓肿', '243', 'J85.253', 'XYXFNZ', '');
INSERT INTO `05diseases` VALUES ('9544', '纵隔脓肿', '243', 'J85.301', 'ZGNZ', '');
INSERT INTO `05diseases` VALUES ('9545', '肝-胸膜瘘', '92', 'J86.001', 'GXML', '');
INSERT INTO `05diseases` VALUES ('9546', '脓胸伴瘘', '212', 'J86.002', 'NXBL', '');
INSERT INTO `05diseases` VALUES ('9547', '食管气管瘘', '270', 'J86.003', 'SGQGL', '');
INSERT INTO `05diseases` VALUES ('9548', '食管胸膜瘘', '212', 'J86.004', 'SGXML', '');
INSERT INTO `05diseases` VALUES ('9549', '食管支气管瘘', '279', 'J86.005', 'SGZQGL', '');
INSERT INTO `05diseases` VALUES ('9550', '手术后支气管胸膜瘘', '279', 'J86.006', 'SSHZQGXML', '');
INSERT INTO `05diseases` VALUES ('9551', '胸壁窦道', '274', 'J86.007', 'XBDD', '');
INSERT INTO `05diseases` VALUES ('9552', '支气管瘘', '279', 'J86.008', 'ZQGL', '');
INSERT INTO `05diseases` VALUES ('9553', '支气管-胃-结肠瘘', '370', 'J86.009', 'ZQGWJCL', '');
INSERT INTO `05diseases` VALUES ('9554', '支气管胸膜瘘', '279', 'J86.010', 'ZQGXML', '');
INSERT INTO `05diseases` VALUES ('9555', '纵隔瘘', '212', 'J86.011', 'ZGL', '');
INSERT INTO `05diseases` VALUES ('9556', '纵隔支气管瘘', '279', 'J86.051', 'ZGZQGL', '');
INSERT INTO `05diseases` VALUES ('9557', '支气管内脏瘘', '279', 'J86.052', 'ZQGNZL', '');
INSERT INTO `05diseases` VALUES ('9558', '脓胸伴支气管胸膜瘘', '279', 'J86.053', 'NXBZQGXML', '');
INSERT INTO `05diseases` VALUES ('9559', '脓胸伴支气管瘘', '279', 'J86.054', 'NXBZQGL', '');
INSERT INTO `05diseases` VALUES ('9560', '脓胸伴纵隔窦道', '274', 'J86.055', 'NXBZGDD', '');
INSERT INTO `05diseases` VALUES ('9561', '化脓性胸膜炎', '408', 'J86.901', 'HNXXMY', '');
INSERT INTO `05diseases` VALUES ('9562', '脓气胸', '284', 'J86.902', 'NQX', '');
INSERT INTO `05diseases` VALUES ('9563', '脓胸', '274', 'J86.903', 'NX', '');
INSERT INTO `05diseases` VALUES ('9564', '急性全脓胸伴肺不张', '79', 'J86.951', 'JXQNXBFBZ', '');
INSERT INTO `05diseases` VALUES ('9565', '浆液性脓性胸膜炎', '408', 'J86.952', 'JYXNXXMY', '');
INSERT INTO `05diseases` VALUES ('9566', '纤维性脓性胸膜炎', '408', 'J86.953', 'XWXNXXMY', '');
INSERT INTO `05diseases` VALUES ('9567', '包裹性胸膜炎', '408', 'J90.X01', 'BGXXMY', '');
INSERT INTO `05diseases` VALUES ('9568', '渗出性胸膜炎', '408', 'J90.X02', 'SCXXMY', '');
INSERT INTO `05diseases` VALUES ('9569', '胸膜炎伴积液', '408', 'J90.X03', 'XMYBJY', '');
INSERT INTO `05diseases` VALUES ('9570', '浆液性胸膜炎', '408', 'J90.X51', 'JYXXMY', '');
INSERT INTO `05diseases` VALUES ('9571', '胸膜斑伴有石棉沉着病', '250', 'J92.051', 'XMBBYSMCZB', '');
INSERT INTO `05diseases` VALUES ('9572', '胸膜肥厚(胸膜纤维化)', '407', 'J92.901', 'XMFHXMXWH', '');
INSERT INTO `05diseases` VALUES ('9573', '胸膜斑', '250', 'J92.951', 'XMB', '');
INSERT INTO `05diseases` VALUES ('9574', '张力性气胸', '284', 'J93.001', 'ZLXQX', '');
INSERT INTO `05diseases` VALUES ('9575', '自发性张力性气胸', '284', 'J93.051', 'ZFXZLXQX', '');
INSERT INTO `05diseases` VALUES ('9576', '自发性气胸', '284', 'J93.101', 'ZFXQX', '');
INSERT INTO `05diseases` VALUES ('9577', '包裹性气胸', '284', 'J93.801', 'BGXQX', '');
INSERT INTO `05diseases` VALUES ('9578', '气胸 NOS', '284', 'J93.901', 'QX', '');
INSERT INTO `05diseases` VALUES ('9579', '乳糜性渗出', '278', 'J94.051', 'RMXSC', '');
INSERT INTO `05diseases` VALUES ('9580', '纤维胸', '274', 'J94.151', 'XWX', '');
INSERT INTO `05diseases` VALUES ('9581', '血气胸', '284', 'J94.201', 'XQX', '');
INSERT INTO `05diseases` VALUES ('9582', '血胸', '274', 'J94.202', 'XX', '');
INSERT INTO `05diseases` VALUES ('9583', '出血性胸膜炎', '408', 'J94.251', 'CXXXMY', '');
INSERT INTO `05diseases` VALUES ('9584', '自发性血气胸', '284', 'J94.252', 'ZFXXQX', '');
INSERT INTO `05diseases` VALUES ('9585', '包裹性胸腔积液', '274', 'J94.801', 'BGXXQJY', '');
INSERT INTO `05diseases` VALUES ('9586', '梅格斯综合征', '278', 'J94.802', 'MGSZHZ', '');
INSERT INTO `05diseases` VALUES ('9587', '手术后胸腔积液', '330', 'J94.803', 'SSHXQJY', '');
INSERT INTO `05diseases` VALUES ('9588', '水气胸', '284', 'J94.804', 'SQX', '');
INSERT INTO `05diseases` VALUES ('9589', '胸膜钙化', '407', 'J94.805', 'XMGH', '');
INSERT INTO `05diseases` VALUES ('9590', '胸膜腔积液', '407', 'J94.806', 'XMQJY', '');
INSERT INTO `05diseases` VALUES ('9591', '胸膜粘连', '407', 'J94.807', 'XMNL', '');
INSERT INTO `05diseases` VALUES ('9592', '胸腔积液', '274', 'J94.808', 'XQJY', '');
INSERT INTO `05diseases` VALUES ('9593', '液气胸', '284', 'J94.809', 'YQX', '');
INSERT INTO `05diseases` VALUES ('9594', '胸膜疾患 NOS', '407', 'J94.951', 'XMJH', '');
INSERT INTO `05diseases` VALUES ('9595', '手术后气管食管瘘', '270', 'J95.001', 'SSHQGSGL', '');
INSERT INTO `05diseases` VALUES ('9596', '气管切开术后拔管困难', '270', 'J95.003', 'QGQKSHBGKN', '');
INSERT INTO `05diseases` VALUES ('9597', '气管切开术后气道阻塞', '270', 'J95.004', 'QGQKSHQDZS', '');
INSERT INTO `05diseases` VALUES ('9598', '气管造瘘口狭窄', '270', 'J95.005', 'QGZLKXZ', '');
INSERT INTO `05diseases` VALUES ('9599', '气管造口术后气管食管瘘', '270', 'J95.006', 'QGZKSHQGSGL', '');
INSERT INTO `05diseases` VALUES ('9600', '气管造口术后出血', '270', 'J95.051', 'QGZKSHCX', '');
INSERT INTO `05diseases` VALUES ('9601', '气管造口术后脓毒病', '270', 'J95.052', 'QGZKSHNDB', '');
INSERT INTO `05diseases` VALUES ('9602', '手术后急性肺机能不全', '79', 'J95.101', 'SSHJXFJNBQ', '');
INSERT INTO `05diseases` VALUES ('9603', '手术后慢性肺机能不全', '79', 'J95.351', 'SSHMXFJNBQ', '');
INSERT INTO `05diseases` VALUES ('9604', '门德尔松综合征', '278', 'J95.451', 'MDESZHZ', '');
INSERT INTO `05diseases` VALUES ('9605', '操作后的声门下狭窄', '278', 'J95.551', 'CZHDSMXXZ', '');
INSERT INTO `05diseases` VALUES ('9606', '气管插管后喉水肿', '133', 'J95.801', 'QGCGHHSZ', '');
INSERT INTO `05diseases` VALUES ('9607', '手术后气胸', '330', 'J95.802', 'SSHQX', '');
INSERT INTO `05diseases` VALUES ('9608', '手术后声带粘连', '330', 'J95.803', 'SSHSDNL', '');
INSERT INTO `05diseases` VALUES ('9609', '胸壁术后软化', '330', 'J95.804', 'XBSHRH', '');
INSERT INTO `05diseases` VALUES ('9610', '气管造瘘术后口狭窄', '270', 'J95.851', 'QGZLSHKXZ', '');
INSERT INTO `05diseases` VALUES ('9611', '操作后呼吸性疾患 NOS', '266', 'J95.951', 'CZHHXXJH', '');
INSERT INTO `05diseases` VALUES ('9612', '急性呼吸衰竭', '266', 'J96.051', 'JXHXSJ', '');
INSERT INTO `05diseases` VALUES ('9613', '慢性呼吸衰竭', '266', 'J96.151', 'MXHXSJ', '');
INSERT INTO `05diseases` VALUES ('9614', '呼吸衰竭 NOS', '266', 'J96.901', 'HXSJ', '');
INSERT INTO `05diseases` VALUES ('9615', '后天性支气管憩室', '279', 'J98.001', 'HTXZQGQS', '');
INSERT INTO `05diseases` VALUES ('9616', '支气管化脓性肉芽肿', '279', 'J98.002', 'ZQGHNXRYZ', '');
INSERT INTO `05diseases` VALUES ('9617', '支气管结石', '279', 'J98.003', 'ZQGJS', '');
INSERT INTO `05diseases` VALUES ('9618', '支气管息肉', '279', 'J98.004', 'ZQGXR', '');
INSERT INTO `05diseases` VALUES ('9619', '支气管狭窄', '279', 'J98.005', 'ZQGXZ', '');
INSERT INTO `05diseases` VALUES ('9620', '支气管粘膜纤维组织增生', '279', 'J98.006', 'ZQGNMXWZZZS', '');
INSERT INTO `05diseases` VALUES ('9621', '支气管钙化', '279', 'J98.051', 'ZQGGH', '');
INSERT INTO `05diseases` VALUES ('9622', '支气管溃疡', '279', 'J98.052', 'ZQGKY', '');
INSERT INTO `05diseases` VALUES ('9623', '支气管憩室', '279', 'J98.053', 'ZQGQS', '');
INSERT INTO `05diseases` VALUES ('9624', '肺不张', '79', 'J98.101', 'FBZ', '');
INSERT INTO `05diseases` VALUES ('9625', '肺萎陷', '79', 'J98.102', 'FWX', '');
INSERT INTO `05diseases` VALUES ('9626', '肺中叶综合征', '79', 'J98.103', 'FZYZHZ', '');
INSERT INTO `05diseases` VALUES ('9627', '纵隔气肿', '278', 'J98.201', 'ZGQZ', '');
INSERT INTO `05diseases` VALUES ('9628', '间质性肺气肿', '79', 'J98.251', 'JZXFQZ', '');
INSERT INTO `05diseases` VALUES ('9629', '代偿性肺气肿', '79', 'J98.301', 'DCXFQZ', '');
INSERT INTO `05diseases` VALUES ('9630', '隔下脓肿', '243', 'J98.351', 'GXNZ', '');
INSERT INTO `05diseases` VALUES ('9631', '多囊肺', '79', 'J98.401', 'DNF', '');
INSERT INTO `05diseases` VALUES ('9632', '肺部感染', '95', 'J98.402', 'FBGR', '');
INSERT INTO `05diseases` VALUES ('9633', '肺膨出', '79', 'J98.403', 'FPC', '');
INSERT INTO `05diseases` VALUES ('9634', '肺钙化', '79', 'J98.404', 'FGH', '');
INSERT INTO `05diseases` VALUES ('9635', '肺后壁空洞', '79', 'J98.405', 'FHBKD', '');
INSERT INTO `05diseases` VALUES ('9636', '肺机能不全', '79', 'J98.406', 'FJNBQ', '');
INSERT INTO `05diseases` VALUES ('9637', '肺假性淋巴瘤', '79', 'J98.407', 'FJXLBL', '');
INSERT INTO `05diseases` VALUES ('9638', '肺假性肿瘤', '473', 'J98.408', 'FJXZL', '');
INSERT INTO `05diseases` VALUES ('9639', '肺炎性假瘤', '81', 'J98.409', 'FYXJL', '');
INSERT INTO `05diseases` VALUES ('9640', '肺弥漫性病变', '79', 'J98.410', 'FMMXBB', '');
INSERT INTO `05diseases` VALUES ('9641', '肺囊肿', '79', 'J98.411', 'FNZ', '');
INSERT INTO `05diseases` VALUES ('9642', '肺肿物', '79', 'J98.412', 'FZW', '');
INSERT INTO `05diseases` VALUES ('9643', '过敏性支气管肺疾患', '279', 'J98.413', 'GMXZQGFJH', '');
INSERT INTO `05diseases` VALUES ('9644', '损毁肺(炎症性)', '79', 'J98.414', 'SHFYZX', '');
INSERT INTO `05diseases` VALUES ('9645', '支气管囊肿', '279', 'J98.415', 'ZQGNZ', '');
INSERT INTO `05diseases` VALUES ('9646', '肺泡蜂窝综合征', '79', 'J98.451', 'FPFWZHZ', '');
INSERT INTO `05diseases` VALUES ('9647', '肺疝', '79', 'J98.452', 'FS', '');
INSERT INTO `05diseases` VALUES ('9648', '肺毒血症', '79', 'J98.453', 'FDXZ', '');
INSERT INTO `05diseases` VALUES ('9649', '肺病 NOS', '79', 'J98.454', 'FB', '');
INSERT INTO `05diseases` VALUES ('9650', '肺石病', '79', 'J98.455', 'FSB', '');
INSERT INTO `05diseases` VALUES ('9651', '慢性纵隔炎', '277', 'J98.501', 'MXZGY', '');
INSERT INTO `05diseases` VALUES ('9652', '纵隔疝', '305', 'J98.502', 'ZGS', '');
INSERT INTO `05diseases` VALUES ('9653', '纵隔纤维化', '278', 'J98.503', 'ZGXWH', '');
INSERT INTO `05diseases` VALUES ('9654', '急性纵隔炎', '277', 'J98.504', 'JXZGY', '');
INSERT INTO `05diseases` VALUES ('9655', '纵隔肿物', '278', 'J98.505', 'ZGZW', '');
INSERT INTO `05diseases` VALUES ('9656', '纵隔阴影', '86', 'J98.506', 'ZGYY', '');
INSERT INTO `05diseases` VALUES ('9657', '纵隔感染', '95', 'J98.551', 'ZGGR', '');
INSERT INTO `05diseases` VALUES ('9658', '纵隔囊肿', '231', 'J98.552', 'ZGNZ', '');
INSERT INTO `05diseases` VALUES ('9659', '纵隔退缩', '278', 'J98.553', 'ZGTS', '');
INSERT INTO `05diseases` VALUES ('9660', '膈(横膈)膨升', '278', 'J98.601', 'GHGPS', '');
INSERT INTO `05diseases` VALUES ('9661', '膈肌麻痹', '217', 'J98.602', 'GJMB', '');
INSERT INTO `05diseases` VALUES ('9662', '横膈麻痹', '217', 'J98.603', 'HGMB', '');
INSERT INTO `05diseases` VALUES ('9663', '膈肌囊肿', '231', 'J98.651', 'GJNZ', '');
INSERT INTO `05diseases` VALUES ('9664', '膈麻痹', '217', 'J98.652', 'GMB', '');
INSERT INTO `05diseases` VALUES ('9665', '膈松弛', '278', 'J98.653', 'GSC', '');
INSERT INTO `05diseases` VALUES ('9666', '鼻咽肿物', '16', 'J98.801', 'BYZW', '');
INSERT INTO `05diseases` VALUES ('9667', '呼吸道感染', '95', 'J98.802', 'HXDGR', '');
INSERT INTO `05diseases` VALUES ('9668', '呼吸道梗阻', '266', 'J98.803', 'HXDGZ', '');
INSERT INTO `05diseases` VALUES ('9669', '胸部肿物', '274', 'J98.804', 'XBZW', '');
INSERT INTO `05diseases` VALUES ('9670', '其他特指的呼吸性疾患', '266', 'J98.851', 'QTTZDHXXJH', '');
INSERT INTO `05diseases` VALUES ('9671', '胸腔占位性病变', '274', 'J98.901', 'XQZWXBB', '');
INSERT INTO `05diseases` VALUES ('9672', '胸腔肿物', '274', 'J98.902', 'XQZW', '');
INSERT INTO `05diseases` VALUES ('9673', '慢性呼吸道感染', '95', 'J98.951', 'MXHXDGR', '');
INSERT INTO `05diseases` VALUES ('9674', '牙齿发育不全', '425', 'K00.051', 'YCFYBQ', '');
INSERT INTO `05diseases` VALUES ('9675', '牙齿缺少', '425', 'K00.052', 'YCQS', '');
INSERT INTO `05diseases` VALUES ('9676', '多生齿', '278', 'K00.101', 'DSC', '');
INSERT INTO `05diseases` VALUES ('9677', '鼻腔牙[异位牙额外齿]', '16', 'K00.151', 'BQYYWYEWC', '');
INSERT INTO `05diseases` VALUES ('9678', '巨齿', '278', 'K00.201', 'JC', '');
INSERT INTO `05diseases` VALUES ('9679', '釉珠', '278', 'K00.251', 'YZ', '');
INSERT INTO `05diseases` VALUES ('9680', '磨牙旁额外牙结节', '425', 'K00.252', 'MYPEWYJJ', '');
INSERT INTO `05diseases` VALUES ('9681', '长冠牙', '425', 'K00.253', 'CGY', '');
INSERT INTO `05diseases` VALUES ('9682', '钉状牙', '425', 'K00.254', 'DZY', '');
INSERT INTO `05diseases` VALUES ('9683', '小牙', '425', 'K00.255', 'XY', '');
INSERT INTO `05diseases` VALUES ('9684', '前突牙', '425', 'K00.256', 'QTY', '');
INSERT INTO `05diseases` VALUES ('9685', '结合牙', '425', 'K00.257', 'JHY', '');
INSERT INTO `05diseases` VALUES ('9686', '融合牙', '425', 'K00.258', 'RHY', '');
INSERT INTO `05diseases` VALUES ('9687', '双生牙', '425', 'K00.259', 'SSY', '');
INSERT INTO `05diseases` VALUES ('9688', '斑釉病(症)[氟斑牙、黄斑牙]', '425', 'K00.351', 'BYBZFBYHBY', '');
INSERT INTO `05diseases` VALUES ('9689', '牙骨质缺失和发育不全', '425', 'K00.451', 'YGZQSHFYBQ', '');
INSERT INTO `05diseases` VALUES ('9690', '弯曲牙', '425', 'K00.452', 'WQY', '');
INSERT INTO `05diseases` VALUES ('9691', '区域性牙体发育异常', '425', 'K00.453', 'QYXYTFYYC', '');
INSERT INTO `05diseases` VALUES ('9692', '特纳牙', '425', 'K00.454', 'TNY', '');
INSERT INTO `05diseases` VALUES ('9693', '牙发生不全', '425', 'K00.551', 'YFSBQ', '');
INSERT INTO `05diseases` VALUES ('9694', '牙釉质发生不全', '425', 'K00.552', 'YYZFSBQ', '');
INSERT INTO `05diseases` VALUES ('9695', '牙本质发育不全', '425', 'K00.553', 'YBZFYBQ', '');
INSERT INTO `05diseases` VALUES ('9696', '壳状牙', '425', 'K00.554', 'KZY', '');
INSERT INTO `05diseases` VALUES ('9697', '乳牙早发', '425', 'K00.651', 'RYZF', '');
INSERT INTO `05diseases` VALUES ('9698', '初齿过早[乳牙]脱落', '425', 'K00.652', 'CCGZRYTL', '');
INSERT INTO `05diseases` VALUES ('9699', '牙过早萌出', '425', 'K00.653', 'YGZMC', '');
INSERT INTO `05diseases` VALUES ('9700', '保留[滞留]初齿', '278', 'K00.654', 'BLZLCC', '');
INSERT INTO `05diseases` VALUES ('9701', '出牙综合征', '425', 'K00.701', 'CYZHZ', '');
INSERT INTO `05diseases` VALUES ('9702', '牙齿形成期间颜色改变', '425', 'K00.851', 'YCXCQJYSGB', '');
INSERT INTO `05diseases` VALUES ('9703', '牙齿内在染色', '425', 'K00.852', 'YCNZRS', '');
INSERT INTO `05diseases` VALUES ('9704', '牙发生疾患', '425', 'K00.951', 'YFSJH', '');
INSERT INTO `05diseases` VALUES ('9705', '埋伏牙', '425', 'K01.051', 'MFY', '');
INSERT INTO `05diseases` VALUES ('9706', '阻生齿', '278', 'K01.101', 'ZSC', '');
INSERT INTO `05diseases` VALUES ('9707', '牙白斑损害', '425', 'K02.051', 'YBBSH', '');
INSERT INTO `05diseases` VALUES ('9708', '牙釉质龋', '425', 'K02.052', 'YYZQ', '');
INSERT INTO `05diseases` VALUES ('9709', '牙本质龋', '425', 'K02.151', 'YBZQ', '');
INSERT INTO `05diseases` VALUES ('9710', '牙骨质龋', '425', 'K02.251', 'YGZQ', '');
INSERT INTO `05diseases` VALUES ('9711', '静止龋', '278', 'K02.351', 'JZQ', '');
INSERT INTO `05diseases` VALUES ('9712', '牙折断', '425', 'K02.401', 'YZD', '');
INSERT INTO `05diseases` VALUES ('9713', '黑牙折断', '425', 'K02.451', 'HYZD', '');
INSERT INTO `05diseases` VALUES ('9714', '其他龋齿', '278', 'K02.851', 'QTQC', '');
INSERT INTO `05diseases` VALUES ('9715', '龋齿', '278', 'K02.901', 'QC', '');
INSERT INTO `05diseases` VALUES ('9716', '牙齿的邻面磨损', '425', 'K03.051', 'YCDLMMS', '');
INSERT INTO `05diseases` VALUES ('9717', '牙齿楔状缺损', '425', 'K03.151', 'YCXZQS', '');
INSERT INTO `05diseases` VALUES ('9718', '传统性牙齿磨损', '425', 'K03.152', 'CTXYCMS', '');
INSERT INTO `05diseases` VALUES ('9719', '宗教仪式性牙齿磨损', '425', 'K03.153', 'ZJYSXYCMS', '');
INSERT INTO `05diseases` VALUES ('9720', '职业性牙齿磨损', '425', 'K03.154', 'ZYXYCMS', '');
INSERT INTO `05diseases` VALUES ('9721', '习惯性牙齿磨损', '425', 'K03.155', 'XGXYCMS', '');
INSERT INTO `05diseases` VALUES ('9722', '净齿剂牙齿磨损', '425', 'K03.156', 'JCJYCMS', '');
INSERT INTO `05diseases` VALUES ('9723', '牙齿腐蚀', '425', 'K03.251', 'YCFS', '');
INSERT INTO `05diseases` VALUES ('9724', '职业性牙齿腐蚀', '425', 'K03.252', 'ZYXYCFS', '');
INSERT INTO `05diseases` VALUES ('9725', '特发性牙齿腐蚀', '425', 'K03.253', 'TFXYCFS', '');
INSERT INTO `05diseases` VALUES ('9726', '持续性呕吐引起的牙齿腐蚀', '425', 'K03.254', 'CXXOTYQDYCFS', '');
INSERT INTO `05diseases` VALUES ('9727', '药物和药剂引起的牙齿腐蚀', '425', 'K03.255', 'YWHYJYQDYCFS', '');
INSERT INTO `05diseases` VALUES ('9728', '饮食引起的牙齿腐蚀', '425', 'K03.256', 'YSYQDYCFS', '');
INSERT INTO `05diseases` VALUES ('9729', '牙髓内部肉芽肿', '425', 'K03.351', 'YSNBRYZ', '');
INSERT INTO `05diseases` VALUES ('9730', '牙齿吸收', '425', 'K03.352', 'YCXS', '');
INSERT INTO `05diseases` VALUES ('9731', '牙骨质增生', '425', 'K03.451', 'YGZZS', '');
INSERT INTO `05diseases` VALUES ('9732', '骨牙粘连', '425', 'K03.551', 'GYNL', '');
INSERT INTO `05diseases` VALUES ('9733', '牙齿沉积物', '425', 'K03.651', 'YCCJW', '');
INSERT INTO `05diseases` VALUES ('9734', '龈上牙石', '425', 'K03.652', 'YSYS', '');
INSERT INTO `05diseases` VALUES ('9735', '龈下牙石', '425', 'K03.653', 'YXYS', '');
INSERT INTO `05diseases` VALUES ('9736', '辐射性牙釉质', '425', 'K03.751', 'FSXYYZ', '');
INSERT INTO `05diseases` VALUES ('9737', '牙齿敏感症(牙本质过敏)', '425', 'K03.851', 'YCMGZYBZGM', '');
INSERT INTO `05diseases` VALUES ('9738', '牙齿硬组织疾病 NOS', '425', 'K03.951', 'YCYZZJB', '');
INSERT INTO `05diseases` VALUES ('9739', '化脓性牙髓炎', '425', 'K04.001', 'HNXYSY', '');
INSERT INTO `05diseases` VALUES ('9740', '急性牙髓炎', '425', 'K04.002', 'JXYSY', '');
INSERT INTO `05diseases` VALUES ('9741', '慢性牙髓炎', '425', 'K04.003', 'MXYSY', '');
INSERT INTO `05diseases` VALUES ('9742', '牙髓脓肿', '425', 'K04.004', 'YSNZ', '');
INSERT INTO `05diseases` VALUES ('9743', '牙髓炎', '425', 'K04.005', 'YSY', '');
INSERT INTO `05diseases` VALUES ('9744', '牙脓肿', '425', 'K04.051', 'YNZ', '');
INSERT INTO `05diseases` VALUES ('9745', '牙髓息肉', '425', 'K04.052', 'YSXR', '');
INSERT INTO `05diseases` VALUES ('9746', '牙髓坏死', '425', 'K04.151', 'YSHS', '');
INSERT INTO `05diseases` VALUES ('9747', '牙髓变性', '425', 'K04.251', 'YSBX', '');
INSERT INTO `05diseases` VALUES ('9748', '不规则牙本质病', '425', 'K04.351', 'BGZYBZB', '');
INSERT INTO `05diseases` VALUES ('9749', '急性根尖牙周炎', '425', 'K04.401', 'JXGJYZY', '');
INSERT INTO `05diseases` VALUES ('9750', '根尖牙周炎', '425', 'K04.501', 'GJYZY', '');
INSERT INTO `05diseases` VALUES ('9751', '根尖周肉芽肿', '295', 'K04.502', 'GJZRYZ', '');
INSERT INTO `05diseases` VALUES ('9752', '慢性根尖牙周炎', '425', 'K04.503', 'MXGJYZY', '');
INSERT INTO `05diseases` VALUES ('9753', '牙根肉芽肿', '425', 'K04.504', 'YGRYZ', '');
INSERT INTO `05diseases` VALUES ('9754', '根尖周围脓肿并脓窦', '243', 'K04.601', 'GJZWNZBND', '');
INSERT INTO `05diseases` VALUES ('9755', '根尖脓肿', '243', 'K04.701', 'GJNZ', '');
INSERT INTO `05diseases` VALUES ('9756', '根尖周脓肿', '243', 'K04.702', 'GJZNZ', '');
INSERT INTO `05diseases` VALUES ('9757', '牙槽脓肿', '425', 'K04.703', 'YCNZ', '');
INSERT INTO `05diseases` VALUES ('9758', '根端囊肿', '231', 'K04.801', 'GDNZ', '');
INSERT INTO `05diseases` VALUES ('9759', '根尖囊肿', '231', 'K04.802', 'GJNZ', '');
INSERT INTO `05diseases` VALUES ('9760', '根尖周组织疾患 NOS', '278', 'K04.951', 'GJZZZJH', '');
INSERT INTO `05diseases` VALUES ('9761', '牙髓疾患 NOS', '425', 'K04.952', 'YSJH', '');
INSERT INTO `05diseases` VALUES ('9762', '急性龈炎', '277', 'K05.001', 'JXYY', '');
INSERT INTO `05diseases` VALUES ('9763', '边缘性龈炎', '277', 'K05.101', 'BYXYY', '');
INSERT INTO `05diseases` VALUES ('9764', '增生性牙龈炎', '425', 'K05.102', 'ZSXYYY', '');
INSERT INTO `05diseases` VALUES ('9765', '化脓性牙龈炎', '425', 'K05.103', 'HNXYYY', '');
INSERT INTO `05diseases` VALUES ('9766', '溃疡性龈炎', '195', 'K05.104', 'KYXYY', '');
INSERT INTO `05diseases` VALUES ('9767', '牙龈炎', '425', 'K05.105', 'YYY', '');
INSERT INTO `05diseases` VALUES ('9768', '慢性牙龈炎', '425', 'K05.151', 'MXYYY', '');
INSERT INTO `05diseases` VALUES ('9769', '龈口炎，白色皱襞性(口腔遗传性疾病)', '193', 'K05.152', 'YKYBSZBXKQYCXJB', '');
INSERT INTO `05diseases` VALUES ('9770', '龈乳头炎', '86', 'K05.153', 'YRTY', '');
INSERT INTO `05diseases` VALUES ('9771', '剥脱性(脱屑性)龈炎', '277', 'K05.154', 'BTXTXXYY', '');
INSERT INTO `05diseases` VALUES ('9772', '急性冠周炎', '277', 'K05.201', 'JXGZY', '');
INSERT INTO `05diseases` VALUES ('9773', '牙冠周脓肿', '425', 'K05.202', 'YGZNZ', '');
INSERT INTO `05diseases` VALUES ('9774', '牙龈脓肿', '425', 'K05.203', 'YYNZ', '');
INSERT INTO `05diseases` VALUES ('9775', '牙周脓肿', '425', 'K05.204', 'YZNZ', '');
INSERT INTO `05diseases` VALUES ('9776', '牙周感染', '425', 'K05.251', 'YZGR', '');
INSERT INTO `05diseases` VALUES ('9777', '牙周炎', '425', 'K05.301', 'YZY', '');
INSERT INTO `05diseases` VALUES ('9778', '慢性牙周炎', '425', 'K05.302', 'MXYZY', '');
INSERT INTO `05diseases` VALUES ('9779', '齿槽脓溢(边缘性牙周炎)[里格斯病]', '425', 'K05.351', 'CCNYBYXYZYLGSB', '');
INSERT INTO `05diseases` VALUES ('9780', '牙周变性', '425', 'K05.451', 'YZBX', '');
INSERT INTO `05diseases` VALUES ('9781', '牙周病', '425', 'K05.501', 'YZB', '');
INSERT INTO `05diseases` VALUES ('9782', '牙创伤症(牙周创伤或咬颌创伤)', '425', 'K05.551', 'YCSZYZCSHYHCS', '');
INSERT INTO `05diseases` VALUES ('9783', '牙龈退缩', '425', 'K06.051', 'YYTS', '');
INSERT INTO `05diseases` VALUES ('9784', '牙龈增生', '425', 'K06.101', 'YYZS', '');
INSERT INTO `05diseases` VALUES ('9785', '牙龈纤维瘤病', '425', 'K06.151', 'YYXWLB', '');
INSERT INTO `05diseases` VALUES ('9786', '无牙牙槽嵴刺激性增生', '425', 'K06.251', 'WYYCJCJXZS', '');
INSERT INTO `05diseases` VALUES ('9787', '巨细胞龈瘤', '261', 'K06.801', 'JXBYL', '');
INSERT INTO `05diseases` VALUES ('9788', '牙龈出血', '425', 'K06.802', 'YYCX', '');
INSERT INTO `05diseases` VALUES ('9789', '牙龈溃疡', '425', 'K06.803', 'YYKY', '');
INSERT INTO `05diseases` VALUES ('9790', '牙龈瘤', '425', 'K06.804', 'YYL', '');
INSERT INTO `05diseases` VALUES ('9791', '牙龈瘘管', '425', 'K06.805', 'YYLG', '');
INSERT INTO `05diseases` VALUES ('9792', '牙龈息肉', '425', 'K06.806', 'YYXR', '');
INSERT INTO `05diseases` VALUES ('9793', '纤维性牙龈瘤[牙龈象皮病]', '425', 'K06.851', 'XWXYYLYYXPB', '');
INSERT INTO `05diseases` VALUES ('9794', '牙龈痛', '425', 'K06.852', 'YYT', '');
INSERT INTO `05diseases` VALUES ('9795', '牙周巨细胞性肉芽肿', '425', 'K06.853', 'YZJXBXRYZ', '');
INSERT INTO `05diseases` VALUES ('9796', '龈痛(纤维性)', '273', 'K06.951', 'YTXWX', '');
INSERT INTO `05diseases` VALUES ('9797', '颌骨发育不全', '128', 'K07.001', 'HGFYBQ', '');
INSERT INTO `05diseases` VALUES ('9798', '上颌骨纤维增生', '128', 'K07.002', 'SHGXWZS', '');
INSERT INTO `05diseases` VALUES ('9799', '小颌畸形', '148', 'K07.003', 'XHJX', '');
INSERT INTO `05diseases` VALUES ('9800', '颌骨增大症', '128', 'K07.051', 'HGZDZ', '');
INSERT INTO `05diseases` VALUES ('9801', '颌骨不对称', '128', 'K07.101', 'HGBDC', '');
INSERT INTO `05diseases` VALUES ('9802', '后缩颌(上、下颌)', '278', 'K07.102', 'HSHSXH', '');
INSERT INTO `05diseases` VALUES ('9803', '前突颌', '278', 'K07.103', 'QTH', '');
INSERT INTO `05diseases` VALUES ('9804', '上颌后缩、下颌前突', '278', 'K07.104', 'SHHSXHQT', '');
INSERT INTO `05diseases` VALUES ('9805', '上颌前突', '278', 'K07.105', 'SHQT', '');
INSERT INTO `05diseases` VALUES ('9806', '上下颌前突畸形', '148', 'K07.106', 'SXHQTJX', '');
INSERT INTO `05diseases` VALUES ('9807', '下颌前突', '278', 'K07.107', 'XHQT', '');
INSERT INTO `05diseases` VALUES ('9808', '下颌畸形', '148', 'K07.151', 'XHJX', '');
INSERT INTO `05diseases` VALUES ('9809', '反咬合', '278', 'K07.201', 'FYH', '');
INSERT INTO `05diseases` VALUES ('9810', '后牙反咬合', '425', 'K07.202', 'HYFYH', '');
INSERT INTO `05diseases` VALUES ('9811', '前牙反咬合', '425', 'K07.203', 'QYFYH', '');
INSERT INTO `05diseases` VALUES ('9812', '前牙开', '425', 'K07.204', 'QYK', '');
INSERT INTO `05diseases` VALUES ('9813', '深覆合', '278', 'K07.205', 'SFH', '');
INSERT INTO `05diseases` VALUES ('9814', '牙弓关系异常', '425', 'K07.206', 'YGGXYC', '');
INSERT INTO `05diseases` VALUES ('9815', '牙弓中线偏离', '425', 'K07.251', 'YGZXPL', '');
INSERT INTO `05diseases` VALUES ('9816', '近中合', '278', 'K07.252', 'JZH', '');
INSERT INTO `05diseases` VALUES ('9817', '下颌牙齿后部舌侧合', '425', 'K07.253', 'XHYCHBSCH', '');
INSERT INTO `05diseases` VALUES ('9818', '牙齿错位', '425', 'K07.301', 'YCCW', '');
INSERT INTO `05diseases` VALUES ('9819', '牙列不齐', '425', 'K07.302', 'YLBQ', '');
INSERT INTO `05diseases` VALUES ('9820', '牙拥挤', '425', 'K07.351', 'YYJ', '');
INSERT INTO `05diseases` VALUES ('9821', '牙扭转', '425', 'K07.352', 'YNZ', '');
INSERT INTO `05diseases` VALUES ('9822', '牙间隙异常', '425', 'K07.353', 'YJXYC', '');
INSERT INTO `05diseases` VALUES ('9823', '错齿(咬合不正)', '278', 'K07.401', 'CCYHBZ', '');
INSERT INTO `05diseases` VALUES ('9824', '舔舌、咬唇或吮指习惯引起的错合', '272', 'K07.551', 'TSYCHSZXGYQDCH', '');
INSERT INTO `05diseases` VALUES ('9825', '口呼吸引起的错合', '191', 'K07.552', 'KHXYQDCH', '');
INSERT INTO `05diseases` VALUES ('9826', '异常吞咽引起的错合', '276', 'K07.553', 'YCTYYQDCH', '');
INSERT INTO `05diseases` VALUES ('9827', '颌面异常', '278', 'K07.554', 'HMYC', '');
INSERT INTO `05diseases` VALUES ('9828', '颞颌关节综合征[颞颌关节痛与功能障碍综合征]', '123', 'K07.601', 'NHGJZHZNHGJTYGNZAZHZ', '');
INSERT INTO `05diseases` VALUES ('9829', '颞颌关节不正', '123', 'K07.602', 'NHGJBZ', '');
INSERT INTO `05diseases` VALUES ('9830', '颞下颌关节强直', '123', 'K07.603', 'NXHGJQZ', '');
INSERT INTO `05diseases` VALUES ('9831', '其他牙面畸形', '425', 'K07.851', 'QTYMJX', '');
INSERT INTO `05diseases` VALUES ('9832', '颌骨后天畸形', '148', 'K07.901', 'HGHTJX', '');
INSERT INTO `05diseases` VALUES ('9833', '颌骨畸形', '148', 'K07.902', 'HGJX', '');
INSERT INTO `05diseases` VALUES ('9834', '颌骨先天畸形', '148', 'K07.903', 'HGXTJX', '');
INSERT INTO `05diseases` VALUES ('9835', '牙面畸形 NOS', '425', 'K07.951', 'YMJX', '');
INSERT INTO `05diseases` VALUES ('9836', '全身性疾病引起的牙齿脱落', '425', 'K08.051', 'QSXJBYQDYCTL', '');
INSERT INTO `05diseases` VALUES ('9837', '后天性牙齿缺失', '425', 'K08.151', 'HTXYCQS', '');
INSERT INTO `05diseases` VALUES ('9838', '齿槽嵴萎缩', '35', 'K08.201', 'CCJWS', '');
INSERT INTO `05diseases` VALUES ('9839', '齿槽突萎缩', '35', 'K08.202', 'CCTWS', '');
INSERT INTO `05diseases` VALUES ('9840', '牙缺损牙槽嵴萎缩', '425', 'K08.251', 'YQSYCJWS', '');
INSERT INTO `05diseases` VALUES ('9841', '残冠', '278', 'K08.301', 'CG', '');
INSERT INTO `05diseases` VALUES ('9842', '残留齿根', '278', 'K08.302', 'CLCG', '');
INSERT INTO `05diseases` VALUES ('9843', '齿槽突不齐', '35', 'K08.801', 'CCTBQ', '');
INSERT INTO `05diseases` VALUES ('9844', '齿槽突裂', '35', 'K08.802', 'CCTL', '');
INSERT INTO `05diseases` VALUES ('9845', '牙槽出血', '425', 'K08.803', 'YCCX', '');
INSERT INTO `05diseases` VALUES ('9846', '牙槽嵴裂', '425', 'K08.804', 'YCJL', '');
INSERT INTO `05diseases` VALUES ('9847', '牙槽嵴裂隙', '425', 'K08.805', 'YCJLX', '');
INSERT INTO `05diseases` VALUES ('9848', '牙痛', '425', 'K08.851', 'YT', '');
INSERT INTO `05diseases` VALUES ('9849', '牙齿及支持结构的疾患 NOS', '425', 'K08.951', 'YCJZCJGDJH', '');
INSERT INTO `05diseases` VALUES ('9850', '颌含牙囊肿', '425', 'K09.001', 'HHYNZ', '');
INSERT INTO `05diseases` VALUES ('9851', '颌骨角化囊肿', '231', 'K09.002', 'HGJHNZ', '');
INSERT INTO `05diseases` VALUES ('9852', '颌角化囊肿', '231', 'K09.003', 'HJHNZ', '');
INSERT INTO `05diseases` VALUES ('9853', '颌骨始基囊肿', '231', 'K09.004', 'HGSJNZ', '');
INSERT INTO `05diseases` VALUES ('9854', '颌骨牙源性囊肿', '425', 'K09.005', 'HGYYXNZ', '');
INSERT INTO `05diseases` VALUES ('9855', '牙龈囊肿', '425', 'K09.051', 'YYNZ', '');
INSERT INTO `05diseases` VALUES ('9856', '腭骨囊肿', '231', 'K09.101', 'EGNZ', '');
INSERT INTO `05diseases` VALUES ('9857', '腭正中囊肿', '231', 'K09.102', 'EZZNZ', '');
INSERT INTO `05diseases` VALUES ('9858', '球上颌囊肿', '231', 'K09.103', 'QSHNZ', '');
INSERT INTO `05diseases` VALUES ('9859', '颌骨囊肿', '231', 'K09.201', 'HGNZ', '');
INSERT INTO `05diseases` VALUES ('9860', '上颌骨囊肿', '231', 'K09.202', 'SHGNZ', '');
INSERT INTO `05diseases` VALUES ('9861', '下颌骨囊肿', '231', 'K09.203', 'XHGNZ', '');
INSERT INTO `05diseases` VALUES ('9862', '鼻唇囊肿', '16', 'K09.801', 'BCNZ', '');
INSERT INTO `05diseases` VALUES ('9863', '口腔表皮样囊肿', '231', 'K09.802', 'KQBPYNZ', '');
INSERT INTO `05diseases` VALUES ('9864', '口腔皮样囊肿', '231', 'K09.803', 'KQPYNZ', '');
INSERT INTO `05diseases` VALUES ('9865', '口腔粘液腺囊肿', '231', 'K09.804', 'KQNYXNZ', '');
INSERT INTO `05diseases` VALUES ('9866', '爱泼斯坦小结', '278', 'K09.851', 'APSTXJ', '');
INSERT INTO `05diseases` VALUES ('9867', '颌骨非牙源性上皮样囊肿', '425', 'K09.852', 'HGFYYXSPYNZ', '');
INSERT INTO `05diseases` VALUES ('9868', '口腔囊肿 NOS', '231', 'K09.951', 'KQNZ', '');
INSERT INTO `05diseases` VALUES ('9869', '下颌隆凸', '278', 'K10.001', 'XHLT', '');
INSERT INTO `05diseases` VALUES ('9870', '斯塔夫尼囊肿', '231', 'K10.051', 'STFNNZ', '');
INSERT INTO `05diseases` VALUES ('9871', '颌的潜伏性骨囊肿', '231', 'K10.052', 'HDQFXGNZ', '');
INSERT INTO `05diseases` VALUES ('9872', '颌骨恶性肉芽肿', '295', 'K10.101', 'HGEXRYZ', '');
INSERT INTO `05diseases` VALUES ('9873', '颌骨肉芽肿', '295', 'K10.102', 'HGRYZ', '');
INSERT INTO `05diseases` VALUES ('9874', '颌下区肉芽肿', '295', 'K10.103', 'HXQRYZ', '');
INSERT INTO `05diseases` VALUES ('9875', '巨细胞肉芽肿', '295', 'K10.151', 'JXBRYZ', '');
INSERT INTO `05diseases` VALUES ('9876', '颌骨放射性骨髓炎', '114', 'K10.201', 'HGFSXGSY', '');
INSERT INTO `05diseases` VALUES ('9877', '颌骨骨髓炎', '114', 'K10.202', 'HGGSY', '');
INSERT INTO `05diseases` VALUES ('9878', '颌骨骨炎', '115', 'K10.203', 'HGGY', '');
INSERT INTO `05diseases` VALUES ('9879', '颌骨慢性炎症', '128', 'K10.204', 'HGMXYZ', '');
INSERT INTO `05diseases` VALUES ('9880', '颌骨死骨', '128', 'K10.205', 'HGSG', '');
INSERT INTO `05diseases` VALUES ('9881', '颌骨炎性增生', '115', 'K10.206', 'HGYXZS', '');
INSERT INTO `05diseases` VALUES ('9882', '化脓性颌骨骨髓炎', '114', 'K10.251', 'HNXHGGSY', '');
INSERT INTO `05diseases` VALUES ('9883', '婴儿急性上颌窦骨髓炎', '114', 'K10.252', 'YEJXSHDGSY', '');
INSERT INTO `05diseases` VALUES ('9884', '齿槽骨炎', '115', 'K10.301', 'CCGY', '');
INSERT INTO `05diseases` VALUES ('9885', '干槽(症)', '278', 'K10.302', 'GCZ', '');
INSERT INTO `05diseases` VALUES ('9886', '腭后天畸形', '148', 'K10.801', 'EHTJX', '');
INSERT INTO `05diseases` VALUES ('9887', '腭血肿', '422', 'K10.802', 'EXZ', '');
INSERT INTO `05diseases` VALUES ('9888', '颌骨纤维性发育不良', '74', 'K10.803', 'HGXWXFYBL', '');
INSERT INTO `05diseases` VALUES ('9889', '颌部瘤样纤维组织增生', '261', 'K10.804', 'HBLYXWZZZS', '');
INSERT INTO `05diseases` VALUES ('9890', '颌骨骨纤维异样增殖', '128', 'K10.805', 'HGGXWYYZZ', '');
INSERT INTO `05diseases` VALUES ('9891', '颌骨骨质增生', '128', 'K10.806', 'HGGZZS', '');
INSERT INTO `05diseases` VALUES ('9892', '上腭穿孔', '278', 'K10.807', 'SECK', '');
INSERT INTO `05diseases` VALUES ('9893', '颌骨外生骨疣', '453', 'K10.851', 'HGWSGY', '');
INSERT INTO `05diseases` VALUES ('9894', '颌骨肿物', '128', 'K10.901', 'HGZW', '');
INSERT INTO `05diseases` VALUES ('9895', '颌的疾病 NOS', '268', 'K10.951', 'HDJB', '');
INSERT INTO `05diseases` VALUES ('9896', '涎腺萎缩', '278', 'K11.001', 'XXWS', '');
INSERT INTO `05diseases` VALUES ('9897', '颌下腺肥大', '129', 'K11.101', 'HXXFD', '');
INSERT INTO `05diseases` VALUES ('9898', '颌下腺良性增生', '129', 'K11.102', 'HXXLXZS', '');
INSERT INTO `05diseases` VALUES ('9899', '腮腺肥大', '278', 'K11.103', 'SXFD', '');
INSERT INTO `05diseases` VALUES ('9900', '涎腺肥大', '278', 'K11.104', 'XXFD', '');
INSERT INTO `05diseases` VALUES ('9901', '非流行性腮腺炎性假瘤', '302', 'K11.201', 'FLXXSXYXJL', '');
INSERT INTO `05diseases` VALUES ('9902', '颌下腺炎', '129', 'K11.202', 'HXXY', '');
INSERT INTO `05diseases` VALUES ('9903', '化脓性腮腺炎', '302', 'K11.203', 'HNXSXY', '');
INSERT INTO `05diseases` VALUES ('9904', '急性化脓性腮腺炎', '302', 'K11.204', 'JXHNXSXY', '');
INSERT INTO `05diseases` VALUES ('9905', '急性腮腺炎', '302', 'K11.205', 'JXSXY', '');
INSERT INTO `05diseases` VALUES ('9906', '慢性颌下腺炎', '129', 'K11.206', 'MXHXXY', '');
INSERT INTO `05diseases` VALUES ('9907', '慢性腮腺炎', '302', 'K11.207', 'MXSXY', '');
INSERT INTO `05diseases` VALUES ('9908', '慢性舌下腺炎', '272', 'K11.208', 'MXSXXY', '');
INSERT INTO `05diseases` VALUES ('9909', '慢性涎腺炎', '277', 'K11.209', 'MXXXY', '');
INSERT INTO `05diseases` VALUES ('9910', '涎腺炎', '277', 'K11.210', 'XXY', '');
INSERT INTO `05diseases` VALUES ('9911', '腮腺脓肿', '243', 'K11.301', 'SXNZ', '');
INSERT INTO `05diseases` VALUES ('9912', '颌下腺脓肿', '243', 'K11.351', 'HXXNZ', '');
INSERT INTO `05diseases` VALUES ('9913', '颌下腺瘘', '212', 'K11.401', 'HXXL', '');
INSERT INTO `05diseases` VALUES ('9914', '腮腺瘘', '212', 'K11.402', 'SXL', '');
INSERT INTO `05diseases` VALUES ('9915', '涎腺瘘管', '212', 'K11.403', 'XXLG', '');
INSERT INTO `05diseases` VALUES ('9916', '颌下腺导管结石(涎石症)', '129', 'K11.501', 'HXXDGJSXSZ', '');
INSERT INTO `05diseases` VALUES ('9917', '腮腺导管结石', '278', 'K11.502', 'SXDGJS', '');
INSERT INTO `05diseases` VALUES ('9918', '舌下管结石', '272', 'K11.503', 'SXGJS', '');
INSERT INTO `05diseases` VALUES ('9919', '颌下腺导管结石(病)', '129', 'K11.551', 'HXXDGJSB', '');
INSERT INTO `05diseases` VALUES ('9920', '涎石病', '268', 'K11.552', 'XSB', '');
INSERT INTO `05diseases` VALUES ('9921', '斯滕森管结石[下颌腺管]', '278', 'K11.553', 'STSGJSXHXG', '');
INSERT INTO `05diseases` VALUES ('9922', '颌下腺囊肿', '231', 'K11.601', 'HXXNZ', '');
INSERT INTO `05diseases` VALUES ('9923', '颌下腺粘液囊肿', '231', 'K11.602', 'HXXNYNZ', '');
INSERT INTO `05diseases` VALUES ('9924', '腮腺囊肿', '231', 'K11.603', 'SXNZ', '');
INSERT INTO `05diseases` VALUES ('9925', '舌下腺囊肿', '231', 'K11.604', 'SXXNZ', '');
INSERT INTO `05diseases` VALUES ('9926', '涎腺粘液腺囊肿', '231', 'K11.605', 'XXNYXNZ', '');
INSERT INTO `05diseases` VALUES ('9927', '口干症', '191', 'K11.701', 'KGZ', '');
INSERT INTO `05diseases` VALUES ('9928', '唾液潴留', '278', 'K11.751', 'TYZL', '');
INSERT INTO `05diseases` VALUES ('9929', '米库利奇病', '268', 'K11.801', 'MKLQB', '');
INSERT INTO `05diseases` VALUES ('9930', '腮腺涎液潴留', '278', 'K11.802', 'SXXYZL', '');
INSERT INTO `05diseases` VALUES ('9931', '腮腺脂肪浸润', '278', 'K11.803', 'SXZFJR', '');
INSERT INTO `05diseases` VALUES ('9932', '涎腺管扩张', '278', 'K11.804', 'XXGKZ', '');
INSERT INTO `05diseases` VALUES ('9933', '涎腺良性淋巴上皮损害', '205', 'K11.805', 'XXLXLBSPSH', '');
INSERT INTO `05diseases` VALUES ('9934', '颌下腺梗阻', '129', 'K11.851', 'HXXGZ', '');
INSERT INTO `05diseases` VALUES ('9935', '腮腺导管断裂', '278', 'K11.852', 'SXDGDL', '');
INSERT INTO `05diseases` VALUES ('9936', '颌下肿物', '129', 'K11.901', 'HXZW', '');
INSERT INTO `05diseases` VALUES ('9937', '腮腺区肿物', '278', 'K11.902', 'SXQZW', '');
INSERT INTO `05diseases` VALUES ('9938', '涎腺肿物', '278', 'K11.903', 'XXZW', '');
INSERT INTO `05diseases` VALUES ('9939', '涎腺病', '268', 'K11.951', 'XXB', '');
INSERT INTO `05diseases` VALUES ('9940', '轻型[阿弗他]口疮', '43', 'K12.001', 'QXAFTKC', '');
INSERT INTO `05diseases` VALUES ('9941', '复发性阿弗他(口腔)溃疡', '195', 'K12.002', 'FFXAFTKQKY', '');
INSERT INTO `05diseases` VALUES ('9942', '口疮', '43', 'K12.003', 'KC', '');
INSERT INTO `05diseases` VALUES ('9943', '口疮性咽峡炎', '428', 'K12.004', 'KCXYXY', '');
INSERT INTO `05diseases` VALUES ('9944', '疱疹样口炎', '248', 'K12.005', 'PZYKY', '');
INSERT INTO `05diseases` VALUES ('9945', '复发性口炎', '193', 'K12.051', 'FFXKY', '');
INSERT INTO `05diseases` VALUES ('9946', '阿弗他口炎', '193', 'K12.052', 'AFTKY', '');
INSERT INTO `05diseases` VALUES ('9947', '腺周口疮[复发性坏死性粘膜腺周围炎]', '43', 'K12.053', 'XZKCFFXHSXNMXZWY', '');
INSERT INTO `05diseases` VALUES ('9948', '腭部溃疡', '195', 'K12.101', 'EBKY', '');
INSERT INTO `05diseases` VALUES ('9949', '过敏性口炎', '193', 'K12.102', 'GMXKY', '');
INSERT INTO `05diseases` VALUES ('9950', '口腔感染', '95', 'K12.103', 'KQGR', '');
INSERT INTO `05diseases` VALUES ('9951', '口腔炎性肿块', '192', 'K12.104', 'KQYXZK', '');
INSERT INTO `05diseases` VALUES ('9952', '口腔炎', '192', 'K12.106', 'KQY', '');
INSERT INTO `05diseases` VALUES ('9953', '溃疡性口炎', '193', 'K12.107', 'KYXKY', '');
INSERT INTO `05diseases` VALUES ('9954', '上腭炎性肿物', '277', 'K12.108', 'SEYXZW', '');
INSERT INTO `05diseases` VALUES ('9955', '接触性口炎', '193', 'K12.151', 'JCXKY', '');
INSERT INTO `05diseases` VALUES ('9956', '膜性[球菌性口炎]口炎', '193', 'K12.152', 'MXQJXKYKY', '');
INSERT INTO `05diseases` VALUES ('9957', '烟草性口炎', '193', 'K12.153', 'YCXKY', '');
INSERT INTO `05diseases` VALUES ('9958', '药物性口炎', '193', 'K12.154', 'YWXKY', '');
INSERT INTO `05diseases` VALUES ('9959', '义齿性口炎', '193', 'K12.155', 'YCXKY', '');
INSERT INTO `05diseases` VALUES ('9960', '小泡性口炎', '193', 'K12.156', 'XPXKY', '');
INSERT INTO `05diseases` VALUES ('9961', '颌面间隙感染', '95', 'K12.201', 'HMJXGR', '');
INSERT INTO `05diseases` VALUES ('9962', '颌下感染(间隙)', '95', 'K12.202', 'HXGRJX', '');
INSERT INTO `05diseases` VALUES ('9963', '颌下瘘管', '212', 'K12.203', 'HXLG', '');
INSERT INTO `05diseases` VALUES ('9964', '颌下区感染', '95', 'K12.204', 'HXQGR', '');
INSERT INTO `05diseases` VALUES ('9965', '颌下区瘘', '212', 'K12.205', 'HXQL', '');
INSERT INTO `05diseases` VALUES ('9966', '颊部瘘管', '212', 'K12.206', 'JBLG', '');
INSERT INTO `05diseases` VALUES ('9967', '颊间隙感染', '95', 'K12.207', 'JJXGR', '');
INSERT INTO `05diseases` VALUES ('9968', '嚼肌间隙感染', '95', 'K12.208', 'JJJXGR', '');
INSERT INTO `05diseases` VALUES ('9969', '颏下区感染', '95', 'K12.209', 'KXQGR', '');
INSERT INTO `05diseases` VALUES ('9970', '口底蜂窝织炎', '83', 'K12.210', 'KDFWZY', '');
INSERT INTO `05diseases` VALUES ('9971', '口腔瘘管', '212', 'K12.211', 'KQLG', '');
INSERT INTO `05diseases` VALUES ('9972', '口腔内脓肿', '243', 'K12.212', 'KQNNZ', '');
INSERT INTO `05diseases` VALUES ('9973', '眶下间隙感染', '95', 'K12.213', 'KXJXGR', '');
INSERT INTO `05diseases` VALUES ('9974', '颞间隙感染', '95', 'K12.214', 'NJXGR', '');
INSERT INTO `05diseases` VALUES ('9975', '牙源性面部皮肤瘘管', '425', 'K12.215', 'YYXMBPFLG', '');
INSERT INTO `05diseases` VALUES ('9976', '舌下间隙感染', '95', 'K12.251', 'SXJXGR', '');
INSERT INTO `05diseases` VALUES ('9977', '路德维希绞痛', '273', 'K12.252', 'LDWXJT', '');
INSERT INTO `05diseases` VALUES ('9978', '颌下蜂窝织炎', '83', 'K12.253', 'HXFWZY', '');
INSERT INTO `05diseases` VALUES ('9979', '传染性口角炎', '191', 'K13.001', 'CRXKJY', '');
INSERT INTO `05diseases` VALUES ('9980', '唇部肿物', '278', 'K13.002', 'CBZW', '');
INSERT INTO `05diseases` VALUES ('9981', '唇肥厚', '278', 'K13.003', 'CFH', '');
INSERT INTO `05diseases` VALUES ('9982', '唇蜂窝织炎', '83', 'K13.004', 'CFWZY', '');
INSERT INTO `05diseases` VALUES ('9983', '唇畸形', '148', 'K13.005', 'CJX', '');
INSERT INTO `05diseases` VALUES ('9984', '唇后天畸形', '148', 'K13.006', 'CHTJX', '');
INSERT INTO `05diseases` VALUES ('9985', '唇桨细胞性肉芽肿', '295', 'K13.007', 'CJXBXRYZ', '');
INSERT INTO `05diseases` VALUES ('9986', '唇皲裂', '278', 'K13.008', 'CJL', '');
INSERT INTO `05diseases` VALUES ('9987', '唇鳞状上皮增生', '278', 'K13.009', 'CLZSPZS', '');
INSERT INTO `05diseases` VALUES ('9988', '唇瘘', '212', 'K13.010', 'CL', '');
INSERT INTO `05diseases` VALUES ('9989', '唇囊肿', '231', 'K13.011', 'CNZ', '');
INSERT INTO `05diseases` VALUES ('9990', '唇疼', '278', 'K13.012', 'CT', '');
INSERT INTO `05diseases` VALUES ('9991', '唇炎', '277', 'K13.013', 'CY', '');
INSERT INTO `05diseases` VALUES ('9992', '唇粘液囊肿', '231', 'K13.014', 'CNYNZ', '');
INSERT INTO `05diseases` VALUES ('9993', '口角炎', '191', 'K13.015', 'KJY', '');
INSERT INTO `05diseases` VALUES ('9994', '烧伤后唇畸形', '309', 'K13.016', 'SSHCJX', '');
INSERT INTO `05diseases` VALUES ('9995', '巨口疮[腺周口疮]', '43', 'K13.051', 'JKCXZKC', '');
INSERT INTO `05diseases` VALUES ('9996', '感染性口角炎', '95', 'K13.052', 'GRXKJY', '');
INSERT INTO `05diseases` VALUES ('9997', '脓肿性腺性唇炎[贝尔茨氏病]', '243', 'K13.053', 'NZXXXCYBECSB', '');
INSERT INTO `05diseases` VALUES ('9998', '肉芽肿性唇炎[肥大性唇炎或巨口]', '295', 'K13.054', 'RYZXCYFDXCYHJK', '');
INSERT INTO `05diseases` VALUES ('9999', '唇周溃疡', '195', 'K13.055', 'CZKY', '');
INSERT INTO `05diseases` VALUES ('10000', '颊或唇咬伤', '431', 'K13.151', 'JHCYS', '');
INSERT INTO `05diseases` VALUES ('10001', '腭白斑', '250', 'K13.201', 'EBB', '');
INSERT INTO `05diseases` VALUES ('10002', '口腔粘膜白斑症', '250', 'K13.202', 'KQNMBBZ', '');
INSERT INTO `05diseases` VALUES ('10003', '舌白斑', '250', 'K13.203', 'SBB', '');
INSERT INTO `05diseases` VALUES ('10004', '毛状白斑', '250', 'K13.351', 'MZBB', '');
INSERT INTO `05diseases` VALUES ('10005', '口腔粘膜恶性肉芽肿', '295', 'K13.401', 'KQNMEXRYZ', '');
INSERT INTO `05diseases` VALUES ('10006', '口腔粘膜肉芽肿', '295', 'K13.402', 'KQNMRYZ', '');
INSERT INTO `05diseases` VALUES ('10007', '口腔粘膜的疣状黄瘤', '453', 'K13.451', 'KQNMDYZHL', '');
INSERT INTO `05diseases` VALUES ('10008', '口腔粘膜的嗜酸性肉芽肿', '295', 'K13.452', 'KQNMDSSXRYZ', '');
INSERT INTO `05diseases` VALUES ('10009', '口腔粘膜纤维变性', '191', 'K13.501', 'KQNMXWBX', '');
INSERT INTO `05diseases` VALUES ('10010', '舌淋巴纤维组织增殖', '272', 'K13.551', 'SLBXWZZZZ', '');
INSERT INTO `05diseases` VALUES ('10011', '舌粘膜下纤维变性', '272', 'K13.552', 'SNMXXWBX', '');
INSERT INTO `05diseases` VALUES ('10012', '腭增生症', '278', 'K13.601', 'EZSZ', '');
INSERT INTO `05diseases` VALUES ('10013', '颊部炎性增生', '277', 'K13.602', 'JBYXZS', '');
INSERT INTO `05diseases` VALUES ('10014', '口腔粘膜增生', '191', 'K13.603', 'KQNMZS', '');
INSERT INTO `05diseases` VALUES ('10015', '口腔粘膜刺激性增生', '191', 'K13.651', 'KQNMCJXZS', '');
INSERT INTO `05diseases` VALUES ('10016', '腭部疤痕组织', '278', 'K13.701', 'EBBHZZ', '');
INSERT INTO `05diseases` VALUES ('10017', '腭粘膜息肉', '374', 'K13.702', 'ENMXR', '');
INSERT INTO `05diseases` VALUES ('10018', '腭粘膜炎症', '277', 'K13.703', 'ENMYZ', '');
INSERT INTO `05diseases` VALUES ('10019', '颊沟后天畸形', '148', 'K13.704', 'JGHTJX', '');
INSERT INTO `05diseases` VALUES ('10020', '后天性小口畸形', '148', 'K13.705', 'HTXXKJX', '');
INSERT INTO `05diseases` VALUES ('10021', '颊部炎性假瘤', '261', 'K13.706', 'JBYXJL', '');
INSERT INTO `05diseases` VALUES ('10022', '颊部炎症', '277', 'K13.707', 'JBYZ', '');
INSERT INTO `05diseases` VALUES ('10023', '颊粘膜脓肿', '243', 'K13.708', 'JNMNZ', '');
INSERT INTO `05diseases` VALUES ('10024', '颊粘膜下慢性炎症', '277', 'K13.709', 'JNMXMXYZ', '');
INSERT INTO `05diseases` VALUES ('10025', '口腔内血管增生', '191', 'K13.710', 'KQNXGZS', '');
INSERT INTO `05diseases` VALUES ('10026', '口腔粘膜出血', '191', 'K13.711', 'KQNMCX', '');
INSERT INTO `05diseases` VALUES ('10027', '口腔肿物', '191', 'K13.712', 'KQZW', '');
INSERT INTO `05diseases` VALUES ('10028', '软腭肿瘤放疗后畸形', '473', 'K13.713', 'REZLFLHJX', '');
INSERT INTO `05diseases` VALUES ('10029', '烧伤后小口畸形', '309', 'K13.714', 'SSHXKJX', '');
INSERT INTO `05diseases` VALUES ('10030', '下颌前庭沟过浅', '278', 'K13.715', 'XHQTGGQ', '');
INSERT INTO `05diseases` VALUES ('10031', '悬雍垂肥大', '278', 'K13.716', 'XYCFD', '');
INSERT INTO `05diseases` VALUES ('10032', '悬雍垂息肉', '374', 'K13.717', 'XYCXR', '');
INSERT INTO `05diseases` VALUES ('10033', '翼钩过长', '278', 'K13.718', 'YGGC', '');
INSERT INTO `05diseases` VALUES ('10034', '悬雍垂囊肿', '231', 'K13.719', 'XYCNZ', '');
INSERT INTO `05diseases` VALUES ('10035', '口后天畸形', '148', 'K13.751', 'KHTJX', '');
INSERT INTO `05diseases` VALUES ('10036', '复发性口腔溃疡', '195', 'K13.752', 'FFXKQKY', '');
INSERT INTO `05diseases` VALUES ('10037', '口腔粘膜病', '191', 'K13.753', 'KQNMB', '');
INSERT INTO `05diseases` VALUES ('10038', '口腔粘膜溃疡', '195', 'K13.754', 'KQNMKY', '');
INSERT INTO `05diseases` VALUES ('10039', '口腔粘膜良性过度角化病[口腔厚上症]', '191', 'K13.755', 'KQNMLXGDJHBKQHSZ', '');
INSERT INTO `05diseases` VALUES ('10040', '口腔粘膜血肿[创伤性血肿]', '422', 'K13.756', 'KQNMXZCSXXZ', '');
INSERT INTO `05diseases` VALUES ('10041', '软腭麻痹', '217', 'K13.757', 'REMB', '');
INSERT INTO `05diseases` VALUES ('10042', '后天性悬壅垂过长', '278', 'K13.758', 'HTXXYCGC', '');
INSERT INTO `05diseases` VALUES ('10043', '舌溃疡', '195', 'K14.001', 'SKY', '');
INSERT INTO `05diseases` VALUES ('10044', '舌脓肿', '243', 'K14.002', 'SNZ', '');
INSERT INTO `05diseases` VALUES ('10045', '舌乳突炎', '297', 'K14.003', 'SRTY', '');
INSERT INTO `05diseases` VALUES ('10046', '舌炎', '310', 'K14.004', 'SY', '');
INSERT INTO `05diseases` VALUES ('10047', '舌炎性肿块', '310', 'K14.005', 'SYXZK', '');
INSERT INTO `05diseases` VALUES ('10048', '舌下感染', '95', 'K14.051', 'SXGR', '');
INSERT INTO `05diseases` VALUES ('10049', '默勒舌炎[慢性舌乳头炎]', '86', 'K14.052', 'MLSYMXSRTY', '');
INSERT INTO `05diseases` VALUES ('10050', '地图舌', '272', 'K14.101', 'DTS', '');
INSERT INTO `05diseases` VALUES ('10051', '移行性舌炎', '310', 'K14.102', 'YXXSY', '');
INSERT INTO `05diseases` VALUES ('10052', '局限性剥脱性舌炎', '310', 'K14.151', 'JXXBTXSY', '');
INSERT INTO `05diseases` VALUES ('10053', '良性游走性舌炎', '310', 'K14.152', 'LXYZXSY', '');
INSERT INTO `05diseases` VALUES ('10054', '正中菱形舌炎', '310', 'K14.251', 'ZZLXSY', '');
INSERT INTO `05diseases` VALUES ('10055', '黑毛舌', '272', 'K14.301', 'HMS', '');
INSERT INTO `05diseases` VALUES ('10056', '舌乳头肥大', '86', 'K14.351', 'SRTFD', '');
INSERT INTO `05diseases` VALUES ('10057', '舌苔', '272', 'K14.352', 'ST', '');
INSERT INTO `05diseases` VALUES ('10058', '舌乳头萎缩', '86', 'K14.401', 'SRTWS', '');
INSERT INTO `05diseases` VALUES ('10059', '萎缩性舌炎', '310', 'K14.402', 'WSXSY', '');
INSERT INTO `05diseases` VALUES ('10060', '裂缝舌', '272', 'K14.501', 'LFS', '');
INSERT INTO `05diseases` VALUES ('10061', '舌痛', '273', 'K14.601', 'ST', '');
INSERT INTO `05diseases` VALUES ('10062', '舌出血', '38', 'K14.801', 'SCX', '');
INSERT INTO `05diseases` VALUES ('10063', '舌肥大(后天性巨舌症)', '272', 'K14.802', 'SFDHTXJSZ', '');
INSERT INTO `05diseases` VALUES ('10064', '舌尖瘘管', '212', 'K14.803', 'SJLG', '');
INSERT INTO `05diseases` VALUES ('10065', '舌良性过度角化症', '272', 'K14.804', 'SLXGDJHZ', '');
INSERT INTO `05diseases` VALUES ('10066', '舌淋巴组织增生', '272', 'K14.805', 'SLBZZZS', '');
INSERT INTO `05diseases` VALUES ('10067', '舌鳞状上皮增生', '272', 'K14.806', 'SLZSPZS', '');
INSERT INTO `05diseases` VALUES ('10068', '舌囊肿', '231', 'K14.807', 'SNZ', '');
INSERT INTO `05diseases` VALUES ('10069', '舌肉芽肿', '295', 'K14.808', 'SRYZ', '');
INSERT INTO `05diseases` VALUES ('10070', '舌萎缩', '272', 'K14.809', 'SWS', '');
INSERT INTO `05diseases` VALUES ('10071', '舌异物', '272', 'K14.810', 'SYW', '');
INSERT INTO `05diseases` VALUES ('10072', '舌下囊肿', '231', 'K14.851', 'SXNZ', '');
INSERT INTO `05diseases` VALUES ('10073', '舌肿物', '272', 'K14.901', 'SZW', '');
INSERT INTO `05diseases` VALUES ('10074', '舌疾病', '272', 'K14.951', 'SJB', '');
INSERT INTO `05diseases` VALUES ('10075', '贲门炎', '15', 'K20.X01', 'BMY', '');
INSERT INTO `05diseases` VALUES ('10076', '出血性食管炎', '38', 'K20.X02', 'CXXSGY', '');
INSERT INTO `05diseases` VALUES ('10077', '创伤性食管炎', '44', 'K20.X03', 'CSXSGY', '');
INSERT INTO `05diseases` VALUES ('10078', '化学性食管炎', '323', 'K20.X04', 'HXXSGY', '');
INSERT INTO `05diseases` VALUES ('10079', '慢性食管炎', '323', 'K20.X05', 'MXSGY', '');
INSERT INTO `05diseases` VALUES ('10080', '食管炎(急性)(慢性)(碱性)', '323', 'K20.X06', 'SGYJXMXJX', '');
INSERT INTO `05diseases` VALUES ('10081', '手术后食管炎', '330', 'K20.X07', 'SSHSGY', '');
INSERT INTO `05diseases` VALUES ('10082', '食管脓肿', '243', 'K20.X51', 'SGNZ', '');
INSERT INTO `05diseases` VALUES ('10083', '剥脱性表浅性食管炎', '323', 'K20.X52', 'BTXBQXSGY', '');
INSERT INTO `05diseases` VALUES ('10084', '表层脱落性食管炎[蜂窝组织炎性食管炎]', '323', 'K20.X53', 'BCTLXSGYFWZZYXSGY', '');
INSERT INTO `05diseases` VALUES ('10085', '肉芽肿性食管炎', '295', 'K20.X54', 'RYZXSGY', '');
INSERT INTO `05diseases` VALUES ('10086', '反流性食管炎', '323', 'K21.001', 'FLXSGY', '');
INSERT INTO `05diseases` VALUES ('10087', '贲门松驰', '15', 'K21.901', 'BMSC', '');
INSERT INTO `05diseases` VALUES ('10088', '食管返流', '323', 'K21.902', 'SGFL', '');
INSERT INTO `05diseases` VALUES ('10089', '贲门失弛缓(贲门痉挛)', '179', 'K22.001', 'BMSCHBMJL', '');
INSERT INTO `05diseases` VALUES ('10090', '贲门口糜烂', '191', 'K22.101', 'BMKML', '');
INSERT INTO `05diseases` VALUES ('10091', '贲门溃疡', '195', 'K22.102', 'BMKY', '');
INSERT INTO `05diseases` VALUES ('10092', '糜烂性食道炎', '322', 'K22.103', 'MLXSDY', '');
INSERT INTO `05diseases` VALUES ('10093', '食管溃疡', '195', 'K22.104', 'SGKY', '');
INSERT INTO `05diseases` VALUES ('10094', '食管糜烂', '323', 'K22.105', 'SGML', '');
INSERT INTO `05diseases` VALUES ('10095', '贲门溃疡伴急性出血', '195', 'K22.151', 'BMKYBJXCX', '');
INSERT INTO `05diseases` VALUES ('10096', '巴雷特溃疡', '195', 'K22.152', 'BLTKY', '');
INSERT INTO `05diseases` VALUES ('10097', '贲门梗阻', '15', 'K22.201', 'BMGZ', '');
INSERT INTO `05diseases` VALUES ('10098', '创伤性食管狭窄', '44', 'K22.202', 'CSXSGXZ', '');
INSERT INTO `05diseases` VALUES ('10099', '后天性食管狭窄', '323', 'K22.203', 'HTXSGXZ', '');
INSERT INTO `05diseases` VALUES ('10100', '食管梗阻', '323', 'K22.204', 'SGGZ', '');
INSERT INTO `05diseases` VALUES ('10101', '食管受压', '323', 'K22.205', 'SGSY', '');
INSERT INTO `05diseases` VALUES ('10102', '食管狭窄', '323', 'K22.206', 'SGXZ', '');
INSERT INTO `05diseases` VALUES ('10103', '手术后食道狭窄', '330', 'K22.207', 'SSHSDXZ', '');
INSERT INTO `05diseases` VALUES ('10104', '食管挛缩', '323', 'K22.251', 'SGLS', '');
INSERT INTO `05diseases` VALUES ('10105', '食管穿孔', '323', 'K22.301', 'SGCK', '');
INSERT INTO `05diseases` VALUES ('10106', '食管运动障碍', '323', 'K22.401', 'SGYDZA', '');
INSERT INTO `05diseases` VALUES ('10107', '原发性弥漫性食管痉挛', '179', 'K22.451', 'YFXMMXSGJL', '');
INSERT INTO `05diseases` VALUES ('10108', '食管痉挛', '179', 'K22.452', 'SGJL', '');
INSERT INTO `05diseases` VALUES ('10109', '后天性食管憩室', '323', 'K22.501', 'HTXSGQS', '');
INSERT INTO `05diseases` VALUES ('10110', '食管憩室', '323', 'K22.502', 'SGQS', '');
INSERT INTO `05diseases` VALUES ('10111', '马洛里-韦斯氏综合征[食管贲门粘膜裂伤]', '201', 'K22.601', 'MLLWSSZHZSGBMNMLS', '');
INSERT INTO `05diseases` VALUES ('10112', '食管肠上皮化生', '323', 'K22.801', 'SGCSPHS', '');
INSERT INTO `05diseases` VALUES ('10113', '食管出血', '38', 'K22.802', 'SGCX', '');
INSERT INTO `05diseases` VALUES ('10114', '食管肌性肥厚', '323', 'K22.803', 'SGJXFH', '');
INSERT INTO `05diseases` VALUES ('10115', '食管克隆氏病', '323', 'K22.804', 'SGKLSB', '');
INSERT INTO `05diseases` VALUES ('10116', '食管扩张', '323', 'K22.805', 'SGKZ', '');
INSERT INTO `05diseases` VALUES ('10117', '食管瘘', '212', 'K22.806', 'SGL', '');
INSERT INTO `05diseases` VALUES ('10118', '食管囊肿', '231', 'K22.807', 'SGNZ', '');
INSERT INTO `05diseases` VALUES ('10119', '食管息肉', '374', 'K22.808', 'SGXR', '');
INSERT INTO `05diseases` VALUES ('10120', '食管粘膜不典型增生', '323', 'K22.809', 'SGNMBDXZS', '');
INSERT INTO `05diseases` VALUES ('10121', '手术后食管瘘', '330', 'K22.810', 'SSHSGL', '');
INSERT INTO `05diseases` VALUES ('10122', '食道白斑', '250', 'K22.851', 'SDBB', '');
INSERT INTO `05diseases` VALUES ('10123', '食道功能不全', '322', 'K22.901', 'SDGNBQ', '');
INSERT INTO `05diseases` VALUES ('10124', '食管肿物', '323', 'K22.902', 'SGZW', '');
INSERT INTO `05diseases` VALUES ('10125', '急性胃溃疡伴出血', '370', 'K25.001', 'JXWKYBCX', '');
INSERT INTO `05diseases` VALUES ('10126', '急性胃粘膜病变伴出血', '370', 'K25.002', 'JXWNMBBBCX', '');
INSERT INTO `05diseases` VALUES ('10127', '迪厄拉富瓦溃疡[胃浅表性溃疡]', '370', 'K25.051', 'DELFWKYWQBXKY', '');
INSERT INTO `05diseases` VALUES ('10128', '急性胃溃疡伴穿孔', '370', 'K25.101', 'JXWKYBCK', '');
INSERT INTO `05diseases` VALUES ('10129', '急性胃穿孔', '370', 'K25.151', 'JXWCK', '');
INSERT INTO `05diseases` VALUES ('10130', '急性胃溃疡伴出血和穿孔', '370', 'K25.201', 'JXWKYBCXHCK', '');
INSERT INTO `05diseases` VALUES ('10131', '急性胃溃疡', '370', 'K25.301', 'JXWKY', '');
INSERT INTO `05diseases` VALUES ('10132', '急性糜烂性胃炎', '371', 'K25.351', 'JXMLXWY', '');
INSERT INTO `05diseases` VALUES ('10133', '胃溃疡伴出血', '370', 'K25.401', 'WKYBCX', '');
INSERT INTO `05diseases` VALUES ('10134', '幽门溃疡伴出血', '195', 'K25.402', 'YMKYBCX', '');
INSERT INTO `05diseases` VALUES ('10135', '胃溃疡伴穿孔', '370', 'K25.501', 'WKYBCK', '');
INSERT INTO `05diseases` VALUES ('10136', '幽门穿孔', '452', 'K25.502', 'YMCK', '');
INSERT INTO `05diseases` VALUES ('10137', '幽门溃疡伴穿孔', '195', 'K25.551', 'YMKYBCK', '');
INSERT INTO `05diseases` VALUES ('10138', '胃溃疡穿孔', '370', 'K25.552', 'WKYCK', '');
INSERT INTO `05diseases` VALUES ('10139', '胃溃疡穿孔伴腹膜炎', '370', 'K25.553', 'WKYCKBFMY', '');
INSERT INTO `05diseases` VALUES ('10140', '慢性胃溃疡', '370', 'K25.701', 'MXWKY', '');
INSERT INTO `05diseases` VALUES ('10141', '残胃溃疡', '370', 'K25.901', 'CWKY', '');
INSERT INTO `05diseases` VALUES ('10142', '胃溃疡', '370', 'K25.903', 'WKY', '');
INSERT INTO `05diseases` VALUES ('10143', '胃溃疡型假性淋巴瘤', '370', 'K25.904', 'WKYXJXLBL', '');
INSERT INTO `05diseases` VALUES ('10144', '幽门管溃疡', '195', 'K25.905', 'YMGKY', '');
INSERT INTO `05diseases` VALUES ('10145', '应激性胃溃疡', '370', 'K25.906', 'YJXWKY', '');
INSERT INTO `05diseases` VALUES ('10146', '胃小弯溃疡', '370', 'K25.951', 'WXWKY', '');
INSERT INTO `05diseases` VALUES ('10147', '急性十二指肠溃疡伴出血', '321', 'K26.001', 'JXSEZCKYBCX', '');
INSERT INTO `05diseases` VALUES ('10148', '急性十二指肠球部溃疡并出血', '321', 'K26.002', 'JXSEZCQBKYBCX', '');
INSERT INTO `05diseases` VALUES ('10149', '急性十二指肠溃疡伴穿孔', '321', 'K26.101', 'JXSEZCKYBCK', '');
INSERT INTO `05diseases` VALUES ('10150', '急性十二指肠溃疡伴出血和穿孔', '321', 'K26.201', 'JXSEZCKYBCXHCK', '');
INSERT INTO `05diseases` VALUES ('10151', '急性十二指肠溃疡', '321', 'K26.301', 'JXSEZCKY', '');
INSERT INTO `05diseases` VALUES ('10152', '十二指肠球部溃疡伴出血', '321', 'K26.401', 'SEZCQBKYBCX', '');
INSERT INTO `05diseases` VALUES ('10153', '十二指肠溃疡伴出血', '321', 'K26.402', 'SEZCKYBCX', '');
INSERT INTO `05diseases` VALUES ('10154', '十二指肠糜烂出血', '321', 'K26.403', 'SEZCMLCX', '');
INSERT INTO `05diseases` VALUES ('10155', '十二指肠溃疡伴穿孔', '321', 'K26.501', 'SEZCKYBCK', '');
INSERT INTO `05diseases` VALUES ('10156', '十二指肠球部溃疡伴穿孔', '321', 'K26.502', 'SEZCQBKYBCK', '');
INSERT INTO `05diseases` VALUES ('10157', '十二指肠溃疡穿孔伴腹膜炎', '90', 'K26.551', 'SEZCKYCKBFMY', '');
INSERT INTO `05diseases` VALUES ('10158', '十二指肠溃疡伴穿孔和出血', '321', 'K26.601', 'SEZCKYBCKHCX', '');
INSERT INTO `05diseases` VALUES ('10159', '慢性或未特指的十二指肠溃疡伴穿孔', '321', 'K26.651', 'MXHWTZDSEZCKYBCK', '');
INSERT INTO `05diseases` VALUES ('10160', '慢性十二指肠溃疡', '321', 'K26.701', 'MXSEZCKY', '');
INSERT INTO `05diseases` VALUES ('10161', '慢性十二指肠球部溃疡', '321', 'K26.702', 'MXSEZCQBKY', '');
INSERT INTO `05diseases` VALUES ('10162', '十二指肠溃疡', '321', 'K26.901', 'SEZCKY', '');
INSERT INTO `05diseases` VALUES ('10163', '十二指肠球部溃疡', '321', 'K26.902', 'SEZCQBKY', '');
INSERT INTO `05diseases` VALUES ('10164', '急性胃十二指肠溃疡伴出血', '370', 'K27.051', 'JXWSEZCKYBCX', '');
INSERT INTO `05diseases` VALUES ('10165', '上消化道溃疡穿孔', '195', 'K27.101', 'SXHDKYCK', '');
INSERT INTO `05diseases` VALUES ('10166', '消化性溃疡伴急性穿孔', '195', 'K27.102', 'XHXKYBJXCK', '');
INSERT INTO `05diseases` VALUES ('10167', '急性胃十二指肠溃疡伴穿孔', '370', 'K27.151', 'JXWSEZCKYBCK', '');
INSERT INTO `05diseases` VALUES ('10168', '上消化道溃疡出血和穿孔', '195', 'K27.251', 'SXHDKYCXHCK', '');
INSERT INTO `05diseases` VALUES ('10169', '急性胃十二指肠溃疡伴穿孔出血', '370', 'K27.252', 'JXWSEZCKYBCKCX', '');
INSERT INTO `05diseases` VALUES ('10170', '急性消化性溃疡伴出血及穿孔(胃及十二指肠溃疡)', '370', 'K27.253', 'JXXHXKYBCXJCKWJSEZCK', '');
INSERT INTO `05diseases` VALUES ('10171', '急性胃十二指肠溃疡', '370', 'K27.351', 'JXWSEZCKY', '');
INSERT INTO `05diseases` VALUES ('10172', '多发性溃疡伴出血', '195', 'K27.401', 'DFXKYBCX', '');
INSERT INTO `05diseases` VALUES ('10173', '胃十二指肠溃疡伴出血', '370', 'K27.402', 'WSEZCKYBCX', '');
INSERT INTO `05diseases` VALUES ('10174', '应激性溃疡伴出血', '195', 'K27.403', 'YJXKYBCX', '');
INSERT INTO `05diseases` VALUES ('10175', '应激性消化道出血', '38', 'K27.404', 'YJXXHDCX', '');
INSERT INTO `05diseases` VALUES ('10176', '消化性溃疡伴出血', '195', 'K27.451', 'XHXKYBCX', '');
INSERT INTO `05diseases` VALUES ('10177', '溃疡病的呕血', '195', 'K27.452', 'KYBDOX', '');
INSERT INTO `05diseases` VALUES ('10178', '溃疡病穿孔', '195', 'K27.501', 'KYBCK', '');
INSERT INTO `05diseases` VALUES ('10179', '胃十二指肠溃疡伴穿孔', '370', 'K27.502', 'WSEZCKYBCK', '');
INSERT INTO `05diseases` VALUES ('10180', '消化道穿孔', '387', 'K27.503', 'XHDCK', '');
INSERT INTO `05diseases` VALUES ('10181', '应激性溃疡伴穿孔', '195', 'K27.504', 'YJXKYBCK', '');
INSERT INTO `05diseases` VALUES ('10182', '慢性胃十二指肠溃疡伴穿孔', '370', 'K27.551', 'MXWSEZCKYBCK', '');
INSERT INTO `05diseases` VALUES ('10183', '慢性胃十二指肠溃疡伴穿孔出血', '370', 'K27.651', 'MXWSEZCKYBCKCX', '');
INSERT INTO `05diseases` VALUES ('10184', '慢性胃十二指肠溃疡', '370', 'K27.751', 'MXWSEZCKY', '');
INSERT INTO `05diseases` VALUES ('10185', '多发性复合性溃疡病', '195', 'K27.901', 'DFXFHXKYB', '');
INSERT INTO `05diseases` VALUES ('10186', '复合性溃疡', '195', 'K27.902', 'FHXKY', '');
INSERT INTO `05diseases` VALUES ('10187', '胃十二指肠溃疡[消化性溃疡]', '370', 'K27.904', 'WSEZCKYXHXKY', '');
INSERT INTO `05diseases` VALUES ('10188', '应激性溃疡', '195', 'K27.905', 'YJXKY', '');
INSERT INTO `05diseases` VALUES ('10189', '胃肠吻合口溃疡伴出血', '370', 'K28.051', 'WCWHKKYBCX', '');
INSERT INTO `05diseases` VALUES ('10190', '急性空肠溃疡伴穿孔', '195', 'K28.151', 'JXKCKYBCK', '');
INSERT INTO `05diseases` VALUES ('10191', '胃肠吻合口溃疡出血', '370', 'K28.401', 'WCWHKKYCX', '');
INSERT INTO `05diseases` VALUES ('10192', '胃肠吻合口溃疡穿孔', '370', 'K28.501', 'WCWHKKYCK', '');
INSERT INTO `05diseases` VALUES ('10193', '慢性胃吻合口炎', '370', 'K28.701', 'MXWWHKY', '');
INSERT INTO `05diseases` VALUES ('10194', '食管空肠吻合口炎', '193', 'K28.901', 'SGKCWHKY', '');
INSERT INTO `05diseases` VALUES ('10195', '胃肠吻合口溃疡', '370', 'K28.902', 'WCWHKKY', '');
INSERT INTO `05diseases` VALUES ('10196', '急性出血性胃炎', '371', 'K29.001', 'JXCXXWY', '');
INSERT INTO `05diseases` VALUES ('10197', '急性出血性胃肠炎', '33', 'K29.051', 'JXCXXWCY', '');
INSERT INTO `05diseases` VALUES ('10198', '急性胃炎', '371', 'K29.101', 'JXWY', '');
INSERT INTO `05diseases` VALUES ('10199', '酒精性胃炎[门内特里尔氏综合征]', '371', 'K29.251', 'JJXWYMNTLESZHZ', '');
INSERT INTO `05diseases` VALUES ('10200', '慢性红斑性胃(窦)炎', '370', 'K29.301', 'MXHBXWDY', '');
INSERT INTO `05diseases` VALUES ('10201', '慢性浅表性胃窦炎', '370', 'K29.302', 'MXQBXWDY', '');
INSERT INTO `05diseases` VALUES ('10202', '慢性浅表性胃炎', '371', 'K29.303', 'MXQBXWY', '');
INSERT INTO `05diseases` VALUES ('10203', '慢性浅表性疣状胃炎', '371', 'K29.304', 'MXQBXYZWY', '');
INSERT INTO `05diseases` VALUES ('10204', '慢性萎缩性胃炎', '371', 'K29.401', 'MXWSXWY', '');
INSERT INTO `05diseases` VALUES ('10205', '萎缩性胃炎', '371', 'K29.402', 'WSXWY', '');
INSERT INTO `05diseases` VALUES ('10206', '慢性萎缩性胃炎伴慢性出血', '371', 'K29.451', 'MXWSXWYBMXCX', '');
INSERT INTO `05diseases` VALUES ('10207', '慢性胃窦炎', '370', 'K29.501', 'MXWDY', '');
INSERT INTO `05diseases` VALUES ('10208', '慢性胃炎', '371', 'K29.502', 'MXWY', '');
INSERT INTO `05diseases` VALUES ('10209', '肥厚性胃炎', '371', 'K29.601', 'FHXWY', '');
INSERT INTO `05diseases` VALUES ('10210', '门内特里尔氏病[胃巨皱襞症]', '370', 'K29.602', 'MNTLESBWJZBZ', '');
INSERT INTO `05diseases` VALUES ('10211', '糜烂性胃炎', '371', 'K29.603', 'MLXWY', '');
INSERT INTO `05diseases` VALUES ('10212', '胃粘膜肥厚', '370', 'K29.604', 'WNMFH', '');
INSERT INTO `05diseases` VALUES ('10213', '药物性胃炎', '371', 'K29.605', 'YWXWY', '');
INSERT INTO `05diseases` VALUES ('10214', '变应性胃炎', '371', 'K29.651', 'BYXWY', '');
INSERT INTO `05diseases` VALUES ('10215', '胆汁反流性胃炎', '371', 'K29.652', 'DZFLXWY', '');
INSERT INTO `05diseases` VALUES ('10216', '化学性胃炎', '371', 'K29.653', 'HXXWY', '');
INSERT INTO `05diseases` VALUES ('10217', '肉芽肿性胃炎', '371', 'K29.654', 'RYZXWY', '');
INSERT INTO `05diseases` VALUES ('10218', '梅内特里耶病或梅内特里耶综合征', '268', 'K29.655', 'MNTLYBHMNTLYZHZ', '');
INSERT INTO `05diseases` VALUES ('10219', '胃巨黏膜症', '370', 'K29.656', 'WJNMZ', '');
INSERT INTO `05diseases` VALUES ('10220', '反流性胃炎', '371', 'K29.701', 'FLXWY', '');
INSERT INTO `05diseases` VALUES ('10221', '胃窦炎', '370', 'K29.702', 'WDY', '');
INSERT INTO `05diseases` VALUES ('10222', '胃炎', '371', 'K29.703', 'WY', '');
INSERT INTO `05diseases` VALUES ('10223', '胃炎性假瘤', '371', 'K29.704', 'WYXJL', '');
INSERT INTO `05diseases` VALUES ('10224', '应激性胃炎', '371', 'K29.705', 'YJXWY', '');
INSERT INTO `05diseases` VALUES ('10225', '幽门炎', '452', 'K29.706', 'YMY', '');
INSERT INTO `05diseases` VALUES ('10226', '疣状胃(胃窦)炎', '370', 'K29.707', 'YZWWDY', '');
INSERT INTO `05diseases` VALUES ('10227', '十二指肠球部炎', '321', 'K29.801', 'SEZCQBY', '');
INSERT INTO `05diseases` VALUES ('10228', '十二指肠炎', '33', 'K29.802', 'SEZCY', '');
INSERT INTO `05diseases` VALUES ('10229', '十二指肠周炎', '321', 'K29.851', 'SEZCZY', '');
INSERT INTO `05diseases` VALUES ('10230', '胃十二指肠炎 NOS', '33', 'K29.901', 'WSEZCY', '');
INSERT INTO `05diseases` VALUES ('10231', '肠消化不良', '259', 'K30.X01', 'CXHBL', '');
INSERT INTO `05diseases` VALUES ('10232', '消化不良', '388', 'K30.X02', 'XHBL', '');
INSERT INTO `05diseases` VALUES ('10233', '急性胃扩张', '370', 'K31.001', 'JXWKZ', '');
INSERT INTO `05diseases` VALUES ('10234', '手术后急性胃扩张', '370', 'K31.002', 'SSHJXWKZ', '');
INSERT INTO `05diseases` VALUES ('10235', '幽门肥大', '452', 'K31.101', 'YMFD', '');
INSERT INTO `05diseases` VALUES ('10236', '幽门梗阻(成人)', '452', 'K31.102', 'YMGZCR', '');
INSERT INTO `05diseases` VALUES ('10237', '幽门狭窄 NOS', '452', 'K31.104', 'YMXZ', '');
INSERT INTO `05diseases` VALUES ('10238', '瘢痕性幽门梗阻', '11', 'K31.151', 'BHXYMGZ', '');
INSERT INTO `05diseases` VALUES ('10239', '肥大性幽门狭窄', '452', 'K31.152', 'FDXYMXZ', '');
INSERT INTO `05diseases` VALUES ('10240', '胃沙漏状狭窄', '370', 'K31.251', 'WSLZXZ', '');
INSERT INTO `05diseases` VALUES ('10241', '幽门痉挛', '179', 'K31.301', 'YMJL', '');
INSERT INTO `05diseases` VALUES ('10242', '胃憩室', '370', 'K31.451', 'WQS', '');
INSERT INTO `05diseases` VALUES ('10243', '十二指肠梗阻', '321', 'K31.501', 'SEZCGZ', '');
INSERT INTO `05diseases` VALUES ('10244', '十二指肠受压', '321', 'K31.502', 'SEZCSY', '');
INSERT INTO `05diseases` VALUES ('10245', '十二指肠淤积', '321', 'K31.503', 'SEZCYJ', '');
INSERT INTO `05diseases` VALUES ('10246', '十二指肠狭窄', '321', 'K31.504', 'SEZCXZ', '');
INSERT INTO `05diseases` VALUES ('10247', '慢性十二指肠梗阻', '321', 'K31.551', 'MXSEZCGZ', '');
INSERT INTO `05diseases` VALUES ('10248', '十二指肠停滞', '321', 'K31.552', 'SEZCTZ', '');
INSERT INTO `05diseases` VALUES ('10249', '十二指肠瘘', '321', 'K31.601', 'SEZCL', '');
INSERT INTO `05diseases` VALUES ('10250', '手术后食管胃瘘', '370', 'K31.602', 'SSHSGWL', '');
INSERT INTO `05diseases` VALUES ('10251', '手术后胃大肠瘘', '370', 'K31.603', 'SSHWDCL', '');
INSERT INTO `05diseases` VALUES ('10252', '手术后胃瘘', '370', 'K31.604', 'SSHWL', '');
INSERT INTO `05diseases` VALUES ('10253', '手术后胃小肠瘘', '370', 'K31.605', 'SSHWXCL', '');
INSERT INTO `05diseases` VALUES ('10254', '胃空肠结肠瘘', '370', 'K31.606', 'WKCJCL', '');
INSERT INTO `05diseases` VALUES ('10255', '胃结肠瘘', '370', 'K31.651', 'WJCL', '');
INSERT INTO `05diseases` VALUES ('10256', '胃息肉', '370', 'K31.701', 'WXR', '');
INSERT INTO `05diseases` VALUES ('10257', '低张力胃', '370', 'K31.801', 'DZLW', '');
INSERT INTO `05diseases` VALUES ('10258', '葫芦状胃(沙漏状胃痉挛)', '370', 'K31.802', 'HLZWSLZWJL', '');
INSERT INTO `05diseases` VALUES ('10259', '急性胃粘膜病变', '370', 'K31.803', 'JXWNMBB', '');
INSERT INTO `05diseases` VALUES ('10260', '十二指肠白点征', '321', 'K31.805', 'SEZCBDZ', '');
INSERT INTO `05diseases` VALUES ('10261', '十二指肠球部变形', '321', 'K31.806', 'SEZCQBBX', '');
INSERT INTO `05diseases` VALUES ('10262', '十二指肠球部息肉', '321', 'K31.807', 'SEZCQBXR', '');
INSERT INTO `05diseases` VALUES ('10263', '十二指肠息肉', '321', 'K31.808', 'SEZCXR', '');
INSERT INTO `05diseases` VALUES ('10264', '胃肠粘膜病变', '370', 'K31.809', 'WCNMBB', '');
INSERT INTO `05diseases` VALUES ('10265', '胃黄色斑', '370', 'K31.810', 'WHSB', '');
INSERT INTO `05diseases` VALUES ('10266', '胃假性淋巴瘤', '370', 'K31.811', 'WJXLBL', '');
INSERT INTO `05diseases` VALUES ('10267', '胃结石', '370', 'K31.812', 'WJS', '');
INSERT INTO `05diseases` VALUES ('10268', '胃痉挛', '370', 'K31.813', 'WJL', '');
INSERT INTO `05diseases` VALUES ('10269', '胃麻痹', '370', 'K31.814', 'WMB', '');
INSERT INTO `05diseases` VALUES ('10270', '胃囊肿', '370', 'K31.815', 'WNZ', '');
INSERT INTO `05diseases` VALUES ('10271', '胃扭转', '370', 'K31.816', 'WNZ', '');
INSERT INTO `05diseases` VALUES ('10272', '胃排空梗阻', '370', 'K31.817', 'WPKGZ', '');
INSERT INTO `05diseases` VALUES ('10273', '胃破裂', '370', 'K31.818', 'WPL', '');
INSERT INTO `05diseases` VALUES ('10274', '胃酸过多[罗斯巴赫氏病]', '370', 'K31.819', 'WSGDLSBHSB', '');
INSERT INTO `05diseases` VALUES ('10275', '胃酸缺乏', '370', 'K31.820', 'WSQF', '');
INSERT INTO `05diseases` VALUES ('10276', '胃下垂', '370', 'K31.821', 'WXC', '');
INSERT INTO `05diseases` VALUES ('10277', '胃腺体增生', '370', 'K31.822', 'WXTZS', '');
INSERT INTO `05diseases` VALUES ('10278', '胃粘膜病变', '370', 'K31.823', 'WNMBB', '');
INSERT INTO `05diseases` VALUES ('10279', '胃粘膜脱垂', '370', 'K31.824', 'WNMTC', '');
INSERT INTO `05diseases` VALUES ('10280', '胃皱襞', '370', 'K31.825', 'WZB', '');
INSERT INTO `05diseases` VALUES ('10281', '胃潴留', '370', 'K31.826', 'WZL', '');
INSERT INTO `05diseases` VALUES ('10282', '胃病', '370', 'K31.851', 'WB', '');
INSERT INTO `05diseases` VALUES ('10283', '胃肠痉挛', '370', 'K31.852', 'WCJL', '');
INSERT INTO `05diseases` VALUES ('10284', '胃毒血症', '370', 'K31.853', 'WDXZ', '');
INSERT INTO `05diseases` VALUES ('10285', '胃机能紊乱', '370', 'K31.854', 'WJNWL', '');
INSERT INTO `05diseases` VALUES ('10286', '痉挛性胃炎', '371', 'K31.856', 'JLXWY', '');
INSERT INTO `05diseases` VALUES ('10287', '嗜酸细胞性胃炎', '371', 'K31.857', 'SSXBXWY', '');
INSERT INTO `05diseases` VALUES ('10288', '十二指肠扭转', '321', 'K31.858', 'SEZCNZ', '');
INSERT INTO `05diseases` VALUES ('10289', '葫芦胃狭窄', '370', 'K31.859', 'HLWXZ', '');
INSERT INTO `05diseases` VALUES ('10290', '十二指肠肿物', '321', 'K31.901', 'SEZCZW', '');
INSERT INTO `05diseases` VALUES ('10291', '胃占位病变', '370', 'K31.902', 'WZWBB', '');
INSERT INTO `05diseases` VALUES ('10292', '胃肠功能紊乱', '370', 'K31.951', 'WCGNWL', '');
INSERT INTO `05diseases` VALUES ('10293', '胃功能障碍', '370', 'K31.952', 'WGNZA', '');
INSERT INTO `05diseases` VALUES ('10294', '急性化脓性阑尾炎伴穿孔', '196', 'K35.001', 'JXHNXLWYBCK', '');
INSERT INTO `05diseases` VALUES ('10295', '急性阑尾炎伴穿孔', '196', 'K35.002', 'JXLWYBCK', '');
INSERT INTO `05diseases` VALUES ('10296', '急性阑尾炎伴腹膜炎', '90', 'K35.003', 'JXLWYBFMY', '');
INSERT INTO `05diseases` VALUES ('10297', '阑尾破裂', '196', 'K35.004', 'LWPL', '');
INSERT INTO `05diseases` VALUES ('10298', '阑尾穿孔', '196', 'K35.051', 'LWCK', '');
INSERT INTO `05diseases` VALUES ('10299', '急性化脓性阑尾穿孔伴腹膜炎', '90', 'K35.052', 'JXHNXLWCKBFMY', '');
INSERT INTO `05diseases` VALUES ('10300', '阑尾炎后腹膜炎', '90', 'K35.053', 'LWYHFMY', '');
INSERT INTO `05diseases` VALUES ('10301', '急性化脓性阑尾炎伴阑尾周围炎', '196', 'K35.102', 'JXHNXLWYBLWZWY', '');
INSERT INTO `05diseases` VALUES ('10302', '急性化脓性阑尾炎伴周围脓肿', '243', 'K35.103', 'JXHNXLWYBZWNZ', '');
INSERT INTO `05diseases` VALUES ('10303', '急性阑尾炎伴腹膜脓肿', '243', 'K35.104', 'JXLWYBFMNZ', '');
INSERT INTO `05diseases` VALUES ('10304', '阑尾脓肿', '243', 'K35.105', 'LWNZ', '');
INSERT INTO `05diseases` VALUES ('10305', '阑尾炎伴脓肿', '243', 'K35.106', 'LWYBNZ', '');
INSERT INTO `05diseases` VALUES ('10306', '阑尾周围脓肿', '243', 'K35.107', 'LWZWNZ', '');
INSERT INTO `05diseases` VALUES ('10307', '盲肠脓肿', '243', 'K35.108', 'MCNZ', '');
INSERT INTO `05diseases` VALUES ('10308', '急性阑尾炎伴脓肿', '243', 'K35.151', 'JXLWYBNZ', '');
INSERT INTO `05diseases` VALUES ('10309', '急性坏疽性阑尾炎', '196', 'K35.901', 'JXHJXLWY', '');
INSERT INTO `05diseases` VALUES ('10310', '急性阑尾炎', '196', 'K35.902', 'JXLWY', '');
INSERT INTO `05diseases` VALUES ('10311', '急性阑尾炎及阑尾周围炎', '196', 'K35.903', 'JXLWYJLWZWY', '');
INSERT INTO `05diseases` VALUES ('10312', '急性化脓性阑尾炎', '196', 'K35.951', 'JXHNXLWY', '');
INSERT INTO `05diseases` VALUES ('10313', '复发性(梗阻性)阑尾炎', '196', 'K36.X01', 'FFXGZXLWY', '');
INSERT INTO `05diseases` VALUES ('10314', '慢性阑尾炎', '196', 'K36.X02', 'MXLWY', '');
INSERT INTO `05diseases` VALUES ('10315', '亚急性阑尾炎', '196', 'K36.X03', 'YJXLWY', '');
INSERT INTO `05diseases` VALUES ('10316', '继发性阑尾炎', '196', 'K36.X51', 'JFXLWY', '');
INSERT INTO `05diseases` VALUES ('10317', '老年性阑尾炎', '196', 'K36.X52', 'LNXLWY', '');
INSERT INTO `05diseases` VALUES ('10318', '妊娠期阑尾炎', '293', 'K36.X53', 'RSQLWY', '');
INSERT INTO `05diseases` VALUES ('10319', '异位阑尾炎', '196', 'K36.X54', 'YWLWY', '');
INSERT INTO `05diseases` VALUES ('10320', '阑尾炎', '196', 'K37.X01', 'LWY', '');
INSERT INTO `05diseases` VALUES ('10321', '阑尾周围炎', '196', 'K37.X02', 'LWZWY', '');
INSERT INTO `05diseases` VALUES ('10322', '盲肠炎', '33', 'K37.X03', 'MCY', '');
INSERT INTO `05diseases` VALUES ('10323', '阑尾残端炎', '196', 'K37.X51', 'LWCDY', '');
INSERT INTO `05diseases` VALUES ('10324', '阑尾组织增生', '196', 'K38.051', 'LWZZZS', '');
INSERT INTO `05diseases` VALUES ('10325', '阑尾结石', '196', 'K38.101', 'LWJS', '');
INSERT INTO `05diseases` VALUES ('10326', '阑尾憩室', '196', 'K38.251', 'LWQS', '');
INSERT INTO `05diseases` VALUES ('10327', '阑尾瘘', '212', 'K38.301', 'LWL', '');
INSERT INTO `05diseases` VALUES ('10328', '闭锁性阑尾', '196', 'K38.801', 'BSXLW', '');
INSERT INTO `05diseases` VALUES ('10329', '阑尾囊肿', '231', 'K38.802', 'LWNZ', '');
INSERT INTO `05diseases` VALUES ('10330', '阑尾套叠', '196', 'K38.851', 'LWTD', '');
INSERT INTO `05diseases` VALUES ('10331', '阑尾包块', '196', 'K38.951', 'LWBK', '');
INSERT INTO `05diseases` VALUES ('10332', '双侧腹股沟疝伴梗阻', '305', 'K40.051', 'SCFGGSBGZ', '');
INSERT INTO `05diseases` VALUES ('10333', '双侧腹股沟疝伴坏疽', '305', 'K40.151', 'SCFGGSBHJ', '');
INSERT INTO `05diseases` VALUES ('10334', '双侧腹股沟疝', '305', 'K40.251', 'SCFGGS', '');
INSERT INTO `05diseases` VALUES ('10335', '绞窄性腹股沟疝(单侧)', '305', 'K40.301', 'JZXFGGSDC', '');
INSERT INTO `05diseases` VALUES ('10336', '难复性腹股沟疝(单侧)', '305', 'K40.302', 'NFXFGGSDC', '');
INSERT INTO `05diseases` VALUES ('10337', '嵌顿性腹股沟疝(单侧)', '305', 'K40.303', 'QDXFGGSDC', '');
INSERT INTO `05diseases` VALUES ('10338', '嵌顿性腹股沟疝伴梗阻(单侧)', '305', 'K40.304', 'QDXFGGSBGZDC', '');
INSERT INTO `05diseases` VALUES ('10339', '坏疽性腹股沟疝', '305', 'K40.451', 'HJXFGGS', '');
INSERT INTO `05diseases` VALUES ('10340', '腹股沟环松弛', '264', 'K40.901', 'FGGHSC', '');
INSERT INTO `05diseases` VALUES ('10341', '腹股沟疝(单侧)', '305', 'K40.902', 'FGGSDC', '');
INSERT INTO `05diseases` VALUES ('10342', '腹股沟斜疝(单侧)', '305', 'K40.903', 'FGGXSDC', '');
INSERT INTO `05diseases` VALUES ('10343', '腹股沟直疝(单侧)', '305', 'K40.904', 'FGGZSDC', '');
INSERT INTO `05diseases` VALUES ('10344', '腹外疝', '305', 'K40.951', 'FWS', '');
INSERT INTO `05diseases` VALUES ('10345', '阴囊疝', '305', 'K40.952', 'YNS', '');
INSERT INTO `05diseases` VALUES ('10346', '双侧股疝伴梗阻', '305', 'K41.051', 'SCGSBGZ', '');
INSERT INTO `05diseases` VALUES ('10347', '双侧股疝伴坏疽', '305', 'K41.151', 'SCGSBHJ', '');
INSERT INTO `05diseases` VALUES ('10348', '双侧股疝不伴梗阻和坏疽', '305', 'K41.251', 'SCGSBBGZHHJ', '');
INSERT INTO `05diseases` VALUES ('10349', '嵌顿性股疝', '305', 'K41.301', 'QDXGS', '');
INSERT INTO `05diseases` VALUES ('10350', '绞窄性股疝(单侧)', '305', 'K41.302', 'JZXGSDC', '');
INSERT INTO `05diseases` VALUES ('10351', '单侧股疝伴梗阻不伴坏疽', '305', 'K41.351', 'DCGSBGZBBHJ', '');
INSERT INTO `05diseases` VALUES ('10352', '股疝伴坏疽', '305', 'K41.451', 'GSBHJ', '');
INSERT INTO `05diseases` VALUES ('10353', '股疝', '305', 'K41.901', 'GS', '');
INSERT INTO `05diseases` VALUES ('10354', '黑塞尔巴赫疝[筛筋膜疝]', '305', 'K41.951', 'HSEBHSSJMS', '');
INSERT INTO `05diseases` VALUES ('10355', '脐疝伴梗阻', '305', 'K42.001', 'QSBGZ', '');
INSERT INTO `05diseases` VALUES ('10356', '坏疽性脐疝', '305', 'K42.151', 'HJXQS', '');
INSERT INTO `05diseases` VALUES ('10357', '脐旁疝', '305', 'K42.901', 'QPS', '');
INSERT INTO `05diseases` VALUES ('10358', '脐疝', '305', 'K42.902', 'QS', '');
INSERT INTO `05diseases` VALUES ('10359', '腹嵌顿疝', '305', 'K43.001', 'FQDS', '');
INSERT INTO `05diseases` VALUES ('10360', '腹疝(切口疝)并梗阻', '305', 'K43.002', 'FSQKSBGZ', '');
INSERT INTO `05diseases` VALUES ('10361', '肠系膜疝伴梗阻', '305', 'K43.051', 'CXMSBGZ', '');
INSERT INTO `05diseases` VALUES ('10362', '腹白线疝梗阻', '305', 'K43.052', 'FBXSGZ', '');
INSERT INTO `05diseases` VALUES ('10363', '坏疽性腹疝)', '305', 'K43.151', 'HJXFS', '');
INSERT INTO `05diseases` VALUES ('10364', '白线疝坏疽', '305', 'K43.152', 'BXSHJ', '');
INSERT INTO `05diseases` VALUES ('10365', '腹白线疝', '305', 'K43.901', 'FBXS', '');
INSERT INTO `05diseases` VALUES ('10366', '腹壁疝(切口疝)', '305', 'K43.902', 'FBSQKS', '');
INSERT INTO `05diseases` VALUES ('10367', '腹疝', '305', 'K43.903', 'FS', '');
INSERT INTO `05diseases` VALUES ('10368', '半月线疝[自发性侧腹壁疝]', '305', 'K43.951', 'BYXSZFXCFBS', '');
INSERT INTO `05diseases` VALUES ('10369', '膈疝伴梗阻不伴坏疽', '305', 'K44.051', 'GSBGZBBHJ', '');
INSERT INTO `05diseases` VALUES ('10370', '裂孔疝梗阻', '305', 'K44.052', 'LKSGZ', '');
INSERT INTO `05diseases` VALUES ('10371', '坏疽性膈疝', '305', 'K44.151', 'HJXGS', '');
INSERT INTO `05diseases` VALUES ('10372', '裂孔疝坏疽', '305', 'K44.152', 'LKSHJ', '');
INSERT INTO `05diseases` VALUES ('10373', '膈疝', '305', 'K44.901', 'GS', '');
INSERT INTO `05diseases` VALUES ('10374', '食道裂孔疝', '305', 'K44.902', 'SDLKS', '');
INSERT INTO `05diseases` VALUES ('10375', '绞窄性腹疝伴梗阻不伴坏疽', '305', 'K45.051', 'JZXFSBGZBBHJ', '');
INSERT INTO `05diseases` VALUES ('10376', '腹嵌顿疝伴坏疽', '305', 'K45.151', 'FQDSBHJ', '');
INSERT INTO `05diseases` VALUES ('10377', '闭孔疝', '305', 'K45.801', 'BKS', '');
INSERT INTO `05diseases` VALUES ('10378', '腰疝', '305', 'K45.803', 'YS', '');
INSERT INTO `05diseases` VALUES ('10379', '阑尾(切口疝)', '305', 'K45.851', 'LWQKS', '');
INSERT INTO `05diseases` VALUES ('10380', '腹内疝(肠疝)', '305', 'K45.852', 'FNSCS', '');
INSERT INTO `05diseases` VALUES ('10381', '坐骨大孔疝', '305', 'K45.853', 'ZGDKS', '');
INSERT INTO `05diseases` VALUES ('10382', '坐骨直肠疝', '305', 'K45.854', 'ZGZCS', '');
INSERT INTO `05diseases` VALUES ('10383', '绞窄性小肠疝', '305', 'K46.001', 'JZXXCS', '');
INSERT INTO `05diseases` VALUES ('10384', '腹内疝伴肠梗阻', '305', 'K46.002', 'FNSBCGZ', '');
INSERT INTO `05diseases` VALUES ('10385', '逆行性嵌顿疝不伴坏疽', '305', 'K46.051', 'NXXQDSBBHJ', '');
INSERT INTO `05diseases` VALUES ('10386', '腹部疝伴坏疽', '305', 'K46.151', 'FBSBHJ', '');
INSERT INTO `05diseases` VALUES ('10387', '肠系膜裂孔疝', '305', 'K46.901', 'CXMLKS', '');
INSERT INTO `05diseases` VALUES ('10388', '腹内疝', '305', 'K46.902', 'FNS', '');
INSERT INTO `05diseases` VALUES ('10389', '输入袢内疝', '305', 'K46.903', 'SRPNS', '');
INSERT INTO `05diseases` VALUES ('10390', '网膜裂孔疝', '305', 'K46.904', 'WMLKS', '');
INSERT INTO `05diseases` VALUES ('10391', '小肠疝', '305', 'K46.905', 'XCS', '');
INSERT INTO `05diseases` VALUES ('10392', '特赖茨(窝)[十二指肠上隐窝疝]', '321', 'K46.951', 'TLCWSEZCSYWS', '');
INSERT INTO `05diseases` VALUES ('10393', '库珀疝', '305', 'K46.952', 'KPS', '');
INSERT INTO `05diseases` VALUES ('10394', '里厄疝[盲肠后疝]', '305', 'K46.953', 'LESMCHS', '');
INSERT INTO `05diseases` VALUES ('10395', '里希特疝[肠壁疝]', '305', 'K46.954', 'LXTSCBS', '');
INSERT INTO `05diseases` VALUES ('10396', '利特雷疝[憩室疝]', '305', 'K46.955', 'LTLSQSS', '');
INSERT INTO `05diseases` VALUES ('10397', '其他腹腔疝未提及梗阻或坏疽', '305', 'K46.956', 'QTFQSWTJGZHHJ', '');
INSERT INTO `05diseases` VALUES ('10398', '闭孔疝(腹的)', '305', 'K46.957', 'BKSFD', '');
INSERT INTO `05diseases` VALUES ('10399', '肠疝', '305', 'K46.958', 'CS', '');
INSERT INTO `05diseases` VALUES ('10400', '韦尔波疝[股血管前股疝]', '305', 'K46.959', 'WEBSGXGQGS', '');
INSERT INTO `05diseases` VALUES ('10401', '末端性回肠炎', '33', 'K50.001', 'MDXHCY', '');
INSERT INTO `05diseases` VALUES ('10402', '小肠节段性肠炎(十二指肠，回肠或空肠)[小肠克隆氏病]', '33', 'K50.002', 'XCJDXCYSEZCHCHKCXCKL', '');
INSERT INTO `05diseases` VALUES ('10403', '大肠克隆氏病[大肠节段性肠炎]', '33', 'K50.101', 'DCKLSBDCJDXCY', '');
INSERT INTO `05diseases` VALUES ('10404', '结肠克隆氏病[结肠节段性肠炎]', '33', 'K50.102', 'JCKLSBJCJDXCY', '');
INSERT INTO `05diseases` VALUES ('10405', '肉芽肿性结肠炎', '33', 'K50.103', 'RYZXJCY', '');
INSERT INTO `05diseases` VALUES ('10406', '直肠节段性肠炎[直肠克隆氏病]', '33', 'K50.104', 'ZCJDXCYZCKLSB', '');
INSERT INTO `05diseases` VALUES ('10407', '大肠和小肠克罗恩病脓肿[节段性肠炎]', '33', 'K50.851', 'DCHXCKLEBNZJDXCY', '');
INSERT INTO `05diseases` VALUES ('10408', '节段性肠炎[克隆氏病]', '33', 'K50.901', 'JDXCYKLSB', '');
INSERT INTO `05diseases` VALUES ('10409', '节段性肠炎性关节病', '33', 'K50.902+', 'JDXCYXGJB', '');
INSERT INTO `05diseases` VALUES ('10410', '溃疡性(慢性)小肠结肠炎', '33', 'K51.051', 'KYXMXXCJCY', '');
INSERT INTO `05diseases` VALUES ('10411', '溃疡性慢性回肠结肠炎', '33', 'K51.151', 'KYXMXHCJCY', '');
INSERT INTO `05diseases` VALUES ('10412', '慢性溃疡性直肠炎', '33', 'K51.251', 'MXKYXZCY', '');
INSERT INTO `05diseases` VALUES ('10413', '溃疡性(慢性)直肠乙状结肠炎', '33', 'K51.351', 'KYXMXZCYZJCY', '');
INSERT INTO `05diseases` VALUES ('10414', '结肠假息肉病', '374', 'K51.401', 'JCJXRB', '');
INSERT INTO `05diseases` VALUES ('10415', '粘膜性直肠结肠炎', '33', 'K51.551', 'NMXZCJCY', '');
INSERT INTO `05diseases` VALUES ('10416', '其他溃疡性结肠炎', '33', 'K51.851', 'QTKYXJCY', '');
INSERT INTO `05diseases` VALUES ('10417', '溃疡性肠炎', '33', 'K51.901', 'KYXCY', '');
INSERT INTO `05diseases` VALUES ('10418', '溃疡性结肠炎 NOS', '33', 'K51.902', 'KYXJCY', '');
INSERT INTO `05diseases` VALUES ('10419', '溃疡性结肠炎性关节病', '33', 'K51.903+', 'KYXJCYXGJB', '');
INSERT INTO `05diseases` VALUES ('10420', '放射性肠炎', '33', 'K52.001', 'FSXCY', '');
INSERT INTO `05diseases` VALUES ('10421', '放射性胃肠炎', '33', 'K52.051', 'FSXWCY', '');
INSERT INTO `05diseases` VALUES ('10422', '放射性结肠炎', '33', 'K52.052', 'FSXJCY', '');
INSERT INTO `05diseases` VALUES ('10423', '中毒性腹泻', '91', 'K52.101', 'ZDXFX', '');
INSERT INTO `05diseases` VALUES ('10424', '中毒性肠炎', '33', 'K52.151', 'ZDXCY', '');
INSERT INTO `05diseases` VALUES ('10425', '中毒性结肠炎', '33', 'K52.152', 'ZDXJCY', '');
INSERT INTO `05diseases` VALUES ('10426', '中毒性胃肠炎', '33', 'K52.153', 'ZDXWCY', '');
INSERT INTO `05diseases` VALUES ('10427', '过敏性肠炎', '33', 'K52.201', 'GMXCY', '');
INSERT INTO `05diseases` VALUES ('10428', '过敏性腹泻', '91', 'K52.202', 'GMXFX', '');
INSERT INTO `05diseases` VALUES ('10429', '过敏性结肠炎', '33', 'K52.203', 'GMXJCY', '');
INSERT INTO `05diseases` VALUES ('10430', '胃肠道过敏症', '31', 'K52.204', 'WCDGMZ', '');
INSERT INTO `05diseases` VALUES ('10431', '饮食性腹泻', '91', 'K52.205', 'YSXFX', '');
INSERT INTO `05diseases` VALUES ('10432', '饮食性胃肠炎', '33', 'K52.251', 'YSXWCY', '');
INSERT INTO `05diseases` VALUES ('10433', '嗜酸粒细胞性胃肠炎', '33', 'K52.801', 'SSLXBXWCY', '');
INSERT INTO `05diseases` VALUES ('10434', '药物相关性肠炎', '33', 'K52.802', 'YWXGXCY', '');
INSERT INTO `05diseases` VALUES ('10435', '胰源性腹泻', '91', 'K52.803', 'YYXFX', '');
INSERT INTO `05diseases` VALUES ('10436', '假膜性结肠炎', '33', 'K52.851', 'JMXJCY', '');
INSERT INTO `05diseases` VALUES ('10437', '肠炎', '33', 'K52.901', 'CY', '');
INSERT INTO `05diseases` VALUES ('10438', '出血性结肠炎', '33', 'K52.902', 'CXXJCY', '');
INSERT INTO `05diseases` VALUES ('10439', '非感染性腹泻', '95', 'K52.903', 'FGRXFX', '');
INSERT INTO `05diseases` VALUES ('10440', '腹泻', '91', 'K52.904', 'FX', '');
INSERT INTO `05diseases` VALUES ('10441', '急性肠炎', '33', 'K52.905', 'JXCY', '');
INSERT INTO `05diseases` VALUES ('10442', '急性出血性肠炎', '33', 'K52.906', 'JXCXXCY', '');
INSERT INTO `05diseases` VALUES ('10443', '急性结肠炎', '33', 'K52.907', 'JXJCY', '');
INSERT INTO `05diseases` VALUES ('10444', '急性胃肠炎', '33', 'K52.908', 'JXWCY', '');
INSERT INTO `05diseases` VALUES ('10445', '结肠炎', '33', 'K52.909', 'JCY', '');
INSERT INTO `05diseases` VALUES ('10446', '流行性肠炎', '33', 'K52.910', 'LXXCY', '');
INSERT INTO `05diseases` VALUES ('10447', '慢性肠炎', '33', 'K52.911', 'MXCY', '');
INSERT INTO `05diseases` VALUES ('10448', '慢性腹泻', '91', 'K52.912', 'MXFX', '');
INSERT INTO `05diseases` VALUES ('10449', '慢性结肠炎', '33', 'K52.913', 'MXJCY', '');
INSERT INTO `05diseases` VALUES ('10450', '慢性胃肠炎', '33', 'K52.914', 'MXWCY', '');
INSERT INTO `05diseases` VALUES ('10451', '脓毒性肠炎', '33', 'K52.915', 'NDXCY', '');
INSERT INTO `05diseases` VALUES ('10452', '秋季腹泻', '91', 'K52.916', 'QJFX', '');
INSERT INTO `05diseases` VALUES ('10453', '伪膜性肠炎', '33', 'K52.917', 'WMXCY', '');
INSERT INTO `05diseases` VALUES ('10454', '胃肠炎(出血性)(急性)', '33', 'K52.918', 'WCYCXXJX', '');
INSERT INTO `05diseases` VALUES ('10455', '小儿肠炎', '33', 'K52.919', 'XECY', '');
INSERT INTO `05diseases` VALUES ('10456', '乙状结肠炎', '33', 'K52.920', 'YZJCY', '');
INSERT INTO `05diseases` VALUES ('10457', '婴儿肠炎', '33', 'K52.921', 'YECY', '');
INSERT INTO `05diseases` VALUES ('10458', '婴儿或新生儿腹泻', '91', 'K52.922', 'YEHXSEFX', '');
INSERT INTO `05diseases` VALUES ('10459', '幼儿腹泻(夏季腹泻)', '91', 'K52.923', 'YEFXXJFX', '');
INSERT INTO `05diseases` VALUES ('10460', '伪膜性结肠炎', '33', 'K52.951', 'WMXJCY', '');
INSERT INTO `05diseases` VALUES ('10461', '分泌性腹泻', '91', 'K52.952', 'FMXFX', '');
INSERT INTO `05diseases` VALUES ('10462', '混合型腹泻', '91', 'K52.953', 'HHXFX', '');
INSERT INTO `05diseases` VALUES ('10463', '流行性腹泻', '91', 'K52.954', 'LXXFX', '');
INSERT INTO `05diseases` VALUES ('10464', '新生儿流行性腹泻', '91', 'K52.955', 'XSELXXFX', '');
INSERT INTO `05diseases` VALUES ('10465', '肠坏疽', '259', 'K55.001', 'CHJ', '');
INSERT INTO `05diseases` VALUES ('10466', '肠坏死', '259', 'K55.002', 'CHS', '');
INSERT INTO `05diseases` VALUES ('10467', '肠系膜动脉栓塞', '260', 'K55.003', 'CXMDMSS', '');
INSERT INTO `05diseases` VALUES ('10468', '肠系膜动脉栓塞伴肠坏死', '260', 'K55.004', 'CXMDMSSBCHS', '');
INSERT INTO `05diseases` VALUES ('10469', '肠系膜动脉狭窄', '260', 'K55.005', 'CXMDMXZ', '');
INSERT INTO `05diseases` VALUES ('10470', '肠系膜坏疽', '259', 'K55.006', 'CXMHJ', '');
INSERT INTO `05diseases` VALUES ('10471', '肠系膜静脉血栓形成', '419', 'K55.007', 'CXMJMXSXC', '');
INSERT INTO `05diseases` VALUES ('10472', '肠系膜静脉血栓形成伴肠坏死', '419', 'K55.008', 'CXMJMXSXCBCHS', '');
INSERT INTO `05diseases` VALUES ('10473', '出血性肠梗塞', '38', 'K55.009', 'CXXCGS', '');
INSERT INTO `05diseases` VALUES ('10474', '缺血性肠病', '259', 'K55.051', 'QXXCB', '');
INSERT INTO `05diseases` VALUES ('10475', '出血性肠坏死', '38', 'K55.052', 'CXXCHS', '');
INSERT INTO `05diseases` VALUES ('10476', '肠系膜上动脉综合征', '260', 'K55.053', 'CXMSDMZHZ', '');
INSERT INTO `05diseases` VALUES ('10477', '出血性肠炎', '33', 'K55.054', 'CXXCY', '');
INSERT INTO `05diseases` VALUES ('10478', '网膜坏死', '278', 'K55.055', 'WMHS', '');
INSERT INTO `05diseases` VALUES ('10479', '肠道慢性缺血性综合征', '31', 'K55.101', 'CDMXQXXZHZ', '');
INSERT INTO `05diseases` VALUES ('10480', '肠系膜动脉供血不足', '59', 'K55.102', 'CXMDMGXBZ', '');
INSERT INTO `05diseases` VALUES ('10481', '肠系膜动脉硬化', '63', 'K55.103', 'CXMDMYH', '');
INSERT INTO `05diseases` VALUES ('10482', '肠系膜上动脉综合征[十二指肠血管压迫综征]', '260', 'K55.104', 'CXMSDMZHZSEZCXGYPZZ', '');
INSERT INTO `05diseases` VALUES ('10483', '肠道血管机能不全', '31', 'K55.151', 'CDXGJNBQ', '');
INSERT INTO `05diseases` VALUES ('10484', '肠缺血性狭窄', '259', 'K55.152', 'CQXXXZ', '');
INSERT INTO `05diseases` VALUES ('10485', '慢性缺血性结肠炎', '33', 'K55.153', 'MXQXXJCY', '');
INSERT INTO `05diseases` VALUES ('10486', '结肠血管发育异常', '170', 'K55.251', 'JCXGFYYC', '');
INSERT INTO `05diseases` VALUES ('10487', '肠系膜动脉炎', '260', 'K55.801', 'CXMDMY', '');
INSERT INTO `05diseases` VALUES ('10488', '结肠血管扩张', '170', 'K55.802', 'JCXGKZ', '');
INSERT INTO `05diseases` VALUES ('10489', '十二指肠动脉破裂', '260', 'K55.803', 'SEZCDMPL', '');
INSERT INTO `05diseases` VALUES ('10490', '小肠毛细血管扩张', '389', 'K55.805', 'XCMXXGKZ', '');
INSERT INTO `05diseases` VALUES ('10491', '肠血管畸形', '148', 'K55.851', 'CXGJX', '');
INSERT INTO `05diseases` VALUES ('10492', '肠血管增生', '259', 'K55.852', 'CXGZS', '');
INSERT INTO `05diseases` VALUES ('10493', '局限性缺血性肠病', '259', 'K55.901', 'JXXQXXCB', '');
INSERT INTO `05diseases` VALUES ('10494', '缺血性肠炎 NOS', '33', 'K55.902', 'QXXCY', '');
INSERT INTO `05diseases` VALUES ('10495', '肠缺血综合征', '259', 'K55.951', 'CQXZHZ', '');
INSERT INTO `05diseases` VALUES ('10496', '肠麻痹', '217', 'K56.001', 'CMB', '');
INSERT INTO `05diseases` VALUES ('10497', '麻痹性肠梗阻', '217', 'K56.002', 'MBXCGZ', '');
INSERT INTO `05diseases` VALUES ('10498', '无力性肠梗阻', '32', 'K56.051', 'WLXCGZ', '');
INSERT INTO `05diseases` VALUES ('10499', '大肠麻痹', '217', 'K56.052', 'DCMB', '');
INSERT INTO `05diseases` VALUES ('10500', '小肠麻痹', '217', 'K56.053', 'XCMB', '');
INSERT INTO `05diseases` VALUES ('10501', '结肠麻痹', '217', 'K56.054', 'JCMB', '');
INSERT INTO `05diseases` VALUES ('10502', '肠套叠', '259', 'K56.101', 'CTD', '');
INSERT INTO `05diseases` VALUES ('10503', '结肠套叠', '170', 'K56.151', 'JCTD', '');
INSERT INTO `05diseases` VALUES ('10504', '小肠套叠', '389', 'K56.152', 'XCTD', '');
INSERT INTO `05diseases` VALUES ('10505', '直肠套叠', '468', 'K56.153', 'ZCTD', '');
INSERT INTO `05diseases` VALUES ('10506', '大肠套叠', '50', 'K56.154', 'DCTD', '');
INSERT INTO `05diseases` VALUES ('10507', '肠绞窄', '259', 'K56.201', 'CJZ', '');
INSERT INTO `05diseases` VALUES ('10508', '肠扭转', '259', 'K56.202', 'CNZ', '');
INSERT INTO `05diseases` VALUES ('10509', '绞窄性肠梗阻', '32', 'K56.203', 'JZXCGZ', '');
INSERT INTO `05diseases` VALUES ('10510', '肠梗阻伴扭转', '32', 'K56.251', 'CGZBNZ', '');
INSERT INTO `05diseases` VALUES ('10511', '结肠纽结', '170', 'K56.252', 'JCNJ', '');
INSERT INTO `05diseases` VALUES ('10512', '乙状结肠扭转', '170', 'K56.253', 'YZJCNZ', '');
INSERT INTO `05diseases` VALUES ('10513', '胆石性肠梗阻', '53', 'K56.351', 'DSXCGZ', '');
INSERT INTO `05diseases` VALUES ('10514', '肠结石', '259', 'K56.402', 'CJS', '');
INSERT INTO `05diseases` VALUES ('10515', '肠粪嵌塞或便结', '259', 'K56.451', 'CFQSHBJ', '');
INSERT INTO `05diseases` VALUES ('10516', '肠石病(嵌塞)', '259', 'K56.452', 'CSBQS', '');
INSERT INTO `05diseases` VALUES ('10517', '回肠结石', '259', 'K56.453', 'HCJS', '');
INSERT INTO `05diseases` VALUES ('10518', '肠梗阻伴粘连', '32', 'K56.501', 'CGZBNL', '');
INSERT INTO `05diseases` VALUES ('10519', '腹膜粘连伴肠梗阻', '89', 'K56.551', 'FMNLBCGZ', '');
INSERT INTO `05diseases` VALUES ('10520', '肠绞窄坏死', '259', 'K56.601', 'CJZHS', '');
INSERT INTO `05diseases` VALUES ('10521', '肠狭窄', '259', 'K56.602', 'CXZ', '');
INSERT INTO `05diseases` VALUES ('10522', '机械性肠梗阻', '32', 'K56.603', 'JXXCGZ', '');
INSERT INTO `05diseases` VALUES ('10523', '急性肠梗阻', '32', 'K56.604', 'JXCGZ', '');
INSERT INTO `05diseases` VALUES ('10524', '痉挛性肠梗阻(假性肠梗阻)', '179', 'K56.605', 'JLXCGZJXCGZ', '');
INSERT INTO `05diseases` VALUES ('10525', '肠坏疽伴梗阻', '259', 'K56.651', 'CHJBGZ', '');
INSERT INTO `05diseases` VALUES ('10526', '莱恩纽结', '278', 'K56.652', 'LENJ', '');
INSERT INTO `05diseases` VALUES ('10527', '上消化道梗阻', '387', 'K56.653', 'SXHDGZ', '');
INSERT INTO `05diseases` VALUES ('10528', '乙状结肠狭窄', '170', 'K56.654', 'YZJCXZ', '');
INSERT INTO `05diseases` VALUES ('10529', '不完全性肠梗阻', '32', 'K56.701', 'BWQXCGZ', '');
INSERT INTO `05diseases` VALUES ('10530', '肠梗阻', '32', 'K56.702', 'CGZ', '');
INSERT INTO `05diseases` VALUES ('10531', '十二指肠憩室伴穿孔', '321', 'K57.001', 'SEZCQSBCK', '');
INSERT INTO `05diseases` VALUES ('10532', '十二指肠憩室伴出血', '321', 'K57.051', 'SEZCQSBCX', '');
INSERT INTO `05diseases` VALUES ('10533', '小肠憩室病伴有腹膜炎', '90', 'K57.052', 'XCQSBBYFMY', '');
INSERT INTO `05diseases` VALUES ('10534', '小肠憩室病伴有穿孔和脓肿', '243', 'K57.053', 'XCQSBBYCKHNZ', '');
INSERT INTO `05diseases` VALUES ('10535', '回盲部憩室', '278', 'K57.101', 'HMBQS', '');
INSERT INTO `05diseases` VALUES ('10536', '空肠憩室', '259', 'K57.102', 'KCQS', '');
INSERT INTO `05diseases` VALUES ('10537', '空肠憩室炎', '259', 'K57.103', 'KCQSY', '');
INSERT INTO `05diseases` VALUES ('10538', '十二指肠憩室炎', '321', 'K57.104', 'SEZCQSY', '');
INSERT INTO `05diseases` VALUES ('10539', '小肠憩室', '389', 'K57.105', 'XCQS', '');
INSERT INTO `05diseases` VALUES ('10540', '小肠憩室炎', '389', 'K57.106', 'XCQSY', '');
INSERT INTO `05diseases` VALUES ('10541', '空肠憩室不伴有穿孔或脓肿', '243', 'K57.151', 'KCQSBBYCKHNZ', '');
INSERT INTO `05diseases` VALUES ('10542', '空肠憩室炎不伴有穿孔或脓肿', '243', 'K57.152', 'KCQSYBBYCKHNZ', '');
INSERT INTO `05diseases` VALUES ('10543', '回肠憩室不伴有穿孔或脓肿', '243', 'K57.153', 'HCQSBBYCKHNZ', '');
INSERT INTO `05diseases` VALUES ('10544', '十二指肠憩室不伴有穿孔或脓肿', '243', 'K57.154', 'SEZCQSBBYCKHNZ', '');
INSERT INTO `05diseases` VALUES ('10545', '十二指肠憩室炎不伴有穿孔或脓肿', '243', 'K57.155', 'SEZCQSYBBYCKHNZ', '');
INSERT INTO `05diseases` VALUES ('10546', '结肠憩室病伴有腹膜炎', '90', 'K57.251', 'JCQSBBYFMY', '');
INSERT INTO `05diseases` VALUES ('10547', '大肠憩室病伴有穿孔和脓肿', '243', 'K57.252', 'DCQSBBYCKHNZ', '');
INSERT INTO `05diseases` VALUES ('10548', '结肠憩室', '170', 'K57.301', 'JCQS', '');
INSERT INTO `05diseases` VALUES ('10549', '结肠憩室炎', '170', 'K57.302', 'JCQSY', '');
INSERT INTO `05diseases` VALUES ('10550', '盲肠憩室', '223', 'K57.303', 'MCQS', '');
INSERT INTO `05diseases` VALUES ('10551', '盲肠憩室炎', '223', 'K57.304', 'MCQSY', '');
INSERT INTO `05diseases` VALUES ('10552', '直肠憩室', '468', 'K57.305', 'ZCQS', '');
INSERT INTO `05diseases` VALUES ('10553', '直肠(乙状结肠)憩室不伴有穿孔或脓肿', '243', 'K57.351', 'ZCYZJCQSBBYCKHNZ', '');
INSERT INTO `05diseases` VALUES ('10554', '结肠憩室不伴有穿孔或脓肿', '243', 'K57.352', 'JCQSBBYCKHNZ', '');
INSERT INTO `05diseases` VALUES ('10555', '大肠憩室不伴有穿孔或脓肿', '243', 'K57.353', 'DCQSBBYCKHNZ', '');
INSERT INTO `05diseases` VALUES ('10556', '小肠和大肠憩室病伴有穿孔和脓肿', '243', 'K57.451', 'XCHDCQSBBYCKHNZ', '');
INSERT INTO `05diseases` VALUES ('10557', '小肠和大肠憩室病伴有伴腹膜炎', '90', 'K57.452', 'XCHDCQSBBYBFMY', '');
INSERT INTO `05diseases` VALUES ('10558', '小肠憩室不伴有穿孔或脓肿', '243', 'K57.551', 'XCQSBBYCKHNZ', '');
INSERT INTO `05diseases` VALUES ('10559', '小肠憩室炎不伴有穿孔或脓肿', '243', 'K57.552', 'XCQSYBBYCKHNZ', '');
INSERT INTO `05diseases` VALUES ('10560', '肠憩室病伴有伴腹膜炎', '90', 'K57.851', 'CQSBBYBFMY', '');
INSERT INTO `05diseases` VALUES ('10561', '肠憩室病伴有穿孔和脓肿 NOS', '243', 'K57.852', 'CQSBBYCKHNZ', '');
INSERT INTO `05diseases` VALUES ('10562', '消化道憩室 NOS', '387', 'K57.951', 'XHDQS', '');
INSERT INTO `05diseases` VALUES ('10563', '肠憩室', '259', 'K57.952', 'CQS', '');
INSERT INTO `05diseases` VALUES ('10564', '肠憩室病不伴有穿孔和脓肿 NOS', '243', 'K57.953', 'CQSBBBYCKHNZ', '');
INSERT INTO `05diseases` VALUES ('10565', '过敏性大肠综合征伴腹泻', '91', 'K58.051', 'GMXDCZHZBFX', '');
INSERT INTO `05diseases` VALUES ('10566', '过敏性结肠(痉挛性结肠炎，粘液性结肠炎)', '33', 'K58.901', 'GMXJCJLXJCYNYXJCY', '');
INSERT INTO `05diseases` VALUES ('10567', '肠痉挛', '179', 'K58.902', 'CJL', '');
INSERT INTO `05diseases` VALUES ('10568', '痉挛性结肠[结肠激惹综合征]', '179', 'K58.903', 'JLXJCJCJRZHZ', '');
INSERT INTO `05diseases` VALUES ('10569', '过敏性大肠综合征', '50', 'K58.951', 'GMXDCZHZ', '');
INSERT INTO `05diseases` VALUES ('10570', '过敏性肠综合征', '259', 'K58.952', 'GMXCZHZ', '');
INSERT INTO `05diseases` VALUES ('10571', '便秘(单纯性)(痉挛性)', '179', 'K59.001', 'BMDCXJLX', '');
INSERT INTO `05diseases` VALUES ('10572', '粪便潴留', '278', 'K59.002', 'FBZL', '');
INSERT INTO `05diseases` VALUES ('10573', '神经原性肠梗阻', '313', 'K59.051', 'SJYXCGZ', '');
INSERT INTO `05diseases` VALUES ('10574', '习惯性肠梗阻', '32', 'K59.052', 'XGXCGZ', '');
INSERT INTO `05diseases` VALUES ('10575', '功能性腹泻', '91', 'K59.101', 'GNXFX', '');
INSERT INTO `05diseases` VALUES ('10576', '神经源性肠 NEC', '313', 'K59.251', 'SJYXC', '');
INSERT INTO `05diseases` VALUES ('10577', '结肠扩张', '170', 'K59.351', 'JCKZ', '');
INSERT INTO `05diseases` VALUES ('10578', '巨结肠(非希尔施普龙氏病)(后天性)', '170', 'K59.352', 'JJCFXESPLSBHTX', '');
INSERT INTO `05diseases` VALUES ('10579', '中毒性巨结肠', '471', 'K59.353', 'ZDXJJC', '');
INSERT INTO `05diseases` VALUES ('10580', '后天性功能性巨结肠症[特发性巨结肠症；精神性巨结肠症]', '177', 'K59.354', 'HTXGNXJJCZTFXJJCZJSX', '');
INSERT INTO `05diseases` VALUES ('10581', '肛门痉挛', '179', 'K59.451', 'GMJL', '');
INSERT INTO `05diseases` VALUES ('10582', '肠道菌群失调', '31', 'K59.801', 'CDJQSD', '');
INSERT INTO `05diseases` VALUES ('10583', '肠扩张', '259', 'K59.802', 'CKZ', '');
INSERT INTO `05diseases` VALUES ('10584', '结肠脾曲综合征[PAYR综合征]', '253', 'K59.803', 'JCPQZHZZHZ', '');
INSERT INTO `05diseases` VALUES ('10585', '脾区综合征', '253', 'K59.804', 'PQZHZ', '');
INSERT INTO `05diseases` VALUES ('10586', '结肠松弛', '170', 'K59.851', 'JCSC', '');
INSERT INTO `05diseases` VALUES ('10587', '肠功能紊乱', '259', 'K59.901', 'CGNWL', '');
INSERT INTO `05diseases` VALUES ('10588', '急性肛裂', '278', 'K60.051', 'JXGL', '');
INSERT INTO `05diseases` VALUES ('10589', '慢性肛裂', '278', 'K60.151', 'MXGL', '');
INSERT INTO `05diseases` VALUES ('10590', '肛裂', '278', 'K60.201', 'GL', '');
INSERT INTO `05diseases` VALUES ('10591', '肛瘘', '212', 'K60.301', 'GL', '');
INSERT INTO `05diseases` VALUES ('10592', '肛门瘘管', '212', 'K60.302', 'GMLG', '');
INSERT INTO `05diseases` VALUES ('10593', '直肠会阴瘘', '212', 'K60.401', 'ZCHYL', '');
INSERT INTO `05diseases` VALUES ('10594', '直肠瘘', '212', 'K60.402', 'ZCL', '');
INSERT INTO `05diseases` VALUES ('10595', '肛门直肠瘘', '212', 'K60.551', 'GMZCL', '');
INSERT INTO `05diseases` VALUES ('10596', '肛门旁皮下脓肿', '243', 'K61.001', 'GMPPXNZ', '');
INSERT INTO `05diseases` VALUES ('10597', '肛周脓肿', '243', 'K61.002', 'GZNZ', '');
INSERT INTO `05diseases` VALUES ('10598', '直肠脓肿', '243', 'K61.101', 'ZCNZ', '');
INSERT INTO `05diseases` VALUES ('10599', '肛门直肠脓肿', '243', 'K61.251', 'GMZCNZ', '');
INSERT INTO `05diseases` VALUES ('10600', '坐骨直肠脓肿', '243', 'K61.351', 'ZGZCNZ', '');
INSERT INTO `05diseases` VALUES ('10601', '坐骨直肠窝脓肿', '243', 'K61.352', 'ZGZCWNZ', '');
INSERT INTO `05diseases` VALUES ('10602', '括约肌内脓肿', '243', 'K61.451', 'KYJNNZ', '');
INSERT INTO `05diseases` VALUES ('10603', '肛门息肉', '374', 'K62.001', 'GMXR', '');
INSERT INTO `05diseases` VALUES ('10604', '直肠息肉', '374', 'K62.101', 'ZCXR', '');
INSERT INTO `05diseases` VALUES ('10605', '肛门脱垂(脱肛)', '96', 'K62.201', 'GMTCTG', '');
INSERT INTO `05diseases` VALUES ('10606', '直肠粘膜脱垂', '468', 'K62.301', 'ZCNMTC', '');
INSERT INTO `05diseases` VALUES ('10607', '直肠脱垂', '468', 'K62.302', 'ZCTC', '');
INSERT INTO `05diseases` VALUES ('10608', '男性直肠膨出', '468', 'K62.351', 'NXZCPC', '');
INSERT INTO `05diseases` VALUES ('10609', '肛门狭窄', '96', 'K62.401', 'GMXZ', '');
INSERT INTO `05diseases` VALUES ('10610', '直肠狭窄', '468', 'K62.402', 'ZCXZ', '');
INSERT INTO `05diseases` VALUES ('10611', '手术后肛门狭窄', '330', 'K62.451', 'SSHGMXZ', '');
INSERT INTO `05diseases` VALUES ('10612', '手术后直肠狭窄', '330', 'K62.452', 'SSHZCXZ', '');
INSERT INTO `05diseases` VALUES ('10613', '肛门出血', '38', 'K62.551', 'GMCX', '');
INSERT INTO `05diseases` VALUES ('10614', '直肠出血', '38', 'K62.552', 'ZCCX', '');
INSERT INTO `05diseases` VALUES ('10615', '肛周溃疡', '195', 'K62.601', 'GZKY', '');
INSERT INTO `05diseases` VALUES ('10616', '直肠溃疡', '195', 'K62.602', 'ZCKY', '');
INSERT INTO `05diseases` VALUES ('10617', '放射性直肠炎', '33', 'K62.751', 'FSXZCY', '');
INSERT INTO `05diseases` VALUES ('10618', '出血性直肠炎', '33', 'K62.801', 'CXXZCY', '');
INSERT INTO `05diseases` VALUES ('10619', '肛管囊肿', '231', 'K62.802', 'GGNZ', '');
INSERT INTO `05diseases` VALUES ('10620', '肛管炎', '277', 'K62.803', 'GGY', '');
INSERT INTO `05diseases` VALUES ('10621', '肛门囊肿', '231', 'K62.804', 'GMNZ', '');
INSERT INTO `05diseases` VALUES ('10622', '肛周感染', '95', 'K62.805', 'GZGR', '');
INSERT INTO `05diseases` VALUES ('10623', '肛乳头肥大', '86', 'K62.806', 'GRTFD', '');
INSERT INTO `05diseases` VALUES ('10624', '巨直肠', '468', 'K62.807', 'JZC', '');
INSERT INTO `05diseases` VALUES ('10625', '慢性肛管直肠炎', '33', 'K62.808', 'MXGGZCY', '');
INSERT INTO `05diseases` VALUES ('10626', '慢性直肠炎', '33', 'K62.809', 'MXZCY', '');
INSERT INTO `05diseases` VALUES ('10627', '直肠穿孔', '468', 'K62.810', 'ZCCK', '');
INSERT INTO `05diseases` VALUES ('10628', '直肠囊肿', '231', 'K62.811', 'ZCNZ', '');
INSERT INTO `05diseases` VALUES ('10629', '直肠前突', '468', 'K62.812', 'ZCQT', '');
INSERT INTO `05diseases` VALUES ('10630', '直肠肉芽肿', '295', 'K62.813', 'ZCRYZ', '');
INSERT INTO `05diseases` VALUES ('10631', '直肠吻合口瘢痕', '191', 'K62.814', 'ZCWHKBH', '');
INSERT INTO `05diseases` VALUES ('10632', '直肠炎', '33', 'K62.815', 'ZCY', '');
INSERT INTO `05diseases` VALUES ('10633', '创伤性肛门闭锁', '44', 'K62.851', 'CSXGMBS', '');
INSERT INTO `05diseases` VALUES ('10634', '肛门括约肌松驰', '96', 'K62.852', 'GMKYJSC', '');
INSERT INTO `05diseases` VALUES ('10635', '肛乳头炎', '86', 'K62.853', 'GRTY', '');
INSERT INTO `05diseases` VALUES ('10636', '肛隐窝炎', '277', 'K62.854', 'GYWY', '');
INSERT INTO `05diseases` VALUES ('10637', '肛周炎', '97', 'K62.855', 'GZY', '');
INSERT INTO `05diseases` VALUES ('10638', '肛部痈', '451', 'K62.856', 'GBY', '');
INSERT INTO `05diseases` VALUES ('10639', '肛旁肿物', '278', 'K62.901', 'GPZW', '');
INSERT INTO `05diseases` VALUES ('10640', '直肠肿物', '468', 'K62.902', 'ZCZW', '');
INSERT INTO `05diseases` VALUES ('10641', '肠脓肿', '243', 'K63.001', 'CNZ', '');
INSERT INTO `05diseases` VALUES ('10642', '肠穿孔(非创伤性)', '44', 'K63.101', 'CCKFCSX', '');
INSERT INTO `05diseases` VALUES ('10643', '肠破裂(非创伤性)', '44', 'K63.102', 'CPLFCSX', '');
INSERT INTO `05diseases` VALUES ('10644', '结肠穿孔(非创伤性)', '44', 'K63.103', 'JCCKFCSX', '');
INSERT INTO `05diseases` VALUES ('10645', '小肠穿孔(非创伤性)', '44', 'K63.104', 'XCCKFCSX', '');
INSERT INTO `05diseases` VALUES ('10646', '乙状结肠穿孔(非创伤性)', '44', 'K63.151', 'YZJCCKFCSX', '');
INSERT INTO `05diseases` VALUES ('10647', '手术后大肠瘘', '330', 'K63.201', 'SSHDCL', '');
INSERT INTO `05diseases` VALUES ('10648', '手术后小肠瘘', '330', 'K63.202', 'SSHXCL', '');
INSERT INTO `05diseases` VALUES ('10649', '肠瘘', '212', 'K63.203', 'CL', '');
INSERT INTO `05diseases` VALUES ('10650', '腹壁肠瘘', '212', 'K63.204', 'FBCL', '');
INSERT INTO `05diseases` VALUES ('10651', '腹壁瘘管', '212', 'K63.205', 'FBLG', '');
INSERT INTO `05diseases` VALUES ('10652', '结肠瘘', '212', 'K63.206', 'JCL', '');
INSERT INTO `05diseases` VALUES ('10653', '结肠胸腔瘘', '212', 'K63.207', 'JCXQL', '');
INSERT INTO `05diseases` VALUES ('10654', '盲肠腹壁瘘', '212', 'K63.208', 'MCFBL', '');
INSERT INTO `05diseases` VALUES ('10655', '盲管瘘', '212', 'K63.209', 'MGL', '');
INSERT INTO `05diseases` VALUES ('10656', '盆腔腹壁瘘', '212', 'K63.210', 'PQFBL', '');
INSERT INTO `05diseases` VALUES ('10657', '手术后肠腹壁瘘', '330', 'K63.211', 'SSHCFBL', '');
INSERT INTO `05diseases` VALUES ('10658', '手术后肠瘘', '330', 'K63.212', 'SSHCL', '');
INSERT INTO `05diseases` VALUES ('10659', '结肠溃疡', '195', 'K63.301', 'JCKY', '');
INSERT INTO `05diseases` VALUES ('10660', '盲肠溃疡', '195', 'K63.302', 'MCKY', '');
INSERT INTO `05diseases` VALUES ('10661', '小肠溃疡', '195', 'K63.303', 'XCKY', '');
INSERT INTO `05diseases` VALUES ('10662', '原发性小肠溃疡[原发性非特异性小肠溃疡]', '195', 'K63.351', 'YFXXCKYYFXFTYXXCKY', '');
INSERT INTO `05diseases` VALUES ('10663', '回肠溃疡', '195', 'K63.352', 'HCKY', '');
INSERT INTO `05diseases` VALUES ('10664', '回肠粘膜脱垂', '259', 'K63.401', 'HCNMTC', '');
INSERT INTO `05diseases` VALUES ('10665', '结肠下垂', '170', 'K63.402', 'JCXC', '');
INSERT INTO `05diseases` VALUES ('10666', '内脏下垂', '278', 'K63.403', 'NZXC', '');
INSERT INTO `05diseases` VALUES ('10667', '肠下垂', '259', 'K63.451', 'CXC', '');
INSERT INTO `05diseases` VALUES ('10668', '盲肠下垂', '223', 'K63.452', 'MCXC', '');
INSERT INTO `05diseases` VALUES ('10669', '结肠息肉', '374', 'K63.501', 'JCXR', '');
INSERT INTO `05diseases` VALUES ('10670', '结肠积气', '170', 'K63.801', 'JCJQ', '');
INSERT INTO `05diseases` VALUES ('10671', '肠息肉', '374', 'K63.802', 'CXR', '');
INSERT INTO `05diseases` VALUES ('10672', '结肠脂肪垂', '170', 'K63.803', 'JCZFC', '');
INSERT INTO `05diseases` VALUES ('10673', '肠炎性包块', '33', 'K63.804', 'CYXBK', '');
INSERT INTO `05diseases` VALUES ('10674', '盲肠息肉', '374', 'K63.805', 'MCXR', '');
INSERT INTO `05diseases` VALUES ('10675', '结肠黑变病', '170', 'K63.806', 'JCHBB', '');
INSERT INTO `05diseases` VALUES ('10676', '小肠肉芽肿', '295', 'K63.807', 'XCRYZ', '');
INSERT INTO `05diseases` VALUES ('10677', '小肠息肉', '374', 'K63.808', 'XCXR', '');
INSERT INTO `05diseases` VALUES ('10678', '结肠囊肿', '231', 'K63.851', 'JCNZ', '');
INSERT INTO `05diseases` VALUES ('10679', '肠肉芽肿', '295', 'K63.852', 'CRYZ', '');
INSERT INTO `05diseases` VALUES ('10680', '大肠炎性息肉', '33', 'K63.853', 'DCYXXR', '');
INSERT INTO `05diseases` VALUES ('10681', '大肠幼年性息肉(幼年性腺瘤；潴留性息肉)', '261', 'K63.854', 'DCYNXXRYNXXLZLXXR', '');
INSERT INTO `05diseases` VALUES ('10682', '大肠增生性息肉(化生性息肉)', '374', 'K63.855', 'DCZSXXRHSXXR', '');
INSERT INTO `05diseases` VALUES ('10683', '结肠肿物', '170', 'K63.901', 'JCZW', '');
INSERT INTO `05diseases` VALUES ('10684', '肠病', '259', 'K63.951', 'CB', '');
INSERT INTO `05diseases` VALUES ('10685', '肠切除后综合征[短肠综合征]', '259', 'K63.952', 'CQCHZHZDCZHZ', '');
INSERT INTO `05diseases` VALUES ('10686', '回盲部肿物', '278', 'K63.953', 'HMBZW', '');
INSERT INTO `05diseases` VALUES ('10687', '肠系膜脓肿', '243', 'K65.001', 'CXMNZ', '');
INSERT INTO `05diseases` VALUES ('10688', '腹膜脓肿', '243', 'K65.002', 'FMNZ', '');
INSERT INTO `05diseases` VALUES ('10689', '腹腔脓肿', '243', 'K65.003', 'FQNZ', '');
INSERT INTO `05diseases` VALUES ('10690', '膈下脓肿', '243', 'K65.004', 'GXNZ', '');
INSERT INTO `05diseases` VALUES ('10691', '化脓性腹膜炎', '90', 'K65.005', 'HNXFMY', '');
INSERT INTO `05diseases` VALUES ('10692', '急性腹膜炎', '90', 'K65.006', 'JXFMY', '');
INSERT INTO `05diseases` VALUES ('10693', '急性化脓性弥漫性腹膜炎', '90', 'K65.007', 'JXHNXMMXFMY', '');
INSERT INTO `05diseases` VALUES ('10694', '急性弥漫性腹膜炎', '90', 'K65.008', 'JXMMXFMY', '');
INSERT INTO `05diseases` VALUES ('10695', '弥漫性腹膜炎', '90', 'K65.009', 'MMXFMY', '');
INSERT INTO `05diseases` VALUES ('10696', '男性盆腔脓肿', '243', 'K65.010', 'NXPQNZ', '');
INSERT INTO `05diseases` VALUES ('10697', '男性盆腔炎', '249', 'K65.011', 'NXPQY', '');
INSERT INTO `05diseases` VALUES ('10698', '男性盆腔炎性包块', '249', 'K65.012', 'NXPQYXBK', '');
INSERT INTO `05diseases` VALUES ('10699', '细菌性腹膜炎', '380', 'K65.013', 'XJXFMY', '');
INSERT INTO `05diseases` VALUES ('10700', '感染性腹膜炎', '95', 'K65.051', 'GRXFMY', '');
INSERT INTO `05diseases` VALUES ('10701', '胰腺性腹膜炎', '262', 'K65.052', 'YXXFMY', '');
INSERT INTO `05diseases` VALUES ('10702', '肠间脓肿(腹中部脓肿)', '243', 'K65.053', 'CJNZFZBNZ', '');
INSERT INTO `05diseases` VALUES ('10703', '网膜脓肿', '243', 'K65.054', 'WMNZ', '');
INSERT INTO `05diseases` VALUES ('10704', '肠系膜炎', '259', 'K65.801', 'CXMY', '');
INSERT INTO `05diseases` VALUES ('10705', '出血性腹膜炎', '90', 'K65.802', 'CXXFMY', '');
INSERT INTO `05diseases` VALUES ('10706', '穿孔性腹膜炎', '90', 'K65.803', 'CKXFMY', '');
INSERT INTO `05diseases` VALUES ('10707', '胆汁性腹膜炎', '53', 'K65.804', 'DZXFMY', '');
INSERT INTO `05diseases` VALUES ('10708', '多发性浆膜腔积液', '278', 'K65.805', 'DFXJMQJY', '');
INSERT INTO `05diseases` VALUES ('10709', '多发性桨膜炎', '277', 'K65.806', 'DFXJMY', '');
INSERT INTO `05diseases` VALUES ('10710', '多浆膜炎', '164', 'K65.807', 'DJMY', '');
INSERT INTO `05diseases` VALUES ('10711', '局限性腹膜炎', '90', 'K65.808', 'JXXFMY', '');
INSERT INTO `05diseases` VALUES ('10712', '慢性腹膜炎', '90', 'K65.809', 'MXFMY', '');
INSERT INTO `05diseases` VALUES ('10713', '肠系膜性纤维性脂膜炎[收缩性肠系膜炎]', '259', 'K65.851', 'CXMXXWXZMYSSXCXMY', '');
INSERT INTO `05diseases` VALUES ('10714', '肺炎球菌性腹膜炎', '81', 'K65.852', 'FYQJXFMY', '');
INSERT INTO `05diseases` VALUES ('10715', '慢性增生性腹膜炎', '90', 'K65.853', 'MXZSXFMY', '');
INSERT INTO `05diseases` VALUES ('10716', '肉芽肿性腹膜炎', '90', 'K65.854', 'RYZXFMY', '');
INSERT INTO `05diseases` VALUES ('10717', '硬化性腹膜炎', '90', 'K65.855', 'YHXFMY', '');
INSERT INTO `05diseases` VALUES ('10718', '腹膜脂肪坏死', '89', 'K65.856', 'FMZFHS', '');
INSERT INTO `05diseases` VALUES ('10719', '腹膜后感染', '95', 'K65.901', 'FMHGR', '');
INSERT INTO `05diseases` VALUES ('10720', '腹膜炎 NOS', '90', 'K65.902', 'FMY', '');
INSERT INTO `05diseases` VALUES ('10721', '腹腔感染', '95', 'K65.903', 'FQGR', '');
INSERT INTO `05diseases` VALUES ('10722', '继发性腹膜炎', '90', 'K65.904', 'JFXFMY', '');
INSERT INTO `05diseases` VALUES ('10723', '原发性腹膜炎', '90', 'K65.905', 'YFXFMY', '');
INSERT INTO `05diseases` VALUES ('10724', '腹壁感染', '95', 'K65.951', 'FBGR', '');
INSERT INTO `05diseases` VALUES ('10725', '粘连性腹膜炎', '90', 'K65.952', 'NLXFMY', '');
INSERT INTO `05diseases` VALUES ('10726', '网膜炎', '277', 'K65.953', 'WMY', '');
INSERT INTO `05diseases` VALUES ('10727', '肠系膜粘连', '259', 'K66.001', 'CXMNL', '');
INSERT INTO `05diseases` VALUES ('10728', '肠粘连', '259', 'K66.002', 'CNL', '');
INSERT INTO `05diseases` VALUES ('10729', '大网膜粘连', '278', 'K66.003', 'DWMNL', '');
INSERT INTO `05diseases` VALUES ('10730', '腹膜粘连', '89', 'K66.004', 'FMNL', '');
INSERT INTO `05diseases` VALUES ('10731', '腹腔粘连', '264', 'K66.005', 'FQNL', '');
INSERT INTO `05diseases` VALUES ('10732', '膈肌粘连', '267', 'K66.006', 'GJNL', '');
INSERT INTO `05diseases` VALUES ('10733', '膈粘连', '278', 'K66.051', 'GNL', '');
INSERT INTO `05diseases` VALUES ('10734', '粘液性结肠炎', '33', 'K66.052', 'NYXJCY', '');
INSERT INTO `05diseases` VALUES ('10735', '胃粘连', '370', 'K66.053', 'WNL', '');
INSERT INTO `05diseases` VALUES ('10736', '腹膜后血肿', '422', 'K66.101', 'FMHXZ', '');
INSERT INTO `05diseases` VALUES ('10737', '腹腔积血', '264', 'K66.102', 'FQJX', '');
INSERT INTO `05diseases` VALUES ('10738', '血腹', '264', 'K66.151', 'XF', '');
INSERT INTO `05diseases` VALUES ('10739', '自发性血腹', '264', 'K66.152', 'ZFXXF', '');
INSERT INTO `05diseases` VALUES ('10740', '肠系膜钙化', '259', 'K66.801', 'CXMGH', '');
INSERT INTO `05diseases` VALUES ('10741', '肠系膜囊肿', '231', 'K66.802', 'CXMNZ', '');
INSERT INTO `05diseases` VALUES ('10742', '骶前囊肿', '231', 'K66.803', 'DQNZ', '');
INSERT INTO `05diseases` VALUES ('10743', '腹膜后囊肿', '231', 'K66.804', 'FMHNZ', '');
INSERT INTO `05diseases` VALUES ('10744', '网膜囊肿', '231', 'K66.805', 'WMNZ', '');
INSERT INTO `05diseases` VALUES ('10745', '腹壁肉芽肿', '295', 'K66.851', 'FBRYZ', '');
INSERT INTO `05diseases` VALUES ('10746', '腹膜增生症', '89', 'K66.852', 'FMZSZ', '');
INSERT INTO `05diseases` VALUES ('10747', '大网膜机化', '278', 'K66.853', 'DWMJH', '');
INSERT INTO `05diseases` VALUES ('10748', '腹膜后肿物', '89', 'K66.901', 'FMHZW', '');
INSERT INTO `05diseases` VALUES ('10749', '腹膜疾患 NOS', '89', 'K66.951', 'FMJH', '');
INSERT INTO `05diseases` VALUES ('10750', '齐夫综合症', '278', 'K70.051', 'QFZHZ', '');
INSERT INTO `05diseases` VALUES ('10751', '酒精性脂肪肝', '92', 'K70.052', 'JJXZFG', '');
INSERT INTO `05diseases` VALUES ('10752', '酒精性肝炎', '93', 'K70.101', 'JJXGY', '');
INSERT INTO `05diseases` VALUES ('10753', '急性酒精性肝炎', '93', 'K70.151', 'JXJJXGY', '');
INSERT INTO `05diseases` VALUES ('10754', '酒精性肝纤维化', '92', 'K70.251', 'JJXGXWH', '');
INSERT INTO `05diseases` VALUES ('10755', '酒精性肝硬化', '92', 'K70.301', 'JJXGYH', '');
INSERT INTO `05diseases` VALUES ('10756', '急性酒精性肝衰竭', '92', 'K70.451', 'JXJJXGSJ', '');
INSERT INTO `05diseases` VALUES ('10757', '慢性酒精性肝衰竭', '92', 'K70.452', 'MXJJXGSJ', '');
INSERT INTO `05diseases` VALUES ('10758', '亚急性酒精性肝衰竭', '92', 'K70.453', 'YJXJJXGSJ', '');
INSERT INTO `05diseases` VALUES ('10759', '酒精性肝衰竭', '92', 'K70.454', 'JJXGSJ', '');
INSERT INTO `05diseases` VALUES ('10760', '酒精性肝衰竭伴有肝昏迷', '92', 'K70.455', 'JJXGSJBYGHM', '');
INSERT INTO `05diseases` VALUES ('10761', '酒精性肝损坏', '92', 'K70.901', 'JJXGSH', '');
INSERT INTO `05diseases` VALUES ('10762', '中毒性肝病伴胆汁郁积', '53', 'K71.051', 'ZDXGBBDZYJ', '');
INSERT INTO `05diseases` VALUES ('10763', '中毒性肝病伴肝坏死', '92', 'K71.151', 'ZDXGBBGHS', '');
INSERT INTO `05diseases` VALUES ('10764', '中毒性肝病伴急性肝病', '92', 'K71.251', 'ZDXGBBJXGB', '');
INSERT INTO `05diseases` VALUES ('10765', '中毒性肝病伴慢性迁延肝炎', '93', 'K71.351', 'ZDXGBBMXQYGY', '');
INSERT INTO `05diseases` VALUES ('10766', '中毒性肝病伴有慢性小叶性肝炎', '93', 'K71.451', 'ZDXGBBYMXXYXGY', '');
INSERT INTO `05diseases` VALUES ('10767', '中毒性肝病伴狼疮状肝炎', '93', 'K71.551', 'ZDXGBBLCZGY', '');
INSERT INTO `05diseases` VALUES ('10768', '中毒性肝病伴有慢性活动性肝炎', '93', 'K71.552', 'ZDXGBBYMXHDXGY', '');
INSERT INTO `05diseases` VALUES ('10769', '药物性肝炎', '93', 'K71.601', 'YWXGY', '');
INSERT INTO `05diseases` VALUES ('10770', '中毒性肝炎', '93', 'K71.602', 'ZDXGY', '');
INSERT INTO `05diseases` VALUES ('10771', '药物性肝硬变', '92', 'K71.701', 'YWXGYB', '');
INSERT INTO `05diseases` VALUES ('10772', '中毒性肝病伴有肝纤维化和硬变', '92', 'K71.751', 'ZDXGBBYGXWHHYB', '');
INSERT INTO `05diseases` VALUES ('10773', '中毒性肝病伴有局灶性结节性增生', '92', 'K71.851', 'ZDXGBBYJZXJJXZS', '');
INSERT INTO `05diseases` VALUES ('10774', '中毒性肝病伴有肝肉芽肿', '92', 'K71.852', 'ZDXGBBYGRYZ', '');
INSERT INTO `05diseases` VALUES ('10775', '中毒性肝病伴有紫癜性肝炎', '93', 'K71.853', 'ZDXGBBYZDXGY', '');
INSERT INTO `05diseases` VALUES ('10776', '中毒性肝病伴有肝静脉闭塞', '92', 'K71.854', 'ZDXGBBYGJMBS', '');
INSERT INTO `05diseases` VALUES ('10777', '药物性肝损害', '92', 'K71.901', 'YWXGSH', '');
INSERT INTO `05diseases` VALUES ('10778', '中毒性肝病 NOS', '92', 'K71.951', 'ZDXGB', '');
INSERT INTO `05diseases` VALUES ('10779', '急性肝功能衰竭', '92', 'K72.001', 'JXGGNSJ', '');
INSERT INTO `05diseases` VALUES ('10780', '急性肝衰竭', '92', 'K72.002', 'JXGSJ', '');
INSERT INTO `05diseases` VALUES ('10781', '急性肝炎(非病毒性)', '93', 'K72.003', 'JXGYFBDX', '');
INSERT INTO `05diseases` VALUES ('10782', '急性黄疸型肝炎', '93', 'K72.004', 'JXHDXGY', '');
INSERT INTO `05diseases` VALUES ('10783', '急性黄色肝萎缩[罗布尔氏病]', '92', 'K72.005', 'JXHSGWSLBESB', '');
INSERT INTO `05diseases` VALUES ('10784', '亚急性肝坏死', '92', 'K72.006', 'YJXGHS', '');
INSERT INTO `05diseases` VALUES ('10785', '亚急性肝炎', '93', 'K72.007', 'YJXGY', '');
INSERT INTO `05diseases` VALUES ('10786', '亚急性肝衰竭', '92', 'K72.051', 'YJXGSJ', '');
INSERT INTO `05diseases` VALUES ('10787', '急性肝萎缩', '92', 'K72.052', 'JXGWS', '');
INSERT INTO `05diseases` VALUES ('10788', '慢性肝炎伴亚急性肝坏死', '93', 'K72.053', 'MXGYBYJXGHS', '');
INSERT INTO `05diseases` VALUES ('10789', '慢性肝衰竭', '92', 'K72.151', 'MXGSJ', '');
INSERT INTO `05diseases` VALUES ('10790', '慢性肝萎缩', '92', 'K72.152', 'MXGWS', '');
INSERT INTO `05diseases` VALUES ('10791', '肝功能衰竭', '92', 'K72.901', 'GGNSJ', '');
INSERT INTO `05diseases` VALUES ('10792', '肝坏死(重症肝炎)', '93', 'K72.902', 'GHSZZGY', '');
INSERT INTO `05diseases` VALUES ('10793', '肝昏迷(肝性脑病)', '92', 'K72.903', 'GHMGXNB', '');
INSERT INTO `05diseases` VALUES ('10794', '肝萎缩', '92', 'K72.904', 'GWS', '');
INSERT INTO `05diseases` VALUES ('10795', '慢性迁延性肝炎', '93', 'K73.001', 'MXQYXGY', '');
INSERT INTO `05diseases` VALUES ('10796', '慢性小叶性肝炎', '93', 'K73.151', 'MXXYXGY', '');
INSERT INTO `05diseases` VALUES ('10797', '慢性活动性肝炎', '93', 'K73.201', 'MXHDXGY', '');
INSERT INTO `05diseases` VALUES ('10798', '狼疮状肝炎', '93', 'K73.251', 'LCZGY', '');
INSERT INTO `05diseases` VALUES ('10799', '慢性复发性肝炎', '93', 'K73.801', 'MXFFXGY', '');
INSERT INTO `05diseases` VALUES ('10800', '慢性肝炎', '93', 'K73.901', 'MXGY', '');
INSERT INTO `05diseases` VALUES ('10801', '慢性肝炎、重型', '93', 'K73.902', 'MXGYZX', '');
INSERT INTO `05diseases` VALUES ('10802', '肝纤维化', '92', 'K74.001', 'GXWH', '');
INSERT INTO `05diseases` VALUES ('10803', '肝硬化', '92', 'K74.151', 'GYH', '');
INSERT INTO `05diseases` VALUES ('10804', '肝纤维化伴有肝硬化', '92', 'K74.251', 'GXWHBYGYH', '');
INSERT INTO `05diseases` VALUES ('10805', '阿诺(肥大性)肝硬变', '92', 'K74.351', 'ANFDXGYB', '');
INSERT INTO `05diseases` VALUES ('10806', '慢性非化脓性破坏性胆管炎', '53', 'K74.352', 'MXFHNXPHXDGY', '');
INSERT INTO `05diseases` VALUES ('10807', '托德硬变(肝)', '92', 'K74.353', 'TDYBG', '');
INSERT INTO `05diseases` VALUES ('10808', '继发性胆汁型肝硬变', '53', 'K74.451', 'JFXDZXGYB', '');
INSERT INTO `05diseases` VALUES ('10809', '胆汁性肝硬变', '53', 'K74.501', 'DZXGYB', '');
INSERT INTO `05diseases` VALUES ('10810', '肝炎后肝硬变', '93', 'K74.601', 'GYHGYB', '');
INSERT INTO `05diseases` VALUES ('10811', '肝硬变', '92', 'K74.602', 'GYB', '');
INSERT INTO `05diseases` VALUES ('10812', '坏死后肝硬变', '92', 'K74.603', 'HSHGYB', '');
INSERT INTO `05diseases` VALUES ('10813', '结节性肝硬变', '92', 'K74.604', 'JJXGYB', '');
INSERT INTO `05diseases` VALUES ('10814', '慢性间质性肝炎', '93', 'K74.605', 'MXJZXGY', '');
INSERT INTO `05diseases` VALUES ('10815', '门脉性肝硬变', '92', 'K74.606', 'MMXGYB', '');
INSERT INTO `05diseases` VALUES ('10816', '血吸虫性肝硬化', '92', 'K74.607', 'XXCXGYH', '');
INSERT INTO `05diseases` VALUES ('10817', '肝硬变伴食管静脉曲张', '92', 'K74.608+', 'GYBBSGJMQZ', '');
INSERT INTO `05diseases` VALUES ('10818', '肝硬变伴食管静脉曲张破裂出血', '92', 'K74.609+', 'GYBBSGJMQZPLCX', '');
INSERT INTO `05diseases` VALUES ('10819', '代谢性肝硬变', '92', 'K74.651', 'DXXGYB', '');
INSERT INTO `05diseases` VALUES ('10820', '肥大性肝硬变', '92', 'K74.652', 'FDXGYB', '');
INSERT INTO `05diseases` VALUES ('10821', '肝硬变伴腹水', '92', 'K74.653', 'GYBBFS', '');
INSERT INTO `05diseases` VALUES ('10822', '中毒性肝硬化', '92', 'K74.654', 'ZDXGYH', '');
INSERT INTO `05diseases` VALUES ('10823', '拉埃内克肝硬变', '92', 'K74.655', 'LANKGYB', '');
INSERT INTO `05diseases` VALUES ('10824', '鲍姆加滕－克吕韦耶肝硬变[先天性肝硬化]', '92', 'K74.656', 'BMJTKLWYGYBXTXGYH', '');
INSERT INTO `05diseases` VALUES ('10825', '肝脓肿', '243', 'K75.001', 'GNZ', '');
INSERT INTO `05diseases` VALUES ('10826', '急性化脓性肝胆管炎', '53', 'K75.002', 'JXHNXGDGY', '');
INSERT INTO `05diseases` VALUES ('10827', '细菌性肝脓肿', '380', 'K75.051', 'XJXGNZ', '');
INSERT INTO `05diseases` VALUES ('10828', '门静脉炎', '185', 'K75.101', 'MJMY', '');
INSERT INTO `05diseases` VALUES ('10829', '门静脉毒血症', '181', 'K75.151', 'MJMDXZ', '');
INSERT INTO `05diseases` VALUES ('10830', '非特异性反应肝炎', '93', 'K75.251', 'FTYXFYGY', '');
INSERT INTO `05diseases` VALUES ('10831', '肝肉芽肿', '92', 'K75.301', 'GRYZ', '');
INSERT INTO `05diseases` VALUES ('10832', '胆小管炎性肝炎', '93', 'K75.801', 'DXGYXGY', '');
INSERT INTO `05diseases` VALUES ('10833', '胆汁郁积性肝炎', '93', 'K75.802', 'DZYJXGY', '');
INSERT INTO `05diseases` VALUES ('10834', '肝胆管炎', '53', 'K75.803', 'GDGY', '');
INSERT INTO `05diseases` VALUES ('10835', '肝内胆管炎', '53', 'K75.804', 'GNDGY', '');
INSERT INTO `05diseases` VALUES ('10836', '肝炎性假瘤', '93', 'K75.805', 'GYXJL', '');
INSERT INTO `05diseases` VALUES ('10837', '肝炎性肿物', '93', 'K75.806', 'GYXZW', '');
INSERT INTO `05diseases` VALUES ('10838', '药物性胆汁郁积性肝炎', '93', 'K75.807', 'YWXDZYJXGY', '');
INSERT INTO `05diseases` VALUES ('10839', '营养性肝炎', '93', 'K75.808', 'YYXGY', '');
INSERT INTO `05diseases` VALUES ('10840', '自家免疫性肝炎', '93', 'K75.809', 'ZJMYXGY', '');
INSERT INTO `05diseases` VALUES ('10841', '瘀胆型病毒性肝炎 [毛细胆管性肝炎]', '93', 'K75.851', 'YDXBDXGYMXDGXGY', '');
INSERT INTO `05diseases` VALUES ('10842', '肝炎', '93', 'K75.901', 'GY', '');
INSERT INTO `05diseases` VALUES ('10843', '肝炎综合征', '93', 'K75.902', 'GYZHZ', '');
INSERT INTO `05diseases` VALUES ('10844', '脂肪肝', '92', 'K76.001', 'ZFG', '');
INSERT INTO `05diseases` VALUES ('10845', '肝[脏]脂肪变', '92', 'K76.051', 'GZZFB', '');
INSERT INTO `05diseases` VALUES ('10846', '中毒性(急性)肝脂肪变性', '92', 'K76.052', 'ZDXJXGZFBX', '');
INSERT INTO `05diseases` VALUES ('10847', '慢性被动性肝郁血', '92', 'K76.101', 'MXBDXGYX', '');
INSERT INTO `05diseases` VALUES ('10848', '心源性肝硬变', '92', 'K76.102', 'XYXGYB', '');
INSERT INTO `05diseases` VALUES ('10849', '淤血性肝损坏', '92', 'K76.103', 'YXXGSH', '');
INSERT INTO `05diseases` VALUES ('10850', '郁滞肝', '92', 'K76.104', 'YZG', '');
INSERT INTO `05diseases` VALUES ('10851', '肝中心出血性坏死', '92', 'K76.251', 'GZXCXXHS', '');
INSERT INTO `05diseases` VALUES ('10852', '肝梗塞', '92', 'K76.301', 'GGS', '');
INSERT INTO `05diseases` VALUES ('10853', '紫癜性肝炎', '93', 'K76.451', 'ZDXGY', '');
INSERT INTO `05diseases` VALUES ('10854', '肝血管瘤病', '92', 'K76.452', 'GXGLB', '');
INSERT INTO `05diseases` VALUES ('10855', '肝静脉闭塞性病', '92', 'K76.551', 'GJMBSXB', '');
INSERT INTO `05diseases` VALUES ('10856', '班替氏综合征', '278', 'K76.601', 'BTSZHZ', '');
INSERT INTO `05diseases` VALUES ('10857', '门脉高压', '278', 'K76.602', 'MMGY', '');
INSERT INTO `05diseases` VALUES ('10858', '特发性门脉高压', '278', 'K76.603', 'TFXMMGY', '');
INSERT INTO `05diseases` VALUES ('10859', '肝肾功能衰竭', '92', 'K76.701', 'GSGNSJ', '');
INSERT INTO `05diseases` VALUES ('10860', '肝肾综合征', '92', 'K76.702', 'GSZHZ', '');
INSERT INTO `05diseases` VALUES ('10861', '肝癌破裂出血', '92', 'K76.801', 'GAPLCX', '');
INSERT INTO `05diseases` VALUES ('10862', '肝出血', '92', 'K76.802', 'GCX', '');
INSERT INTO `05diseases` VALUES ('10863', '肝多发性再生肥大结节', '92', 'K76.803', 'GDFXZSFDJJ', '');
INSERT INTO `05diseases` VALUES ('10864', '肝肺综合征', '92', 'K76.804', 'GFZHZ', '');
INSERT INTO `05diseases` VALUES ('10865', '肝钙化灶', '92', 'K76.805', 'GGHZ', '');
INSERT INTO `05diseases` VALUES ('10866', '肝功能不全', '92', 'K76.806', 'GGNBQ', '');
INSERT INTO `05diseases` VALUES ('10867', '肝管出血', '92', 'K76.807', 'GGCX', '');
INSERT INTO `05diseases` VALUES ('10868', '肝管息肉', '92', 'K76.808', 'GGXR', '');
INSERT INTO `05diseases` VALUES ('10869', '肝积液', '92', 'K76.809', 'GJY', '');
INSERT INTO `05diseases` VALUES ('10870', '肝内钙化点', '92', 'K76.810', 'GNGHD', '');
INSERT INTO `05diseases` VALUES ('10871', '肝囊肿', '92', 'K76.811', 'GNZ', '');
INSERT INTO `05diseases` VALUES ('10872', '肝细胞性黄疸', '137', 'K76.812', 'GXBXHD', '');
INSERT INTO `05diseases` VALUES ('10873', '肝下垂', '92', 'K76.813', 'GXC', '');
INSERT INTO `05diseases` VALUES ('10874', '肝血肿', '92', 'K76.814', 'GXZ', '');
INSERT INTO `05diseases` VALUES ('10875', '肝炎后黄疸', '137', 'K76.815', 'GYHHD', '');
INSERT INTO `05diseases` VALUES ('10876', '肝增生性结节', '92', 'K76.816', 'GZSXJJ', '');
INSERT INTO `05diseases` VALUES ('10877', '肝自发性破裂出血', '92', 'K76.817', 'GZFXPLCX', '');
INSERT INTO `05diseases` VALUES ('10878', '肝黑变病', '92', 'K76.851', 'GHBB', '');
INSERT INTO `05diseases` VALUES ('10879', '肝痛', '92', 'K76.852', 'GT', '');
INSERT INTO `05diseases` VALUES ('10880', '肝源性水肿', '92', 'K76.854', 'GYXSZ', '');
INSERT INTO `05diseases` VALUES ('10881', '肝局灶结节性增生', '92', 'K76.855', 'GJZJJXZS', '');
INSERT INTO `05diseases` VALUES ('10882', '肝病', '92', 'K76.901', 'GB', '');
INSERT INTO `05diseases` VALUES ('10883', '肝损害', '92', 'K76.902', 'GSH', '');
INSERT INTO `05diseases` VALUES ('10884', '肝占位性病变', '92', 'K76.903', 'GZWXBB', '');
INSERT INTO `05diseases` VALUES ('10885', '肝肿物', '92', 'K76.904', 'GZW', '');
INSERT INTO `05diseases` VALUES ('10886', '慢性肝损害', '92', 'K76.905', 'MXGSH', '');
INSERT INTO `05diseases` VALUES ('10887', '胆囊结石伴坏疽性胆囊炎', '53', 'K80.001', 'DNJSBHJXDNY', '');
INSERT INTO `05diseases` VALUES ('10888', '胆囊结石伴急性胆囊炎(胆石症伴急性胆囊炎)', '53', 'K80.002', 'DNJSBJXDNYDSZBJXDNY', '');
INSERT INTO `05diseases` VALUES ('10889', '胆囊结石伴急性化脓性胆囊炎', '53', 'K80.051', 'DNJSBJXHNXDNY', '');
INSERT INTO `05diseases` VALUES ('10890', '胆囊结石伴胆囊炎', '53', 'K80.101', 'DNJSBDNY', '');
INSERT INTO `05diseases` VALUES ('10891', '胆囊结石伴慢性胆囊炎', '53', 'K80.102', 'DNJSBMXDNY', '');
INSERT INTO `05diseases` VALUES ('10892', '胆囊结石伴萎缩性胆囊炎', '53', 'K80.151', 'DNJSBWSXDNY', '');
INSERT INTO `05diseases` VALUES ('10893', '残余胆囊结石', '53', 'K80.201', 'CYDNJS', '');
INSERT INTO `05diseases` VALUES ('10894', '胆囊绞痛(复发性)', '53', 'K80.202', 'DNJTFFX', '');
INSERT INTO `05diseases` VALUES ('10895', '胆囊结石', '53', 'K80.203', 'DNJS', '');
INSERT INTO `05diseases` VALUES ('10896', '胆囊结石嵌顿', '53', 'K80.204', 'DNJSQD', '');
INSERT INTO `05diseases` VALUES ('10897', '胆囊管结石', '53', 'K80.251', 'DNGJS', '');
INSERT INTO `05diseases` VALUES ('10898', '总胆管结石伴急性化脓性胆管炎', '53', 'K80.301', 'ZDGJSBJXHNXDGY', '');
INSERT INTO `05diseases` VALUES ('10899', '胆管结石伴有胆管炎', '53', 'K80.351', 'DGJSBYDGY', '');
INSERT INTO `05diseases` VALUES ('10900', '胆管结石伴(慢性)胆囊炎', '53', 'K80.401', 'DGJSBMXDNY', '');
INSERT INTO `05diseases` VALUES ('10901', '胆总管结石伴(慢性)胆囊炎', '53', 'K80.402', 'DZGJSBMXDNY', '');
INSERT INTO `05diseases` VALUES ('10902', '胆管结石伴急性胆囊炎', '53', 'K80.403', 'DGJSBJXDNY', '');
INSERT INTO `05diseases` VALUES ('10903', '胆总管结石伴急性胆囊炎', '53', 'K80.404', 'DZGJSBJXDNY', '');
INSERT INTO `05diseases` VALUES ('10904', '肝胆管结石伴(慢性)胆囊炎', '53', 'K80.405', 'GDGJSBMXDNY', '');
INSERT INTO `05diseases` VALUES ('10905', '肝管结石伴(慢性)胆囊炎', '53', 'K80.406', 'GGJSBMXDNY', '');
INSERT INTO `05diseases` VALUES ('10906', '肝管结石伴慢性胆囊炎', '53', 'K80.407', 'GGJSBMXDNY', '');
INSERT INTO `05diseases` VALUES ('10907', '总胆管结石伴慢性胆囊炎', '53', 'K80.408', 'ZDGJSBMXDNY', '');
INSERT INTO `05diseases` VALUES ('10908', '胆道术后残留结石', '53', 'K80.501', 'DDSHCLJS', '');
INSERT INTO `05diseases` VALUES ('10909', '胆管结石', '53', 'K80.502', 'DGJS', '');
INSERT INTO `05diseases` VALUES ('10910', '胆绞痛', '53', 'K80.503', 'DJT', '');
INSERT INTO `05diseases` VALUES ('10911', '胆总管结石', '53', 'K80.504', 'DZGJS', '');
INSERT INTO `05diseases` VALUES ('10912', '胆总管残余结石', '53', 'K80.505', 'DZGCYJS', '');
INSERT INTO `05diseases` VALUES ('10913', '复发性肝绞痛', '92', 'K80.506', 'FFXGJT', '');
INSERT INTO `05diseases` VALUES ('10914', '肝胆管结石', '53', 'K80.507', 'GDGJS', '');
INSERT INTO `05diseases` VALUES ('10915', '肝管结石', '92', 'K80.508', 'GGJS', '');
INSERT INTO `05diseases` VALUES ('10916', '肝结石', '92', 'K80.551', 'GJS', '');
INSERT INTO `05diseases` VALUES ('10917', '胆道腹腔镜(LC)术后胆管结石', '53', 'K80.552', 'DDFQJSHDGJS', '');
INSERT INTO `05diseases` VALUES ('10918', '胆管结石伴梗阻', '53', 'K80.553', 'DGJSBGZ', '');
INSERT INTO `05diseases` VALUES ('10919', '原发性胆管结石[胆红素钙结石]', '53', 'K80.554', 'YFXDGJSDHSGJS', '');
INSERT INTO `05diseases` VALUES ('10920', '法特氏壶腹结石', '264', 'K80.555', 'FTSHFJS', '');
INSERT INTO `05diseases` VALUES ('10921', '夏科热(胆)(肝)(间歇性)', '53', 'K80.556', 'XKRDGJXX', '');
INSERT INTO `05diseases` VALUES ('10922', '其他胆石病', '53', 'K80.851', 'QTDSB', '');
INSERT INTO `05diseases` VALUES ('10923', '胆囊坏疽', '53', 'K81.001', 'DNHJ', '');
INSERT INTO `05diseases` VALUES ('10924', '胆囊脓肿', '53', 'K81.002', 'DNNZ', '');
INSERT INTO `05diseases` VALUES ('10925', '胆囊周围脓肿', '53', 'K81.003', 'DNZWNZ', '');
INSERT INTO `05diseases` VALUES ('10926', '急性胆囊炎', '53', 'K81.004', 'JXDNY', '');
INSERT INTO `05diseases` VALUES ('10927', '急性化脓性胆囊炎', '53', 'K81.005', 'JXHNXDNY', '');
INSERT INTO `05diseases` VALUES ('10928', '急性坏疽性胆囊炎', '53', 'K81.006', 'JXHJXDNY', '');
INSERT INTO `05diseases` VALUES ('10929', '慢性胆囊炎急性发作', '53', 'K81.007', 'MXDNYJXFZ', '');
INSERT INTO `05diseases` VALUES ('10930', '坏疽性胆囊炎', '53', 'K81.051', 'HJXDNY', '');
INSERT INTO `05diseases` VALUES ('10931', '慢性胆囊炎', '53', 'K81.101', 'MXDNY', '');
INSERT INTO `05diseases` VALUES ('10932', '胆囊周炎', '53', 'K81.801', 'DNZY', '');
INSERT INTO `05diseases` VALUES ('10933', '其他胆囊炎', '53', 'K81.851', 'QTDNY', '');
INSERT INTO `05diseases` VALUES ('10934', '萎缩性胆囊炎', '53', 'K81.852', 'WSXDNY', '');
INSERT INTO `05diseases` VALUES ('10935', '息肉性胆囊炎', '53', 'K81.853', 'XRXDNY', '');
INSERT INTO `05diseases` VALUES ('10936', '胆囊炎 NOS', '53', 'K81.901', 'DNY', '');
INSERT INTO `05diseases` VALUES ('10937', '胆囊管梗阻', '53', 'K82.001', 'DNGGZ', '');
INSERT INTO `05diseases` VALUES ('10938', '梗阻性黄疸(胆囊)', '137', 'K82.002', 'GZXHDDN', '');
INSERT INTO `05diseases` VALUES ('10939', '梗阻性胆囊肿大', '53', 'K82.051', 'GZXDNZD', '');
INSERT INTO `05diseases` VALUES ('10940', '胆囊积液', '53', 'K82.101', 'DNJY', '');
INSERT INTO `05diseases` VALUES ('10941', '胆囊粘液囊肿', '53', 'K82.151', 'DNNYNZ', '');
INSERT INTO `05diseases` VALUES ('10942', '胆囊穿孔', '53', 'K82.201', 'DNCK', '');
INSERT INTO `05diseases` VALUES ('10943', '胆囊肠瘘', '53', 'K82.301', 'DNCL', '');
INSERT INTO `05diseases` VALUES ('10944', '胆囊结肠瘘', '53', 'K82.302', 'DNJCL', '');
INSERT INTO `05diseases` VALUES ('10945', '胆囊瘘', '53', 'K82.303', 'DNL', '');
INSERT INTO `05diseases` VALUES ('10946', '胆囊十二指肠瘘', '53', 'K82.304', 'DNSEZCL', '');
INSERT INTO `05diseases` VALUES ('10947', '胆囊胃瘘', '53', 'K82.305', 'DNWL', '');
INSERT INTO `05diseases` VALUES ('10948', '手术后胆囊瘘', '53', 'K82.306', 'SSHDNL', '');
INSERT INTO `05diseases` VALUES ('10949', '胆囊肝总管瘘', '53', 'K82.351', 'DNGZGL', '');
INSERT INTO `05diseases` VALUES ('10950', '胆固醇性胆囊炎', '53', 'K82.401', 'DGCXDNY', '');
INSERT INTO `05diseases` VALUES ('10951', '胆囊胆固醇沉着症', '53', 'K82.402', 'DNDGCCZZ', '');
INSERT INTO `05diseases` VALUES ('10952', '胆固醇性胆囊息肉伴慢性胆囊炎', '53', 'K82.451', 'DGCXDNXRBMXDNY', '');
INSERT INTO `05diseases` VALUES ('10953', '草霉状胆囊', '53', 'K82.452', 'CMZDN', '');
INSERT INTO `05diseases` VALUES ('10954', '胆囊管扩张', '53', 'K82.801', 'DNGKZ', '');
INSERT INTO `05diseases` VALUES ('10955', '胆囊沉积物', '53', 'K82.802', 'DNCJW', '');
INSERT INTO `05diseases` VALUES ('10956', '胆囊肥大', '53', 'K82.803', 'DNFD', '');
INSERT INTO `05diseases` VALUES ('10957', '胆囊钙化', '53', 'K82.804', 'DNGH', '');
INSERT INTO `05diseases` VALUES ('10958', '胆囊肌腺症', '53', 'K82.805', 'DNJXZ', '');
INSERT INTO `05diseases` VALUES ('10959', '胆囊扭转', '53', 'K82.806', 'DNNZ', '');
INSERT INTO `05diseases` VALUES ('10960', '胆囊萎缩', '53', 'K82.807', 'DNWS', '');
INSERT INTO `05diseases` VALUES ('10961', '胆囊息肉', '53', 'K82.808', 'DNXR', '');
INSERT INTO `05diseases` VALUES ('10962', '胆囊缺如', '53', 'K82.851', 'DNQR', '');
INSERT INTO `05diseases` VALUES ('10963', '胆囊囊肿', '53', 'K82.852', 'DNNZ', '');
INSERT INTO `05diseases` VALUES ('10964', '胆囊溃疡', '53', 'K82.853', 'DNKY', '');
INSERT INTO `05diseases` VALUES ('10965', '胆囊运动障碍', '53', 'K82.854', 'DNYDZA', '');
INSERT INTO `05diseases` VALUES ('10966', '胆囊病变', '53', 'K82.901', 'DNBB', '');
INSERT INTO `05diseases` VALUES ('10967', '胆囊占位性病变', '53', 'K82.902', 'DNZWXBB', '');
INSERT INTO `05diseases` VALUES ('10968', '胆囊肿物', '53', 'K82.903', 'DNZW', '');
INSERT INTO `05diseases` VALUES ('10969', '胆心综合征', '53', 'K82.951', 'DXZHZ', '');
INSERT INTO `05diseases` VALUES ('10970', '胆囊病 NOS', '53', 'K82.952', 'DNB', '');
INSERT INTO `05diseases` VALUES ('10971', '奥狄氏括约肌炎', '146', 'K83.001', 'ADSKYJY', '');
INSERT INTO `05diseases` VALUES ('10972', '胆道感染', '53', 'K83.002', 'DDGR', '');
INSERT INTO `05diseases` VALUES ('10973', '胆管炎', '53', 'K83.003', 'DGY', '');
INSERT INTO `05diseases` VALUES ('10974', '胆管周围炎', '53', 'K83.004', 'DGZWY', '');
INSERT INTO `05diseases` VALUES ('10975', '胆总管炎', '53', 'K83.005', 'DZGY', '');
INSERT INTO `05diseases` VALUES ('10976', '返流性胆管炎', '53', 'K83.006', 'FLXDGY', '');
INSERT INTO `05diseases` VALUES ('10977', '复发性胆管炎', '53', 'K83.007', 'FFXDGY', '');
INSERT INTO `05diseases` VALUES ('10978', '梗阻性胆管炎', '53', 'K83.008', 'GZXDGY', '');
INSERT INTO `05diseases` VALUES ('10979', '梗阻性化脓性胆管炎', '53', 'K83.009', 'GZXHNXDGY', '');
INSERT INTO `05diseases` VALUES ('10980', '化脓性胆管炎', '53', 'K83.010', 'HNXDGY', '');
INSERT INTO `05diseases` VALUES ('10981', '急性胆管炎', '53', 'K83.011', 'JXDGY', '');
INSERT INTO `05diseases` VALUES ('10982', '急性梗阻性胆管炎', '53', 'K83.012', 'JXGZXDGY', '');
INSERT INTO `05diseases` VALUES ('10983', '急性化脓性胆管炎', '53', 'K83.013', 'JXHNXDGY', '');
INSERT INTO `05diseases` VALUES ('10984', '急性化脓性梗阻性胆管炎', '53', 'K83.014', 'JXHNXGZXDGY', '');
INSERT INTO `05diseases` VALUES ('10985', '慢性胆管炎', '53', 'K83.015', 'MXDGY', '');
INSERT INTO `05diseases` VALUES ('10986', '硬化性胆管炎', '53', 'K83.016', 'YHXDGY', '');
INSERT INTO `05diseases` VALUES ('10987', '淤积性胆管炎', '53', 'K83.017', 'YJXDGY', '');
INSERT INTO `05diseases` VALUES ('10988', '毛细胆管炎', '53', 'K83.051', 'MXDGY', '');
INSERT INTO `05diseases` VALUES ('10989', '缩窄性胆管炎', '53', 'K83.052', 'SZXDGY', '');
INSERT INTO `05diseases` VALUES ('10990', '中毒性胆管炎', '53', 'K83.053', 'ZDXDGY', '');
INSERT INTO `05diseases` VALUES ('10991', '肝内性胆总管炎', '53', 'K83.054', 'GNXDZGY', '');
INSERT INTO `05diseases` VALUES ('10992', '化脓性胆总管炎', '53', 'K83.055', 'HNXDZGY', '');
INSERT INTO `05diseases` VALUES ('10993', '十二指肠胆管炎', '53', 'K83.056', 'SEZCDGY', '');
INSERT INTO `05diseases` VALUES ('10994', '肝管梗阻综合征', '92', 'K83.101', 'GGGZZHZ', '');
INSERT INTO `05diseases` VALUES ('10995', '胆管狭窄', '53', 'K83.102', 'DGXZ', '');
INSERT INTO `05diseases` VALUES ('10996', '胆管阻塞', '53', 'K83.103', 'DGZS', '');
INSERT INTO `05diseases` VALUES ('10997', '胆汁郁积症', '53', 'K83.104', 'DZYJZ', '');
INSERT INTO `05diseases` VALUES ('10998', '胆总管阻塞', '53', 'K83.105', 'DZGZS', '');
INSERT INTO `05diseases` VALUES ('10999', '胆总管梗阻', '53', 'K83.106', 'DZGGZ', '');
INSERT INTO `05diseases` VALUES ('11000', '胆总管狭窄', '53', 'K83.107', 'DZGXZ', '');
INSERT INTO `05diseases` VALUES ('11001', '肝胆管狭窄', '53', 'K83.108', 'GDGXZ', '');
INSERT INTO `05diseases` VALUES ('11002', '肝管狭窄', '92', 'K83.109', 'GGXZ', '');
INSERT INTO `05diseases` VALUES ('11003', '原发性胆管狭窄', '53', 'K83.151', 'YFXDGXZ', '');
INSERT INTO `05diseases` VALUES ('11004', '胆管穿孔', '53', 'K83.201', 'DGCK', '');
INSERT INTO `05diseases` VALUES ('11005', '胆管瘘', '53', 'K83.301', 'DGL', '');
INSERT INTO `05diseases` VALUES ('11006', '手术后胆总管小肠瘘', '53', 'K83.302', 'SSHDZGXCL', '');
INSERT INTO `05diseases` VALUES ('11007', '手术后肝总管小肠瘘', '92', 'K83.303', 'SSHGZGXCL', '');
INSERT INTO `05diseases` VALUES ('11008', '总胆管十二指肠瘘', '53', 'K83.304', 'ZDGSEZCL', '');
INSERT INTO `05diseases` VALUES ('11009', '奥狄氏扩约肌痉挛', '179', 'K83.401', 'ADSKYJJL', '');
INSERT INTO `05diseases` VALUES ('11010', '法特壶腹痉挛', '179', 'K83.451', 'FTHFJL', '');
INSERT INTO `05diseases` VALUES ('11011', '欧狄氏括约肌痉挛', '179', 'K83.452', 'ODSKYJJL', '');
INSERT INTO `05diseases` VALUES ('11012', '胆管囊肿', '53', 'K83.501', 'DGNZ', '');
INSERT INTO `05diseases` VALUES ('11013', '胆总管(肝总管)囊肿', '53', 'K83.502', 'DZGGZGNZ', '');
INSERT INTO `05diseases` VALUES ('11014', '奥狄氏括约肌狭窄', '267', 'K83.801', 'ADSKYJXZ', '');
INSERT INTO `05diseases` VALUES ('11015', '缩窄性法特氏乳头炎', '86', 'K83.802', 'SZXFTSRTY', '');
INSERT INTO `05diseases` VALUES ('11016', '胆管出血', '53', 'K83.803', 'DGCX', '');
INSERT INTO `05diseases` VALUES ('11017', '胆管溃疡', '53', 'K83.804', 'DGKY', '');
INSERT INTO `05diseases` VALUES ('11018', '胆总管痉挛', '53', 'K83.805', 'DZGJL', '');
INSERT INTO `05diseases` VALUES ('11019', '胆总管扩张', '53', 'K83.806', 'DZGKZ', '');
INSERT INTO `05diseases` VALUES ('11020', '肝胆管扩张', '53', 'K83.807', 'GDGKZ', '');
INSERT INTO `05diseases` VALUES ('11021', '胆管扩张', '53', 'K83.851', 'DGKZ', '');
INSERT INTO `05diseases` VALUES ('11022', '胆总管息肉', '53', 'K83.852', 'DZGXR', '');
INSERT INTO `05diseases` VALUES ('11023', '胆总管粘连', '53', 'K83.853', 'DZGNL', '');
INSERT INTO `05diseases` VALUES ('11024', '肝囊管综合征', '92', 'K83.951', 'GNGZHZ', '');
INSERT INTO `05diseases` VALUES ('11025', '梗阻性黄疸', '137', 'K83.952', 'GZXHD', '');
INSERT INTO `05diseases` VALUES ('11026', '胆源性胰腺炎', '53', 'K85.X01', 'DYXYXY', '');
INSERT INTO `05diseases` VALUES ('11027', '化脓性胰腺炎', '437', 'K85.X02', 'HNXYXY', '');
INSERT INTO `05diseases` VALUES ('11028', '急性出血坏死性胰腺炎', '437', 'K85.X03', 'JXCXHSXYXY', '');
INSERT INTO `05diseases` VALUES ('11029', '急性出血性胰腺炎', '437', 'K85.X04', 'JXCXXYXY', '');
INSERT INTO `05diseases` VALUES ('11030', '急性坏死性胰腺炎', '437', 'K85.X05', 'JXHSXYXY', '');
INSERT INTO `05diseases` VALUES ('11031', '急性水肿性胰腺炎', '437', 'K85.X06', 'JXSZXYXY', '');
INSERT INTO `05diseases` VALUES ('11032', '急性胰腺炎', '437', 'K85.X07', 'JXYXY', '');
INSERT INTO `05diseases` VALUES ('11033', '慢性胰腺炎急性发作', '437', 'K85.X08', 'MXYXYJXFZ', '');
INSERT INTO `05diseases` VALUES ('11034', '亚急性胰腺炎', '437', 'K85.X09', 'YJXYXY', '');
INSERT INTO `05diseases` VALUES ('11035', '胰腺脓肿', '243', 'K85.X10', 'YXNZ', '');
INSERT INTO `05diseases` VALUES ('11036', '胰腺炎', '437', 'K85.X11', 'YXY', '');
INSERT INTO `05diseases` VALUES ('11037', '注射后胰腺炎', '437', 'K85.X12', 'ZSHYXY', '');
INSERT INTO `05diseases` VALUES ('11038', '急性胰坏死', '435', 'K85.X51', 'JXYHS', '');
INSERT INTO `05diseases` VALUES ('11039', '坏疽性胰腺炎', '437', 'K85.X52', 'HJXYXY', '');
INSERT INTO `05diseases` VALUES ('11040', '环状胰腺炎', '437', 'K85.X53', 'HZYXY', '');
INSERT INTO `05diseases` VALUES ('11041', '急性间质性胰腺炎', '437', 'K85.X54', 'JXJZXYXY', '');
INSERT INTO `05diseases` VALUES ('11042', '急性重症胰腺炎', '437', 'K85.X55', 'JXZZYXY', '');
INSERT INTO `05diseases` VALUES ('11043', '胰腺炎猝死[猝死型急性胰腺炎暴发性胰腺坏死]', '437', 'K85.X56', 'YXYCSCSXJXYXYBFXYXHS', '');
INSERT INTO `05diseases` VALUES ('11044', '胰腺坏死', '262', 'K85.X57', 'YXHS', '');
INSERT INTO `05diseases` VALUES ('11045', '酒精性慢性胰腺炎', '437', 'K86.051', 'JJXMXYXY', '');
INSERT INTO `05diseases` VALUES ('11046', '药物性胰腺炎', '437', 'K86.052', 'YWXYXY', '');
INSERT INTO `05diseases` VALUES ('11047', '复发性胰腺炎', '437', 'K86.101', 'FFXYXY', '');
INSERT INTO `05diseases` VALUES ('11048', '慢性胰腺炎', '437', 'K86.102', 'MXYXY', '');
INSERT INTO `05diseases` VALUES ('11049', '胆石性胰腺炎', '53', 'K86.151', 'DSXYXY', '');
INSERT INTO `05diseases` VALUES ('11050', '高血钙性胰腺炎', '437', 'K86.152', 'GXGXYXY', '');
INSERT INTO `05diseases` VALUES ('11051', '慢性间质性胰腺炎', '437', 'K86.153', 'MXJZXYXY', '');
INSERT INTO `05diseases` VALUES ('11052', '纤维性胰腺炎', '437', 'K86.154', 'XWXYXY', '');
INSERT INTO `05diseases` VALUES ('11053', '胰腺囊肿', '262', 'K86.201', 'YXNZ', '');
INSERT INTO `05diseases` VALUES ('11054', '真性胰腺囊肿', '262', 'K86.251', 'ZXYXNZ', '');
INSERT INTO `05diseases` VALUES ('11055', '胰腺假囊肿', '262', 'K86.301', 'YXJNZ', '');
INSERT INTO `05diseases` VALUES ('11056', '胰大', '435', 'K86.801', 'YD', '');
INSERT INTO `05diseases` VALUES ('11057', '胰胆管扩张', '53', 'K86.802', 'YDGKZ', '');
INSERT INTO `05diseases` VALUES ('11058', '胰岛组织硬化', '435', 'K86.803', 'YDZZYH', '');
INSERT INTO `05diseases` VALUES ('11059', '胰管梗阻', '435', 'K86.804', 'YGGZ', '');
INSERT INTO `05diseases` VALUES ('11060', '胰管痉挛', '179', 'K86.805', 'YGJL', '');
INSERT INTO `05diseases` VALUES ('11061', '胰管扩张', '435', 'K86.806', 'YGKZ', '');
INSERT INTO `05diseases` VALUES ('11062', '胰管狭窄', '435', 'K86.807', 'YGXZ', '');
INSERT INTO `05diseases` VALUES ('11063', '胰坏死', '435', 'K86.808', 'YHS', '');
INSERT INTO `05diseases` VALUES ('11064', '胰结石', '435', 'K86.809', 'YJS', '');
INSERT INTO `05diseases` VALUES ('11065', '胰瘘', '212', 'K86.810', 'YL', '');
INSERT INTO `05diseases` VALUES ('11066', '胰腺钙化', '262', 'K86.811', 'YXGH', '');
INSERT INTO `05diseases` VALUES ('11067', '胰腺肉芽肿', '262', 'K86.812', 'YXRYZ', '');
INSERT INTO `05diseases` VALUES ('11068', '胰腺腹水', '262', 'K86.851', 'YXFS', '');
INSERT INTO `05diseases` VALUES ('11069', '胰腺萎缩', '262', 'K86.852', 'YXWS', '');
INSERT INTO `05diseases` VALUES ('11070', '胰腺硬化', '262', 'K86.853', 'YXYH', '');
INSERT INTO `05diseases` VALUES ('11071', '脂肪性胰腺坏死', '262', 'K86.854', 'ZFXYXHS', '');
INSERT INTO `05diseases` VALUES ('11072', '胰腺肿物', '262', 'K86.901', 'YXZW', '');
INSERT INTO `05diseases` VALUES ('11073', '胰占位性病变', '435', 'K86.902', 'YZWXBB', '');
INSERT INTO `05diseases` VALUES ('11074', '胰胆综合征', '53', 'K86.951', 'YDZHZ', '');
INSERT INTO `05diseases` VALUES ('11075', '非热带性口炎性腹泻', '91', 'K90.001', 'FRDXKYXFX', '');
INSERT INTO `05diseases` VALUES ('11076', '谷胶肠病', '259', 'K90.002', 'GJCB', '');
INSERT INTO `05diseases` VALUES ('11077', '乳糜泻(脂泻病)', '268', 'K90.003', 'RMXZXB', '');
INSERT INTO `05diseases` VALUES ('11078', '腹性佝偻病', '264', 'K90.051', 'FXGLB', '');
INSERT INTO `05diseases` VALUES ('11079', '口炎性腹泻', '91', 'K90.151', 'KYXFX', '');
INSERT INTO `05diseases` VALUES ('11080', '热带性脂肪痢', '271', 'K90.152', 'RDXZFL', '');
INSERT INTO `05diseases` VALUES ('11081', '盲袢综合征 (非手术性)', '330', 'K90.201', 'MPZHZFSSX', '');
INSERT INTO `05diseases` VALUES ('11082', '胰性脂肪痢', '435', 'K90.351', 'YXZFL', '');
INSERT INTO `05diseases` VALUES ('11083', '脂肪吸收不良', '278', 'K90.401', 'ZFXSBL', '');
INSERT INTO `05diseases` VALUES ('11084', '淀粉耐受不良引起的吸收障碍', '373', 'K90.451', 'DFNSBLYQDXSZA', '');
INSERT INTO `05diseases` VALUES ('11085', '蛋白耐受不良引起的吸收障碍', '373', 'K90.452', 'DBNSBLYQDXSZA', '');
INSERT INTO `05diseases` VALUES ('11086', '脂肪耐受不良引起的吸收障碍', '373', 'K90.453', 'ZFNSBLYQDXSZA', '');
INSERT INTO `05diseases` VALUES ('11087', '碳水化合物耐受不良引起的吸收障碍', '373', 'K90.454', 'TSHHWNSBLYQDXSZA', '');
INSERT INTO `05diseases` VALUES ('11088', '原发性小肠吸收不良综合征', '389', 'K90.801', 'YFXXCXSBLZHZ', '');
INSERT INTO `05diseases` VALUES ('11089', '肠源性脂肪代谢障碍[惠普尔氏病]', '259', 'K90.802+', 'CYXZFDXZAHPESB', '');
INSERT INTO `05diseases` VALUES ('11091', '肠吸收不良', '259', 'K90.901', 'CXSBL', '');
INSERT INTO `05diseases` VALUES ('11092', '小肠吸收不良综合征(非手术性)', '330', 'K90.902', 'XCXSBLZHZFSSX', '');
INSERT INTO `05diseases` VALUES ('11093', '原发性小肠吸收不良', '389', 'K90.951', 'YFXXCXSBL', '');
INSERT INTO `05diseases` VALUES ('11094', '胃肠手术后呕吐', '370', 'K91.001', 'WCSSHOT', '');
INSERT INTO `05diseases` VALUES ('11095', '迟发型倾倒综合征', '278', 'K91.101', 'CFXQDZHZ', '');
INSERT INTO `05diseases` VALUES ('11096', '迷走神经切断术后综合征', '313', 'K91.102', 'MZSJQDSHZHZ', '');
INSERT INTO `05diseases` VALUES ('11097', '倾倒综合征(胃切除术后综合征)', '370', 'K91.103', 'QDZHZWQCSHZHZ', '');
INSERT INTO `05diseases` VALUES ('11098', '胃手术后综合征', '370', 'K91.104', 'WSSHZHZ', '');
INSERT INTO `05diseases` VALUES ('11099', '胃肠吻合口炎', '370', 'K91.151', 'WCWHKY', '');
INSERT INTO `05diseases` VALUES ('11100', '短肠综合征(肠切除后综合征)', '259', 'K91.201', 'DCZHZCQCHZHZ', '');
INSERT INTO `05diseases` VALUES ('11101', '手术后吸收不良综合征', '330', 'K91.202', 'SSHXSBLZHZ', '');
INSERT INTO `05diseases` VALUES ('11102', '手术后盲袢综合征', '330', 'K91.251', 'SSHMPZHZ', '');
INSERT INTO `05diseases` VALUES ('11103', '手术后肠梗阻', '330', 'K91.301', 'SSHCGZ', '');
INSERT INTO `05diseases` VALUES ('11104', '手术后幽门梗阻', '330', 'K91.351', 'SSHYMGZ', '');
INSERT INTO `05diseases` VALUES ('11105', '肠造瘘术后功能障碍', '330', 'K91.401', 'CZLSHGNZA', '');
INSERT INTO `05diseases` VALUES ('11106', '假肛口瘢痕狭窄', '191', 'K91.402', 'JGKBHXZ', '');
INSERT INTO `05diseases` VALUES ('11107', '结肠造口术后狭窄', '330', 'K91.403', 'JCZKSHXZ', '');
INSERT INTO `05diseases` VALUES ('11108', '胃肠吻合口瘘', '370', 'K91.451', 'WCWHKL', '');
INSERT INTO `05diseases` VALUES ('11109', '胆囊切除术后综合征', '53', 'K91.501', 'DNQCSHZHZ', '');
INSERT INTO `05diseases` VALUES ('11110', '胆道腹腔镜术后(LC)胆道感染', '53', 'K91.551', 'DDFQJSHDDGR', '');
INSERT INTO `05diseases` VALUES ('11111', '胆道术后胆道感染', '53', 'K91.552', 'DDSHDDGR', '');
INSERT INTO `05diseases` VALUES ('11112', '残窦综合征(胃切除术后)', '370', 'K91.801', 'CDZHZWQCSH', '');
INSERT INTO `05diseases` VALUES ('11113', '残胃炎', '371', 'K91.802', 'CWY', '');
INSERT INTO `05diseases` VALUES ('11114', '肠吻合口狭窄', '191', 'K91.803', 'CWHKXZ', '');
INSERT INTO `05diseases` VALUES ('11115', '胆管十二指肠吻合口狭窄', '53', 'K91.804', 'DGSEZCWHKXZ', '');
INSERT INTO `05diseases` VALUES ('11116', '胆囊空肠吻合口狭窄', '53', 'K91.805', 'DNKCWHKXZ', '');
INSERT INTO `05diseases` VALUES ('11117', '胆囊切除术后粘连', '53', 'K91.806', 'DNQCSHNL', '');
INSERT INTO `05diseases` VALUES ('11118', '肝管空肠吻合口狭窄', '92', 'K91.807', 'GGKCWHKXZ', '');
INSERT INTO `05diseases` VALUES ('11119', '食管空肠吻合口狭窄', '191', 'K91.808', 'SGKCWHKXZ', '');
INSERT INTO `05diseases` VALUES ('11120', '食管胃吻合口狭窄', '370', 'K91.809', 'SGWWHKXZ', '');
INSERT INTO `05diseases` VALUES ('11121', '手术后肠粘连', '330', 'K91.810', 'SSHCNL', '');
INSERT INTO `05diseases` VALUES ('11122', '手术后胆管闭锁', '53', 'K91.811', 'SSHDGBS', '');
INSERT INTO `05diseases` VALUES ('11123', '手术后胆管狭窄', '53', 'K91.812', 'SSHDGXZ', '');
INSERT INTO `05diseases` VALUES ('11124', '手术后肝管狭窄', '92', 'K91.813', 'SSHGGXZ', '');
INSERT INTO `05diseases` VALUES ('11125', '手术后肝外胆管狭窄', '53', 'K91.814', 'SSHGWDGXZ', '');
INSERT INTO `05diseases` VALUES ('11126', '手术后胃肠功能紊乱', '370', 'K91.815', 'SSHWCGNWL', '');
INSERT INTO `05diseases` VALUES ('11127', '胃肠吻合口机能障碍', '370', 'K91.817', 'WCWHKJNZA', '');
INSERT INTO `05diseases` VALUES ('11128', '胃肠吻合口水肿', '370', 'K91.818', 'WCWHKSZ', '');
INSERT INTO `05diseases` VALUES ('11129', '胃肠吻合口狭窄', '370', 'K91.819', 'WCWHKXZ', '');
INSERT INTO `05diseases` VALUES ('11130', '胃肠吻合术后输出袢梗阻', '370', 'K91.820', 'WCWHSHSCPGZ', '');
INSERT INTO `05diseases` VALUES ('11131', '胃肠吻合术后输入袢梗阻', '370', 'K91.821', 'WCWHSHSRPGZ', '');
INSERT INTO `05diseases` VALUES ('11132', '胆道术后肾衰或无尿', '53', 'K91.851', 'DDSHSSHWN', '');
INSERT INTO `05diseases` VALUES ('11133', '手术后胰腺炎', '437', 'K91.852', 'SSHYXY', '');
INSERT INTO `05diseases` VALUES ('11134', '输入性肠袢梗阻综合征[胆汁性呕吐]', '53', 'K91.853', 'SRXCPGZZHZDZXOT', '');
INSERT INTO `05diseases` VALUES ('11135', '操作后消化系统疾患 NOS', '388', 'K91.951', 'CZHXHXTJH', '');
INSERT INTO `05diseases` VALUES ('11136', '呕血', '275', 'K92.001', 'OX', '');
INSERT INTO `05diseases` VALUES ('11137', '黑粪(柏油样粪)', '278', 'K92.101', 'HFBYYF', '');
INSERT INTO `05diseases` VALUES ('11138', '便血', '275', 'K92.201', 'BX', '');
INSERT INTO `05diseases` VALUES ('11139', '残胃出血', '370', 'K92.202', 'CWCX', '');
INSERT INTO `05diseases` VALUES ('11140', '肠出血', '38', 'K92.203', 'CCX', '');
INSERT INTO `05diseases` VALUES ('11141', '上消化道出血', '38', 'K92.204', 'SXHDCX', '');
INSERT INTO `05diseases` VALUES ('11142', '胃肠道出血', '31', 'K92.205', 'WCDCX', '');
INSERT INTO `05diseases` VALUES ('11143', '胃出血', '370', 'K92.206', 'WCX', '');
INSERT INTO `05diseases` VALUES ('11144', '下消化道出血', '38', 'K92.207', 'XXHDCX', '');
INSERT INTO `05diseases` VALUES ('11145', '消化道出血', '38', 'K92.208', 'XHDCX', '');
INSERT INTO `05diseases` VALUES ('11146', '门脉高压性胃肠病', '370', 'K92.801', 'MMGYXWCB', '');
INSERT INTO `05diseases` VALUES ('11147', '蛋白丢失性胃肠病', '370', 'K92.851', 'DBDSXWCB', '');
INSERT INTO `05diseases` VALUES ('11148', '消化道病变', '387', 'K92.902', 'XHDBB', '');
INSERT INTO `05diseases` VALUES ('11149', '功能性消化疾患', '388', 'K92.951', 'GNXXHJH', '');
INSERT INTO `05diseases` VALUES ('11150', '新生儿脓疱病', '405', 'L00.X01', 'XSENPB', '');
INSERT INTO `05diseases` VALUES ('11151', '新生儿天疱疮', '405', 'L00.X02', 'XSETPC', '');
INSERT INTO `05diseases` VALUES ('11152', '里特病', '268', 'L00.X51', 'LTB', '');
INSERT INTO `05diseases` VALUES ('11153', '新生儿大疱性脓疮', '405', 'L01.051', 'XSEDPXNC', '');
INSERT INTO `05diseases` VALUES ('11154', '大疱性脓疱疮', '242', 'L01.052', 'DPXNPC', '');
INSERT INTO `05diseases` VALUES ('11155', '伯克哈特脓疱病', '242', 'L01.053', 'BKHTNPB', '');
INSERT INTO `05diseases` VALUES ('11156', '溃疡性脓疱病', '242', 'L01.151', 'KYXNPB', '');
INSERT INTO `05diseases` VALUES ('11157', '脓疱病性湿疹', '320', 'L01.152', 'NPBXSZ', '');
INSERT INTO `05diseases` VALUES ('11158', '额部脓肿', '243', 'L02.001', 'EBNZ', '');
INSERT INTO `05diseases` VALUES ('11159', '面部疖肿', '169', 'L02.002', 'MBJZ', '');
INSERT IN