"""add created/updated at

Revision ID: f25003750af4
Revises: 00bacef91f18
Create Date: 2024-01-07 04:53:24.441861

"""
import sqlalchemy as sa
from alembic import op


def _is_pg(conn):
    return conn.dialect.name == "postgresql"

# revision identifiers, used by Alembic.
revision = 'f25003750af4'
down_revision = '00bacef91f18'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    conn = op.get_bind()
    
    if _is_pg(conn):
        # PostgreSQL: Keep original syntax
        with op.batch_alter_table('tool_api_providers', schema=None) as batch_op:
            batch_op.add_column(sa.Column('created_at', sa.DateTime(), server_default=sa.text('CURRENT_TIMESTAMP(0)'), nullable=False))
            batch_op.add_column(sa.Column('updated_at', sa.DateTime(), server_default=sa.text('CURRENT_TIMESTAMP(0)'), nullable=False))
    else:
        # MySQL: Use compatible syntax
        with op.batch_alter_table('tool_api_providers', schema=None) as batch_op:
            batch_op.add_column(sa.Column('created_at', sa.DateTime(), server_default=sa.func.current_timestamp(), nullable=False))
            batch_op.add_column(sa.Column('updated_at', sa.DateTime(), server_default=sa.func.current_timestamp(), nullable=False))

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('tool_api_providers', schema=None) as batch_op:
        batch_op.drop_column('updated_at')
        batch_op.drop_column('created_at')

    # ### end Alembic commands ###
