"""change message chain id to nullable

Revision ID: 4829e54d2fee
Revises: 114eed84c228
Create Date: 2024-01-12 03:42:27.362415

"""
from alembic import op
from sqlalchemy.dialects import postgresql

import models.types


def _is_pg(conn):
    return conn.dialect.name == "postgresql"

# revision identifiers, used by Alembic.
revision = '4829e54d2fee'
down_revision = '114eed84c228'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    conn = op.get_bind()
    
    if _is_pg(conn):
        # PostgreSQL: Keep original syntax
        with op.batch_alter_table('message_agent_thoughts', schema=None) as batch_op:
            batch_op.alter_column('message_chain_id',
                   existing_type=postgresql.UUID(),
                   nullable=True)
    else:
        # MySQL: Use compatible syntax
        with op.batch_alter_table('message_agent_thoughts', schema=None) as batch_op:
            batch_op.alter_column('message_chain_id',
                   existing_type=models.types.StringUUID(),
                   nullable=True)

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    conn = op.get_bind()
    
    if _is_pg(conn):
        # PostgreSQL: Keep original syntax
        with op.batch_alter_table('message_agent_thoughts', schema=None) as batch_op:
            batch_op.alter_column('message_chain_id',
                   existing_type=postgresql.UUID(),
                   nullable=False)
    else:
        # MySQL: Use compatible syntax
        with op.batch_alter_table('message_agent_thoughts', schema=None) as batch_op:
            batch_op.alter_column('message_chain_id',
                   existing_type=models.types.StringUUID(),
                   nullable=False)

    # ### end Alembic commands ###
