"""introduce_trigger

Revision ID: 669ffd70119c
Revises: 03f8dcbc611e
Create Date: 2025-10-30 15:18:49.549156

"""
from alembic import op
import models as models
import sqlalchemy as sa
from libs.uuid_utils import uuidv7

from models.enums import AppTriggerStatus, AppTriggerType

def _is_pg(conn):
    return conn.dialect.name == "postgresql"

# revision identifiers, used by Alembic.
revision = '669ffd70119c'
down_revision = '03f8dcbc611e'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    conn = op.get_bind()
    
    if _is_pg(conn):
        op.create_table('app_triggers',
        sa.Column('id', models.types.StringUUID(), server_default=sa.text('uuidv7()'), nullable=False),
        sa.Column('tenant_id', models.types.StringUUID(), nullable=False),
        sa.Column('app_id', models.types.StringUUID(), nullable=False),
        sa.Column('node_id', sa.String(length=64), nullable=False),
        sa.Column('trigger_type', models.types.EnumText(AppTriggerType, length=50), nullable=False),
        sa.Column('title', sa.String(length=255), nullable=False),
        sa.Column('provider_name', sa.String(length=255), server_default='', nullable=True),
        sa.Column('status', models.types.EnumText(AppTriggerStatus, length=50), nullable=False),
        sa.Column('created_at', sa.DateTime(), server_default=sa.text('CURRENT_TIMESTAMP'), nullable=False),
        sa.Column('updated_at', sa.DateTime(), nullable=False),
        sa.PrimaryKeyConstraint('id', name='app_trigger_pkey')
        )
    else:
        op.create_table('app_triggers',
        sa.Column('id', models.types.StringUUID(), nullable=False),
        sa.Column('tenant_id', models.types.StringUUID(), nullable=False),
        sa.Column('app_id', models.types.StringUUID(), nullable=False),
        sa.Column('node_id', sa.String(length=64), nullable=False),
        sa.Column('trigger_type', models.types.EnumText(AppTriggerType, length=50), nullable=False),
        sa.Column('title', sa.String(length=255), nullable=False),
        sa.Column('provider_name', sa.String(length=255), server_default='', nullable=True),
        sa.Column('status', models.types.EnumText(AppTriggerStatus, length=50), nullable=False),
        sa.Column('created_at', sa.DateTime(), server_default=sa.func.current_timestamp(), nullable=False),
        sa.Column('updated_at', sa.DateTime(), nullable=False),
        sa.PrimaryKeyConstraint('id', name='app_trigger_pkey')
        )
    with op.batch_alter_table('app_triggers', schema=None) as batch_op:
        batch_op.create_index('app_trigger_tenant_app_idx', ['tenant_id', 'app_id'], unique=False)

    if _is_pg(conn):
        op.create_table('trigger_oauth_system_clients',
        sa.Column('id', models.types.StringUUID(), server_default=sa.text('uuid_generate_v4()'), nullable=False),
        sa.Column('plugin_id', sa.String(length=512), nullable=False),
        sa.Column('provider', sa.String(length=255), nullable=False),
        sa.Column('encrypted_oauth_params', sa.Text(), nullable=False),
        sa.Column('created_at', sa.DateTime(), server_default=sa.text('CURRENT_TIMESTAMP'), nullable=False),
        sa.Column('updated_at', sa.DateTime(), server_default=sa.text('CURRENT_TIMESTAMP'), nullable=False),
        sa.PrimaryKeyConstraint('id', name='trigger_oauth_system_client_pkey'),
        sa.UniqueConstraint('plugin_id', 'provider', name='trigger_oauth_system_client_plugin_id_provider_idx')
        )
    else:
        op.create_table('trigger_oauth_system_clients',
        sa.Column('id', models.types.StringUUID(), nullable=False),
        sa.Column('plugin_id', sa.String(length=512), nullable=False),
        sa.Column('provider', sa.String(length=255), nullable=False),
        sa.Column('encrypted_oauth_params', models.types.LongText(), nullable=False),
        sa.Column('created_at', sa.DateTime(), server_default=sa.func.current_timestamp(), nullable=False),
        sa.Column('updated_at', sa.DateTime(), server_default=sa.func.current_timestamp(), nullable=False),
        sa.PrimaryKeyConstraint('id', name='trigger_oauth_system_client_pkey'),
        sa.UniqueConstraint('plugin_id', 'provider', name='trigger_oauth_system_client_plugin_id_provider_idx')
        )
    if _is_pg(conn):
        op.create_table('trigger_oauth_tenant_clients',
        sa.Column('id', models.types.StringUUID(), server_default=sa.text('uuid_generate_v4()'), nullable=False),
        sa.Column('tenant_id', models.types.StringUUID(), nullable=False),
        sa.Column('plugin_id', sa.String(length=255), nullable=False),
        sa.Column('provider', sa.String(length=255), nullable=False),
        sa.Column('enabled', sa.Boolean(), server_default=sa.text('true'), nullable=False),
        sa.Column('encrypted_oauth_params', sa.Text(), nullable=False),
        sa.Column('created_at', sa.DateTime(), server_default=sa.text('CURRENT_TIMESTAMP'), nullable=False),
        sa.Column('updated_at', sa.DateTime(), server_default=sa.text('CURRENT_TIMESTAMP'), nullable=False),
        sa.PrimaryKeyConstraint('id', name='trigger_oauth_tenant_client_pkey'),
        sa.UniqueConstraint('tenant_id', 'plugin_id', 'provider', name='unique_trigger_oauth_tenant_client')
        )
    else:
        op.create_table('trigger_oauth_tenant_clients',
        sa.Column('id', models.types.StringUUID(), nullable=False),
        sa.Column('tenant_id', models.types.StringUUID(), nullable=False),
        sa.Column('plugin_id', sa.String(length=255), nullable=False),
        sa.Column('provider', sa.String(length=255), nullable=False),
        sa.Column('enabled', sa.Boolean(), server_default=sa.text('true'), nullable=False),
        sa.Column('encrypted_oauth_params', models.types.LongText(), nullable=False),
        sa.Column('created_at', sa.DateTime(), server_default=sa.func.current_timestamp(), nullable=False),
        sa.Column('updated_at', sa.DateTime(), server_default=sa.func.current_timestamp(), nullable=False),
        sa.PrimaryKeyConstraint('id', name='trigger_oauth_tenant_client_pkey'),
        sa.UniqueConstraint('tenant_id', 'plugin_id', 'provider', name='unique_trigger_oauth_tenant_client')
        )
    if _is_pg(conn):
        op.create_table('trigger_subscriptions',
        sa.Column('id', models.types.StringUUID(), server_default=sa.text('uuid_generate_v4()'), nullable=False),
        sa.Column('name', sa.String(length=255), nullable=False, comment='Subscription instance name'),
        sa.Column('tenant_id', models.types.StringUUID(), nullable=False),
        sa.Column('user_id', models.types.StringUUID(), nullable=False),
        sa.Column('provider_id', sa.String(length=255), nullable=False, comment='Provider identifier (e.g., plugin_id/provider_name)'),
        sa.Column('endpoint_id', sa.String(length=255), nullable=False, comment='Subscription endpoint'),
        sa.Column('parameters', sa.JSON(), nullable=False, comment='Subscription parameters JSON'),
        sa.Column('properties', sa.JSON(), nullable=False, comment='Subscription properties JSON'),
        sa.Column('credentials', sa.JSON(), nullable=False, comment='Subscription credentials JSON'),
        sa.Column('credential_type', sa.String(length=50), nullable=False, comment='oauth or api_key'),
        sa.Column('credential_expires_at', sa.Integer(), nullable=False, comment='OAuth token expiration timestamp, -1 for never'),
        sa.Column('expires_at', sa.Integer(), nullable=False, comment='Subscription instance expiration timestamp, -1 for never'),
        sa.Column('created_at', sa.DateTime(), server_default=sa.text('CURRENT_TIMESTAMP'), nullable=False),
        sa.Column('updated_at', sa.DateTime(), server_default=sa.text('CURRENT_TIMESTAMP'), nullable=False),
        sa.PrimaryKeyConstraint('id', name='trigger_provider_pkey'),
        sa.UniqueConstraint('tenant_id', 'provider_id', 'name', name='unique_trigger_provider')
        )
    else:
        op.create_table('trigger_subscriptions',
        sa.Column('id', models.types.StringUUID(), nullable=False),
        sa.Column('name', sa.String(length=255), nullable=False, comment='Subscription instance name'),
        sa.Column('tenant_id', models.types.StringUUID(), nullable=False),
        sa.Column('user_id', models.types.StringUUID(), nullable=False),
        sa.Column('provider_id', sa.String(length=255), nullable=False, comment='Provider identifier (e.g., plugin_id/provider_name)'),
        sa.Column('endpoint_id', sa.String(length=255), nullable=False, comment='Subscription endpoint'),
        sa.Column('parameters', sa.JSON(), nullable=False, comment='Subscription parameters JSON'),
        sa.Column('properties', sa.JSON(), nullable=False, comment='Subscription properties JSON'),
        sa.Column('credentials', sa.JSON(), nullable=False, comment='Subscription credentials JSON'),
        sa.Column('credential_type', sa.String(length=50), nullable=False, comment='oauth or api_key'),
        sa.Column('credential_expires_at', sa.Integer(), nullable=False, comment='OAuth token expiration timestamp, -1 for never'),
        sa.Column('expires_at', sa.Integer(), nullable=False, comment='Subscription instance expiration timestamp, -1 for never'),
        sa.Column('created_at', sa.DateTime(), server_default=sa.func.current_timestamp(), nullable=False),
        sa.Column('updated_at', sa.DateTime(), server_default=sa.func.current_timestamp(), nullable=False),
        sa.PrimaryKeyConstraint('id', name='trigger_provider_pkey'),
        sa.UniqueConstraint('tenant_id', 'provider_id', 'name', name='unique_trigger_provider')
        )
    with op.batch_alter_table('trigger_subscriptions', schema=None) as batch_op:
        batch_op.create_index('idx_trigger_providers_endpoint', ['endpoint_id'], unique=True)
        batch_op.create_index('idx_trigger_providers_tenant_endpoint', ['tenant_id', 'endpoint_id'], unique=False)
        batch_op.create_index('idx_trigger_providers_tenant_provider', ['tenant_id', 'provider_id'], unique=False)

    if _is_pg(conn):
        op.create_table('workflow_plugin_triggers',
        sa.Column('id', models.types.StringUUID(), server_default=sa.text('uuid_generate_v4()'), nullable=False),
        sa.Column('app_id', models.types.StringUUID(), nullable=False),
        sa.Column('node_id', sa.String(length=64), nullable=False),
        sa.Column('tenant_id', models.types.StringUUID(), nullable=False),
        sa.Column('provider_id', sa.String(length=512), nullable=False),
        sa.Column('event_name', sa.String(length=255), nullable=False),
        sa.Column('subscription_id', sa.String(length=255), nullable=False),
        sa.Column('created_at', sa.DateTime(), server_default=sa.text('CURRENT_TIMESTAMP'), nullable=False),
        sa.Column('updated_at', sa.DateTime(), server_default=sa.text('CURRENT_TIMESTAMP'), nullable=False),
        sa.PrimaryKeyConstraint('id', name='workflow_plugin_trigger_pkey'),
        sa.UniqueConstraint('app_id', 'node_id', name='uniq_app_node_subscription')
        )
    else:
        op.create_table('workflow_plugin_triggers',
        sa.Column('id', models.types.StringUUID(), nullable=False),
        sa.Column('app_id', models.types.StringUUID(), nullable=False),
        sa.Column('node_id', sa.String(length=64), nullable=False),
        sa.Column('tenant_id', models.types.StringUUID(), nullable=False),
        sa.Column('provider_id', sa.String(length=512), nullable=False),
        sa.Column('event_name', sa.String(length=255), nullable=False),
        sa.Column('subscription_id', sa.String(length=255), nullable=False),
        sa.Column('created_at', sa.DateTime(), server_default=sa.func.current_timestamp(), nullable=False),
        sa.Column('updated_at', sa.DateTime(), server_default=sa.func.current_timestamp(), nullable=False),
        sa.PrimaryKeyConstraint('id', name='workflow_plugin_trigger_pkey'),
        sa.UniqueConstraint('app_id', 'node_id', name='uniq_app_node_subscription')
        )
    with op.batch_alter_table('workflow_plugin_triggers', schema=None) as batch_op:
        batch_op.create_index('workflow_plugin_trigger_tenant_subscription_idx', ['tenant_id', 'subscription_id', 'event_name'], unique=False)

    if _is_pg(conn):
        op.create_table('workflow_schedule_plans',
        sa.Column('id', models.types.StringUUID(), server_default=sa.text('uuidv7()'), nullable=False),
        sa.Column('app_id', models.types.StringUUID(), nullable=False),
        sa.Column('node_id', sa.String(length=64), nullable=False),
        sa.Column('tenant_id', models.types.StringUUID(), nullable=False),
        sa.Column('cron_expression', sa.String(length=255), nullable=False),
        sa.Column('timezone', sa.String(length=64), nullable=False),
        sa.Column('next_run_at', sa.DateTime(), nullable=True),
        sa.Column('created_at', sa.DateTime(), server_default=sa.text('CURRENT_TIMESTAMP'), nullable=False),
        sa.Column('updated_at', sa.DateTime(), server_default=sa.text('CURRENT_TIMESTAMP'), nullable=False),
        sa.PrimaryKeyConstraint('id', name='workflow_schedule_plan_pkey'),
        sa.UniqueConstraint('app_id', 'node_id', name='uniq_app_node')
        )
    else:
        op.create_table('workflow_schedule_plans',
        sa.Column('id', models.types.StringUUID(), nullable=False),
        sa.Column('app_id', models.types.StringUUID(), nullable=False),
        sa.Column('node_id', sa.String(length=64), nullable=False),
        sa.Column('tenant_id', models.types.StringUUID(), nullable=False),
        sa.Column('cron_expression', sa.String(length=255), nullable=False),
        sa.Column('timezone', sa.String(length=64), nullable=False),
        sa.Column('next_run_at', sa.DateTime(), nullable=True),
        sa.Column('created_at', sa.DateTime(), server_default=sa.func.current_timestamp(), nullable=False),
        sa.Column('updated_at', sa.DateTime(), server_default=sa.func.current_timestamp(), nullable=False),
        sa.PrimaryKeyConstraint('id', name='workflow_schedule_plan_pkey'),
        sa.UniqueConstraint('app_id', 'node_id', name='uniq_app_node')
        )
    with op.batch_alter_table('workflow_schedule_plans', schema=None) as batch_op:
        batch_op.create_index('workflow_schedule_plan_next_idx', ['next_run_at'], unique=False)

    if _is_pg(conn):
        op.create_table('workflow_trigger_logs',
        sa.Column('id', models.types.StringUUID(), server_default=sa.text('uuidv7()'), nullable=False),
        sa.Column('tenant_id', models.types.StringUUID(), nullable=False),
        sa.Column('app_id', models.types.StringUUID(), nullable=False),
        sa.Column('workflow_id', models.types.StringUUID(), nullable=False),
        sa.Column('workflow_run_id', models.types.StringUUID(), nullable=True),
        sa.Column('root_node_id', sa.String(length=255), nullable=True),
        sa.Column('trigger_metadata', sa.Text(), nullable=False),
        sa.Column('trigger_type', models.types.EnumText(AppTriggerType, length=50), nullable=False),
        sa.Column('trigger_data', sa.Text(), nullable=False),
        sa.Column('inputs', sa.Text(), nullable=False),
        sa.Column('outputs', sa.Text(), nullable=True),
        sa.Column('status', models.types.EnumText(AppTriggerStatus, length=50), nullable=False),
        sa.Column('error', sa.Text(), nullable=True),
        sa.Column('queue_name', sa.String(length=100), nullable=False),
        sa.Column('celery_task_id', sa.String(length=255), nullable=True),
        sa.Column('retry_count', sa.Integer(), nullable=False),
        sa.Column('elapsed_time', sa.Float(), nullable=True),
        sa.Column('total_tokens', sa.Integer(), nullable=True),
        sa.Column('created_at', sa.DateTime(), server_default=sa.text('CURRENT_TIMESTAMP'), nullable=False),
        sa.Column('created_by_role', sa.String(length=255), nullable=False),
        sa.Column('created_by', sa.String(length=255), nullable=False),
        sa.Column('triggered_at', sa.DateTime(), nullable=True),
        sa.Column('finished_at', sa.DateTime(), nullable=True),
        sa.PrimaryKeyConstraint('id', name='workflow_trigger_log_pkey')
        )
    else:
        op.create_table('workflow_trigger_logs',
        sa.Column('id', models.types.StringUUID(), nullable=False),
        sa.Column('tenant_id', models.types.StringUUID(), nullable=False),
        sa.Column('app_id', models.types.StringUUID(), nullable=False),
        sa.Column('workflow_id', models.types.StringUUID(), nullable=False),
        sa.Column('workflow_run_id', models.types.StringUUID(), nullable=True),
        sa.Column('root_node_id', sa.String(length=255), nullable=True),
        sa.Column('trigger_metadata', models.types.LongText(), nullable=False),
        sa.Column('trigger_type', models.types.EnumText(AppTriggerType, length=50), nullable=False),
        sa.Column('trigger_data', models.types.LongText(), nullable=False),
        sa.Column('inputs', models.types.LongText(), nullable=False),
        sa.Column('outputs', models.types.LongText(), nullable=True),
        sa.Column('status', models.types.EnumText(AppTriggerStatus, length=50), nullable=False),
        sa.Column('error', models.types.LongText(), nullable=True),
        sa.Column('queue_name', sa.String(length=100), nullable=False),
        sa.Column('celery_task_id', sa.String(length=255), nullable=True),
        sa.Column('retry_count', sa.Integer(), nullable=False),
        sa.Column('elapsed_time', sa.Float(), nullable=True),
        sa.Column('total_tokens', sa.Integer(), nullable=True),
        sa.Column('created_at', sa.DateTime(), server_default=sa.func.current_timestamp(), nullable=False),
        sa.Column('created_by_role', sa.String(length=255), nullable=False),
        sa.Column('created_by', sa.String(length=255), nullable=False),
        sa.Column('triggered_at', sa.DateTime(), nullable=True),
        sa.Column('finished_at', sa.DateTime(), nullable=True),
        sa.PrimaryKeyConstraint('id', name='workflow_trigger_log_pkey')
        )
    with op.batch_alter_table('workflow_trigger_logs', schema=None) as batch_op:
        batch_op.create_index('workflow_trigger_log_created_at_idx', ['created_at'], unique=False)
        batch_op.create_index('workflow_trigger_log_status_idx', ['status'], unique=False)
        batch_op.create_index('workflow_trigger_log_tenant_app_idx', ['tenant_id', 'app_id'], unique=False)
        batch_op.create_index('workflow_trigger_log_workflow_id_idx', ['workflow_id'], unique=False)
        batch_op.create_index('workflow_trigger_log_workflow_run_idx', ['workflow_run_id'], unique=False)

    if _is_pg(conn):
        op.create_table('workflow_webhook_triggers',
        sa.Column('id', models.types.StringUUID(), server_default=sa.text('uuidv7()'), nullable=False),
        sa.Column('app_id', models.types.StringUUID(), nullable=False),
        sa.Column('node_id', sa.String(length=64), nullable=False),
        sa.Column('tenant_id', models.types.StringUUID(), nullable=False),
        sa.Column('webhook_id', sa.String(length=24), nullable=False),
        sa.Column('created_by', models.types.StringUUID(), nullable=False),
        sa.Column('created_at', sa.DateTime(), server_default=sa.text('CURRENT_TIMESTAMP'), nullable=False),
        sa.Column('updated_at', sa.DateTime(), server_default=sa.text('CURRENT_TIMESTAMP'), nullable=False),
        sa.PrimaryKeyConstraint('id', name='workflow_webhook_trigger_pkey'),
        sa.UniqueConstraint('app_id', 'node_id', name='uniq_node'),
        sa.UniqueConstraint('webhook_id', name='uniq_webhook_id')
        )
    else:
        op.create_table('workflow_webhook_triggers',
        sa.Column('id', models.types.StringUUID(), nullable=False),
        sa.Column('app_id', models.types.StringUUID(), nullable=False),
        sa.Column('node_id', sa.String(length=64), nullable=False),
        sa.Column('tenant_id', models.types.StringUUID(), nullable=False),
        sa.Column('webhook_id', sa.String(length=24), nullable=False),
        sa.Column('created_by', models.types.StringUUID(), nullable=False),
        sa.Column('created_at', sa.DateTime(), server_default=sa.func.current_timestamp(), nullable=False),
        sa.Column('updated_at', sa.DateTime(), server_default=sa.func.current_timestamp(), nullable=False),
        sa.PrimaryKeyConstraint('id', name='workflow_webhook_trigger_pkey'),
        sa.UniqueConstraint('app_id', 'node_id', name='uniq_node'),
        sa.UniqueConstraint('webhook_id', name='uniq_webhook_id')
        )
    with op.batch_alter_table('workflow_webhook_triggers', schema=None) as batch_op:
        batch_op.create_index('workflow_webhook_trigger_tenant_idx', ['tenant_id'], unique=False)

    with op.batch_alter_table('celery_taskmeta', schema=None) as batch_op:
        batch_op.alter_column('task_id',
               existing_type=sa.VARCHAR(length=155),
               nullable=False)
        batch_op.alter_column('status',
               existing_type=sa.VARCHAR(length=50),
               nullable=False)

    with op.batch_alter_table('celery_tasksetmeta', schema=None) as batch_op:
        batch_op.alter_column('taskset_id',
               existing_type=sa.VARCHAR(length=155),
               nullable=False)

    with op.batch_alter_table('providers', schema=None) as batch_op:
        batch_op.drop_column('credential_status')

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    conn = op.get_bind()
    
    if _is_pg(conn):
        with op.batch_alter_table('providers', schema=None) as batch_op:
            batch_op.add_column(sa.Column('credential_status', sa.VARCHAR(length=20), server_default=sa.text("'active'::character varying"), autoincrement=False, nullable=True))
    else:
        with op.batch_alter_table('providers', schema=None) as batch_op:
            batch_op.add_column(sa.Column('credential_status', sa.VARCHAR(length=20), server_default=sa.text("'active'"), autoincrement=False, nullable=True))

    with op.batch_alter_table('celery_tasksetmeta', schema=None) as batch_op:
        batch_op.alter_column('taskset_id',
               existing_type=sa.VARCHAR(length=155),
               nullable=True)

    with op.batch_alter_table('celery_taskmeta', schema=None) as batch_op:
        batch_op.alter_column('status',
               existing_type=sa.VARCHAR(length=50),
               nullable=True)
        batch_op.alter_column('task_id',
               existing_type=sa.VARCHAR(length=155),
               nullable=True)

    with op.batch_alter_table('workflow_webhook_triggers', schema=None) as batch_op:
        batch_op.drop_index('workflow_webhook_trigger_tenant_idx')

    op.drop_table('workflow_webhook_triggers')
    with op.batch_alter_table('workflow_trigger_logs', schema=None) as batch_op:
        batch_op.drop_index('workflow_trigger_log_workflow_run_idx')
        batch_op.drop_index('workflow_trigger_log_workflow_id_idx')
        batch_op.drop_index('workflow_trigger_log_tenant_app_idx')
        batch_op.drop_index('workflow_trigger_log_status_idx')
        batch_op.drop_index('workflow_trigger_log_created_at_idx')

    op.drop_table('workflow_trigger_logs')
    with op.batch_alter_table('workflow_schedule_plans', schema=None) as batch_op:
        batch_op.drop_index('workflow_schedule_plan_next_idx')

    op.drop_table('workflow_schedule_plans')
    with op.batch_alter_table('workflow_plugin_triggers', schema=None) as batch_op:
        batch_op.drop_index('workflow_plugin_trigger_tenant_subscription_idx')

    op.drop_table('workflow_plugin_triggers')
    with op.batch_alter_table('trigger_subscriptions', schema=None) as batch_op:
        batch_op.drop_index('idx_trigger_providers_tenant_provider')
        batch_op.drop_index('idx_trigger_providers_tenant_endpoint')
        batch_op.drop_index('idx_trigger_providers_endpoint')

    op.drop_table('trigger_subscriptions')
    op.drop_table('trigger_oauth_tenant_clients')
    op.drop_table('trigger_oauth_system_clients')
    with op.batch_alter_table('app_triggers', schema=None) as batch_op:
        batch_op.drop_index('app_trigger_tenant_app_idx')

    op.drop_table('app_triggers')
    # ### end Alembic commands ###
