"""add WorkflowPause model

Revision ID: 03f8dcbc611e
Revises: ae662b25d9bc
Create Date: 2025-10-22 16:11:31.805407

"""

from alembic import op
import models as models
import sqlalchemy as sa
from libs.uuid_utils import uuidv7

def _is_pg(conn):
    return conn.dialect.name == "postgresql"

# revision identifiers, used by Alembic.
revision = "03f8dcbc611e"
down_revision = "ae662b25d9bc"
branch_labels = None
depends_on = None

def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    conn = op.get_bind()
    if _is_pg(conn):
        op.create_table(
            "workflow_pauses",
            sa.Column("workflow_id", models.types.StringUUID(), nullable=False),
            sa.Column("workflow_run_id", models.types.StringUUID(), nullable=False),
            sa.Column("resumed_at", sa.DateTime(), nullable=True),
            sa.Column("state_object_key", sa.String(length=255), nullable=False),
            sa.Column("id", models.types.StringUUID(), server_default=sa.text("uuidv7()"), nullable=False),
            sa.Column("created_at", sa.DateTime(), server_default=sa.text("CURRENT_TIMESTAMP"), nullable=False),
            sa.Column("updated_at", sa.DateTime(), server_default=sa.text("CURRENT_TIMESTAMP"), nullable=False),
            sa.PrimaryKeyConstraint("id", name=op.f("workflow_pauses_pkey")),
            sa.UniqueConstraint("workflow_run_id", name=op.f("workflow_pauses_workflow_run_id_key")),
        )
    else:
        op.create_table(
            "workflow_pauses",
            sa.Column("workflow_id", models.types.StringUUID(), nullable=False),
            sa.Column("workflow_run_id", models.types.StringUUID(), nullable=False),
            sa.Column("resumed_at", sa.DateTime(), nullable=True),
            sa.Column("state_object_key", sa.String(length=255), nullable=False),
            sa.Column("id", models.types.StringUUID(), nullable=False),
            sa.Column("created_at", sa.DateTime(), server_default=sa.func.current_timestamp(), nullable=False),
            sa.Column("updated_at", sa.DateTime(), server_default=sa.func.current_timestamp(), nullable=False),
            sa.PrimaryKeyConstraint("id", name=op.f("workflow_pauses_pkey")),
            sa.UniqueConstraint("workflow_run_id", name=op.f("workflow_pauses_workflow_run_id_key")),
        )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("workflow_pauses")
    # ### end Alembic commands ###
