"""rename api provider description

Revision ID: 00bacef91f18
Revises: 8ec536f3c800
Create Date: 2024-01-07 04:07:34.482983

"""
import sqlalchemy as sa
from alembic import op

import models.types


def _is_pg(conn):
    return conn.dialect.name == "postgresql"

# revision identifiers, used by Alembic.
revision = '00bacef91f18'
down_revision = '8ec536f3c800'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    conn = op.get_bind()
    
    if _is_pg(conn):
        with op.batch_alter_table('tool_api_providers', schema=None) as batch_op:
            batch_op.add_column(sa.Column('description', sa.Text(), nullable=False))
            batch_op.drop_column('description_str')
    else:
        with op.batch_alter_table('tool_api_providers', schema=None) as batch_op:
            batch_op.add_column(sa.Column('description', models.types.LongText(), nullable=False))
            batch_op.drop_column('description_str')

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    conn = op.get_bind()
    
    if _is_pg(conn):
        with op.batch_alter_table('tool_api_providers', schema=None) as batch_op:
            batch_op.add_column(sa.Column('description_str', sa.TEXT(), autoincrement=False, nullable=False))
            batch_op.drop_column('description')
    else:
        with op.batch_alter_table('tool_api_providers', schema=None) as batch_op:
            batch_op.add_column(sa.Column('description_str', models.types.LongText(), autoincrement=False, nullable=False))
            batch_op.drop_column('description')

    # ### end Alembic commands ###
