# gomplate templates for GitHub Actions

This document describes gomplate templates use for GitHub Actions.

## Requirements

You have to have installed [gomplate](https://docs.gomplate.ca/installing/) tool in order to render a template file.

> gomplate is a template renderer which supports a growing list of datastores, such as: JSON (including EJSON - encrypted JSON), YAML, AWS EC2 metadata, BoltDB, Hashicorp Consul and Hashicorp Vault secrets.

## Templates

Below you can find a list of templates with their description and the commands to render them.

### `configuration_variables.tmpl`

The template maps dataset name and configuration name for the model regression tests into paths where files are located. As a result, the template returns two environment variables `DATASET` and `CONFIG` which contain paths to file/directory.

#### How to run locally

```shell
gomplate -d mapping=<path_to_json_file_with_mapping> -f .github/templates/configuration_variables.tmpl
```

### `model_regression_test_config_comment.tmpl`

The template returns a comment message which is used as a help description in a PR. The template reads the `.github/configs/mr-test-example.yaml` file and include it as example content.

The help message is triggered by adding `status:model-regression-tests` label.
Comment with a help message is added if a PR doesn't contain a comment with a configuration for the model regression tests.

#### How to run locally

```shell
gomplate -f .github/templates/model_regression_test_config_comment.tmpl
```

The template uses the `GITHUB_ACTOR` environment variable, you have to export the variable before executing the command.

### `model_regression_test_config_to_json.tmpl`

The template reads an issue/a PR comment and transforms a YAML code block into JSON.

#### How to run locally

```shell
gomplate -d github=https://api.github.com/repos/${{ github.repository }}/issues/comments/${{ comment-id }} -H 'github=Authorization:token ${{ secrets.GITHUB_TOKEN }}' -f .github/templates/model_regression_test_config_to_json.tmpl
```

### `model_regression_test_results.tmpl`

The template reads a file with a report (the report file is available as an artifact in the model regression tests workflow) and returns markdown table with a summary of tests.

#### How to run locally

```shell
gomplate -d data=report.json -d results_main=report_main.json -f .github/templates/model_regression_test_results.tmpl
```

In order to be able to use the `.github/templates/model_regression_test_results.tmpl` template you need the following files:

- `report.json` - the file with a report generated by the `CI - Model Regression` workflow run in a PR. The report is available to download as an artifact in the workflow related to the PR.
- `report_main.json` - the file with a report generated by the `CI - Model Regression` workflow that is triggered on schedule event. A list of the workflows that you can download an artifact from, can be found [here](https://github.com/RasaHQ/rasa/actions?query=workflow%3A%22CI+-+Model+Regression%22+event%3Aschedule).
