/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Iterator;
import java.util.List;
import mslinks.ShellLink;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.cache.CacheLRUWrapper;
import net.sourceforge.jnlp.security.dialogresults.AccessWarningPaneComplexReturn;
import net.sourceforge.jnlp.util.FileUtils;
import net.sourceforge.jnlp.util.GenericDesktopEntry;
import net.sourceforge.jnlp.util.XDesktopEntry;
import net.sourceforge.jnlp.util.logging.OutputController;

public class WindowsDesktopEntry
implements GenericDesktopEntry {
    private final JNLPFile file;
    private final String iconLocation;
    private static final String DOUBLE_QUOTE = "\"";

    public WindowsDesktopEntry(JNLPFile file) {
        this.file = file;
        this.iconLocation = new XDesktopEntry(file).cacheAndGetIconLocation();
    }

    @Override
    public String getDesktopIconFileName() {
        return XDesktopEntry.getDesktopIconName(this.file) + ".lnk";
    }

    private String getDesktopLnkPath() {
        return System.getenv("userprofile") + "/Desktop/" + this.getDesktopIconFileName();
    }

    @Override
    public File getDesktopIconFile() {
        return new File(this.getDesktopLnkPath());
    }

    @Override
    public void createShortcutOnWindowsDesktop() throws IOException {
        String path = this.getDesktopLnkPath();
        String JavaWsBin = XDesktopEntry.getJavaWsBin();
        ShellLink sl = ShellLink.createLink((String)JavaWsBin).setCMDArgs(this.quoted(this.file.getSourceLocation()));
        if (this.iconLocation != null) {
            sl.setIconLocation(this.iconLocation);
        }
        sl.saveTo(path);
        this.manageShortcutList(ManageMode.A, path);
    }

    @Override
    public void createWindowsMenu() throws IOException {
        String path;
        File menuDir;
        String pathSuffix;
        try {
            pathSuffix = this.file.getInformation().getShortcut().getMenu().getSubMenu();
        }
        catch (NullPointerException npe) {
            OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, npe);
            pathSuffix = null;
        }
        if (pathSuffix == null) {
            pathSuffix = XDesktopEntry.getDesktopIconName(this.file);
        }
        if (!(menuDir = new File(path = System.getenv("userprofile") + "/AppData/Roaming/Microsoft/Windows/Start Menu/Programs/" + pathSuffix)).exists()) {
            menuDir.mkdir();
        }
        String JavaWsBin = XDesktopEntry.getJavaWsBin();
        ShellLink sl = ShellLink.createLink((String)JavaWsBin).setCMDArgs(this.quoted(this.file.getSourceLocation()));
        ShellLink ul = ShellLink.createLink((String)JavaWsBin).setCMDArgs("-Xclearcache " + this.quoted(this.file.getFileLocation()));
        if (this.iconLocation != null) {
            sl.setIconLocation(this.iconLocation);
            ul.setIconLocation(this.iconLocation);
        }
        String link = FileUtils.sanitizeFileName(this.file.getInformation().getTitle() + ".lnk", '-');
        sl.saveTo(path + "/" + link);
        ul.saveTo(path + "/Uninstall " + link);
        this.manageShortcutList(ManageMode.A, path + "/" + link);
        this.manageShortcutList(ManageMode.A, path + "/Uninstall " + link);
    }

    private void manageShortcutList(ManageMode mode, String path) throws IOException {
        if (!CacheLRUWrapper.getInstance().getWindowsShortcutList().exists()) {
            CacheLRUWrapper.getInstance().getWindowsShortcutList().createNewFile();
        }
        if (ManageMode.A == mode) {
            List<String> lines = Files.readAllLines(CacheLRUWrapper.getInstance().getWindowsShortcutList().toPath(), Charset.forName("UTF-8"));
            Iterator<String> it = lines.iterator();
            String sItem = "";
            Boolean fAdd = true;
            while (it.hasNext()) {
                sItem = it.next().toString();
                String[] sArray = sItem.split(",");
                String application = sArray[0];
                String sPath = sArray[1];
                if (!sPath.equalsIgnoreCase(path)) continue;
                fAdd = false;
                break;
            }
            if (fAdd.booleanValue()) {
                OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Adding sCut to list = " + sItem);
                String scInfo = this.file.getFileLocation().toString() + ",";
                scInfo = scInfo + path + "\r\n";
                Files.write(CacheLRUWrapper.getInstance().getWindowsShortcutList().toPath(), scInfo.getBytes(), StandardOpenOption.APPEND);
            }
        }
    }

    private String getFavIcon() {
        return XDesktopEntry.getFavIcon(this.file);
    }

    @Override
    public void createDesktopShortcuts(AccessWarningPaneComplexReturn.ShortcutResult menu, AccessWarningPaneComplexReturn.ShortcutResult desktop, boolean isSigned) {
        throw new UnsupportedOperationException("not suported on windows like systems");
    }

    @Override
    public void refreshExistingShortcuts(boolean desktop, boolean menu) {
        throw new UnsupportedOperationException("not suported on windows like systems");
    }

    @Override
    public File getGeneratedJnlpFileName() {
        throw new UnsupportedOperationException("not suported on windows like systems");
    }

    @Override
    public File getLinuxMenuIconFile() {
        throw new UnsupportedOperationException("not suported on windows like systems");
    }

    private String quoted(URL url) {
        return DOUBLE_QUOTE + url + DOUBLE_QUOTE;
    }

    private static enum ManageMode {
        A;

    }
}

