/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import net.sourceforge.jnlp.Node;
import net.sourceforge.jnlp.ParseException;
import net.sourceforge.jnlp.XMLParser;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.util.logging.OutputController;
import org.ccil.cowan.tagsoup.HTMLSchema;
import org.ccil.cowan.tagsoup.Parser;
import org.ccil.cowan.tagsoup.XMLWriter;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MalformedXMLParser
extends XMLParser {
    @Override
    public Node getRootNode(InputStream input) throws ParseException {
        OutputController.getLogger().log("Using MalformedXMLParser");
        InputStream xmlInput = MalformedXMLParser.xmlizeInputStream(input);
        return super.getRootNode(xmlInput);
    }

    public static InputStream xmlizeInputStream(InputStream original) throws ParseException {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            HTMLSchema schema = new HTMLSchema();
            Parser reader = new Parser();
            reader.setProperty("http://www.ccil.org/~cowan/tagsoup/properties/schema", schema);
            reader.setFeature("http://www.ccil.org/~cowan/tagsoup/features/bogons-empty", false);
            reader.setFeature("http://www.ccil.org/~cowan/tagsoup/features/ignorable-whitespace", true);
            reader.setFeature("http://www.ccil.org/~cowan/tagsoup/features/ignore-bogons", false);
            OutputStreamWriter writeger = new OutputStreamWriter(out);
            XMLWriter x = new XMLWriter((Writer)writeger);
            reader.setContentHandler((ContentHandler)x);
            InputSource s = new InputSource(original);
            reader.parse(s);
            return new ByteArrayInputStream(out.toByteArray());
        }
        catch (IOException | SAXException e1) {
            throw new ParseException(Translator.R("PBadXML"), e1);
        }
        catch (NoClassDefFoundError e2) {
            OutputController.getLogger().log(e2);
            ParseException.setUsed(null);
            return original;
        }
    }
}

