# Localizations

**🌐 Localizations for Harmonoid**

## Languages

| Language   | Country       | Contributors                                       | Source                                     |
| ---------- | ------------- | -------------------------------------------------- | ------------------------------------------ |
| English    | United States | [@alexmercerind](https://github.com/alexmercerind) | [`en_US.json`](./localizations/en_US.json) |
| German     | Germany       | [@vcmikuu](https://github.com/vcmikuu)             | [`de_DE.json`](./localizations/de_DE.json) |
| Greek      | Greece        | [@cuhsy](https://github.com/cuhsy)                 | [`el_GR.json`](./localizations/el_GR.json) |
| Spanish    | Spain         | [@PelatusRex](https://github.com/PelatusRex)       | [`es_ES.json`](./localizations/es_ES.json) |
| Japanese   | Japan         | [@maboroshin](https://github.com/maboroshin)       | [`ja_JP.json`](./localizations/ja_JP.json) |
| Korean     | Korea         | [@exflynet](https://github.com/exflynet)           | [`ko_KR.json`](./localizations/ko_KR.json) |
| Polish     | Poland        | [@KOXXPL](https://github.com/KOXXPL)               | [`pl_PL.json`](./localizations/pl_PL.json) |
| Portuguese | Brazil        | [@maisondasilva](https://github.com/maisondasilva) | [`pt_BR.json`](./localizations/pt_BR.json) |
| Romanian   | Romania       | [@raresnita](https://github.com/raresnita)         | [`ro_RO.json`](./localizations/ro_RO.json) |
| Slovenian  | Slovenia      | [@alexmercerind](https://github.com/alexmercerind) | [`sl_SI.json`](./localizations/sl_SI.json) |
| Turkish    | Turkey        | [@mikropsoft](https://github.com/mikropsoft)       | [`tr_TR.json`](./localizations/tr_TR.json) |
| Vietnamese | Vietnam       | [@honhatduy](https://github.com/honhatduy)         | [`vi_VN.json`](./localizations/vi_VN.json) |
| Chinese    | China         | [@VisionsAll](https://github.com/VisionsAll)       | [`zh_CN.json`](./localizations/zh_CN.json) |

## Contribute

- Use existing [English • United States](./localizations/en_US.json) values as a reference.
- Edit or add the file for your localization e.g. `fr_FR.json`.
- Add an entry in [`index.json`](./index.json).
- Add your name to this README.
- Raise a new [pull request](https://github.com/harmonoid/localizations/pulls).
- Want to become a permanent maintainer & need write access to this repository? Please [open a new issue](https://github.com/harmonoid/localizations/issues/new).
- 🎉🎉🎉

#### NOTE:

Please follow [Conventional Commits](https://www.conventionalcommits.org/en/v1.0.0/#summary) specification in your commit messages.

## License

This repository & work here is under [The Unlicense](https://unlicense.org/) license.

## Notes

- Usernames of various contributors are sorted lexicographically.
- Hyphen (-) indicates unknown or anonymous contributors.
