/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.ChunkCoordIntPair;

public class ChunkShapeHelper {
    private static double pointSegmentDist(int x1, int z1, int x2, int z2, int px, int pz) {
        int dx = x2 - x1;
        int dz = z2 - z1;
        if (dx == 0 && dz == 0) {
            return Math.sqrt((px - x1) * (px - x1) + (pz - z1) * (pz - z1));
        }
        double t = (double)((px - x1) * dx + (pz - z1) * dz) / (double)(dx * dx + dz * dz);
        if (t < 0.0) {
            return Math.sqrt((px - x1) * (px - x1) + (pz - z1) * (pz - z1));
        }
        if (t > 1.0) {
            return Math.sqrt((px - x2) * (px - x2) + (pz - z2) * (pz - z2));
        }
        double projX = (double)x1 + t * (double)dx;
        double projZ = (double)z1 + t * (double)dz;
        return Math.sqrt(((double)px - projX) * ((double)px - projX) + ((double)pz - projZ) * ((double)pz - projZ));
    }

    private static double boxLineDist(int lineX0, int lineZ0, int lineX1, int lineZ1, int boxX, int boxZ) {
        int[][] corners;
        double minDist = Double.MAX_VALUE;
        for (int[] corner : corners = new int[][]{{0, 0}, {0, 16}, {16, 0}, {16, 16}}) {
            minDist = Math.min(minDist, ChunkShapeHelper.pointSegmentDist(lineX0, lineZ0, lineX1, lineZ1, boxX + corner[0], boxZ + corner[1]));
        }
        return minDist;
    }

    public static List<ChunkCoordIntPair> getChunksAlongLineSegment(int x0, int z0, int x1, int z1, double paddingSize) {
        int dx = Math.abs(x1 - x0);
        int sx = x0 < x1 ? 1 : -1;
        int dz = -Math.abs(z1 - z0);
        int sz = z0 < z1 ? 1 : -1;
        int error = dx + dz;
        int originalX = x0;
        int originalZ = z0;
        ArrayList<ChunkCoordIntPair> out = new ArrayList<ChunkCoordIntPair>();
        ArrayList<ChunkCoordIntPair> checked = new ArrayList<ChunkCoordIntPair>();
        while (true) {
            int[][] corners;
            ChunkCoordIntPair coords;
            if (!out.contains(coords = new ChunkCoordIntPair(x0 >> 4, z0 >> 4))) {
                out.add(coords);
            }
            for (int[] corner : corners = new int[][]{{-1, -1}, {0, -1}, {1, -1}, {-1, 0}, {1, 0}, {-1, 1}, {0, 1}, {1, 1}}) {
                ChunkCoordIntPair cornerCoords = new ChunkCoordIntPair((x0 >> 4) + corner[0], (z0 >> 4) + corner[1]);
                if (checked.contains(cornerCoords)) continue;
                checked.add(cornerCoords);
                if (out.contains(cornerCoords) || !(ChunkShapeHelper.boxLineDist(originalX, originalZ, x1, z1, cornerCoords.field_77276_a * 16, cornerCoords.field_77275_b * 16) < paddingSize)) continue;
                out.add(cornerCoords);
            }
            int e2 = 2 * error;
            if (e2 >= dz) {
                if (x0 == x1) break;
                error += dz;
                x0 += sx;
            }
            if (e2 > dx) continue;
            if (z0 == z1) break;
            error += dx;
            z0 += sz;
        }
        return out;
    }
}

