/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.turret;

import com.hbm.blocks.ModBlocks;
import com.hbm.handler.threading.PacketThreading;
import com.hbm.inventory.gui.GUITurretMaxwell;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemMachineUpgrade;
import com.hbm.lib.ModDamageSource;
import com.hbm.packet.toclient.AuxParticlePacketNT;
import com.hbm.potion.HbmPotion;
import com.hbm.tileentity.IUpgradeInfoProvider;
import com.hbm.tileentity.turret.TileEntityTurretBaseNT;
import com.hbm.util.BobMathUtil;
import com.hbm.util.EntityDamageUtil;
import com.hbm.util.i18n.I18nUtil;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class TileEntityTurretMaxwell
extends TileEntityTurretBaseNT
implements IUpgradeInfoProvider {
    public int beam;
    public double lastDist;
    int redLevel;
    int greenLevel;
    int blueLevel;
    int blackLevel;
    int pinkLevel;
    boolean _5g;
    boolean screm;
    int checkDelay;
    private boolean shot = false;

    @Override
    public String getName() {
        return "container.turretMaxwell";
    }

    @Override
    protected List<Integer> getAmmoList() {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<ItemStack> getAmmoTypesForDisplay() {
        if (this.ammoStacks != null) {
            return this.ammoStacks;
        }
        this.ammoStacks = new ArrayList();
        this.ammoStacks.add(new ItemStack(ModItems.upgrade_speed_1));
        this.ammoStacks.add(new ItemStack(ModItems.upgrade_speed_2));
        this.ammoStacks.add(new ItemStack(ModItems.upgrade_speed_3));
        this.ammoStacks.add(new ItemStack(ModItems.upgrade_effect_1));
        this.ammoStacks.add(new ItemStack(ModItems.upgrade_effect_2));
        this.ammoStacks.add(new ItemStack(ModItems.upgrade_effect_3));
        this.ammoStacks.add(new ItemStack(ModItems.upgrade_power_1));
        this.ammoStacks.add(new ItemStack(ModItems.upgrade_power_2));
        this.ammoStacks.add(new ItemStack(ModItems.upgrade_power_3));
        this.ammoStacks.add(new ItemStack(ModItems.upgrade_afterburn_1));
        this.ammoStacks.add(new ItemStack(ModItems.upgrade_afterburn_2));
        this.ammoStacks.add(new ItemStack(ModItems.upgrade_afterburn_3));
        this.ammoStacks.add(new ItemStack(ModItems.upgrade_overdrive_1));
        this.ammoStacks.add(new ItemStack(ModItems.upgrade_overdrive_2));
        this.ammoStacks.add(new ItemStack(ModItems.upgrade_overdrive_3));
        this.ammoStacks.add(new ItemStack(ModItems.upgrade_5g));
        this.ammoStacks.add(new ItemStack(ModItems.upgrade_screm));
        return this.ammoStacks;
    }

    @Override
    public boolean canProvideInfo(ItemMachineUpgrade.UpgradeType type, int level, boolean extendedInfo) {
        return type == ItemMachineUpgrade.UpgradeType.SPEED || type == ItemMachineUpgrade.UpgradeType.EFFECT || type == ItemMachineUpgrade.UpgradeType.POWER || type == ItemMachineUpgrade.UpgradeType.AFTERBURN || type == ItemMachineUpgrade.UpgradeType.OVERDRIVE;
    }

    @Override
    public void provideInfo(ItemMachineUpgrade.UpgradeType type, int level, List<String> info, boolean extendedInfo) {
        info.add(IUpgradeInfoProvider.getStandardLabel(ModBlocks.turret_maxwell));
        if (type == ItemMachineUpgrade.UpgradeType.SPEED) {
            info.add(EnumChatFormatting.GREEN + "Damage +0." + level * 25 + "/t");
        }
        if (type == ItemMachineUpgrade.UpgradeType.POWER) {
            info.add(EnumChatFormatting.GREEN + I18nUtil.resolveKey("upgrade.consumption", "-" + level * 3 + "%"));
        }
        if (type == ItemMachineUpgrade.UpgradeType.EFFECT) {
            info.add(EnumChatFormatting.GREEN + I18nUtil.resolveKey("upgrade.range", "+" + level * 3 + "m"));
        }
        if (type == ItemMachineUpgrade.UpgradeType.AFTERBURN) {
            info.add(EnumChatFormatting.GREEN + "Afterburn +3s");
        }
        if (type == ItemMachineUpgrade.UpgradeType.OVERDRIVE) {
            info.add((BobMathUtil.getBlink() ? EnumChatFormatting.RED : EnumChatFormatting.DARK_GRAY) + "YES");
        }
    }

    @Override
    public HashMap<ItemMachineUpgrade.UpgradeType, Integer> getValidUpgrades() {
        HashMap<ItemMachineUpgrade.UpgradeType, Integer> upgrades = new HashMap<ItemMachineUpgrade.UpgradeType, Integer>();
        upgrades.put(ItemMachineUpgrade.UpgradeType.SPEED, 27);
        upgrades.put(ItemMachineUpgrade.UpgradeType.POWER, 27);
        upgrades.put(ItemMachineUpgrade.UpgradeType.EFFECT, 27);
        upgrades.put(ItemMachineUpgrade.UpgradeType.AFTERBURN, 27);
        upgrades.put(ItemMachineUpgrade.UpgradeType.OVERDRIVE, 27);
        return upgrades;
    }

    @Override
    public double getAcceptableInaccuracy() {
        return 2.0;
    }

    @Override
    public double getDecetorGrace() {
        return 5.0;
    }

    @Override
    public double getTurretYawSpeed() {
        return 9.0;
    }

    @Override
    public double getTurretPitchSpeed() {
        return 6.0;
    }

    @Override
    public double getTurretElevation() {
        return 40.0;
    }

    @Override
    public double getTurretDepression() {
        return 35.0;
    }

    @Override
    public double getDecetorRange() {
        return 64.0 + (double)(this.greenLevel * 3);
    }

    @Override
    public long getMaxPower() {
        return 10000000L;
    }

    @Override
    public long getConsumption() {
        return this._5g ? 10L : (long)(10000 - this.blueLevel * 300);
    }

    @Override
    public double getBarrelLength() {
        return 2.125;
    }

    @Override
    public double getHeightOffset() {
        return 2.0;
    }

    @Override
    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            if (this.tPos != null) {
                double length;
                Vec3 pos = this.getTurretPos();
                this.lastDist = length = Vec3.func_72443_a((double)(this.tPos.field_72450_a - pos.field_72450_a), (double)(this.tPos.field_72448_b - pos.field_72448_b), (double)(this.tPos.field_72449_c - pos.field_72449_c)).func_72433_c();
            }
            if (this.beam > 0) {
                --this.beam;
            }
        } else {
            if (this.checkDelay <= 0) {
                this.checkDelay = 20;
                this.redLevel = 0;
                this.greenLevel = 0;
                this.blueLevel = 0;
                this.blackLevel = 0;
                this.pinkLevel = 0;
                this._5g = false;
                this.screm = false;
                for (int i = 1; i < 10; ++i) {
                    if (this.slots[i] == null) continue;
                    Item item = this.slots[i].func_77973_b();
                    if (item == ModItems.upgrade_speed_1) {
                        ++this.redLevel;
                    }
                    if (item == ModItems.upgrade_speed_2) {
                        this.redLevel += 2;
                    }
                    if (item == ModItems.upgrade_speed_3) {
                        this.redLevel += 3;
                    }
                    if (item == ModItems.upgrade_effect_1) {
                        ++this.greenLevel;
                    }
                    if (item == ModItems.upgrade_effect_2) {
                        this.greenLevel += 2;
                    }
                    if (item == ModItems.upgrade_effect_3) {
                        this.greenLevel += 3;
                    }
                    if (item == ModItems.upgrade_power_1) {
                        ++this.blueLevel;
                    }
                    if (item == ModItems.upgrade_power_2) {
                        this.blueLevel += 2;
                    }
                    if (item == ModItems.upgrade_power_3) {
                        this.blueLevel += 3;
                    }
                    if (item == ModItems.upgrade_afterburn_1) {
                        ++this.pinkLevel;
                    }
                    if (item == ModItems.upgrade_afterburn_2) {
                        this.pinkLevel += 2;
                    }
                    if (item == ModItems.upgrade_afterburn_3) {
                        this.pinkLevel += 3;
                    }
                    if (item == ModItems.upgrade_overdrive_1) {
                        ++this.blackLevel;
                    }
                    if (item == ModItems.upgrade_overdrive_2) {
                        this.blackLevel += 2;
                    }
                    if (item == ModItems.upgrade_overdrive_3) {
                        this.blackLevel += 3;
                    }
                    if (item == ModItems.upgrade_5g) {
                        this._5g = true;
                    }
                    if (item != ModItems.upgrade_screm) continue;
                    this.screm = true;
                }
            }
            --this.checkDelay;
        }
        super.func_145845_h();
    }

    @Override
    public void updateFiringTick() {
        long demand = this.getConsumption() * 10L;
        if (this.target != null && this.getPower() >= demand) {
            if (this._5g && this.target instanceof EntityPlayer) {
                EntityPlayer living = (EntityPlayer)this.target;
                living.func_70690_d(new PotionEffect(HbmPotion.death.field_76415_H, 36000, 0, true));
            } else {
                EntityDamageUtil.attackEntityFromIgnoreIFrame(this.target, ModDamageSource.microwave, ((float)(this.blackLevel * 10 + this.redLevel) + 1.0f) * 0.25f);
            }
            if (this.pinkLevel > 0) {
                this.target.func_70015_d(this.pinkLevel * 3);
            }
            if (!this.target.func_70089_S() && this.target instanceof EntityLivingBase) {
                NBTTagCompound vdat = new NBTTagCompound();
                vdat.func_74778_a("type", "giblets");
                vdat.func_74768_a("ent", this.target.func_145782_y());
                PacketThreading.createAllAroundThreadedPacket(new AuxParticlePacketNT(vdat, this.target.field_70165_t, this.target.field_70163_u + (double)this.target.field_70131_O * 0.5, this.target.field_70161_v), new NetworkRegistry.TargetPoint(this.target.field_71093_bK, this.target.field_70165_t, this.target.field_70163_u + (double)this.target.field_70131_O * 0.5, this.target.field_70161_v, 150.0));
                if (this.screm) {
                    this.field_145850_b.func_72908_a(this.target.field_70165_t, this.target.field_70163_u, this.target.field_70161_v, "hbm:block.screm", 20.0f, 1.0f);
                } else {
                    this.field_145850_b.func_72908_a(this.target.field_70165_t, this.target.field_70163_u, this.target.field_70161_v, "mob.zombie.woodbreak", 2.0f, 0.95f + this.field_145850_b.field_73012_v.nextFloat() * 0.2f);
                }
            }
            this.power -= demand;
            this.shot = true;
            this.networkPackNT(250);
            this.shot = false;
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        if (this.shot) {
            buf.writeBoolean(true);
        } else {
            buf.writeBoolean(false);
            super.serialize(buf);
        }
    }

    @Override
    public void deserialize(ByteBuf buf) {
        boolean shot = buf.readBoolean();
        if (shot) {
            this.beam = 5;
        } else {
            super.deserialize(buf);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUITurretMaxwell(player.field_71071_by, this);
    }
}

