/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.network;

import api.hbm.energymk2.IEnergyProviderMK2;
import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyHandler;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.tileentity.IConfigurableMachine;
import com.hbm.tileentity.TileEntityLoadedBase;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityConverterRfHe
extends TileEntityLoadedBase
implements IEnergyProviderMK2,
IEnergyHandler,
IConfigurableMachine {
    public long power;
    public final long maxPower = 5000000L;
    public static long rfInput = 2L;
    public static long heOutput = 5L;
    public static double inputDecay = 0.0;
    public EnergyStorage storage = new EnergyStorage(1000000, 1000000, 1000000);

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            long rfCreated = Math.min((long)this.storage.getEnergyStored(), (5000000L - this.power) * rfInput / heOutput);
            this.storage.setEnergyStored((int)((long)this.storage.getEnergyStored() - rfCreated));
            this.power += rfCreated * heOutput / rfInput;
            if (this.storage.getEnergyStored() > 0) {
                this.storage.extractEnergy((int)Math.ceil((double)this.storage.getEnergyStored() * inputDecay), false);
            }
            if (rfCreated > 0L) {
                this.field_145850_b.func_147476_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, (TileEntity)this);
            }
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                this.tryProvide(this.field_145850_b, this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ, dir);
            }
        }
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.storage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public long getMaxPower() {
        return 5000000L;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.storage.readFromNBT(nbt);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        this.storage.writeToNBT(nbt);
    }

    @Override
    public String getConfigName() {
        return "RFToHEConverter";
    }

    @Override
    public void readIfPresent(JsonObject obj) {
        rfInput = IConfigurableMachine.grab(obj, "L:RF_Used2", rfInput);
        heOutput = IConfigurableMachine.grab(obj, "L:HE_Created2", heOutput);
        inputDecay = IConfigurableMachine.grab(obj, "D:inputDecay2", inputDecay);
    }

    @Override
    public void writeConfig(JsonWriter writer) throws IOException {
        writer.name("L:RF_Used2").value(rfInput);
        writer.name("L:HE_Created2").value(heOutput);
        writer.name("D:inputDecay2").value(inputDecay);
    }
}

