/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity;

import api.hbm.fluid.IFluidStandardSender;
import com.hbm.handler.pollution.PollutionHandler;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.fluid.trait.FT_Polluting;
import com.hbm.inventory.fluid.trait.FluidTrait;
import com.hbm.tileentity.TileEntityMachineBase;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityMachinePolluting
extends TileEntityMachineBase
implements IFluidStandardSender {
    public FluidTank smoke;
    public FluidTank smoke_leaded;
    public FluidTank smoke_poison;

    public TileEntityMachinePolluting(int scount, int buffer) {
        super(scount);
        this.smoke = new FluidTank(Fluids.SMOKE, buffer);
        this.smoke_leaded = new FluidTank(Fluids.SMOKE_LEADED, buffer);
        this.smoke_poison = new FluidTank(Fluids.SMOKE_POISON, buffer);
    }

    public void pollute(PollutionHandler.PollutionType type, float amount) {
        FluidTank tank = type == PollutionHandler.PollutionType.SOOT ? this.smoke : (type == PollutionHandler.PollutionType.HEAVYMETAL ? this.smoke_leaded : this.smoke_poison);
        int fluidAmount = (int)Math.ceil(amount * 100.0f);
        tank.setFill(tank.getFill() + fluidAmount);
        if (tank.getFill() > tank.getMaxFill()) {
            int overflow = tank.getFill() - tank.getMaxFill();
            tank.setFill(tank.getMaxFill());
            PollutionHandler.incrementPollution(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, type, (float)overflow / 100.0f);
            if (this.field_145850_b.field_73012_v.nextInt(3) == 0) {
                this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "random.fizz", 0.1f, 1.5f);
            }
        }
    }

    public void pollute(FluidType type, FluidTrait.FluidReleaseType release, float amount) {
        FT_Polluting trait = type.getTrait(FT_Polluting.class);
        if (trait == null) {
            return;
        }
        if (release == FluidTrait.FluidReleaseType.VOID) {
            return;
        }
        HashMap<PollutionHandler.PollutionType, Float> map = release == FluidTrait.FluidReleaseType.BURN ? trait.burnMap : trait.releaseMap;
        for (Map.Entry<PollutionHandler.PollutionType, Float> entry : map.entrySet()) {
            FluidTank tank = entry.getKey() == PollutionHandler.PollutionType.SOOT ? this.smoke : (entry.getKey() == PollutionHandler.PollutionType.HEAVYMETAL ? this.smoke_leaded : this.smoke_poison);
            int fluidAmount = (int)Math.ceil(entry.getValue().floatValue() * amount * 100.0f);
            tank.setFill(tank.getFill() + fluidAmount);
            if (tank.getFill() <= tank.getMaxFill()) continue;
            int overflow = tank.getFill() - tank.getMaxFill();
            tank.setFill(tank.getMaxFill());
            PollutionHandler.incrementPollution(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, entry.getKey(), (float)overflow / 100.0f);
            if (this.field_145850_b.field_73012_v.nextInt(3) != 0) continue;
            this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "random.fizz", 0.1f, 1.5f);
        }
    }

    public void sendSmoke(int x, int y, int z, ForgeDirection dir) {
        if (this.smoke.getFill() > 0) {
            this.sendFluid(this.smoke, this.field_145850_b, x, y, z, dir);
        }
        if (this.smoke_leaded.getFill() > 0) {
            this.sendFluid(this.smoke_leaded, this.field_145850_b, x, y, z, dir);
        }
        if (this.smoke_poison.getFill() > 0) {
            this.sendFluid(this.smoke_poison, this.field_145850_b, x, y, z, dir);
        }
    }

    public FluidTank[] getSmokeTanks() {
        return new FluidTank[]{this.smoke, this.smoke_leaded, this.smoke_poison};
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.smoke.readFromNBT(nbt, "smoke0");
        this.smoke_leaded.readFromNBT(nbt, "smoke1");
        this.smoke_poison.readFromNBT(nbt, "smoke2");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.smoke.writeToNBT(nbt, "smoke0");
        this.smoke_leaded.writeToNBT(nbt, "smoke1");
        this.smoke_poison.writeToNBT(nbt, "smoke2");
    }
}

