/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.weapon;

import com.hbm.entity.missile.EntityMissileCustom;
import com.hbm.items.special.ItemLootCrate;
import com.hbm.main.MainRegistry;
import com.hbm.util.i18n.I18nUtil;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;

public class ItemCustomMissilePart
extends Item {
    public PartType type;
    public PartSize top;
    public PartSize bottom;
    public Rarity rarity;
    public float health;
    private String title;
    private String author;
    private String witty;
    public static HashMap<Integer, ItemCustomMissilePart> parts = new HashMap();
    public Object[] attributes;

    public ItemCustomMissilePart() {
        this.func_77625_d(1);
        this.func_77637_a(MainRegistry.missileTab);
    }

    public ItemCustomMissilePart makeChip(float inaccuracy) {
        this.type = PartType.CHIP;
        this.top = PartSize.ANY;
        this.bottom = PartSize.ANY;
        this.attributes = new Object[]{Float.valueOf(inaccuracy)};
        parts.put(((Object)((Object)this)).hashCode(), this);
        return this;
    }

    public ItemCustomMissilePart makeWarhead(WarheadType type, float punch, float weight, PartSize size) {
        this.type = PartType.WARHEAD;
        this.top = PartSize.NONE;
        this.bottom = size;
        this.attributes = new Object[]{type, Float.valueOf(punch), Float.valueOf(weight)};
        this.func_111206_d("hbm:mp_warhead");
        parts.put(((Object)((Object)this)).hashCode(), this);
        return this;
    }

    public ItemCustomMissilePart makeFuselage(FuelType type, float fuel, PartSize top, PartSize bottom) {
        this.type = PartType.FUSELAGE;
        this.top = top;
        this.bottom = bottom;
        this.attributes = new Object[]{type, Float.valueOf(fuel)};
        this.func_111206_d("hbm:mp_fuselage");
        parts.put(((Object)((Object)this)).hashCode(), this);
        return this;
    }

    public ItemCustomMissilePart makeStability(float inaccuracy, PartSize size) {
        this.type = PartType.FINS;
        this.top = size;
        this.bottom = size;
        this.attributes = new Object[]{Float.valueOf(inaccuracy)};
        this.func_111206_d("hbm:mp_stability");
        parts.put(((Object)((Object)this)).hashCode(), this);
        return this;
    }

    public ItemCustomMissilePart makeThruster(FuelType type, float consumption, float lift, PartSize size) {
        this.type = PartType.THRUSTER;
        this.top = size;
        this.bottom = PartSize.NONE;
        this.attributes = new Object[]{type, Float.valueOf(consumption), Float.valueOf(lift)};
        this.func_111206_d("hbm:mp_thruster");
        parts.put(((Object)((Object)this)).hashCode(), this);
        return this;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        if (this.title != null) {
            list.add(EnumChatFormatting.DARK_PURPLE + "\"" + this.title + "\"");
        }
        try {
            switch (this.type) {
                case CHIP: {
                    list.add(EnumChatFormatting.BOLD + I18nUtil.resolveKey("item.missile.part.inaccuracy", new Object[0]) + ": " + EnumChatFormatting.GRAY + ((Float)this.attributes[0]).floatValue() * 100.0f + "%");
                    break;
                }
                case WARHEAD: {
                    list.add(EnumChatFormatting.BOLD + I18nUtil.resolveKey("item.missile.part.size", new Object[0]) + ": " + EnumChatFormatting.GRAY + this.getSize(this.bottom));
                    list.add(EnumChatFormatting.BOLD + I18nUtil.resolveKey("item.missile.part.type", new Object[0]) + ": " + EnumChatFormatting.GRAY + this.getWarhead((WarheadType)((Object)this.attributes[0])));
                    list.add(EnumChatFormatting.BOLD + I18nUtil.resolveKey("item.missile.part.strength", new Object[0]) + ": " + EnumChatFormatting.GRAY + (Float)this.attributes[1]);
                    list.add(EnumChatFormatting.BOLD + I18nUtil.resolveKey("item.missile.part.weight", new Object[0]) + ": " + EnumChatFormatting.GRAY + (Float)this.attributes[2] + "t");
                    break;
                }
                case FUSELAGE: {
                    list.add(EnumChatFormatting.BOLD + I18nUtil.resolveKey("item.missile.part.topSize", new Object[0]) + ": " + EnumChatFormatting.GRAY + this.getSize(this.top));
                    list.add(EnumChatFormatting.BOLD + I18nUtil.resolveKey("item.missile.part.bottomSize", new Object[0]) + ": " + EnumChatFormatting.GRAY + this.getSize(this.bottom));
                    list.add(EnumChatFormatting.BOLD + I18nUtil.resolveKey("item.missile.part.fuelType", new Object[0]) + ": " + EnumChatFormatting.GRAY + this.getFuel((FuelType)((Object)this.attributes[0])));
                    list.add(EnumChatFormatting.BOLD + I18nUtil.resolveKey("item.missile.part.fuelAmount", new Object[0]) + ": " + EnumChatFormatting.GRAY + (Float)this.attributes[1] + "l");
                    break;
                }
                case FINS: {
                    list.add(EnumChatFormatting.BOLD + I18nUtil.resolveKey("item.missile.part.size", new Object[0]) + ": " + EnumChatFormatting.GRAY + this.getSize(this.top));
                    list.add(EnumChatFormatting.BOLD + I18nUtil.resolveKey("item.missile.part.inaccuracy", new Object[0]) + ": " + EnumChatFormatting.GRAY + ((Float)this.attributes[0]).floatValue() * 100.0f + "%");
                    break;
                }
                case THRUSTER: {
                    list.add(EnumChatFormatting.BOLD + I18nUtil.resolveKey("item.missile.part.size", new Object[0]) + ": " + EnumChatFormatting.GRAY + this.getSize(this.top));
                    list.add(EnumChatFormatting.BOLD + I18nUtil.resolveKey("item.missile.part.fuelType", new Object[0]) + ": " + EnumChatFormatting.GRAY + this.getFuel((FuelType)((Object)this.attributes[0])));
                    list.add(EnumChatFormatting.BOLD + I18nUtil.resolveKey("item.missile.part.fuelConsumption", new Object[0]) + ": " + EnumChatFormatting.GRAY + (Float)this.attributes[1] + "l/tick");
                    list.add(EnumChatFormatting.BOLD + I18nUtil.resolveKey("item.missile.part.maxPayload", new Object[0]) + ": " + EnumChatFormatting.GRAY + (Float)this.attributes[2] + "t");
                }
            }
        }
        catch (Exception ex) {
            list.add(I18nUtil.resolveKey("error.generic", new Object[0]));
        }
        if (this.type != PartType.CHIP) {
            list.add(EnumChatFormatting.BOLD + I18nUtil.resolveKey("item.missile.part.health", new Object[0]) + ": " + EnumChatFormatting.GRAY + this.health + "HP");
        }
        if (this.rarity != null) {
            list.add(EnumChatFormatting.BOLD + I18nUtil.resolveKey("item.missile.part.rarity", new Object[0]) + ": " + EnumChatFormatting.GRAY + this.rarity.getDisplay());
        }
        if (this.author != null) {
            list.add(EnumChatFormatting.WHITE + "   " + I18nUtil.resolveKey("item.missile.part.by", new Object[0]) + " " + this.author);
        }
        if (this.witty != null) {
            list.add(EnumChatFormatting.GOLD + "   " + EnumChatFormatting.ITALIC + "\"" + this.witty + "\"");
        }
    }

    public String getSize(PartSize size) {
        switch (size) {
            case ANY: {
                return I18nUtil.resolveKey("item.missile.part.size.any", new Object[0]);
            }
            case SIZE_10: {
                return "1.0m";
            }
            case SIZE_15: {
                return "1.5m";
            }
            case SIZE_20: {
                return "2.0m";
            }
        }
        return I18nUtil.resolveKey("item.missile.part.size.none", new Object[0]);
    }

    public String getWarhead(WarheadType type) {
        if (type.labelCustom != null) {
            return type.labelCustom;
        }
        switch (type) {
            case HE: {
                return EnumChatFormatting.YELLOW + I18nUtil.resolveKey("item.warhead.desc.he", new Object[0]);
            }
            case INC: {
                return EnumChatFormatting.GOLD + I18nUtil.resolveKey("item.warhead.desc.incendiary", new Object[0]);
            }
            case CLUSTER: {
                return EnumChatFormatting.GRAY + I18nUtil.resolveKey("item.warhead.desc.cluster", new Object[0]);
            }
            case BUSTER: {
                return EnumChatFormatting.WHITE + I18nUtil.resolveKey("item.warhead.desc.bunker_buster", new Object[0]);
            }
            case NUCLEAR: {
                return EnumChatFormatting.DARK_GREEN + I18nUtil.resolveKey("item.warhead.desc.nuclear", new Object[0]);
            }
            case TX: {
                return EnumChatFormatting.DARK_PURPLE + I18nUtil.resolveKey("item.warhead.desc.thermonuclear", new Object[0]);
            }
            case N2: {
                return EnumChatFormatting.RED + I18nUtil.resolveKey("item.warhead.desc.n2", new Object[0]);
            }
            case BALEFIRE: {
                return EnumChatFormatting.GREEN + I18nUtil.resolveKey("item.warhead.desc.balefire", new Object[0]);
            }
            case SCHRAB: {
                return EnumChatFormatting.AQUA + I18nUtil.resolveKey("item.warhead.desc.schrabidium", new Object[0]);
            }
            case TAINT: {
                return EnumChatFormatting.DARK_PURPLE + I18nUtil.resolveKey("item.warhead.desc.taint", new Object[0]);
            }
            case CLOUD: {
                return EnumChatFormatting.LIGHT_PURPLE + I18nUtil.resolveKey("item.warhead.desc.cloud", new Object[0]);
            }
            case TURBINE: {
                return (System.currentTimeMillis() % 1000L < 500L ? EnumChatFormatting.RED : EnumChatFormatting.LIGHT_PURPLE) + I18nUtil.resolveKey("item.warhead.desc.turbine", new Object[0]);
            }
        }
        return EnumChatFormatting.BOLD + I18nUtil.resolveKey("general.na", new Object[0]);
    }

    public String getFuel(FuelType type) {
        switch (type) {
            case KEROSENE: {
                return EnumChatFormatting.LIGHT_PURPLE + I18nUtil.resolveKey("item.missile.fuel.kerosene_peroxide", new Object[0]);
            }
            case SOLID: {
                return EnumChatFormatting.GOLD + I18nUtil.resolveKey("item.missile.fuel.solid", new Object[0]);
            }
            case HYDROGEN: {
                return EnumChatFormatting.DARK_AQUA + I18nUtil.resolveKey("item.missile.fuel.hydrogen", new Object[0]);
            }
            case XENON: {
                return EnumChatFormatting.DARK_PURPLE + I18nUtil.resolveKey("item.missile.fuel.xenon", new Object[0]);
            }
            case BALEFIRE: {
                return EnumChatFormatting.GREEN + I18nUtil.resolveKey("item.missile.fuel.balefire", new Object[0]);
            }
        }
        return EnumChatFormatting.BOLD + I18nUtil.resolveKey("general.na", new Object[0]);
    }

    public ItemCustomMissilePart copy() {
        ItemCustomMissilePart part = new ItemCustomMissilePart();
        part.type = this.type;
        part.top = this.top;
        part.bottom = this.bottom;
        part.health = this.health;
        part.attributes = this.attributes;
        part.health = this.health;
        part.func_111206_d(this.field_111218_cA);
        return part;
    }

    public ItemCustomMissilePart setAuthor(String author) {
        this.author = author;
        return this;
    }

    public ItemCustomMissilePart setTitle(String title) {
        this.title = title;
        return this;
    }

    public ItemCustomMissilePart setWittyText(String witty) {
        this.witty = witty;
        return this;
    }

    public ItemCustomMissilePart setHealth(float health) {
        this.health = health;
        return this;
    }

    public ItemCustomMissilePart setRarity(Rarity rarity) {
        this.rarity = rarity;
        if (this.type == PartType.FUSELAGE) {
            if (this.top == PartSize.SIZE_10) {
                ItemLootCrate.list10.add(this);
            }
            if (this.top == PartSize.SIZE_15) {
                ItemLootCrate.list15.add(this);
            }
        } else {
            ItemLootCrate.listMisc.add(this);
        }
        return this;
    }

    public static enum Rarity {
        COMMON("item.missile.part.rarity.common", EnumChatFormatting.GRAY),
        UNCOMMON("item.missile.part.rarity.uncommon", EnumChatFormatting.YELLOW),
        RARE("item.missile.part.rarity.rare", EnumChatFormatting.AQUA),
        EPIC("item.missile.part.rarity.epic", EnumChatFormatting.LIGHT_PURPLE),
        LEGENDARY("item.missile.part.rarity.legendary", EnumChatFormatting.DARK_GREEN),
        SEWS_CLOTHES_AND_SUCKS_HORSE_COCK("item.missile.part.rarity.strange", EnumChatFormatting.DARK_AQUA);

        private final String key;
        private final EnumChatFormatting color;

        private Rarity(String key, EnumChatFormatting color) {
            this.key = key;
            this.color = color;
        }

        public String getDisplay() {
            return this.color + I18nUtil.resolveKey(this.key, new Object[0]);
        }
    }

    public static enum FuelType {
        KEROSENE,
        SOLID,
        HYDROGEN,
        XENON,
        BALEFIRE;

    }

    public static enum WarheadType {
        HE,
        INC,
        BUSTER,
        CLUSTER,
        NUCLEAR,
        TX,
        N2,
        BALEFIRE,
        SCHRAB,
        TAINT,
        CLOUD,
        TURBINE,
        CUSTOM0,
        CUSTOM1,
        CUSTOM2,
        CUSTOM3,
        CUSTOM4,
        CUSTOM5,
        CUSTOM6,
        CUSTOM7,
        CUSTOM8,
        CUSTOM9;

        public Consumer<EntityMissileCustom> impactCustom = null;
        public Consumer<EntityMissileCustom> updateCustom = null;
        public String labelCustom = null;
    }

    public static enum PartSize {
        ANY,
        NONE,
        SIZE_10,
        SIZE_15,
        SIZE_20;

    }

    public static enum PartType {
        CHIP,
        WARHEAD,
        FUSELAGE,
        FINS,
        THRUSTER;

    }
}

