/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.tool;

import com.hbm.inventory.container.ContainerToolBox;
import com.hbm.inventory.gui.GUIToolBox;
import com.hbm.items.ItemInventory;
import com.hbm.items.ModItems;
import com.hbm.main.MainRegistry;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.util.ItemStackUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemToolBox
extends Item
implements IGUIProvider {
    @SideOnly(value=Side.CLIENT)
    protected IIcon iconOpen;
    @SideOnly(value=Side.CLIENT)
    protected IIcon iconClosed;

    public ItemToolBox() {
        this.func_77625_d(1);
    }

    public int func_77626_a(ItemStack stack) {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        super.func_94581_a(iconRegister);
        this.iconOpen = iconRegister.func_94245_a("hbm:kit_toolbox_empty");
        this.iconClosed = iconRegister.func_94245_a("hbm:kit_toolbox");
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int renderPass) {
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74767_n("isOpen") && renderPass == 1) {
            return this.iconOpen;
        }
        return renderPass == 1 ? this.iconClosed : this.func_77618_c(stack.func_77960_j(), renderPass);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        list.add("Click with the toolbox to swap hotbars in/out of the toolbox.");
        list.add("Shift-click with the toolbox to open the toolbox.");
    }

    public List<Integer> getActiveRows(ItemStack box) {
        ItemStack[] stacks = ItemStackUtil.readStacksFromNBT(box, 24);
        if (stacks == null) {
            return new ArrayList<Integer>();
        }
        ArrayList<Integer> activeRows = new ArrayList<Integer>();
        block0: for (int row = 0; row < 3; ++row) {
            for (int slot = 0; slot < 8; ++slot) {
                if (stacks[row * 8 + slot] == null) continue;
                activeRows.add(row);
                continue block0;
            }
        }
        return activeRows;
    }

    public void moveRows(ItemStack box, EntityPlayer player) {
        ItemStack[] endingHotBar = new ItemStack[9];
        ItemStack[] stacksToTransferToBox = new ItemStack[8];
        boolean hasToolbox = false;
        int extraToolboxes = 0;
        for (int i = 0; i < 9; ++i) {
            ItemStack slot = player.field_71071_by.func_70301_a(i);
            if (slot != null && slot.func_77973_b() == ModItems.toolbox && i != player.field_71071_by.field_70461_c) {
                ++extraToolboxes;
                player.func_71019_a(slot, true);
                player.field_71071_by.func_70299_a(i, null);
                continue;
            }
            if (i == player.field_71071_by.field_70461_c) {
                hasToolbox = true;
                endingHotBar[i] = slot;
                continue;
            }
            stacksToTransferToBox[i - (hasToolbox ? 1 : 0)] = slot;
        }
        if (extraToolboxes > 0) {
            if (extraToolboxes == 1) {
                player.func_146105_b(new ChatComponentText("You can't toolbox a toolbox... ").func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.RED)));
            } else {
                player.func_146105_b(new ChatComponentText("You can't toolbox a toolbox... (x" + extraToolboxes + ")").func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.RED)));
            }
        }
        ItemStack[] stacks = ItemStackUtil.readStacksFromNBT(box, 24);
        ItemStack[] endingStacks = new ItemStack[24];
        int lowestActiveIndex = Integer.MAX_VALUE;
        int lowestInactiveIndex = Integer.MAX_VALUE;
        if (stacks != null) {
            List<Integer> activeRows = this.getActiveRows(box);
            for (int i = 0; i < 3; ++i) {
                if (activeRows.contains(i)) {
                    lowestActiveIndex = Math.min(i, lowestActiveIndex);
                    continue;
                }
                lowestInactiveIndex = Math.min(i, lowestInactiveIndex);
            }
            lowestInactiveIndex = lowestInactiveIndex > 2 ? 2 : Math.max(0, lowestInactiveIndex - 1);
            for (Integer activeRowIndex : activeRows) {
                int activeIndex = 8 * activeRowIndex;
                if (activeRowIndex == lowestActiveIndex) {
                    hasToolbox = false;
                    for (int i = 0; i < 9; ++i) {
                        if (i == player.field_71071_by.field_70461_c) {
                            hasToolbox = true;
                            continue;
                        }
                        endingHotBar[i] = stacks[activeIndex + i - (hasToolbox ? 1 : 0)];
                    }
                    continue;
                }
                int targetIndex = 8 * (activeRowIndex - 1);
                System.arraycopy(stacks, activeIndex, endingStacks, targetIndex, 8);
            }
        }
        if (stacks == null) {
            lowestInactiveIndex = 0;
        }
        System.arraycopy(stacksToTransferToBox, 0, endingStacks, lowestInactiveIndex * 8, 8);
        for (int i = 0; i < endingHotBar.length; ++i) {
            player.field_71071_by.func_70299_a(i, endingHotBar[i]);
        }
        box.func_77982_d(new NBTTagCompound());
        ItemStackUtil.addStacksToNBT(box, endingStacks);
        NBTTagCompound nbt = box.func_77978_p();
        if (!nbt.func_82582_d()) {
            Random random = new Random();
            try {
                byte[] abyte = CompressedStreamTools.func_74798_a((NBTTagCompound)nbt);
                if (abyte.length > 6000) {
                    player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Warning: Container NBT exceeds 6kB, contents will be ejected!"));
                    ItemStack[] stacks1 = ItemStackUtil.readStacksFromNBT(box, 24);
                    if (stacks1 == null) {
                        return;
                    }
                    for (ItemStack itemstack : stacks1) {
                        if (itemstack == null) continue;
                        float f = random.nextFloat() * 0.8f + 0.1f;
                        float f1 = random.nextFloat() * 0.8f + 0.1f;
                        float f2 = random.nextFloat() * 0.8f + 0.1f;
                        while (itemstack.field_77994_a > 0) {
                            int j1 = random.nextInt(21) + 10;
                            if (j1 > itemstack.field_77994_a) {
                                j1 = itemstack.field_77994_a;
                            }
                            itemstack.field_77994_a -= j1;
                            EntityItem entityitem = new EntityItem(player.field_70170_p, player.field_70165_t + (double)f, player.field_70163_u + (double)f1, player.field_70161_v + (double)f2, new ItemStack(itemstack.func_77973_b(), j1, itemstack.func_77960_j()));
                            if (itemstack.func_77942_o()) {
                                entityitem.func_92059_d().func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
                            }
                            float f3 = 0.05f;
                            entityitem.field_70159_w = (double)((float)random.nextGaussian() * f3) + player.field_70159_w;
                            entityitem.field_70181_x = (double)((float)random.nextGaussian() * f3 + 0.2f) + player.field_70181_x;
                            entityitem.field_70179_y = (double)((float)random.nextGaussian() * f3) + player.field_70179_y;
                            player.field_70170_p.func_72838_d((Entity)entityitem);
                        }
                    }
                    box.func_77982_d(new NBTTagCompound());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            if (!player.func_70093_af()) {
                this.moveRows(stack, player);
                player.field_71069_bz.func_75142_b();
            } else {
                if (stack.func_77978_p() == null) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                stack.func_77978_p().func_74757_a("isOpen", true);
                player.openGui((Object)MainRegistry.instance, 0, world, 0, 0, 0);
            }
        }
        return stack;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerToolBox(player.field_71071_by, new InventoryToolBox(player, player.func_70694_bm()));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIToolBox(player.field_71071_by, new InventoryToolBox(player, player.func_70694_bm()));
    }

    public static class InventoryToolBox
    extends ItemInventory {
        public InventoryToolBox(EntityPlayer player, ItemStack box) {
            ItemStack[] fromNBT;
            this.player = player;
            this.target = box;
            this.slots = new ItemStack[this.func_70302_i_()];
            if (!box.func_77942_o()) {
                box.func_77982_d(new NBTTagCompound());
            }
            if ((fromNBT = ItemStackUtil.readStacksFromNBT(box, this.slots.length)) != null) {
                System.arraycopy(fromNBT, 0, this.slots, 0, this.slots.length);
            }
        }

        public int func_70302_i_() {
            return 24;
        }

        public String func_145825_b() {
            return "container.toolBox";
        }

        public boolean func_145818_k_() {
            return this.target.func_82837_s();
        }

        @Override
        public void func_70305_f() {
            super.func_70305_f();
            this.target.func_77978_p().func_82580_o("isOpen");
            this.target.func_77978_p().func_74768_a("rand", this.player.field_70170_p.field_73012_v.nextInt());
            this.player.field_71069_bz.func_75142_b();
        }

        @Override
        public boolean func_94041_b(int slot, ItemStack stack) {
            return stack.func_77973_b() != ModItems.toolbox;
        }
    }
}

