/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.inventory.FluidStack;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.recipes.loader.SerializableRecipe;
import com.hbm.items.machine.ItemFluidIcon;
import com.hbm.util.Tuple;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;

public class CrackingRecipes
extends SerializableRecipe {
    public static final int oil_crack_oil = 80;
    public static final int oil_crack_petro = 20;
    public static final int bitumen_crack_oil = 80;
    public static final int bitumen_crack_aroma = 20;
    public static final int smear_crack_napht = 60;
    public static final int smear_crack_petro = 40;
    public static final int gas_crack_petro = 30;
    public static final int gas_crack_unsat = 20;
    public static final int diesel_crack_kero = 40;
    public static final int diesel_crack_petro = 30;
    public static final int kero_crack_petro = 60;
    public static final int wood_crack_aroma = 10;
    public static final int wood_crack_heat = 40;
    public static final int xyl_crack_aroma = 80;
    public static final int xyl_crack_petro = 20;
    public static Map<FluidType, Tuple.Pair<FluidStack, FluidStack>> cracking = new HashMap<FluidType, Tuple.Pair<FluidStack, FluidStack>>();

    @Override
    public void registerDefaults() {
        cracking.put(Fluids.OIL, new Tuple.Pair<FluidStack, FluidStack>(new FluidStack(Fluids.CRACKOIL, 80), new FluidStack(Fluids.PETROLEUM, 20)));
        cracking.put(Fluids.BITUMEN, new Tuple.Pair<FluidStack, FluidStack>(new FluidStack(Fluids.OIL, 80), new FluidStack(Fluids.AROMATICS, 20)));
        cracking.put(Fluids.SMEAR, new Tuple.Pair<FluidStack, FluidStack>(new FluidStack(Fluids.NAPHTHA, 60), new FluidStack(Fluids.PETROLEUM, 40)));
        cracking.put(Fluids.GAS, new Tuple.Pair<FluidStack, FluidStack>(new FluidStack(Fluids.PETROLEUM, 30), new FluidStack(Fluids.UNSATURATEDS, 20)));
        cracking.put(Fluids.DIESEL, new Tuple.Pair<FluidStack, FluidStack>(new FluidStack(Fluids.KEROSENE, 40), new FluidStack(Fluids.PETROLEUM, 30)));
        cracking.put(Fluids.DIESEL_CRACK, new Tuple.Pair<FluidStack, FluidStack>(new FluidStack(Fluids.KEROSENE, 40), new FluidStack(Fluids.PETROLEUM, 30)));
        cracking.put(Fluids.KEROSENE, new Tuple.Pair<FluidStack, FluidStack>(new FluidStack(Fluids.PETROLEUM, 60), new FluidStack(Fluids.NONE, 0)));
        cracking.put(Fluids.WOODOIL, new Tuple.Pair<FluidStack, FluidStack>(new FluidStack(Fluids.HEATINGOIL, 40), new FluidStack(Fluids.AROMATICS, 10)));
        cracking.put(Fluids.XYLENE, new Tuple.Pair<FluidStack, FluidStack>(new FluidStack(Fluids.AROMATICS, 80), new FluidStack(Fluids.PETROLEUM, 20)));
        cracking.put(Fluids.HEATINGOIL_VACUUM, new Tuple.Pair<FluidStack, FluidStack>(new FluidStack(Fluids.HEATINGOIL, 80), new FluidStack(Fluids.REFORMGAS, 20)));
        cracking.put(Fluids.REFORMATE, new Tuple.Pair<FluidStack, FluidStack>(new FluidStack(Fluids.UNSATURATEDS, 40), new FluidStack(Fluids.REFORMGAS, 60)));
        cracking.put(Fluids.BIOGAS, new Tuple.Pair<FluidStack, FluidStack>(new FluidStack(Fluids.PETROLEUM, 20), new FluidStack(Fluids.AROMATICS, 20)));
    }

    public static Tuple.Pair<FluidStack, FluidStack> getCracking(FluidType oil) {
        return cracking.get(oil);
    }

    protected static Map<FluidType, Tuple.Pair<FluidStack, FluidStack>> getCrackingRecipes() {
        return cracking;
    }

    public static HashMap<Object, Object> getCrackingRecipesForNEI() {
        HashMap<Object, Object> recipes = new HashMap<Object, Object>();
        for (Map.Entry<FluidType, Tuple.Pair<FluidStack, FluidStack>> recipe : cracking.entrySet()) {
            ItemStack[] itemStackArray;
            ItemStack[] in = new ItemStack[]{ItemFluidIcon.make(recipe.getKey(), 100), ItemFluidIcon.make(Fluids.STEAM, 200)};
            ItemStack[] out = new ItemStack[]{ItemFluidIcon.make(recipe.getValue().getKey()), ItemFluidIcon.make(recipe.getValue().getValue()), ItemFluidIcon.make(Fluids.SPENTSTEAM, 2)};
            if (recipe.getValue().getValue().type == Fluids.NONE) {
                ItemStack[] itemStackArray2 = new ItemStack[2];
                itemStackArray2[0] = ItemFluidIcon.make(recipe.getValue().getKey());
                itemStackArray = itemStackArray2;
                itemStackArray2[1] = ItemFluidIcon.make(Fluids.SPENTSTEAM, 2);
            } else {
                itemStackArray = out;
            }
            recipes.put(in, itemStackArray);
        }
        return recipes;
    }

    @Override
    public String getFileName() {
        return "hbmCracking.json";
    }

    @Override
    public String getComment() {
        return "Inputs are always 100mB, set output quantities accordingly. The steam in/outputs are fixed, using 200mB of steam per 100mB of input.";
    }

    @Override
    public Object getRecipeObject() {
        return cracking;
    }

    @Override
    public void deleteRecipes() {
        cracking.clear();
    }

    @Override
    public void readRecipe(JsonElement recipe) {
        JsonObject obj = (JsonObject)recipe;
        FluidType input = Fluids.fromName(obj.get("input").getAsString());
        FluidStack output1 = CrackingRecipes.readFluidStack(obj.get("output1").getAsJsonArray());
        FluidStack output2 = CrackingRecipes.readFluidStack(obj.get("output2").getAsJsonArray());
        cracking.put(input, new Tuple.Pair<FluidStack, FluidStack>(output1, output2));
    }

    @Override
    public void writeRecipe(Object recipe, JsonWriter writer) throws IOException {
        Map.Entry rec = (Map.Entry)recipe;
        writer.name("input").value(((FluidType)rec.getKey()).getName());
        writer.name("output1");
        CrackingRecipes.writeFluidStack((FluidStack)((Tuple.Pair)rec.getValue()).getKey(), writer);
        writer.name("output2");
        CrackingRecipes.writeFluidStack((FluidStack)((Tuple.Pair)rec.getValue()).getValue(), writer);
    }
}

