/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.material;

import com.hbm.inventory.OreDictManager;
import com.hbm.inventory.material.MaterialShapes;
import com.hbm.inventory.material.Mats;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class NTMMaterial {
    public final int id;
    public String[] names;
    public Set<MaterialShapes> autogen = new HashSet<MaterialShapes>();
    public Set<MatTraits> traits = new HashSet<MatTraits>();
    public SmeltingBehavior smeltable = SmeltingBehavior.NOT_SMELTABLE;
    public int solidColorLight = 16730624;
    public int solidColorDark = 0x802000;
    public int moltenColor = 16730624;
    public NTMMaterial smeltsInto;
    public int convIn;
    public int convOut;

    public NTMMaterial(int id, OreDictManager.DictFrame dict) {
        this.names = dict.mats;
        this.id = id;
        this.smeltsInto = this;
        this.convIn = 1;
        this.convOut = 1;
        for (String name : dict.mats) {
            Mats.matByName.put(name, this);
        }
        Mats.orderedList.add(this);
        Mats.matById.put(id, this);
    }

    public String getUnlocalizedName() {
        return "hbmmat." + this.names[0].toLowerCase(Locale.US);
    }

    public NTMMaterial setConversion(NTMMaterial mat, int in, int out) {
        this.smeltsInto = mat;
        this.convIn = in;
        this.convOut = out;
        return this;
    }

    public NTMMaterial setAutogen(MaterialShapes ... shapes) {
        for (MaterialShapes shape : shapes) {
            this.autogen.add(shape);
        }
        return this;
    }

    public NTMMaterial setTraits(MatTraits ... traits) {
        for (MatTraits trait : traits) {
            this.traits.add(trait);
        }
        return this;
    }

    public NTMMaterial m() {
        this.traits.add(MatTraits.METAL);
        return this;
    }

    public NTMMaterial n() {
        this.traits.add(MatTraits.NONMETAL);
        return this;
    }

    public NTMMaterial smeltable(SmeltingBehavior behavior) {
        this.smeltable = behavior;
        return this;
    }

    public NTMMaterial setSolidColor(int colorLight, int colorDark) {
        this.solidColorLight = colorLight;
        this.solidColorDark = colorDark;
        return this;
    }

    public NTMMaterial setMoltenColor(int color) {
        this.moltenColor = color;
        return this;
    }

    public ItemStack make(Item item, int amount) {
        return new ItemStack(item, amount, this.id);
    }

    public ItemStack make(Item item) {
        return this.make(item, 1);
    }

    public static enum MatTraits {
        METAL,
        NONMETAL;

    }

    public static enum SmeltingBehavior {
        NOT_SMELTABLE,
        VAPORIZES,
        BREAKS,
        SMELTABLE,
        ADDITIVE;

    }
}

