/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.neutron;

import api.hbm.block.IPileNeutronReceiver;
import com.hbm.blocks.ModBlocks;
import com.hbm.handler.neutron.NeutronNode;
import com.hbm.handler.neutron.NeutronNodeWorld;
import com.hbm.handler.neutron.NeutronStream;
import com.hbm.tileentity.machine.pile.TileEntityPileBase;
import com.hbm.util.ContaminationUtil;
import com.hbm.util.fauxpointtwelve.BlockPos;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class PileNeutronHandler {
    public static int range = 5;

    public static PileNeutronNode makeNode(NeutronNodeWorld.StreamWorld streamWorld, TileEntityPileBase tile) {
        BlockPos pos = new BlockPos(tile);
        PileNeutronNode node = (PileNeutronNode)streamWorld.getNode(pos);
        return node != null ? node : new PileNeutronNode(tile);
    }

    private static TileEntity blockPosToTE(World worldObj, BlockPos pos) {
        return worldObj.func_147438_o(pos.getX(), pos.getY(), pos.getZ());
    }

    public static class PileNeutronStream
    extends NeutronStream {
        public PileNeutronStream(NeutronNode origin, Vec3 vector, double flux) {
            super(origin, vector, flux, 0.0, NeutronStream.NeutronType.PILE);
        }

        @Override
        public void runStreamInteraction(World worldObj, NeutronNodeWorld.StreamWorld streamWorld) {
            TileEntityPileBase originTE = (TileEntityPileBase)this.origin.tile;
            BlockPos pos = new BlockPos(originTE);
            for (float i = 1.0f; i <= (float)range; i += 0.5f) {
                int z;
                int y;
                int x;
                List entities;
                TileEntity tile;
                BlockPos nodePos = new BlockPos((int)Math.floor((double)pos.getX() + 0.5 + this.vector.field_72450_a * (double)i), (int)Math.floor((double)pos.getY() + 0.5 + this.vector.field_72448_b * (double)i), (int)Math.floor((double)pos.getZ() + 0.5 + this.vector.field_72449_c * (double)i));
                if (nodePos.equals(pos)) continue;
                pos.mutate(nodePos.getX(), nodePos.getY(), nodePos.getZ());
                NeutronNode node = streamWorld.getNode(nodePos);
                if (node != null && node instanceof PileNeutronNode) {
                    tile = node.tile;
                } else {
                    tile = PileNeutronHandler.blockPosToTE(worldObj, nodePos);
                    if (tile == null) {
                        return;
                    }
                    if (tile instanceof TileEntityPileBase) {
                        streamWorld.addNode(new PileNeutronNode((TileEntityPileBase)tile));
                    }
                }
                Block block = tile.func_145838_q();
                int meta = tile.func_145832_p();
                if (!(tile instanceof TileEntityPileBase)) {
                    if (block == ModBlocks.block_boron) {
                        return;
                    }
                    if (block == ModBlocks.concrete || block == ModBlocks.concrete_smooth || block == ModBlocks.concrete_asbestos || block == ModBlocks.concrete_colored || block == ModBlocks.brick_concrete) {
                        this.fluxQuantity *= 0.25;
                    }
                    if (block == ModBlocks.block_graphite_rod && (meta & 8) == 0) {
                        return;
                    }
                }
                if (tile instanceof IPileNeutronReceiver) {
                    IPileNeutronReceiver rec = (IPileNeutronReceiver)tile;
                    rec.receiveNeutrons((int)Math.floor(this.fluxQuantity));
                    if (block != ModBlocks.block_graphite_detector || (meta & 8) == 0) {
                        return;
                    }
                }
                if ((entities = worldObj.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)(x = (int)((double)nodePos.getX() + 0.5)), (double)(y = (int)((double)nodePos.getY() + 0.5)), (double)(z = (int)((double)nodePos.getZ() + 0.5)), (double)x, (double)y, (double)z))) == null) continue;
                for (EntityLivingBase e : entities) {
                    ContaminationUtil.contaminate(e, ContaminationUtil.HazardType.RADIATION, ContaminationUtil.ContaminationType.CREATIVE, (float)(this.fluxQuantity / 4.0));
                }
            }
        }
    }

    public static class PileNeutronNode
    extends NeutronNode {
        public PileNeutronNode(TileEntityPileBase tile) {
            super(tile, NeutronStream.NeutronType.PILE);
        }
    }
}

