/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.projectile;

import api.hbm.entity.IRadarDetectable;
import com.google.common.collect.ImmutableSet;
import com.hbm.entity.logic.IChunkLoader;
import com.hbm.entity.projectile.EntityThrowableInterp;
import com.hbm.entity.projectile.rocketbehavior.IRocketSteeringBehavior;
import com.hbm.entity.projectile.rocketbehavior.IRocketTargetingBehavior;
import com.hbm.entity.projectile.rocketbehavior.RocketSteeringBallisticArc;
import com.hbm.entity.projectile.rocketbehavior.RocketTargetingPredictive;
import com.hbm.items.weapon.ItemAmmoHIMARS;
import com.hbm.main.MainRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class EntityArtilleryRocket
extends EntityThrowableInterp
implements IChunkLoader,
IRadarDetectable {
    private ForgeChunkManager.Ticket loaderTicket;
    public Entity targetEntity = null;
    public Vec3 lastTargetPos;
    public IRocketTargetingBehavior targeting;
    public IRocketSteeringBehavior steering;
    List<ChunkCoordIntPair> loadedChunks = new ArrayList<ChunkCoordIntPair>();

    public EntityArtilleryRocket(World world) {
        super(world);
        this.field_70158_ak = true;
        this.targeting = new RocketTargetingPredictive();
        this.steering = new RocketSteeringBallisticArc();
    }

    @Override
    protected void func_70088_a() {
        this.init(ForgeChunkManager.requestTicket((Object)MainRegistry.instance, (World)this.field_70170_p, (ForgeChunkManager.Type)ForgeChunkManager.Type.ENTITY));
        this.field_70180_af.func_75682_a(10, (Object)new Integer(0));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        return true;
    }

    public EntityArtilleryRocket setType(int type) {
        this.field_70180_af.func_75692_b(10, (Object)type);
        return this;
    }

    public ItemAmmoHIMARS.HIMARSRocket getType() {
        try {
            return ItemAmmoHIMARS.itemTypes[this.field_70180_af.func_75679_c(10)];
        }
        catch (Exception ex) {
            return ItemAmmoHIMARS.itemTypes[0];
        }
    }

    public EntityArtilleryRocket setTarget(Entity target) {
        this.targetEntity = target;
        this.setTarget(target.field_70165_t, target.field_70163_u - (double)target.field_70129_M + (double)target.field_70131_O / 2.0, target.field_70161_v);
        return this;
    }

    public EntityArtilleryRocket setTarget(double x, double y, double z) {
        this.lastTargetPos = Vec3.func_72443_a((double)x, (double)y, (double)z);
        return this;
    }

    public Vec3 getLastTarget() {
        return this.lastTargetPos;
    }

    @Override
    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K) {
            this.field_70142_S = this.field_70165_t;
            this.field_70137_T = this.field_70163_u;
            this.field_70136_U = this.field_70161_v;
        }
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            Vec3 delta;
            if (this.targeting == null) {
                this.targeting = new RocketTargetingPredictive();
            }
            if (this.steering == null) {
                this.steering = new RocketSteeringBallisticArc();
            }
            if (this.targetEntity == null && (delta = Vec3.func_72443_a((double)(this.lastTargetPos.field_72450_a - this.field_70165_t), (double)(this.lastTargetPos.field_72448_b - this.field_70163_u), (double)(this.lastTargetPos.field_72449_c - this.field_70161_v))).func_72433_c() <= 15.0) {
                this.targeting = null;
                this.steering = null;
            }
            if (this.targeting != null && this.targetEntity != null) {
                this.targeting.recalculateTargetPosition(this, this.targetEntity);
            }
            if (this.steering != null) {
                this.steering.adjustCourse(this, 25.0, 15.0);
            }
            this.loadNeighboringChunks((int)Math.floor(this.field_70165_t / 16.0), (int)Math.floor(this.field_70161_v / 16.0));
            this.getType().onUpdate(this);
        } else {
            Vec3 v = Vec3.func_72443_a((double)(this.field_70142_S - this.field_70165_t), (double)(this.field_70137_T - this.field_70163_u), (double)(this.field_70136_U - this.field_70161_v));
            double velocity = v.func_72433_c();
            v = v.func_72432_b();
            int offset = 6;
            if (velocity > 1.0) {
                int i = offset;
                while ((double)i < velocity + (double)offset) {
                    NBTTagCompound data = new NBTTagCompound();
                    data.func_74780_a("posX", this.field_70165_t + v.field_72450_a * (double)i);
                    data.func_74780_a("posY", this.field_70163_u + v.field_72448_b * (double)i);
                    data.func_74780_a("posZ", this.field_70161_v + v.field_72449_c * (double)i);
                    data.func_74778_a("type", "exKerosene");
                    MainRegistry.proxy.effectNT(data);
                    ++i;
                }
            }
        }
    }

    @Override
    protected void onImpact(MovingObjectPosition mop) {
        if (!this.field_70170_p.field_72995_K) {
            this.getType().onImpact(this, mop);
        }
    }

    @Override
    public void init(ForgeChunkManager.Ticket ticket) {
        if (!this.field_70170_p.field_72995_K && ticket != null) {
            if (this.loaderTicket == null) {
                this.loaderTicket = ticket;
                this.loaderTicket.bindEntity((Entity)this);
                this.loaderTicket.getModData();
            }
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.loaderTicket, (ChunkCoordIntPair)new ChunkCoordIntPair(this.field_70176_ah, this.field_70164_aj));
        }
    }

    public void loadNeighboringChunks(int newChunkX, int newChunkZ) {
        if (!this.field_70170_p.field_72995_K && this.loaderTicket != null) {
            for (ChunkCoordIntPair chunk : ImmutableSet.copyOf((Collection)this.loaderTicket.getChunkList())) {
                ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.loaderTicket, (ChunkCoordIntPair)chunk);
            }
            this.loadedChunks.clear();
            this.loadedChunks.add(new ChunkCoordIntPair(newChunkX, newChunkZ));
            for (ChunkCoordIntPair chunk : this.loadedChunks) {
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.loaderTicket, (ChunkCoordIntPair)chunk);
            }
        }
    }

    public void killAndClear() {
        this.func_70106_y();
        this.clearChunkLoader();
    }

    public void clearChunkLoader() {
        if (!this.field_70170_p.field_72995_K && this.loaderTicket != null) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.loaderTicket);
            this.loaderTicket = null;
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        if (this.lastTargetPos == null) {
            this.lastTargetPos = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
        }
        nbt.func_74780_a("targetX", this.lastTargetPos.field_72450_a);
        nbt.func_74780_a("targetY", this.lastTargetPos.field_72448_b);
        nbt.func_74780_a("targetZ", this.lastTargetPos.field_72449_c);
        nbt.func_74768_a("type", this.field_70180_af.func_75679_c(10));
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.lastTargetPos = Vec3.func_72443_a((double)nbt.func_74769_h("targetX"), (double)nbt.func_74769_h("targetY"), (double)nbt.func_74769_h("targetZ"));
        this.field_70180_af.func_75692_b(10, (Object)nbt.func_74762_e("type"));
    }

    @Override
    protected float getAirDrag() {
        return 1.0f;
    }

    @Override
    public double getGravityVelocity() {
        return this.steering != null ? 0.0 : 0.01;
    }

    @Override
    public IRadarDetectable.RadarTargetType getTargetType() {
        return IRadarDetectable.RadarTargetType.ARTILLERY;
    }

    @Override
    public int approachNum() {
        return 0;
    }
}

