/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.network;

import api.hbm.block.IToolable;
import api.hbm.energymk2.IEnergyConnectorBlock;
import api.hbm.energymk2.IEnergyConnectorMK2;
import api.hbm.energymk2.IEnergyReceiverMK2;
import api.hbm.energymk2.Nodespace;
import api.hbm.energymk2.PowerNetMK2;
import com.hbm.blocks.ILookOverlay;
import com.hbm.blocks.ITooltipProvider;
import com.hbm.tileentity.TileEntityLoadedBase;
import com.hbm.util.BobMathUtil;
import com.hbm.util.Compat;
import com.hbm.util.i18n.I18nUtil;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.util.ForgeDirection;

public class CableDiode
extends BlockContainer
implements IEnergyConnectorBlock,
ILookOverlay,
IToolable,
ITooltipProvider {
    public static int renderID = RenderingRegistry.getNextAvailableRenderId();

    public CableDiode(Material mat) {
        super(mat);
    }

    public int func_149645_b() {
        return renderID;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess p_149646_1_, int p_149646_2_, int p_149646_3_, int p_149646_4_, int p_149646_5_) {
        return true;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack stack) {
        int l = BlockPistonBase.func_150071_a((World)world, (int)x, (int)y, (int)z, (EntityLivingBase)player);
        world.func_72921_c(x, y, z, l, 2);
    }

    @Override
    public boolean canConnect(IBlockAccess world, int x, int y, int z, ForgeDirection dir) {
        return true;
    }

    @Override
    public boolean onScrew(World world, EntityPlayer player, int x, int y, int z, int side, float fX, float fY, float fZ, IToolable.ToolType tool) {
        TileEntityDiode te = (TileEntityDiode)world.func_147438_o(x, y, z);
        if (world.field_72995_K) {
            return true;
        }
        if (tool == IToolable.ToolType.SCREWDRIVER) {
            if (te.level < 11) {
                ++te.level;
            }
            te.func_70296_d();
            world.func_147471_g(x, y, z);
            return true;
        }
        if (tool == IToolable.ToolType.HAND_DRILL) {
            if (te.level > 1) {
                --te.level;
            }
            te.func_70296_d();
            world.func_147471_g(x, y, z);
            return true;
        }
        if (tool == IToolable.ToolType.DEFUSER) {
            int p = te.priority.ordinal() + 1;
            if (p > 4) {
                p = 0;
            }
            te.priority = IEnergyReceiverMK2.ConnectionPriority.values()[p];
            te.func_70296_d();
            world.func_147471_g(x, y, z);
            return true;
        }
        return false;
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean ext) {
        list.add(EnumChatFormatting.GOLD + "Limits throughput and restricts flow direction");
        list.add(EnumChatFormatting.YELLOW + "Use screwdriver to increase throughput");
        list.add(EnumChatFormatting.YELLOW + "Use hand drill to decrease throughput");
        list.add(EnumChatFormatting.YELLOW + "Use defuser to change network priority");
    }

    @Override
    public void printHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof TileEntityDiode)) {
            return;
        }
        TileEntityDiode diode = (TileEntityDiode)te;
        ArrayList<String> text = new ArrayList<String>();
        text.add("Max.: " + BobMathUtil.getShortNumber(diode.getMaxPower()) + "HE/t");
        text.add("Priority: " + diode.priority.name());
        ILookOverlay.printGeneric(event, I18nUtil.resolveKey(this.func_149739_a() + ".name", new Object[0]), 0xFFFF00, 0x404000, text);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityDiode();
    }

    public static class TileEntityDiode
    extends TileEntityLoadedBase
    implements IEnergyReceiverMK2 {
        int level = 1;
        private long power;
        private boolean recursionBrake = false;
        private int pulses = 0;
        public IEnergyReceiverMK2.ConnectionPriority priority = IEnergyReceiverMK2.ConnectionPriority.NORMAL;

        @Override
        public void func_145839_a(NBTTagCompound nbt) {
            super.func_145839_a(nbt);
            this.level = nbt.func_74762_e("level");
            this.priority = IEnergyReceiverMK2.ConnectionPriority.values()[nbt.func_74771_c("p")];
        }

        @Override
        public void func_145841_b(NBTTagCompound nbt) {
            super.func_145841_b(nbt);
            nbt.func_74768_a("level", this.level);
            nbt.func_74774_a("p", (byte)this.priority.ordinal());
        }

        public Packet func_145844_m() {
            NBTTagCompound nbt = new NBTTagCompound();
            this.func_145841_b(nbt);
            return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbt);
        }

        public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
            this.func_145839_a(pkt.func_148857_g());
        }

        private ForgeDirection getDir() {
            return ForgeDirection.getOrientation((int)this.func_145832_p()).getOpposite();
        }

        public void func_145845_h() {
            if (!this.field_145850_b.field_72995_K) {
                for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                    if (dir == this.getDir()) continue;
                    this.trySubscribe(this.field_145850_b, this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ, dir);
                }
                this.pulses = 0;
                this.setPower(0L);
            }
        }

        @Override
        public boolean canConnect(ForgeDirection dir) {
            return dir != this.getDir();
        }

        @Override
        public long transferPower(long power) {
            IEnergyReceiverMK2 rec;
            if (this.recursionBrake) {
                return power;
            }
            ++this.pulses;
            if (this.getPower() >= this.getMaxPower() || this.pulses > 10) {
                return power;
            }
            this.recursionBrake = true;
            ForgeDirection dir = this.getDir();
            Nodespace.PowerNode node = Nodespace.getNode(this.field_145850_b, this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
            TileEntity te = Compat.getTileStandard(this.field_145850_b, this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
            if (node != null && !node.expired && node.hasValidNet() && te instanceof IEnergyConnectorMK2 && ((IEnergyConnectorMK2)te).canConnect(dir.getOpposite())) {
                long toTransfer = Math.min(power, this.getReceiverSpeed());
                long remainder = ((PowerNetMK2)node.net).sendPowerDiode(toTransfer);
                long transferred = toTransfer - remainder;
                this.power += transferred;
                power -= transferred;
            } else if (te instanceof IEnergyReceiverMK2 && te != this && (rec = (IEnergyReceiverMK2)te).canConnect(dir.getOpposite())) {
                long toTransfer = Math.min(power, rec.getReceiverSpeed());
                long remainder = rec.transferPower(toTransfer);
                this.recursionBrake = false;
                return power -= toTransfer - remainder;
            }
            this.recursionBrake = false;
            return power;
        }

        @Override
        public long getReceiverSpeed() {
            return this.getMaxPower() - this.getPower();
        }

        @Override
        public long getMaxPower() {
            return (long)Math.pow(10.0, this.level);
        }

        @Override
        public long getPower() {
            return Math.min(this.power, this.getMaxPower());
        }

        @Override
        public void setPower(long power) {
            this.power = power;
        }

        @Override
        public IEnergyReceiverMK2.ConnectionPriority getPriority() {
            return this.priority;
        }
    }
}

