/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.generic;

import api.hbm.block.IToolable;
import com.hbm.blocks.IBlockSideRotation;
import com.hbm.blocks.ILookOverlay;
import com.hbm.blocks.ITooltipProvider;
import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.generic.BlockWandLoot;
import com.hbm.blocks.generic.LogicBlock;
import com.hbm.config.StructureConfig;
import com.hbm.interfaces.IBomb;
import com.hbm.interfaces.ICopiable;
import com.hbm.main.MainRegistry;
import com.hbm.tileentity.TileEntityLoadedBase;
import com.hbm.util.BufferUtil;
import com.hbm.util.i18n.I18nUtil;
import com.hbm.world.gen.nbt.INBTTileEntityTransformable;
import com.hbm.world.gen.util.LogicBlockActions;
import com.hbm.world.gen.util.LogicBlockConditions;
import com.hbm.world.gen.util.LogicBlockInteractions;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockWandLogic
extends BlockContainer
implements ILookOverlay,
IToolable,
ITooltipProvider,
IBlockSideRotation,
IBomb {
    @SideOnly(value=Side.CLIENT)
    protected IIcon iconTop;

    public BlockWandLogic() {
        super(Material.field_151573_f);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.field_149761_L = iconRegister.func_94245_a("hbm:wand_logic");
        this.iconTop = iconRegister.func_94245_a("hbm:wand_logic_top");
    }

    public IIcon func_149691_a(int side, int meta) {
        return side <= 1 ? this.iconTop : this.field_149761_L;
    }

    @Override
    public int getRotationFromSide(IBlockAccess world, int x, int y, int z, int side) {
        if (side == 0) {
            return IBlockSideRotation.topToBottom(world.func_72805_g(x, y, z));
        }
        if (side == 1) {
            return world.func_72805_g(x, y, z);
        }
        return 0;
    }

    public int func_149645_b() {
        return IBlockSideRotation.getRenderType();
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack itemStack) {
        int i = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (i == 0) {
            world.func_72921_c(x, y, z, 3, 2);
        }
        if (i == 1) {
            world.func_72921_c(x, y, z, 2, 2);
        }
        if (i == 2) {
            world.func_72921_c(x, y, z, 0, 2);
        }
        if (i == 3) {
            world.func_72921_c(x, y, z, 1, 2);
        }
        ForgeDirection dir = ForgeDirection.UNKNOWN;
        switch (i) {
            case 0: {
                dir = ForgeDirection.SOUTH;
                break;
            }
            case 1: {
                dir = ForgeDirection.WEST;
                break;
            }
            case 2: {
                dir = ForgeDirection.NORTH;
                break;
            }
            case 3: {
                dir = ForgeDirection.EAST;
            }
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityWandLogic) {
            ((TileEntityWandLogic)te).placedRotation = dir.ordinal();
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float fX, float fY, float fZ) {
        ItemStack stack = player.func_70694_bm();
        if (stack != null && stack.func_77973_b() instanceof ItemBlock && !player.func_70093_af()) {
            TileEntity tile;
            ItemBlock ib = (ItemBlock)stack.func_77973_b();
            Block block = ib.field_150939_a;
            if (block.func_149686_d() && block != this && (tile = world.func_147438_o(x, y, z)) instanceof TileEntityWandLogic) {
                TileEntityWandLogic logic = (TileEntityWandLogic)tile;
                logic.disguise = block;
                logic.disguiseMeta = stack.func_77960_j() & 0xF;
                return true;
            }
        }
        return super.func_149727_a(world, x, y, z, player, side, fX, fY, fZ);
    }

    @Override
    public boolean onScrew(World world, EntityPlayer player, int x, int y, int z, int side, float fX, float fY, float fZ, IToolable.ToolType tool) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof TileEntityWandLogic)) {
            return false;
        }
        TileEntityWandLogic logic = (TileEntityWandLogic)te;
        switch (tool) {
            case SCREWDRIVER: {
                List<String> actionNames = LogicBlockActions.getActionNames();
                int indexA = actionNames.indexOf(logic.actionID);
                indexA += player.func_70093_af() ? -1 : 1;
                indexA = MathHelper.func_76125_a((int)indexA, (int)0, (int)(actionNames.size() - 1));
                logic.actionID = actionNames.get(indexA);
                return true;
            }
            case DEFUSER: {
                List<String> conditionNames = LogicBlockConditions.getConditionNames();
                int indexC = conditionNames.indexOf(logic.conditionID);
                indexC += player.func_70093_af() ? -1 : 1;
                indexC = MathHelper.func_76125_a((int)indexC, (int)0, (int)(conditionNames.size() - 1));
                logic.conditionID = conditionNames.get(indexC);
                return true;
            }
            case HAND_DRILL: {
                List<String> interactionNames = LogicBlockInteractions.getInteractionNames();
                int indexI = interactionNames.indexOf(logic.interactionID);
                indexI += player.func_70093_af() ? -1 : 1;
                indexI = MathHelper.func_76125_a((int)indexI, (int)0, (int)(interactionNames.size() - 1));
                logic.interactionID = interactionNames.get(indexI);
                return true;
            }
        }
        return false;
    }

    @Override
    public void printHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof TileEntityWandLogic)) {
            return;
        }
        TileEntityWandLogic logic = (TileEntityWandLogic)te;
        ArrayList<String> text = new ArrayList<String>();
        text.add("Action: " + logic.actionID);
        text.add("Condition: " + logic.conditionID);
        text.add("Interaction: " + (logic.interactionID != null ? logic.interactionID : "None"));
        String block = logic.disguise != null && logic.disguise != Blocks.field_150350_a ? I18nUtil.resolveKey(logic.disguise.func_149739_a() + ".name", new Object[0]) : "None";
        text.add("Disguise Block: " + block);
        ILookOverlay.printGeneric(event, I18nUtil.resolveKey(this.func_149739_a() + ".name", new Object[0]), 0xFFFF00, 0x404000, text);
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean ext) {
        list.add(EnumChatFormatting.GOLD + "Use screwdriver to cycle forwards through the action list, shift click to go back");
        list.add(EnumChatFormatting.GOLD + "Use defuser to cycle forwards through the condition list, shift click to go back");
        list.add(EnumChatFormatting.GOLD + "Use hand drill to cycle forwards through the interaction list, shift click to go back");
        list.add(EnumChatFormatting.YELLOW + "Use a detonator to transform");
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityWandLogic();
    }

    @Override
    public IBomb.BombReturnCode explode(World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof TileEntityWandLogic)) {
            return null;
        }
        ((TileEntityWandLogic)te).triggerReplace = true;
        return IBomb.BombReturnCode.TRIGGERED;
    }

    public static class TileEntityWandLogic
    extends TileEntityLoadedBase
    implements INBTTileEntityTransformable,
    ICopiable {
        private boolean triggerReplace;
        public int placedRotation;
        Block disguise;
        int disguiseMeta = -1;
        public String actionID = "FODDER_WAVE";
        public String conditionID = "PLAYER_CUBE_5";
        public String interactionID;

        public void func_145845_h() {
            if (!this.field_145850_b.field_72995_K) {
                if (this.triggerReplace) {
                    this.replace();
                } else {
                    this.networkPackNT(15);
                }
            }
        }

        private void replace() {
            if (!(this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e) instanceof BlockWandLogic)) {
                MainRegistry.logger.warn("Somehow the block at: " + this.field_145851_c + ", " + this.field_145848_d + ", " + this.field_145849_e + " isn't a logic block but we're doing a TE update as if it is, cancelling!");
                return;
            }
            this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, ModBlocks.logic_block);
            TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (te == null || te instanceof BlockWandLoot.TileEntityWandLoot) {
                MainRegistry.logger.warn("TE for logic block set incorrectly at: " + this.field_145851_c + ", " + this.field_145848_d + ", " + this.field_145849_e + ". If you're using some sort of world generation mod, report it to the author!");
                te = ModBlocks.wand_logic.createTileEntity(this.field_145850_b, 0);
                this.field_145850_b.func_147455_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, te);
            }
            if (te instanceof LogicBlock.TileEntityLogicBlock) {
                LogicBlock.TileEntityLogicBlock logic = (LogicBlock.TileEntityLogicBlock)te;
                logic.actionID = this.actionID;
                logic.conditionID = this.conditionID;
                logic.interactionID = this.interactionID;
                logic.direction = ForgeDirection.getOrientation((int)this.placedRotation);
                logic.disguise = this.disguise;
                logic.disguiseMeta = this.disguiseMeta;
            }
        }

        @Override
        public void transformTE(World world, int coordBaseMode) {
            this.triggerReplace = !StructureConfig.debugStructures;
        }

        @Override
        public void func_145841_b(NBTTagCompound nbt) {
            super.func_145841_b(nbt);
            nbt.func_74778_a("actionID", this.actionID);
            nbt.func_74778_a("conditionID", this.conditionID);
            if (this.interactionID != null) {
                nbt.func_74778_a("interactionID", this.interactionID);
            }
            nbt.func_74768_a("rotation", this.placedRotation);
            if (this.disguise != null) {
                nbt.func_74778_a("disguise", GameRegistry.findUniqueIdentifierFor((Block)this.disguise).toString());
                nbt.func_74768_a("disguiseMeta", this.disguiseMeta);
            }
        }

        @Override
        public void func_145839_a(NBTTagCompound nbt) {
            super.func_145839_a(nbt);
            this.actionID = nbt.func_74779_i("actionID");
            this.conditionID = nbt.func_74779_i("conditionID");
            if (nbt.func_74764_b("interactionID")) {
                this.interactionID = nbt.func_74779_i("interactionID");
            }
            this.placedRotation = nbt.func_74762_e("rotation");
            if (nbt.func_74764_b("disguise")) {
                this.disguise = Block.func_149684_b((String)nbt.func_74779_i("disguise"));
                this.disguiseMeta = nbt.func_74762_e("disguiseMeta");
            }
        }

        @Override
        public void serialize(ByteBuf buf) {
            buf.writeInt(this.placedRotation);
            BufferUtil.writeString(buf, this.actionID);
            BufferUtil.writeString(buf, this.conditionID);
            BufferUtil.writeString(buf, this.interactionID);
            buf.writeInt(Block.func_149682_b((Block)this.disguise));
            buf.writeInt(this.disguiseMeta);
        }

        @Override
        public void deserialize(ByteBuf buf) {
            this.placedRotation = buf.readInt();
            this.actionID = BufferUtil.readString(buf);
            this.conditionID = BufferUtil.readString(buf);
            this.interactionID = BufferUtil.readString(buf);
            this.disguise = Block.func_149729_e((int)buf.readInt());
            this.disguiseMeta = buf.readInt();
        }

        @Override
        public NBTTagCompound getSettings(World world, int x, int y, int z) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74778_a("actionID", this.actionID);
            nbt.func_74778_a("conditionID", this.conditionID);
            if (this.interactionID != null) {
                nbt.func_74778_a("interactionID", this.interactionID);
            }
            if (this.disguise != null) {
                nbt.func_74778_a("disguise", GameRegistry.findUniqueIdentifierFor((Block)this.disguise).toString());
                nbt.func_74768_a("disguiseMeta", this.disguiseMeta);
            }
            return nbt;
        }

        @Override
        public void pasteSettings(NBTTagCompound nbt, int index, World world, EntityPlayer player, int x, int y, int z) {
            this.actionID = nbt.func_74779_i("actionID");
            this.conditionID = nbt.func_74779_i("conditionID");
            this.interactionID = nbt.func_74779_i("interactionID");
            if (nbt.func_74764_b("disguise")) {
                this.disguise = Block.func_149684_b((String)nbt.func_74779_i("disguise"));
                this.disguiseMeta = nbt.func_74762_e("disguiseMeta");
            }
        }
    }
}

