/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.animloader;

import com.hbm.util.BobMathUtil;
import java.nio.FloatBuffer;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.util.Vec3;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Quaternion;

public class Transform {
    protected static FloatBuffer auxGLMatrix = GLAllocation.func_74529_h((int)16);
    Vec3 scale;
    Vec3 translation;
    Quaternion rotation;
    boolean hidden = false;

    public Transform(float[] matrix) {
        this.scale = this.getScaleFromMatrix(matrix);
        auxGLMatrix.put(matrix);
        auxGLMatrix.rewind();
        this.rotation = new Quaternion().setFromMatrix((Matrix4f)new Matrix4f().load(auxGLMatrix));
        this.translation = Vec3.func_72443_a((double)matrix[3], (double)matrix[7], (double)matrix[11]);
        auxGLMatrix.rewind();
    }

    private Vec3 getScaleFromMatrix(float[] matrix) {
        float scaleX = (float)Vec3.func_72443_a((double)matrix[0], (double)matrix[1], (double)matrix[2]).func_72433_c();
        float scaleY = (float)Vec3.func_72443_a((double)matrix[4], (double)matrix[5], (double)matrix[6]).func_72433_c();
        float scaleZ = (float)Vec3.func_72443_a((double)matrix[8], (double)matrix[9], (double)matrix[10]).func_72433_c();
        matrix[0] = matrix[0] / scaleX;
        matrix[1] = matrix[1] / scaleX;
        matrix[2] = matrix[2] / scaleX;
        matrix[4] = matrix[4] / scaleY;
        matrix[5] = matrix[5] / scaleY;
        matrix[6] = matrix[6] / scaleY;
        matrix[8] = matrix[8] / scaleZ;
        matrix[9] = matrix[9] / scaleZ;
        matrix[10] = matrix[10] / scaleZ;
        return Vec3.func_72443_a((double)scaleX, (double)scaleY, (double)scaleZ);
    }

    public void interpolateAndApply(Transform other, float inter) {
        Vec3 trans = BobMathUtil.interpVec(this.translation, other.translation, inter);
        Vec3 scale = BobMathUtil.interpVec(this.scale, other.scale, inter);
        Quaternion rot = this.slerp(this.rotation, other.rotation, inter);
        Transform.quatToGlMatrix(auxGLMatrix, rot);
        this.scale(auxGLMatrix, scale);
        auxGLMatrix.put(12, (float)trans.field_72450_a);
        auxGLMatrix.put(13, (float)trans.field_72448_b);
        auxGLMatrix.put(14, (float)trans.field_72449_c);
        GL11.glMultMatrix((FloatBuffer)auxGLMatrix);
    }

    public static FloatBuffer quatToGlMatrix(FloatBuffer buf, Quaternion q) {
        buf.clear();
        float xx = q.x * q.x;
        float xy = q.x * q.y;
        float xz = q.x * q.z;
        float xw = q.x * q.w;
        float yy = q.y * q.y;
        float yz = q.y * q.z;
        float yw = q.y * q.w;
        float zz = q.z * q.z;
        float zw = q.z * q.w;
        buf.put(1.0f - 2.0f * (yy + zz));
        buf.put(2.0f * (xy + zw));
        buf.put(2.0f * (xz - yw));
        buf.put(0.0f);
        buf.put(2.0f * (xy - zw));
        buf.put(1.0f - 2.0f * (xx + zz));
        buf.put(2.0f * (yz + xw));
        buf.put(0.0f);
        buf.put(2.0f * (xz + yw));
        buf.put(2.0f * (yz - xw));
        buf.put(1.0f - 2.0f * (xx + yy));
        buf.put(0.0f);
        buf.put(0.0f);
        buf.put(0.0f);
        buf.put(0.0f);
        buf.put(1.0f);
        buf.rewind();
        return buf;
    }

    private void scale(FloatBuffer matrix, Vec3 scale) {
        matrix.put(0, (float)((double)matrix.get(0) * scale.field_72450_a));
        matrix.put(4, (float)((double)matrix.get(4) * scale.field_72450_a));
        matrix.put(8, (float)((double)matrix.get(8) * scale.field_72450_a));
        matrix.put(12, (float)((double)matrix.get(12) * scale.field_72450_a));
        matrix.put(1, (float)((double)matrix.get(1) * scale.field_72448_b));
        matrix.put(5, (float)((double)matrix.get(5) * scale.field_72448_b));
        matrix.put(9, (float)((double)matrix.get(9) * scale.field_72448_b));
        matrix.put(13, (float)((double)matrix.get(13) * scale.field_72448_b));
        matrix.put(2, (float)((double)matrix.get(2) * scale.field_72449_c));
        matrix.put(6, (float)((double)matrix.get(6) * scale.field_72449_c));
        matrix.put(10, (float)((double)matrix.get(10) * scale.field_72449_c));
        matrix.put(14, (float)((double)matrix.get(14) * scale.field_72449_c));
    }

    protected Quaternion slerp(Quaternion v0, Quaternion v1, float t) {
        double dot = Quaternion.dot((Quaternion)v0, (Quaternion)v1);
        if (dot < 0.0) {
            v1 = new Quaternion(-v1.x, -v1.y, -v1.z, -v1.w);
            dot = -dot;
        }
        double DOT_THRESHOLD = 0.9999999;
        if (dot > 0.9999999) {
            Quaternion result = new Quaternion(v0.x + t * v1.x, v0.y + t * v1.y, v0.z + t * v1.z, v0.w + t * v1.w);
            result.normalise();
            return result;
        }
        double theta_0 = Math.acos(dot);
        double theta = theta_0 * (double)t;
        double sin_theta = Math.sin(theta);
        double sin_theta_0 = Math.sin(theta_0);
        float s0 = (float)(Math.cos(theta) - dot * sin_theta / sin_theta_0);
        float s1 = (float)(sin_theta / sin_theta_0);
        return new Quaternion(s0 * v0.x + s1 * v1.x, s0 * v0.y + s1 * v1.y, s0 * v0.z + s1 * v1.z, s0 * v0.w + s1 * v1.w);
    }
}

