/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.crypto.modes;

import org.spongycastle.crypto.BlockCipher;
import org.spongycastle.crypto.CipherParameters;
import org.spongycastle.crypto.DataLengthException;
import org.spongycastle.crypto.SkippingStreamCipher;
import org.spongycastle.crypto.StreamBlockCipher;
import org.spongycastle.crypto.params.ParametersWithIV;
import org.spongycastle.util.Pack;

public class SICBlockCipher
extends StreamBlockCipher
implements SkippingStreamCipher {
    private final BlockCipher cipher;
    private final int blockSize;
    private byte[] IV;
    private byte[] counter;
    private byte[] counterOut;
    private int byteCount;

    public SICBlockCipher(BlockCipher c) {
        super(c);
        this.cipher = c;
        this.blockSize = this.cipher.getBlockSize();
        this.IV = new byte[this.blockSize];
        this.counter = new byte[this.blockSize];
        this.counterOut = new byte[this.blockSize];
        this.byteCount = 0;
    }

    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        if (params instanceof ParametersWithIV) {
            ParametersWithIV ivParam = (ParametersWithIV)params;
            byte[] iv = ivParam.getIV();
            System.arraycopy(iv, 0, this.IV, 0, this.IV.length);
            if (ivParam.getParameters() != null) {
                this.cipher.init(true, ivParam.getParameters());
            }
        } else {
            throw new IllegalArgumentException("SIC mode requires ParametersWithIV");
        }
        this.reset();
    }

    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName() + "/SIC";
    }

    public int getBlockSize() {
        return this.cipher.getBlockSize();
    }

    public int processBlock(byte[] in, int inOff, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        this.processBytes(in, inOff, this.blockSize, out, outOff);
        return this.blockSize;
    }

    protected byte calculateByte(byte in) throws DataLengthException, IllegalStateException {
        if (this.byteCount == 0) {
            this.cipher.processBlock(this.counter, 0, this.counterOut, 0);
            return (byte)(this.counterOut[this.byteCount++] ^ in);
        }
        byte rv = (byte)(this.counterOut[this.byteCount++] ^ in);
        if (this.byteCount == this.counter.length) {
            this.byteCount = 0;
            this.incrementCounter();
        }
        return rv;
    }

    private void incrementCounter() {
        int i = this.counter.length - 1;
        while (i >= 0) {
            int n = i--;
            this.counter[n] = (byte)(this.counter[n] + 1);
            if (this.counter[n] == 0) continue;
        }
    }

    private void decrementCounter() {
        if (this.counter[0] == 0) {
            boolean nonZero = false;
            for (int i = this.counter.length - 1; i > 0; --i) {
                if (this.counter[i] == 0) continue;
                nonZero = true;
            }
            if (!nonZero) {
                throw new IllegalStateException("attempt to reduce counter past zero.");
            }
        }
        int i = this.counter.length - 1;
        while (i >= 0) {
            int n = i--;
            this.counter[n] = (byte)(this.counter[n] - 1);
            if (this.counter[n] == -1) continue;
        }
    }

    private void adjustCounter(long n) {
        if (n >= 0L) {
            long numBlocks = (n + (long)this.byteCount) / (long)this.blockSize;
            for (long i = 0L; i != numBlocks; ++i) {
                this.incrementCounter();
            }
            this.byteCount = (int)(n + (long)this.byteCount - (long)this.blockSize * numBlocks);
        } else {
            long numBlocks = (-n - (long)this.byteCount) / (long)this.blockSize;
            for (long i = 0L; i != numBlocks; ++i) {
                this.decrementCounter();
            }
            int gap = (int)((long)this.byteCount + n + (long)this.blockSize * numBlocks);
            if (gap >= 0) {
                this.byteCount = 0;
            } else {
                this.decrementCounter();
                this.byteCount = this.blockSize + gap;
            }
        }
    }

    public void reset() {
        System.arraycopy(this.IV, 0, this.counter, 0, this.counter.length);
        this.cipher.reset();
        this.byteCount = 0;
    }

    public long skip(long numberOfBytes) {
        this.adjustCounter(numberOfBytes);
        this.cipher.processBlock(this.counter, 0, this.counterOut, 0);
        return numberOfBytes;
    }

    public long seekTo(long position) {
        this.reset();
        return this.skip(position);
    }

    public long getPosition() {
        byte[] res = new byte[this.IV.length];
        System.arraycopy(this.counter, 0, res, 0, res.length);
        for (int i = res.length - 1; i >= 1; --i) {
            int v = res[i] - this.IV[i];
            if (v < 0) {
                int n = i - 1;
                res[n] = (byte)(res[n] - 1);
                v += 256;
            }
            res[i] = (byte)v;
        }
        return Pack.bigEndianToLong(res, res.length - 8) * (long)this.blockSize + (long)this.byteCount;
    }
}

