/*
 * Decompiled with CFR 0.152.
 */
package kellinwood.security.zipsigner;

import java.util.ArrayList;
import kellinwood.security.zipsigner.ProgressEvent;
import kellinwood.security.zipsigner.ProgressListener;

public class ProgressHelper {
    private int progressTotalItems = 0;
    private int progressCurrentItem = 0;
    private ProgressEvent progressEvent = new ProgressEvent();
    private ArrayList<ProgressListener> listeners = new ArrayList();

    public void initProgress() {
        this.progressTotalItems = 10000;
        this.progressCurrentItem = 0;
    }

    public int getProgressTotalItems() {
        return this.progressTotalItems;
    }

    public void setProgressTotalItems(int progressTotalItems) {
        this.progressTotalItems = progressTotalItems;
    }

    public int getProgressCurrentItem() {
        return this.progressCurrentItem;
    }

    public void setProgressCurrentItem(int progressCurrentItem) {
        this.progressCurrentItem = progressCurrentItem;
    }

    public void progress(int priority, String message) {
        ++this.progressCurrentItem;
        int percentDone = this.progressTotalItems == 0 ? 0 : 100 * this.progressCurrentItem / this.progressTotalItems;
        for (ProgressListener listener : this.listeners) {
            this.progressEvent.setMessage(message);
            this.progressEvent.setPercentDone(percentDone);
            this.progressEvent.setPriority(priority);
            listener.onProgress(this.progressEvent);
        }
    }

    public synchronized void addProgressListener(ProgressListener l) {
        ArrayList list = (ArrayList)this.listeners.clone();
        list.add(l);
        this.listeners = list;
    }

    public synchronized void removeProgressListener(ProgressListener l) {
        ArrayList list = (ArrayList)this.listeners.clone();
        list.remove(l);
        this.listeners = list;
    }
}

