/*
 * Decompiled with CFR 0.152.
 */
package kellinwood.logging.android;

import android.content.Context;
import android.util.Log;
import android.widget.Toast;
import kellinwood.logging.AbstractLogger;

public class AndroidLogger
extends AbstractLogger {
    Context toastContext;
    boolean isErrorToastEnabled = true;
    boolean isWarningToastEnabled = true;
    boolean isInfoToastEnabled = false;
    boolean isDebugToastEnabled = false;

    public AndroidLogger(String c) {
        super(c);
        int pos = this.category.lastIndexOf(46);
        if (pos > 0) {
            this.category = this.category.substring(pos + 1);
        }
    }

    public Context getToastContext() {
        return this.toastContext;
    }

    public void setToastContext(Context toastContext) {
        this.toastContext = toastContext;
    }

    public boolean isErrorToastEnabled() {
        return this.isErrorToastEnabled;
    }

    public void setErrorToastEnabled(boolean isErrorToastEnabled) {
        this.isErrorToastEnabled = isErrorToastEnabled;
    }

    public boolean isWarningToastEnabled() {
        return this.isWarningToastEnabled;
    }

    public void setWarningToastEnabled(boolean isWarningToastEnabled) {
        this.isWarningToastEnabled = isWarningToastEnabled;
    }

    public boolean isInfoToastEnabled() {
        return this.isInfoToastEnabled;
    }

    public void setInfoToastEnabled(boolean isInfoToastEnabled) {
        this.isInfoToastEnabled = isInfoToastEnabled;
    }

    public boolean isDebugToastEnabled() {
        return this.isDebugToastEnabled;
    }

    public void setDebugToastEnabled(boolean isDebugToastEnabled) {
        this.isDebugToastEnabled = isDebugToastEnabled;
    }

    public void errorLO(String message, Throwable t) {
        boolean toastState = this.isErrorToastEnabled;
        this.isErrorToastEnabled = false;
        this.writeFixNullMessage("ERROR", message, t);
        this.isErrorToastEnabled = toastState;
    }

    public void warningLO(String message, Throwable t) {
        boolean toastState = this.isWarningToastEnabled;
        this.isWarningToastEnabled = false;
        this.writeFixNullMessage("WARNING", message, t);
        this.isWarningToastEnabled = toastState;
    }

    public void infoLO(String message, Throwable t) {
        boolean toastState = this.isInfoToastEnabled;
        this.isInfoToastEnabled = false;
        this.writeFixNullMessage("INFO", message, t);
        this.isInfoToastEnabled = toastState;
    }

    public void debugLO(String message, Throwable t) {
        boolean toastState = this.isDebugToastEnabled;
        this.isDebugToastEnabled = false;
        this.writeFixNullMessage("DEBUG", message, t);
        this.isDebugToastEnabled = toastState;
    }

    protected void toast(String message) {
        try {
            if (this.toastContext != null) {
                Toast.makeText((Context)this.toastContext, (CharSequence)message, (int)1).show();
            }
        }
        catch (Throwable t) {
            Log.e((String)this.category, (String)message, (Throwable)t);
        }
    }

    public void write(String level, String message, Throwable t) {
        if ("ERROR".equals(level)) {
            if (t != null) {
                Log.e((String)this.category, (String)message, (Throwable)t);
            } else {
                Log.e((String)this.category, (String)message);
            }
            if (this.isErrorToastEnabled) {
                this.toast(message);
            }
        } else if ("DEBUG".equals(level)) {
            if (t != null) {
                Log.d((String)this.category, (String)message, (Throwable)t);
            } else {
                Log.d((String)this.category, (String)message);
            }
            if (this.isDebugToastEnabled) {
                this.toast(message);
            }
        } else if ("WARNING".equals(level)) {
            if (t != null) {
                Log.w((String)this.category, (String)message, (Throwable)t);
            } else {
                Log.w((String)this.category, (String)message);
            }
            if (this.isWarningToastEnabled) {
                this.toast(message);
            }
        } else if ("INFO".equals(level)) {
            if (t != null) {
                Log.i((String)this.category, (String)message, (Throwable)t);
            } else {
                Log.i((String)this.category, (String)message);
            }
            if (this.isInfoToastEnabled) {
                this.toast(message);
            }
        }
    }

    public boolean isDebugEnabled() {
        boolean enabled = Log.isLoggable((String)this.category, (int)3);
        return enabled;
    }

    public boolean isErrorEnabled() {
        return Log.isLoggable((String)this.category, (int)6);
    }

    public boolean isInfoEnabled() {
        return Log.isLoggable((String)this.category, (int)4);
    }

    public boolean isWarningEnabled() {
        return Log.isLoggable((String)this.category, (int)5);
    }
}

